// Code generated by smithy-go-codegen DO NOT EDIT.

package kms

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Immediately initiates rotation of the key material of the specified symmetric
// encryption KMS key.
//
// You can perform [on-demand rotation] of the key material in customer managed KMS keys, regardless
// of whether or not [automatic key rotation]is enabled. On-demand rotations do not change existing
// automatic rotation schedules. For example, consider a KMS key that has automatic
// key rotation enabled with a rotation period of 730 days. If the key is scheduled
// to automatically rotate on April 14, 2024, and you perform an on-demand rotation
// on April 10, 2024, the key will automatically rotate, as scheduled, on April 14,
// 2024 and every 730 days thereafter.
//
// You can perform on-demand key rotation a maximum of 10 times per KMS key. You
// can use the KMS console to view the number of remaining on-demand rotations
// available for a KMS key.
//
// You can use GetKeyRotationStatus to identify any in progress on-demand rotations. You can use ListKeyRotations to
// identify the date that completed on-demand rotations were performed. You can
// monitor rotation of the key material for your KMS keys in CloudTrail and Amazon
// CloudWatch.
//
// On-demand key rotation is supported only on symmetric encryption KMS keys. You
// cannot perform on-demand rotation of [asymmetric KMS keys], [HMAC KMS keys], multi-Region KMS keys with [imported key material], or KMS
// keys in a [custom key store]. When you initiate on-demand key rotation on a symmetric encryption
// KMS key with imported key material, you must have already imported [new key material]and that key
// material's state should be PENDING_ROTATION . Use the ListKeyRotations
// operation to check the state of all key materials associated with a KMS key. To
// perform on-demand rotation of a set of related [multi-Region keys], invoke the on-demand rotation
// on the primary key.
//
// You cannot initiate on-demand rotation of [Amazon Web Services managed KMS keys]. KMS always rotates the key material
// of Amazon Web Services managed keys every year. Rotation of [Amazon Web Services owned KMS keys]is managed by the
// Amazon Web Services service that owns the key.
//
// The KMS key that you use for this operation must be in a compatible key state.
// For details, see [Key states of KMS keys]in the Key Management Service Developer Guide.
//
// Cross-account use: No. You cannot perform this operation on a KMS key in a
// different Amazon Web Services account.
//
// Required permissions: [kms:RotateKeyOnDemand] (key policy)
//
// Related operations:
//
// # EnableKeyRotation
//
// # DisableKeyRotation
//
// # GetKeyRotationStatus
//
// # ImportKeyMaterial
//
// # ListKeyRotations
//
// Eventual consistency: The KMS API follows an eventual consistency model. For
// more information, see [KMS eventual consistency].
//
// [new key material]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-import-key-material.html
// [on-demand rotation]: https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-on-demand.html
// [Amazon Web Services owned KMS keys]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-key
// [automatic key rotation]: https://docs.aws.amazon.com/kms/latest/developerguide/rotating-keys-enable-disable.html
// [kms:RotateKeyOnDemand]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
// [multi-Region keys]: https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#multi-region-rotate
// [KMS eventual consistency]: https://docs.aws.amazon.com/kms/latest/developerguide/accessing-kms.html#programming-eventual-consistency
// [imported key material]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html
// [Key states of KMS keys]: https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html
// [HMAC KMS keys]: https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html
// [Amazon Web Services managed KMS keys]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-key
// [asymmetric KMS keys]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
// [custom key store]: https://docs.aws.amazon.com/kms/latest/developerguide/key-store-overview.html
func (c *Client) RotateKeyOnDemand(ctx context.Context, params *RotateKeyOnDemandInput, optFns ...func(*Options)) (*RotateKeyOnDemandOutput, error) {
	if params == nil {
		params = &RotateKeyOnDemandInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RotateKeyOnDemand", params, optFns, c.addOperationRotateKeyOnDemandMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RotateKeyOnDemandOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RotateKeyOnDemandInput struct {

	// Identifies a symmetric encryption KMS key. You cannot perform on-demand
	// rotation of [asymmetric KMS keys], [HMAC KMS keys], multi-Region KMS keys with [imported key material], or KMS keys in a [custom key store]. To perform
	// on-demand rotation of a set of related [multi-Region keys], invoke the on-demand rotation on the
	// primary key.
	//
	// Specify the key ID or key ARN of the KMS key.
	//
	// For example:
	//
	//   - Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Key ARN:
	//   arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
	//
	// [imported key material]: https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html
	// [HMAC KMS keys]: https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html
	// [asymmetric KMS keys]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
	// [multi-Region keys]: https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#multi-region-rotate
	// [custom key store]: https://docs.aws.amazon.com/kms/latest/developerguide/key-store-overview.html
	//
	// This member is required.
	KeyId *string

	noSmithyDocumentSerde
}

type RotateKeyOnDemandOutput struct {

	// Identifies the symmetric encryption KMS key that you initiated on-demand
	// rotation on.
	KeyId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRotateKeyOnDemandMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpRotateKeyOnDemand{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpRotateKeyOnDemand{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RotateKeyOnDemand"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpRotateKeyOnDemandValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRotateKeyOnDemand(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRotateKeyOnDemand(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RotateKeyOnDemand",
	}
}
