// WARNING! All changes made in this file will be lost!
// Created from 'lang.strings' by 'codegen_style'
//
// This file is part of Desktop App Toolkit,
// a set of libraries for developing nice desktop applications.
//
// For license and copyright information please follow this link:
// https://github.com/desktop-app/legal/blob/master/LEGAL
//
#pragma once

#include "lang/lang_tag.h"
#include "lang/lang_values.h"

namespace Lang {

inline constexpr auto kTagsCount = ushort(153);
inline constexpr auto kKeysCount = ushort(9173);

} // namespace Lang

enum lngtag_text : int { lt_text = 0 };
enum lngtag_count : int { lt_count = 1, lt_count_short = 1001, lt_count_decimal = 2001 };
enum lngtag_month : int { lt_month = 2 };
enum lngtag_day : int { lt_day = 3 };
enum lngtag_year : int { lt_year = 4 };
enum lngtag_time : int { lt_time = 5 };
enum lngtag_date : int { lt_date = 6 };
enum lngtag_members_count : int { lt_members_count = 7 };
enum lngtag_online_count : int { lt_online_count = 8 };
enum lngtag_user : int { lt_user = 9 };
enum lngtag_type : int { lt_type = 10 };
enum lngtag_link : int { lt_link = 11 };
enum lngtag_size : int { lt_size = 12 };
enum lngtag_more_info : int { lt_more_info = 13 };
enum lngtag_server : int { lt_server = 14 };
enum lngtag_port : int { lt_port = 15 };
enum lngtag_phone_number : int { lt_phone_number = 16 };
enum lngtag_email : int { lt_email = 17 };
enum lngtag_minutes : int { lt_minutes = 18 };
enum lngtag_seconds : int { lt_seconds = 19 };
enum lngtag_password_hint : int { lt_password_hint = 20 };
enum lngtag_recover_email : int { lt_recover_email = 21 };
enum lngtag_when : int { lt_when = 22 };
enum lngtag_days_count : int { lt_days_count = 23 };
enum lngtag_hours_count : int { lt_hours_count = 24 };
enum lngtag_minutes_count : int { lt_minutes_count = 25 };
enum lngtag_phone : int { lt_phone = 26 };
enum lngtag_username : int { lt_username = 27 };
enum lngtag_price : int { lt_price = 28 };
enum lngtag_exceptions : int { lt_exceptions = 29 };
enum lngtag_reaction : int { lt_reaction = 30 };
enum lngtag_emoji : int { lt_emoji = 31 };
enum lngtag_name : int { lt_name = 32 };
enum lngtag_title : int { lt_title = 33 };
enum lngtag_version : int { lt_version = 34 };
enum lngtag_index : int { lt_index = 35 };
enum lngtag_progress : int { lt_progress = 36 };
enum lngtag_domain : int { lt_domain = 37 };
enum lngtag_duration : int { lt_duration = 38 };
enum lngtag_after_duration : int { lt_after_duration = 39 };
enum lngtag_limit : int { lt_limit = 40 };
enum lngtag_transport : int { lt_transport = 41 };
enum lngtag_ping : int { lt_ping = 42 };
enum lngtag_users : int { lt_users = 43 };
enum lngtag_percent : int { lt_percent = 44 };
enum lngtag_amount : int { lt_amount = 45 };
enum lngtag_last : int { lt_last = 46 };
enum lngtag_chat : int { lt_chat = 47 };
enum lngtag_terms : int { lt_terms = 48 };
enum lngtag_same_count : int { lt_same_count = 49 };
enum lngtag_bot : int { lt_bot = 50 };
enum lngtag_sort : int { lt_sort = 51 };
enum lngtag_app : int { lt_app = 52 };
enum lngtag_arrow : int { lt_arrow = 53 };
enum lngtag_group : int { lt_group = 54 };
enum lngtag_channel : int { lt_channel = 55 };
enum lngtag_contact : int { lt_contact = 56 };
enum lngtag_days : int { lt_days = 57 };
enum lngtag_seconds_count : int { lt_seconds_count = 58 };
enum lngtag_from : int { lt_from = 59 };
enum lngtag_accumulated : int { lt_accumulated = 60 };
enum lngtag_media : int { lt_media = 61 };
enum lngtag_game : int { lt_game = 62 };
enum lngtag_invoice : int { lt_invoice = 63 };
enum lngtag_documents : int { lt_documents = 64 };
enum lngtag_distance : int { lt_distance = 65 };
enum lngtag_cost : int { lt_cost = 66 };
enum lngtag_hours : int { lt_hours = 67 };
enum lngtag_topic : int { lt_topic = 68 };
enum lngtag_peer : int { lt_peer = 69 };
enum lngtag_action : int { lt_action = 70 };
enum lngtag_tasks : int { lt_tasks = 71 };
enum lngtag_task : int { lt_task = 72 };
enum lngtag_multiplier : int { lt_multiplier = 73 };
enum lngtag_total : int { lt_total = 74 };
enum lngtag_inline_bot : int { lt_inline_bot = 75 };
enum lngtag_second_user : int { lt_second_user = 76 };
enum lngtag_policy : int { lt_policy = 77 };
enum lngtag_recipient : int { lt_recipient = 78 };
enum lngtag_photo : int { lt_photo = 79 };
enum lngtag_video : int { lt_video = 80 };
enum lngtag_shortcut : int { lt_shortcut = 81 };
enum lngtag_links : int { lt_links = 82 };
enum lngtag_post : int { lt_post = 83 };
enum lngtag_left : int { lt_left = 84 };
enum lngtag_other : int { lt_other = 85 };
enum lngtag_gift : int { lt_gift = 86 };
enum lngtag_channels : int { lt_channels = 87 };
enum lngtag_country : int { lt_country = 88 };
enum lngtag_prize : int { lt_prize = 89 };
enum lngtag_countries : int { lt_countries = 90 };
enum lngtag_admins : int { lt_admins = 91 };
enum lngtag_winners : int { lt_winners = 92 };
enum lngtag_start_date : int { lt_start_date = 93 };
enum lngtag_cup : int { lt_cup = 94 };
enum lngtag_features : int { lt_features = 95 };
enum lngtag_platform : int { lt_platform = 96 };
enum lngtag_stars : int { lt_stars = 97 };
enum lngtag_rounds : int { lt_rounds = 98 };
enum lngtag_bidders : int { lt_bidders = 99 };
enum lngtag_n : int { lt_n = 100 };
enum lngtag_increase : int { lt_increase = 101 };
enum lngtag_sticker_pack : int { lt_sticker_pack = 102 };
enum lngtag_types : int { lt_types = 103 };
enum lngtag_chats : int { lt_chats = 104 };
enum lngtag_from_part : int { lt_from_part = 105 };
enum lngtag_message : int { lt_message = 106 };
enum lngtag_media_part : int { lt_media_part = 107 };
enum lngtag_caption : int { lt_caption = 108 };
enum lngtag_bot_name : int { lt_bot_name = 109 };
enum lngtag_retry : int { lt_retry = 110 };
enum lngtag_ready : int { lt_ready = 111 };
enum lngtag_mb : int { lt_mb = 112 };
enum lngtag_played : int { lt_played = 113 };
enum lngtag_language : int { lt_language = 114 };
enum lngtag_mention : int { lt_mention = 115 };
enum lngtag_api_link : int { lt_api_link = 116 };
enum lngtag_gpl_link : int { lt_gpl_link = 117 };
enum lngtag_github_link : int { lt_github_link = 118 };
enum lngtag_faq_link : int { lt_faq_link = 119 };
enum lngtag_file : int { lt_file = 120 };
enum lngtag_downloads : int { lt_downloads = 121 };
enum lngtag_speed : int { lt_speed = 122 };
enum lngtag_changes : int { lt_changes = 123 };
enum lngtag_first_name : int { lt_first_name = 124 };
enum lngtag_last_name : int { lt_last_name = 125 };
enum lngtag_provider : int { lt_provider = 126 };
enum lngtag_bot1 : int { lt_bot1 = 127 };
enum lngtag_bot2 : int { lt_bot2 = 128 };
enum lngtag_bot3 : int { lt_bot3 = 129 };
enum lngtag_card : int { lt_card = 130 };
enum lngtag_status : int { lt_status = 131 };
enum lngtag_delay : int { lt_delay = 132 };
enum lngtag_third : int { lt_third = 133 };
enum lngtag_interval : int { lt_interval = 134 };
enum lngtag_query : int { lt_query = 135 };
enum lngtag_until : int { lt_until = 136 };
enum lngtag_sticker_set : int { lt_sticker_set = 137 };
enum lngtag_address : int { lt_address = 138 };
enum lngtag_previous : int { lt_previous = 139 };
enum lngtag_color : int { lt_color = 140 };
enum lngtag_new_topic : int { lt_new_topic = 141 };
enum lngtag_document : int { lt_document = 142 };
enum lngtag_second_document : int { lt_second_document = 143 };
enum lngtag_existing : int { lt_existing = 144 };
enum lngtag_path : int { lt_path = 145 };
enum lngtag_format : int { lt_format = 146 };
enum lngtag_till : int { lt_till = 147 };
enum lngtag_lang_name : int { lt_lang_name = 148 };
enum lngtag_extension : int { lt_extension = 149 };
enum lngtag_folder : int { lt_folder = 150 };
enum lngtag_rights : int { lt_rights = 151 };
enum lngtag_telegram : int { lt_telegram = 152 };

namespace Lang {

ushort GetTagIndex(QLatin1String tag);
ushort GetKeyIndex(QLatin1String key);
bool IsTagReplaced(ushort key, ushort tag);
QString GetOriginalValue(ushort key);

namespace details {

template <typename Tag>
struct TagData;

template <typename Tag>
inline constexpr ushort TagValue() {
	return TagData<Tag>::value;
}

template <> struct TagData<lngtag_text> : std::integral_constant<ushort, ushort(lt_text)> {};
template <> struct TagData<lngtag_count> : std::integral_constant<ushort, ushort(lt_count)> {};
template <> struct TagData<lngtag_month> : std::integral_constant<ushort, ushort(lt_month)> {};
template <> struct TagData<lngtag_day> : std::integral_constant<ushort, ushort(lt_day)> {};
template <> struct TagData<lngtag_year> : std::integral_constant<ushort, ushort(lt_year)> {};
template <> struct TagData<lngtag_time> : std::integral_constant<ushort, ushort(lt_time)> {};
template <> struct TagData<lngtag_date> : std::integral_constant<ushort, ushort(lt_date)> {};
template <> struct TagData<lngtag_members_count> : std::integral_constant<ushort, ushort(lt_members_count)> {};
template <> struct TagData<lngtag_online_count> : std::integral_constant<ushort, ushort(lt_online_count)> {};
template <> struct TagData<lngtag_user> : std::integral_constant<ushort, ushort(lt_user)> {};
template <> struct TagData<lngtag_type> : std::integral_constant<ushort, ushort(lt_type)> {};
template <> struct TagData<lngtag_link> : std::integral_constant<ushort, ushort(lt_link)> {};
template <> struct TagData<lngtag_size> : std::integral_constant<ushort, ushort(lt_size)> {};
template <> struct TagData<lngtag_more_info> : std::integral_constant<ushort, ushort(lt_more_info)> {};
template <> struct TagData<lngtag_server> : std::integral_constant<ushort, ushort(lt_server)> {};
template <> struct TagData<lngtag_port> : std::integral_constant<ushort, ushort(lt_port)> {};
template <> struct TagData<lngtag_phone_number> : std::integral_constant<ushort, ushort(lt_phone_number)> {};
template <> struct TagData<lngtag_email> : std::integral_constant<ushort, ushort(lt_email)> {};
template <> struct TagData<lngtag_minutes> : std::integral_constant<ushort, ushort(lt_minutes)> {};
template <> struct TagData<lngtag_seconds> : std::integral_constant<ushort, ushort(lt_seconds)> {};
template <> struct TagData<lngtag_password_hint> : std::integral_constant<ushort, ushort(lt_password_hint)> {};
template <> struct TagData<lngtag_recover_email> : std::integral_constant<ushort, ushort(lt_recover_email)> {};
template <> struct TagData<lngtag_when> : std::integral_constant<ushort, ushort(lt_when)> {};
template <> struct TagData<lngtag_days_count> : std::integral_constant<ushort, ushort(lt_days_count)> {};
template <> struct TagData<lngtag_hours_count> : std::integral_constant<ushort, ushort(lt_hours_count)> {};
template <> struct TagData<lngtag_minutes_count> : std::integral_constant<ushort, ushort(lt_minutes_count)> {};
template <> struct TagData<lngtag_phone> : std::integral_constant<ushort, ushort(lt_phone)> {};
template <> struct TagData<lngtag_username> : std::integral_constant<ushort, ushort(lt_username)> {};
template <> struct TagData<lngtag_price> : std::integral_constant<ushort, ushort(lt_price)> {};
template <> struct TagData<lngtag_exceptions> : std::integral_constant<ushort, ushort(lt_exceptions)> {};
template <> struct TagData<lngtag_reaction> : std::integral_constant<ushort, ushort(lt_reaction)> {};
template <> struct TagData<lngtag_emoji> : std::integral_constant<ushort, ushort(lt_emoji)> {};
template <> struct TagData<lngtag_name> : std::integral_constant<ushort, ushort(lt_name)> {};
template <> struct TagData<lngtag_title> : std::integral_constant<ushort, ushort(lt_title)> {};
template <> struct TagData<lngtag_version> : std::integral_constant<ushort, ushort(lt_version)> {};
template <> struct TagData<lngtag_index> : std::integral_constant<ushort, ushort(lt_index)> {};
template <> struct TagData<lngtag_progress> : std::integral_constant<ushort, ushort(lt_progress)> {};
template <> struct TagData<lngtag_domain> : std::integral_constant<ushort, ushort(lt_domain)> {};
template <> struct TagData<lngtag_duration> : std::integral_constant<ushort, ushort(lt_duration)> {};
template <> struct TagData<lngtag_after_duration> : std::integral_constant<ushort, ushort(lt_after_duration)> {};
template <> struct TagData<lngtag_limit> : std::integral_constant<ushort, ushort(lt_limit)> {};
template <> struct TagData<lngtag_transport> : std::integral_constant<ushort, ushort(lt_transport)> {};
template <> struct TagData<lngtag_ping> : std::integral_constant<ushort, ushort(lt_ping)> {};
template <> struct TagData<lngtag_users> : std::integral_constant<ushort, ushort(lt_users)> {};
template <> struct TagData<lngtag_percent> : std::integral_constant<ushort, ushort(lt_percent)> {};
template <> struct TagData<lngtag_amount> : std::integral_constant<ushort, ushort(lt_amount)> {};
template <> struct TagData<lngtag_last> : std::integral_constant<ushort, ushort(lt_last)> {};
template <> struct TagData<lngtag_chat> : std::integral_constant<ushort, ushort(lt_chat)> {};
template <> struct TagData<lngtag_terms> : std::integral_constant<ushort, ushort(lt_terms)> {};
template <> struct TagData<lngtag_same_count> : std::integral_constant<ushort, ushort(lt_same_count)> {};
template <> struct TagData<lngtag_bot> : std::integral_constant<ushort, ushort(lt_bot)> {};
template <> struct TagData<lngtag_sort> : std::integral_constant<ushort, ushort(lt_sort)> {};
template <> struct TagData<lngtag_app> : std::integral_constant<ushort, ushort(lt_app)> {};
template <> struct TagData<lngtag_arrow> : std::integral_constant<ushort, ushort(lt_arrow)> {};
template <> struct TagData<lngtag_group> : std::integral_constant<ushort, ushort(lt_group)> {};
template <> struct TagData<lngtag_channel> : std::integral_constant<ushort, ushort(lt_channel)> {};
template <> struct TagData<lngtag_contact> : std::integral_constant<ushort, ushort(lt_contact)> {};
template <> struct TagData<lngtag_days> : std::integral_constant<ushort, ushort(lt_days)> {};
template <> struct TagData<lngtag_seconds_count> : std::integral_constant<ushort, ushort(lt_seconds_count)> {};
template <> struct TagData<lngtag_from> : std::integral_constant<ushort, ushort(lt_from)> {};
template <> struct TagData<lngtag_accumulated> : std::integral_constant<ushort, ushort(lt_accumulated)> {};
template <> struct TagData<lngtag_media> : std::integral_constant<ushort, ushort(lt_media)> {};
template <> struct TagData<lngtag_game> : std::integral_constant<ushort, ushort(lt_game)> {};
template <> struct TagData<lngtag_invoice> : std::integral_constant<ushort, ushort(lt_invoice)> {};
template <> struct TagData<lngtag_documents> : std::integral_constant<ushort, ushort(lt_documents)> {};
template <> struct TagData<lngtag_distance> : std::integral_constant<ushort, ushort(lt_distance)> {};
template <> struct TagData<lngtag_cost> : std::integral_constant<ushort, ushort(lt_cost)> {};
template <> struct TagData<lngtag_hours> : std::integral_constant<ushort, ushort(lt_hours)> {};
template <> struct TagData<lngtag_topic> : std::integral_constant<ushort, ushort(lt_topic)> {};
template <> struct TagData<lngtag_peer> : std::integral_constant<ushort, ushort(lt_peer)> {};
template <> struct TagData<lngtag_action> : std::integral_constant<ushort, ushort(lt_action)> {};
template <> struct TagData<lngtag_tasks> : std::integral_constant<ushort, ushort(lt_tasks)> {};
template <> struct TagData<lngtag_task> : std::integral_constant<ushort, ushort(lt_task)> {};
template <> struct TagData<lngtag_multiplier> : std::integral_constant<ushort, ushort(lt_multiplier)> {};
template <> struct TagData<lngtag_total> : std::integral_constant<ushort, ushort(lt_total)> {};
template <> struct TagData<lngtag_inline_bot> : std::integral_constant<ushort, ushort(lt_inline_bot)> {};
template <> struct TagData<lngtag_second_user> : std::integral_constant<ushort, ushort(lt_second_user)> {};
template <> struct TagData<lngtag_policy> : std::integral_constant<ushort, ushort(lt_policy)> {};
template <> struct TagData<lngtag_recipient> : std::integral_constant<ushort, ushort(lt_recipient)> {};
template <> struct TagData<lngtag_photo> : std::integral_constant<ushort, ushort(lt_photo)> {};
template <> struct TagData<lngtag_video> : std::integral_constant<ushort, ushort(lt_video)> {};
template <> struct TagData<lngtag_shortcut> : std::integral_constant<ushort, ushort(lt_shortcut)> {};
template <> struct TagData<lngtag_links> : std::integral_constant<ushort, ushort(lt_links)> {};
template <> struct TagData<lngtag_post> : std::integral_constant<ushort, ushort(lt_post)> {};
template <> struct TagData<lngtag_left> : std::integral_constant<ushort, ushort(lt_left)> {};
template <> struct TagData<lngtag_other> : std::integral_constant<ushort, ushort(lt_other)> {};
template <> struct TagData<lngtag_gift> : std::integral_constant<ushort, ushort(lt_gift)> {};
template <> struct TagData<lngtag_channels> : std::integral_constant<ushort, ushort(lt_channels)> {};
template <> struct TagData<lngtag_country> : std::integral_constant<ushort, ushort(lt_country)> {};
template <> struct TagData<lngtag_prize> : std::integral_constant<ushort, ushort(lt_prize)> {};
template <> struct TagData<lngtag_countries> : std::integral_constant<ushort, ushort(lt_countries)> {};
template <> struct TagData<lngtag_admins> : std::integral_constant<ushort, ushort(lt_admins)> {};
template <> struct TagData<lngtag_winners> : std::integral_constant<ushort, ushort(lt_winners)> {};
template <> struct TagData<lngtag_start_date> : std::integral_constant<ushort, ushort(lt_start_date)> {};
template <> struct TagData<lngtag_cup> : std::integral_constant<ushort, ushort(lt_cup)> {};
template <> struct TagData<lngtag_features> : std::integral_constant<ushort, ushort(lt_features)> {};
template <> struct TagData<lngtag_platform> : std::integral_constant<ushort, ushort(lt_platform)> {};
template <> struct TagData<lngtag_stars> : std::integral_constant<ushort, ushort(lt_stars)> {};
template <> struct TagData<lngtag_rounds> : std::integral_constant<ushort, ushort(lt_rounds)> {};
template <> struct TagData<lngtag_bidders> : std::integral_constant<ushort, ushort(lt_bidders)> {};
template <> struct TagData<lngtag_n> : std::integral_constant<ushort, ushort(lt_n)> {};
template <> struct TagData<lngtag_increase> : std::integral_constant<ushort, ushort(lt_increase)> {};
template <> struct TagData<lngtag_sticker_pack> : std::integral_constant<ushort, ushort(lt_sticker_pack)> {};
template <> struct TagData<lngtag_types> : std::integral_constant<ushort, ushort(lt_types)> {};
template <> struct TagData<lngtag_chats> : std::integral_constant<ushort, ushort(lt_chats)> {};
template <> struct TagData<lngtag_from_part> : std::integral_constant<ushort, ushort(lt_from_part)> {};
template <> struct TagData<lngtag_message> : std::integral_constant<ushort, ushort(lt_message)> {};
template <> struct TagData<lngtag_media_part> : std::integral_constant<ushort, ushort(lt_media_part)> {};
template <> struct TagData<lngtag_caption> : std::integral_constant<ushort, ushort(lt_caption)> {};
template <> struct TagData<lngtag_bot_name> : std::integral_constant<ushort, ushort(lt_bot_name)> {};
template <> struct TagData<lngtag_retry> : std::integral_constant<ushort, ushort(lt_retry)> {};
template <> struct TagData<lngtag_ready> : std::integral_constant<ushort, ushort(lt_ready)> {};
template <> struct TagData<lngtag_mb> : std::integral_constant<ushort, ushort(lt_mb)> {};
template <> struct TagData<lngtag_played> : std::integral_constant<ushort, ushort(lt_played)> {};
template <> struct TagData<lngtag_language> : std::integral_constant<ushort, ushort(lt_language)> {};
template <> struct TagData<lngtag_mention> : std::integral_constant<ushort, ushort(lt_mention)> {};
template <> struct TagData<lngtag_api_link> : std::integral_constant<ushort, ushort(lt_api_link)> {};
template <> struct TagData<lngtag_gpl_link> : std::integral_constant<ushort, ushort(lt_gpl_link)> {};
template <> struct TagData<lngtag_github_link> : std::integral_constant<ushort, ushort(lt_github_link)> {};
template <> struct TagData<lngtag_faq_link> : std::integral_constant<ushort, ushort(lt_faq_link)> {};
template <> struct TagData<lngtag_file> : std::integral_constant<ushort, ushort(lt_file)> {};
template <> struct TagData<lngtag_downloads> : std::integral_constant<ushort, ushort(lt_downloads)> {};
template <> struct TagData<lngtag_speed> : std::integral_constant<ushort, ushort(lt_speed)> {};
template <> struct TagData<lngtag_changes> : std::integral_constant<ushort, ushort(lt_changes)> {};
template <> struct TagData<lngtag_first_name> : std::integral_constant<ushort, ushort(lt_first_name)> {};
template <> struct TagData<lngtag_last_name> : std::integral_constant<ushort, ushort(lt_last_name)> {};
template <> struct TagData<lngtag_provider> : std::integral_constant<ushort, ushort(lt_provider)> {};
template <> struct TagData<lngtag_bot1> : std::integral_constant<ushort, ushort(lt_bot1)> {};
template <> struct TagData<lngtag_bot2> : std::integral_constant<ushort, ushort(lt_bot2)> {};
template <> struct TagData<lngtag_bot3> : std::integral_constant<ushort, ushort(lt_bot3)> {};
template <> struct TagData<lngtag_card> : std::integral_constant<ushort, ushort(lt_card)> {};
template <> struct TagData<lngtag_status> : std::integral_constant<ushort, ushort(lt_status)> {};
template <> struct TagData<lngtag_delay> : std::integral_constant<ushort, ushort(lt_delay)> {};
template <> struct TagData<lngtag_third> : std::integral_constant<ushort, ushort(lt_third)> {};
template <> struct TagData<lngtag_interval> : std::integral_constant<ushort, ushort(lt_interval)> {};
template <> struct TagData<lngtag_query> : std::integral_constant<ushort, ushort(lt_query)> {};
template <> struct TagData<lngtag_until> : std::integral_constant<ushort, ushort(lt_until)> {};
template <> struct TagData<lngtag_sticker_set> : std::integral_constant<ushort, ushort(lt_sticker_set)> {};
template <> struct TagData<lngtag_address> : std::integral_constant<ushort, ushort(lt_address)> {};
template <> struct TagData<lngtag_previous> : std::integral_constant<ushort, ushort(lt_previous)> {};
template <> struct TagData<lngtag_color> : std::integral_constant<ushort, ushort(lt_color)> {};
template <> struct TagData<lngtag_new_topic> : std::integral_constant<ushort, ushort(lt_new_topic)> {};
template <> struct TagData<lngtag_document> : std::integral_constant<ushort, ushort(lt_document)> {};
template <> struct TagData<lngtag_second_document> : std::integral_constant<ushort, ushort(lt_second_document)> {};
template <> struct TagData<lngtag_existing> : std::integral_constant<ushort, ushort(lt_existing)> {};
template <> struct TagData<lngtag_path> : std::integral_constant<ushort, ushort(lt_path)> {};
template <> struct TagData<lngtag_format> : std::integral_constant<ushort, ushort(lt_format)> {};
template <> struct TagData<lngtag_till> : std::integral_constant<ushort, ushort(lt_till)> {};
template <> struct TagData<lngtag_lang_name> : std::integral_constant<ushort, ushort(lt_lang_name)> {};
template <> struct TagData<lngtag_extension> : std::integral_constant<ushort, ushort(lt_extension)> {};
template <> struct TagData<lngtag_folder> : std::integral_constant<ushort, ushort(lt_folder)> {};
template <> struct TagData<lngtag_rights> : std::integral_constant<ushort, ushort(lt_rights)> {};
template <> struct TagData<lngtag_telegram> : std::integral_constant<ushort, ushort(lt_telegram)> {};

} // namespace details
} // namespace Lang

namespace tr {
namespace details {

struct Identity {
	QString operator()(const QString &value) const {
		return value;
	}
};

} // namespace details

struct now_t {
};

inline constexpr now_t now{};

inline auto to_count() {
	return rpl::map([](auto value) {
		return float64(value);
	});
}

template <typename P>
using S = std::decay_t<decltype(std::declval<P>()(QString()))>;

template <typename ...Tags>
struct phrase;

template <>
struct phrase<> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(P p = P()) const {
		return ::Lang::details::Producer<>::Combine(base, std::move(p));
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, P p = P()) const {
		return ::Lang::details::Producer<>::Current(base, std::move(p));
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_text> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_text, rpl::producer<S<P>> text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_text>::Combine(base, std::move(p), type, count__val, text__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_text, const S<P> &text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_text>::Current(base, std::move(p), type, count__val, text__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_month, lngtag_day> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_month, rpl::producer<S<P>> month__val, lngtag_day, rpl::producer<S<P>> day__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_month, lngtag_day>::Combine(base, std::move(p), month__val, day__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_month, const S<P> &month__val, lngtag_day, const S<P> &day__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_month, lngtag_day>::Current(base, std::move(p), month__val, day__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_month, lngtag_day, lngtag_year> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_month, rpl::producer<S<P>> month__val, lngtag_day, rpl::producer<S<P>> day__val, lngtag_year, rpl::producer<S<P>> year__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_month, lngtag_day, lngtag_year>::Combine(base, std::move(p), month__val, day__val, year__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_month, const S<P> &month__val, lngtag_day, const S<P> &day__val, lngtag_year, const S<P> &year__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_month, lngtag_day, lngtag_year>::Current(base, std::move(p), month__val, day__val, year__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_month, lngtag_year> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_month, rpl::producer<S<P>> month__val, lngtag_year, rpl::producer<S<P>> year__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_month, lngtag_year>::Combine(base, std::move(p), month__val, year__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_month, const S<P> &month__val, lngtag_year, const S<P> &year__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_month, lngtag_year>::Current(base, std::move(p), month__val, year__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count>::Combine(base, std::move(p), type, count__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count>::Current(base, std::move(p), type, count__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_time> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_time, rpl::producer<S<P>> time__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_time>::Combine(base, std::move(p), time__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_time, const S<P> &time__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_time>::Current(base, std::move(p), time__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date>::Combine(base, std::move(p), date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date>::Current(base, std::move(p), date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_date, lngtag_time> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_date, rpl::producer<S<P>> date__val, lngtag_time, rpl::producer<S<P>> time__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date, lngtag_time>::Combine(base, std::move(p), date__val, time__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_date, const S<P> &date__val, lngtag_time, const S<P> &time__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date, lngtag_time>::Current(base, std::move(p), date__val, time__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_members_count, lngtag_online_count> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_members_count, rpl::producer<S<P>> members_count__val, lngtag_online_count, rpl::producer<S<P>> online_count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_members_count, lngtag_online_count>::Combine(base, std::move(p), members_count__val, online_count__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_members_count, const S<P> &members_count__val, lngtag_online_count, const S<P> &online_count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_members_count, lngtag_online_count>::Current(base, std::move(p), members_count__val, online_count__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user>::Combine(base, std::move(p), user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user>::Current(base, std::move(p), user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_type, lngtag_time> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_type, rpl::producer<S<P>> type__val, lngtag_time, rpl::producer<S<P>> time__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_type, lngtag_time>::Combine(base, std::move(p), type__val, time__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_type, const S<P> &type__val, lngtag_time, const S<P> &time__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_type, lngtag_time>::Current(base, std::move(p), type__val, time__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_link>::Combine(base, std::move(p), type, count__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_link>::Current(base, std::move(p), type, count__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_size> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_size, rpl::producer<S<P>> size__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_size>::Combine(base, std::move(p), size__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_size, const S<P> &size__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_size>::Current(base, std::move(p), size__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_more_info> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_more_info, rpl::producer<S<P>> more_info__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_more_info>::Combine(base, std::move(p), more_info__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_more_info, const S<P> &more_info__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_more_info>::Current(base, std::move(p), more_info__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_server, lngtag_port> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_server, rpl::producer<S<P>> server__val, lngtag_port, rpl::producer<S<P>> port__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_server, lngtag_port>::Combine(base, std::move(p), server__val, port__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_server, const S<P> &server__val, lngtag_port, const S<P> &port__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_server, lngtag_port>::Current(base, std::move(p), server__val, port__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_phone_number> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_phone_number, rpl::producer<S<P>> phone_number__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_phone_number>::Combine(base, std::move(p), phone_number__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_phone_number, const S<P> &phone_number__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_phone_number>::Current(base, std::move(p), phone_number__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_email> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_email, rpl::producer<S<P>> email__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_email>::Combine(base, std::move(p), email__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_email, const S<P> &email__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_email>::Current(base, std::move(p), email__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_minutes, lngtag_seconds> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_minutes, rpl::producer<S<P>> minutes__val, lngtag_seconds, rpl::producer<S<P>> seconds__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_minutes, lngtag_seconds>::Combine(base, std::move(p), minutes__val, seconds__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_minutes, const S<P> &minutes__val, lngtag_seconds, const S<P> &seconds__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_minutes, lngtag_seconds>::Current(base, std::move(p), minutes__val, seconds__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_password_hint> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_password_hint, rpl::producer<S<P>> password_hint__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_password_hint>::Combine(base, std::move(p), password_hint__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_password_hint, const S<P> &password_hint__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_password_hint>::Current(base, std::move(p), password_hint__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_recover_email> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_recover_email, rpl::producer<S<P>> recover_email__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_recover_email>::Combine(base, std::move(p), recover_email__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_recover_email, const S<P> &recover_email__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_recover_email>::Current(base, std::move(p), recover_email__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_phone_number, lngtag_when> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_phone_number, rpl::producer<S<P>> phone_number__val, lngtag_when, rpl::producer<S<P>> when__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_phone_number, lngtag_when>::Combine(base, std::move(p), phone_number__val, when__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_phone_number, const S<P> &phone_number__val, lngtag_when, const S<P> &when__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_phone_number, lngtag_when>::Current(base, std::move(p), phone_number__val, when__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_days_count, lngtag_hours_count, lngtag_minutes_count> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_days_count, rpl::producer<S<P>> days_count__val, lngtag_hours_count, rpl::producer<S<P>> hours_count__val, lngtag_minutes_count, rpl::producer<S<P>> minutes_count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_days_count, lngtag_hours_count, lngtag_minutes_count>::Combine(base, std::move(p), days_count__val, hours_count__val, minutes_count__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_days_count, const S<P> &days_count__val, lngtag_hours_count, const S<P> &hours_count__val, lngtag_minutes_count, const S<P> &minutes_count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_days_count, lngtag_hours_count, lngtag_minutes_count>::Current(base, std::move(p), days_count__val, hours_count__val, minutes_count__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_hours_count, lngtag_minutes_count> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_hours_count, rpl::producer<S<P>> hours_count__val, lngtag_minutes_count, rpl::producer<S<P>> minutes_count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_hours_count, lngtag_minutes_count>::Combine(base, std::move(p), hours_count__val, minutes_count__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_hours_count, const S<P> &hours_count__val, lngtag_minutes_count, const S<P> &minutes_count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_hours_count, lngtag_minutes_count>::Current(base, std::move(p), hours_count__val, minutes_count__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_link>::Combine(base, std::move(p), link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_link>::Current(base, std::move(p), link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_phone> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_phone, rpl::producer<S<P>> phone__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_phone>::Combine(base, std::move(p), phone__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_phone, const S<P> &phone__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_phone>::Current(base, std::move(p), phone__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_username> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_username, rpl::producer<S<P>> username__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_username>::Combine(base, std::move(p), username__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_username, const S<P> &username__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_username>::Current(base, std::move(p), username__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_date, lngtag_price> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_date, rpl::producer<S<P>> date__val, lngtag_price, rpl::producer<S<P>> price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date, lngtag_price>::Combine(base, std::move(p), date__val, price__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_date, const S<P> &date__val, lngtag_price, const S<P> &price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date, lngtag_price>::Current(base, std::move(p), date__val, price__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_exceptions> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_exceptions, rpl::producer<S<P>> exceptions__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_exceptions>::Combine(base, std::move(p), exceptions__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_exceptions, const S<P> &exceptions__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_exceptions>::Current(base, std::move(p), exceptions__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_reaction, lngtag_text> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_reaction, rpl::producer<S<P>> reaction__val, lngtag_text, rpl::producer<S<P>> text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_reaction, lngtag_text>::Combine(base, std::move(p), reaction__val, text__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_reaction, const S<P> &reaction__val, lngtag_text, const S<P> &text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_reaction, lngtag_text>::Current(base, std::move(p), reaction__val, text__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_reaction> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_reaction, rpl::producer<S<P>> reaction__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_reaction>::Combine(base, std::move(p), reaction__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_reaction, const S<P> &reaction__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_reaction>::Current(base, std::move(p), reaction__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_reaction, lngtag_emoji> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_reaction, rpl::producer<S<P>> reaction__val, lngtag_emoji, rpl::producer<S<P>> emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_reaction, lngtag_emoji>::Combine(base, std::move(p), reaction__val, emoji__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_reaction, const S<P> &reaction__val, lngtag_emoji, const S<P> &emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_reaction, lngtag_emoji>::Current(base, std::move(p), reaction__val, emoji__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_reaction, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_reaction, rpl::producer<S<P>> reaction__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_reaction, lngtag_name>::Combine(base, std::move(p), reaction__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_reaction, const S<P> &reaction__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_reaction, lngtag_name>::Current(base, std::move(p), reaction__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_reaction, lngtag_title> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_reaction, rpl::producer<S<P>> reaction__val, lngtag_title, rpl::producer<S<P>> title__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_reaction, lngtag_title>::Combine(base, std::move(p), reaction__val, title__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_reaction, const S<P> &reaction__val, lngtag_title, const S<P> &title__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_reaction, lngtag_title>::Current(base, std::move(p), reaction__val, title__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_version> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_version, rpl::producer<S<P>> version__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_version>::Combine(base, std::move(p), version__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_version, const S<P> &version__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_version>::Current(base, std::move(p), version__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_text> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_text, rpl::producer<S<P>> text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_text>::Combine(base, std::move(p), text__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_text, const S<P> &text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_text>::Current(base, std::move(p), text__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_index> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_index, rpl::producer<S<P>> index__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_index>::Combine(base, std::move(p), index__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_index, const S<P> &index__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_index>::Current(base, std::move(p), index__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_progress> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_progress, rpl::producer<S<P>> progress__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_progress>::Combine(base, std::move(p), progress__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_progress, const S<P> &progress__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_progress>::Current(base, std::move(p), progress__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_domain> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_domain, rpl::producer<S<P>> domain__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_domain>::Combine(base, std::move(p), domain__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_domain, const S<P> &domain__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_domain>::Current(base, std::move(p), domain__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name>::Combine(base, std::move(p), name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name>::Current(base, std::move(p), name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_emoji> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_emoji, rpl::producer<S<P>> emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji>::Combine(base, std::move(p), emoji__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_emoji, const S<P> &emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji>::Current(base, std::move(p), emoji__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_duration>::Combine(base, std::move(p), duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_duration>::Current(base, std::move(p), duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_after_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_after_duration, rpl::producer<S<P>> after_duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_after_duration>::Combine(base, std::move(p), after_duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_after_duration, const S<P> &after_duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_after_duration>::Current(base, std::move(p), after_duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_duration>::Combine(base, std::move(p), type, count__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_duration>::Current(base, std::move(p), type, count__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_limit> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_limit, rpl::producer<S<P>> limit__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_limit>::Combine(base, std::move(p), limit__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_limit, const S<P> &limit__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_limit>::Current(base, std::move(p), limit__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_transport> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_transport, rpl::producer<S<P>> transport__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_transport>::Combine(base, std::move(p), transport__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_transport, const S<P> &transport__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_transport>::Current(base, std::move(p), transport__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_ping> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_ping, rpl::producer<S<P>> ping__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_ping>::Combine(base, std::move(p), ping__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_ping, const S<P> &ping__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_ping>::Current(base, std::move(p), ping__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_users> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_users, rpl::producer<S<P>> users__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_users>::Combine(base, std::move(p), users__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_users, const S<P> &users__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_users>::Current(base, std::move(p), users__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_percent, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_percent, rpl::producer<S<P>> percent__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_percent, lngtag_amount>::Combine(base, std::move(p), percent__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_percent, const S<P> &percent__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_percent, lngtag_amount>::Current(base, std::move(p), percent__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_users> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_users, rpl::producer<S<P>> users__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_users>::Combine(base, std::move(p), type, count__val, users__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_users, const S<P> &users__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_users>::Current(base, std::move(p), type, count__val, users__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_users, lngtag_last> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_users, rpl::producer<S<P>> users__val, lngtag_last, rpl::producer<S<P>> last__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_users, lngtag_last>::Combine(base, std::move(p), users__val, last__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_users, const S<P> &users__val, lngtag_last, const S<P> &last__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_users, lngtag_last>::Current(base, std::move(p), users__val, last__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_chat> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_chat, rpl::producer<S<P>> chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_chat>::Combine(base, std::move(p), user__val, chat__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_chat, const S<P> &chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_chat>::Current(base, std::move(p), user__val, chat__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_date>::Combine(base, std::move(p), type, count__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_date>::Current(base, std::move(p), type, count__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_emoji, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_date>::Combine(base, std::move(p), emoji__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_emoji, const S<P> &emoji__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_date>::Current(base, std::move(p), emoji__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_terms> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_terms, rpl::producer<S<P>> terms__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_terms>::Combine(base, std::move(p), terms__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_terms, const S<P> &terms__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_terms>::Current(base, std::move(p), terms__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_same_count> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_same_count, rpl::producer<S<P>> same_count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_same_count>::Combine(base, std::move(p), type, count__val, same_count__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_same_count, const S<P> &same_count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_same_count>::Current(base, std::move(p), type, count__val, same_count__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_bot, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_bot, rpl::producer<S<P>> bot__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot, lngtag_amount>::Combine(base, std::move(p), bot__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_bot, const S<P> &bot__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot, lngtag_amount>::Current(base, std::move(p), bot__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_bot> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_bot, rpl::producer<S<P>> bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot>::Combine(base, std::move(p), bot__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_bot, const S<P> &bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot>::Current(base, std::move(p), bot__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_sort> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_sort, rpl::producer<S<P>> sort__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_sort>::Combine(base, std::move(p), sort__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_sort, const S<P> &sort__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_sort>::Current(base, std::move(p), sort__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_app, lngtag_amount, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_app, rpl::producer<S<P>> app__val, lngtag_amount, rpl::producer<S<P>> amount__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_app, lngtag_amount, lngtag_duration>::Combine(base, std::move(p), app__val, amount__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_app, const S<P> &app__val, lngtag_amount, const S<P> &amount__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_app, lngtag_amount, lngtag_duration>::Current(base, std::move(p), app__val, amount__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount>::Combine(base, std::move(p), amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount>::Current(base, std::move(p), amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_amount, lngtag_app, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_amount, rpl::producer<S<P>> amount__val, lngtag_app, rpl::producer<S<P>> app__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_app, lngtag_duration>::Combine(base, std::move(p), amount__val, app__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_amount, const S<P> &amount__val, lngtag_app, const S<P> &app__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_app, lngtag_duration>::Current(base, std::move(p), amount__val, app__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_app> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_app, rpl::producer<S<P>> app__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_app>::Combine(base, std::move(p), app__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_app, const S<P> &app__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_app>::Current(base, std::move(p), app__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_app> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_app, rpl::producer<S<P>> app__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_app>::Combine(base, std::move(p), type, count__val, app__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_app, const S<P> &app__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_app>::Current(base, std::move(p), type, count__val, app__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_amount, lngtag_app> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_amount, rpl::producer<S<P>> amount__val, lngtag_app, rpl::producer<S<P>> app__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_app>::Combine(base, std::move(p), amount__val, app__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_amount, const S<P> &amount__val, lngtag_app, const S<P> &app__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_app>::Current(base, std::move(p), amount__val, app__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_when, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_when, rpl::producer<S<P>> when__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_when, lngtag_link>::Combine(base, std::move(p), type, count__val, when__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_when, const S<P> &when__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_when, lngtag_link>::Current(base, std::move(p), type, count__val, when__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_arrow> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_arrow, rpl::producer<S<P>> arrow__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_arrow>::Combine(base, std::move(p), arrow__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_arrow, const S<P> &arrow__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_arrow>::Current(base, std::move(p), arrow__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_group> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_group, rpl::producer<S<P>> group__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_group>::Combine(base, std::move(p), group__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_group, const S<P> &group__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_group>::Current(base, std::move(p), group__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_group, lngtag_channel> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_group, rpl::producer<S<P>> group__val, lngtag_channel, rpl::producer<S<P>> channel__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_group, lngtag_channel>::Combine(base, std::move(p), group__val, channel__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_group, const S<P> &group__val, lngtag_channel, const S<P> &channel__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_group, lngtag_channel>::Current(base, std::move(p), group__val, channel__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_channel> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_channel, rpl::producer<S<P>> channel__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel>::Combine(base, std::move(p), channel__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_channel, const S<P> &channel__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel>::Current(base, std::move(p), channel__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_group> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_group, rpl::producer<S<P>> group__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_group>::Combine(base, std::move(p), user__val, group__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_group, const S<P> &group__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_group>::Current(base, std::move(p), user__val, group__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_group> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_group, rpl::producer<S<P>> group__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_group>::Combine(base, std::move(p), type, count__val, group__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_group, const S<P> &group__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_group>::Current(base, std::move(p), type, count__val, group__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_contact> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_contact, rpl::producer<S<P>> contact__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_contact>::Combine(base, std::move(p), contact__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_contact, const S<P> &contact__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_contact>::Current(base, std::move(p), contact__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_days> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_days, rpl::producer<S<P>> days__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_days>::Combine(base, std::move(p), days__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_days, const S<P> &days__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_days>::Current(base, std::move(p), days__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_minutes_count, lngtag_seconds_count> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_minutes_count, rpl::producer<S<P>> minutes_count__val, lngtag_seconds_count, rpl::producer<S<P>> seconds_count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_minutes_count, lngtag_seconds_count>::Combine(base, std::move(p), minutes_count__val, seconds_count__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_minutes_count, const S<P> &minutes_count__val, lngtag_seconds_count, const S<P> &seconds_count__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_minutes_count, lngtag_seconds_count>::Current(base, std::move(p), minutes_count__val, seconds_count__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_user, lngtag_chat> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_user, rpl::producer<S<P>> user__val, lngtag_chat, rpl::producer<S<P>> chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_user, lngtag_chat>::Combine(base, std::move(p), from__val, user__val, chat__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_user, const S<P> &user__val, lngtag_chat, const S<P> &chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_user, lngtag_chat>::Current(base, std::move(p), from__val, user__val, chat__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_users, lngtag_chat> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_users, rpl::producer<S<P>> users__val, lngtag_chat, rpl::producer<S<P>> chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_users, lngtag_chat>::Combine(base, std::move(p), from__val, users__val, chat__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_users, const S<P> &users__val, lngtag_chat, const S<P> &chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_users, lngtag_chat>::Current(base, std::move(p), from__val, users__val, chat__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_accumulated, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_accumulated, rpl::producer<S<P>> accumulated__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_accumulated, lngtag_user>::Combine(base, std::move(p), accumulated__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_accumulated, const S<P> &accumulated__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_accumulated, lngtag_user>::Current(base, std::move(p), accumulated__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from>::Combine(base, std::move(p), from__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from>::Current(base, std::move(p), from__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_date>::Combine(base, std::move(p), from__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_date>::Current(base, std::move(p), from__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_duration>::Combine(base, std::move(p), from__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_duration>::Current(base, std::move(p), from__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_user>::Combine(base, std::move(p), from__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_user>::Current(base, std::move(p), from__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_users> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_users, rpl::producer<S<P>> users__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_users>::Combine(base, std::move(p), from__val, users__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_users, const S<P> &users__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_users>::Current(base, std::move(p), from__val, users__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_title> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_title, rpl::producer<S<P>> title__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_title>::Combine(base, std::move(p), from__val, title__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_title, const S<P> &title__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_title>::Current(base, std::move(p), from__val, title__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_title> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_title, rpl::producer<S<P>> title__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_title>::Combine(base, std::move(p), title__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_title, const S<P> &title__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_title>::Current(base, std::move(p), title__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_text> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_text, rpl::producer<S<P>> text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_text>::Combine(base, std::move(p), from__val, text__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_text, const S<P> &text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_text>::Current(base, std::move(p), from__val, text__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_media> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_media, rpl::producer<S<P>> media__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_media>::Combine(base, std::move(p), from__val, media__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_media, const S<P> &media__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_media>::Current(base, std::move(p), from__val, media__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_game> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_game, rpl::producer<S<P>> game__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_game>::Combine(base, std::move(p), game__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_game, const S<P> &game__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_game>::Current(base, std::move(p), game__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_from, lngtag_game> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_from, rpl::producer<S<P>> from__val, lngtag_game, rpl::producer<S<P>> game__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_from, lngtag_game>::Combine(base, std::move(p), type, count__val, from__val, game__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_from, const S<P> &from__val, lngtag_game, const S<P> &game__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_from, lngtag_game>::Current(base, std::move(p), type, count__val, from__val, game__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_game> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_game, rpl::producer<S<P>> game__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_game>::Combine(base, std::move(p), type, count__val, game__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_game, const S<P> &game__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_game>::Current(base, std::move(p), type, count__val, game__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_from> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_from, rpl::producer<S<P>> from__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_from>::Combine(base, std::move(p), type, count__val, from__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_from, const S<P> &from__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_from>::Current(base, std::move(p), type, count__val, from__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_amount, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_amount, rpl::producer<S<P>> amount__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_user>::Combine(base, std::move(p), amount__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_amount, const S<P> &amount__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_user>::Current(base, std::move(p), amount__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_amount, lngtag_user, lngtag_invoice> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_amount, rpl::producer<S<P>> amount__val, lngtag_user, rpl::producer<S<P>> user__val, lngtag_invoice, rpl::producer<S<P>> invoice__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_user, lngtag_invoice>::Combine(base, std::move(p), amount__val, user__val, invoice__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_amount, const S<P> &amount__val, lngtag_user, const S<P> &user__val, lngtag_invoice, const S<P> &invoice__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_user, lngtag_invoice>::Current(base, std::move(p), amount__val, user__val, invoice__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_documents> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_documents, rpl::producer<S<P>> documents__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_documents>::Combine(base, std::move(p), user__val, documents__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_documents, const S<P> &documents__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_documents>::Current(base, std::move(p), user__val, documents__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_distance, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_distance, rpl::producer<S<P>> distance__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_distance, lngtag_user>::Combine(base, std::move(p), from__val, distance__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_distance, const S<P> &distance__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_distance, lngtag_user>::Current(base, std::move(p), from__val, distance__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_distance> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_distance, rpl::producer<S<P>> distance__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_distance>::Combine(base, std::move(p), from__val, distance__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_distance, const S<P> &distance__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_distance>::Current(base, std::move(p), from__val, distance__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_distance, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_distance, rpl::producer<S<P>> distance__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_distance, lngtag_user>::Combine(base, std::move(p), distance__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_distance, const S<P> &distance__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_distance, lngtag_user>::Current(base, std::move(p), distance__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_emoji> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_emoji, rpl::producer<S<P>> emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_emoji>::Combine(base, std::move(p), from__val, emoji__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_emoji, const S<P> &emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_emoji>::Current(base, std::move(p), from__val, emoji__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_name>::Combine(base, std::move(p), from__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_name>::Current(base, std::move(p), from__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_cost> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_cost, rpl::producer<S<P>> cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_cost>::Combine(base, std::move(p), user__val, cost__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_cost, const S<P> &cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_cost>::Current(base, std::move(p), user__val, cost__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_cost> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_cost, rpl::producer<S<P>> cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_cost>::Combine(base, std::move(p), cost__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_cost, const S<P> &cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_cost>::Current(base, std::move(p), cost__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_channel> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_channel, rpl::producer<S<P>> channel__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_channel>::Combine(base, std::move(p), user__val, channel__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_channel, const S<P> &channel__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_channel>::Current(base, std::move(p), user__val, channel__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_cost, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_cost, rpl::producer<S<P>> cost__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_cost, lngtag_user>::Combine(base, std::move(p), from__val, cost__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_cost, const S<P> &cost__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_cost, lngtag_user>::Current(base, std::move(p), from__val, cost__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_cost, lngtag_name, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_cost, rpl::producer<S<P>> cost__val, lngtag_name, rpl::producer<S<P>> name__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_cost, lngtag_name, lngtag_user>::Combine(base, std::move(p), cost__val, name__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_cost, const S<P> &cost__val, lngtag_name, const S<P> &name__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_cost, lngtag_name, lngtag_user>::Current(base, std::move(p), cost__val, name__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_cost> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_cost, rpl::producer<S<P>> cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_cost>::Combine(base, std::move(p), from__val, cost__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_cost, const S<P> &cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_cost>::Current(base, std::move(p), from__val, cost__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_cost, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_cost, rpl::producer<S<P>> cost__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_cost, lngtag_name>::Combine(base, std::move(p), cost__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_cost, const S<P> &cost__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_cost, lngtag_name>::Current(base, std::move(p), cost__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_name, lngtag_cost> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_name, rpl::producer<S<P>> name__val, lngtag_cost, rpl::producer<S<P>> cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_name, lngtag_cost>::Combine(base, std::move(p), user__val, name__val, cost__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_name, const S<P> &name__val, lngtag_cost, const S<P> &cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_name, lngtag_cost>::Current(base, std::move(p), user__val, name__val, cost__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_cost> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_cost, rpl::producer<S<P>> cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_cost>::Combine(base, std::move(p), name__val, cost__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_cost, const S<P> &cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_cost>::Current(base, std::move(p), name__val, cost__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_user>::Combine(base, std::move(p), type, count__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_user>::Current(base, std::move(p), type, count__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_cost, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_cost, rpl::producer<S<P>> cost__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_cost, lngtag_name>::Combine(base, std::move(p), user__val, cost__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_cost, const S<P> &cost__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_cost, lngtag_name>::Current(base, std::move(p), user__val, cost__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_hours> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_hours, rpl::producer<S<P>> hours__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_hours>::Combine(base, std::move(p), hours__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_hours, const S<P> &hours__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_hours>::Current(base, std::move(p), hours__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_hours, lngtag_minutes> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_hours, rpl::producer<S<P>> hours__val, lngtag_minutes, rpl::producer<S<P>> minutes__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_hours, lngtag_minutes>::Combine(base, std::move(p), hours__val, minutes__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_hours, const S<P> &hours__val, lngtag_minutes, const S<P> &minutes__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_hours, lngtag_minutes>::Current(base, std::move(p), hours__val, minutes__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_minutes> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_minutes, rpl::producer<S<P>> minutes__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_minutes>::Combine(base, std::move(p), minutes__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_minutes, const S<P> &minutes__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_minutes>::Current(base, std::move(p), minutes__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_topic> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_topic, rpl::producer<S<P>> topic__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_topic>::Combine(base, std::move(p), topic__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_topic, const S<P> &topic__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_topic>::Current(base, std::move(p), topic__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_link, lngtag_title> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_link, rpl::producer<S<P>> link__val, lngtag_title, rpl::producer<S<P>> title__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_link, lngtag_title>::Combine(base, std::move(p), from__val, link__val, title__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_link, const S<P> &link__val, lngtag_title, const S<P> &title__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_link, lngtag_title>::Current(base, std::move(p), from__val, link__val, title__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_link, lngtag_emoji> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_link, rpl::producer<S<P>> link__val, lngtag_emoji, rpl::producer<S<P>> emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_link, lngtag_emoji>::Combine(base, std::move(p), from__val, link__val, emoji__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_link, const S<P> &link__val, lngtag_emoji, const S<P> &emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_link, lngtag_emoji>::Current(base, std::move(p), from__val, link__val, emoji__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_link>::Combine(base, std::move(p), from__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_link>::Current(base, std::move(p), from__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_chat, lngtag_bot> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_chat, rpl::producer<S<P>> chat__val, lngtag_bot, rpl::producer<S<P>> bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_chat, lngtag_bot>::Combine(base, std::move(p), chat__val, bot__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_chat, const S<P> &chat__val, lngtag_bot, const S<P> &bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_chat, lngtag_bot>::Current(base, std::move(p), chat__val, bot__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_amount>::Combine(base, std::move(p), from__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_amount>::Current(base, std::move(p), from__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_peer, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_peer, rpl::producer<S<P>> peer__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_peer, lngtag_amount>::Combine(base, std::move(p), peer__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_peer, const S<P> &peer__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_peer, lngtag_amount>::Current(base, std::move(p), peer__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_action> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_action, rpl::producer<S<P>> action__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_action>::Combine(base, std::move(p), type, count__val, action__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_action, const S<P> &action__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_action>::Current(base, std::move(p), type, count__val, action__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_name>::Combine(base, std::move(p), type, count__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_name>::Current(base, std::move(p), type, count__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_tasks> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_tasks, rpl::producer<S<P>> tasks__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_tasks>::Combine(base, std::move(p), from__val, tasks__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_tasks, const S<P> &tasks__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_tasks>::Current(base, std::move(p), from__val, tasks__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_tasks> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_tasks, rpl::producer<S<P>> tasks__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_tasks>::Combine(base, std::move(p), tasks__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_tasks, const S<P> &tasks__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_tasks>::Current(base, std::move(p), tasks__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_tasks, lngtag_task> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_tasks, rpl::producer<S<P>> tasks__val, lngtag_task, rpl::producer<S<P>> task__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_tasks, lngtag_task>::Combine(base, std::move(p), tasks__val, task__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_tasks, const S<P> &tasks__val, lngtag_task, const S<P> &task__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_tasks, lngtag_task>::Current(base, std::move(p), tasks__val, task__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_from> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_from, rpl::producer<S<P>> from__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_from>::Combine(base, std::move(p), user__val, from__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_from, const S<P> &from__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_from>::Current(base, std::move(p), user__val, from__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_link, lngtag_group> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_link, rpl::producer<S<P>> link__val, lngtag_group, rpl::producer<S<P>> group__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_link, lngtag_group>::Combine(base, std::move(p), link__val, group__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_link, const S<P> &link__val, lngtag_group, const S<P> &group__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_link, lngtag_group>::Current(base, std::move(p), link__val, group__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_channel, lngtag_price> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_price, rpl::producer<S<P>> price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_price>::Combine(base, std::move(p), channel__val, price__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_channel, const S<P> &channel__val, lngtag_price, const S<P> &price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_price>::Current(base, std::move(p), channel__val, price__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_when> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_when, rpl::producer<S<P>> when__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_when>::Combine(base, std::move(p), when__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_when, const S<P> &when__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_when>::Current(base, std::move(p), when__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_emoji, lngtag_price, lngtag_multiplier, lngtag_total> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_price, rpl::producer<S<P>> price__val, lngtag_multiplier, rpl::producer<S<P>> multiplier__val, lngtag_total, rpl::producer<S<P>> total__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_price, lngtag_multiplier, lngtag_total>::Combine(base, std::move(p), emoji__val, price__val, multiplier__val, total__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_emoji, const S<P> &emoji__val, lngtag_price, const S<P> &price__val, lngtag_multiplier, const S<P> &multiplier__val, lngtag_total, const S<P> &total__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_price, lngtag_multiplier, lngtag_total>::Current(base, std::move(p), emoji__val, price__val, multiplier__val, total__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_emoji, lngtag_price> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_price, rpl::producer<S<P>> price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_price>::Combine(base, std::move(p), emoji__val, price__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_emoji, const S<P> &emoji__val, lngtag_price, const S<P> &price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_price>::Current(base, std::move(p), emoji__val, price__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_total> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_total, rpl::producer<S<P>> total__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_total>::Combine(base, std::move(p), total__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_total, const S<P> &total__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_total>::Current(base, std::move(p), total__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_inline_bot> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_inline_bot, rpl::producer<S<P>> inline_bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_inline_bot>::Combine(base, std::move(p), user__val, inline_bot__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_inline_bot, const S<P> &inline_bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_inline_bot>::Current(base, std::move(p), user__val, inline_bot__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_channel, lngtag_inline_bot> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_inline_bot, rpl::producer<S<P>> inline_bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_inline_bot>::Combine(base, std::move(p), channel__val, inline_bot__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_channel, const S<P> &channel__val, lngtag_inline_bot, const S<P> &inline_bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_inline_bot>::Current(base, std::move(p), channel__val, inline_bot__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_channel, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_user>::Combine(base, std::move(p), channel__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_channel, const S<P> &channel__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_user>::Current(base, std::move(p), channel__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_percent, lngtag_progress> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_percent, rpl::producer<S<P>> percent__val, lngtag_progress, rpl::producer<S<P>> progress__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_percent, lngtag_progress>::Combine(base, std::move(p), percent__val, progress__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_percent, const S<P> &percent__val, lngtag_progress, const S<P> &progress__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_percent, lngtag_progress>::Current(base, std::move(p), percent__val, progress__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_link>::Combine(base, std::move(p), user__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_link>::Current(base, std::move(p), user__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_second_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_second_user, rpl::producer<S<P>> second_user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_second_user>::Combine(base, std::move(p), user__val, second_user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_second_user, const S<P> &second_user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_second_user>::Current(base, std::move(p), user__val, second_user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_second_user, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_second_user, rpl::producer<S<P>> second_user__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_second_user, lngtag_name>::Combine(base, std::move(p), user__val, second_user__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_second_user, const S<P> &second_user__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_second_user, lngtag_name>::Current(base, std::move(p), user__val, second_user__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_user, lngtag_second_user, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_user, rpl::producer<S<P>> user__val, lngtag_second_user, rpl::producer<S<P>> second_user__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_user, lngtag_second_user, lngtag_name>::Combine(base, std::move(p), type, count__val, user__val, second_user__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_user, const S<P> &user__val, lngtag_second_user, const S<P> &second_user__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_user, lngtag_second_user, lngtag_name>::Current(base, std::move(p), type, count__val, user__val, second_user__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_emoji> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_emoji, rpl::producer<S<P>> emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_emoji>::Combine(base, std::move(p), type, count__val, emoji__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_emoji, const S<P> &emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_emoji>::Current(base, std::move(p), type, count__val, emoji__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_link, lngtag_policy> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_link, rpl::producer<S<P>> link__val, lngtag_policy, rpl::producer<S<P>> policy__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_link, lngtag_policy>::Combine(base, std::move(p), link__val, policy__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_link, const S<P> &link__val, lngtag_policy, const S<P> &policy__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_link, lngtag_policy>::Current(base, std::move(p), link__val, policy__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_percent, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_percent, rpl::producer<S<P>> percent__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_percent, lngtag_link>::Combine(base, std::move(p), percent__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_percent, const S<P> &percent__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_percent, lngtag_link>::Current(base, std::move(p), percent__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_emoji, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_amount>::Combine(base, std::move(p), emoji__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_emoji, const S<P> &emoji__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_amount>::Current(base, std::move(p), emoji__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_text, lngtag_bot> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_text, rpl::producer<S<P>> text__val, lngtag_bot, rpl::producer<S<P>> bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_text, lngtag_bot>::Combine(base, std::move(p), type, count__val, text__val, bot__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_text, const S<P> &text__val, lngtag_bot, const S<P> &bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_text, lngtag_bot>::Current(base, std::move(p), type, count__val, text__val, bot__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_media, lngtag_chat> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_media, rpl::producer<S<P>> media__val, lngtag_chat, rpl::producer<S<P>> chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_media, lngtag_chat>::Combine(base, std::move(p), type, count__val, media__val, chat__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_media, const S<P> &media__val, lngtag_chat, const S<P> &chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_media, lngtag_chat>::Current(base, std::move(p), type, count__val, media__val, chat__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_media, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_media, rpl::producer<S<P>> media__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_media, lngtag_user>::Combine(base, std::move(p), type, count__val, media__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_media, const S<P> &media__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_media, lngtag_user>::Current(base, std::move(p), type, count__val, media__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_title, lngtag_recipient> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_title, rpl::producer<S<P>> title__val, lngtag_recipient, rpl::producer<S<P>> recipient__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_title, lngtag_recipient>::Combine(base, std::move(p), type, count__val, title__val, recipient__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_title, const S<P> &title__val, lngtag_recipient, const S<P> &recipient__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_title, lngtag_recipient>::Current(base, std::move(p), type, count__val, title__val, recipient__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_photo, lngtag_video> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_photo, rpl::producer<S<P>> photo__val, lngtag_video, rpl::producer<S<P>> video__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_photo, lngtag_video>::Combine(base, std::move(p), photo__val, video__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_photo, const S<P> &photo__val, lngtag_video, const S<P> &video__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_photo, lngtag_video>::Current(base, std::move(p), photo__val, video__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_chat> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_chat, rpl::producer<S<P>> chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_chat>::Combine(base, std::move(p), type, count__val, chat__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_chat, const S<P> &chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_chat>::Current(base, std::move(p), type, count__val, chat__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_emoji, lngtag_cost> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_cost, rpl::producer<S<P>> cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_cost>::Combine(base, std::move(p), emoji__val, cost__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_emoji, const S<P> &emoji__val, lngtag_cost, const S<P> &cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_cost>::Current(base, std::move(p), emoji__val, cost__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_shortcut> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_shortcut, rpl::producer<S<P>> shortcut__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_shortcut>::Combine(base, std::move(p), shortcut__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_shortcut, const S<P> &shortcut__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_shortcut>::Current(base, std::move(p), shortcut__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_links> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_links, rpl::producer<S<P>> links__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_links>::Combine(base, std::move(p), links__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_links, const S<P> &links__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_links>::Current(base, std::move(p), links__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_username, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_username, rpl::producer<S<P>> username__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_username, lngtag_link>::Combine(base, std::move(p), username__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_username, const S<P> &username__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_username, lngtag_link>::Current(base, std::move(p), username__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_channel> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_channel, rpl::producer<S<P>> channel__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel>::Combine(base, std::move(p), type, count__val, channel__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_channel, const S<P> &channel__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel>::Current(base, std::move(p), type, count__val, channel__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_post> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_post, rpl::producer<S<P>> post__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_post>::Combine(base, std::move(p), type, count__val, post__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_post, const S<P> &post__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_post>::Current(base, std::move(p), type, count__val, post__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_left> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_left, rpl::producer<S<P>> left__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_left>::Combine(base, std::move(p), left__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_left, const S<P> &left__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_left>::Current(base, std::move(p), left__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_channel, lngtag_other> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_other, rpl::producer<S<P>> other__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_other>::Combine(base, std::move(p), channel__val, other__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_channel, const S<P> &channel__val, lngtag_other, const S<P> &other__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_other>::Current(base, std::move(p), channel__val, other__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_channel, lngtag_gift> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_gift, rpl::producer<S<P>> gift__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_gift>::Combine(base, std::move(p), channel__val, gift__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_channel, const S<P> &channel__val, lngtag_gift, const S<P> &gift__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_gift>::Current(base, std::move(p), channel__val, gift__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_channels> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_channels, rpl::producer<S<P>> channels__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channels>::Combine(base, std::move(p), type, count__val, channels__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_channels, const S<P> &channels__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channels>::Current(base, std::move(p), type, count__val, channels__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_country> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_country, rpl::producer<S<P>> country__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_country>::Combine(base, std::move(p), country__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_country, const S<P> &country__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_country>::Current(base, std::move(p), country__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_price, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_price, rpl::producer<S<P>> price__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_price, lngtag_amount>::Combine(base, std::move(p), price__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_price, const S<P> &price__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_price, lngtag_amount>::Current(base, std::move(p), price__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_prize, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_prize, rpl::producer<S<P>> prize__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_prize, lngtag_duration>::Combine(base, std::move(p), type, count__val, prize__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_prize, const S<P> &prize__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_prize, lngtag_duration>::Current(base, std::move(p), type, count__val, prize__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_prize, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_prize, rpl::producer<S<P>> prize__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_prize, lngtag_amount>::Combine(base, std::move(p), type, count__val, prize__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_prize, const S<P> &prize__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_prize, lngtag_amount>::Current(base, std::move(p), type, count__val, prize__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_prize> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_prize, rpl::producer<S<P>> prize__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_prize>::Combine(base, std::move(p), type, count__val, prize__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_prize, const S<P> &prize__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_prize>::Current(base, std::move(p), type, count__val, prize__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_amount>::Combine(base, std::move(p), type, count__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_amount>::Current(base, std::move(p), type, count__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_countries> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_countries, rpl::producer<S<P>> countries__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_countries>::Combine(base, std::move(p), countries__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_countries, const S<P> &countries__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_countries>::Current(base, std::move(p), countries__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_countries, lngtag_country> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_countries, rpl::producer<S<P>> countries__val, lngtag_country, rpl::producer<S<P>> country__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_countries, lngtag_country>::Combine(base, std::move(p), countries__val, country__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_countries, const S<P> &countries__val, lngtag_country, const S<P> &country__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_countries, lngtag_country>::Current(base, std::move(p), countries__val, country__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_admins> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_admins, rpl::producer<S<P>> admins__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_admins>::Combine(base, std::move(p), admins__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_admins, const S<P> &admins__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_admins>::Current(base, std::move(p), admins__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_channel, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel, lngtag_duration>::Combine(base, std::move(p), type, count__val, channel__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_channel, const S<P> &channel__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel, lngtag_duration>::Current(base, std::move(p), type, count__val, channel__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_channel, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_amount>::Combine(base, std::move(p), channel__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_channel, const S<P> &channel__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_amount>::Current(base, std::move(p), channel__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_channel, lngtag_prize> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_prize, rpl::producer<S<P>> prize__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel, lngtag_prize>::Combine(base, std::move(p), type, count__val, channel__val, prize__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_channel, const S<P> &channel__val, lngtag_prize, const S<P> &prize__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel, lngtag_prize>::Current(base, std::move(p), type, count__val, channel__val, prize__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_date, lngtag_winners> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_date, rpl::producer<S<P>> date__val, lngtag_winners, rpl::producer<S<P>> winners__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date, lngtag_winners>::Combine(base, std::move(p), date__val, winners__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_date, const S<P> &date__val, lngtag_winners, const S<P> &winners__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date, lngtag_winners>::Current(base, std::move(p), date__val, winners__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_channel, lngtag_start_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_start_date, rpl::producer<S<P>> start_date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel, lngtag_start_date>::Combine(base, std::move(p), type, count__val, channel__val, start_date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_channel, const S<P> &channel__val, lngtag_start_date, const S<P> &start_date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel, lngtag_start_date>::Current(base, std::move(p), type, count__val, channel__val, start_date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_channel, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_date>::Combine(base, std::move(p), channel__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_channel, const S<P> &channel__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_channel, lngtag_date>::Current(base, std::move(p), channel__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_cup> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_cup, rpl::producer<S<P>> cup__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_cup>::Combine(base, std::move(p), cup__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_cup, const S<P> &cup__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_cup>::Current(base, std::move(p), cup__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_amount, lngtag_cup> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_amount, rpl::producer<S<P>> amount__val, lngtag_cup, rpl::producer<S<P>> cup__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_cup>::Combine(base, std::move(p), amount__val, cup__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_amount, const S<P> &amount__val, lngtag_cup, const S<P> &cup__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_cup>::Current(base, std::move(p), amount__val, cup__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_date, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_date, rpl::producer<S<P>> date__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date, lngtag_link>::Combine(base, std::move(p), date__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_date, const S<P> &date__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date, lngtag_link>::Current(base, std::move(p), date__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_features> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_features, rpl::producer<S<P>> features__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_features>::Combine(base, std::move(p), name__val, features__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_features, const S<P> &features__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_features>::Current(base, std::move(p), name__val, features__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_link>::Combine(base, std::move(p), name__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_link>::Current(base, std::move(p), name__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_price> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_price, rpl::producer<S<P>> price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_price>::Combine(base, std::move(p), price__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_price, const S<P> &price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_price>::Current(base, std::move(p), price__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_amount, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_amount, rpl::producer<S<P>> amount__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_link>::Combine(base, std::move(p), amount__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_amount, const S<P> &amount__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_link>::Current(base, std::move(p), amount__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_recipient> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_recipient, rpl::producer<S<P>> recipient__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_recipient>::Combine(base, std::move(p), user__val, recipient__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_recipient, const S<P> &recipient__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_recipient>::Current(base, std::move(p), user__val, recipient__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_price, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_price, rpl::producer<S<P>> price__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_price, lngtag_user>::Combine(base, std::move(p), name__val, price__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_price, const S<P> &price__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_price, lngtag_user>::Current(base, std::move(p), name__val, price__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_price> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_price, rpl::producer<S<P>> price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_price>::Combine(base, std::move(p), name__val, price__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_price, const S<P> &price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_price>::Current(base, std::move(p), name__val, price__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_gift> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_gift, rpl::producer<S<P>> gift__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_gift>::Combine(base, std::move(p), gift__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_gift, const S<P> &gift__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_gift>::Current(base, std::move(p), gift__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_index, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_index, rpl::producer<S<P>> index__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_index, lngtag_name>::Combine(base, std::move(p), index__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_index, const S<P> &index__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_index, lngtag_name>::Current(base, std::move(p), index__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_percent> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_percent, rpl::producer<S<P>> percent__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_percent>::Combine(base, std::move(p), percent__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_percent, const S<P> &percent__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_percent>::Current(base, std::move(p), percent__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_recipient, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_recipient, rpl::producer<S<P>> recipient__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_recipient, lngtag_date>::Combine(base, std::move(p), recipient__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_recipient, const S<P> &recipient__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_recipient, lngtag_date>::Current(base, std::move(p), recipient__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_recipient, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_recipient, rpl::producer<S<P>> recipient__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_recipient, lngtag_date>::Combine(base, std::move(p), from__val, recipient__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_recipient, const S<P> &recipient__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_recipient, lngtag_date>::Current(base, std::move(p), from__val, recipient__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_recipient, lngtag_date, lngtag_text> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_recipient, rpl::producer<S<P>> recipient__val, lngtag_date, rpl::producer<S<P>> date__val, lngtag_text, rpl::producer<S<P>> text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_recipient, lngtag_date, lngtag_text>::Combine(base, std::move(p), from__val, recipient__val, date__val, text__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_recipient, const S<P> &recipient__val, lngtag_date, const S<P> &date__val, lngtag_text, const S<P> &text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_recipient, lngtag_date, lngtag_text>::Current(base, std::move(p), from__val, recipient__val, date__val, text__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_recipient, lngtag_date, lngtag_text> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_recipient, rpl::producer<S<P>> recipient__val, lngtag_date, rpl::producer<S<P>> date__val, lngtag_text, rpl::producer<S<P>> text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_recipient, lngtag_date, lngtag_text>::Combine(base, std::move(p), recipient__val, date__val, text__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_recipient, const S<P> &recipient__val, lngtag_date, const S<P> &date__val, lngtag_text, const S<P> &text__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_recipient, lngtag_date, lngtag_text>::Current(base, std::move(p), recipient__val, date__val, text__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_gift, lngtag_platform> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_gift, rpl::producer<S<P>> gift__val, lngtag_platform, rpl::producer<S<P>> platform__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_gift, lngtag_platform>::Combine(base, std::move(p), gift__val, platform__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_gift, const S<P> &gift__val, lngtag_platform, const S<P> &platform__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_gift, lngtag_platform>::Current(base, std::move(p), gift__val, platform__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_stars, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_stars, rpl::producer<S<P>> stars__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_stars, lngtag_amount>::Combine(base, std::move(p), stars__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_stars, const S<P> &stars__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_stars, lngtag_amount>::Current(base, std::move(p), stars__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_amount, lngtag_gift> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_amount, rpl::producer<S<P>> amount__val, lngtag_gift, rpl::producer<S<P>> gift__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_gift>::Combine(base, std::move(p), amount__val, gift__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_amount, const S<P> &amount__val, lngtag_gift, const S<P> &gift__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_gift>::Current(base, std::move(p), amount__val, gift__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_emoji, lngtag_platform, lngtag_arrow> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_platform, rpl::producer<S<P>> platform__val, lngtag_arrow, rpl::producer<S<P>> arrow__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_emoji, lngtag_platform, lngtag_arrow>::Combine(base, std::move(p), type, count__val, emoji__val, platform__val, arrow__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_emoji, const S<P> &emoji__val, lngtag_platform, const S<P> &platform__val, lngtag_arrow, const S<P> &arrow__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_emoji, lngtag_platform, lngtag_arrow>::Current(base, std::move(p), type, count__val, emoji__val, platform__val, arrow__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_emoji, lngtag_arrow> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_arrow, rpl::producer<S<P>> arrow__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_arrow>::Combine(base, std::move(p), emoji__val, arrow__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_emoji, const S<P> &emoji__val, lngtag_arrow, const S<P> &arrow__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_arrow>::Current(base, std::move(p), emoji__val, arrow__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_recipient> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_recipient, rpl::producer<S<P>> recipient__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_recipient>::Combine(base, std::move(p), name__val, recipient__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_recipient, const S<P> &recipient__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_recipient>::Current(base, std::move(p), name__val, recipient__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_recipient, lngtag_price> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_recipient, rpl::producer<S<P>> recipient__val, lngtag_price, rpl::producer<S<P>> price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_recipient, lngtag_price>::Combine(base, std::move(p), name__val, recipient__val, price__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_recipient, const S<P> &recipient__val, lngtag_price, const S<P> &price__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_recipient, lngtag_price>::Current(base, std::move(p), name__val, recipient__val, price__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_user, lngtag_cost> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_user, rpl::producer<S<P>> user__val, lngtag_cost, rpl::producer<S<P>> cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_user, lngtag_cost>::Combine(base, std::move(p), name__val, user__val, cost__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_user, const S<P> &user__val, lngtag_cost, const S<P> &cost__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_user, lngtag_cost>::Current(base, std::move(p), name__val, user__val, cost__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_percent, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_percent, rpl::producer<S<P>> percent__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_percent, lngtag_name>::Combine(base, std::move(p), percent__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_percent, const S<P> &percent__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_percent, lngtag_name>::Current(base, std::move(p), percent__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_cost, lngtag_user, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_cost, rpl::producer<S<P>> cost__val, lngtag_user, rpl::producer<S<P>> user__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_cost, lngtag_user, lngtag_name>::Combine(base, std::move(p), cost__val, user__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_cost, const S<P> &cost__val, lngtag_user, const S<P> &user__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_cost, lngtag_user, lngtag_name>::Current(base, std::move(p), cost__val, user__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_rounds, lngtag_bidders> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_rounds, rpl::producer<S<P>> rounds__val, lngtag_bidders, rpl::producer<S<P>> bidders__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_rounds, lngtag_bidders>::Combine(base, std::move(p), type, count__val, rounds__val, bidders__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_rounds, const S<P> &rounds__val, lngtag_bidders, const S<P> &bidders__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_rounds, lngtag_bidders>::Current(base, std::move(p), type, count__val, rounds__val, bidders__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_bidders, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_bidders, rpl::producer<S<P>> bidders__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_bidders, lngtag_link>::Combine(base, std::move(p), type, count__val, bidders__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_bidders, const S<P> &bidders__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_bidders, lngtag_link>::Current(base, std::move(p), type, count__val, bidders__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_name, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_name, rpl::producer<S<P>> name__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_name, lngtag_link>::Combine(base, std::move(p), type, count__val, name__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_name, const S<P> &name__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_name, lngtag_link>::Current(base, std::move(p), type, count__val, name__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_n> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_n, rpl::producer<S<P>> n__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_n>::Combine(base, std::move(p), n__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_n, const S<P> &n__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_n>::Current(base, std::move(p), n__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_n, lngtag_last> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_n, rpl::producer<S<P>> n__val, lngtag_last, rpl::producer<S<P>> last__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_n, lngtag_last>::Combine(base, std::move(p), n__val, last__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_n, const S<P> &n__val, lngtag_last, const S<P> &last__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_n, lngtag_last>::Current(base, std::move(p), n__val, last__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_duration, lngtag_increase, lngtag_n> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_duration, rpl::producer<S<P>> duration__val, lngtag_increase, rpl::producer<S<P>> increase__val, lngtag_n, rpl::producer<S<P>> n__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_duration, lngtag_increase, lngtag_n>::Combine(base, std::move(p), duration__val, increase__val, n__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_duration, const S<P> &duration__val, lngtag_increase, const S<P> &increase__val, lngtag_n, const S<P> &n__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_duration, lngtag_increase, lngtag_n>::Current(base, std::move(p), duration__val, increase__val, n__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_n, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_n, rpl::producer<S<P>> n__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_n, lngtag_amount>::Combine(base, std::move(p), n__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_n, const S<P> &n__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_n, lngtag_amount>::Current(base, std::move(p), n__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_emoji, lngtag_arrow> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_arrow, rpl::producer<S<P>> arrow__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_emoji, lngtag_arrow>::Combine(base, std::move(p), type, count__val, emoji__val, arrow__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_emoji, const S<P> &emoji__val, lngtag_arrow, const S<P> &arrow__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_emoji, lngtag_arrow>::Current(base, std::move(p), type, count__val, emoji__val, arrow__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_stars> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_stars, rpl::producer<S<P>> stars__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_stars>::Combine(base, std::move(p), stars__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_stars, const S<P> &stars__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_stars>::Current(base, std::move(p), stars__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_stars, lngtag_n> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_stars, rpl::producer<S<P>> stars__val, lngtag_n, rpl::producer<S<P>> n__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_stars, lngtag_n>::Combine(base, std::move(p), stars__val, n__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_stars, const S<P> &stars__val, lngtag_n, const S<P> &n__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_stars, lngtag_n>::Current(base, std::move(p), stars__val, n__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_n> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_n, rpl::producer<S<P>> n__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_n>::Combine(base, std::move(p), name__val, n__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_n, const S<P> &n__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_n>::Current(base, std::move(p), name__val, n__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_inline_bot> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_inline_bot, rpl::producer<S<P>> inline_bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_inline_bot>::Combine(base, std::move(p), inline_bot__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_inline_bot, const S<P> &inline_bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_inline_bot>::Current(base, std::move(p), inline_bot__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_sticker_pack> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_sticker_pack, rpl::producer<S<P>> sticker_pack__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_sticker_pack>::Combine(base, std::move(p), sticker_pack__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_sticker_pack, const S<P> &sticker_pack__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_sticker_pack>::Current(base, std::move(p), sticker_pack__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_phone, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_phone, rpl::producer<S<P>> phone__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_phone, lngtag_user>::Combine(base, std::move(p), phone__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_phone, const S<P> &phone__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_phone, lngtag_user>::Current(base, std::move(p), phone__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_name>::Combine(base, std::move(p), user__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_name>::Current(base, std::move(p), user__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_emoji, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_link>::Combine(base, std::move(p), emoji__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_emoji, const S<P> &emoji__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_emoji, lngtag_link>::Current(base, std::move(p), emoji__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_date>::Combine(base, std::move(p), name__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_date>::Current(base, std::move(p), name__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_types> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_types, rpl::producer<S<P>> types__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_types>::Combine(base, std::move(p), types__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_types, const S<P> &types__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_types>::Current(base, std::move(p), types__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_types, lngtag_last> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_types, rpl::producer<S<P>> types__val, lngtag_last, rpl::producer<S<P>> last__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_types, lngtag_last>::Combine(base, std::move(p), types__val, last__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_types, const S<P> &types__val, lngtag_last, const S<P> &last__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_types, lngtag_last>::Current(base, std::move(p), types__val, last__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_accumulated, lngtag_chat> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_accumulated, rpl::producer<S<P>> accumulated__val, lngtag_chat, rpl::producer<S<P>> chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_accumulated, lngtag_chat>::Combine(base, std::move(p), accumulated__val, chat__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_accumulated, const S<P> &accumulated__val, lngtag_chat, const S<P> &chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_accumulated, lngtag_chat>::Current(base, std::move(p), accumulated__val, chat__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_chats> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_chats, rpl::producer<S<P>> chats__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_chats>::Combine(base, std::move(p), type, count__val, chats__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_chats, const S<P> &chats__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_chats>::Current(base, std::move(p), type, count__val, chats__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from_part, lngtag_message> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from_part, rpl::producer<S<P>> from_part__val, lngtag_message, rpl::producer<S<P>> message__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from_part, lngtag_message>::Combine(base, std::move(p), from_part__val, message__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from_part, const S<P> &from_part__val, lngtag_message, const S<P> &message__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from_part, lngtag_message>::Current(base, std::move(p), from_part__val, message__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_media_part, lngtag_caption> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_media_part, rpl::producer<S<P>> media_part__val, lngtag_caption, rpl::producer<S<P>> caption__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_media_part, lngtag_caption>::Combine(base, std::move(p), media_part__val, caption__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_media_part, const S<P> &media_part__val, lngtag_caption, const S<P> &caption__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_media_part, lngtag_caption>::Current(base, std::move(p), media_part__val, caption__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_media> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_media, rpl::producer<S<P>> media__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_media>::Combine(base, std::move(p), media__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_media, const S<P> &media__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_media>::Current(base, std::move(p), media__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_topic> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_topic, rpl::producer<S<P>> topic__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_topic>::Combine(base, std::move(p), from__val, topic__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_topic, const S<P> &topic__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_topic>::Current(base, std::move(p), from__val, topic__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_emoji, lngtag_channels> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_channels, rpl::producer<S<P>> channels__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_emoji, lngtag_channels>::Combine(base, std::move(p), type, count__val, emoji__val, channels__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_emoji, const S<P> &emoji__val, lngtag_channels, const S<P> &channels__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_emoji, lngtag_channels>::Current(base, std::move(p), type, count__val, emoji__val, channels__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_country> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_country, rpl::producer<S<P>> country__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_country>::Combine(base, std::move(p), from__val, country__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_country, const S<P> &country__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_country>::Current(base, std::move(p), from__val, country__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_country> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_country, rpl::producer<S<P>> country__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_country>::Combine(base, std::move(p), type, count__val, country__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_country, const S<P> &country__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_country>::Current(base, std::move(p), type, count__val, country__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_bot_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_bot_name, rpl::producer<S<P>> bot_name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot_name>::Combine(base, std::move(p), bot_name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_bot_name, const S<P> &bot_name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot_name>::Current(base, std::move(p), bot_name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_domain, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_domain, rpl::producer<S<P>> domain__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_domain, lngtag_user>::Combine(base, std::move(p), domain__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_domain, const S<P> &domain__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_domain, lngtag_user>::Current(base, std::move(p), domain__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_domain, lngtag_phone> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_domain, rpl::producer<S<P>> domain__val, lngtag_phone, rpl::producer<S<P>> phone__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_domain, lngtag_phone>::Combine(base, std::move(p), domain__val, phone__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_domain, const S<P> &domain__val, lngtag_phone, const S<P> &phone__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_domain, lngtag_phone>::Current(base, std::move(p), domain__val, phone__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_bot, lngtag_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_bot, rpl::producer<S<P>> bot__val, lngtag_name, rpl::producer<S<P>> name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot, lngtag_name>::Combine(base, std::move(p), bot__val, name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_bot, const S<P> &bot__val, lngtag_name, const S<P> &name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot, lngtag_name>::Current(base, std::move(p), bot__val, name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_retry> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_retry, rpl::producer<S<P>> retry__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_retry>::Combine(base, std::move(p), retry__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_retry, const S<P> &retry__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_retry>::Current(base, std::move(p), retry__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_ready, lngtag_total, lngtag_mb> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_ready, rpl::producer<S<P>> ready__val, lngtag_total, rpl::producer<S<P>> total__val, lngtag_mb, rpl::producer<S<P>> mb__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_ready, lngtag_total, lngtag_mb>::Combine(base, std::move(p), ready__val, total__val, mb__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_ready, const S<P> &ready__val, lngtag_total, const S<P> &total__val, lngtag_mb, const S<P> &mb__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_ready, lngtag_total, lngtag_mb>::Current(base, std::move(p), ready__val, total__val, mb__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_duration, lngtag_size> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_duration, rpl::producer<S<P>> duration__val, lngtag_size, rpl::producer<S<P>> size__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_duration, lngtag_size>::Combine(base, std::move(p), duration__val, size__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_duration, const S<P> &duration__val, lngtag_size, const S<P> &size__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_duration, lngtag_size>::Current(base, std::move(p), duration__val, size__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_played, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_played, rpl::producer<S<P>> played__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_played, lngtag_duration>::Combine(base, std::move(p), played__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_played, const S<P> &played__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_played, lngtag_duration>::Current(base, std::move(p), played__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_date, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_date, rpl::producer<S<P>> date__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date, lngtag_duration>::Combine(base, std::move(p), date__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_date, const S<P> &date__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_date, lngtag_duration>::Current(base, std::move(p), date__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_amount>::Combine(base, std::move(p), name__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_amount>::Current(base, std::move(p), name__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_language> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_language, rpl::producer<S<P>> language__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_language>::Combine(base, std::move(p), language__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_language, const S<P> &language__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_language>::Current(base, std::move(p), language__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_mention> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_mention, rpl::producer<S<P>> mention__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_mention>::Combine(base, std::move(p), mention__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_mention, const S<P> &mention__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_mention>::Current(base, std::move(p), mention__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_recipient> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_recipient, rpl::producer<S<P>> recipient__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_recipient>::Combine(base, std::move(p), recipient__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_recipient, const S<P> &recipient__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_recipient>::Current(base, std::move(p), recipient__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_percent> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_percent, rpl::producer<S<P>> percent__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_percent>::Combine(base, std::move(p), type, count__val, percent__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_percent, const S<P> &percent__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_percent>::Current(base, std::move(p), type, count__val, percent__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_channel, lngtag_percent, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_percent, rpl::producer<S<P>> percent__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel, lngtag_percent, lngtag_date>::Combine(base, std::move(p), type, count__val, channel__val, percent__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_channel, const S<P> &channel__val, lngtag_percent, const S<P> &percent__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel, lngtag_percent, lngtag_date>::Current(base, std::move(p), type, count__val, channel__val, percent__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_channel, lngtag_percent> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_channel, rpl::producer<S<P>> channel__val, lngtag_percent, rpl::producer<S<P>> percent__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel, lngtag_percent>::Combine(base, std::move(p), type, count__val, channel__val, percent__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_channel, const S<P> &channel__val, lngtag_percent, const S<P> &percent__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_channel, lngtag_percent>::Current(base, std::move(p), type, count__val, channel__val, percent__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_chat> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_chat, rpl::producer<S<P>> chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_chat>::Combine(base, std::move(p), chat__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_chat, const S<P> &chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_chat>::Current(base, std::move(p), chat__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_api_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_api_link, rpl::producer<S<P>> api_link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_api_link>::Combine(base, std::move(p), api_link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_api_link, const S<P> &api_link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_api_link>::Current(base, std::move(p), api_link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_gpl_link, lngtag_github_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_gpl_link, rpl::producer<S<P>> gpl_link__val, lngtag_github_link, rpl::producer<S<P>> github_link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_gpl_link, lngtag_github_link>::Combine(base, std::move(p), gpl_link__val, github_link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_gpl_link, const S<P> &gpl_link__val, lngtag_github_link, const S<P> &github_link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_gpl_link, lngtag_github_link>::Current(base, std::move(p), gpl_link__val, github_link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_faq_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_faq_link, rpl::producer<S<P>> faq_link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_faq_link>::Combine(base, std::move(p), faq_link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_faq_link, const S<P> &faq_link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_faq_link>::Current(base, std::move(p), faq_link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_file, lngtag_n, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_file, rpl::producer<S<P>> file__val, lngtag_n, rpl::producer<S<P>> n__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_file, lngtag_n, lngtag_amount>::Combine(base, std::move(p), file__val, n__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_file, const S<P> &file__val, lngtag_n, const S<P> &n__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_file, lngtag_n, lngtag_amount>::Current(base, std::move(p), file__val, n__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_downloads> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_downloads, rpl::producer<S<P>> downloads__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_downloads>::Combine(base, std::move(p), downloads__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_downloads, const S<P> &downloads__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_downloads>::Current(base, std::move(p), downloads__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_speed> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_speed, rpl::producer<S<P>> speed__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_speed>::Combine(base, std::move(p), speed__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_speed, const S<P> &speed__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_speed>::Current(base, std::move(p), speed__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_version, lngtag_changes, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_version, rpl::producer<S<P>> version__val, lngtag_changes, rpl::producer<S<P>> changes__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_version, lngtag_changes, lngtag_link>::Combine(base, std::move(p), version__val, changes__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_version, const S<P> &version__val, lngtag_changes, const S<P> &changes__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_version, lngtag_changes, lngtag_link>::Current(base, std::move(p), version__val, changes__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_first_name, lngtag_last_name> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_first_name, rpl::producer<S<P>> first_name__val, lngtag_last_name, rpl::producer<S<P>> last_name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_first_name, lngtag_last_name>::Combine(base, std::move(p), first_name__val, last_name__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_first_name, const S<P> &first_name__val, lngtag_last_name, const S<P> &last_name__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_first_name, lngtag_last_name>::Current(base, std::move(p), first_name__val, last_name__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_amount, lngtag_title> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_amount, rpl::producer<S<P>> amount__val, lngtag_title, rpl::producer<S<P>> title__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_title>::Combine(base, std::move(p), amount__val, title__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_amount, const S<P> &amount__val, lngtag_title, const S<P> &title__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_title>::Current(base, std::move(p), amount__val, title__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_provider> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_provider, rpl::producer<S<P>> provider__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_provider>::Combine(base, std::move(p), provider__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_provider, const S<P> &provider__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_provider>::Current(base, std::move(p), provider__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_bot1, lngtag_provider, lngtag_bot2, lngtag_bot3> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_bot1, rpl::producer<S<P>> bot1__val, lngtag_provider, rpl::producer<S<P>> provider__val, lngtag_bot2, rpl::producer<S<P>> bot2__val, lngtag_bot3, rpl::producer<S<P>> bot3__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot1, lngtag_provider, lngtag_bot2, lngtag_bot3>::Combine(base, std::move(p), bot1__val, provider__val, bot2__val, bot3__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_bot1, const S<P> &bot1__val, lngtag_provider, const S<P> &provider__val, lngtag_bot2, const S<P> &bot2__val, lngtag_bot3, const S<P> &bot3__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot1, lngtag_provider, lngtag_bot2, lngtag_bot3>::Current(base, std::move(p), bot1__val, provider__val, bot2__val, bot3__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_card> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_card, rpl::producer<S<P>> card__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_card>::Combine(base, std::move(p), card__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_card, const S<P> &card__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_card>::Current(base, std::move(p), card__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_amount, lngtag_status> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_amount, rpl::producer<S<P>> amount__val, lngtag_status, rpl::producer<S<P>> status__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_status>::Combine(base, std::move(p), amount__val, status__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_amount, const S<P> &amount__val, lngtag_status, const S<P> &status__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_amount, lngtag_status>::Current(base, std::move(p), amount__val, status__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_time, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_time, rpl::producer<S<P>> time__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_time, lngtag_duration>::Combine(base, std::move(p), time__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_time, const S<P> &time__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_time, lngtag_duration>::Current(base, std::move(p), time__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_type, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_type, rpl::producer<S<P>> type__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_type, lngtag_duration>::Combine(base, std::move(p), type__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_type, const S<P> &type__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_type, lngtag_duration>::Current(base, std::move(p), type__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_delay> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_delay, rpl::producer<S<P>> delay__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_delay>::Combine(base, std::move(p), delay__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_delay, const S<P> &delay__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_delay>::Current(base, std::move(p), delay__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_other> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_other, rpl::producer<S<P>> other__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_other>::Combine(base, std::move(p), user__val, other__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_other, const S<P> &other__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_other>::Current(base, std::move(p), user__val, other__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_other, lngtag_third> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_other, rpl::producer<S<P>> other__val, lngtag_third, rpl::producer<S<P>> third__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_other, lngtag_third>::Combine(base, std::move(p), user__val, other__val, third__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_other, const S<P> &other__val, lngtag_third, const S<P> &third__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_other, lngtag_third>::Current(base, std::move(p), user__val, other__val, third__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_user, lngtag_other> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_user, rpl::producer<S<P>> user__val, lngtag_other, rpl::producer<S<P>> other__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_user, lngtag_other>::Combine(base, std::move(p), type, count__val, user__val, other__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_user, const S<P> &user__val, lngtag_other, const S<P> &other__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_user, lngtag_other>::Current(base, std::move(p), type, count__val, user__val, other__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_date>::Combine(base, std::move(p), user__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_date>::Current(base, std::move(p), user__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_interval> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_interval, rpl::producer<S<P>> interval__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_interval>::Combine(base, std::move(p), interval__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_interval, const S<P> &interval__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_interval>::Current(base, std::move(p), interval__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_group, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_group, rpl::producer<S<P>> group__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_group, lngtag_user>::Combine(base, std::move(p), group__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_group, const S<P> &group__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_group, lngtag_user>::Current(base, std::move(p), group__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_amount> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_amount, rpl::producer<S<P>> amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_amount>::Combine(base, std::move(p), user__val, amount__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_amount, const S<P> &amount__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_amount>::Current(base, std::move(p), user__val, amount__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_query> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_query, rpl::producer<S<P>> query__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_query>::Combine(base, std::move(p), query__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_query, const S<P> &query__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_query>::Current(base, std::move(p), query__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_link, lngtag_user> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_link, rpl::producer<S<P>> link__val, lngtag_user, rpl::producer<S<P>> user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_link, lngtag_user>::Combine(base, std::move(p), from__val, link__val, user__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_link, const S<P> &link__val, lngtag_user, const S<P> &user__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_link, lngtag_user>::Current(base, std::move(p), from__val, link__val, user__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_user, lngtag_until> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_user, rpl::producer<S<P>> user__val, lngtag_until, rpl::producer<S<P>> until__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_until>::Combine(base, std::move(p), user__val, until__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_user, const S<P> &user__val, lngtag_until, const S<P> &until__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_user, lngtag_until>::Current(base, std::move(p), user__val, until__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_sticker_set> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_sticker_set, rpl::producer<S<P>> sticker_set__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_sticker_set>::Combine(base, std::move(p), from__val, sticker_set__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_sticker_set, const S<P> &sticker_set__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_sticker_set>::Current(base, std::move(p), from__val, sticker_set__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_chat> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_chat, rpl::producer<S<P>> chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_chat>::Combine(base, std::move(p), from__val, chat__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_chat, const S<P> &chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_chat>::Current(base, std::move(p), from__val, chat__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_address> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_address, rpl::producer<S<P>> address__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_address>::Combine(base, std::move(p), from__val, address__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_address, const S<P> &address__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_address>::Current(base, std::move(p), from__val, address__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_user, lngtag_percent> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_user, rpl::producer<S<P>> user__val, lngtag_percent, rpl::producer<S<P>> percent__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_user, lngtag_percent>::Combine(base, std::move(p), from__val, user__val, percent__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_user, const S<P> &user__val, lngtag_percent, const S<P> &percent__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_user, lngtag_percent>::Current(base, std::move(p), from__val, user__val, percent__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_previous, lngtag_color> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_previous, rpl::producer<S<P>> previous__val, lngtag_color, rpl::producer<S<P>> color__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_previous, lngtag_color>::Combine(base, std::move(p), from__val, previous__val, color__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_previous, const S<P> &previous__val, lngtag_color, const S<P> &color__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_previous, lngtag_color>::Current(base, std::move(p), from__val, previous__val, color__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_previous, lngtag_emoji> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_previous, rpl::producer<S<P>> previous__val, lngtag_emoji, rpl::producer<S<P>> emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_previous, lngtag_emoji>::Combine(base, std::move(p), from__val, previous__val, emoji__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_previous, const S<P> &previous__val, lngtag_emoji, const S<P> &emoji__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_previous, lngtag_emoji>::Current(base, std::move(p), from__val, previous__val, emoji__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_emoji, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_emoji, lngtag_date>::Combine(base, std::move(p), from__val, emoji__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_emoji, const S<P> &emoji__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_emoji, lngtag_date>::Current(base, std::move(p), from__val, emoji__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_previous, lngtag_emoji, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_previous, rpl::producer<S<P>> previous__val, lngtag_emoji, rpl::producer<S<P>> emoji__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_previous, lngtag_emoji, lngtag_date>::Combine(base, std::move(p), from__val, previous__val, emoji__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_previous, const S<P> &previous__val, lngtag_emoji, const S<P> &emoji__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_previous, lngtag_emoji, lngtag_date>::Current(base, std::move(p), from__val, previous__val, emoji__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_name, lngtag_mention> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_name, rpl::producer<S<P>> name__val, lngtag_mention, rpl::producer<S<P>> mention__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_mention>::Combine(base, std::move(p), name__val, mention__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_name, const S<P> &name__val, lngtag_mention, const S<P> &mention__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_name, lngtag_mention>::Current(base, std::move(p), name__val, mention__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_previous, lngtag_duration> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_previous, rpl::producer<S<P>> previous__val, lngtag_duration, rpl::producer<S<P>> duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_previous, lngtag_duration>::Combine(base, std::move(p), from__val, previous__val, duration__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_previous, const S<P> &previous__val, lngtag_duration, const S<P> &duration__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_previous, lngtag_duration>::Current(base, std::move(p), from__val, previous__val, duration__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_previous, lngtag_limit> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_previous, rpl::producer<S<P>> previous__val, lngtag_limit, rpl::producer<S<P>> limit__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_previous, lngtag_limit>::Combine(base, std::move(p), previous__val, limit__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_previous, const S<P> &previous__val, lngtag_limit, const S<P> &limit__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_previous, lngtag_limit>::Current(base, std::move(p), previous__val, limit__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_topic, lngtag_new_topic> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_topic, rpl::producer<S<P>> topic__val, lngtag_new_topic, rpl::producer<S<P>> new_topic__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_topic, lngtag_new_topic>::Combine(base, std::move(p), from__val, topic__val, new_topic__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_topic, const S<P> &topic__val, lngtag_new_topic, const S<P> &new_topic__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_topic, lngtag_new_topic>::Current(base, std::move(p), from__val, topic__val, new_topic__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_document, lngtag_second_document> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_document, rpl::producer<S<P>> document__val, lngtag_second_document, rpl::producer<S<P>> second_document__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_document, lngtag_second_document>::Combine(base, std::move(p), document__val, second_document__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_document, const S<P> &document__val, lngtag_second_document, const S<P> &second_document__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_document, lngtag_second_document>::Current(base, std::move(p), document__val, second_document__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_policy, lngtag_bot> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_policy, rpl::producer<S<P>> policy__val, lngtag_bot, rpl::producer<S<P>> bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_policy, lngtag_bot>::Combine(base, std::move(p), policy__val, bot__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_policy, const S<P> &policy__val, lngtag_bot, const S<P> &bot__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_policy, lngtag_bot>::Current(base, std::move(p), policy__val, bot__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_existing> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_existing, rpl::producer<S<P>> existing__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_existing>::Combine(base, std::move(p), existing__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_existing, const S<P> &existing__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_existing>::Current(base, std::move(p), existing__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_path> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_path, rpl::producer<S<P>> path__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_path>::Combine(base, std::move(p), path__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_path, const S<P> &path__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_path>::Current(base, std::move(p), path__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_format, lngtag_path> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_format, rpl::producer<S<P>> format__val, lngtag_path, rpl::producer<S<P>> path__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_format, lngtag_path>::Combine(base, std::move(p), format__val, path__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_format, const S<P> &format__val, lngtag_path, const S<P> &path__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_format, lngtag_path>::Current(base, std::move(p), format__val, path__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_from, lngtag_till> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_from, rpl::producer<S<P>> from__val, lngtag_till, rpl::producer<S<P>> till__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_till>::Combine(base, std::move(p), from__val, till__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_from, const S<P> &from__val, lngtag_till, const S<P> &till__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_from, lngtag_till>::Current(base, std::move(p), from__val, till__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_hours, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_hours, rpl::producer<S<P>> hours__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_hours, lngtag_date>::Combine(base, std::move(p), hours__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_hours, const S<P> &hours__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_hours, lngtag_date>::Current(base, std::move(p), hours__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_lang_name, lngtag_percent, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_lang_name, rpl::producer<S<P>> lang_name__val, lngtag_percent, rpl::producer<S<P>> percent__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_lang_name, lngtag_percent, lngtag_link>::Combine(base, std::move(p), lang_name__val, percent__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_lang_name, const S<P> &lang_name__val, lngtag_percent, const S<P> &percent__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_lang_name, lngtag_percent, lngtag_link>::Current(base, std::move(p), lang_name__val, percent__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_lang_name, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_lang_name, rpl::producer<S<P>> lang_name__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_lang_name, lngtag_link>::Combine(base, std::move(p), lang_name__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_lang_name, const S<P> &lang_name__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_lang_name, lngtag_link>::Current(base, std::move(p), lang_name__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_extension> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_extension, rpl::producer<S<P>> extension__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_extension>::Combine(base, std::move(p), extension__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_extension, const S<P> &extension__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_extension>::Current(base, std::move(p), extension__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_count, lngtag_total> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_count type, rpl::producer<float64> count__val, lngtag_total, rpl::producer<S<P>> total__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_total>::Combine(base, std::move(p), type, count__val, total__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_count type, float64 count__val, lngtag_total, const S<P> &total__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_count, lngtag_total>::Current(base, std::move(p), type, count__val, total__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_chat, lngtag_folder> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_chat, rpl::producer<S<P>> chat__val, lngtag_folder, rpl::producer<S<P>> folder__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_chat, lngtag_folder>::Combine(base, std::move(p), chat__val, folder__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_chat, const S<P> &chat__val, lngtag_folder, const S<P> &folder__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_chat, lngtag_folder>::Current(base, std::move(p), chat__val, folder__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_folder> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_folder, rpl::producer<S<P>> folder__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_folder>::Combine(base, std::move(p), folder__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_folder, const S<P> &folder__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_folder>::Current(base, std::move(p), folder__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_rights> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_rights, rpl::producer<S<P>> rights__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_rights>::Combine(base, std::move(p), rights__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_rights, const S<P> &rights__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_rights>::Current(base, std::move(p), rights__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_rights, lngtag_last> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_rights, rpl::producer<S<P>> rights__val, lngtag_last, rpl::producer<S<P>> last__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_rights, lngtag_last>::Combine(base, std::move(p), rights__val, last__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_rights, const S<P> &rights__val, lngtag_last, const S<P> &last__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_rights, lngtag_last>::Current(base, std::move(p), rights__val, last__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_bot, lngtag_chat> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_bot, rpl::producer<S<P>> bot__val, lngtag_chat, rpl::producer<S<P>> chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot, lngtag_chat>::Combine(base, std::move(p), bot__val, chat__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_bot, const S<P> &bot__val, lngtag_chat, const S<P> &chat__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot, lngtag_chat>::Current(base, std::move(p), bot__val, chat__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_bot, lngtag_chat, lngtag_rights> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_bot, rpl::producer<S<P>> bot__val, lngtag_chat, rpl::producer<S<P>> chat__val, lngtag_rights, rpl::producer<S<P>> rights__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot, lngtag_chat, lngtag_rights>::Combine(base, std::move(p), bot__val, chat__val, rights__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_bot, const S<P> &bot__val, lngtag_chat, const S<P> &chat__val, lngtag_rights, const S<P> &rights__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot, lngtag_chat, lngtag_rights>::Current(base, std::move(p), bot__val, chat__val, rights__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_days_count, lngtag_month, lngtag_year> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_days_count, rpl::producer<S<P>> days_count__val, lngtag_month, rpl::producer<S<P>> month__val, lngtag_year, rpl::producer<S<P>> year__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_days_count, lngtag_month, lngtag_year>::Combine(base, std::move(p), days_count__val, month__val, year__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_days_count, const S<P> &days_count__val, lngtag_month, const S<P> &month__val, lngtag_year, const S<P> &year__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_days_count, lngtag_month, lngtag_year>::Current(base, std::move(p), days_count__val, month__val, year__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_days_count, lngtag_month> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_days_count, rpl::producer<S<P>> days_count__val, lngtag_month, rpl::producer<S<P>> month__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_days_count, lngtag_month>::Combine(base, std::move(p), days_count__val, month__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_days_count, const S<P> &days_count__val, lngtag_month, const S<P> &month__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_days_count, lngtag_month>::Current(base, std::move(p), days_count__val, month__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_day, lngtag_days_count, lngtag_month, lngtag_year> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_day, rpl::producer<S<P>> day__val, lngtag_days_count, rpl::producer<S<P>> days_count__val, lngtag_month, rpl::producer<S<P>> month__val, lngtag_year, rpl::producer<S<P>> year__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_day, lngtag_days_count, lngtag_month, lngtag_year>::Combine(base, std::move(p), day__val, days_count__val, month__val, year__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_day, const S<P> &day__val, lngtag_days_count, const S<P> &days_count__val, lngtag_month, const S<P> &month__val, lngtag_year, const S<P> &year__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_day, lngtag_days_count, lngtag_month, lngtag_year>::Current(base, std::move(p), day__val, days_count__val, month__val, year__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_day, lngtag_days_count, lngtag_month, lngtag_time> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_day, rpl::producer<S<P>> day__val, lngtag_days_count, rpl::producer<S<P>> days_count__val, lngtag_month, rpl::producer<S<P>> month__val, lngtag_time, rpl::producer<S<P>> time__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_day, lngtag_days_count, lngtag_month, lngtag_time>::Combine(base, std::move(p), day__val, days_count__val, month__val, time__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_day, const S<P> &day__val, lngtag_days_count, const S<P> &days_count__val, lngtag_month, const S<P> &month__val, lngtag_time, const S<P> &time__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_day, lngtag_days_count, lngtag_month, lngtag_time>::Current(base, std::move(p), day__val, days_count__val, month__val, time__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_link, lngtag_increase> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_link, rpl::producer<S<P>> link__val, lngtag_increase, rpl::producer<S<P>> increase__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_link, lngtag_increase>::Combine(base, std::move(p), link__val, increase__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_link, const S<P> &link__val, lngtag_increase, const S<P> &increase__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_link, lngtag_increase>::Current(base, std::move(p), link__val, increase__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_bot, lngtag_link> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_bot, rpl::producer<S<P>> bot__val, lngtag_link, rpl::producer<S<P>> link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot, lngtag_link>::Combine(base, std::move(p), bot__val, link__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_bot, const S<P> &bot__val, lngtag_link, const S<P> &link__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_bot, lngtag_link>::Current(base, std::move(p), bot__val, link__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_link, lngtag_date> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_link, rpl::producer<S<P>> link__val, lngtag_date, rpl::producer<S<P>> date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_link, lngtag_date>::Combine(base, std::move(p), link__val, date__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_link, const S<P> &link__val, lngtag_date, const S<P> &date__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_link, lngtag_date>::Current(base, std::move(p), link__val, date__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_file> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_file, rpl::producer<S<P>> file__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_file>::Combine(base, std::move(p), file__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_file, const S<P> &file__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_file>::Current(base, std::move(p), file__val);
	}

	ushort base;
};

template <>
struct phrase<lngtag_telegram> {
	template <typename P = details::Identity>
	rpl::producer<S<P>> operator()(lngtag_telegram, rpl::producer<S<P>> telegram__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_telegram>::Combine(base, std::move(p), telegram__val);
	}

	template <typename P = details::Identity>
	S<P> operator()(now_t, lngtag_telegram, const S<P> &telegram__val, P p = P()) const {
		return ::Lang::details::Producer<lngtag_telegram>::Current(base, std::move(p), telegram__val);
	}

	ushort base;
};

inline constexpr phrase<> lng_language_name{ ushort(0) };
inline constexpr phrase<> lng_switch_to_this{ ushort(1) };
inline constexpr phrase<> lng_menu_contacts{ ushort(2) };
inline constexpr phrase<> lng_menu_calls{ ushort(3) };
inline constexpr phrase<> lng_menu_settings{ ushort(4) };
inline constexpr phrase<> lng_menu_about{ ushort(5) };
inline constexpr phrase<> lng_menu_update{ ushort(6) };
inline constexpr phrase<> lng_menu_night_mode{ ushort(7) };
inline constexpr phrase<> lng_menu_add_account{ ushort(8) };
inline constexpr phrase<> lng_menu_activate{ ushort(9) };
inline constexpr phrase<> lng_menu_set_status{ ushort(10) };
inline constexpr phrase<> lng_menu_change_status{ ushort(11) };
inline constexpr phrase<> lng_menu_my_profile{ ushort(12) };
inline constexpr phrase<> lng_menu_my_stories{ ushort(13) };
inline constexpr phrase<> lng_menu_my_groups{ ushort(14) };
inline constexpr phrase<> lng_menu_my_channels{ ushort(15) };
inline constexpr phrase<> lng_main_menu{ ushort(16) };
inline constexpr phrase<lngtag_count, lngtag_text> lng_filter_unread_chats{ ushort(17) };
inline constexpr phrase<> lng_disable_notifications_from_tray{ ushort(23) };
inline constexpr phrase<> lng_enable_notifications_from_tray{ ushort(24) };
inline constexpr phrase<> lng_open_from_tray{ ushort(25) };
inline constexpr phrase<> lng_minimize_to_tray{ ushort(26) };
inline constexpr phrase<> lng_quit_from_tray{ ushort(27) };
inline constexpr phrase<> lng_tray_icon_text{ ushort(28) };
inline constexpr phrase<> lng_month1{ ushort(29) };
inline constexpr phrase<> lng_month2{ ushort(30) };
inline constexpr phrase<> lng_month3{ ushort(31) };
inline constexpr phrase<> lng_month4{ ushort(32) };
inline constexpr phrase<> lng_month5{ ushort(33) };
inline constexpr phrase<> lng_month6{ ushort(34) };
inline constexpr phrase<> lng_month7{ ushort(35) };
inline constexpr phrase<> lng_month8{ ushort(36) };
inline constexpr phrase<> lng_month9{ ushort(37) };
inline constexpr phrase<> lng_month10{ ushort(38) };
inline constexpr phrase<> lng_month11{ ushort(39) };
inline constexpr phrase<> lng_month12{ ushort(40) };
inline constexpr phrase<> lng_month_day1{ ushort(41) };
inline constexpr phrase<> lng_month_day2{ ushort(42) };
inline constexpr phrase<> lng_month_day3{ ushort(43) };
inline constexpr phrase<> lng_month_day4{ ushort(44) };
inline constexpr phrase<> lng_month_day5{ ushort(45) };
inline constexpr phrase<> lng_month_day6{ ushort(46) };
inline constexpr phrase<> lng_month_day7{ ushort(47) };
inline constexpr phrase<> lng_month_day8{ ushort(48) };
inline constexpr phrase<> lng_month_day9{ ushort(49) };
inline constexpr phrase<> lng_month_day10{ ushort(50) };
inline constexpr phrase<> lng_month_day11{ ushort(51) };
inline constexpr phrase<> lng_month_day12{ ushort(52) };
inline constexpr phrase<> lng_month1_small{ ushort(53) };
inline constexpr phrase<> lng_month2_small{ ushort(54) };
inline constexpr phrase<> lng_month3_small{ ushort(55) };
inline constexpr phrase<> lng_month4_small{ ushort(56) };
inline constexpr phrase<> lng_month5_small{ ushort(57) };
inline constexpr phrase<> lng_month6_small{ ushort(58) };
inline constexpr phrase<> lng_month7_small{ ushort(59) };
inline constexpr phrase<> lng_month8_small{ ushort(60) };
inline constexpr phrase<> lng_month9_small{ ushort(61) };
inline constexpr phrase<> lng_month10_small{ ushort(62) };
inline constexpr phrase<> lng_month11_small{ ushort(63) };
inline constexpr phrase<> lng_month12_small{ ushort(64) };
inline constexpr phrase<> lng_weekday1{ ushort(65) };
inline constexpr phrase<> lng_weekday2{ ushort(66) };
inline constexpr phrase<> lng_weekday3{ ushort(67) };
inline constexpr phrase<> lng_weekday4{ ushort(68) };
inline constexpr phrase<> lng_weekday5{ ushort(69) };
inline constexpr phrase<> lng_weekday6{ ushort(70) };
inline constexpr phrase<> lng_weekday7{ ushort(71) };
inline constexpr phrase<lngtag_month, lngtag_day> lng_month_day{ ushort(72) };
inline constexpr phrase<lngtag_month, lngtag_day, lngtag_year> lng_month_day_year{ ushort(73) };
inline constexpr phrase<lngtag_month, lngtag_year> lng_month_year{ ushort(74) };
inline constexpr phrase<> lng_calendar_select_days{ ushort(75) };
inline constexpr phrase<> lng_calendar_start_tip{ ushort(76) };
inline constexpr phrase<> lng_calendar_end_tip{ ushort(77) };
inline constexpr phrase<lngtag_count> lng_calendar_days{ ushort(78) };
inline constexpr phrase<lngtag_count> lng_seconds{ ushort(84) };
inline constexpr phrase<lngtag_count> lng_minutes{ ushort(90) };
inline constexpr phrase<lngtag_count> lng_hours{ ushort(96) };
inline constexpr phrase<lngtag_count> lng_days{ ushort(102) };
inline constexpr phrase<lngtag_count> lng_weeks{ ushort(108) };
inline constexpr phrase<lngtag_count> lng_months{ ushort(114) };
inline constexpr phrase<lngtag_count> lng_years{ ushort(120) };
inline constexpr phrase<lngtag_count> lng_seconds_tiny{ ushort(126) };
inline constexpr phrase<lngtag_count> lng_minutes_tiny{ ushort(132) };
inline constexpr phrase<lngtag_count> lng_hours_tiny{ ushort(138) };
inline constexpr phrase<lngtag_count> lng_days_tiny{ ushort(144) };
inline constexpr phrase<lngtag_count> lng_weeks_tiny{ ushort(150) };
inline constexpr phrase<lngtag_count> lng_months_tiny{ ushort(156) };
inline constexpr phrase<lngtag_count> lng_years_tiny{ ushort(162) };
inline constexpr phrase<> lng_box_ok{ ushort(168) };
inline constexpr phrase<> lng_box_done{ ushort(169) };
inline constexpr phrase<> lng_box_yes{ ushort(170) };
inline constexpr phrase<> lng_box_no{ ushort(171) };
inline constexpr phrase<> lng_cancel{ ushort(172) };
inline constexpr phrase<> lng_continue{ ushort(173) };
inline constexpr phrase<> lng_close{ ushort(174) };
inline constexpr phrase<> lng_minimize_window{ ushort(175) };
inline constexpr phrase<> lng_maximize_window{ ushort(176) };
inline constexpr phrase<> lng_restore_window{ ushort(177) };
inline constexpr phrase<> lng_go_back{ ushort(178) };
inline constexpr phrase<> lng_connecting{ ushort(179) };
inline constexpr phrase<lngtag_count> lng_reconnecting{ ushort(180) };
inline constexpr phrase<> lng_reconnecting_try_now{ ushort(186) };
inline constexpr phrase<> lng_code_block_header_copy{ ushort(187) };
inline constexpr phrase<> lng_status_service_notifications{ ushort(188) };
inline constexpr phrase<> lng_status_support{ ushort(189) };
inline constexpr phrase<> lng_status_bot{ ushort(190) };
inline constexpr phrase<> lng_status_bot_reads_all{ ushort(191) };
inline constexpr phrase<> lng_status_bot_not_reads_all{ ushort(192) };
inline constexpr phrase<> lng_status_offline{ ushort(193) };
inline constexpr phrase<> lng_status_recently{ ushort(194) };
inline constexpr phrase<> lng_status_last_week{ ushort(195) };
inline constexpr phrase<> lng_status_last_month{ ushort(196) };
inline constexpr phrase<> lng_status_lastseen_now{ ushort(197) };
inline constexpr phrase<> lng_status_lastseen_when{ ushort(198) };
inline constexpr phrase<lngtag_count> lng_status_lastseen_minutes{ ushort(199) };
inline constexpr phrase<lngtag_count> lng_status_lastseen_hours{ ushort(205) };
inline constexpr phrase<lngtag_time> lng_status_lastseen_today{ ushort(211) };
inline constexpr phrase<lngtag_time> lng_status_lastseen_yesterday{ ushort(212) };
inline constexpr phrase<lngtag_date> lng_status_lastseen_date{ ushort(213) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_status_lastseen_date_time{ ushort(214) };
inline constexpr phrase<> lng_status_online{ ushort(215) };
inline constexpr phrase<> lng_status_connecting{ ushort(216) };
inline constexpr phrase<> lng_chat_status_unaccessible{ ushort(217) };
inline constexpr phrase<lngtag_count> lng_chat_status_members{ ushort(218) };
inline constexpr phrase<lngtag_count> lng_chat_status_online{ ushort(224) };
inline constexpr phrase<lngtag_members_count, lngtag_online_count> lng_chat_status_members_online{ ushort(230) };
inline constexpr phrase<lngtag_count> lng_chat_status_subscribers{ ushort(231) };
inline constexpr phrase<> lng_chat_status_direct{ ushort(237) };
inline constexpr phrase<> lng_channel_status{ ushort(238) };
inline constexpr phrase<> lng_group_status{ ushort(239) };
inline constexpr phrase<> lng_scam_badge{ ushort(240) };
inline constexpr phrase<> lng_fake_badge{ ushort(241) };
inline constexpr phrase<> lng_direct_badge{ ushort(242) };
inline constexpr phrase<> lng_remember{ ushort(243) };
inline constexpr phrase<> lng_lastseen_show_title{ ushort(244) };
inline constexpr phrase<lngtag_user> lng_lastseen_show_about{ ushort(245) };
inline constexpr phrase<> lng_lastseen_show_button{ ushort(246) };
inline constexpr phrase<> lng_lastseen_or{ ushort(247) };
inline constexpr phrase<> lng_lastseen_premium_title{ ushort(248) };
inline constexpr phrase<lngtag_user> lng_lastseen_premium_about{ ushort(249) };
inline constexpr phrase<> lng_lastseen_premium_button{ ushort(250) };
inline constexpr phrase<> lng_lastseen_shown_toast{ ushort(251) };
inline constexpr phrase<> lng_readtime_show_title{ ushort(252) };
inline constexpr phrase<lngtag_user> lng_readtime_show_about{ ushort(253) };
inline constexpr phrase<> lng_readtime_show_button{ ushort(254) };
inline constexpr phrase<> lng_readtime_or{ ushort(255) };
inline constexpr phrase<> lng_readtime_premium_title{ ushort(256) };
inline constexpr phrase<lngtag_user> lng_readtime_premium_about{ ushort(257) };
inline constexpr phrase<> lng_readtime_premium_button{ ushort(258) };
inline constexpr phrase<> lng_readtime_shown_toast{ ushort(259) };
inline constexpr phrase<> lng_channels_limit_title{ ushort(260) };
inline constexpr phrase<lngtag_count> lng_channels_limit1{ ushort(261) };
inline constexpr phrase<lngtag_count> lng_channels_limit2{ ushort(267) };
inline constexpr phrase<> lng_channels_limit2_final{ ushort(273) };
inline constexpr phrase<> lng_channels_leave_title{ ushort(274) };
inline constexpr phrase<lngtag_type, lngtag_time> lng_channels_leave_status{ ushort(275) };
inline constexpr phrase<lngtag_count> lng_channels_leave{ ushort(276) };
inline constexpr phrase<> lng_channels_leave_done{ ushort(282) };
inline constexpr phrase<> lng_links_limit_title{ ushort(283) };
inline constexpr phrase<lngtag_count> lng_links_limit1{ ushort(284) };
inline constexpr phrase<lngtag_count> lng_links_limit2{ ushort(290) };
inline constexpr phrase<> lng_links_limit2_final{ ushort(296) };
inline constexpr phrase<> lng_links_revoke_title{ ushort(297) };
inline constexpr phrase<> lng_filter_chats_limit_title{ ushort(298) };
inline constexpr phrase<lngtag_count> lng_filter_chats_limit1{ ushort(299) };
inline constexpr phrase<lngtag_count> lng_filter_chats_exlude_limit1{ ushort(305) };
inline constexpr phrase<lngtag_count> lng_filter_chats_limit2{ ushort(311) };
inline constexpr phrase<> lng_filters_limit_title{ ushort(317) };
inline constexpr phrase<lngtag_count> lng_filters_limit1{ ushort(318) };
inline constexpr phrase<lngtag_count> lng_filters_limit2{ ushort(324) };
inline constexpr phrase<> lng_filter_pin_limit_title{ ushort(330) };
inline constexpr phrase<lngtag_count> lng_filter_pin_limit1{ ushort(331) };
inline constexpr phrase<lngtag_count> lng_filter_pin_limit2{ ushort(337) };
inline constexpr phrase<lngtag_count> lng_forum_pin_limit{ ushort(343) };
inline constexpr phrase<lngtag_count> lng_fave_sticker_limit_title{ ushort(349) };
inline constexpr phrase<lngtag_count, lngtag_link> lng_fave_sticker_limit_more{ ushort(355) };
inline constexpr phrase<> lng_fave_sticker_limit_link{ ushort(361) };
inline constexpr phrase<lngtag_count> lng_saved_gif_limit_title{ ushort(362) };
inline constexpr phrase<lngtag_count, lngtag_link> lng_saved_gif_limit_more{ ushort(368) };
inline constexpr phrase<> lng_saved_gif_limit_link{ ushort(374) };
inline constexpr phrase<> lng_caption_limit_title{ ushort(375) };
inline constexpr phrase<lngtag_count> lng_caption_limit1{ ushort(376) };
inline constexpr phrase<lngtag_count> lng_caption_limit2{ ushort(382) };
inline constexpr phrase<lngtag_count> lng_caption_limit_reached{ ushort(388) };
inline constexpr phrase<> lng_caption_move_up{ ushort(394) };
inline constexpr phrase<> lng_caption_move_down{ ushort(395) };
inline constexpr phrase<> lng_file_size_limit_title{ ushort(396) };
inline constexpr phrase<lngtag_count> lng_file_size_limit{ ushort(397) };
inline constexpr phrase<lngtag_size> lng_file_size_limit1{ ushort(403) };
inline constexpr phrase<lngtag_size> lng_file_size_limit2{ ushort(404) };
inline constexpr phrase<> lng_filter_links_limit_title{ ushort(405) };
inline constexpr phrase<lngtag_count> lng_filter_links_limit1{ ushort(406) };
inline constexpr phrase<lngtag_count> lng_filter_links_limit2{ ushort(412) };
inline constexpr phrase<> lng_filter_shared_limit_title{ ushort(418) };
inline constexpr phrase<lngtag_count> lng_filter_shared_limit1{ ushort(419) };
inline constexpr phrase<lngtag_count> lng_filter_shared_limit2{ ushort(425) };
inline constexpr phrase<> lng_limits_increase{ ushort(431) };
inline constexpr phrase<> lng_sticker_premium_text{ ushort(432) };
inline constexpr phrase<> lng_sticker_premium_view{ ushort(433) };
inline constexpr phrase<> lng_animated_emoji_text{ ushort(434) };
inline constexpr phrase<> lng_animated_emoji_saved{ ushort(435) };
inline constexpr phrase<> lng_animated_emoji_saved_open{ ushort(436) };
inline constexpr phrase<> lng_flood_error{ ushort(437) };
inline constexpr phrase<> lng_edit_error{ ushort(438) };
inline constexpr phrase<> lng_error_phone_flood{ ushort(439) };
inline constexpr phrase<> lng_error_start_minimized_passcoded{ ushort(440) };
inline constexpr phrase<lngtag_more_info> lng_error_public_groups_denied{ ushort(441) };
inline constexpr phrase<> lng_error_cant_add_member{ ushort(442) };
inline constexpr phrase<> lng_error_cant_add_bot{ ushort(443) };
inline constexpr phrase<> lng_error_cant_add_admin_invite{ ushort(444) };
inline constexpr phrase<> lng_error_you_blocked_user{ ushort(445) };
inline constexpr phrase<> lng_error_add_admin_not_member{ ushort(446) };
inline constexpr phrase<> lng_error_user_admin_invalid{ ushort(447) };
inline constexpr phrase<> lng_error_channel_bots_too_much{ ushort(448) };
inline constexpr phrase<> lng_error_group_bots_too_much{ ushort(449) };
inline constexpr phrase<> lng_error_cant_add_admin_unban{ ushort(450) };
inline constexpr phrase<> lng_error_cant_ban_admin{ ushort(451) };
inline constexpr phrase<> lng_error_cant_reply_other{ ushort(452) };
inline constexpr phrase<> lng_error_admin_limit{ ushort(453) };
inline constexpr phrase<> lng_error_admin_limit_channel{ ushort(454) };
inline constexpr phrase<> lng_error_post_link_invalid{ ushort(455) };
inline constexpr phrase<> lng_error_noforwards_group{ ushort(456) };
inline constexpr phrase<> lng_error_noforwards_channel{ ushort(457) };
inline constexpr phrase<> lng_error_nocopy_group{ ushort(458) };
inline constexpr phrase<> lng_error_nocopy_channel{ ushort(459) };
inline constexpr phrase<> lng_error_nocopy_story{ ushort(460) };
inline constexpr phrase<> lng_error_schedule_limit{ ushort(461) };
inline constexpr phrase<> lng_sure_add_admin_invite{ ushort(462) };
inline constexpr phrase<> lng_sure_add_admin_invite_channel{ ushort(463) };
inline constexpr phrase<> lng_sure_add_admin_unremove{ ushort(464) };
inline constexpr phrase<> lng_sure_ban_admin{ ushort(465) };
inline constexpr phrase<lngtag_server, lngtag_port> lng_sure_enable_socks{ ushort(466) };
inline constexpr phrase<> lng_sure_enable{ ushort(467) };
inline constexpr phrase<> lng_proxy_box_title{ ushort(468) };
inline constexpr phrase<> lng_proxy_box_server{ ushort(469) };
inline constexpr phrase<> lng_proxy_box_port{ ushort(470) };
inline constexpr phrase<> lng_proxy_box_secret{ ushort(471) };
inline constexpr phrase<> lng_proxy_box_status{ ushort(472) };
inline constexpr phrase<> lng_proxy_box_username{ ushort(473) };
inline constexpr phrase<> lng_proxy_box_password{ ushort(474) };
inline constexpr phrase<> lng_proxy_invalid{ ushort(475) };
inline constexpr phrase<> lng_proxy_unsupported{ ushort(476) };
inline constexpr phrase<> lng_proxy_incorrect_secret{ ushort(477) };
inline constexpr phrase<> lng_edit_deleted{ ushort(478) };
inline constexpr phrase<lngtag_count> lng_edit_limit_reached{ ushort(479) };
inline constexpr phrase<> lng_edit_message{ ushort(485) };
inline constexpr phrase<> lng_edit_message_text{ ushort(486) };
inline constexpr phrase<> lng_deleted{ ushort(487) };
inline constexpr phrase<> lng_deleted_message{ ushort(488) };
inline constexpr phrase<> lng_deleted_story{ ushort(489) };
inline constexpr phrase<> lng_pinned_message{ ushort(490) };
inline constexpr phrase<> lng_pinned_previous{ ushort(491) };
inline constexpr phrase<> lng_pinned_unpin_sure{ ushort(492) };
inline constexpr phrase<> lng_pinned_pin_sure{ ushort(493) };
inline constexpr phrase<> lng_pinned_pin_sure_group{ ushort(494) };
inline constexpr phrase<> lng_pinned_pin_old_sure{ ushort(495) };
inline constexpr phrase<> lng_pinned_pin{ ushort(496) };
inline constexpr phrase<> lng_pinned_unpin{ ushort(497) };
inline constexpr phrase<> lng_pinned_notify{ ushort(498) };
inline constexpr phrase<lngtag_user> lng_pinned_also_for_other{ ushort(499) };
inline constexpr phrase<lngtag_count> lng_pinned_messages_title{ ushort(500) };
inline constexpr phrase<> lng_pinned_hide_all{ ushort(506) };
inline constexpr phrase<lngtag_count> lng_pinned_unpin_all{ ushort(507) };
inline constexpr phrase<> lng_pinned_unpin_all_sure{ ushort(513) };
inline constexpr phrase<> lng_pinned_hide_all_sure{ ushort(514) };
inline constexpr phrase<> lng_pinned_hide_all_hide{ ushort(515) };
inline constexpr phrase<> lng_edit_media_album_error{ ushort(516) };
inline constexpr phrase<> lng_edit_media_invalid_file{ ushort(517) };
inline constexpr phrase<> lng_edit_photo_editor_hint{ ushort(518) };
inline constexpr phrase<> lng_edit_caption_attach{ ushort(519) };
inline constexpr phrase<> lng_edit_caption_voice{ ushort(520) };
inline constexpr phrase<> lng_intro_about{ ushort(521) };
inline constexpr phrase<> lng_start_msgs{ ushort(522) };
inline constexpr phrase<> lng_intro_next{ ushort(523) };
inline constexpr phrase<> lng_intro_finish{ ushort(524) };
inline constexpr phrase<> lng_intro_submit{ ushort(525) };
inline constexpr phrase<> lng_photo_caption{ ushort(526) };
inline constexpr phrase<> lng_photos_comment{ ushort(527) };
inline constexpr phrase<> lng_intro_qr_title{ ushort(528) };
inline constexpr phrase<> lng_intro_qr_step1{ ushort(529) };
inline constexpr phrase<> lng_intro_qr_step2{ ushort(530) };
inline constexpr phrase<> lng_intro_qr_step3{ ushort(531) };
inline constexpr phrase<> lng_intro_qr_skip{ ushort(532) };
inline constexpr phrase<> lng_intro_qr_phone{ ushort(533) };
inline constexpr phrase<> lng_intro_qr_passkey{ ushort(534) };
inline constexpr phrase<> lng_intro_fragment_title{ ushort(535) };
inline constexpr phrase<lngtag_phone_number> lng_intro_fragment_about{ ushort(536) };
inline constexpr phrase<> lng_intro_fragment_button{ ushort(537) };
inline constexpr phrase<> lng_intro_email_setup_title{ ushort(538) };
inline constexpr phrase<lngtag_email> lng_intro_email_confirm_subtitle{ ushort(539) };
inline constexpr phrase<> lng_phone_title{ ushort(540) };
inline constexpr phrase<> lng_phone_desc{ ushort(541) };
inline constexpr phrase<> lng_phone_to_qr{ ushort(542) };
inline constexpr phrase<> lng_country_code{ ushort(543) };
inline constexpr phrase<> lng_bad_country_code{ ushort(544) };
inline constexpr phrase<> lng_country_ph{ ushort(545) };
inline constexpr phrase<> lng_country_none{ ushort(546) };
inline constexpr phrase<> lng_country_select{ ushort(547) };
inline constexpr phrase<> lng_phone_number{ ushort(548) };
inline constexpr phrase<> lng_code_ph{ ushort(549) };
inline constexpr phrase<> lng_code_desc{ ushort(550) };
inline constexpr phrase<> lng_code_from_telegram{ ushort(551) };
inline constexpr phrase<> lng_code_no_telegram{ ushort(552) };
inline constexpr phrase<lngtag_minutes, lngtag_seconds> lng_code_call{ ushort(553) };
inline constexpr phrase<> lng_code_calling{ ushort(554) };
inline constexpr phrase<> lng_code_called{ ushort(555) };
inline constexpr phrase<> lng_bad_phone{ ushort(556) };
inline constexpr phrase<> lng_bad_code{ ushort(557) };
inline constexpr phrase<> lng_bad_name{ ushort(558) };
inline constexpr phrase<> lng_bad_photo{ ushort(559) };
inline constexpr phrase<> lng_signin_title{ ushort(560) };
inline constexpr phrase<> lng_signin_desc{ ushort(561) };
inline constexpr phrase<lngtag_email> lng_signin_recover_desc{ ushort(562) };
inline constexpr phrase<> lng_signin_password{ ushort(563) };
inline constexpr phrase<> lng_signin_code{ ushort(564) };
inline constexpr phrase<> lng_signin_recover{ ushort(565) };
inline constexpr phrase<> lng_signin_recover_title{ ushort(566) };
inline constexpr phrase<lngtag_password_hint> lng_signin_hint{ ushort(567) };
inline constexpr phrase<lngtag_recover_email> lng_signin_recover_hint{ ushort(568) };
inline constexpr phrase<> lng_signin_bad_password{ ushort(569) };
inline constexpr phrase<> lng_signin_wrong_code{ ushort(570) };
inline constexpr phrase<> lng_signin_try_password{ ushort(571) };
inline constexpr phrase<> lng_signin_no_email_forgot{ ushort(572) };
inline constexpr phrase<> lng_signin_cant_email_forgot{ ushort(573) };
inline constexpr phrase<> lng_signin_reset_account{ ushort(574) };
inline constexpr phrase<> lng_signin_sure_reset{ ushort(575) };
inline constexpr phrase<> lng_signin_reset{ ushort(576) };
inline constexpr phrase<lngtag_phone_number, lngtag_when> lng_signin_reset_wait{ ushort(577) };
inline constexpr phrase<lngtag_days_count, lngtag_hours_count, lngtag_minutes_count> lng_signin_reset_in_days{ ushort(578) };
inline constexpr phrase<lngtag_hours_count, lngtag_minutes_count> lng_signin_reset_in_hours{ ushort(579) };
inline constexpr phrase<> lng_signin_reset_cancelled{ ushort(580) };
inline constexpr phrase<> lng_signin_banned_text{ ushort(581) };
inline constexpr phrase<> lng_signin_banned_help{ ushort(582) };
inline constexpr phrase<> lng_signup_title{ ushort(583) };
inline constexpr phrase<> lng_signup_desc{ ushort(584) };
inline constexpr phrase<> lng_signup_firstname{ ushort(585) };
inline constexpr phrase<> lng_signup_lastname{ ushort(586) };
inline constexpr phrase<> lng_dlg_filter{ ushort(587) };
inline constexpr phrase<> lng_dlg_new_group_name{ ushort(588) };
inline constexpr phrase<> lng_dlg_new_channel_name{ ushort(589) };
inline constexpr phrase<> lng_dlg_new_bot_name{ ushort(590) };
inline constexpr phrase<> lng_no_chats{ ushort(591) };
inline constexpr phrase<> lng_no_conversations{ ushort(592) };
inline constexpr phrase<> lng_no_conversations_button{ ushort(593) };
inline constexpr phrase<> lng_no_conversations_subtitle{ ushort(594) };
inline constexpr phrase<> lng_no_chats_filter{ ushort(595) };
inline constexpr phrase<> lng_no_saved_sublists{ ushort(596) };
inline constexpr phrase<> lng_contacts_loading{ ushort(597) };
inline constexpr phrase<> lng_contacts_not_found{ ushort(598) };
inline constexpr phrase<> lng_topics_not_found{ ushort(599) };
inline constexpr phrase<> lng_dlg_search_for_messages{ ushort(600) };
inline constexpr phrase<> lng_update_telegram{ ushort(601) };
inline constexpr phrase<> lng_dlg_search_in{ ushort(602) };
inline constexpr phrase<lngtag_user> lng_dlg_search_from{ ushort(603) };
inline constexpr phrase<> lng_chat_menu{ ushort(604) };
inline constexpr phrase<> lng_settings_save{ ushort(605) };
inline constexpr phrase<> lng_settings_apply{ ushort(606) };
inline constexpr phrase<> lng_username_title{ ushort(607) };
inline constexpr phrase<> lng_username_description1{ ushort(608) };
inline constexpr phrase<> lng_username_description2{ ushort(609) };
inline constexpr phrase<> lng_username_choose{ ushort(610) };
inline constexpr phrase<> lng_username_invalid{ ushort(611) };
inline constexpr phrase<> lng_username_occupied{ ushort(612) };
inline constexpr phrase<> lng_username_too_short{ ushort(613) };
inline constexpr phrase<lngtag_link> lng_username_purchase_available{ ushort(614) };
inline constexpr phrase<> lng_username_purchase_available_link{ ushort(615) };
inline constexpr phrase<> lng_username_bad_symbols{ ushort(616) };
inline constexpr phrase<> lng_username_available{ ushort(617) };
inline constexpr phrase<lngtag_user> lng_username_not_found{ ushort(618) };
inline constexpr phrase<lngtag_phone> lng_username_by_phone_not_found{ ushort(619) };
inline constexpr phrase<> lng_username_app_not_found{ ushort(620) };
inline constexpr phrase<> lng_username_link{ ushort(621) };
inline constexpr phrase<> lng_username_copied{ ushort(622) };
inline constexpr phrase<> lng_username_text_copied{ ushort(623) };
inline constexpr phrase<> lng_usernames_edit{ ushort(624) };
inline constexpr phrase<> lng_usernames_active{ ushort(625) };
inline constexpr phrase<> lng_usernames_non_active{ ushort(626) };
inline constexpr phrase<> lng_usernames_subtitle{ ushort(627) };
inline constexpr phrase<lngtag_count> lng_usernames_activate_error{ ushort(628) };
inline constexpr phrase<> lng_usernames_activate_description{ ushort(634) };
inline constexpr phrase<> lng_usernames_activate_confirm{ ushort(635) };
inline constexpr phrase<> lng_channel_usernames_subtitle{ ushort(636) };
inline constexpr phrase<> lng_usernames_deactivate_description{ ushort(637) };
inline constexpr phrase<> lng_usernames_deactivate_confirm{ ushort(638) };
inline constexpr phrase<> lng_usernames_description{ ushort(639) };
inline constexpr phrase<> lng_channel_usernames_activate_description{ ushort(640) };
inline constexpr phrase<> lng_channel_usernames_deactivate_description{ ushort(641) };
inline constexpr phrase<> lng_channel_usernames_description{ ushort(642) };
inline constexpr phrase<> lng_bot_username_title{ ushort(643) };
inline constexpr phrase<lngtag_link> lng_bot_username_description1{ ushort(644) };
inline constexpr phrase<> lng_bot_username_description1_link{ ushort(645) };
inline constexpr phrase<> lng_bot_usernames_activate_description{ ushort(646) };
inline constexpr phrase<> lng_bot_usernames_deactivate_description{ ushort(647) };
inline constexpr phrase<> lng_bot_usernames_description{ ushort(648) };
inline constexpr phrase<> lng_bio_placeholder{ ushort(649) };
inline constexpr phrase<lngtag_username> lng_collectible_username_title{ ushort(650) };
inline constexpr phrase<lngtag_date, lngtag_price> lng_collectible_username_info{ ushort(651) };
inline constexpr phrase<> lng_collectible_username_copy{ ushort(652) };
inline constexpr phrase<lngtag_phone> lng_collectible_phone_title{ ushort(653) };
inline constexpr phrase<lngtag_date, lngtag_price> lng_collectible_phone_info{ ushort(654) };
inline constexpr phrase<> lng_collectible_phone_copy{ ushort(655) };
inline constexpr phrase<> lng_collectible_learn_more{ ushort(656) };
inline constexpr phrase<> lng_collectible_phone_copied{ ushort(657) };
inline constexpr phrase<> lng_settings_section_info{ ushort(658) };
inline constexpr phrase<> lng_settings_section_notify{ ushort(659) };
inline constexpr phrase<> lng_settings_show_from{ ushort(660) };
inline constexpr phrase<> lng_settings_notify_all{ ushort(661) };
inline constexpr phrase<> lng_settings_notify_all_about{ ushort(662) };
inline constexpr phrase<> lng_settings_notify_global{ ushort(663) };
inline constexpr phrase<> lng_settings_notify_title{ ushort(664) };
inline constexpr phrase<> lng_settings_desktop_notify{ ushort(665) };
inline constexpr phrase<> lng_settings_master_volume_notifications{ ushort(666) };
inline constexpr phrase<> lng_settings_native_title{ ushort(667) };
inline constexpr phrase<> lng_settings_use_windows{ ushort(668) };
inline constexpr phrase<> lng_settings_skip_in_focus{ ushort(669) };
inline constexpr phrase<> lng_settings_use_native_notifications{ ushort(670) };
inline constexpr phrase<> lng_settings_notifications_position{ ushort(671) };
inline constexpr phrase<> lng_settings_notifications_count{ ushort(672) };
inline constexpr phrase<> lng_settings_notifications_display{ ushort(673) };
inline constexpr phrase<> lng_settings_notifications_display_default{ ushort(674) };
inline constexpr phrase<> lng_settings_sound_allowed{ ushort(675) };
inline constexpr phrase<> lng_settings_alert_windows{ ushort(676) };
inline constexpr phrase<> lng_settings_alert_mac{ ushort(677) };
inline constexpr phrase<> lng_settings_alert_linux{ ushort(678) };
inline constexpr phrase<> lng_settings_badge_title{ ushort(679) };
inline constexpr phrase<> lng_settings_include_muted{ ushort(680) };
inline constexpr phrase<> lng_settings_include_muted_folders{ ushort(681) };
inline constexpr phrase<> lng_settings_count_unread{ ushort(682) };
inline constexpr phrase<> lng_settings_events_title{ ushort(683) };
inline constexpr phrase<> lng_settings_events_joined{ ushort(684) };
inline constexpr phrase<> lng_settings_events_pinned{ ushort(685) };
inline constexpr phrase<> lng_settings_notifications_calls_title{ ushort(686) };
inline constexpr phrase<> lng_notification_preview_title{ ushort(687) };
inline constexpr phrase<> lng_notification_preview_text{ ushort(688) };
inline constexpr phrase<> lng_notification_show_name{ ushort(689) };
inline constexpr phrase<> lng_notification_show_text{ ushort(690) };
inline constexpr phrase<> lng_notification_preview{ ushort(691) };
inline constexpr phrase<> lng_notification_reply{ ushort(692) };
inline constexpr phrase<> lng_notification_hide_all{ ushort(693) };
inline constexpr phrase<> lng_notification_sample{ ushort(694) };
inline constexpr phrase<> lng_notification_reminder{ ushort(695) };
inline constexpr phrase<> lng_notification_private_chats{ ushort(696) };
inline constexpr phrase<> lng_notification_groups{ ushort(697) };
inline constexpr phrase<> lng_notification_channels{ ushort(698) };
inline constexpr phrase<> lng_notification_click_to_change{ ushort(699) };
inline constexpr phrase<lngtag_exceptions> lng_notification_on{ ushort(700) };
inline constexpr phrase<lngtag_exceptions> lng_notification_off{ ushort(701) };
inline constexpr phrase<lngtag_count> lng_notification_exceptions{ ushort(702) };
inline constexpr phrase<> lng_notification_exceptions_title{ ushort(708) };
inline constexpr phrase<> lng_notification_title_private_chats{ ushort(709) };
inline constexpr phrase<lngtag_count> lng_notification_about_private_chats{ ushort(710) };
inline constexpr phrase<> lng_notification_volume_private_chats{ ushort(716) };
inline constexpr phrase<> lng_notification_title_groups{ ushort(717) };
inline constexpr phrase<lngtag_count> lng_notification_about_groups{ ushort(718) };
inline constexpr phrase<> lng_notification_volume_groups{ ushort(724) };
inline constexpr phrase<> lng_notification_title_channels{ ushort(725) };
inline constexpr phrase<lngtag_count> lng_notification_about_channels{ ushort(726) };
inline constexpr phrase<> lng_notification_volume_channel{ ushort(732) };
inline constexpr phrase<> lng_notification_exceptions_view{ ushort(733) };
inline constexpr phrase<> lng_notification_enable{ ushort(734) };
inline constexpr phrase<> lng_notification_sound{ ushort(735) };
inline constexpr phrase<> lng_notification_tone{ ushort(736) };
inline constexpr phrase<> lng_notification_exceptions_muted{ ushort(737) };
inline constexpr phrase<> lng_notification_exceptions_unmuted{ ushort(738) };
inline constexpr phrase<> lng_notification_exceptions_add{ ushort(739) };
inline constexpr phrase<> lng_notification_exceptions_clear{ ushort(740) };
inline constexpr phrase<> lng_notification_exceptions_clear_sure{ ushort(741) };
inline constexpr phrase<> lng_notification_exceptions_clear_button{ ushort(742) };
inline constexpr phrase<> lng_notification_exceptions_remove{ ushort(743) };
inline constexpr phrase<> lng_notification_context_remove{ ushort(744) };
inline constexpr phrase<lngtag_reaction, lngtag_text> lng_reaction_text{ ushort(745) };
inline constexpr phrase<lngtag_reaction> lng_reaction_notext{ ushort(746) };
inline constexpr phrase<lngtag_reaction> lng_reaction_photo{ ushort(747) };
inline constexpr phrase<lngtag_reaction> lng_reaction_video{ ushort(748) };
inline constexpr phrase<lngtag_reaction> lng_reaction_video_message{ ushort(749) };
inline constexpr phrase<lngtag_reaction> lng_reaction_document{ ushort(750) };
inline constexpr phrase<lngtag_reaction, lngtag_emoji> lng_reaction_sticker{ ushort(751) };
inline constexpr phrase<lngtag_reaction> lng_reaction_voice_message{ ushort(752) };
inline constexpr phrase<lngtag_reaction, lngtag_name> lng_reaction_contact{ ushort(753) };
inline constexpr phrase<lngtag_reaction> lng_reaction_location{ ushort(754) };
inline constexpr phrase<lngtag_reaction, lngtag_title> lng_reaction_poll{ ushort(755) };
inline constexpr phrase<lngtag_reaction, lngtag_title> lng_reaction_quiz{ ushort(756) };
inline constexpr phrase<lngtag_reaction> lng_reaction_game{ ushort(757) };
inline constexpr phrase<lngtag_reaction> lng_reaction_invoice{ ushort(758) };
inline constexpr phrase<lngtag_reaction> lng_reaction_gif{ ushort(759) };
inline constexpr phrase<> lng_effect_add_title{ ushort(760) };
inline constexpr phrase<> lng_effect_stickers_title{ ushort(761) };
inline constexpr phrase<> lng_effect_send{ ushort(762) };
inline constexpr phrase<> lng_effect_none{ ushort(763) };
inline constexpr phrase<lngtag_link> lng_effect_premium{ ushort(764) };
inline constexpr phrase<> lng_effect_premium_link{ ushort(765) };
inline constexpr phrase<> lng_languages{ ushort(766) };
inline constexpr phrase<> lng_languages_none{ ushort(767) };
inline constexpr phrase<lngtag_count> lng_languages_count{ ushort(768) };
inline constexpr phrase<> lng_sure_save_language{ ushort(774) };
inline constexpr phrase<> lng_settings_update_automatically{ ushort(775) };
inline constexpr phrase<> lng_settings_install_beta{ ushort(776) };
inline constexpr phrase<lngtag_version> lng_settings_current_version{ ushort(777) };
inline constexpr phrase<> lng_settings_check_now{ ushort(778) };
inline constexpr phrase<> lng_settings_update_checking{ ushort(779) };
inline constexpr phrase<> lng_settings_latest_installed{ ushort(780) };
inline constexpr phrase<> lng_settings_update_ready{ ushort(781) };
inline constexpr phrase<> lng_settings_update_fail{ ushort(782) };
inline constexpr phrase<> lng_settings_workmode_tray{ ushort(783) };
inline constexpr phrase<> lng_settings_workmode_window{ ushort(784) };
inline constexpr phrase<> lng_settings_window_close{ ushort(785) };
inline constexpr phrase<> lng_settings_run_in_background{ ushort(786) };
inline constexpr phrase<> lng_settings_quit_on_close{ ushort(787) };
inline constexpr phrase<> lng_settings_close_to_taskbar{ ushort(788) };
inline constexpr phrase<> lng_settings_monochrome_icon{ ushort(789) };
inline constexpr phrase<> lng_settings_window_system{ ushort(790) };
inline constexpr phrase<> lng_settings_title_chat_name{ ushort(791) };
inline constexpr phrase<> lng_settings_title_account_name{ ushort(792) };
inline constexpr phrase<> lng_settings_title_total_count{ ushort(793) };
inline constexpr phrase<> lng_settings_native_frame{ ushort(794) };
inline constexpr phrase<> lng_settings_qt_frame{ ushort(795) };
inline constexpr phrase<> lng_settings_auto_start{ ushort(796) };
inline constexpr phrase<> lng_settings_start_min{ ushort(797) };
inline constexpr phrase<> lng_settings_auto_start_disabled_uwp{ ushort(798) };
inline constexpr phrase<> lng_settings_open_system_settings{ ushort(799) };
inline constexpr phrase<> lng_settings_add_sendto{ ushort(800) };
inline constexpr phrase<lngtag_text> lng_settings_mac_warn_before_quit{ ushort(801) };
inline constexpr phrase<> lng_settings_mac_round_icon{ ushort(802) };
inline constexpr phrase<> lng_settings_experimental{ ushort(803) };
inline constexpr phrase<> lng_settings_experimental_about{ ushort(804) };
inline constexpr phrase<> lng_settings_experimental_restore{ ushort(805) };
inline constexpr phrase<> lng_settings_experimental_irrelevant{ ushort(806) };
inline constexpr phrase<> lng_settings_section_chat_settings{ ushort(807) };
inline constexpr phrase<> lng_settings_replace_emojis{ ushort(808) };
inline constexpr phrase<> lng_settings_suggest_emoji{ ushort(809) };
inline constexpr phrase<> lng_settings_suggest_animated_emoji{ ushort(810) };
inline constexpr phrase<> lng_settings_suggest_by_emoji{ ushort(811) };
inline constexpr phrase<> lng_settings_loop_stickers{ ushort(812) };
inline constexpr phrase<> lng_settings_large_emoji{ ushort(813) };
inline constexpr phrase<> lng_settings_send_enter{ ushort(814) };
inline constexpr phrase<> lng_settings_send_ctrlenter{ ushort(815) };
inline constexpr phrase<> lng_settings_send_cmdenter{ ushort(816) };
inline constexpr phrase<> lng_settings_chat_quick_action_reply{ ushort(817) };
inline constexpr phrase<> lng_settings_chat_quick_action_react{ ushort(818) };
inline constexpr phrase<> lng_settings_chat_corner_reaction{ ushort(819) };
inline constexpr phrase<> lng_settings_shortcuts{ ushort(820) };
inline constexpr phrase<> lng_shortcuts_reset{ ushort(821) };
inline constexpr phrase<> lng_shortcuts_recording{ ushort(822) };
inline constexpr phrase<> lng_shortcuts_add_another{ ushort(823) };
inline constexpr phrase<> lng_shortcuts_close{ ushort(824) };
inline constexpr phrase<> lng_shortcuts_lock{ ushort(825) };
inline constexpr phrase<> lng_shortcuts_minimize{ ushort(826) };
inline constexpr phrase<> lng_shortcuts_quit{ ushort(827) };
inline constexpr phrase<> lng_shortcuts_media_play{ ushort(828) };
inline constexpr phrase<> lng_shortcuts_media_pause{ ushort(829) };
inline constexpr phrase<> lng_shortcuts_media_play_pause{ ushort(830) };
inline constexpr phrase<> lng_shortcuts_media_stop{ ushort(831) };
inline constexpr phrase<> lng_shortcuts_media_previous{ ushort(832) };
inline constexpr phrase<> lng_shortcuts_media_next{ ushort(833) };
inline constexpr phrase<> lng_shortcuts_search{ ushort(834) };
inline constexpr phrase<> lng_shortcuts_chat_previous{ ushort(835) };
inline constexpr phrase<> lng_shortcuts_chat_next{ ushort(836) };
inline constexpr phrase<> lng_shortcuts_chat_first{ ushort(837) };
inline constexpr phrase<> lng_shortcuts_chat_last{ ushort(838) };
inline constexpr phrase<> lng_shortcuts_chat_self{ ushort(839) };
inline constexpr phrase<lngtag_index> lng_shortcuts_chat_pinned_n{ ushort(840) };
inline constexpr phrase<lngtag_index> lng_shortcuts_show_account_n{ ushort(841) };
inline constexpr phrase<> lng_shortcuts_show_all_chats{ ushort(842) };
inline constexpr phrase<lngtag_index> lng_shortcuts_show_folder_n{ ushort(843) };
inline constexpr phrase<> lng_shortcuts_show_folder_last{ ushort(844) };
inline constexpr phrase<> lng_shortcuts_folder_next{ ushort(845) };
inline constexpr phrase<> lng_shortcuts_folder_previous{ ushort(846) };
inline constexpr phrase<> lng_shortcuts_scheduled{ ushort(847) };
inline constexpr phrase<> lng_shortcuts_archive{ ushort(848) };
inline constexpr phrase<> lng_shortcuts_contacts{ ushort(849) };
inline constexpr phrase<> lng_shortcuts_just_send{ ushort(850) };
inline constexpr phrase<> lng_shortcuts_silent_send{ ushort(851) };
inline constexpr phrase<> lng_shortcuts_schedule{ ushort(852) };
inline constexpr phrase<> lng_shortcuts_read_chat{ ushort(853) };
inline constexpr phrase<> lng_shortcuts_archive_chat{ ushort(854) };
inline constexpr phrase<> lng_shortcuts_media_fullscreen{ ushort(855) };
inline constexpr phrase<> lng_shortcuts_show_chat_menu{ ushort(856) };
inline constexpr phrase<> lng_shortcuts_show_chat_preview{ ushort(857) };
inline constexpr phrase<> lng_shortcuts_record_voice_message{ ushort(858) };
inline constexpr phrase<> lng_shortcuts_record_round_message{ ushort(859) };
inline constexpr phrase<> lng_shortcuts_admin_log{ ushort(860) };
inline constexpr phrase<> lng_attach{ ushort(861) };
inline constexpr phrase<> lng_attach_replace{ ushort(862) };
inline constexpr phrase<> lng_emoji_sticker_gif{ ushort(863) };
inline constexpr phrase<> lng_bot_keyboard_show{ ushort(864) };
inline constexpr phrase<> lng_bot_keyboard_hide{ ushort(865) };
inline constexpr phrase<> lng_bot_commands_start{ ushort(866) };
inline constexpr phrase<> lng_broadcast_silent{ ushort(867) };
inline constexpr phrase<> lng_settings_chat_reactions_title{ ushort(868) };
inline constexpr phrase<> lng_settings_chat_reactions_subtitle{ ushort(869) };
inline constexpr phrase<> lng_settings_chat_message_reply_from{ ushort(870) };
inline constexpr phrase<> lng_settings_chat_message_reply{ ushort(871) };
inline constexpr phrase<> lng_settings_chat_message{ ushort(872) };
inline constexpr phrase<> lng_settings_section_filters{ ushort(873) };
inline constexpr phrase<> lng_settings_section_background{ ushort(874) };
inline constexpr phrase<> lng_settings_bg_from_gallery{ ushort(875) };
inline constexpr phrase<> lng_settings_bg_from_file{ ushort(876) };
inline constexpr phrase<> lng_settings_bg_remove{ ushort(877) };
inline constexpr phrase<> lng_settings_bg_theme_edit{ ushort(878) };
inline constexpr phrase<> lng_settings_bg_theme_create{ ushort(879) };
inline constexpr phrase<> lng_settings_bg_cloud_themes{ ushort(880) };
inline constexpr phrase<> lng_settings_bg_show_all{ ushort(881) };
inline constexpr phrase<> lng_settings_bg_tile{ ushort(882) };
inline constexpr phrase<> lng_settings_adaptive_wide{ ushort(883) };
inline constexpr phrase<> lng_settings_section_call_settings{ ushort(884) };
inline constexpr phrase<> lng_settings_call_camera{ ushort(885) };
inline constexpr phrase<> lng_settings_call_section_output{ ushort(886) };
inline constexpr phrase<> lng_settings_call_section_input{ ushort(887) };
inline constexpr phrase<> lng_settings_call_input_device{ ushort(888) };
inline constexpr phrase<> lng_settings_call_output_device{ ushort(889) };
inline constexpr phrase<> lng_settings_call_section_other{ ushort(890) };
inline constexpr phrase<> lng_settings_call_open_system_prefs{ ushort(891) };
inline constexpr phrase<> lng_settings_call_accept_calls{ ushort(892) };
inline constexpr phrase<> lng_settings_call_device_default{ ushort(893) };
inline constexpr phrase<> lng_settings_section_devices{ ushort(894) };
inline constexpr phrase<> lng_settings_devices_calls{ ushort(895) };
inline constexpr phrase<> lng_settings_devices_calls_same{ ushort(896) };
inline constexpr phrase<> lng_settings_devices_inactive{ ushort(897) };
inline constexpr phrase<> lng_settings_language{ ushort(898) };
inline constexpr phrase<> lng_settings_default_scale{ ushort(899) };
inline constexpr phrase<> lng_settings_scale{ ushort(900) };
inline constexpr phrase<> lng_settings_connection_type{ ushort(901) };
inline constexpr phrase<lngtag_progress> lng_settings_downloading_update{ ushort(902) };
inline constexpr phrase<> lng_settings_privacy_title{ ushort(903) };
inline constexpr phrase<> lng_settings_last_seen{ ushort(904) };
inline constexpr phrase<> lng_settings_calls{ ushort(905) };
inline constexpr phrase<> lng_settings_calls_peer_to_peer_title{ ushort(906) };
inline constexpr phrase<> lng_settings_calls_peer_to_peer_button{ ushort(907) };
inline constexpr phrase<> lng_settings_groups_invite{ ushort(908) };
inline constexpr phrase<> lng_settings_phone_number_privacy{ ushort(909) };
inline constexpr phrase<> lng_settings_forwards_privacy{ ushort(910) };
inline constexpr phrase<> lng_settings_profile_photo_privacy{ ushort(911) };
inline constexpr phrase<> lng_settings_messages_privacy{ ushort(912) };
inline constexpr phrase<> lng_settings_voices_privacy{ ushort(913) };
inline constexpr phrase<> lng_settings_bio_privacy{ ushort(914) };
inline constexpr phrase<> lng_settings_gifts_privacy{ ushort(915) };
inline constexpr phrase<> lng_settings_birthday_privacy{ ushort(916) };
inline constexpr phrase<> lng_settings_saved_music_privacy{ ushort(917) };
inline constexpr phrase<lngtag_link> lng_settings_privacy_premium{ ushort(918) };
inline constexpr phrase<> lng_settings_privacy_premium_link{ ushort(919) };
inline constexpr phrase<> lng_settings_passcode_disable{ ushort(920) };
inline constexpr phrase<> lng_settings_passcode_disable_sure{ ushort(921) };
inline constexpr phrase<> lng_settings_use_winhello{ ushort(922) };
inline constexpr phrase<> lng_settings_use_winhello_about{ ushort(923) };
inline constexpr phrase<> lng_settings_use_touchid{ ushort(924) };
inline constexpr phrase<> lng_settings_use_touchid_about{ ushort(925) };
inline constexpr phrase<> lng_settings_use_applewatch{ ushort(926) };
inline constexpr phrase<> lng_settings_use_applewatch_about{ ushort(927) };
inline constexpr phrase<> lng_settings_use_systempwd{ ushort(928) };
inline constexpr phrase<> lng_settings_use_systempwd_about{ ushort(929) };
inline constexpr phrase<> lng_settings_password_disable{ ushort(930) };
inline constexpr phrase<> lng_settings_password_abort{ ushort(931) };
inline constexpr phrase<> lng_settings_about_bio{ ushort(932) };
inline constexpr phrase<> lng_settings_name_label{ ushort(933) };
inline constexpr phrase<> lng_settings_username_label{ ushort(934) };
inline constexpr phrase<> lng_settings_phone_label{ ushort(935) };
inline constexpr phrase<> lng_settings_username_add{ ushort(936) };
inline constexpr phrase<> lng_settings_username_about{ ushort(937) };
inline constexpr phrase<> lng_settings_birthday_label{ ushort(938) };
inline constexpr phrase<> lng_settings_birthday_title{ ushort(939) };
inline constexpr phrase<> lng_settings_birthday_add{ ushort(940) };
inline constexpr phrase<lngtag_link> lng_settings_birthday_about{ ushort(941) };
inline constexpr phrase<> lng_settings_birthday_about_link{ ushort(942) };
inline constexpr phrase<lngtag_link> lng_settings_birthday_contacts{ ushort(943) };
inline constexpr phrase<> lng_settings_birthday_contacts_link{ ushort(944) };
inline constexpr phrase<> lng_settings_birthday_saved{ ushort(945) };
inline constexpr phrase<lngtag_user> lng_settings_birthday_suggested{ ushort(946) };
inline constexpr phrase<> lng_settings_birthday_reset{ ushort(947) };
inline constexpr phrase<> lng_settings_channel_label{ ushort(948) };
inline constexpr phrase<> lng_settings_channel_add{ ushort(949) };
inline constexpr phrase<> lng_settings_channel_remove{ ushort(950) };
inline constexpr phrase<> lng_settings_channel_menu_remove{ ushort(951) };
inline constexpr phrase<> lng_settings_channel_no_yet{ ushort(952) };
inline constexpr phrase<> lng_settings_channel_start{ ushort(953) };
inline constexpr phrase<> lng_settings_channel_saved{ ushort(954) };
inline constexpr phrase<> lng_settings_channel_removed{ ushort(955) };
inline constexpr phrase<> lng_settings_add_account_about{ ushort(956) };
inline constexpr phrase<> lng_settings_peer_to_peer_about{ ushort(957) };
inline constexpr phrase<> lng_settings_advanced{ ushort(958) };
inline constexpr phrase<> lng_settings_stickers_emoji{ ushort(959) };
inline constexpr phrase<> lng_settings_messages{ ushort(960) };
inline constexpr phrase<> lng_settings_themes{ ushort(961) };
inline constexpr phrase<> lng_settings_theme_day{ ushort(962) };
inline constexpr phrase<> lng_settings_theme_classic{ ushort(963) };
inline constexpr phrase<> lng_settings_theme_tinted{ ushort(964) };
inline constexpr phrase<> lng_settings_theme_night{ ushort(965) };
inline constexpr phrase<> lng_settings_theme_accent_title{ ushort(966) };
inline constexpr phrase<> lng_settings_data_storage{ ushort(967) };
inline constexpr phrase<> lng_settings_information{ ushort(968) };
inline constexpr phrase<> lng_settings_my_account{ ushort(969) };
inline constexpr phrase<> lng_settings_security{ ushort(970) };
inline constexpr phrase<> lng_settings_passcode_title{ ushort(971) };
inline constexpr phrase<> lng_settings_sessions_title{ ushort(972) };
inline constexpr phrase<> lng_settings_sessions_about{ ushort(973) };
inline constexpr phrase<> lng_settings_archive_title{ ushort(974) };
inline constexpr phrase<> lng_settings_new_unknown{ ushort(975) };
inline constexpr phrase<> lng_settings_auto_archive{ ushort(976) };
inline constexpr phrase<> lng_settings_auto_archive_about{ ushort(977) };
inline constexpr phrase<> lng_settings_unmuted_chats{ ushort(978) };
inline constexpr phrase<> lng_settings_always_in_archive{ ushort(979) };
inline constexpr phrase<> lng_settings_unmuted_chats_about{ ushort(980) };
inline constexpr phrase<> lng_settings_chats_from_folders{ ushort(981) };
inline constexpr phrase<> lng_settings_chats_from_folders_about{ ushort(982) };
inline constexpr phrase<> lng_settings_destroy_title{ ushort(983) };
inline constexpr phrase<> lng_settings_version_info{ ushort(984) };
inline constexpr phrase<> lng_settings_system_integration{ ushort(985) };
inline constexpr phrase<> lng_settings_performance{ ushort(986) };
inline constexpr phrase<> lng_settings_enable_hwaccel{ ushort(987) };
inline constexpr phrase<> lng_settings_enable_opengl{ ushort(988) };
inline constexpr phrase<> lng_settings_angle_backend{ ushort(989) };
inline constexpr phrase<> lng_settings_angle_backend_auto{ ushort(990) };
inline constexpr phrase<> lng_settings_angle_backend_d3d9{ ushort(991) };
inline constexpr phrase<> lng_settings_angle_backend_d3d11{ ushort(992) };
inline constexpr phrase<> lng_settings_angle_backend_d3d11on12{ ushort(993) };
inline constexpr phrase<> lng_settings_angle_backend_opengl{ ushort(994) };
inline constexpr phrase<> lng_settings_angle_backend_disabled{ ushort(995) };
inline constexpr phrase<> lng_settings_top_peers_title{ ushort(996) };
inline constexpr phrase<> lng_settings_top_peers_suggest{ ushort(997) };
inline constexpr phrase<> lng_settings_top_peers_about{ ushort(998) };
inline constexpr phrase<> lng_settings_sensitive_title{ ushort(999) };
inline constexpr phrase<> lng_settings_sensitive_disable_filtering{ ushort(1000) };
inline constexpr phrase<> lng_settings_sensitive_about{ ushort(1001) };
inline constexpr phrase<> lng_settings_security_bots{ ushort(1002) };
inline constexpr phrase<> lng_settings_file_confirmations{ ushort(1003) };
inline constexpr phrase<> lng_settings_edit_extensions{ ushort(1004) };
inline constexpr phrase<> lng_settings_edit_extensions_about{ ushort(1005) };
inline constexpr phrase<> lng_settings_edit_ip_confirm{ ushort(1006) };
inline constexpr phrase<> lng_settings_edit_ip_confirm_about{ ushort(1007) };
inline constexpr phrase<> lng_settings_clear_payment_info{ ushort(1008) };
inline constexpr phrase<> lng_settings_logged_in{ ushort(1009) };
inline constexpr phrase<> lng_settings_logged_in_title{ ushort(1010) };
inline constexpr phrase<> lng_settings_logged_in_description{ ushort(1011) };
inline constexpr phrase<> lng_settings_disconnect_all{ ushort(1012) };
inline constexpr phrase<> lng_settings_disconnect_title{ ushort(1013) };
inline constexpr phrase<lngtag_domain> lng_settings_disconnect_sure{ ushort(1014) };
inline constexpr phrase<lngtag_name> lng_settings_disconnect_block{ ushort(1015) };
inline constexpr phrase<> lng_settings_disconnect_all_title{ ushort(1016) };
inline constexpr phrase<> lng_settings_disconnect_all_sure{ ushort(1017) };
inline constexpr phrase<> lng_settings_disconnect{ ushort(1018) };
inline constexpr phrase<> lng_settings_connected_title{ ushort(1019) };
inline constexpr phrase<lngtag_phone> lng_settings_suggestion_phone_number_title{ ushort(1020) };
inline constexpr phrase<lngtag_link> lng_settings_suggestion_phone_number_about{ ushort(1021) };
inline constexpr phrase<> lng_settings_suggestion_phone_number_about_link{ ushort(1022) };
inline constexpr phrase<lngtag_emoji> lng_settings_suggestion_phone_number_change{ ushort(1023) };
inline constexpr phrase<> lng_settings_suggestion_password_title{ ushort(1024) };
inline constexpr phrase<> lng_settings_suggestion_password_about{ ushort(1025) };
inline constexpr phrase<> lng_settings_suggestion_password_yes{ ushort(1026) };
inline constexpr phrase<> lng_settings_suggestion_password_no{ ushort(1027) };
inline constexpr phrase<> lng_settings_suggestion_password_step_input_title{ ushort(1028) };
inline constexpr phrase<> lng_settings_suggestion_password_step_input_about{ ushort(1029) };
inline constexpr phrase<> lng_settings_suggestion_password_step_finish_title{ ushort(1030) };
inline constexpr phrase<> lng_settings_suggestion_password_step_finish_about{ ushort(1031) };
inline constexpr phrase<> lng_settings_power_menu{ ushort(1032) };
inline constexpr phrase<> lng_settings_power_title{ ushort(1033) };
inline constexpr phrase<> lng_settings_power_subtitle{ ushort(1034) };
inline constexpr phrase<> lng_settings_power_stickers{ ushort(1035) };
inline constexpr phrase<> lng_settings_power_stickers_panel{ ushort(1036) };
inline constexpr phrase<> lng_settings_power_stickers_chat{ ushort(1037) };
inline constexpr phrase<> lng_settings_power_emoji{ ushort(1038) };
inline constexpr phrase<> lng_settings_power_emoji_panel{ ushort(1039) };
inline constexpr phrase<> lng_settings_power_emoji_reactions{ ushort(1040) };
inline constexpr phrase<> lng_settings_power_emoji_chat{ ushort(1041) };
inline constexpr phrase<> lng_settings_power_emoji_status{ ushort(1042) };
inline constexpr phrase<> lng_settings_power_chat{ ushort(1043) };
inline constexpr phrase<> lng_settings_power_chat_background{ ushort(1044) };
inline constexpr phrase<> lng_settings_power_chat_spoiler{ ushort(1045) };
inline constexpr phrase<> lng_settings_power_chat_effects{ ushort(1046) };
inline constexpr phrase<> lng_settings_power_calls{ ushort(1047) };
inline constexpr phrase<> lng_settings_power_ui{ ushort(1048) };
inline constexpr phrase<> lng_settings_power_auto{ ushort(1049) };
inline constexpr phrase<> lng_settings_power_auto_about{ ushort(1050) };
inline constexpr phrase<> lng_settings_power_turn_off{ ushort(1051) };
inline constexpr phrase<> lng_settings_cloud_password_on{ ushort(1052) };
inline constexpr phrase<> lng_settings_cloud_password_off{ ushort(1053) };
inline constexpr phrase<> lng_settings_cloud_password_start_title{ ushort(1054) };
inline constexpr phrase<> lng_settings_cloud_password_password_title{ ushort(1055) };
inline constexpr phrase<> lng_settings_cloud_password_hint_title{ ushort(1056) };
inline constexpr phrase<> lng_settings_cloud_password_email_title{ ushort(1057) };
inline constexpr phrase<> lng_settings_cloud_password_start_about{ ushort(1058) };
inline constexpr phrase<> lng_settings_cloud_password_hint_about{ ushort(1059) };
inline constexpr phrase<> lng_settings_cloud_password_email_about{ ushort(1060) };
inline constexpr phrase<> lng_settings_cloud_password_password_subtitle{ ushort(1061) };
inline constexpr phrase<> lng_settings_cloud_password_check_subtitle{ ushort(1062) };
inline constexpr phrase<> lng_settings_cloud_password_hint_subtitle{ ushort(1063) };
inline constexpr phrase<> lng_settings_cloud_password_email_subtitle{ ushort(1064) };
inline constexpr phrase<> lng_settings_cloud_password_email_recovery_subtitle{ ushort(1065) };
inline constexpr phrase<> lng_settings_cloud_password_manage_about1{ ushort(1066) };
inline constexpr phrase<> lng_settings_cloud_password_manage_about2{ ushort(1067) };
inline constexpr phrase<> lng_settings_cloud_password_manage_disable_sure{ ushort(1068) };
inline constexpr phrase<> lng_settings_cloud_password_manage_email_new{ ushort(1069) };
inline constexpr phrase<> lng_settings_cloud_password_manage_email_change{ ushort(1070) };
inline constexpr phrase<> lng_settings_cloud_password_manage_password_change{ ushort(1071) };
inline constexpr phrase<> lng_settings_cloud_password_skip_hint{ ushort(1072) };
inline constexpr phrase<> lng_settings_cloud_password_save{ ushort(1073) };
inline constexpr phrase<> lng_settings_cloud_password_email_confirm{ ushort(1074) };
inline constexpr phrase<lngtag_duration> lng_settings_cloud_password_reset_in{ ushort(1075) };
inline constexpr phrase<> lng_settings_cloud_login_email_section_title{ ushort(1076) };
inline constexpr phrase<> lng_settings_cloud_login_email_box_about{ ushort(1077) };
inline constexpr phrase<> lng_settings_cloud_login_email_box_ok{ ushort(1078) };
inline constexpr phrase<> lng_settings_cloud_login_email_title{ ushort(1079) };
inline constexpr phrase<> lng_settings_cloud_login_email_placeholder{ ushort(1080) };
inline constexpr phrase<> lng_settings_cloud_login_email_about{ ushort(1081) };
inline constexpr phrase<> lng_settings_cloud_login_email_confirm{ ushort(1082) };
inline constexpr phrase<> lng_settings_cloud_login_email_code_title{ ushort(1083) };
inline constexpr phrase<lngtag_email> lng_settings_cloud_login_email_code_about{ ushort(1084) };
inline constexpr phrase<> lng_settings_cloud_login_email_success{ ushort(1085) };
inline constexpr phrase<> lng_settings_cloud_login_email_set_success{ ushort(1086) };
inline constexpr phrase<> lng_settings_cloud_login_email_busy{ ushort(1087) };
inline constexpr phrase<> lng_settings_error_email_not_alowed{ ushort(1088) };
inline constexpr phrase<> lng_settings_ttl_title{ ushort(1089) };
inline constexpr phrase<> lng_settings_ttl_about{ ushort(1090) };
inline constexpr phrase<lngtag_after_duration> lng_settings_ttl_after{ ushort(1091) };
inline constexpr phrase<lngtag_count> lng_settings_ttl_after_hours{ ushort(1092) };
inline constexpr phrase<lngtag_count> lng_settings_ttl_after_days{ ushort(1098) };
inline constexpr phrase<lngtag_count> lng_settings_ttl_after_weeks{ ushort(1104) };
inline constexpr phrase<lngtag_count> lng_settings_ttl_after_months{ ushort(1110) };
inline constexpr phrase<lngtag_count> lng_settings_ttl_after_years{ ushort(1116) };
inline constexpr phrase<> lng_settings_ttl_after_off{ ushort(1122) };
inline constexpr phrase<> lng_settings_ttl_after_custom{ ushort(1123) };
inline constexpr phrase<lngtag_link> lng_settings_ttl_after_about{ ushort(1124) };
inline constexpr phrase<> lng_settings_ttl_after_about_link{ ushort(1125) };
inline constexpr phrase<> lng_settings_ttl_after_subtitle{ ushort(1126) };
inline constexpr phrase<lngtag_after_duration> lng_settings_ttl_after_sure{ ushort(1127) };
inline constexpr phrase<lngtag_after_duration> lng_settings_ttl_after_toast{ ushort(1128) };
inline constexpr phrase<> lng_settings_ttl_select_chats_sorry{ ushort(1129) };
inline constexpr phrase<lngtag_after_duration> lng_settings_ttl_select_chats_status{ ushort(1130) };
inline constexpr phrase<> lng_settings_ttl_select_chats_status_disabled{ ushort(1131) };
inline constexpr phrase<lngtag_count, lngtag_duration> lng_settings_ttl_select_chats_toast{ ushort(1132) };
inline constexpr phrase<lngtag_count> lng_settings_ttl_select_chats_disabled_toast{ ushort(1138) };
inline constexpr phrase<> lng_clear_payment_info_title{ ushort(1144) };
inline constexpr phrase<> lng_clear_payment_info_sure{ ushort(1145) };
inline constexpr phrase<> lng_clear_payment_info_shipping{ ushort(1146) };
inline constexpr phrase<> lng_clear_payment_info_payment{ ushort(1147) };
inline constexpr phrase<> lng_clear_payment_info_clear{ ushort(1148) };
inline constexpr phrase<> lng_clear_payment_info_confirm{ ushort(1149) };
inline constexpr phrase<> lng_settings_theme_settings{ ushort(1150) };
inline constexpr phrase<> lng_settings_theme_name_color{ ushort(1151) };
inline constexpr phrase<> lng_settings_auto_night_mode{ ushort(1152) };
inline constexpr phrase<> lng_settings_auto_night_mode_off{ ushort(1153) };
inline constexpr phrase<> lng_settings_auto_night_mode_on{ ushort(1154) };
inline constexpr phrase<> lng_settings_auto_night_warning{ ushort(1155) };
inline constexpr phrase<> lng_settings_auto_night_disable{ ushort(1156) };
inline constexpr phrase<> lng_settings_font_family{ ushort(1157) };
inline constexpr phrase<> lng_settings_color_title{ ushort(1158) };
inline constexpr phrase<> lng_settings_color_tab_profile{ ushort(1159) };
inline constexpr phrase<> lng_settings_color_tab_name{ ushort(1160) };
inline constexpr phrase<> lng_settings_color_reply{ ushort(1161) };
inline constexpr phrase<> lng_settings_color_reply_channel{ ushort(1162) };
inline constexpr phrase<> lng_settings_color_text{ ushort(1163) };
inline constexpr phrase<> lng_settings_color_text_channel{ ushort(1164) };
inline constexpr phrase<> lng_settings_color_link_name{ ushort(1165) };
inline constexpr phrase<> lng_settings_color_link_title{ ushort(1166) };
inline constexpr phrase<> lng_settings_color_link_description{ ushort(1167) };
inline constexpr phrase<> lng_settings_color_about{ ushort(1168) };
inline constexpr phrase<> lng_settings_color_about_channel{ ushort(1169) };
inline constexpr phrase<> lng_settings_color_emoji{ ushort(1170) };
inline constexpr phrase<> lng_settings_color_emoji_remove{ ushort(1171) };
inline constexpr phrase<> lng_settings_color_emoji_off{ ushort(1172) };
inline constexpr phrase<> lng_settings_color_emoji_about{ ushort(1173) };
inline constexpr phrase<> lng_settings_color_emoji_about_channel{ ushort(1174) };
inline constexpr phrase<> lng_settings_color_changed{ ushort(1175) };
inline constexpr phrase<> lng_settings_color_changed_channel{ ushort(1176) };
inline constexpr phrase<> lng_settings_color_changed_profile{ ushort(1177) };
inline constexpr phrase<> lng_settings_color_changed_profile_channel{ ushort(1178) };
inline constexpr phrase<> lng_settings_color_apply{ ushort(1179) };
inline constexpr phrase<> lng_settings_color_wear{ ushort(1180) };
inline constexpr phrase<> lng_settings_color_profile_emoji{ ushort(1181) };
inline constexpr phrase<> lng_settings_color_profile_emoji_channel{ ushort(1182) };
inline constexpr phrase<> lng_settings_color_reset{ ushort(1183) };
inline constexpr phrase<lngtag_link> lng_settings_color_profile_about{ ushort(1184) };
inline constexpr phrase<lngtag_emoji> lng_settings_color_profile_about_link{ ushort(1185) };
inline constexpr phrase<> lng_settings_color_choose_channel{ ushort(1186) };
inline constexpr phrase<> lng_settings_color_choose_group{ ushort(1187) };
inline constexpr phrase<lngtag_count, lngtag_link> lng_settings_color_group_boost_footer{ ushort(1188) };
inline constexpr phrase<> lng_settings_color_group_boost_footer_link{ ushort(1194) };
inline constexpr phrase<> lng_suggest_hide_new_title{ ushort(1195) };
inline constexpr phrase<> lng_suggest_hide_new_about{ ushort(1196) };
inline constexpr phrase<> lng_suggest_hide_new_to_settings{ ushort(1197) };
inline constexpr phrase<> lng_settings_spellchecker{ ushort(1198) };
inline constexpr phrase<> lng_settings_system_spellchecker{ ushort(1199) };
inline constexpr phrase<> lng_settings_custom_spellchecker{ ushort(1200) };
inline constexpr phrase<> lng_settings_auto_download_dictionaries{ ushort(1201) };
inline constexpr phrase<> lng_settings_manage_dictionaries{ ushort(1202) };
inline constexpr phrase<> lng_settings_manage_enabled_dictionary{ ushort(1203) };
inline constexpr phrase<> lng_settings_manage_remove_dictionary{ ushort(1204) };
inline constexpr phrase<> lng_settings_gift_premium{ ushort(1205) };
inline constexpr phrase<> lng_settings_gift_premium_users_confirm{ ushort(1206) };
inline constexpr phrase<lngtag_count> lng_settings_gift_premium_users_error{ ushort(1207) };
inline constexpr phrase<> lng_settings_gift_premium_choose{ ushort(1213) };
inline constexpr phrase<> lng_backgrounds_header{ ushort(1214) };
inline constexpr phrase<> lng_theme_sure_keep{ ushort(1215) };
inline constexpr phrase<lngtag_count> lng_theme_reverting{ ushort(1216) };
inline constexpr phrase<> lng_theme_keep_changes{ ushort(1222) };
inline constexpr phrase<> lng_theme_revert{ ushort(1223) };
inline constexpr phrase<> lng_theme_no_desktop{ ushort(1224) };
inline constexpr phrase<> lng_theme_share{ ushort(1225) };
inline constexpr phrase<> lng_theme_edit{ ushort(1226) };
inline constexpr phrase<> lng_theme_delete{ ushort(1227) };
inline constexpr phrase<> lng_theme_delete_sure{ ushort(1228) };
inline constexpr phrase<> lng_background_header{ ushort(1229) };
inline constexpr phrase<> lng_background_text1{ ushort(1230) };
inline constexpr phrase<> lng_background_text2{ ushort(1231) };
inline constexpr phrase<> lng_background_bad_link{ ushort(1232) };
inline constexpr phrase<> lng_background_share{ ushort(1233) };
inline constexpr phrase<> lng_background_link_copied{ ushort(1234) };
inline constexpr phrase<> lng_background_blur{ ushort(1235) };
inline constexpr phrase<> lng_background_sure_delete{ ushort(1236) };
inline constexpr phrase<lngtag_user> lng_background_other_info{ ushort(1237) };
inline constexpr phrase<> lng_background_other_channel{ ushort(1238) };
inline constexpr phrase<> lng_background_other_group{ ushort(1239) };
inline constexpr phrase<> lng_background_apply1{ ushort(1240) };
inline constexpr phrase<> lng_background_apply2{ ushort(1241) };
inline constexpr phrase<> lng_background_apply_button{ ushort(1242) };
inline constexpr phrase<> lng_background_dimming{ ushort(1243) };
inline constexpr phrase<> lng_background_sure_reset_default{ ushort(1244) };
inline constexpr phrase<> lng_background_reset_default{ ushort(1245) };
inline constexpr phrase<> lng_background_apply_me{ ushort(1246) };
inline constexpr phrase<lngtag_user> lng_background_apply_both{ ushort(1247) };
inline constexpr phrase<> lng_background_apply_channel{ ushort(1248) };
inline constexpr phrase<> lng_background_apply_group{ ushort(1249) };
inline constexpr phrase<> lng_download_path_ask{ ushort(1250) };
inline constexpr phrase<> lng_download_path{ ushort(1251) };
inline constexpr phrase<> lng_download_path_temp{ ushort(1252) };
inline constexpr phrase<> lng_download_path_default{ ushort(1253) };
inline constexpr phrase<> lng_download_path_header{ ushort(1254) };
inline constexpr phrase<> lng_download_path_default_radio{ ushort(1255) };
inline constexpr phrase<> lng_download_path_temp_radio{ ushort(1256) };
inline constexpr phrase<> lng_download_path_dir_radio{ ushort(1257) };
inline constexpr phrase<> lng_download_path_choose{ ushort(1258) };
inline constexpr phrase<> lng_download_path_failed{ ushort(1259) };
inline constexpr phrase<> lng_download_finish_failed{ ushort(1260) };
inline constexpr phrase<> lng_settings_section_privacy{ ushort(1261) };
inline constexpr phrase<> lng_local_storage_title{ ushort(1262) };
inline constexpr phrase<> lng_local_storage_empty{ ushort(1263) };
inline constexpr phrase<lngtag_count> lng_local_storage_image{ ushort(1264) };
inline constexpr phrase<lngtag_count> lng_local_storage_sticker{ ushort(1270) };
inline constexpr phrase<lngtag_count> lng_local_storage_voice{ ushort(1276) };
inline constexpr phrase<lngtag_count> lng_local_storage_round{ ushort(1282) };
inline constexpr phrase<lngtag_count> lng_local_storage_animation{ ushort(1288) };
inline constexpr phrase<> lng_local_storage_media{ ushort(1294) };
inline constexpr phrase<lngtag_size> lng_local_storage_size_limit{ ushort(1295) };
inline constexpr phrase<lngtag_size> lng_local_storage_media_limit{ ushort(1296) };
inline constexpr phrase<lngtag_limit> lng_local_storage_time_limit{ ushort(1297) };
inline constexpr phrase<> lng_local_storage_limit_never{ ushort(1298) };
inline constexpr phrase<> lng_local_storage_summary{ ushort(1299) };
inline constexpr phrase<> lng_local_storage_clear_some{ ushort(1300) };
inline constexpr phrase<> lng_local_storage_clear{ ushort(1301) };
inline constexpr phrase<> lng_local_storage_clearing{ ushort(1302) };
inline constexpr phrase<> lng_passcode_remove_button{ ushort(1303) };
inline constexpr phrase<> lng_passcode_change{ ushort(1304) };
inline constexpr phrase<> lng_passcode_create{ ushort(1305) };
inline constexpr phrase<> lng_passcode_remove{ ushort(1306) };
inline constexpr phrase<> lng_passcode_autolock{ ushort(1307) };
inline constexpr phrase<> lng_passcode_autolock_away{ ushort(1308) };
inline constexpr phrase<> lng_passcode_autolock_inactive{ ushort(1309) };
inline constexpr phrase<lngtag_hours_count, lngtag_minutes_count> lng_passcode_autolock_hours_minutes{ ushort(1310) };
inline constexpr phrase<> lng_passcode_enter_old{ ushort(1311) };
inline constexpr phrase<> lng_passcode_enter_first{ ushort(1312) };
inline constexpr phrase<> lng_passcode_enter_new{ ushort(1313) };
inline constexpr phrase<> lng_passcode_confirm_new{ ushort(1314) };
inline constexpr phrase<> lng_passcode_about{ ushort(1315) };
inline constexpr phrase<> lng_passcode_about1{ ushort(1316) };
inline constexpr phrase<> lng_passcode_about2{ ushort(1317) };
inline constexpr phrase<> lng_passcode_about3{ ushort(1318) };
inline constexpr phrase<> lng_passcode_differ{ ushort(1319) };
inline constexpr phrase<> lng_passcode_wrong{ ushort(1320) };
inline constexpr phrase<> lng_passcode_is_same{ ushort(1321) };
inline constexpr phrase<> lng_passcode_enter{ ushort(1322) };
inline constexpr phrase<> lng_passcode_ph{ ushort(1323) };
inline constexpr phrase<> lng_passcode_submit{ ushort(1324) };
inline constexpr phrase<> lng_passcode_logout{ ushort(1325) };
inline constexpr phrase<> lng_passcode_winhello{ ushort(1326) };
inline constexpr phrase<> lng_passcode_touchid{ ushort(1327) };
inline constexpr phrase<> lng_passcode_applewatch{ ushort(1328) };
inline constexpr phrase<> lng_passcode_systempwd{ ushort(1329) };
inline constexpr phrase<> lng_passcode_winhello_unlock{ ushort(1330) };
inline constexpr phrase<> lng_passcode_touchid_unlock{ ushort(1331) };
inline constexpr phrase<> lng_passcode_create_button{ ushort(1332) };
inline constexpr phrase<> lng_passcode_check_button{ ushort(1333) };
inline constexpr phrase<> lng_passcode_change_button{ ushort(1334) };
inline constexpr phrase<> lng_passcode_create_title{ ushort(1335) };
inline constexpr phrase<> lng_passcode_check_title{ ushort(1336) };
inline constexpr phrase<> lng_passcode_change_title{ ushort(1337) };
inline constexpr phrase<lngtag_email> lng_cloud_password_waiting_code{ ushort(1338) };
inline constexpr phrase<> lng_cloud_password_confirm{ ushort(1339) };
inline constexpr phrase<> lng_cloud_password_change{ ushort(1340) };
inline constexpr phrase<> lng_cloud_password_create{ ushort(1341) };
inline constexpr phrase<> lng_cloud_password_remove{ ushort(1342) };
inline constexpr phrase<> lng_cloud_password_reset_ready{ ushort(1343) };
inline constexpr phrase<> lng_cloud_password_enter_old{ ushort(1344) };
inline constexpr phrase<> lng_cloud_password_enter_first{ ushort(1345) };
inline constexpr phrase<> lng_cloud_password_enter_new{ ushort(1346) };
inline constexpr phrase<> lng_cloud_password_confirm_new{ ushort(1347) };
inline constexpr phrase<> lng_cloud_password_hint{ ushort(1348) };
inline constexpr phrase<> lng_cloud_password_change_hint{ ushort(1349) };
inline constexpr phrase<> lng_cloud_password_bad{ ushort(1350) };
inline constexpr phrase<> lng_cloud_password_email{ ushort(1351) };
inline constexpr phrase<> lng_cloud_password_bad_email{ ushort(1352) };
inline constexpr phrase<> lng_cloud_password_about{ ushort(1353) };
inline constexpr phrase<> lng_cloud_password_about_recover{ ushort(1354) };
inline constexpr phrase<> lng_cloud_password_skip_email{ ushort(1355) };
inline constexpr phrase<> lng_cloud_password_was_set{ ushort(1356) };
inline constexpr phrase<> lng_cloud_password_updated{ ushort(1357) };
inline constexpr phrase<> lng_cloud_password_removed{ ushort(1358) };
inline constexpr phrase<> lng_cloud_password_differ{ ushort(1359) };
inline constexpr phrase<> lng_cloud_password_wrong{ ushort(1360) };
inline constexpr phrase<> lng_cloud_password_is_same{ ushort(1361) };
inline constexpr phrase<> lng_cloud_password_passport_losing{ ushort(1362) };
inline constexpr phrase<> lng_cloud_password_resend{ ushort(1363) };
inline constexpr phrase<> lng_cloud_password_resent{ ushort(1364) };
inline constexpr phrase<> lng_cloud_password_reset_no_email{ ushort(1365) };
inline constexpr phrase<> lng_cloud_password_reset_with_email{ ushort(1366) };
inline constexpr phrase<> lng_cloud_password_reset_ok{ ushort(1367) };
inline constexpr phrase<> lng_cloud_password_reset_cancel_title{ ushort(1368) };
inline constexpr phrase<> lng_cloud_password_reset_cancel_sure{ ushort(1369) };
inline constexpr phrase<lngtag_duration> lng_cloud_password_reset_later{ ushort(1370) };
inline constexpr phrase<> lng_cloud_password_expired{ ushort(1371) };
inline constexpr phrase<> lng_connection_auto_connecting{ ushort(1372) };
inline constexpr phrase<lngtag_transport> lng_connection_auto{ ushort(1373) };
inline constexpr phrase<> lng_connection_proxy_connecting{ ushort(1374) };
inline constexpr phrase<lngtag_transport> lng_connection_proxy{ ushort(1375) };
inline constexpr phrase<> lng_connection_try_ipv6{ ushort(1376) };
inline constexpr phrase<> lng_connection_host_ph{ ushort(1377) };
inline constexpr phrase<> lng_connection_port_ph{ ushort(1378) };
inline constexpr phrase<> lng_connection_user_ph{ ushort(1379) };
inline constexpr phrase<> lng_connection_password_ph{ ushort(1380) };
inline constexpr phrase<> lng_connection_proxy_secret_ph{ ushort(1381) };
inline constexpr phrase<> lng_connection_save{ ushort(1382) };
inline constexpr phrase<> lng_proxy_settings{ ushort(1383) };
inline constexpr phrase<> lng_proxy_disable{ ushort(1384) };
inline constexpr phrase<> lng_proxy_use_system_settings{ ushort(1385) };
inline constexpr phrase<> lng_proxy_use_custom{ ushort(1386) };
inline constexpr phrase<> lng_proxy_use_for_calls{ ushort(1387) };
inline constexpr phrase<> lng_proxy_about{ ushort(1388) };
inline constexpr phrase<> lng_proxy_add{ ushort(1389) };
inline constexpr phrase<> lng_proxy_share{ ushort(1390) };
inline constexpr phrase<> lng_proxy_online{ ushort(1391) };
inline constexpr phrase<> lng_proxy_checking{ ushort(1392) };
inline constexpr phrase<> lng_proxy_connecting{ ushort(1393) };
inline constexpr phrase<lngtag_ping> lng_proxy_available{ ushort(1394) };
inline constexpr phrase<> lng_proxy_unavailable{ ushort(1395) };
inline constexpr phrase<> lng_proxy_edit{ ushort(1396) };
inline constexpr phrase<> lng_proxy_menu_edit{ ushort(1397) };
inline constexpr phrase<> lng_proxy_menu_delete{ ushort(1398) };
inline constexpr phrase<> lng_proxy_menu_restore{ ushort(1399) };
inline constexpr phrase<> lng_proxy_edit_share{ ushort(1400) };
inline constexpr phrase<> lng_proxy_edit_share_qr_box_title{ ushort(1401) };
inline constexpr phrase<> lng_proxy_edit_share_list_button{ ushort(1402) };
inline constexpr phrase<> lng_proxy_edit_share_list_toast{ ushort(1403) };
inline constexpr phrase<> lng_proxy_address_label{ ushort(1404) };
inline constexpr phrase<> lng_proxy_credentials_optional{ ushort(1405) };
inline constexpr phrase<> lng_proxy_credentials{ ushort(1406) };
inline constexpr phrase<> lng_proxy_description{ ushort(1407) };
inline constexpr phrase<> lng_proxy_sponsor{ ushort(1408) };
inline constexpr phrase<> lng_proxy_sponsor_about{ ushort(1409) };
inline constexpr phrase<> lng_proxy_sponsor_warning{ ushort(1410) };
inline constexpr phrase<> lng_proxy_add_from_clipboard{ ushort(1411) };
inline constexpr phrase<> lng_proxy_add_from_clipboard_good_toast{ ushort(1412) };
inline constexpr phrase<> lng_proxy_add_from_clipboard_failed_toast{ ushort(1413) };
inline constexpr phrase<> lng_proxy_add_from_clipboard_existing_toast{ ushort(1414) };
inline constexpr phrase<> lng_badge_psa_default{ ushort(1415) };
inline constexpr phrase<> lng_about_psa_default{ ushort(1416) };
inline constexpr phrase<> lng_tooltip_psa_default{ ushort(1417) };
inline constexpr phrase<> lng_settings_blocked_users{ ushort(1418) };
inline constexpr phrase<> lng_settings_no_blocked_users{ ushort(1419) };
inline constexpr phrase<> lng_settings_show_sessions{ ushort(1420) };
inline constexpr phrase<> lng_settings_export_data{ ushort(1421) };
inline constexpr phrase<> lng_settings_destroy_if{ ushort(1422) };
inline constexpr phrase<> lng_settings_terminate_title{ ushort(1423) };
inline constexpr phrase<> lng_settings_terminate_if{ ushort(1424) };
inline constexpr phrase<> lng_settings_reset_sure{ ushort(1425) };
inline constexpr phrase<> lng_settings_reset_one_sure{ ushort(1426) };
inline constexpr phrase<> lng_settings_reset_button{ ushort(1427) };
inline constexpr phrase<> lng_settings_rename_device{ ushort(1428) };
inline constexpr phrase<> lng_settings_device_name{ ushort(1429) };
inline constexpr phrase<> lng_settings_rename_device_title{ ushort(1430) };
inline constexpr phrase<> lng_settings_manage_local_storage{ ushort(1431) };
inline constexpr phrase<> lng_settings_ask_question{ ushort(1432) };
inline constexpr phrase<> lng_settings_ask_sure{ ushort(1433) };
inline constexpr phrase<> lng_settings_faq_button{ ushort(1434) };
inline constexpr phrase<> lng_settings_ask_ok{ ushort(1435) };
inline constexpr phrase<> lng_settings_faq{ ushort(1436) };
inline constexpr phrase<> lng_settings_faq_subtitle{ ushort(1437) };
inline constexpr phrase<> lng_settings_faq_link{ ushort(1438) };
inline constexpr phrase<> lng_settings_features{ ushort(1439) };
inline constexpr phrase<> lng_settings_credits{ ushort(1440) };
inline constexpr phrase<> lng_settings_currency{ ushort(1441) };
inline constexpr phrase<> lng_settings_logout{ ushort(1442) };
inline constexpr phrase<> lng_sure_logout{ ushort(1443) };
inline constexpr phrase<> lng_settings_need_restart{ ushort(1444) };
inline constexpr phrase<> lng_settings_restart_now{ ushort(1445) };
inline constexpr phrase<> lng_settings_restart_later{ ushort(1446) };
inline constexpr phrase<> lng_settings_passkeys_title{ ushort(1447) };
inline constexpr phrase<> lng_settings_passkeys_about{ ushort(1448) };
inline constexpr phrase<> lng_settings_passkeys_button{ ushort(1449) };
inline constexpr phrase<lngtag_link> lng_settings_passkeys_button_about{ ushort(1450) };
inline constexpr phrase<> lng_settings_passkeys_delete_sure_title{ ushort(1451) };
inline constexpr phrase<> lng_settings_passkeys_delete_sure_about{ ushort(1452) };
inline constexpr phrase<> lng_settings_passkeys_delete_sure_about2{ ushort(1453) };
inline constexpr phrase<> lng_settings_passkeys_none_title{ ushort(1454) };
inline constexpr phrase<> lng_settings_passkeys_none_about{ ushort(1455) };
inline constexpr phrase<> lng_settings_passkeys_none_info1_title{ ushort(1456) };
inline constexpr phrase<> lng_settings_passkeys_none_info1_about{ ushort(1457) };
inline constexpr phrase<> lng_settings_passkeys_none_info2_title{ ushort(1458) };
inline constexpr phrase<> lng_settings_passkeys_none_info2_about{ ushort(1459) };
inline constexpr phrase<> lng_settings_passkeys_none_info3_title{ ushort(1460) };
inline constexpr phrase<> lng_settings_passkeys_none_info3_about{ ushort(1461) };
inline constexpr phrase<> lng_settings_passkeys_none_button{ ushort(1462) };
inline constexpr phrase<> lng_settings_passkeys_none_button_unsupported{ ushort(1463) };
inline constexpr phrase<lngtag_date> lng_settings_passkeys_created{ ushort(1464) };
inline constexpr phrase<lngtag_date> lng_settings_passkeys_last_used{ ushort(1465) };
inline constexpr phrase<> lng_settings_passkeys_unsigned_error{ ushort(1466) };
inline constexpr phrase<> lng_settings_passkey_unknown{ ushort(1467) };
inline constexpr phrase<> lng_settings_quick_dialog_action_title{ ushort(1468) };
inline constexpr phrase<> lng_settings_quick_dialog_action_about{ ushort(1469) };
inline constexpr phrase<> lng_settings_quick_dialog_action_both{ ushort(1470) };
inline constexpr phrase<> lng_settings_quick_dialog_action_swipe{ ushort(1471) };
inline constexpr phrase<> lng_settings_quick_dialog_action_mute{ ushort(1472) };
inline constexpr phrase<> lng_settings_quick_dialog_action_unmute{ ushort(1473) };
inline constexpr phrase<> lng_settings_quick_dialog_action_pin{ ushort(1474) };
inline constexpr phrase<> lng_settings_quick_dialog_action_unpin{ ushort(1475) };
inline constexpr phrase<> lng_settings_quick_dialog_action_read{ ushort(1476) };
inline constexpr phrase<> lng_settings_quick_dialog_action_unread{ ushort(1477) };
inline constexpr phrase<> lng_settings_quick_dialog_action_archive{ ushort(1478) };
inline constexpr phrase<> lng_settings_quick_dialog_action_unarchive{ ushort(1479) };
inline constexpr phrase<> lng_settings_quick_dialog_action_delete{ ushort(1480) };
inline constexpr phrase<> lng_settings_quick_dialog_action_disabled{ ushort(1481) };
inline constexpr phrase<> lng_quick_dialog_action_toast_mute_success{ ushort(1482) };
inline constexpr phrase<> lng_quick_dialog_action_toast_unmute_success{ ushort(1483) };
inline constexpr phrase<> lng_quick_dialog_action_toast_pin_success{ ushort(1484) };
inline constexpr phrase<> lng_quick_dialog_action_toast_unpin_success{ ushort(1485) };
inline constexpr phrase<> lng_quick_dialog_action_toast_read_success{ ushort(1486) };
inline constexpr phrase<> lng_quick_dialog_action_toast_unread_success{ ushort(1487) };
inline constexpr phrase<> lng_quick_dialog_action_toast_archive_success{ ushort(1488) };
inline constexpr phrase<> lng_quick_dialog_action_toast_unarchive_success{ ushort(1489) };
inline constexpr phrase<> lng_archive_hint_title{ ushort(1490) };
inline constexpr phrase<lngtag_link> lng_archive_hint_about{ ushort(1491) };
inline constexpr phrase<lngtag_link> lng_archive_hint_about_unmuted{ ushort(1492) };
inline constexpr phrase<lngtag_emoji> lng_archive_hint_about_link{ ushort(1493) };
inline constexpr phrase<> lng_archive_hint_section_1{ ushort(1494) };
inline constexpr phrase<> lng_archive_hint_section_1_info{ ushort(1495) };
inline constexpr phrase<> lng_archive_hint_section_2{ ushort(1496) };
inline constexpr phrase<> lng_archive_hint_section_2_info{ ushort(1497) };
inline constexpr phrase<> lng_archive_hint_section_3{ ushort(1498) };
inline constexpr phrase<> lng_archive_hint_section_3_info{ ushort(1499) };
inline constexpr phrase<> lng_archive_hint_button{ ushort(1500) };
inline constexpr phrase<lngtag_link> lng_settings_generic_subscribe{ ushort(1501) };
inline constexpr phrase<> lng_settings_generic_subscribe_link{ ushort(1502) };
inline constexpr phrase<> lng_sessions_header{ ushort(1503) };
inline constexpr phrase<> lng_sessions_other_header{ ushort(1504) };
inline constexpr phrase<> lng_sessions_other_desc{ ushort(1505) };
inline constexpr phrase<> lng_sessions_terminate_all{ ushort(1506) };
inline constexpr phrase<> lng_sessions_terminate_all_about{ ushort(1507) };
inline constexpr phrase<> lng_sessions_incomplete{ ushort(1508) };
inline constexpr phrase<> lng_sessions_incomplete_about{ ushort(1509) };
inline constexpr phrase<> lng_sessions_info{ ushort(1510) };
inline constexpr phrase<> lng_sessions_terminate{ ushort(1511) };
inline constexpr phrase<> lng_sessions_application{ ushort(1512) };
inline constexpr phrase<> lng_sessions_system{ ushort(1513) };
inline constexpr phrase<> lng_sessions_browser{ ushort(1514) };
inline constexpr phrase<> lng_sessions_ip{ ushort(1515) };
inline constexpr phrase<> lng_sessions_location{ ushort(1516) };
inline constexpr phrase<> lng_sessions_location_about{ ushort(1517) };
inline constexpr phrase<> lng_sessions_about_apps{ ushort(1518) };
inline constexpr phrase<> lng_blocked_list_title{ ushort(1519) };
inline constexpr phrase<> lng_blocked_list_unknown_phone{ ushort(1520) };
inline constexpr phrase<> lng_blocked_list_unblock{ ushort(1521) };
inline constexpr phrase<> lng_blocked_list_add{ ushort(1522) };
inline constexpr phrase<> lng_blocked_list_add_title{ ushort(1523) };
inline constexpr phrase<> lng_blocked_list_already_blocked{ ushort(1524) };
inline constexpr phrase<> lng_blocked_list_about{ ushort(1525) };
inline constexpr phrase<> lng_blocked_list_not_found{ ushort(1526) };
inline constexpr phrase<lngtag_name> lng_blocked_list_confirm_title{ ushort(1527) };
inline constexpr phrase<lngtag_name> lng_blocked_list_confirm_text{ ushort(1528) };
inline constexpr phrase<> lng_blocked_list_confirm_clear{ ushort(1529) };
inline constexpr phrase<> lng_blocked_list_confirm_ok{ ushort(1530) };
inline constexpr phrase<> lng_blocked_list_empty_title{ ushort(1531) };
inline constexpr phrase<> lng_blocked_list_empty_description{ ushort(1532) };
inline constexpr phrase<lngtag_count> lng_blocked_list_subtitle{ ushort(1533) };
inline constexpr phrase<> lng_edit_privacy_everyone{ ushort(1539) };
inline constexpr phrase<> lng_edit_privacy_no_miniapps{ ushort(1540) };
inline constexpr phrase<> lng_edit_privacy_contacts{ ushort(1541) };
inline constexpr phrase<> lng_edit_privacy_close_friends{ ushort(1542) };
inline constexpr phrase<> lng_edit_privacy_contacts_and_premium{ ushort(1543) };
inline constexpr phrase<> lng_edit_privacy_paid{ ushort(1544) };
inline constexpr phrase<> lng_edit_privacy_contacts_and_miniapps{ ushort(1545) };
inline constexpr phrase<> lng_edit_privacy_nobody{ ushort(1546) };
inline constexpr phrase<> lng_edit_privacy_premium{ ushort(1547) };
inline constexpr phrase<> lng_edit_privacy_miniapps{ ushort(1548) };
inline constexpr phrase<> lng_edit_privacy_exceptions{ ushort(1549) };
inline constexpr phrase<> lng_edit_privacy_user_types{ ushort(1550) };
inline constexpr phrase<> lng_edit_privacy_users_and_groups{ ushort(1551) };
inline constexpr phrase<> lng_edit_privacy_premium_status{ ushort(1552) };
inline constexpr phrase<> lng_edit_privacy_miniapps_status{ ushort(1553) };
inline constexpr phrase<lngtag_count> lng_edit_privacy_exceptions_count{ ushort(1554) };
inline constexpr phrase<lngtag_users> lng_edit_privacy_exceptions_premium_and{ ushort(1560) };
inline constexpr phrase<lngtag_users> lng_edit_privacy_exceptions_miniapps_and{ ushort(1561) };
inline constexpr phrase<> lng_edit_privacy_exceptions_add{ ushort(1562) };
inline constexpr phrase<> lng_edit_privacy_phone_number_title{ ushort(1563) };
inline constexpr phrase<> lng_edit_privacy_phone_number_header{ ushort(1564) };
inline constexpr phrase<> lng_edit_privacy_phone_number_warning{ ushort(1565) };
inline constexpr phrase<> lng_edit_privacy_phone_number_always_empty{ ushort(1566) };
inline constexpr phrase<> lng_edit_privacy_phone_number_never_empty{ ushort(1567) };
inline constexpr phrase<> lng_edit_privacy_phone_number_exceptions{ ushort(1568) };
inline constexpr phrase<> lng_edit_privacy_phone_number_always_title{ ushort(1569) };
inline constexpr phrase<> lng_edit_privacy_phone_number_never_title{ ushort(1570) };
inline constexpr phrase<> lng_edit_privacy_phone_number_find{ ushort(1571) };
inline constexpr phrase<> lng_edit_privacy_phone_number_contacts{ ushort(1572) };
inline constexpr phrase<> lng_edit_privacy_lastseen_title{ ushort(1573) };
inline constexpr phrase<> lng_edit_privacy_lastseen_header{ ushort(1574) };
inline constexpr phrase<> lng_edit_privacy_lastseen_warning{ ushort(1575) };
inline constexpr phrase<> lng_edit_privacy_lastseen_always_empty{ ushort(1576) };
inline constexpr phrase<> lng_edit_privacy_lastseen_never_empty{ ushort(1577) };
inline constexpr phrase<> lng_edit_privacy_lastseen_exceptions{ ushort(1578) };
inline constexpr phrase<> lng_edit_privacy_lastseen_always_title{ ushort(1579) };
inline constexpr phrase<> lng_edit_privacy_lastseen_never_title{ ushort(1580) };
inline constexpr phrase<> lng_edit_lastseen_hide_read_time{ ushort(1581) };
inline constexpr phrase<> lng_edit_lastseen_hide_read_time_about{ ushort(1582) };
inline constexpr phrase<> lng_edit_lastseen_subscribe{ ushort(1583) };
inline constexpr phrase<> lng_edit_lastseen_subscribe_about{ ushort(1584) };
inline constexpr phrase<> lng_edit_privacy_groups_title{ ushort(1585) };
inline constexpr phrase<> lng_edit_privacy_groups_header{ ushort(1586) };
inline constexpr phrase<> lng_edit_privacy_groups_always_empty{ ushort(1587) };
inline constexpr phrase<> lng_edit_privacy_groups_never_empty{ ushort(1588) };
inline constexpr phrase<> lng_edit_privacy_groups_exceptions{ ushort(1589) };
inline constexpr phrase<> lng_edit_privacy_groups_always_title{ ushort(1590) };
inline constexpr phrase<> lng_edit_privacy_groups_never_title{ ushort(1591) };
inline constexpr phrase<> lng_edit_privacy_about_title{ ushort(1592) };
inline constexpr phrase<> lng_edit_privacy_about_header{ ushort(1593) };
inline constexpr phrase<> lng_edit_privacy_about_always_empty{ ushort(1594) };
inline constexpr phrase<> lng_edit_privacy_about_never_empty{ ushort(1595) };
inline constexpr phrase<> lng_edit_privacy_about_exceptions{ ushort(1596) };
inline constexpr phrase<> lng_edit_privacy_about_always_title{ ushort(1597) };
inline constexpr phrase<> lng_edit_privacy_about_never_title{ ushort(1598) };
inline constexpr phrase<> lng_edit_privacy_birthday_title{ ushort(1599) };
inline constexpr phrase<> lng_edit_privacy_birthday_header{ ushort(1600) };
inline constexpr phrase<> lng_edit_privacy_birthday_always_empty{ ushort(1601) };
inline constexpr phrase<> lng_edit_privacy_birthday_never_empty{ ushort(1602) };
inline constexpr phrase<> lng_edit_privacy_birthday_exceptions{ ushort(1603) };
inline constexpr phrase<> lng_edit_privacy_birthday_always_title{ ushort(1604) };
inline constexpr phrase<> lng_edit_privacy_birthday_never_title{ ushort(1605) };
inline constexpr phrase<lngtag_link> lng_edit_privacy_birthday_yet{ ushort(1606) };
inline constexpr phrase<> lng_edit_privacy_birthday_yet_link{ ushort(1607) };
inline constexpr phrase<> lng_edit_privacy_gifts_title{ ushort(1608) };
inline constexpr phrase<> lng_edit_privacy_gifts_header{ ushort(1609) };
inline constexpr phrase<> lng_edit_privacy_gifts_always_empty{ ushort(1610) };
inline constexpr phrase<> lng_edit_privacy_gifts_never_empty{ ushort(1611) };
inline constexpr phrase<> lng_edit_privacy_gifts_exceptions{ ushort(1612) };
inline constexpr phrase<> lng_edit_privacy_gifts_always_title{ ushort(1613) };
inline constexpr phrase<> lng_edit_privacy_gifts_never_title{ ushort(1614) };
inline constexpr phrase<> lng_edit_privacy_gifts_types{ ushort(1615) };
inline constexpr phrase<> lng_edit_privacy_gifts_premium{ ushort(1616) };
inline constexpr phrase<> lng_edit_privacy_gifts_unlimited{ ushort(1617) };
inline constexpr phrase<> lng_edit_privacy_gifts_limited{ ushort(1618) };
inline constexpr phrase<> lng_edit_privacy_gifts_unique{ ushort(1619) };
inline constexpr phrase<> lng_edit_privacy_gifts_channels{ ushort(1620) };
inline constexpr phrase<> lng_edit_privacy_gifts_types_about{ ushort(1621) };
inline constexpr phrase<> lng_edit_privacy_gifts_show_icon{ ushort(1622) };
inline constexpr phrase<lngtag_emoji> lng_edit_privacy_gifts_show_icon_about{ ushort(1623) };
inline constexpr phrase<> lng_edit_privacy_gifts_restricted{ ushort(1624) };
inline constexpr phrase<> lng_edit_privacy_calls_title{ ushort(1625) };
inline constexpr phrase<> lng_edit_privacy_calls_header{ ushort(1626) };
inline constexpr phrase<> lng_edit_privacy_calls_always_empty{ ushort(1627) };
inline constexpr phrase<> lng_edit_privacy_calls_never_empty{ ushort(1628) };
inline constexpr phrase<> lng_edit_privacy_calls_exceptions{ ushort(1629) };
inline constexpr phrase<> lng_edit_privacy_calls_always_title{ ushort(1630) };
inline constexpr phrase<> lng_edit_privacy_calls_never_title{ ushort(1631) };
inline constexpr phrase<> lng_edit_privacy_calls_p2p_title{ ushort(1632) };
inline constexpr phrase<> lng_edit_privacy_calls_p2p_header{ ushort(1633) };
inline constexpr phrase<> lng_edit_privacy_calls_p2p_always_empty{ ushort(1634) };
inline constexpr phrase<> lng_edit_privacy_calls_p2p_never_empty{ ushort(1635) };
inline constexpr phrase<> lng_edit_privacy_calls_p2p_exceptions{ ushort(1636) };
inline constexpr phrase<> lng_edit_privacy_calls_p2p_always_title{ ushort(1637) };
inline constexpr phrase<> lng_edit_privacy_calls_p2p_never_title{ ushort(1638) };
inline constexpr phrase<> lng_edit_privacy_calls_p2p_everyone{ ushort(1639) };
inline constexpr phrase<> lng_edit_privacy_calls_p2p_contacts{ ushort(1640) };
inline constexpr phrase<> lng_edit_privacy_calls_p2p_nobody{ ushort(1641) };
inline constexpr phrase<> lng_edit_privacy_forwards_title{ ushort(1642) };
inline constexpr phrase<> lng_edit_privacy_forwards_header{ ushort(1643) };
inline constexpr phrase<> lng_edit_privacy_forwards_warning{ ushort(1644) };
inline constexpr phrase<> lng_edit_privacy_forwards_always_empty{ ushort(1645) };
inline constexpr phrase<> lng_edit_privacy_forwards_never_empty{ ushort(1646) };
inline constexpr phrase<> lng_edit_privacy_forwards_exceptions{ ushort(1647) };
inline constexpr phrase<> lng_edit_privacy_forwards_exceptions_everyone{ ushort(1648) };
inline constexpr phrase<> lng_edit_privacy_forwards_exceptions_nobody{ ushort(1649) };
inline constexpr phrase<> lng_edit_privacy_forwards_always_title{ ushort(1650) };
inline constexpr phrase<> lng_edit_privacy_forwards_never_title{ ushort(1651) };
inline constexpr phrase<> lng_edit_privacy_forwards_sample_message{ ushort(1652) };
inline constexpr phrase<> lng_edit_privacy_forwards_sample_everyone{ ushort(1653) };
inline constexpr phrase<> lng_edit_privacy_forwards_sample_contacts{ ushort(1654) };
inline constexpr phrase<> lng_edit_privacy_forwards_sample_nobody{ ushort(1655) };
inline constexpr phrase<> lng_edit_privacy_profile_photo_title{ ushort(1656) };
inline constexpr phrase<> lng_edit_privacy_profile_photo_header{ ushort(1657) };
inline constexpr phrase<> lng_edit_privacy_profile_photo_always_empty{ ushort(1658) };
inline constexpr phrase<> lng_edit_privacy_profile_photo_never_empty{ ushort(1659) };
inline constexpr phrase<> lng_edit_privacy_profile_photo_always_title{ ushort(1660) };
inline constexpr phrase<> lng_edit_privacy_profile_photo_never_title{ ushort(1661) };
inline constexpr phrase<> lng_edit_privacy_profile_photo_public_set{ ushort(1662) };
inline constexpr phrase<> lng_edit_privacy_profile_photo_public_update{ ushort(1663) };
inline constexpr phrase<> lng_edit_privacy_profile_photo_public_remove{ ushort(1664) };
inline constexpr phrase<> lng_edit_privacy_profile_photo_public_about{ ushort(1665) };
inline constexpr phrase<> lng_edit_privacy_voices_title{ ushort(1666) };
inline constexpr phrase<> lng_edit_privacy_voices_header{ ushort(1667) };
inline constexpr phrase<> lng_edit_privacy_voices_always_empty{ ushort(1668) };
inline constexpr phrase<> lng_edit_privacy_voices_never_empty{ ushort(1669) };
inline constexpr phrase<> lng_edit_privacy_voices_exceptions{ ushort(1670) };
inline constexpr phrase<> lng_edit_privacy_voices_always_title{ ushort(1671) };
inline constexpr phrase<> lng_edit_privacy_voices_never_title{ ushort(1672) };
inline constexpr phrase<> lng_edit_privacy_saved_music_title{ ushort(1673) };
inline constexpr phrase<> lng_edit_privacy_saved_music_header{ ushort(1674) };
inline constexpr phrase<> lng_edit_privacy_saved_music_always_empty{ ushort(1675) };
inline constexpr phrase<> lng_edit_privacy_saved_music_never_empty{ ushort(1676) };
inline constexpr phrase<> lng_edit_privacy_saved_music_exceptions{ ushort(1677) };
inline constexpr phrase<> lng_edit_privacy_saved_music_always_title{ ushort(1678) };
inline constexpr phrase<> lng_edit_privacy_saved_music_never_title{ ushort(1679) };
inline constexpr phrase<> lng_messages_privacy_title{ ushort(1680) };
inline constexpr phrase<> lng_messages_privacy_subtitle{ ushort(1681) };
inline constexpr phrase<> lng_messages_privacy_everyone{ ushort(1682) };
inline constexpr phrase<> lng_messages_privacy_restricted{ ushort(1683) };
inline constexpr phrase<> lng_messages_privacy_about{ ushort(1684) };
inline constexpr phrase<> lng_messages_privacy_premium_button{ ushort(1685) };
inline constexpr phrase<> lng_messages_privacy_premium_about{ ushort(1686) };
inline constexpr phrase<lngtag_link> lng_messages_privacy_premium{ ushort(1687) };
inline constexpr phrase<> lng_messages_privacy_premium_link{ ushort(1688) };
inline constexpr phrase<> lng_messages_privacy_charge{ ushort(1689) };
inline constexpr phrase<> lng_messages_privacy_charge_about{ ushort(1690) };
inline constexpr phrase<> lng_messages_privacy_price{ ushort(1691) };
inline constexpr phrase<lngtag_percent, lngtag_amount> lng_messages_privacy_price_about{ ushort(1692) };
inline constexpr phrase<> lng_messages_privacy_exceptions{ ushort(1693) };
inline constexpr phrase<> lng_messages_privacy_remove_fee{ ushort(1694) };
inline constexpr phrase<> lng_messages_privacy_remove_about{ ushort(1695) };
inline constexpr phrase<> lng_self_destruct_title{ ushort(1696) };
inline constexpr phrase<> lng_self_destruct_description{ ushort(1697) };
inline constexpr phrase<> lng_self_destruct_sessions_title{ ushort(1698) };
inline constexpr phrase<> lng_self_destruct_sessions_description{ ushort(1699) };
inline constexpr phrase<> lng_change_phone_new_submit{ ushort(1700) };
inline constexpr phrase<> lng_change_phone_code_title{ ushort(1701) };
inline constexpr phrase<> lng_change_phone_error{ ushort(1702) };
inline constexpr phrase<> lng_mute_menu_mute{ ushort(1703) };
inline constexpr phrase<> lng_mute_menu_unmute{ ushort(1704) };
inline constexpr phrase<lngtag_duration> lng_mute_menu_duration_any{ ushort(1705) };
inline constexpr phrase<> lng_mute_menu_duration{ ushort(1706) };
inline constexpr phrase<> lng_mute_menu_duration_forever{ ushort(1707) };
inline constexpr phrase<> lng_mute_menu_duration_unmute{ ushort(1708) };
inline constexpr phrase<> lng_mute_menu_sound_on{ ushort(1709) };
inline constexpr phrase<> lng_mute_menu_sound_off{ ushort(1710) };
inline constexpr phrase<> lng_mute_menu_sound_select{ ushort(1711) };
inline constexpr phrase<> lng_mute_box_title{ ushort(1712) };
inline constexpr phrase<> lng_preview_loading{ ushort(1713) };
inline constexpr phrase<> lng_preview_cant{ ushort(1714) };
inline constexpr phrase<> lng_profile_settings_section{ ushort(1715) };
inline constexpr phrase<> lng_profile_bot_settings{ ushort(1716) };
inline constexpr phrase<> lng_profile_bot_help{ ushort(1717) };
inline constexpr phrase<> lng_profile_bot_privacy{ ushort(1718) };
inline constexpr phrase<> lng_profile_bot_privacy_url{ ushort(1719) };
inline constexpr phrase<lngtag_count> lng_profile_common_groups{ ushort(1720) };
inline constexpr phrase<lngtag_count> lng_profile_similar_channels{ ushort(1726) };
inline constexpr phrase<lngtag_count> lng_profile_similar_bots{ ushort(1732) };
inline constexpr phrase<lngtag_count> lng_profile_saved_messages{ ushort(1738) };
inline constexpr phrase<lngtag_count> lng_profile_peer_gifts{ ushort(1744) };
inline constexpr phrase<> lng_profile_participants_section{ ushort(1750) };
inline constexpr phrase<> lng_profile_subscribers_section{ ushort(1751) };
inline constexpr phrase<> lng_profile_add_contact{ ushort(1752) };
inline constexpr phrase<> lng_profile_clear_and_exit{ ushort(1753) };
inline constexpr phrase<> lng_profile_leave_channel{ ushort(1754) };
inline constexpr phrase<> lng_profile_delete_channel{ ushort(1755) };
inline constexpr phrase<> lng_profile_leave_group{ ushort(1756) };
inline constexpr phrase<> lng_profile_delete_group{ ushort(1757) };
inline constexpr phrase<> lng_profile_report{ ushort(1758) };
inline constexpr phrase<> lng_profile_block_bot{ ushort(1759) };
inline constexpr phrase<> lng_profile_restart_bot{ ushort(1760) };
inline constexpr phrase<> lng_profile_invite_to_group{ ushort(1761) };
inline constexpr phrase<> lng_profile_add_bot_as_admin{ ushort(1762) };
inline constexpr phrase<> lng_profile_invite_to_channel{ ushort(1763) };
inline constexpr phrase<> lng_profile_invite_to_group_about{ ushort(1764) };
inline constexpr phrase<> lng_profile_invite_to_channel_about{ ushort(1765) };
inline constexpr phrase<> lng_profile_add_bot_as_admin_about{ ushort(1766) };
inline constexpr phrase<> lng_profile_add_participant{ ushort(1767) };
inline constexpr phrase<> lng_profile_add_via_link{ ushort(1768) };
inline constexpr phrase<> lng_profile_hide_participants{ ushort(1769) };
inline constexpr phrase<> lng_profile_hide_participants_about{ ushort(1770) };
inline constexpr phrase<> lng_profile_view_channel{ ushort(1771) };
inline constexpr phrase<> lng_profile_view_discussion{ ushort(1772) };
inline constexpr phrase<> lng_profile_direct_messages{ ushort(1773) };
inline constexpr phrase<> lng_profile_join_channel{ ushort(1774) };
inline constexpr phrase<> lng_profile_join_group{ ushort(1775) };
inline constexpr phrase<> lng_profile_apply_to_join_group{ ushort(1776) };
inline constexpr phrase<> lng_profile_kick{ ushort(1777) };
inline constexpr phrase<> lng_profile_delete_removed{ ushort(1778) };
inline constexpr phrase<lngtag_user> lng_profile_sure_kick{ ushort(1779) };
inline constexpr phrase<lngtag_user> lng_profile_sure_kick_channel{ ushort(1780) };
inline constexpr phrase<lngtag_user> lng_profile_sure_remove_admin{ ushort(1781) };
inline constexpr phrase<> lng_profile_loading{ ushort(1782) };
inline constexpr phrase<lngtag_count> lng_profile_saved_stories{ ushort(1783) };
inline constexpr phrase<lngtag_count> lng_profile_posts{ ushort(1789) };
inline constexpr phrase<lngtag_count> lng_profile_photos{ ushort(1795) };
inline constexpr phrase<lngtag_count> lng_profile_gifs{ ushort(1801) };
inline constexpr phrase<lngtag_count> lng_profile_videos{ ushort(1807) };
inline constexpr phrase<lngtag_count> lng_profile_songs{ ushort(1813) };
inline constexpr phrase<lngtag_count> lng_profile_files{ ushort(1819) };
inline constexpr phrase<lngtag_count> lng_profile_audios{ ushort(1825) };
inline constexpr phrase<lngtag_count> lng_profile_shared_links{ ushort(1831) };
inline constexpr phrase<> lng_profile_copy_phone{ ushort(1837) };
inline constexpr phrase<> lng_profile_copy_fullname{ ushort(1838) };
inline constexpr phrase<> lng_profile_photo_by_you{ ushort(1839) };
inline constexpr phrase<> lng_profile_public_photo{ ushort(1840) };
inline constexpr phrase<lngtag_count> lng_profile_administrators{ ushort(1841) };
inline constexpr phrase<> lng_profile_manage{ ushort(1847) };
inline constexpr phrase<lngtag_name> lng_profile_topic_toast{ ushort(1848) };
inline constexpr phrase<> lng_invite_upgrade_title{ ushort(1849) };
inline constexpr phrase<lngtag_count, lngtag_users> lng_invite_upgrade_group_invite{ ushort(1850) };
inline constexpr phrase<lngtag_count, lngtag_users> lng_invite_upgrade_group_write{ ushort(1856) };
inline constexpr phrase<lngtag_count, lngtag_users> lng_invite_upgrade_channel_invite{ ushort(1862) };
inline constexpr phrase<lngtag_count, lngtag_users> lng_invite_upgrade_channel_write{ ushort(1868) };
inline constexpr phrase<lngtag_users, lngtag_last> lng_invite_upgrade_users_few{ ushort(1874) };
inline constexpr phrase<lngtag_count, lngtag_users> lng_invite_upgrade_users_many{ ushort(1875) };
inline constexpr phrase<> lng_invite_upgrade_or{ ushort(1881) };
inline constexpr phrase<> lng_invite_upgrade_via_title{ ushort(1882) };
inline constexpr phrase<> lng_invite_upgrade_via_group_about{ ushort(1883) };
inline constexpr phrase<> lng_invite_upgrade_via_channel_about{ ushort(1884) };
inline constexpr phrase<> lng_invite_status_disabled{ ushort(1885) };
inline constexpr phrase<> lng_leave_next_owner_box_title{ ushort(1886) };
inline constexpr phrase<> lng_leave_next_owner_box_title_group{ ushort(1887) };
inline constexpr phrase<lngtag_user, lngtag_chat> lng_leave_next_owner_box_about{ ushort(1888) };
inline constexpr phrase<lngtag_user, lngtag_chat> lng_leave_next_owner_box_about_admin{ ushort(1889) };
inline constexpr phrase<> lng_select_next_owner_box{ ushort(1890) };
inline constexpr phrase<> lng_select_next_owner_box_admin{ ushort(1891) };
inline constexpr phrase<> lng_select_next_owner_box_title{ ushort(1892) };
inline constexpr phrase<> lng_select_next_owner_box_title_admin{ ushort(1893) };
inline constexpr phrase<> lng_select_next_owner_box_confirm{ ushort(1894) };
inline constexpr phrase<> lng_select_next_owner_box_sub_admins{ ushort(1895) };
inline constexpr phrase<> lng_select_next_owner_box_sub_admins_group{ ushort(1896) };
inline constexpr phrase<> lng_select_next_owner_box_sub_members{ ushort(1897) };
inline constexpr phrase<> lng_select_next_owner_box_sub_members_group{ ushort(1898) };
inline constexpr phrase<lngtag_date> lng_select_next_owner_box_status_joined{ ushort(1899) };
inline constexpr phrase<lngtag_date> lng_select_next_owner_box_status_promoted{ ushort(1900) };
inline constexpr phrase<> lng_select_next_owner_box_empty_list{ ushort(1901) };
inline constexpr phrase<> lng_select_next_owner_box_empty_list_admin{ ushort(1902) };
inline constexpr phrase<lngtag_user> lng_via_link_group_one{ ushort(1903) };
inline constexpr phrase<lngtag_count> lng_via_link_group_many{ ushort(1904) };
inline constexpr phrase<lngtag_user> lng_via_link_channel_one{ ushort(1910) };
inline constexpr phrase<lngtag_count> lng_via_link_channel_many{ ushort(1911) };
inline constexpr phrase<> lng_via_link_send{ ushort(1917) };
inline constexpr phrase<> lng_via_link_cant{ ushort(1918) };
inline constexpr phrase<lngtag_user> lng_via_link_cant_one{ ushort(1919) };
inline constexpr phrase<lngtag_count> lng_via_link_cant_many{ ushort(1920) };
inline constexpr phrase<lngtag_user> lng_via_link_shared_one{ ushort(1926) };
inline constexpr phrase<lngtag_count> lng_via_link_shared_many{ ushort(1927) };
inline constexpr phrase<> lng_info_personal_channel_label{ ushort(1933) };
inline constexpr phrase<> lng_info_mobile_label{ ushort(1934) };
inline constexpr phrase<lngtag_link> lng_info_mobile_context_menu_fragment_about{ ushort(1935) };
inline constexpr phrase<> lng_info_mobile_context_menu_fragment_about_link{ ushort(1936) };
inline constexpr phrase<> lng_info_mobile_hidden{ ushort(1937) };
inline constexpr phrase<> lng_info_username_label{ ushort(1938) };
inline constexpr phrase<> lng_info_usernames_label{ ushort(1939) };
inline constexpr phrase<> lng_info_birthday_label{ ushort(1940) };
inline constexpr phrase<lngtag_count, lngtag_date> lng_info_birthday_years{ ushort(1941) };
inline constexpr phrase<lngtag_count, lngtag_date> lng_info_birthday_today_years{ ushort(1947) };
inline constexpr phrase<> lng_info_birthday_today_label{ ushort(1953) };
inline constexpr phrase<lngtag_emoji, lngtag_date> lng_info_birthday_today{ ushort(1954) };
inline constexpr phrase<> lng_info_notes_label{ ushort(1955) };
inline constexpr phrase<> lng_info_notes_private{ ushort(1956) };
inline constexpr phrase<> lng_edit_note{ ushort(1957) };
inline constexpr phrase<> lng_delete_note{ ushort(1958) };
inline constexpr phrase<> lng_info_bio_label{ ushort(1959) };
inline constexpr phrase<> lng_info_link_label{ ushort(1960) };
inline constexpr phrase<> lng_info_link_topic_label{ ushort(1961) };
inline constexpr phrase<> lng_info_location_label{ ushort(1962) };
inline constexpr phrase<> lng_info_about_label{ ushort(1963) };
inline constexpr phrase<> lng_info_work_open{ ushort(1964) };
inline constexpr phrase<> lng_info_work_closed{ ushort(1965) };
inline constexpr phrase<> lng_info_hours_label{ ushort(1966) };
inline constexpr phrase<> lng_info_hours_closed{ ushort(1967) };
inline constexpr phrase<lngtag_count> lng_info_hours_opens_in_minutes{ ushort(1968) };
inline constexpr phrase<lngtag_count> lng_info_hours_opens_in_hours{ ushort(1974) };
inline constexpr phrase<lngtag_count> lng_info_hours_opens_in_days{ ushort(1980) };
inline constexpr phrase<> lng_info_hours_open_full{ ushort(1986) };
inline constexpr phrase<lngtag_time> lng_info_hours_next_day{ ushort(1987) };
inline constexpr phrase<> lng_info_hours_local_time{ ushort(1988) };
inline constexpr phrase<> lng_info_hours_my_time{ ushort(1989) };
inline constexpr phrase<> lng_info_user_title{ ushort(1990) };
inline constexpr phrase<> lng_info_bot_title{ ushort(1991) };
inline constexpr phrase<> lng_info_group_title{ ushort(1992) };
inline constexpr phrase<> lng_info_channel_title{ ushort(1993) };
inline constexpr phrase<> lng_info_topic_title{ ushort(1994) };
inline constexpr phrase<> lng_info_thread_title{ ushort(1995) };
inline constexpr phrase<> lng_profile_enable_notifications{ ushort(1996) };
inline constexpr phrase<> lng_profile_send_message{ ushort(1997) };
inline constexpr phrase<> lng_profile_open_app{ ushort(1998) };
inline constexpr phrase<> lng_profile_open_app_short{ ushort(1999) };
inline constexpr phrase<lngtag_terms> lng_profile_open_app_about{ ushort(2000) };
inline constexpr phrase<> lng_profile_open_app_terms{ ushort(2001) };
inline constexpr phrase<> lng_profile_open_photo{ ushort(2002) };
inline constexpr phrase<> lng_profile_bot_permissions_title{ ushort(2003) };
inline constexpr phrase<> lng_profile_bot_emoji_status_access{ ushort(2004) };
inline constexpr phrase<> lng_info_add_as_contact{ ushort(2005) };
inline constexpr phrase<> lng_profile_shared_media{ ushort(2006) };
inline constexpr phrase<> lng_profile_suggest_photo{ ushort(2007) };
inline constexpr phrase<> lng_profile_suggest_photo_from_clipboard{ ushort(2008) };
inline constexpr phrase<> lng_profile_set_photo_for{ ushort(2009) };
inline constexpr phrase<> lng_profile_set_photo_for_group{ ushort(2010) };
inline constexpr phrase<> lng_profile_set_photo_for_channel{ ushort(2011) };
inline constexpr phrase<> lng_profile_set_photo_for_from_clipboard{ ushort(2012) };
inline constexpr phrase<lngtag_user> lng_profile_set_photo_for_about{ ushort(2013) };
inline constexpr phrase<> lng_profile_photo_reset{ ushort(2014) };
inline constexpr phrase<> lng_profile_photo_reset_button{ ushort(2015) };
inline constexpr phrase<lngtag_user> lng_profile_photo_reset_sure{ ushort(2016) };
inline constexpr phrase<> lng_profile_photo_from_clipboard{ ushort(2017) };
inline constexpr phrase<lngtag_user> lng_profile_suggest_sure{ ushort(2018) };
inline constexpr phrase<> lng_profile_suggest_button{ ushort(2019) };
inline constexpr phrase<lngtag_user> lng_profile_set_personal_sure{ ushort(2020) };
inline constexpr phrase<lngtag_user> lng_profile_accept_photo_sure{ ushort(2021) };
inline constexpr phrase<> lng_profile_set_photo_button{ ushort(2022) };
inline constexpr phrase<lngtag_user> lng_profile_accept_video_sure{ ushort(2023) };
inline constexpr phrase<> lng_profile_set_video_button{ ushort(2024) };
inline constexpr phrase<> lng_profile_changed_photo_title{ ushort(2025) };
inline constexpr phrase<lngtag_link> lng_profile_changed_photo_about{ ushort(2026) };
inline constexpr phrase<> lng_profile_changed_photo_link{ ushort(2027) };
inline constexpr phrase<> lng_profile_action_short_message{ ushort(2028) };
inline constexpr phrase<> lng_profile_action_short_channel{ ushort(2029) };
inline constexpr phrase<> lng_profile_action_short_mute{ ushort(2030) };
inline constexpr phrase<> lng_profile_action_short_unmute{ ushort(2031) };
inline constexpr phrase<> lng_profile_action_short_call{ ushort(2032) };
inline constexpr phrase<> lng_profile_action_short_discuss{ ushort(2033) };
inline constexpr phrase<> lng_profile_action_short_gift{ ushort(2034) };
inline constexpr phrase<> lng_profile_action_short_join{ ushort(2035) };
inline constexpr phrase<> lng_profile_action_short_report{ ushort(2036) };
inline constexpr phrase<> lng_profile_action_short_leave{ ushort(2037) };
inline constexpr phrase<> lng_profile_action_short_more{ ushort(2038) };
inline constexpr phrase<> lng_profile_action_short_manage{ ushort(2039) };
inline constexpr phrase<> lng_media_type_photos{ ushort(2040) };
inline constexpr phrase<> lng_media_type_gifs{ ushort(2041) };
inline constexpr phrase<> lng_media_type_videos{ ushort(2042) };
inline constexpr phrase<> lng_media_type_songs{ ushort(2043) };
inline constexpr phrase<> lng_media_type_files{ ushort(2044) };
inline constexpr phrase<> lng_media_type_audios{ ushort(2045) };
inline constexpr phrase<> lng_media_type_links{ ushort(2046) };
inline constexpr phrase<> lng_media_type_rounds{ ushort(2047) };
inline constexpr phrase<> lng_media_saved_music_your{ ushort(2048) };
inline constexpr phrase<> lng_media_saved_music_title{ ushort(2049) };
inline constexpr phrase<> lng_profile_common_groups_section{ ushort(2050) };
inline constexpr phrase<> lng_info_edit_contact{ ushort(2051) };
inline constexpr phrase<> lng_info_delete_contact{ ushort(2052) };
inline constexpr phrase<> lng_info_share_contact{ ushort(2053) };
inline constexpr phrase<> lng_profile_clear_history{ ushort(2054) };
inline constexpr phrase<> lng_profile_delete_conversation{ ushort(2055) };
inline constexpr phrase<> lng_profile_block_user{ ushort(2056) };
inline constexpr phrase<> lng_profile_unblock_user{ ushort(2057) };
inline constexpr phrase<> lng_profile_export_chat{ ushort(2058) };
inline constexpr phrase<> lng_profile_export_topic{ ushort(2059) };
inline constexpr phrase<> lng_profile_gift_premium{ ushort(2060) };
inline constexpr phrase<lngtag_count> lng_media_selected_photo{ ushort(2061) };
inline constexpr phrase<lngtag_count> lng_media_selected_gif{ ushort(2067) };
inline constexpr phrase<lngtag_count> lng_media_selected_video{ ushort(2073) };
inline constexpr phrase<lngtag_count> lng_media_selected_song{ ushort(2079) };
inline constexpr phrase<lngtag_count> lng_media_selected_file{ ushort(2085) };
inline constexpr phrase<lngtag_count> lng_media_selected_audio{ ushort(2091) };
inline constexpr phrase<lngtag_count> lng_media_selected_link{ ushort(2097) };
inline constexpr phrase<> lng_media_photo_empty{ ushort(2103) };
inline constexpr phrase<> lng_media_gif_empty{ ushort(2104) };
inline constexpr phrase<> lng_media_video_empty{ ushort(2105) };
inline constexpr phrase<> lng_media_song_empty{ ushort(2106) };
inline constexpr phrase<> lng_media_file_empty{ ushort(2107) };
inline constexpr phrase<> lng_media_audio_empty{ ushort(2108) };
inline constexpr phrase<> lng_media_link_empty{ ushort(2109) };
inline constexpr phrase<> lng_media_song_empty_search{ ushort(2110) };
inline constexpr phrase<> lng_media_file_empty_search{ ushort(2111) };
inline constexpr phrase<> lng_media_link_empty_search{ ushort(2112) };
inline constexpr phrase<> lng_manage_group_title{ ushort(2113) };
inline constexpr phrase<> lng_manage_channel_title{ ushort(2114) };
inline constexpr phrase<> lng_manage_bot_title{ ushort(2115) };
inline constexpr phrase<> lng_manage_peer_recent_actions{ ushort(2116) };
inline constexpr phrase<> lng_manage_peer_star_ref{ ushort(2117) };
inline constexpr phrase<> lng_manage_peer_members{ ushort(2118) };
inline constexpr phrase<> lng_manage_peer_subscribers{ ushort(2119) };
inline constexpr phrase<> lng_manage_peer_administrators{ ushort(2120) };
inline constexpr phrase<> lng_manage_peer_exceptions{ ushort(2121) };
inline constexpr phrase<> lng_manage_peer_removed_users{ ushort(2122) };
inline constexpr phrase<> lng_manage_peer_permissions{ ushort(2123) };
inline constexpr phrase<> lng_manage_peer_invite_links{ ushort(2124) };
inline constexpr phrase<> lng_manage_peer_reactions{ ushort(2125) };
inline constexpr phrase<> lng_manage_peer_reactions_on{ ushort(2126) };
inline constexpr phrase<> lng_manage_peer_reactions_off{ ushort(2127) };
inline constexpr phrase<> lng_manage_peer_requests{ ushort(2128) };
inline constexpr phrase<> lng_manage_peer_requests_channel{ ushort(2129) };
inline constexpr phrase<> lng_manage_peer_reactions_enable{ ushort(2130) };
inline constexpr phrase<> lng_manage_peer_reactions_about_channel{ ushort(2131) };
inline constexpr phrase<> lng_manage_peer_reactions_all{ ushort(2132) };
inline constexpr phrase<> lng_manage_peer_reactions_all_about{ ushort(2133) };
inline constexpr phrase<> lng_manage_peer_reactions_some{ ushort(2134) };
inline constexpr phrase<> lng_manage_peer_reactions_some_about{ ushort(2135) };
inline constexpr phrase<> lng_manage_peer_reactions_none{ ushort(2136) };
inline constexpr phrase<> lng_manage_peer_reactions_none_about{ ushort(2137) };
inline constexpr phrase<> lng_manage_peer_reactions_some_title{ ushort(2138) };
inline constexpr phrase<> lng_manage_peer_reactions_available{ ushort(2139) };
inline constexpr phrase<> lng_manage_peer_reactions_available_ph{ ushort(2140) };
inline constexpr phrase<lngtag_link> lng_manage_peer_reactions_own{ ushort(2141) };
inline constexpr phrase<> lng_manage_peer_reactions_own_link{ ushort(2142) };
inline constexpr phrase<lngtag_count, lngtag_same_count> lng_manage_peer_reactions_level{ ushort(2143) };
inline constexpr phrase<lngtag_link> lng_manage_peer_reactions_boost{ ushort(2149) };
inline constexpr phrase<> lng_manage_peer_reactions_boost_link{ ushort(2150) };
inline constexpr phrase<> lng_manage_peer_reactions_limit{ ushort(2151) };
inline constexpr phrase<> lng_manage_peer_reactions_max_title{ ushort(2152) };
inline constexpr phrase<lngtag_count> lng_manage_peer_reactions_max_slider{ ushort(2153) };
inline constexpr phrase<> lng_manage_peer_reactions_max_about{ ushort(2159) };
inline constexpr phrase<> lng_manage_peer_reactions_paid{ ushort(2160) };
inline constexpr phrase<lngtag_link> lng_manage_peer_reactions_paid_about{ ushort(2161) };
inline constexpr phrase<> lng_manage_peer_reactions_paid_link{ ushort(2162) };
inline constexpr phrase<> lng_manage_peer_antispam{ ushort(2163) };
inline constexpr phrase<> lng_manage_peer_antispam_about{ ushort(2164) };
inline constexpr phrase<lngtag_count> lng_manage_peer_antispam_not_enough{ ushort(2165) };
inline constexpr phrase<> lng_manage_peer_group_type{ ushort(2171) };
inline constexpr phrase<> lng_manage_peer_channel_type{ ushort(2172) };
inline constexpr phrase<> lng_manage_peer_link_type{ ushort(2173) };
inline constexpr phrase<> lng_manage_peer_link_permanent{ ushort(2174) };
inline constexpr phrase<> lng_manage_peer_link_invite{ ushort(2175) };
inline constexpr phrase<> lng_manage_peer_link_expired{ ushort(2176) };
inline constexpr phrase<> lng_manage_private_group_title{ ushort(2177) };
inline constexpr phrase<> lng_manage_private_group_noforwards_title{ ushort(2178) };
inline constexpr phrase<> lng_manage_public_group_title{ ushort(2179) };
inline constexpr phrase<> lng_manage_private_peer_title{ ushort(2180) };
inline constexpr phrase<> lng_manage_private_peer_noforwards_title{ ushort(2181) };
inline constexpr phrase<> lng_manage_public_peer_title{ ushort(2182) };
inline constexpr phrase<> lng_manage_peer_send_title{ ushort(2183) };
inline constexpr phrase<> lng_manage_peer_send_only_members{ ushort(2184) };
inline constexpr phrase<> lng_manage_peer_send_only_members_about{ ushort(2185) };
inline constexpr phrase<> lng_manage_peer_send_approve_members{ ushort(2186) };
inline constexpr phrase<> lng_manage_peer_send_approve_members_about{ ushort(2187) };
inline constexpr phrase<> lng_manage_peer_no_forwards_title{ ushort(2188) };
inline constexpr phrase<> lng_manage_peer_no_forwards{ ushort(2189) };
inline constexpr phrase<> lng_manage_peer_no_forwards_about{ ushort(2190) };
inline constexpr phrase<> lng_manage_peer_no_forwards_about_channel{ ushort(2191) };
inline constexpr phrase<> lng_manage_peer_bot_public_link{ ushort(2192) };
inline constexpr phrase<> lng_manage_peer_bot_public_links{ ushort(2193) };
inline constexpr phrase<> lng_manage_peer_bot_balance{ ushort(2194) };
inline constexpr phrase<> lng_manage_peer_bot_balance_currency{ ushort(2195) };
inline constexpr phrase<> lng_manage_peer_bot_balance_credits{ ushort(2196) };
inline constexpr phrase<> lng_manage_peer_bot_star_ref{ ushort(2197) };
inline constexpr phrase<> lng_manage_peer_bot_star_ref_off{ ushort(2198) };
inline constexpr phrase<lngtag_bot, lngtag_amount> lng_manage_peer_bot_star_ref_about{ ushort(2199) };
inline constexpr phrase<> lng_manage_peer_bot_verify{ ushort(2200) };
inline constexpr phrase<> lng_manage_peer_bot_edit_intro{ ushort(2201) };
inline constexpr phrase<> lng_manage_peer_bot_edit_commands{ ushort(2202) };
inline constexpr phrase<> lng_manage_peer_bot_edit_settings{ ushort(2203) };
inline constexpr phrase<lngtag_bot> lng_manage_peer_bot_about{ ushort(2204) };
inline constexpr phrase<> lng_bot_verify_title{ ushort(2205) };
inline constexpr phrase<> lng_bot_verify_bot_title{ ushort(2206) };
inline constexpr phrase<lngtag_name> lng_bot_verify_bot_text{ ushort(2207) };
inline constexpr phrase<> lng_bot_verify_bot_about{ ushort(2208) };
inline constexpr phrase<> lng_bot_verify_bot_submit{ ushort(2209) };
inline constexpr phrase<lngtag_name> lng_bot_verify_bot_sent{ ushort(2210) };
inline constexpr phrase<> lng_bot_verify_bot_remove{ ushort(2211) };
inline constexpr phrase<> lng_bot_verify_user_title{ ushort(2212) };
inline constexpr phrase<lngtag_name> lng_bot_verify_user_text{ ushort(2213) };
inline constexpr phrase<> lng_bot_verify_user_about{ ushort(2214) };
inline constexpr phrase<> lng_bot_verify_user_submit{ ushort(2215) };
inline constexpr phrase<lngtag_name> lng_bot_verify_user_sent{ ushort(2216) };
inline constexpr phrase<> lng_bot_verify_user_remove{ ushort(2217) };
inline constexpr phrase<> lng_bot_verify_channel_title{ ushort(2218) };
inline constexpr phrase<lngtag_name> lng_bot_verify_channel_text{ ushort(2219) };
inline constexpr phrase<> lng_bot_verify_channel_about{ ushort(2220) };
inline constexpr phrase<> lng_bot_verify_channel_submit{ ushort(2221) };
inline constexpr phrase<lngtag_name> lng_bot_verify_channel_sent{ ushort(2222) };
inline constexpr phrase<> lng_bot_verify_channel_remove{ ushort(2223) };
inline constexpr phrase<> lng_bot_verify_group_title{ ushort(2224) };
inline constexpr phrase<lngtag_name> lng_bot_verify_group_text{ ushort(2225) };
inline constexpr phrase<> lng_bot_verify_group_about{ ushort(2226) };
inline constexpr phrase<> lng_bot_verify_group_submit{ ushort(2227) };
inline constexpr phrase<lngtag_name> lng_bot_verify_group_sent{ ushort(2228) };
inline constexpr phrase<> lng_bot_verify_group_remove{ ushort(2229) };
inline constexpr phrase<> lng_bot_verify_description_label{ ushort(2230) };
inline constexpr phrase<> lng_bot_verify_remove_title{ ushort(2231) };
inline constexpr phrase<> lng_bot_verify_remove_submit{ ushort(2232) };
inline constexpr phrase<> lng_bot_verify_remove_done{ ushort(2233) };
inline constexpr phrase<> lng_star_ref_title{ ushort(2234) };
inline constexpr phrase<> lng_star_ref_about{ ushort(2235) };
inline constexpr phrase<> lng_star_ref_share_title{ ushort(2236) };
inline constexpr phrase<> lng_star_ref_share_about{ ushort(2237) };
inline constexpr phrase<> lng_star_ref_launch_title{ ushort(2238) };
inline constexpr phrase<> lng_star_ref_launch_about{ ushort(2239) };
inline constexpr phrase<> lng_star_ref_let_title{ ushort(2240) };
inline constexpr phrase<> lng_star_ref_let_about{ ushort(2241) };
inline constexpr phrase<> lng_star_ref_commission_title{ ushort(2242) };
inline constexpr phrase<> lng_star_ref_commission_about{ ushort(2243) };
inline constexpr phrase<> lng_star_ref_duration_title{ ushort(2244) };
inline constexpr phrase<> lng_star_ref_duration_about{ ushort(2245) };
inline constexpr phrase<> lng_star_ref_existing_title{ ushort(2246) };
inline constexpr phrase<> lng_star_ref_existing_about{ ushort(2247) };
inline constexpr phrase<lngtag_bot> lng_star_ref_add_bot{ ushort(2248) };
inline constexpr phrase<> lng_star_ref_end{ ushort(2249) };
inline constexpr phrase<> lng_star_ref_start{ ushort(2250) };
inline constexpr phrase<lngtag_time> lng_star_ref_start_disabled{ ushort(2251) };
inline constexpr phrase<lngtag_terms> lng_star_ref_start_info{ ushort(2252) };
inline constexpr phrase<> lng_star_ref_update{ ushort(2253) };
inline constexpr phrase<lngtag_terms> lng_star_ref_update_info{ ushort(2254) };
inline constexpr phrase<> lng_star_ref_button_link{ ushort(2255) };
inline constexpr phrase<> lng_star_ref_tos_url{ ushort(2256) };
inline constexpr phrase<> lng_star_ref_warning_title{ ushort(2257) };
inline constexpr phrase<> lng_star_ref_warning_text{ ushort(2258) };
inline constexpr phrase<> lng_star_ref_warning_change{ ushort(2259) };
inline constexpr phrase<> lng_star_ref_warning_start{ ushort(2260) };
inline constexpr phrase<> lng_star_ref_warning_update{ ushort(2261) };
inline constexpr phrase<> lng_star_ref_warning_if_end{ ushort(2262) };
inline constexpr phrase<> lng_star_ref_warning_if_end1{ ushort(2263) };
inline constexpr phrase<> lng_star_ref_warning_if_end2{ ushort(2264) };
inline constexpr phrase<> lng_star_ref_warning_if_end3{ ushort(2265) };
inline constexpr phrase<> lng_star_ref_warning_end{ ushort(2266) };
inline constexpr phrase<> lng_star_ref_created_title{ ushort(2267) };
inline constexpr phrase<> lng_star_ref_created_text{ ushort(2268) };
inline constexpr phrase<> lng_star_ref_updated_title{ ushort(2269) };
inline constexpr phrase<> lng_star_ref_updated_text{ ushort(2270) };
inline constexpr phrase<> lng_star_ref_ended_title{ ushort(2271) };
inline constexpr phrase<> lng_star_ref_ended_text{ ushort(2272) };
inline constexpr phrase<> lng_star_ref_list_title{ ushort(2273) };
inline constexpr phrase<> lng_star_ref_list_about_channel{ ushort(2274) };
inline constexpr phrase<> lng_star_ref_list_text{ ushort(2275) };
inline constexpr phrase<> lng_star_ref_list_my{ ushort(2276) };
inline constexpr phrase<> lng_star_ref_list_my_open{ ushort(2277) };
inline constexpr phrase<> lng_star_ref_list_my_copy{ ushort(2278) };
inline constexpr phrase<> lng_star_ref_list_my_leave{ ushort(2279) };
inline constexpr phrase<> lng_star_ref_list_subtitle{ ushort(2280) };
inline constexpr phrase<lngtag_sort> lng_star_ref_sort_text{ ushort(2281) };
inline constexpr phrase<> lng_star_ref_sort_profitability{ ushort(2282) };
inline constexpr phrase<> lng_star_ref_sort_date{ ushort(2283) };
inline constexpr phrase<> lng_star_ref_sort_revenue{ ushort(2284) };
inline constexpr phrase<> lng_star_ref_reliable_title{ ushort(2285) };
inline constexpr phrase<> lng_star_ref_reliable_about{ ushort(2286) };
inline constexpr phrase<> lng_star_ref_transparent_title{ ushort(2287) };
inline constexpr phrase<> lng_star_ref_transparent_about{ ushort(2288) };
inline constexpr phrase<> lng_star_ref_simple_title{ ushort(2289) };
inline constexpr phrase<> lng_star_ref_simple_about{ ushort(2290) };
inline constexpr phrase<> lng_star_ref_duration_forever{ ushort(2291) };
inline constexpr phrase<lngtag_app, lngtag_amount, lngtag_duration> lng_star_ref_one_about{ ushort(2292) };
inline constexpr phrase<> lng_star_ref_one_about_for_forever{ ushort(2293) };
inline constexpr phrase<lngtag_count> lng_star_ref_one_about_for_months{ ushort(2294) };
inline constexpr phrase<lngtag_count> lng_star_ref_one_about_for_years{ ushort(2300) };
inline constexpr phrase<lngtag_amount> lng_star_ref_one_daily_revenue{ ushort(2306) };
inline constexpr phrase<> lng_star_ref_one_join{ ushort(2307) };
inline constexpr phrase<lngtag_terms> lng_star_ref_one_join_text{ ushort(2308) };
inline constexpr phrase<> lng_star_ref_joined_title{ ushort(2309) };
inline constexpr phrase<> lng_star_ref_joined_text{ ushort(2310) };
inline constexpr phrase<> lng_star_ref_link_title{ ushort(2311) };
inline constexpr phrase<lngtag_amount, lngtag_app, lngtag_duration> lng_star_ref_link_about_channel{ ushort(2312) };
inline constexpr phrase<lngtag_amount, lngtag_app, lngtag_duration> lng_star_ref_link_about_user{ ushort(2313) };
inline constexpr phrase<lngtag_amount, lngtag_app, lngtag_duration> lng_star_ref_link_about_bot{ ushort(2314) };
inline constexpr phrase<> lng_star_ref_link_recipient{ ushort(2315) };
inline constexpr phrase<> lng_star_ref_link_copy{ ushort(2316) };
inline constexpr phrase<lngtag_app> lng_star_ref_link_copy_none{ ushort(2317) };
inline constexpr phrase<lngtag_count, lngtag_app> lng_star_ref_link_copy_users{ ushort(2318) };
inline constexpr phrase<> lng_star_ref_link_copied_title{ ushort(2324) };
inline constexpr phrase<lngtag_amount, lngtag_app> lng_star_ref_link_copied_text{ ushort(2325) };
inline constexpr phrase<> lng_star_ref_stopped{ ushort(2326) };
inline constexpr phrase<> lng_star_ref_revoke_title{ ushort(2327) };
inline constexpr phrase<lngtag_bot> lng_star_ref_revoke_text{ ushort(2328) };
inline constexpr phrase<> lng_star_ref_revoked_title{ ushort(2329) };
inline constexpr phrase<> lng_star_ref_revoked_text{ ushort(2330) };
inline constexpr phrase<> lng_stars_rating_title{ ushort(2331) };
inline constexpr phrase<> lng_stars_rating_future{ ushort(2332) };
inline constexpr phrase<lngtag_count> lng_stars_rating_updates{ ushort(2333) };
inline constexpr phrase<lngtag_count, lngtag_when, lngtag_link> lng_stars_rating_pending{ ushort(2339) };
inline constexpr phrase<lngtag_arrow> lng_stars_rating_pending_preview{ ushort(2345) };
inline constexpr phrase<lngtag_arrow> lng_stars_rating_pending_back{ ushort(2346) };
inline constexpr phrase<> lng_stars_rating_negative_label{ ushort(2347) };
inline constexpr phrase<lngtag_name> lng_stars_rating_negative{ ushort(2348) };
inline constexpr phrase<lngtag_count> lng_stars_rating_negative_your{ ushort(2349) };
inline constexpr phrase<lngtag_name> lng_stars_rating_about{ ushort(2355) };
inline constexpr phrase<> lng_stars_rating_about_your{ ushort(2356) };
inline constexpr phrase<> lng_stars_title_gifts_telegram{ ushort(2357) };
inline constexpr phrase<lngtag_emoji> lng_stars_about_gifts_telegram{ ushort(2358) };
inline constexpr phrase<> lng_stars_title_gifts_users{ ushort(2359) };
inline constexpr phrase<lngtag_emoji> lng_stars_about_gifts_users{ ushort(2360) };
inline constexpr phrase<> lng_stars_title_refunds{ ushort(2361) };
inline constexpr phrase<lngtag_emoji> lng_stars_about_refunds{ ushort(2362) };
inline constexpr phrase<> lng_stars_rating_added{ ushort(2363) };
inline constexpr phrase<> lng_stars_rating_deducted{ ushort(2364) };
inline constexpr phrase<> lng_stars_rating_understood{ ushort(2365) };
inline constexpr phrase<> lng_manage_discussion_group{ ushort(2366) };
inline constexpr phrase<> lng_manage_discussion_group_add{ ushort(2367) };
inline constexpr phrase<> lng_manage_linked_channel{ ushort(2368) };
inline constexpr phrase<> lng_manage_linked_channel_restore{ ushort(2369) };
inline constexpr phrase<> lng_manage_discussion_group_about{ ushort(2370) };
inline constexpr phrase<lngtag_group> lng_manage_discussion_group_about_chosen{ ushort(2371) };
inline constexpr phrase<> lng_manage_discussion_group_create{ ushort(2372) };
inline constexpr phrase<> lng_manage_discussion_group_unlink{ ushort(2373) };
inline constexpr phrase<> lng_manage_discussion_group_posted{ ushort(2374) };
inline constexpr phrase<lngtag_group, lngtag_channel> lng_manage_discussion_group_sure{ ushort(2375) };
inline constexpr phrase<> lng_manage_linked_channel_private{ ushort(2376) };
inline constexpr phrase<> lng_manage_discussion_group_private{ ushort(2377) };
inline constexpr phrase<> lng_manage_discussion_group_link{ ushort(2378) };
inline constexpr phrase<> lng_manage_linked_channel_private_status{ ushort(2379) };
inline constexpr phrase<> lng_manage_discussion_group_private_status{ ushort(2380) };
inline constexpr phrase<lngtag_channel> lng_manage_linked_channel_about{ ushort(2381) };
inline constexpr phrase<> lng_manage_linked_channel_unlink{ ushort(2382) };
inline constexpr phrase<> lng_manage_linked_channel_posted{ ushort(2383) };
inline constexpr phrase<> lng_manage_discussion_group_warning{ ushort(2384) };
inline constexpr phrase<> lng_manage_monoforum{ ushort(2385) };
inline constexpr phrase<> lng_manage_monoforum_off{ ushort(2386) };
inline constexpr phrase<> lng_manage_monoforum_free{ ushort(2387) };
inline constexpr phrase<> lng_manage_monoforum_allow{ ushort(2388) };
inline constexpr phrase<> lng_manage_monoforum_price{ ushort(2389) };
inline constexpr phrase<> lng_manage_monoforum_about{ ushort(2390) };
inline constexpr phrase<lngtag_percent, lngtag_amount> lng_manage_monoforum_price_about{ ushort(2391) };
inline constexpr phrase<> lng_manage_monoforum_link_subtitle{ ushort(2392) };
inline constexpr phrase<> lng_manage_history_visibility_title{ ushort(2393) };
inline constexpr phrase<> lng_manage_history_visibility_shown{ ushort(2394) };
inline constexpr phrase<> lng_manage_history_visibility_shown_about{ ushort(2395) };
inline constexpr phrase<> lng_manage_history_visibility_hidden{ ushort(2396) };
inline constexpr phrase<> lng_manage_history_visibility_hidden_about{ ushort(2397) };
inline constexpr phrase<> lng_manage_history_visibility_hidden_legacy{ ushort(2398) };
inline constexpr phrase<> lng_manage_messages_ttl_title{ ushort(2399) };
inline constexpr phrase<> lng_manage_messages_ttl_disable{ ushort(2400) };
inline constexpr phrase<> lng_manage_messages_ttl_after1{ ushort(2401) };
inline constexpr phrase<> lng_manage_messages_ttl_after2{ ushort(2402) };
inline constexpr phrase<> lng_manage_messages_ttl_after3{ ushort(2403) };
inline constexpr phrase<> lng_manage_messages_ttl_after4{ ushort(2404) };
inline constexpr phrase<> lng_manage_messages_ttl_after_custom{ ushort(2405) };
inline constexpr phrase<> lng_manage_messages_ttl_menu{ ushort(2406) };
inline constexpr phrase<lngtag_user> lng_ttl_edit_about{ ushort(2407) };
inline constexpr phrase<> lng_ttl_edit_about_group{ ushort(2408) };
inline constexpr phrase<> lng_ttl_edit_about_channel{ ushort(2409) };
inline constexpr phrase<lngtag_link> lng_ttl_edit_about2{ ushort(2410) };
inline constexpr phrase<> lng_ttl_edit_about2_link{ ushort(2411) };
inline constexpr phrase<lngtag_duration> lng_ttl_about_tooltip{ ushort(2412) };
inline constexpr phrase<lngtag_duration> lng_ttl_about_tooltip_channel{ ushort(2413) };
inline constexpr phrase<> lng_ttl_about_tooltip_off{ ushort(2414) };
inline constexpr phrase<> lng_report_title{ ushort(2415) };
inline constexpr phrase<> lng_report_group_title{ ushort(2416) };
inline constexpr phrase<> lng_report_bot_title{ ushort(2417) };
inline constexpr phrase<> lng_report_message_title{ ushort(2418) };
inline constexpr phrase<> lng_report_profile_photo_title{ ushort(2419) };
inline constexpr phrase<> lng_report_profile_video_title{ ushort(2420) };
inline constexpr phrase<> lng_report_group_photo_title{ ushort(2421) };
inline constexpr phrase<> lng_report_group_video_title{ ushort(2422) };
inline constexpr phrase<> lng_report_channel_photo_title{ ushort(2423) };
inline constexpr phrase<> lng_report_channel_video_title{ ushort(2424) };
inline constexpr phrase<> lng_report_story{ ushort(2425) };
inline constexpr phrase<> lng_report_please_select_messages{ ushort(2426) };
inline constexpr phrase<> lng_report_select_messages{ ushort(2427) };
inline constexpr phrase<> lng_report_messages_none{ ushort(2428) };
inline constexpr phrase<lngtag_count> lng_report_messages_count{ ushort(2429) };
inline constexpr phrase<> lng_report_reaction{ ushort(2435) };
inline constexpr phrase<> lng_report_and_ban{ ushort(2436) };
inline constexpr phrase<> lng_report_reaction_title{ ushort(2437) };
inline constexpr phrase<> lng_report_reaction_about{ ushort(2438) };
inline constexpr phrase<> lng_report_and_ban_button{ ushort(2439) };
inline constexpr phrase<> lng_report_details_about{ ushort(2440) };
inline constexpr phrase<> lng_report_details{ ushort(2441) };
inline constexpr phrase<> lng_report_details_optional{ ushort(2442) };
inline constexpr phrase<> lng_report_details_non_optional{ ushort(2443) };
inline constexpr phrase<> lng_report_details_message_about{ ushort(2444) };
inline constexpr phrase<> lng_report_reason_spam{ ushort(2445) };
inline constexpr phrase<> lng_report_reason_fake{ ushort(2446) };
inline constexpr phrase<> lng_report_reason_violence{ ushort(2447) };
inline constexpr phrase<> lng_report_reason_child_abuse{ ushort(2448) };
inline constexpr phrase<> lng_report_reason_pornography{ ushort(2449) };
inline constexpr phrase<> lng_report_reason_copyright{ ushort(2450) };
inline constexpr phrase<> lng_report_reason_illegal_drugs{ ushort(2451) };
inline constexpr phrase<> lng_report_reason_personal_details{ ushort(2452) };
inline constexpr phrase<> lng_report_reason_other{ ushort(2453) };
inline constexpr phrase<> lng_report_button{ ushort(2454) };
inline constexpr phrase<> lng_report_thanks{ ushort(2455) };
inline constexpr phrase<> lng_report_sponsored_hidden{ ushort(2456) };
inline constexpr phrase<lngtag_link> lng_report_sponsored_reported{ ushort(2457) };
inline constexpr phrase<> lng_report_sponsored_reported_link{ ushort(2458) };
inline constexpr phrase<lngtag_link> lng_report_sponsored_reported_learn{ ushort(2459) };
inline constexpr phrase<> lng_channel_add_members{ ushort(2460) };
inline constexpr phrase<> lng_channel_add_users{ ushort(2461) };
inline constexpr phrase<> lng_channel_add_removed{ ushort(2462) };
inline constexpr phrase<> lng_channel_add_exception{ ushort(2463) };
inline constexpr phrase<> lng_channel_admins{ ushort(2464) };
inline constexpr phrase<> lng_channel_add_admin{ ushort(2465) };
inline constexpr phrase<> lng_channel_admin_status_creator{ ushort(2466) };
inline constexpr phrase<lngtag_user> lng_channel_admin_status_promoted_by{ ushort(2467) };
inline constexpr phrase<> lng_channel_admin_status_not_admin{ ushort(2468) };
inline constexpr phrase<lngtag_user> lng_channel_banned_status_restricted_by{ ushort(2469) };
inline constexpr phrase<lngtag_user> lng_channel_banned_status_removed_by{ ushort(2470) };
inline constexpr phrase<> lng_channel_removed_list_about{ ushort(2471) };
inline constexpr phrase<> lng_group_removed_list_about{ ushort(2472) };
inline constexpr phrase<> lng_participant_filter{ ushort(2473) };
inline constexpr phrase<> lng_participant_invite{ ushort(2474) };
inline constexpr phrase<> lng_participant_invite_history{ ushort(2475) };
inline constexpr phrase<lngtag_user, lngtag_group> lng_participant_invite_sure{ ushort(2476) };
inline constexpr phrase<lngtag_count, lngtag_group> lng_participant_invite_sure_many{ ushort(2477) };
inline constexpr phrase<lngtag_count> lng_participant_invite_sorry{ ushort(2483) };
inline constexpr phrase<> lng_create_group_back{ ushort(2489) };
inline constexpr phrase<> lng_create_group_next{ ushort(2490) };
inline constexpr phrase<> lng_create_group_create{ ushort(2491) };
inline constexpr phrase<> lng_create_group_title{ ushort(2492) };
inline constexpr phrase<> lng_create_channel_title{ ushort(2493) };
inline constexpr phrase<> lng_create_public_channel_title{ ushort(2494) };
inline constexpr phrase<> lng_create_public_channel_about{ ushort(2495) };
inline constexpr phrase<> lng_create_private_channel_title{ ushort(2496) };
inline constexpr phrase<> lng_create_private_channel_about{ ushort(2497) };
inline constexpr phrase<> lng_create_public_group_title{ ushort(2498) };
inline constexpr phrase<> lng_create_public_group_about{ ushort(2499) };
inline constexpr phrase<> lng_create_private_group_title{ ushort(2500) };
inline constexpr phrase<> lng_create_private_group_about{ ushort(2501) };
inline constexpr phrase<> lng_create_permanent_link_title{ ushort(2502) };
inline constexpr phrase<> lng_create_invite_link_title{ ushort(2503) };
inline constexpr phrase<> lng_create_invite_link_about{ ushort(2504) };
inline constexpr phrase<> lng_create_group_skip{ ushort(2505) };
inline constexpr phrase<> lng_create_channel_link_about{ ushort(2506) };
inline constexpr phrase<> lng_create_channel_link_invalid{ ushort(2507) };
inline constexpr phrase<> lng_create_channel_link_occupied{ ushort(2508) };
inline constexpr phrase<> lng_create_channel_link_too_short{ ushort(2509) };
inline constexpr phrase<> lng_create_channel_link_bad_symbols{ ushort(2510) };
inline constexpr phrase<> lng_create_channel_link_available{ ushort(2511) };
inline constexpr phrase<> lng_create_channel_link_pending{ ushort(2512) };
inline constexpr phrase<> lng_create_channel_link_copied{ ushort(2513) };
inline constexpr phrase<> lng_failed_add_participant{ ushort(2514) };
inline constexpr phrase<> lng_failed_add_not_mutual{ ushort(2515) };
inline constexpr phrase<lngtag_contact> lng_sure_delete_contact{ ushort(2516) };
inline constexpr phrase<lngtag_contact> lng_sure_delete_history{ ushort(2517) };
inline constexpr phrase<lngtag_group> lng_sure_delete_group_history{ ushort(2518) };
inline constexpr phrase<lngtag_channel> lng_sure_delete_channel_history{ ushort(2519) };
inline constexpr phrase<lngtag_group> lng_sure_delete_and_exit{ ushort(2520) };
inline constexpr phrase<> lng_sure_leave_channel{ ushort(2521) };
inline constexpr phrase<> lng_sure_delete_channel{ ushort(2522) };
inline constexpr phrase<> lng_sure_leave_group{ ushort(2523) };
inline constexpr phrase<> lng_sure_delete_group{ ushort(2524) };
inline constexpr phrase<> lng_sure_delete_saved_messages{ ushort(2525) };
inline constexpr phrase<> lng_no_clear_history_channel{ ushort(2526) };
inline constexpr phrase<> lng_no_clear_history_group{ ushort(2527) };
inline constexpr phrase<lngtag_date> lng_sure_delete_by_date_one{ ushort(2528) };
inline constexpr phrase<lngtag_days> lng_sure_delete_by_date_many{ ushort(2529) };
inline constexpr phrase<lngtag_count> lng_sure_delete_selected_days{ ushort(2530) };
inline constexpr phrase<> lng_message_empty{ ushort(2536) };
inline constexpr phrase<lngtag_link> lng_message_unsupported{ ushort(2537) };
inline constexpr phrase<> lng_message_not_found{ ushort(2538) };
inline constexpr phrase<lngtag_count> lng_duration_minsec_minutes{ ushort(2539) };
inline constexpr phrase<lngtag_count> lng_duration_minsec_seconds{ ushort(2545) };
inline constexpr phrase<lngtag_minutes_count, lngtag_seconds_count> lng_duration_minutes_seconds{ ushort(2551) };
inline constexpr phrase<lngtag_from, lngtag_user, lngtag_chat> lng_action_invite_user{ ushort(2552) };
inline constexpr phrase<lngtag_from, lngtag_users, lngtag_chat> lng_action_invite_users_many{ ushort(2553) };
inline constexpr phrase<> lng_action_invite_user_chat{ ushort(2554) };
inline constexpr phrase<lngtag_accumulated, lngtag_user> lng_action_invite_users_and_one{ ushort(2555) };
inline constexpr phrase<lngtag_accumulated, lngtag_user> lng_action_invite_users_and_last{ ushort(2556) };
inline constexpr phrase<lngtag_from> lng_action_group_call_started_group{ ushort(2557) };
inline constexpr phrase<> lng_action_group_call_started_channel{ ushort(2558) };
inline constexpr phrase<lngtag_from, lngtag_date> lng_action_group_call_scheduled_group{ ushort(2559) };
inline constexpr phrase<lngtag_date> lng_action_group_call_scheduled_channel{ ushort(2560) };
inline constexpr phrase<lngtag_duration> lng_action_group_call_finished{ ushort(2561) };
inline constexpr phrase<lngtag_from, lngtag_duration> lng_action_group_call_finished_group{ ushort(2562) };
inline constexpr phrase<lngtag_from, lngtag_user> lng_action_add_user{ ushort(2563) };
inline constexpr phrase<lngtag_from, lngtag_users> lng_action_add_users_many{ ushort(2564) };
inline constexpr phrase<lngtag_accumulated, lngtag_user> lng_action_add_users_and_one{ ushort(2565) };
inline constexpr phrase<lngtag_accumulated, lngtag_user> lng_action_add_users_and_last{ ushort(2566) };
inline constexpr phrase<lngtag_from> lng_action_add_you{ ushort(2567) };
inline constexpr phrase<> lng_action_you_joined{ ushort(2568) };
inline constexpr phrase<lngtag_from> lng_action_add_you_group{ ushort(2569) };
inline constexpr phrase<lngtag_from, lngtag_user> lng_action_kick_user{ ushort(2570) };
inline constexpr phrase<lngtag_from> lng_action_user_left{ ushort(2571) };
inline constexpr phrase<lngtag_from> lng_action_user_joined{ ushort(2572) };
inline constexpr phrase<lngtag_from> lng_action_user_joined_by_link{ ushort(2573) };
inline constexpr phrase<lngtag_from> lng_action_user_joined_by_request{ ushort(2574) };
inline constexpr phrase<> lng_action_you_joined_by_request{ ushort(2575) };
inline constexpr phrase<> lng_action_you_joined_by_request_channel{ ushort(2576) };
inline constexpr phrase<lngtag_from> lng_action_user_registered{ ushort(2577) };
inline constexpr phrase<lngtag_from> lng_action_removed_photo{ ushort(2578) };
inline constexpr phrase<> lng_action_removed_photo_channel{ ushort(2579) };
inline constexpr phrase<lngtag_from> lng_action_changed_photo{ ushort(2580) };
inline constexpr phrase<> lng_action_changed_photo_channel{ ushort(2581) };
inline constexpr phrase<lngtag_from, lngtag_title> lng_action_changed_title{ ushort(2582) };
inline constexpr phrase<lngtag_title> lng_action_changed_title_channel{ ushort(2583) };
inline constexpr phrase<lngtag_from, lngtag_title> lng_action_created_chat{ ushort(2584) };
inline constexpr phrase<> lng_action_created_monoforum{ ushort(2585) };
inline constexpr phrase<lngtag_from, lngtag_duration> lng_action_ttl_changed{ ushort(2586) };
inline constexpr phrase<lngtag_duration> lng_action_ttl_changed_you{ ushort(2587) };
inline constexpr phrase<lngtag_duration> lng_action_ttl_changed_channel{ ushort(2588) };
inline constexpr phrase<lngtag_from, lngtag_duration> lng_action_ttl_global{ ushort(2589) };
inline constexpr phrase<lngtag_duration> lng_action_ttl_global_me{ ushort(2590) };
inline constexpr phrase<lngtag_from> lng_action_ttl_removed{ ushort(2591) };
inline constexpr phrase<> lng_action_ttl_removed_you{ ushort(2592) };
inline constexpr phrase<> lng_action_ttl_removed_channel{ ushort(2593) };
inline constexpr phrase<> lng_action_created_channel{ ushort(2594) };
inline constexpr phrase<lngtag_from, lngtag_text> lng_action_pinned_message{ ushort(2595) };
inline constexpr phrase<lngtag_from, lngtag_media> lng_action_pinned_media{ ushort(2596) };
inline constexpr phrase<> lng_action_pinned_media_photo{ ushort(2597) };
inline constexpr phrase<> lng_action_pinned_media_video{ ushort(2598) };
inline constexpr phrase<> lng_action_pinned_media_audio{ ushort(2599) };
inline constexpr phrase<> lng_action_pinned_media_voice{ ushort(2600) };
inline constexpr phrase<> lng_action_pinned_media_video_message{ ushort(2601) };
inline constexpr phrase<> lng_action_pinned_media_file{ ushort(2602) };
inline constexpr phrase<> lng_action_pinned_media_gif{ ushort(2603) };
inline constexpr phrase<> lng_action_pinned_media_contact{ ushort(2604) };
inline constexpr phrase<> lng_action_pinned_media_location{ ushort(2605) };
inline constexpr phrase<> lng_action_pinned_media_sticker{ ushort(2606) };
inline constexpr phrase<lngtag_emoji> lng_action_pinned_media_emoji_sticker{ ushort(2607) };
inline constexpr phrase<lngtag_game> lng_action_pinned_media_game{ ushort(2608) };
inline constexpr phrase<> lng_action_pinned_media_story{ ushort(2609) };
inline constexpr phrase<lngtag_count, lngtag_from, lngtag_game> lng_action_game_score{ ushort(2610) };
inline constexpr phrase<lngtag_count, lngtag_game> lng_action_game_you_scored{ ushort(2616) };
inline constexpr phrase<lngtag_count, lngtag_from> lng_action_game_score_no_game{ ushort(2622) };
inline constexpr phrase<lngtag_count> lng_action_game_you_scored_no_game{ ushort(2628) };
inline constexpr phrase<lngtag_amount, lngtag_user> lng_action_payment_done{ ushort(2634) };
inline constexpr phrase<lngtag_amount, lngtag_user, lngtag_invoice> lng_action_payment_done_for{ ushort(2635) };
inline constexpr phrase<lngtag_amount, lngtag_user, lngtag_invoice> lng_action_payment_init_recurring_for{ ushort(2636) };
inline constexpr phrase<lngtag_amount, lngtag_user> lng_action_payment_init_recurring{ ushort(2637) };
inline constexpr phrase<lngtag_amount> lng_action_payment_used_recurring{ ushort(2638) };
inline constexpr phrase<lngtag_amount> lng_action_payment_bot_done{ ushort(2639) };
inline constexpr phrase<lngtag_amount> lng_action_payment_bot_recurring{ ushort(2640) };
inline constexpr phrase<lngtag_from> lng_action_took_screenshot{ ushort(2641) };
inline constexpr phrase<> lng_action_you_took_screenshot{ ushort(2642) };
inline constexpr phrase<lngtag_domain> lng_action_bot_allowed_from_domain{ ushort(2643) };
inline constexpr phrase<lngtag_app> lng_action_bot_allowed_from_app{ ushort(2644) };
inline constexpr phrase<lngtag_user, lngtag_documents> lng_action_secure_values_sent{ ushort(2645) };
inline constexpr phrase<> lng_action_secure_personal_details{ ushort(2646) };
inline constexpr phrase<> lng_action_secure_proof_of_identity{ ushort(2647) };
inline constexpr phrase<> lng_action_secure_address{ ushort(2648) };
inline constexpr phrase<> lng_action_secure_proof_of_address{ ushort(2649) };
inline constexpr phrase<> lng_action_secure_phone{ ushort(2650) };
inline constexpr phrase<> lng_action_secure_email{ ushort(2651) };
inline constexpr phrase<lngtag_from, lngtag_distance, lngtag_user> lng_action_proximity_reached{ ushort(2652) };
inline constexpr phrase<lngtag_from, lngtag_distance> lng_action_proximity_reached_you{ ushort(2653) };
inline constexpr phrase<lngtag_distance, lngtag_user> lng_action_you_proximity_reached{ ushort(2654) };
inline constexpr phrase<lngtag_emoji> lng_action_you_theme_changed{ ushort(2655) };
inline constexpr phrase<lngtag_from, lngtag_emoji> lng_action_theme_changed{ ushort(2656) };
inline constexpr phrase<lngtag_name> lng_action_you_gift_theme_changed{ ushort(2657) };
inline constexpr phrase<lngtag_from, lngtag_name> lng_action_gift_theme_changed{ ushort(2658) };
inline constexpr phrase<> lng_action_you_theme_disabled{ ushort(2659) };
inline constexpr phrase<lngtag_from> lng_action_theme_disabled{ ushort(2660) };
inline constexpr phrase<lngtag_count> lng_action_proximity_distance_m{ ushort(2661) };
inline constexpr phrase<lngtag_count> lng_action_proximity_distance_km{ ushort(2667) };
inline constexpr phrase<lngtag_text> lng_action_webview_data_done{ ushort(2673) };
inline constexpr phrase<lngtag_user, lngtag_cost> lng_action_gift_received{ ushort(2674) };
inline constexpr phrase<lngtag_user, lngtag_cost> lng_action_gift_received_sold{ ushort(2675) };
inline constexpr phrase<lngtag_user> lng_action_gift_unique_received{ ushort(2676) };
inline constexpr phrase<lngtag_cost> lng_action_gift_sent{ ushort(2677) };
inline constexpr phrase<lngtag_cost> lng_action_gift_sent_sold{ ushort(2678) };
inline constexpr phrase<> lng_action_gift_unique_sent{ ushort(2679) };
inline constexpr phrase<lngtag_user> lng_action_gift_upgraded{ ushort(2680) };
inline constexpr phrase<lngtag_user, lngtag_channel> lng_action_gift_upgraded_channel{ ushort(2681) };
inline constexpr phrase<lngtag_channel> lng_action_gift_upgraded_self_channel{ ushort(2682) };
inline constexpr phrase<lngtag_user> lng_action_gift_upgraded_mine{ ushort(2683) };
inline constexpr phrase<> lng_action_gift_upgraded_self{ ushort(2684) };
inline constexpr phrase<lngtag_from, lngtag_cost, lngtag_user> lng_action_gift_sent_upgrade_other{ ushort(2685) };
inline constexpr phrase<lngtag_cost, lngtag_name, lngtag_user> lng_action_gift_sent_upgrade_self_other{ ushort(2686) };
inline constexpr phrase<lngtag_from, lngtag_cost> lng_action_gift_sent_upgrade{ ushort(2687) };
inline constexpr phrase<lngtag_cost> lng_action_gift_sent_upgrade_self{ ushort(2688) };
inline constexpr phrase<lngtag_cost, lngtag_name> lng_action_gift_sent_upgrade_self_channel{ ushort(2689) };
inline constexpr phrase<lngtag_user> lng_action_gift_upgraded_helped{ ushort(2690) };
inline constexpr phrase<lngtag_user> lng_action_gift_upgraded_helped_self{ ushort(2691) };
inline constexpr phrase<lngtag_user> lng_action_gift_transferred{ ushort(2692) };
inline constexpr phrase<lngtag_user, lngtag_channel> lng_action_gift_transferred_channel{ ushort(2693) };
inline constexpr phrase<> lng_action_gift_transferred_unknown{ ushort(2694) };
inline constexpr phrase<lngtag_channel> lng_action_gift_transferred_unknown_channel{ ushort(2695) };
inline constexpr phrase<> lng_action_gift_transferred_self{ ushort(2696) };
inline constexpr phrase<lngtag_name> lng_action_gift_displayed_self{ ushort(2697) };
inline constexpr phrase<lngtag_channel> lng_action_gift_transferred_self_channel{ ushort(2698) };
inline constexpr phrase<lngtag_user> lng_action_gift_transferred_mine{ ushort(2699) };
inline constexpr phrase<> lng_action_gift_crafted{ ushort(2700) };
inline constexpr phrase<lngtag_cost> lng_action_gift_received_anonymous{ ushort(2701) };
inline constexpr phrase<lngtag_user, lngtag_name, lngtag_cost> lng_action_gift_sent_channel{ ushort(2702) };
inline constexpr phrase<lngtag_name, lngtag_cost> lng_action_gift_sent_self_channel{ ushort(2703) };
inline constexpr phrase<lngtag_cost> lng_action_gift_self_bought{ ushort(2704) };
inline constexpr phrase<lngtag_cost> lng_action_gift_self_auction{ ushort(2705) };
inline constexpr phrase<lngtag_cost> lng_action_gift_auction_won{ ushort(2706) };
inline constexpr phrase<> lng_action_gift_self_subtitle{ ushort(2707) };
inline constexpr phrase<> lng_action_gift_crafted_subtitle{ ushort(2708) };
inline constexpr phrase<lngtag_count> lng_action_gift_self_about{ ushort(2709) };
inline constexpr phrase<> lng_action_gift_self_about_unique{ ushort(2715) };
inline constexpr phrase<lngtag_count> lng_action_gift_channel_about{ ushort(2716) };
inline constexpr phrase<> lng_action_gift_channel_about_unique{ ushort(2722) };
inline constexpr phrase<lngtag_count> lng_action_gift_for_stars{ ushort(2723) };
inline constexpr phrase<lngtag_count> lng_action_gift_for_ton{ ushort(2729) };
inline constexpr phrase<lngtag_user> lng_action_gift_got_subtitle{ ushort(2735) };
inline constexpr phrase<lngtag_count> lng_action_gift_got_stars_text{ ushort(2736) };
inline constexpr phrase<> lng_action_gift_got_upgradable_text{ ushort(2742) };
inline constexpr phrase<> lng_action_gift_got_gift_text{ ushort(2743) };
inline constexpr phrase<> lng_action_gift_can_remove_text{ ushort(2744) };
inline constexpr phrase<> lng_action_gift_got_gift_channel{ ushort(2745) };
inline constexpr phrase<> lng_action_gift_can_remove_channel{ ushort(2746) };
inline constexpr phrase<lngtag_user> lng_action_gift_sent_subtitle{ ushort(2747) };
inline constexpr phrase<lngtag_count, lngtag_user> lng_action_gift_sent_text{ ushort(2748) };
inline constexpr phrase<lngtag_user> lng_action_gift_sent_upgradable{ ushort(2754) };
inline constexpr phrase<lngtag_count> lng_action_gift_premium_months{ ushort(2755) };
inline constexpr phrase<> lng_action_gift_premium_about{ ushort(2761) };
inline constexpr phrase<> lng_action_gift_refunded{ ushort(2762) };
inline constexpr phrase<> lng_action_gift_got_ton{ ushort(2763) };
inline constexpr phrase<lngtag_user, lngtag_cost, lngtag_name> lng_action_gift_offer{ ushort(2764) };
inline constexpr phrase<lngtag_cost, lngtag_name> lng_action_gift_offer_you{ ushort(2765) };
inline constexpr phrase<lngtag_time> lng_action_gift_offer_state_expires{ ushort(2766) };
inline constexpr phrase<lngtag_hours> lng_action_gift_offer_time_large{ ushort(2767) };
inline constexpr phrase<lngtag_hours, lngtag_minutes> lng_action_gift_offer_time_medium{ ushort(2768) };
inline constexpr phrase<lngtag_minutes> lng_action_gift_offer_time_small{ ushort(2769) };
inline constexpr phrase<> lng_action_gift_offer_state_accepted{ ushort(2770) };
inline constexpr phrase<> lng_action_gift_offer_state_rejected{ ushort(2771) };
inline constexpr phrase<> lng_action_gift_offer_state_expired{ ushort(2772) };
inline constexpr phrase<lngtag_user, lngtag_name, lngtag_cost> lng_action_gift_offer_sold{ ushort(2773) };
inline constexpr phrase<lngtag_name, lngtag_cost> lng_action_gift_offer_sold_you{ ushort(2774) };
inline constexpr phrase<> lng_action_gift_offer_decline{ ushort(2775) };
inline constexpr phrase<> lng_action_gift_offer_accept{ ushort(2776) };
inline constexpr phrase<lngtag_user, lngtag_name, lngtag_cost> lng_action_gift_offer_expired{ ushort(2777) };
inline constexpr phrase<lngtag_name, lngtag_cost> lng_action_gift_offer_expired_your{ ushort(2778) };
inline constexpr phrase<lngtag_user, lngtag_name, lngtag_cost> lng_action_gift_offer_declined{ ushort(2779) };
inline constexpr phrase<lngtag_user, lngtag_name, lngtag_cost> lng_action_gift_offer_declined_you{ ushort(2780) };
inline constexpr phrase<lngtag_user> lng_action_suggested_photo_me{ ushort(2781) };
inline constexpr phrase<lngtag_user> lng_action_suggested_photo{ ushort(2782) };
inline constexpr phrase<> lng_action_suggested_photo_button{ ushort(2783) };
inline constexpr phrase<lngtag_user> lng_action_suggested_video_me{ ushort(2784) };
inline constexpr phrase<lngtag_user> lng_action_suggested_video{ ushort(2785) };
inline constexpr phrase<> lng_action_suggested_video_button{ ushort(2786) };
inline constexpr phrase<lngtag_user> lng_action_suggested_birthday_me{ ushort(2787) };
inline constexpr phrase<lngtag_user> lng_action_suggested_birthday{ ushort(2788) };
inline constexpr phrase<> lng_action_suggested_birtday_button{ ushort(2789) };
inline constexpr phrase<> lng_action_attach_menu_bot_allowed{ ushort(2790) };
inline constexpr phrase<> lng_action_webapp_bot_allowed{ ushort(2791) };
inline constexpr phrase<> lng_action_set_wallpaper_me{ ushort(2792) };
inline constexpr phrase<lngtag_user> lng_action_set_wallpaper{ ushort(2793) };
inline constexpr phrase<lngtag_user> lng_action_set_wallpaper_both_me{ ushort(2794) };
inline constexpr phrase<> lng_action_set_wallpaper_button{ ushort(2795) };
inline constexpr phrase<> lng_action_set_wallpaper_remove{ ushort(2796) };
inline constexpr phrase<> lng_action_set_same_wallpaper_me{ ushort(2797) };
inline constexpr phrase<lngtag_user> lng_action_set_same_wallpaper{ ushort(2798) };
inline constexpr phrase<> lng_action_topic_created_inside{ ushort(2799) };
inline constexpr phrase<> lng_action_topic_closed_inside{ ushort(2800) };
inline constexpr phrase<> lng_action_topic_reopened_inside{ ushort(2801) };
inline constexpr phrase<> lng_action_topic_hidden_inside{ ushort(2802) };
inline constexpr phrase<> lng_action_topic_unhidden_inside{ ushort(2803) };
inline constexpr phrase<lngtag_topic> lng_action_topic_created{ ushort(2804) };
inline constexpr phrase<lngtag_topic> lng_action_topic_closed{ ushort(2805) };
inline constexpr phrase<lngtag_topic> lng_action_topic_reopened{ ushort(2806) };
inline constexpr phrase<lngtag_topic> lng_action_topic_hidden{ ushort(2807) };
inline constexpr phrase<lngtag_topic> lng_action_topic_unhidden{ ushort(2808) };
inline constexpr phrase<> lng_action_topic_placeholder{ ushort(2809) };
inline constexpr phrase<> lng_action_topic_bot_thread{ ushort(2810) };
inline constexpr phrase<lngtag_from, lngtag_link, lngtag_title> lng_action_topic_renamed{ ushort(2811) };
inline constexpr phrase<lngtag_from, lngtag_link, lngtag_emoji> lng_action_topic_icon_changed{ ushort(2812) };
inline constexpr phrase<lngtag_from, lngtag_link> lng_action_topic_icon_removed{ ushort(2813) };
inline constexpr phrase<lngtag_chat, lngtag_bot> lng_action_shared_chat_with_bot{ ushort(2814) };
inline constexpr phrase<lngtag_user> lng_action_story_mention_me{ ushort(2815) };
inline constexpr phrase<lngtag_user> lng_action_story_mention{ ushort(2816) };
inline constexpr phrase<> lng_action_story_mention_button{ ushort(2817) };
inline constexpr phrase<lngtag_user> lng_action_story_mention_me_unavailable{ ushort(2818) };
inline constexpr phrase<lngtag_user> lng_action_story_mention_unavailable{ ushort(2819) };
inline constexpr phrase<lngtag_from> lng_action_giveaway_started_group{ ushort(2820) };
inline constexpr phrase<lngtag_from> lng_action_giveaway_started{ ushort(2821) };
inline constexpr phrase<lngtag_count> lng_action_giveaway_credits_started_amount{ ushort(2822) };
inline constexpr phrase<lngtag_from, lngtag_amount> lng_action_giveaway_credits_started_group{ ushort(2828) };
inline constexpr phrase<lngtag_from, lngtag_amount> lng_action_giveaway_credits_started{ ushort(2829) };
inline constexpr phrase<lngtag_count> lng_action_giveaway_results{ ushort(2830) };
inline constexpr phrase<> lng_action_giveaway_results_some{ ushort(2836) };
inline constexpr phrase<lngtag_count> lng_action_giveaway_results_credits{ ushort(2837) };
inline constexpr phrase<> lng_action_giveaway_results_credits_some{ ushort(2843) };
inline constexpr phrase<> lng_action_giveaway_results_none{ ushort(2844) };
inline constexpr phrase<> lng_action_boost_apply_me{ ushort(2845) };
inline constexpr phrase<lngtag_count, lngtag_from> lng_action_boost_apply{ ushort(2846) };
inline constexpr phrase<lngtag_from> lng_action_set_chat_intro{ ushort(2852) };
inline constexpr phrase<lngtag_peer, lngtag_amount> lng_action_payment_refunded{ ushort(2853) };
inline constexpr phrase<lngtag_count, lngtag_action> lng_action_paid_message_sent{ ushort(2854) };
inline constexpr phrase<> lng_action_paid_message_one{ ushort(2860) };
inline constexpr phrase<lngtag_count> lng_action_paid_message_some{ ushort(2861) };
inline constexpr phrase<lngtag_count, lngtag_name> lng_action_paid_message_got{ ushort(2867) };
inline constexpr phrase<lngtag_count, lngtag_from> lng_action_paid_message_refund{ ushort(2873) };
inline constexpr phrase<lngtag_count, lngtag_name> lng_action_paid_message_refund_self{ ushort(2879) };
inline constexpr phrase<> lng_action_message_price_free{ ushort(2885) };
inline constexpr phrase<lngtag_count> lng_action_message_price_paid{ ushort(2886) };
inline constexpr phrase<> lng_action_direct_messages_enabled{ ushort(2892) };
inline constexpr phrase<lngtag_count> lng_action_direct_messages_paid{ ushort(2893) };
inline constexpr phrase<> lng_action_direct_messages_disabled{ ushort(2899) };
inline constexpr phrase<lngtag_from, lngtag_tasks> lng_action_todo_marked_done{ ushort(2900) };
inline constexpr phrase<lngtag_tasks> lng_action_todo_marked_done_self{ ushort(2901) };
inline constexpr phrase<lngtag_from, lngtag_tasks> lng_action_todo_marked_not_done{ ushort(2902) };
inline constexpr phrase<lngtag_tasks> lng_action_todo_marked_not_done_self{ ushort(2903) };
inline constexpr phrase<lngtag_from, lngtag_tasks> lng_action_todo_added{ ushort(2904) };
inline constexpr phrase<lngtag_tasks> lng_action_todo_added_self{ ushort(2905) };
inline constexpr phrase<lngtag_count> lng_action_todo_tasks_fallback{ ushort(2906) };
inline constexpr phrase<lngtag_tasks, lngtag_task> lng_action_todo_tasks_and_one{ ushort(2912) };
inline constexpr phrase<lngtag_tasks, lngtag_task> lng_action_todo_tasks_and_last{ ushort(2913) };
inline constexpr phrase<lngtag_count, lngtag_from> lng_action_suggest_success_stars{ ushort(2914) };
inline constexpr phrase<lngtag_count, lngtag_from> lng_action_suggest_success_ton{ ushort(2920) };
inline constexpr phrase<> lng_action_suggest_refund_user{ ushort(2926) };
inline constexpr phrase<> lng_action_suggest_refund_admin{ ushort(2927) };
inline constexpr phrase<> lng_action_post_rejected{ ushort(2928) };
inline constexpr phrase<> lng_action_not_enough_funds{ ushort(2929) };
inline constexpr phrase<lngtag_count> lng_you_paid_stars{ ushort(2930) };
inline constexpr phrase<lngtag_from> lng_action_stake_game_nothing{ ushort(2936) };
inline constexpr phrase<> lng_action_stake_game_nothing_you{ ushort(2937) };
inline constexpr phrase<lngtag_from, lngtag_amount> lng_action_stake_game_won{ ushort(2938) };
inline constexpr phrase<lngtag_amount> lng_action_stake_game_won_you{ ushort(2939) };
inline constexpr phrase<lngtag_from, lngtag_amount> lng_action_stake_game_lost{ ushort(2940) };
inline constexpr phrase<lngtag_amount> lng_action_stake_game_lost_you{ ushort(2941) };
inline constexpr phrase<lngtag_from, lngtag_user> lng_action_change_creator{ ushort(2942) };
inline constexpr phrase<lngtag_user, lngtag_from> lng_action_new_creator_pending{ ushort(2943) };
inline constexpr phrase<> lng_stake_game_title{ ushort(2944) };
inline constexpr phrase<> lng_stake_game_beta{ ushort(2945) };
inline constexpr phrase<> lng_stake_game_about{ ushort(2946) };
inline constexpr phrase<> lng_stake_game_results{ ushort(2947) };
inline constexpr phrase<lngtag_emoji> lng_stake_game_resets{ ushort(2948) };
inline constexpr phrase<> lng_stake_game_your{ ushort(2949) };
inline constexpr phrase<> lng_stake_game_save_and_roll{ ushort(2950) };
inline constexpr phrase<> lng_you_joined_group{ ushort(2951) };
inline constexpr phrase<> lng_similar_channels_title{ ushort(2952) };
inline constexpr phrase<> lng_similar_channels_view_all{ ushort(2953) };
inline constexpr phrase<> lng_similar_channels_more{ ushort(2954) };
inline constexpr phrase<lngtag_count, lngtag_link> lng_similar_channels_premium_all{ ushort(2955) };
inline constexpr phrase<> lng_similar_channels_premium_all_link{ ushort(2961) };
inline constexpr phrase<> lng_similar_channels_show_more{ ushort(2962) };
inline constexpr phrase<> lng_similar_bots_title{ ushort(2963) };
inline constexpr phrase<lngtag_count, lngtag_link> lng_similar_bots_premium_all{ ushort(2964) };
inline constexpr phrase<> lng_similar_bots_show_more{ ushort(2970) };
inline constexpr phrase<> lng_peer_gifts_title{ ushort(2971) };
inline constexpr phrase<lngtag_user> lng_peer_gifts_about{ ushort(2972) };
inline constexpr phrase<> lng_peer_gifts_about_mine{ ushort(2973) };
inline constexpr phrase<> lng_peer_gifts_empty_search{ ushort(2974) };
inline constexpr phrase<> lng_peer_gifts_view_all{ ushort(2975) };
inline constexpr phrase<> lng_peer_gifts_notify{ ushort(2976) };
inline constexpr phrase<> lng_peer_gifts_notify_enabled{ ushort(2977) };
inline constexpr phrase<> lng_peer_gifts_filter_by_value{ ushort(2978) };
inline constexpr phrase<> lng_peer_gifts_filter_by_date{ ushort(2979) };
inline constexpr phrase<> lng_peer_gifts_filter_unlimited{ ushort(2980) };
inline constexpr phrase<> lng_peer_gifts_filter_upgradable{ ushort(2981) };
inline constexpr phrase<> lng_peer_gifts_filter_limited{ ushort(2982) };
inline constexpr phrase<> lng_peer_gifts_filter_unique{ ushort(2983) };
inline constexpr phrase<> lng_peer_gifts_filter_saved{ ushort(2984) };
inline constexpr phrase<> lng_peer_gifts_filter_unsaved{ ushort(2985) };
inline constexpr phrase<lngtag_count> lng_premium_gift_duration_days{ ushort(2986) };
inline constexpr phrase<lngtag_count> lng_premium_gift_duration_months{ ushort(2992) };
inline constexpr phrase<lngtag_count> lng_premium_gift_duration_years{ ushort(2998) };
inline constexpr phrase<lngtag_from> lng_ttl_photo_received{ ushort(3004) };
inline constexpr phrase<> lng_ttl_photo_sent{ ushort(3005) };
inline constexpr phrase<> lng_ttl_photo_expired{ ushort(3006) };
inline constexpr phrase<lngtag_from> lng_ttl_video_received{ ushort(3007) };
inline constexpr phrase<> lng_ttl_video_sent{ ushort(3008) };
inline constexpr phrase<> lng_ttl_video_expired{ ushort(3009) };
inline constexpr phrase<> lng_ttl_voice_sent{ ushort(3010) };
inline constexpr phrase<> lng_ttl_voice_expired{ ushort(3011) };
inline constexpr phrase<> lng_ttl_round_sent{ ushort(3012) };
inline constexpr phrase<> lng_ttl_round_expired{ ushort(3013) };
inline constexpr phrase<> lng_ttl_voice_tooltip_in{ ushort(3014) };
inline constexpr phrase<lngtag_user> lng_ttl_voice_tooltip_out{ ushort(3015) };
inline constexpr phrase<> lng_ttl_voice_close_in{ ushort(3016) };
inline constexpr phrase<> lng_ttl_round_tooltip_in{ ushort(3017) };
inline constexpr phrase<lngtag_user> lng_ttl_round_tooltip_out{ ushort(3018) };
inline constexpr phrase<> lng_profile_add_more_after_create{ ushort(3019) };
inline constexpr phrase<> lng_profile_camera_title{ ushort(3020) };
inline constexpr phrase<> lng_channel_not_accessible{ ushort(3021) };
inline constexpr phrase<> lng_group_not_accessible{ ushort(3022) };
inline constexpr phrase<> lng_group_full{ ushort(3023) };
inline constexpr phrase<lngtag_link, lngtag_group> lng_channels_too_much_public_revoke_confirm_group{ ushort(3024) };
inline constexpr phrase<lngtag_link, lngtag_group> lng_channels_too_much_public_revoke_confirm_channel{ ushort(3025) };
inline constexpr phrase<> lng_channels_too_much_public_revoke{ ushort(3026) };
inline constexpr phrase<> lng_channels_too_much_public_other{ ushort(3027) };
inline constexpr phrase<> lng_channels_too_much_located_other{ ushort(3028) };
inline constexpr phrase<> lng_group_invite_bad_link{ ushort(3029) };
inline constexpr phrase<lngtag_count> lng_group_invite_members{ ushort(3030) };
inline constexpr phrase<> lng_channel_invite_private{ ushort(3036) };
inline constexpr phrase<> lng_channel_invite_subscription_button{ ushort(3037) };
inline constexpr phrase<> lng_channel_invite_subscription_title{ ushort(3038) };
inline constexpr phrase<lngtag_channel, lngtag_price> lng_channel_invite_subscription_about{ ushort(3039) };
inline constexpr phrase<lngtag_link> lng_channel_invite_subscription_terms{ ushort(3040) };
inline constexpr phrase<> lng_group_invite_create{ ushort(3041) };
inline constexpr phrase<> lng_group_invite_about_new{ ushort(3042) };
inline constexpr phrase<> lng_group_invite_copied{ ushort(3043) };
inline constexpr phrase<> lng_group_invite_no_room{ ushort(3044) };
inline constexpr phrase<> lng_group_invite_copy{ ushort(3045) };
inline constexpr phrase<> lng_group_invite_share{ ushort(3046) };
inline constexpr phrase<> lng_group_invite_reactivate{ ushort(3047) };
inline constexpr phrase<> lng_group_invite_delete{ ushort(3048) };
inline constexpr phrase<> lng_group_invite_no_joined{ ushort(3049) };
inline constexpr phrase<lngtag_count> lng_group_invite_joined{ ushort(3050) };
inline constexpr phrase<> lng_group_invite_joined_via_filter{ ushort(3056) };
inline constexpr phrase<lngtag_count> lng_group_invite_remaining{ ushort(3057) };
inline constexpr phrase<lngtag_count> lng_group_invite_requested{ ushort(3063) };
inline constexpr phrase<lngtag_count> lng_group_invite_requested_full{ ushort(3069) };
inline constexpr phrase<lngtag_count> lng_group_invite_can_join{ ushort(3075) };
inline constexpr phrase<lngtag_count> lng_group_invite_days_left{ ushort(3081) };
inline constexpr phrase<> lng_group_invite_about_permanent_group{ ushort(3087) };
inline constexpr phrase<> lng_group_invite_about_permanent_channel{ ushort(3088) };
inline constexpr phrase<> lng_group_invite_title{ ushort(3089) };
inline constexpr phrase<> lng_group_invite_add{ ushort(3090) };
inline constexpr phrase<> lng_group_invite_add_about{ ushort(3091) };
inline constexpr phrase<lngtag_when> lng_group_invite_expires_at{ ushort(3092) };
inline constexpr phrase<> lng_group_invite_created_by{ ushort(3093) };
inline constexpr phrase<lngtag_count> lng_group_invite_links_count{ ushort(3094) };
inline constexpr phrase<> lng_group_invite_context_copy{ ushort(3100) };
inline constexpr phrase<> lng_group_invite_context_share{ ushort(3101) };
inline constexpr phrase<> lng_group_invite_context_edit{ ushort(3102) };
inline constexpr phrase<> lng_group_invite_context_qr{ ushort(3103) };
inline constexpr phrase<> lng_group_invite_context_revoke{ ushort(3104) };
inline constexpr phrase<> lng_group_invite_context_delete{ ushort(3105) };
inline constexpr phrase<> lng_group_invite_context_delete_all{ ushort(3106) };
inline constexpr phrase<> lng_group_invite_delete_sure{ ushort(3107) };
inline constexpr phrase<> lng_group_invite_delete_all_sure{ ushort(3108) };
inline constexpr phrase<> lng_group_invite_revoked_title{ ushort(3109) };
inline constexpr phrase<> lng_group_invite_revoke_about{ ushort(3110) };
inline constexpr phrase<> lng_group_invite_link_expired{ ushort(3111) };
inline constexpr phrase<> lng_group_invite_edit_title{ ushort(3112) };
inline constexpr phrase<> lng_group_invite_new_title{ ushort(3113) };
inline constexpr phrase<> lng_group_invite_label_header{ ushort(3114) };
inline constexpr phrase<> lng_group_invite_label_about{ ushort(3115) };
inline constexpr phrase<> lng_group_invite_expire_title{ ushort(3116) };
inline constexpr phrase<> lng_group_invite_expire_about{ ushort(3117) };
inline constexpr phrase<> lng_group_invite_expire_never{ ushort(3118) };
inline constexpr phrase<> lng_group_invite_expire_custom{ ushort(3119) };
inline constexpr phrase<> lng_group_invite_usage_title{ ushort(3120) };
inline constexpr phrase<> lng_group_invite_usage_about{ ushort(3121) };
inline constexpr phrase<> lng_group_invite_expire_after{ ushort(3122) };
inline constexpr phrase<> lng_group_invite_custom_limit{ ushort(3123) };
inline constexpr phrase<> lng_group_invite_usage_any{ ushort(3124) };
inline constexpr phrase<> lng_group_invite_usage_custom{ ushort(3125) };
inline constexpr phrase<> lng_group_invite_other_title{ ushort(3126) };
inline constexpr phrase<lngtag_count> lng_group_invite_other_count{ ushort(3127) };
inline constexpr phrase<> lng_group_invite_other_list{ ushort(3133) };
inline constexpr phrase<> lng_group_invite_expired_about{ ushort(3134) };
inline constexpr phrase<> lng_group_invite_used_about{ ushort(3135) };
inline constexpr phrase<lngtag_count> lng_group_invite_can_join_via_link{ ushort(3136) };
inline constexpr phrase<> lng_group_invite_qr_title{ ushort(3142) };
inline constexpr phrase<> lng_group_invite_qr_about{ ushort(3143) };
inline constexpr phrase<> lng_group_invite_qr_copied{ ushort(3144) };
inline constexpr phrase<> lng_group_invite_request_approve{ ushort(3145) };
inline constexpr phrase<> lng_group_invite_about_approve{ ushort(3146) };
inline constexpr phrase<> lng_group_invite_about_no_approve{ ushort(3147) };
inline constexpr phrase<> lng_group_invite_about_approve_channel{ ushort(3148) };
inline constexpr phrase<> lng_group_invite_about_no_approve_channel{ ushort(3149) };
inline constexpr phrase<> lng_group_invite_subscription{ ushort(3150) };
inline constexpr phrase<> lng_group_invite_subscription_ph{ ushort(3151) };
inline constexpr phrase<lngtag_cost> lng_group_invite_subscription_price{ ushort(3152) };
inline constexpr phrase<> lng_group_invite_subscription_toast{ ushort(3153) };
inline constexpr phrase<lngtag_link> lng_group_invite_subscription_about{ ushort(3154) };
inline constexpr phrase<lngtag_emoji> lng_group_invite_subscription_about_link{ ushort(3155) };
inline constexpr phrase<> lng_group_invite_subscription_about_url{ ushort(3156) };
inline constexpr phrase<> lng_group_invite_subscription_info_subtitle{ ushort(3157) };
inline constexpr phrase<lngtag_emoji, lngtag_price, lngtag_multiplier, lngtag_total> lng_group_invite_subscription_info_title{ ushort(3158) };
inline constexpr phrase<lngtag_emoji, lngtag_price> lng_group_invite_subscription_info_title_none{ ushort(3159) };
inline constexpr phrase<lngtag_total> lng_group_invite_subscription_info_about{ ushort(3160) };
inline constexpr phrase<> lng_group_invite_joined_right{ ushort(3161) };
inline constexpr phrase<lngtag_date> lng_group_invite_joined_status{ ushort(3162) };
inline constexpr phrase<> lng_group_invite_joined_row_subscriber{ ushort(3163) };
inline constexpr phrase<> lng_group_invite_joined_row_date{ ushort(3164) };
inline constexpr phrase<> lng_group_request_to_join{ ushort(3165) };
inline constexpr phrase<> lng_group_request_about{ ushort(3166) };
inline constexpr phrase<> lng_group_request_about_channel{ ushort(3167) };
inline constexpr phrase<> lng_group_request_sent{ ushort(3168) };
inline constexpr phrase<> lng_group_request_sent_channel{ ushort(3169) };
inline constexpr phrase<lngtag_count> lng_group_requests_pending{ ushort(3170) };
inline constexpr phrase<lngtag_user> lng_group_requests_pending_user{ ushort(3176) };
inline constexpr phrase<lngtag_time> lng_group_requests_status_today{ ushort(3177) };
inline constexpr phrase<lngtag_time> lng_group_requests_status_yesterday{ ushort(3178) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_group_requests_status_date_time{ ushort(3179) };
inline constexpr phrase<> lng_group_requests_add{ ushort(3180) };
inline constexpr phrase<> lng_group_requests_add_channel{ ushort(3181) };
inline constexpr phrase<> lng_group_requests_dismiss{ ushort(3182) };
inline constexpr phrase<lngtag_user> lng_group_requests_was_added{ ushort(3183) };
inline constexpr phrase<lngtag_user> lng_group_requests_was_added_channel{ ushort(3184) };
inline constexpr phrase<> lng_group_requests_none{ ushort(3185) };
inline constexpr phrase<> lng_group_requests_none_channel{ ushort(3186) };
inline constexpr phrase<> lng_channel_public_link_copied{ ushort(3187) };
inline constexpr phrase<> lng_context_about_private_link{ ushort(3188) };
inline constexpr phrase<> lng_public_post_private_hint_ctrl{ ushort(3189) };
inline constexpr phrase<> lng_public_post_private_hint_cmd{ ushort(3190) };
inline constexpr phrase<lngtag_user> lng_forwarded{ ushort(3191) };
inline constexpr phrase<lngtag_user> lng_forwarded_story{ ushort(3192) };
inline constexpr phrase<> lng_forwarded_story_expired{ ushort(3193) };
inline constexpr phrase<lngtag_date> lng_forwarded_date{ ushort(3194) };
inline constexpr phrase<lngtag_date> lng_forwarded_forwarded_date{ ushort(3195) };
inline constexpr phrase<lngtag_channel> lng_forwarded_channel{ ushort(3196) };
inline constexpr phrase<lngtag_channel> lng_forwarded_psa_default{ ushort(3197) };
inline constexpr phrase<lngtag_user, lngtag_inline_bot> lng_forwarded_via{ ushort(3198) };
inline constexpr phrase<lngtag_channel, lngtag_inline_bot> lng_forwarded_channel_via{ ushort(3199) };
inline constexpr phrase<lngtag_channel, lngtag_user> lng_forwarded_signed{ ushort(3200) };
inline constexpr phrase<> lng_forwarded_hidden{ ushort(3201) };
inline constexpr phrase<> lng_forwarded_imported{ ushort(3202) };
inline constexpr phrase<lngtag_user> lng_signed_author{ ushort(3203) };
inline constexpr phrase<> lng_sponsored_message_title{ ushort(3204) };
inline constexpr phrase<> lng_sponsored_message_revenue_button{ ushort(3205) };
inline constexpr phrase<> lng_recommended_message_title{ ushort(3206) };
inline constexpr phrase<> lng_edited{ ushort(3207) };
inline constexpr phrase<> lng_commented{ ushort(3208) };
inline constexpr phrase<> lng_approximate{ ushort(3209) };
inline constexpr phrase<> lng_repeated_daily{ ushort(3210) };
inline constexpr phrase<> lng_repeated_weekly{ ushort(3211) };
inline constexpr phrase<> lng_repeated_biweekly{ ushort(3212) };
inline constexpr phrase<> lng_repeated_monthly{ ushort(3213) };
inline constexpr phrase<lngtag_count> lng_repeated_every_month{ ushort(3214) };
inline constexpr phrase<> lng_repeated_yearly{ ushort(3220) };
inline constexpr phrase<lngtag_date> lng_edited_date{ ushort(3221) };
inline constexpr phrase<lngtag_date> lng_sent_date{ ushort(3222) };
inline constexpr phrase<> lng_approximate_about{ ushort(3223) };
inline constexpr phrase<lngtag_count> lng_views_tooltip{ ushort(3224) };
inline constexpr phrase<lngtag_count> lng_forwards_tooltip{ ushort(3230) };
inline constexpr phrase<> lng_imported{ ushort(3236) };
inline constexpr phrase<> lng_admin_badge{ ushort(3237) };
inline constexpr phrase<> lng_owner_badge{ ushort(3238) };
inline constexpr phrase<> lng_channel_badge{ ushort(3239) };
inline constexpr phrase<> lng_topic_author_badge{ ushort(3240) };
inline constexpr phrase<> lng_fast_reply{ ushort(3241) };
inline constexpr phrase<> lng_fast_share_tooltip{ ushort(3242) };
inline constexpr phrase<> lng_cancel_edit_post_sure{ ushort(3243) };
inline constexpr phrase<> lng_cancel_edit_post_yes{ ushort(3244) };
inline constexpr phrase<> lng_cancel_edit_post_no{ ushort(3245) };
inline constexpr phrase<> lng_bot_share_location_unavailable{ ushort(3246) };
inline constexpr phrase<> lng_bot_share_phone{ ushort(3247) };
inline constexpr phrase<> lng_bot_share_phone_confirm{ ushort(3248) };
inline constexpr phrase<> lng_bot_allow_write_title{ ushort(3249) };
inline constexpr phrase<> lng_bot_allow_write{ ushort(3250) };
inline constexpr phrase<> lng_bot_allow_write_confirm{ ushort(3251) };
inline constexpr phrase<> lng_bot_new_chat{ ushort(3252) };
inline constexpr phrase<> lng_bot_new_thread_title{ ushort(3253) };
inline constexpr phrase<> lng_bot_new_thread_about{ ushort(3254) };
inline constexpr phrase<> lng_bot_show_threads_list{ ushort(3255) };
inline constexpr phrase<> lng_bot_off_thread_ph{ ushort(3256) };
inline constexpr phrase<> lng_attach_failed{ ushort(3257) };
inline constexpr phrase<> lng_attach_file{ ushort(3258) };
inline constexpr phrase<> lng_attach_photo{ ushort(3259) };
inline constexpr phrase<> lng_attach_camera{ ushort(3260) };
inline constexpr phrase<> lng_attach_document{ ushort(3261) };
inline constexpr phrase<> lng_attach_photo_or_video{ ushort(3262) };
inline constexpr phrase<> lng_attach_profile_emoji{ ushort(3263) };
inline constexpr phrase<> lng_media_open_with{ ushort(3264) };
inline constexpr phrase<> lng_media_download{ ushort(3265) };
inline constexpr phrase<> lng_media_cancel{ ushort(3266) };
inline constexpr phrase<> lng_media_video{ ushort(3267) };
inline constexpr phrase<> lng_media_audio{ ushort(3268) };
inline constexpr phrase<> lng_media_round{ ushort(3269) };
inline constexpr phrase<> lng_media_auto_settings{ ushort(3270) };
inline constexpr phrase<> lng_media_auto_in_private{ ushort(3271) };
inline constexpr phrase<> lng_media_auto_in_groups{ ushort(3272) };
inline constexpr phrase<> lng_media_auto_in_channels{ ushort(3273) };
inline constexpr phrase<> lng_media_auto_title{ ushort(3274) };
inline constexpr phrase<> lng_media_auto_play{ ushort(3275) };
inline constexpr phrase<> lng_media_photo_title{ ushort(3276) };
inline constexpr phrase<> lng_media_video_title{ ushort(3277) };
inline constexpr phrase<> lng_media_video_messages_title{ ushort(3278) };
inline constexpr phrase<> lng_media_file_title{ ushort(3279) };
inline constexpr phrase<> lng_media_animation_title{ ushort(3280) };
inline constexpr phrase<> lng_media_size_limit{ ushort(3281) };
inline constexpr phrase<lngtag_size> lng_media_size_up_to{ ushort(3282) };
inline constexpr phrase<> lng_media_chat_background{ ushort(3283) };
inline constexpr phrase<> lng_media_color_theme{ ushort(3284) };
inline constexpr phrase<> lng_emoji_category1{ ushort(3285) };
inline constexpr phrase<> lng_emoji_category2{ ushort(3286) };
inline constexpr phrase<> lng_emoji_category3{ ushort(3287) };
inline constexpr phrase<> lng_emoji_category4{ ushort(3288) };
inline constexpr phrase<> lng_emoji_category5{ ushort(3289) };
inline constexpr phrase<> lng_emoji_category6{ ushort(3290) };
inline constexpr phrase<> lng_emoji_category7{ ushort(3291) };
inline constexpr phrase<> lng_emoji_manage_sets{ ushort(3292) };
inline constexpr phrase<> lng_emoji_set_ready{ ushort(3293) };
inline constexpr phrase<> lng_emoji_set_active{ ushort(3294) };
inline constexpr phrase<lngtag_size> lng_emoji_set_download{ ushort(3295) };
inline constexpr phrase<lngtag_percent, lngtag_progress> lng_emoji_set_loading{ ushort(3296) };
inline constexpr phrase<> lng_emoji_color_all{ ushort(3297) };
inline constexpr phrase<> lng_emoji_copy{ ushort(3298) };
inline constexpr phrase<> lng_emoji_view_pack{ ushort(3299) };
inline constexpr phrase<> lng_emoji_remove_recent{ ushort(3300) };
inline constexpr phrase<> lng_emoji_reset_recent{ ushort(3301) };
inline constexpr phrase<> lng_emoji_reset_recent_sure{ ushort(3302) };
inline constexpr phrase<> lng_emoji_reset_recent_button{ ushort(3303) };
inline constexpr phrase<> lng_recent_stickers{ ushort(3304) };
inline constexpr phrase<> lng_faved_stickers_add{ ushort(3305) };
inline constexpr phrase<> lng_faved_stickers_remove{ ushort(3306) };
inline constexpr phrase<> lng_recent_stickers_remove{ ushort(3307) };
inline constexpr phrase<> lng_group_stickers{ ushort(3308) };
inline constexpr phrase<> lng_group_stickers_description{ ushort(3309) };
inline constexpr phrase<> lng_group_stickers_add{ ushort(3310) };
inline constexpr phrase<> lng_group_emoji{ ushort(3311) };
inline constexpr phrase<> lng_group_emoji_description{ ushort(3312) };
inline constexpr phrase<> lng_collectible_emoji{ ushort(3313) };
inline constexpr phrase<> lng_premium{ ushort(3314) };
inline constexpr phrase<> lng_premium_free{ ushort(3315) };
inline constexpr phrase<> lng_premium_more_about{ ushort(3316) };
inline constexpr phrase<> lng_premium_unlock_reactions{ ushort(3317) };
inline constexpr phrase<> lng_premium_unlock_stickers{ ushort(3318) };
inline constexpr phrase<> lng_premium_unlock_emoji{ ushort(3319) };
inline constexpr phrase<> lng_premium_unlock_status{ ushort(3320) };
inline constexpr phrase<> lng_premium_subscribe_months_24{ ushort(3321) };
inline constexpr phrase<> lng_premium_subscribe_months_12{ ushort(3322) };
inline constexpr phrase<> lng_premium_subscribe_months_6{ ushort(3323) };
inline constexpr phrase<> lng_premium_subscribe_months_1{ ushort(3324) };
inline constexpr phrase<lngtag_cost> lng_premium_subscribe_total{ ushort(3325) };
inline constexpr phrase<lngtag_cost> lng_premium_subscribe_button{ ushort(3326) };
inline constexpr phrase<lngtag_user, lngtag_link> lng_premium_emoji_status_title{ ushort(3327) };
inline constexpr phrase<lngtag_user> lng_premium_emoji_status_title_colored{ ushort(3328) };
inline constexpr phrase<> lng_premium_emoji_status_about{ ushort(3329) };
inline constexpr phrase<> lng_premium_emoji_status_button{ ushort(3330) };
inline constexpr phrase<lngtag_user> lng_premium_summary_user_title{ ushort(3331) };
inline constexpr phrase<> lng_premium_summary_user_about{ ushort(3332) };
inline constexpr phrase<> lng_premium_summary_title{ ushort(3333) };
inline constexpr phrase<> lng_premium_summary_top_about{ ushort(3334) };
inline constexpr phrase<> lng_premium_summary_title_subscribed{ ushort(3335) };
inline constexpr phrase<lngtag_count, lngtag_user> lng_premium_summary_subtitle_gift{ ushort(3336) };
inline constexpr phrase<lngtag_count, lngtag_user> lng_premium_summary_subtitle_gift_days{ ushort(3342) };
inline constexpr phrase<lngtag_count, lngtag_user> lng_premium_summary_subtitle_gift_me{ ushort(3348) };
inline constexpr phrase<lngtag_count, lngtag_user> lng_premium_summary_subtitle_gift_days_me{ ushort(3354) };
inline constexpr phrase<> lng_premium_summary_subtitle_wallpapers{ ushort(3360) };
inline constexpr phrase<> lng_premium_summary_about_wallpapers{ ushort(3361) };
inline constexpr phrase<> lng_premium_summary_subtitle_stories{ ushort(3362) };
inline constexpr phrase<> lng_premium_summary_about_stories{ ushort(3363) };
inline constexpr phrase<> lng_premium_summary_subtitle_double_limits{ ushort(3364) };
inline constexpr phrase<> lng_premium_summary_about_double_limits{ ushort(3365) };
inline constexpr phrase<> lng_premium_summary_subtitle_more_upload{ ushort(3366) };
inline constexpr phrase<> lng_premium_summary_about_more_upload{ ushort(3367) };
inline constexpr phrase<> lng_premium_summary_subtitle_faster_download{ ushort(3368) };
inline constexpr phrase<> lng_premium_summary_about_faster_download{ ushort(3369) };
inline constexpr phrase<> lng_premium_summary_subtitle_voice_to_text{ ushort(3370) };
inline constexpr phrase<> lng_premium_summary_about_voice_to_text{ ushort(3371) };
inline constexpr phrase<> lng_premium_summary_subtitle_no_ads{ ushort(3372) };
inline constexpr phrase<> lng_premium_summary_about_no_ads{ ushort(3373) };
inline constexpr phrase<> lng_premium_summary_subtitle_emoji_status{ ushort(3374) };
inline constexpr phrase<> lng_premium_summary_about_emoji_status{ ushort(3375) };
inline constexpr phrase<> lng_premium_summary_subtitle_infinite_reactions{ ushort(3376) };
inline constexpr phrase<> lng_premium_summary_about_infinite_reactions{ ushort(3377) };
inline constexpr phrase<> lng_premium_summary_subtitle_tags_for_messages{ ushort(3378) };
inline constexpr phrase<> lng_premium_summary_about_tags_for_messages{ ushort(3379) };
inline constexpr phrase<> lng_premium_summary_subtitle_last_seen{ ushort(3380) };
inline constexpr phrase<> lng_premium_summary_about_last_seen{ ushort(3381) };
inline constexpr phrase<> lng_premium_summary_subtitle_message_privacy{ ushort(3382) };
inline constexpr phrase<> lng_premium_summary_about_message_privacy{ ushort(3383) };
inline constexpr phrase<> lng_premium_summary_subtitle_premium_stickers{ ushort(3384) };
inline constexpr phrase<> lng_premium_summary_about_premium_stickers{ ushort(3385) };
inline constexpr phrase<> lng_premium_summary_subtitle_animated_emoji{ ushort(3386) };
inline constexpr phrase<> lng_premium_summary_about_animated_emoji{ ushort(3387) };
inline constexpr phrase<> lng_premium_summary_subtitle_advanced_chat_management{ ushort(3388) };
inline constexpr phrase<> lng_premium_summary_about_advanced_chat_management{ ushort(3389) };
inline constexpr phrase<> lng_premium_summary_subtitle_profile_badge{ ushort(3390) };
inline constexpr phrase<> lng_premium_summary_about_profile_badge{ ushort(3391) };
inline constexpr phrase<> lng_premium_summary_subtitle_animated_userpics{ ushort(3392) };
inline constexpr phrase<> lng_premium_summary_about_animated_userpics{ ushort(3393) };
inline constexpr phrase<> lng_premium_summary_subtitle_translation{ ushort(3394) };
inline constexpr phrase<> lng_premium_summary_about_translation{ ushort(3395) };
inline constexpr phrase<> lng_premium_summary_subtitle_business{ ushort(3396) };
inline constexpr phrase<> lng_premium_summary_about_business{ ushort(3397) };
inline constexpr phrase<> lng_premium_summary_subtitle_effects{ ushort(3398) };
inline constexpr phrase<> lng_premium_summary_about_effects{ ushort(3399) };
inline constexpr phrase<> lng_premium_summary_subtitle_filter_tags{ ushort(3400) };
inline constexpr phrase<> lng_premium_summary_about_filter_tags{ ushort(3401) };
inline constexpr phrase<> lng_premium_summary_subtitle_todo_lists{ ushort(3402) };
inline constexpr phrase<> lng_premium_summary_about_todo_lists{ ushort(3403) };
inline constexpr phrase<> lng_premium_summary_subtitle_peer_colors{ ushort(3404) };
inline constexpr phrase<> lng_premium_summary_about_peer_colors{ ushort(3405) };
inline constexpr phrase<> lng_premium_summary_subtitle_gifts{ ushort(3406) };
inline constexpr phrase<> lng_premium_summary_about_gifts{ ushort(3407) };
inline constexpr phrase<> lng_premium_summary_bottom_subtitle{ ushort(3408) };
inline constexpr phrase<> lng_premium_summary_bottom_about{ ushort(3409) };
inline constexpr phrase<lngtag_cost> lng_premium_summary_button{ ushort(3410) };
inline constexpr phrase<> lng_premium_summary_new_badge{ ushort(3411) };
inline constexpr phrase<> lng_soon_badge{ ushort(3412) };
inline constexpr phrase<> lng_premium_success{ ushort(3413) };
inline constexpr phrase<> lng_premium_unavailable{ ushort(3414) };
inline constexpr phrase<> lng_premium_stories_subtitle_order{ ushort(3415) };
inline constexpr phrase<> lng_premium_stories_about_order{ ushort(3416) };
inline constexpr phrase<> lng_premium_stories_subtitle_stealth{ ushort(3417) };
inline constexpr phrase<> lng_premium_stories_about_stealth{ ushort(3418) };
inline constexpr phrase<> lng_premium_stories_subtitle_views{ ushort(3419) };
inline constexpr phrase<> lng_premium_stories_about_views{ ushort(3420) };
inline constexpr phrase<> lng_premium_stories_subtitle_expiration{ ushort(3421) };
inline constexpr phrase<> lng_premium_stories_about_expiration{ ushort(3422) };
inline constexpr phrase<> lng_premium_stories_subtitle_download{ ushort(3423) };
inline constexpr phrase<> lng_premium_stories_about_download{ ushort(3424) };
inline constexpr phrase<> lng_premium_stories_subtitle_caption{ ushort(3425) };
inline constexpr phrase<> lng_premium_stories_about_caption{ ushort(3426) };
inline constexpr phrase<> lng_premium_stories_subtitle_links{ ushort(3427) };
inline constexpr phrase<> lng_premium_stories_about_links{ ushort(3428) };
inline constexpr phrase<> lng_premium_stories_about_mobile{ ushort(3429) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_channels{ ushort(3430) };
inline constexpr phrase<lngtag_count> lng_premium_double_limits_about_channels{ ushort(3431) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_pins{ ushort(3437) };
inline constexpr phrase<lngtag_count> lng_premium_double_limits_about_pins{ ushort(3438) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_links{ ushort(3444) };
inline constexpr phrase<lngtag_count> lng_premium_double_limits_about_links{ ushort(3445) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_gifs{ ushort(3451) };
inline constexpr phrase<lngtag_count> lng_premium_double_limits_about_gifs{ ushort(3452) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_stickers{ ushort(3458) };
inline constexpr phrase<lngtag_count> lng_premium_double_limits_about_stickers{ ushort(3459) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_bio{ ushort(3465) };
inline constexpr phrase<> lng_premium_double_limits_about_bio{ ushort(3466) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_captions{ ushort(3467) };
inline constexpr phrase<> lng_premium_double_limits_about_captions{ ushort(3468) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_folders{ ushort(3469) };
inline constexpr phrase<lngtag_count> lng_premium_double_limits_about_folders{ ushort(3470) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_folder_chats{ ushort(3476) };
inline constexpr phrase<lngtag_count> lng_premium_double_limits_about_folder_chats{ ushort(3477) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_accounts{ ushort(3483) };
inline constexpr phrase<lngtag_count> lng_premium_double_limits_about_accounts{ ushort(3484) };
inline constexpr phrase<> lng_premium_double_limits_subtitle_similar_channels{ ushort(3490) };
inline constexpr phrase<lngtag_count> lng_premium_double_limits_about_similar_channels{ ushort(3491) };
inline constexpr phrase<> lng_premium_gift_title{ ushort(3497) };
inline constexpr phrase<lngtag_user> lng_premium_gift_about{ ushort(3498) };
inline constexpr phrase<lngtag_cost> lng_premium_gift_button{ ushort(3499) };
inline constexpr phrase<lngtag_cost> lng_premium_gift_per{ ushort(3500) };
inline constexpr phrase<lngtag_link> lng_premium_gift_terms{ ushort(3501) };
inline constexpr phrase<> lng_premium_gift_terms_link{ ushort(3502) };
inline constexpr phrase<lngtag_user> lng_premium_gifts_about_user1{ ushort(3503) };
inline constexpr phrase<lngtag_user, lngtag_second_user> lng_premium_gifts_about_user2{ ushort(3504) };
inline constexpr phrase<lngtag_user, lngtag_second_user, lngtag_name> lng_premium_gifts_about_user3{ ushort(3505) };
inline constexpr phrase<lngtag_count, lngtag_user, lngtag_second_user, lngtag_name> lng_premium_gifts_about_user_more{ ushort(3506) };
inline constexpr phrase<lngtag_count, lngtag_emoji> lng_premium_gifts_about_reward{ ushort(3512) };
inline constexpr phrase<> lng_premium_gifts_about_paid_title{ ushort(3518) };
inline constexpr phrase<lngtag_user> lng_premium_gifts_about_paid1{ ushort(3519) };
inline constexpr phrase<lngtag_user, lngtag_second_user> lng_premium_gifts_about_paid2{ ushort(3520) };
inline constexpr phrase<lngtag_user, lngtag_second_user, lngtag_name> lng_premium_gifts_about_paid3{ ushort(3521) };
inline constexpr phrase<lngtag_count, lngtag_user, lngtag_second_user, lngtag_name> lng_premium_gifts_about_paid_more{ ushort(3522) };
inline constexpr phrase<lngtag_count> lng_premium_gifts_about_paid_below{ ushort(3528) };
inline constexpr phrase<> lng_premium_gifts_summary_subtitle{ ushort(3534) };
inline constexpr phrase<lngtag_link, lngtag_policy> lng_premium_gifts_terms{ ushort(3535) };
inline constexpr phrase<> lng_premium_gifts_terms_policy{ ushort(3536) };
inline constexpr phrase<> lng_business_title{ ushort(3537) };
inline constexpr phrase<> lng_business_about{ ushort(3538) };
inline constexpr phrase<> lng_business_unlocked{ ushort(3539) };
inline constexpr phrase<> lng_business_subtitle_location{ ushort(3540) };
inline constexpr phrase<> lng_business_about_location{ ushort(3541) };
inline constexpr phrase<> lng_business_subtitle_opening_hours{ ushort(3542) };
inline constexpr phrase<> lng_business_about_opening_hours{ ushort(3543) };
inline constexpr phrase<> lng_business_subtitle_quick_replies{ ushort(3544) };
inline constexpr phrase<> lng_business_about_quick_replies{ ushort(3545) };
inline constexpr phrase<> lng_business_subtitle_greeting_messages{ ushort(3546) };
inline constexpr phrase<> lng_business_about_greeting_messages{ ushort(3547) };
inline constexpr phrase<> lng_business_subtitle_away_messages{ ushort(3548) };
inline constexpr phrase<> lng_business_about_away_messages{ ushort(3549) };
inline constexpr phrase<> lng_business_subtitle_chatbots{ ushort(3550) };
inline constexpr phrase<> lng_business_about_chatbots{ ushort(3551) };
inline constexpr phrase<> lng_business_subtitle_chat_intro{ ushort(3552) };
inline constexpr phrase<> lng_business_about_chat_intro{ ushort(3553) };
inline constexpr phrase<> lng_business_subtitle_chat_links{ ushort(3554) };
inline constexpr phrase<> lng_business_about_chat_links{ ushort(3555) };
inline constexpr phrase<> lng_business_subtitle_sponsored{ ushort(3556) };
inline constexpr phrase<> lng_business_button_sponsored{ ushort(3557) };
inline constexpr phrase<lngtag_link> lng_business_about_sponsored{ ushort(3558) };
inline constexpr phrase<lngtag_emoji> lng_business_about_sponsored_link{ ushort(3559) };
inline constexpr phrase<> lng_business_about_sponsored_url{ ushort(3560) };
inline constexpr phrase<> lng_credits_summary_title{ ushort(3561) };
inline constexpr phrase<> lng_credits_summary_about{ ushort(3562) };
inline constexpr phrase<> lng_credits_currency_summary_title{ ushort(3563) };
inline constexpr phrase<> lng_credits_currency_summary_about{ ushort(3564) };
inline constexpr phrase<> lng_credits_currency_summary_subtitle{ ushort(3565) };
inline constexpr phrase<> lng_credits_currency_summary_in_button{ ushort(3566) };
inline constexpr phrase<> lng_credits_currency_summary_in_subtitle{ ushort(3567) };
inline constexpr phrase<> lng_credits_summary_options_subtitle{ ushort(3568) };
inline constexpr phrase<lngtag_count> lng_credits_summary_options_credits{ ushort(3569) };
inline constexpr phrase<> lng_credits_summary_options_more{ ushort(3575) };
inline constexpr phrase<lngtag_link> lng_credits_summary_options_about{ ushort(3576) };
inline constexpr phrase<> lng_credits_summary_options_about_link{ ushort(3577) };
inline constexpr phrase<> lng_credits_summary_options_about_url{ ushort(3578) };
inline constexpr phrase<> lng_credits_summary_earn_title{ ushort(3579) };
inline constexpr phrase<> lng_credits_summary_earn_about{ ushort(3580) };
inline constexpr phrase<> lng_credits_summary_history_tab_full{ ushort(3581) };
inline constexpr phrase<> lng_credits_summary_history_tab_in{ ushort(3582) };
inline constexpr phrase<> lng_credits_summary_history_tab_out{ ushort(3583) };
inline constexpr phrase<> lng_credits_summary_history_entry_inner_in{ ushort(3584) };
inline constexpr phrase<> lng_credits_summary_balance{ ushort(3585) };
inline constexpr phrase<lngtag_amount> lng_credits_commission{ ushort(3586) };
inline constexpr phrase<> lng_credits_paid_messages_fee_live_reaction{ ushort(3587) };
inline constexpr phrase<lngtag_count> lng_credits_paid_messages_fee{ ushort(3588) };
inline constexpr phrase<lngtag_percent, lngtag_link> lng_credits_paid_messages_fee_about{ ushort(3594) };
inline constexpr phrase<lngtag_emoji> lng_credits_paid_messages_fee_about_link{ ushort(3595) };
inline constexpr phrase<> lng_credits_paid_messages_full{ ushort(3596) };
inline constexpr phrase<> lng_credits_premium_gift_duration{ ushort(3597) };
inline constexpr phrase<> lng_credits_more_options{ ushort(3598) };
inline constexpr phrase<> lng_credits_balance_me{ ushort(3599) };
inline constexpr phrase<lngtag_emoji, lngtag_amount> lng_credits_balance_me_count{ ushort(3600) };
inline constexpr phrase<> lng_credits_buy_button{ ushort(3601) };
inline constexpr phrase<lngtag_emoji> lng_credits_topup_button{ ushort(3602) };
inline constexpr phrase<> lng_credits_buy_button_short{ ushort(3603) };
inline constexpr phrase<> lng_credits_stats_button_short{ ushort(3604) };
inline constexpr phrase<> lng_credits_stats_button{ ushort(3605) };
inline constexpr phrase<> lng_credits_gift_button{ ushort(3606) };
inline constexpr phrase<> lng_credits_earn_button{ ushort(3607) };
inline constexpr phrase<> lng_credits_box_out_title{ ushort(3608) };
inline constexpr phrase<lngtag_count, lngtag_text, lngtag_bot> lng_credits_box_out_sure{ ushort(3609) };
inline constexpr phrase<lngtag_count, lngtag_media, lngtag_chat> lng_credits_box_out_media{ ushort(3615) };
inline constexpr phrase<lngtag_count, lngtag_media, lngtag_user> lng_credits_box_out_media_user{ ushort(3621) };
inline constexpr phrase<lngtag_count, lngtag_title, lngtag_recipient> lng_credits_box_out_subscription_bot{ ushort(3627) };
inline constexpr phrase<lngtag_count, lngtag_title, lngtag_recipient> lng_credits_box_out_subscription_business{ ushort(3633) };
inline constexpr phrase<lngtag_count, lngtag_emoji> lng_credits_box_out_subscription_confirm{ ushort(3639) };
inline constexpr phrase<> lng_credits_box_out_photo{ ushort(3645) };
inline constexpr phrase<lngtag_count> lng_credits_box_out_photos{ ushort(3646) };
inline constexpr phrase<> lng_credits_box_out_video{ ushort(3652) };
inline constexpr phrase<lngtag_count> lng_credits_box_out_videos{ ushort(3653) };
inline constexpr phrase<lngtag_photo, lngtag_video> lng_credits_box_out_both{ ushort(3659) };
inline constexpr phrase<lngtag_count, lngtag_emoji> lng_credits_box_out_confirm{ ushort(3660) };
inline constexpr phrase<lngtag_link> lng_credits_box_out_about{ ushort(3666) };
inline constexpr phrase<> lng_credits_box_out_about_link{ ushort(3667) };
inline constexpr phrase<> lng_credits_media_done_title{ ushort(3668) };
inline constexpr phrase<lngtag_count, lngtag_chat> lng_credits_media_done_text{ ushort(3669) };
inline constexpr phrase<lngtag_count, lngtag_user> lng_credits_media_done_text_user{ ushort(3675) };
inline constexpr phrase<> lng_credits_summary_in_toast_title{ ushort(3681) };
inline constexpr phrase<lngtag_count> lng_credits_summary_in_toast_about{ ushort(3682) };
inline constexpr phrase<> lng_credits_box_history_entry_peer{ ushort(3688) };
inline constexpr phrase<> lng_credits_box_history_entry_peer_in{ ushort(3689) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_from{ ushort(3690) };
inline constexpr phrase<> lng_credits_box_history_entry_via{ ushort(3691) };
inline constexpr phrase<> lng_credits_box_history_entry_play_market{ ushort(3692) };
inline constexpr phrase<> lng_credits_box_history_entry_app_store{ ushort(3693) };
inline constexpr phrase<> lng_credits_box_history_entry_fragment{ ushort(3694) };
inline constexpr phrase<> lng_credits_box_history_entry_anonymous{ ushort(3695) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_name{ ushort(3696) };
inline constexpr phrase<> lng_credits_box_history_entry_giveaway_name{ ushort(3697) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_sent{ ushort(3698) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_converted{ ushort(3699) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_transfer{ ushort(3700) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_unavailable{ ushort(3701) };
inline constexpr phrase<lngtag_name> lng_credits_box_history_entry_gift_released{ ushort(3702) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_sold_out{ ushort(3703) };
inline constexpr phrase<lngtag_user, lngtag_link> lng_credits_box_history_entry_gift_out_about{ ushort(3704) };
inline constexpr phrase<lngtag_link> lng_credits_box_history_entry_gift_in_about{ ushort(3705) };
inline constexpr phrase<lngtag_emoji> lng_credits_box_history_entry_gift_about_link{ ushort(3706) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_examples{ ushort(3707) };
inline constexpr phrase<> lng_credits_box_history_entry_ads{ ushort(3708) };
inline constexpr phrase<> lng_credits_box_history_entry_premium_bot{ ushort(3709) };
inline constexpr phrase<> lng_credits_box_history_entry_currency_in{ ushort(3710) };
inline constexpr phrase<> lng_credits_box_history_entry_posts_search{ ushort(3711) };
inline constexpr phrase<> lng_credits_box_history_entry_api{ ushort(3712) };
inline constexpr phrase<lngtag_count> lng_credits_box_history_entry_floodskip_about{ ushort(3713) };
inline constexpr phrase<> lng_credits_box_history_entry_floodskip_row{ ushort(3719) };
inline constexpr phrase<> lng_credits_box_history_entry_via_premium_bot{ ushort(3720) };
inline constexpr phrase<> lng_credits_box_history_entry_id{ ushort(3721) };
inline constexpr phrase<> lng_credits_box_history_entry_id_copied{ ushort(3722) };
inline constexpr phrase<> lng_credits_box_history_entry_reason_star_ref{ ushort(3723) };
inline constexpr phrase<> lng_credits_box_history_entry_affiliate{ ushort(3724) };
inline constexpr phrase<> lng_credits_box_history_entry_miniapp{ ushort(3725) };
inline constexpr phrase<> lng_credits_box_history_entry_referred{ ushort(3726) };
inline constexpr phrase<> lng_credits_box_history_entry_success_date{ ushort(3727) };
inline constexpr phrase<> lng_credits_box_history_entry_success_url{ ushort(3728) };
inline constexpr phrase<> lng_credits_box_history_entry_media{ ushort(3729) };
inline constexpr phrase<> lng_credits_box_history_entry_message{ ushort(3730) };
inline constexpr phrase<lngtag_link> lng_credits_box_history_entry_about{ ushort(3731) };
inline constexpr phrase<> lng_credits_box_history_entry_about_link{ ushort(3732) };
inline constexpr phrase<> lng_credits_box_history_entry_reaction_name{ ushort(3733) };
inline constexpr phrase<> lng_credits_box_history_entry_subscription{ ushort(3734) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_upgrade{ ushort(3735) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_sold{ ushort(3736) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_bought{ ushort(3737) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_sold_to{ ushort(3738) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_full_price{ ushort(3739) };
inline constexpr phrase<> lng_credits_box_history_entry_gift_bought_from{ ushort(3740) };
inline constexpr phrase<> lng_credits_subscription_section{ ushort(3741) };
inline constexpr phrase<> lng_credits_box_subscription_title{ ushort(3742) };
inline constexpr phrase<lngtag_emoji, lngtag_cost> lng_credits_subscription_subtitle{ ushort(3743) };
inline constexpr phrase<lngtag_total> lng_credits_subscriber_subtitle{ ushort(3744) };
inline constexpr phrase<> lng_credits_subscription_row_to{ ushort(3745) };
inline constexpr phrase<> lng_credits_subscription_row_to_bot{ ushort(3746) };
inline constexpr phrase<> lng_credits_subscription_row_to_business{ ushort(3747) };
inline constexpr phrase<> lng_credits_subscription_row_from{ ushort(3748) };
inline constexpr phrase<> lng_credits_subscription_row_next_on{ ushort(3749) };
inline constexpr phrase<> lng_credits_subscription_row_next_off{ ushort(3750) };
inline constexpr phrase<> lng_credits_subscription_row_next_none{ ushort(3751) };
inline constexpr phrase<> lng_credits_subscription_on_button{ ushort(3752) };
inline constexpr phrase<lngtag_date> lng_credits_subscription_on_about{ ushort(3753) };
inline constexpr phrase<> lng_credits_subscription_off_button{ ushort(3754) };
inline constexpr phrase<> lng_credits_subscription_off_rejoin_button{ ushort(3755) };
inline constexpr phrase<> lng_credits_subscription_off_about{ ushort(3756) };
inline constexpr phrase<lngtag_bot> lng_credits_subscription_off_by_bot_about{ ushort(3757) };
inline constexpr phrase<lngtag_date> lng_credits_subscription_status_on{ ushort(3758) };
inline constexpr phrase<lngtag_date> lng_credits_subscription_status_off{ ushort(3759) };
inline constexpr phrase<lngtag_date> lng_credits_subscription_status_none{ ushort(3760) };
inline constexpr phrase<> lng_credits_subscription_status_off_right{ ushort(3761) };
inline constexpr phrase<> lng_credits_subscription_status_none_right{ ushort(3762) };
inline constexpr phrase<> lng_credits_subscription_status_off_by_bot_right{ ushort(3763) };
inline constexpr phrase<lngtag_count> lng_credits_small_balance_title{ ushort(3764) };
inline constexpr phrase<lngtag_bot> lng_credits_small_balance_about{ ushort(3770) };
inline constexpr phrase<lngtag_channel> lng_credits_small_balance_reaction{ ushort(3771) };
inline constexpr phrase<lngtag_name> lng_credits_small_balance_video_stream{ ushort(3772) };
inline constexpr phrase<lngtag_channel> lng_credits_small_balance_subscribe{ ushort(3773) };
inline constexpr phrase<lngtag_user> lng_credits_small_balance_star_gift{ ushort(3774) };
inline constexpr phrase<lngtag_user> lng_credits_small_balance_for_message{ ushort(3775) };
inline constexpr phrase<> lng_credits_small_balance_for_messages{ ushort(3776) };
inline constexpr phrase<lngtag_channel> lng_credits_small_balance_for_suggest{ ushort(3777) };
inline constexpr phrase<> lng_credits_small_balance_for_offer{ ushort(3778) };
inline constexpr phrase<> lng_credits_small_balance_for_search{ ushort(3779) };
inline constexpr phrase<> lng_credits_small_balance_fallback{ ushort(3780) };
inline constexpr phrase<> lng_credits_purchase_blocked{ ushort(3781) };
inline constexpr phrase<lngtag_link> lng_credits_enough{ ushort(3782) };
inline constexpr phrase<> lng_credits_enough_link{ ushort(3783) };
inline constexpr phrase<> lng_credits_gift_title{ ushort(3784) };
inline constexpr phrase<> lng_location_title{ ushort(3785) };
inline constexpr phrase<> lng_location_about{ ushort(3786) };
inline constexpr phrase<> lng_location_address{ ushort(3787) };
inline constexpr phrase<> lng_location_set_map{ ushort(3788) };
inline constexpr phrase<> lng_location_fallback{ ushort(3789) };
inline constexpr phrase<> lng_hours_title{ ushort(3790) };
inline constexpr phrase<> lng_hours_about{ ushort(3791) };
inline constexpr phrase<> lng_hours_show{ ushort(3792) };
inline constexpr phrase<> lng_hours_time_zone{ ushort(3793) };
inline constexpr phrase<> lng_hours_monday{ ushort(3794) };
inline constexpr phrase<> lng_hours_tuesday{ ushort(3795) };
inline constexpr phrase<> lng_hours_wednesday{ ushort(3796) };
inline constexpr phrase<> lng_hours_thursday{ ushort(3797) };
inline constexpr phrase<> lng_hours_friday{ ushort(3798) };
inline constexpr phrase<> lng_hours_saturday{ ushort(3799) };
inline constexpr phrase<> lng_hours_sunday{ ushort(3800) };
inline constexpr phrase<> lng_hours_closed{ ushort(3801) };
inline constexpr phrase<> lng_hours_open_full{ ushort(3802) };
inline constexpr phrase<lngtag_time> lng_hours_next_day{ ushort(3803) };
inline constexpr phrase<lngtag_time> lng_hours_on_next_day{ ushort(3804) };
inline constexpr phrase<> lng_hours_time_zone_title{ ushort(3805) };
inline constexpr phrase<> lng_hours_add_button{ ushort(3806) };
inline constexpr phrase<> lng_hours_opening{ ushort(3807) };
inline constexpr phrase<> lng_hours_closing{ ushort(3808) };
inline constexpr phrase<> lng_hours_remove{ ushort(3809) };
inline constexpr phrase<> lng_hours_about_day{ ushort(3810) };
inline constexpr phrase<> lng_replies_title{ ushort(3811) };
inline constexpr phrase<> lng_replies_about{ ushort(3812) };
inline constexpr phrase<> lng_replies_add{ ushort(3813) };
inline constexpr phrase<> lng_replies_add_title{ ushort(3814) };
inline constexpr phrase<> lng_replies_add_shortcut{ ushort(3815) };
inline constexpr phrase<> lng_replies_add_placeholder{ ushort(3816) };
inline constexpr phrase<> lng_replies_add_exists{ ushort(3817) };
inline constexpr phrase<> lng_replies_empty_title{ ushort(3818) };
inline constexpr phrase<lngtag_shortcut> lng_replies_empty_about{ ushort(3819) };
inline constexpr phrase<> lng_replies_remove_title{ ushort(3820) };
inline constexpr phrase<> lng_replies_remove_text{ ushort(3821) };
inline constexpr phrase<> lng_replies_edit_title{ ushort(3822) };
inline constexpr phrase<> lng_replies_edit_about{ ushort(3823) };
inline constexpr phrase<> lng_replies_message_placeholder{ ushort(3824) };
inline constexpr phrase<> lng_replies_delete_sure{ ushort(3825) };
inline constexpr phrase<> lng_replies_error_occupied{ ushort(3826) };
inline constexpr phrase<> lng_replies_edit_button{ ushort(3827) };
inline constexpr phrase<> lng_greeting_title{ ushort(3828) };
inline constexpr phrase<> lng_greeting_about{ ushort(3829) };
inline constexpr phrase<> lng_greeting_enable{ ushort(3830) };
inline constexpr phrase<> lng_greeting_create{ ushort(3831) };
inline constexpr phrase<> lng_greeting_recipients{ ushort(3832) };
inline constexpr phrase<> lng_greeting_select{ ushort(3833) };
inline constexpr phrase<> lng_greeting_period_title{ ushort(3834) };
inline constexpr phrase<> lng_greeting_period_about{ ushort(3835) };
inline constexpr phrase<> lng_greeting_empty_title{ ushort(3836) };
inline constexpr phrase<> lng_greeting_empty_about{ ushort(3837) };
inline constexpr phrase<> lng_greeting_message_placeholder{ ushort(3838) };
inline constexpr phrase<> lng_greeting_limit_reached{ ushort(3839) };
inline constexpr phrase<> lng_greeting_recipients_empty{ ushort(3840) };
inline constexpr phrase<> lng_away_title{ ushort(3841) };
inline constexpr phrase<> lng_away_about{ ushort(3842) };
inline constexpr phrase<> lng_away_enable{ ushort(3843) };
inline constexpr phrase<> lng_away_create{ ushort(3844) };
inline constexpr phrase<> lng_away_schedule{ ushort(3845) };
inline constexpr phrase<> lng_away_schedule_always{ ushort(3846) };
inline constexpr phrase<> lng_away_schedule_outside{ ushort(3847) };
inline constexpr phrase<> lng_away_schedule_custom{ ushort(3848) };
inline constexpr phrase<> lng_away_custom_start{ ushort(3849) };
inline constexpr phrase<> lng_away_custom_end{ ushort(3850) };
inline constexpr phrase<> lng_away_offline_only{ ushort(3851) };
inline constexpr phrase<> lng_away_offline_only_about{ ushort(3852) };
inline constexpr phrase<> lng_away_recipients{ ushort(3853) };
inline constexpr phrase<> lng_away_select{ ushort(3854) };
inline constexpr phrase<> lng_away_empty_title{ ushort(3855) };
inline constexpr phrase<> lng_away_empty_about{ ushort(3856) };
inline constexpr phrase<> lng_away_message_placeholder{ ushort(3857) };
inline constexpr phrase<> lng_away_limit_reached{ ushort(3858) };
inline constexpr phrase<> lng_business_edit_messages{ ushort(3859) };
inline constexpr phrase<lngtag_count> lng_business_limit_reached{ ushort(3860) };
inline constexpr phrase<> lng_chatbots_title{ ushort(3866) };
inline constexpr phrase<lngtag_link> lng_chatbots_about{ ushort(3867) };
inline constexpr phrase<> lng_chatbots_about_link{ ushort(3868) };
inline constexpr phrase<> lng_chatbots_placeholder{ ushort(3869) };
inline constexpr phrase<> lng_chatbots_add_about{ ushort(3870) };
inline constexpr phrase<> lng_chatbots_access_title{ ushort(3871) };
inline constexpr phrase<> lng_chatbots_all_except{ ushort(3872) };
inline constexpr phrase<> lng_chatbots_selected{ ushort(3873) };
inline constexpr phrase<> lng_chatbots_excluded_title{ ushort(3874) };
inline constexpr phrase<> lng_chatbots_exclude_button{ ushort(3875) };
inline constexpr phrase<> lng_chatbots_included_title{ ushort(3876) };
inline constexpr phrase<> lng_chatbots_include_button{ ushort(3877) };
inline constexpr phrase<> lng_chatbots_exclude_about{ ushort(3878) };
inline constexpr phrase<> lng_chatbots_permissions_title{ ushort(3879) };
inline constexpr phrase<> lng_chatbots_warning_title{ ushort(3880) };
inline constexpr phrase<lngtag_bot> lng_chatbots_warning_both_text{ ushort(3881) };
inline constexpr phrase<lngtag_bot> lng_chatbots_warning_gifts_text{ ushort(3882) };
inline constexpr phrase<lngtag_bot> lng_chatbots_warning_stars_text{ ushort(3883) };
inline constexpr phrase<lngtag_bot> lng_chatbots_warning_username_text{ ushort(3884) };
inline constexpr phrase<> lng_chatbots_manage_messages{ ushort(3885) };
inline constexpr phrase<> lng_chatbots_read{ ushort(3886) };
inline constexpr phrase<> lng_chatbots_reply{ ushort(3887) };
inline constexpr phrase<> lng_chatbots_mark_as_read{ ushort(3888) };
inline constexpr phrase<> lng_chatbots_delete_sent{ ushort(3889) };
inline constexpr phrase<> lng_chatbots_delete_received{ ushort(3890) };
inline constexpr phrase<> lng_chatbots_manage_profile{ ushort(3891) };
inline constexpr phrase<> lng_chatbots_edit_name{ ushort(3892) };
inline constexpr phrase<> lng_chatbots_edit_bio{ ushort(3893) };
inline constexpr phrase<> lng_chatbots_edit_userpic{ ushort(3894) };
inline constexpr phrase<> lng_chatbots_edit_username{ ushort(3895) };
inline constexpr phrase<> lng_chatbots_manage_gifts{ ushort(3896) };
inline constexpr phrase<> lng_chatbots_view_gifts{ ushort(3897) };
inline constexpr phrase<> lng_chatbots_sell_gifts{ ushort(3898) };
inline constexpr phrase<> lng_chatbots_gift_settings{ ushort(3899) };
inline constexpr phrase<> lng_chatbots_transfer_gifts{ ushort(3900) };
inline constexpr phrase<> lng_chatbots_transfer_stars{ ushort(3901) };
inline constexpr phrase<> lng_chatbots_manage_stories{ ushort(3902) };
inline constexpr phrase<> lng_chatbots_remove{ ushort(3903) };
inline constexpr phrase<> lng_chatbots_not_found{ ushort(3904) };
inline constexpr phrase<> lng_chatbots_not_supported{ ushort(3905) };
inline constexpr phrase<> lng_chatbots_add{ ushort(3906) };
inline constexpr phrase<> lng_chatbots_info_url{ ushort(3907) };
inline constexpr phrase<> lng_chatbot_status_can_reply{ ushort(3908) };
inline constexpr phrase<> lng_chatbot_status_paused{ ushort(3909) };
inline constexpr phrase<> lng_chatbot_status_views{ ushort(3910) };
inline constexpr phrase<> lng_chatbot_button_pause{ ushort(3911) };
inline constexpr phrase<> lng_chatbot_button_resume{ ushort(3912) };
inline constexpr phrase<> lng_chatbot_menu_manage{ ushort(3913) };
inline constexpr phrase<> lng_chatbot_menu_remove{ ushort(3914) };
inline constexpr phrase<> lng_chatbot_menu_revoke{ ushort(3915) };
inline constexpr phrase<> lng_chat_intro_title{ ushort(3916) };
inline constexpr phrase<> lng_chat_intro_subtitle{ ushort(3917) };
inline constexpr phrase<> lng_chat_intro_default_title{ ushort(3918) };
inline constexpr phrase<> lng_chat_intro_default_message{ ushort(3919) };
inline constexpr phrase<> lng_chat_intro_enter_title{ ushort(3920) };
inline constexpr phrase<> lng_chat_intro_enter_message{ ushort(3921) };
inline constexpr phrase<> lng_chat_intro_choose_sticker{ ushort(3922) };
inline constexpr phrase<> lng_chat_intro_random_sticker{ ushort(3923) };
inline constexpr phrase<> lng_chat_intro_about{ ushort(3924) };
inline constexpr phrase<> lng_chat_intro_reset{ ushort(3925) };
inline constexpr phrase<> lng_chat_links_title{ ushort(3926) };
inline constexpr phrase<> lng_chat_links_about{ ushort(3927) };
inline constexpr phrase<> lng_chat_links_create_link{ ushort(3928) };
inline constexpr phrase<lngtag_links> lng_chat_links_footer{ ushort(3929) };
inline constexpr phrase<lngtag_username, lngtag_link> lng_chat_links_footer_both{ ushort(3930) };
inline constexpr phrase<> lng_chat_links_no_clicks{ ushort(3931) };
inline constexpr phrase<lngtag_count> lng_chat_links_clicks{ ushort(3932) };
inline constexpr phrase<> lng_chat_link_new_title{ ushort(3938) };
inline constexpr phrase<> lng_chat_link_edit_title{ ushort(3939) };
inline constexpr phrase<> lng_chat_link_description{ ushort(3940) };
inline constexpr phrase<> lng_chat_link_placeholder{ ushort(3941) };
inline constexpr phrase<> lng_chat_link_saved{ ushort(3942) };
inline constexpr phrase<> lng_chat_link_copy{ ushort(3943) };
inline constexpr phrase<> lng_chat_link_share{ ushort(3944) };
inline constexpr phrase<> lng_chat_link_rename{ ushort(3945) };
inline constexpr phrase<> lng_chat_link_delete{ ushort(3946) };
inline constexpr phrase<> lng_chat_link_name{ ushort(3947) };
inline constexpr phrase<> lng_chat_link_name_about{ ushort(3948) };
inline constexpr phrase<> lng_chat_link_delete_sure{ ushort(3949) };
inline constexpr phrase<> lng_chat_link_qr_title{ ushort(3950) };
inline constexpr phrase<> lng_chat_link_qr_about{ ushort(3951) };
inline constexpr phrase<> lng_chat_link_copied{ ushort(3952) };
inline constexpr phrase<> lng_boost_channel_button{ ushort(3953) };
inline constexpr phrase<> lng_boost_group_button{ ushort(3954) };
inline constexpr phrase<> lng_boost_again_button{ ushort(3955) };
inline constexpr phrase<> lng_boost_group_about{ ushort(3956) };
inline constexpr phrase<lngtag_count> lng_boost_level{ ushort(3957) };
inline constexpr phrase<lngtag_count> lng_boost_level_unlocks{ ushort(3963) };
inline constexpr phrase<> lng_boost_channel_title_first{ ushort(3969) };
inline constexpr phrase<> lng_boost_channel_title_first_group{ ushort(3970) };
inline constexpr phrase<lngtag_count, lngtag_channel> lng_boost_channel_needs_unlock{ ushort(3971) };
inline constexpr phrase<> lng_boost_channel_title_more{ ushort(3977) };
inline constexpr phrase<> lng_boost_channel_title_more_group{ ushort(3978) };
inline constexpr phrase<> lng_boost_channel_title_max{ ushort(3979) };
inline constexpr phrase<lngtag_channel> lng_boost_channel_you_title{ ushort(3980) };
inline constexpr phrase<> lng_boost_channel_reached_first{ ushort(3981) };
inline constexpr phrase<lngtag_count, lngtag_post> lng_boost_channel_reached_more{ ushort(3982) };
inline constexpr phrase<> lng_boost_channel_reached_first_group{ ushort(3988) };
inline constexpr phrase<lngtag_count, lngtag_post> lng_boost_channel_reached_more_group{ ushort(3989) };
inline constexpr phrase<lngtag_count> lng_boost_channel_post_stories{ ushort(3995) };
inline constexpr phrase<lngtag_channel> lng_boost_channel_features{ ushort(4001) };
inline constexpr phrase<> lng_boost_group_lift_restrictions{ ushort(4002) };
inline constexpr phrase<lngtag_count> lng_boost_group_lift_restrictions_many{ ushort(4003) };
inline constexpr phrase<> lng_boost_error_gifted_title{ ushort(4009) };
inline constexpr phrase<> lng_boost_error_gifted_text{ ushort(4010) };
inline constexpr phrase<> lng_boost_error_gifted_text_group{ ushort(4011) };
inline constexpr phrase<> lng_boost_need_more{ ushort(4012) };
inline constexpr phrase<lngtag_count, lngtag_channel> lng_boost_need_more_text{ ushort(4013) };
inline constexpr phrase<lngtag_count, lngtag_channel> lng_boost_need_more_again{ ushort(4019) };
inline constexpr phrase<> lng_boost_error_already_title{ ushort(4025) };
inline constexpr phrase<> lng_boost_error_already_text{ ushort(4026) };
inline constexpr phrase<> lng_boost_error_already_text_group{ ushort(4027) };
inline constexpr phrase<> lng_boost_error_premium_title{ ushort(4028) };
inline constexpr phrase<> lng_boost_error_premium_text_group{ ushort(4029) };
inline constexpr phrase<> lng_boost_error_premium_text{ ushort(4030) };
inline constexpr phrase<> lng_boost_error_premium_yes{ ushort(4031) };
inline constexpr phrase<> lng_boost_error_flood_title{ ushort(4032) };
inline constexpr phrase<lngtag_left> lng_boost_error_flood_text_group{ ushort(4033) };
inline constexpr phrase<lngtag_left> lng_boost_error_flood_text{ ushort(4034) };
inline constexpr phrase<lngtag_channel, lngtag_other> lng_boost_now_instead{ ushort(4035) };
inline constexpr phrase<> lng_boost_now_replace{ ushort(4036) };
inline constexpr phrase<> lng_boost_reassign_title{ ushort(4037) };
inline constexpr phrase<lngtag_channel, lngtag_gift> lng_boost_reassign_text{ ushort(4038) };
inline constexpr phrase<lngtag_count> lng_boost_reassign_gift{ ushort(4039) };
inline constexpr phrase<> lng_boost_remove_title{ ushort(4045) };
inline constexpr phrase<> lng_boost_reassign_button{ ushort(4046) };
inline constexpr phrase<lngtag_duration> lng_boost_available_in{ ushort(4047) };
inline constexpr phrase<lngtag_count> lng_boost_available_in_toast{ ushort(4048) };
inline constexpr phrase<lngtag_count, lngtag_channels> lng_boost_reassign_done{ ushort(4054) };
inline constexpr phrase<lngtag_count> lng_boost_reassign_channels{ ushort(4060) };
inline constexpr phrase<lngtag_count> lng_boost_reassign_groups{ ushort(4066) };
inline constexpr phrase<lngtag_count> lng_boost_reassign_mixed{ ushort(4072) };
inline constexpr phrase<> lng_boost_channel_title_color{ ushort(4078) };
inline constexpr phrase<lngtag_count> lng_boost_channel_needs_level_color{ ushort(4079) };
inline constexpr phrase<> lng_boost_channel_title_wallpaper{ ushort(4085) };
inline constexpr phrase<lngtag_count> lng_boost_channel_needs_level_wallpaper{ ushort(4086) };
inline constexpr phrase<lngtag_count> lng_boost_group_needs_level_wallpaper{ ushort(4092) };
inline constexpr phrase<> lng_boost_channel_title_status{ ushort(4098) };
inline constexpr phrase<lngtag_count> lng_boost_channel_needs_level_status{ ushort(4099) };
inline constexpr phrase<lngtag_count> lng_boost_group_needs_level_status{ ushort(4105) };
inline constexpr phrase<> lng_boost_channel_title_reactions{ ushort(4111) };
inline constexpr phrase<lngtag_count, lngtag_same_count> lng_boost_channel_needs_level_reactions{ ushort(4112) };
inline constexpr phrase<> lng_boost_channel_title_cpm{ ushort(4118) };
inline constexpr phrase<lngtag_count> lng_boost_channel_needs_level_cpm{ ushort(4119) };
inline constexpr phrase<> lng_boost_group_title_emoji{ ushort(4125) };
inline constexpr phrase<lngtag_count> lng_boost_group_needs_level_emoji{ ushort(4126) };
inline constexpr phrase<> lng_boost_channel_title_wear{ ushort(4132) };
inline constexpr phrase<lngtag_count> lng_boost_channel_needs_level_wear{ ushort(4133) };
inline constexpr phrase<> lng_boost_channel_ask{ ushort(4139) };
inline constexpr phrase<> lng_boost_channel_ask_button{ ushort(4140) };
inline constexpr phrase<> lng_boost_group_ask{ ushort(4141) };
inline constexpr phrase<> lng_boost_channel_title_autotranslate{ ushort(4142) };
inline constexpr phrase<lngtag_count> lng_boost_channel_needs_level_autotranslate{ ushort(4143) };
inline constexpr phrase<lngtag_count> lng_feature_stories{ ushort(4149) };
inline constexpr phrase<lngtag_count> lng_feature_reactions{ ushort(4155) };
inline constexpr phrase<lngtag_count> lng_feature_name_color_channel{ ushort(4161) };
inline constexpr phrase<lngtag_count> lng_feature_link_style_channel{ ushort(4167) };
inline constexpr phrase<> lng_feature_link_emoji{ ushort(4173) };
inline constexpr phrase<> lng_feature_emoji_status{ ushort(4174) };
inline constexpr phrase<lngtag_count> lng_feature_backgrounds_channel{ ushort(4175) };
inline constexpr phrase<> lng_feature_custom_background_channel{ ushort(4181) };
inline constexpr phrase<lngtag_count> lng_feature_backgrounds_group{ ushort(4182) };
inline constexpr phrase<> lng_feature_custom_background_group{ ushort(4188) };
inline constexpr phrase<> lng_feature_custom_emoji_pack{ ushort(4189) };
inline constexpr phrase<> lng_feature_transcribe{ ushort(4190) };
inline constexpr phrase<> lng_feature_autotranslate{ ushort(4191) };
inline constexpr phrase<lngtag_count> lng_feature_profile_color_channel{ ushort(4192) };
inline constexpr phrase<lngtag_count> lng_feature_profile_color_group{ ushort(4198) };
inline constexpr phrase<> lng_feature_profile_icon_channel{ ushort(4204) };
inline constexpr phrase<> lng_feature_profile_icon_group{ ushort(4205) };
inline constexpr phrase<> lng_edit_topics_enable{ ushort(4206) };
inline constexpr phrase<> lng_edit_topics_about{ ushort(4207) };
inline constexpr phrase<> lng_edit_topics_layout{ ushort(4208) };
inline constexpr phrase<> lng_edit_topics_layout_about{ ushort(4209) };
inline constexpr phrase<> lng_edit_topics_tabs{ ushort(4210) };
inline constexpr phrase<> lng_edit_topics_list{ ushort(4211) };
inline constexpr phrase<> lng_giveaway_new_title{ ushort(4212) };
inline constexpr phrase<> lng_giveaway_new_about{ ushort(4213) };
inline constexpr phrase<> lng_giveaway_new_about_group{ ushort(4214) };
inline constexpr phrase<> lng_giveaway_credits_new_about{ ushort(4215) };
inline constexpr phrase<> lng_giveaway_credits_new_about_group{ ushort(4216) };
inline constexpr phrase<> lng_giveaway_create_option{ ushort(4217) };
inline constexpr phrase<> lng_giveaway_create_subtitle{ ushort(4218) };
inline constexpr phrase<> lng_giveaway_award_option{ ushort(4219) };
inline constexpr phrase<> lng_giveaway_award_subtitle{ ushort(4220) };
inline constexpr phrase<lngtag_count> lng_giveaway_award_chosen{ ushort(4221) };
inline constexpr phrase<> lng_giveaway_quantity_title{ ushort(4227) };
inline constexpr phrase<lngtag_count> lng_giveaway_quantity{ ushort(4228) };
inline constexpr phrase<> lng_giveaway_quantity_about{ ushort(4234) };
inline constexpr phrase<> lng_giveaway_channels_title{ ushort(4235) };
inline constexpr phrase<lngtag_count> lng_giveaway_channels_this{ ushort(4236) };
inline constexpr phrase<lngtag_count> lng_giveaway_channels_this_group{ ushort(4242) };
inline constexpr phrase<> lng_giveaway_channels_add{ ushort(4248) };
inline constexpr phrase<> lng_giveaway_channels_about{ ushort(4249) };
inline constexpr phrase<> lng_giveaway_users_title{ ushort(4250) };
inline constexpr phrase<> lng_giveaway_users_all{ ushort(4251) };
inline constexpr phrase<> lng_giveaway_users_all_group{ ushort(4252) };
inline constexpr phrase<> lng_giveaway_users_from_all_countries{ ushort(4253) };
inline constexpr phrase<lngtag_country> lng_giveaway_users_from_one_country{ ushort(4254) };
inline constexpr phrase<lngtag_count> lng_giveaway_users_from_countries{ ushort(4255) };
inline constexpr phrase<> lng_giveaway_users_new{ ushort(4261) };
inline constexpr phrase<> lng_giveaway_users_new_group{ ushort(4262) };
inline constexpr phrase<> lng_giveaway_users_about{ ushort(4263) };
inline constexpr phrase<> lng_giveaway_users_about_group{ ushort(4264) };
inline constexpr phrase<> lng_giveaway_start{ ushort(4265) };
inline constexpr phrase<> lng_giveaway_award{ ushort(4266) };
inline constexpr phrase<> lng_giveaway_random_button{ ushort(4267) };
inline constexpr phrase<> lng_giveaway_start_sure{ ushort(4268) };
inline constexpr phrase<> lng_giveaway_date_title{ ushort(4269) };
inline constexpr phrase<> lng_giveaway_date{ ushort(4270) };
inline constexpr phrase<lngtag_count> lng_giveaway_date_about{ ushort(4271) };
inline constexpr phrase<lngtag_count> lng_giveaway_date_about_group{ ushort(4277) };
inline constexpr phrase<lngtag_count> lng_giveaway_duration_title{ ushort(4283) };
inline constexpr phrase<lngtag_price, lngtag_amount> lng_giveaway_duration_price{ ushort(4289) };
inline constexpr phrase<> lng_giveaway_date_select{ ushort(4290) };
inline constexpr phrase<> lng_giveaway_date_confirm{ ushort(4291) };
inline constexpr phrase<> lng_giveaway_recipients_save{ ushort(4292) };
inline constexpr phrase<> lng_giveaway_recipients_deselect{ ushort(4293) };
inline constexpr phrase<lngtag_count> lng_giveaway_maximum_countries_error{ ushort(4294) };
inline constexpr phrase<lngtag_count> lng_giveaway_maximum_channels_error{ ushort(4300) };
inline constexpr phrase<lngtag_count> lng_giveaway_maximum_users_error{ ushort(4306) };
inline constexpr phrase<> lng_giveaway_channels_confirm_title{ ushort(4312) };
inline constexpr phrase<> lng_giveaway_channels_confirm_about{ ushort(4313) };
inline constexpr phrase<> lng_giveaway_additional_prizes{ ushort(4314) };
inline constexpr phrase<> lng_giveaway_additional_about{ ushort(4315) };
inline constexpr phrase<> lng_giveaway_additional_prizes_ph{ ushort(4316) };
inline constexpr phrase<lngtag_count, lngtag_duration> lng_giveaway_prizes_just_premium{ ushort(4317) };
inline constexpr phrase<lngtag_count, lngtag_prize, lngtag_duration> lng_giveaway_prizes_additional{ ushort(4323) };
inline constexpr phrase<> lng_giveaway_additional_credits_about{ ushort(4329) };
inline constexpr phrase<lngtag_count> lng_giveaway_prizes_just_credits{ ushort(4330) };
inline constexpr phrase<lngtag_count, lngtag_prize, lngtag_amount> lng_giveaway_prizes_additional_credits{ ushort(4336) };
inline constexpr phrase<lngtag_count> lng_giveaway_prizes_additional_credits_amount{ ushort(4342) };
inline constexpr phrase<> lng_giveaway_show_winners{ ushort(4348) };
inline constexpr phrase<> lng_giveaway_show_winners_about{ ushort(4349) };
inline constexpr phrase<> lng_giveaway_created_title{ ushort(4350) };
inline constexpr phrase<lngtag_link> lng_giveaway_created_body{ ushort(4351) };
inline constexpr phrase<lngtag_link> lng_giveaway_created_body_group{ ushort(4352) };
inline constexpr phrase<> lng_giveaway_awarded_title{ ushort(4353) };
inline constexpr phrase<lngtag_link> lng_giveaway_awarded_body{ ushort(4354) };
inline constexpr phrase<lngtag_link> lng_giveaway_awarded_body_group{ ushort(4355) };
inline constexpr phrase<> lng_giveaway_created_link{ ushort(4356) };
inline constexpr phrase<> lng_giveaway_credits_options_title{ ushort(4357) };
inline constexpr phrase<lngtag_count> lng_giveaway_credits_option_status{ ushort(4358) };
inline constexpr phrase<> lng_giveaway_credits_options_about{ ushort(4364) };
inline constexpr phrase<> lng_giveaway_credits_quantity_title{ ushort(4365) };
inline constexpr phrase<> lng_giveaway_credits_quantity_about{ ushort(4366) };
inline constexpr phrase<> lng_prize_title{ ushort(4367) };
inline constexpr phrase<lngtag_channel> lng_prize_about{ ushort(4368) };
inline constexpr phrase<lngtag_duration> lng_prize_duration{ ushort(4369) };
inline constexpr phrase<lngtag_amount> lng_prize_credits{ ushort(4370) };
inline constexpr phrase<lngtag_count> lng_prize_credits_amount{ ushort(4371) };
inline constexpr phrase<lngtag_channel> lng_prize_gift_about{ ushort(4377) };
inline constexpr phrase<lngtag_duration> lng_prize_gift_duration{ ushort(4378) };
inline constexpr phrase<> lng_prize_open{ ushort(4379) };
inline constexpr phrase<> lng_prize_unclaimed_title{ ushort(4380) };
inline constexpr phrase<lngtag_channel> lng_prize_unclaimed_about{ ushort(4381) };
inline constexpr phrase<lngtag_duration> lng_prize_unclaimed_duration{ ushort(4382) };
inline constexpr phrase<lngtag_count> lng_prizes_title{ ushort(4383) };
inline constexpr phrase<lngtag_count, lngtag_prize> lng_prizes_additional{ ushort(4389) };
inline constexpr phrase<> lng_prizes_additional_with{ ushort(4395) };
inline constexpr phrase<lngtag_count, lngtag_duration> lng_prizes_about{ ushort(4396) };
inline constexpr phrase<lngtag_amount> lng_prizes_credits_about_single{ ushort(4402) };
inline constexpr phrase<lngtag_count, lngtag_amount> lng_prizes_credits_about{ ushort(4403) };
inline constexpr phrase<lngtag_count> lng_prizes_credits_about_amount{ ushort(4409) };
inline constexpr phrase<> lng_prizes_participants{ ushort(4415) };
inline constexpr phrase<lngtag_count> lng_prizes_participants_all{ ushort(4416) };
inline constexpr phrase<lngtag_count> lng_prizes_participants_all_group{ ushort(4422) };
inline constexpr phrase<lngtag_count> lng_prizes_participants_all_mixed{ ushort(4428) };
inline constexpr phrase<lngtag_count> lng_prizes_participants_new{ ushort(4434) };
inline constexpr phrase<lngtag_count> lng_prizes_participants_new_group{ ushort(4440) };
inline constexpr phrase<lngtag_count> lng_prizes_participants_new_mixed{ ushort(4446) };
inline constexpr phrase<lngtag_countries> lng_prizes_countries{ ushort(4452) };
inline constexpr phrase<lngtag_countries, lngtag_country> lng_prizes_countries_and_one{ ushort(4453) };
inline constexpr phrase<lngtag_countries, lngtag_country> lng_prizes_countries_and_last{ ushort(4454) };
inline constexpr phrase<> lng_prizes_date{ ushort(4455) };
inline constexpr phrase<> lng_prizes_how_works{ ushort(4456) };
inline constexpr phrase<> lng_prizes_how_title{ ushort(4457) };
inline constexpr phrase<> lng_prizes_end_title{ ushort(4458) };
inline constexpr phrase<lngtag_admins> lng_prizes_how_text{ ushort(4459) };
inline constexpr phrase<lngtag_admins> lng_prizes_end_text{ ushort(4460) };
inline constexpr phrase<lngtag_count, lngtag_channel, lngtag_duration> lng_prizes_admins{ ushort(4461) };
inline constexpr phrase<lngtag_count, lngtag_channel, lngtag_duration> lng_prizes_admins_group{ ushort(4467) };
inline constexpr phrase<lngtag_channel, lngtag_amount> lng_prizes_credits_admins{ ushort(4473) };
inline constexpr phrase<lngtag_channel, lngtag_amount> lng_prizes_credits_admins_group{ ushort(4474) };
inline constexpr phrase<lngtag_count> lng_prizes_credits_admins_amount{ ushort(4475) };
inline constexpr phrase<lngtag_count, lngtag_channel, lngtag_prize> lng_prizes_additional_added{ ushort(4481) };
inline constexpr phrase<lngtag_count, lngtag_channel, lngtag_prize> lng_prizes_additional_added_group{ ushort(4487) };
inline constexpr phrase<lngtag_date, lngtag_winners> lng_prizes_how_when_finish{ ushort(4493) };
inline constexpr phrase<lngtag_date, lngtag_winners> lng_prizes_end_when_finish{ ushort(4494) };
inline constexpr phrase<lngtag_count> lng_prizes_end_activated{ ushort(4495) };
inline constexpr phrase<lngtag_count, lngtag_channel> lng_prizes_winners_all_of_one{ ushort(4501) };
inline constexpr phrase<lngtag_count, lngtag_channel> lng_prizes_winners_all_of_one_group{ ushort(4507) };
inline constexpr phrase<lngtag_count, lngtag_channel> lng_prizes_winners_all_of_many{ ushort(4513) };
inline constexpr phrase<lngtag_count, lngtag_channel> lng_prizes_winners_all_of_many_group{ ushort(4519) };
inline constexpr phrase<lngtag_count, lngtag_channel, lngtag_start_date> lng_prizes_winners_new_of_one{ ushort(4525) };
inline constexpr phrase<lngtag_count, lngtag_channel, lngtag_start_date> lng_prizes_winners_new_of_many{ ushort(4531) };
inline constexpr phrase<lngtag_channel, lngtag_date> lng_prizes_how_participate_one{ ushort(4537) };
inline constexpr phrase<lngtag_channel, lngtag_date> lng_prizes_how_participate_many{ ushort(4538) };
inline constexpr phrase<lngtag_channel> lng_prizes_how_no_admin{ ushort(4539) };
inline constexpr phrase<lngtag_channel> lng_prizes_how_no_admin_group{ ushort(4540) };
inline constexpr phrase<lngtag_date> lng_prizes_how_no_joined{ ushort(4541) };
inline constexpr phrase<lngtag_date> lng_prizes_how_no_joined_group{ ushort(4542) };
inline constexpr phrase<> lng_prizes_how_no_country{ ushort(4543) };
inline constexpr phrase<lngtag_channel> lng_prizes_how_yes_joined_one{ ushort(4544) };
inline constexpr phrase<lngtag_channel> lng_prizes_how_yes_joined_many{ ushort(4545) };
inline constexpr phrase<lngtag_cup> lng_prizes_you_won{ ushort(4546) };
inline constexpr phrase<lngtag_amount, lngtag_cup> lng_prizes_you_won_credits{ ushort(4547) };
inline constexpr phrase<lngtag_count> lng_prizes_you_won_credits_amount{ ushort(4548) };
inline constexpr phrase<> lng_prizes_view_prize{ ushort(4554) };
inline constexpr phrase<> lng_prizes_you_didnt{ ushort(4555) };
inline constexpr phrase<> lng_prizes_cancelled{ ushort(4556) };
inline constexpr phrase<> lng_prizes_cancelled_group{ ushort(4557) };
inline constexpr phrase<lngtag_amount> lng_prizes_badge{ ushort(4558) };
inline constexpr phrase<> lng_prizes_results_title{ ushort(4559) };
inline constexpr phrase<> lng_prizes_results_title_one{ ushort(4560) };
inline constexpr phrase<lngtag_count, lngtag_link> lng_prizes_results_about{ ushort(4561) };
inline constexpr phrase<> lng_prizes_results_link{ ushort(4567) };
inline constexpr phrase<> lng_prizes_results_winner{ ushort(4568) };
inline constexpr phrase<> lng_prizes_results_winners{ ushort(4569) };
inline constexpr phrase<lngtag_count> lng_prizes_results_more{ ushort(4570) };
inline constexpr phrase<> lng_prizes_results_one{ ushort(4576) };
inline constexpr phrase<> lng_prizes_results_all{ ushort(4577) };
inline constexpr phrase<lngtag_count> lng_prizes_credits_results_one{ ushort(4578) };
inline constexpr phrase<lngtag_count> lng_prizes_credits_results_all{ ushort(4584) };
inline constexpr phrase<> lng_prizes_results_some{ ushort(4590) };
inline constexpr phrase<> lng_gift_link_title{ ushort(4591) };
inline constexpr phrase<> lng_gift_link_about{ ushort(4592) };
inline constexpr phrase<> lng_gift_link_label_from{ ushort(4593) };
inline constexpr phrase<> lng_gift_link_label_to{ ushort(4594) };
inline constexpr phrase<> lng_gift_link_label_to_unclaimed{ ushort(4595) };
inline constexpr phrase<> lng_gift_link_label_gift{ ushort(4596) };
inline constexpr phrase<lngtag_duration> lng_gift_link_gift_premium{ ushort(4597) };
inline constexpr phrase<> lng_gift_link_label_reason{ ushort(4598) };
inline constexpr phrase<> lng_gift_link_reason_giveaway{ ushort(4599) };
inline constexpr phrase<> lng_gift_link_reason_unclaimed{ ushort(4600) };
inline constexpr phrase<> lng_gift_link_reason_chosen{ ushort(4601) };
inline constexpr phrase<> lng_gift_link_label_date{ ushort(4602) };
inline constexpr phrase<> lng_gift_link_label_first_sale{ ushort(4603) };
inline constexpr phrase<> lng_gift_link_label_last_sale{ ushort(4604) };
inline constexpr phrase<> lng_gift_link_label_value{ ushort(4605) };
inline constexpr phrase<lngtag_link> lng_gift_link_also_send{ ushort(4606) };
inline constexpr phrase<> lng_gift_link_also_send_link{ ushort(4607) };
inline constexpr phrase<> lng_gift_link_use{ ushort(4608) };
inline constexpr phrase<> lng_gift_link_already_title{ ushort(4609) };
inline constexpr phrase<lngtag_date, lngtag_link> lng_gift_link_already_about{ ushort(4610) };
inline constexpr phrase<> lng_gift_link_already_link{ ushort(4611) };
inline constexpr phrase<> lng_gift_link_used_title{ ushort(4612) };
inline constexpr phrase<> lng_gift_link_used_about{ ushort(4613) };
inline constexpr phrase<lngtag_date> lng_gift_link_used_footer{ ushort(4614) };
inline constexpr phrase<> lng_gift_link_expired{ ushort(4615) };
inline constexpr phrase<lngtag_user> lng_gift_link_pending_about{ ushort(4616) };
inline constexpr phrase<> lng_gift_link_pending_toast{ ushort(4617) };
inline constexpr phrase<> lng_gift_link_pending_footer{ ushort(4618) };
inline constexpr phrase<lngtag_count> lng_gift_stars_title{ ushort(4619) };
inline constexpr phrase<lngtag_user> lng_gift_stars_outgoing{ ushort(4625) };
inline constexpr phrase<> lng_gift_stars_incoming{ ushort(4626) };
inline constexpr phrase<> lng_gift_until{ ushort(4627) };
inline constexpr phrase<lngtag_count> lng_gift_ton_amount{ ushort(4628) };
inline constexpr phrase<> lng_gift_premium_title{ ushort(4634) };
inline constexpr phrase<lngtag_count> lng_gift_premium_text{ ushort(4635) };
inline constexpr phrase<> lng_gift_premium_or_stars{ ushort(4641) };
inline constexpr phrase<> lng_gift_premium_subtitle{ ushort(4642) };
inline constexpr phrase<lngtag_name, lngtag_features> lng_gift_premium_about{ ushort(4643) };
inline constexpr phrase<> lng_gift_premium_features{ ushort(4644) };
inline constexpr phrase<> lng_gift_premium_label{ ushort(4645) };
inline constexpr phrase<lngtag_amount> lng_gift_premium_by_stars{ ushort(4646) };
inline constexpr phrase<> lng_gift_stars_subtitle{ ushort(4647) };
inline constexpr phrase<lngtag_name, lngtag_link> lng_gift_stars_about{ ushort(4648) };
inline constexpr phrase<lngtag_link> lng_gift_stars_about_collectibles{ ushort(4649) };
inline constexpr phrase<> lng_gift_stars_link{ ushort(4650) };
inline constexpr phrase<> lng_gift_stars_limited{ ushort(4651) };
inline constexpr phrase<> lng_gift_stars_sold_out{ ushort(4652) };
inline constexpr phrase<> lng_gift_stars_resale{ ushort(4653) };
inline constexpr phrase<> lng_gift_stars_on_sale{ ushort(4654) };
inline constexpr phrase<lngtag_price> lng_gift_on_sale_for{ ushort(4655) };
inline constexpr phrase<> lng_gift_stars_premium{ ushort(4656) };
inline constexpr phrase<> lng_gift_stars_auction{ ushort(4657) };
inline constexpr phrase<> lng_gift_stars_auction_join{ ushort(4658) };
inline constexpr phrase<> lng_gift_stars_auction_view{ ushort(4659) };
inline constexpr phrase<> lng_gift_stars_auction_soon{ ushort(4660) };
inline constexpr phrase<> lng_gift_stars_auction_upgraded{ ushort(4661) };
inline constexpr phrase<lngtag_count> lng_gift_stars_your_left{ ushort(4662) };
inline constexpr phrase<> lng_gift_stars_your_finished{ ushort(4668) };
inline constexpr phrase<> lng_gift_stars_tabs_all{ ushort(4669) };
inline constexpr phrase<> lng_gift_stars_tabs_my{ ushort(4670) };
inline constexpr phrase<> lng_gift_stars_tabs_my_empty{ ushort(4671) };
inline constexpr phrase<lngtag_emoji> lng_gift_stars_tabs_my_empty_next{ ushort(4672) };
inline constexpr phrase<> lng_gift_stars_tabs_collectibles{ ushort(4673) };
inline constexpr phrase<> lng_gift_send_title{ ushort(4674) };
inline constexpr phrase<> lng_gift_send_message{ ushort(4675) };
inline constexpr phrase<> lng_gift_send_anonymous{ ushort(4676) };
inline constexpr phrase<lngtag_amount> lng_gift_send_pay_with_stars{ ushort(4677) };
inline constexpr phrase<lngtag_amount, lngtag_link> lng_gift_send_stars_balance{ ushort(4678) };
inline constexpr phrase<> lng_gift_send_stars_balance_link{ ushort(4679) };
inline constexpr phrase<> lng_gift_send_anonymous_self{ ushort(4680) };
inline constexpr phrase<lngtag_user, lngtag_recipient> lng_gift_send_anonymous_about{ ushort(4681) };
inline constexpr phrase<lngtag_user, lngtag_recipient> lng_gift_send_anonymous_about_paid{ ushort(4682) };
inline constexpr phrase<> lng_gift_send_anonymous_about_channel{ ushort(4683) };
inline constexpr phrase<lngtag_price> lng_gift_send_unique{ ushort(4684) };
inline constexpr phrase<lngtag_user, lngtag_link> lng_gift_send_unique_about{ ushort(4685) };
inline constexpr phrase<lngtag_name, lngtag_link> lng_gift_send_unique_about_channel{ ushort(4686) };
inline constexpr phrase<> lng_gift_send_unique_link{ ushort(4687) };
inline constexpr phrase<lngtag_user> lng_gift_send_premium_about{ ushort(4688) };
inline constexpr phrase<lngtag_count> lng_gift_send_limited_sold{ ushort(4689) };
inline constexpr phrase<lngtag_count> lng_gift_send_limited_left{ ushort(4695) };
inline constexpr phrase<lngtag_cost> lng_gift_send_button{ ushort(4701) };
inline constexpr phrase<lngtag_cost> lng_gift_send_button_self{ ushort(4702) };
inline constexpr phrase<lngtag_name> lng_gift_buy_resale_title{ ushort(4703) };
inline constexpr phrase<lngtag_cost> lng_gift_buy_resale_button{ ushort(4704) };
inline constexpr phrase<lngtag_cost> lng_gift_buy_resale_equals{ ushort(4705) };
inline constexpr phrase<> lng_gift_buy_resale_only_ton{ ushort(4706) };
inline constexpr phrase<> lng_gift_buy_resale_pay_stars{ ushort(4707) };
inline constexpr phrase<> lng_gift_buy_resale_pay_ton{ ushort(4708) };
inline constexpr phrase<lngtag_name, lngtag_price, lngtag_user> lng_gift_buy_resale_confirm{ ushort(4709) };
inline constexpr phrase<lngtag_name, lngtag_price> lng_gift_buy_resale_confirm_self{ ushort(4710) };
inline constexpr phrase<> lng_gift_buy_price_change_title{ ushort(4711) };
inline constexpr phrase<lngtag_price> lng_gift_buy_price_change_text{ ushort(4712) };
inline constexpr phrase<> lng_gift_sent_title{ ushort(4713) };
inline constexpr phrase<lngtag_user> lng_gift_sent_resale_done{ ushort(4714) };
inline constexpr phrase<lngtag_gift> lng_gift_sent_resale_done_self{ ushort(4715) };
inline constexpr phrase<lngtag_count> lng_gift_sent_about{ ushort(4716) };
inline constexpr phrase<lngtag_count> lng_gift_sent_finished{ ushort(4722) };
inline constexpr phrase<lngtag_count> lng_gift_sent_remains{ ushort(4728) };
inline constexpr phrase<> lng_gift_limited_of_one{ ushort(4734) };
inline constexpr phrase<lngtag_amount> lng_gift_limited_of_count{ ushort(4735) };
inline constexpr phrase<> lng_gift_collectible_tag{ ushort(4736) };
inline constexpr phrase<> lng_gift_burned_tag{ ushort(4737) };
inline constexpr phrase<> lng_gift_crafted_tag{ ushort(4738) };
inline constexpr phrase<> lng_gift_uncommon_tag{ ushort(4739) };
inline constexpr phrase<> lng_gift_rare_tag{ ushort(4740) };
inline constexpr phrase<> lng_gift_epic_tag{ ushort(4741) };
inline constexpr phrase<> lng_gift_legendary_tag{ ushort(4742) };
inline constexpr phrase<> lng_gift_view_unpack{ ushort(4743) };
inline constexpr phrase<> lng_gift_anonymous_hint{ ushort(4744) };
inline constexpr phrase<> lng_gift_anonymous_hint_channel{ ushort(4745) };
inline constexpr phrase<> lng_gift_hidden_hint{ ushort(4746) };
inline constexpr phrase<> lng_gift_hidden_unique{ ushort(4747) };
inline constexpr phrase<> lng_gift_visible_hint{ ushort(4748) };
inline constexpr phrase<> lng_gift_burned_message{ ushort(4749) };
inline constexpr phrase<> lng_gift_hidden_hint_channel{ ushort(4750) };
inline constexpr phrase<> lng_gift_visible_hint_channel{ ushort(4751) };
inline constexpr phrase<lngtag_link> lng_gift_in_blockchain{ ushort(4752) };
inline constexpr phrase<lngtag_arrow> lng_gift_in_blockchain_link_arrow{ ushort(4753) };
inline constexpr phrase<lngtag_arrow> lng_gift_visible_hide_arrow{ ushort(4754) };
inline constexpr phrase<lngtag_arrow> lng_gift_visible_show_arrow{ ushort(4755) };
inline constexpr phrase<> lng_gift_show_on_page{ ushort(4756) };
inline constexpr phrase<> lng_gift_show_on_channel{ ushort(4757) };
inline constexpr phrase<> lng_gift_availability{ ushort(4758) };
inline constexpr phrase<> lng_gift_from_hidden{ ushort(4759) };
inline constexpr phrase<> lng_gift_subtitle_birthdays{ ushort(4760) };
inline constexpr phrase<lngtag_emoji> lng_gift_list_birthday_status_today{ ushort(4761) };
inline constexpr phrase<> lng_gift_list_birthday_status_yesterday{ ushort(4762) };
inline constexpr phrase<> lng_gift_list_birthday_status_tomorrow{ ushort(4763) };
inline constexpr phrase<> lng_gift_self_status{ ushort(4764) };
inline constexpr phrase<> lng_gift_self_title{ ushort(4765) };
inline constexpr phrase<> lng_gift_self_about{ ushort(4766) };
inline constexpr phrase<> lng_gift_channel_title{ ushort(4767) };
inline constexpr phrase<lngtag_name> lng_gift_channel_about{ ushort(4768) };
inline constexpr phrase<lngtag_name> lng_gift_released_by{ ushort(4769) };
inline constexpr phrase<> lng_gift_unique_owner{ ushort(4770) };
inline constexpr phrase<> lng_gift_unique_address_copied{ ushort(4771) };
inline constexpr phrase<> lng_gift_unique_telegram{ ushort(4772) };
inline constexpr phrase<> lng_gift_unique_status{ ushort(4773) };
inline constexpr phrase<> lng_gift_unique_status_non{ ushort(4774) };
inline constexpr phrase<> lng_gift_unique_upgrade{ ushort(4775) };
inline constexpr phrase<> lng_gift_unique_upgrade_next{ ushort(4776) };
inline constexpr phrase<> lng_gift_unique_gift_upgrade{ ushort(4777) };
inline constexpr phrase<lngtag_index> lng_gift_unique_number{ ushort(4778) };
inline constexpr phrase<lngtag_index, lngtag_name> lng_gift_unique_number_by{ ushort(4779) };
inline constexpr phrase<> lng_gift_unique_model{ ushort(4780) };
inline constexpr phrase<> lng_gift_unique_backdrop{ ushort(4781) };
inline constexpr phrase<> lng_gift_unique_symbol{ ushort(4782) };
inline constexpr phrase<lngtag_percent> lng_gift_unique_rarity{ ushort(4783) };
inline constexpr phrase<lngtag_from, lngtag_date> lng_gift_unique_sender{ ushort(4784) };
inline constexpr phrase<lngtag_date> lng_gift_unique_sender_you{ ushort(4785) };
inline constexpr phrase<> lng_gift_unique_availability_label{ ushort(4786) };
inline constexpr phrase<lngtag_count, lngtag_amount> lng_gift_unique_availability{ ushort(4787) };
inline constexpr phrase<> lng_gift_unique_value{ ushort(4793) };
inline constexpr phrase<> lng_gift_unique_value_learn_more{ ushort(4794) };
inline constexpr phrase<lngtag_recipient, lngtag_date> lng_gift_unique_info{ ushort(4795) };
inline constexpr phrase<lngtag_from, lngtag_recipient, lngtag_date> lng_gift_unique_info_sender{ ushort(4796) };
inline constexpr phrase<lngtag_from, lngtag_recipient, lngtag_date, lngtag_text> lng_gift_unique_info_sender_comment{ ushort(4797) };
inline constexpr phrase<lngtag_recipient, lngtag_date> lng_gift_unique_info_reciever{ ushort(4798) };
inline constexpr phrase<lngtag_recipient, lngtag_date, lngtag_text> lng_gift_unique_info_reciever_comment{ ushort(4799) };
inline constexpr phrase<> lng_gift_unique_info_remove_title{ ushort(4800) };
inline constexpr phrase<> lng_gift_unique_info_remove_text{ ushort(4801) };
inline constexpr phrase<lngtag_cost> lng_gift_unique_info_remove_confirm{ ushort(4802) };
inline constexpr phrase<lngtag_name> lng_gift_unique_info_removed{ ushort(4803) };
inline constexpr phrase<lngtag_count, lngtag_amount> lng_gift_availability_left{ ushort(4804) };
inline constexpr phrase<lngtag_amount> lng_gift_availability_none{ ushort(4810) };
inline constexpr phrase<lngtag_gift> lng_gift_value_about_average{ ushort(4811) };
inline constexpr phrase<lngtag_gift, lngtag_platform> lng_gift_value_about_last{ ushort(4812) };
inline constexpr phrase<> lng_gift_value_initial_sale{ ushort(4813) };
inline constexpr phrase<> lng_gift_value_initial_price{ ushort(4814) };
inline constexpr phrase<lngtag_stars, lngtag_amount> lng_gift_value_initial_price_value{ ushort(4815) };
inline constexpr phrase<> lng_gift_value_last_sale{ ushort(4816) };
inline constexpr phrase<> lng_gift_value_last_price{ ushort(4817) };
inline constexpr phrase<> lng_gift_value_minimum_price{ ushort(4818) };
inline constexpr phrase<lngtag_amount, lngtag_gift> lng_gift_value_minimum_price_tooltip{ ushort(4819) };
inline constexpr phrase<> lng_gift_vlaue_average_price{ ushort(4820) };
inline constexpr phrase<lngtag_amount, lngtag_gift> lng_gift_value_average_price_tooltip{ ushort(4821) };
inline constexpr phrase<lngtag_count, lngtag_emoji, lngtag_platform, lngtag_arrow> lng_gift_value_availability{ ushort(4822) };
inline constexpr phrase<> lng_gift_value_telegram{ ushort(4828) };
inline constexpr phrase<> lng_gift_value_fragment{ ushort(4829) };
inline constexpr phrase<lngtag_count> lng_gift_convert_to_stars{ ushort(4830) };
inline constexpr phrase<> lng_gift_convert_sure_title{ ushort(4836) };
inline constexpr phrase<lngtag_count, lngtag_user> lng_gift_convert_sure_confirm{ ushort(4837) };
inline constexpr phrase<lngtag_count, lngtag_channel> lng_gift_convert_sure_confirm_channel{ ushort(4843) };
inline constexpr phrase<lngtag_count> lng_gift_convert_sure_limit{ ushort(4849) };
inline constexpr phrase<> lng_gift_convert_sure_caution{ ushort(4855) };
inline constexpr phrase<> lng_gift_convert_sure{ ushort(4856) };
inline constexpr phrase<> lng_gift_display_done{ ushort(4857) };
inline constexpr phrase<> lng_gift_display_done_channel{ ushort(4858) };
inline constexpr phrase<> lng_gift_display_done_hide{ ushort(4859) };
inline constexpr phrase<> lng_gift_display_done_hide_channel{ ushort(4860) };
inline constexpr phrase<lngtag_gift> lng_gift_pinned_done_title{ ushort(4861) };
inline constexpr phrase<> lng_gift_pinned_done{ ushort(4862) };
inline constexpr phrase<lngtag_gift> lng_gift_pinned_done_replaced{ ushort(4863) };
inline constexpr phrase<lngtag_count> lng_gift_got_stars{ ushort(4864) };
inline constexpr phrase<lngtag_count> lng_gift_channel_got{ ushort(4870) };
inline constexpr phrase<> lng_gift_sold_out_title{ ushort(4876) };
inline constexpr phrase<lngtag_count> lng_gift_sold_out_text{ ushort(4877) };
inline constexpr phrase<> lng_gift_send_small{ ushort(4883) };
inline constexpr phrase<lngtag_count> lng_gift_sell_small{ ushort(4884) };
inline constexpr phrase<> lng_gift_upgrade_title{ ushort(4890) };
inline constexpr phrase<> lng_gift_upgrade_about{ ushort(4891) };
inline constexpr phrase<lngtag_emoji, lngtag_arrow> lng_gift_upgrade_view_all{ ushort(4892) };
inline constexpr phrase<> lng_gift_upgrade_preview_title{ ushort(4893) };
inline constexpr phrase<lngtag_name> lng_gift_upgrade_preview_about{ ushort(4894) };
inline constexpr phrase<lngtag_name> lng_gift_upgrade_preview_about_channel{ ushort(4895) };
inline constexpr phrase<> lng_gift_upgrade_unique_title{ ushort(4896) };
inline constexpr phrase<> lng_gift_upgrade_unique_about{ ushort(4897) };
inline constexpr phrase<lngtag_name> lng_gift_upgrade_unique_about_user{ ushort(4898) };
inline constexpr phrase<lngtag_name> lng_gift_upgrade_unique_about_channel{ ushort(4899) };
inline constexpr phrase<> lng_gift_upgrade_transferable_title{ ushort(4900) };
inline constexpr phrase<> lng_gift_upgrade_transferable_about{ ushort(4901) };
inline constexpr phrase<lngtag_name> lng_gift_upgrade_transferable_about_user{ ushort(4902) };
inline constexpr phrase<lngtag_name> lng_gift_upgrade_transferable_about_channel{ ushort(4903) };
inline constexpr phrase<> lng_gift_upgrade_tradable_title{ ushort(4904) };
inline constexpr phrase<> lng_gift_upgrade_tradable_about{ ushort(4905) };
inline constexpr phrase<lngtag_name> lng_gift_upgrade_tradable_about_user{ ushort(4906) };
inline constexpr phrase<lngtag_name> lng_gift_upgrade_tradable_about_channel{ ushort(4907) };
inline constexpr phrase<> lng_gift_upgrade_wearable_title{ ushort(4908) };
inline constexpr phrase<> lng_gift_upgrade_wearable_about{ ushort(4909) };
inline constexpr phrase<lngtag_price> lng_gift_upgrade_button{ ushort(4910) };
inline constexpr phrase<lngtag_time> lng_gift_upgrade_decreases{ ushort(4911) };
inline constexpr phrase<lngtag_arrow> lng_gift_upgrade_see_table{ ushort(4912) };
inline constexpr phrase<> lng_gift_upgrade_prices_about{ ushort(4913) };
inline constexpr phrase<> lng_gift_upgrade_prices_title{ ushort(4914) };
inline constexpr phrase<> lng_gift_upgrade_prices_subtitle{ ushort(4915) };
inline constexpr phrase<> lng_gift_upgrade_free{ ushort(4916) };
inline constexpr phrase<> lng_gift_upgrade_confirm{ ushort(4917) };
inline constexpr phrase<> lng_gift_upgrade_add_my{ ushort(4918) };
inline constexpr phrase<> lng_gift_upgrade_add_my_comment{ ushort(4919) };
inline constexpr phrase<> lng_gift_upgrade_add_sender{ ushort(4920) };
inline constexpr phrase<> lng_gift_upgrade_add_comment{ ushort(4921) };
inline constexpr phrase<> lng_gift_upgraded_title{ ushort(4922) };
inline constexpr phrase<lngtag_name> lng_gift_upgraded_about{ ushort(4923) };
inline constexpr phrase<> lng_gift_upgrade_gifted_title{ ushort(4924) };
inline constexpr phrase<lngtag_name> lng_gift_upgrade_gifted_about{ ushort(4925) };
inline constexpr phrase<lngtag_name> lng_gift_upgrade_gifted_about_channel{ ushort(4926) };
inline constexpr phrase<> lng_gift_transferred_title{ ushort(4927) };
inline constexpr phrase<lngtag_name, lngtag_recipient> lng_gift_transferred_about{ ushort(4928) };
inline constexpr phrase<lngtag_name> lng_gift_transfer_title{ ushort(4929) };
inline constexpr phrase<> lng_gift_transfer_via_blockchain{ ushort(4930) };
inline constexpr phrase<> lng_gift_transfer_password_title{ ushort(4931) };
inline constexpr phrase<> lng_gift_transfer_password_description{ ushort(4932) };
inline constexpr phrase<> lng_gift_transfer_password_about{ ushort(4933) };
inline constexpr phrase<> lng_gift_transfer_confirm_title{ ushort(4934) };
inline constexpr phrase<lngtag_name> lng_gift_transfer_confirm_text{ ushort(4935) };
inline constexpr phrase<> lng_gift_transfer_confirm_button{ ushort(4936) };
inline constexpr phrase<lngtag_count> lng_gift_transfer_unlocks_days{ ushort(4937) };
inline constexpr phrase<lngtag_count> lng_gift_transfer_unlocks_hours{ ushort(4943) };
inline constexpr phrase<> lng_gift_transfer_unlocks_title{ ushort(4949) };
inline constexpr phrase<lngtag_when> lng_gift_transfer_unlocks_about{ ushort(4950) };
inline constexpr phrase<lngtag_count> lng_gift_transfer_unlocks_when_days{ ushort(4951) };
inline constexpr phrase<lngtag_count> lng_gift_transfer_unlocks_when_hours{ ushort(4957) };
inline constexpr phrase<> lng_gift_transfer_unlocks_update_title{ ushort(4963) };
inline constexpr phrase<> lng_gift_transfer_unlocks_update_about{ ushort(4964) };
inline constexpr phrase<lngtag_name, lngtag_recipient> lng_gift_transfer_sure{ ushort(4965) };
inline constexpr phrase<lngtag_name, lngtag_recipient, lngtag_price> lng_gift_transfer_sure_for{ ushort(4966) };
inline constexpr phrase<> lng_gift_transfer_button{ ushort(4967) };
inline constexpr phrase<lngtag_price> lng_gift_transfer_button_for{ ushort(4968) };
inline constexpr phrase<> lng_gift_transfer_set_theme{ ushort(4969) };
inline constexpr phrase<> lng_gift_transfer_choose{ ushort(4970) };
inline constexpr phrase<> lng_gift_transfer_wear{ ushort(4971) };
inline constexpr phrase<> lng_gift_transfer_take_off{ ushort(4972) };
inline constexpr phrase<> lng_gift_transfer_sell{ ushort(4973) };
inline constexpr phrase<> lng_gift_transfer_update{ ushort(4974) };
inline constexpr phrase<> lng_gift_transfer_unlist{ ushort(4975) };
inline constexpr phrase<> lng_gift_transfer_locked_title{ ushort(4976) };
inline constexpr phrase<> lng_gift_transfer_locked_text{ ushort(4977) };
inline constexpr phrase<> lng_gift_offer_button{ ushort(4978) };
inline constexpr phrase<> lng_gift_offer_title{ ushort(4979) };
inline constexpr phrase<lngtag_name> lng_gift_offer_stars_about{ ushort(4980) };
inline constexpr phrase<lngtag_name> lng_gift_offer_ton_about{ ushort(4981) };
inline constexpr phrase<> lng_gift_offer_duration{ ushort(4982) };
inline constexpr phrase<lngtag_user> lng_gift_offer_duration_about{ ushort(4983) };
inline constexpr phrase<lngtag_cost> lng_gift_offer_cost_button{ ushort(4984) };
inline constexpr phrase<> lng_gift_offer_reject_title{ ushort(4985) };
inline constexpr phrase<lngtag_user> lng_gift_offer_confirm_reject{ ushort(4986) };
inline constexpr phrase<lngtag_name, lngtag_user, lngtag_cost> lng_gift_offer_confirm_accept{ ushort(4987) };
inline constexpr phrase<lngtag_cost> lng_gift_offer_you_get{ ushort(4988) };
inline constexpr phrase<lngtag_percent, lngtag_name> lng_gift_offer_higher{ ushort(4989) };
inline constexpr phrase<lngtag_percent, lngtag_name> lng_gift_offer_lower{ ushort(4990) };
inline constexpr phrase<lngtag_price> lng_gift_offer_sell_for{ ushort(4991) };
inline constexpr phrase<> lng_gift_offer_confirm_title{ ushort(4992) };
inline constexpr phrase<lngtag_cost, lngtag_user, lngtag_name> lng_gift_offer_confirm_text{ ushort(4993) };
inline constexpr phrase<> lng_gift_offer_table_offer{ ushort(4994) };
inline constexpr phrase<> lng_gift_offer_table_fee{ ushort(4995) };
inline constexpr phrase<> lng_gift_offer_table_duration{ ushort(4996) };
inline constexpr phrase<lngtag_name> lng_gift_sell_unlist_title{ ushort(4997) };
inline constexpr phrase<> lng_gift_sell_unlist_sure{ ushort(4998) };
inline constexpr phrase<> lng_gift_sell_title{ ushort(4999) };
inline constexpr phrase<lngtag_percent> lng_gift_sell_about{ ushort(5000) };
inline constexpr phrase<lngtag_count> lng_gift_sell_amount{ ushort(5001) };
inline constexpr phrase<lngtag_count> lng_gift_sell_min_price{ ushort(5007) };
inline constexpr phrase<> lng_gift_sell_only_ton{ ushort(5013) };
inline constexpr phrase<> lng_gift_sell_only_ton_about{ ushort(5014) };
inline constexpr phrase<lngtag_count> lng_gift_sell_amount_ton{ ushort(5015) };
inline constexpr phrase<lngtag_count> lng_gift_sell_min_price_ton{ ushort(5021) };
inline constexpr phrase<> lng_gift_sell_title_ton{ ushort(5027) };
inline constexpr phrase<> lng_gift_sell_put{ ushort(5028) };
inline constexpr phrase<> lng_gift_sell_update{ ushort(5029) };
inline constexpr phrase<lngtag_name> lng_gift_sell_toast{ ushort(5030) };
inline constexpr phrase<lngtag_name> lng_gift_sell_updated{ ushort(5031) };
inline constexpr phrase<lngtag_name> lng_gift_sell_removed{ ushort(5032) };
inline constexpr phrase<> lng_gift_menu_show{ ushort(5033) };
inline constexpr phrase<> lng_gift_menu_hide{ ushort(5034) };
inline constexpr phrase<lngtag_name> lng_gift_wear_title{ ushort(5035) };
inline constexpr phrase<> lng_gift_wear_about{ ushort(5036) };
inline constexpr phrase<> lng_gift_wear_badge_title{ ushort(5037) };
inline constexpr phrase<> lng_gift_wear_badge_about{ ushort(5038) };
inline constexpr phrase<> lng_gift_wear_badge_about_channel{ ushort(5039) };
inline constexpr phrase<> lng_gift_wear_design_title{ ushort(5040) };
inline constexpr phrase<> lng_gift_wear_design_about{ ushort(5041) };
inline constexpr phrase<> lng_gift_wear_design_about_channel{ ushort(5042) };
inline constexpr phrase<> lng_gift_wear_proof_title{ ushort(5043) };
inline constexpr phrase<> lng_gift_wear_proof_about{ ushort(5044) };
inline constexpr phrase<> lng_gift_wear_proof_about_channel{ ushort(5045) };
inline constexpr phrase<> lng_gift_wear_start{ ushort(5046) };
inline constexpr phrase<lngtag_link> lng_gift_wear_subscribe{ ushort(5047) };
inline constexpr phrase<lngtag_name> lng_gift_wear_start_toast{ ushort(5048) };
inline constexpr phrase<lngtag_name> lng_gift_wear_end_toast{ ushort(5049) };
inline constexpr phrase<> lng_gift_many_pinned_title{ ushort(5050) };
inline constexpr phrase<> lng_gift_many_pinned_choose{ ushort(5051) };
inline constexpr phrase<> lng_gift_resale_price{ ushort(5052) };
inline constexpr phrase<> lng_gift_resale_number{ ushort(5053) };
inline constexpr phrase<> lng_gift_resale_date{ ushort(5054) };
inline constexpr phrase<lngtag_count> lng_gift_resale_count{ ushort(5055) };
inline constexpr phrase<> lng_gift_resale_sort_price{ ushort(5061) };
inline constexpr phrase<> lng_gift_resale_sort_date{ ushort(5062) };
inline constexpr phrase<> lng_gift_resale_sort_number{ ushort(5063) };
inline constexpr phrase<> lng_gift_resale_filter_all{ ushort(5064) };
inline constexpr phrase<> lng_gift_resale_model{ ushort(5065) };
inline constexpr phrase<lngtag_count> lng_gift_resale_models{ ushort(5066) };
inline constexpr phrase<> lng_gift_resale_backdrop{ ushort(5072) };
inline constexpr phrase<lngtag_count> lng_gift_resale_backdrops{ ushort(5073) };
inline constexpr phrase<> lng_gift_resale_symbol{ ushort(5079) };
inline constexpr phrase<lngtag_count> lng_gift_resale_symbols{ ushort(5080) };
inline constexpr phrase<> lng_gift_resale_switch_to_ton{ ushort(5086) };
inline constexpr phrase<> lng_gift_resale_switch_to_stars{ ushort(5087) };
inline constexpr phrase<lngtag_duration> lng_gift_resale_early{ ushort(5088) };
inline constexpr phrase<lngtag_duration> lng_gift_transfer_early{ ushort(5089) };
inline constexpr phrase<> lng_gift_resale_transfer_early_title{ ushort(5090) };
inline constexpr phrase<> lng_gift_collection_add{ ushort(5091) };
inline constexpr phrase<> lng_gift_collection_new_title{ ushort(5092) };
inline constexpr phrase<> lng_gift_collection_new_button{ ushort(5093) };
inline constexpr phrase<> lng_gift_collection_new_text{ ushort(5094) };
inline constexpr phrase<> lng_gift_collection_new_ph{ ushort(5095) };
inline constexpr phrase<> lng_gift_collection_new_create{ ushort(5096) };
inline constexpr phrase<> lng_gift_collection_empty_title{ ushort(5097) };
inline constexpr phrase<> lng_gift_collection_empty_text{ ushort(5098) };
inline constexpr phrase<> lng_gift_collection_all{ ushort(5099) };
inline constexpr phrase<> lng_gift_collection_add_title{ ushort(5100) };
inline constexpr phrase<> lng_gift_collection_add_button{ ushort(5101) };
inline constexpr phrase<> lng_gift_collection_share{ ushort(5102) };
inline constexpr phrase<> lng_gift_collection_edit{ ushort(5103) };
inline constexpr phrase<> lng_gift_collection_limit_title{ ushort(5104) };
inline constexpr phrase<> lng_gift_collection_limit_text{ ushort(5105) };
inline constexpr phrase<> lng_gift_collection_delete{ ushort(5106) };
inline constexpr phrase<> lng_gift_collection_delete_sure{ ushort(5107) };
inline constexpr phrase<> lng_gift_collection_delete_button{ ushort(5108) };
inline constexpr phrase<> lng_gift_collection_add_to{ ushort(5109) };
inline constexpr phrase<> lng_gift_collection_reorder{ ushort(5110) };
inline constexpr phrase<> lng_gift_collection_reorder_exit{ ushort(5111) };
inline constexpr phrase<> lng_gift_collection_remove_from{ ushort(5112) };
inline constexpr phrase<> lng_gift_locked_title{ ushort(5113) };
inline constexpr phrase<> lng_gift_craft_menu_button{ ushort(5114) };
inline constexpr phrase<> lng_gift_craft_info_title{ ushort(5115) };
inline constexpr phrase<> lng_gift_craft_info_about{ ushort(5116) };
inline constexpr phrase<> lng_gift_craft_rare_title{ ushort(5117) };
inline constexpr phrase<> lng_gift_craft_rare_about{ ushort(5118) };
inline constexpr phrase<> lng_gift_craft_chance_title{ ushort(5119) };
inline constexpr phrase<> lng_gift_craft_chance_about{ ushort(5120) };
inline constexpr phrase<> lng_gift_craft_affect_title{ ushort(5121) };
inline constexpr phrase<> lng_gift_craft_affect_about{ ushort(5122) };
inline constexpr phrase<> lng_gift_craft_start_button{ ushort(5123) };
inline constexpr phrase<> lng_gift_craft_title{ ushort(5124) };
inline constexpr phrase<lngtag_gift> lng_gift_craft_about1{ ushort(5125) };
inline constexpr phrase<> lng_gift_craft_about2{ ushort(5126) };
inline constexpr phrase<lngtag_emoji, lngtag_arrow> lng_gift_craft_view_all{ ushort(5127) };
inline constexpr phrase<lngtag_percent, lngtag_name> lng_gift_craft_chance_backdrop{ ushort(5128) };
inline constexpr phrase<lngtag_percent, lngtag_name> lng_gift_craft_chance_symbol{ ushort(5129) };
inline constexpr phrase<lngtag_gift> lng_gift_craft_button{ ushort(5130) };
inline constexpr phrase<lngtag_percent> lng_gift_craft_button_chance{ ushort(5131) };
inline constexpr phrase<> lng_gift_craft_select_title{ ushort(5132) };
inline constexpr phrase<> lng_gift_craft_select_about{ ushort(5133) };
inline constexpr phrase<> lng_gift_craft_select_your{ ushort(5134) };
inline constexpr phrase<> lng_gift_craft_select_none{ ushort(5135) };
inline constexpr phrase<> lng_gift_craft_search_none{ ushort(5136) };
inline constexpr phrase<lngtag_count> lng_gift_craft_select_market{ ushort(5137) };
inline constexpr phrase<> lng_gift_craft_progress{ ushort(5143) };
inline constexpr phrase<lngtag_gift> lng_gift_craft_progress_about{ ushort(5144) };
inline constexpr phrase<lngtag_percent> lng_gift_craft_progress_chance{ ushort(5145) };
inline constexpr phrase<> lng_gift_craft_progress_fails{ ushort(5146) };
inline constexpr phrase<> lng_gift_craft_failed{ ushort(5147) };
inline constexpr phrase<> lng_gift_craft_failed_title{ ushort(5148) };
inline constexpr phrase<lngtag_count> lng_gift_craft_failed_about{ ushort(5149) };
inline constexpr phrase<> lng_gift_craft_new_button{ ushort(5155) };
inline constexpr phrase<> lng_gift_craft_another_button{ ushort(5156) };
inline constexpr phrase<> lng_gift_craft_unavailable{ ushort(5157) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_gift_craft_when{ ushort(5158) };
inline constexpr phrase<> lng_auction_about_title{ ushort(5159) };
inline constexpr phrase<> lng_auction_about_subtitle{ ushort(5160) };
inline constexpr phrase<lngtag_count> lng_auction_about_top_title{ ushort(5161) };
inline constexpr phrase<lngtag_count> lng_auction_about_top_rounds{ ushort(5167) };
inline constexpr phrase<lngtag_count> lng_auction_about_top_bidders{ ushort(5173) };
inline constexpr phrase<lngtag_count, lngtag_rounds, lngtag_bidders> lng_auction_about_top_about{ ushort(5179) };
inline constexpr phrase<lngtag_count, lngtag_bidders, lngtag_link> lng_auction_about_top_short{ ushort(5185) };
inline constexpr phrase<> lng_auction_about_bid_title{ ushort(5191) };
inline constexpr phrase<lngtag_count> lng_auction_about_bid_about{ ushort(5192) };
inline constexpr phrase<> lng_auction_about_missed_title{ ushort(5198) };
inline constexpr phrase<> lng_auction_about_missed_about{ ushort(5199) };
inline constexpr phrase<> lng_auction_about_understood{ ushort(5200) };
inline constexpr phrase<lngtag_count, lngtag_name, lngtag_link> lng_auction_text{ ushort(5201) };
inline constexpr phrase<lngtag_arrow> lng_auction_text_link{ ushort(5207) };
inline constexpr phrase<> lng_auction_text_ended{ ushort(5208) };
inline constexpr phrase<> lng_auction_start_label{ ushort(5209) };
inline constexpr phrase<> lng_auction_starts_label{ ushort(5210) };
inline constexpr phrase<> lng_auction_rounds_label{ ushort(5211) };
inline constexpr phrase<lngtag_n> lng_auction_rounds_exact{ ushort(5212) };
inline constexpr phrase<lngtag_n, lngtag_last> lng_auction_rounds_range{ ushort(5213) };
inline constexpr phrase<lngtag_count> lng_auction_rounds_seconds{ ushort(5214) };
inline constexpr phrase<lngtag_count> lng_auction_rounds_minutes{ ushort(5220) };
inline constexpr phrase<lngtag_count> lng_auction_rounds_hours{ ushort(5226) };
inline constexpr phrase<lngtag_duration, lngtag_increase, lngtag_n> lng_auction_rounds_extended{ ushort(5232) };
inline constexpr phrase<> lng_auction_end_label{ ushort(5233) };
inline constexpr phrase<> lng_auction_round_label{ ushort(5234) };
inline constexpr phrase<lngtag_n, lngtag_amount> lng_auction_round_value{ ushort(5235) };
inline constexpr phrase<> lng_auction_average_label{ ushort(5236) };
inline constexpr phrase<lngtag_amount, lngtag_gift> lng_auction_average_tooltip{ ushort(5237) };
inline constexpr phrase<> lng_auction_availability_label{ ushort(5238) };
inline constexpr phrase<lngtag_n, lngtag_amount> lng_auction_availability_value{ ushort(5239) };
inline constexpr phrase<lngtag_count, lngtag_emoji, lngtag_arrow> lng_auction_bought{ ushort(5240) };
inline constexpr phrase<> lng_auction_join_button{ ushort(5246) };
inline constexpr phrase<> lng_auction_join_bid{ ushort(5247) };
inline constexpr phrase<lngtag_time> lng_auction_join_time_left{ ushort(5248) };
inline constexpr phrase<lngtag_hours, lngtag_minutes> lng_auction_join_time_medium{ ushort(5249) };
inline constexpr phrase<lngtag_minutes> lng_auction_join_time_small{ ushort(5250) };
inline constexpr phrase<lngtag_time> lng_auction_join_starts_in{ ushort(5251) };
inline constexpr phrase<> lng_auction_join_early_bid{ ushort(5252) };
inline constexpr phrase<> lng_auction_menu_about{ ushort(5253) };
inline constexpr phrase<> lng_auction_menu_copy_link{ ushort(5254) };
inline constexpr phrase<> lng_auction_menu_share{ ushort(5255) };
inline constexpr phrase<> lng_auction_bid_title{ ushort(5256) };
inline constexpr phrase<> lng_auction_bid_title_early{ ushort(5257) };
inline constexpr phrase<lngtag_count> lng_auction_bid_subtitle{ ushort(5258) };
inline constexpr phrase<> lng_auction_bid_your{ ushort(5264) };
inline constexpr phrase<> lng_auction_bid_custom{ ushort(5265) };
inline constexpr phrase<lngtag_count> lng_auction_bid_threshold{ ushort(5266) };
inline constexpr phrase<lngtag_count> lng_auction_bid_minimal{ ushort(5272) };
inline constexpr phrase<> lng_auction_bid_until{ ushort(5278) };
inline constexpr phrase<lngtag_count> lng_auction_bid_left{ ushort(5279) };
inline constexpr phrase<> lng_auction_bid_before_start{ ushort(5285) };
inline constexpr phrase<> lng_auction_bid_your_title{ ushort(5286) };
inline constexpr phrase<> lng_auction_bid_your_outbid{ ushort(5287) };
inline constexpr phrase<> lng_auction_bid_your_winning{ ushort(5288) };
inline constexpr phrase<> lng_auction_bid_winners_title{ ushort(5289) };
inline constexpr phrase<lngtag_stars> lng_auction_bid_place{ ushort(5290) };
inline constexpr phrase<lngtag_stars> lng_auction_bid_increase{ ushort(5291) };
inline constexpr phrase<> lng_auction_bid_placed_title{ ushort(5292) };
inline constexpr phrase<> lng_auction_bid_increased_title{ ushort(5293) };
inline constexpr phrase<lngtag_count> lng_auction_bid_done_text{ ushort(5294) };
inline constexpr phrase<> lng_auction_bid_custom_title{ ushort(5300) };
inline constexpr phrase<lngtag_count> lng_auction_preview_left{ ushort(5301) };
inline constexpr phrase<> lng_auction_preview_join{ ushort(5307) };
inline constexpr phrase<> lng_auctino_preview_finished{ ushort(5308) };
inline constexpr phrase<> lng_auction_preview_sold_out{ ushort(5309) };
inline constexpr phrase<> lng_auction_preview_view_results{ ushort(5310) };
inline constexpr phrase<> lng_auction_bar_active{ ushort(5311) };
inline constexpr phrase<lngtag_count> lng_auction_bar_active_many{ ushort(5312) };
inline constexpr phrase<lngtag_count> lng_auction_bar_winning{ ushort(5318) };
inline constexpr phrase<> lng_auction_bar_outbid{ ushort(5324) };
inline constexpr phrase<> lng_auction_bar_winning_all{ ushort(5325) };
inline constexpr phrase<lngtag_count> lng_auction_bar_outbid_some{ ushort(5326) };
inline constexpr phrase<> lng_auction_bar_outbid_all{ ushort(5332) };
inline constexpr phrase<> lng_auction_bar_view{ ushort(5333) };
inline constexpr phrase<lngtag_n, lngtag_amount> lng_auction_bar_round{ ushort(5334) };
inline constexpr phrase<lngtag_stars, lngtag_n> lng_auction_bar_bid_ranked{ ushort(5335) };
inline constexpr phrase<lngtag_stars> lng_auction_bar_bid_outbid{ ushort(5336) };
inline constexpr phrase<> lng_auction_bar_raise_bid{ ushort(5337) };
inline constexpr phrase<lngtag_count> lng_auction_bought_title{ ushort(5338) };
inline constexpr phrase<> lng_auction_bought_date{ ushort(5344) };
inline constexpr phrase<> lng_auction_bought_bid{ ushort(5345) };
inline constexpr phrase<lngtag_name, lngtag_n> lng_auction_bought_in_round{ ushort(5346) };
inline constexpr phrase<> lng_auction_change_title{ ushort(5347) };
inline constexpr phrase<> lng_auction_change_button{ ushort(5348) };
inline constexpr phrase<lngtag_name> lng_auction_change_already{ ushort(5349) };
inline constexpr phrase<lngtag_name> lng_auction_change_to{ ushort(5350) };
inline constexpr phrase<> lng_auction_change_already_me{ ushort(5351) };
inline constexpr phrase<> lng_auction_change_to_me{ ushort(5352) };
inline constexpr phrase<> lng_auction_preview_name{ ushort(5353) };
inline constexpr phrase<lngtag_arrow> lng_auction_preview_learn_gifts{ ushort(5354) };
inline constexpr phrase<lngtag_count, lngtag_emoji, lngtag_arrow> lng_auction_preview_variants{ ushort(5355) };
inline constexpr phrase<> lng_auction_preview_random{ ushort(5361) };
inline constexpr phrase<> lng_auction_preview_selected{ ushort(5362) };
inline constexpr phrase<> lng_auction_preview_randomize{ ushort(5363) };
inline constexpr phrase<> lng_auction_preview_model{ ushort(5364) };
inline constexpr phrase<lngtag_count> lng_auction_preview_models{ ushort(5365) };
inline constexpr phrase<> lng_auction_preview_models_button{ ushort(5371) };
inline constexpr phrase<lngtag_count> lng_auction_preview_crafted{ ushort(5372) };
inline constexpr phrase<lngtag_arrow> lng_auction_preview_view_craftable{ ushort(5378) };
inline constexpr phrase<lngtag_arrow> lng_auction_preview_view_primary{ ushort(5379) };
inline constexpr phrase<> lng_auction_preview_backdrop{ ushort(5380) };
inline constexpr phrase<lngtag_count> lng_auction_preview_backdrops{ ushort(5381) };
inline constexpr phrase<> lng_auction_preview_backdrops_button{ ushort(5387) };
inline constexpr phrase<> lng_auction_preview_symbol{ ushort(5388) };
inline constexpr phrase<lngtag_count> lng_auction_preview_symbols{ ushort(5389) };
inline constexpr phrase<> lng_auction_preview_symbols_button{ ushort(5395) };
inline constexpr phrase<lngtag_arrow> lng_auction_preview_wear{ ushort(5396) };
inline constexpr phrase<> lng_auction_preview_free_upgrade{ ushort(5397) };
inline constexpr phrase<> lng_accounts_limit_title{ ushort(5398) };
inline constexpr phrase<lngtag_count> lng_accounts_limit1{ ushort(5399) };
inline constexpr phrase<> lng_accounts_limit2{ ushort(5405) };
inline constexpr phrase<> lng_emoji_status_for_title{ ushort(5406) };
inline constexpr phrase<> lng_emoji_status_for_submit{ ushort(5407) };
inline constexpr phrase<lngtag_duration> lng_emoji_status_menu_duration_any{ ushort(5408) };
inline constexpr phrase<> lng_group_about_header{ ushort(5409) };
inline constexpr phrase<> lng_group_about_text{ ushort(5410) };
inline constexpr phrase<> lng_group_about1{ ushort(5411) };
inline constexpr phrase<> lng_group_about2{ ushort(5412) };
inline constexpr phrase<> lng_group_about3{ ushort(5413) };
inline constexpr phrase<> lng_group_about4{ ushort(5414) };
inline constexpr phrase<> lng_switch_stickers{ ushort(5415) };
inline constexpr phrase<> lng_switch_emoji{ ushort(5416) };
inline constexpr phrase<> lng_switch_gifs{ ushort(5417) };
inline constexpr phrase<> lng_switch_masks{ ushort(5418) };
inline constexpr phrase<> lng_stickers_featured_add{ ushort(5419) };
inline constexpr phrase<> lng_stickers_featured_installed{ ushort(5420) };
inline constexpr phrase<> lng_emoji_featured_unlock{ ushort(5421) };
inline constexpr phrase<> lng_emoji_premium_restore{ ushort(5422) };
inline constexpr phrase<> lng_gifs_search{ ushort(5423) };
inline constexpr phrase<> lng_gifs_no_saved{ ushort(5424) };
inline constexpr phrase<> lng_inline_bot_no_results{ ushort(5425) };
inline constexpr phrase<lngtag_inline_bot> lng_inline_bot_via{ ushort(5426) };
inline constexpr phrase<> lng_box_remove{ ushort(5427) };
inline constexpr phrase<> lng_stickers_installed_tab{ ushort(5428) };
inline constexpr phrase<> lng_stickers_masks_tab{ ushort(5429) };
inline constexpr phrase<> lng_stickers_featured_tab{ ushort(5430) };
inline constexpr phrase<> lng_stickers_archived_tab{ ushort(5431) };
inline constexpr phrase<lngtag_sticker_pack> lng_stickers_remove_pack{ ushort(5432) };
inline constexpr phrase<> lng_stickers_add_pack{ ushort(5433) };
inline constexpr phrase<> lng_stickers_add_masks{ ushort(5434) };
inline constexpr phrase<> lng_stickers_add_emoji{ ushort(5435) };
inline constexpr phrase<> lng_stickers_share_pack{ ushort(5436) };
inline constexpr phrase<> lng_stickers_share_masks{ ushort(5437) };
inline constexpr phrase<> lng_stickers_share_emoji{ ushort(5438) };
inline constexpr phrase<> lng_stickers_not_found{ ushort(5439) };
inline constexpr phrase<> lng_stickers_packs_archived{ ushort(5440) };
inline constexpr phrase<> lng_stickers_copied{ ushort(5441) };
inline constexpr phrase<> lng_stickers_copied_emoji{ ushort(5442) };
inline constexpr phrase<> lng_stickers_default_set{ ushort(5443) };
inline constexpr phrase<> lng_stickers_you_have{ ushort(5444) };
inline constexpr phrase<> lng_stickers_return{ ushort(5445) };
inline constexpr phrase<lngtag_count> lng_stickers_count{ ushort(5446) };
inline constexpr phrase<lngtag_count> lng_masks_count{ ushort(5452) };
inline constexpr phrase<lngtag_count> lng_custom_emoji_count{ ushort(5458) };
inline constexpr phrase<> lng_stickers_attached_sets{ ushort(5464) };
inline constexpr phrase<> lng_custom_emoji_used_sets{ ushort(5465) };
inline constexpr phrase<> lng_custom_emoji_remove_pack_button{ ushort(5466) };
inline constexpr phrase<> lng_stickers_group_set{ ushort(5467) };
inline constexpr phrase<> lng_stickers_remove_group_set{ ushort(5468) };
inline constexpr phrase<> lng_stickers_group_from_your{ ushort(5469) };
inline constexpr phrase<> lng_stickers_group_from_featured{ ushort(5470) };
inline constexpr phrase<> lng_stickers_nothing_found{ ushort(5471) };
inline constexpr phrase<> lng_stickers_remove_pack_confirm{ ushort(5472) };
inline constexpr phrase<> lng_stickers_archive_pack{ ushort(5473) };
inline constexpr phrase<> lng_stickers_has_been_archived{ ushort(5474) };
inline constexpr phrase<> lng_emoji_group_set{ ushort(5475) };
inline constexpr phrase<> lng_emoji_remove_group_set{ ushort(5476) };
inline constexpr phrase<> lng_emoji_group_from_your{ ushort(5477) };
inline constexpr phrase<> lng_emoji_group_from_featured{ ushort(5478) };
inline constexpr phrase<> lng_masks_archive_pack{ ushort(5479) };
inline constexpr phrase<> lng_masks_has_been_archived{ ushort(5480) };
inline constexpr phrase<> lng_masks_installed{ ushort(5481) };
inline constexpr phrase<> lng_emoji_nothing_found{ ushort(5482) };
inline constexpr phrase<> lng_stickers_context_reorder{ ushort(5483) };
inline constexpr phrase<> lng_stickers_context_edit_name{ ushort(5484) };
inline constexpr phrase<> lng_stickers_context_delete{ ushort(5485) };
inline constexpr phrase<> lng_stickers_context_delete_sure{ ushort(5486) };
inline constexpr phrase<> lng_stickers_box_edit_name_title{ ushort(5487) };
inline constexpr phrase<> lng_stickers_box_edit_name_about{ ushort(5488) };
inline constexpr phrase<> lng_stickers_creator_badge{ ushort(5489) };
inline constexpr phrase<> lng_in_dlg_photo{ ushort(5490) };
inline constexpr phrase<> lng_in_dlg_album{ ushort(5491) };
inline constexpr phrase<> lng_in_dlg_video{ ushort(5492) };
inline constexpr phrase<> lng_in_dlg_audio_file{ ushort(5493) };
inline constexpr phrase<> lng_in_dlg_contact{ ushort(5494) };
inline constexpr phrase<> lng_in_dlg_audio{ ushort(5495) };
inline constexpr phrase<> lng_in_dlg_video_message{ ushort(5496) };
inline constexpr phrase<> lng_in_dlg_voice_message_ttl{ ushort(5497) };
inline constexpr phrase<> lng_in_dlg_video_message_ttl{ ushort(5498) };
inline constexpr phrase<> lng_in_dlg_file{ ushort(5499) };
inline constexpr phrase<> lng_in_dlg_sticker{ ushort(5500) };
inline constexpr phrase<lngtag_emoji> lng_in_dlg_sticker_emoji{ ushort(5501) };
inline constexpr phrase<> lng_in_dlg_poll{ ushort(5502) };
inline constexpr phrase<> lng_in_dlg_story{ ushort(5503) };
inline constexpr phrase<> lng_in_dlg_todo_list{ ushort(5504) };
inline constexpr phrase<> lng_in_dlg_story_expired{ ushort(5505) };
inline constexpr phrase<lngtag_count> lng_in_dlg_media_count{ ushort(5506) };
inline constexpr phrase<lngtag_count> lng_in_dlg_photo_count{ ushort(5512) };
inline constexpr phrase<lngtag_count> lng_in_dlg_video_count{ ushort(5518) };
inline constexpr phrase<lngtag_count> lng_in_dlg_file_count{ ushort(5524) };
inline constexpr phrase<lngtag_count> lng_in_dlg_audio_count{ ushort(5530) };
inline constexpr phrase<> lng_ban_user{ ushort(5536) };
inline constexpr phrase<> lng_ban_users{ ushort(5537) };
inline constexpr phrase<> lng_restrict_users{ ushort(5538) };
inline constexpr phrase<lngtag_user> lng_delete_all_from_user{ ushort(5539) };
inline constexpr phrase<> lng_delete_all_from_users{ ushort(5540) };
inline constexpr phrase<lngtag_count> lng_restrict_user{ ushort(5541) };
inline constexpr phrase<lngtag_emoji> lng_restrict_user_part{ ushort(5547) };
inline constexpr phrase<lngtag_emoji> lng_restrict_users_part{ ushort(5548) };
inline constexpr phrase<lngtag_emoji> lng_restrict_user_full{ ushort(5549) };
inline constexpr phrase<lngtag_emoji> lng_restrict_users_full{ ushort(5550) };
inline constexpr phrase<> lng_restrict_users_part_single_header{ ushort(5551) };
inline constexpr phrase<lngtag_count> lng_restrict_users_part_header{ ushort(5552) };
inline constexpr phrase<> lng_restrict_users_kick_from_common_group{ ushort(5558) };
inline constexpr phrase<> lng_report_spam{ ushort(5559) };
inline constexpr phrase<> lng_report_spam_and_leave{ ushort(5560) };
inline constexpr phrase<> lng_report_spam_done{ ushort(5561) };
inline constexpr phrase<> lng_report_spam_sure_group{ ushort(5562) };
inline constexpr phrase<> lng_report_spam_sure_channel{ ushort(5563) };
inline constexpr phrase<> lng_report_spam_ok{ ushort(5564) };
inline constexpr phrase<> lng_new_contact_block{ ushort(5565) };
inline constexpr phrase<lngtag_user> lng_new_contact_block_done{ ushort(5566) };
inline constexpr phrase<> lng_new_contact_add{ ushort(5567) };
inline constexpr phrase<> lng_new_contact_share{ ushort(5568) };
inline constexpr phrase<lngtag_phone, lngtag_user> lng_new_contact_share_sure{ ushort(5569) };
inline constexpr phrase<lngtag_user> lng_new_contact_share_done{ ushort(5570) };
inline constexpr phrase<lngtag_user> lng_new_contact_add_name{ ushort(5571) };
inline constexpr phrase<lngtag_user> lng_new_contact_add_done{ ushort(5572) };
inline constexpr phrase<> lng_new_contact_unarchive{ ushort(5573) };
inline constexpr phrase<lngtag_user, lngtag_name> lng_new_contact_from_request_channel{ ushort(5574) };
inline constexpr phrase<lngtag_user, lngtag_name> lng_new_contact_from_request_group{ ushort(5575) };
inline constexpr phrase<lngtag_emoji, lngtag_link> lng_new_contact_about_status{ ushort(5576) };
inline constexpr phrase<> lng_new_contact_about_status_link{ ushort(5577) };
inline constexpr phrase<> lng_new_contact_not_contact{ ushort(5578) };
inline constexpr phrase<> lng_new_contact_phone_number{ ushort(5579) };
inline constexpr phrase<> lng_new_contact_registration{ ushort(5580) };
inline constexpr phrase<> lng_new_contact_common_groups{ ushort(5581) };
inline constexpr phrase<lngtag_count, lngtag_emoji, lngtag_arrow> lng_new_contact_groups{ ushort(5582) };
inline constexpr phrase<> lng_new_contact_not_official{ ushort(5588) };
inline constexpr phrase<lngtag_when> lng_new_contact_updated_name{ ushort(5589) };
inline constexpr phrase<lngtag_when> lng_new_contact_updated_photo{ ushort(5590) };
inline constexpr phrase<> lng_new_contact_updated_now{ ushort(5591) };
inline constexpr phrase<lngtag_count> lng_new_contact_updated_hours{ ushort(5592) };
inline constexpr phrase<lngtag_count> lng_new_contact_updated_days{ ushort(5598) };
inline constexpr phrase<lngtag_count> lng_new_contact_updated_months{ ushort(5604) };
inline constexpr phrase<> lng_from_request_title_channel{ ushort(5610) };
inline constexpr phrase<> lng_from_request_title_group{ ushort(5611) };
inline constexpr phrase<lngtag_name, lngtag_date> lng_from_request_body{ ushort(5612) };
inline constexpr phrase<> lng_from_request_understand{ ushort(5613) };
inline constexpr phrase<lngtag_more_info> lng_cant_send_to_not_contact{ ushort(5614) };
inline constexpr phrase<lngtag_more_info> lng_cant_invite_not_contact{ ushort(5615) };
inline constexpr phrase<> lng_cant_more_info{ ushort(5616) };
inline constexpr phrase<> lng_cant_invite_banned{ ushort(5617) };
inline constexpr phrase<> lng_cant_invite_privacy{ ushort(5618) };
inline constexpr phrase<> lng_cant_invite_bot_to_channel{ ushort(5619) };
inline constexpr phrase<> lng_cant_do_this{ ushort(5620) };
inline constexpr phrase<> lng_cant_invite_offer_admin{ ushort(5621) };
inline constexpr phrase<> lng_cant_invite_make_admin{ ushort(5622) };
inline constexpr phrase<> lng_send_button{ ushort(5623) };
inline constexpr phrase<> lng_schedule_button{ ushort(5624) };
inline constexpr phrase<> lng_send_silent_message{ ushort(5625) };
inline constexpr phrase<> lng_schedule_message{ ushort(5626) };
inline constexpr phrase<> lng_reminder_message{ ushort(5627) };
inline constexpr phrase<> lng_schedule_title{ ushort(5628) };
inline constexpr phrase<> lng_remind_title{ ushort(5629) };
inline constexpr phrase<> lng_schedule_repeat_label{ ushort(5630) };
inline constexpr phrase<> lng_schedule_repeat_never{ ushort(5631) };
inline constexpr phrase<> lng_schedule_repeat_daily{ ushort(5632) };
inline constexpr phrase<> lng_schedule_repeat_weekly{ ushort(5633) };
inline constexpr phrase<> lng_schedule_repeat_biweekly{ ushort(5634) };
inline constexpr phrase<> lng_schedule_repeat_monthly{ ushort(5635) };
inline constexpr phrase<lngtag_count> lng_schedule_repeat_every_month{ ushort(5636) };
inline constexpr phrase<> lng_schedule_repeat_yearly{ ushort(5642) };
inline constexpr phrase<lngtag_link> lng_schedule_repeat_promo{ ushort(5643) };
inline constexpr phrase<> lng_schedule_repeat_promo_link{ ushort(5644) };
inline constexpr phrase<> lng_schedule_at{ ushort(5645) };
inline constexpr phrase<> lng_message_ph{ ushort(5646) };
inline constexpr phrase<> lng_broadcast_ph{ ushort(5647) };
inline constexpr phrase<> lng_broadcast_silent_ph{ ushort(5648) };
inline constexpr phrase<> lng_send_anonymous_ph{ ushort(5649) };
inline constexpr phrase<> lng_story_reply_ph{ ushort(5650) };
inline constexpr phrase<> lng_story_comment_ph{ ushort(5651) };
inline constexpr phrase<> lng_video_stream_comment_ph{ ushort(5652) };
inline constexpr phrase<lngtag_count> lng_video_stream_comment_paid_ph{ ushort(5653) };
inline constexpr phrase<> lng_video_stream_comments_disabled{ ushort(5659) };
inline constexpr phrase<> lng_video_stream_stars{ ushort(5660) };
inline constexpr phrase<> lng_video_stream_live{ ushort(5661) };
inline constexpr phrase<lngtag_count> lng_video_stream_watched{ ushort(5662) };
inline constexpr phrase<> lng_video_stream_edit_stars{ ushort(5668) };
inline constexpr phrase<> lng_video_stream_remove_stars{ ushort(5669) };
inline constexpr phrase<lngtag_count> lng_message_stars_ph{ ushort(5670) };
inline constexpr phrase<> lng_send_text_no{ ushort(5676) };
inline constexpr phrase<lngtag_types> lng_send_text_no_about{ ushort(5677) };
inline constexpr phrase<lngtag_types, lngtag_last> lng_send_text_type_and_last{ ushort(5678) };
inline constexpr phrase<> lng_send_text_type_photos{ ushort(5679) };
inline constexpr phrase<> lng_send_text_type_videos{ ushort(5680) };
inline constexpr phrase<> lng_send_text_type_video_messages{ ushort(5681) };
inline constexpr phrase<> lng_send_text_type_music{ ushort(5682) };
inline constexpr phrase<> lng_send_text_type_voice_messages{ ushort(5683) };
inline constexpr phrase<> lng_send_text_type_files{ ushort(5684) };
inline constexpr phrase<> lng_send_text_type_stickers{ ushort(5685) };
inline constexpr phrase<> lng_send_text_type_polls{ ushort(5686) };
inline constexpr phrase<> lng_send_gif_with_caption{ ushort(5687) };
inline constexpr phrase<> lng_send_as_title{ ushort(5688) };
inline constexpr phrase<> lng_send_as_anonymous_admin{ ushort(5689) };
inline constexpr phrase<lngtag_link> lng_send_as_premium_required{ ushort(5690) };
inline constexpr phrase<> lng_send_as_premium_required_link{ ushort(5691) };
inline constexpr phrase<> lng_record_cancel{ ushort(5692) };
inline constexpr phrase<> lng_record_cancel_stories{ ushort(5693) };
inline constexpr phrase<> lng_record_lock_cancel_sure{ ushort(5694) };
inline constexpr phrase<> lng_record_lock_cancel_sure_round{ ushort(5695) };
inline constexpr phrase<> lng_record_listen_cancel_sure{ ushort(5696) };
inline constexpr phrase<> lng_record_listen_cancel_sure_round{ ushort(5697) };
inline constexpr phrase<> lng_record_lock_discard{ ushort(5698) };
inline constexpr phrase<> lng_record_lock{ ushort(5699) };
inline constexpr phrase<> lng_record_lock_resume{ ushort(5700) };
inline constexpr phrase<> lng_record_lock_delete{ ushort(5701) };
inline constexpr phrase<> lng_record_lock_play{ ushort(5702) };
inline constexpr phrase<> lng_record_lock_pause{ ushort(5703) };
inline constexpr phrase<> lng_record_cancel_recording{ ushort(5704) };
inline constexpr phrase<> lng_record_hold_tip{ ushort(5705) };
inline constexpr phrase<> lng_record_voice_tip{ ushort(5706) };
inline constexpr phrase<> lng_record_video_tip{ ushort(5707) };
inline constexpr phrase<> lng_record_audio_problem{ ushort(5708) };
inline constexpr phrase<> lng_record_video_problem{ ushort(5709) };
inline constexpr phrase<> lng_record_once_first_tooltip{ ushort(5710) };
inline constexpr phrase<> lng_record_once_active_tooltip{ ushort(5711) };
inline constexpr phrase<> lng_record_once_active_video{ ushort(5712) };
inline constexpr phrase<> lng_will_be_notified{ ushort(5713) };
inline constexpr phrase<> lng_wont_be_notified{ ushort(5714) };
inline constexpr phrase<> lng_willbe_history{ ushort(5715) };
inline constexpr phrase<> lng_from_you{ ushort(5716) };
inline constexpr phrase<> lng_from_draft{ ushort(5717) };
inline constexpr phrase<> lng_bot_description{ ushort(5718) };
inline constexpr phrase<> lng_unblock_button{ ushort(5719) };
inline constexpr phrase<> lng_restart_button{ ushort(5720) };
inline constexpr phrase<> lng_channel_mute{ ushort(5721) };
inline constexpr phrase<> lng_channel_unmute{ ushort(5722) };
inline constexpr phrase<> lng_saved_messages{ ushort(5723) };
inline constexpr phrase<> lng_saved_short{ ushort(5724) };
inline constexpr phrase<> lng_saved_forward_here{ ushort(5725) };
inline constexpr phrase<> lng_saved_quote_here{ ushort(5726) };
inline constexpr phrase<> lng_saved_open_chat{ ushort(5727) };
inline constexpr phrase<> lng_saved_open_channel{ ushort(5728) };
inline constexpr phrase<> lng_saved_open_group{ ushort(5729) };
inline constexpr phrase<> lng_saved_about_hidden{ ushort(5730) };
inline constexpr phrase<> lng_scheduled_messages{ ushort(5731) };
inline constexpr phrase<> lng_scheduled_messages_empty{ ushort(5732) };
inline constexpr phrase<> lng_reminder_messages{ ushort(5733) };
inline constexpr phrase<lngtag_date> lng_scheduled_date{ ushort(5734) };
inline constexpr phrase<> lng_scheduled_date_until_online{ ushort(5735) };
inline constexpr phrase<> lng_scheduled_send_until_online{ ushort(5736) };
inline constexpr phrase<> lng_scheduled_send_now{ ushort(5737) };
inline constexpr phrase<lngtag_count> lng_scheduled_send_now_many{ ushort(5738) };
inline constexpr phrase<> lng_scheduled_video_tip_title{ ushort(5744) };
inline constexpr phrase<> lng_scheduled_video_tip_text{ ushort(5745) };
inline constexpr phrase<> lng_scheduled_video_tip{ ushort(5746) };
inline constexpr phrase<> lng_scheduled_video_published{ ushort(5747) };
inline constexpr phrase<> lng_scheduled_video_view{ ushort(5748) };
inline constexpr phrase<lngtag_count> lng_replies_view{ ushort(5749) };
inline constexpr phrase<> lng_replies_view_thread{ ushort(5755) };
inline constexpr phrase<lngtag_count> lng_replies_header{ ushort(5756) };
inline constexpr phrase<> lng_replies_header_none{ ushort(5762) };
inline constexpr phrase<> lng_replies_view_topic{ ushort(5763) };
inline constexpr phrase<lngtag_count> lng_comments_header{ ushort(5764) };
inline constexpr phrase<> lng_comments_header_none{ ushort(5770) };
inline constexpr phrase<lngtag_count> lng_comments_open_count{ ushort(5771) };
inline constexpr phrase<> lng_comments_open_none{ ushort(5777) };
inline constexpr phrase<> lng_replies_view_original{ ushort(5778) };
inline constexpr phrase<> lng_replies_messages{ ushort(5779) };
inline constexpr phrase<> lng_hidden_author_messages{ ushort(5780) };
inline constexpr phrase<> lng_my_notes{ ushort(5781) };
inline constexpr phrase<> lng_replies_discussion_started{ ushort(5782) };
inline constexpr phrase<> lng_replies_no_comments{ ushort(5783) };
inline constexpr phrase<> lng_verification_codes{ ushort(5784) };
inline constexpr phrase<> lng_verification_codes_about{ ushort(5785) };
inline constexpr phrase<> lng_archived_name{ ushort(5786) };
inline constexpr phrase<> lng_archived_add{ ushort(5787) };
inline constexpr phrase<> lng_archived_remove{ ushort(5788) };
inline constexpr phrase<> lng_archived_added{ ushort(5789) };
inline constexpr phrase<> lng_archived_removed{ ushort(5790) };
inline constexpr phrase<lngtag_accumulated, lngtag_chat> lng_archived_last_list{ ushort(5791) };
inline constexpr phrase<lngtag_count, lngtag_chats> lng_archived_last{ ushort(5792) };
inline constexpr phrase<lngtag_from_part, lngtag_message> lng_dialogs_text_with_from{ ushort(5798) };
inline constexpr phrase<lngtag_from> lng_dialogs_text_from_wrapped{ ushort(5799) };
inline constexpr phrase<lngtag_media_part, lngtag_caption> lng_dialogs_text_media{ ushort(5800) };
inline constexpr phrase<lngtag_media> lng_dialogs_text_media_wrapped{ ushort(5801) };
inline constexpr phrase<lngtag_from, lngtag_topic> lng_dialogs_text_from_in_topic{ ushort(5802) };
inline constexpr phrase<> lng_dialogs_skip_archive_in_search{ ushort(5803) };
inline constexpr phrase<> lng_dialogs_show_archive_in_search{ ushort(5804) };
inline constexpr phrase<> lng_dialogs_suggestions_birthday_title{ ushort(5805) };
inline constexpr phrase<> lng_dialogs_suggestions_birthday_about{ ushort(5806) };
inline constexpr phrase<lngtag_text> lng_dialogs_suggestions_birthday_contact_title{ ushort(5807) };
inline constexpr phrase<> lng_dialogs_suggestions_birthday_contact_about{ ushort(5808) };
inline constexpr phrase<lngtag_count> lng_dialogs_suggestions_birthday_contacts_title{ ushort(5809) };
inline constexpr phrase<> lng_dialogs_suggestions_birthday_contacts_about{ ushort(5815) };
inline constexpr phrase<> lng_dialogs_suggestions_birthday_contact_dismiss{ ushort(5816) };
inline constexpr phrase<lngtag_text> lng_dialogs_suggestions_premium_annual_title{ ushort(5817) };
inline constexpr phrase<> lng_dialogs_suggestions_premium_annual_about{ ushort(5818) };
inline constexpr phrase<lngtag_text> lng_dialogs_suggestions_premium_upgrade_title{ ushort(5819) };
inline constexpr phrase<> lng_dialogs_suggestions_premium_upgrade_about{ ushort(5820) };
inline constexpr phrase<lngtag_text> lng_dialogs_suggestions_premium_restore_title{ ushort(5821) };
inline constexpr phrase<> lng_dialogs_suggestions_premium_restore_about{ ushort(5822) };
inline constexpr phrase<> lng_dialogs_suggestions_premium_grace_title{ ushort(5823) };
inline constexpr phrase<> lng_dialogs_suggestions_premium_grace_about{ ushort(5824) };
inline constexpr phrase<> lng_dialogs_suggestions_userpics_title{ ushort(5825) };
inline constexpr phrase<> lng_dialogs_suggestions_userpics_about{ ushort(5826) };
inline constexpr phrase<lngtag_count, lngtag_emoji, lngtag_channels> lng_dialogs_suggestions_credits_sub_low_title{ ushort(5827) };
inline constexpr phrase<> lng_dialogs_suggestions_credits_sub_low_about{ ushort(5833) };
inline constexpr phrase<> lng_unconfirmed_auth_title{ ushort(5834) };
inline constexpr phrase<> lng_unconfirmed_auth_confirm{ ushort(5835) };
inline constexpr phrase<> lng_unconfirmed_auth_deny{ ushort(5836) };
inline constexpr phrase<lngtag_from, lngtag_country> lng_unconfirmed_auth_single{ ushort(5837) };
inline constexpr phrase<lngtag_count> lng_unconfirmed_auth_multiple{ ushort(5838) };
inline constexpr phrase<lngtag_count, lngtag_country> lng_unconfirmed_auth_multiple_from{ ushort(5844) };
inline constexpr phrase<lngtag_count> lng_unconfirmed_auth_denied_title{ ushort(5850) };
inline constexpr phrase<lngtag_country> lng_unconfirmed_auth_denied_single{ ushort(5856) };
inline constexpr phrase<lngtag_country> lng_unconfirmed_auth_denied_multiple{ ushort(5857) };
inline constexpr phrase<> lng_unconfirmed_auth_denied_warning{ ushort(5858) };
inline constexpr phrase<> lng_unconfirmed_auth_confirmed{ ushort(5859) };
inline constexpr phrase<lngtag_link> lng_unconfirmed_auth_confirmed_message{ ushort(5860) };
inline constexpr phrase<lngtag_emoji> lng_about_random{ ushort(5861) };
inline constexpr phrase<> lng_about_random_send{ ushort(5862) };
inline constexpr phrase<lngtag_amount> lng_about_random_stake{ ushort(5863) };
inline constexpr phrase<> lng_about_random_stake_change{ ushort(5864) };
inline constexpr phrase<> lng_open_this_link{ ushort(5865) };
inline constexpr phrase<> lng_open_link{ ushort(5866) };
inline constexpr phrase<lngtag_bot_name> lng_allow_bot_pass{ ushort(5867) };
inline constexpr phrase<> lng_allow_bot{ ushort(5868) };
inline constexpr phrase<lngtag_emoji> lng_allow_bot_webview_details{ ushort(5869) };
inline constexpr phrase<> lng_allow_bot_webview_details_about{ ushort(5870) };
inline constexpr phrase<lngtag_link> lng_url_auth_open_confirm{ ushort(5871) };
inline constexpr phrase<lngtag_domain, lngtag_user> lng_url_auth_login_option{ ushort(5872) };
inline constexpr phrase<lngtag_bot> lng_url_auth_allow_messages{ ushort(5873) };
inline constexpr phrase<lngtag_domain> lng_url_auth_login_title{ ushort(5874) };
inline constexpr phrase<> lng_url_auth_login_button{ ushort(5875) };
inline constexpr phrase<> lng_url_auth_site_access{ ushort(5876) };
inline constexpr phrase<> lng_url_auth_device_label{ ushort(5877) };
inline constexpr phrase<> lng_url_auth_ip_label{ ushort(5878) };
inline constexpr phrase<> lng_url_auth_login_attempt{ ushort(5879) };
inline constexpr phrase<> lng_url_auth_allow_messages_label{ ushort(5880) };
inline constexpr phrase<lngtag_bot> lng_url_auth_allow_messages_about{ ushort(5881) };
inline constexpr phrase<> lng_url_auth_phone_sure_title{ ushort(5882) };
inline constexpr phrase<lngtag_domain, lngtag_phone> lng_url_auth_phone_sure_text{ ushort(5883) };
inline constexpr phrase<> lng_url_auth_phone_sure_deny{ ushort(5884) };
inline constexpr phrase<> lng_url_auth_phone_toast_good_title{ ushort(5885) };
inline constexpr phrase<lngtag_domain> lng_url_auth_phone_toast_good{ ushort(5886) };
inline constexpr phrase<lngtag_domain> lng_url_auth_phone_toast_good_no_phone{ ushort(5887) };
inline constexpr phrase<> lng_url_auth_phone_toast_bad_title{ ushort(5888) };
inline constexpr phrase<lngtag_domain> lng_url_auth_phone_toast_bad{ ushort(5889) };
inline constexpr phrase<> lng_url_auth_phone_toast_bad_expired{ ushort(5890) };
inline constexpr phrase<> lng_bot_start{ ushort(5891) };
inline constexpr phrase<> lng_bot_choose_group{ ushort(5892) };
inline constexpr phrase<> lng_bot_no_groups{ ushort(5893) };
inline constexpr phrase<> lng_bot_groups_not_found{ ushort(5894) };
inline constexpr phrase<lngtag_group> lng_bot_sure_invite{ ushort(5895) };
inline constexpr phrase<> lng_bot_already_in_group{ ushort(5896) };
inline constexpr phrase<> lng_bot_choose_chat{ ushort(5897) };
inline constexpr phrase<> lng_bot_no_chats{ ushort(5898) };
inline constexpr phrase<> lng_bot_chats_not_found{ ushort(5899) };
inline constexpr phrase<lngtag_user> lng_bot_sure_share_game{ ushort(5900) };
inline constexpr phrase<lngtag_group> lng_bot_sure_share_game_group{ ushort(5901) };
inline constexpr phrase<> lng_bot_groups_manage{ ushort(5902) };
inline constexpr phrase<> lng_bot_channels_manage{ ushort(5903) };
inline constexpr phrase<> lng_bot_groups{ ushort(5904) };
inline constexpr phrase<> lng_bot_add_title{ ushort(5905) };
inline constexpr phrase<> lng_bot_as_admin_check{ ushort(5906) };
inline constexpr phrase<> lng_bot_add_as_admin{ ushort(5907) };
inline constexpr phrase<> lng_bot_add_as_member{ ushort(5908) };
inline constexpr phrase<lngtag_group> lng_bot_sure_add_text_group{ ushort(5909) };
inline constexpr phrase<lngtag_group> lng_bot_sure_add_text_channel{ ushort(5910) };
inline constexpr phrase<> lng_bot_no_webview{ ushort(5911) };
inline constexpr phrase<> lng_bot_remove_from_menu{ ushort(5912) };
inline constexpr phrase<lngtag_bot> lng_bot_remove_from_menu_sure{ ushort(5913) };
inline constexpr phrase<> lng_bot_remove_from_menu_done{ ushort(5914) };
inline constexpr phrase<> lng_bot_remove_from_side_menu{ ushort(5915) };
inline constexpr phrase<lngtag_bot> lng_bot_remove_from_side_menu_sure{ ushort(5916) };
inline constexpr phrase<> lng_bot_remove_from_side_menu_done{ ushort(5917) };
inline constexpr phrase<> lng_bot_settings{ ushort(5918) };
inline constexpr phrase<> lng_bot_open{ ushort(5919) };
inline constexpr phrase<> lng_bot_terms{ ushort(5920) };
inline constexpr phrase<> lng_bot_privacy{ ushort(5921) };
inline constexpr phrase<> lng_bot_reload_page{ ushort(5922) };
inline constexpr phrase<lngtag_bot> lng_bot_add_to_menu{ ushort(5923) };
inline constexpr phrase<> lng_bot_add_to_menu_done{ ushort(5924) };
inline constexpr phrase<lngtag_bot> lng_bot_will_be_added{ ushort(5925) };
inline constexpr phrase<> lng_bot_side_menu_new{ ushort(5926) };
inline constexpr phrase<> lng_bot_menu_not_supported{ ushort(5927) };
inline constexpr phrase<> lng_bot_menu_already_added{ ushort(5928) };
inline constexpr phrase<> lng_bot_menu_button{ ushort(5929) };
inline constexpr phrase<> lng_bot_close_warning_title{ ushort(5930) };
inline constexpr phrase<> lng_bot_close_warning{ ushort(5931) };
inline constexpr phrase<> lng_bot_close_warning_sure{ ushort(5932) };
inline constexpr phrase<lngtag_bot> lng_bot_add_to_side_menu{ ushort(5933) };
inline constexpr phrase<> lng_bot_add_to_side_menu_done{ ushort(5934) };
inline constexpr phrase<> lng_bot_no_scan_qr{ ushort(5935) };
inline constexpr phrase<> lng_bot_no_share_story{ ushort(5936) };
inline constexpr phrase<> lng_bot_emoji_status_confirm{ ushort(5937) };
inline constexpr phrase<> lng_bot_emoji_status_title{ ushort(5938) };
inline constexpr phrase<lngtag_bot> lng_bot_emoji_status_text{ ushort(5939) };
inline constexpr phrase<lngtag_bot, lngtag_name> lng_bot_emoji_status_access_text{ ushort(5940) };
inline constexpr phrase<> lng_bot_emoji_status_access_allow{ ushort(5941) };
inline constexpr phrase<> lng_bot_share_prepared_title{ ushort(5942) };
inline constexpr phrase<lngtag_bot> lng_bot_share_prepared_about{ ushort(5943) };
inline constexpr phrase<> lng_bot_share_prepared_button{ ushort(5944) };
inline constexpr phrase<> lng_bot_download_file{ ushort(5945) };
inline constexpr phrase<lngtag_bot> lng_bot_download_file_sure{ ushort(5946) };
inline constexpr phrase<> lng_bot_download_file_button{ ushort(5947) };
inline constexpr phrase<> lng_bot_download_starting{ ushort(5948) };
inline constexpr phrase<lngtag_retry> lng_bot_download_failed{ ushort(5949) };
inline constexpr phrase<> lng_bot_download_retry{ ushort(5950) };
inline constexpr phrase<lngtag_count> lng_bot_status_users{ ushort(5951) };
inline constexpr phrase<> lng_typing{ ushort(5957) };
inline constexpr phrase<lngtag_user> lng_user_typing{ ushort(5958) };
inline constexpr phrase<lngtag_user, lngtag_second_user> lng_users_typing{ ushort(5959) };
inline constexpr phrase<lngtag_count> lng_many_typing{ ushort(5960) };
inline constexpr phrase<> lng_playing_game{ ushort(5966) };
inline constexpr phrase<lngtag_user> lng_user_playing_game{ ushort(5967) };
inline constexpr phrase<lngtag_user, lngtag_second_user> lng_users_playing_game{ ushort(5968) };
inline constexpr phrase<lngtag_count> lng_many_playing_game{ ushort(5969) };
inline constexpr phrase<> lng_send_action_record_video{ ushort(5975) };
inline constexpr phrase<lngtag_user> lng_user_action_record_video{ ushort(5976) };
inline constexpr phrase<> lng_send_action_upload_video{ ushort(5977) };
inline constexpr phrase<lngtag_user> lng_user_action_upload_video{ ushort(5978) };
inline constexpr phrase<> lng_send_action_record_audio{ ushort(5979) };
inline constexpr phrase<lngtag_user> lng_user_action_record_audio{ ushort(5980) };
inline constexpr phrase<> lng_send_action_upload_audio{ ushort(5981) };
inline constexpr phrase<lngtag_user> lng_user_action_upload_audio{ ushort(5982) };
inline constexpr phrase<> lng_send_action_record_round{ ushort(5983) };
inline constexpr phrase<lngtag_user> lng_user_action_record_round{ ushort(5984) };
inline constexpr phrase<> lng_send_action_upload_round{ ushort(5985) };
inline constexpr phrase<lngtag_user> lng_user_action_upload_round{ ushort(5986) };
inline constexpr phrase<> lng_send_action_upload_photo{ ushort(5987) };
inline constexpr phrase<lngtag_user> lng_user_action_upload_photo{ ushort(5988) };
inline constexpr phrase<> lng_send_action_upload_file{ ushort(5989) };
inline constexpr phrase<lngtag_user> lng_user_action_upload_file{ ushort(5990) };
inline constexpr phrase<> lng_send_action_choose_sticker{ ushort(5991) };
inline constexpr phrase<lngtag_user> lng_user_action_choose_sticker{ ushort(5992) };
inline constexpr phrase<lngtag_emoji> lng_user_action_watching_animations{ ushort(5993) };
inline constexpr phrase<lngtag_count> lng_unread_bar{ ushort(5994) };
inline constexpr phrase<> lng_unread_bar_some{ ushort(6000) };
inline constexpr phrase<> lng_maps_point{ ushort(6001) };
inline constexpr phrase<> lng_maps_select_on_map{ ushort(6002) };
inline constexpr phrase<> lng_maps_point_send{ ushort(6003) };
inline constexpr phrase<> lng_maps_point_set{ ushort(6004) };
inline constexpr phrase<> lng_maps_or_choose{ ushort(6005) };
inline constexpr phrase<> lng_maps_places_in_area{ ushort(6006) };
inline constexpr phrase<> lng_maps_no_places{ ushort(6007) };
inline constexpr phrase<> lng_maps_choose_to_search{ ushort(6008) };
inline constexpr phrase<> lng_maps_venues_source{ ushort(6009) };
inline constexpr phrase<> lng_live_location{ ushort(6010) };
inline constexpr phrase<> lng_live_location_now{ ushort(6011) };
inline constexpr phrase<lngtag_count> lng_live_location_minutes{ ushort(6012) };
inline constexpr phrase<lngtag_count> lng_live_location_hours{ ushort(6018) };
inline constexpr phrase<lngtag_time> lng_live_location_today{ ushort(6024) };
inline constexpr phrase<lngtag_time> lng_live_location_yesterday{ ushort(6025) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_live_location_date_time{ ushort(6026) };
inline constexpr phrase<> lng_save_photo{ ushort(6027) };
inline constexpr phrase<> lng_save_video{ ushort(6028) };
inline constexpr phrase<> lng_save_audio_file{ ushort(6029) };
inline constexpr phrase<> lng_save_audio{ ushort(6030) };
inline constexpr phrase<> lng_save_file{ ushort(6031) };
inline constexpr phrase<lngtag_ready, lngtag_total, lngtag_mb> lng_save_downloaded{ ushort(6032) };
inline constexpr phrase<lngtag_duration, lngtag_size> lng_duration_and_size{ ushort(6033) };
inline constexpr phrase<lngtag_played, lngtag_duration> lng_duration_played{ ushort(6034) };
inline constexpr phrase<lngtag_date, lngtag_duration> lng_date_and_duration{ ushort(6035) };
inline constexpr phrase<> lng_choose_image{ ushort(6036) };
inline constexpr phrase<> lng_choose_file{ ushort(6037) };
inline constexpr phrase<> lng_choose_files{ ushort(6038) };
inline constexpr phrase<> lng_choose_cover{ ushort(6039) };
inline constexpr phrase<> lng_choose_cover_bad{ ushort(6040) };
inline constexpr phrase<> lng_game_tag{ ushort(6041) };
inline constexpr phrase<> lng_context_new_window{ ushort(6042) };
inline constexpr phrase<> lng_context_view_profile{ ushort(6043) };
inline constexpr phrase<> lng_context_send_message{ ushort(6044) };
inline constexpr phrase<> lng_context_view_group{ ushort(6045) };
inline constexpr phrase<> lng_context_view_channel{ ushort(6046) };
inline constexpr phrase<> lng_context_view_topic{ ushort(6047) };
inline constexpr phrase<> lng_context_view_thread{ ushort(6048) };
inline constexpr phrase<> lng_context_hide_psa{ ushort(6049) };
inline constexpr phrase<> lng_context_pin_to_top{ ushort(6050) };
inline constexpr phrase<> lng_context_unpin_from_top{ ushort(6051) };
inline constexpr phrase<> lng_context_mark_unread{ ushort(6052) };
inline constexpr phrase<> lng_context_mark_read{ ushort(6053) };
inline constexpr phrase<> lng_context_mark_read_sure{ ushort(6054) };
inline constexpr phrase<> lng_context_mark_read_all{ ushort(6055) };
inline constexpr phrase<> lng_context_mark_read_all_sure{ ushort(6056) };
inline constexpr phrase<> lng_context_mark_read_all_sure_2{ ushort(6057) };
inline constexpr phrase<> lng_context_mark_read_mentions_all{ ushort(6058) };
inline constexpr phrase<> lng_context_mark_read_reactions_all{ ushort(6059) };
inline constexpr phrase<> lng_context_archive_expand{ ushort(6060) };
inline constexpr phrase<> lng_context_archive_collapse{ ushort(6061) };
inline constexpr phrase<> lng_context_archive_to_menu{ ushort(6062) };
inline constexpr phrase<> lng_context_archive_to_list{ ushort(6063) };
inline constexpr phrase<> lng_context_archive_to_menu_info{ ushort(6064) };
inline constexpr phrase<> lng_context_archive_settings{ ushort(6065) };
inline constexpr phrase<> lng_context_archive_how_does_it_work{ ushort(6066) };
inline constexpr phrase<> lng_context_mute{ ushort(6067) };
inline constexpr phrase<> lng_context_unmute{ ushort(6068) };
inline constexpr phrase<> lng_context_promote_admin{ ushort(6069) };
inline constexpr phrase<> lng_context_edit_permissions{ ushort(6070) };
inline constexpr phrase<> lng_context_restrict_user{ ushort(6071) };
inline constexpr phrase<> lng_context_ban_user{ ushort(6072) };
inline constexpr phrase<> lng_context_remove_from_group{ ushort(6073) };
inline constexpr phrase<> lng_context_add_to_group{ ushort(6074) };
inline constexpr phrase<> lng_context_rate_transcription{ ushort(6075) };
inline constexpr phrase<> lng_toast_sent_rate_transcription{ ushort(6076) };
inline constexpr phrase<> lng_context_copy_link{ ushort(6077) };
inline constexpr phrase<> lng_context_copy_message_link{ ushort(6078) };
inline constexpr phrase<> lng_context_copy_post_link{ ushort(6079) };
inline constexpr phrase<> lng_context_copy_topic_link{ ushort(6080) };
inline constexpr phrase<> lng_context_copy_email{ ushort(6081) };
inline constexpr phrase<> lng_context_copy_hashtag{ ushort(6082) };
inline constexpr phrase<> lng_context_copy_mention{ ushort(6083) };
inline constexpr phrase<> lng_context_copy_filename{ ushort(6084) };
inline constexpr phrase<> lng_context_save_image{ ushort(6085) };
inline constexpr phrase<> lng_context_copy_image{ ushort(6086) };
inline constexpr phrase<> lng_context_cancel_download{ ushort(6087) };
inline constexpr phrase<> lng_context_show_in_folder{ ushort(6088) };
inline constexpr phrase<> lng_context_show_in_finder{ ushort(6089) };
inline constexpr phrase<> lng_context_save_video{ ushort(6090) };
inline constexpr phrase<> lng_context_save_audio_file{ ushort(6091) };
inline constexpr phrase<> lng_context_save_audio{ ushort(6092) };
inline constexpr phrase<> lng_context_pack_info{ ushort(6093) };
inline constexpr phrase<> lng_context_pack_add{ ushort(6094) };
inline constexpr phrase<> lng_context_save_file{ ushort(6095) };
inline constexpr phrase<> lng_context_save_music_to{ ushort(6096) };
inline constexpr phrase<> lng_context_save_music_profile{ ushort(6097) };
inline constexpr phrase<> lng_context_save_music_saved{ ushort(6098) };
inline constexpr phrase<> lng_context_save_music_folder{ ushort(6099) };
inline constexpr phrase<> lng_context_save_music_about{ ushort(6100) };
inline constexpr phrase<> lng_context_copy_text{ ushort(6101) };
inline constexpr phrase<> lng_context_open_gif{ ushort(6102) };
inline constexpr phrase<> lng_context_save_gif{ ushort(6103) };
inline constexpr phrase<> lng_context_delete_gif{ ushort(6104) };
inline constexpr phrase<> lng_context_open_channel{ ushort(6105) };
inline constexpr phrase<> lng_context_open_group{ ushort(6106) };
inline constexpr phrase<> lng_context_attached_stickers{ ushort(6107) };
inline constexpr phrase<> lng_context_to_msg{ ushort(6108) };
inline constexpr phrase<> lng_context_reply_msg{ ushort(6109) };
inline constexpr phrase<> lng_context_quote_and_reply{ ushort(6110) };
inline constexpr phrase<> lng_context_reply_to_task{ ushort(6111) };
inline constexpr phrase<> lng_context_edit_msg{ ushort(6112) };
inline constexpr phrase<> lng_context_add_factcheck{ ushort(6113) };
inline constexpr phrase<> lng_context_edit_factcheck{ ushort(6114) };
inline constexpr phrase<> lng_context_add_offer{ ushort(6115) };
inline constexpr phrase<> lng_context_forward_msg{ ushort(6116) };
inline constexpr phrase<> lng_context_send_now_msg{ ushort(6117) };
inline constexpr phrase<> lng_context_reschedule{ ushort(6118) };
inline constexpr phrase<> lng_context_delete_msg{ ushort(6119) };
inline constexpr phrase<lngtag_duration> lng_context_auto_delete_in{ ushort(6120) };
inline constexpr phrase<> lng_context_select_msg{ ushort(6121) };
inline constexpr phrase<> lng_context_select_msg_bulk{ ushort(6122) };
inline constexpr phrase<> lng_context_report_msg{ ushort(6123) };
inline constexpr phrase<> lng_context_pin_msg{ ushort(6124) };
inline constexpr phrase<> lng_context_unpin_msg{ ushort(6125) };
inline constexpr phrase<> lng_context_cancel_upload{ ushort(6126) };
inline constexpr phrase<> lng_context_upload_edit_caption{ ushort(6127) };
inline constexpr phrase<> lng_context_copy_selected{ ushort(6128) };
inline constexpr phrase<> lng_context_copy_selected_items{ ushort(6129) };
inline constexpr phrase<> lng_context_forward_selected{ ushort(6130) };
inline constexpr phrase<> lng_context_send_now_selected{ ushort(6131) };
inline constexpr phrase<> lng_context_reschedule_selected{ ushort(6132) };
inline constexpr phrase<> lng_context_delete_selected{ ushort(6133) };
inline constexpr phrase<> lng_context_save_images_selected{ ushort(6134) };
inline constexpr phrase<> lng_context_save_documents_selected{ ushort(6135) };
inline constexpr phrase<> lng_context_clear_selection{ ushort(6136) };
inline constexpr phrase<> lng_context_seen_loading{ ushort(6137) };
inline constexpr phrase<lngtag_count> lng_context_seen_text{ ushort(6138) };
inline constexpr phrase<> lng_context_seen_text_none{ ushort(6144) };
inline constexpr phrase<lngtag_count> lng_context_seen_listened{ ushort(6145) };
inline constexpr phrase<> lng_context_seen_listened_none{ ushort(6151) };
inline constexpr phrase<lngtag_count> lng_context_seen_watched{ ushort(6152) };
inline constexpr phrase<> lng_context_seen_watched_none{ ushort(6158) };
inline constexpr phrase<lngtag_count> lng_context_seen_reacted{ ushort(6159) };
inline constexpr phrase<> lng_context_seen_reacted_none{ ushort(6165) };
inline constexpr phrase<> lng_context_seen_reacted_all{ ushort(6166) };
inline constexpr phrase<lngtag_user> lng_context_sent_by{ ushort(6167) };
inline constexpr phrase<lngtag_time> lng_context_sent_today{ ushort(6168) };
inline constexpr phrase<lngtag_time> lng_context_sent_yesterday{ ushort(6169) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_context_sent_date{ ushort(6170) };
inline constexpr phrase<> lng_context_set_as_quick{ ushort(6171) };
inline constexpr phrase<> lng_context_filter_by_tag{ ushort(6172) };
inline constexpr phrase<> lng_context_tag_add_name{ ushort(6173) };
inline constexpr phrase<> lng_context_tag_edit_name{ ushort(6174) };
inline constexpr phrase<> lng_context_remove_tag{ ushort(6175) };
inline constexpr phrase<> lng_context_delete_from_disk{ ushort(6176) };
inline constexpr phrase<> lng_context_delete_all_files{ ushort(6177) };
inline constexpr phrase<> lng_context_save_custom_sound{ ushort(6178) };
inline constexpr phrase<> lng_context_translate{ ushort(6179) };
inline constexpr phrase<> lng_context_translate_selected{ ushort(6180) };
inline constexpr phrase<> lng_context_read_hidden{ ushort(6181) };
inline constexpr phrase<> lng_context_read_show{ ushort(6182) };
inline constexpr phrase<> lng_context_edit_shortcut{ ushort(6183) };
inline constexpr phrase<> lng_context_delete_shortcut{ ushort(6184) };
inline constexpr phrase<> lng_context_gift_send{ ushort(6185) };
inline constexpr phrase<> lng_context_charge_fee{ ushort(6186) };
inline constexpr phrase<> lng_context_remove_fee{ ushort(6187) };
inline constexpr phrase<lngtag_name, lngtag_amount> lng_context_fee_now{ ushort(6188) };
inline constexpr phrase<lngtag_name> lng_context_fee_free{ ushort(6189) };
inline constexpr phrase<> lng_add_tag_about{ ushort(6190) };
inline constexpr phrase<lngtag_link> lng_subscribe_tag_about{ ushort(6191) };
inline constexpr phrase<> lng_subscribe_tag_link{ ushort(6192) };
inline constexpr phrase<> lng_edit_tag_about{ ushort(6193) };
inline constexpr phrase<> lng_edit_tag_name{ ushort(6194) };
inline constexpr phrase<> lng_add_tag_button{ ushort(6195) };
inline constexpr phrase<lngtag_arrow> lng_add_tag_phrase{ ushort(6196) };
inline constexpr phrase<lngtag_arrow> lng_add_tag_phrase_long{ ushort(6197) };
inline constexpr phrase<> lng_unlock_tags{ ushort(6198) };
inline constexpr phrase<lngtag_count> lng_add_tag_selector{ ushort(6199) };
inline constexpr phrase<lngtag_emoji> lng_message_tagged_with{ ushort(6205) };
inline constexpr phrase<> lng_tagged_view_saved{ ushort(6206) };
inline constexpr phrase<> lng_add_channel_to_filter_selector{ ushort(6207) };
inline constexpr phrase<> lng_add_group_to_filter_selector{ ushort(6208) };
inline constexpr phrase<lngtag_name> lng_context_animated_emoji{ ushort(6209) };
inline constexpr phrase<lngtag_count> lng_context_animated_emoji_many{ ushort(6210) };
inline constexpr phrase<lngtag_name> lng_context_animated_reaction{ ushort(6216) };
inline constexpr phrase<lngtag_name> lng_context_animated_tag{ ushort(6217) };
inline constexpr phrase<lngtag_name> lng_context_animated_reactions{ ushort(6218) };
inline constexpr phrase<lngtag_count> lng_context_animated_reactions_many{ ushort(6219) };
inline constexpr phrase<> lng_context_noforwards_info_channel{ ushort(6225) };
inline constexpr phrase<> lng_context_noforwards_info_group{ ushort(6226) };
inline constexpr phrase<> lng_context_noforwards_info_bot{ ushort(6227) };
inline constexpr phrase<> lng_context_spoiler_effect{ ushort(6228) };
inline constexpr phrase<> lng_context_disable_spoiler{ ushort(6229) };
inline constexpr phrase<> lng_context_make_paid{ ushort(6230) };
inline constexpr phrase<> lng_context_change_price{ ushort(6231) };
inline constexpr phrase<> lng_context_edit_cover{ ushort(6232) };
inline constexpr phrase<> lng_context_clear_cover{ ushort(6233) };
inline constexpr phrase<> lng_context_mention{ ushort(6234) };
inline constexpr phrase<> lng_context_search_from{ ushort(6235) };
inline constexpr phrase<> lng_factcheck_title{ ushort(6236) };
inline constexpr phrase<> lng_factcheck_placeholder{ ushort(6237) };
inline constexpr phrase<> lng_factcheck_whats_this{ ushort(6238) };
inline constexpr phrase<lngtag_country> lng_factcheck_about{ ushort(6239) };
inline constexpr phrase<> lng_factcheck_add_done{ ushort(6240) };
inline constexpr phrase<> lng_factcheck_edit_done{ ushort(6241) };
inline constexpr phrase<> lng_factcheck_remove_done{ ushort(6242) };
inline constexpr phrase<lngtag_country> lng_factcheck_bottom{ ushort(6243) };
inline constexpr phrase<> lng_factcheck_links{ ushort(6244) };
inline constexpr phrase<> lng_paid_title{ ushort(6245) };
inline constexpr phrase<> lng_paid_enter_cost{ ushort(6246) };
inline constexpr phrase<> lng_paid_cost_placeholder{ ushort(6247) };
inline constexpr phrase<lngtag_link> lng_paid_about{ ushort(6248) };
inline constexpr phrase<> lng_paid_about_link{ ushort(6249) };
inline constexpr phrase<> lng_paid_about_link_url{ ushort(6250) };
inline constexpr phrase<lngtag_price> lng_paid_price{ ushort(6251) };
inline constexpr phrase<> lng_paid_react_title{ ushort(6252) };
inline constexpr phrase<lngtag_channel> lng_paid_react_about{ ushort(6253) };
inline constexpr phrase<lngtag_count> lng_paid_react_already{ ushort(6254) };
inline constexpr phrase<> lng_paid_react_top_title{ ushort(6260) };
inline constexpr phrase<lngtag_price> lng_paid_react_send{ ushort(6261) };
inline constexpr phrase<lngtag_link> lng_paid_react_agree{ ushort(6262) };
inline constexpr phrase<> lng_paid_react_agree_link{ ushort(6263) };
inline constexpr phrase<> lng_paid_react_admin_cant{ ushort(6264) };
inline constexpr phrase<lngtag_count> lng_paid_react_toast{ ushort(6265) };
inline constexpr phrase<lngtag_count> lng_paid_react_toast_anonymous{ ushort(6271) };
inline constexpr phrase<lngtag_count> lng_paid_react_toast_text{ ushort(6277) };
inline constexpr phrase<> lng_paid_react_undo{ ushort(6283) };
inline constexpr phrase<> lng_paid_react_show_in_top{ ushort(6284) };
inline constexpr phrase<> lng_paid_react_anonymous{ ushort(6285) };
inline constexpr phrase<> lng_paid_comment_title{ ushort(6286) };
inline constexpr phrase<lngtag_name> lng_paid_comment_about{ ushort(6287) };
inline constexpr phrase<lngtag_stars> lng_paid_comment_button{ ushort(6288) };
inline constexpr phrase<> lng_paid_comment_pin_about{ ushort(6289) };
inline constexpr phrase<lngtag_count> lng_paid_comment_limit_about{ ushort(6290) };
inline constexpr phrase<lngtag_count> lng_paid_comment_emoji_about{ ushort(6296) };
inline constexpr phrase<> lng_paid_reaction_title{ ushort(6302) };
inline constexpr phrase<lngtag_name> lng_paid_reaction_about{ ushort(6303) };
inline constexpr phrase<lngtag_stars> lng_paid_reaction_button{ ushort(6304) };
inline constexpr phrase<> lng_paid_admin_title{ ushort(6305) };
inline constexpr phrase<> lng_paid_admin_about{ ushort(6306) };
inline constexpr phrase<> lng_sensitive_tag{ ushort(6307) };
inline constexpr phrase<> lng_sensitive_title{ ushort(6308) };
inline constexpr phrase<> lng_sensitive_text{ ushort(6309) };
inline constexpr phrase<> lng_sensitive_always{ ushort(6310) };
inline constexpr phrase<> lng_sensitive_view{ ushort(6311) };
inline constexpr phrase<> lng_sensitive_toast{ ushort(6312) };
inline constexpr phrase<> lng_translate_show_original{ ushort(6313) };
inline constexpr phrase<lngtag_language> lng_translate_return_original{ ushort(6314) };
inline constexpr phrase<lngtag_name> lng_translate_bar_to{ ushort(6315) };
inline constexpr phrase<lngtag_name> lng_translate_bar_to_other{ ushort(6316) };
inline constexpr phrase<> lng_translate_menu_to{ ushort(6317) };
inline constexpr phrase<lngtag_name> lng_translate_menu_dont{ ushort(6318) };
inline constexpr phrase<lngtag_name> lng_translate_menu_dont_other{ ushort(6319) };
inline constexpr phrase<> lng_translate_menu_hide{ ushort(6320) };
inline constexpr phrase<> lng_translate_hidden_user{ ushort(6321) };
inline constexpr phrase<> lng_translate_hidden_group{ ushort(6322) };
inline constexpr phrase<> lng_translate_hidden_channel{ ushort(6323) };
inline constexpr phrase<lngtag_name> lng_translate_dont_added{ ushort(6324) };
inline constexpr phrase<> lng_translate_settings{ ushort(6325) };
inline constexpr phrase<> lng_translate_undo{ ushort(6326) };
inline constexpr phrase<lngtag_emoji, lngtag_link> lng_translate_cocoon_menu{ ushort(6327) };
inline constexpr phrase<> lng_translate_cocoon_link{ ushort(6328) };
inline constexpr phrase<> lng_translate_cocoon_title{ ushort(6329) };
inline constexpr phrase<lngtag_text> lng_translate_cocoon_subtitle{ ushort(6330) };
inline constexpr phrase<> lng_translate_cocoon_explain{ ushort(6331) };
inline constexpr phrase<> lng_translate_cocoon_private_title{ ushort(6332) };
inline constexpr phrase<lngtag_mention> lng_translate_cocoon_private_text{ ushort(6333) };
inline constexpr phrase<> lng_translate_cocoon_private_mention{ ushort(6334) };
inline constexpr phrase<> lng_translate_cocoon_efficient_title{ ushort(6335) };
inline constexpr phrase<> lng_translate_cocoon_efficient_text{ ushort(6336) };
inline constexpr phrase<> lng_translate_cocoon_everyone_title{ ushort(6337) };
inline constexpr phrase<lngtag_domain> lng_translate_cocoon_everyone_text{ ushort(6338) };
inline constexpr phrase<> lng_translate_cocoon_everyone_domain{ ushort(6339) };
inline constexpr phrase<lngtag_link> lng_translate_cocoon_text{ ushort(6340) };
inline constexpr phrase<> lng_translate_cocoon_text_link{ ushort(6341) };
inline constexpr phrase<> lng_translate_cocoon_done{ ushort(6342) };
inline constexpr phrase<> lng_downloads_section{ ushort(6343) };
inline constexpr phrase<> lng_downloads_view_in_chat{ ushort(6344) };
inline constexpr phrase<> lng_downloads_view_in_section{ ushort(6345) };
inline constexpr phrase<> lng_downloads_delete_sure_one{ ushort(6346) };
inline constexpr phrase<> lng_downloads_delete_sure_all{ ushort(6347) };
inline constexpr phrase<lngtag_count> lng_downloads_delete_sure{ ushort(6348) };
inline constexpr phrase<> lng_downloads_delete_in_cloud_one{ ushort(6354) };
inline constexpr phrase<> lng_downloads_delete_in_cloud{ ushort(6355) };
inline constexpr phrase<lngtag_name> lng_send_image_empty{ ushort(6356) };
inline constexpr phrase<lngtag_count> lng_send_images_selected{ ushort(6357) };
inline constexpr phrase<lngtag_count> lng_send_files_selected{ ushort(6363) };
inline constexpr phrase<> lng_send_grouped{ ushort(6369) };
inline constexpr phrase<> lng_send_compressed_one{ ushort(6370) };
inline constexpr phrase<> lng_send_compressed{ ushort(6371) };
inline constexpr phrase<> lng_send_media_invalid_files{ ushort(6372) };
inline constexpr phrase<> lng_send_image{ ushort(6373) };
inline constexpr phrase<> lng_send_file{ ushort(6374) };
inline constexpr phrase<> lng_send_video{ ushort(6375) };
inline constexpr phrase<> lng_forward_choose{ ushort(6376) };
inline constexpr phrase<> lng_forward_cant{ ushort(6377) };
inline constexpr phrase<lngtag_recipient> lng_forward_share_contact{ ushort(6378) };
inline constexpr phrase<> lng_forward_share_cant{ ushort(6379) };
inline constexpr phrase<> lng_forward_send_files_cant{ ushort(6380) };
inline constexpr phrase<> lng_forward_send{ ushort(6381) };
inline constexpr phrase<lngtag_count> lng_forward_messages{ ushort(6382) };
inline constexpr phrase<lngtag_count, lngtag_user> lng_forwarding_from{ ushort(6388) };
inline constexpr phrase<lngtag_user, lngtag_second_user> lng_forwarding_from_two{ ushort(6394) };
inline constexpr phrase<> lng_inline_switch_choose{ ushort(6395) };
inline constexpr phrase<> lng_inline_switch_cant{ ushort(6396) };
inline constexpr phrase<lngtag_name> lng_preview_reply_to{ ushort(6397) };
inline constexpr phrase<lngtag_name> lng_preview_reply_to_quote{ ushort(6398) };
inline constexpr phrase<lngtag_title> lng_preview_reply_to_task{ ushort(6399) };
inline constexpr phrase<> lng_suggest_bar_title{ ushort(6400) };
inline constexpr phrase<> lng_suggest_bar_text{ ushort(6401) };
inline constexpr phrase<lngtag_amount> lng_suggest_bar_priced{ ushort(6402) };
inline constexpr phrase<lngtag_date> lng_suggest_bar_dated{ ushort(6403) };
inline constexpr phrase<> lng_suggest_options_title{ ushort(6404) };
inline constexpr phrase<> lng_suggest_options_change{ ushort(6405) };
inline constexpr phrase<> lng_suggest_options_stars_offer{ ushort(6406) };
inline constexpr phrase<> lng_suggest_options_stars_request{ ushort(6407) };
inline constexpr phrase<> lng_suggest_options_stars_price{ ushort(6408) };
inline constexpr phrase<> lng_suggest_options_stars_price_about{ ushort(6409) };
inline constexpr phrase<> lng_suggest_options_ton_offer{ ushort(6410) };
inline constexpr phrase<> lng_suggest_options_ton_request{ ushort(6411) };
inline constexpr phrase<> lng_suggest_options_ton_price{ ushort(6412) };
inline constexpr phrase<> lng_suggest_options_ton_price_about{ ushort(6413) };
inline constexpr phrase<> lng_suggest_options_date{ ushort(6414) };
inline constexpr phrase<> lng_suggest_options_date_any{ ushort(6415) };
inline constexpr phrase<> lng_suggest_options_date_publish{ ushort(6416) };
inline constexpr phrase<> lng_suggest_options_date_now{ ushort(6417) };
inline constexpr phrase<> lng_suggest_options_date_about{ ushort(6418) };
inline constexpr phrase<lngtag_count, lngtag_percent> lng_suggest_options_you_get_stars{ ushort(6419) };
inline constexpr phrase<lngtag_count, lngtag_percent> lng_suggest_options_you_get_ton{ ushort(6425) };
inline constexpr phrase<> lng_suggest_options_stars_warning{ ushort(6431) };
inline constexpr phrase<lngtag_amount> lng_suggest_options_offer{ ushort(6432) };
inline constexpr phrase<> lng_suggest_options_offer_free{ ushort(6433) };
inline constexpr phrase<> lng_suggest_options_update{ ushort(6434) };
inline constexpr phrase<> lng_suggest_options_update_date{ ushort(6435) };
inline constexpr phrase<> lng_suggest_action_decline{ ushort(6436) };
inline constexpr phrase<> lng_suggest_action_accept{ ushort(6437) };
inline constexpr phrase<> lng_suggest_action_change{ ushort(6438) };
inline constexpr phrase<> lng_suggest_action_your{ ushort(6439) };
inline constexpr phrase<lngtag_from> lng_suggest_action_his{ ushort(6440) };
inline constexpr phrase<> lng_suggest_action_price_label{ ushort(6441) };
inline constexpr phrase<> lng_suggest_action_price_free{ ushort(6442) };
inline constexpr phrase<> lng_suggest_action_time_label{ ushort(6443) };
inline constexpr phrase<> lng_suggest_action_time_any{ ushort(6444) };
inline constexpr phrase<> lng_suggest_action_agreement{ ushort(6445) };
inline constexpr phrase<lngtag_channel, lngtag_date> lng_suggest_action_agree_date{ ushort(6446) };
inline constexpr phrase<lngtag_count> lng_suggest_action_your_charged_stars{ ushort(6447) };
inline constexpr phrase<lngtag_count> lng_suggest_action_your_charged_ton{ ushort(6453) };
inline constexpr phrase<lngtag_count, lngtag_from> lng_suggest_action_his_charged_stars{ ushort(6459) };
inline constexpr phrase<lngtag_count, lngtag_from> lng_suggest_action_his_charged_ton{ ushort(6465) };
inline constexpr phrase<lngtag_channel> lng_suggest_action_agree_receive_stars{ ushort(6471) };
inline constexpr phrase<lngtag_channel> lng_suggest_action_agree_receive_ton{ ushort(6472) };
inline constexpr phrase<lngtag_channel> lng_suggest_action_agree_removed_stars{ ushort(6473) };
inline constexpr phrase<lngtag_channel> lng_suggest_action_agree_removed_ton{ ushort(6474) };
inline constexpr phrase<> lng_suggest_action_your_not_enough_stars{ ushort(6475) };
inline constexpr phrase<> lng_suggest_action_your_not_enough_ton{ ushort(6476) };
inline constexpr phrase<> lng_suggest_action_his_not_enough_stars{ ushort(6477) };
inline constexpr phrase<> lng_suggest_action_his_not_enough_ton{ ushort(6478) };
inline constexpr phrase<lngtag_from> lng_suggest_action_declined{ ushort(6479) };
inline constexpr phrase<lngtag_from> lng_suggest_action_declined_reason{ ushort(6480) };
inline constexpr phrase<lngtag_from> lng_suggest_change_price{ ushort(6481) };
inline constexpr phrase<lngtag_from> lng_suggest_change_time{ ushort(6482) };
inline constexpr phrase<lngtag_from> lng_suggest_change_price_time{ ushort(6483) };
inline constexpr phrase<lngtag_from> lng_suggest_change_content{ ushort(6484) };
inline constexpr phrase<> lng_suggest_change_price_label{ ushort(6485) };
inline constexpr phrase<> lng_suggest_change_time_label{ ushort(6486) };
inline constexpr phrase<> lng_suggest_change_text_label{ ushort(6487) };
inline constexpr phrase<> lng_suggest_menu_edit_message{ ushort(6488) };
inline constexpr phrase<> lng_suggest_menu_edit_price{ ushort(6489) };
inline constexpr phrase<> lng_suggest_menu_edit_time{ ushort(6490) };
inline constexpr phrase<> lng_suggest_decline_title{ ushort(6491) };
inline constexpr phrase<lngtag_from> lng_suggest_decline_text{ ushort(6492) };
inline constexpr phrase<lngtag_channel> lng_suggest_decline_text_to{ ushort(6493) };
inline constexpr phrase<> lng_suggest_decline_reason{ ushort(6494) };
inline constexpr phrase<> lng_suggest_accept_title{ ushort(6495) };
inline constexpr phrase<lngtag_from> lng_suggest_accept_text{ ushort(6496) };
inline constexpr phrase<lngtag_channel> lng_suggest_accept_text_to{ ushort(6497) };
inline constexpr phrase<lngtag_count, lngtag_channel, lngtag_percent, lngtag_date> lng_suggest_accept_receive_stars{ ushort(6498) };
inline constexpr phrase<lngtag_count, lngtag_channel, lngtag_percent, lngtag_date> lng_suggest_accept_receive_ton{ ushort(6504) };
inline constexpr phrase<lngtag_count, lngtag_channel, lngtag_percent> lng_suggest_accept_receive_now_stars{ ushort(6510) };
inline constexpr phrase<lngtag_count, lngtag_channel, lngtag_percent> lng_suggest_accept_receive_now_ton{ ushort(6516) };
inline constexpr phrase<> lng_suggest_accept_receive_if{ ushort(6522) };
inline constexpr phrase<lngtag_count, lngtag_date> lng_suggest_accept_pay_stars{ ushort(6523) };
inline constexpr phrase<lngtag_count, lngtag_date> lng_suggest_accept_pay_ton{ ushort(6529) };
inline constexpr phrase<lngtag_count> lng_suggest_accept_pay_now_stars{ ushort(6535) };
inline constexpr phrase<lngtag_count> lng_suggest_accept_pay_now_ton{ ushort(6541) };
inline constexpr phrase<> lng_suggest_accept_send{ ushort(6547) };
inline constexpr phrase<lngtag_count> lng_suggest_stars_amount{ ushort(6548) };
inline constexpr phrase<lngtag_count> lng_suggest_ton_amount{ ushort(6554) };
inline constexpr phrase<> lng_suggest_warn_title_stars{ ushort(6560) };
inline constexpr phrase<> lng_suggest_warn_title_ton{ ushort(6561) };
inline constexpr phrase<> lng_suggest_warn_text_stars{ ushort(6562) };
inline constexpr phrase<> lng_suggest_warn_text_ton{ ushort(6563) };
inline constexpr phrase<> lng_suggest_warn_delete_anyway{ ushort(6564) };
inline constexpr phrase<lngtag_amount> lng_suggest_low_ton_title{ ushort(6565) };
inline constexpr phrase<> lng_suggest_low_ton_text{ ushort(6566) };
inline constexpr phrase<> lng_suggest_low_ton_fragment{ ushort(6567) };
inline constexpr phrase<> lng_suggest_low_ton_fragment_url{ ushort(6568) };
inline constexpr phrase<> lng_reply_in_another_title{ ushort(6569) };
inline constexpr phrase<> lng_reply_in_another_chat{ ushort(6570) };
inline constexpr phrase<> lng_reply_in_author{ ushort(6571) };
inline constexpr phrase<> lng_reply_in_chats_list{ ushort(6572) };
inline constexpr phrase<> lng_reply_show_in_chat{ ushort(6573) };
inline constexpr phrase<> lng_reply_remove{ ushort(6574) };
inline constexpr phrase<> lng_reply_about_quote{ ushort(6575) };
inline constexpr phrase<> lng_reply_options_header{ ushort(6576) };
inline constexpr phrase<> lng_reply_options_quote{ ushort(6577) };
inline constexpr phrase<> lng_reply_header_short{ ushort(6578) };
inline constexpr phrase<> lng_reply_quote_selected{ ushort(6579) };
inline constexpr phrase<> lng_reply_from_private_chat{ ushort(6580) };
inline constexpr phrase<> lng_reply_quote_long_title{ ushort(6581) };
inline constexpr phrase<> lng_reply_quote_long_text{ ushort(6582) };
inline constexpr phrase<> lng_link_options_header{ ushort(6583) };
inline constexpr phrase<> lng_link_header_short{ ushort(6584) };
inline constexpr phrase<> lng_link_move_up{ ushort(6585) };
inline constexpr phrase<> lng_link_move_down{ ushort(6586) };
inline constexpr phrase<> lng_link_shrink_photo{ ushort(6587) };
inline constexpr phrase<> lng_link_enlarge_photo{ ushort(6588) };
inline constexpr phrase<> lng_link_shrink_video{ ushort(6589) };
inline constexpr phrase<> lng_link_enlarge_video{ ushort(6590) };
inline constexpr phrase<> lng_link_remove{ ushort(6591) };
inline constexpr phrase<> lng_link_about_choose{ ushort(6592) };
inline constexpr phrase<> lng_share_cant{ ushort(6593) };
inline constexpr phrase<> lng_reply_cant{ ushort(6594) };
inline constexpr phrase<> lng_reply_cant_forward{ ushort(6595) };
inline constexpr phrase<> lng_share_title{ ushort(6596) };
inline constexpr phrase<lngtag_time> lng_share_at_time_title{ ushort(6597) };
inline constexpr phrase<> lng_share_copy_link{ ushort(6598) };
inline constexpr phrase<> lng_share_confirm{ ushort(6599) };
inline constexpr phrase<> lng_share_wrong_user{ ushort(6600) };
inline constexpr phrase<> lng_share_game_link_copied{ ushort(6601) };
inline constexpr phrase<> lng_share_done{ ushort(6602) };
inline constexpr phrase<> lng_share_message_to_saved_messages{ ushort(6603) };
inline constexpr phrase<> lng_share_messages_to_saved_messages{ ushort(6604) };
inline constexpr phrase<lngtag_chat> lng_share_message_to_chat{ ushort(6605) };
inline constexpr phrase<lngtag_chat> lng_share_messages_to_chat{ ushort(6606) };
inline constexpr phrase<lngtag_user, lngtag_chat> lng_share_message_to_two_chats{ ushort(6607) };
inline constexpr phrase<lngtag_user, lngtag_chat> lng_share_messages_to_two_chats{ ushort(6608) };
inline constexpr phrase<lngtag_count> lng_share_message_to_many_chats{ ushort(6609) };
inline constexpr phrase<lngtag_count> lng_share_messages_to_many_chats{ ushort(6615) };
inline constexpr phrase<> lng_contact_phone{ ushort(6621) };
inline constexpr phrase<> lng_enter_contact_data{ ushort(6622) };
inline constexpr phrase<> lng_contact_mobile_hidden{ ushort(6623) };
inline constexpr phrase<lngtag_user> lng_contact_phone_after{ ushort(6624) };
inline constexpr phrase<> lng_contact_share_phone{ ushort(6625) };
inline constexpr phrase<lngtag_user> lng_contact_phone_will_be_shared{ ushort(6626) };
inline constexpr phrase<> lng_contact_add_notes{ ushort(6627) };
inline constexpr phrase<> lng_contact_add_notes_about{ ushort(6628) };
inline constexpr phrase<lngtag_count> lng_contact_notes_limit_reached{ ushort(6629) };
inline constexpr phrase<lngtag_user> lng_suggest_photo_for{ ushort(6635) };
inline constexpr phrase<> lng_suggest_birthday{ ushort(6636) };
inline constexpr phrase<lngtag_user> lng_suggest_birthday_box_title{ ushort(6637) };
inline constexpr phrase<> lng_suggest_birthday_box_confirm{ ushort(6638) };
inline constexpr phrase<lngtag_user> lng_set_photo_for_user{ ushort(6639) };
inline constexpr phrase<lngtag_user> lng_contact_photo_replace_info{ ushort(6640) };
inline constexpr phrase<> lng_edit_contact_title{ ushort(6641) };
inline constexpr phrase<> lng_edit_channel_title{ ushort(6642) };
inline constexpr phrase<> lng_edit_bot_title{ ushort(6643) };
inline constexpr phrase<> lng_edit_autotranslate{ ushort(6644) };
inline constexpr phrase<> lng_edit_sign_messages{ ushort(6645) };
inline constexpr phrase<> lng_edit_sign_messages_about{ ushort(6646) };
inline constexpr phrase<> lng_edit_sign_profiles{ ushort(6647) };
inline constexpr phrase<> lng_edit_sign_profiles_about{ ushort(6648) };
inline constexpr phrase<> lng_edit_group{ ushort(6649) };
inline constexpr phrase<> lng_edit_channel_color{ ushort(6650) };
inline constexpr phrase<> lng_edit_channel_level_min{ ushort(6651) };
inline constexpr phrase<> lng_edit_channel_wallpaper{ ushort(6652) };
inline constexpr phrase<> lng_edit_channel_wallpaper_about{ ushort(6653) };
inline constexpr phrase<> lng_edit_channel_wallpaper_group{ ushort(6654) };
inline constexpr phrase<> lng_edit_channel_wallpaper_about_group{ ushort(6655) };
inline constexpr phrase<> lng_edit_channel_status{ ushort(6656) };
inline constexpr phrase<> lng_edit_channel_status_about{ ushort(6657) };
inline constexpr phrase<> lng_edit_channel_status_group{ ushort(6658) };
inline constexpr phrase<> lng_edit_channel_status_about_group{ ushort(6659) };
inline constexpr phrase<> lng_edit_channel_personal_channel{ ushort(6660) };
inline constexpr phrase<> lng_edit_self_title{ ushort(6661) };
inline constexpr phrase<> lng_confirm_contact_data{ ushort(6662) };
inline constexpr phrase<> lng_add_contact{ ushort(6663) };
inline constexpr phrase<> lng_add_contact_button{ ushort(6664) };
inline constexpr phrase<> lng_contacts_header{ ushort(6665) };
inline constexpr phrase<> lng_menu_not_contact{ ushort(6666) };
inline constexpr phrase<> lng_contacts_hidden_stories{ ushort(6667) };
inline constexpr phrase<lngtag_count> lng_contacts_stories_status{ ushort(6668) };
inline constexpr phrase<lngtag_count> lng_contacts_stories_status_new{ ushort(6674) };
inline constexpr phrase<lngtag_name> lng_contact_not_joined{ ushort(6680) };
inline constexpr phrase<> lng_try_other_contact{ ushort(6681) };
inline constexpr phrase<> lng_create_group_link{ ushort(6682) };
inline constexpr phrase<> lng_create_group_invite_link{ ushort(6683) };
inline constexpr phrase<> lng_create_group_description{ ushort(6684) };
inline constexpr phrase<> lng_drag_images_here{ ushort(6685) };
inline constexpr phrase<> lng_drag_photos_here{ ushort(6686) };
inline constexpr phrase<> lng_drag_files_here{ ushort(6687) };
inline constexpr phrase<> lng_drag_to_send_quick{ ushort(6688) };
inline constexpr phrase<> lng_drag_to_send_no_compression{ ushort(6689) };
inline constexpr phrase<> lng_drag_to_send_files{ ushort(6690) };
inline constexpr phrase<> lng_selected_clear{ ushort(6691) };
inline constexpr phrase<> lng_selected_delete{ ushort(6692) };
inline constexpr phrase<> lng_selected_forward{ ushort(6693) };
inline constexpr phrase<> lng_selected_send_now{ ushort(6694) };
inline constexpr phrase<> lng_selected_cancel_sure_this{ ushort(6695) };
inline constexpr phrase<> lng_selected_upload_stop{ ushort(6696) };
inline constexpr phrase<> lng_selected_delete_sure_this{ ushort(6697) };
inline constexpr phrase<lngtag_count> lng_selected_delete_sure{ ushort(6698) };
inline constexpr phrase<> lng_selected_remove_saved_music{ ushort(6704) };
inline constexpr phrase<> lng_saved_music_added{ ushort(6705) };
inline constexpr phrase<> lng_saved_music_removed{ ushort(6706) };
inline constexpr phrase<> lng_delete_photo_sure{ ushort(6707) };
inline constexpr phrase<lngtag_count> lng_delete_for_everyone_hint{ ushort(6708) };
inline constexpr phrase<lngtag_count> lng_delete_for_me_chat_hint{ ushort(6714) };
inline constexpr phrase<lngtag_count> lng_delete_for_me_hint{ ushort(6720) };
inline constexpr phrase<> lng_delete_clear_for_me{ ushort(6726) };
inline constexpr phrase<> lng_edit_auto_delete_settings{ ushort(6727) };
inline constexpr phrase<> lng_enable_auto_delete{ ushort(6728) };
inline constexpr phrase<lngtag_user> lng_selected_unsend_about_user_one{ ushort(6729) };
inline constexpr phrase<lngtag_count, lngtag_user> lng_selected_unsend_about_user{ ushort(6730) };
inline constexpr phrase<> lng_selected_unsend_about_group_one{ ushort(6736) };
inline constexpr phrase<lngtag_count> lng_selected_unsend_about_group{ ushort(6737) };
inline constexpr phrase<> lng_delete_for_everyone_check{ ushort(6743) };
inline constexpr phrase<lngtag_user> lng_delete_for_other_check{ ushort(6744) };
inline constexpr phrase<> lng_delete_for_other_my{ ushort(6745) };
inline constexpr phrase<> lng_box_delete{ ushort(6746) };
inline constexpr phrase<> lng_box_leave{ ushort(6747) };
inline constexpr phrase<> lng_upload_sure_stop{ ushort(6748) };
inline constexpr phrase<> lng_download_sure_stop{ ushort(6749) };
inline constexpr phrase<> lng_upload_show_file{ ushort(6750) };
inline constexpr phrase<lngtag_version> lng_about_version{ ushort(6751) };
inline constexpr phrase<lngtag_api_link> lng_about_text1{ ushort(6752) };
inline constexpr phrase<> lng_about_text1_api{ ushort(6753) };
inline constexpr phrase<lngtag_gpl_link, lngtag_github_link> lng_about_text2{ ushort(6754) };
inline constexpr phrase<lngtag_faq_link> lng_about_text3{ ushort(6755) };
inline constexpr phrase<> lng_about_text3_faq{ ushort(6756) };
inline constexpr phrase<> lng_about_done{ ushort(6757) };
inline constexpr phrase<> lng_search_no_results{ ushort(6758) };
inline constexpr phrase<lngtag_count> lng_search_found_results{ ushort(6759) };
inline constexpr phrase<> lng_search_global_results{ ushort(6765) };
inline constexpr phrase<> lng_search_messages_from{ ushort(6766) };
inline constexpr phrase<lngtag_n, lngtag_amount> lng_search_messages_n_of_amount{ ushort(6767) };
inline constexpr phrase<> lng_search_messages_none{ ushort(6768) };
inline constexpr phrase<> lng_search_filter_all{ ushort(6769) };
inline constexpr phrase<> lng_search_filter_private{ ushort(6770) };
inline constexpr phrase<> lng_search_filter_group{ ushort(6771) };
inline constexpr phrase<> lng_search_filter_channel{ ushort(6772) };
inline constexpr phrase<> lng_search_sponsored_button{ ushort(6773) };
inline constexpr phrase<lngtag_ready, lngtag_total, lngtag_mb> lng_media_save_progress{ ushort(6774) };
inline constexpr phrase<> lng_mediaview_save_as{ ushort(6775) };
inline constexpr phrase<> lng_mediaview_copy{ ushort(6776) };
inline constexpr phrase<> lng_mediaview_copy_frame{ ushort(6777) };
inline constexpr phrase<> lng_mediaview_forward{ ushort(6778) };
inline constexpr phrase<lngtag_time> lng_mediaview_share_at_time{ ushort(6779) };
inline constexpr phrase<> lng_mediaview_delete{ ushort(6780) };
inline constexpr phrase<> lng_mediaview_save_to_profile{ ushort(6781) };
inline constexpr phrase<> lng_mediaview_pin_story_done{ ushort(6782) };
inline constexpr phrase<> lng_mediaview_pin_story_about{ ushort(6783) };
inline constexpr phrase<lngtag_count> lng_mediaview_pin_stories_done{ ushort(6784) };
inline constexpr phrase<lngtag_count> lng_mediaview_pin_stories_about{ ushort(6790) };
inline constexpr phrase<> lng_mediaview_unpin_story_done{ ushort(6796) };
inline constexpr phrase<lngtag_count> lng_mediaview_unpin_stories_done{ ushort(6797) };
inline constexpr phrase<lngtag_count> lng_mediaview_pin_limit{ ushort(6803) };
inline constexpr phrase<> lng_mediaview_archive_story{ ushort(6809) };
inline constexpr phrase<> lng_mediaview_photos_all{ ushort(6810) };
inline constexpr phrase<> lng_mediaview_files_all{ ushort(6811) };
inline constexpr phrase<> lng_mediaview_single_photo{ ushort(6812) };
inline constexpr phrase<> lng_mediaview_group_photo{ ushort(6813) };
inline constexpr phrase<> lng_mediaview_channel_photo{ ushort(6814) };
inline constexpr phrase<> lng_mediaview_profile_photo{ ushort(6815) };
inline constexpr phrase<> lng_mediaview_profile_public_photo{ ushort(6816) };
inline constexpr phrase<> lng_mediaview_profile_photo_by_you{ ushort(6817) };
inline constexpr phrase<lngtag_file, lngtag_n, lngtag_amount> lng_mediaview_file_n_of_amount{ ushort(6818) };
inline constexpr phrase<lngtag_n, lngtag_amount> lng_mediaview_n_of_amount{ ushort(6819) };
inline constexpr phrase<> lng_mediaview_doc_image{ ushort(6820) };
inline constexpr phrase<lngtag_time> lng_mediaview_today{ ushort(6821) };
inline constexpr phrase<lngtag_time> lng_mediaview_yesterday{ ushort(6822) };
inline constexpr phrase<> lng_mediaview_just_now{ ushort(6823) };
inline constexpr phrase<lngtag_count> lng_mediaview_minutes_ago{ ushort(6824) };
inline constexpr phrase<lngtag_count> lng_mediaview_hours_ago{ ushort(6830) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_mediaview_date_time{ ushort(6836) };
inline constexpr phrase<> lng_mediaview_set_userpic{ ushort(6837) };
inline constexpr phrase<> lng_mediaview_report_profile_photo{ ushort(6838) };
inline constexpr phrase<> lng_mediaview_title{ ushort(6839) };
inline constexpr phrase<lngtag_downloads> lng_mediaview_saved_to{ ushort(6840) };
inline constexpr phrase<lngtag_downloads> lng_mediaview_saved_images_to{ ushort(6841) };
inline constexpr phrase<lngtag_downloads> lng_mediaview_video_saved_to{ ushort(6842) };
inline constexpr phrase<> lng_mediaview_downloads{ ushort(6843) };
inline constexpr phrase<lngtag_speed> lng_mediaview_playback_speed{ ushort(6844) };
inline constexpr phrase<> lng_mediaview_rotate_video{ ushort(6845) };
inline constexpr phrase<> lng_mediaview_quality_auto{ ushort(6846) };
inline constexpr phrase<> lng_theme_preview_title{ ushort(6847) };
inline constexpr phrase<> lng_theme_preview_generating{ ushort(6848) };
inline constexpr phrase<> lng_theme_preview_invalid{ ushort(6849) };
inline constexpr phrase<> lng_theme_preview_apply{ ushort(6850) };
inline constexpr phrase<lngtag_count> lng_theme_preview_users{ ushort(6851) };
inline constexpr phrase<lngtag_version, lngtag_changes, lngtag_link> lng_new_version_wrap{ ushort(6857) };
inline constexpr phrase<> lng_new_version_minor{ ushort(6858) };
inline constexpr phrase<> lng_menu_insert_unicode{ ushort(6859) };
inline constexpr phrase<> lng_menu_formatting{ ushort(6860) };
inline constexpr phrase<> lng_menu_formatting_bold{ ushort(6861) };
inline constexpr phrase<> lng_menu_formatting_italic{ ushort(6862) };
inline constexpr phrase<> lng_menu_formatting_underline{ ushort(6863) };
inline constexpr phrase<> lng_menu_formatting_strike_out{ ushort(6864) };
inline constexpr phrase<> lng_menu_formatting_blockquote{ ushort(6865) };
inline constexpr phrase<> lng_menu_formatting_monospace{ ushort(6866) };
inline constexpr phrase<> lng_menu_formatting_spoiler{ ushort(6867) };
inline constexpr phrase<> lng_menu_formatting_link_create{ ushort(6868) };
inline constexpr phrase<> lng_menu_formatting_link_edit{ ushort(6869) };
inline constexpr phrase<> lng_menu_formatting_clear{ ushort(6870) };
inline constexpr phrase<> lng_formatting_link_create_title{ ushort(6871) };
inline constexpr phrase<> lng_formatting_link_edit_title{ ushort(6872) };
inline constexpr phrase<> lng_formatting_link_text{ ushort(6873) };
inline constexpr phrase<> lng_formatting_link_url{ ushort(6874) };
inline constexpr phrase<> lng_formatting_link_create{ ushort(6875) };
inline constexpr phrase<> lng_formatting_code_title{ ushort(6876) };
inline constexpr phrase<> lng_formatting_code_language{ ushort(6877) };
inline constexpr phrase<> lng_formatting_code_auto{ ushort(6878) };
inline constexpr phrase<> lng_text_copied{ ushort(6879) };
inline constexpr phrase<> lng_code_copied{ ushort(6880) };
inline constexpr phrase<> lng_spellchecker_submenu{ ushort(6881) };
inline constexpr phrase<> lng_spellchecker_add{ ushort(6882) };
inline constexpr phrase<> lng_spellchecker_remove{ ushort(6883) };
inline constexpr phrase<> lng_spellchecker_ignore{ ushort(6884) };
inline constexpr phrase<lngtag_first_name, lngtag_last_name> lng_full_name{ ushort(6885) };
inline constexpr phrase<> lng_confirm_phone_link_invalid{ ushort(6886) };
inline constexpr phrase<> lng_confirm_phone_title{ ushort(6887) };
inline constexpr phrase<lngtag_phone> lng_confirm_phone_about{ ushort(6888) };
inline constexpr phrase<lngtag_phone> lng_confirm_phone_success{ ushort(6889) };
inline constexpr phrase<> lng_confirm_phone_send{ ushort(6890) };
inline constexpr phrase<> lng_confirm_phone_enter_code{ ushort(6891) };
inline constexpr phrase<> lng_theme_editor_no_keys{ ushort(6892) };
inline constexpr phrase<> lng_theme_editor_cant_change_theme{ ushort(6893) };
inline constexpr phrase<> lng_theme_editor_new_keys{ ushort(6894) };
inline constexpr phrase<> lng_theme_editor_background_image{ ushort(6895) };
inline constexpr phrase<lngtag_size> lng_theme_editor_saved_to_jpg{ ushort(6896) };
inline constexpr phrase<lngtag_size> lng_theme_editor_read_from_jpg{ ushort(6897) };
inline constexpr phrase<lngtag_size> lng_theme_editor_read_from_png{ ushort(6898) };
inline constexpr phrase<> lng_theme_editor_choose_image{ ushort(6899) };
inline constexpr phrase<> lng_theme_editor_choose_name{ ushort(6900) };
inline constexpr phrase<> lng_theme_editor_error{ ushort(6901) };
inline constexpr phrase<> lng_theme_editor_sure_close{ ushort(6902) };
inline constexpr phrase<> lng_theme_editor_need_auth{ ushort(6903) };
inline constexpr phrase<> lng_theme_editor_need_unlock{ ushort(6904) };
inline constexpr phrase<> lng_theme_editor_done{ ushort(6905) };
inline constexpr phrase<> lng_theme_editor_title{ ushort(6906) };
inline constexpr phrase<> lng_theme_editor_save_button{ ushort(6907) };
inline constexpr phrase<> lng_theme_editor_create_title{ ushort(6908) };
inline constexpr phrase<> lng_theme_editor_create{ ushort(6909) };
inline constexpr phrase<> lng_theme_editor_name{ ushort(6910) };
inline constexpr phrase<> lng_theme_editor_create_description{ ushort(6911) };
inline constexpr phrase<> lng_theme_editor_attach_description{ ushort(6912) };
inline constexpr phrase<> lng_theme_editor_import_existing{ ushort(6913) };
inline constexpr phrase<> lng_theme_editor_save_title{ ushort(6914) };
inline constexpr phrase<> lng_theme_editor_link_about{ ushort(6915) };
inline constexpr phrase<> lng_theme_editor_menu_export{ ushort(6916) };
inline constexpr phrase<> lng_theme_editor_menu_import{ ushort(6917) };
inline constexpr phrase<> lng_theme_editor_menu_show{ ushort(6918) };
inline constexpr phrase<> lng_payments_webview_no_use{ ushort(6919) };
inline constexpr phrase<lngtag_link> lng_payments_webview_install_edge{ ushort(6920) };
inline constexpr phrase<> lng_payments_webview_install_webkit{ ushort(6921) };
inline constexpr phrase<> lng_payments_webview_update_windows{ ushort(6922) };
inline constexpr phrase<> lng_payments_sure_close{ ushort(6923) };
inline constexpr phrase<> lng_payments_receipt_label{ ushort(6924) };
inline constexpr phrase<> lng_payments_receipt_label_test{ ushort(6925) };
inline constexpr phrase<> lng_payments_invoice_label{ ushort(6926) };
inline constexpr phrase<> lng_payments_invoice_label_test{ ushort(6927) };
inline constexpr phrase<> lng_payments_receipt_button{ ushort(6928) };
inline constexpr phrase<lngtag_amount, lngtag_title> lng_payments_success{ ushort(6929) };
inline constexpr phrase<> lng_payments_checkout_title{ ushort(6930) };
inline constexpr phrase<> lng_payments_receipt_title{ ushort(6931) };
inline constexpr phrase<> lng_payments_total_label{ ushort(6932) };
inline constexpr phrase<> lng_payments_date_label{ ushort(6933) };
inline constexpr phrase<lngtag_amount> lng_payments_pay_amount{ ushort(6934) };
inline constexpr phrase<> lng_payments_payment_method{ ushort(6935) };
inline constexpr phrase<> lng_payments_new_card{ ushort(6936) };
inline constexpr phrase<> lng_payments_shipping_address{ ushort(6937) };
inline constexpr phrase<> lng_payments_address_street1{ ushort(6938) };
inline constexpr phrase<> lng_payments_address_street2{ ushort(6939) };
inline constexpr phrase<> lng_payments_address_city{ ushort(6940) };
inline constexpr phrase<> lng_payments_address_state{ ushort(6941) };
inline constexpr phrase<> lng_payments_address_country{ ushort(6942) };
inline constexpr phrase<> lng_payments_address_postcode{ ushort(6943) };
inline constexpr phrase<> lng_payments_shipping_method{ ushort(6944) };
inline constexpr phrase<> lng_payments_info_name{ ushort(6945) };
inline constexpr phrase<> lng_payments_info_email{ ushort(6946) };
inline constexpr phrase<> lng_payments_info_phone{ ushort(6947) };
inline constexpr phrase<lngtag_provider> lng_payments_to_provider_phone_email{ ushort(6948) };
inline constexpr phrase<lngtag_provider> lng_payments_to_provider_email{ ushort(6949) };
inline constexpr phrase<lngtag_provider> lng_payments_to_provider_phone{ ushort(6950) };
inline constexpr phrase<lngtag_provider> lng_payments_processed_by{ ushort(6951) };
inline constexpr phrase<> lng_payments_warning_title{ ushort(6952) };
inline constexpr phrase<lngtag_bot1, lngtag_provider, lngtag_bot2, lngtag_bot3> lng_payments_warning_body{ ushort(6953) };
inline constexpr phrase<> lng_payments_shipping_address_title{ ushort(6954) };
inline constexpr phrase<> lng_payments_card_title{ ushort(6955) };
inline constexpr phrase<> lng_payments_card_number{ ushort(6956) };
inline constexpr phrase<> lng_payments_card_cvc{ ushort(6957) };
inline constexpr phrase<> lng_payments_card_expire_date{ ushort(6958) };
inline constexpr phrase<> lng_payments_card_holder{ ushort(6959) };
inline constexpr phrase<> lng_payments_billing_address{ ushort(6960) };
inline constexpr phrase<> lng_payments_billing_country{ ushort(6961) };
inline constexpr phrase<> lng_payments_billing_zip_code{ ushort(6962) };
inline constexpr phrase<> lng_payments_save_information{ ushort(6963) };
inline constexpr phrase<> lng_payments_need_password{ ushort(6964) };
inline constexpr phrase<> lng_payments_password_title{ ushort(6965) };
inline constexpr phrase<lngtag_card> lng_payments_password_description{ ushort(6966) };
inline constexpr phrase<> lng_payments_password_submit{ ushort(6967) };
inline constexpr phrase<> lng_payments_tips_label{ ushort(6968) };
inline constexpr phrase<> lng_payments_tips_box_title{ ushort(6969) };
inline constexpr phrase<lngtag_amount> lng_payments_tips_max{ ushort(6970) };
inline constexpr phrase<> lng_payments_shipping_not_available{ ushort(6971) };
inline constexpr phrase<> lng_payments_card_declined{ ushort(6972) };
inline constexpr phrase<> lng_payments_payment_failed{ ushort(6973) };
inline constexpr phrase<> lng_payments_precheckout_failed{ ushort(6974) };
inline constexpr phrase<> lng_payments_precheckout_timeout{ ushort(6975) };
inline constexpr phrase<> lng_payments_precheckout_stars_failed{ ushort(6976) };
inline constexpr phrase<> lng_payments_precheckout_stars_timeout{ ushort(6977) };
inline constexpr phrase<> lng_payments_already_paid{ ushort(6978) };
inline constexpr phrase<> lng_payments_terms_title{ ushort(6979) };
inline constexpr phrase<lngtag_bot> lng_payments_terms_text{ ushort(6980) };
inline constexpr phrase<lngtag_bot> lng_payments_terms_text_once{ ushort(6981) };
inline constexpr phrase<lngtag_link> lng_payments_terms_agree{ ushort(6982) };
inline constexpr phrase<> lng_payments_terms_link{ ushort(6983) };
inline constexpr phrase<> lng_payments_terms_accept{ ushort(6984) };
inline constexpr phrase<> lng_call_status_incoming{ ushort(6985) };
inline constexpr phrase<> lng_call_status_connecting{ ushort(6986) };
inline constexpr phrase<> lng_call_status_exchanging{ ushort(6987) };
inline constexpr phrase<> lng_call_status_waiting{ ushort(6988) };
inline constexpr phrase<> lng_call_status_requesting{ ushort(6989) };
inline constexpr phrase<> lng_call_status_hanging{ ushort(6990) };
inline constexpr phrase<> lng_call_status_ended{ ushort(6991) };
inline constexpr phrase<> lng_call_status_failed{ ushort(6992) };
inline constexpr phrase<> lng_call_status_ringing{ ushort(6993) };
inline constexpr phrase<> lng_call_status_busy{ ushort(6994) };
inline constexpr phrase<> lng_call_status_group_invite{ ushort(6995) };
inline constexpr phrase<> lng_call_status_sure{ ushort(6996) };
inline constexpr phrase<lngtag_user> lng_call_fingerprint_tooltip{ ushort(6997) };
inline constexpr phrase<lngtag_user> lng_call_error_not_available{ ushort(6998) };
inline constexpr phrase<lngtag_user> lng_call_error_outdated{ ushort(6999) };
inline constexpr phrase<> lng_call_error_no_camera{ ushort(7000) };
inline constexpr phrase<> lng_call_error_camera_not_started{ ushort(7001) };
inline constexpr phrase<lngtag_user> lng_call_error_camera_outdated{ ushort(7002) };
inline constexpr phrase<> lng_call_error_audio_io{ ushort(7003) };
inline constexpr phrase<> lng_call_error_add_not_started{ ushort(7004) };
inline constexpr phrase<> lng_call_bar_hangup{ ushort(7005) };
inline constexpr phrase<> lng_call_leave_to_other_sure{ ushort(7006) };
inline constexpr phrase<> lng_call_leave_to_other_sure_channel{ ushort(7007) };
inline constexpr phrase<> lng_call_box_title{ ushort(7008) };
inline constexpr phrase<> lng_call_box_about{ ushort(7009) };
inline constexpr phrase<lngtag_time> lng_call_box_status_today{ ushort(7010) };
inline constexpr phrase<lngtag_time> lng_call_box_status_yesterday{ ushort(7011) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_call_box_status_date{ ushort(7012) };
inline constexpr phrase<lngtag_amount, lngtag_status> lng_call_box_status_group{ ushort(7013) };
inline constexpr phrase<> lng_call_box_clear_all{ ushort(7014) };
inline constexpr phrase<> lng_call_box_clear_sure{ ushort(7015) };
inline constexpr phrase<> lng_call_box_clear_button{ ushort(7016) };
inline constexpr phrase<> lng_call_box_groupcalls_subtitle{ ushort(7017) };
inline constexpr phrase<> lng_call_outgoing{ ushort(7018) };
inline constexpr phrase<> lng_call_video_outgoing{ ushort(7019) };
inline constexpr phrase<> lng_call_group_outgoing{ ushort(7020) };
inline constexpr phrase<> lng_call_incoming{ ushort(7021) };
inline constexpr phrase<> lng_call_video_incoming{ ushort(7022) };
inline constexpr phrase<> lng_call_group_incoming{ ushort(7023) };
inline constexpr phrase<> lng_call_missed{ ushort(7024) };
inline constexpr phrase<> lng_call_video_missed{ ushort(7025) };
inline constexpr phrase<> lng_call_group_missed{ ushort(7026) };
inline constexpr phrase<> lng_call_cancelled{ ushort(7027) };
inline constexpr phrase<> lng_call_video_cancelled{ ushort(7028) };
inline constexpr phrase<> lng_call_declined{ ushort(7029) };
inline constexpr phrase<> lng_call_video_declined{ ushort(7030) };
inline constexpr phrase<> lng_call_group_declined{ ushort(7031) };
inline constexpr phrase<lngtag_time, lngtag_duration> lng_call_duration_info{ ushort(7032) };
inline constexpr phrase<lngtag_type, lngtag_duration> lng_call_type_and_duration{ ushort(7033) };
inline constexpr phrase<> lng_call_invitation{ ushort(7034) };
inline constexpr phrase<> lng_call_ongoing{ ushort(7035) };
inline constexpr phrase<> lng_call_rate_label{ ushort(7036) };
inline constexpr phrase<> lng_call_rate_comment{ ushort(7037) };
inline constexpr phrase<> lng_call_start{ ushort(7038) };
inline constexpr phrase<> lng_call_start_video{ ushort(7039) };
inline constexpr phrase<> lng_call_stop_video{ ushort(7040) };
inline constexpr phrase<> lng_call_screencast{ ushort(7041) };
inline constexpr phrase<> lng_call_add_people{ ushort(7042) };
inline constexpr phrase<> lng_call_end_call{ ushort(7043) };
inline constexpr phrase<> lng_call_mute_audio{ ushort(7044) };
inline constexpr phrase<> lng_call_unmute_audio{ ushort(7045) };
inline constexpr phrase<> lng_call_accept{ ushort(7046) };
inline constexpr phrase<> lng_call_decline{ ushort(7047) };
inline constexpr phrase<> lng_call_redial{ ushort(7048) };
inline constexpr phrase<> lng_call_cancel{ ushort(7049) };
inline constexpr phrase<lngtag_user> lng_call_microphone_off{ ushort(7050) };
inline constexpr phrase<lngtag_user> lng_call_battery_level_low{ ushort(7051) };
inline constexpr phrase<> lng_group_call_title{ ushort(7052) };
inline constexpr phrase<> lng_group_call_title_channel{ ushort(7053) };
inline constexpr phrase<> lng_group_call_active{ ushort(7054) };
inline constexpr phrase<> lng_group_call_inactive{ ushort(7055) };
inline constexpr phrase<> lng_group_call_raised_hand_status{ ushort(7056) };
inline constexpr phrase<> lng_group_call_settings{ ushort(7057) };
inline constexpr phrase<> lng_group_call_video{ ushort(7058) };
inline constexpr phrase<> lng_group_call_message{ ushort(7059) };
inline constexpr phrase<> lng_group_call_screen_share_start{ ushort(7060) };
inline constexpr phrase<> lng_group_call_screen_share_stop{ ushort(7061) };
inline constexpr phrase<lngtag_index> lng_group_call_screen_title{ ushort(7062) };
inline constexpr phrase<> lng_group_call_screen_share_audio{ ushort(7063) };
inline constexpr phrase<> lng_group_call_unmute{ ushort(7064) };
inline constexpr phrase<> lng_group_call_unmute_sub{ ushort(7065) };
inline constexpr phrase<> lng_group_call_you_are_live{ ushort(7066) };
inline constexpr phrase<> lng_group_call_force_muted{ ushort(7067) };
inline constexpr phrase<> lng_group_call_force_muted_sub{ ushort(7068) };
inline constexpr phrase<> lng_group_call_raised_hand{ ushort(7069) };
inline constexpr phrase<> lng_group_call_connecting{ ushort(7070) };
inline constexpr phrase<> lng_group_call_leave{ ushort(7071) };
inline constexpr phrase<> lng_group_call_leave_title{ ushort(7072) };
inline constexpr phrase<> lng_group_call_leave_title_call{ ushort(7073) };
inline constexpr phrase<> lng_group_call_leave_title_channel{ ushort(7074) };
inline constexpr phrase<> lng_group_call_leave_sure{ ushort(7075) };
inline constexpr phrase<> lng_group_call_leave_sure_call{ ushort(7076) };
inline constexpr phrase<> lng_group_call_leave_sure_channel{ ushort(7077) };
inline constexpr phrase<> lng_group_call_close{ ushort(7078) };
inline constexpr phrase<> lng_group_call_close_sure{ ushort(7079) };
inline constexpr phrase<> lng_group_call_close_sure_channel{ ushort(7080) };
inline constexpr phrase<> lng_group_call_also_cancel{ ushort(7081) };
inline constexpr phrase<> lng_group_call_also_cancel_channel{ ushort(7082) };
inline constexpr phrase<> lng_group_call_leave_to_other_sure{ ushort(7083) };
inline constexpr phrase<> lng_group_call_leave_to_other_sure_channel{ ushort(7084) };
inline constexpr phrase<> lng_group_call_leave_channel_to_other_sure{ ushort(7085) };
inline constexpr phrase<> lng_group_call_leave_channel_to_other_sure_channel{ ushort(7086) };
inline constexpr phrase<> lng_group_call_create_sure{ ushort(7087) };
inline constexpr phrase<> lng_group_call_create_sure_channel{ ushort(7088) };
inline constexpr phrase<> lng_group_call_join_sure_personal{ ushort(7089) };
inline constexpr phrase<> lng_group_call_muted_no_camera{ ushort(7090) };
inline constexpr phrase<> lng_group_call_muted_no_screen{ ushort(7091) };
inline constexpr phrase<> lng_group_call_chat_no_camera{ ushort(7092) };
inline constexpr phrase<> lng_group_call_chat_no_screen{ ushort(7093) };
inline constexpr phrase<> lng_group_call_failed_screen{ ushort(7094) };
inline constexpr phrase<> lng_group_call_failed_camera{ ushort(7095) };
inline constexpr phrase<> lng_group_call_tooltip_screen{ ushort(7096) };
inline constexpr phrase<> lng_group_call_tooltip_camera{ ushort(7097) };
inline constexpr phrase<> lng_group_call_tooltip_microphone{ ushort(7098) };
inline constexpr phrase<> lng_group_call_tooltip_camera_off{ ushort(7099) };
inline constexpr phrase<> lng_group_call_tooltip_force_muted{ ushort(7100) };
inline constexpr phrase<> lng_group_call_tooltip_raised_hand{ ushort(7101) };
inline constexpr phrase<> lng_group_call_also_end{ ushort(7102) };
inline constexpr phrase<> lng_group_call_also_end_channel{ ushort(7103) };
inline constexpr phrase<> lng_group_call_settings_title{ ushort(7104) };
inline constexpr phrase<> lng_group_call_invite{ ushort(7105) };
inline constexpr phrase<> lng_group_call_invite_conf{ ushort(7106) };
inline constexpr phrase<> lng_group_call_invited_status{ ushort(7107) };
inline constexpr phrase<> lng_group_call_calling_status{ ushort(7108) };
inline constexpr phrase<> lng_group_call_blockchain_only_status{ ushort(7109) };
inline constexpr phrase<> lng_group_call_muted_by_me_status{ ushort(7110) };
inline constexpr phrase<> lng_group_call_invite_title{ ushort(7111) };
inline constexpr phrase<> lng_group_call_invite_button{ ushort(7112) };
inline constexpr phrase<> lng_group_call_confcall_add{ ushort(7113) };
inline constexpr phrase<lngtag_user, lngtag_group> lng_group_call_add_to_group_one{ ushort(7114) };
inline constexpr phrase<lngtag_group> lng_group_call_add_to_group_some{ ushort(7115) };
inline constexpr phrase<lngtag_group> lng_group_call_add_to_group_all{ ushort(7116) };
inline constexpr phrase<> lng_group_call_invite_members{ ushort(7117) };
inline constexpr phrase<> lng_group_call_invite_search_results{ ushort(7118) };
inline constexpr phrase<> lng_group_call_invite_limit{ ushort(7119) };
inline constexpr phrase<> lng_group_call_new_muted{ ushort(7120) };
inline constexpr phrase<> lng_group_call_enable_messages{ ushort(7121) };
inline constexpr phrase<> lng_group_call_speakers{ ushort(7122) };
inline constexpr phrase<> lng_group_call_microphone{ ushort(7123) };
inline constexpr phrase<> lng_group_call_push_to_talk{ ushort(7124) };
inline constexpr phrase<> lng_group_call_ptt_shortcut{ ushort(7125) };
inline constexpr phrase<> lng_group_call_ptt_recording{ ushort(7126) };
inline constexpr phrase<lngtag_amount> lng_group_call_ptt_delay_ms{ ushort(7127) };
inline constexpr phrase<lngtag_amount> lng_group_call_ptt_delay_s{ ushort(7128) };
inline constexpr phrase<lngtag_delay> lng_group_call_ptt_delay{ ushort(7129) };
inline constexpr phrase<> lng_group_call_share{ ushort(7130) };
inline constexpr phrase<> lng_group_call_noise_suppression{ ushort(7131) };
inline constexpr phrase<> lng_group_call_video_paused{ ushort(7132) };
inline constexpr phrase<> lng_group_call_share_speaker{ ushort(7133) };
inline constexpr phrase<> lng_group_call_copy_speaker_link{ ushort(7134) };
inline constexpr phrase<> lng_group_call_copy_listener_link{ ushort(7135) };
inline constexpr phrase<> lng_group_call_end{ ushort(7136) };
inline constexpr phrase<> lng_group_call_end_channel{ ushort(7137) };
inline constexpr phrase<> lng_group_call_cancel{ ushort(7138) };
inline constexpr phrase<> lng_group_call_cancel_channel{ ushort(7139) };
inline constexpr phrase<> lng_group_call_join{ ushort(7140) };
inline constexpr phrase<lngtag_chat> lng_group_call_join_confirm{ ushort(7141) };
inline constexpr phrase<lngtag_chat> lng_group_call_join_confirm_channel{ ushort(7142) };
inline constexpr phrase<lngtag_user> lng_group_call_invite_done_user{ ushort(7143) };
inline constexpr phrase<lngtag_count> lng_group_call_invite_done_many{ ushort(7144) };
inline constexpr phrase<> lng_group_call_no_members{ ushort(7150) };
inline constexpr phrase<lngtag_count> lng_group_call_members{ ushort(7151) };
inline constexpr phrase<> lng_group_call_context_mute{ ushort(7157) };
inline constexpr phrase<> lng_group_call_context_unmute{ ushort(7158) };
inline constexpr phrase<> lng_group_call_context_remove_hand{ ushort(7159) };
inline constexpr phrase<> lng_group_call_context_mute_for_me{ ushort(7160) };
inline constexpr phrase<> lng_group_call_context_unmute_for_me{ ushort(7161) };
inline constexpr phrase<> lng_group_call_context_pin_camera{ ushort(7162) };
inline constexpr phrase<> lng_group_call_context_unpin_camera{ ushort(7163) };
inline constexpr phrase<> lng_group_call_context_pin_screen{ ushort(7164) };
inline constexpr phrase<> lng_group_call_context_unpin_screen{ ushort(7165) };
inline constexpr phrase<> lng_group_call_context_remove{ ushort(7166) };
inline constexpr phrase<> lng_group_call_context_cancel_invite{ ushort(7167) };
inline constexpr phrase<> lng_group_call_context_stop_ringing{ ushort(7168) };
inline constexpr phrase<> lng_group_call_context_ban_from_call{ ushort(7169) };
inline constexpr phrase<lngtag_channel> lng_group_call_remove_channel{ ushort(7170) };
inline constexpr phrase<lngtag_channel> lng_group_call_remove_channel_from_channel{ ushort(7171) };
inline constexpr phrase<> lng_group_call_mac_access{ ushort(7172) };
inline constexpr phrase<> lng_group_call_mac_input{ ushort(7173) };
inline constexpr phrase<> lng_group_call_mac_accessibility{ ushort(7174) };
inline constexpr phrase<> lng_group_call_mac_screencast_access{ ushort(7175) };
inline constexpr phrase<> lng_group_call_mac_recording{ ushort(7176) };
inline constexpr phrase<> lng_group_call_mac_settings{ ushort(7177) };
inline constexpr phrase<> lng_group_call_start_as_header{ ushort(7178) };
inline constexpr phrase<> lng_group_call_start_as_header_channel{ ushort(7179) };
inline constexpr phrase<> lng_group_call_join_as_header{ ushort(7180) };
inline constexpr phrase<> lng_group_call_join_as_header_channel{ ushort(7181) };
inline constexpr phrase<> lng_group_call_display_as_header{ ushort(7182) };
inline constexpr phrase<> lng_group_call_join_as_about{ ushort(7183) };
inline constexpr phrase<lngtag_link> lng_group_call_or_schedule{ ushort(7184) };
inline constexpr phrase<> lng_group_call_schedule{ ushort(7185) };
inline constexpr phrase<> lng_group_call_schedule_channel{ ushort(7186) };
inline constexpr phrase<> lng_group_call_schedule_title{ ushort(7187) };
inline constexpr phrase<> lng_group_call_schedule_title_channel{ ushort(7188) };
inline constexpr phrase<lngtag_duration> lng_group_call_schedule_notified_group{ ushort(7189) };
inline constexpr phrase<lngtag_duration> lng_group_call_schedule_notified_channel{ ushort(7190) };
inline constexpr phrase<> lng_group_call_scheduled_status{ ushort(7191) };
inline constexpr phrase<> lng_group_call_scheduled_title{ ushort(7192) };
inline constexpr phrase<> lng_group_call_scheduled_title_channel{ ushort(7193) };
inline constexpr phrase<lngtag_when> lng_group_call_starts_short{ ushort(7194) };
inline constexpr phrase<lngtag_when> lng_group_call_starts{ ushort(7195) };
inline constexpr phrase<lngtag_when> lng_group_call_starts_channel{ ushort(7196) };
inline constexpr phrase<lngtag_time> lng_group_call_starts_today{ ushort(7197) };
inline constexpr phrase<lngtag_time> lng_group_call_starts_tomorrow{ ushort(7198) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_group_call_starts_date{ ushort(7199) };
inline constexpr phrase<> lng_group_call_starts_in{ ushort(7200) };
inline constexpr phrase<> lng_group_call_late_by{ ushort(7201) };
inline constexpr phrase<lngtag_time> lng_group_call_starts_short_today{ ushort(7202) };
inline constexpr phrase<lngtag_time> lng_group_call_starts_short_tomorrow{ ushort(7203) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_group_call_starts_short_date{ ushort(7204) };
inline constexpr phrase<> lng_group_call_start_now{ ushort(7205) };
inline constexpr phrase<> lng_group_call_start_now_sure{ ushort(7206) };
inline constexpr phrase<> lng_group_call_start_now_sure_channel{ ushort(7207) };
inline constexpr phrase<> lng_group_call_set_reminder{ ushort(7208) };
inline constexpr phrase<> lng_group_call_cancel_reminder{ ushort(7209) };
inline constexpr phrase<> lng_group_call_join_as_personal{ ushort(7210) };
inline constexpr phrase<> lng_group_call_edit_title{ ushort(7211) };
inline constexpr phrase<> lng_group_call_edit_title_channel{ ushort(7212) };
inline constexpr phrase<> lng_group_call_recording_start{ ushort(7213) };
inline constexpr phrase<> lng_group_call_recording_stop{ ushort(7214) };
inline constexpr phrase<> lng_group_call_recording_started{ ushort(7215) };
inline constexpr phrase<> lng_group_call_recording_started_video{ ushort(7216) };
inline constexpr phrase<> lng_group_call_recording_started_channel{ ushort(7217) };
inline constexpr phrase<> lng_group_call_recording_stopped{ ushort(7218) };
inline constexpr phrase<> lng_group_call_recording_stopped_channel{ ushort(7219) };
inline constexpr phrase<> lng_group_call_recording_saved{ ushort(7220) };
inline constexpr phrase<> lng_group_call_recording_saved_video{ ushort(7221) };
inline constexpr phrase<> lng_group_call_pinned_camera_me{ ushort(7222) };
inline constexpr phrase<> lng_group_call_pinned_screen_me{ ushort(7223) };
inline constexpr phrase<lngtag_user> lng_group_call_pinned_camera{ ushort(7224) };
inline constexpr phrase<lngtag_user> lng_group_call_pinned_screen{ ushort(7225) };
inline constexpr phrase<> lng_group_call_unpinned_camera_me{ ushort(7226) };
inline constexpr phrase<> lng_group_call_unpinned_screen_me{ ushort(7227) };
inline constexpr phrase<lngtag_user> lng_group_call_unpinned_camera{ ushort(7228) };
inline constexpr phrase<lngtag_user> lng_group_call_unpinned_screen{ ushort(7229) };
inline constexpr phrase<lngtag_user> lng_group_call_sure_screencast{ ushort(7230) };
inline constexpr phrase<> lng_group_call_pinned_on_top{ ushort(7231) };
inline constexpr phrase<> lng_group_call_unpinned_on_top{ ushort(7232) };
inline constexpr phrase<> lng_group_call_recording_start_sure{ ushort(7233) };
inline constexpr phrase<> lng_group_call_recording_stop_sure{ ushort(7234) };
inline constexpr phrase<> lng_group_call_recording_start_field{ ushort(7235) };
inline constexpr phrase<> lng_group_call_recording_start_button{ ushort(7236) };
inline constexpr phrase<> lng_group_call_recording_start_title{ ushort(7237) };
inline constexpr phrase<> lng_group_call_recording_start_checkbox{ ushort(7238) };
inline constexpr phrase<> lng_group_call_recording_start_audio_subtitle{ ushort(7239) };
inline constexpr phrase<> lng_group_call_recording_start_video_subtitle{ ushort(7240) };
inline constexpr phrase<> lng_group_call_is_recorded{ ushort(7241) };
inline constexpr phrase<> lng_group_call_is_recorded_video{ ushort(7242) };
inline constexpr phrase<> lng_group_call_is_recorded_channel{ ushort(7243) };
inline constexpr phrase<> lng_group_call_can_speak_here{ ushort(7244) };
inline constexpr phrase<lngtag_chat> lng_group_call_can_speak{ ushort(7245) };
inline constexpr phrase<lngtag_title> lng_group_call_title_changed{ ushort(7246) };
inline constexpr phrase<lngtag_title> lng_group_call_title_changed_channel{ ushort(7247) };
inline constexpr phrase<lngtag_name> lng_group_call_join_as_changed{ ushort(7248) };
inline constexpr phrase<lngtag_name> lng_group_call_join_as_changed_channel{ ushort(7249) };
inline constexpr phrase<> lng_group_call_no_stream_admin{ ushort(7250) };
inline constexpr phrase<lngtag_group> lng_group_call_no_stream{ ushort(7251) };
inline constexpr phrase<> lng_menu_start_group_call{ ushort(7252) };
inline constexpr phrase<> lng_menu_start_group_call_scheduled{ ushort(7253) };
inline constexpr phrase<> lng_menu_start_group_call_with{ ushort(7254) };
inline constexpr phrase<> lng_menu_start_group_call_join{ ushort(7255) };
inline constexpr phrase<> lng_menu_start_group_call_options{ ushort(7256) };
inline constexpr phrase<> lng_menu_start_group_call_channel{ ushort(7257) };
inline constexpr phrase<> lng_menu_start_group_call_scheduled_channel{ ushort(7258) };
inline constexpr phrase<> lng_menu_start_group_call_with_channel{ ushort(7259) };
inline constexpr phrase<> lng_group_call_rtmp_title{ ushort(7260) };
inline constexpr phrase<> lng_group_call_rtmp_url_subtitle{ ushort(7261) };
inline constexpr phrase<> lng_group_call_rtmp_url_copy{ ushort(7262) };
inline constexpr phrase<> lng_group_call_rtmp_url_copied{ ushort(7263) };
inline constexpr phrase<> lng_group_call_rtmp_key_subtitle{ ushort(7264) };
inline constexpr phrase<> lng_group_call_rtmp_key_copy{ ushort(7265) };
inline constexpr phrase<> lng_group_call_rtmp_key_copied{ ushort(7266) };
inline constexpr phrase<> lng_group_call_rtmp_key_warning{ ushort(7267) };
inline constexpr phrase<> lng_group_call_rtmp_info{ ushort(7268) };
inline constexpr phrase<> lng_group_call_rtmp_start{ ushort(7269) };
inline constexpr phrase<> lng_group_call_rtmp_revoke{ ushort(7270) };
inline constexpr phrase<> lng_group_call_rtmp_revoke_sure{ ushort(7271) };
inline constexpr phrase<lngtag_count> lng_group_call_rtmp_viewers{ ushort(7272) };
inline constexpr phrase<> lng_confcall_join_title{ ushort(7278) };
inline constexpr phrase<> lng_confcall_join_text{ ushort(7279) };
inline constexpr phrase<lngtag_user> lng_confcall_join_text_inviter{ ushort(7280) };
inline constexpr phrase<lngtag_user> lng_confcall_already_joined_one{ ushort(7281) };
inline constexpr phrase<lngtag_user, lngtag_other> lng_confcall_already_joined_two{ ushort(7282) };
inline constexpr phrase<lngtag_user, lngtag_other, lngtag_third> lng_confcall_already_joined_three{ ushort(7283) };
inline constexpr phrase<lngtag_count, lngtag_user, lngtag_other> lng_confcall_already_joined_many{ ushort(7284) };
inline constexpr phrase<> lng_confcall_join_button{ ushort(7290) };
inline constexpr phrase<> lng_confcall_create_call{ ushort(7291) };
inline constexpr phrase<lngtag_count> lng_confcall_create_call_description{ ushort(7292) };
inline constexpr phrase<> lng_confcall_create_title{ ushort(7298) };
inline constexpr phrase<> lng_confcall_create_link{ ushort(7299) };
inline constexpr phrase<> lng_confcall_create_link_description{ ushort(7300) };
inline constexpr phrase<> lng_confcall_link_revoke{ ushort(7301) };
inline constexpr phrase<> lng_confcall_link_revoked_title{ ushort(7302) };
inline constexpr phrase<> lng_confcall_link_inactive{ ushort(7303) };
inline constexpr phrase<> lng_confcall_link_revoked_text{ ushort(7304) };
inline constexpr phrase<> lng_confcall_link_title{ ushort(7305) };
inline constexpr phrase<> lng_confcall_link_about{ ushort(7306) };
inline constexpr phrase<> lng_confcall_link_or{ ushort(7307) };
inline constexpr phrase<lngtag_link> lng_confcall_link_join{ ushort(7308) };
inline constexpr phrase<lngtag_arrow> lng_confcall_link_join_link{ ushort(7309) };
inline constexpr phrase<> lng_confcall_inactive_title{ ushort(7310) };
inline constexpr phrase<> lng_confcall_inactive_about{ ushort(7311) };
inline constexpr phrase<lngtag_user> lng_confcall_invite_done_user{ ushort(7312) };
inline constexpr phrase<lngtag_count> lng_confcall_invite_done_many{ ushort(7313) };
inline constexpr phrase<lngtag_user> lng_confcall_invite_already_user{ ushort(7319) };
inline constexpr phrase<lngtag_count> lng_confcall_invite_already_many{ ushort(7320) };
inline constexpr phrase<lngtag_user> lng_confcall_invite_privacy_user{ ushort(7326) };
inline constexpr phrase<lngtag_count> lng_confcall_invite_privacy_many{ ushort(7327) };
inline constexpr phrase<lngtag_user> lng_confcall_invite_fail_user{ ushort(7333) };
inline constexpr phrase<lngtag_count> lng_confcall_invite_fail_many{ ushort(7334) };
inline constexpr phrase<lngtag_user> lng_confcall_invite_kicked_user{ ushort(7340) };
inline constexpr phrase<lngtag_count> lng_confcall_invite_kicked_many{ ushort(7341) };
inline constexpr phrase<> lng_confcall_not_accessible{ ushort(7347) };
inline constexpr phrase<> lng_confcall_participants_limit{ ushort(7348) };
inline constexpr phrase<lngtag_user> lng_confcall_sure_remove{ ushort(7349) };
inline constexpr phrase<> lng_confcall_e2e_badge{ ushort(7350) };
inline constexpr phrase<> lng_confcall_e2e_badge_small{ ushort(7351) };
inline constexpr phrase<> lng_confcall_e2e_about{ ushort(7352) };
inline constexpr phrase<> lng_no_mic_permission{ ushort(7353) };
inline constexpr phrase<lngtag_time> lng_player_message_today{ ushort(7354) };
inline constexpr phrase<lngtag_time> lng_player_message_yesterday{ ushort(7355) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_player_message_date{ ushort(7356) };
inline constexpr phrase<> lng_audio_player_reverse{ ushort(7357) };
inline constexpr phrase<> lng_audio_player_shuffle{ ushort(7358) };
inline constexpr phrase<> lng_audio_transcribe_long{ ushort(7359) };
inline constexpr phrase<lngtag_count, lngtag_date> lng_audio_transcribe_trials_left{ ushort(7360) };
inline constexpr phrase<lngtag_date, lngtag_link> lng_audio_transcribe_trials_over{ ushort(7366) };
inline constexpr phrase<> lng_rights_edit_admin{ ushort(7367) };
inline constexpr phrase<> lng_rights_edit_admin_header{ ushort(7368) };
inline constexpr phrase<> lng_rights_edit_admin_rank_name{ ushort(7369) };
inline constexpr phrase<lngtag_title> lng_rights_edit_admin_rank_about{ ushort(7370) };
inline constexpr phrase<> lng_rights_about_add_admins_yes{ ushort(7371) };
inline constexpr phrase<> lng_rights_about_add_admins_no{ ushort(7372) };
inline constexpr phrase<lngtag_user, lngtag_date> lng_rights_about_by{ ushort(7373) };
inline constexpr phrase<> lng_rights_about_admin_cant_edit{ ushort(7374) };
inline constexpr phrase<> lng_rights_about_restriction_cant_edit{ ushort(7375) };
inline constexpr phrase<> lng_rights_restriction_for_all{ ushort(7376) };
inline constexpr phrase<> lng_rights_permission_for_all{ ushort(7377) };
inline constexpr phrase<> lng_rights_permission_unavailable{ ushort(7378) };
inline constexpr phrase<> lng_rights_permission_in_discuss{ ushort(7379) };
inline constexpr phrase<> lng_rights_permission_cant_edit{ ushort(7380) };
inline constexpr phrase<> lng_rights_user_restrictions{ ushort(7381) };
inline constexpr phrase<> lng_rights_user_restrictions_header{ ushort(7382) };
inline constexpr phrase<> lng_rights_default_restrictions_header{ ushort(7383) };
inline constexpr phrase<> lng_rights_slowmode_header{ ushort(7384) };
inline constexpr phrase<> lng_rights_slowmode_off{ ushort(7385) };
inline constexpr phrase<> lng_rights_slowmode_about{ ushort(7386) };
inline constexpr phrase<lngtag_interval> lng_rights_slowmode_about_interval{ ushort(7387) };
inline constexpr phrase<lngtag_count> lng_rights_slowmode_interval_seconds{ ushort(7388) };
inline constexpr phrase<lngtag_count> lng_rights_slowmode_interval_minutes{ ushort(7394) };
inline constexpr phrase<> lng_rights_boosts_no_restrict{ ushort(7400) };
inline constexpr phrase<> lng_rights_boosts_about{ ushort(7401) };
inline constexpr phrase<> lng_rights_boosts_about_on{ ushort(7402) };
inline constexpr phrase<> lng_rights_charge_stars{ ushort(7403) };
inline constexpr phrase<> lng_rights_charge_stars_about{ ushort(7404) };
inline constexpr phrase<> lng_rights_charge_price{ ushort(7405) };
inline constexpr phrase<lngtag_percent, lngtag_amount> lng_rights_charge_price_about{ ushort(7406) };
inline constexpr phrase<lngtag_left> lng_slowmode_enabled{ ushort(7407) };
inline constexpr phrase<> lng_slowmode_no_many{ ushort(7408) };
inline constexpr phrase<> lng_slowmode_too_long{ ushort(7409) };
inline constexpr phrase<lngtag_count> lng_slowmode_seconds{ ushort(7410) };
inline constexpr phrase<> lng_payment_confirm_title{ ushort(7416) };
inline constexpr phrase<lngtag_count, lngtag_name> lng_payment_confirm_text{ ushort(7417) };
inline constexpr phrase<lngtag_count> lng_payment_confirm_amount{ ushort(7423) };
inline constexpr phrase<lngtag_count> lng_payment_confirm_users{ ushort(7429) };
inline constexpr phrase<lngtag_count> lng_payment_confirm_chats{ ushort(7435) };
inline constexpr phrase<lngtag_count, lngtag_amount> lng_payment_confirm_sure{ ushort(7441) };
inline constexpr phrase<> lng_payment_confirm_dont_ask{ ushort(7447) };
inline constexpr phrase<lngtag_count> lng_payment_confirm_button{ ushort(7448) };
inline constexpr phrase<lngtag_name, lngtag_cost> lng_payment_bar_text{ ushort(7454) };
inline constexpr phrase<> lng_payment_bar_button{ ushort(7455) };
inline constexpr phrase<> lng_payment_refund_title{ ushort(7456) };
inline constexpr phrase<lngtag_name> lng_payment_refund_text{ ushort(7457) };
inline constexpr phrase<lngtag_name> lng_payment_refund_channel{ ushort(7458) };
inline constexpr phrase<lngtag_count> lng_payment_refund_also{ ushort(7459) };
inline constexpr phrase<> lng_payment_refund_confirm{ ushort(7465) };
inline constexpr phrase<> lng_rights_gigagroup_title{ ushort(7466) };
inline constexpr phrase<> lng_rights_gigagroup_convert{ ushort(7467) };
inline constexpr phrase<> lng_rights_gigagroup_about{ ushort(7468) };
inline constexpr phrase<> lng_gigagroup_convert_title{ ushort(7469) };
inline constexpr phrase<> lng_gigagroup_convert_feature1{ ushort(7470) };
inline constexpr phrase<> lng_gigagroup_convert_feature2{ ushort(7471) };
inline constexpr phrase<> lng_gigagroup_convert_feature3{ ushort(7472) };
inline constexpr phrase<> lng_gigagroup_convert_sure{ ushort(7473) };
inline constexpr phrase<> lng_gigagroup_warning_title{ ushort(7474) };
inline constexpr phrase<> lng_gigagroup_warning{ ushort(7475) };
inline constexpr phrase<> lng_gigagroup_done{ ushort(7476) };
inline constexpr phrase<> lng_gigagroup_suggest_title{ ushort(7477) };
inline constexpr phrase<> lng_gigagroup_suggest_text{ ushort(7478) };
inline constexpr phrase<> lng_gigagroup_suggest_more{ ushort(7479) };
inline constexpr phrase<> lng_rights_channel_info{ ushort(7480) };
inline constexpr phrase<> lng_rights_channel_manage{ ushort(7481) };
inline constexpr phrase<> lng_rights_channel_post{ ushort(7482) };
inline constexpr phrase<> lng_rights_channel_edit{ ushort(7483) };
inline constexpr phrase<> lng_rights_channel_delete{ ushort(7484) };
inline constexpr phrase<> lng_rights_channel_manage_stories{ ushort(7485) };
inline constexpr phrase<> lng_rights_channel_post_stories{ ushort(7486) };
inline constexpr phrase<> lng_rights_channel_edit_stories{ ushort(7487) };
inline constexpr phrase<> lng_rights_channel_delete_stories{ ushort(7488) };
inline constexpr phrase<> lng_rights_channel_manage_calls{ ushort(7489) };
inline constexpr phrase<> lng_rights_channel_manage_direct{ ushort(7490) };
inline constexpr phrase<> lng_rights_group_info{ ushort(7491) };
inline constexpr phrase<> lng_rights_group_ban{ ushort(7492) };
inline constexpr phrase<> lng_rights_group_invite_link{ ushort(7493) };
inline constexpr phrase<> lng_rights_group_invite{ ushort(7494) };
inline constexpr phrase<> lng_rights_group_pin{ ushort(7495) };
inline constexpr phrase<> lng_rights_group_topics{ ushort(7496) };
inline constexpr phrase<> lng_rights_group_add_topics{ ushort(7497) };
inline constexpr phrase<> lng_rights_group_manage_calls{ ushort(7498) };
inline constexpr phrase<> lng_rights_group_delete{ ushort(7499) };
inline constexpr phrase<> lng_rights_group_anonymous{ ushort(7500) };
inline constexpr phrase<> lng_rights_add_admins{ ushort(7501) };
inline constexpr phrase<> lng_rights_chat_send_text{ ushort(7502) };
inline constexpr phrase<> lng_rights_chat_send_media{ ushort(7503) };
inline constexpr phrase<> lng_rights_chat_send_stickers{ ushort(7504) };
inline constexpr phrase<> lng_rights_chat_send_links{ ushort(7505) };
inline constexpr phrase<> lng_rights_chat_send_polls{ ushort(7506) };
inline constexpr phrase<> lng_rights_chat_add_members{ ushort(7507) };
inline constexpr phrase<> lng_rights_chat_photos{ ushort(7508) };
inline constexpr phrase<> lng_rights_chat_videos{ ushort(7509) };
inline constexpr phrase<> lng_rights_chat_stickers{ ushort(7510) };
inline constexpr phrase<> lng_rights_chat_music{ ushort(7511) };
inline constexpr phrase<> lng_rights_chat_files{ ushort(7512) };
inline constexpr phrase<> lng_rights_chat_voice_messages{ ushort(7513) };
inline constexpr phrase<> lng_rights_chat_video_messages{ ushort(7514) };
inline constexpr phrase<lngtag_user, lngtag_date> lng_rights_chat_restricted_by{ ushort(7515) };
inline constexpr phrase<lngtag_user, lngtag_date> lng_rights_chat_banned_by{ ushort(7516) };
inline constexpr phrase<> lng_rights_chat_banned_until_header{ ushort(7517) };
inline constexpr phrase<> lng_rights_chat_banned_forever{ ushort(7518) };
inline constexpr phrase<lngtag_count> lng_rights_chat_banned_day{ ushort(7519) };
inline constexpr phrase<lngtag_count> lng_rights_chat_banned_week{ ushort(7525) };
inline constexpr phrase<> lng_rights_chat_banned_custom{ ushort(7531) };
inline constexpr phrase<lngtag_date> lng_rights_chat_banned_custom_date{ ushort(7532) };
inline constexpr phrase<> lng_rights_transfer_group{ ushort(7533) };
inline constexpr phrase<> lng_rights_transfer_channel{ ushort(7534) };
inline constexpr phrase<> lng_rights_transfer_check{ ushort(7535) };
inline constexpr phrase<lngtag_user> lng_rights_transfer_check_about{ ushort(7536) };
inline constexpr phrase<lngtag_user> lng_rights_transfer_check_about_channel{ ushort(7537) };
inline constexpr phrase<> lng_rights_transfer_check_password{ ushort(7538) };
inline constexpr phrase<> lng_rights_transfer_check_session{ ushort(7539) };
inline constexpr phrase<> lng_rights_transfer_check_later{ ushort(7540) };
inline constexpr phrase<> lng_rights_transfer_set_password{ ushort(7541) };
inline constexpr phrase<lngtag_group, lngtag_user> lng_rights_transfer_about{ ushort(7542) };
inline constexpr phrase<> lng_rights_transfer_sure{ ushort(7543) };
inline constexpr phrase<> lng_rights_transfer_password_title{ ushort(7544) };
inline constexpr phrase<> lng_rights_transfer_password_description{ ushort(7545) };
inline constexpr phrase<lngtag_user> lng_rights_transfer_done_group{ ushort(7546) };
inline constexpr phrase<lngtag_user> lng_rights_transfer_done_channel{ ushort(7547) };
inline constexpr phrase<> lng_bots_password_confirm_check_about{ ushort(7548) };
inline constexpr phrase<> lng_bots_password_confirm_title{ ushort(7549) };
inline constexpr phrase<> lng_bots_password_confirm_description{ ushort(7550) };
inline constexpr phrase<> lng_restricted_send_message{ ushort(7551) };
inline constexpr phrase<> lng_restricted_send_photos{ ushort(7552) };
inline constexpr phrase<> lng_restricted_send_videos{ ushort(7553) };
inline constexpr phrase<> lng_restricted_send_music{ ushort(7554) };
inline constexpr phrase<> lng_restricted_send_files{ ushort(7555) };
inline constexpr phrase<> lng_restricted_send_voice_messages_group{ ushort(7556) };
inline constexpr phrase<> lng_restricted_send_video_messages_group{ ushort(7557) };
inline constexpr phrase<> lng_restricted_send_stickers{ ushort(7558) };
inline constexpr phrase<> lng_restricted_send_gifs{ ushort(7559) };
inline constexpr phrase<> lng_restricted_send_inline{ ushort(7560) };
inline constexpr phrase<> lng_restricted_send_polls{ ushort(7561) };
inline constexpr phrase<> lng_restricted_boost_group{ ushort(7562) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_message_until{ ushort(7563) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_photos_until{ ushort(7564) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_videos_until{ ushort(7565) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_music_until{ ushort(7566) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_files_until{ ushort(7567) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_voice_messages_until{ ushort(7568) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_video_messages_until{ ushort(7569) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_stickers_until{ ushort(7570) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_gifs_until{ ushort(7571) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_inline_until{ ushort(7572) };
inline constexpr phrase<lngtag_date, lngtag_time> lng_restricted_send_polls_until{ ushort(7573) };
inline constexpr phrase<> lng_restricted_send_message_all{ ushort(7574) };
inline constexpr phrase<> lng_restricted_send_photos_all{ ushort(7575) };
inline constexpr phrase<> lng_restricted_send_videos_all{ ushort(7576) };
inline constexpr phrase<> lng_restricted_send_music_all{ ushort(7577) };
inline constexpr phrase<> lng_restricted_send_files_all{ ushort(7578) };
inline constexpr phrase<> lng_restricted_send_voice_messages_all{ ushort(7579) };
inline constexpr phrase<> lng_restricted_send_video_messages_all{ ushort(7580) };
inline constexpr phrase<> lng_restricted_send_stickers_all{ ushort(7581) };
inline constexpr phrase<> lng_restricted_send_gifs_all{ ushort(7582) };
inline constexpr phrase<> lng_restricted_send_inline_all{ ushort(7583) };
inline constexpr phrase<> lng_restricted_send_polls_all{ ushort(7584) };
inline constexpr phrase<> lng_restricted_send_public_polls{ ushort(7585) };
inline constexpr phrase<> lng_restricted_send_todo_lists{ ushort(7586) };
inline constexpr phrase<> lng_restricted_send_paid_media{ ushort(7587) };
inline constexpr phrase<lngtag_user> lng_restricted_send_voice_messages{ ushort(7588) };
inline constexpr phrase<lngtag_user> lng_restricted_send_video_messages{ ushort(7589) };
inline constexpr phrase<lngtag_user> lng_restricted_send_non_premium{ ushort(7590) };
inline constexpr phrase<> lng_restricted_send_non_premium_more{ ushort(7591) };
inline constexpr phrase<lngtag_user> lng_send_non_premium_text{ ushort(7592) };
inline constexpr phrase<> lng_send_non_premium_go{ ushort(7593) };
inline constexpr phrase<> lng_send_non_premium_story{ ushort(7594) };
inline constexpr phrase<> lng_send_non_premium_unlock{ ushort(7595) };
inline constexpr phrase<lngtag_user, lngtag_link> lng_send_non_premium_message_toast{ ushort(7596) };
inline constexpr phrase<> lng_send_non_premium_message_toast_link{ ushort(7597) };
inline constexpr phrase<lngtag_channel, lngtag_amount> lng_send_charges_stars_channel{ ushort(7598) };
inline constexpr phrase<lngtag_channel> lng_send_free_channel{ ushort(7599) };
inline constexpr phrase<lngtag_user, lngtag_amount> lng_send_charges_stars_text{ ushort(7600) };
inline constexpr phrase<> lng_send_charges_stars_go{ ushort(7601) };
inline constexpr phrase<> lng_exceptions_list_title{ ushort(7602) };
inline constexpr phrase<> lng_removed_list_title{ ushort(7603) };
inline constexpr phrase<> lng_admin_log_title_all{ ushort(7604) };
inline constexpr phrase<> lng_admin_log_title_selected{ ushort(7605) };
inline constexpr phrase<> lng_admin_log_filter_title{ ushort(7606) };
inline constexpr phrase<> lng_admin_log_filter_all_actions{ ushort(7607) };
inline constexpr phrase<> lng_admin_log_filter_actions_type_subtitle{ ushort(7608) };
inline constexpr phrase<> lng_admin_log_filter_actions_member_section{ ushort(7609) };
inline constexpr phrase<> lng_admin_log_filter_actions_subscriber_section{ ushort(7610) };
inline constexpr phrase<> lng_admin_log_filter_restrictions{ ushort(7611) };
inline constexpr phrase<> lng_admin_log_filter_admins_new{ ushort(7612) };
inline constexpr phrase<> lng_admin_log_filter_members_new{ ushort(7613) };
inline constexpr phrase<> lng_admin_log_filter_subscribers_new{ ushort(7614) };
inline constexpr phrase<> lng_admin_log_filter_actions_settings_section{ ushort(7615) };
inline constexpr phrase<> lng_admin_log_filter_actions_channel_settings_section{ ushort(7616) };
inline constexpr phrase<> lng_admin_log_filter_info_group{ ushort(7617) };
inline constexpr phrase<> lng_admin_log_filter_info_channel{ ushort(7618) };
inline constexpr phrase<> lng_admin_log_filter_actions_messages_section{ ushort(7619) };
inline constexpr phrase<> lng_admin_log_filter_messages_deleted{ ushort(7620) };
inline constexpr phrase<> lng_admin_log_filter_messages_edited{ ushort(7621) };
inline constexpr phrase<> lng_admin_log_filter_messages_pinned{ ushort(7622) };
inline constexpr phrase<> lng_admin_log_filter_voice_chats{ ushort(7623) };
inline constexpr phrase<> lng_admin_log_filter_voice_chats_channel{ ushort(7624) };
inline constexpr phrase<> lng_admin_log_filter_invite_links{ ushort(7625) };
inline constexpr phrase<> lng_admin_log_filter_members_removed{ ushort(7626) };
inline constexpr phrase<> lng_admin_log_filter_subscribers_removed{ ushort(7627) };
inline constexpr phrase<> lng_admin_log_filter_topics{ ushort(7628) };
inline constexpr phrase<> lng_admin_log_filter_sub_extend{ ushort(7629) };
inline constexpr phrase<> lng_admin_log_filter_all_admins{ ushort(7630) };
inline constexpr phrase<> lng_admin_log_filter_actions_admins_subtitle{ ushort(7631) };
inline constexpr phrase<> lng_admin_log_filter_actions_admins_section{ ushort(7632) };
inline constexpr phrase<> lng_admin_log_about_text{ ushort(7633) };
inline constexpr phrase<> lng_admin_log_about_text_channel{ ushort(7634) };
inline constexpr phrase<> lng_admin_log_no_results_title{ ushort(7635) };
inline constexpr phrase<> lng_admin_log_no_results_text{ ushort(7636) };
inline constexpr phrase<lngtag_query> lng_admin_log_no_results_search_text{ ushort(7637) };
inline constexpr phrase<> lng_admin_log_no_events_title{ ushort(7638) };
inline constexpr phrase<> lng_admin_log_no_events_text{ ushort(7639) };
inline constexpr phrase<> lng_admin_log_no_events_text_channel{ ushort(7640) };
inline constexpr phrase<> lng_admin_log_empty_text{ ushort(7641) };
inline constexpr phrase<lngtag_from, lngtag_title> lng_admin_log_changed_title_channel{ ushort(7642) };
inline constexpr phrase<lngtag_from> lng_admin_log_changed_description_group{ ushort(7643) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_description_group{ ushort(7644) };
inline constexpr phrase<lngtag_from> lng_admin_log_changed_description_channel{ ushort(7645) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_description_channel{ ushort(7646) };
inline constexpr phrase<> lng_admin_log_previous_description{ ushort(7647) };
inline constexpr phrase<lngtag_from> lng_admin_log_changed_link_group{ ushort(7648) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_link_group{ ushort(7649) };
inline constexpr phrase<lngtag_from> lng_admin_log_changed_link_channel{ ushort(7650) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_link_channel{ ushort(7651) };
inline constexpr phrase<> lng_admin_log_previous_link{ ushort(7652) };
inline constexpr phrase<lngtag_from> lng_admin_log_reordered_link_group{ ushort(7653) };
inline constexpr phrase<lngtag_from> lng_admin_log_reordered_link_channel{ ushort(7654) };
inline constexpr phrase<> lng_admin_log_previous_links_order{ ushort(7655) };
inline constexpr phrase<lngtag_from, lngtag_link> lng_admin_log_activated_link{ ushort(7656) };
inline constexpr phrase<lngtag_from, lngtag_link> lng_admin_log_deactivated_link{ ushort(7657) };
inline constexpr phrase<lngtag_from> lng_admin_log_changed_photo_group{ ushort(7658) };
inline constexpr phrase<lngtag_from> lng_admin_log_changed_photo_channel{ ushort(7659) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_photo_group{ ushort(7660) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_photo_channel{ ushort(7661) };
inline constexpr phrase<lngtag_from> lng_admin_log_invites_enabled{ ushort(7662) };
inline constexpr phrase<lngtag_from> lng_admin_log_invites_disabled{ ushort(7663) };
inline constexpr phrase<lngtag_from> lng_admin_log_signatures_enabled{ ushort(7664) };
inline constexpr phrase<lngtag_from> lng_admin_log_signatures_disabled{ ushort(7665) };
inline constexpr phrase<lngtag_from> lng_admin_log_signature_profiles_enabled{ ushort(7666) };
inline constexpr phrase<lngtag_from> lng_admin_log_signature_profiles_disabled{ ushort(7667) };
inline constexpr phrase<lngtag_from> lng_admin_log_forwards_enabled{ ushort(7668) };
inline constexpr phrase<lngtag_from> lng_admin_log_forwards_disabled{ ushort(7669) };
inline constexpr phrase<lngtag_from> lng_admin_log_history_made_hidden{ ushort(7670) };
inline constexpr phrase<lngtag_from> lng_admin_log_history_made_visible{ ushort(7671) };
inline constexpr phrase<lngtag_from> lng_admin_log_pinned_message{ ushort(7672) };
inline constexpr phrase<lngtag_from> lng_admin_log_unpinned_message{ ushort(7673) };
inline constexpr phrase<lngtag_from> lng_admin_log_edited_caption{ ushort(7674) };
inline constexpr phrase<lngtag_from> lng_admin_log_edited_media{ ushort(7675) };
inline constexpr phrase<lngtag_from> lng_admin_log_edited_media_and_caption{ ushort(7676) };
inline constexpr phrase<lngtag_from> lng_admin_log_edited_media_and_removed_caption{ ushort(7677) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_caption{ ushort(7678) };
inline constexpr phrase<> lng_admin_log_previous_caption{ ushort(7679) };
inline constexpr phrase<lngtag_from> lng_admin_log_edited_message{ ushort(7680) };
inline constexpr phrase<> lng_admin_log_previous_message{ ushort(7681) };
inline constexpr phrase<lngtag_from> lng_admin_log_deleted_message{ ushort(7682) };
inline constexpr phrase<lngtag_from> lng_admin_log_sent_message{ ushort(7683) };
inline constexpr phrase<lngtag_from> lng_admin_log_participant_joined{ ushort(7684) };
inline constexpr phrase<lngtag_from> lng_admin_log_participant_joined_channel{ ushort(7685) };
inline constexpr phrase<lngtag_from, lngtag_link> lng_admin_log_participant_joined_by_link{ ushort(7686) };
inline constexpr phrase<lngtag_from, lngtag_link> lng_admin_log_participant_joined_by_link_channel{ ushort(7687) };
inline constexpr phrase<lngtag_from, lngtag_link> lng_admin_log_participant_joined_by_filter_link{ ushort(7688) };
inline constexpr phrase<lngtag_from, lngtag_link> lng_admin_log_participant_joined_by_filter_link_channel{ ushort(7689) };
inline constexpr phrase<lngtag_from, lngtag_link, lngtag_user> lng_admin_log_participant_approved_by_link{ ushort(7690) };
inline constexpr phrase<lngtag_from, lngtag_link, lngtag_user> lng_admin_log_participant_approved_by_link_channel{ ushort(7691) };
inline constexpr phrase<lngtag_from, lngtag_user> lng_admin_log_participant_approved_by_request{ ushort(7692) };
inline constexpr phrase<lngtag_from, lngtag_user> lng_admin_log_participant_approved_by_request_channel{ ushort(7693) };
inline constexpr phrase<lngtag_from, lngtag_link> lng_admin_log_revoke_invite_link{ ushort(7694) };
inline constexpr phrase<lngtag_from, lngtag_link> lng_admin_log_delete_invite_link{ ushort(7695) };
inline constexpr phrase<lngtag_from> lng_admin_log_participant_left{ ushort(7696) };
inline constexpr phrase<lngtag_from> lng_admin_log_participant_left_channel{ ushort(7697) };
inline constexpr phrase<lngtag_from> lng_admin_log_stopped_poll{ ushort(7698) };
inline constexpr phrase<lngtag_user> lng_admin_log_invited{ ushort(7699) };
inline constexpr phrase<lngtag_user> lng_admin_log_banned{ ushort(7700) };
inline constexpr phrase<lngtag_user, lngtag_until> lng_admin_log_banned_until{ ushort(7701) };
inline constexpr phrase<lngtag_user> lng_admin_log_unbanned{ ushort(7702) };
inline constexpr phrase<lngtag_user, lngtag_until> lng_admin_log_restricted{ ushort(7703) };
inline constexpr phrase<lngtag_user> lng_admin_log_promoted{ ushort(7704) };
inline constexpr phrase<lngtag_user> lng_admin_log_transferred{ ushort(7705) };
inline constexpr phrase<> lng_admin_log_changed_default_permissions{ ushort(7706) };
inline constexpr phrase<lngtag_from, lngtag_sticker_set> lng_admin_log_changed_stickers_group{ ushort(7707) };
inline constexpr phrase<> lng_admin_log_changed_stickers_set{ ushort(7708) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_stickers_group{ ushort(7709) };
inline constexpr phrase<lngtag_from, lngtag_sticker_set> lng_admin_log_changed_emoji_group{ ushort(7710) };
inline constexpr phrase<> lng_admin_log_changed_emoji_set{ ushort(7711) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_emoji_group{ ushort(7712) };
inline constexpr phrase<lngtag_from, lngtag_chat> lng_admin_log_changed_linked_chat{ ushort(7713) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_linked_chat{ ushort(7714) };
inline constexpr phrase<lngtag_from, lngtag_chat> lng_admin_log_changed_linked_channel{ ushort(7715) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_linked_channel{ ushort(7716) };
inline constexpr phrase<lngtag_from, lngtag_address> lng_admin_log_changed_location_chat{ ushort(7717) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_location_chat{ ushort(7718) };
inline constexpr phrase<lngtag_from, lngtag_duration> lng_admin_log_changed_slow_mode{ ushort(7719) };
inline constexpr phrase<lngtag_from> lng_admin_log_removed_slow_mode{ ushort(7720) };
inline constexpr phrase<lngtag_from> lng_admin_log_started_group_call{ ushort(7721) };
inline constexpr phrase<lngtag_from> lng_admin_log_started_group_call_channel{ ushort(7722) };
inline constexpr phrase<lngtag_from> lng_admin_log_discarded_group_call{ ushort(7723) };
inline constexpr phrase<lngtag_from> lng_admin_log_discarded_group_call_channel{ ushort(7724) };
inline constexpr phrase<lngtag_from, lngtag_user> lng_admin_log_muted_participant{ ushort(7725) };
inline constexpr phrase<lngtag_from, lngtag_user> lng_admin_log_muted_participant_channel{ ushort(7726) };
inline constexpr phrase<lngtag_from, lngtag_user> lng_admin_log_unmuted_participant{ ushort(7727) };
inline constexpr phrase<lngtag_from, lngtag_user> lng_admin_log_unmuted_participant_channel{ ushort(7728) };
inline constexpr phrase<lngtag_from> lng_admin_log_allowed_unmute_self{ ushort(7729) };
inline constexpr phrase<lngtag_from> lng_admin_log_allowed_unmute_self_channel{ ushort(7730) };
inline constexpr phrase<lngtag_from> lng_admin_log_disallowed_unmute_self{ ushort(7731) };
inline constexpr phrase<lngtag_from> lng_admin_log_disallowed_unmute_self_channel{ ushort(7732) };
inline constexpr phrase<lngtag_from, lngtag_user, lngtag_percent> lng_admin_log_participant_volume{ ushort(7733) };
inline constexpr phrase<lngtag_from, lngtag_user, lngtag_percent> lng_admin_log_participant_volume_channel{ ushort(7734) };
inline constexpr phrase<lngtag_from> lng_admin_log_antispam_enabled{ ushort(7735) };
inline constexpr phrase<lngtag_from> lng_admin_log_antispam_disabled{ ushort(7736) };
inline constexpr phrase<lngtag_from> lng_admin_log_autotranslate_enabled{ ushort(7737) };
inline constexpr phrase<lngtag_from> lng_admin_log_autotranslate_disabled{ ushort(7738) };
inline constexpr phrase<lngtag_from, lngtag_previous, lngtag_color> lng_admin_log_change_color{ ushort(7739) };
inline constexpr phrase<lngtag_from, lngtag_emoji> lng_admin_log_set_background_emoji{ ushort(7740) };
inline constexpr phrase<lngtag_from, lngtag_previous, lngtag_emoji> lng_admin_log_change_background_emoji{ ushort(7741) };
inline constexpr phrase<lngtag_from, lngtag_emoji> lng_admin_log_removed_background_emoji{ ushort(7742) };
inline constexpr phrase<lngtag_from, lngtag_previous, lngtag_color> lng_admin_log_change_profile_color{ ushort(7743) };
inline constexpr phrase<lngtag_from, lngtag_emoji> lng_admin_log_set_profile_background_emoji{ ushort(7744) };
inline constexpr phrase<lngtag_from, lngtag_previous, lngtag_emoji> lng_admin_log_change_profile_background_emoji{ ushort(7745) };
inline constexpr phrase<lngtag_from, lngtag_emoji> lng_admin_log_removed_profile_background_emoji{ ushort(7746) };
inline constexpr phrase<lngtag_from, lngtag_previous, lngtag_color> lng_admin_log_change_profile_color_group{ ushort(7747) };
inline constexpr phrase<lngtag_from, lngtag_emoji> lng_admin_log_set_profile_background_emoji_group{ ushort(7748) };
inline constexpr phrase<lngtag_from, lngtag_previous, lngtag_emoji> lng_admin_log_change_profile_background_emoji_group{ ushort(7749) };
inline constexpr phrase<lngtag_from, lngtag_emoji> lng_admin_log_removed_profile_background_emoji_group{ ushort(7750) };
inline constexpr phrase<lngtag_from> lng_admin_log_change_wallpaper{ ushort(7751) };
inline constexpr phrase<lngtag_from, lngtag_emoji> lng_admin_log_set_status{ ushort(7752) };
inline constexpr phrase<lngtag_from, lngtag_previous, lngtag_emoji> lng_admin_log_change_status{ ushort(7753) };
inline constexpr phrase<lngtag_from, lngtag_emoji> lng_admin_log_removed_status{ ushort(7754) };
inline constexpr phrase<lngtag_from, lngtag_emoji, lngtag_date> lng_admin_log_set_status_until{ ushort(7755) };
inline constexpr phrase<lngtag_from, lngtag_previous, lngtag_emoji, lngtag_date> lng_admin_log_change_status_until{ ushort(7756) };
inline constexpr phrase<lngtag_name, lngtag_mention> lng_admin_log_user_with_username{ ushort(7757) };
inline constexpr phrase<lngtag_from, lngtag_duration> lng_admin_log_messages_ttl_set{ ushort(7758) };
inline constexpr phrase<lngtag_from, lngtag_previous, lngtag_duration> lng_admin_log_messages_ttl_changed{ ushort(7759) };
inline constexpr phrase<lngtag_from, lngtag_duration> lng_admin_log_messages_ttl_removed{ ushort(7760) };
inline constexpr phrase<lngtag_from> lng_admin_log_reactions_disabled{ ushort(7761) };
inline constexpr phrase<lngtag_from, lngtag_emoji> lng_admin_log_reactions_updated{ ushort(7762) };
inline constexpr phrase<lngtag_from> lng_admin_log_reactions_allowed_all{ ushort(7763) };
inline constexpr phrase<lngtag_from> lng_admin_log_reactions_allowed_official{ ushort(7764) };
inline constexpr phrase<lngtag_link> lng_admin_log_edited_invite_link{ ushort(7765) };
inline constexpr phrase<lngtag_previous, lngtag_limit> lng_admin_log_invite_link_expire_date{ ushort(7766) };
inline constexpr phrase<lngtag_previous, lngtag_limit> lng_admin_log_invite_link_usage_limit{ ushort(7767) };
inline constexpr phrase<lngtag_previous, lngtag_limit> lng_admin_log_invite_link_label{ ushort(7768) };
inline constexpr phrase<> lng_admin_log_invite_link_request_needed{ ushort(7769) };
inline constexpr phrase<> lng_admin_log_invite_link_request_not_needed{ ushort(7770) };
inline constexpr phrase<lngtag_from> lng_admin_log_topics_enabled{ ushort(7771) };
inline constexpr phrase<lngtag_from> lng_admin_log_topics_disabled{ ushort(7772) };
inline constexpr phrase<lngtag_from, lngtag_topic> lng_admin_log_topics_created{ ushort(7773) };
inline constexpr phrase<lngtag_from, lngtag_topic, lngtag_new_topic> lng_admin_log_topics_changed{ ushort(7774) };
inline constexpr phrase<lngtag_from, lngtag_topic> lng_admin_log_topics_closed{ ushort(7775) };
inline constexpr phrase<lngtag_from, lngtag_topic> lng_admin_log_topics_reopened{ ushort(7776) };
inline constexpr phrase<lngtag_from, lngtag_topic> lng_admin_log_topics_hidden{ ushort(7777) };
inline constexpr phrase<lngtag_from, lngtag_topic> lng_admin_log_topics_unhidden{ ushort(7778) };
inline constexpr phrase<lngtag_from, lngtag_topic> lng_admin_log_topics_deleted{ ushort(7779) };
inline constexpr phrase<lngtag_from, lngtag_topic> lng_admin_log_topics_pinned{ ushort(7780) };
inline constexpr phrase<lngtag_from, lngtag_topic> lng_admin_log_topics_unpinned{ ushort(7781) };
inline constexpr phrase<> lng_admin_log_restricted_forever{ ushort(7782) };
inline constexpr phrase<lngtag_date> lng_admin_log_restricted_until{ ushort(7783) };
inline constexpr phrase<> lng_admin_log_banned_view_messages{ ushort(7784) };
inline constexpr phrase<> lng_admin_log_banned_send_messages{ ushort(7785) };
inline constexpr phrase<> lng_admin_log_banned_send_photos{ ushort(7786) };
inline constexpr phrase<> lng_admin_log_banned_send_videos{ ushort(7787) };
inline constexpr phrase<> lng_admin_log_banned_send_music{ ushort(7788) };
inline constexpr phrase<> lng_admin_log_banned_send_files{ ushort(7789) };
inline constexpr phrase<> lng_admin_log_banned_send_voice_messages{ ushort(7790) };
inline constexpr phrase<> lng_admin_log_banned_send_video_messages{ ushort(7791) };
inline constexpr phrase<> lng_admin_log_banned_send_stickers{ ushort(7792) };
inline constexpr phrase<> lng_admin_log_banned_embed_links{ ushort(7793) };
inline constexpr phrase<> lng_admin_log_banned_send_polls{ ushort(7794) };
inline constexpr phrase<> lng_admin_log_admin_change_info{ ushort(7795) };
inline constexpr phrase<> lng_admin_log_admin_post_messages{ ushort(7796) };
inline constexpr phrase<> lng_admin_log_admin_edit_messages{ ushort(7797) };
inline constexpr phrase<> lng_admin_log_admin_delete_messages{ ushort(7798) };
inline constexpr phrase<> lng_admin_log_admin_post_stories{ ushort(7799) };
inline constexpr phrase<> lng_admin_log_admin_edit_stories{ ushort(7800) };
inline constexpr phrase<> lng_admin_log_admin_delete_stories{ ushort(7801) };
inline constexpr phrase<> lng_admin_log_admin_remain_anonymous{ ushort(7802) };
inline constexpr phrase<> lng_admin_log_admin_ban_users{ ushort(7803) };
inline constexpr phrase<> lng_admin_log_admin_invite_users{ ushort(7804) };
inline constexpr phrase<> lng_admin_log_admin_invite_link{ ushort(7805) };
inline constexpr phrase<> lng_admin_log_admin_pin_messages{ ushort(7806) };
inline constexpr phrase<> lng_admin_log_admin_manage_topics{ ushort(7807) };
inline constexpr phrase<> lng_admin_log_admin_create_topics{ ushort(7808) };
inline constexpr phrase<> lng_admin_log_admin_manage_calls{ ushort(7809) };
inline constexpr phrase<> lng_admin_log_admin_manage_calls_channel{ ushort(7810) };
inline constexpr phrase<> lng_admin_log_admin_manage_direct{ ushort(7811) };
inline constexpr phrase<> lng_admin_log_admin_add_admins{ ushort(7812) };
inline constexpr phrase<lngtag_name, lngtag_date> lng_admin_log_subscription_extend{ ushort(7813) };
inline constexpr phrase<> lng_admin_log_antispam_menu_report{ ushort(7814) };
inline constexpr phrase<lngtag_link> lng_admin_log_antispam_menu_report_toast{ ushort(7815) };
inline constexpr phrase<> lng_admin_log_antispam_menu_report_toast_link{ ushort(7816) };
inline constexpr phrase<lngtag_link> lng_terms_signup{ ushort(7817) };
inline constexpr phrase<> lng_terms_signup_link{ ushort(7818) };
inline constexpr phrase<> lng_terms_header{ ushort(7819) };
inline constexpr phrase<lngtag_count> lng_terms_age{ ushort(7820) };
inline constexpr phrase<> lng_terms_agree{ ushort(7826) };
inline constexpr phrase<> lng_terms_decline{ ushort(7827) };
inline constexpr phrase<> lng_terms_signup_sorry{ ushort(7828) };
inline constexpr phrase<> lng_terms_update_sorry{ ushort(7829) };
inline constexpr phrase<> lng_terms_decline_and_delete{ ushort(7830) };
inline constexpr phrase<> lng_terms_back{ ushort(7831) };
inline constexpr phrase<> lng_terms_delete_warning{ ushort(7832) };
inline constexpr phrase<> lng_terms_delete_now{ ushort(7833) };
inline constexpr phrase<lngtag_bot> lng_terms_agree_to_proceed{ ushort(7834) };
inline constexpr phrase<> lng_date_input_day{ ushort(7835) };
inline constexpr phrase<> lng_date_input_month{ ushort(7836) };
inline constexpr phrase<> lng_date_input_year{ ushort(7837) };
inline constexpr phrase<> lng_forward_title{ ushort(7838) };
inline constexpr phrase<lngtag_count> lng_forward_many_title{ ushort(7839) };
inline constexpr phrase<> lng_forward_about{ ushort(7845) };
inline constexpr phrase<> lng_forward_many_about{ ushort(7846) };
inline constexpr phrase<> lng_forward_show_sender{ ushort(7847) };
inline constexpr phrase<> lng_forward_show_senders{ ushort(7848) };
inline constexpr phrase<> lng_forward_show_caption{ ushort(7849) };
inline constexpr phrase<> lng_forward_show_captions{ ushort(7850) };
inline constexpr phrase<> lng_forward_change_recipient{ ushort(7851) };
inline constexpr phrase<> lng_forward_sender_names_removed{ ushort(7852) };
inline constexpr phrase<> lng_forward_header_short{ ushort(7853) };
inline constexpr phrase<> lng_forward_action_show_sender{ ushort(7854) };
inline constexpr phrase<> lng_forward_action_show_senders{ ushort(7855) };
inline constexpr phrase<> lng_forward_action_hide_sender{ ushort(7856) };
inline constexpr phrase<> lng_forward_action_hide_senders{ ushort(7857) };
inline constexpr phrase<> lng_forward_action_show_caption{ ushort(7858) };
inline constexpr phrase<> lng_forward_action_show_captions{ ushort(7859) };
inline constexpr phrase<> lng_forward_action_hide_caption{ ushort(7860) };
inline constexpr phrase<> lng_forward_action_hide_captions{ ushort(7861) };
inline constexpr phrase<> lng_forward_action_change_recipient{ ushort(7862) };
inline constexpr phrase<> lng_forward_action_remove{ ushort(7863) };
inline constexpr phrase<> lng_passport_title{ ushort(7864) };
inline constexpr phrase<lngtag_bot> lng_passport_request1{ ushort(7865) };
inline constexpr phrase<> lng_passport_request2{ ushort(7866) };
inline constexpr phrase<> lng_passport_create_password{ ushort(7867) };
inline constexpr phrase<> lng_passport_about_password{ ushort(7868) };
inline constexpr phrase<> lng_passport_password_create{ ushort(7869) };
inline constexpr phrase<> lng_passport_email_validate{ ushort(7870) };
inline constexpr phrase<lngtag_email> lng_passport_code_sent{ ushort(7871) };
inline constexpr phrase<> lng_passport_stop_password_sure{ ushort(7872) };
inline constexpr phrase<> lng_passport_password_placeholder{ ushort(7873) };
inline constexpr phrase<> lng_passport_next{ ushort(7874) };
inline constexpr phrase<> lng_passport_password_wrong{ ushort(7875) };
inline constexpr phrase<> lng_passport_header{ ushort(7876) };
inline constexpr phrase<> lng_passport_identity_title{ ushort(7877) };
inline constexpr phrase<> lng_passport_identity_description{ ushort(7878) };
inline constexpr phrase<> lng_passport_identity_passport{ ushort(7879) };
inline constexpr phrase<> lng_passport_identity_passport_upload{ ushort(7880) };
inline constexpr phrase<> lng_passport_identity_card{ ushort(7881) };
inline constexpr phrase<> lng_passport_identity_card_upload{ ushort(7882) };
inline constexpr phrase<> lng_passport_identity_license{ ushort(7883) };
inline constexpr phrase<> lng_passport_identity_license_upload{ ushort(7884) };
inline constexpr phrase<> lng_passport_identity_internal{ ushort(7885) };
inline constexpr phrase<> lng_passport_identity_internal_upload{ ushort(7886) };
inline constexpr phrase<> lng_passport_identity_about{ ushort(7887) };
inline constexpr phrase<> lng_passport_address_title{ ushort(7888) };
inline constexpr phrase<> lng_passport_address_description{ ushort(7889) };
inline constexpr phrase<> lng_passport_address_bill{ ushort(7890) };
inline constexpr phrase<> lng_passport_address_bill_upload{ ushort(7891) };
inline constexpr phrase<> lng_passport_address_statement{ ushort(7892) };
inline constexpr phrase<> lng_passport_address_statement_upload{ ushort(7893) };
inline constexpr phrase<> lng_passport_address_agreement{ ushort(7894) };
inline constexpr phrase<> lng_passport_address_agreement_upload{ ushort(7895) };
inline constexpr phrase<> lng_passport_address_registration{ ushort(7896) };
inline constexpr phrase<> lng_passport_address_registration_upload{ ushort(7897) };
inline constexpr phrase<> lng_passport_address_temporary{ ushort(7898) };
inline constexpr phrase<> lng_passport_address_temporary_upload{ ushort(7899) };
inline constexpr phrase<> lng_passport_address_about{ ushort(7900) };
inline constexpr phrase<lngtag_document, lngtag_second_document> lng_passport_or_title{ ushort(7901) };
inline constexpr phrase<> lng_passport_document_type{ ushort(7902) };
inline constexpr phrase<> lng_passport_upload_document{ ushort(7903) };
inline constexpr phrase<> lng_passport_phone_title{ ushort(7904) };
inline constexpr phrase<> lng_passport_phone_description{ ushort(7905) };
inline constexpr phrase<> lng_passport_email_title{ ushort(7906) };
inline constexpr phrase<> lng_passport_email_description{ ushort(7907) };
inline constexpr phrase<> lng_passport_identity_selfie{ ushort(7908) };
inline constexpr phrase<> lng_passport_translation_needed{ ushort(7909) };
inline constexpr phrase<lngtag_policy, lngtag_bot> lng_passport_accept_allow{ ushort(7910) };
inline constexpr phrase<lngtag_bot> lng_passport_allow{ ushort(7911) };
inline constexpr phrase<lngtag_bot> lng_passport_policy{ ushort(7912) };
inline constexpr phrase<> lng_passport_authorize{ ushort(7913) };
inline constexpr phrase<> lng_passport_form_error{ ushort(7914) };
inline constexpr phrase<> lng_passport_save_value{ ushort(7915) };
inline constexpr phrase<lngtag_index> lng_passport_scan_index{ ushort(7916) };
inline constexpr phrase<> lng_passport_upload_scans{ ushort(7917) };
inline constexpr phrase<> lng_passport_upload_more{ ushort(7918) };
inline constexpr phrase<> lng_passport_selfie_title{ ushort(7919) };
inline constexpr phrase<> lng_passport_selfie_description{ ushort(7920) };
inline constexpr phrase<> lng_passport_upload_selfie{ ushort(7921) };
inline constexpr phrase<> lng_passport_reupload_selfie{ ushort(7922) };
inline constexpr phrase<> lng_passport_front_side_title{ ushort(7923) };
inline constexpr phrase<> lng_passport_front_side_description{ ushort(7924) };
inline constexpr phrase<> lng_passport_upload_front_side{ ushort(7925) };
inline constexpr phrase<> lng_passport_reupload_front_side{ ushort(7926) };
inline constexpr phrase<> lng_passport_reverse_side_title{ ushort(7927) };
inline constexpr phrase<> lng_passport_reverse_side_description{ ushort(7928) };
inline constexpr phrase<> lng_passport_upload_reverse_side{ ushort(7929) };
inline constexpr phrase<> lng_passport_reupload_reverse_side{ ushort(7930) };
inline constexpr phrase<> lng_passport_main_page_title{ ushort(7931) };
inline constexpr phrase<> lng_passport_main_page_description{ ushort(7932) };
inline constexpr phrase<> lng_passport_upload_main_page{ ushort(7933) };
inline constexpr phrase<> lng_passport_reupload_main_page{ ushort(7934) };
inline constexpr phrase<> lng_passport_personal_details{ ushort(7935) };
inline constexpr phrase<> lng_passport_personal_details_enter{ ushort(7936) };
inline constexpr phrase<> lng_passport_document_details{ ushort(7937) };
inline constexpr phrase<> lng_passport_choose_image{ ushort(7938) };
inline constexpr phrase<> lng_passport_delete_scan_undo{ ushort(7939) };
inline constexpr phrase<lngtag_date> lng_passport_scan_uploaded{ ushort(7940) };
inline constexpr phrase<> lng_passport_first_name{ ushort(7941) };
inline constexpr phrase<> lng_passport_middle_name{ ushort(7942) };
inline constexpr phrase<> lng_passport_last_name{ ushort(7943) };
inline constexpr phrase<> lng_passport_birth_date{ ushort(7944) };
inline constexpr phrase<> lng_passport_gender{ ushort(7945) };
inline constexpr phrase<> lng_passport_gender_male{ ushort(7946) };
inline constexpr phrase<> lng_passport_gender_female{ ushort(7947) };
inline constexpr phrase<> lng_passport_country{ ushort(7948) };
inline constexpr phrase<> lng_passport_residence_country{ ushort(7949) };
inline constexpr phrase<> lng_passport_country_choose{ ushort(7950) };
inline constexpr phrase<> lng_passport_document_number{ ushort(7951) };
inline constexpr phrase<> lng_passport_expiry_date{ ushort(7952) };
inline constexpr phrase<> lng_passport_native_name_title{ ushort(7953) };
inline constexpr phrase<lngtag_country> lng_passport_native_name_about{ ushort(7954) };
inline constexpr phrase<lngtag_language> lng_passport_native_name_language{ ushort(7955) };
inline constexpr phrase<> lng_passport_native_name_language_about{ ushort(7956) };
inline constexpr phrase<> lng_passport_address{ ushort(7957) };
inline constexpr phrase<> lng_passport_address_enter{ ushort(7958) };
inline constexpr phrase<> lng_passport_street{ ushort(7959) };
inline constexpr phrase<> lng_passport_city{ ushort(7960) };
inline constexpr phrase<> lng_passport_state{ ushort(7961) };
inline constexpr phrase<> lng_passport_postcode{ ushort(7962) };
inline constexpr phrase<> lng_passport_translation{ ushort(7963) };
inline constexpr phrase<lngtag_existing> lng_passport_use_existing{ ushort(7964) };
inline constexpr phrase<> lng_passport_use_existing_phone{ ushort(7965) };
inline constexpr phrase<> lng_passport_new_phone{ ushort(7966) };
inline constexpr phrase<> lng_passport_new_phone_code{ ushort(7967) };
inline constexpr phrase<> lng_passport_use_existing_email{ ushort(7968) };
inline constexpr phrase<> lng_passport_new_email{ ushort(7969) };
inline constexpr phrase<> lng_passport_new_email_code{ ushort(7970) };
inline constexpr phrase<lngtag_phone> lng_passport_confirm_phone{ ushort(7971) };
inline constexpr phrase<lngtag_email> lng_passport_confirm_email{ ushort(7972) };
inline constexpr phrase<> lng_passport_sure_cancel{ ushort(7973) };
inline constexpr phrase<> lng_passport_scans_limit_reached{ ushort(7974) };
inline constexpr phrase<> lng_passport_delete_document{ ushort(7975) };
inline constexpr phrase<> lng_passport_delete_document_sure{ ushort(7976) };
inline constexpr phrase<> lng_passport_delete_details{ ushort(7977) };
inline constexpr phrase<> lng_passport_delete_details_sure{ ushort(7978) };
inline constexpr phrase<> lng_passport_delete_address{ ushort(7979) };
inline constexpr phrase<> lng_passport_delete_address_sure{ ushort(7980) };
inline constexpr phrase<> lng_passport_delete_email{ ushort(7981) };
inline constexpr phrase<> lng_passport_delete_email_sure{ ushort(7982) };
inline constexpr phrase<> lng_passport_delete_phone{ ushort(7983) };
inline constexpr phrase<> lng_passport_delete_phone_sure{ ushort(7984) };
inline constexpr phrase<> lng_passport_success{ ushort(7985) };
inline constexpr phrase<> lng_passport_stop_sure{ ushort(7986) };
inline constexpr phrase<> lng_passport_stop{ ushort(7987) };
inline constexpr phrase<> lng_passport_restart_sure{ ushort(7988) };
inline constexpr phrase<> lng_passport_restart{ ushort(7989) };
inline constexpr phrase<> lng_passport_error_too_large{ ushort(7990) };
inline constexpr phrase<> lng_passport_error_bad_size{ ushort(7991) };
inline constexpr phrase<> lng_passport_error_cant_read{ ushort(7992) };
inline constexpr phrase<> lng_passport_bad_name{ ushort(7993) };
inline constexpr phrase<> lng_passport_wait_upload{ ushort(7994) };
inline constexpr phrase<> lng_passport_app_out_of_date{ ushort(7995) };
inline constexpr phrase<> lng_export_title{ ushort(7996) };
inline constexpr phrase<> lng_export_progress_title{ ushort(7997) };
inline constexpr phrase<> lng_export_option_info{ ushort(7998) };
inline constexpr phrase<> lng_export_option_info_about{ ushort(7999) };
inline constexpr phrase<> lng_export_option_contacts{ ushort(8000) };
inline constexpr phrase<> lng_export_option_contacts_about{ ushort(8001) };
inline constexpr phrase<> lng_export_option_stories{ ushort(8002) };
inline constexpr phrase<> lng_export_option_stories_about{ ushort(8003) };
inline constexpr phrase<> lng_export_option_profile_music{ ushort(8004) };
inline constexpr phrase<> lng_export_option_profile_music_about{ ushort(8005) };
inline constexpr phrase<> lng_export_option_sessions{ ushort(8006) };
inline constexpr phrase<> lng_export_option_sessions_about{ ushort(8007) };
inline constexpr phrase<> lng_export_header_other{ ushort(8008) };
inline constexpr phrase<> lng_export_option_other{ ushort(8009) };
inline constexpr phrase<> lng_export_option_other_about{ ushort(8010) };
inline constexpr phrase<> lng_export_header_chats{ ushort(8011) };
inline constexpr phrase<> lng_export_header_topic{ ushort(8012) };
inline constexpr phrase<> lng_export_option_personal_chats{ ushort(8013) };
inline constexpr phrase<> lng_export_option_bot_chats{ ushort(8014) };
inline constexpr phrase<> lng_export_option_private_groups{ ushort(8015) };
inline constexpr phrase<> lng_export_option_private_channels{ ushort(8016) };
inline constexpr phrase<> lng_export_option_public_groups{ ushort(8017) };
inline constexpr phrase<> lng_export_option_public_channels{ ushort(8018) };
inline constexpr phrase<> lng_export_option_only_my{ ushort(8019) };
inline constexpr phrase<> lng_export_header_media{ ushort(8020) };
inline constexpr phrase<> lng_export_option_photos{ ushort(8021) };
inline constexpr phrase<> lng_export_option_video_files{ ushort(8022) };
inline constexpr phrase<> lng_export_option_voice_messages{ ushort(8023) };
inline constexpr phrase<> lng_export_option_video_messages{ ushort(8024) };
inline constexpr phrase<> lng_export_option_stickers{ ushort(8025) };
inline constexpr phrase<> lng_export_option_gifs{ ushort(8026) };
inline constexpr phrase<> lng_export_option_files{ ushort(8027) };
inline constexpr phrase<lngtag_size> lng_export_option_size_limit{ ushort(8028) };
inline constexpr phrase<> lng_export_header_format{ ushort(8029) };
inline constexpr phrase<lngtag_path> lng_export_option_location{ ushort(8030) };
inline constexpr phrase<lngtag_format, lngtag_path> lng_export_option_format_location{ ushort(8031) };
inline constexpr phrase<> lng_export_option_choose_format{ ushort(8032) };
inline constexpr phrase<> lng_export_option_html{ ushort(8033) };
inline constexpr phrase<> lng_export_option_json{ ushort(8034) };
inline constexpr phrase<> lng_export_option_html_and_json{ ushort(8035) };
inline constexpr phrase<lngtag_from, lngtag_till> lng_export_limits{ ushort(8036) };
inline constexpr phrase<> lng_export_beginning{ ushort(8037) };
inline constexpr phrase<> lng_export_end{ ushort(8038) };
inline constexpr phrase<> lng_export_from_beginning{ ushort(8039) };
inline constexpr phrase<> lng_export_till_end{ ushort(8040) };
inline constexpr phrase<> lng_export_start{ ushort(8041) };
inline constexpr phrase<> lng_export_state_initializing{ ushort(8042) };
inline constexpr phrase<> lng_export_state_userpics{ ushort(8043) };
inline constexpr phrase<> lng_export_state_chats_list{ ushort(8044) };
inline constexpr phrase<> lng_export_state_chats{ ushort(8045) };
inline constexpr phrase<> lng_export_skip_file{ ushort(8046) };
inline constexpr phrase<> lng_export_progress{ ushort(8047) };
inline constexpr phrase<> lng_export_stop{ ushort(8048) };
inline constexpr phrase<> lng_export_sure_stop{ ushort(8049) };
inline constexpr phrase<> lng_export_about_done{ ushort(8050) };
inline constexpr phrase<> lng_export_done{ ushort(8051) };
inline constexpr phrase<> lng_export_finished{ ushort(8052) };
inline constexpr phrase<lngtag_amount> lng_export_total_amount{ ushort(8053) };
inline constexpr phrase<lngtag_size> lng_export_total_size{ ushort(8054) };
inline constexpr phrase<> lng_export_folder{ ushort(8055) };
inline constexpr phrase<> lng_export_invalid{ ushort(8056) };
inline constexpr phrase<lngtag_hours, lngtag_date> lng_export_delay{ ushort(8057) };
inline constexpr phrase<> lng_export_delay_less_than_hour{ ushort(8058) };
inline constexpr phrase<> lng_export_suggest_title{ ushort(8059) };
inline constexpr phrase<> lng_export_suggest_text{ ushort(8060) };
inline constexpr phrase<> lng_export_suggest_cancel{ ushort(8061) };
inline constexpr phrase<> lng_export_about_telegram{ ushort(8062) };
inline constexpr phrase<> lng_export_about_contacts{ ushort(8063) };
inline constexpr phrase<> lng_export_about_frequent{ ushort(8064) };
inline constexpr phrase<> lng_export_about_sessions{ ushort(8065) };
inline constexpr phrase<> lng_export_about_web_sessions{ ushort(8066) };
inline constexpr phrase<> lng_export_about_chats{ ushort(8067) };
inline constexpr phrase<> lng_export_about_left_chats{ ushort(8068) };
inline constexpr phrase<> lng_language_switch_title{ ushort(8069) };
inline constexpr phrase<lngtag_lang_name, lngtag_percent, lngtag_link> lng_language_switch_about_official{ ushort(8070) };
inline constexpr phrase<lngtag_lang_name, lngtag_percent, lngtag_link> lng_language_switch_about_unofficial{ ushort(8071) };
inline constexpr phrase<> lng_language_switch_link{ ushort(8072) };
inline constexpr phrase<> lng_language_switch_apply{ ushort(8073) };
inline constexpr phrase<> lng_language_not_found{ ushort(8074) };
inline constexpr phrase<> lng_language_already{ ushort(8075) };
inline constexpr phrase<> lng_language_not_ready_title{ ushort(8076) };
inline constexpr phrase<lngtag_lang_name, lngtag_link> lng_language_not_ready_about{ ushort(8077) };
inline constexpr phrase<> lng_language_not_ready_link{ ushort(8078) };
inline constexpr phrase<> lng_translate_box_error{ ushort(8079) };
inline constexpr phrase<> lng_translate_settings_subtitle{ ushort(8080) };
inline constexpr phrase<> lng_translate_settings_show{ ushort(8081) };
inline constexpr phrase<> lng_translate_settings_chat{ ushort(8082) };
inline constexpr phrase<> lng_translate_settings_choose{ ushort(8083) };
inline constexpr phrase<> lng_translate_settings_about{ ushort(8084) };
inline constexpr phrase<> lng_translate_settings_one{ ushort(8085) };
inline constexpr phrase<lngtag_extension> lng_launch_exe_warning{ ushort(8086) };
inline constexpr phrase<lngtag_extension> lng_launch_other_warning{ ushort(8087) };
inline constexpr phrase<> lng_launch_svg_warning{ ushort(8088) };
inline constexpr phrase<> lng_launch_exe_sure{ ushort(8089) };
inline constexpr phrase<> lng_launch_other_sure{ ushort(8090) };
inline constexpr phrase<> lng_launch_exe_dont_ask{ ushort(8091) };
inline constexpr phrase<> lng_launch_dont_ask{ ushort(8092) };
inline constexpr phrase<> lng_launch_dont_ask_settings{ ushort(8093) };
inline constexpr phrase<> lng_polls_anonymous{ ushort(8094) };
inline constexpr phrase<> lng_polls_public{ ushort(8095) };
inline constexpr phrase<> lng_polls_anonymous_quiz{ ushort(8096) };
inline constexpr phrase<> lng_polls_public_quiz{ ushort(8097) };
inline constexpr phrase<> lng_polls_closed{ ushort(8098) };
inline constexpr phrase<lngtag_count> lng_polls_votes_count{ ushort(8099) };
inline constexpr phrase<> lng_polls_votes_none{ ushort(8105) };
inline constexpr phrase<lngtag_count> lng_polls_answers_count{ ushort(8106) };
inline constexpr phrase<> lng_polls_answers_none{ ushort(8112) };
inline constexpr phrase<> lng_polls_submit_votes{ ushort(8113) };
inline constexpr phrase<> lng_polls_view_results{ ushort(8114) };
inline constexpr phrase<> lng_polls_retract{ ushort(8115) };
inline constexpr phrase<> lng_polls_stop{ ushort(8116) };
inline constexpr phrase<> lng_polls_stop_warning{ ushort(8117) };
inline constexpr phrase<> lng_polls_stop_sure{ ushort(8118) };
inline constexpr phrase<> lng_polls_menu_item{ ushort(8119) };
inline constexpr phrase<> lng_polls_create{ ushort(8120) };
inline constexpr phrase<> lng_polls_create_title{ ushort(8121) };
inline constexpr phrase<> lng_polls_create_question{ ushort(8122) };
inline constexpr phrase<> lng_polls_create_question_placeholder{ ushort(8123) };
inline constexpr phrase<> lng_polls_create_options{ ushort(8124) };
inline constexpr phrase<> lng_polls_create_option_add{ ushort(8125) };
inline constexpr phrase<lngtag_count> lng_polls_create_limit{ ushort(8126) };
inline constexpr phrase<> lng_polls_create_maximum{ ushort(8132) };
inline constexpr phrase<> lng_polls_create_settings{ ushort(8133) };
inline constexpr phrase<> lng_polls_create_anonymous{ ushort(8134) };
inline constexpr phrase<> lng_polls_create_multiple_choice{ ushort(8135) };
inline constexpr phrase<> lng_polls_create_quiz_mode{ ushort(8136) };
inline constexpr phrase<> lng_polls_create_button{ ushort(8137) };
inline constexpr phrase<> lng_polls_create_one_answer{ ushort(8138) };
inline constexpr phrase<> lng_polls_choose_question{ ushort(8139) };
inline constexpr phrase<> lng_polls_choose_answers{ ushort(8140) };
inline constexpr phrase<> lng_polls_choose_correct{ ushort(8141) };
inline constexpr phrase<> lng_polls_solution_title{ ushort(8142) };
inline constexpr phrase<> lng_polls_solution_placeholder{ ushort(8143) };
inline constexpr phrase<> lng_polls_solution_about{ ushort(8144) };
inline constexpr phrase<> lng_polls_poll_results_title{ ushort(8145) };
inline constexpr phrase<> lng_polls_quiz_results_title{ ushort(8146) };
inline constexpr phrase<lngtag_count> lng_polls_show_more{ ushort(8147) };
inline constexpr phrase<> lng_polls_votes_collapse{ ushort(8153) };
inline constexpr phrase<> lng_todo_title{ ushort(8154) };
inline constexpr phrase<> lng_todo_title_group{ ushort(8155) };
inline constexpr phrase<> lng_todo_title_user{ ushort(8156) };
inline constexpr phrase<lngtag_count, lngtag_total> lng_todo_completed{ ushort(8157) };
inline constexpr phrase<lngtag_total> lng_todo_completed_none{ ushort(8163) };
inline constexpr phrase<> lng_todo_menu_item{ ushort(8164) };
inline constexpr phrase<> lng_todo_create{ ushort(8165) };
inline constexpr phrase<> lng_todo_create_title{ ushort(8166) };
inline constexpr phrase<> lng_todo_create_title_placeholder{ ushort(8167) };
inline constexpr phrase<> lng_todo_create_list{ ushort(8168) };
inline constexpr phrase<> lng_todo_create_list_add{ ushort(8169) };
inline constexpr phrase<lngtag_count> lng_todo_create_limit{ ushort(8170) };
inline constexpr phrase<> lng_todo_create_maximum{ ushort(8176) };
inline constexpr phrase<> lng_todo_create_settings{ ushort(8177) };
inline constexpr phrase<> lng_todo_create_allow_add{ ushort(8178) };
inline constexpr phrase<> lng_todo_create_allow_mark{ ushort(8179) };
inline constexpr phrase<> lng_todo_create_button{ ushort(8180) };
inline constexpr phrase<> lng_todo_choose_title{ ushort(8181) };
inline constexpr phrase<> lng_todo_choose_tasks{ ushort(8182) };
inline constexpr phrase<> lng_todo_add_title{ ushort(8183) };
inline constexpr phrase<lngtag_link> lng_todo_create_premium{ ushort(8184) };
inline constexpr phrase<lngtag_link> lng_todo_add_premium{ ushort(8185) };
inline constexpr phrase<lngtag_link> lng_todo_mark_premium{ ushort(8186) };
inline constexpr phrase<> lng_todo_premium_link{ ushort(8187) };
inline constexpr phrase<lngtag_user> lng_todo_mark_restricted{ ushort(8188) };
inline constexpr phrase<> lng_todo_mark_forwarded{ ushort(8189) };
inline constexpr phrase<> lng_outdated_title{ ushort(8190) };
inline constexpr phrase<> lng_outdated_title_bits{ ushort(8191) };
inline constexpr phrase<lngtag_date> lng_outdated_soon{ ushort(8192) };
inline constexpr phrase<> lng_outdated_now{ ushort(8193) };
inline constexpr phrase<> lng_filters_all{ ushort(8194) };
inline constexpr phrase<> lng_filters_all_short{ ushort(8195) };
inline constexpr phrase<> lng_filters_setup{ ushort(8196) };
inline constexpr phrase<> lng_filters_title{ ushort(8197) };
inline constexpr phrase<> lng_filters_subtitle{ ushort(8198) };
inline constexpr phrase<> lng_filters_no_chats{ ushort(8199) };
inline constexpr phrase<lngtag_count> lng_filters_chats_count{ ushort(8200) };
inline constexpr phrase<> lng_filters_create{ ushort(8206) };
inline constexpr phrase<> lng_filters_about{ ushort(8207) };
inline constexpr phrase<> lng_filters_recommended{ ushort(8208) };
inline constexpr phrase<> lng_filters_recommended_add{ ushort(8209) };
inline constexpr phrase<> lng_filters_restore{ ushort(8210) };
inline constexpr phrase<> lng_filters_new{ ushort(8211) };
inline constexpr phrase<> lng_filters_edit{ ushort(8212) };
inline constexpr phrase<> lng_filters_setup_menu{ ushort(8213) };
inline constexpr phrase<> lng_filters_new_name{ ushort(8214) };
inline constexpr phrase<> lng_filters_enable_animations{ ushort(8215) };
inline constexpr phrase<> lng_filters_disable_animations{ ushort(8216) };
inline constexpr phrase<> lng_filters_add_chats{ ushort(8217) };
inline constexpr phrase<> lng_filters_remove_chats{ ushort(8218) };
inline constexpr phrase<> lng_filters_include{ ushort(8219) };
inline constexpr phrase<> lng_filters_include_about{ ushort(8220) };
inline constexpr phrase<> lng_filters_exclude{ ushort(8221) };
inline constexpr phrase<> lng_filters_exclude_about{ ushort(8222) };
inline constexpr phrase<> lng_filters_create_button{ ushort(8223) };
inline constexpr phrase<> lng_filters_include_title{ ushort(8224) };
inline constexpr phrase<> lng_filters_exclude_title{ ushort(8225) };
inline constexpr phrase<> lng_filters_edit_types{ ushort(8226) };
inline constexpr phrase<> lng_filters_edit_chats{ ushort(8227) };
inline constexpr phrase<> lng_filters_include_contacts{ ushort(8228) };
inline constexpr phrase<> lng_filters_include_groups{ ushort(8229) };
inline constexpr phrase<> lng_filters_include_channels{ ushort(8230) };
inline constexpr phrase<> lng_filters_include_bots{ ushort(8231) };
inline constexpr phrase<> lng_filters_name_people{ ushort(8232) };
inline constexpr phrase<> lng_filters_name_unread{ ushort(8233) };
inline constexpr phrase<> lng_filters_name_unmuted{ ushort(8234) };
inline constexpr phrase<> lng_filters_empty{ ushort(8235) };
inline constexpr phrase<> lng_filters_default{ ushort(8236) };
inline constexpr phrase<> lng_filters_type_contacts{ ushort(8237) };
inline constexpr phrase<> lng_filters_type_non_contacts{ ushort(8238) };
inline constexpr phrase<> lng_filters_type_groups{ ushort(8239) };
inline constexpr phrase<> lng_filters_type_channels{ ushort(8240) };
inline constexpr phrase<> lng_filters_type_new{ ushort(8241) };
inline constexpr phrase<> lng_filters_type_existing{ ushort(8242) };
inline constexpr phrase<> lng_filters_type_bots{ ushort(8243) };
inline constexpr phrase<> lng_filters_type_no_archived{ ushort(8244) };
inline constexpr phrase<> lng_filters_type_no_muted{ ushort(8245) };
inline constexpr phrase<> lng_filters_type_no_read{ ushort(8246) };
inline constexpr phrase<> lng_filters_icon_header{ ushort(8247) };
inline constexpr phrase<> lng_filters_context_edit{ ushort(8248) };
inline constexpr phrase<> lng_filters_context_remove{ ushort(8249) };
inline constexpr phrase<> lng_filters_remove_sure{ ushort(8250) };
inline constexpr phrase<> lng_filters_remove_yes{ ushort(8251) };
inline constexpr phrase<> lng_filters_menu_add{ ushort(8252) };
inline constexpr phrase<lngtag_chat, lngtag_folder> lng_filters_toast_add{ ushort(8253) };
inline constexpr phrase<lngtag_chat, lngtag_folder> lng_filters_toast_remove{ ushort(8254) };
inline constexpr phrase<> lng_filters_shareable_status{ ushort(8255) };
inline constexpr phrase<> lng_filters_view_subtitle{ ushort(8256) };
inline constexpr phrase<> lng_filters_vertical{ ushort(8257) };
inline constexpr phrase<> lng_filters_horizontal{ ushort(8258) };
inline constexpr phrase<> lng_filters_enable_tags{ ushort(8259) };
inline constexpr phrase<> lng_filters_enable_tags_about{ ushort(8260) };
inline constexpr phrase<lngtag_link> lng_filters_enable_tags_about_premium{ ushort(8261) };
inline constexpr phrase<> lng_filters_tag_color_subtitle{ ushort(8262) };
inline constexpr phrase<> lng_filters_tag_color_about{ ushort(8263) };
inline constexpr phrase<> lng_filters_tag_color_no{ ushort(8264) };
inline constexpr phrase<> lng_filters_delete_sure{ ushort(8265) };
inline constexpr phrase<> lng_filters_link{ ushort(8266) };
inline constexpr phrase<> lng_filters_link_has{ ushort(8267) };
inline constexpr phrase<> lng_filters_checkbox_remove_bot{ ushort(8268) };
inline constexpr phrase<> lng_filters_checkbox_remove_group{ ushort(8269) };
inline constexpr phrase<> lng_filters_checkbox_remove_channel{ ushort(8270) };
inline constexpr phrase<> lng_filters_link_create{ ushort(8271) };
inline constexpr phrase<> lng_filters_link_cant{ ushort(8272) };
inline constexpr phrase<> lng_filters_link_about{ ushort(8273) };
inline constexpr phrase<> lng_filters_link_about_many{ ushort(8274) };
inline constexpr phrase<> lng_filters_link_title{ ushort(8275) };
inline constexpr phrase<lngtag_folder> lng_filters_link_share_about{ ushort(8276) };
inline constexpr phrase<> lng_filters_link_subtitle{ ushort(8277) };
inline constexpr phrase<> lng_filters_link_chats_none{ ushort(8278) };
inline constexpr phrase<lngtag_count> lng_filters_link_chats{ ushort(8279) };
inline constexpr phrase<> lng_filters_link_bot_status{ ushort(8285) };
inline constexpr phrase<> lng_filters_link_bot_error{ ushort(8286) };
inline constexpr phrase<> lng_filters_link_private_status{ ushort(8287) };
inline constexpr phrase<> lng_filters_link_private_error{ ushort(8288) };
inline constexpr phrase<> lng_filters_link_noadmin_status{ ushort(8289) };
inline constexpr phrase<> lng_filters_link_noadmin_group_error{ ushort(8290) };
inline constexpr phrase<> lng_filters_link_noadmin_channel_error{ ushort(8291) };
inline constexpr phrase<> lng_filters_link_already_group{ ushort(8292) };
inline constexpr phrase<> lng_filters_link_already_channel{ ushort(8293) };
inline constexpr phrase<> lng_filters_link_inaccessible{ ushort(8294) };
inline constexpr phrase<> lng_filters_link_chats_about{ ushort(8295) };
inline constexpr phrase<> lng_filters_link_no_about{ ushort(8296) };
inline constexpr phrase<> lng_filters_link_chats_no{ ushort(8297) };
inline constexpr phrase<> lng_filters_link_chats_no_about{ ushort(8298) };
inline constexpr phrase<> lng_filters_link_name_it{ ushort(8299) };
inline constexpr phrase<> lng_filters_link_delete_sure{ ushort(8300) };
inline constexpr phrase<> lng_filters_link_qr_about{ ushort(8301) };
inline constexpr phrase<> lng_filters_link_group_admin_error{ ushort(8302) };
inline constexpr phrase<> lng_filters_by_link_title{ ushort(8303) };
inline constexpr phrase<lngtag_folder> lng_filters_by_link_sure{ ushort(8304) };
inline constexpr phrase<lngtag_count> lng_filters_by_link_join{ ushort(8305) };
inline constexpr phrase<lngtag_folder> lng_filters_by_link_add_button{ ushort(8311) };
inline constexpr phrase<> lng_filters_by_link_add_no{ ushort(8312) };
inline constexpr phrase<> lng_filters_by_link_more{ ushort(8313) };
inline constexpr phrase<lngtag_folder> lng_filters_by_link_more_sure{ ushort(8314) };
inline constexpr phrase<> lng_filters_by_link_about{ ushort(8315) };
inline constexpr phrase<lngtag_count> lng_filters_by_link_and_join_button{ ushort(8316) };
inline constexpr phrase<> lng_filters_by_link_join_no{ ushort(8322) };
inline constexpr phrase<> lng_filters_by_link_already{ ushort(8323) };
inline constexpr phrase<lngtag_folder> lng_filters_by_link_already_about{ ushort(8324) };
inline constexpr phrase<lngtag_count> lng_filters_by_link_in{ ushort(8325) };
inline constexpr phrase<> lng_filters_by_link_remove{ ushort(8331) };
inline constexpr phrase<lngtag_folder> lng_filters_by_link_remove_sure{ ushort(8332) };
inline constexpr phrase<lngtag_count> lng_filters_by_link_quit{ ushort(8333) };
inline constexpr phrase<> lng_filters_by_link_select{ ushort(8339) };
inline constexpr phrase<> lng_filters_by_link_deselect{ ushort(8340) };
inline constexpr phrase<> lng_filters_by_link_about_quit{ ushort(8341) };
inline constexpr phrase<> lng_filters_by_link_remove_button{ ushort(8342) };
inline constexpr phrase<lngtag_count> lng_filters_by_link_and_quit_button{ ushort(8343) };
inline constexpr phrase<lngtag_folder> lng_filters_added_title{ ushort(8349) };
inline constexpr phrase<lngtag_count> lng_filters_added_also{ ushort(8350) };
inline constexpr phrase<lngtag_folder> lng_filters_updated_title{ ushort(8356) };
inline constexpr phrase<lngtag_count> lng_filters_updated_also{ ushort(8357) };
inline constexpr phrase<lngtag_count> lng_filters_bar_you_can{ ushort(8363) };
inline constexpr phrase<lngtag_count> lng_filters_bar_view{ ushort(8369) };
inline constexpr phrase<> lng_chat_theme_change{ ushort(8375) };
inline constexpr phrase<> lng_chat_theme_wallpaper{ ushort(8376) };
inline constexpr phrase<> lng_chat_theme_none{ ushort(8377) };
inline constexpr phrase<> lng_chat_theme_apply{ ushort(8378) };
inline constexpr phrase<> lng_chat_theme_change_wallpaper{ ushort(8379) };
inline constexpr phrase<> lng_chat_theme_title{ ushort(8380) };
inline constexpr phrase<> lng_chat_theme_cant_voice{ ushort(8381) };
inline constexpr phrase<lngtag_name> lng_chat_theme_gift_replace{ ushort(8382) };
inline constexpr phrase<> lng_photo_editor_menu_delete{ ushort(8383) };
inline constexpr phrase<> lng_photo_editor_menu_flip{ ushort(8384) };
inline constexpr phrase<> lng_photo_editor_menu_duplicate{ ushort(8385) };
inline constexpr phrase<> lng_voice_speed_slow{ ushort(8386) };
inline constexpr phrase<> lng_voice_speed_normal{ ushort(8387) };
inline constexpr phrase<> lng_voice_speed_medium{ ushort(8388) };
inline constexpr phrase<> lng_voice_speed_fast{ ushort(8389) };
inline constexpr phrase<> lng_voice_speed_very_fast{ ushort(8390) };
inline constexpr phrase<> lng_voice_speed_super_fast{ ushort(8391) };
inline constexpr phrase<> lng_view_button_user{ ushort(8392) };
inline constexpr phrase<> lng_view_button_bot{ ushort(8393) };
inline constexpr phrase<> lng_view_button_group{ ushort(8394) };
inline constexpr phrase<> lng_view_button_channel{ ushort(8395) };
inline constexpr phrase<> lng_view_button_bot_app{ ushort(8396) };
inline constexpr phrase<> lng_view_button_background{ ushort(8397) };
inline constexpr phrase<> lng_view_button_theme{ ushort(8398) };
inline constexpr phrase<> lng_view_button_message{ ushort(8399) };
inline constexpr phrase<> lng_view_button_story{ ushort(8400) };
inline constexpr phrase<> lng_view_button_voice_chat{ ushort(8401) };
inline constexpr phrase<> lng_view_button_voice_chat_channel{ ushort(8402) };
inline constexpr phrase<> lng_view_button_request_join{ ushort(8403) };
inline constexpr phrase<> lng_view_button_external_link{ ushort(8404) };
inline constexpr phrase<> lng_view_button_boost{ ushort(8405) };
inline constexpr phrase<> lng_view_button_giftcode{ ushort(8406) };
inline constexpr phrase<> lng_view_button_iv{ ushort(8407) };
inline constexpr phrase<> lng_view_button_stickerset{ ushort(8408) };
inline constexpr phrase<> lng_view_button_emojipack{ ushort(8409) };
inline constexpr phrase<> lng_view_button_collectible{ ushort(8410) };
inline constexpr phrase<> lng_view_button_call{ ushort(8411) };
inline constexpr phrase<> lng_view_button_storyalbum{ ushort(8412) };
inline constexpr phrase<> lng_view_button_collection{ ushort(8413) };
inline constexpr phrase<> lng_sponsored_hide_ads{ ushort(8414) };
inline constexpr phrase<> lng_sponsored_title{ ushort(8415) };
inline constexpr phrase<lngtag_link> lng_sponsored_info_description1_linked{ ushort(8416) };
inline constexpr phrase<> lng_sponsored_info_description1_link{ ushort(8417) };
inline constexpr phrase<> lng_sponsored_info_description1_url{ ushort(8418) };
inline constexpr phrase<> lng_sponsored_info_description2{ ushort(8419) };
inline constexpr phrase<> lng_sponsored_info_menu{ ushort(8420) };
inline constexpr phrase<lngtag_text> lng_sponsored_info_submenu{ ushort(8421) };
inline constexpr phrase<> lng_sponsored_menu_revenued_about{ ushort(8422) };
inline constexpr phrase<> lng_sponsored_menu_revenued_report{ ushort(8423) };
inline constexpr phrase<> lng_sponsored_revenued_subtitle{ ushort(8424) };
inline constexpr phrase<> lng_sponsored_revenued_info1_title{ ushort(8425) };
inline constexpr phrase<> lng_sponsored_revenued_info1_description{ ushort(8426) };
inline constexpr phrase<> lng_sponsored_revenued_info1_bot_description{ ushort(8427) };
inline constexpr phrase<> lng_sponsored_revenued_info1_search_description{ ushort(8428) };
inline constexpr phrase<> lng_sponsored_revenued_info2_title{ ushort(8429) };
inline constexpr phrase<> lng_sponsored_revenued_info2_bot_title{ ushort(8430) };
inline constexpr phrase<> lng_sponsored_revenued_info2_description{ ushort(8431) };
inline constexpr phrase<> lng_sponsored_revenued_info2_bot_description{ ushort(8432) };
inline constexpr phrase<> lng_sponsored_revenued_info3_title{ ushort(8433) };
inline constexpr phrase<lngtag_count, lngtag_link> lng_sponsored_revenued_info3_description{ ushort(8434) };
inline constexpr phrase<lngtag_link> lng_sponsored_revenued_info3_bot_description{ ushort(8440) };
inline constexpr phrase<lngtag_link> lng_sponsored_revenued_info3_search_description{ ushort(8441) };
inline constexpr phrase<lngtag_arrow> lng_sponsored_revenued_info3_search_link{ ushort(8442) };
inline constexpr phrase<> lng_sponsored_revenued_footer_title{ ushort(8443) };
inline constexpr phrase<lngtag_link> lng_sponsored_revenued_footer_description{ ushort(8444) };
inline constexpr phrase<lngtag_link> lng_sponsored_revenued_footer_bot_description{ ushort(8445) };
inline constexpr phrase<lngtag_link> lng_sponsored_revenued_footer_search_description{ ushort(8446) };
inline constexpr phrase<> lng_sponsored_top_bar_hide{ ushort(8447) };
inline constexpr phrase<> lng_telegram_features_url{ ushort(8448) };
inline constexpr phrase<> lng_mini_apps_disclaimer_title{ ushort(8449) };
inline constexpr phrase<> lng_mini_apps_disclaimer_text{ ushort(8450) };
inline constexpr phrase<lngtag_link> lng_mini_apps_disclaimer_button{ ushort(8451) };
inline constexpr phrase<> lng_mini_apps_disclaimer_link{ ushort(8452) };
inline constexpr phrase<> lng_mini_apps_tos_url{ ushort(8453) };
inline constexpr phrase<> lng_ringtones_box_title{ ushort(8454) };
inline constexpr phrase<> lng_ringtones_box_cloud_subtitle{ ushort(8455) };
inline constexpr phrase<> lng_ringtones_box_volume{ ushort(8456) };
inline constexpr phrase<> lng_ringtones_box_upload_choose{ ushort(8457) };
inline constexpr phrase<> lng_ringtones_box_upload_button{ ushort(8458) };
inline constexpr phrase<> lng_ringtones_box_about{ ushort(8459) };
inline constexpr phrase<> lng_ringtones_box_default{ ushort(8460) };
inline constexpr phrase<> lng_ringtones_box_no_sound{ ushort(8461) };
inline constexpr phrase<> lng_ringtones_toast_added{ ushort(8462) };
inline constexpr phrase<lngtag_size> lng_ringtones_error_max_size{ ushort(8463) };
inline constexpr phrase<lngtag_duration> lng_ringtones_error_max_duration{ ushort(8464) };
inline constexpr phrase<> lng_bot_thread_edit{ ushort(8465) };
inline constexpr phrase<> lng_bot_thread_title{ ushort(8466) };
inline constexpr phrase<> lng_bot_thread_choose_title_and_icon{ ushort(8467) };
inline constexpr phrase<> lng_forum_topic_new{ ushort(8468) };
inline constexpr phrase<> lng_forum_topic_edit{ ushort(8469) };
inline constexpr phrase<> lng_forum_topic_title{ ushort(8470) };
inline constexpr phrase<> lng_forum_topic_close{ ushort(8471) };
inline constexpr phrase<> lng_forum_topic_reopen{ ushort(8472) };
inline constexpr phrase<> lng_forum_topic_closed{ ushort(8473) };
inline constexpr phrase<> lng_forum_topic_delete{ ushort(8474) };
inline constexpr phrase<> lng_forum_topic_delete_sure{ ushort(8475) };
inline constexpr phrase<> lng_forum_topic_created_title_my{ ushort(8476) };
inline constexpr phrase<> lng_forum_topic_created_body_my{ ushort(8477) };
inline constexpr phrase<> lng_forum_topic_created_title{ ushort(8478) };
inline constexpr phrase<> lng_forum_topic_created_body{ ushort(8479) };
inline constexpr phrase<> lng_forum_topics_switch{ ushort(8480) };
inline constexpr phrase<lngtag_count> lng_forum_topics_not_enough{ ushort(8481) };
inline constexpr phrase<> lng_forum_topics_no_discussion{ ushort(8487) };
inline constexpr phrase<> lng_forum_choose_title_and_icon{ ushort(8488) };
inline constexpr phrase<> lng_forum_replies_only{ ushort(8489) };
inline constexpr phrase<lngtag_topic> lng_forum_message_in{ ushort(8490) };
inline constexpr phrase<lngtag_topic> lng_forum_reply_in{ ushort(8491) };
inline constexpr phrase<> lng_forum_no_topics{ ushort(8492) };
inline constexpr phrase<> lng_forum_create_topic{ ushort(8493) };
inline constexpr phrase<> lng_forum_discard_sure{ ushort(8494) };
inline constexpr phrase<> lng_forum_view_as_messages{ ushort(8495) };
inline constexpr phrase<> lng_forum_view_as_topics{ ushort(8496) };
inline constexpr phrase<> lng_forum_no_messages{ ushort(8497) };
inline constexpr phrase<lngtag_count> lng_forum_messages{ ushort(8498) };
inline constexpr phrase<> lng_forum_show_topics_list{ ushort(8504) };
inline constexpr phrase<> lng_monoforum_choose_to_reply{ ushort(8505) };
inline constexpr phrase<> lng_request_peer_requirements{ ushort(8506) };
inline constexpr phrase<lngtag_rights> lng_request_peer_rights{ ushort(8507) };
inline constexpr phrase<lngtag_rights, lngtag_last> lng_request_peer_rights_and{ ushort(8508) };
inline constexpr phrase<lngtag_chat, lngtag_bot> lng_request_peer_confirm{ ushort(8509) };
inline constexpr phrase<lngtag_bot, lngtag_chat> lng_request_peer_confirm_add{ ushort(8510) };
inline constexpr phrase<lngtag_bot, lngtag_chat, lngtag_rights> lng_request_peer_confirm_rights{ ushort(8511) };
inline constexpr phrase<> lng_request_peer_confirm_send{ ushort(8512) };
inline constexpr phrase<> lng_request_user_title{ ushort(8513) };
inline constexpr phrase<> lng_request_users_title{ ushort(8514) };
inline constexpr phrase<> lng_request_user_premium_yes{ ushort(8515) };
inline constexpr phrase<> lng_request_user_premium_no{ ushort(8516) };
inline constexpr phrase<> lng_request_user_no{ ushort(8517) };
inline constexpr phrase<> lng_request_user_no_about{ ushort(8518) };
inline constexpr phrase<> lng_request_bot_title{ ushort(8519) };
inline constexpr phrase<> lng_request_bot_no{ ushort(8520) };
inline constexpr phrase<> lng_request_bot_no_about{ ushort(8521) };
inline constexpr phrase<> lng_request_group_title{ ushort(8522) };
inline constexpr phrase<> lng_request_group_no{ ushort(8523) };
inline constexpr phrase<> lng_request_group_no_about{ ushort(8524) };
inline constexpr phrase<> lng_request_group_public_yes{ ushort(8525) };
inline constexpr phrase<> lng_request_group_public_no{ ushort(8526) };
inline constexpr phrase<> lng_request_group_topics_yes{ ushort(8527) };
inline constexpr phrase<> lng_request_group_topics_no{ ushort(8528) };
inline constexpr phrase<> lng_request_group_am_owner{ ushort(8529) };
inline constexpr phrase<> lng_request_group_change_info{ ushort(8530) };
inline constexpr phrase<> lng_request_group_delete_messages{ ushort(8531) };
inline constexpr phrase<> lng_request_group_ban_users{ ushort(8532) };
inline constexpr phrase<> lng_request_group_invite{ ushort(8533) };
inline constexpr phrase<> lng_request_group_pin_messages{ ushort(8534) };
inline constexpr phrase<> lng_request_group_manage_topics{ ushort(8535) };
inline constexpr phrase<> lng_request_group_manage_video_chats{ ushort(8536) };
inline constexpr phrase<> lng_request_group_anonymous{ ushort(8537) };
inline constexpr phrase<> lng_request_group_add_admins{ ushort(8538) };
inline constexpr phrase<> lng_request_group_create{ ushort(8539) };
inline constexpr phrase<> lng_request_channel_title{ ushort(8540) };
inline constexpr phrase<> lng_request_channel_no{ ushort(8541) };
inline constexpr phrase<> lng_request_channel_no_about{ ushort(8542) };
inline constexpr phrase<> lng_request_channel_public_yes{ ushort(8543) };
inline constexpr phrase<> lng_request_channel_public_no{ ushort(8544) };
inline constexpr phrase<> lng_request_channel_am_owner{ ushort(8545) };
inline constexpr phrase<> lng_request_channel_change_info{ ushort(8546) };
inline constexpr phrase<> lng_request_channel_post_messages{ ushort(8547) };
inline constexpr phrase<> lng_request_channel_edit_messages{ ushort(8548) };
inline constexpr phrase<> lng_request_channel_delete_messages{ ushort(8549) };
inline constexpr phrase<> lng_request_channel_add_subscribers{ ushort(8550) };
inline constexpr phrase<> lng_request_channel_manage_livestreams{ ushort(8551) };
inline constexpr phrase<> lng_request_channel_manage_direct{ ushort(8552) };
inline constexpr phrase<> lng_request_channel_add_admins{ ushort(8553) };
inline constexpr phrase<> lng_request_channel_create{ ushort(8554) };
inline constexpr phrase<> lng_userpic_builder_color_subtitle{ ushort(8555) };
inline constexpr phrase<> lng_userpic_builder_emoji_subtitle{ ushort(8556) };
inline constexpr phrase<> lng_stories_my_name{ ushort(8557) };
inline constexpr phrase<> lng_stories_archive{ ushort(8558) };
inline constexpr phrase<> lng_stories_unarchive{ ushort(8559) };
inline constexpr phrase<> lng_stories_view_anonymously{ ushort(8560) };
inline constexpr phrase<lngtag_count> lng_stories_row_count{ ushort(8561) };
inline constexpr phrase<lngtag_count> lng_stories_views{ ushort(8567) };
inline constexpr phrase<> lng_stories_no_views{ ushort(8573) };
inline constexpr phrase<> lng_stories_view_reactions{ ushort(8574) };
inline constexpr phrase<> lng_stories_unsupported{ ushort(8575) };
inline constexpr phrase<> lng_stories_cant_reply{ ushort(8576) };
inline constexpr phrase<> lng_stories_about_silent{ ushort(8577) };
inline constexpr phrase<lngtag_user> lng_stories_about_close_friends{ ushort(8578) };
inline constexpr phrase<lngtag_user> lng_stories_about_contacts{ ushort(8579) };
inline constexpr phrase<lngtag_user> lng_stories_about_selected_contacts{ ushort(8580) };
inline constexpr phrase<> lng_stories_about_close_friends_my{ ushort(8581) };
inline constexpr phrase<> lng_stories_about_contacts_my{ ushort(8582) };
inline constexpr phrase<> lng_stories_about_selected_contacts_my{ ushort(8583) };
inline constexpr phrase<> lng_stories_click_to_view_mine{ ushort(8584) };
inline constexpr phrase<lngtag_users> lng_stories_click_to_view{ ushort(8585) };
inline constexpr phrase<lngtag_accumulated, lngtag_user> lng_stories_click_to_view_and_one{ ushort(8586) };
inline constexpr phrase<lngtag_accumulated, lngtag_user> lng_stories_click_to_view_and_last{ ushort(8587) };
inline constexpr phrase<> lng_stories_show_more{ ushort(8588) };
inline constexpr phrase<> lng_stories_my_title{ ushort(8589) };
inline constexpr phrase<> lng_stories_archive_button{ ushort(8590) };
inline constexpr phrase<> lng_stories_recent_button{ ushort(8591) };
inline constexpr phrase<> lng_stories_archive_title{ ushort(8592) };
inline constexpr phrase<> lng_stories_archive_about{ ushort(8593) };
inline constexpr phrase<> lng_stories_channel_archive_about{ ushort(8594) };
inline constexpr phrase<> lng_stories_empty{ ushort(8595) };
inline constexpr phrase<> lng_stories_empty_channel{ ushort(8596) };
inline constexpr phrase<> lng_stories_reply_sent{ ushort(8597) };
inline constexpr phrase<lngtag_user> lng_stories_hidden_to_contacts{ ushort(8598) };
inline constexpr phrase<lngtag_user> lng_stories_shown_in_chats{ ushort(8599) };
inline constexpr phrase<> lng_stories_delete_one_sure{ ushort(8600) };
inline constexpr phrase<lngtag_count> lng_stories_delete_sure{ ushort(8601) };
inline constexpr phrase<> lng_stories_save_sure{ ushort(8607) };
inline constexpr phrase<lngtag_count> lng_stories_save_sure_many{ ushort(8608) };
inline constexpr phrase<> lng_stories_save_done{ ushort(8614) };
inline constexpr phrase<lngtag_count> lng_stories_save_done_many{ ushort(8615) };
inline constexpr phrase<> lng_stories_save_done_about{ ushort(8621) };
inline constexpr phrase<> lng_stories_archive_sure{ ushort(8622) };
inline constexpr phrase<lngtag_count> lng_stories_archive_sure_many{ ushort(8623) };
inline constexpr phrase<> lng_stories_archive_done{ ushort(8629) };
inline constexpr phrase<lngtag_count> lng_stories_archive_done_many{ ushort(8630) };
inline constexpr phrase<> lng_stories_channel_save_sure{ ushort(8636) };
inline constexpr phrase<lngtag_count> lng_stories_channel_save_sure_many{ ushort(8637) };
inline constexpr phrase<> lng_stories_channel_save_done{ ushort(8643) };
inline constexpr phrase<lngtag_count> lng_stories_channel_save_done_many{ ushort(8644) };
inline constexpr phrase<> lng_stories_channel_save_done_about{ ushort(8650) };
inline constexpr phrase<> lng_stories_channel_archive_sure{ ushort(8651) };
inline constexpr phrase<lngtag_count> lng_stories_channel_archive_sure_many{ ushort(8652) };
inline constexpr phrase<> lng_stories_channel_archive_done{ ushort(8658) };
inline constexpr phrase<lngtag_count> lng_stories_channel_archive_done_many{ ushort(8659) };
inline constexpr phrase<lngtag_link> lng_stories_save_promo{ ushort(8665) };
inline constexpr phrase<> lng_stories_reaction_as_message{ ushort(8666) };
inline constexpr phrase<> lng_stories_album_add{ ushort(8667) };
inline constexpr phrase<> lng_stories_album_new_title{ ushort(8668) };
inline constexpr phrase<> lng_stories_album_new_button{ ushort(8669) };
inline constexpr phrase<> lng_stories_album_new_text{ ushort(8670) };
inline constexpr phrase<> lng_stories_album_new_ph{ ushort(8671) };
inline constexpr phrase<> lng_stories_album_new_create{ ushort(8672) };
inline constexpr phrase<> lng_stories_album_empty_title{ ushort(8673) };
inline constexpr phrase<> lng_stories_album_empty_text{ ushort(8674) };
inline constexpr phrase<> lng_stories_album_all{ ushort(8675) };
inline constexpr phrase<> lng_stories_album_add_title{ ushort(8676) };
inline constexpr phrase<> lng_stories_album_add_button{ ushort(8677) };
inline constexpr phrase<> lng_stories_album_share{ ushort(8678) };
inline constexpr phrase<> lng_stories_album_edit{ ushort(8679) };
inline constexpr phrase<> lng_stories_album_limit_title{ ushort(8680) };
inline constexpr phrase<> lng_stories_album_limit_text{ ushort(8681) };
inline constexpr phrase<> lng_stories_album_delete{ ushort(8682) };
inline constexpr phrase<> lng_stories_album_delete_sure{ ushort(8683) };
inline constexpr phrase<> lng_stories_album_delete_button{ ushort(8684) };
inline constexpr phrase<> lng_stories_album_add_to{ ushort(8685) };
inline constexpr phrase<> lng_stealth_mode_menu_item{ ushort(8686) };
inline constexpr phrase<> lng_stealth_mode_title{ ushort(8687) };
inline constexpr phrase<> lng_stealth_mode_unlock_about{ ushort(8688) };
inline constexpr phrase<> lng_stealth_mode_about{ ushort(8689) };
inline constexpr phrase<> lng_stealth_mode_past_title{ ushort(8690) };
inline constexpr phrase<> lng_stealth_mode_past_about{ ushort(8691) };
inline constexpr phrase<> lng_stealth_mode_next_title{ ushort(8692) };
inline constexpr phrase<> lng_stealth_mode_next_about{ ushort(8693) };
inline constexpr phrase<> lng_stealth_mode_unlock{ ushort(8694) };
inline constexpr phrase<> lng_stealth_mode_enable{ ushort(8695) };
inline constexpr phrase<> lng_stealth_mode_enable_and_open{ ushort(8696) };
inline constexpr phrase<lngtag_left> lng_stealth_mode_cooldown_in{ ushort(8697) };
inline constexpr phrase<> lng_stealth_mode_cooldown_tip{ ushort(8698) };
inline constexpr phrase<> lng_stealth_mode_enabled_tip_title{ ushort(8699) };
inline constexpr phrase<> lng_stealth_mode_enabled_tip{ ushort(8700) };
inline constexpr phrase<lngtag_left> lng_stealth_mode_countdown{ ushort(8701) };
inline constexpr phrase<> lng_stealth_mode_already_title{ ushort(8702) };
inline constexpr phrase<lngtag_left> lng_stealth_mode_already_about{ ushort(8703) };
inline constexpr phrase<> lng_stories_link_invalid{ ushort(8704) };
inline constexpr phrase<> lng_stories_live_finished{ ushort(8705) };
inline constexpr phrase<> lng_stats_title{ ushort(8706) };
inline constexpr phrase<> lng_stats_message_title{ ushort(8707) };
inline constexpr phrase<> lng_stats_story_title{ ushort(8708) };
inline constexpr phrase<> lng_stats_zoom_out{ ushort(8709) };
inline constexpr phrase<lngtag_days_count, lngtag_month, lngtag_year> lng_stats_day_month_year{ ushort(8710) };
inline constexpr phrase<lngtag_days_count, lngtag_month> lng_stats_day_month{ ushort(8711) };
inline constexpr phrase<lngtag_day, lngtag_days_count, lngtag_month, lngtag_year> lng_stats_weekday_day_month_year{ ushort(8712) };
inline constexpr phrase<lngtag_day, lngtag_days_count, lngtag_month, lngtag_time> lng_stats_weekday_day_month_time{ ushort(8713) };
inline constexpr phrase<> lng_stats_overview_title{ ushort(8714) };
inline constexpr phrase<> lng_stats_overview_member_count{ ushort(8715) };
inline constexpr phrase<> lng_stats_overview_mean_view_count{ ushort(8716) };
inline constexpr phrase<> lng_stats_overview_mean_share_count{ ushort(8717) };
inline constexpr phrase<> lng_stats_overview_mean_reactions_count{ ushort(8718) };
inline constexpr phrase<> lng_stats_overview_mean_story_view_count{ ushort(8719) };
inline constexpr phrase<> lng_stats_overview_mean_story_share_count{ ushort(8720) };
inline constexpr phrase<> lng_stats_overview_mean_story_reactions_count{ ushort(8721) };
inline constexpr phrase<> lng_stats_overview_enabled_notifications{ ushort(8722) };
inline constexpr phrase<> lng_stats_overview_messages{ ushort(8723) };
inline constexpr phrase<> lng_stats_overview_group_mean_view_count{ ushort(8724) };
inline constexpr phrase<> lng_stats_overview_group_mean_post_count{ ushort(8725) };
inline constexpr phrase<> lng_stats_overview_message_private_shares{ ushort(8726) };
inline constexpr phrase<> lng_stats_overview_message_public_shares{ ushort(8727) };
inline constexpr phrase<> lng_stats_overview_message_views{ ushort(8728) };
inline constexpr phrase<lngtag_count> lng_stats_overview_message_public_share{ ushort(8729) };
inline constexpr phrase<> lng_stats_members_title{ ushort(8735) };
inline constexpr phrase<> lng_stats_admins_title{ ushort(8736) };
inline constexpr phrase<> lng_stats_inviters_title{ ushort(8737) };
inline constexpr phrase<lngtag_count> lng_stats_member_messages{ ushort(8738) };
inline constexpr phrase<lngtag_count> lng_stats_member_characters{ ushort(8744) };
inline constexpr phrase<lngtag_count> lng_stats_member_deletions{ ushort(8750) };
inline constexpr phrase<lngtag_count> lng_stats_member_bans{ ushort(8756) };
inline constexpr phrase<lngtag_count> lng_stats_member_restrictions{ ushort(8762) };
inline constexpr phrase<lngtag_count> lng_stats_member_invitations{ ushort(8768) };
inline constexpr phrase<> lng_stats_recent_messages_title{ ushort(8774) };
inline constexpr phrase<lngtag_count> lng_stats_recent_messages_views{ ushort(8775) };
inline constexpr phrase<> lng_stats_loading{ ushort(8781) };
inline constexpr phrase<> lng_stats_loading_subtext{ ushort(8782) };
inline constexpr phrase<> lng_stats_boosts_loading{ ushort(8783) };
inline constexpr phrase<> lng_stats_boosts_loading_subtext{ ushort(8784) };
inline constexpr phrase<> lng_stats_earn_loading{ ushort(8785) };
inline constexpr phrase<> lng_stats_earn_loading_subtext{ ushort(8786) };
inline constexpr phrase<> lng_chart_title_member_count{ ushort(8787) };
inline constexpr phrase<> lng_chart_title_join{ ushort(8788) };
inline constexpr phrase<> lng_chart_title_mute{ ushort(8789) };
inline constexpr phrase<> lng_chart_title_view_count_by_hour{ ushort(8790) };
inline constexpr phrase<> lng_chart_title_view_count_by_source{ ushort(8791) };
inline constexpr phrase<> lng_chart_title_join_by_source{ ushort(8792) };
inline constexpr phrase<> lng_chart_title_language{ ushort(8793) };
inline constexpr phrase<> lng_chart_title_message_interaction{ ushort(8794) };
inline constexpr phrase<> lng_chart_title_instant_view_interaction{ ushort(8795) };
inline constexpr phrase<> lng_chart_title_reactions_by_emotion{ ushort(8796) };
inline constexpr phrase<> lng_chart_title_story_interactions{ ushort(8797) };
inline constexpr phrase<> lng_chart_title_story_reactions_by_emotion{ ushort(8798) };
inline constexpr phrase<> lng_chart_title_group_join{ ushort(8799) };
inline constexpr phrase<> lng_chart_title_group_join_by_source{ ushort(8800) };
inline constexpr phrase<> lng_chart_title_group_language{ ushort(8801) };
inline constexpr phrase<> lng_chart_title_group_message_content{ ushort(8802) };
inline constexpr phrase<> lng_chart_title_group_action{ ushort(8803) };
inline constexpr phrase<> lng_chart_title_group_day{ ushort(8804) };
inline constexpr phrase<> lng_chart_title_group_week{ ushort(8805) };
inline constexpr phrase<> lng_boosts_title{ ushort(8806) };
inline constexpr phrase<> lng_boosts_level{ ushort(8807) };
inline constexpr phrase<> lng_boosts_existing{ ushort(8808) };
inline constexpr phrase<> lng_boosts_premium_audience{ ushort(8809) };
inline constexpr phrase<> lng_boosts_premium_members{ ushort(8810) };
inline constexpr phrase<> lng_boosts_next_level{ ushort(8811) };
inline constexpr phrase<lngtag_count> lng_boosts_list_title{ ushort(8812) };
inline constexpr phrase<> lng_boosts_list_subtext{ ushort(8818) };
inline constexpr phrase<> lng_boosts_list_subtext_group{ ushort(8819) };
inline constexpr phrase<lngtag_count> lng_boosts_show_more_boosts{ ushort(8820) };
inline constexpr phrase<lngtag_count> lng_boosts_show_more_gifts{ ushort(8826) };
inline constexpr phrase<lngtag_date> lng_boosts_list_status{ ushort(8832) };
inline constexpr phrase<> lng_boosts_link_title{ ushort(8833) };
inline constexpr phrase<> lng_boosts_link_subtext{ ushort(8834) };
inline constexpr phrase<> lng_boosts_link_subtext_group{ ushort(8835) };
inline constexpr phrase<> lng_boosts_get_boosts{ ushort(8836) };
inline constexpr phrase<> lng_boosts_get_boosts_subtext{ ushort(8837) };
inline constexpr phrase<> lng_boosts_get_boosts_subtext_group{ ushort(8838) };
inline constexpr phrase<> lng_boosts_list_unclaimed{ ushort(8839) };
inline constexpr phrase<> lng_boosts_list_pending{ ushort(8840) };
inline constexpr phrase<> lng_boosts_list_pending_about{ ushort(8841) };
inline constexpr phrase<lngtag_count> lng_boosts_list_tab_gifts{ ushort(8842) };
inline constexpr phrase<> lng_boosts_prepaid_giveaway_title{ ushort(8848) };
inline constexpr phrase<> lng_boosts_prepaid_giveaway_title_subtext{ ushort(8849) };
inline constexpr phrase<> lng_boosts_prepaid_giveaway_single{ ushort(8850) };
inline constexpr phrase<lngtag_count> lng_boosts_prepaid_giveaway_quantity{ ushort(8851) };
inline constexpr phrase<lngtag_count> lng_boosts_prepaid_giveaway_moths{ ushort(8857) };
inline constexpr phrase<lngtag_count, lngtag_duration> lng_boosts_prepaid_giveaway_status{ ushort(8863) };
inline constexpr phrase<lngtag_count, lngtag_amount> lng_boosts_prepaid_giveaway_credits_status{ ushort(8869) };
inline constexpr phrase<> lng_channel_earn_title{ ushort(8875) };
inline constexpr phrase<lngtag_link> lng_channel_earn_about{ ushort(8876) };
inline constexpr phrase<lngtag_link> lng_channel_earn_about_bot{ ushort(8877) };
inline constexpr phrase<lngtag_emoji> lng_channel_earn_about_link{ ushort(8878) };
inline constexpr phrase<> lng_channel_earn_overview_title{ ushort(8879) };
inline constexpr phrase<> lng_channel_earn_available{ ushort(8880) };
inline constexpr phrase<> lng_channel_earn_reward{ ushort(8881) };
inline constexpr phrase<> lng_channel_earn_total{ ushort(8882) };
inline constexpr phrase<> lng_channel_earn_balance_title{ ushort(8883) };
inline constexpr phrase<> lng_channel_earn_balance_button{ ushort(8884) };
inline constexpr phrase<> lng_channel_earn_balance_password_title{ ushort(8885) };
inline constexpr phrase<> lng_channel_earn_balance_password_description{ ushort(8886) };
inline constexpr phrase<lngtag_link> lng_channel_earn_balance_about{ ushort(8887) };
inline constexpr phrase<lngtag_link> lng_channel_earn_balance_about_temp{ ushort(8888) };
inline constexpr phrase<> lng_channel_earn_transfer_sure_about1{ ushort(8889) };
inline constexpr phrase<> lng_channel_earn_transfer_sure_about2{ ushort(8890) };
inline constexpr phrase<> lng_channel_earn_history_title{ ushort(8891) };
inline constexpr phrase<> lng_channel_earn_history_in{ ushort(8892) };
inline constexpr phrase<> lng_channel_earn_history_in_about{ ushort(8893) };
inline constexpr phrase<> lng_channel_earn_history_out{ ushort(8894) };
inline constexpr phrase<> lng_channel_earn_history_out_failed{ ushort(8895) };
inline constexpr phrase<> lng_channel_earn_history_out_about_failed{ ushort(8896) };
inline constexpr phrase<> lng_channel_earn_history_out_button{ ushort(8897) };
inline constexpr phrase<> lng_channel_earn_history_return{ ushort(8898) };
inline constexpr phrase<> lng_channel_earn_history_return_about{ ushort(8899) };
inline constexpr phrase<> lng_channel_earn_history_pending{ ushort(8900) };
inline constexpr phrase<> lng_channel_earn_history_failed{ ushort(8901) };
inline constexpr phrase<lngtag_count> lng_channel_earn_history_show_more{ ushort(8902) };
inline constexpr phrase<> lng_channel_earn_off{ ushort(8908) };
inline constexpr phrase<> lng_channel_earn_off_about{ ushort(8909) };
inline constexpr phrase<> lng_channel_earn_cpm_min{ ushort(8910) };
inline constexpr phrase<lngtag_count, lngtag_emoji> lng_channel_earn_cpm{ ushort(8911) };
inline constexpr phrase<> lng_channel_earn_learn_title{ ushort(8917) };
inline constexpr phrase<> lng_channel_earn_bot_learn_title{ ushort(8918) };
inline constexpr phrase<> lng_channel_earn_learn_in_subtitle{ ushort(8919) };
inline constexpr phrase<> lng_channel_earn_learn_in_about{ ushort(8920) };
inline constexpr phrase<> lng_channel_earn_learn_bot_in_about{ ushort(8921) };
inline constexpr phrase<> lng_channel_earn_learn_split_subtitle{ ushort(8922) };
inline constexpr phrase<> lng_channel_earn_learn_split_about{ ushort(8923) };
inline constexpr phrase<> lng_channel_earn_learn_out_subtitle{ ushort(8924) };
inline constexpr phrase<> lng_channel_earn_learn_out_about{ ushort(8925) };
inline constexpr phrase<lngtag_emoji> lng_channel_earn_learn_coin_title{ ushort(8926) };
inline constexpr phrase<lngtag_link> lng_channel_earn_learn_coin_about{ ushort(8927) };
inline constexpr phrase<> lng_channel_earn_learn_close{ ushort(8928) };
inline constexpr phrase<> lng_channel_earn_learn_coin_link{ ushort(8929) };
inline constexpr phrase<> lng_channel_earn_chart_top_hours{ ushort(8930) };
inline constexpr phrase<> lng_channel_earn_chart_revenue{ ushort(8931) };
inline constexpr phrase<> lng_channel_earn_chart_overriden_detail_credits{ ushort(8932) };
inline constexpr phrase<> lng_channel_earn_chart_overriden_detail_currency{ ushort(8933) };
inline constexpr phrase<> lng_channel_earn_chart_overriden_detail_usd{ ushort(8934) };
inline constexpr phrase<> lng_channel_earn_currency_history{ ushort(8935) };
inline constexpr phrase<> lng_channel_earn_credits_history{ ushort(8936) };
inline constexpr phrase<> lng_channel_earn_out_check_password_about{ ushort(8937) };
inline constexpr phrase<> lng_bot_earn_title{ ushort(8938) };
inline constexpr phrase<> lng_bot_earn_chart_revenue{ ushort(8939) };
inline constexpr phrase<> lng_bot_earn_overview_title{ ushort(8940) };
inline constexpr phrase<> lng_bot_earn_available{ ushort(8941) };
inline constexpr phrase<> lng_bot_earn_reward{ ushort(8942) };
inline constexpr phrase<> lng_bot_earn_total{ ushort(8943) };
inline constexpr phrase<> lng_bot_earn_balance_title{ ushort(8944) };
inline constexpr phrase<> lng_bot_earn_balance_about{ ushort(8945) };
inline constexpr phrase<> lng_bot_earn_balance_about_url{ ushort(8946) };
inline constexpr phrase<lngtag_count, lngtag_emoji> lng_bot_earn_balance_button{ ushort(8947) };
inline constexpr phrase<> lng_bot_earn_balance_button_all{ ushort(8953) };
inline constexpr phrase<> lng_bot_earn_balance_button_locked{ ushort(8954) };
inline constexpr phrase<> lng_bot_earn_balance_button_buy_ads{ ushort(8955) };
inline constexpr phrase<lngtag_link> lng_bot_earn_learn_credits_out_about{ ushort(8956) };
inline constexpr phrase<lngtag_link> lng_self_earn_learn_credits_out_about{ ushort(8957) };
inline constexpr phrase<> lng_bot_earn_out_ph{ ushort(8958) };
inline constexpr phrase<lngtag_amount> lng_bot_earn_out_ph_max{ ushort(8959) };
inline constexpr phrase<> lng_bot_earn_balance_password_title{ ushort(8960) };
inline constexpr phrase<> lng_bot_earn_balance_password_description{ ushort(8961) };
inline constexpr phrase<lngtag_link> lng_bot_earn_credits_out_minimal{ ushort(8962) };
inline constexpr phrase<lngtag_count> lng_bot_earn_credits_out_minimal_link{ ushort(8963) };
inline constexpr phrase<lngtag_text> lng_bot_copy_text_tooltip{ ushort(8969) };
inline constexpr phrase<> lng_contact_add{ ushort(8970) };
inline constexpr phrase<> lng_contact_send_message{ ushort(8971) };
inline constexpr phrase<> lng_iv_open_in_browser{ ushort(8972) };
inline constexpr phrase<> lng_iv_share{ ushort(8973) };
inline constexpr phrase<> lng_iv_join_channel{ ushort(8974) };
inline constexpr phrase<> lng_iv_window_title{ ushort(8975) };
inline constexpr phrase<> lng_iv_wrong_layout{ ushort(8976) };
inline constexpr phrase<> lng_iv_not_supported{ ushort(8977) };
inline constexpr phrase<> lng_iv_zoom_tooltip_ctrl{ ushort(8978) };
inline constexpr phrase<> lng_iv_zoom_tooltip_cmd{ ushort(8979) };
inline constexpr phrase<> lng_limit_download_title{ ushort(8980) };
inline constexpr phrase<lngtag_link, lngtag_increase> lng_limit_download_subscribe{ ushort(8981) };
inline constexpr phrase<lngtag_count> lng_limit_download_increase_times{ ushort(8982) };
inline constexpr phrase<lngtag_percent> lng_limit_download_increase_speed{ ushort(8988) };
inline constexpr phrase<> lng_limit_download_subscribe_link{ ushort(8989) };
inline constexpr phrase<> lng_limit_upload_title{ ushort(8990) };
inline constexpr phrase<lngtag_link, lngtag_increase> lng_limit_upload_subscribe{ ushort(8991) };
inline constexpr phrase<lngtag_count> lng_limit_upload_increase_times{ ushort(8992) };
inline constexpr phrase<lngtag_percent> lng_limit_upload_increase_speed{ ushort(8998) };
inline constexpr phrase<> lng_limit_upload_subscribe_link{ ushort(8999) };
inline constexpr phrase<> lng_recent_frequent{ ushort(9000) };
inline constexpr phrase<> lng_recent_frequent_all{ ushort(9001) };
inline constexpr phrase<> lng_recent_frequent_collapse{ ushort(9002) };
inline constexpr phrase<> lng_recent_title{ ushort(9003) };
inline constexpr phrase<> lng_recent_clear{ ushort(9004) };
inline constexpr phrase<> lng_recent_clear_sure{ ushort(9005) };
inline constexpr phrase<> lng_recent_remove{ ushort(9006) };
inline constexpr phrase<> lng_recent_clear_all{ ushort(9007) };
inline constexpr phrase<> lng_recent_hide_top{ ushort(9008) };
inline constexpr phrase<> lng_recent_hide_sure{ ushort(9009) };
inline constexpr phrase<> lng_recent_hide_button{ ushort(9010) };
inline constexpr phrase<> lng_recent_none{ ushort(9011) };
inline constexpr phrase<> lng_recent_chats{ ushort(9012) };
inline constexpr phrase<> lng_recent_channels{ ushort(9013) };
inline constexpr phrase<> lng_recent_apps{ ushort(9014) };
inline constexpr phrase<> lng_recent_posts{ ushort(9015) };
inline constexpr phrase<> lng_all_photos{ ushort(9016) };
inline constexpr phrase<> lng_all_videos{ ushort(9017) };
inline constexpr phrase<> lng_all_downloads{ ushort(9018) };
inline constexpr phrase<> lng_all_links{ ushort(9019) };
inline constexpr phrase<> lng_all_files{ ushort(9020) };
inline constexpr phrase<> lng_all_music{ ushort(9021) };
inline constexpr phrase<> lng_all_voice{ ushort(9022) };
inline constexpr phrase<> lng_channels_none_title{ ushort(9023) };
inline constexpr phrase<> lng_channels_none_about{ ushort(9024) };
inline constexpr phrase<> lng_channels_your_title{ ushort(9025) };
inline constexpr phrase<> lng_channels_your_more{ ushort(9026) };
inline constexpr phrase<> lng_channels_your_less{ ushort(9027) };
inline constexpr phrase<> lng_channels_recommended{ ushort(9028) };
inline constexpr phrase<> lng_bot_apps_your{ ushort(9029) };
inline constexpr phrase<> lng_bot_apps_popular{ ushort(9030) };
inline constexpr phrase<lngtag_link> lng_bot_apps_which{ ushort(9031) };
inline constexpr phrase<> lng_bot_apps_which_link{ ushort(9032) };
inline constexpr phrase<> lng_posts_title{ ushort(9033) };
inline constexpr phrase<> lng_posts_start{ ushort(9034) };
inline constexpr phrase<> lng_posts_subscribe{ ushort(9035) };
inline constexpr phrase<> lng_posts_need_subscribe{ ushort(9036) };
inline constexpr phrase<lngtag_query> lng_posts_search_button{ ushort(9037) };
inline constexpr phrase<lngtag_count> lng_posts_remaining{ ushort(9038) };
inline constexpr phrase<> lng_posts_subtitle_empty{ ushort(9044) };
inline constexpr phrase<> lng_posts_subtitle{ ushort(9045) };
inline constexpr phrase<> lng_posts_limit_reached{ ushort(9046) };
inline constexpr phrase<lngtag_count> lng_posts_limit_about{ ushort(9047) };
inline constexpr phrase<lngtag_cost> lng_posts_limit_search_paid{ ushort(9053) };
inline constexpr phrase<lngtag_duration> lng_posts_limit_unlocks{ ushort(9054) };
inline constexpr phrase<lngtag_count> lng_posts_paid_spent{ ushort(9055) };
inline constexpr phrase<> lng_popular_apps_info_title{ ushort(9061) };
inline constexpr phrase<lngtag_bot, lngtag_link> lng_popular_apps_info_text{ ushort(9062) };
inline constexpr phrase<> lng_popular_apps_info_bot{ ushort(9063) };
inline constexpr phrase<> lng_popular_apps_info_here{ ushort(9064) };
inline constexpr phrase<> lng_popular_apps_info_url{ ushort(9065) };
inline constexpr phrase<> lng_popular_apps_info_confirm{ ushort(9066) };
inline constexpr phrase<> lng_font_box_title{ ushort(9067) };
inline constexpr phrase<> lng_font_default{ ushort(9068) };
inline constexpr phrase<> lng_font_system{ ushort(9069) };
inline constexpr phrase<> lng_font_not_found{ ushort(9070) };
inline constexpr phrase<> lng_search_tab_my_messages{ ushort(9071) };
inline constexpr phrase<> lng_search_tab_this_topic{ ushort(9072) };
inline constexpr phrase<> lng_search_tab_this_chat{ ushort(9073) };
inline constexpr phrase<> lng_search_tab_this_channel{ ushort(9074) };
inline constexpr phrase<> lng_search_tab_this_group{ ushort(9075) };
inline constexpr phrase<> lng_search_tab_public_posts{ ushort(9076) };
inline constexpr phrase<> lng_search_tab_no_results{ ushort(9077) };
inline constexpr phrase<lngtag_query> lng_search_tab_no_results_text{ ushort(9078) };
inline constexpr phrase<> lng_search_tab_no_results_retry{ ushort(9079) };
inline constexpr phrase<> lng_search_tab_by_hashtag{ ushort(9080) };
inline constexpr phrase<> lng_search_tab_try_in_all{ ushort(9081) };
inline constexpr phrase<> lng_contact_details_button{ ushort(9082) };
inline constexpr phrase<> lng_contact_details_title{ ushort(9083) };
inline constexpr phrase<> lng_contact_details_phone{ ushort(9084) };
inline constexpr phrase<> lng_contact_details_phone_main{ ushort(9085) };
inline constexpr phrase<> lng_contact_details_phone_home{ ushort(9086) };
inline constexpr phrase<> lng_contact_details_phone_mobile{ ushort(9087) };
inline constexpr phrase<> lng_contact_details_phone_work{ ushort(9088) };
inline constexpr phrase<> lng_contact_details_phone_other{ ushort(9089) };
inline constexpr phrase<> lng_contact_details_email{ ushort(9090) };
inline constexpr phrase<> lng_contact_details_address{ ushort(9091) };
inline constexpr phrase<> lng_contact_details_url{ ushort(9092) };
inline constexpr phrase<> lng_contact_details_note{ ushort(9093) };
inline constexpr phrase<> lng_contact_details_birthday{ ushort(9094) };
inline constexpr phrase<> lng_contact_details_organization{ ushort(9095) };
inline constexpr phrase<> lng_qr_box_quality{ ushort(9096) };
inline constexpr phrase<> lng_qr_box_quality1{ ushort(9097) };
inline constexpr phrase<> lng_qr_box_quality2{ ushort(9098) };
inline constexpr phrase<> lng_qr_box_quality3{ ushort(9099) };
inline constexpr phrase<> lng_qr_box_transparent_background{ ushort(9100) };
inline constexpr phrase<> lng_qr_box_font_size{ ushort(9101) };
inline constexpr phrase<> lng_frozen_bar_title{ ushort(9102) };
inline constexpr phrase<lngtag_arrow> lng_frozen_bar_text{ ushort(9103) };
inline constexpr phrase<> lng_frozen_restrict_title{ ushort(9104) };
inline constexpr phrase<> lng_frozen_restrict_text{ ushort(9105) };
inline constexpr phrase<> lng_frozen_title{ ushort(9106) };
inline constexpr phrase<> lng_frozen_subtitle1{ ushort(9107) };
inline constexpr phrase<> lng_frozen_text1{ ushort(9108) };
inline constexpr phrase<> lng_frozen_subtitle2{ ushort(9109) };
inline constexpr phrase<> lng_frozen_text2{ ushort(9110) };
inline constexpr phrase<> lng_frozen_subtitle3{ ushort(9111) };
inline constexpr phrase<lngtag_link, lngtag_date> lng_frozen_text3{ ushort(9112) };
inline constexpr phrase<> lng_frozen_appeal_button{ ushort(9113) };
inline constexpr phrase<> lng_age_verify_title{ ushort(9114) };
inline constexpr phrase<> lng_age_verify_mobile{ ushort(9115) };
inline constexpr phrase<> lng_age_verify_here{ ushort(9116) };
inline constexpr phrase<> lng_age_verify_button{ ushort(9117) };
inline constexpr phrase<> lng_age_verify_sorry_title{ ushort(9118) };
inline constexpr phrase<> lng_age_verify_sorry_text{ ushort(9119) };
inline constexpr phrase<> lng_context_bank_card_copy{ ushort(9120) };
inline constexpr phrase<> lng_context_bank_card_copied{ ushort(9121) };
inline constexpr phrase<> lng_summarize_header_title{ ushort(9122) };
inline constexpr phrase<> lng_summarize_header_about{ ushort(9123) };
inline constexpr phrase<> lng_wnd_choose_program_menu{ ushort(9124) };
inline constexpr phrase<> lng_wnd_menu_undo{ ushort(9125) };
inline constexpr phrase<> lng_wnd_menu_redo{ ushort(9126) };
inline constexpr phrase<> lng_linux_menu_undo{ ushort(9127) };
inline constexpr phrase<> lng_linux_menu_redo{ ushort(9128) };
inline constexpr phrase<> lng_linux_menu_tools{ ushort(9129) };
inline constexpr phrase<> lng_linux_menu_help{ ushort(9130) };
inline constexpr phrase<> lng_linux_no_audio_prefs{ ushort(9131) };
inline constexpr phrase<> lng_mac_choose_program_menu{ ushort(9132) };
inline constexpr phrase<> lng_mac_choose_app{ ushort(9133) };
inline constexpr phrase<lngtag_file> lng_mac_choose_text{ ushort(9134) };
inline constexpr phrase<> lng_mac_enable_filter{ ushort(9135) };
inline constexpr phrase<> lng_mac_recommended_apps{ ushort(9136) };
inline constexpr phrase<> lng_mac_all_apps{ ushort(9137) };
inline constexpr phrase<> lng_mac_always_open_with{ ushort(9138) };
inline constexpr phrase<lngtag_file> lng_mac_this_app_can_open{ ushort(9139) };
inline constexpr phrase<lngtag_file> lng_mac_not_known_app{ ushort(9140) };
inline constexpr phrase<> lng_mac_menu_services{ ushort(9141) };
inline constexpr phrase<lngtag_telegram> lng_mac_menu_hide_telegram{ ushort(9142) };
inline constexpr phrase<> lng_mac_menu_hide_others{ ushort(9143) };
inline constexpr phrase<> lng_mac_menu_show_all{ ushort(9144) };
inline constexpr phrase<> lng_mac_menu_preferences{ ushort(9145) };
inline constexpr phrase<lngtag_telegram> lng_mac_menu_quit_telegram{ ushort(9146) };
inline constexpr phrase<lngtag_telegram> lng_mac_menu_about_telegram{ ushort(9147) };
inline constexpr phrase<> lng_mac_menu_file{ ushort(9148) };
inline constexpr phrase<> lng_mac_menu_logout{ ushort(9149) };
inline constexpr phrase<> lng_mac_menu_edit{ ushort(9150) };
inline constexpr phrase<> lng_mac_menu_undo{ ushort(9151) };
inline constexpr phrase<> lng_mac_menu_redo{ ushort(9152) };
inline constexpr phrase<> lng_mac_menu_cut{ ushort(9153) };
inline constexpr phrase<> lng_mac_menu_copy{ ushort(9154) };
inline constexpr phrase<> lng_mac_menu_paste{ ushort(9155) };
inline constexpr phrase<> lng_mac_menu_delete{ ushort(9156) };
inline constexpr phrase<> lng_mac_menu_select_all{ ushort(9157) };
inline constexpr phrase<> lng_mac_menu_window{ ushort(9158) };
inline constexpr phrase<> lng_mac_menu_contacts{ ushort(9159) };
inline constexpr phrase<> lng_mac_menu_add_contact{ ushort(9160) };
inline constexpr phrase<> lng_mac_menu_new_group{ ushort(9161) };
inline constexpr phrase<> lng_mac_menu_new_channel{ ushort(9162) };
inline constexpr phrase<> lng_mac_menu_show{ ushort(9163) };
inline constexpr phrase<> lng_mac_menu_emoji_and_symbols{ ushort(9164) };
inline constexpr phrase<> lng_mac_menu_fullscreen{ ushort(9165) };
inline constexpr phrase<> lng_mac_menu_player_pause{ ushort(9166) };
inline constexpr phrase<> lng_mac_menu_player_resume{ ushort(9167) };
inline constexpr phrase<> lng_mac_menu_player_next{ ushort(9168) };
inline constexpr phrase<> lng_mac_menu_player_previous{ ushort(9169) };
inline constexpr phrase<> lng_mac_menu_profiles{ ushort(9170) };
inline constexpr phrase<> lng_mac_touchbar_favorite_stickers{ ushort(9171) };
inline constexpr phrase<lngtag_text> lng_mac_hold_to_quit{ ushort(9172) };

} // namespace tr

