/* Plug.c generated by valac 0.56.17, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-2.0-or-later
 * SPDX-FileCopyrightText: 2016-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.sound.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <granite-7.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_PLUG_0_PROPERTY,
	SOUND_PLUG_NUM_PROPERTIES
};
static GParamSpec* sound_plug_properties[SOUND_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SoundPlugSearchData SoundPlugSearchData;

struct _SoundPlugPrivate {
	GtkBox* box;
	GtkStack* stack;
	SoundInputPanel* input_panel;
};

struct _SoundPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SoundPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GeeTreeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
};

static gint SoundPlug_private_offset;
static gpointer sound_plug_parent_class = NULL;

static GtkWidget* sound_plug_real_get_widget (SwitchboardPlug* base);
static void ___lambda39_ (SoundPlug* self);
static void ____lambda39__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void sound_plug_real_shown (SwitchboardPlug* base);
static void sound_plug_real_hidden (SwitchboardPlug* base);
static void sound_plug_real_search_callback (SwitchboardPlug* base,
                                      const gchar* location);
static void sound_plug_real_search_data_free (gpointer _data);
static void sound_plug_real_search (SwitchboardPlug* base,
                             const gchar* search,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
static gboolean sound_plug_real_search_co (SoundPlugSearchData* _data_);
static void sound_plug_finalize (GObject * obj);
static GType sound_plug_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sound_plug_get_instance_private (SoundPlug* self)
{
	return G_STRUCT_MEMBER_P (self, SoundPlug_private_offset);
}

SoundPlug*
sound_plug_construct (GType object_type)
{
	SoundPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "sound", NULL);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "sound/applications", "applications");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "sound/input", "input");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "sound/output", "output");
	self = (SoundPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_HARDWARE, "code-name", "io.elementary.settings.sound", "display-name", _ ("Sound"), "description", _ ("Change sound and microphone volume"), "icon", "multimedia-volume-control", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

SoundPlug*
sound_plug_new (void)
{
	return sound_plug_construct (SOUND_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda39_ (SoundPlug* self)
{
	SoundInputPanel* _tmp0_;
	GtkStack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	SoundInputPanel* _tmp4_;
	_tmp0_ = self->priv->input_panel;
	_tmp1_ = self->priv->stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->input_panel;
	sound_input_panel_set_visibility (_tmp0_, _tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
}

static void
____lambda39__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda39_ ((SoundPlug*) self);
}

static GtkWidget*
sound_plug_real_get_widget (SwitchboardPlug* base)
{
	SoundPlug * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp33_;
	GtkWidget* _tmp34_;
	GtkWidget* result;
	self = (SoundPlug*) base;
	_tmp0_ = self->priv->box;
	if (_tmp0_ == NULL) {
		SoundOutputPanel* output_panel = NULL;
		SoundOutputPanel* _tmp1_;
		SoundInputPanel* _tmp2_;
		SoundApplicationsPanel* applications_panel = NULL;
		SoundApplicationsPanel* _tmp3_;
		GtkStack* _tmp4_ = NULL;
		GtkStack* _tmp5_;
		SoundOutputPanel* _tmp6_;
		GtkStack* _tmp7_;
		SoundInputPanel* _tmp8_;
		GtkStack* _tmp9_;
		SoundApplicationsPanel* _tmp10_;
		GtkStackSwitcher* stack_switcher = NULL;
		GtkStack* _tmp11_;
		GtkStack* _tmp12_;
		GtkStackSwitcher* _tmp13_ = NULL;
		GtkStackSwitcher* _tmp14_;
		GtkLayoutManager* _tmp15_;
		GtkLayoutManager* _tmp16_;
		AdwClamp* clamp = NULL;
		GtkStack* _tmp17_;
		GtkWidget* _tmp18_;
		AdwClamp* _tmp19_ = NULL;
		AdwHeaderBar* headerbar = NULL;
		GtkStackSwitcher* _tmp20_;
		GtkWidget* _tmp21_;
		AdwHeaderBar* _tmp22_ = NULL;
		AdwHeaderBar* _tmp23_;
		GtkBox* _tmp24_;
		GtkBox* _tmp25_;
		AdwHeaderBar* _tmp26_;
		GtkBox* _tmp27_;
		AdwClamp* _tmp28_;
		SoundPulseAudioManager* pam = NULL;
		SoundPulseAudioManager* _tmp29_;
		SoundPulseAudioManager* _tmp30_;
		SoundPulseAudioManager* _tmp31_;
		GtkStack* _tmp32_;
		_tmp1_ = sound_output_panel_new ();
		g_object_ref_sink (_tmp1_);
		output_panel = _tmp1_;
		_tmp2_ = sound_input_panel_new ();
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->input_panel);
		self->priv->input_panel = _tmp2_;
		_tmp3_ = sound_applications_panel_new ();
		g_object_ref_sink (_tmp3_);
		applications_panel = _tmp3_;
		_tmp4_ = (GtkStack*) gtk_stack_new ();
		gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
		gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
		gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 12);
		gtk_widget_set_margin_end ((GtkWidget*) _tmp4_, 12);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp4_, 12);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->stack);
		self->priv->stack = _tmp4_;
		_tmp5_ = self->priv->stack;
		_tmp6_ = output_panel;
		gtk_stack_add_titled (_tmp5_, (GtkWidget*) _tmp6_, "output", _ ("Output"));
		_tmp7_ = self->priv->stack;
		_tmp8_ = self->priv->input_panel;
		gtk_stack_add_titled (_tmp7_, (GtkWidget*) _tmp8_, "input", _ ("Input"));
		_tmp9_ = self->priv->stack;
		_tmp10_ = applications_panel;
		gtk_stack_add_titled (_tmp9_, (GtkWidget*) _tmp10_, "applications", _ ("Applications"));
		_tmp11_ = self->priv->stack;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_tmp13_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
		gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
		gtk_stack_switcher_set_stack (_tmp13_, _tmp12_);
		_g_object_unref0 (_tmp12_);
		g_object_ref_sink (_tmp13_);
		stack_switcher = _tmp13_;
		_tmp14_ = stack_switcher;
		_tmp15_ = gtk_widget_get_layout_manager ((GtkWidget*) _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_box_layout_set_homogeneous (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_box_layout_get_type (), GtkBoxLayout), TRUE);
		_tmp17_ = self->priv->stack;
		_tmp18_ = _g_object_ref0 ((GtkWidget*) _tmp17_);
		_tmp19_ = (AdwClamp*) adw_clamp_new ();
		adw_clamp_set_child (_tmp19_, _tmp18_);
		_g_object_unref0 (_tmp18_);
		g_object_ref_sink (_tmp19_);
		clamp = _tmp19_;
		_tmp20_ = stack_switcher;
		_tmp21_ = _g_object_ref0 ((GtkWidget*) _tmp20_);
		_tmp22_ = (AdwHeaderBar*) adw_header_bar_new ();
		adw_header_bar_set_title_widget (_tmp22_, _tmp21_);
		_g_object_unref0 (_tmp21_);
		g_object_ref_sink (_tmp22_);
		headerbar = _tmp22_;
		_tmp23_ = headerbar;
		gtk_widget_add_css_class ((GtkWidget*) _tmp23_, GRANITE_STYLE_CLASS_FLAT);
		_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp24_);
		_g_object_unref0 (self->priv->box);
		self->priv->box = _tmp24_;
		_tmp25_ = self->priv->box;
		_tmp26_ = headerbar;
		gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
		_tmp27_ = self->priv->box;
		_tmp28_ = clamp;
		gtk_box_append (_tmp27_, (GtkWidget*) _tmp28_);
		_tmp29_ = sound_pulse_audio_manager_get_default ();
		_tmp30_ = _g_object_ref0 (_tmp29_);
		pam = _tmp30_;
		_tmp31_ = pam;
		sound_pulse_audio_manager_start (_tmp31_);
		_tmp32_ = self->priv->stack;
		g_signal_connect_object ((GObject*) _tmp32_, "notify::visible-child", (GCallback) ____lambda39__g_object_notify, self, 0);
		_g_object_unref0 (pam);
		_g_object_unref0 (headerbar);
		_g_object_unref0 (clamp);
		_g_object_unref0 (stack_switcher);
		_g_object_unref0 (applications_panel);
		_g_object_unref0 (output_panel);
	}
	_tmp33_ = self->priv->box;
	_tmp34_ = _g_object_ref0 ((GtkWidget*) _tmp33_);
	result = _tmp34_;
	return result;
}

static void
sound_plug_real_shown (SwitchboardPlug* base)
{
	SoundPlug * self;
	GtkBox* _tmp0_;
	GtkStack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	SoundInputPanel* _tmp4_;
	self = (SoundPlug*) base;
	_tmp0_ = self->priv->box;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->input_panel;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		SoundInputPanel* _tmp5_;
		_tmp5_ = self->priv->input_panel;
		sound_input_panel_set_visibility (_tmp5_, TRUE);
	}
}

static void
sound_plug_real_hidden (SwitchboardPlug* base)
{
	SoundPlug * self;
	self = (SoundPlug*) base;
}

static void
sound_plug_real_search_callback (SwitchboardPlug* base,
                                 const gchar* location)
{
	SoundPlug * self;
	GtkStack* _tmp0_;
	self = (SoundPlug*) base;
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, location);
}

static void
sound_plug_real_search_data_free (gpointer _data)
{
	SoundPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SoundPlugSearchData, _data_);
}

static void
sound_plug_real_search (SwitchboardPlug* base,
                        const gchar* search,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	SoundPlug * self;
	SoundPlugSearchData* _data_;
	SoundPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (SoundPlug*) base;
	_data_ = g_slice_new0 (SoundPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, sound_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	sound_plug_real_search_co (_data_);
}

static GeeTreeMap*
sound_plug_search_finish (SwitchboardPlug* base,
                          GAsyncResult* _res_)
{
	GeeTreeMap* result;
	SoundPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
sound_plug_real_search_co (SoundPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->search_results = _data_->_tmp0_;
	_data_->_tmp1_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_strdup_printf ("%s → %s", _data_->_tmp2_, _ ("Output"));
	_data_->_tmp4_ = _data_->_tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp4_, "output");
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp5_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp6_, _ ("Output"), _ ("Device"));
	_data_->_tmp8_ = _data_->_tmp7_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp8_, "output");
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp9_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp10_, _ ("Output"), _ ("Event Alerts"));
	_data_->_tmp12_ = _data_->_tmp11_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp12_, "output");
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp14_, _ ("Output"), _ ("Port"));
	_data_->_tmp16_ = _data_->_tmp15_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp16_, "output");
	_g_free0 (_data_->_tmp16_);
	_data_->_tmp17_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp18_, _ ("Output"), _ ("Volume"));
	_data_->_tmp20_ = _data_->_tmp19_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp20_, "output");
	_g_free0 (_data_->_tmp20_);
	_data_->_tmp21_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp22_, _ ("Output"), _ ("Balance"));
	_data_->_tmp24_ = _data_->_tmp23_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp24_, "output");
	_g_free0 (_data_->_tmp24_);
	_data_->_tmp25_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp27_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp26_, _ ("Output"), _ ("Screen Reader"));
	_data_->_tmp28_ = _data_->_tmp27_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp28_, "output");
	_g_free0 (_data_->_tmp28_);
	_data_->_tmp29_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp30_, _ ("Output"), _ ("Test Speakers"));
	_data_->_tmp32_ = _data_->_tmp31_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp32_, "output");
	_g_free0 (_data_->_tmp32_);
	_data_->_tmp33_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->_tmp35_ = g_strdup_printf ("%s → %s", _data_->_tmp34_, _ ("Input"));
	_data_->_tmp36_ = _data_->_tmp35_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp36_, "input");
	_g_free0 (_data_->_tmp36_);
	_data_->_tmp37_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp38_ = _data_->_tmp37_;
	_data_->_tmp39_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp38_, _ ("Input"), _ ("Device"));
	_data_->_tmp40_ = _data_->_tmp39_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp40_, "input");
	_g_free0 (_data_->_tmp40_);
	_data_->_tmp41_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp42_ = _data_->_tmp41_;
	_data_->_tmp43_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp42_, _ ("Input"), _ ("Port"));
	_data_->_tmp44_ = _data_->_tmp43_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp44_, "input");
	_g_free0 (_data_->_tmp44_);
	_data_->_tmp45_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp46_ = _data_->_tmp45_;
	_data_->_tmp47_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp46_, _ ("Input"), _ ("Volume"));
	_data_->_tmp48_ = _data_->_tmp47_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp48_, "input");
	_g_free0 (_data_->_tmp48_);
	_data_->_tmp49_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp50_ = _data_->_tmp49_;
	_data_->_tmp51_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp50_, _ ("Input"), _ ("Enable"));
	_data_->_tmp52_ = _data_->_tmp51_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp52_, "input");
	_g_free0 (_data_->_tmp52_);
	_data_->_tmp53_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp54_ = _data_->_tmp53_;
	_data_->_tmp55_ = g_strdup_printf ("%s → %s", _data_->_tmp54_, _ ("Applications"));
	_data_->_tmp56_ = _data_->_tmp55_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp56_, "applications");
	_g_free0 (_data_->_tmp56_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
sound_plug_class_init (SoundPlugClass * klass,
                       gpointer klass_data)
{
	sound_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) sound_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) sound_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) sound_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) sound_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) sound_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) sound_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = sound_plug_finalize;
}

static void
sound_plug_instance_init (SoundPlug * self,
                          gpointer klass)
{
	self->priv = sound_plug_get_instance_private (self);
}

static void
sound_plug_finalize (GObject * obj)
{
	SoundPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_PLUG, SoundPlug);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->input_panel);
	G_OBJECT_CLASS (sound_plug_parent_class)->finalize (obj);
}

static GType
sound_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundPlug), 0, (GInstanceInitFunc) sound_plug_instance_init, NULL };
	GType sound_plug_type_id;
	sound_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "SoundPlug", &g_define_type_info, 0);
	SoundPlug_private_offset = g_type_add_instance_private (sound_plug_type_id, sizeof (SoundPlugPrivate));
	return sound_plug_type_id;
}

GType
sound_plug_get_type (void)
{
	static volatile gsize sound_plug_type_id__once = 0;
	if (g_once_init_enter (&sound_plug_type_id__once)) {
		GType sound_plug_type_id;
		sound_plug_type_id = sound_plug_get_type_once ();
		g_once_init_leave (&sound_plug_type_id__once, sound_plug_type_id);
	}
	return sound_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	SoundPlug* plug = NULL;
	SoundPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:114: Activating Sound plug");
	_tmp0_ = sound_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

