/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
* Copyright 2014-2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Akshay Shekher <voldyman666@gmail.com>
*              Marius Meisenzahl <mariusmeisenzahl@gmail.com>
*/

#include "applications.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	APPLICATIONS_PLUG_0_PROPERTY,
	APPLICATIONS_PLUG_NUM_PROPERTIES
};
static GParamSpec* applications_plug_properties[APPLICATIONS_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ApplicationsPlugSearchData ApplicationsPlugSearchData;

struct _ApplicationsPlugPrivate {
	GtkPaned* paned;
	GtkStack* stack;
};

struct _ApplicationsPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationsPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
};

static gint ApplicationsPlug_private_offset;
static gpointer applications_plug_parent_class = NULL;

static GtkWidget* applications_plug_real_get_widget (SwitchboardPlug* base);
static void applications_plug_real_shown (SwitchboardPlug* base);
static void applications_plug_real_hidden (SwitchboardPlug* base);
static void applications_plug_real_search_callback (SwitchboardPlug* base,
                                             const gchar* location);
static void applications_plug_real_search_data_free (gpointer _data);
static void applications_plug_real_search (SwitchboardPlug* base,
                                    const gchar* search,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static gboolean applications_plug_real_search_co (ApplicationsPlugSearchData* _data_);
static void applications_plug_finalize (GObject * obj);
static GType applications_plug_get_type_once (void);

static inline gpointer
applications_plug_get_instance_private (ApplicationsPlug* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationsPlug_private_offset);
}

ApplicationsPlug*
applications_plug_construct (GType object_type)
{
	ApplicationsPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "applications", NULL);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "applications/defaults", APPLICATIONS_PLUG_DEFAULTS);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "applications/startup", APPLICATIONS_PLUG_STARTUP);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "applications/permissions", APPLICATIONS_PLUG_PERMISSIONS);
	self = (ApplicationsPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_PERSONAL, "code-name", "io.elementary.settings.applications", "description", _ ("Manage default apps, startup apps, and app permissions"), "display-name", _ ("Applications"), "icon", "io.elementary.settings.applications", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

ApplicationsPlug*
applications_plug_new (void)
{
	return applications_plug_construct (APPLICATIONS_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
applications_plug_real_get_widget (SwitchboardPlug* base)
{
	ApplicationsPlug * self;
	GtkPaned* _tmp0_;
	GtkPaned* _tmp26_;
	GtkWidget* _tmp27_;
	GtkWidget* result;
	self = (ApplicationsPlug*) base;
	_tmp0_ = self->priv->paned;
	if (_tmp0_ == NULL) {
		PermissionsWidgetsAppSettingsView* app_settings_view = NULL;
		PermissionsWidgetsAppSettingsView* _tmp1_;
		GtkStack* _tmp2_;
		GtkStack* _tmp3_;
		DefaultsPlug* _tmp4_;
		DefaultsPlug* _tmp5_;
		GtkStack* _tmp6_;
		StartupPlug* _tmp7_;
		StartupPlug* _tmp8_;
		GtkStack* _tmp9_;
		PermissionsWidgetsAppSettingsView* _tmp10_;
		ApplicationsSidebar* sidebar = NULL;
		GtkStack* _tmp11_;
		ApplicationsSidebar* _tmp12_;
		ApplicationsSidebar* _tmp13_;
		GtkWidget* _tmp14_;
		GtkStack* _tmp15_;
		GtkWidget* _tmp16_;
		GtkPaned* _tmp17_ = NULL;
		GSettingsSchema* sss = NULL;
		GSettingsSchemaSource* _tmp18_;
		GSettingsSchema* _tmp19_;
		gboolean _tmp20_ = FALSE;
		GSettingsSchema* _tmp21_;
		_tmp1_ = permissions_widgets_app_settings_view_new ();
		g_object_ref_sink (_tmp1_);
		app_settings_view = _tmp1_;
		_tmp2_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->stack);
		self->priv->stack = _tmp2_;
		_tmp3_ = self->priv->stack;
		_tmp4_ = defaults_plug_new ();
		g_object_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		gtk_stack_add_named (_tmp3_, (GtkWidget*) _tmp5_, APPLICATIONS_PLUG_DEFAULTS);
		_g_object_unref0 (_tmp5_);
		_tmp6_ = self->priv->stack;
		_tmp7_ = startup_plug_new ();
		g_object_ref_sink (_tmp7_);
		_tmp8_ = _tmp7_;
		gtk_stack_add_named (_tmp6_, (GtkWidget*) _tmp8_, APPLICATIONS_PLUG_STARTUP);
		_g_object_unref0 (_tmp8_);
		_tmp9_ = self->priv->stack;
		_tmp10_ = app_settings_view;
		gtk_stack_add_named (_tmp9_, (GtkWidget*) _tmp10_, APPLICATIONS_PLUG_PERMISSIONS);
		_tmp11_ = self->priv->stack;
		_tmp12_ = applications_sidebar_new (_tmp11_);
		g_object_ref_sink (_tmp12_);
		sidebar = _tmp12_;
		_tmp13_ = sidebar;
		_tmp14_ = _g_object_ref0 ((GtkWidget*) _tmp13_);
		_tmp15_ = self->priv->stack;
		_tmp16_ = _g_object_ref0 ((GtkWidget*) _tmp15_);
		_tmp17_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_paned_set_start_child (_tmp17_, _tmp14_);
		_g_object_unref0 (_tmp14_);
		gtk_paned_set_end_child (_tmp17_, _tmp16_);
		_g_object_unref0 (_tmp16_);
		gtk_paned_set_shrink_start_child (_tmp17_, FALSE);
		gtk_paned_set_shrink_end_child (_tmp17_, FALSE);
		gtk_paned_set_resize_start_child (_tmp17_, FALSE);
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (self->priv->paned);
		self->priv->paned = _tmp17_;
		_tmp18_ = g_settings_schema_source_get_default ();
		_tmp19_ = g_settings_schema_source_lookup (_tmp18_, "io.elementary.settings", TRUE);
		sss = _tmp19_;
		_tmp21_ = sss;
		if (_tmp21_ != NULL) {
			GSettingsSchema* _tmp22_;
			_tmp22_ = sss;
			_tmp20_ = g_settings_schema_has_key (_tmp22_, "sidebar-position");
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GSettings* settings = NULL;
			GSettings* _tmp23_;
			GSettings* _tmp24_;
			GtkPaned* _tmp25_;
			_tmp23_ = g_settings_new ("io.elementary.settings");
			settings = _tmp23_;
			_tmp24_ = settings;
			_tmp25_ = self->priv->paned;
			g_settings_bind (_tmp24_, "sidebar-position", (GObject*) _tmp25_, "position", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (settings);
		}
		_g_settings_schema_unref0 (sss);
		_g_object_unref0 (sidebar);
		_g_object_unref0 (app_settings_view);
	}
	_tmp26_ = self->priv->paned;
	_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
	result = _tmp27_;
	return result;
}

static void
applications_plug_real_shown (SwitchboardPlug* base)
{
	ApplicationsPlug * self;
	self = (ApplicationsPlug*) base;
}

static void
applications_plug_real_hidden (SwitchboardPlug* base)
{
	ApplicationsPlug * self;
	self = (ApplicationsPlug*) base;
}

static void
applications_plug_real_search_callback (SwitchboardPlug* base,
                                        const gchar* location)
{
	ApplicationsPlug * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	self = (ApplicationsPlug*) base;
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (APPLICATIONS_PLUG_STARTUP)))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (APPLICATIONS_PLUG_DEFAULTS))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (APPLICATIONS_PLUG_PERMISSIONS))))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp3_;
				_tmp3_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp3_, location);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkStack* _tmp4_;
				_tmp4_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp4_, APPLICATIONS_PLUG_DEFAULTS);
				break;
			}
		}
	}
}

static void
applications_plug_real_search_data_free (gpointer _data)
{
	ApplicationsPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationsPlugSearchData, _data_);
}

static void
applications_plug_real_search (SwitchboardPlug* base,
                               const gchar* search,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	ApplicationsPlug * self;
	ApplicationsPlugSearchData* _data_;
	ApplicationsPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (ApplicationsPlug*) base;
	_data_ = g_slice_new0 (ApplicationsPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, applications_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	applications_plug_real_search_co (_data_);
}

static GeeTreeMap*
applications_plug_search_finish (SwitchboardPlug* base,
                                 GAsyncResult* _res_)
{
	GeeTreeMap* result;
	ApplicationsPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
applications_plug_real_search_co (ApplicationsPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%s → %s", _data_->_tmp4_, _ ("Startup"));
	_data_->_tmp6_ = _data_->_tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp6_, APPLICATIONS_PLUG_STARTUP);
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp7_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strdup_printf ("%s → %s", _data_->_tmp8_, _ ("Default Apps"));
	_data_->_tmp10_ = _data_->_tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp10_, APPLICATIONS_PLUG_DEFAULTS);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("%s → %s", _data_->_tmp12_, _ ("Permissions"));
	_data_->_tmp14_ = _data_->_tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp14_, APPLICATIONS_PLUG_PERMISSIONS);
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_strdup_printf ("%s → %s", _data_->_tmp16_, _ ("Sandboxing"));
	_data_->_tmp18_ = _data_->_tmp17_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp18_, APPLICATIONS_PLUG_PERMISSIONS);
	_g_free0 (_data_->_tmp18_);
	_data_->_tmp19_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = g_strdup_printf ("%s → %s", _data_->_tmp20_, _ ("Confinement"));
	_data_->_tmp22_ = _data_->_tmp21_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp22_, APPLICATIONS_PLUG_PERMISSIONS);
	_g_free0 (_data_->_tmp22_);
	_data_->_tmp23_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp24_, _ ("Default"), _ ("Web Browser"));
	_data_->_tmp26_ = _data_->_tmp25_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp26_, APPLICATIONS_PLUG_DEFAULTS);
	_g_free0 (_data_->_tmp26_);
	_data_->_tmp27_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp28_, _ ("Default"), _ ("Email Client"));
	_data_->_tmp30_ = _data_->_tmp29_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp30_, APPLICATIONS_PLUG_DEFAULTS);
	_g_free0 (_data_->_tmp30_);
	_data_->_tmp31_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp32_, _ ("Default"), _ ("Calendar"));
	_data_->_tmp34_ = _data_->_tmp33_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp34_, APPLICATIONS_PLUG_DEFAULTS);
	_g_free0 (_data_->_tmp34_);
	_data_->_tmp35_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp36_, _ ("Default"), _ ("Video Player"));
	_data_->_tmp38_ = _data_->_tmp37_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp38_, APPLICATIONS_PLUG_DEFAULTS);
	_g_free0 (_data_->_tmp38_);
	_data_->_tmp39_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp41_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp40_, _ ("Default"), _ ("Music Player"));
	_data_->_tmp42_ = _data_->_tmp41_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp42_, APPLICATIONS_PLUG_DEFAULTS);
	_g_free0 (_data_->_tmp42_);
	_data_->_tmp43_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp44_ = _data_->_tmp43_;
	_data_->_tmp45_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp44_, _ ("Default"), _ ("Text Editor"));
	_data_->_tmp46_ = _data_->_tmp45_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp46_, APPLICATIONS_PLUG_DEFAULTS);
	_g_free0 (_data_->_tmp46_);
	_data_->_tmp47_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp48_ = _data_->_tmp47_;
	_data_->_tmp49_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp48_, _ ("Default"), _ ("Image Viewer"));
	_data_->_tmp50_ = _data_->_tmp49_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp50_, APPLICATIONS_PLUG_DEFAULTS);
	_g_free0 (_data_->_tmp50_);
	_data_->_tmp51_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp52_ = _data_->_tmp51_;
	_data_->_tmp53_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp52_, _ ("Default"), _ ("File Browser"));
	_data_->_tmp54_ = _data_->_tmp53_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp54_, APPLICATIONS_PLUG_DEFAULTS);
	_g_free0 (_data_->_tmp54_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
applications_plug_class_init (ApplicationsPlugClass * klass,
                              gpointer klass_data)
{
	applications_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationsPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) applications_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) applications_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) applications_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) applications_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) applications_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) applications_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = applications_plug_finalize;
}

static void
applications_plug_instance_init (ApplicationsPlug * self,
                                 gpointer klass)
{
	self->priv = applications_plug_get_instance_private (self);
}

static void
applications_plug_finalize (GObject * obj)
{
	ApplicationsPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATIONS_TYPE_PLUG, ApplicationsPlug);
	_g_object_unref0 (self->priv->paned);
	_g_object_unref0 (self->priv->stack);
	G_OBJECT_CLASS (applications_plug_parent_class)->finalize (obj);
}

static GType
applications_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationsPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) applications_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationsPlug), 0, (GInstanceInitFunc) applications_plug_instance_init, NULL };
	GType applications_plug_type_id;
	applications_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "ApplicationsPlug", &g_define_type_info, 0);
	ApplicationsPlug_private_offset = g_type_add_instance_private (applications_plug_type_id, sizeof (ApplicationsPlugPrivate));
	return applications_plug_type_id;
}

GType
applications_plug_get_type (void)
{
	static volatile gsize applications_plug_type_id__once = 0;
	if (g_once_init_enter (&applications_plug_type_id__once)) {
		GType applications_plug_type_id;
		applications_plug_type_id = applications_plug_get_type_once ();
		g_once_init_leave (&applications_plug_type_id__once, applications_plug_type_id);
	}
	return applications_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	ApplicationsPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	_tmp0_ = applications_plug_new ();
	result = (SwitchboardPlug*) _tmp0_;
	return result;
}

