/* PickerWindow.c generated by valac 0.56.18, the Vala compiler
 * generated from PickerWindow.vala, do not modify */

/*
* Copyright (c) 2017 Ronny Dobra (https://github.com/RonnyDo/ColorPicker)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Ronny Dobra <ronnydobra at arcor dot de>
* Inspired by: https://github.com/stuartlangridge/ColourPicker/
*/

#include <granite.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>

#define SPICE_PICKER_WINDOW_dark_border_color_string "#333333"
#define SPICE_PICKER_WINDOW_bright_border_color_string "#FFFFFF"
#define SPICE_PICKER_WINDOW_SNAPSIZE 31
#define SPICE_PICKER_WINDOW_SHADOW_WIDTH 15
#define SPICE_PICKER_WINDOW_MAX_ZOOM_LEVEL 7
#define SPICE_PICKER_WINDOW_MIN_ZOOM_LEVEL 2
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_PICKER_WINDOW (spice_picker_window_get_type ())
#define SPICE_PICKER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_PICKER_WINDOW, SpicePickerWindow))
#define SPICE_PICKER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_PICKER_WINDOW, SpicePickerWindowClass))
#define SPICE_IS_PICKER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_PICKER_WINDOW))
#define SPICE_IS_PICKER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_PICKER_WINDOW))
#define SPICE_PICKER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_PICKER_WINDOW, SpicePickerWindowClass))

typedef struct _SpicePickerWindow SpicePickerWindow;
typedef struct _SpicePickerWindowClass SpicePickerWindowClass;
typedef struct _SpicePickerWindowPrivate SpicePickerWindowPrivate;
enum  {
	SPICE_PICKER_WINDOW_0_PROPERTY,
	SPICE_PICKER_WINDOW_ZOOMLEVEL_PROPERTY,
	SPICE_PICKER_WINDOW_NUM_PROPERTIES
};
static GParamSpec* spice_picker_window_properties[SPICE_PICKER_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GdkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRectangle_free (var), NULL)))
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SPICE_PICKER_WINDOW_PICKED_SIGNAL,
	SPICE_PICKER_WINDOW_CANCELLED_SIGNAL,
	SPICE_PICKER_WINDOW_MOVED_SIGNAL,
	SPICE_PICKER_WINDOW_NUM_SIGNALS
};
static guint spice_picker_window_signals[SPICE_PICKER_WINDOW_NUM_SIGNALS] = {0};

#define TYPE_EXT_RGBA (ext_rgba_get_type ())
typedef GdkRGBA ExtRGBA;

struct _SpicePickerWindow {
	GraniteWidgetsCompositedWindow parent_instance;
	SpicePickerWindowPrivate * priv;
};

struct _SpicePickerWindowClass {
	GraniteWidgetsCompositedWindowClass parent_class;
};

struct _SpicePickerWindowPrivate {
	GdkRGBA dark_border_color;
	GdkRGBA bright_border_color;
	GdkCursor* magnifier;
};

static gint SpicePickerWindow_private_offset;
static gpointer spice_picker_window_parent_class = NULL;
static gint spice_picker_window__zoom_level;
static gint spice_picker_window__zoom_level = 2;

VALA_EXTERN GType spice_picker_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpicePickerWindow, g_object_unref)
VALA_EXTERN SpicePickerWindow* spice_picker_window_new (void);
VALA_EXTERN SpicePickerWindow* spice_picker_window_construct (GType object_type);
static GdkRectangle* _vala_GdkRectangle_copy (GdkRectangle* self);
static void _vala_GdkRectangle_free (GdkRectangle* self);
static gboolean spice_picker_window_real_button_release_event (GtkWidget* base,
                                                        GdkEventButton* e);
VALA_EXTERN void spice_picker_window_get_color_at (SpicePickerWindow* self,
                                       gint x,
                                       gint y,
                                       GdkRGBA* result);
static gboolean spice_picker_window_real_draw (GtkWidget* base,
                                        cairo_t* cr);
static gboolean spice_picker_window_real_motion_notify_event (GtkWidget* base,
                                                       GdkEventMotion* e);
static void spice_picker_window_set_magnifier_cursor (SpicePickerWindow* self);
static gboolean spice_picker_window_real_scroll_event (GtkWidget* base,
                                                GdkEventScroll* e);
VALA_EXTERN gint spice_picker_window_get_zoomlevel (SpicePickerWindow* self);
VALA_EXTERN void spice_picker_window_set_zoomlevel (SpicePickerWindow* self,
                                        gint value);
VALA_EXTERN GdkPixbuf* spice_picker_window_snap (SpicePickerWindow* self,
                                     gint x,
                                     gint y,
                                     gint w,
                                     gint h);
static void _vala_GdkEvent_free (GdkEvent* self);
static gboolean spice_picker_window_real_key_press_event (GtkWidget* base,
                                                   GdkEventKey* e);
static void spice_picker_window_real_show_all (GtkWidget* base);
VALA_EXTERN void spice_picker_window_close (SpicePickerWindow* self);
static GObject * spice_picker_window_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void spice_picker_window_finalize (GObject * obj);
static GType spice_picker_window_get_type_once (void);
static void _vala_spice_picker_window_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_spice_picker_window_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
VALA_EXTERN GType ext_rgba_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ExtRGBA* ext_rgba_dup (const ExtRGBA* self);
VALA_EXTERN void ext_rgba_free (ExtRGBA* self);
VALA_EXTERN gchar* ext_rgba_to_css_rgb_string (ExtRGBA *self);

static inline gpointer
spice_picker_window_get_instance_private (SpicePickerWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SpicePickerWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 78 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return self ? g_object_ref (self) : NULL;
#line 177 "PickerWindow.c"
}

static GdkRectangle*
_vala_GdkRectangle_copy (GdkRectangle* self)
{
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return g_boxed_copy (gdk_rectangle_get_type (), self);
#line 185 "PickerWindow.c"
}

static gpointer
__vala_GdkRectangle_copy0 (gpointer self)
{
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return self ? _vala_GdkRectangle_copy (self) : NULL;
#line 193 "PickerWindow.c"
}

static void
_vala_GdkRectangle_free (GdkRectangle* self)
{
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_boxed_free (gdk_rectangle_get_type (), self);
#line 201 "PickerWindow.c"
}

SpicePickerWindow*
spice_picker_window_construct (GType object_type)
{
	SpicePickerWindow * self = NULL;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkRectangle* screens_rectangle = NULL;
	gint n_monitors = 0;
	GdkDisplay* _tmp2_;
	GdkRectangle* _tmp19_;
	GdkRectangle* _tmp20_;
#line 67 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self = (SpicePickerWindow*) granite_widgets_composited_window_construct (object_type);
#line 68 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gtk_window_stick ((GtkWindow*) self);
#line 69 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gtk_window_set_resizable ((GtkWindow*) self, TRUE);
#line 70 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
#line 71 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
#line 72 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
#line 73 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
#line 75 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gdk_rgba_parse (&self->priv->dark_border_color, SPICE_PICKER_WINDOW_dark_border_color_string);
#line 76 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gdk_rgba_parse (&self->priv->bright_border_color, SPICE_PICKER_WINDOW_bright_border_color_string);
#line 78 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp0_ = gdk_display_get_default ();
#line 78 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 78 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	display = _tmp1_;
#line 80 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	screens_rectangle = NULL;
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp2_ = display;
#line 81 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	n_monitors = gdk_display_get_n_monitors (_tmp2_);
#line 246 "PickerWindow.c"
	{
		gint i = 0;
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		i = 0;
#line 251 "PickerWindow.c"
		{
			gboolean _tmp3_ = FALSE;
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			_tmp3_ = TRUE;
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			while (TRUE) {
#line 258 "PickerWindow.c"
				GdkMonitor* monitor = NULL;
				GdkDisplay* _tmp5_;
				GdkMonitor* _tmp6_;
				GdkMonitor* _tmp7_;
				GdkRectangle* _tmp8_;
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				if (!_tmp3_) {
#line 266 "PickerWindow.c"
					gint _tmp4_;
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					_tmp4_ = i;
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					i = _tmp4_ + 1;
#line 272 "PickerWindow.c"
				}
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_tmp3_ = FALSE;
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				if (!(i < n_monitors)) {
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					break;
#line 280 "PickerWindow.c"
				}
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_tmp5_ = display;
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_tmp6_ = gdk_display_get_monitor (_tmp5_, i);
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_tmp7_ = _g_object_ref0 (_tmp6_);
#line 84 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				monitor = _tmp7_;
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_tmp8_ = screens_rectangle;
#line 86 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				if (_tmp8_ == NULL) {
#line 294 "PickerWindow.c"
					GdkMonitor* _tmp9_;
					GdkRectangle _tmp10_ = {0};
					GdkRectangle* _tmp11_;
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					_tmp9_ = monitor;
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					gdk_monitor_get_geometry (_tmp9_, &_tmp10_);
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					_tmp11_ = __vala_GdkRectangle_copy0 (&_tmp10_);
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					__vala_GdkRectangle_free0 (screens_rectangle);
#line 87 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					screens_rectangle = _tmp11_;
#line 308 "PickerWindow.c"
				} else {
					GdkRectangle rectangle = {0};
					GdkMonitor* _tmp12_;
					GdkRectangle _tmp13_ = {0};
					GdkRectangle* _tmp14_;
					GdkRectangle _tmp15_;
					GdkRectangle _tmp16_ = {0};
					GdkRectangle _tmp17_;
					GdkRectangle* _tmp18_;
#line 89 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					_tmp12_ = monitor;
#line 89 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					gdk_monitor_get_geometry (_tmp12_, &_tmp13_);
#line 89 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					rectangle = _tmp13_;
#line 90 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					_tmp14_ = screens_rectangle;
#line 90 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					_tmp15_ = rectangle;
#line 90 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					gdk_rectangle_union (_tmp14_, &_tmp15_, &_tmp16_);
#line 90 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					__vala_GdkRectangle_free0 (screens_rectangle);
#line 90 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					_tmp17_ = _tmp16_;
#line 90 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					_tmp18_ = __vala_GdkRectangle_copy0 (&_tmp17_);
#line 90 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					screens_rectangle = _tmp18_;
#line 338 "PickerWindow.c"
				}
#line 83 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_g_object_unref0 (monitor);
#line 342 "PickerWindow.c"
			}
		}
	}
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp19_ = screens_rectangle;
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp20_ = screens_rectangle;
#line 94 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gtk_window_set_default_size ((GtkWindow*) self, (*_tmp19_).width, (*_tmp20_).height);
#line 67 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	__vala_GdkRectangle_free0 (screens_rectangle);
#line 67 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (display);
#line 67 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return self;
#line 358 "PickerWindow.c"
}

SpicePickerWindow*
spice_picker_window_new (void)
{
#line 67 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return spice_picker_window_construct (SPICE_TYPE_PICKER_WINDOW);
#line 366 "PickerWindow.c"
}

static gboolean
spice_picker_window_real_button_release_event (GtkWidget* base,
                                               GdkEventButton* e)
{
	SpicePickerWindow * self;
	gboolean result;
#line 97 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self = (SpicePickerWindow*) base;
#line 97 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_val_if_fail (e != NULL, FALSE);
#line 98 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	if (e->button == ((guint) 1)) {
#line 381 "PickerWindow.c"
		GdkRGBA color = {0};
		GdkRGBA _tmp0_ = {0};
		GdkRGBA _tmp1_;
#line 99 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		spice_picker_window_get_color_at (self, (gint) e->x_root, (gint) e->y_root, &_tmp0_);
#line 99 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		color = _tmp0_;
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp1_ = color;
#line 100 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		g_signal_emit (self, spice_picker_window_signals[SPICE_PICKER_WINDOW_PICKED_SIGNAL], 0, &_tmp1_);
#line 393 "PickerWindow.c"
	} else {
#line 101 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		if (e->button == ((guint) 3)) {
#line 102 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			g_signal_emit (self, spice_picker_window_signals[SPICE_PICKER_WINDOW_CANCELLED_SIGNAL], 0);
#line 399 "PickerWindow.c"
		}
	}
#line 105 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	result = TRUE;
#line 105 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return result;
#line 406 "PickerWindow.c"
}

static gboolean
spice_picker_window_real_draw (GtkWidget* base,
                               cairo_t* cr)
{
	SpicePickerWindow * self;
	gboolean result;
#line 108 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self = (SpicePickerWindow*) base;
#line 108 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 109 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	result = FALSE;
#line 109 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return result;
#line 423 "PickerWindow.c"
}

static gboolean
spice_picker_window_real_motion_notify_event (GtkWidget* base,
                                              GdkEventMotion* e)
{
	SpicePickerWindow * self;
	GdkRGBA color = {0};
	GdkRGBA _tmp0_ = {0};
	GdkRGBA _tmp1_;
	gboolean result;
#line 112 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self = (SpicePickerWindow*) base;
#line 112 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_val_if_fail (e != NULL, FALSE);
#line 113 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	spice_picker_window_get_color_at (self, (gint) e->x_root, (gint) e->y_root, &_tmp0_);
#line 113 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	color = _tmp0_;
#line 114 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp1_ = color;
#line 114 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_signal_emit (self, spice_picker_window_signals[SPICE_PICKER_WINDOW_MOVED_SIGNAL], 0, &_tmp1_);
#line 116 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	spice_picker_window_set_magnifier_cursor (self);
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	result = TRUE;
#line 118 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return result;
#line 453 "PickerWindow.c"
}

static gboolean
spice_picker_window_real_scroll_event (GtkWidget* base,
                                       GdkEventScroll* e)
{
	SpicePickerWindow * self;
	gboolean result;
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self = (SpicePickerWindow*) base;
#line 121 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_val_if_fail (e != NULL, FALSE);
#line 122 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	switch (e->direction) {
#line 122 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		case GDK_SCROLL_UP:
#line 470 "PickerWindow.c"
		{
			gint _tmp0_;
			gint _tmp1_;
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			_tmp0_ = spice_picker_window_get_zoomlevel (self);
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			_tmp1_ = _tmp0_;
#line 124 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			spice_picker_window_set_zoomlevel (self, _tmp1_ + 1);
#line 125 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			break;
#line 482 "PickerWindow.c"
		}
#line 122 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		case GDK_SCROLL_DOWN:
#line 486 "PickerWindow.c"
		{
			gint _tmp2_;
			gint _tmp3_;
#line 127 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			_tmp2_ = spice_picker_window_get_zoomlevel (self);
#line 127 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			_tmp3_ = _tmp2_;
#line 127 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			spice_picker_window_set_zoomlevel (self, _tmp3_ - 1);
#line 128 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			break;
#line 498 "PickerWindow.c"
		}
		default:
		{
#line 130 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			break;
#line 504 "PickerWindow.c"
		}
	}
#line 133 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	result = TRUE;
#line 133 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return result;
#line 511 "PickerWindow.c"
}

static void
_vala_GdkEvent_free (GdkEvent* self)
{
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_boxed_free (gdk_event_get_type (), self);
#line 519 "PickerWindow.c"
}

static void
spice_picker_window_set_magnifier_cursor (SpicePickerWindow* self)
{
	GdkSeat* manager = NULL;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkSeat* _tmp2_;
	gint px = 0;
	gint py = 0;
	GdkSeat* _tmp3_;
	GdkDevice* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint radius = 0;
	gint _tmp7_;
	gint _tmp8_;
	GdkPixbuf* latest_pb = NULL;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* scaled_pb = NULL;
	GdkPixbuf* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GdkPixbuf* _tmp15_;
	cairo_surface_t* base_surface = NULL;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	cairo_surface_t* _tmp20_;
	cairo_t* base_context = NULL;
	cairo_surface_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
	GdkPixbuf* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	gdouble shadow_alpha = 0.0;
	cairo_t* _tmp30_;
	cairo_t* _tmp37_;
	GdkRGBA _tmp38_;
	cairo_t* _tmp39_;
	cairo_t* _tmp40_;
	cairo_t* _tmp41_;
	cairo_t* _tmp42_;
	GdkRGBA _tmp43_;
	cairo_t* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	cairo_t* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	cairo_t* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	cairo_t* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	cairo_t* _tmp64_;
	cairo_t* _tmp65_;
	cairo_t* _tmp66_;
	GdkRGBA _tmp67_;
	cairo_t* _tmp68_;
	gint _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	cairo_t* _tmp73_;
	gint _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	cairo_t* _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	cairo_t* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	gint _tmp87_;
	cairo_t* _tmp88_;
	cairo_t* _tmp89_;
	GdkPixbuf* drawn_pb = NULL;
	cairo_surface_t* _tmp90_;
	cairo_surface_t* _tmp91_;
	cairo_surface_t* _tmp92_;
	GdkPixbuf* _tmp93_;
	GdkScreen* _tmp94_;
	GdkDisplay* _tmp95_;
	GdkCursor* _tmp96_;
	GdkEvent* events = NULL;
	GdkEvent* _tmp97_;
	GdkSeat* _tmp98_;
	GdkWindow* _tmp99_;
	GdkCursor* _tmp100_;
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_if_fail (self != NULL);
#line 138 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp0_ = gdk_display_get_default ();
#line 138 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
#line 138 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 138 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	manager = _tmp2_;
#line 141 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp3_ = manager;
#line 141 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp4_ = gdk_seat_get_pointer (_tmp3_);
#line 141 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gdk_device_get_position (_tmp4_, NULL, &_tmp5_, &_tmp6_);
#line 141 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	px = _tmp5_;
#line 141 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	py = _tmp6_;
#line 143 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp7_ = spice_picker_window_get_zoomlevel (self);
#line 143 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp8_ = _tmp7_;
#line 143 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	radius = (SPICE_PICKER_WINDOW_SNAPSIZE * _tmp8_) / 2;
#line 146 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp9_ = spice_picker_window_snap (self, px - (SPICE_PICKER_WINDOW_SNAPSIZE / 2), py - (SPICE_PICKER_WINDOW_SNAPSIZE / 2), SPICE_PICKER_WINDOW_SNAPSIZE, SPICE_PICKER_WINDOW_SNAPSIZE);
#line 146 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	latest_pb = _tmp9_;
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp10_ = latest_pb;
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp11_ = spice_picker_window_get_zoomlevel (self);
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp12_ = _tmp11_;
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp13_ = spice_picker_window_get_zoomlevel (self);
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp14_ = _tmp13_;
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp15_ = gdk_pixbuf_scale_simple (_tmp10_, (SPICE_PICKER_WINDOW_SNAPSIZE * _tmp12_) + (SPICE_PICKER_WINDOW_SHADOW_WIDTH * 2), (SPICE_PICKER_WINDOW_SNAPSIZE * _tmp14_) + (SPICE_PICKER_WINDOW_SHADOW_WIDTH * 2), GDK_INTERP_NEAREST);
#line 149 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	scaled_pb = _tmp15_;
#line 152 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp16_ = spice_picker_window_get_zoomlevel (self);
#line 152 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp17_ = _tmp16_;
#line 152 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp18_ = spice_picker_window_get_zoomlevel (self);
#line 152 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp19_ = _tmp18_;
#line 152 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp20_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (SPICE_PICKER_WINDOW_SNAPSIZE * _tmp17_) + (SPICE_PICKER_WINDOW_SHADOW_WIDTH * 2), (SPICE_PICKER_WINDOW_SNAPSIZE * _tmp19_) + (SPICE_PICKER_WINDOW_SHADOW_WIDTH * 2));
#line 152 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	base_surface = _tmp20_;
#line 153 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp21_ = base_surface;
#line 153 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp22_ = cairo_create (_tmp21_);
#line 153 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	base_context = _tmp22_;
#line 156 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp23_ = base_context;
#line 156 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_arc (_tmp23_, (gdouble) (radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH), (gdouble) (radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH), (gdouble) radius, (gdouble) 0, 2 * G_PI);
#line 159 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp24_ = base_context;
#line 159 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp25_ = scaled_pb;
#line 159 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gdk_cairo_set_source_pixbuf (_tmp24_, _tmp25_, (gdouble) 0, (gdouble) 0);
#line 162 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp26_ = base_context;
#line 162 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_save (_tmp26_);
#line 163 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp27_ = base_context;
#line 163 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_clip_preserve (_tmp27_);
#line 164 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp28_ = base_context;
#line 164 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_paint (_tmp28_);
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp29_ = base_context;
#line 165 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_restore (_tmp29_);
#line 168 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	shadow_alpha = 0.6;
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp30_ = base_context;
#line 169 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_set_line_width (_tmp30_, (gdouble) 1);
#line 725 "PickerWindow.c"
	{
		gint i = 0;
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		i = 0;
#line 730 "PickerWindow.c"
		{
			gboolean _tmp31_ = FALSE;
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			_tmp31_ = TRUE;
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			while (TRUE) {
#line 737 "PickerWindow.c"
				cairo_t* _tmp33_;
				GdkRGBA shadow_color = {0};
				cairo_t* _tmp34_;
				GdkRGBA _tmp35_;
				cairo_t* _tmp36_;
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				if (!_tmp31_) {
#line 745 "PickerWindow.c"
					gint _tmp32_;
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					_tmp32_ = i;
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					i = _tmp32_ + 1;
#line 751 "PickerWindow.c"
				}
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_tmp31_ = FALSE;
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				if (!(i <= SPICE_PICKER_WINDOW_SHADOW_WIDTH)) {
#line 171 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
					break;
#line 759 "PickerWindow.c"
				}
#line 172 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_tmp33_ = base_context;
#line 172 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				cairo_arc (_tmp33_, (gdouble) (radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH), (gdouble) (radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH), (gdouble) ((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) - i), (gdouble) 0, 2 * G_PI);
#line 173 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				memset (&shadow_color, 0, sizeof (GdkRGBA));
#line 174 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				gdk_rgba_parse (&shadow_color, SPICE_PICKER_WINDOW_dark_border_color_string);
#line 175 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				shadow_color.alpha = shadow_alpha / (((SPICE_PICKER_WINDOW_SHADOW_WIDTH - i) + 1) * ((SPICE_PICKER_WINDOW_SHADOW_WIDTH - i) + 1));
#line 176 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_tmp34_ = base_context;
#line 176 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_tmp35_ = shadow_color;
#line 176 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				gdk_cairo_set_source_rgba (_tmp34_, &_tmp35_);
#line 177 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				_tmp36_ = base_context;
#line 177 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
				cairo_stroke (_tmp36_);
#line 781 "PickerWindow.c"
			}
		}
	}
#line 181 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp37_ = base_context;
#line 181 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp38_ = self->priv->bright_border_color;
#line 181 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gdk_cairo_set_source_rgba (_tmp37_, &_tmp38_);
#line 182 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp39_ = base_context;
#line 182 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_arc (_tmp39_, (gdouble) (radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH), (gdouble) (radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH), (gdouble) (radius - 1), (gdouble) 0, 2 * G_PI);
#line 183 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp40_ = base_context;
#line 183 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_stroke (_tmp40_);
#line 186 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp41_ = base_context;
#line 186 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_set_line_width (_tmp41_, (gdouble) 1);
#line 188 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp42_ = base_context;
#line 188 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp43_ = self->priv->dark_border_color;
#line 188 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gdk_cairo_set_source_rgba (_tmp42_, &_tmp43_);
#line 189 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp44_ = base_context;
#line 189 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp45_ = spice_picker_window_get_zoomlevel (self);
#line 189 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp46_ = _tmp45_;
#line 189 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp47_ = spice_picker_window_get_zoomlevel (self);
#line 189 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp48_ = _tmp47_;
#line 189 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_move_to (_tmp44_, (gdouble) ((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) - _tmp46_), (gdouble) ((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) - _tmp48_));
#line 190 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp49_ = base_context;
#line 190 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp50_ = spice_picker_window_get_zoomlevel (self);
#line 190 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp51_ = _tmp50_;
#line 190 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp52_ = spice_picker_window_get_zoomlevel (self);
#line 190 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp53_ = _tmp52_;
#line 190 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_line_to (_tmp49_, (gdouble) ((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) + _tmp51_), (gdouble) ((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) - _tmp53_));
#line 191 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp54_ = base_context;
#line 191 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp55_ = spice_picker_window_get_zoomlevel (self);
#line 191 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp56_ = _tmp55_;
#line 191 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp57_ = spice_picker_window_get_zoomlevel (self);
#line 191 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp58_ = _tmp57_;
#line 191 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_line_to (_tmp54_, (gdouble) ((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) + _tmp56_), (gdouble) ((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) + _tmp58_));
#line 192 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp59_ = base_context;
#line 192 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp60_ = spice_picker_window_get_zoomlevel (self);
#line 192 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp61_ = _tmp60_;
#line 192 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp62_ = spice_picker_window_get_zoomlevel (self);
#line 192 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp63_ = _tmp62_;
#line 192 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_line_to (_tmp59_, (gdouble) ((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) - _tmp61_), (gdouble) ((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) + _tmp63_));
#line 193 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp64_ = base_context;
#line 193 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_close_path (_tmp64_);
#line 194 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp65_ = base_context;
#line 194 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_stroke (_tmp65_);
#line 196 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp66_ = base_context;
#line 196 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp67_ = self->priv->bright_border_color;
#line 196 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gdk_cairo_set_source_rgba (_tmp66_, &_tmp67_);
#line 197 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp68_ = base_context;
#line 197 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp69_ = spice_picker_window_get_zoomlevel (self);
#line 197 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp70_ = _tmp69_;
#line 197 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp71_ = spice_picker_window_get_zoomlevel (self);
#line 197 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp72_ = _tmp71_;
#line 197 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_move_to (_tmp68_, (gdouble) (((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) - _tmp70_) + 1), (gdouble) (((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) - _tmp72_) + 1));
#line 198 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp73_ = base_context;
#line 198 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp74_ = spice_picker_window_get_zoomlevel (self);
#line 198 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp75_ = _tmp74_;
#line 198 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp76_ = spice_picker_window_get_zoomlevel (self);
#line 198 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp77_ = _tmp76_;
#line 198 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_line_to (_tmp73_, (gdouble) (((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) + _tmp75_) - 1), (gdouble) (((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) - _tmp77_) + 1));
#line 199 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp78_ = base_context;
#line 199 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp79_ = spice_picker_window_get_zoomlevel (self);
#line 199 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp80_ = _tmp79_;
#line 199 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp81_ = spice_picker_window_get_zoomlevel (self);
#line 199 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp82_ = _tmp81_;
#line 199 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_line_to (_tmp78_, (gdouble) (((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) + _tmp80_) - 1), (gdouble) (((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) + _tmp82_) - 1));
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp83_ = base_context;
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp84_ = spice_picker_window_get_zoomlevel (self);
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp85_ = _tmp84_;
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp86_ = spice_picker_window_get_zoomlevel (self);
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp87_ = _tmp86_;
#line 200 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_line_to (_tmp83_, (gdouble) (((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) - _tmp85_) + 1), (gdouble) (((radius + SPICE_PICKER_WINDOW_SHADOW_WIDTH) + _tmp87_) - 1));
#line 201 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp88_ = base_context;
#line 201 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_close_path (_tmp88_);
#line 202 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp89_ = base_context;
#line 202 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	cairo_stroke (_tmp89_);
#line 205 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp90_ = base_surface;
#line 205 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp91_ = base_surface;
#line 205 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp92_ = base_surface;
#line 205 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp93_ = gdk_pixbuf_get_from_surface (_tmp90_, 0, 0, cairo_image_surface_get_width (_tmp91_), cairo_image_surface_get_height (_tmp92_));
#line 205 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	drawn_pb = _tmp93_;
#line 207 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp94_ = gtk_window_get_screen ((GtkWindow*) self);
#line 207 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp95_ = gdk_screen_get_display (_tmp94_);
#line 207 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp96_ = gdk_cursor_new_from_pixbuf (_tmp95_, drawn_pb, gdk_pixbuf_get_width (drawn_pb) / 2, gdk_pixbuf_get_height (drawn_pb) / 2);
#line 207 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (self->priv->magnifier);
#line 207 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self->priv->magnifier = _tmp96_;
#line 214 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp97_ = gdk_event_new ((GDK_BUTTON_PRESS | GDK_MOTION_NOTIFY) | GDK_SCROLL);
#line 214 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	events = _tmp97_;
#line 217 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp98_ = manager;
#line 217 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp99_ = gtk_widget_get_window ((GtkWidget*) self);
#line 217 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp100_ = self->priv->magnifier;
#line 217 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gdk_seat_grab (_tmp98_, _tmp99_, GDK_SEAT_CAPABILITY_ALL, TRUE, _tmp100_, events, NULL, NULL);
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	__vala_GdkEvent_free0 (events);
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (drawn_pb);
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_cairo_destroy0 (base_context);
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_cairo_surface_destroy0 (base_surface);
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (scaled_pb);
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (latest_pb);
#line 136 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (manager);
#line 973 "PickerWindow.c"
}

GdkPixbuf*
spice_picker_window_snap (SpicePickerWindow* self,
                          gint x,
                          gint y,
                          gint w,
                          gint h)
{
	GdkWindow* root = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkPixbuf* screenshot = NULL;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* result;
#line 227 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 228 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp0_ = gdk_get_default_root_window ();
#line 228 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 228 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	root = _tmp1_;
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp2_ = gdk_pixbuf_get_from_window (root, x, y, w, h);
#line 230 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	screenshot = _tmp2_;
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	result = screenshot;
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (root);
#line 231 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return result;
#line 1007 "PickerWindow.c"
}

static gboolean
spice_picker_window_real_key_press_event (GtkWidget* base,
                                          GdkEventKey* e)
{
	SpicePickerWindow * self;
	gboolean result;
#line 234 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self = (SpicePickerWindow*) base;
#line 234 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_val_if_fail (e != NULL, FALSE);
#line 235 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	if (e->keyval == GDK_KEY_Escape) {
#line 236 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		g_signal_emit (self, spice_picker_window_signals[SPICE_PICKER_WINDOW_CANCELLED_SIGNAL], 0);
#line 1024 "PickerWindow.c"
	}
#line 239 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	result = TRUE;
#line 239 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return result;
#line 1030 "PickerWindow.c"
}

void
spice_picker_window_get_color_at (SpicePickerWindow* self,
                                  gint x,
                                  gint y,
                                  GdkRGBA* result)
{
	GdkWindow* root = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkPixbuf* pixbuf = NULL;
	GdkWindow* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkRGBA _tmp33_ = {0};
#line 242 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_if_fail (self != NULL);
#line 243 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp0_ = gdk_get_default_root_window ();
#line 243 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 243 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	root = _tmp1_;
#line 244 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp2_ = root;
#line 244 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp3_ = gdk_pixbuf_get_from_window (_tmp2_, x, y, 1, 1);
#line 244 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	pixbuf = _tmp3_;
#line 246 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp4_ = pixbuf;
#line 246 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	if (_tmp4_ != NULL) {
#line 1065 "PickerWindow.c"
		guint8 red = 0U;
		GdkPixbuf* _tmp5_;
		guint8* _tmp6_;
		guint8 _tmp7_;
		guint8 green = 0U;
		GdkPixbuf* _tmp8_;
		guint8* _tmp9_;
		guint8 _tmp10_;
		guint8 blue = 0U;
		GdkPixbuf* _tmp11_;
		guint8* _tmp12_;
		guint8 _tmp13_;
		GdkRGBA color = {0};
		gchar* spec = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
#line 248 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp5_ = pixbuf;
#line 248 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp6_ = gdk_pixbuf_get_pixels (_tmp5_);
#line 248 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp7_ = _tmp6_[0];
#line 248 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		red = _tmp7_;
#line 249 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp8_ = pixbuf;
#line 249 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp9_ = gdk_pixbuf_get_pixels (_tmp8_);
#line 249 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp10_ = _tmp9_[1];
#line 249 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		green = _tmp10_;
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp11_ = pixbuf;
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp12_ = gdk_pixbuf_get_pixels (_tmp11_);
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp13_ = _tmp12_[2];
#line 250 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		blue = _tmp13_;
#line 252 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		memset (&color, 0, sizeof (GdkRGBA));
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp14_ = g_strdup_printf ("%hhu", red);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp15_ = _tmp14_;
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp16_ = g_strconcat ("rgb(", _tmp15_, NULL);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp17_ = _tmp16_;
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp18_ = g_strconcat (_tmp17_, ",", NULL);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp19_ = _tmp18_;
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp20_ = g_strdup_printf ("%hhu", green);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp21_ = _tmp20_;
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp22_ = g_strconcat (_tmp19_, _tmp21_, NULL);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp23_ = _tmp22_;
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp24_ = g_strconcat (_tmp23_, ",", NULL);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp25_ = _tmp24_;
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp26_ = g_strdup_printf ("%hhu", blue);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp27_ = _tmp26_;
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp28_ = g_strconcat (_tmp25_, _tmp27_, NULL);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp29_ = _tmp28_;
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp30_ = g_strconcat (_tmp29_, ")", NULL);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp31_ = _tmp30_;
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_g_free0 (_tmp29_);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_g_free0 (_tmp27_);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_g_free0 (_tmp25_);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_g_free0 (_tmp23_);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_g_free0 (_tmp21_);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_g_free0 (_tmp19_);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_g_free0 (_tmp17_);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_g_free0 (_tmp15_);
#line 253 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		spec = _tmp31_;
#line 254 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp32_ = spec;
#line 254 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		if (gdk_rgba_parse (&color, _tmp32_)) {
#line 255 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			*result = color;
#line 255 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			_g_free0 (spec);
#line 255 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			_g_object_unref0 (pixbuf);
#line 255 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			_g_object_unref0 (root);
#line 255 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			return;
#line 1193 "PickerWindow.c"
		} else {
#line 257 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
			g_warning ("PickerWindow.vala:257: Parse of pixel rgb values failed.");
#line 1197 "PickerWindow.c"
		}
#line 246 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_g_free0 (spec);
#line 1201 "PickerWindow.c"
	}
#line 262 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_warning ("PickerWindow.vala:262: Gdk.pixbuf_get_from_window failed");
#line 263 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	memset (&_tmp33_, 0, sizeof (GdkRGBA));
#line 263 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	*result = _tmp33_;
#line 263 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (pixbuf);
#line 263 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (root);
#line 263 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return;
#line 1215 "PickerWindow.c"
}

static void
spice_picker_window_real_show_all (GtkWidget* base)
{
	SpicePickerWindow * self;
	GdkSeat* manager = NULL;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkSeat* _tmp2_;
	GdkWindow* window = NULL;
	GdkWindow* _tmp3_;
	GdkWindow* _tmp4_;
	GdkEvent* events = NULL;
	GdkEvent* _tmp5_;
	GdkGrabStatus status = 0;
	GdkSeat* _tmp6_;
	GdkWindow* _tmp7_;
	GdkWindow* _tmp8_;
	GdkDisplay* _tmp9_;
	GdkCursor* _tmp10_;
	GdkCursor* _tmp11_;
	GdkEvent* _tmp12_;
	GdkGrabStatus _tmp13_;
#line 266 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self = (SpicePickerWindow*) base;
#line 267 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	GTK_WIDGET_CLASS (spice_picker_window_parent_class)->show_all ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GRANITE_WIDGETS_TYPE_COMPOSITED_WINDOW, GraniteWidgetsCompositedWindow));
#line 269 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp0_ = gdk_display_get_default ();
#line 269 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
#line 269 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 269 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	manager = _tmp2_;
#line 270 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
#line 270 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 270 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	window = _tmp4_;
#line 272 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp5_ = gdk_event_new ((GDK_BUTTON_PRESS | GDK_MOTION_NOTIFY) | GDK_SCROLL);
#line 272 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	events = _tmp5_;
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp6_ = manager;
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp7_ = window;
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp8_ = window;
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp9_ = gdk_window_get_display (_tmp8_);
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp10_ = gdk_cursor_new_for_display (_tmp9_, GDK_CROSSHAIR);
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp11_ = _tmp10_;
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp12_ = events;
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp13_ = gdk_seat_grab (_tmp6_, _tmp7_, GDK_SEAT_CAPABILITY_ALL, TRUE, _tmp11_, _tmp12_, NULL, NULL);
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (_tmp11_);
#line 275 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	status = _tmp13_;
#line 284 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	if (status != GDK_GRAB_SUCCESS) {
#line 1284 "PickerWindow.c"
		GdkSeat* _tmp14_;
#line 285 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp14_ = manager;
#line 285 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		gdk_seat_ungrab (_tmp14_);
#line 1290 "PickerWindow.c"
	}
#line 289 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	spice_picker_window_set_magnifier_cursor (self);
#line 266 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	__vala_GdkEvent_free0 (events);
#line 266 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (window);
#line 266 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (manager);
#line 1300 "PickerWindow.c"
}

void
spice_picker_window_close (SpicePickerWindow* self)
{
	GdkWindow* _tmp0_;
#line 292 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_if_fail (self != NULL);
#line 293 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
#line 293 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gdk_window_set_cursor (_tmp0_, NULL);
#line 294 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	gtk_window_close ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, GRANITE_WIDGETS_TYPE_COMPOSITED_WINDOW, GraniteWidgetsCompositedWindow));
#line 1315 "PickerWindow.c"
}

gint
spice_picker_window_get_zoomlevel (SpicePickerWindow* self)
{
	gint result;
#line 52 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	result = spice_picker_window__zoom_level;
#line 53 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return result;
#line 1328 "PickerWindow.c"
}

void
spice_picker_window_set_zoomlevel (SpicePickerWindow* self,
                                   gint value)
{
	gboolean _tmp0_ = FALSE;
#line 55 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_return_if_fail (self != NULL);
#line 56 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	if (value >= SPICE_PICKER_WINDOW_MIN_ZOOM_LEVEL) {
#line 56 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp0_ = value <= SPICE_PICKER_WINDOW_MAX_ZOOM_LEVEL;
#line 1342 "PickerWindow.c"
	} else {
#line 56 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		_tmp0_ = FALSE;
#line 1346 "PickerWindow.c"
	}
#line 56 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	if (_tmp0_) {
#line 57 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		spice_picker_window__zoom_level = value;
#line 58 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		spice_picker_window_set_magnifier_cursor (self);
#line 1354 "PickerWindow.c"
	}
#line 55 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_picker_window_properties[SPICE_PICKER_WINDOW_ZOOMLEVEL_PROPERTY]);
#line 1358 "PickerWindow.c"
}

static GObject *
spice_picker_window_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpicePickerWindow * self;
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	parent_class = G_OBJECT_CLASS (spice_picker_window_parent_class);
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_PICKER_WINDOW, SpicePickerWindow);
#line 64 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_object_set ((GtkWindow*) self, "type", GTK_WINDOW_POPUP, NULL);
#line 63 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return obj;
#line 1379 "PickerWindow.c"
}

static void
spice_picker_window_class_init (SpicePickerWindowClass * klass,
                                gpointer klass_data)
{
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	spice_picker_window_parent_class = g_type_class_peek_parent (klass);
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_type_class_adjust_private_offset (klass, &SpicePickerWindow_private_offset);
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) spice_picker_window_real_button_release_event;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) spice_picker_window_real_draw;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget*, GdkEventMotion*)) spice_picker_window_real_motion_notify_event;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) spice_picker_window_real_scroll_event;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) spice_picker_window_real_key_press_event;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	((GtkWidgetClass *) klass)->show_all = (void (*) (GtkWidget*)) spice_picker_window_real_show_all;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_picker_window_get_property;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_picker_window_set_property;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_picker_window_constructor;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_picker_window_finalize;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_PICKER_WINDOW_ZOOMLEVEL_PROPERTY, spice_picker_window_properties[SPICE_PICKER_WINDOW_ZOOMLEVEL_PROPERTY] = g_param_spec_int ("zoomlevel", "zoomlevel", "zoomlevel", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	spice_picker_window_signals[SPICE_PICKER_WINDOW_PICKED_SIGNAL] = g_signal_new ("picked", SPICE_TYPE_PICKER_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, gdk_rgba_get_type ());
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	spice_picker_window_signals[SPICE_PICKER_WINDOW_CANCELLED_SIGNAL] = g_signal_new ("cancelled", SPICE_TYPE_PICKER_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	spice_picker_window_signals[SPICE_PICKER_WINDOW_MOVED_SIGNAL] = g_signal_new ("moved", SPICE_TYPE_PICKER_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, gdk_rgba_get_type ());
#line 1418 "PickerWindow.c"
}

static void
spice_picker_window_instance_init (SpicePickerWindow * self,
                                   gpointer klass)
{
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self->priv = spice_picker_window_get_instance_private (self);
#line 30 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	memset (&self->priv->dark_border_color, 0, sizeof (GdkRGBA));
#line 33 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	memset (&self->priv->bright_border_color, 0, sizeof (GdkRGBA));
#line 35 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self->priv->magnifier = NULL;
#line 1433 "PickerWindow.c"
}

static void
spice_picker_window_finalize (GObject * obj)
{
	SpicePickerWindow * self;
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_PICKER_WINDOW, SpicePickerWindow);
#line 35 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_g_object_unref0 (self->priv->magnifier);
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	G_OBJECT_CLASS (spice_picker_window_parent_class)->finalize (obj);
#line 1446 "PickerWindow.c"
}

static GType
spice_picker_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpicePickerWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_picker_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpicePickerWindow), 0, (GInstanceInitFunc) spice_picker_window_instance_init, NULL };
	GType spice_picker_window_type_id;
	spice_picker_window_type_id = g_type_register_static (GRANITE_WIDGETS_TYPE_COMPOSITED_WINDOW, "SpicePickerWindow", &g_define_type_info, 0);
	SpicePickerWindow_private_offset = g_type_add_instance_private (spice_picker_window_type_id, sizeof (SpicePickerWindowPrivate));
	return spice_picker_window_type_id;
}

GType
spice_picker_window_get_type (void)
{
	static volatile gsize spice_picker_window_type_id__once = 0;
	if (g_once_init_enter (&spice_picker_window_type_id__once)) {
		GType spice_picker_window_type_id;
		spice_picker_window_type_id = spice_picker_window_get_type_once ();
		g_once_init_leave (&spice_picker_window_type_id__once, spice_picker_window_type_id);
	}
	return spice_picker_window_type_id__once;
}

static void
_vala_spice_picker_window_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SpicePickerWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_PICKER_WINDOW, SpicePickerWindow);
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	switch (property_id) {
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		case SPICE_PICKER_WINDOW_ZOOMLEVEL_PROPERTY:
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		g_value_set_int (value, spice_picker_window_get_zoomlevel (self));
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		break;
#line 1487 "PickerWindow.c"
		default:
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		break;
#line 1493 "PickerWindow.c"
	}
}

static void
_vala_spice_picker_window_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SpicePickerWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_PICKER_WINDOW, SpicePickerWindow);
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	switch (property_id) {
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		case SPICE_PICKER_WINDOW_ZOOMLEVEL_PROPERTY:
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		spice_picker_window_set_zoomlevel (self, g_value_get_int (value));
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		break;
#line 1513 "PickerWindow.c"
		default:
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
		break;
#line 1519 "PickerWindow.c"
	}
}

gchar*
ext_rgba_to_css_rgb_string (ExtRGBA *self)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 301 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	_tmp0_ = g_strdup_printf ("rgb(%i, %i, %i)", (gint) ((*self).red * 255), (gint) ((*self).green * 255), (gint) ((*self).blue * 255));
#line 301 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	s = _tmp0_;
#line 305 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	result = s;
#line 305 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return result;
#line 1537 "PickerWindow.c"
}

ExtRGBA*
ext_rgba_dup (const ExtRGBA* self)
{
	ExtRGBA* dup;
#line 299 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	dup = g_new0 (ExtRGBA, 1);
#line 299 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	memcpy (dup, self, sizeof (ExtRGBA));
#line 299 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	return dup;
#line 1550 "PickerWindow.c"
}

void
ext_rgba_free (ExtRGBA* self)
{
#line 299 "../Spice-up-1.9.1/src/Widgets/ColorPicker/PickerWindow.vala"
	g_free (self);
#line 1558 "PickerWindow.c"
}

static GType
ext_rgba_get_type_once (void)
{
	GType ext_rgba_type_id;
	ext_rgba_type_id = g_boxed_type_register_static ("ExtRGBA", (GBoxedCopyFunc) ext_rgba_dup, (GBoxedFreeFunc) ext_rgba_free);
	return ext_rgba_type_id;
}

GType
ext_rgba_get_type (void)
{
	static volatile gsize ext_rgba_type_id__once = 0;
	if (g_once_init_enter (&ext_rgba_type_id__once)) {
		GType ext_rgba_type_id;
		ext_rgba_type_id = ext_rgba_get_type_once ();
		g_once_init_leave (&ext_rgba_type_id__once, ext_rgba_type_id);
	}
	return ext_rgba_type_id__once;
}

