/* CanvasItem.c generated by valac 0.56.18, the Vala compiler
 * generated from CanvasItem.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <json-glib/json-glib.h>
#include <granite.h>
#include <cairo-gobject.h>

#define SPICE_CANVAS_ITEM_MIN_SIZE 40
#define SPICE_CANVAS_ITEM_CSS ".colored.selected {\n" \
"                                     border: 2px dotted white;\n" \
"                                  }"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SPICE_CANVAS_ITEM_TYPE_TEXT,
	SPICE_CANVAS_ITEM_TYPE_IMAGE,
	SPICE_CANVAS_ITEM_TYPE_SHAPE
} SpiceCanvasItemType;

#define SPICE_TYPE_CANVAS_ITEM_TYPE (spice_canvas_item_type_get_type ())

#define SPICE_TYPE_CANVAS_ITEM (spice_canvas_item_get_type ())
#define SPICE_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem))
#define SPICE_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))
#define SPICE_IS_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_IS_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_CANVAS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))

typedef struct _SpiceCanvasItem SpiceCanvasItem;
typedef struct _SpiceCanvasItemClass SpiceCanvasItemClass;
typedef struct _SpiceCanvasItemPrivate SpiceCanvasItemPrivate;

#define SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION (spice_services_history_manager_history_action_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))

typedef struct _SpiceServicesHistoryManagerHistoryAction SpiceServicesHistoryManagerHistoryAction;
typedef struct _SpiceServicesHistoryManagerHistoryActionClass SpiceServicesHistoryManagerHistoryActionClass;

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;
enum  {
	SPICE_CANVAS_ITEM_0_PROPERTY,
	SPICE_CANVAS_ITEM_DELTA_X_PROPERTY,
	SPICE_CANVAS_ITEM_DELTA_Y_PROPERTY,
	SPICE_CANVAS_ITEM_RECTANGLE_PROPERTY,
	SPICE_CANVAS_ITEM_ITEM_VISIBLE_PROPERTY,
	SPICE_CANVAS_ITEM_SAVE_DATA_PROPERTY,
	SPICE_CANVAS_ITEM_CANVAS_PROPERTY,
	SPICE_CANVAS_ITEM_NUM_PROPERTIES
};
static GParamSpec* spice_canvas_item_properties[SPICE_CANVAS_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define SPICE_TYPE_GRABBER (spice_grabber_get_type ())
#define SPICE_GRABBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_GRABBER, SpiceGrabber))
#define SPICE_GRABBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_GRABBER, SpiceGrabberClass))
#define SPICE_IS_GRABBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_GRABBER))
#define SPICE_IS_GRABBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_GRABBER))
#define SPICE_GRABBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_GRABBER, SpiceGrabberClass))

typedef struct _SpiceGrabber SpiceGrabber;
typedef struct _SpiceGrabberClass SpiceGrabberClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SpiceCanvasPrivate SpiceCanvasPrivate;

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;

#define SPICE_CANVAS_TYPE_CANVAS_GRID (spice_canvas_canvas_grid_get_type ())
#define SPICE_CANVAS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGrid))
#define SPICE_CANVAS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))
#define SPICE_CANVAS_IS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_IS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_CANVAS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))

typedef struct _SpiceCanvasCanvasGrid SpiceCanvasCanvasGrid;
typedef struct _SpiceCanvasCanvasGridClass SpiceCanvasCanvasGridClass;

#define SPICE_SERVICES_TYPE_HISTORY_MANAGER (spice_services_history_manager_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManager))
#define SPICE_SERVICES_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))
#define SPICE_SERVICES_IS_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_IS_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_HISTORY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))

typedef struct _SpiceServicesHistoryManager SpiceServicesHistoryManager;
typedef struct _SpiceServicesHistoryManagerClass SpiceServicesHistoryManagerClass;
typedef struct _Block23Data Block23Data;
enum  {
	SPICE_CANVAS_ITEM_CLICKED_SIGNAL,
	SPICE_CANVAS_ITEM_UN_SELECT_SIGNAL,
	SPICE_CANVAS_ITEM_SET_AS_PRIMARY_SIGNAL,
	SPICE_CANVAS_ITEM_MOVE_ITEM_SIGNAL,
	SPICE_CANVAS_ITEM_CHECK_POSITION_SIGNAL,
	SPICE_CANVAS_ITEM_ACTIVE_CHANGED_SIGNAL,
	SPICE_CANVAS_ITEM_NUM_SIGNALS
};
static guint spice_canvas_item_signals[SPICE_CANVAS_ITEM_NUM_SIGNALS] = {0};

struct _SpiceCanvasItem {
	GtkEventBox parent_instance;
	SpiceCanvasItemPrivate * priv;
	gdouble start_x;
	gdouble start_y;
	gint start_w;
	gint start_h;
	gboolean holding;
	gint holding_id;
	gint real_width;
	gint real_height;
	gint real_x;
	gint real_y;
	GtkGrid* grid;
	GtkRevealer* grabber_revealer;
};

struct _SpiceCanvasItemClass {
	GtkEventBoxClass parent_class;
	gchar* (*serialise_item) (SpiceCanvasItem* self);
	void (*load_item_data) (SpiceCanvasItem* self);
	void (*style) (SpiceCanvasItem* self);
};

struct _SpiceCanvasItemPrivate {
	gint _delta_x;
	gint _delta_y;
	SpiceServicesHistoryManagerHistoryAction* undo_move_action;
	GdkRectangle rectangle_;
	JsonObject* _save_data;
	SpiceCanvas* _canvas;
};

struct _SpiceCanvas {
	GtkOverlay parent_instance;
	SpiceCanvasPrivate * priv;
	SpiceWindow* window;
	gdouble current_allocated_width;
	gdouble current_allocated_height;
	SpiceCanvasCanvasGrid* grid;
	JsonObject* save_data;
	GraniteDrawingBufferSurface* surface;
};

struct _SpiceCanvasClass {
	GtkOverlayClass parent_class;
};

struct _Block23Data {
	int _ref_count_;
	SpiceCanvasItem* self;
	SpiceGrabber* grabber_1;
	SpiceGrabber* grabber_2;
	SpiceGrabber* grabber_3;
	SpiceGrabber* grabber_4;
	SpiceGrabber* grabber_5;
	SpiceGrabber* grabber_6;
	SpiceGrabber* grabber_7;
	SpiceGrabber* grabber_8;
};

static gint SpiceCanvasItem_private_offset;
static gpointer spice_canvas_item_parent_class = NULL;

VALA_EXTERN GType spice_canvas_item_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType spice_canvas_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasItem, g_object_unref)
VALA_EXTERN GType spice_services_history_manager_history_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManagerHistoryAction, g_object_unref)
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN gchar* spice_canvas_item_serialise_item (SpiceCanvasItem* self);
VALA_EXTERN void spice_canvas_item_load_item_data (SpiceCanvasItem* self);
VALA_EXTERN void spice_canvas_item_style (SpiceCanvasItem* self);
VALA_EXTERN SpiceCanvasItem* spice_canvas_item_construct (GType object_type,
                                              SpiceCanvas* _canvas,
                                              JsonObject* _save_data);
VALA_EXTERN GType spice_grabber_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGrabber, g_object_unref)
static SpiceGrabber* spice_canvas_item_make_grabber (SpiceCanvasItem* self,
                                              gint _id,
                                              GtkAlign _halign,
                                              GtkAlign _valign,
                                              GtkOverlay* overlay);
VALA_EXTERN SpiceGrabber* spice_grabber_new (gint id);
VALA_EXTERN SpiceGrabber* spice_grabber_construct (GType object_type,
                                       gint id);
static void spice_canvas_item_connect_grabber (SpiceCanvasItem* self,
                                        SpiceGrabber* grabber);
VALA_EXTERN void spice_canvas_item_load_data (SpiceCanvasItem* self);
VALA_EXTERN JsonObject* spice_canvas_item_get_save_data (SpiceCanvasItem* self);
static gchar* spice_canvas_item_real_serialise_item (SpiceCanvasItem* self);
VALA_EXTERN gchar* spice_canvas_item_serialise (SpiceCanvasItem* self);
static void spice_canvas_item_real_load_item_data (SpiceCanvasItem* self);
VALA_EXTERN void spice_canvas_item_unselect (SpiceCanvasItem* self);
static void spice_canvas_item_real_style (SpiceCanvasItem* self);
static void __lambda62_ (SpiceCanvasItem* self,
                  GdkEventButton* event,
                  gint id);
static void spice_canvas_item_resize (SpiceCanvasItem* self,
                               gint id);
static void ___lambda62__spice_grabber_grabbed (SpiceGrabber* _sender,
                                         GdkEventButton* event,
                                         gint id,
                                         gpointer self);
static void __lambda63_ (SpiceCanvasItem* self,
                  GdkEventMotion* event);
static void ___lambda63__spice_grabber_grabbed_motion (SpiceGrabber* _sender,
                                                GdkEventMotion* event,
                                                gpointer self);
static void __lambda64_ (SpiceCanvasItem* self,
                  GdkEventButton* event);
static void ___lambda64__spice_grabber_grabbed_stoped (SpiceGrabber* _sender,
                                                GdkEventButton* event,
                                                gpointer self);
static void spice_canvas_item_set_cursor (SpiceCanvasItem* self,
                                   gint holding_id);
VALA_EXTERN void spice_canvas_item_delete (SpiceCanvasItem* self);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_item_changed (GType i_type,
                                                                                                          GBoxedCopyFunc i_dup_func,
                                                                                                          GDestroyNotify i_destroy_func,
                                                                                                          GType t_type,
                                                                                                          GBoxedCopyFunc t_dup_func,
                                                                                                          GDestroyNotify t_destroy_func,
                                                                                                          gconstpointer item,
                                                                                                          const gchar* property);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_item_changed (GType object_type,
                                                                                                                GType i_type,
                                                                                                                GBoxedCopyFunc i_dup_func,
                                                                                                                GDestroyNotify i_destroy_func,
                                                                                                                GType t_type,
                                                                                                                GBoxedCopyFunc t_dup_func,
                                                                                                                GDestroyNotify t_destroy_func,
                                                                                                                gconstpointer item,
                                                                                                                const gchar* property);
VALA_EXTERN SpiceCanvas* spice_canvas_item_get_canvas (SpiceCanvasItem* self);
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN GType spice_canvas_canvas_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasCanvasGrid, g_object_unref)
VALA_EXTERN GType spice_services_history_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManager, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManager* spice_window_get_history_manager (SpiceWindow* self);
VALA_EXTERN void spice_services_history_manager_add_undoable_action (SpiceServicesHistoryManager* self,
                                                         SpiceServicesHistoryManagerHistoryAction* action,
                                                         gboolean force_add);
VALA_EXTERN void spice_canvas_item_set_item_visible (SpiceCanvasItem* self,
                                         gboolean value);
static gboolean spice_canvas_item_real_button_press_event (GtkWidget* base,
                                                    GdkEventButton* event);
VALA_EXTERN gboolean spice_window_get_is_presenting (SpiceWindow* self);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_item_moved (GType i_type,
                                                                                                        GBoxedCopyFunc i_dup_func,
                                                                                                        GDestroyNotify i_destroy_func,
                                                                                                        GType t_type,
                                                                                                        GBoxedCopyFunc t_dup_func,
                                                                                                        GDestroyNotify t_destroy_func,
                                                                                                        gconstpointer item);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_item_moved (GType object_type,
                                                                                                              GType i_type,
                                                                                                              GBoxedCopyFunc i_dup_func,
                                                                                                              GDestroyNotify i_destroy_func,
                                                                                                              GType t_type,
                                                                                                              GBoxedCopyFunc t_dup_func,
                                                                                                              GDestroyNotify t_destroy_func,
                                                                                                              gconstpointer item);
static GdkRectangle* _vala_GdkRectangle_copy (GdkRectangle* self);
static void _vala_GdkRectangle_free (GdkRectangle* self);
VALA_EXTERN void spice_utils_set_cursor (const gchar* cursor_type);
static gboolean spice_canvas_item_real_button_release_event (GtkWidget* base,
                                                      GdkEventButton* event);
VALA_EXTERN gint spice_canvas_item_get_delta_x (SpiceCanvasItem* self);
VALA_EXTERN gint spice_canvas_item_get_delta_y (SpiceCanvasItem* self);
VALA_EXTERN void spice_canvas_item_set_delta_x (SpiceCanvasItem* self,
                                    gint value);
VALA_EXTERN void spice_canvas_item_set_delta_y (SpiceCanvasItem* self,
                                    gint value);
static gboolean spice_canvas_item_real_motion_notify_event (GtkWidget* base,
                                                     GdkEventMotion* event);
static gint spice_canvas_item_fix_position (SpiceCanvasItem* self,
                                     gint delta,
                                     gint length,
                                     gint initial_length);
static gint spice_canvas_item_fix_size (SpiceCanvasItem* self,
                                 gint size);
VALA_EXTERN gdouble spice_canvas_get_current_ratio (SpiceCanvas* self);
VALA_EXTERN void spice_canvas_item_get_rectangle (SpiceCanvasItem* self,
                                      GdkRectangle * result);
VALA_EXTERN void spice_canvas_item_set_rectangle (SpiceCanvasItem* self,
                                      GdkRectangle * value);
VALA_EXTERN gboolean spice_canvas_item_get_item_visible (SpiceCanvasItem* self);
static void spice_canvas_item_set_save_data (SpiceCanvasItem* self,
                                      JsonObject* value);
static void spice_canvas_item_set_canvas (SpiceCanvasItem* self,
                                   SpiceCanvas* value);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static GObject * spice_canvas_item_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
VALA_EXTERN void spice_utils_set_style (GtkWidget* widget,
                            const gchar* css);
static void _spice_canvas_item___lambda65_ (Block23Data* _data23_);
VALA_EXTERN void spice_grabber_set_make_visible (SpiceGrabber* self,
                                     gboolean value);
static void __spice_canvas_item___lambda65__spice_canvas_item_clicked (SpiceCanvasItem* _sender,
                                                                gpointer self);
static void _spice_canvas_item___lambda66_ (Block23Data* _data23_);
static void __spice_canvas_item___lambda66__spice_canvas_item_un_select (SpiceCanvasItem* _sender,
                                                                  gpointer self);
static void spice_canvas_item_finalize (GObject * obj);
static GType spice_canvas_item_get_type_once (void);
static void _vala_spice_canvas_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_spice_canvas_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static GType
spice_canvas_item_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SPICE_CANVAS_ITEM_TYPE_TEXT, "SPICE_CANVAS_ITEM_TYPE_TEXT", "text"}, {SPICE_CANVAS_ITEM_TYPE_IMAGE, "SPICE_CANVAS_ITEM_TYPE_IMAGE", "image"}, {SPICE_CANVAS_ITEM_TYPE_SHAPE, "SPICE_CANVAS_ITEM_TYPE_SHAPE", "shape"}, {0, NULL, NULL}};
	GType spice_canvas_item_type_type_id;
	spice_canvas_item_type_type_id = g_enum_register_static ("SpiceCanvasItemType", values);
	return spice_canvas_item_type_type_id;
}

GType
spice_canvas_item_type_get_type (void)
{
	static volatile gsize spice_canvas_item_type_type_id__once = 0;
	if (g_once_init_enter (&spice_canvas_item_type_type_id__once)) {
		GType spice_canvas_item_type_type_id;
		spice_canvas_item_type_type_id = spice_canvas_item_type_get_type_once ();
		g_once_init_leave (&spice_canvas_item_type_type_id__once, spice_canvas_item_type_type_id);
	}
	return spice_canvas_item_type_type_id__once;
}

static inline gpointer
spice_canvas_item_get_instance_private (SpiceCanvasItem* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceCanvasItem_private_offset);
}

SpiceCanvasItem*
spice_canvas_item_construct (GType object_type,
                             SpiceCanvas* _canvas,
                             JsonObject* _save_data)
{
	SpiceCanvasItem * self = NULL;
#line 89 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (_save_data != NULL, NULL);
#line 90 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self = (SpiceCanvasItem*) g_object_new (object_type, "canvas", _canvas, "save-data", _save_data, NULL);
#line 89 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return self;
#line 429 "CanvasItem.c"
}

static SpiceGrabber*
spice_canvas_item_make_grabber (SpiceCanvasItem* self,
                                gint _id,
                                GtkAlign _halign,
                                GtkAlign _valign,
                                GtkOverlay* overlay)
{
	SpiceGrabber* grabber = NULL;
	SpiceGrabber* _tmp0_;
	SpiceGrabber* result;
#line 157 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 157 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (overlay != NULL, NULL);
#line 158 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = spice_grabber_new (_id);
#line 158 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_ref_sink (_tmp0_);
#line 158 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	grabber = _tmp0_;
#line 159 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_widget_set_halign ((GtkWidget*) grabber, _halign);
#line 160 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_widget_set_valign ((GtkWidget*) grabber, _valign);
#line 162 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_connect_grabber (self, grabber);
#line 164 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_overlay_add_overlay (overlay, (GtkWidget*) grabber);
#line 166 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = grabber;
#line 166 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 464 "CanvasItem.c"
}

void
spice_canvas_item_load_data (SpiceCanvasItem* self)
{
	JsonObject* _tmp0_;
#line 169 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 170 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = self->priv->_save_data;
#line 170 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (_tmp0_ != NULL) {
#line 477 "CanvasItem.c"
		JsonObject* _tmp1_;
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
		JsonObject* _tmp4_;
#line 171 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp1_ = self->priv->_save_data;
#line 171 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		self->real_width = (gint) json_object_get_int_member (_tmp1_, "w");
#line 172 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp2_ = self->priv->_save_data;
#line 172 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		self->real_height = (gint) json_object_get_int_member (_tmp2_, "h");
#line 173 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp3_ = self->priv->_save_data;
#line 173 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		self->real_x = (gint) json_object_get_int_member (_tmp3_, "x");
#line 174 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp4_ = self->priv->_save_data;
#line 174 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		self->real_y = (gint) json_object_get_int_member (_tmp4_, "y");
#line 176 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		spice_canvas_item_load_item_data (self);
#line 178 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_signal_emit (self, spice_canvas_item_signals[SPICE_CANVAS_ITEM_CHECK_POSITION_SIGNAL], 0);
#line 502 "CanvasItem.c"
	}
}

static gchar*
spice_canvas_item_real_serialise_item (SpiceCanvasItem* self)
{
#line 182 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_critical ("Type `%s' does not implement abstract method `spice_canvas_item_serialise_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 182 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return NULL;
#line 513 "CanvasItem.c"
}

gchar*
spice_canvas_item_serialise_item (SpiceCanvasItem* self)
{
	SpiceCanvasItemClass* _klass_;
#line 182 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 182 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_klass_ = SPICE_CANVAS_ITEM_GET_CLASS (self);
#line 182 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (_klass_->serialise_item) {
#line 182 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		return _klass_->serialise_item (self);
#line 528 "CanvasItem.c"
	}
#line 182 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return NULL;
#line 532 "CanvasItem.c"
}

gchar*
spice_canvas_item_serialise (SpiceCanvasItem* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
#line 184 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 185 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = spice_canvas_item_serialise_item (self);
#line 185 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp1_ = _tmp0_;
#line 185 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp2_ = g_strdup_printf ("{\"x\": %d,\"y\": %d,\"w\": %d,\"h\": %d,%s}\n", self->real_x, self->real_y, self->real_width, self->real_height, _tmp1_);
#line 185 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp3_ = _tmp2_;
#line 185 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_free0 (_tmp1_);
#line 185 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = _tmp3_;
#line 185 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 559 "CanvasItem.c"
}

static void
spice_canvas_item_real_load_item_data (SpiceCanvasItem* self)
{
}

void
spice_canvas_item_load_item_data (SpiceCanvasItem* self)
{
	SpiceCanvasItemClass* _klass_;
#line 188 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 188 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_klass_ = SPICE_CANVAS_ITEM_GET_CLASS (self);
#line 188 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (_klass_->load_item_data) {
#line 188 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_klass_->load_item_data (self);
#line 579 "CanvasItem.c"
	}
}

void
spice_canvas_item_unselect (SpiceCanvasItem* self)
{
#line 190 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 191 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (!self->holding) {
#line 192 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_signal_emit (self, spice_canvas_item_signals[SPICE_CANVAS_ITEM_UN_SELECT_SIGNAL], 0);
#line 592 "CanvasItem.c"
	}
}

static void
spice_canvas_item_real_style (SpiceCanvasItem* self)
{
#line 196 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_critical ("Type `%s' does not implement abstract method `spice_canvas_item_style'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 196 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return;
#line 603 "CanvasItem.c"
}

void
spice_canvas_item_style (SpiceCanvasItem* self)
{
	SpiceCanvasItemClass* _klass_;
#line 196 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 196 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_klass_ = SPICE_CANVAS_ITEM_GET_CLASS (self);
#line 196 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (_klass_->style) {
#line 196 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_klass_->style (self);
#line 618 "CanvasItem.c"
	}
}

static void
__lambda62_ (SpiceCanvasItem* self,
             GdkEventButton* event,
             gint id)
{
	gboolean _tmp0_ = FALSE;
#line 199 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (event != NULL);
#line 200 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_emit_by_name ((GtkWidget*) self, "button-press-event", event, &_tmp0_);
#line 201 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_resize (self, id);
#line 634 "CanvasItem.c"
}

static void
___lambda62__spice_grabber_grabbed (SpiceGrabber* _sender,
                                    GdkEventButton* event,
                                    gint id,
                                    gpointer self)
{
#line 199 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	__lambda62_ ((SpiceCanvasItem*) self, event, id);
#line 645 "CanvasItem.c"
}

static void
__lambda63_ (SpiceCanvasItem* self,
             GdkEventMotion* event)
{
	gboolean _tmp0_ = FALSE;
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (event != NULL);
#line 205 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_emit_by_name ((GtkWidget*) self, "motion-notify-event", event, &_tmp0_);
#line 657 "CanvasItem.c"
}

static void
___lambda63__spice_grabber_grabbed_motion (SpiceGrabber* _sender,
                                           GdkEventMotion* event,
                                           gpointer self)
{
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	__lambda63_ ((SpiceCanvasItem*) self, event);
#line 667 "CanvasItem.c"
}

static void
__lambda64_ (SpiceCanvasItem* self,
             GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
#line 208 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (event != NULL);
#line 209 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_emit_by_name ((GtkWidget*) self, "button-release-event", event, &_tmp0_);
#line 679 "CanvasItem.c"
}

static void
___lambda64__spice_grabber_grabbed_stoped (SpiceGrabber* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
#line 208 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	__lambda64_ ((SpiceCanvasItem*) self, event);
#line 689 "CanvasItem.c"
}

static void
spice_canvas_item_connect_grabber (SpiceCanvasItem* self,
                                   SpiceGrabber* grabber)
{
#line 198 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 198 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (grabber != NULL);
#line 199 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_connect_object (grabber, "grabbed", (GCallback) ___lambda62__spice_grabber_grabbed, self, 0);
#line 204 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_connect_object (grabber, "grabbed-motion", (GCallback) ___lambda63__spice_grabber_grabbed_motion, self, 0);
#line 208 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_connect_object (grabber, "grabbed-stoped", (GCallback) ___lambda64__spice_grabber_grabbed_stoped, self, 0);
#line 706 "CanvasItem.c"
}

static void
spice_canvas_item_resize (SpiceCanvasItem* self,
                          gint id)
{
#line 213 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 214 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->holding = TRUE;
#line 215 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->holding_id = id;
#line 216 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_set_cursor (self, self->holding_id);
#line 721 "CanvasItem.c"
}

void
spice_canvas_item_delete (SpiceCanvasItem* self)
{
	SpiceServicesHistoryManagerHistoryAction* action = NULL;
	SpiceServicesHistoryManagerHistoryAction* _tmp0_;
	SpiceCanvas* _tmp1_;
	SpiceWindow* _tmp2_;
	SpiceServicesHistoryManager* _tmp3_;
	SpiceServicesHistoryManager* _tmp4_;
#line 219 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 220 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = spice_services_history_manager_history_action_new_item_changed (SPICE_TYPE_CANVAS_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, self, "item-visible");
#line 220 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	action = _tmp0_;
#line 221 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp1_ = self->priv->_canvas;
#line 221 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp2_ = _tmp1_->window;
#line 221 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp3_ = spice_window_get_history_manager (_tmp2_);
#line 221 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp4_ = _tmp3_;
#line 221 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_services_history_manager_add_undoable_action (_tmp4_, action, TRUE);
#line 223 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_set_item_visible (self, FALSE);
#line 219 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_object_unref0 (action);
#line 753 "CanvasItem.c"
}

static GdkRectangle*
_vala_GdkRectangle_copy (GdkRectangle* self)
{
#line 235 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return g_boxed_copy (gdk_rectangle_get_type (), self);
#line 761 "CanvasItem.c"
}

static void
_vala_GdkRectangle_free (GdkRectangle* self)
{
#line 235 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_boxed_free (gdk_rectangle_get_type (), self);
#line 769 "CanvasItem.c"
}

static gboolean
spice_canvas_item_real_button_press_event (GtkWidget* base,
                                           GdkEventButton* event)
{
	SpiceCanvasItem * self;
	SpiceCanvas* _tmp0_;
	SpiceWindow* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	SpiceServicesHistoryManagerHistoryAction* _tmp4_;
	gboolean result;
#line 226 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self = (SpiceCanvasItem*) base;
#line 226 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 227 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = self->priv->_canvas;
#line 227 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp1_ = _tmp0_->window;
#line 227 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp2_ = spice_window_get_is_presenting (_tmp1_);
#line 227 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp3_ = _tmp2_;
#line 227 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (_tmp3_) {
#line 228 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		result = FALSE;
#line 228 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		return result;
#line 801 "CanvasItem.c"
	}
#line 231 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (self->holding) {
#line 232 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		result = TRUE;
#line 232 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		return result;
#line 809 "CanvasItem.c"
	}
#line 235 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp4_ = spice_services_history_manager_history_action_new_item_moved (SPICE_TYPE_CANVAS_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, gdk_rectangle_get_type (), (GBoxedCopyFunc) _vala_GdkRectangle_copy, (GDestroyNotify) _vala_GdkRectangle_free, self);
#line 235 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_object_unref0 (self->priv->undo_move_action);
#line 235 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->priv->undo_move_action = _tmp4_;
#line 237 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->start_x = event->x_root;
#line 238 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->start_y = event->y_root;
#line 239 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->start_w = self->real_width;
#line 240 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->start_h = self->real_height;
#line 242 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->holding = TRUE;
#line 244 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_emit (self, spice_canvas_item_signals[SPICE_CANVAS_ITEM_CLICKED_SIGNAL], 0);
#line 245 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_set_cursor (self, self->holding_id);
#line 247 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = TRUE;
#line 247 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 835 "CanvasItem.c"
}

static void
spice_canvas_item_set_cursor (SpiceCanvasItem* self,
                              gint holding_id)
{
#line 250 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	switch (holding_id) {
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case 0:
#line 848 "CanvasItem.c"
		{
#line 253 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			spice_utils_set_cursor ("grabbing");
#line 254 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			break;
#line 854 "CanvasItem.c"
		}
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case 1:
#line 858 "CanvasItem.c"
		{
#line 256 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			spice_utils_set_cursor ("nw-resize");
#line 257 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			break;
#line 864 "CanvasItem.c"
		}
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case 2:
#line 868 "CanvasItem.c"
		{
#line 259 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			spice_utils_set_cursor ("n-resize");
#line 260 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			break;
#line 874 "CanvasItem.c"
		}
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case 3:
#line 878 "CanvasItem.c"
		{
#line 262 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			spice_utils_set_cursor ("ne-resize");
#line 263 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			break;
#line 884 "CanvasItem.c"
		}
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case 4:
#line 888 "CanvasItem.c"
		{
#line 265 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			spice_utils_set_cursor ("e-resize");
#line 266 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			break;
#line 894 "CanvasItem.c"
		}
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case 5:
#line 898 "CanvasItem.c"
		{
#line 268 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			spice_utils_set_cursor ("se-resize");
#line 269 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			break;
#line 904 "CanvasItem.c"
		}
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case 6:
#line 908 "CanvasItem.c"
		{
#line 271 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			spice_utils_set_cursor ("s-resize");
#line 272 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			break;
#line 914 "CanvasItem.c"
		}
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case 7:
#line 918 "CanvasItem.c"
		{
#line 274 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			spice_utils_set_cursor ("sw-resize");
#line 275 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			break;
#line 924 "CanvasItem.c"
		}
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case 8:
#line 928 "CanvasItem.c"
		{
#line 277 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			spice_utils_set_cursor ("w-resize");
#line 278 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			break;
#line 934 "CanvasItem.c"
		}
		default:
#line 251 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 939 "CanvasItem.c"
	}
}

static gboolean
spice_canvas_item_real_button_release_event (GtkWidget* base,
                                             GdkEventButton* event)
{
	SpiceCanvasItem * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	SpiceCanvas* _tmp5_;
	SpiceWindow* _tmp6_;
	SpiceServicesHistoryManager* _tmp7_;
	SpiceServicesHistoryManager* _tmp8_;
	SpiceServicesHistoryManagerHistoryAction* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean result;
#line 282 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self = (SpiceCanvasItem*) base;
#line 282 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 283 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (!self->holding) {
#line 283 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		result = FALSE;
#line 283 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		return result;
#line 970 "CanvasItem.c"
	}
#line 285 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_utils_set_cursor ("default");
#line 287 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->holding = FALSE;
#line 288 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->holding_id = 0;
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp3_ = self->priv->_delta_x;
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (_tmp3_ == 0) {
#line 982 "CanvasItem.c"
		gint _tmp4_;
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp4_ = self->priv->_delta_y;
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp2_ = _tmp4_ == 0;
#line 988 "CanvasItem.c"
	} else {
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp2_ = FALSE;
#line 992 "CanvasItem.c"
	}
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (_tmp2_) {
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp1_ = self->start_w == self->real_width;
#line 998 "CanvasItem.c"
	} else {
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp1_ = FALSE;
#line 1002 "CanvasItem.c"
	}
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (_tmp1_) {
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp0_ = self->start_h == self->real_height;
#line 1008 "CanvasItem.c"
	} else {
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp0_ = FALSE;
#line 1012 "CanvasItem.c"
	}
#line 290 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (_tmp0_) {
#line 291 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		result = FALSE;
#line 291 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		return result;
#line 1020 "CanvasItem.c"
	}
#line 294 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp5_ = self->priv->_canvas;
#line 294 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp6_ = _tmp5_->window;
#line 294 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp7_ = spice_window_get_history_manager (_tmp6_);
#line 294 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp8_ = _tmp7_;
#line 294 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp9_ = self->priv->undo_move_action;
#line 294 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_services_history_manager_add_undoable_action (_tmp8_, _tmp9_, TRUE);
#line 296 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp10_ = self->priv->_delta_x;
#line 296 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp11_ = self->priv->_delta_y;
#line 296 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_emit (self, spice_canvas_item_signals[SPICE_CANVAS_ITEM_MOVE_ITEM_SIGNAL], 0, _tmp10_, _tmp11_);
#line 297 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_set_delta_x (self, 0);
#line 298 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_set_delta_y (self, 0);
#line 300 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = FALSE;
#line 300 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 1048 "CanvasItem.c"
}

static gboolean
spice_canvas_item_real_motion_notify_event (GtkWidget* base,
                                            GdkEventMotion* event)
{
	SpiceCanvasItem * self;
	gboolean result;
#line 303 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self = (SpiceCanvasItem*) base;
#line 303 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 304 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (self->holding) {
#line 1063 "CanvasItem.c"
		gint x = 0;
		gint y = 0;
#line 305 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		x = (gint) (event->x_root - self->start_x);
#line 306 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		y = (gint) (event->y_root - self->start_y);
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		switch (self->holding_id) {
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			case 0:
#line 1074 "CanvasItem.c"
			{
#line 309 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				spice_canvas_item_set_delta_x (self, x);
#line 310 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				spice_canvas_item_set_delta_y (self, y);
#line 311 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				break;
#line 1082 "CanvasItem.c"
			}
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			case 1:
#line 1086 "CanvasItem.c"
			{
				SpiceCanvas* _tmp0_;
				gdouble _tmp1_;
				gdouble _tmp2_;
				SpiceCanvas* _tmp3_;
				gdouble _tmp4_;
				gdouble _tmp5_;
#line 313 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				spice_canvas_item_set_delta_x (self, spice_canvas_item_fix_position (self, x, self->real_width, self->start_w));
#line 314 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				spice_canvas_item_set_delta_y (self, spice_canvas_item_fix_position (self, y, self->real_height, self->start_h));
#line 315 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp0_ = self->priv->_canvas;
#line 315 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp1_ = spice_canvas_get_current_ratio (_tmp0_);
#line 315 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp2_ = _tmp1_;
#line 315 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_height = spice_canvas_item_fix_size (self, (gint) (self->start_h - ((1 / _tmp2_) * y)));
#line 316 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp3_ = self->priv->_canvas;
#line 316 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp4_ = spice_canvas_get_current_ratio (_tmp3_);
#line 316 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp5_ = _tmp4_;
#line 316 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_width = spice_canvas_item_fix_size (self, (gint) (self->start_w - ((1 / _tmp5_) * x)));
#line 317 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				break;
#line 1116 "CanvasItem.c"
			}
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			case 2:
#line 1120 "CanvasItem.c"
			{
				SpiceCanvas* _tmp6_;
				gdouble _tmp7_;
				gdouble _tmp8_;
#line 319 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				spice_canvas_item_set_delta_y (self, spice_canvas_item_fix_position (self, y, self->real_height, self->start_h));
#line 320 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp6_ = self->priv->_canvas;
#line 320 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp7_ = spice_canvas_get_current_ratio (_tmp6_);
#line 320 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp8_ = _tmp7_;
#line 320 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_height = spice_canvas_item_fix_size (self, (gint) (self->start_h - ((1 / _tmp8_) * y)));
#line 321 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				break;
#line 1137 "CanvasItem.c"
			}
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			case 3:
#line 1141 "CanvasItem.c"
			{
				SpiceCanvas* _tmp9_;
				gdouble _tmp10_;
				gdouble _tmp11_;
				SpiceCanvas* _tmp12_;
				gdouble _tmp13_;
				gdouble _tmp14_;
#line 323 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				spice_canvas_item_set_delta_y (self, spice_canvas_item_fix_position (self, y, self->real_height, self->start_h));
#line 324 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp9_ = self->priv->_canvas;
#line 324 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp10_ = spice_canvas_get_current_ratio (_tmp9_);
#line 324 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp11_ = _tmp10_;
#line 324 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_height = spice_canvas_item_fix_size (self, (gint) (self->start_h - ((1 / _tmp11_) * y)));
#line 325 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp12_ = self->priv->_canvas;
#line 325 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp13_ = spice_canvas_get_current_ratio (_tmp12_);
#line 325 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp14_ = _tmp13_;
#line 325 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_width = spice_canvas_item_fix_size (self, (gint) (self->start_w + ((1 / _tmp14_) * x)));
#line 326 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				break;
#line 1169 "CanvasItem.c"
			}
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			case 4:
#line 1173 "CanvasItem.c"
			{
				SpiceCanvas* _tmp15_;
				gdouble _tmp16_;
				gdouble _tmp17_;
#line 328 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp15_ = self->priv->_canvas;
#line 328 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp16_ = spice_canvas_get_current_ratio (_tmp15_);
#line 328 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp17_ = _tmp16_;
#line 328 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_width = spice_canvas_item_fix_size (self, (gint) (self->start_w + ((1 / _tmp17_) * x)));
#line 329 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				break;
#line 1188 "CanvasItem.c"
			}
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			case 5:
#line 1192 "CanvasItem.c"
			{
				SpiceCanvas* _tmp18_;
				gdouble _tmp19_;
				gdouble _tmp20_;
				SpiceCanvas* _tmp21_;
				gdouble _tmp22_;
				gdouble _tmp23_;
#line 331 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp18_ = self->priv->_canvas;
#line 331 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp19_ = spice_canvas_get_current_ratio (_tmp18_);
#line 331 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp20_ = _tmp19_;
#line 331 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_width = spice_canvas_item_fix_size (self, (gint) (self->start_w + ((1 / _tmp20_) * x)));
#line 332 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp21_ = self->priv->_canvas;
#line 332 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp22_ = spice_canvas_get_current_ratio (_tmp21_);
#line 332 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp23_ = _tmp22_;
#line 332 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_height = spice_canvas_item_fix_size (self, (gint) (self->start_h + ((1 / _tmp23_) * y)));
#line 333 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				break;
#line 1218 "CanvasItem.c"
			}
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			case 6:
#line 1222 "CanvasItem.c"
			{
				SpiceCanvas* _tmp24_;
				gdouble _tmp25_;
				gdouble _tmp26_;
#line 335 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp24_ = self->priv->_canvas;
#line 335 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp25_ = spice_canvas_get_current_ratio (_tmp24_);
#line 335 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp26_ = _tmp25_;
#line 335 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_height = spice_canvas_item_fix_size (self, (gint) (self->start_h + ((1 / _tmp26_) * y)));
#line 336 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				break;
#line 1237 "CanvasItem.c"
			}
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			case 7:
#line 1241 "CanvasItem.c"
			{
				SpiceCanvas* _tmp27_;
				gdouble _tmp28_;
				gdouble _tmp29_;
				SpiceCanvas* _tmp30_;
				gdouble _tmp31_;
				gdouble _tmp32_;
#line 338 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp27_ = self->priv->_canvas;
#line 338 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp28_ = spice_canvas_get_current_ratio (_tmp27_);
#line 338 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp29_ = _tmp28_;
#line 338 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_height = spice_canvas_item_fix_size (self, (gint) (self->start_h + ((1 / _tmp29_) * y)));
#line 339 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp30_ = self->priv->_canvas;
#line 339 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp31_ = spice_canvas_get_current_ratio (_tmp30_);
#line 339 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp32_ = _tmp31_;
#line 339 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_width = spice_canvas_item_fix_size (self, (gint) (self->start_w - ((1 / _tmp32_) * x)));
#line 340 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				spice_canvas_item_set_delta_x (self, spice_canvas_item_fix_position (self, x, self->real_width, self->start_w));
#line 341 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				break;
#line 1269 "CanvasItem.c"
			}
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			case 8:
#line 1273 "CanvasItem.c"
			{
				SpiceCanvas* _tmp33_;
				gdouble _tmp34_;
				gdouble _tmp35_;
#line 343 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp33_ = self->priv->_canvas;
#line 343 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp34_ = spice_canvas_get_current_ratio (_tmp33_);
#line 343 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				_tmp35_ = _tmp34_;
#line 343 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				self->real_width = spice_canvas_item_fix_size (self, (gint) (self->start_w - ((1 / _tmp35_) * x)));
#line 344 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				spice_canvas_item_set_delta_x (self, spice_canvas_item_fix_position (self, x, self->real_width, self->start_w));
#line 345 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
				break;
#line 1290 "CanvasItem.c"
			}
			default:
#line 307 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			break;
#line 1295 "CanvasItem.c"
		}
#line 348 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_signal_emit (self, spice_canvas_item_signals[SPICE_CANVAS_ITEM_CHECK_POSITION_SIGNAL], 0);
#line 1299 "CanvasItem.c"
	}
#line 351 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = FALSE;
#line 351 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 1305 "CanvasItem.c"
}

static gint
spice_canvas_item_fix_position (SpiceCanvasItem* self,
                                gint delta,
                                gint length,
                                gint initial_length)
{
	gdouble max_delta = 0.0;
	SpiceCanvas* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gint result;
#line 354 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 355 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = self->priv->_canvas;
#line 355 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp1_ = spice_canvas_get_current_ratio (_tmp0_);
#line 355 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp2_ = _tmp1_;
#line 355 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	max_delta = (initial_length - SPICE_CANVAS_ITEM_MIN_SIZE) * _tmp2_;
#line 356 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (((gdouble) delta) < max_delta) {
#line 357 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		result = delta;
#line 357 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		return result;
#line 1335 "CanvasItem.c"
	} else {
#line 359 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		result = (gint) max_delta;
#line 359 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		return result;
#line 1341 "CanvasItem.c"
	}
}

static gint
spice_canvas_item_fix_size (SpiceCanvasItem* self,
                            gint size)
{
	gint _tmp0_ = 0;
	gint result;
#line 363 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 364 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (size > SPICE_CANVAS_ITEM_MIN_SIZE) {
#line 364 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp0_ = size;
#line 1357 "CanvasItem.c"
	} else {
#line 364 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp0_ = SPICE_CANVAS_ITEM_MIN_SIZE;
#line 1361 "CanvasItem.c"
	}
#line 364 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = _tmp0_;
#line 364 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 1367 "CanvasItem.c"
}

gint
spice_canvas_item_get_delta_x (SpiceCanvasItem* self)
{
	gint result;
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = self->priv->_delta_x;
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 1380 "CanvasItem.c"
}

void
spice_canvas_item_set_delta_x (SpiceCanvasItem* self,
                               gint value)
{
	gint old_value;
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	old_value = spice_canvas_item_get_delta_x (self);
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (old_value != value) {
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		self->priv->_delta_x = value;
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_canvas_item_properties[SPICE_CANVAS_ITEM_DELTA_X_PROPERTY]);
#line 1398 "CanvasItem.c"
	}
}

gint
spice_canvas_item_get_delta_y (SpiceCanvasItem* self)
{
	gint result;
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = self->priv->_delta_y;
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 1412 "CanvasItem.c"
}

void
spice_canvas_item_set_delta_y (SpiceCanvasItem* self,
                               gint value)
{
	gint old_value;
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	old_value = spice_canvas_item_get_delta_y (self);
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (old_value != value) {
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		self->priv->_delta_y = value;
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_canvas_item_properties[SPICE_CANVAS_ITEM_DELTA_Y_PROPERTY]);
#line 1430 "CanvasItem.c"
	}
}

void
spice_canvas_item_get_rectangle (SpiceCanvasItem* self,
                                 GdkRectangle * result)
{
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
#line 45 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 46 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_.x = self->real_x;
#line 46 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_.y = self->real_y;
#line 46 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_.width = self->real_width;
#line 46 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_.height = self->real_height;
#line 46 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->priv->rectangle_ = _tmp0_;
#line 47 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp1_ = self->priv->rectangle_;
#line 47 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	*result = _tmp1_;
#line 47 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return;
#line 1458 "CanvasItem.c"
}

void
spice_canvas_item_set_rectangle (SpiceCanvasItem* self,
                                 GdkRectangle * value)
{
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
#line 48 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 49 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = *value;
#line 49 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->real_x = _tmp0_.x;
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp1_ = *value;
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->real_y = _tmp1_.y;
#line 51 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp2_ = *value;
#line 51 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->real_width = _tmp2_.width;
#line 52 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp3_ = *value;
#line 52 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->real_height = _tmp3_.height;
#line 53 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_emit (self, spice_canvas_item_signals[SPICE_CANVAS_ITEM_CHECK_POSITION_SIGNAL], 0);
#line 48 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_canvas_item_properties[SPICE_CANVAS_ITEM_RECTANGLE_PROPERTY]);
#line 1491 "CanvasItem.c"
}

gboolean
spice_canvas_item_get_item_visible (SpiceCanvasItem* self)
{
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 58 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp1_ = _tmp0_;
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = _tmp1_;
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 1510 "CanvasItem.c"
}

void
spice_canvas_item_set_item_visible (SpiceCanvasItem* self,
                                    gboolean value)
{
#line 60 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 61 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_widget_set_visible ((GtkWidget*) self, value);
#line 62 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_widget_set_no_show_all ((GtkWidget*) self, !value);
#line 60 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_canvas_item_properties[SPICE_CANVAS_ITEM_ITEM_VISIBLE_PROPERTY]);
#line 1525 "CanvasItem.c"
}

JsonObject*
spice_canvas_item_get_save_data (SpiceCanvasItem* self)
{
	JsonObject* result;
	JsonObject* _tmp0_;
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = self->priv->_save_data;
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = _tmp0_;
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 1541 "CanvasItem.c"
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return self ? json_object_ref (self) : NULL;
#line 1549 "CanvasItem.c"
}

static void
spice_canvas_item_set_save_data (SpiceCanvasItem* self,
                                 JsonObject* value)
{
	JsonObject* old_value;
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	old_value = spice_canvas_item_get_save_data (self);
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (old_value != value) {
#line 1563 "CanvasItem.c"
		JsonObject* _tmp0_;
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_tmp0_ = _json_object_ref0 (value);
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_json_object_unref0 (self->priv->_save_data);
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		self->priv->_save_data = _tmp0_;
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_canvas_item_properties[SPICE_CANVAS_ITEM_SAVE_DATA_PROPERTY]);
#line 1573 "CanvasItem.c"
	}
}

SpiceCanvas*
spice_canvas_item_get_canvas (SpiceCanvasItem* self)
{
	SpiceCanvas* result;
	SpiceCanvas* _tmp0_;
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = self->priv->_canvas;
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	result = _tmp0_;
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return result;
#line 1590 "CanvasItem.c"
}

static void
spice_canvas_item_set_canvas (SpiceCanvasItem* self,
                              SpiceCanvas* value)
{
	SpiceCanvas* old_value;
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (self != NULL);
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	old_value = spice_canvas_item_get_canvas (self);
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (old_value != value) {
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		self->priv->_canvas = value;
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_canvas_item_properties[SPICE_CANVAS_ITEM_CANVAS_PROPERTY]);
#line 1608 "CanvasItem.c"
	}
}

static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_return_if_fail (n_param_values == 3);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		data1 = closure->data;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		data2 = param_values->data[0].v_pointer;
#line 1634 "CanvasItem.c"
	} else {
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		data1 = param_values->data[0].v_pointer;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		data2 = closure->data;
#line 1640 "CanvasItem.c"
	}
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 1646 "CanvasItem.c"
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_atomic_int_inc (&_data23_->_ref_count_);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return _data23_;
#line 1656 "CanvasItem.c"
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
#line 1666 "CanvasItem.c"
		SpiceCanvasItem* self;
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		self = _data23_->self;
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_g_object_unref0 (_data23_->grabber_8);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_g_object_unref0 (_data23_->grabber_7);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_g_object_unref0 (_data23_->grabber_6);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_g_object_unref0 (_data23_->grabber_5);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_g_object_unref0 (_data23_->grabber_4);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_g_object_unref0 (_data23_->grabber_3);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_g_object_unref0 (_data23_->grabber_2);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_g_object_unref0 (_data23_->grabber_1);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		_g_object_unref0 (self);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_slice_free (Block23Data, _data23_);
#line 1690 "CanvasItem.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 101 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return self ? g_object_ref (self) : NULL;
#line 1699 "CanvasItem.c"
}

static void
_spice_canvas_item___lambda65_ (Block23Data* _data23_)
{
	SpiceCanvasItem* self;
	SpiceGrabber* _tmp0_;
	SpiceGrabber* _tmp1_;
	SpiceGrabber* _tmp2_;
	SpiceGrabber* _tmp3_;
	SpiceGrabber* _tmp4_;
	SpiceGrabber* _tmp5_;
	SpiceGrabber* _tmp6_;
	SpiceGrabber* _tmp7_;
#line 131 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self = _data23_->self;
#line 132 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = _data23_->grabber_1;
#line 132 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp0_, TRUE);
#line 133 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp1_ = _data23_->grabber_2;
#line 133 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp1_, TRUE);
#line 134 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp2_ = _data23_->grabber_3;
#line 134 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp2_, TRUE);
#line 135 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp3_ = _data23_->grabber_4;
#line 135 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp3_, TRUE);
#line 136 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp4_ = _data23_->grabber_5;
#line 136 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp4_, TRUE);
#line 137 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp5_ = _data23_->grabber_6;
#line 137 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp5_, TRUE);
#line 138 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp6_ = _data23_->grabber_7;
#line 138 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp6_, TRUE);
#line 139 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp7_ = _data23_->grabber_8;
#line 139 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp7_, TRUE);
#line 1748 "CanvasItem.c"
}

static void
__spice_canvas_item___lambda65__spice_canvas_item_clicked (SpiceCanvasItem* _sender,
                                                           gpointer self)
{
#line 131 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_spice_canvas_item___lambda65_ (self);
#line 1757 "CanvasItem.c"
}

static void
_spice_canvas_item___lambda66_ (Block23Data* _data23_)
{
	SpiceCanvasItem* self;
	SpiceGrabber* _tmp0_;
	SpiceGrabber* _tmp1_;
	SpiceGrabber* _tmp2_;
	SpiceGrabber* _tmp3_;
	SpiceGrabber* _tmp4_;
	SpiceGrabber* _tmp5_;
	SpiceGrabber* _tmp6_;
	SpiceGrabber* _tmp7_;
#line 142 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self = _data23_->self;
#line 143 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = _data23_->grabber_1;
#line 143 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp0_, FALSE);
#line 144 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp1_ = _data23_->grabber_2;
#line 144 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp1_, FALSE);
#line 145 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp2_ = _data23_->grabber_3;
#line 145 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp2_, FALSE);
#line 146 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp3_ = _data23_->grabber_4;
#line 146 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp3_, FALSE);
#line 147 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp4_ = _data23_->grabber_5;
#line 147 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp4_, FALSE);
#line 148 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp5_ = _data23_->grabber_6;
#line 148 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp5_, FALSE);
#line 149 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp6_ = _data23_->grabber_7;
#line 149 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp6_, FALSE);
#line 150 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp7_ = _data23_->grabber_8;
#line 150 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_grabber_set_make_visible (_tmp7_, FALSE);
#line 1806 "CanvasItem.c"
}

static void
__spice_canvas_item___lambda66__spice_canvas_item_un_select (SpiceCanvasItem* _sender,
                                                             gpointer self)
{
#line 142 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_spice_canvas_item___lambda66_ (self);
#line 1815 "CanvasItem.c"
}

static GObject *
spice_canvas_item_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpiceCanvasItem * self;
	Block23Data* _data23_;
	GdkEventMask _tmp0_;
	GdkEventMask _tmp1_;
	GdkEventMask _tmp2_;
	GdkEventMask _tmp3_;
	GdkEventMask _tmp4_;
	GdkEventMask _tmp5_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkGrid* _tmp9_;
	GtkRevealer* _tmp10_;
	GtkRevealer* _tmp11_;
	GtkGrid* grabber_grid = NULL;
	GtkGrid* _tmp12_;
	GtkGrid* _tmp13_;
	GtkGrid* _tmp14_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp15_;
	GtkOverlay* _tmp16_;
	GtkGrid* _tmp17_;
	GtkOverlay* _tmp18_;
	SpiceGrabber* _tmp19_;
	GtkOverlay* _tmp20_;
	SpiceGrabber* _tmp21_;
	GtkOverlay* _tmp22_;
	SpiceGrabber* _tmp23_;
	GtkOverlay* _tmp24_;
	SpiceGrabber* _tmp25_;
	GtkOverlay* _tmp26_;
	SpiceGrabber* _tmp27_;
	GtkOverlay* _tmp28_;
	SpiceGrabber* _tmp29_;
	GtkOverlay* _tmp30_;
	SpiceGrabber* _tmp31_;
	GtkOverlay* _tmp32_;
	SpiceGrabber* _tmp33_;
	GtkOverlay* _tmp34_;
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	parent_class = G_OBJECT_CLASS (spice_canvas_item_parent_class);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_ = g_slice_new0 (Block23Data);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_->_ref_count_ = 1;
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_->self = g_object_ref (self);
#line 94 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp0_ = gtk_widget_get_events ((GtkWidget*) self);
#line 94 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp1_ = _tmp0_;
#line 94 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_widget_set_events ((GtkWidget*) self, _tmp1_ | GDK_BUTTON_PRESS_MASK);
#line 95 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp2_ = gtk_widget_get_events ((GtkWidget*) self);
#line 95 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp3_ = _tmp2_;
#line 95 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_widget_set_events ((GtkWidget*) self, _tmp3_ | GDK_BUTTON_RELEASE_MASK);
#line 96 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp4_ = gtk_widget_get_events ((GtkWidget*) self);
#line 96 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp5_ = _tmp4_;
#line 96 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_widget_set_events ((GtkWidget*) self, _tmp5_ | GDK_POINTER_MOTION_MASK);
#line 98 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->real_width = 720;
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->real_height = 510;
#line 101 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 101 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 101 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	context = _tmp7_;
#line 102 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp8_ = context;
#line 102 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_style_context_add_class (_tmp8_, "colored");
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_utils_set_style ((GtkWidget*) self, SPICE_CANVAS_ITEM_CSS);
#line 111 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
#line 111 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_ref_sink (_tmp9_);
#line 111 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_object_unref0 (self->grid);
#line 111 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->grid = _tmp9_;
#line 112 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp10_ = (GtkRevealer*) gtk_revealer_new ();
#line 112 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_ref_sink (_tmp10_);
#line 112 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_object_unref0 (self->grabber_revealer);
#line 112 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->grabber_revealer = _tmp10_;
#line 113 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp11_ = self->grabber_revealer;
#line 113 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_revealer_set_transition_duration (_tmp11_, (guint) 0);
#line 114 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp12_ = (GtkGrid*) gtk_grid_new ();
#line 114 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_ref_sink (_tmp12_);
#line 114 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	grabber_grid = _tmp12_;
#line 116 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp13_ = grabber_grid;
#line 116 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_grid_set_row_homogeneous (_tmp13_, TRUE);
#line 117 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp14_ = grabber_grid;
#line 117 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_grid_set_column_homogeneous (_tmp14_, TRUE);
#line 119 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp15_ = (GtkOverlay*) gtk_overlay_new ();
#line 119 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_ref_sink (_tmp15_);
#line 119 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	overlay = _tmp15_;
#line 120 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp16_ = overlay;
#line 120 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp17_ = self->grid;
#line 120 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
#line 122 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp18_ = overlay;
#line 122 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp19_ = spice_canvas_item_make_grabber (self, 1, GTK_ALIGN_START, GTK_ALIGN_START, _tmp18_);
#line 122 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_->grabber_1 = _tmp19_;
#line 123 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp20_ = overlay;
#line 123 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp21_ = spice_canvas_item_make_grabber (self, 2, GTK_ALIGN_CENTER, GTK_ALIGN_START, _tmp20_);
#line 123 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_->grabber_2 = _tmp21_;
#line 124 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp22_ = overlay;
#line 124 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp23_ = spice_canvas_item_make_grabber (self, 3, GTK_ALIGN_END, GTK_ALIGN_START, _tmp22_);
#line 124 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_->grabber_3 = _tmp23_;
#line 125 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp24_ = overlay;
#line 125 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp25_ = spice_canvas_item_make_grabber (self, 4, GTK_ALIGN_END, GTK_ALIGN_CENTER, _tmp24_);
#line 125 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_->grabber_4 = _tmp25_;
#line 126 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp26_ = overlay;
#line 126 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp27_ = spice_canvas_item_make_grabber (self, 5, GTK_ALIGN_END, GTK_ALIGN_END, _tmp26_);
#line 126 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_->grabber_5 = _tmp27_;
#line 127 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp28_ = overlay;
#line 127 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp29_ = spice_canvas_item_make_grabber (self, 6, GTK_ALIGN_CENTER, GTK_ALIGN_END, _tmp28_);
#line 127 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_->grabber_6 = _tmp29_;
#line 128 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp30_ = overlay;
#line 128 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp31_ = spice_canvas_item_make_grabber (self, 7, GTK_ALIGN_START, GTK_ALIGN_END, _tmp30_);
#line 128 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_->grabber_7 = _tmp31_;
#line 129 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp32_ = overlay;
#line 129 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp33_ = spice_canvas_item_make_grabber (self, 8, GTK_ALIGN_START, GTK_ALIGN_CENTER, _tmp32_);
#line 129 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_->grabber_8 = _tmp33_;
#line 131 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_connect_data (self, "clicked", (GCallback) __spice_canvas_item___lambda65__spice_canvas_item_clicked, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
#line 142 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_signal_connect_data (self, "un-select", (GCallback) __spice_canvas_item___lambda66__spice_canvas_item_un_select, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
#line 153 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_tmp34_ = overlay;
#line 153 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp34_);
#line 154 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_object_unref0 (overlay);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_object_unref0 (grabber_grid);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_object_unref0 (context);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	block23_data_unref (_data23_);
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_data23_ = NULL;
#line 93 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	return obj;
#line 2027 "CanvasItem.c"
}

static void
spice_canvas_item_class_init (SpiceCanvasItemClass * klass,
                              gpointer klass_data)
{
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_parent_class = g_type_class_peek_parent (klass);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_type_class_adjust_private_offset (klass, &SpiceCanvasItem_private_offset);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	((SpiceCanvasItemClass *) klass)->serialise_item = (gchar* (*) (SpiceCanvasItem*)) spice_canvas_item_real_serialise_item;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	((SpiceCanvasItemClass *) klass)->load_item_data = (void (*) (SpiceCanvasItem*)) spice_canvas_item_real_load_item_data;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	((SpiceCanvasItemClass *) klass)->style = (void (*) (SpiceCanvasItem*)) spice_canvas_item_real_style;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) spice_canvas_item_real_button_press_event;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) spice_canvas_item_real_button_release_event;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget*, GdkEventMotion*)) spice_canvas_item_real_motion_notify_event;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_canvas_item_get_property;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_canvas_item_set_property;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_canvas_item_constructor;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_canvas_item_finalize;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CANVAS_ITEM_DELTA_X_PROPERTY, spice_canvas_item_properties[SPICE_CANVAS_ITEM_DELTA_X_PROPERTY] = g_param_spec_int ("delta-x", "delta-x", "delta-x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CANVAS_ITEM_DELTA_Y_PROPERTY, spice_canvas_item_properties[SPICE_CANVAS_ITEM_DELTA_Y_PROPERTY] = g_param_spec_int ("delta-y", "delta-y", "delta-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CANVAS_ITEM_RECTANGLE_PROPERTY, spice_canvas_item_properties[SPICE_CANVAS_ITEM_RECTANGLE_PROPERTY] = g_param_spec_boxed ("rectangle", "rectangle", "rectangle", gdk_rectangle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CANVAS_ITEM_ITEM_VISIBLE_PROPERTY, spice_canvas_item_properties[SPICE_CANVAS_ITEM_ITEM_VISIBLE_PROPERTY] = g_param_spec_boolean ("item-visible", "item-visible", "item-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CANVAS_ITEM_SAVE_DATA_PROPERTY, spice_canvas_item_properties[SPICE_CANVAS_ITEM_SAVE_DATA_PROPERTY] = g_param_spec_boxed ("save-data", "save-data", "save-data", json_object_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_CANVAS_ITEM_CANVAS_PROPERTY, spice_canvas_item_properties[SPICE_CANVAS_ITEM_CANVAS_PROPERTY] = g_param_spec_object ("canvas", "canvas", "canvas", SPICE_TYPE_CANVAS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_signals[SPICE_CANVAS_ITEM_CLICKED_SIGNAL] = g_signal_new ("clicked", SPICE_TYPE_CANVAS_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_signals[SPICE_CANVAS_ITEM_UN_SELECT_SIGNAL] = g_signal_new ("un-select", SPICE_TYPE_CANVAS_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_signals[SPICE_CANVAS_ITEM_SET_AS_PRIMARY_SIGNAL] = g_signal_new ("set-as-primary", SPICE_TYPE_CANVAS_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_signals[SPICE_CANVAS_ITEM_MOVE_ITEM_SIGNAL] = g_signal_new ("move-item", SPICE_TYPE_CANVAS_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_signals[SPICE_CANVAS_ITEM_CHECK_POSITION_SIGNAL] = g_signal_new ("check-position", SPICE_TYPE_CANVAS_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	spice_canvas_item_signals[SPICE_CANVAS_ITEM_ACTIVE_CHANGED_SIGNAL] = g_signal_new ("active-changed", SPICE_TYPE_CANVAS_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2082 "CanvasItem.c"
}

static void
spice_canvas_item_instance_init (SpiceCanvasItem * self,
                                 gpointer klass)
{
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->priv = spice_canvas_item_get_instance_private (self);
#line 39 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->priv->_delta_x = 0;
#line 40 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->priv->_delta_y = 0;
#line 66 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->start_x = (gdouble) 0;
#line 67 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->start_y = (gdouble) 0;
#line 68 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->start_w = 0;
#line 69 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->start_h = 0;
#line 72 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->holding = FALSE;
#line 73 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->holding_id = 0;
#line 75 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->real_width = 0;
#line 76 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->real_height = 0;
#line 77 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->real_x = 0;
#line 78 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self->real_y = 0;
#line 2115 "CanvasItem.c"
}

static void
spice_canvas_item_finalize (GObject * obj)
{
	SpiceCanvasItem * self;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem);
#line 42 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_object_unref0 (self->priv->undo_move_action);
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_json_object_unref0 (self->priv->_save_data);
#line 80 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_object_unref0 (self->grid);
#line 81 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	_g_object_unref0 (self->grabber_revealer);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	G_OBJECT_CLASS (spice_canvas_item_parent_class)->finalize (obj);
#line 2134 "CanvasItem.c"
}

static GType
spice_canvas_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceCanvasItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_canvas_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceCanvasItem), 0, (GInstanceInitFunc) spice_canvas_item_instance_init, NULL };
	GType spice_canvas_item_type_id;
	spice_canvas_item_type_id = g_type_register_static (gtk_event_box_get_type (), "SpiceCanvasItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SpiceCanvasItem_private_offset = g_type_add_instance_private (spice_canvas_item_type_id, sizeof (SpiceCanvasItemPrivate));
	return spice_canvas_item_type_id;
}

GType
spice_canvas_item_get_type (void)
{
	static volatile gsize spice_canvas_item_type_id__once = 0;
	if (g_once_init_enter (&spice_canvas_item_type_id__once)) {
		GType spice_canvas_item_type_id;
		spice_canvas_item_type_id = spice_canvas_item_get_type_once ();
		g_once_init_leave (&spice_canvas_item_type_id__once, spice_canvas_item_type_id);
	}
	return spice_canvas_item_type_id__once;
}

static void
_vala_spice_canvas_item_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	SpiceCanvasItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	switch (property_id) {
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_DELTA_X_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_value_set_int (value, spice_canvas_item_get_delta_x (self));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_DELTA_Y_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_value_set_int (value, spice_canvas_item_get_delta_y (self));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_RECTANGLE_PROPERTY:
#line 2183 "CanvasItem.c"
		{
			GdkRectangle boxed;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			spice_canvas_item_get_rectangle (self, &boxed);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
			g_value_set_boxed (value, &boxed);
#line 2190 "CanvasItem.c"
		}
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_ITEM_VISIBLE_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_value_set_boolean (value, spice_canvas_item_get_item_visible (self));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_SAVE_DATA_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_value_set_boxed (value, spice_canvas_item_get_save_data (self));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_CANVAS_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		g_value_set_object (value, spice_canvas_item_get_canvas (self));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 2212 "CanvasItem.c"
		default:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 2218 "CanvasItem.c"
	}
}

static void
_vala_spice_canvas_item_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	SpiceCanvasItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
	switch (property_id) {
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_DELTA_X_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		spice_canvas_item_set_delta_x (self, g_value_get_int (value));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_DELTA_Y_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		spice_canvas_item_set_delta_y (self, g_value_get_int (value));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_RECTANGLE_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		spice_canvas_item_set_rectangle (self, g_value_get_boxed (value));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_ITEM_VISIBLE_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		spice_canvas_item_set_item_visible (self, g_value_get_boolean (value));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_SAVE_DATA_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		spice_canvas_item_set_save_data (self, g_value_get_boxed (value));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		case SPICE_CANVAS_ITEM_CANVAS_PROPERTY:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		spice_canvas_item_set_canvas (self, g_value_get_object (value));
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 2268 "CanvasItem.c"
		default:
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "../Spice-up-1.9.1/src/Widgets/CanvasItems/CanvasItem.vala"
		break;
#line 2274 "CanvasItem.c"
	}
}

