/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkLabelIntensityStatisticsImageFilter.h"
#include "itkLabelImageToStatisticsLabelMapFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
LabelIntensityStatisticsImageFilter::LabelIntensityStatisticsImageFilter ()
{

  this->m_DualMemberFactory.reset( new detail::DualMemberFunctionFactory<MemberFunctionType>( this ) );
  using PixelIDTypeList2 = BasicPixelIDTypeList;
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 3 > ();
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 2 > ();





}

//
// Destructor
//
LabelIntensityStatisticsImageFilter::~LabelIntensityStatisticsImageFilter(){
  if (this->m_Filter != nullptr)
    {
      m_Filter->UnRegister();
    }
}


//
// ToString
//
std::string LabelIntensityStatisticsImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::LabelIntensityStatisticsImageFilter\n";
  out << "  BackgroundValue: ";
  this->ToStringHelper(out, this->m_BackgroundValue);
  out << std::endl;
  out << "  ComputeFeretDiameter: ";
  this->ToStringHelper(out, this->m_ComputeFeretDiameter);
  out << std::endl;
  out << "  ComputePerimeter: ";
  this->ToStringHelper(out, this->m_ComputePerimeter);
  out << std::endl;
  out << "  NumberOfBins: ";
  this->ToStringHelper(out, this->m_NumberOfBins);
  out << std::endl;
  out << "  Labels: " << this->m_Labels << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}


//
// Custom Methods
//

bool LabelIntensityStatisticsImageFilter::HasLabel(int64_t label )
{
  return std::find(m_Labels.begin(),m_Labels.end(), label) != m_Labels.end();
}

uint64_t LabelIntensityStatisticsImageFilter::GetNumberOfLabels( )
{
  return m_Labels.size();
}


//
// Execute
//
void LabelIntensityStatisticsImageFilter::Execute ( const Image & image, const Image & featureImage )
{
  const PixelIDValueEnum type1 = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();
  CheckImageMatchingDimension(  image, featureImage, "featureImage" );
  CheckImageMatchingSize(  image, featureImage, "featureImage" );
  const PixelIDValueType type2 = featureImage.GetPixelIDValue();

  return this->m_DualMemberFactory->GetMemberFunction( type1, type2, dimension )( &image, &featureImage );
}




//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType, class TImageType2>
void LabelIntensityStatisticsImageFilter::DualExecuteInternal ( const Image * inImage, const Image * inFeatureImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;
  using InputImageType2 = TImageType2;

  using OutputImageType = InputImageType;



  using FilterType = itk::LabelImageToStatisticsLabelMapFilter<InputImageType,InputImageType2, itk::LabelMap< itk::StatisticsLabelObject< int64_t, InputImageType::ImageDimension > > >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  assert( inFeatureImage != nullptr );
  filter->SetFeatureImage( this->CastImageToITK<typename FilterType::FeatureImageType>(*inFeatureImage) );


  filter->SetBackgroundValue ( static_cast< typename OutputImageType::PixelType> ( this->m_BackgroundValue ) );
  filter->SetComputeFeretDiameter ( this->m_ComputeFeretDiameter );
  filter->SetComputePerimeter ( this->m_ComputePerimeter );
  filter->SetNumberOfBins ( this->m_NumberOfBins );



  // release the old filter ( and output data )
  if ( this->m_Filter != nullptr)
    {
      this->m_pfGetBoundingBox = nullptr;
      this->m_pfGetRegion = nullptr;
      this->m_pfGetCentroid = nullptr;
      this->m_pfGetElongation = nullptr;
      this->m_pfGetEquivalentEllipsoidDiameter = nullptr;
      this->m_pfGetEquivalentSphericalPerimeter = nullptr;
      this->m_pfGetEquivalentSphericalRadius = nullptr;
      this->m_pfGetFeretDiameter = nullptr;
      this->m_pfGetFlatness = nullptr;
      this->m_pfGetNumberOfPixels = nullptr;
      this->m_pfGetNumberOfPixelsOnBorder = nullptr;
      this->m_pfGetPerimeter = nullptr;
      this->m_pfGetPerimeterOnBorder = nullptr;
      this->m_pfGetPerimeterOnBorderRatio = nullptr;
      this->m_pfGetPhysicalSize = nullptr;
      this->m_pfGetPrincipalAxes = nullptr;
      this->m_pfGetPrincipalMoments = nullptr;
      this->m_pfGetRoundness = nullptr;
      this->m_pfGetCenterOfGravity = nullptr;
      this->m_pfGetKurtosis = nullptr;
      this->m_pfGetMaximum = nullptr;
      this->m_pfGetMaximumIndex = nullptr;
      this->m_pfGetMean = nullptr;
      this->m_pfGetMedian = nullptr;
      this->m_pfGetMinimum = nullptr;
      this->m_pfGetMinimumIndex = nullptr;
      this->m_pfGetSkewness = nullptr;
      this->m_pfGetStandardDeviation = nullptr;
      this->m_pfGetSum = nullptr;
      this->m_pfGetVariance = nullptr;
      this->m_pfGetWeightedElongation = nullptr;
      this->m_pfGetWeightedFlatness = nullptr;
      this->m_pfGetWeightedPrincipalAxes = nullptr;
      this->m_pfGetWeightedPrincipalMoments = nullptr;
      this->m_Filter->UnRegister();
      this->m_Filter = nullptr;
    }

  this->m_Filter = filter;
  this->m_Filter->Register();


  this->PreUpdate( filter.GetPointer() );

  this->m_pfGetBoundingBox = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetBoundingBox();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKImageRegionToSTL(value);
  };
  this->m_pfGetRegion = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetRegion();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKImageRegionToSTL(value);
  };
  this->m_pfGetCentroid = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetCentroid();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<double>(value);
  };
  this->m_pfGetElongation = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetElongation();
    return value;
  };
  this->m_pfGetEquivalentEllipsoidDiameter = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetEquivalentEllipsoidDiameter();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<double>(value);
  };
  this->m_pfGetEquivalentSphericalPerimeter = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetEquivalentSphericalPerimeter();
    return value;
  };
  this->m_pfGetEquivalentSphericalRadius = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetEquivalentSphericalRadius();
    return value;
  };
  this->m_pfGetFeretDiameter = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetFeretDiameter();
    return value;
  };
  this->m_pfGetFlatness = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetFlatness();
    return value;
  };
  this->m_pfGetNumberOfPixels = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetNumberOfPixels();
    return value;
  };
  this->m_pfGetNumberOfPixelsOnBorder = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetNumberOfPixelsOnBorder();
    return value;
  };
  this->m_pfGetPerimeter = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPerimeter();
    return value;
  };
  this->m_pfGetPerimeterOnBorder = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPerimeterOnBorder();
    return value;
  };
  this->m_pfGetPerimeterOnBorderRatio = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPerimeterOnBorderRatio();
    return value;
  };
  this->m_pfGetPhysicalSize = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPhysicalSize();
    return value;
  };
  this->m_pfGetPrincipalAxes = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPrincipalAxes();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return std::vector<double>(value[0], value[T::RowDimensions-1]+T::ColumnDimensions);
  };
  this->m_pfGetPrincipalMoments = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPrincipalMoments();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<double>(value);
  };
  this->m_pfGetRoundness = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetRoundness();
    return value;
  };
  this->m_pfGetCenterOfGravity = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetCenterOfGravity();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<double>(value);
  };
  this->m_pfGetKurtosis = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetKurtosis();
    return value;
  };
  this->m_pfGetMaximum = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetMaximum();
    return value;
  };
  this->m_pfGetMaximumIndex = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetMaximumIndex();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<uint32_t>(value);
  };
  this->m_pfGetMean = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetMean();
    return value;
  };
  this->m_pfGetMedian = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetMedian();
    return value;
  };
  this->m_pfGetMinimum = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetMinimum();
    return value;
  };
  this->m_pfGetMinimumIndex = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetMinimumIndex();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<uint32_t>(value);
  };
  this->m_pfGetSkewness = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetSkewness();
    return value;
  };
  this->m_pfGetStandardDeviation = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetStandardDeviation();
    return value;
  };
  this->m_pfGetSum = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetSum();
    return value;
  };
  this->m_pfGetVariance = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetVariance();
    return value;
  };
  this->m_pfGetWeightedElongation = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetWeightedElongation();
    return value;
  };
  this->m_pfGetWeightedFlatness = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetWeightedFlatness();
    return value;
  };
  this->m_pfGetWeightedPrincipalAxes = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetWeightedPrincipalAxes();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return std::vector<double>(value[0], value[T::RowDimensions-1]+T::ColumnDimensions);
  };
  this->m_pfGetWeightedPrincipalMoments = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetWeightedPrincipalMoments();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<double>(value);
  };


  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();

  const std::vector<typename FilterType::OutputImageType::LabelType> tempLabels = filter->GetOutput()->GetLabels();
  this->m_Labels = std::vector<int64_t>(tempLabels.begin(), tempLabels.end());

  return;

}




//-----------------------------------------------------------------------------



}
