/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkCurvatureAnisotropicDiffusionImageFilter.h"
#include "itkCurvatureAnisotropicDiffusionImageFilter.h"

// Additional include files
#include "algorithm"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
CurvatureAnisotropicDiffusionImageFilter::CurvatureAnisotropicDiffusionImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
CurvatureAnisotropicDiffusionImageFilter::~CurvatureAnisotropicDiffusionImageFilter() = default;


//
// Custom Methods
//

double CurvatureAnisotropicDiffusionImageFilter::EstimateOptimalTimeStep(Image & inImage )
{
  std::vector<double> spacing = inImage.GetSpacing();
double minSpacing = *std::min_element( spacing.begin(), spacing.end()); this->m_TimeStep = minSpacing / std::pow(2.0, static_cast< double >( inImage.GetDimension() ) + 1.0 ); return this->m_TimeStep;
}


//
// ToString
//
std::string CurvatureAnisotropicDiffusionImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::CurvatureAnisotropicDiffusionImageFilter\n";
  out << "  TimeStep: ";
  this->ToStringHelper(out, this->m_TimeStep);
  out << std::endl;
  out << "  ConductanceParameter: ";
  this->ToStringHelper(out, this->m_ConductanceParameter);
  out << std::endl;
  out << "  ConductanceScalingUpdateInterval: ";
  this->ToStringHelper(out, this->m_ConductanceScalingUpdateInterval);
  out << std::endl;
  out << "  NumberOfIterations: ";
  this->ToStringHelper(out, this->m_NumberOfIterations);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image CurvatureAnisotropicDiffusionImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}
Image CurvatureAnisotropicDiffusionImageFilter::Execute ( Image&& image1 )
{
  Image &temp = image1;
  auto autoResetInPlace = make_scope_exit([this, &temp]{this->m_InPlace=false; Image moved(std::move(temp));});
  if (temp.IsUnique())
    {
    m_InPlace = true;
    }
  return this->Execute( image1 );
}


//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image CurvatureAnisotropicDiffusionImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::CurvatureAnisotropicDiffusionImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  filter->SetTimeStep ( this->m_TimeStep );
  filter->SetConductanceParameter ( this->m_ConductanceParameter );
  filter->SetConductanceScalingUpdateInterval ( this->m_ConductanceScalingUpdateInterval );
  filter->SetNumberOfIterations ( this->m_NumberOfIterations );
  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image CurvatureAnisotropicDiffusion ( const Image& image1, double timeStep, double conductanceParameter, unsigned int conductanceScalingUpdateInterval, uint32_t numberOfIterations )
{
  CurvatureAnisotropicDiffusionImageFilter filter;
  filter.SetTimeStep( timeStep );  filter.SetConductanceParameter( conductanceParameter );  filter.SetConductanceScalingUpdateInterval( conductanceScalingUpdateInterval );  filter.SetNumberOfIterations( numberOfIterations );
  return filter.Execute ( image1 );
}
//
// Function to run the Execute method of this filter
//
Image CurvatureAnisotropicDiffusion ( Image&& image1, double timeStep, double conductanceParameter, unsigned int conductanceScalingUpdateInterval, uint32_t numberOfIterations )
{
  CurvatureAnisotropicDiffusionImageFilter filter;
  filter.SetTimeStep( timeStep );  filter.SetConductanceParameter( conductanceParameter );  filter.SetConductanceScalingUpdateInterval( conductanceScalingUpdateInterval );  filter.SetNumberOfIterations( numberOfIterations );
  return filter.Execute ( std::move(image1) );
}

}
