/* Box.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Box.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>

#define BOX_HAND_GRENADES 12
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BOX_LOCATION_OUTSIDE,
	BOX_LOCATION_INSIDE,
	BOX_LOCATION_TOP_SIDE,
	BOX_LOCATION_LEFT_SIDE,
	BOX_LOCATION_RIGHT_SIDE,
	BOX_LOCATION_BOTTOM_SIDE,
	BOX_LOCATION_TOP_LEFT,
	BOX_LOCATION_BOTTOM_LEFT,
	BOX_LOCATION_TOP_RIGHT,
	BOX_LOCATION_BOTTOM_RIGHT
} BoxLocation;

#define TYPE_BOX_LOCATION (box_location_get_type ())
typedef enum  {
	BOX_COMPLEMENTS_NONE,
	BOX_COMPLEMENTS_VERTICAL,
	BOX_COMPLEMENTS_HORIZONTAL,
	BOX_COMPLEMENTS_BOTH
} BoxComplements;

#define TYPE_BOX_COMPLEMENTS (box_complements_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _Dimensions {
	gint width;
	gint height;
};

VALA_EXTERN GType box_location_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType box_complements_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BoxComplements box_complements_derive (gboolean horizontal_complement,
                                       gboolean vertical_complement);
VALA_EXTERN GType box_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Box* box_dup (const Box* self);
VALA_EXTERN void box_free (Box* self);
VALA_EXTERN void box_init (Box *self,
               gint left,
               gint top,
               gint right,
               gint bottom);
VALA_EXTERN void box_from_rectangle (GdkRectangle* rect,
                         Box* result);
VALA_EXTERN void box_from_allocation (GtkAllocation* alloc,
                          Box* result);
VALA_EXTERN void box_from_points (GdkPoint* corner1,
                      GdkPoint* corner2,
                      Box* result);
VALA_EXTERN void box_from_center (GdkPoint* center,
                      gint width,
                      gint height,
                      Box* result);
VALA_EXTERN gint box_get_width (Box *self);
VALA_EXTERN gint box_get_height (Box *self);
VALA_EXTERN gboolean box_is_valid (Box *self);
VALA_EXTERN gboolean box_equals (Box *self,
                     Box* box);
VALA_EXTERN void box_adjust_width (Box *self,
                       gint width);
VALA_EXTERN void box_adjust_height (Box *self,
                        gint height);
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN void box_get_scaled (Box *self,
                     Dimensions* scaled,
                     Box* result);
VALA_EXTERN void box_get_dimensions (Box *self,
                         Dimensions* result);
VALA_EXTERN void dimensions_get_scale_ratios (Dimensions *self,
                                  Dimensions* scaled,
                                  gdouble* width_ratio,
                                  gdouble* height_ratio);
VALA_EXTERN void box_get_scaled_similar (Box *self,
                             Dimensions* original,
                             Dimensions* scaled,
                             Box* result);
VALA_EXTERN void box_get_offset (Box *self,
                     gint xofs,
                     gint yofs,
                     Box* result);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN void box_get_points (Box *self,
                     GdkPoint* top_left,
                     GdkPoint* bottom_right);
VALA_EXTERN void box_get_rectangle (Box *self,
                        GdkRectangle* result);
VALA_EXTERN void box_get_center (Box *self,
                     GdkPoint* result);
VALA_EXTERN void box_rotate_clockwise (Box *self,
                           Dimensions* space,
                           Box* result);
VALA_EXTERN void box_rotate_counterclockwise (Box *self,
                                  Dimensions* space,
                                  Box* result);
VALA_EXTERN void box_flip_left_to_right (Box *self,
                             Dimensions* space,
                             Box* result);
VALA_EXTERN void box_flip_top_to_bottom (Box *self,
                             Dimensions* space,
                             Box* result);
VALA_EXTERN gboolean box_intersects (Box *self,
                         Box* compare);
VALA_EXTERN void box_get_reduced (Box *self,
                      gint amount,
                      Box* result);
VALA_EXTERN void box_get_expanded (Box *self,
                       gint amount,
                       Box* result);
VALA_EXTERN gboolean box_contains (Box *self,
                       GdkPoint* point);
VALA_EXTERN BoxComplements box_resized_complements (Box *self,
                                        Box* resized,
                                        Box* horizontal,
                                        gboolean* horizontal_enlarged,
                                        Box* vertical,
                                        gboolean* vertical_enlarged);
VALA_EXTERN BoxComplements box_shifted_complements (Box *self,
                                        Box* shifted,
                                        Box* horizontal_this,
                                        Box* vertical_this,
                                        Box* horizontal_shifted,
                                        Box* vertical_shifted);
VALA_EXTERN void box_rubber_band (Box *self,
                      GdkPoint* point,
                      Box* result);
VALA_EXTERN gchar* box_to_string (Box *self);
VALA_EXTERN gchar* dimensions_to_string (Dimensions *self);
static gboolean box_in_zone (gdouble pos,
                      gint zone);
static gboolean box_in_between (gdouble pos,
                         gint top,
                         gint bottom);
static gboolean box_near_in_between (gdouble pos,
                              gint top,
                              gint bottom);
VALA_EXTERN BoxLocation box_approx_location (Box *self,
                                 gint x,
                                 gint y);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
box_location_get_type_once (void)
{
	static const GEnumValue values[] = {{BOX_LOCATION_OUTSIDE, "BOX_LOCATION_OUTSIDE", "outside"}, {BOX_LOCATION_INSIDE, "BOX_LOCATION_INSIDE", "inside"}, {BOX_LOCATION_TOP_SIDE, "BOX_LOCATION_TOP_SIDE", "top-side"}, {BOX_LOCATION_LEFT_SIDE, "BOX_LOCATION_LEFT_SIDE", "left-side"}, {BOX_LOCATION_RIGHT_SIDE, "BOX_LOCATION_RIGHT_SIDE", "right-side"}, {BOX_LOCATION_BOTTOM_SIDE, "BOX_LOCATION_BOTTOM_SIDE", "bottom-side"}, {BOX_LOCATION_TOP_LEFT, "BOX_LOCATION_TOP_LEFT", "top-left"}, {BOX_LOCATION_BOTTOM_LEFT, "BOX_LOCATION_BOTTOM_LEFT", "bottom-left"}, {BOX_LOCATION_TOP_RIGHT, "BOX_LOCATION_TOP_RIGHT", "top-right"}, {BOX_LOCATION_BOTTOM_RIGHT, "BOX_LOCATION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
	GType box_location_type_id;
	box_location_type_id = g_enum_register_static ("BoxLocation", values);
	return box_location_type_id;
}

GType
box_location_get_type (void)
{
	static volatile gsize box_location_type_id__once = 0;
	if (g_once_init_enter (&box_location_type_id__once)) {
		GType box_location_type_id;
		box_location_type_id = box_location_get_type_once ();
		g_once_init_leave (&box_location_type_id__once, box_location_type_id);
	}
	return box_location_type_id__once;
}

BoxComplements
box_complements_derive (gboolean horizontal_complement,
                        gboolean vertical_complement)
{
	gboolean _tmp0_ = FALSE;
	BoxComplements result;
	if (horizontal_complement) {
		_tmp0_ = vertical_complement;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = BOX_COMPLEMENTS_BOTH;
		return result;
	} else {
		if (horizontal_complement) {
			result = BOX_COMPLEMENTS_HORIZONTAL;
			return result;
		} else {
			if (vertical_complement) {
				result = BOX_COMPLEMENTS_VERTICAL;
				return result;
			}
		}
	}
	result = BOX_COMPLEMENTS_NONE;
	return result;
}

static GType
box_complements_get_type_once (void)
{
	static const GEnumValue values[] = {{BOX_COMPLEMENTS_NONE, "BOX_COMPLEMENTS_NONE", "none"}, {BOX_COMPLEMENTS_VERTICAL, "BOX_COMPLEMENTS_VERTICAL", "vertical"}, {BOX_COMPLEMENTS_HORIZONTAL, "BOX_COMPLEMENTS_HORIZONTAL", "horizontal"}, {BOX_COMPLEMENTS_BOTH, "BOX_COMPLEMENTS_BOTH", "both"}, {0, NULL, NULL}};
	GType box_complements_type_id;
	box_complements_type_id = g_enum_register_static ("BoxComplements", values);
	return box_complements_type_id;
}

GType
box_complements_get_type (void)
{
	static volatile gsize box_complements_type_id__once = 0;
	if (g_once_init_enter (&box_complements_type_id__once)) {
		GType box_complements_type_id;
		box_complements_type_id = box_complements_get_type_once ();
		g_once_init_leave (&box_complements_type_id__once, box_complements_type_id);
	}
	return box_complements_type_id__once;
}

void
box_init (Box *self,
          gint left,
          gint top,
          gint right,
          gint bottom)
{
	memset (self, 0, sizeof (Box));
	left = CLAMP (left, 0, G_MAXINT);
	top = CLAMP (top, 0, G_MAXINT);
	if (right <= left) {
		right = left + 1;
	}
	if (bottom <= top) {
		bottom = top + 1;
	}
	(*self).left = left;
	(*self).top = top;
	(*self).right = right;
	(*self).bottom = bottom;
}

void
box_from_rectangle (GdkRectangle* rect,
                    Box* result)
{
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	Box _tmp6_ = {0};
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	_tmp1_ = *rect;
	_tmp2_ = *rect;
	_tmp3_ = *rect;
	_tmp4_ = *rect;
	_tmp5_ = *rect;
	box_init (&_tmp6_, _tmp0_.x, _tmp1_.y, (_tmp2_.x + _tmp3_.width) - 1, (_tmp4_.y + _tmp5_.height) - 1);
	*result = _tmp6_;
	return;
}

void
box_from_allocation (GtkAllocation* alloc,
                     Box* result)
{
	GtkAllocation _tmp0_;
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	GtkAllocation _tmp5_;
	Box _tmp6_ = {0};
	g_return_if_fail (alloc != NULL);
	_tmp0_ = *alloc;
	_tmp1_ = *alloc;
	_tmp2_ = *alloc;
	_tmp3_ = *alloc;
	_tmp4_ = *alloc;
	_tmp5_ = *alloc;
	box_init (&_tmp6_, _tmp0_.x, _tmp1_.y, (_tmp2_.x + _tmp3_.width) - 1, (_tmp4_.y + _tmp5_.height) - 1);
	*result = _tmp6_;
	return;
}

void
box_from_points (GdkPoint* corner1,
                 GdkPoint* corner2,
                 Box* result)
{
	GdkPoint _tmp0_;
	GdkPoint _tmp1_;
	GdkPoint _tmp2_;
	GdkPoint _tmp3_;
	GdkPoint _tmp4_;
	GdkPoint _tmp5_;
	GdkPoint _tmp6_;
	GdkPoint _tmp7_;
	Box _tmp8_ = {0};
	g_return_if_fail (corner1 != NULL);
	g_return_if_fail (corner2 != NULL);
	_tmp0_ = *corner1;
	_tmp1_ = *corner2;
	_tmp2_ = *corner1;
	_tmp3_ = *corner2;
	_tmp4_ = *corner1;
	_tmp5_ = *corner2;
	_tmp6_ = *corner1;
	_tmp7_ = *corner2;
	box_init (&_tmp8_, MIN (_tmp0_.x, _tmp1_.x), MIN (_tmp2_.y, _tmp3_.y), MAX (_tmp4_.x, _tmp5_.x), MAX (_tmp6_.y, _tmp7_.y));
	*result = _tmp8_;
	return;
}

void
box_from_center (GdkPoint* center,
                 gint width,
                 gint height,
                 Box* result)
{
	GdkPoint _tmp0_;
	GdkPoint _tmp1_;
	GdkPoint _tmp2_;
	GdkPoint _tmp3_;
	Box _tmp4_ = {0};
	g_return_if_fail (center != NULL);
	_tmp0_ = *center;
	_tmp1_ = *center;
	_tmp2_ = *center;
	_tmp3_ = *center;
	box_init (&_tmp4_, _tmp0_.x - (width / 2), _tmp1_.y - (height / 2), _tmp2_.x + (width / 2), _tmp3_.y + (height / 2));
	*result = _tmp4_;
	return;
}

gint
box_get_width (Box *self)
{
	gint result;
	_vala_assert ((*self).right >= (*self).left, "right >= left");
	result = ((*self).right - (*self).left) + 1;
	return result;
}

gint
box_get_height (Box *self)
{
	gint result;
	_vala_assert ((*self).bottom >= (*self).top, "bottom >= top");
	result = ((*self).bottom - (*self).top) + 1;
	return result;
}

gboolean
box_is_valid (Box *self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	if ((*self).left >= 0) {
		_tmp2_ = (*self).top >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = (*self).right >= (*self).left;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = (*self).bottom >= (*self).top;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
box_equals (Box *self,
            Box* box)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Box _tmp3_;
	gboolean result;
	g_return_val_if_fail (box != NULL, FALSE);
	_tmp3_ = *box;
	if ((*self).left == _tmp3_.left) {
		Box _tmp4_;
		_tmp4_ = *box;
		_tmp2_ = (*self).top == _tmp4_.top;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Box _tmp5_;
		_tmp5_ = *box;
		_tmp1_ = (*self).right == _tmp5_.right;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Box _tmp6_;
		_tmp6_ = *box;
		_tmp0_ = (*self).bottom == _tmp6_.bottom;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
box_adjust_width (Box *self,
                  gint width)
{
	gint center_x = 0;
	center_x = ((*self).left + (*self).right) / 2;
	(*self).left = center_x - (width / 2);
	(*self).right = center_x + (width / 2);
}

void
box_adjust_height (Box *self,
                   gint height)
{
	gint center_y = 0;
	center_y = ((*self).top + (*self).bottom) / 2;
	(*self).top = center_y - (height / 2);
	(*self).bottom = center_y + (height / 2);
}

void
box_get_scaled (Box *self,
                Dimensions* scaled,
                Box* result)
{
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gint l = 0;
	gint t = 0;
	gint r = 0;
	Dimensions _tmp4_;
	gint b = 0;
	Dimensions _tmp5_;
	Box box = {0};
	gboolean _tmp6_ = FALSE;
	Dimensions _tmp7_;
	g_return_if_fail (scaled != NULL);
	box_get_dimensions (&(*self), &_tmp0_);
	_tmp1_ = *scaled;
	dimensions_get_scale_ratios (&_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x_scale = _tmp2_;
	y_scale = _tmp3_;
	l = (gint) round (((gdouble) (*self).left) * x_scale);
	t = (gint) round (((gdouble) (*self).top) * y_scale);
	_tmp4_ = *scaled;
	r = (l + _tmp4_.width) - 1;
	_tmp5_ = *scaled;
	b = (t + _tmp5_.height) - 1;
	box_init (&box, l, t, r, b);
	_tmp7_ = *scaled;
	if (box_get_width (&box) == _tmp7_.width) {
		_tmp6_ = TRUE;
	} else {
		Dimensions _tmp8_;
		_tmp8_ = *scaled;
		_tmp6_ = box_get_height (&box) == _tmp8_.height;
	}
	_vala_assert (_tmp6_, "box.get_width() == scaled.width || box.get_height() == scaled.height");
	*result = box;
	return;
}

void
box_get_scaled_similar (Box *self,
                        Dimensions* original,
                        Dimensions* scaled,
                        Box* result)
{
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gint l = 0;
	gint t = 0;
	gint r = 0;
	gint b = 0;
	Dimensions _tmp3_;
	Dimensions _tmp5_;
	Box _tmp7_ = {0};
	g_return_if_fail (original != NULL);
	g_return_if_fail (scaled != NULL);
	_tmp0_ = *scaled;
	dimensions_get_scale_ratios (original, &_tmp0_, &_tmp1_, &_tmp2_);
	x_scale = _tmp1_;
	y_scale = _tmp2_;
	l = (gint) round (((gdouble) (*self).left) * x_scale);
	t = (gint) round (((gdouble) (*self).top) * y_scale);
	r = (gint) round (((gdouble) (*self).right) * x_scale);
	b = (gint) round (((gdouble) (*self).bottom) * y_scale);
	_tmp3_ = *scaled;
	if (r >= _tmp3_.width) {
		Dimensions _tmp4_;
		_tmp4_ = *scaled;
		r = _tmp4_.width - 1;
	}
	_tmp5_ = *scaled;
	if (b >= _tmp5_.height) {
		Dimensions _tmp6_;
		_tmp6_ = *scaled;
		b = _tmp6_.height - 1;
	}
	box_init (&_tmp7_, l, t, r, b);
	*result = _tmp7_;
	return;
}

void
box_get_offset (Box *self,
                gint xofs,
                gint yofs,
                Box* result)
{
	Box _tmp0_ = {0};
	box_init (&_tmp0_, (*self).left + xofs, (*self).top + yofs, (*self).right + xofs, (*self).bottom + yofs);
	*result = _tmp0_;
	return;
}

void
box_get_dimensions (Box *self,
                    Dimensions* result)
{
	Dimensions _tmp0_ = {0};
	dimensions_init (&_tmp0_, box_get_width (&(*self)), box_get_height (&(*self)));
	*result = _tmp0_;
	return;
}

void
box_get_points (Box *self,
                GdkPoint* top_left,
                GdkPoint* bottom_right)
{
	GdkPoint _vala_top_left = {0};
	GdkPoint _vala_bottom_right = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_ = {0};
	_tmp0_.x = (*self).left;
	_tmp0_.y = (*self).top;
	_vala_top_left = _tmp0_;
	_tmp1_.x = (*self).right;
	_tmp1_.y = (*self).bottom;
	_vala_bottom_right = _tmp1_;
	if (top_left) {
		*top_left = _vala_top_left;
	}
	if (bottom_right) {
		*bottom_right = _vala_bottom_right;
	}
}

void
box_get_rectangle (Box *self,
                   GdkRectangle* result)
{
	GdkRectangle rect = {0};
	memset (&rect, 0, sizeof (GdkRectangle));
	rect.x = (*self).left;
	rect.y = (*self).top;
	rect.width = box_get_width (&(*self));
	rect.height = box_get_height (&(*self));
	*result = rect;
	return;
}

void
box_get_center (Box *self,
                GdkPoint* result)
{
	GdkPoint _tmp0_ = {0};
	_tmp0_.x = ((*self).left + (*self).right) / 2;
	_tmp0_.y = ((*self).top + (*self).bottom) / 2;
	*result = _tmp0_;
	return;
}

void
box_rotate_clockwise (Box *self,
                      Dimensions* space,
                      Box* result)
{
	gint l = 0;
	Dimensions _tmp0_;
	gint t = 0;
	gint r = 0;
	Dimensions _tmp1_;
	gint b = 0;
	Box _tmp2_ = {0};
	g_return_if_fail (space != NULL);
	_tmp0_ = *space;
	l = (_tmp0_.width - (*self).bottom) - 1;
	t = (*self).left;
	_tmp1_ = *space;
	r = (_tmp1_.width - (*self).top) - 1;
	b = (*self).right;
	box_init (&_tmp2_, l, t, r, b);
	*result = _tmp2_;
	return;
}

void
box_rotate_counterclockwise (Box *self,
                             Dimensions* space,
                             Box* result)
{
	gint l = 0;
	gint t = 0;
	Dimensions _tmp0_;
	gint r = 0;
	gint b = 0;
	Dimensions _tmp1_;
	Box _tmp2_ = {0};
	g_return_if_fail (space != NULL);
	l = (*self).top;
	_tmp0_ = *space;
	t = (_tmp0_.height - (*self).right) - 1;
	r = (*self).bottom;
	_tmp1_ = *space;
	b = (_tmp1_.height - (*self).left) - 1;
	box_init (&_tmp2_, l, t, r, b);
	*result = _tmp2_;
	return;
}

void
box_flip_left_to_right (Box *self,
                        Dimensions* space,
                        Box* result)
{
	gint l = 0;
	Dimensions _tmp0_;
	gint r = 0;
	Dimensions _tmp1_;
	Box _tmp2_ = {0};
	g_return_if_fail (space != NULL);
	_tmp0_ = *space;
	l = (_tmp0_.width - (*self).right) - 1;
	_tmp1_ = *space;
	r = (_tmp1_.width - (*self).left) - 1;
	box_init (&_tmp2_, l, (*self).top, r, (*self).bottom);
	*result = _tmp2_;
	return;
}

void
box_flip_top_to_bottom (Box *self,
                        Dimensions* space,
                        Box* result)
{
	gint t = 0;
	Dimensions _tmp0_;
	gint b = 0;
	Dimensions _tmp1_;
	Box _tmp2_ = {0};
	g_return_if_fail (space != NULL);
	_tmp0_ = *space;
	t = (_tmp0_.height - (*self).bottom) - 1;
	_tmp1_ = *space;
	b = (_tmp1_.height - (*self).top) - 1;
	box_init (&_tmp2_, (*self).left, t, (*self).right, b);
	*result = _tmp2_;
	return;
}

gboolean
box_intersects (Box *self,
                Box* compare)
{
	gint left_intersect = 0;
	Box _tmp0_;
	gint top_intersect = 0;
	Box _tmp1_;
	gint right_intersect = 0;
	Box _tmp2_;
	gint bottom_intersect = 0;
	Box _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (compare != NULL, FALSE);
	_tmp0_ = *compare;
	left_intersect = MAX ((*self).left, _tmp0_.left);
	_tmp1_ = *compare;
	top_intersect = MAX ((*self).top, _tmp1_.top);
	_tmp2_ = *compare;
	right_intersect = MIN ((*self).right, _tmp2_.right);
	_tmp3_ = *compare;
	bottom_intersect = MIN ((*self).bottom, _tmp3_.bottom);
	if (right_intersect >= left_intersect) {
		_tmp4_ = bottom_intersect >= top_intersect;
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	return result;
}

void
box_get_reduced (Box *self,
                 gint amount,
                 Box* result)
{
	Box _tmp0_ = {0};
	box_init (&_tmp0_, (*self).left + amount, (*self).top + amount, (*self).right - amount, (*self).bottom - amount);
	*result = _tmp0_;
	return;
}

void
box_get_expanded (Box *self,
                  gint amount,
                  Box* result)
{
	Box _tmp0_ = {0};
	box_init (&_tmp0_, (*self).left - amount, (*self).top - amount, (*self).right + amount, (*self).bottom + amount);
	*result = _tmp0_;
	return;
}

gboolean
box_contains (Box *self,
              GdkPoint* point)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GdkPoint _tmp3_;
	gboolean result;
	g_return_val_if_fail (point != NULL, FALSE);
	_tmp3_ = *point;
	if (_tmp3_.x >= (*self).left) {
		GdkPoint _tmp4_;
		_tmp4_ = *point;
		_tmp2_ = _tmp4_.x <= (*self).right;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GdkPoint _tmp5_;
		_tmp5_ = *point;
		_tmp1_ = _tmp5_.y >= (*self).top;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GdkPoint _tmp6_;
		_tmp6_ = *point;
		_tmp0_ = _tmp6_.y <= (*self).bottom;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

BoxComplements
box_resized_complements (Box *self,
                         Box* resized,
                         Box* horizontal,
                         gboolean* horizontal_enlarged,
                         Box* vertical,
                         gboolean* vertical_enlarged)
{
	Box _vala_horizontal = {0};
	gboolean _vala_horizontal_enlarged = FALSE;
	Box _vala_vertical = {0};
	gboolean _vala_vertical_enlarged = FALSE;
	gboolean horizontal_complement = FALSE;
	Box _tmp0_;
	gboolean vertical_complement = FALSE;
	Box _tmp12_;
	BoxComplements result;
	g_return_val_if_fail (resized != NULL, 0);
	horizontal_complement = TRUE;
	_tmp0_ = *resized;
	if (_tmp0_.top < (*self).top) {
		Box _tmp1_;
		Box _tmp2_;
		Box _tmp3_;
		_tmp1_ = *resized;
		_tmp2_ = *resized;
		_tmp3_ = *resized;
		box_init (&_vala_horizontal, _tmp1_.left, _tmp2_.top, _tmp3_.right, (*self).top);
		_vala_horizontal_enlarged = TRUE;
	} else {
		Box _tmp4_;
		_tmp4_ = *resized;
		if (_tmp4_.top > (*self).top) {
			Box _tmp5_;
			_tmp5_ = *resized;
			box_init (&_vala_horizontal, (*self).left, (*self).top, (*self).right, _tmp5_.top);
			_vala_horizontal_enlarged = FALSE;
		} else {
			Box _tmp6_;
			_tmp6_ = *resized;
			if (_tmp6_.bottom < (*self).bottom) {
				Box _tmp7_;
				_tmp7_ = *resized;
				box_init (&_vala_horizontal, (*self).left, _tmp7_.bottom, (*self).right, (*self).bottom);
				_vala_horizontal_enlarged = FALSE;
			} else {
				Box _tmp8_;
				_tmp8_ = *resized;
				if (_tmp8_.bottom > (*self).bottom) {
					Box _tmp9_;
					Box _tmp10_;
					Box _tmp11_;
					_tmp9_ = *resized;
					_tmp10_ = *resized;
					_tmp11_ = *resized;
					box_init (&_vala_horizontal, _tmp9_.left, (*self).bottom, _tmp10_.right, _tmp11_.bottom);
					_vala_horizontal_enlarged = TRUE;
				} else {
					box_init (&_vala_horizontal, 0, 0, 0, 0);
					_vala_horizontal_enlarged = FALSE;
					horizontal_complement = FALSE;
				}
			}
		}
	}
	vertical_complement = TRUE;
	_tmp12_ = *resized;
	if (_tmp12_.left < (*self).left) {
		Box _tmp13_;
		Box _tmp14_;
		Box _tmp15_;
		_tmp13_ = *resized;
		_tmp14_ = *resized;
		_tmp15_ = *resized;
		box_init (&_vala_vertical, _tmp13_.left, _tmp14_.top, (*self).left, _tmp15_.bottom);
		_vala_vertical_enlarged = TRUE;
	} else {
		Box _tmp16_;
		_tmp16_ = *resized;
		if (_tmp16_.left > (*self).left) {
			Box _tmp17_;
			_tmp17_ = *resized;
			box_init (&_vala_vertical, (*self).left, (*self).top, _tmp17_.left, (*self).bottom);
			_vala_vertical_enlarged = FALSE;
		} else {
			Box _tmp18_;
			_tmp18_ = *resized;
			if (_tmp18_.right < (*self).right) {
				Box _tmp19_;
				_tmp19_ = *resized;
				box_init (&_vala_vertical, _tmp19_.right, (*self).top, (*self).right, (*self).bottom);
				_vala_vertical_enlarged = FALSE;
			} else {
				Box _tmp20_;
				_tmp20_ = *resized;
				if (_tmp20_.right > (*self).right) {
					Box _tmp21_;
					Box _tmp22_;
					Box _tmp23_;
					_tmp21_ = *resized;
					_tmp22_ = *resized;
					_tmp23_ = *resized;
					box_init (&_vala_vertical, (*self).right, _tmp21_.top, _tmp22_.right, _tmp23_.bottom);
					_vala_vertical_enlarged = TRUE;
				} else {
					box_init (&_vala_vertical, 0, 0, 0, 0);
					_vala_vertical_enlarged = FALSE;
					vertical_complement = FALSE;
				}
			}
		}
	}
	result = box_complements_derive (horizontal_complement, vertical_complement);
	if (horizontal) {
		*horizontal = _vala_horizontal;
	}
	if (horizontal_enlarged) {
		*horizontal_enlarged = _vala_horizontal_enlarged;
	}
	if (vertical) {
		*vertical = _vala_vertical;
	}
	if (vertical_enlarged) {
		*vertical_enlarged = _vala_vertical_enlarged;
	}
	return result;
}

BoxComplements
box_shifted_complements (Box *self,
                         Box* shifted,
                         Box* horizontal_this,
                         Box* vertical_this,
                         Box* horizontal_shifted,
                         Box* vertical_shifted)
{
	Box _vala_horizontal_this = {0};
	Box _vala_vertical_this = {0};
	Box _vala_horizontal_shifted = {0};
	Box _vala_vertical_shifted = {0};
	gboolean horizontal_complement = FALSE;
	gboolean _tmp0_ = FALSE;
	Box _tmp1_;
	gboolean vertical_complement = FALSE;
	gboolean _tmp14_ = FALSE;
	Box _tmp15_;
	BoxComplements result;
	g_return_val_if_fail (shifted != NULL, 0);
	_vala_assert (box_get_width (&(*self)) == box_get_width (shifted), "get_width() == shifted.get_width()");
	_vala_assert (box_get_height (&(*self)) == box_get_height (shifted), "get_height() == shifted.get_height()");
	horizontal_complement = TRUE;
	_tmp1_ = *shifted;
	if (_tmp1_.top < (*self).top) {
		Box _tmp2_;
		_tmp2_ = *shifted;
		_tmp0_ = _tmp2_.bottom > (*self).top;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Box _tmp3_;
		Box _tmp4_;
		Box _tmp5_;
		Box _tmp6_;
		_tmp3_ = *shifted;
		box_init (&_vala_horizontal_this, (*self).left, _tmp3_.bottom, (*self).right, (*self).bottom);
		_tmp4_ = *shifted;
		_tmp5_ = *shifted;
		_tmp6_ = *shifted;
		box_init (&_vala_horizontal_shifted, _tmp4_.left, _tmp5_.top, _tmp6_.right, (*self).top);
	} else {
		gboolean _tmp7_ = FALSE;
		Box _tmp8_;
		_tmp8_ = *shifted;
		if (_tmp8_.top > (*self).top) {
			Box _tmp9_;
			_tmp9_ = *shifted;
			_tmp7_ = _tmp9_.top < (*self).bottom;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			Box _tmp10_;
			Box _tmp11_;
			Box _tmp12_;
			Box _tmp13_;
			_tmp10_ = *shifted;
			box_init (&_vala_horizontal_this, (*self).left, (*self).top, (*self).right, _tmp10_.top);
			_tmp11_ = *shifted;
			_tmp12_ = *shifted;
			_tmp13_ = *shifted;
			box_init (&_vala_horizontal_shifted, _tmp11_.left, (*self).bottom, _tmp12_.right, _tmp13_.bottom);
		} else {
			box_init (&_vala_horizontal_this, 0, 0, 0, 0);
			box_init (&_vala_horizontal_shifted, 0, 0, 0, 0);
			horizontal_complement = FALSE;
		}
	}
	vertical_complement = TRUE;
	_tmp15_ = *shifted;
	if (_tmp15_.left < (*self).left) {
		Box _tmp16_;
		_tmp16_ = *shifted;
		_tmp14_ = _tmp16_.right > (*self).left;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		Box _tmp17_;
		Box _tmp18_;
		Box _tmp19_;
		Box _tmp20_;
		_tmp17_ = *shifted;
		box_init (&_vala_vertical_this, _tmp17_.right, (*self).top, (*self).right, (*self).bottom);
		_tmp18_ = *shifted;
		_tmp19_ = *shifted;
		_tmp20_ = *shifted;
		box_init (&_vala_vertical_shifted, _tmp18_.left, _tmp19_.top, (*self).left, _tmp20_.bottom);
	} else {
		gboolean _tmp21_ = FALSE;
		Box _tmp22_;
		_tmp22_ = *shifted;
		if (_tmp22_.left > (*self).left) {
			Box _tmp23_;
			_tmp23_ = *shifted;
			_tmp21_ = _tmp23_.left < (*self).right;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			Box _tmp24_;
			Box _tmp25_;
			Box _tmp26_;
			Box _tmp27_;
			_tmp24_ = *shifted;
			box_init (&_vala_vertical_this, (*self).left, (*self).top, _tmp24_.left, (*self).bottom);
			_tmp25_ = *shifted;
			_tmp26_ = *shifted;
			_tmp27_ = *shifted;
			box_init (&_vala_vertical_shifted, (*self).right, _tmp25_.top, _tmp26_.right, _tmp27_.bottom);
		} else {
			box_init (&_vala_vertical_this, 0, 0, 0, 0);
			box_init (&_vala_vertical_shifted, 0, 0, 0, 0);
			vertical_complement = FALSE;
		}
	}
	result = box_complements_derive (horizontal_complement, vertical_complement);
	if (horizontal_this) {
		*horizontal_this = _vala_horizontal_this;
	}
	if (vertical_this) {
		*vertical_this = _vala_vertical_this;
	}
	if (horizontal_shifted) {
		*horizontal_shifted = _vala_horizontal_shifted;
	}
	if (vertical_shifted) {
		*vertical_shifted = _vala_vertical_shifted;
	}
	return result;
}

void
box_rubber_band (Box *self,
                 GdkPoint* point,
                 Box* result)
{
	GdkPoint _tmp0_;
	GdkPoint _tmp1_;
	gint t = 0;
	GdkPoint _tmp2_;
	gint b = 0;
	GdkPoint _tmp3_;
	gint l = 0;
	GdkPoint _tmp4_;
	gint r = 0;
	GdkPoint _tmp5_;
	Box _tmp6_ = {0};
	g_return_if_fail (point != NULL);
	_tmp0_ = *point;
	_vala_assert (_tmp0_.x >= 0, "point.x >= 0");
	_tmp1_ = *point;
	_vala_assert (_tmp1_.y >= 0, "point.y >= 0");
	_tmp2_ = *point;
	t = MIN ((*self).top, _tmp2_.y);
	_tmp3_ = *point;
	b = MAX ((*self).bottom, _tmp3_.y);
	_tmp4_ = *point;
	l = MIN ((*self).left, _tmp4_.x);
	_tmp5_ = *point;
	r = MAX ((*self).right, _tmp5_.x);
	box_init (&_tmp6_, l, t, r, b);
	*result = _tmp6_;
	return;
}

gchar*
box_to_string (Box *self)
{
	Dimensions _tmp0_ = {0};
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	box_get_dimensions (&(*self), &_tmp0_);
	_tmp1_ = dimensions_to_string (&_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%d,%d %d,%d (%s)", (*self).left, (*self).top, (*self).right, (*self).bottom, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static gboolean
box_in_zone (gdouble pos,
             gint zone)
{
	gint top_zone = 0;
	gint bottom_zone = 0;
	gboolean result;
	top_zone = zone - BOX_HAND_GRENADES;
	bottom_zone = zone + BOX_HAND_GRENADES;
	result = box_in_between (pos, top_zone, bottom_zone);
	return result;
}

static gboolean
box_in_between (gdouble pos,
                gint top,
                gint bottom)
{
	gint ipos = 0;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	ipos = (gint) pos;
	if (ipos > top) {
		_tmp0_ = ipos < bottom;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
box_near_in_between (gdouble pos,
                     gint top,
                     gint bottom)
{
	gint ipos = 0;
	gint top_zone = 0;
	gint bottom_zone = 0;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	ipos = (gint) pos;
	top_zone = top - BOX_HAND_GRENADES;
	bottom_zone = bottom + BOX_HAND_GRENADES;
	if (ipos > top_zone) {
		_tmp0_ = ipos < bottom_zone;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

BoxLocation
box_approx_location (Box *self,
                     gint x,
                     gint y)
{
	gboolean near_width = FALSE;
	gboolean near_height = FALSE;
	gboolean _tmp0_ = FALSE;
	BoxLocation result;
	near_width = box_near_in_between ((gdouble) x, (*self).left, (*self).right);
	near_height = box_near_in_between ((gdouble) y, (*self).top, (*self).bottom);
	if (box_in_zone ((gdouble) x, (*self).left)) {
		_tmp0_ = near_height;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (box_in_zone ((gdouble) y, (*self).top)) {
			result = BOX_LOCATION_TOP_LEFT;
			return result;
		} else {
			if (box_in_zone ((gdouble) y, (*self).bottom)) {
				result = BOX_LOCATION_BOTTOM_LEFT;
				return result;
			} else {
				result = BOX_LOCATION_LEFT_SIDE;
				return result;
			}
		}
	} else {
		gboolean _tmp1_ = FALSE;
		if (box_in_zone ((gdouble) x, (*self).right)) {
			_tmp1_ = near_height;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			if (box_in_zone ((gdouble) y, (*self).top)) {
				result = BOX_LOCATION_TOP_RIGHT;
				return result;
			} else {
				if (box_in_zone ((gdouble) y, (*self).bottom)) {
					result = BOX_LOCATION_BOTTOM_RIGHT;
					return result;
				} else {
					result = BOX_LOCATION_RIGHT_SIDE;
					return result;
				}
			}
		} else {
			gboolean _tmp2_ = FALSE;
			if (box_in_zone ((gdouble) y, (*self).top)) {
				_tmp2_ = near_width;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = BOX_LOCATION_TOP_SIDE;
				return result;
			} else {
				gboolean _tmp3_ = FALSE;
				if (box_in_zone ((gdouble) y, (*self).bottom)) {
					_tmp3_ = near_width;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					result = BOX_LOCATION_BOTTOM_SIDE;
					return result;
				} else {
					gboolean _tmp4_ = FALSE;
					if (box_in_between ((gdouble) x, (*self).left, (*self).right)) {
						_tmp4_ = box_in_between ((gdouble) y, (*self).top, (*self).bottom);
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						result = BOX_LOCATION_INSIDE;
						return result;
					} else {
						result = BOX_LOCATION_OUTSIDE;
						return result;
					}
				}
			}
		}
	}
}

Box*
box_dup (const Box* self)
{
	Box* dup;
	dup = g_new0 (Box, 1);
	memcpy (dup, self, sizeof (Box));
	return dup;
}

void
box_free (Box* self)
{
	g_free (self);
}

static GType
box_get_type_once (void)
{
	GType box_type_id;
	box_type_id = g_boxed_type_register_static ("Box", (GBoxedCopyFunc) box_dup, (GBoxedFreeFunc) box_free);
	return box_type_id;
}

GType
box_get_type (void)
{
	static volatile gsize box_type_id__once = 0;
	if (g_once_init_enter (&box_type_id__once)) {
		GType box_type_id;
		box_type_id = box_get_type_once ();
		g_once_init_leave (&box_type_id__once, box_type_id);
	}
	return box_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

