// services/audio/public/mojom/system_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_SYSTEM_INFO_MOJOM_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_SYSTEM_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/audio/public/mojom/system_info.mojom-features.h"  // IWYU pragma: export
#include "services/audio/public/mojom/system_info.mojom-shared.h"  // IWYU pragma: export
#include "services/audio/public/mojom/system_info.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_parameters.mojom.h"
#include "services/audio/public/mojom/audio_device_description.mojom.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace audio::mojom {

class SystemInfoProxy;

template <typename ImplRefTraits>
class SystemInfoStub;

class SystemInfoRequestValidator;
class SystemInfoResponseValidator;


class SystemInfo
    : public SystemInfoInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SystemInfoInterfaceBase;
  using Proxy_ = SystemInfoProxy;

  template <typename ImplRefTraits>
  using Stub_ = SystemInfoStub<ImplRefTraits>;

  using RequestValidator_ = SystemInfoRequestValidator;
  using ResponseValidator_ = SystemInfoResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetInputStreamParametersMinVersion = 0,
    kGetOutputStreamParametersMinVersion = 0,
    kHasInputDevicesMinVersion = 0,
    kHasOutputDevicesMinVersion = 0,
    kGetInputDeviceDescriptionsMinVersion = 0,
    kGetOutputDeviceDescriptionsMinVersion = 0,
    kGetAssociatedOutputDeviceIDMinVersion = 0,
    kGetInputDeviceInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetInputStreamParameters_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetOutputStreamParameters_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HasInputDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HasOutputDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetInputDeviceDescriptions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetOutputDeviceDescriptions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAssociatedOutputDeviceID_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetInputDeviceInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SystemInfo() = default;


  using GetInputStreamParametersCallback = base::OnceCallback<void(const std::optional<::media::AudioParameters>&)>;
  
  virtual void GetInputStreamParameters(const std::string& device_id, GetInputStreamParametersCallback callback) = 0;


  using GetOutputStreamParametersCallback = base::OnceCallback<void(const std::optional<::media::AudioParameters>&)>;
  
  virtual void GetOutputStreamParameters(const std::string& device_id, GetOutputStreamParametersCallback callback) = 0;


  using HasInputDevicesCallback = base::OnceCallback<void(bool)>;
  
  virtual void HasInputDevices(HasInputDevicesCallback callback) = 0;


  using HasOutputDevicesCallback = base::OnceCallback<void(bool)>;
  
  virtual void HasOutputDevices(HasOutputDevicesCallback callback) = 0;


  using GetInputDeviceDescriptionsCallback = base::OnceCallback<void(std::vector<::media::AudioDeviceDescription>)>;
  
  virtual void GetInputDeviceDescriptions(GetInputDeviceDescriptionsCallback callback) = 0;


  using GetOutputDeviceDescriptionsCallback = base::OnceCallback<void(std::vector<::media::AudioDeviceDescription>)>;
  
  virtual void GetOutputDeviceDescriptions(GetOutputDeviceDescriptionsCallback callback) = 0;


  using GetAssociatedOutputDeviceIDCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  
  virtual void GetAssociatedOutputDeviceID(const std::string& input_device_id, GetAssociatedOutputDeviceIDCallback callback) = 0;


  using GetInputDeviceInfoCallback = base::OnceCallback<void(const std::optional<::media::AudioParameters>&, const std::optional<std::string>&)>;
  
  virtual void GetInputDeviceInfo(const std::string& input_device_id, GetInputDeviceInfoCallback callback) = 0;
};



class  SystemInfoProxy
    : public SystemInfo {
 public:
  using InterfaceType = SystemInfo;

  explicit SystemInfoProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetInputStreamParameters(const std::string& device_id, GetInputStreamParametersCallback callback) final;
  
  void GetOutputStreamParameters(const std::string& device_id, GetOutputStreamParametersCallback callback) final;
  
  void HasInputDevices(HasInputDevicesCallback callback) final;
  
  void HasOutputDevices(HasOutputDevicesCallback callback) final;
  
  void GetInputDeviceDescriptions(GetInputDeviceDescriptionsCallback callback) final;
  
  void GetOutputDeviceDescriptions(GetOutputDeviceDescriptionsCallback callback) final;
  
  void GetAssociatedOutputDeviceID(const std::string& input_device_id, GetAssociatedOutputDeviceIDCallback callback) final;
  
  void GetInputDeviceInfo(const std::string& input_device_id, GetInputDeviceInfoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SystemInfoStubDispatch {
 public:
  static bool Accept(SystemInfo* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SystemInfo* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SystemInfo>>
class SystemInfoStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SystemInfoStub() = default;
  ~SystemInfoStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SystemInfoStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SystemInfoStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SystemInfoRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SystemInfoResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // audio::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_AUDIO_PUBLIC_MOJOM_SYSTEM_INFO_MOJOM_H_