// components/metrics/dwa/mojom/dwa_interface.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/metrics/dwa/mojom/dwa_interface.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/metrics/dwa/mojom/dwa_interface.mojom-params-data.h"
namespace metrics {
namespace dwa {
namespace mojom {

namespace internal {


// static
bool DwaEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DwaEntry_Data* object =
      static_cast<const DwaEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->studies_of_interest, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& studies_of_interest_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->studies_of_interest, validation_context,
                                         &studies_of_interest_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metrics, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& metrics_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->metrics, validation_context,
                                         &metrics_validate_params)) {
    return false;
  }

  return true;
}

DwaEntry_Data::DwaEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DwaRecorderInterface_AddEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DwaRecorderInterface_AddEntry_Params_Data* object =
      static_cast<const DwaRecorderInterface_AddEntry_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entry, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->entry, validation_context))
    return false;

  return true;
}

DwaRecorderInterface_AddEntry_Params_Data::DwaRecorderInterface_AddEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DwaRecorderFactory_CreateDwaRecorder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DwaRecorderFactory_CreateDwaRecorder_Params_Data* object =
      static_cast<const DwaRecorderFactory_CreateDwaRecorder_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_remote, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DwaRecorderFactory_CreateDwaRecorder_Params_Data::DwaRecorderFactory_CreateDwaRecorder_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace dwa
}  // namespace metrics