// cc/mojom/browser_controls_offset_tag_modifications.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAG_MODIFICATIONS_MOJOM_SHARED_H_
#define CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAG_MODIFICATIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-shared.h"







namespace cc::mojom {
class BrowserControlsOffsetTagsDataView;

class BrowserControlsOffsetTagModificationsDataView;



}  // cc::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cc::mojom::BrowserControlsOffsetTagsDataView> {
  using Data = ::cc::mojom::internal::BrowserControlsOffsetTags_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cc::mojom::BrowserControlsOffsetTagModificationsDataView> {
  using Data = ::cc::mojom::internal::BrowserControlsOffsetTagModifications_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cc::mojom {


class BrowserControlsOffsetTagsDataView {
 public:
  BrowserControlsOffsetTagsDataView() = default;

  BrowserControlsOffsetTagsDataView(
      internal::BrowserControlsOffsetTags_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopControlsOffsetTagDataView(
      ::viz::mojom::OffsetTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopControlsOffsetTag(UserType* output) {
    
    auto* pointer = data_->top_controls_offset_tag.Get();
    return mojo::internal::Deserialize<::viz::mojom::OffsetTagDataView>(
        pointer, output, message_);
  }
  inline void GetContentOffsetTagDataView(
      ::viz::mojom::OffsetTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentOffsetTag(UserType* output) {
    
    auto* pointer = data_->content_offset_tag.Get();
    return mojo::internal::Deserialize<::viz::mojom::OffsetTagDataView>(
        pointer, output, message_);
  }
  inline void GetBottomControlsOffsetTagDataView(
      ::viz::mojom::OffsetTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBottomControlsOffsetTag(UserType* output) {
    
    auto* pointer = data_->bottom_controls_offset_tag.Get();
    return mojo::internal::Deserialize<::viz::mojom::OffsetTagDataView>(
        pointer, output, message_);
  }
 private:
  internal::BrowserControlsOffsetTags_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BrowserControlsOffsetTagModificationsDataView {
 public:
  BrowserControlsOffsetTagModificationsDataView() = default;

  BrowserControlsOffsetTagModificationsDataView(
      internal::BrowserControlsOffsetTagModifications_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTagsDataView(
      BrowserControlsOffsetTagsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTags(UserType* output) {
    
    auto* pointer = data_->tags.Get();
    return mojo::internal::Deserialize<::cc::mojom::BrowserControlsOffsetTagsDataView>(
        pointer, output, message_);
  }
  int32_t top_controls_additional_height() const {
    return data_->top_controls_additional_height;
  }
  int32_t bottom_controls_additional_height() const {
    return data_->bottom_controls_additional_height;
  }
 private:
  internal::BrowserControlsOffsetTagModifications_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // cc::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::BrowserControlsOffsetTagsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::BrowserControlsOffsetTagsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::BrowserControlsOffsetTags_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::top_controls_offset_tag(input)) in_top_controls_offset_tag = Traits::top_controls_offset_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_controls_offset_tag)::BaseType> top_controls_offset_tag_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::OffsetTagDataView>(
        in_top_controls_offset_tag, top_controls_offset_tag_fragment);
    fragment->top_controls_offset_tag.Set(
        top_controls_offset_tag_fragment.is_null() ? nullptr : top_controls_offset_tag_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->top_controls_offset_tag.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_controls_offset_tag in BrowserControlsOffsetTags struct");
    decltype(Traits::content_offset_tag(input)) in_content_offset_tag = Traits::content_offset_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_offset_tag)::BaseType> content_offset_tag_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::OffsetTagDataView>(
        in_content_offset_tag, content_offset_tag_fragment);
    fragment->content_offset_tag.Set(
        content_offset_tag_fragment.is_null() ? nullptr : content_offset_tag_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content_offset_tag.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_offset_tag in BrowserControlsOffsetTags struct");
    decltype(Traits::bottom_controls_offset_tag(input)) in_bottom_controls_offset_tag = Traits::bottom_controls_offset_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bottom_controls_offset_tag)::BaseType> bottom_controls_offset_tag_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::OffsetTagDataView>(
        in_bottom_controls_offset_tag, bottom_controls_offset_tag_fragment);
    fragment->bottom_controls_offset_tag.Set(
        bottom_controls_offset_tag_fragment.is_null() ? nullptr : bottom_controls_offset_tag_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bottom_controls_offset_tag.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bottom_controls_offset_tag in BrowserControlsOffsetTags struct");
  }

  static bool Deserialize(::cc::mojom::internal::BrowserControlsOffsetTags_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cc::mojom::BrowserControlsOffsetTagsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::BrowserControlsOffsetTagModificationsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::BrowserControlsOffsetTagModificationsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::BrowserControlsOffsetTagModifications_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::tags(input)) in_tags = Traits::tags(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tags)::BaseType> tags_fragment(
            fragment.message());
    mojo::internal::Serialize<::cc::mojom::BrowserControlsOffsetTagsDataView>(
        in_tags, tags_fragment);
    fragment->tags.Set(
        tags_fragment.is_null() ? nullptr : tags_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tags.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tags in BrowserControlsOffsetTagModifications struct");
    fragment->top_controls_additional_height = Traits::top_controls_additional_height(input);
    fragment->bottom_controls_additional_height = Traits::bottom_controls_additional_height(input);
  }

  static bool Deserialize(::cc::mojom::internal::BrowserControlsOffsetTagModifications_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cc::mojom::BrowserControlsOffsetTagModificationsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cc::mojom {

inline void BrowserControlsOffsetTagsDataView::GetTopControlsOffsetTagDataView(
    ::viz::mojom::OffsetTagDataView* output) {
  auto pointer = data_->top_controls_offset_tag.Get();
  *output = ::viz::mojom::OffsetTagDataView(pointer, message_);
}
inline void BrowserControlsOffsetTagsDataView::GetContentOffsetTagDataView(
    ::viz::mojom::OffsetTagDataView* output) {
  auto pointer = data_->content_offset_tag.Get();
  *output = ::viz::mojom::OffsetTagDataView(pointer, message_);
}
inline void BrowserControlsOffsetTagsDataView::GetBottomControlsOffsetTagDataView(
    ::viz::mojom::OffsetTagDataView* output) {
  auto pointer = data_->bottom_controls_offset_tag.Get();
  *output = ::viz::mojom::OffsetTagDataView(pointer, message_);
}


inline void BrowserControlsOffsetTagModificationsDataView::GetTagsDataView(
    BrowserControlsOffsetTagsDataView* output) {
  auto pointer = data_->tags.Get();
  *output = BrowserControlsOffsetTagsDataView(pointer, message_);
}



}  // cc::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAG_MODIFICATIONS_MOJOM_SHARED_H_