// third_party/blink/public/mojom/blob/serialized_blob.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_SERIALIZED_BLOB_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_SERIALIZED_BLOB_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/blob.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT SerializedBlob {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerializedBlob, T>::value>;
  using DataView = SerializedBlobDataView;
  using Data_ = internal::SerializedBlob_Data;

  template <typename... Args>
  static SerializedBlobPtr New(Args&&... args) {
    return SerializedBlobPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerializedBlobPtr From(const U& u) {
    return mojo::TypeConverter<SerializedBlobPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerializedBlob>::Convert(*this);
  }


  SerializedBlob();

  SerializedBlob(
      const std::string& uuid,
      const std::string& content_type,
      uint64_t size,
      ::mojo::PendingRemote<::blink::mojom::Blob> blob);

SerializedBlob(const SerializedBlob&) = delete;
SerializedBlob& operator=(const SerializedBlob&) = delete;

  ~SerializedBlob();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerializedBlobPtr>
  SerializedBlobPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerializedBlob::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerializedBlob::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerializedBlob::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerializedBlob::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerializedBlob_UnserializedMessageContext<
            UserType, SerializedBlob::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerializedBlob::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerializedBlob::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerializedBlob_UnserializedMessageContext<
            UserType, SerializedBlob::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerializedBlob::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string uuid;
  
  std::string content_type;
  
  uint64_t size;
  
  ::mojo::PendingRemote<::blink::mojom::Blob> blob;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerializedBlob::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerializedBlob::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerializedBlob::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerializedBlob::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SerializedBlobPtr SerializedBlob::Clone() const {
  return New(
      mojo::Clone(uuid),
      mojo::Clone(content_type),
      mojo::Clone(size),
      mojo::Clone(blob)
  );
}

template <typename T, SerializedBlob::EnableIfSame<T>*>
bool SerializedBlob::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->content_type, other_struct.content_type))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->blob, other_struct.blob))
    return false;
  return true;
}

template <typename T, SerializedBlob::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.content_type < rhs.content_type)
    return true;
  if (rhs.content_type < lhs.content_type)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.blob < rhs.blob)
    return true;
  if (rhs.blob < lhs.blob)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SerializedBlob::DataView,
                                         ::blink::mojom::SerializedBlobPtr> {
  static bool IsNull(const ::blink::mojom::SerializedBlobPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SerializedBlobPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SerializedBlob::uuid)& uuid(
      const ::blink::mojom::SerializedBlobPtr& input) {
    return input->uuid;
  }

  static const decltype(::blink::mojom::SerializedBlob::content_type)& content_type(
      const ::blink::mojom::SerializedBlobPtr& input) {
    return input->content_type;
  }

  static decltype(::blink::mojom::SerializedBlob::size) size(
      const ::blink::mojom::SerializedBlobPtr& input) {
    return input->size;
  }

  static  decltype(::blink::mojom::SerializedBlob::blob)& blob(
       ::blink::mojom::SerializedBlobPtr& input) {
    return input->blob;
  }

  static bool Read(::blink::mojom::SerializedBlob::DataView input, ::blink::mojom::SerializedBlobPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_SERIALIZED_BLOB_MOJOM_H_