/*
 * Module code.
 *
 * Generated by SIP 6.15.1
 */

#include "sipAPI_analysis.h"

#line 21 "auto_generated/network/qgsgraphanalyzer.sip"
#include "qgsgraphanalyzer.h"
#line 12 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"

#line 106 "auto_generated/network/qgsgraph.sip"
#include "qgsgraph.h"
#line 16 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"
#line 442 "/usr/lib/python3.14/site-packages/PyQt5/bindings/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 19 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"
#line 241 "/usr/lib/python3.14/site-packages/PyQt5/bindings/QtGui/qpygui_qvector.sip"
#include <qvector.h>
#line 22 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"


PyDoc_STRVAR(doc_QgsGraphAnalyzer_dijkstra, "dijkstra(source: QgsGraph|None, startVertexIdx: int, criterionNum: int, resultTree: Iterable[int] = [], resultCost: Iterable[float] = []) -> list\n"
"Solve shortest path problem using Dijkstra algorithm\n"
"\n"
":param source: source graph\n"
":param startVertexIdx: index of the start vertex\n"
":param criterionNum: index of the optimization strategy\n"
":param resultTree: array that represents shortest path tree. resultTree[\n"
"                   vertexIndex ] == inboundingArcIndex if vertex\n"
"                   reachable, otherwise resultTree[ vertexIndex ] == -1.\n"
"                   Note that the startVertexIdx will also have a value\n"
"                   of -1 and may need special handling by callers.\n"
":param resultCost: array of the paths costs");

extern "C" {static PyObject *meth_QgsGraphAnalyzer_dijkstra(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraphAnalyzer_dijkstra(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGraph* a0;
        int a1;
        int a2;
        ::QVector<int>* a3 = 0;
        int a3State = 0;
        ::QVector< ::qreal>* a4 = 0;
        int a4State = 0;

        static const char *sipKwdList[] = {
            sipName_source,
            sipName_startVertexIdx,
            sipName_criterionNum,
            sipName_resultTree,
            sipName_resultCost,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8ii|J0J0", sipType_QgsGraph, &a0, &a1, &a2, sipType_QVector_1800, &a3, &a3State, sipType_QVector_2400, &a4, &a4State))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 40 "auto_generated/network/qgsgraphanalyzer.sip"
    QVector<int> treeResult;
    QVector<double> costResult;
    QgsGraphAnalyzer::dijkstra( a0, a1, a2, &treeResult, &costResult );

    PyObject *l1 = PyList_New( treeResult.size() );
    if ( l1 == NULL )
    {
      return NULL;
    }
    PyObject *l2 = PyList_New( costResult.size() );
    if ( l2 == NULL )
    {
      return NULL;
    }
    int i;
    for ( i = 0; i < costResult.size(); ++i )
    {
      PyObject *Int = PyLong_FromLong( treeResult[i] );
      PyList_SET_ITEM( l1, i, Int );
      PyObject *Float = PyFloat_FromDouble( costResult[i] );
      PyList_SET_ITEM( l2, i, Float );
    }

    sipRes = PyTuple_New( 2 );
    PyTuple_SET_ITEM( sipRes, 0, l1 );
    PyTuple_SET_ITEM( sipRes, 1, l2 );
#line 91 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"
            sipReleaseType(a3, sipType_QVector_1800, a3State);
            sipReleaseType(a4, sipType_QVector_2400, a4State);

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraphAnalyzer, sipName_dijkstra, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraphAnalyzer_shortestTree, "shortestTree(source: QgsGraph|None, startVertexIdx: int, criterionNum: int) -> QgsGraph|None\n"
"Returns shortest path tree with root-node in startVertexIdx\n"
"\n"
":param source: source graph\n"
":param startVertexIdx: index of the start vertex\n"
":param criterionNum: index of the optimization strategy");

extern "C" {static PyObject *meth_QgsGraphAnalyzer_shortestTree(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraphAnalyzer_shortestTree(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGraph* a0;
        int a1;
        int a2;

        static const char *sipKwdList[] = {
            sipName_source,
            sipName_startVertexIdx,
            sipName_criterionNum,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8ii", sipType_QgsGraph, &a0, &a1, &a2))
        {
            ::QgsGraph*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsGraphAnalyzer::shortestTree(a0, a1, a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsGraph, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraphAnalyzer, sipName_shortestTree, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsGraphAnalyzer(void *, int);}
static void release_QgsGraphAnalyzer(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsGraphAnalyzer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsGraphAnalyzer(Py_ssize_t);}
static void *array_QgsGraphAnalyzer(Py_ssize_t sipNrElem)
{
    return new ::QgsGraphAnalyzer[sipNrElem];
}


extern "C" {static void array_delete_QgsGraphAnalyzer(void *);}
static void array_delete_QgsGraphAnalyzer(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsGraphAnalyzer *>(sipCpp);
}


extern "C" {static void assign_QgsGraphAnalyzer(void *, Py_ssize_t, void *);}
static void assign_QgsGraphAnalyzer(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsGraphAnalyzer *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsGraphAnalyzer *>(sipSrc);
}


extern "C" {static void *copy_QgsGraphAnalyzer(const void *, Py_ssize_t);}
static void *copy_QgsGraphAnalyzer(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsGraphAnalyzer(reinterpret_cast<const ::QgsGraphAnalyzer *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsGraphAnalyzer(sipSimpleWrapper *);}
static void dealloc_QgsGraphAnalyzer(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsGraphAnalyzer(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsGraphAnalyzer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsGraphAnalyzer(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsGraphAnalyzer *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGraphAnalyzer();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsGraphAnalyzer* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsGraphAnalyzer, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGraphAnalyzer(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsGraphAnalyzer[] = {
    {sipName_dijkstra, SIP_MLMETH_CAST(meth_QgsGraphAnalyzer_dijkstra), METH_VARARGS|METH_KEYWORDS, doc_QgsGraphAnalyzer_dijkstra},
    {sipName_shortestTree, SIP_MLMETH_CAST(meth_QgsGraphAnalyzer_shortestTree), METH_VARARGS|METH_KEYWORDS, doc_QgsGraphAnalyzer_shortestTree}
};

PyDoc_STRVAR(doc_QgsGraphAnalyzer, "Performs graph analysis, e.g. calculates shortest path between two\n"
"points using different strategies with Dijkstra's algorithm.\n"
"\n"
"");


static pyqt5ClassPluginDef plugin_QgsGraphAnalyzer = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsGraphAnalyzer = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsGraphAnalyzer,
        SIP_NULLPTR,
        &plugin_QgsGraphAnalyzer,
    },
    {
        sipNameNr_QgsGraphAnalyzer,
        {0, 0, 1},
        2, methods_QgsGraphAnalyzer,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsGraphAnalyzer,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsGraphAnalyzer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsGraphAnalyzer,
    assign_QgsGraphAnalyzer,
    array_QgsGraphAnalyzer,
    copy_QgsGraphAnalyzer,
    release_QgsGraphAnalyzer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsGraphAnalyzer,
    sizeof (::QgsGraphAnalyzer),
};

#line 106 "auto_generated/network/qgsgraph.sip"
#include "qgsgraph.h"
#line 348 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"

#line 50 "/build/qgis/src/build/python/core/auto_generated/qgspointxy.sip"
#include "qgspointxy.h"
#line 352 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"
#line 22 "auto_generated/network/qgsgraph.sip"
#include "qgsgraph.h"
#line 355 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"
#line 65 "auto_generated/network/qgsgraph.sip"
#include "qgsgraph.h"
#line 358 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"
#line 28 "/usr/lib/python3.14/site-packages/PyQt5/bindings/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 361 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"
#line 26 "/usr/lib/python3.14/site-packages/PyQt5/bindings/QtCore/qvariant.sip"
#include <qvariant.h>
#line 364 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"


PyDoc_STRVAR(doc_QgsGraph_addVertex, "addVertex(self, pt: QgsPointXY) -> int\n"
"Add a vertex to the graph");

extern "C" {static PyObject *meth_QgsGraph_addVertex(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_addVertex(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointXY* a0;
        ::QgsGraph *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsGraph, &sipCpp, sipType_QgsPointXY, &a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->addVertex(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_addVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_addEdge, "addEdge(self, fromVertexIdx: int, toVertexIdx: int, strategies: Iterable[Any]) -> int\n"
"Add an edge to the graph, going from the ``fromVertexIdx`` to\n"
"``toVertexIdx``.");

extern "C" {static PyObject *meth_QgsGraph_addEdge(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_addEdge(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        const QVector< ::QVariant>* a2;
        int a2State = 0;
        ::QgsGraph *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fromVertexIdx,
            sipName_toVertexIdx,
            sipName_strategies,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiiJ1", &sipSelf, sipType_QgsGraph, &sipCpp, &a0, &a1, sipType_QVector_0100QVariant, &a2, &a2State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->addEdge(a0, a1, *a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast<QVector< ::QVariant> *>(a2), sipType_QVector_0100QVariant, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QVector< ::QVariant> *>(a2), sipType_QVector_0100QVariant, a2State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_addEdge, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_vertexCount, "vertexCount(self) -> int\n"
"Returns number of graph vertices");

extern "C" {static PyObject *meth_QgsGraph_vertexCount(PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_vertexCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGraph *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGraph, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->vertexCount();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_vertexCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_vertex, "vertex(self, idx: int) -> QgsGraphVertex\n"
"Returns the vertex at the given index.\n"
"\n"
":raises IndexError: if the vertex is not found.");

extern "C" {static PyObject *meth_QgsGraph_vertex(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_vertex(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QgsGraph *sipCpp;

        static const char *sipKwdList[] = {
            sipName_idx,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_QgsGraph, &sipCpp, &a0))
        {
            ::QgsGraphVertex*sipRes = 0;
            int sipIsErr = 0;

#line 136 "auto_generated/network/qgsgraph.sip"
    if ( sipCpp->hasVertex( a0 ) )
    {
      return sipConvertFromNewType( new QgsGraphVertex( sipCpp->vertex( a0 ) ), sipType_QgsGraphVertex, Py_None );
    }
    else
    {
      PyErr_SetString( PyExc_IndexError, QByteArray::number( a0 ) );
      sipIsErr = 1;
    }
#line 559 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_QgsGraphVertex, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_vertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_removeVertex, "removeVertex(self, index: int)\n"
"Removes the vertex at specified ``index``.\n"
"\n"
"All edges which are incoming or outgoing edges for the vertex will also\n"
"be removed.\n"
"\n"
":raises IndexError: if the vertex is not found.\n"
"\n"
".. versionadded:: 3.24");

extern "C" {static PyObject *meth_QgsGraph_removeVertex(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_removeVertex(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QgsGraph *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_QgsGraph, &sipCpp, &a0))
        {
            int sipIsErr = 0;

#line 160 "auto_generated/network/qgsgraph.sip"
    if ( sipCpp->hasVertex( a0 ) )
    {
      sipCpp->removeVertex( a0 );
    }
    else
    {
      PyErr_SetString( PyExc_IndexError, QByteArray::number( a0 ) );
      sipIsErr = 1;
    }
#line 611 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_removeVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_edgeCount, "edgeCount(self) -> int\n"
"Returns number of graph edges");

extern "C" {static PyObject *meth_QgsGraph_edgeCount(PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_edgeCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGraph *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGraph, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->edgeCount();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_edgeCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_edge, "edge(self, idx: int) -> QgsGraphEdge\n"
"Returns the edge at the given index.\n"
"\n"
":raises IndexError: if the edge is not found.");

extern "C" {static PyObject *meth_QgsGraph_edge(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_edge(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QgsGraph *sipCpp;

        static const char *sipKwdList[] = {
            sipName_idx,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_QgsGraph, &sipCpp, &a0))
        {
            ::QgsGraphEdge*sipRes = 0;
            int sipIsErr = 0;

#line 184 "auto_generated/network/qgsgraph.sip"
    if ( sipCpp->hasEdge( a0 ) )
    {
      return sipConvertFromNewType( new QgsGraphEdge( sipCpp->edge( a0 ) ), sipType_QgsGraphEdge, Py_None );
    }
    else
    {
      PyErr_SetString( PyExc_IndexError, QByteArray::number( a0 ) );
      sipIsErr = 1;
    }
#line 707 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_QgsGraphEdge, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_edge, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_removeEdge, "removeEdge(self, index: int)\n"
"Removes the edge at specified ``index``.\n"
"\n"
"The incoming and outgoing edges for all graph vertices will be updated\n"
"accordingly. Vertices which no longer have any incoming or outgoing\n"
"edges as a result will be removed from the graph automatically.\n"
"\n"
":raises IndexError: if the vertex is not found.\n"
"\n"
".. versionadded:: 3.24");

extern "C" {static PyObject *meth_QgsGraph_removeEdge(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_removeEdge(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QgsGraph *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_QgsGraph, &sipCpp, &a0))
        {
            int sipIsErr = 0;

#line 210 "auto_generated/network/qgsgraph.sip"
    if ( sipCpp->hasEdge( a0 ) )
    {
      sipCpp->removeEdge( a0 );
    }
    else
    {
      PyErr_SetString( PyExc_IndexError, QByteArray::number( a0 ) );
      sipIsErr = 1;
    }
#line 760 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_removeEdge, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_findVertex, "findVertex(self, pt: QgsPointXY) -> int\n"
"Find vertex by associated point\n"
"\n"
":return: vertex index");

extern "C" {static PyObject *meth_QgsGraph_findVertex(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_findVertex(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointXY* a0;
        const ::QgsGraph *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsGraph, &sipCpp, sipType_QgsPointXY, &a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->findVertex(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_findVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_findOppositeEdge, "findOppositeEdge(self, index: int) -> int\n"
"Finds the first edge which is the opposite of the edge with the\n"
"specified index.\n"
"\n"
"This represents the edge which has the same vertices as the specified\n"
"edge, but the opposite direction in the graph.(I.e. the edge which\n"
"starts at the \"from\" vertex of the specified edge and ends at the \"to\"\n"
"vertex.)\n"
"\n"
"Returns -1 if no opposite edge exists.\n"
"\n"
":raises IndexError: if the edge with the specified ``index`` is not\n"
"                    found.\n"
"\n"
".. versionadded:: 3.24");

extern "C" {static PyObject *meth_QgsGraph_findOppositeEdge(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_findOppositeEdge(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QgsGraph *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_QgsGraph, &sipCpp, &a0))
        {
            int sipRes = 0;
            int sipIsErr = 0;

#line 247 "auto_generated/network/qgsgraph.sip"
    if ( sipCpp->hasEdge( a0 ) )
    {
      sipRes = sipCpp->findOppositeEdge( a0 );
    }
    else
    {
      PyErr_SetString( PyExc_IndexError, QByteArray::number( a0 ) );
      sipIsErr = 1;
    }
#line 874 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_findOppositeEdge, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_hasEdge, "hasEdge(self, index: int) -> bool\n"
"Returns whether the edge of the given index exists.\n"
"\n"
".. versionadded:: 3.24");

extern "C" {static PyObject *meth_QgsGraph_hasEdge(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_hasEdge(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QgsGraph *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_QgsGraph, &sipCpp, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->hasEdge(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_hasEdge, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraph_hasVertex, "hasVertex(self, index: int) -> bool\n"
"Returns whether the vertex of the given index exists.\n"
"\n"
".. versionadded:: 3.24");

extern "C" {static PyObject *meth_QgsGraph_hasVertex(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraph_hasVertex(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QgsGraph *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_QgsGraph, &sipCpp, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->hasVertex(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraph, sipName_hasVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsGraph(void *, int);}
static void release_QgsGraph(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsGraph *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsGraph(Py_ssize_t);}
static void *array_QgsGraph(Py_ssize_t sipNrElem)
{
    return new ::QgsGraph[sipNrElem];
}


extern "C" {static void array_delete_QgsGraph(void *);}
static void array_delete_QgsGraph(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsGraph *>(sipCpp);
}


extern "C" {static void assign_QgsGraph(void *, Py_ssize_t, void *);}
static void assign_QgsGraph(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsGraph *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsGraph *>(sipSrc);
}


extern "C" {static void *copy_QgsGraph(const void *, Py_ssize_t);}
static void *copy_QgsGraph(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsGraph(reinterpret_cast<const ::QgsGraph *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsGraph(sipSimpleWrapper *);}
static void dealloc_QgsGraph(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsGraph(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsGraph(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsGraph(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsGraph *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGraph();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsGraph* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsGraph, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGraph(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsGraph[] = {
    {sipName_addEdge, SIP_MLMETH_CAST(meth_QgsGraph_addEdge), METH_VARARGS|METH_KEYWORDS, doc_QgsGraph_addEdge},
    {sipName_addVertex, SIP_MLMETH_CAST(meth_QgsGraph_addVertex), METH_VARARGS|METH_KEYWORDS, doc_QgsGraph_addVertex},
    {sipName_edge, SIP_MLMETH_CAST(meth_QgsGraph_edge), METH_VARARGS|METH_KEYWORDS, doc_QgsGraph_edge},
    {sipName_edgeCount, meth_QgsGraph_edgeCount, METH_VARARGS, doc_QgsGraph_edgeCount},
    {sipName_findOppositeEdge, SIP_MLMETH_CAST(meth_QgsGraph_findOppositeEdge), METH_VARARGS|METH_KEYWORDS, doc_QgsGraph_findOppositeEdge},
    {sipName_findVertex, SIP_MLMETH_CAST(meth_QgsGraph_findVertex), METH_VARARGS|METH_KEYWORDS, doc_QgsGraph_findVertex},
    {sipName_hasEdge, SIP_MLMETH_CAST(meth_QgsGraph_hasEdge), METH_VARARGS|METH_KEYWORDS, doc_QgsGraph_hasEdge},
    {sipName_hasVertex, SIP_MLMETH_CAST(meth_QgsGraph_hasVertex), METH_VARARGS|METH_KEYWORDS, doc_QgsGraph_hasVertex},
    {sipName_removeEdge, SIP_MLMETH_CAST(meth_QgsGraph_removeEdge), METH_VARARGS|METH_KEYWORDS, doc_QgsGraph_removeEdge},
    {sipName_removeVertex, SIP_MLMETH_CAST(meth_QgsGraph_removeVertex), METH_VARARGS|METH_KEYWORDS, doc_QgsGraph_removeVertex},
    {sipName_vertex, SIP_MLMETH_CAST(meth_QgsGraph_vertex), METH_VARARGS|METH_KEYWORDS, doc_QgsGraph_vertex},
    {sipName_vertexCount, meth_QgsGraph_vertexCount, METH_VARARGS, doc_QgsGraph_vertexCount}
};

PyDoc_STRVAR(doc_QgsGraph, "Mathematical graph representation.\n"
"\n"
"");


static pyqt5ClassPluginDef plugin_QgsGraph = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsGraph = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsGraph,
        SIP_NULLPTR,
        &plugin_QgsGraph,
    },
    {
        sipNameNr_QgsGraph,
        {0, 0, 1},
        12, methods_QgsGraph,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsGraph,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsGraph,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsGraph,
    assign_QgsGraph,
    array_QgsGraph,
    copy_QgsGraph,
    release_QgsGraph,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsGraph,
    sizeof (::QgsGraph),
};

#line 65 "auto_generated/network/qgsgraph.sip"
#include "qgsgraph.h"
#line 1190 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"

#line 50 "/build/qgis/src/build/python/core/auto_generated/qgspointxy.sip"
#include "qgspointxy.h"
#line 1194 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"
#line 646 "/usr/lib/python3.14/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 1197 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"


PyDoc_STRVAR(doc_QgsGraphVertex_incomingEdges, "incomingEdges(self) -> list[int]\n"
"Returns the incoming edge ids, i.e. edges which end at this node.\n"
"\n"
".. seealso:: :py:func:`outgoingEdges`");

extern "C" {static PyObject *meth_QgsGraphVertex_incomingEdges(PyObject *, PyObject *);}
static PyObject *meth_QgsGraphVertex_incomingEdges(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGraphVertex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGraphVertex, &sipCpp))
        {
            ::QgsGraphEdgeIds*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsGraphEdgeIds(sipCpp->incomingEdges());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QList_1800, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraphVertex, sipName_incomingEdges, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraphVertex_outgoingEdges, "outgoingEdges(self) -> list[int]\n"
"Returns outgoing edge ids, i.e. edges which start at this node.\n"
"\n"
".. seealso:: :py:func:`incomingEdges`");

extern "C" {static PyObject *meth_QgsGraphVertex_outgoingEdges(PyObject *, PyObject *);}
static PyObject *meth_QgsGraphVertex_outgoingEdges(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGraphVertex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGraphVertex, &sipCpp))
        {
            ::QgsGraphEdgeIds*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsGraphEdgeIds(sipCpp->outgoingEdges());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QList_1800, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraphVertex, sipName_outgoingEdges, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraphVertex_point, "point(self) -> QgsPointXY\n"
"Returns point associated with graph vertex.");

extern "C" {static PyObject *meth_QgsGraphVertex_point(PyObject *, PyObject *);}
static PyObject *meth_QgsGraphVertex_point(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGraphVertex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGraphVertex, &sipCpp))
        {
            ::QgsPointXY*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointXY(sipCpp->point());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointXY, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraphVertex, sipName_point, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsGraphVertex(void *, int);}
static void release_QgsGraphVertex(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsGraphVertex *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsGraphVertex(Py_ssize_t);}
static void *array_QgsGraphVertex(Py_ssize_t sipNrElem)
{
    return new ::QgsGraphVertex[sipNrElem];
}


extern "C" {static void array_delete_QgsGraphVertex(void *);}
static void array_delete_QgsGraphVertex(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsGraphVertex *>(sipCpp);
}


extern "C" {static void assign_QgsGraphVertex(void *, Py_ssize_t, void *);}
static void assign_QgsGraphVertex(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsGraphVertex *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsGraphVertex *>(sipSrc);
}


extern "C" {static void *copy_QgsGraphVertex(const void *, Py_ssize_t);}
static void *copy_QgsGraphVertex(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsGraphVertex(reinterpret_cast<const ::QgsGraphVertex *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsGraphVertex(sipSimpleWrapper *);}
static void dealloc_QgsGraphVertex(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsGraphVertex(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsGraphVertex(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsGraphVertex(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsGraphVertex *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGraphVertex();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsPointXY* a0;

        static const char *sipKwdList[] = {
            sipName_point,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_QgsPointXY, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGraphVertex(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsGraphVertex* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsGraphVertex, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGraphVertex(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsGraphVertex[] = {
    {sipName_incomingEdges, meth_QgsGraphVertex_incomingEdges, METH_VARARGS, doc_QgsGraphVertex_incomingEdges},
    {sipName_outgoingEdges, meth_QgsGraphVertex_outgoingEdges, METH_VARARGS, doc_QgsGraphVertex_outgoingEdges},
    {sipName_point, meth_QgsGraphVertex_point, METH_VARARGS, doc_QgsGraphVertex_point}
};

PyDoc_STRVAR(doc_QgsGraphVertex, "Represents vertex in a graph.\n"
"\n"
"QgsGraphVertex()\n"
"\n"
"QgsGraphVertex(point: QgsPointXY)\n"
"This constructor initializes QgsGraphVertex object and associates a\n"
"vertex with a point\n"
"\n"
"QgsGraphVertex(a0: QgsGraphVertex)");


static pyqt5ClassPluginDef plugin_QgsGraphVertex = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsGraphVertex = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsGraphVertex,
        SIP_NULLPTR,
        &plugin_QgsGraphVertex,
    },
    {
        sipNameNr_QgsGraphVertex,
        {0, 0, 1},
        3, methods_QgsGraphVertex,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsGraphVertex,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsGraphVertex,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsGraphVertex,
    assign_QgsGraphVertex,
    array_QgsGraphVertex,
    copy_QgsGraphVertex,
    release_QgsGraphVertex,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsGraphVertex,
    sizeof (::QgsGraphVertex),
};

#line 22 "auto_generated/network/qgsgraph.sip"
#include "qgsgraph.h"
#line 1570 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"

#line 28 "/usr/lib/python3.14/site-packages/PyQt5/bindings/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 1574 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"
#line 26 "/usr/lib/python3.14/site-packages/PyQt5/bindings/QtCore/qvariant.sip"
#include <qvariant.h>
#line 1577 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart15.cpp"


PyDoc_STRVAR(doc_QgsGraphEdge_cost, "cost(self, strategyIndex: int) -> Any\n"
"Returns edge cost calculated using specified strategy\n"
"\n"
":param strategyIndex: strategy index");

extern "C" {static PyObject *meth_QgsGraphEdge_cost(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsGraphEdge_cost(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QgsGraphEdge *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strategyIndex,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_QgsGraphEdge, &sipCpp, &a0))
        {
            ::QVariant*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QVariant(sipCpp->cost(a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraphEdge, sipName_cost, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraphEdge_strategies, "strategies(self) -> list[Any]\n"
"Returns array of available strategies");

extern "C" {static PyObject *meth_QgsGraphEdge_strategies(PyObject *, PyObject *);}
static PyObject *meth_QgsGraphEdge_strategies(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGraphEdge *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGraphEdge, &sipCpp))
        {
            QVector< ::QVariant>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QVector< ::QVariant>(sipCpp->strategies());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QVector_0100QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraphEdge, sipName_strategies, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraphEdge_toVertex, "toVertex(self) -> int\n"
"Returns the index of the vertex at the end of this edge.\n"
"\n"
".. seealso:: :py:func:`fromVertex`");

extern "C" {static PyObject *meth_QgsGraphEdge_toVertex(PyObject *, PyObject *);}
static PyObject *meth_QgsGraphEdge_toVertex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGraphEdge *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGraphEdge, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->toVertex();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraphEdge, sipName_toVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsGraphEdge_fromVertex, "fromVertex(self) -> int\n"
"Returns the index of the vertex at the start of this edge.\n"
"\n"
".. seealso:: :py:func:`toVertex`");

extern "C" {static PyObject *meth_QgsGraphEdge_fromVertex(PyObject *, PyObject *);}
static PyObject *meth_QgsGraphEdge_fromVertex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGraphEdge *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsGraphEdge, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->fromVertex();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsGraphEdge, sipName_fromVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsGraphEdge(void *, int);}
static void release_QgsGraphEdge(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsGraphEdge *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsGraphEdge(Py_ssize_t);}
static void *array_QgsGraphEdge(Py_ssize_t sipNrElem)
{
    return new ::QgsGraphEdge[sipNrElem];
}


extern "C" {static void array_delete_QgsGraphEdge(void *);}
static void array_delete_QgsGraphEdge(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsGraphEdge *>(sipCpp);
}


extern "C" {static void assign_QgsGraphEdge(void *, Py_ssize_t, void *);}
static void assign_QgsGraphEdge(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsGraphEdge *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsGraphEdge *>(sipSrc);
}


extern "C" {static void *copy_QgsGraphEdge(const void *, Py_ssize_t);}
static void *copy_QgsGraphEdge(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsGraphEdge(reinterpret_cast<const ::QgsGraphEdge *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsGraphEdge(sipSimpleWrapper *);}
static void dealloc_QgsGraphEdge(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsGraphEdge(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsGraphEdge(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsGraphEdge(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsGraphEdge *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGraphEdge();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsGraphEdge* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsGraphEdge, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsGraphEdge(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsGraphEdge[] = {
    {sipName_cost, SIP_MLMETH_CAST(meth_QgsGraphEdge_cost), METH_VARARGS|METH_KEYWORDS, doc_QgsGraphEdge_cost},
    {sipName_fromVertex, meth_QgsGraphEdge_fromVertex, METH_VARARGS, doc_QgsGraphEdge_fromVertex},
    {sipName_strategies, meth_QgsGraphEdge_strategies, METH_VARARGS, doc_QgsGraphEdge_strategies},
    {sipName_toVertex, meth_QgsGraphEdge_toVertex, METH_VARARGS, doc_QgsGraphEdge_toVertex}
};

PyDoc_STRVAR(doc_QgsGraphEdge, "Represents an edge in a graph.\n"
"\n"
"");


static pyqt5ClassPluginDef plugin_QgsGraphEdge = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsGraphEdge = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsGraphEdge,
        SIP_NULLPTR,
        &plugin_QgsGraphEdge,
    },
    {
        sipNameNr_QgsGraphEdge,
        {0, 0, 1},
        4, methods_QgsGraphEdge,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsGraphEdge,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsGraphEdge,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsGraphEdge,
    assign_QgsGraphEdge,
    array_QgsGraphEdge,
    copy_QgsGraphEdge,
    release_QgsGraphEdge,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsGraphEdge,
    sizeof (::QgsGraphEdge),
};
