/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Declarations                                                  *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: ProtonGPUAttrDefs.td                                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {
// The strategy for buffer management
enum class BufferStrategy : uint32_t {
  CIRCULAR = 0,
  FLUSH = 1,
};

::std::optional<BufferStrategy> symbolizeBufferStrategy(uint32_t);
::llvm::StringRef stringifyBufferStrategy(BufferStrategy);
::std::optional<BufferStrategy> symbolizeBufferStrategy(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForBufferStrategy() {
  return 1;
}


inline ::llvm::StringRef stringifyEnum(BufferStrategy enumValue) {
  return stringifyBufferStrategy(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<BufferStrategy> symbolizeEnum<BufferStrategy>(::llvm::StringRef str) {
  return symbolizeBufferStrategy(str);
}

class BufferStrategyAttr : public ::mlir::IntegerAttr {
public:
  using ValueType = BufferStrategy;
  using ::mlir::IntegerAttr::IntegerAttr;
  static bool classof(::mlir::Attribute attr);
  static BufferStrategyAttr get(::mlir::MLIRContext *context, BufferStrategy val);
  BufferStrategy getValue() const;
};
} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::triton::proton::gpu::BufferStrategy, ::mlir::triton::proton::gpu::BufferStrategy> {
  template <typename ParserT>
  static FailureOr<::mlir::triton::proton::gpu::BufferStrategy> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for The strategy for buffer management");

    // Symbolize the keyword.
    if (::std::optional<::mlir::triton::proton::gpu::BufferStrategy> attr = ::mlir::triton::proton::gpu::symbolizeEnum<::mlir::triton::proton::gpu::BufferStrategy>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [circular, flush] for The strategy for buffer management, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::triton::proton::gpu::BufferStrategy>, std::optional<::mlir::triton::proton::gpu::BufferStrategy>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::triton::proton::gpu::BufferStrategy>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::triton::proton::gpu::BufferStrategy>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::triton::proton::gpu::BufferStrategy> attr = ::mlir::triton::proton::gpu::symbolizeEnum<::mlir::triton::proton::gpu::BufferStrategy>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [circular, flush] for The strategy for buffer management, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::triton::proton::gpu::BufferStrategy value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::triton::proton::gpu::BufferStrategy> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::triton::proton::gpu::BufferStrategy getEmptyKey() {
    return static_cast<::mlir::triton::proton::gpu::BufferStrategy>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::triton::proton::gpu::BufferStrategy getTombstoneKey() {
    return static_cast<::mlir::triton::proton::gpu::BufferStrategy>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::triton::proton::gpu::BufferStrategy &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::triton::proton::gpu::BufferStrategy &lhs, const ::mlir::triton::proton::gpu::BufferStrategy &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {
// The type of internal buffer to be used
enum class BufferType : uint32_t {
  SHARED = 1,
  GLOBAL = 2,
};

::std::optional<BufferType> symbolizeBufferType(uint32_t);
::llvm::StringRef stringifyBufferType(BufferType);
::std::optional<BufferType> symbolizeBufferType(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForBufferType() {
  return 2;
}


inline ::llvm::StringRef stringifyEnum(BufferType enumValue) {
  return stringifyBufferType(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<BufferType> symbolizeEnum<BufferType>(::llvm::StringRef str) {
  return symbolizeBufferType(str);
}

class BufferTypeAttr : public ::mlir::IntegerAttr {
public:
  using ValueType = BufferType;
  using ::mlir::IntegerAttr::IntegerAttr;
  static bool classof(::mlir::Attribute attr);
  static BufferTypeAttr get(::mlir::MLIRContext *context, BufferType val);
  BufferType getValue() const;
};
} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::triton::proton::gpu::BufferType, ::mlir::triton::proton::gpu::BufferType> {
  template <typename ParserT>
  static FailureOr<::mlir::triton::proton::gpu::BufferType> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for The type of internal buffer to be used");

    // Symbolize the keyword.
    if (::std::optional<::mlir::triton::proton::gpu::BufferType> attr = ::mlir::triton::proton::gpu::symbolizeEnum<::mlir::triton::proton::gpu::BufferType>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [shared, global] for The type of internal buffer to be used, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::triton::proton::gpu::BufferType>, std::optional<::mlir::triton::proton::gpu::BufferType>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::triton::proton::gpu::BufferType>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::triton::proton::gpu::BufferType>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::triton::proton::gpu::BufferType> attr = ::mlir::triton::proton::gpu::symbolizeEnum<::mlir::triton::proton::gpu::BufferType>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [shared, global] for The type of internal buffer to be used, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::triton::proton::gpu::BufferType value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::triton::proton::gpu::BufferType> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::triton::proton::gpu::BufferType getEmptyKey() {
    return static_cast<::mlir::triton::proton::gpu::BufferType>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::triton::proton::gpu::BufferType getTombstoneKey() {
    return static_cast<::mlir::triton::proton::gpu::BufferType>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::triton::proton::gpu::BufferType &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::triton::proton::gpu::BufferType &lhs, const ::mlir::triton::proton::gpu::BufferType &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {
// The granularity of the profiling metric
enum class Granularity : uint32_t {
  THREAD = 0,
  WARP = 1,
  WARP_2 = 2,
  WARP_4 = 3,
  WARP_8 = 4,
  CTA = 5,
  WARP_GROUP = 6,
  WARP_GROUP_2 = 7,
  WARP_GROUP_4 = 8,
  WARP_GROUP_8 = 9,
};

::std::optional<Granularity> symbolizeGranularity(uint32_t);
::llvm::StringRef stringifyGranularity(Granularity);
::std::optional<Granularity> symbolizeGranularity(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForGranularity() {
  return 9;
}


inline ::llvm::StringRef stringifyEnum(Granularity enumValue) {
  return stringifyGranularity(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<Granularity> symbolizeEnum<Granularity>(::llvm::StringRef str) {
  return symbolizeGranularity(str);
}

class GranularityAttr : public ::mlir::IntegerAttr {
public:
  using ValueType = Granularity;
  using ::mlir::IntegerAttr::IntegerAttr;
  static bool classof(::mlir::Attribute attr);
  static GranularityAttr get(::mlir::MLIRContext *context, Granularity val);
  Granularity getValue() const;
};
} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::triton::proton::gpu::Granularity, ::mlir::triton::proton::gpu::Granularity> {
  template <typename ParserT>
  static FailureOr<::mlir::triton::proton::gpu::Granularity> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for The granularity of the profiling metric");

    // Symbolize the keyword.
    if (::std::optional<::mlir::triton::proton::gpu::Granularity> attr = ::mlir::triton::proton::gpu::symbolizeEnum<::mlir::triton::proton::gpu::Granularity>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [thread, warp, warp_2, warp_4, warp_8, cta, warp_group, warp_group_2, warp_group_4, warp_group_8] for The granularity of the profiling metric, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::triton::proton::gpu::Granularity>, std::optional<::mlir::triton::proton::gpu::Granularity>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::triton::proton::gpu::Granularity>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::triton::proton::gpu::Granularity>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::triton::proton::gpu::Granularity> attr = ::mlir::triton::proton::gpu::symbolizeEnum<::mlir::triton::proton::gpu::Granularity>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [thread, warp, warp_2, warp_4, warp_8, cta, warp_group, warp_group_2, warp_group_4, warp_group_8] for The granularity of the profiling metric, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::triton::proton::gpu::Granularity value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::triton::proton::gpu::Granularity> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::triton::proton::gpu::Granularity getEmptyKey() {
    return static_cast<::mlir::triton::proton::gpu::Granularity>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::triton::proton::gpu::Granularity getTombstoneKey() {
    return static_cast<::mlir::triton::proton::gpu::Granularity>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::triton::proton::gpu::Granularity &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::triton::proton::gpu::Granularity &lhs, const ::mlir::triton::proton::gpu::Granularity &rhs) {
    return lhs == rhs;
  }
};
}

