/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: TritonNvidiaGPUOps.td                                                *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::triton::nvidia_gpu::ArriveBarrierOp,
::mlir::triton::nvidia_gpu::AsyncCopyMbarrierArriveOp,
::mlir::triton::nvidia_gpu::AsyncTMACopyGlobalToLocalOp,
::mlir::triton::nvidia_gpu::AsyncTMACopyLocalToGlobalOp,
::mlir::triton::nvidia_gpu::AsyncTMAGatherOp,
::mlir::triton::nvidia_gpu::AsyncTMAReduceOp,
::mlir::triton::nvidia_gpu::AsyncTMAScatterOp,
::mlir::triton::nvidia_gpu::BarrierExpectOp,
::mlir::triton::nvidia_gpu::ClusterArriveOp,
::mlir::triton::nvidia_gpu::ClusterWaitOp,
::mlir::triton::nvidia_gpu::FenceAsyncSharedOp,
::mlir::triton::nvidia_gpu::InitBarrierOp,
::mlir::triton::nvidia_gpu::InvalBarrierOp,
::mlir::triton::nvidia_gpu::ReinterpretTensorDescOp,
::mlir::triton::nvidia_gpu::TCGen5CommitOp,
::mlir::triton::nvidia_gpu::TCGen5MMAOp,
::mlir::triton::nvidia_gpu::TCGen5MMAScaledOp,
::mlir::triton::nvidia_gpu::TMAStoreWaitOp,
::mlir::triton::nvidia_gpu::TMEMAllocOp,
::mlir::triton::nvidia_gpu::TMEMCopyOp,
::mlir::triton::nvidia_gpu::TMEMLoadOp,
::mlir::triton::nvidia_gpu::TMEMStoreOp,
::mlir::triton::nvidia_gpu::TMEMSubSliceOp,
::mlir::triton::nvidia_gpu::TensormapCreateOp,
::mlir::triton::nvidia_gpu::TensormapFenceproxyAcquireOp,
::mlir::triton::nvidia_gpu::WaitBarrierOp,
::mlir::triton::nvidia_gpu::WarpGroupDotOp,
::mlir::triton::nvidia_gpu::WarpGroupDotWaitOp
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace mlir {
namespace triton {
namespace nvidia_gpu {

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::triton::gpu::MemDescType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be memory descriptor type (`::mlir::triton::gpu::MemDescType`) in Triton IR type system, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(1)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 1-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::triton::TensorDescType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be Tensor descriptor type (`::mlir::triton::TensorDescType`) in Triton IR type system, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(32)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of 32-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps5(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::mlir::RankedTensorType>(type))) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(32)); }(::llvm::cast<::mlir::ShapedType>(type).getElementType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be ranked tensor of 32-bit signless integer values, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps6(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(32)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 32-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps7(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::mlir::isa<::mlir::triton::PointerType>(type))) && ([](::mlir::Type pointeeType) { return (true); }(::mlir::cast<::mlir::triton::PointerType>(type).getPointeeType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be ptr, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps8(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::triton::gpu::AsyncTokenType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be async token type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps9(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::triton::gpu::MemDescType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of memory descriptor type (`::mlir::triton::gpu::MemDescType`) in Triton IR type system, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps10(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(1)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of 1-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps11(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::mlir::RankedTensorType>(type))) && ([](::mlir::Type elementType) { return (((::llvm::isa<::mlir::Float8E4M3FNType>(elementType))) || ((::llvm::isa<::mlir::Float8E4M3FNUZType>(elementType))) || ((::llvm::isa<::mlir::Float8E5M2Type>(elementType))) || ((::llvm::isa<::mlir::Float8E5M2FNUZType>(elementType))) || ((elementType.isF16())) || ((::llvm::isa<::mlir::BFloat16Type>(elementType))) || ((elementType.isF32())) || ((elementType.isF64()))) || (((elementType.isSignlessInteger(1))) || ((elementType.isSignlessInteger(4))) || ((elementType.isSignlessInteger(8))) || ((elementType.isSignlessInteger(16))) || ((elementType.isSignlessInteger(32))) || ((elementType.isSignlessInteger(64)))) || (((::mlir::isa<::mlir::triton::PointerType>(elementType))) && ([](::mlir::Type pointeeType) { return (true); }(::mlir::cast<::mlir::triton::PointerType>(elementType).getPointeeType()))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be ranked tensor of floating-point or integer or ptr values, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps12(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::triton::PointerType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be Pointer type (`::mlir::triton::PointerType`) in Triton IR type system, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps13(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(64)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of 64-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps14(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::triton::gpu::TensorOrMemDesc>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be TensorOrMemDesc instance, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps15(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::mlir::RankedTensorType>(type))) && ([](::mlir::Type elementType) { return (((::llvm::isa<::mlir::Float8E4M3FNType>(elementType))) || ((::llvm::isa<::mlir::Float8E4M3FNUZType>(elementType))) || ((::llvm::isa<::mlir::Float8E5M2Type>(elementType))) || ((::llvm::isa<::mlir::Float8E5M2FNUZType>(elementType))) || ((elementType.isF16())) || ((::llvm::isa<::mlir::BFloat16Type>(elementType))) || ((elementType.isF32())) || ((elementType.isF64()))) || (((elementType.isSignlessInteger(1))) || ((elementType.isSignlessInteger(4))) || ((elementType.isSignlessInteger(8))) || ((elementType.isSignlessInteger(16))) || ((elementType.isSignlessInteger(32))) || ((elementType.isSignlessInteger(64)))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be ranked tensor of floating-point or integer values, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TritonNvidiaGPUOps16(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::triton::gpu::TensorOrMemDesc>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of TensorOrMemDesc instance, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::UnitAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: unit attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::triton::CacheModifierAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: allowed 32-bit signless integer cases: 1, 2, 3, 4, 5, 6, 7";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps4(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::triton::EvictionPolicyAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: allowed 32-bit signless integer cases: 1, 2, 3";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps4(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps4(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps5(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::BoolAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: bool attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps5(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps5(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps6(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::triton::DescriptorReduceKindAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: allowed 32-bit signless integer cases: 1, 2, 3, 4, 5, 6, 7, 8";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps6(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps6(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps7(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(1)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 1-bit signless integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps7(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps7(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps8(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::triton::ScaleDotElemTypeAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: allowed 32-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps8(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps8(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps9(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && ((!::llvm::cast<::mlir::IntegerAttr>(attr).getValue().isNegative())) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getInt() <= 15))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute whose value is non-negative whose maximum value is 15";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps9(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps9(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps10(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && ((!::llvm::cast<::mlir::IntegerAttr>(attr).getValue().isNegative())) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getInt() <= 2))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute whose value is non-negative whose maximum value is 2";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps10(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps10(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps11(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && ((!::llvm::cast<::mlir::IntegerAttr>(attr).getValue().isNegative())) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getInt() <= 3))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute whose value is non-negative whose maximum value is 3";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps11(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps11(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps12(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && ((!::llvm::cast<::mlir::IntegerAttr>(attr).getValue().isNegative())) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getInt() <= 1))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute whose value is non-negative whose maximum value is 1";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps12(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps12(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps13(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::triton::InputPrecisionAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: allowed 32-bit signless integer cases: 0, 1, 2";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps13(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TritonNvidiaGPUOps13(attr, attrName, [op]() {
    return op->emitOpError();
  });
}
} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::ArriveBarrierOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ArriveBarrierOpGenericAdaptorBase::ArriveBarrierOpGenericAdaptorBase(ArriveBarrierOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ArriveBarrierOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

uint32_t ArriveBarrierOpGenericAdaptorBase::getCount() {
  auto attr = getCountAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
ArriveBarrierOpAdaptor::ArriveBarrierOpAdaptor(ArriveBarrierOp op) : ArriveBarrierOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ArriveBarrierOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_count = getProperties().count; (void)tblgen_count;
  if (!tblgen_count) return emitError(loc, "'ttng.arrive_barrier' op ""requires attribute 'count'");

  if (tblgen_count && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_count))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_count).getType().isSignlessInteger(32)))))
    return emitError(loc, "'ttng.arrive_barrier' op ""attribute 'count' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ArriveBarrierOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange ArriveBarrierOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult ArriveBarrierOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.count;
       auto attr = dict.get("count");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `count` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ArriveBarrierOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.count;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("count",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ArriveBarrierOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.count.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ArriveBarrierOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "count")
      return prop.count;
  return std::nullopt;
}

void ArriveBarrierOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "count") {
       prop.count = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.count)>>(value);
       return;
    }
}

void ArriveBarrierOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.count) attrs.append("count", prop.count);
}

::llvm::LogicalResult ArriveBarrierOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCountAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(attr, "count", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ArriveBarrierOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.count)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ArriveBarrierOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.count);
}

uint32_t ArriveBarrierOp::getCount() {
  auto attr = getCountAttr();
  return attr.getValue().getZExtValue();
}

void ArriveBarrierOp::setCount(uint32_t attrValue) {
  getProperties().count = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void ArriveBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value alloc, uint32_t count) {
      return build(odsBuilder, odsState, alloc, count, /*pred=*/Value());
    
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value alloc, uint32_t count) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, count);
  auto __res__ = ::llvm::dyn_cast<ArriveBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, Value alloc, uint32_t count) {
  return create(builder, builder.getLoc(), alloc, count);
}

void ArriveBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value alloc, ::mlir::IntegerAttr count, /*optional*/::mlir::Value pred) {
  odsState.addOperands(alloc);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().count = count;
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value alloc, ::mlir::IntegerAttr count, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, count, pred);
  auto __res__ = ::llvm::dyn_cast<ArriveBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value alloc, ::mlir::IntegerAttr count, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), alloc, count, pred);
}

void ArriveBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::IntegerAttr count, /*optional*/::mlir::Value pred) {
  odsState.addOperands(alloc);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().count = count;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::IntegerAttr count, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, alloc, count, pred);
  auto __res__ = ::llvm::dyn_cast<ArriveBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::IntegerAttr count, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, alloc, count, pred);
}

void ArriveBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value alloc, uint32_t count, /*optional*/::mlir::Value pred) {
  odsState.addOperands(alloc);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().count = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), count);
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value alloc, uint32_t count, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, count, pred);
  auto __res__ = ::llvm::dyn_cast<ArriveBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value alloc, uint32_t count, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), alloc, count, pred);
}

void ArriveBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, uint32_t count, /*optional*/::mlir::Value pred) {
  odsState.addOperands(alloc);
  if (pred)
    odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().count = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), count);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, uint32_t count, /*optional*/::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, alloc, count, pred);
  auto __res__ = ::llvm::dyn_cast<ArriveBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, uint32_t count, /*optional*/::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, alloc, count, pred);
}

void ArriveBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ArriveBarrierOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ArriveBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ArriveBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ArriveBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ArriveBarrierOp ArriveBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ArriveBarrierOp::verifyInvariantsImpl() {
  auto tblgen_count = getProperties().count; (void)tblgen_count;
  if (!tblgen_count) return emitOpError("requires attribute 'count'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(*this, tblgen_count, "count")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ArriveBarrierOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ArriveBarrierOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand allocRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> allocOperands(&allocRawOperand, 1);  ::llvm::SMLoc allocOperandsLoc;
  (void)allocOperandsLoc;
  ::mlir::IntegerAttr countAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type allocRawType{};
  ::llvm::ArrayRef<::mlir::Type> allocTypes(&allocRawType, 1);

  allocOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(allocRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(countAttr, parser.getBuilder().getIntegerType(32))) {
    return ::mlir::failure();
  }
  if (countAttr) result.getOrAddProperties<ArriveBarrierOp::Properties>().count = countAttr;
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(allocRawType))
    return ::mlir::failure();
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(allocOperands, allocTypes, allocOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ArriveBarrierOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getAlloc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getCountAttr());
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("count");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getAlloc().getType();
}

void ArriveBarrierOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::ArriveBarrierOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::AsyncCopyMbarrierArriveOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AsyncCopyMbarrierArriveOpGenericAdaptorBase::AsyncCopyMbarrierArriveOpGenericAdaptorBase(AsyncCopyMbarrierArriveOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::UnitAttr AsyncCopyMbarrierArriveOpGenericAdaptorBase::getNoIncrementAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().noIncrement);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool AsyncCopyMbarrierArriveOpGenericAdaptorBase::getNoIncrement() {
  auto attr = getNoIncrementAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

} // namespace detail
AsyncCopyMbarrierArriveOpAdaptor::AsyncCopyMbarrierArriveOpAdaptor(AsyncCopyMbarrierArriveOp op) : AsyncCopyMbarrierArriveOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AsyncCopyMbarrierArriveOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_noIncrement = getProperties().noIncrement; (void)tblgen_noIncrement;

  if (tblgen_noIncrement && !((::llvm::isa<::mlir::UnitAttr>(tblgen_noIncrement))))
    return emitError(loc, "'ttng.async_copy_mbarrier_arrive' op ""attribute 'noIncrement' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

::llvm::LogicalResult AsyncCopyMbarrierArriveOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.noIncrement;
       auto attr = dict.get("noIncrement");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `noIncrement` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute AsyncCopyMbarrierArriveOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.noIncrement;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("noIncrement",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AsyncCopyMbarrierArriveOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.noIncrement.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> AsyncCopyMbarrierArriveOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "noIncrement")
      return prop.noIncrement;
  return std::nullopt;
}

void AsyncCopyMbarrierArriveOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "noIncrement") {
       prop.noIncrement = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.noIncrement)>>(value);
       return;
    }
}

void AsyncCopyMbarrierArriveOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.noIncrement) attrs.append("noIncrement", prop.noIncrement);
}

::llvm::LogicalResult AsyncCopyMbarrierArriveOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getNoIncrementAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(attr, "noIncrement", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult AsyncCopyMbarrierArriveOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.noIncrement)))
    return ::mlir::failure();
  return ::mlir::success();
}

void AsyncCopyMbarrierArriveOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.noIncrement);
}

bool AsyncCopyMbarrierArriveOp::getNoIncrement() {
  auto attr = getNoIncrementAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

void AsyncCopyMbarrierArriveOp::setNoIncrement(bool attrValue) {
    auto &odsProp = getProperties().noIncrement;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

void AsyncCopyMbarrierArriveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value barrier, /*optional*/::mlir::UnitAttr noIncrement) {
  odsState.addOperands(barrier);
  if (noIncrement) {
    odsState.getOrAddProperties<Properties>().noIncrement = noIncrement;
  }
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value barrier, /*optional*/::mlir::UnitAttr noIncrement) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, barrier, noIncrement);
  auto __res__ = ::llvm::dyn_cast<AsyncCopyMbarrierArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value barrier, /*optional*/::mlir::UnitAttr noIncrement) {
  return create(builder, builder.getLoc(), barrier, noIncrement);
}

void AsyncCopyMbarrierArriveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/::mlir::UnitAttr noIncrement) {
  odsState.addOperands(barrier);
  if (noIncrement) {
    odsState.getOrAddProperties<Properties>().noIncrement = noIncrement;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/::mlir::UnitAttr noIncrement) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, barrier, noIncrement);
  auto __res__ = ::llvm::dyn_cast<AsyncCopyMbarrierArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/::mlir::UnitAttr noIncrement) {
  return create(builder, builder.getLoc(), resultTypes, barrier, noIncrement);
}

void AsyncCopyMbarrierArriveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value barrier, /*optional*/bool noIncrement) {
  odsState.addOperands(barrier);
  if (noIncrement) {
    odsState.getOrAddProperties<Properties>().noIncrement = ((noIncrement) ? odsBuilder.getUnitAttr() : nullptr);
  }
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value barrier, /*optional*/bool noIncrement) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, barrier, noIncrement);
  auto __res__ = ::llvm::dyn_cast<AsyncCopyMbarrierArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value barrier, /*optional*/bool noIncrement) {
  return create(builder, builder.getLoc(), barrier, noIncrement);
}

void AsyncCopyMbarrierArriveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/bool noIncrement) {
  odsState.addOperands(barrier);
  if (noIncrement) {
    odsState.getOrAddProperties<Properties>().noIncrement = ((noIncrement) ? odsBuilder.getUnitAttr() : nullptr);
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/bool noIncrement) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, barrier, noIncrement);
  auto __res__ = ::llvm::dyn_cast<AsyncCopyMbarrierArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/bool noIncrement) {
  return create(builder, builder.getLoc(), resultTypes, barrier, noIncrement);
}

void AsyncCopyMbarrierArriveOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<AsyncCopyMbarrierArriveOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<AsyncCopyMbarrierArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void AsyncCopyMbarrierArriveOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<AsyncCopyMbarrierArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncCopyMbarrierArriveOp AsyncCopyMbarrierArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult AsyncCopyMbarrierArriveOp::verifyInvariantsImpl() {
  auto tblgen_noIncrement = getProperties().noIncrement; (void)tblgen_noIncrement;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(*this, tblgen_noIncrement, "noIncrement")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult AsyncCopyMbarrierArriveOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult AsyncCopyMbarrierArriveOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand barrierRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> barrierOperands(&barrierRawOperand, 1);  ::llvm::SMLoc barrierOperandsLoc;
  (void)barrierOperandsLoc;
  ::mlir::Type barrierRawType{};
  ::llvm::ArrayRef<::mlir::Type> barrierTypes(&barrierRawType, 1);

  barrierOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(barrierRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(barrierRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(barrierOperands, barrierTypes, barrierOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AsyncCopyMbarrierArriveOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBarrier();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getNoIncrementAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("noIncrement");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getBarrier().getType();
}

void AsyncCopyMbarrierArriveOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::AsyncCopyMbarrierArriveOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::AsyncTMACopyGlobalToLocalOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AsyncTMACopyGlobalToLocalOpGenericAdaptorBase::AsyncTMACopyGlobalToLocalOpGenericAdaptorBase(AsyncTMACopyGlobalToLocalOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> AsyncTMACopyGlobalToLocalOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true, false, false, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 4) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::triton::CacheModifierAttr AsyncTMACopyGlobalToLocalOpGenericAdaptorBase::getCacheAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::triton::CacheModifierAttr>(getProperties().cache);
  return attr;
}

::mlir::triton::CacheModifier AsyncTMACopyGlobalToLocalOpGenericAdaptorBase::getCache() {
  auto attr = getCacheAttr();
  return attr.getValue();
}

::mlir::triton::EvictionPolicyAttr AsyncTMACopyGlobalToLocalOpGenericAdaptorBase::getEvictAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::triton::EvictionPolicyAttr>(getProperties().evict);
  return attr;
}

::mlir::triton::EvictionPolicy AsyncTMACopyGlobalToLocalOpGenericAdaptorBase::getEvict() {
  auto attr = getEvictAttr();
  return attr.getValue();
}

::mlir::BoolAttr AsyncTMACopyGlobalToLocalOpGenericAdaptorBase::getIsVolatileAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().isVolatile);
  return attr;
}

bool AsyncTMACopyGlobalToLocalOpGenericAdaptorBase::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue();
}

} // namespace detail
AsyncTMACopyGlobalToLocalOpAdaptor::AsyncTMACopyGlobalToLocalOpAdaptor(AsyncTMACopyGlobalToLocalOp op) : AsyncTMACopyGlobalToLocalOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AsyncTMACopyGlobalToLocalOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_cache = getProperties().cache; (void)tblgen_cache;
  auto tblgen_evict = getProperties().evict; (void)tblgen_evict;
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;

  if (tblgen_cache && !((::llvm::isa<::mlir::triton::CacheModifierAttr>(tblgen_cache))))
    return emitError(loc, "'ttng.async_tma_copy_global_to_local' op ""attribute 'cache' failed to satisfy constraint: allowed 32-bit signless integer cases: 1, 2, 3, 4, 5, 6, 7");

  if (tblgen_evict && !((::llvm::isa<::mlir::triton::EvictionPolicyAttr>(tblgen_evict))))
    return emitError(loc, "'ttng.async_tma_copy_global_to_local' op ""attribute 'evict' failed to satisfy constraint: allowed 32-bit signless integer cases: 1, 2, 3");

  if (tblgen_isVolatile && !((::llvm::isa<::mlir::BoolAttr>(tblgen_isVolatile))))
    return emitError(loc, "'ttng.async_tma_copy_global_to_local' op ""attribute 'isVolatile' failed to satisfy constraint: bool attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> AsyncTMACopyGlobalToLocalOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true, false, false, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 4) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange AsyncTMACopyGlobalToLocalOp::getCoordMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult AsyncTMACopyGlobalToLocalOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.cache;
       auto attr = dict.get("cache");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.evict;
       auto attr = dict.get("evict");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `evict` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.isVolatile;
       auto attr = dict.get("isVolatile");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `isVolatile` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute AsyncTMACopyGlobalToLocalOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.cache;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("cache",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.evict;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("evict",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.isVolatile;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("isVolatile",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AsyncTMACopyGlobalToLocalOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.cache.getAsOpaquePointer()), 
    llvm::hash_value(prop.evict.getAsOpaquePointer()), 
    llvm::hash_value(prop.isVolatile.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> AsyncTMACopyGlobalToLocalOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "cache")
      return prop.cache;

    if (name == "evict")
      return prop.evict;

    if (name == "isVolatile")
      return prop.isVolatile;
  return std::nullopt;
}

void AsyncTMACopyGlobalToLocalOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "cache") {
       prop.cache = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.cache)>>(value);
       return;
    }

    if (name == "evict") {
       prop.evict = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.evict)>>(value);
       return;
    }

    if (name == "isVolatile") {
       prop.isVolatile = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.isVolatile)>>(value);
       return;
    }
}

void AsyncTMACopyGlobalToLocalOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.cache) attrs.append("cache", prop.cache);

    if (prop.evict) attrs.append("evict", prop.evict);

    if (prop.isVolatile) attrs.append("isVolatile", prop.isVolatile);
}

::llvm::LogicalResult AsyncTMACopyGlobalToLocalOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCacheAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps3(attr, "cache", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getEvictAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps4(attr, "evict", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getIsVolatileAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps5(attr, "isVolatile", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult AsyncTMACopyGlobalToLocalOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.cache)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.evict)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.isVolatile)))
    return ::mlir::failure();
  return ::mlir::success();
}

void AsyncTMACopyGlobalToLocalOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.cache);

  writer.writeOptionalAttribute(prop.evict);

  writer.writeOptionalAttribute(prop.isVolatile);
}

::mlir::triton::CacheModifier AsyncTMACopyGlobalToLocalOp::getCache() {
  auto attr = getCacheAttr();
  return attr.getValue();
}

::mlir::triton::EvictionPolicy AsyncTMACopyGlobalToLocalOp::getEvict() {
  auto attr = getEvictAttr();
  return attr.getValue();
}

bool AsyncTMACopyGlobalToLocalOp::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue();
}

void AsyncTMACopyGlobalToLocalOp::setCache(::mlir::triton::CacheModifier attrValue) {
  getProperties().cache = ::mlir::triton::CacheModifierAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void AsyncTMACopyGlobalToLocalOp::setEvict(::mlir::triton::EvictionPolicy attrValue) {
  getProperties().evict = ::mlir::triton::EvictionPolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void AsyncTMACopyGlobalToLocalOp::setIsVolatile(bool attrValue) {
  getProperties().isVolatile = ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue);
}

void AsyncTMACopyGlobalToLocalOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifierAttr cache, ::mlir::triton::EvictionPolicyAttr evict, ::mlir::BoolAttr isVolatile) {
  odsState.addOperands(desc);
  odsState.addOperands(coord);
  odsState.addOperands(barrier);
  odsState.addOperands(result);
  odsState.addOperands(pred);
  if (cache) {
    odsState.getOrAddProperties<Properties>().cache = cache;
  }
  if (evict) {
    odsState.getOrAddProperties<Properties>().evict = evict;
  }
  if (isVolatile) {
    odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  }
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifierAttr cache, ::mlir::triton::EvictionPolicyAttr evict, ::mlir::BoolAttr isVolatile) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, desc, coord, barrier, result, pred, cache, evict, isVolatile);
  auto __res__ = ::llvm::dyn_cast<AsyncTMACopyGlobalToLocalOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifierAttr cache, ::mlir::triton::EvictionPolicyAttr evict, ::mlir::BoolAttr isVolatile) {
  return create(builder, builder.getLoc(), desc, coord, barrier, result, pred, cache, evict, isVolatile);
}

void AsyncTMACopyGlobalToLocalOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifierAttr cache, ::mlir::triton::EvictionPolicyAttr evict, ::mlir::BoolAttr isVolatile) {
  odsState.addOperands(desc);
  odsState.addOperands(coord);
  odsState.addOperands(barrier);
  odsState.addOperands(result);
  odsState.addOperands(pred);
  if (cache) {
    odsState.getOrAddProperties<Properties>().cache = cache;
  }
  if (evict) {
    odsState.getOrAddProperties<Properties>().evict = evict;
  }
  if (isVolatile) {
    odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifierAttr cache, ::mlir::triton::EvictionPolicyAttr evict, ::mlir::BoolAttr isVolatile) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, desc, coord, barrier, result, pred, cache, evict, isVolatile);
  auto __res__ = ::llvm::dyn_cast<AsyncTMACopyGlobalToLocalOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifierAttr cache, ::mlir::triton::EvictionPolicyAttr evict, ::mlir::BoolAttr isVolatile) {
  return create(builder, builder.getLoc(), resultTypes, desc, coord, barrier, result, pred, cache, evict, isVolatile);
}

void AsyncTMACopyGlobalToLocalOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifier cache, ::mlir::triton::EvictionPolicy evict, bool isVolatile) {
  odsState.addOperands(desc);
  odsState.addOperands(coord);
  odsState.addOperands(barrier);
  odsState.addOperands(result);
  odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().cache = ::mlir::triton::CacheModifierAttr::get(odsBuilder.getContext(), cache);
  odsState.getOrAddProperties<Properties>().evict = ::mlir::triton::EvictionPolicyAttr::get(odsBuilder.getContext(), evict);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getBoolAttr(isVolatile);
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifier cache, ::mlir::triton::EvictionPolicy evict, bool isVolatile) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, desc, coord, barrier, result, pred, cache, evict, isVolatile);
  auto __res__ = ::llvm::dyn_cast<AsyncTMACopyGlobalToLocalOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifier cache, ::mlir::triton::EvictionPolicy evict, bool isVolatile) {
  return create(builder, builder.getLoc(), desc, coord, barrier, result, pred, cache, evict, isVolatile);
}

void AsyncTMACopyGlobalToLocalOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifier cache, ::mlir::triton::EvictionPolicy evict, bool isVolatile) {
  odsState.addOperands(desc);
  odsState.addOperands(coord);
  odsState.addOperands(barrier);
  odsState.addOperands(result);
  odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().cache = ::mlir::triton::CacheModifierAttr::get(odsBuilder.getContext(), cache);
  odsState.getOrAddProperties<Properties>().evict = ::mlir::triton::EvictionPolicyAttr::get(odsBuilder.getContext(), evict);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getBoolAttr(isVolatile);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifier cache, ::mlir::triton::EvictionPolicy evict, bool isVolatile) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, desc, coord, barrier, result, pred, cache, evict, isVolatile);
  auto __res__ = ::llvm::dyn_cast<AsyncTMACopyGlobalToLocalOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred, ::mlir::triton::CacheModifier cache, ::mlir::triton::EvictionPolicy evict, bool isVolatile) {
  return create(builder, builder.getLoc(), resultTypes, desc, coord, barrier, result, pred, cache, evict, isVolatile);
}

void AsyncTMACopyGlobalToLocalOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<AsyncTMACopyGlobalToLocalOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<AsyncTMACopyGlobalToLocalOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void AsyncTMACopyGlobalToLocalOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<AsyncTMACopyGlobalToLocalOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMACopyGlobalToLocalOp AsyncTMACopyGlobalToLocalOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

void AsyncTMACopyGlobalToLocalOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.cache)
    properties.cache = ::mlir::triton::CacheModifierAttr::get(odsBuilder.getContext(), triton::CacheModifier::NONE);
  if (!properties.evict)
    properties.evict = ::mlir::triton::EvictionPolicyAttr::get(odsBuilder.getContext(), triton::EvictionPolicy::NORMAL);
  if (!properties.isVolatile)
    properties.isVolatile = odsBuilder.getBoolAttr(false);
}

::llvm::LogicalResult AsyncTMACopyGlobalToLocalOp::verifyInvariantsImpl() {
  auto tblgen_cache = getProperties().cache; (void)tblgen_cache;
  auto tblgen_evict = getProperties().evict; (void)tblgen_evict;
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps3(*this, tblgen_cache, "cache")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps4(*this, tblgen_evict, "evict")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps5(*this, tblgen_isVolatile, "isVolatile")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult AsyncTMACopyGlobalToLocalOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult AsyncTMACopyGlobalToLocalOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand descRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> descOperands(&descRawOperand, 1);  ::llvm::SMLoc descOperandsLoc;
  (void)descOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> coordOperands;
  ::llvm::SMLoc coordOperandsLoc;
  (void)coordOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand resultRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> resultOperands(&resultRawOperand, 1);  ::llvm::SMLoc resultOperandsLoc;
  (void)resultOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand barrierRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> barrierOperands(&barrierRawOperand, 1);  ::llvm::SMLoc barrierOperandsLoc;
  (void)barrierOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand predRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> predOperands(&predRawOperand, 1);  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::triton::CacheModifierAttr cacheAttr;
  ::mlir::triton::EvictionPolicyAttr evictAttr;
  ::mlir::Type descRawType{};
  ::llvm::ArrayRef<::mlir::Type> descTypes(&descRawType, 1);
  ::mlir::Type barrierRawType{};
  ::llvm::ArrayRef<::mlir::Type> barrierTypes(&barrierRawType, 1);
  ::mlir::Type resultRawType{};
  ::llvm::ArrayRef<::mlir::Type> resultTypes(&resultRawType, 1);

  descOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(descRawOperand))
    return ::mlir::failure();
  if (parser.parseLSquare())
    return ::mlir::failure();

  coordOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(coordOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();

  resultOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(resultRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  barrierOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(barrierRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  predOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(predRawOperand))
    return ::mlir::failure();
  bool cacheModifierClause = false;
  bool evictionPolicyClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("cacheModifier"))) {

  if (cacheModifierClause) {
    return parser.emitError(parser.getNameLoc())
          << "`cacheModifier` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  cacheModifierClause = true;
  if (parser.parseEqual())
    return ::mlir::failure();

  {
    ::llvm::StringRef attrStr;
    ::mlir::NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseOptionalKeyword(&attrStr, {"none","ca","cg","wb","cs","wt","cv"})) {
      ::mlir::StringAttr attrVal;
      ::mlir::OptionalParseResult parseResult =
        parser.parseOptionalAttribute(attrVal,
                                      parser.getBuilder().getNoneType(),
                                      "cache", attrStorage);
      if (parseResult.has_value()) {
        if (failed(*parseResult))
          return ::mlir::failure();
        attrStr = attrVal.getValue();
      } else {
        return parser.emitError(loc, "expected string or keyword containing one of the following enum values for attribute 'cache' [none, ca, cg, wb, cs, wt, cv]");
      }
    }
    if (!attrStr.empty()) {
      auto attrOptional = ::mlir::triton::symbolizeCacheModifier(attrStr);
      if (!attrOptional)
        return parser.emitError(loc, "invalid ")
               << "cache attribute specification: \"" << attrStr << '"';;

      cacheAttr = ::mlir::triton::CacheModifierAttr::get(parser.getBuilder().getContext(), *attrOptional);
        result.getOrAddProperties<AsyncTMACopyGlobalToLocalOp::Properties>().cache = cacheAttr;
    }
  }
    } else if (succeeded(parser.parseOptionalKeyword("evictionPolicy"))) {

  if (evictionPolicyClause) {
    return parser.emitError(parser.getNameLoc())
          << "`evictionPolicy` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  evictionPolicyClause = true;
  if (parser.parseEqual())
    return ::mlir::failure();

  {
    ::llvm::StringRef attrStr;
    ::mlir::NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseOptionalKeyword(&attrStr, {"evict_normal","evict_first","evict_last"})) {
      ::mlir::StringAttr attrVal;
      ::mlir::OptionalParseResult parseResult =
        parser.parseOptionalAttribute(attrVal,
                                      parser.getBuilder().getNoneType(),
                                      "evict", attrStorage);
      if (parseResult.has_value()) {
        if (failed(*parseResult))
          return ::mlir::failure();
        attrStr = attrVal.getValue();
      } else {
        return parser.emitError(loc, "expected string or keyword containing one of the following enum values for attribute 'evict' [evict_normal, evict_first, evict_last]");
      }
    }
    if (!attrStr.empty()) {
      auto attrOptional = ::mlir::triton::symbolizeEvictionPolicy(attrStr);
      if (!attrOptional)
        return parser.emitError(loc, "invalid ")
               << "evict attribute specification: \"" << attrStr << '"';;

      evictAttr = ::mlir::triton::EvictionPolicyAttr::get(parser.getBuilder().getContext(), *attrOptional);
        result.getOrAddProperties<AsyncTMACopyGlobalToLocalOp::Properties>().evict = evictAttr;
    }
  }
    } else  {
    break;
  }
}
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(descRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(barrierRawType))
    return ::mlir::failure();
  if (parser.parseArrow())
    return ::mlir::failure();

  if (parser.parseType(resultRawType))
    return ::mlir::failure();
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(32);
  ::mlir::Type odsBuildableType1 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(descOperands, descTypes, descOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(coordOperands, odsBuildableType0, coordOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(barrierOperands, barrierTypes, barrierOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(resultOperands, resultTypes, resultOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType1, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AsyncTMACopyGlobalToLocalOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getDesc();
  _odsPrinter << "[";
  _odsPrinter << getCoord();
  _odsPrinter << "]";
  _odsPrinter << ' ';
  _odsPrinter << getResult();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getBarrier();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getPred();
  if (false || (getCacheAttr() != ::mlir::triton::CacheModifierAttr::get(::mlir::OpBuilder((*this)->getContext()).getContext(), triton::CacheModifier::NONE))) {
  _odsPrinter << ' ' << "cacheModifier";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';

  {
    auto caseValue = getCache();
    auto caseValueStr = stringifyCacheModifier(caseValue);
    _odsPrinter << caseValueStr;
  }
  }
  if (false || (getEvictAttr() != ::mlir::triton::EvictionPolicyAttr::get(::mlir::OpBuilder((*this)->getContext()).getContext(), triton::EvictionPolicy::NORMAL))) {
  _odsPrinter << ' ' << "evictionPolicy";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';

  {
    auto caseValue = getEvict();
    auto caseValueStr = stringifyEvictionPolicy(caseValue);
    _odsPrinter << caseValueStr;
  }
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("cache");
  elidedAttrs.push_back("evict");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getCacheAttr();
     if(attr && (attr == ::mlir::triton::CacheModifierAttr::get(odsBuilder.getContext(), triton::CacheModifier::NONE)))
       elidedAttrs.push_back("cache");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getEvictAttr();
     if(attr && (attr == ::mlir::triton::EvictionPolicyAttr::get(odsBuilder.getContext(), triton::EvictionPolicy::NORMAL)))
       elidedAttrs.push_back("evict");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getIsVolatileAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("isVolatile");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getDesc().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getBarrier().getType();
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
   _odsPrinter << getResult().getType();
}

void AsyncTMACopyGlobalToLocalOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::GlobalMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(2);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(3);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::AsyncTMACopyGlobalToLocalOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::AsyncTMACopyLocalToGlobalOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AsyncTMACopyLocalToGlobalOpGenericAdaptorBase::AsyncTMACopyLocalToGlobalOpGenericAdaptorBase(AsyncTMACopyLocalToGlobalOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> AsyncTMACopyLocalToGlobalOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

} // namespace detail
AsyncTMACopyLocalToGlobalOpAdaptor::AsyncTMACopyLocalToGlobalOpAdaptor(AsyncTMACopyLocalToGlobalOp op) : AsyncTMACopyLocalToGlobalOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AsyncTMACopyLocalToGlobalOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> AsyncTMACopyLocalToGlobalOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange AsyncTMACopyLocalToGlobalOp::getCoordMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult AsyncTMACopyLocalToGlobalOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute AsyncTMACopyLocalToGlobalOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AsyncTMACopyLocalToGlobalOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> AsyncTMACopyLocalToGlobalOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void AsyncTMACopyLocalToGlobalOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void AsyncTMACopyLocalToGlobalOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult AsyncTMACopyLocalToGlobalOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void AsyncTMACopyLocalToGlobalOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  odsState.addOperands(desc);
  odsState.addOperands(coord);
  odsState.addOperands(src);
}

AsyncTMACopyLocalToGlobalOp AsyncTMACopyLocalToGlobalOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, desc, coord, src);
  auto __res__ = ::llvm::dyn_cast<AsyncTMACopyLocalToGlobalOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMACopyLocalToGlobalOp AsyncTMACopyLocalToGlobalOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  return create(builder, builder.getLoc(), desc, coord, src);
}

void AsyncTMACopyLocalToGlobalOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  odsState.addOperands(desc);
  odsState.addOperands(coord);
  odsState.addOperands(src);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AsyncTMACopyLocalToGlobalOp AsyncTMACopyLocalToGlobalOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, desc, coord, src);
  auto __res__ = ::llvm::dyn_cast<AsyncTMACopyLocalToGlobalOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMACopyLocalToGlobalOp AsyncTMACopyLocalToGlobalOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  return create(builder, builder.getLoc(), resultTypes, desc, coord, src);
}

void AsyncTMACopyLocalToGlobalOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AsyncTMACopyLocalToGlobalOp AsyncTMACopyLocalToGlobalOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<AsyncTMACopyLocalToGlobalOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMACopyLocalToGlobalOp AsyncTMACopyLocalToGlobalOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void AsyncTMACopyLocalToGlobalOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AsyncTMACopyLocalToGlobalOp AsyncTMACopyLocalToGlobalOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<AsyncTMACopyLocalToGlobalOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMACopyLocalToGlobalOp AsyncTMACopyLocalToGlobalOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult AsyncTMACopyLocalToGlobalOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult AsyncTMACopyLocalToGlobalOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult AsyncTMACopyLocalToGlobalOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand descRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> descOperands(&descRawOperand, 1);  ::llvm::SMLoc descOperandsLoc;
  (void)descOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> coordOperands;
  ::llvm::SMLoc coordOperandsLoc;
  (void)coordOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand srcRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> srcOperands(&srcRawOperand, 1);  ::llvm::SMLoc srcOperandsLoc;
  (void)srcOperandsLoc;
  ::mlir::Type descRawType{};
  ::llvm::ArrayRef<::mlir::Type> descTypes(&descRawType, 1);
  ::mlir::Type srcRawType{};
  ::llvm::ArrayRef<::mlir::Type> srcTypes(&srcRawType, 1);

  descOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(descRawOperand))
    return ::mlir::failure();
  if (parser.parseLSquare())
    return ::mlir::failure();

  coordOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(coordOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();

  srcOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(srcRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(descRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(srcRawType))
    return ::mlir::failure();
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(32);
  if (parser.resolveOperands(descOperands, descTypes, descOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(coordOperands, odsBuildableType0, coordOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(srcOperands, srcTypes, srcOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AsyncTMACopyLocalToGlobalOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getDesc();
  _odsPrinter << "[";
  _odsPrinter << getCoord();
  _odsPrinter << "]";
  _odsPrinter << ' ';
  _odsPrinter << getSrc();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getDesc().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getSrc().getType();
}

void AsyncTMACopyLocalToGlobalOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::GlobalMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::GlobalMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(2);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::AsyncTMACopyLocalToGlobalOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::AsyncTMAGatherOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AsyncTMAGatherOpGenericAdaptorBase::AsyncTMAGatherOpGenericAdaptorBase(AsyncTMAGatherOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
AsyncTMAGatherOpAdaptor::AsyncTMAGatherOpAdaptor(AsyncTMAGatherOp op) : AsyncTMAGatherOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AsyncTMAGatherOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult AsyncTMAGatherOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute AsyncTMAGatherOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AsyncTMAGatherOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> AsyncTMAGatherOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void AsyncTMAGatherOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void AsyncTMAGatherOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult AsyncTMAGatherOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void AsyncTMAGatherOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred) {
  odsState.addOperands(desc);
  odsState.addOperands(x_offsets);
  odsState.addOperands(y_offset);
  odsState.addOperands(barrier);
  odsState.addOperands(result);
  odsState.addOperands(pred);
}

AsyncTMAGatherOp AsyncTMAGatherOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, desc, x_offsets, y_offset, barrier, result, pred);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAGatherOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAGatherOp AsyncTMAGatherOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred) {
  return create(builder, builder.getLoc(), desc, x_offsets, y_offset, barrier, result, pred);
}

void AsyncTMAGatherOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred) {
  odsState.addOperands(desc);
  odsState.addOperands(x_offsets);
  odsState.addOperands(y_offset);
  odsState.addOperands(barrier);
  odsState.addOperands(result);
  odsState.addOperands(pred);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AsyncTMAGatherOp AsyncTMAGatherOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, desc, x_offsets, y_offset, barrier, result, pred);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAGatherOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAGatherOp AsyncTMAGatherOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value barrier, ::mlir::Value result, ::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, desc, x_offsets, y_offset, barrier, result, pred);
}

void AsyncTMAGatherOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 6u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AsyncTMAGatherOp AsyncTMAGatherOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAGatherOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAGatherOp AsyncTMAGatherOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void AsyncTMAGatherOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 6u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AsyncTMAGatherOp AsyncTMAGatherOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAGatherOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAGatherOp AsyncTMAGatherOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult AsyncTMAGatherOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult AsyncTMAGatherOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult AsyncTMAGatherOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand descRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> descOperands(&descRawOperand, 1);  ::llvm::SMLoc descOperandsLoc;
  (void)descOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand x_offsetsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> x_offsetsOperands(&x_offsetsRawOperand, 1);  ::llvm::SMLoc x_offsetsOperandsLoc;
  (void)x_offsetsOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand y_offsetRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> y_offsetOperands(&y_offsetRawOperand, 1);  ::llvm::SMLoc y_offsetOperandsLoc;
  (void)y_offsetOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand resultRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> resultOperands(&resultRawOperand, 1);  ::llvm::SMLoc resultOperandsLoc;
  (void)resultOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand barrierRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> barrierOperands(&barrierRawOperand, 1);  ::llvm::SMLoc barrierOperandsLoc;
  (void)barrierOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand predRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> predOperands(&predRawOperand, 1);  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> allOperandTypes;

  descOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(descRawOperand))
    return ::mlir::failure();
  if (parser.parseLSquare())
    return ::mlir::failure();

  x_offsetsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(x_offsetsRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  y_offsetOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(y_offsetRawOperand))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();

  resultOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(resultRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  barrierOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(barrierRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  predOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(predRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(allOperandTypes))
    return ::mlir::failure();
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(descOperands, x_offsetsOperands, y_offsetOperands, barrierOperands, resultOperands, predOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AsyncTMAGatherOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getDesc();
  _odsPrinter << "[";
  _odsPrinter << getXOffsets();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getYOffset();
  _odsPrinter << "]";
  _odsPrinter << ' ';
  _odsPrinter << getResult();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getBarrier();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getPred();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperandTypes();
}

void AsyncTMAGatherOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::GlobalMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(3);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(4);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::AsyncTMAGatherOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::AsyncTMAReduceOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AsyncTMAReduceOpGenericAdaptorBase::AsyncTMAReduceOpGenericAdaptorBase(AsyncTMAReduceOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> AsyncTMAReduceOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::triton::DescriptorReduceKind AsyncTMAReduceOpGenericAdaptorBase::getKind() {
  auto attr = getKindAttr();
  return attr.getValue();
}

} // namespace detail
AsyncTMAReduceOpAdaptor::AsyncTMAReduceOpAdaptor(AsyncTMAReduceOp op) : AsyncTMAReduceOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AsyncTMAReduceOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_kind = getProperties().kind; (void)tblgen_kind;
  if (!tblgen_kind) return emitError(loc, "'ttng.async_tma_reduce' op ""requires attribute 'kind'");

  if (tblgen_kind && !((::llvm::isa<::mlir::triton::DescriptorReduceKindAttr>(tblgen_kind))))
    return emitError(loc, "'ttng.async_tma_reduce' op ""attribute 'kind' failed to satisfy constraint: allowed 32-bit signless integer cases: 1, 2, 3, 4, 5, 6, 7, 8");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> AsyncTMAReduceOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange AsyncTMAReduceOp::getCoordMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult AsyncTMAReduceOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.kind;
       auto attr = dict.get("kind");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `kind` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute AsyncTMAReduceOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.kind;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("kind",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AsyncTMAReduceOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.kind.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> AsyncTMAReduceOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "kind")
      return prop.kind;
  return std::nullopt;
}

void AsyncTMAReduceOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "kind") {
       prop.kind = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.kind)>>(value);
       return;
    }
}

void AsyncTMAReduceOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.kind) attrs.append("kind", prop.kind);
}

::llvm::LogicalResult AsyncTMAReduceOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getKindAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps6(attr, "kind", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult AsyncTMAReduceOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.kind)))
    return ::mlir::failure();
  return ::mlir::success();
}

void AsyncTMAReduceOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.kind);
}

::mlir::triton::DescriptorReduceKind AsyncTMAReduceOp::getKind() {
  auto attr = getKindAttr();
  return attr.getValue();
}

void AsyncTMAReduceOp::setKind(::mlir::triton::DescriptorReduceKind attrValue) {
  getProperties().kind = ::mlir::triton::DescriptorReduceKindAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void AsyncTMAReduceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::triton::DescriptorReduceKindAttr kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  odsState.addOperands(desc);
  odsState.addOperands(coord);
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().kind = kind;
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::triton::DescriptorReduceKindAttr kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, kind, desc, coord, src);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAReduceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::triton::DescriptorReduceKindAttr kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  return create(builder, builder.getLoc(), kind, desc, coord, src);
}

void AsyncTMAReduceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::triton::DescriptorReduceKindAttr kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  odsState.addOperands(desc);
  odsState.addOperands(coord);
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().kind = kind;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::triton::DescriptorReduceKindAttr kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, kind, desc, coord, src);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAReduceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::triton::DescriptorReduceKindAttr kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  return create(builder, builder.getLoc(), resultTypes, kind, desc, coord, src);
}

void AsyncTMAReduceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::triton::DescriptorReduceKind kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  odsState.addOperands(desc);
  odsState.addOperands(coord);
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().kind = ::mlir::triton::DescriptorReduceKindAttr::get(odsBuilder.getContext(), kind);
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::triton::DescriptorReduceKind kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, kind, desc, coord, src);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAReduceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::triton::DescriptorReduceKind kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  return create(builder, builder.getLoc(), kind, desc, coord, src);
}

void AsyncTMAReduceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::triton::DescriptorReduceKind kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  odsState.addOperands(desc);
  odsState.addOperands(coord);
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().kind = ::mlir::triton::DescriptorReduceKindAttr::get(odsBuilder.getContext(), kind);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::triton::DescriptorReduceKind kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, kind, desc, coord, src);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAReduceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::triton::DescriptorReduceKind kind, ::mlir::Value desc, ::mlir::ValueRange coord, ::mlir::Value src) {
  return create(builder, builder.getLoc(), resultTypes, kind, desc, coord, src);
}

void AsyncTMAReduceOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<AsyncTMAReduceOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAReduceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void AsyncTMAReduceOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAReduceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAReduceOp AsyncTMAReduceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult AsyncTMAReduceOp::verifyInvariantsImpl() {
  auto tblgen_kind = getProperties().kind; (void)tblgen_kind;
  if (!tblgen_kind) return emitOpError("requires attribute 'kind'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps6(*this, tblgen_kind, "kind")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult AsyncTMAReduceOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult AsyncTMAReduceOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::triton::DescriptorReduceKindAttr kindAttr;
  ::mlir::OpAsmParser::UnresolvedOperand descRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> descOperands(&descRawOperand, 1);  ::llvm::SMLoc descOperandsLoc;
  (void)descOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> coordOperands;
  ::llvm::SMLoc coordOperandsLoc;
  (void)coordOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand srcRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> srcOperands(&srcRawOperand, 1);  ::llvm::SMLoc srcOperandsLoc;
  (void)srcOperandsLoc;
  ::mlir::Type descRawType{};
  ::llvm::ArrayRef<::mlir::Type> descTypes(&descRawType, 1);
  ::mlir::Type srcRawType{};
  ::llvm::ArrayRef<::mlir::Type> srcTypes(&srcRawType, 1);

  {
    ::llvm::StringRef attrStr;
    ::mlir::NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseOptionalKeyword(&attrStr, {"add","min","max","inc","dec","and","or","xor"})) {
      ::mlir::StringAttr attrVal;
      ::mlir::OptionalParseResult parseResult =
        parser.parseOptionalAttribute(attrVal,
                                      parser.getBuilder().getNoneType(),
                                      "kind", attrStorage);
      if (parseResult.has_value()) {
        if (failed(*parseResult))
          return ::mlir::failure();
        attrStr = attrVal.getValue();
      } else {
        return parser.emitError(loc, "expected string or keyword containing one of the following enum values for attribute 'kind' [add, min, max, inc, dec, and, or, xor]");
      }
    }
    if (!attrStr.empty()) {
      auto attrOptional = ::mlir::triton::symbolizeDescriptorReduceKind(attrStr);
      if (!attrOptional)
        return parser.emitError(loc, "invalid ")
               << "kind attribute specification: \"" << attrStr << '"';;

      kindAttr = ::mlir::triton::DescriptorReduceKindAttr::get(parser.getBuilder().getContext(), *attrOptional);
        result.getOrAddProperties<AsyncTMAReduceOp::Properties>().kind = kindAttr;
    }
  }
  if (parser.parseComma())
    return ::mlir::failure();

  descOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(descRawOperand))
    return ::mlir::failure();
  if (parser.parseLSquare())
    return ::mlir::failure();

  coordOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(coordOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();

  srcOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(srcRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(descRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(srcRawType))
    return ::mlir::failure();
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(32);
  if (parser.resolveOperands(descOperands, descTypes, descOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(coordOperands, odsBuildableType0, coordOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(srcOperands, srcTypes, srcOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AsyncTMAReduceOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';

  {
    auto caseValue = getKind();
    auto caseValueStr = stringifyDescriptorReduceKind(caseValue);
    _odsPrinter << caseValueStr;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getDesc();
  _odsPrinter << "[";
  _odsPrinter << getCoord();
  _odsPrinter << "]";
  _odsPrinter << ' ';
  _odsPrinter << getSrc();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("kind");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getDesc().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getSrc().getType();
}

void AsyncTMAReduceOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Read::get(), 0, false, ::mlir::triton::GlobalMemory::get());
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::GlobalMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(2);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::AsyncTMAReduceOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::AsyncTMAScatterOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AsyncTMAScatterOpGenericAdaptorBase::AsyncTMAScatterOpGenericAdaptorBase(AsyncTMAScatterOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
AsyncTMAScatterOpAdaptor::AsyncTMAScatterOpAdaptor(AsyncTMAScatterOp op) : AsyncTMAScatterOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AsyncTMAScatterOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult AsyncTMAScatterOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute AsyncTMAScatterOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AsyncTMAScatterOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> AsyncTMAScatterOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void AsyncTMAScatterOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void AsyncTMAScatterOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult AsyncTMAScatterOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void AsyncTMAScatterOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value src) {
  odsState.addOperands(desc);
  odsState.addOperands(x_offsets);
  odsState.addOperands(y_offset);
  odsState.addOperands(src);
}

AsyncTMAScatterOp AsyncTMAScatterOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value src) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, desc, x_offsets, y_offset, src);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAScatterOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAScatterOp AsyncTMAScatterOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value src) {
  return create(builder, builder.getLoc(), desc, x_offsets, y_offset, src);
}

void AsyncTMAScatterOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value src) {
  odsState.addOperands(desc);
  odsState.addOperands(x_offsets);
  odsState.addOperands(y_offset);
  odsState.addOperands(src);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

AsyncTMAScatterOp AsyncTMAScatterOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value src) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, desc, x_offsets, y_offset, src);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAScatterOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAScatterOp AsyncTMAScatterOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value desc, ::mlir::Value x_offsets, ::mlir::Value y_offset, ::mlir::Value src) {
  return create(builder, builder.getLoc(), resultTypes, desc, x_offsets, y_offset, src);
}

void AsyncTMAScatterOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AsyncTMAScatterOp AsyncTMAScatterOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAScatterOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAScatterOp AsyncTMAScatterOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void AsyncTMAScatterOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

AsyncTMAScatterOp AsyncTMAScatterOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<AsyncTMAScatterOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AsyncTMAScatterOp AsyncTMAScatterOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult AsyncTMAScatterOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult AsyncTMAScatterOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult AsyncTMAScatterOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand descRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> descOperands(&descRawOperand, 1);  ::llvm::SMLoc descOperandsLoc;
  (void)descOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand x_offsetsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> x_offsetsOperands(&x_offsetsRawOperand, 1);  ::llvm::SMLoc x_offsetsOperandsLoc;
  (void)x_offsetsOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand y_offsetRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> y_offsetOperands(&y_offsetRawOperand, 1);  ::llvm::SMLoc y_offsetOperandsLoc;
  (void)y_offsetOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand srcRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> srcOperands(&srcRawOperand, 1);  ::llvm::SMLoc srcOperandsLoc;
  (void)srcOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> allOperandTypes;

  descOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(descRawOperand))
    return ::mlir::failure();
  if (parser.parseLSquare())
    return ::mlir::failure();

  x_offsetsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(x_offsetsRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  y_offsetOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(y_offsetRawOperand))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();

  srcOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(srcRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(allOperandTypes))
    return ::mlir::failure();
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(descOperands, x_offsetsOperands, y_offsetOperands, srcOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AsyncTMAScatterOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getDesc();
  _odsPrinter << "[";
  _odsPrinter << getXOffsets();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getYOffset();
  _odsPrinter << "]";
  _odsPrinter << ' ';
  _odsPrinter << getSrc();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperandTypes();
}

void AsyncTMAScatterOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::GlobalMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::GlobalMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(3);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::AsyncTMAScatterOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::BarrierExpectOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
BarrierExpectOpGenericAdaptorBase::BarrierExpectOpGenericAdaptorBase(BarrierExpectOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

uint32_t BarrierExpectOpGenericAdaptorBase::getSize() {
  auto attr = getSizeAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
BarrierExpectOpAdaptor::BarrierExpectOpAdaptor(BarrierExpectOp op) : BarrierExpectOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult BarrierExpectOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_size = getProperties().size; (void)tblgen_size;
  if (!tblgen_size) return emitError(loc, "'ttng.barrier_expect' op ""requires attribute 'size'");

  if (tblgen_size && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_size))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_size).getType().isSignlessInteger(32)))))
    return emitError(loc, "'ttng.barrier_expect' op ""attribute 'size' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

::llvm::LogicalResult BarrierExpectOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.size;
       auto attr = dict.get("size");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `size` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute BarrierExpectOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.size;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("size",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code BarrierExpectOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.size.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> BarrierExpectOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "size")
      return prop.size;
  return std::nullopt;
}

void BarrierExpectOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "size") {
       prop.size = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.size)>>(value);
       return;
    }
}

void BarrierExpectOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.size) attrs.append("size", prop.size);
}

::llvm::LogicalResult BarrierExpectOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getSizeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(attr, "size", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult BarrierExpectOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.size)))
    return ::mlir::failure();
  return ::mlir::success();
}

void BarrierExpectOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.size);
}

uint32_t BarrierExpectOp::getSize() {
  auto attr = getSizeAttr();
  return attr.getValue().getZExtValue();
}

void BarrierExpectOp::setSize(uint32_t attrValue) {
  getProperties().size = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void BarrierExpectOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value alloc, ::mlir::IntegerAttr size, ::mlir::Value pred) {
  odsState.addOperands(alloc);
  odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().size = size;
}

BarrierExpectOp BarrierExpectOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value alloc, ::mlir::IntegerAttr size, ::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, size, pred);
  auto __res__ = ::llvm::dyn_cast<BarrierExpectOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BarrierExpectOp BarrierExpectOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value alloc, ::mlir::IntegerAttr size, ::mlir::Value pred) {
  return create(builder, builder.getLoc(), alloc, size, pred);
}

void BarrierExpectOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::IntegerAttr size, ::mlir::Value pred) {
  odsState.addOperands(alloc);
  odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().size = size;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

BarrierExpectOp BarrierExpectOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::IntegerAttr size, ::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, alloc, size, pred);
  auto __res__ = ::llvm::dyn_cast<BarrierExpectOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BarrierExpectOp BarrierExpectOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::IntegerAttr size, ::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, alloc, size, pred);
}

void BarrierExpectOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value alloc, uint32_t size, ::mlir::Value pred) {
  odsState.addOperands(alloc);
  odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().size = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), size);
}

BarrierExpectOp BarrierExpectOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value alloc, uint32_t size, ::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, size, pred);
  auto __res__ = ::llvm::dyn_cast<BarrierExpectOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BarrierExpectOp BarrierExpectOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value alloc, uint32_t size, ::mlir::Value pred) {
  return create(builder, builder.getLoc(), alloc, size, pred);
}

void BarrierExpectOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, uint32_t size, ::mlir::Value pred) {
  odsState.addOperands(alloc);
  odsState.addOperands(pred);
  odsState.getOrAddProperties<Properties>().size = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), size);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

BarrierExpectOp BarrierExpectOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, uint32_t size, ::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, alloc, size, pred);
  auto __res__ = ::llvm::dyn_cast<BarrierExpectOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BarrierExpectOp BarrierExpectOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, uint32_t size, ::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, alloc, size, pred);
}

void BarrierExpectOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<BarrierExpectOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

BarrierExpectOp BarrierExpectOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<BarrierExpectOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BarrierExpectOp BarrierExpectOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void BarrierExpectOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

BarrierExpectOp BarrierExpectOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<BarrierExpectOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

BarrierExpectOp BarrierExpectOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult BarrierExpectOp::verifyInvariantsImpl() {
  auto tblgen_size = getProperties().size; (void)tblgen_size;
  if (!tblgen_size) return emitOpError("requires attribute 'size'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(*this, tblgen_size, "size")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult BarrierExpectOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult BarrierExpectOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand allocRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> allocOperands(&allocRawOperand, 1);  ::llvm::SMLoc allocOperandsLoc;
  (void)allocOperandsLoc;
  ::mlir::IntegerAttr sizeAttr;
  ::mlir::OpAsmParser::UnresolvedOperand predRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> predOperands(&predRawOperand, 1);  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type allocRawType{};
  ::llvm::ArrayRef<::mlir::Type> allocTypes(&allocRawType, 1);

  allocOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(allocRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(sizeAttr, parser.getBuilder().getIntegerType(32))) {
    return ::mlir::failure();
  }
  if (sizeAttr) result.getOrAddProperties<BarrierExpectOp::Properties>().size = sizeAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseComma())
    return ::mlir::failure();

  predOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(predRawOperand))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(allocRawType))
    return ::mlir::failure();
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(allocOperands, allocTypes, allocOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void BarrierExpectOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getAlloc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getSizeAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("size");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getPred();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getAlloc().getType();
}

void BarrierExpectOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::BarrierExpectOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::ClusterArriveOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ClusterArriveOpGenericAdaptorBase::ClusterArriveOpGenericAdaptorBase(ClusterArriveOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

bool ClusterArriveOpGenericAdaptorBase::getRelaxed() {
  auto attr = getRelaxedAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
ClusterArriveOpAdaptor::ClusterArriveOpAdaptor(ClusterArriveOp op) : ClusterArriveOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ClusterArriveOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_relaxed = getProperties().relaxed; (void)tblgen_relaxed;
  if (!tblgen_relaxed) return emitError(loc, "'ttng.cluster_arrive' op ""requires attribute 'relaxed'");

  if (tblgen_relaxed && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_relaxed))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_relaxed).getType().isSignlessInteger(1)))))
    return emitError(loc, "'ttng.cluster_arrive' op ""attribute 'relaxed' failed to satisfy constraint: 1-bit signless integer attribute");
  return ::mlir::success();
}

::llvm::LogicalResult ClusterArriveOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.relaxed;
       auto attr = dict.get("relaxed");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `relaxed` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ClusterArriveOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.relaxed;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("relaxed",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ClusterArriveOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.relaxed.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ClusterArriveOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "relaxed")
      return prop.relaxed;
  return std::nullopt;
}

void ClusterArriveOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "relaxed") {
       prop.relaxed = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.relaxed)>>(value);
       return;
    }
}

void ClusterArriveOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.relaxed) attrs.append("relaxed", prop.relaxed);
}

::llvm::LogicalResult ClusterArriveOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getRelaxedAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps7(attr, "relaxed", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ClusterArriveOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.relaxed)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ClusterArriveOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.relaxed);
}

bool ClusterArriveOp::getRelaxed() {
  auto attr = getRelaxedAttr();
  return attr.getValue().getZExtValue();
}

void ClusterArriveOp::setRelaxed(bool attrValue) {
  getProperties().relaxed = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue);
}

void ClusterArriveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr relaxed) {
  odsState.getOrAddProperties<Properties>().relaxed = relaxed;
}

ClusterArriveOp ClusterArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr relaxed) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, relaxed);
  auto __res__ = ::llvm::dyn_cast<ClusterArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ClusterArriveOp ClusterArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr relaxed) {
  return create(builder, builder.getLoc(), relaxed);
}

void ClusterArriveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr relaxed) {
  odsState.getOrAddProperties<Properties>().relaxed = relaxed;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ClusterArriveOp ClusterArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr relaxed) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, relaxed);
  auto __res__ = ::llvm::dyn_cast<ClusterArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ClusterArriveOp ClusterArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr relaxed) {
  return create(builder, builder.getLoc(), resultTypes, relaxed);
}

void ClusterArriveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, bool relaxed) {
  odsState.getOrAddProperties<Properties>().relaxed = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), relaxed);
}

ClusterArriveOp ClusterArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, bool relaxed) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, relaxed);
  auto __res__ = ::llvm::dyn_cast<ClusterArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ClusterArriveOp ClusterArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, bool relaxed) {
  return create(builder, builder.getLoc(), relaxed);
}

void ClusterArriveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, bool relaxed) {
  odsState.getOrAddProperties<Properties>().relaxed = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), relaxed);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ClusterArriveOp ClusterArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, bool relaxed) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, relaxed);
  auto __res__ = ::llvm::dyn_cast<ClusterArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ClusterArriveOp ClusterArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, bool relaxed) {
  return create(builder, builder.getLoc(), resultTypes, relaxed);
}

void ClusterArriveOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ClusterArriveOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ClusterArriveOp ClusterArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ClusterArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ClusterArriveOp ClusterArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ClusterArriveOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ClusterArriveOp ClusterArriveOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ClusterArriveOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ClusterArriveOp ClusterArriveOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ClusterArriveOp::verifyInvariantsImpl() {
  auto tblgen_relaxed = getProperties().relaxed; (void)tblgen_relaxed;
  if (!tblgen_relaxed) return emitOpError("requires attribute 'relaxed'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps7(*this, tblgen_relaxed, "relaxed")))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult ClusterArriveOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ClusterArriveOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void ClusterArriveOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::ClusterArriveOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::ClusterWaitOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ClusterWaitOpGenericAdaptorBase::ClusterWaitOpGenericAdaptorBase(ClusterWaitOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
ClusterWaitOpAdaptor::ClusterWaitOpAdaptor(ClusterWaitOp op) : ClusterWaitOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ClusterWaitOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult ClusterWaitOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute ClusterWaitOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ClusterWaitOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> ClusterWaitOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void ClusterWaitOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void ClusterWaitOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult ClusterWaitOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void ClusterWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState) {
}

ClusterWaitOp ClusterWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__);
  auto __res__ = ::llvm::dyn_cast<ClusterWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ClusterWaitOp ClusterWaitOp::create(::mlir::ImplicitLocOpBuilder &builder) {
  return create(builder, builder.getLoc());
}

void ClusterWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes) {
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ClusterWaitOp ClusterWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes);
  auto __res__ = ::llvm::dyn_cast<ClusterWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ClusterWaitOp ClusterWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes) {
  return create(builder, builder.getLoc(), resultTypes);
}

void ClusterWaitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ClusterWaitOp ClusterWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ClusterWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ClusterWaitOp ClusterWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ClusterWaitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ClusterWaitOp ClusterWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ClusterWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ClusterWaitOp ClusterWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ClusterWaitOp::verifyInvariantsImpl() {
  return ::mlir::success();
}

::llvm::LogicalResult ClusterWaitOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ClusterWaitOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void ClusterWaitOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::ClusterWaitOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::FenceAsyncSharedOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FenceAsyncSharedOpGenericAdaptorBase::FenceAsyncSharedOpGenericAdaptorBase(FenceAsyncSharedOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

bool FenceAsyncSharedOpGenericAdaptorBase::getBCluster() {
  auto attr = getBClusterAttr();
  return attr.getValue();
}

} // namespace detail
FenceAsyncSharedOpAdaptor::FenceAsyncSharedOpAdaptor(FenceAsyncSharedOp op) : FenceAsyncSharedOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult FenceAsyncSharedOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_bCluster = getProperties().bCluster; (void)tblgen_bCluster;
  if (!tblgen_bCluster) return emitError(loc, "'ttng.fence_async_shared' op ""requires attribute 'bCluster'");

  if (tblgen_bCluster && !((::llvm::isa<::mlir::BoolAttr>(tblgen_bCluster))))
    return emitError(loc, "'ttng.fence_async_shared' op ""attribute 'bCluster' failed to satisfy constraint: bool attribute");
  return ::mlir::success();
}

::llvm::LogicalResult FenceAsyncSharedOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.bCluster;
       auto attr = dict.get("bCluster");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `bCluster` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute FenceAsyncSharedOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.bCluster;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("bCluster",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FenceAsyncSharedOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.bCluster.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> FenceAsyncSharedOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "bCluster")
      return prop.bCluster;
  return std::nullopt;
}

void FenceAsyncSharedOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "bCluster") {
       prop.bCluster = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.bCluster)>>(value);
       return;
    }
}

void FenceAsyncSharedOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.bCluster) attrs.append("bCluster", prop.bCluster);
}

::llvm::LogicalResult FenceAsyncSharedOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getBClusterAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps5(attr, "bCluster", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult FenceAsyncSharedOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.bCluster)))
    return ::mlir::failure();
  return ::mlir::success();
}

void FenceAsyncSharedOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.bCluster);
}

bool FenceAsyncSharedOp::getBCluster() {
  auto attr = getBClusterAttr();
  return attr.getValue();
}

void FenceAsyncSharedOp::setBCluster(bool attrValue) {
  getProperties().bCluster = ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue);
}

void FenceAsyncSharedOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::BoolAttr bCluster) {
  odsState.getOrAddProperties<Properties>().bCluster = bCluster;
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::BoolAttr bCluster) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, bCluster);
  auto __res__ = ::llvm::dyn_cast<FenceAsyncSharedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::BoolAttr bCluster) {
  return create(builder, builder.getLoc(), bCluster);
}

void FenceAsyncSharedOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::BoolAttr bCluster) {
  odsState.getOrAddProperties<Properties>().bCluster = bCluster;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::BoolAttr bCluster) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, bCluster);
  auto __res__ = ::llvm::dyn_cast<FenceAsyncSharedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::BoolAttr bCluster) {
  return create(builder, builder.getLoc(), resultTypes, bCluster);
}

void FenceAsyncSharedOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, bool bCluster) {
  odsState.getOrAddProperties<Properties>().bCluster = odsBuilder.getBoolAttr(bCluster);
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, bool bCluster) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, bCluster);
  auto __res__ = ::llvm::dyn_cast<FenceAsyncSharedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::ImplicitLocOpBuilder &builder, bool bCluster) {
  return create(builder, builder.getLoc(), bCluster);
}

void FenceAsyncSharedOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, bool bCluster) {
  odsState.getOrAddProperties<Properties>().bCluster = odsBuilder.getBoolAttr(bCluster);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, bool bCluster) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, bCluster);
  auto __res__ = ::llvm::dyn_cast<FenceAsyncSharedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, bool bCluster) {
  return create(builder, builder.getLoc(), resultTypes, bCluster);
}

void FenceAsyncSharedOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<FenceAsyncSharedOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<FenceAsyncSharedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void FenceAsyncSharedOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<FenceAsyncSharedOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FenceAsyncSharedOp FenceAsyncSharedOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult FenceAsyncSharedOp::verifyInvariantsImpl() {
  auto tblgen_bCluster = getProperties().bCluster; (void)tblgen_bCluster;
  if (!tblgen_bCluster) return emitOpError("requires attribute 'bCluster'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps5(*this, tblgen_bCluster, "bCluster")))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult FenceAsyncSharedOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult FenceAsyncSharedOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void FenceAsyncSharedOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::FenceAsyncSharedOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::InitBarrierOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
InitBarrierOpGenericAdaptorBase::InitBarrierOpGenericAdaptorBase(InitBarrierOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

uint32_t InitBarrierOpGenericAdaptorBase::getCount() {
  auto attr = getCountAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
InitBarrierOpAdaptor::InitBarrierOpAdaptor(InitBarrierOp op) : InitBarrierOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult InitBarrierOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_count = getProperties().count; (void)tblgen_count;
  if (!tblgen_count) return emitError(loc, "'ttng.init_barrier' op ""requires attribute 'count'");

  if (tblgen_count && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_count))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_count).getType().isSignlessInteger(32)))))
    return emitError(loc, "'ttng.init_barrier' op ""attribute 'count' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

::llvm::LogicalResult InitBarrierOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.count;
       auto attr = dict.get("count");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `count` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute InitBarrierOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.count;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("count",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code InitBarrierOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.count.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> InitBarrierOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "count")
      return prop.count;
  return std::nullopt;
}

void InitBarrierOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "count") {
       prop.count = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.count)>>(value);
       return;
    }
}

void InitBarrierOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.count) attrs.append("count", prop.count);
}

::llvm::LogicalResult InitBarrierOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCountAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(attr, "count", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult InitBarrierOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.count)))
    return ::mlir::failure();
  return ::mlir::success();
}

void InitBarrierOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.count);
}

uint32_t InitBarrierOp::getCount() {
  auto attr = getCountAttr();
  return attr.getValue().getZExtValue();
}

void InitBarrierOp::setCount(uint32_t attrValue) {
  getProperties().count = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void InitBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value alloc, ::mlir::IntegerAttr count) {
  odsState.addOperands(alloc);
  odsState.getOrAddProperties<Properties>().count = count;
}

InitBarrierOp InitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value alloc, ::mlir::IntegerAttr count) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, count);
  auto __res__ = ::llvm::dyn_cast<InitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InitBarrierOp InitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value alloc, ::mlir::IntegerAttr count) {
  return create(builder, builder.getLoc(), alloc, count);
}

void InitBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::IntegerAttr count) {
  odsState.addOperands(alloc);
  odsState.getOrAddProperties<Properties>().count = count;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

InitBarrierOp InitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::IntegerAttr count) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, alloc, count);
  auto __res__ = ::llvm::dyn_cast<InitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InitBarrierOp InitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::IntegerAttr count) {
  return create(builder, builder.getLoc(), resultTypes, alloc, count);
}

void InitBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value alloc, uint32_t count) {
  odsState.addOperands(alloc);
  odsState.getOrAddProperties<Properties>().count = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), count);
}

InitBarrierOp InitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value alloc, uint32_t count) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, count);
  auto __res__ = ::llvm::dyn_cast<InitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InitBarrierOp InitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value alloc, uint32_t count) {
  return create(builder, builder.getLoc(), alloc, count);
}

void InitBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, uint32_t count) {
  odsState.addOperands(alloc);
  odsState.getOrAddProperties<Properties>().count = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), count);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

InitBarrierOp InitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, uint32_t count) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, alloc, count);
  auto __res__ = ::llvm::dyn_cast<InitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InitBarrierOp InitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, uint32_t count) {
  return create(builder, builder.getLoc(), resultTypes, alloc, count);
}

void InitBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<InitBarrierOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

InitBarrierOp InitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<InitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InitBarrierOp InitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void InitBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

InitBarrierOp InitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<InitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InitBarrierOp InitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult InitBarrierOp::verifyInvariantsImpl() {
  auto tblgen_count = getProperties().count; (void)tblgen_count;
  if (!tblgen_count) return emitOpError("requires attribute 'count'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(*this, tblgen_count, "count")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult InitBarrierOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult InitBarrierOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand allocRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> allocOperands(&allocRawOperand, 1);  ::llvm::SMLoc allocOperandsLoc;
  (void)allocOperandsLoc;
  ::mlir::IntegerAttr countAttr;
  ::mlir::Type allocRawType{};
  ::llvm::ArrayRef<::mlir::Type> allocTypes(&allocRawType, 1);

  allocOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(allocRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(countAttr, parser.getBuilder().getIntegerType(32))) {
    return ::mlir::failure();
  }
  if (countAttr) result.getOrAddProperties<InitBarrierOp::Properties>().count = countAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(allocRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(allocOperands, allocTypes, allocOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void InitBarrierOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getAlloc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getCountAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("count");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getAlloc().getType();
}

void InitBarrierOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::InitBarrierOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::InvalBarrierOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
InvalBarrierOpGenericAdaptorBase::InvalBarrierOpGenericAdaptorBase(InvalBarrierOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
InvalBarrierOpAdaptor::InvalBarrierOpAdaptor(InvalBarrierOp op) : InvalBarrierOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult InvalBarrierOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult InvalBarrierOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute InvalBarrierOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code InvalBarrierOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> InvalBarrierOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void InvalBarrierOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void InvalBarrierOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult InvalBarrierOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void InvalBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value alloc) {
  odsState.addOperands(alloc);
}

InvalBarrierOp InvalBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value alloc) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc);
  auto __res__ = ::llvm::dyn_cast<InvalBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InvalBarrierOp InvalBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value alloc) {
  return create(builder, builder.getLoc(), alloc);
}

void InvalBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value alloc) {
  odsState.addOperands(alloc);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

InvalBarrierOp InvalBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value alloc) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, alloc);
  auto __res__ = ::llvm::dyn_cast<InvalBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InvalBarrierOp InvalBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value alloc) {
  return create(builder, builder.getLoc(), resultTypes, alloc);
}

void InvalBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

InvalBarrierOp InvalBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<InvalBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InvalBarrierOp InvalBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void InvalBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

InvalBarrierOp InvalBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<InvalBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InvalBarrierOp InvalBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult InvalBarrierOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult InvalBarrierOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult InvalBarrierOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand allocRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> allocOperands(&allocRawOperand, 1);  ::llvm::SMLoc allocOperandsLoc;
  (void)allocOperandsLoc;
  ::mlir::Type allocRawType{};
  ::llvm::ArrayRef<::mlir::Type> allocTypes(&allocRawType, 1);

  allocOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(allocRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(allocRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(allocOperands, allocTypes, allocOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void InvalBarrierOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getAlloc();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getAlloc().getType();
}

void InvalBarrierOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::InvalBarrierOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::ReinterpretTensorDescOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ReinterpretTensorDescOpGenericAdaptorBase::ReinterpretTensorDescOpGenericAdaptorBase(ReinterpretTensorDescOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
ReinterpretTensorDescOpAdaptor::ReinterpretTensorDescOpAdaptor(ReinterpretTensorDescOp op) : ReinterpretTensorDescOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ReinterpretTensorDescOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult ReinterpretTensorDescOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute ReinterpretTensorDescOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ReinterpretTensorDescOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> ReinterpretTensorDescOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void ReinterpretTensorDescOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void ReinterpretTensorDescOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult ReinterpretTensorDescOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void ReinterpretTensorDescOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value rawDesc) {
  odsState.addOperands(rawDesc);
  odsState.addTypes(result);
}

ReinterpretTensorDescOp ReinterpretTensorDescOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value rawDesc) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, rawDesc);
  auto __res__ = ::llvm::dyn_cast<ReinterpretTensorDescOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReinterpretTensorDescOp ReinterpretTensorDescOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value rawDesc) {
  return create(builder, builder.getLoc(), result, rawDesc);
}

void ReinterpretTensorDescOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value rawDesc) {
  odsState.addOperands(rawDesc);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ReinterpretTensorDescOp ReinterpretTensorDescOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value rawDesc) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, rawDesc);
  auto __res__ = ::llvm::dyn_cast<ReinterpretTensorDescOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReinterpretTensorDescOp ReinterpretTensorDescOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value rawDesc) {
  return create(builder, builder.getLoc(), resultTypes, rawDesc);
}

void ReinterpretTensorDescOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ReinterpretTensorDescOp ReinterpretTensorDescOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ReinterpretTensorDescOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReinterpretTensorDescOp ReinterpretTensorDescOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ReinterpretTensorDescOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ReinterpretTensorDescOp ReinterpretTensorDescOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ReinterpretTensorDescOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReinterpretTensorDescOp ReinterpretTensorDescOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ReinterpretTensorDescOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ReinterpretTensorDescOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ReinterpretTensorDescOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand rawDescRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> rawDescOperands(&rawDescRawOperand, 1);  ::llvm::SMLoc rawDescOperandsLoc;
  (void)rawDescOperandsLoc;
  ::mlir::Type rawDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> rawDescTypes(&rawDescRawType, 1);
  ::mlir::Type resultRawType{};
  ::llvm::ArrayRef<::mlir::Type> resultTypes(&resultRawType, 1);

  rawDescOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(rawDescRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(rawDescRawType))
    return ::mlir::failure();
  if (parser.parseKeyword("to"))
    return ::mlir::failure();

  if (parser.parseType(resultRawType))
    return ::mlir::failure();
  result.addTypes(resultTypes);
  if (parser.resolveOperands(rawDescOperands, rawDescTypes, rawDescOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ReinterpretTensorDescOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getRawDesc();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getRawDesc().getType();
  _odsPrinter << ' ' << "to";
  _odsPrinter << ' ';
   _odsPrinter << getResult().getType();
}

void ReinterpretTensorDescOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::ReinterpretTensorDescOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TCGen5CommitOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TCGen5CommitOpGenericAdaptorBase::TCGen5CommitOpGenericAdaptorBase(TCGen5CommitOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> TCGen5CommitOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::UnitAttr TCGen5CommitOpGenericAdaptorBase::getTwoCtasAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().two_ctas);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool TCGen5CommitOpGenericAdaptorBase::getTwoCtas() {
  auto attr = getTwoCtasAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

} // namespace detail
TCGen5CommitOpAdaptor::TCGen5CommitOpAdaptor(TCGen5CommitOp op) : TCGen5CommitOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TCGen5CommitOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_two_ctas = getProperties().two_ctas; (void)tblgen_two_ctas;

  if (tblgen_two_ctas && !((::llvm::isa<::mlir::UnitAttr>(tblgen_two_ctas))))
    return emitError(loc, "'ttng.tc_gen5_commit' op ""attribute 'two_ctas' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> TCGen5CommitOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange TCGen5CommitOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult TCGen5CommitOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.two_ctas;
       auto attr = dict.get("two_ctas");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `two_ctas` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute TCGen5CommitOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.two_ctas;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("two_ctas",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TCGen5CommitOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.two_ctas.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> TCGen5CommitOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "two_ctas")
      return prop.two_ctas;
  return std::nullopt;
}

void TCGen5CommitOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "two_ctas") {
       prop.two_ctas = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.two_ctas)>>(value);
       return;
    }
}

void TCGen5CommitOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.two_ctas) attrs.append("two_ctas", prop.two_ctas);
}

::llvm::LogicalResult TCGen5CommitOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getTwoCtasAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(attr, "two_ctas", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult TCGen5CommitOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.two_ctas)))
    return ::mlir::failure();
  return ::mlir::success();
}

void TCGen5CommitOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.two_ctas);
}

bool TCGen5CommitOp::getTwoCtas() {
  auto attr = getTwoCtasAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

void TCGen5CommitOp::setTwoCtas(bool attrValue) {
    auto &odsProp = getProperties().two_ctas;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

void TCGen5CommitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value barrier, bool two_ctas) {
      build(odsBuilder, odsState, barrier, /*pred=*/Value(), two_ctas);
    
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value barrier, bool two_ctas) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, barrier, two_ctas);
  auto __res__ = ::llvm::dyn_cast<TCGen5CommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::ImplicitLocOpBuilder &builder, Value barrier, bool two_ctas) {
  return create(builder, builder.getLoc(), barrier, two_ctas);
}

void TCGen5CommitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/::mlir::UnitAttr two_ctas) {
  odsState.addOperands(barrier);
  if (pred)
    odsState.addOperands(pred);
  if (two_ctas) {
    odsState.getOrAddProperties<Properties>().two_ctas = two_ctas;
  }
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/::mlir::UnitAttr two_ctas) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, barrier, pred, two_ctas);
  auto __res__ = ::llvm::dyn_cast<TCGen5CommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/::mlir::UnitAttr two_ctas) {
  return create(builder, builder.getLoc(), barrier, pred, two_ctas);
}

void TCGen5CommitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/::mlir::UnitAttr two_ctas) {
  odsState.addOperands(barrier);
  if (pred)
    odsState.addOperands(pred);
  if (two_ctas) {
    odsState.getOrAddProperties<Properties>().two_ctas = two_ctas;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/::mlir::UnitAttr two_ctas) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, barrier, pred, two_ctas);
  auto __res__ = ::llvm::dyn_cast<TCGen5CommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/::mlir::UnitAttr two_ctas) {
  return create(builder, builder.getLoc(), resultTypes, barrier, pred, two_ctas);
}

void TCGen5CommitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/bool two_ctas) {
  odsState.addOperands(barrier);
  if (pred)
    odsState.addOperands(pred);
  if (two_ctas) {
    odsState.getOrAddProperties<Properties>().two_ctas = ((two_ctas) ? odsBuilder.getUnitAttr() : nullptr);
  }
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/bool two_ctas) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, barrier, pred, two_ctas);
  auto __res__ = ::llvm::dyn_cast<TCGen5CommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/bool two_ctas) {
  return create(builder, builder.getLoc(), barrier, pred, two_ctas);
}

void TCGen5CommitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/bool two_ctas) {
  odsState.addOperands(barrier);
  if (pred)
    odsState.addOperands(pred);
  if (two_ctas) {
    odsState.getOrAddProperties<Properties>().two_ctas = ((two_ctas) ? odsBuilder.getUnitAttr() : nullptr);
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/bool two_ctas) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, barrier, pred, two_ctas);
  auto __res__ = ::llvm::dyn_cast<TCGen5CommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value barrier, /*optional*/::mlir::Value pred, /*optional*/bool two_ctas) {
  return create(builder, builder.getLoc(), resultTypes, barrier, pred, two_ctas);
}

void TCGen5CommitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<TCGen5CommitOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TCGen5CommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TCGen5CommitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TCGen5CommitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5CommitOp TCGen5CommitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TCGen5CommitOp::verifyInvariantsImpl() {
  auto tblgen_two_ctas = getProperties().two_ctas; (void)tblgen_two_ctas;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(*this, tblgen_two_ctas, "two_ctas")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult TCGen5CommitOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult TCGen5CommitOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand barrierRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> barrierOperands(&barrierRawOperand, 1);  ::llvm::SMLoc barrierOperandsLoc;
  (void)barrierOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type barrierRawType{};
  ::llvm::ArrayRef<::mlir::Type> barrierTypes(&barrierRawType, 1);

  barrierOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(barrierRawOperand))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(barrierRawType))
    return ::mlir::failure();
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(barrierOperands, barrierTypes, barrierOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType0, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void TCGen5CommitOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBarrier();
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getTwoCtasAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("two_ctas");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getBarrier().getType();
}

void TCGen5CommitOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TCGen5CommitOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TCGen5MMAOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TCGen5MMAOpGenericAdaptorBase::TCGen5MMAOpGenericAdaptorBase(TCGen5MMAOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> TCGen5MMAOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::UnitAttr TCGen5MMAOpGenericAdaptorBase::getIsAsyncAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().is_async);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool TCGen5MMAOpGenericAdaptorBase::getIsAsync() {
  auto attr = getIsAsyncAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr TCGen5MMAOpGenericAdaptorBase::getTwoCtasAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().two_ctas);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool TCGen5MMAOpGenericAdaptorBase::getTwoCtas() {
  auto attr = getTwoCtasAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

} // namespace detail
TCGen5MMAOpAdaptor::TCGen5MMAOpAdaptor(TCGen5MMAOp op) : TCGen5MMAOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TCGen5MMAOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_is_async = getProperties().is_async; (void)tblgen_is_async;
  auto tblgen_two_ctas = getProperties().two_ctas; (void)tblgen_two_ctas;

  if (tblgen_is_async && !((::llvm::isa<::mlir::UnitAttr>(tblgen_is_async))))
    return emitError(loc, "'ttng.tc_gen5_mma' op ""attribute 'is_async' failed to satisfy constraint: unit attribute");

  if (tblgen_two_ctas && !((::llvm::isa<::mlir::UnitAttr>(tblgen_two_ctas))))
    return emitError(loc, "'ttng.tc_gen5_mma' op ""attribute 'two_ctas' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> TCGen5MMAOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange TCGen5MMAOp::getAccDepMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange TCGen5MMAOp::getBarriersMutable() {
  auto range = getODSOperandIndexAndLength(6);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(6u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange TCGen5MMAOp::getBarrierPredsMutable() {
  auto range = getODSOperandIndexAndLength(7);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(7u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> TCGen5MMAOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::llvm::LogicalResult TCGen5MMAOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.is_async;
       auto attr = dict.get("is_async");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `is_async` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.two_ctas;
       auto attr = dict.get("two_ctas");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `two_ctas` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute TCGen5MMAOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.is_async;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("is_async",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.two_ctas;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("two_ctas",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TCGen5MMAOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.is_async.getAsOpaquePointer()), 
    llvm::hash_value(prop.two_ctas.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> TCGen5MMAOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "is_async")
      return prop.is_async;

    if (name == "two_ctas")
      return prop.two_ctas;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void TCGen5MMAOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "is_async") {
       prop.is_async = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.is_async)>>(value);
       return;
    }

    if (name == "two_ctas") {
       prop.two_ctas = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.two_ctas)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void TCGen5MMAOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.is_async) attrs.append("is_async", prop.is_async);

    if (prop.two_ctas) attrs.append("two_ctas", prop.two_ctas);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult TCGen5MMAOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getIsAsyncAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(attr, "is_async", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTwoCtasAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(attr, "two_ctas", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult TCGen5MMAOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.is_async)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  if (::mlir::failed(reader.readOptionalAttribute(prop.two_ctas)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void TCGen5MMAOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.is_async);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  writer.writeOptionalAttribute(prop.two_ctas);

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

bool TCGen5MMAOp::getIsAsync() {
  auto attr = getIsAsyncAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

bool TCGen5MMAOp::getTwoCtas() {
  auto attr = getTwoCtasAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

void TCGen5MMAOp::setIsAsync(bool attrValue) {
    auto &odsProp = getProperties().is_async;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

void TCGen5MMAOp::setTwoCtas(bool attrValue) {
    auto &odsProp = getProperties().two_ctas;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Type token, Value a, Value b, Value d, Value acc_dep, Value useD, Value pred, bool two_ctas, ValueRange barriers, ValueRange barrier_preds, bool is_async) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, token, a, b, d, acc_dep, useD, pred, two_ctas, barriers, barrier_preds, is_async);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, Type token, Value a, Value b, Value d, Value acc_dep, Value useD, Value pred, bool two_ctas, ValueRange barriers, ValueRange barrier_preds, bool is_async) {
  return create(builder, builder.getLoc(), token, a, b, d, acc_dep, useD, pred, two_ctas, barriers, barrier_preds, is_async);
}

void TCGen5MMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async, /*optional*/::mlir::UnitAttr two_ctas) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(d);
  if (acc_dep)
    odsState.addOperands(acc_dep);
  odsState.addOperands(useD);
  odsState.addOperands(pred);
  odsState.addOperands(barriers);
  odsState.addOperands(barrier_preds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, (acc_dep ? 1 : 0), 1, 1, static_cast<int32_t>(barriers.size()), static_cast<int32_t>(barrier_preds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (is_async) {
    odsState.getOrAddProperties<Properties>().is_async = is_async;
  }
  if (two_ctas) {
    odsState.getOrAddProperties<Properties>().two_ctas = two_ctas;
  }
  if (token)
    odsState.addTypes(token);
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async, /*optional*/::mlir::UnitAttr two_ctas) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, token, a, b, d, acc_dep, useD, pred, barriers, barrier_preds, is_async, two_ctas);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async, /*optional*/::mlir::UnitAttr two_ctas) {
  return create(builder, builder.getLoc(), token, a, b, d, acc_dep, useD, pred, barriers, barrier_preds, is_async, two_ctas);
}

void TCGen5MMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async, /*optional*/::mlir::UnitAttr two_ctas) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(d);
  if (acc_dep)
    odsState.addOperands(acc_dep);
  odsState.addOperands(useD);
  odsState.addOperands(pred);
  odsState.addOperands(barriers);
  odsState.addOperands(barrier_preds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, (acc_dep ? 1 : 0), 1, 1, static_cast<int32_t>(barriers.size()), static_cast<int32_t>(barrier_preds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (is_async) {
    odsState.getOrAddProperties<Properties>().is_async = is_async;
  }
  if (two_ctas) {
    odsState.getOrAddProperties<Properties>().two_ctas = two_ctas;
  }
  odsState.addTypes(resultTypes);
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async, /*optional*/::mlir::UnitAttr two_ctas) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, a, b, d, acc_dep, useD, pred, barriers, barrier_preds, is_async, two_ctas);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async, /*optional*/::mlir::UnitAttr two_ctas) {
  return create(builder, builder.getLoc(), resultTypes, a, b, d, acc_dep, useD, pred, barriers, barrier_preds, is_async, two_ctas);
}

void TCGen5MMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/bool is_async, /*optional*/bool two_ctas) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(d);
  if (acc_dep)
    odsState.addOperands(acc_dep);
  odsState.addOperands(useD);
  odsState.addOperands(pred);
  odsState.addOperands(barriers);
  odsState.addOperands(barrier_preds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, (acc_dep ? 1 : 0), 1, 1, static_cast<int32_t>(barriers.size()), static_cast<int32_t>(barrier_preds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (is_async) {
    odsState.getOrAddProperties<Properties>().is_async = ((is_async) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (two_ctas) {
    odsState.getOrAddProperties<Properties>().two_ctas = ((two_ctas) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (token)
    odsState.addTypes(token);
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/bool is_async, /*optional*/bool two_ctas) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, token, a, b, d, acc_dep, useD, pred, barriers, barrier_preds, is_async, two_ctas);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/bool is_async, /*optional*/bool two_ctas) {
  return create(builder, builder.getLoc(), token, a, b, d, acc_dep, useD, pred, barriers, barrier_preds, is_async, two_ctas);
}

void TCGen5MMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/bool is_async, /*optional*/bool two_ctas) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(d);
  if (acc_dep)
    odsState.addOperands(acc_dep);
  odsState.addOperands(useD);
  odsState.addOperands(pred);
  odsState.addOperands(barriers);
  odsState.addOperands(barrier_preds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, (acc_dep ? 1 : 0), 1, 1, static_cast<int32_t>(barriers.size()), static_cast<int32_t>(barrier_preds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (is_async) {
    odsState.getOrAddProperties<Properties>().is_async = ((is_async) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (two_ctas) {
    odsState.getOrAddProperties<Properties>().two_ctas = ((two_ctas) ? odsBuilder.getUnitAttr() : nullptr);
  }
  odsState.addTypes(resultTypes);
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/bool is_async, /*optional*/bool two_ctas) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, a, b, d, acc_dep, useD, pred, barriers, barrier_preds, is_async, two_ctas);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/bool is_async, /*optional*/bool two_ctas) {
  return create(builder, builder.getLoc(), resultTypes, a, b, d, acc_dep, useD, pred, barriers, barrier_preds, is_async, two_ctas);
}

void TCGen5MMAOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 5u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<TCGen5MMAOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TCGen5MMAOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 5u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  odsState.addTypes(resultTypes);
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAOp TCGen5MMAOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TCGen5MMAOp::verifyInvariantsImpl() {
  auto tblgen_is_async = getProperties().is_async; (void)tblgen_is_async;
  auto tblgen_two_ctas = getProperties().two_ctas; (void)tblgen_two_ctas;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(*this, tblgen_is_async, "is_async")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(*this, tblgen_two_ctas, "two_ctas")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps9(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup7 = getODSOperands(7);

    for (auto v : valueGroup7) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps10(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("result group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps8(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult TCGen5MMAOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult TCGen5MMAOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand aRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> aOperands(&aRawOperand, 1);  ::llvm::SMLoc aOperandsLoc;
  (void)aOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand bRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bOperands(&bRawOperand, 1);  ::llvm::SMLoc bOperandsLoc;
  (void)bOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand dRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> dOperands(&dRawOperand, 1);  ::llvm::SMLoc dOperandsLoc;
  (void)dOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> acc_depOperands;
  ::llvm::SMLoc acc_depOperandsLoc;
  (void)acc_depOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> tokenTypes;
  ::mlir::OpAsmParser::UnresolvedOperand useDRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> useDOperands(&useDRawOperand, 1);  ::llvm::SMLoc useDOperandsLoc;
  (void)useDOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand predRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> predOperands(&predRawOperand, 1);  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> barriersOperands;
  ::llvm::SMLoc barriersOperandsLoc;
  (void)barriersOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> barrier_predsOperands;
  ::llvm::SMLoc barrier_predsOperandsLoc;
  (void)barrier_predsOperandsLoc;
  ::mlir::Type aRawType{};
  ::llvm::ArrayRef<::mlir::Type> aTypes(&aRawType, 1);
  ::mlir::Type bRawType{};
  ::llvm::ArrayRef<::mlir::Type> bTypes(&bRawType, 1);
  ::mlir::Type dRawType{};
  ::llvm::ArrayRef<::mlir::Type> dTypes(&dRawType, 1);
  ::llvm::SmallVector<::mlir::Type, 1> barriersTypes;

  aOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(aRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  bOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  dOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(dRawOperand))
    return ::mlir::failure();
  {
    acc_depOperandsLoc = parser.getCurrentLocation();
    ::std::optional<::mlir::OpAsmParser::UnresolvedOperand> acc_depOperand;
    ::mlir::Type tokenType;
    auto odsResult = parseToken(parser, acc_depOperand, tokenType);
    if (odsResult) return ::mlir::failure();
    if (acc_depOperand.has_value())
      acc_depOperands.push_back(*acc_depOperand);
    if (tokenType)
      tokenTypes.push_back(tokenType);
  }
  if (parser.parseComma())
    return ::mlir::failure();

  useDOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(useDRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  predOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(predRawOperand))
    return ::mlir::failure();
  {
    barriersOperandsLoc = parser.getCurrentLocation();
    barrier_predsOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseBarriersAndPreds(parser, barriersOperands, barrier_predsOperands);
    if (odsResult) return ::mlir::failure();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(aRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(bRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(dRawType))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  if (parser.parseTypeList(barriersTypes))
    return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, static_cast<int32_t>(acc_depOperands.size()), 1, 1, static_cast<int32_t>(barriersOperands.size()), static_cast<int32_t>(barrier_predsOperands.size())}), result.getOrAddProperties<TCGen5MMAOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::triton::gpu::AsyncTokenType>();
  ::mlir::Type odsBuildableType1 = parser.getBuilder().getIntegerType(1);
  result.addTypes(tokenTypes);
  if (parser.resolveOperands(aOperands, aTypes, aOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(bOperands, bTypes, bOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dOperands, dTypes, dOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(acc_depOperands, odsBuildableType0, acc_depOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(useDOperands, odsBuildableType1, useDOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType1, predOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(barriersOperands, barriersTypes, barriersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(barrier_predsOperands, odsBuildableType1, barrier_predsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void TCGen5MMAOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getA();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getB();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getD();
  printToken(_odsPrinter, *this, getAccDep(), (getToken() ? getToken().getType() : ::mlir::Type()));
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getUseD();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getPred();
  printBarriersAndPreds(_odsPrinter, *this, getBarriers(), getBarrierPreds());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getIsAsyncAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("is_async");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getTwoCtasAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("two_ctas");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getA().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getB().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getD().getType();
  if (!getBarriers().empty()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    _odsPrinter << getBarriers().getTypes();
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TCGen5MMAOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TCGen5MMAScaledOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TCGen5MMAScaledOpGenericAdaptorBase::TCGen5MMAScaledOpGenericAdaptorBase(TCGen5MMAScaledOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> TCGen5MMAScaledOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::triton::ScaleDotElemType TCGen5MMAScaledOpGenericAdaptorBase::getAType() {
  auto attr = getATypeAttr();
  return attr.getValue();
}

::mlir::triton::ScaleDotElemType TCGen5MMAScaledOpGenericAdaptorBase::getBType() {
  auto attr = getBTypeAttr();
  return attr.getValue();
}

::mlir::UnitAttr TCGen5MMAScaledOpGenericAdaptorBase::getIsAsyncAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().is_async);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool TCGen5MMAScaledOpGenericAdaptorBase::getIsAsync() {
  auto attr = getIsAsyncAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

} // namespace detail
TCGen5MMAScaledOpAdaptor::TCGen5MMAScaledOpAdaptor(TCGen5MMAScaledOp op) : TCGen5MMAScaledOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TCGen5MMAScaledOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_a_type = getProperties().a_type; (void)tblgen_a_type;
  if (!tblgen_a_type) return emitError(loc, "'ttng.tc_gen5_mma_scaled' op ""requires attribute 'a_type'");
  auto tblgen_b_type = getProperties().b_type; (void)tblgen_b_type;
  if (!tblgen_b_type) return emitError(loc, "'ttng.tc_gen5_mma_scaled' op ""requires attribute 'b_type'");
  auto tblgen_is_async = getProperties().is_async; (void)tblgen_is_async;

  if (tblgen_a_type && !((::llvm::isa<::mlir::triton::ScaleDotElemTypeAttr>(tblgen_a_type))))
    return emitError(loc, "'ttng.tc_gen5_mma_scaled' op ""attribute 'a_type' failed to satisfy constraint: allowed 32-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6");

  if (tblgen_b_type && !((::llvm::isa<::mlir::triton::ScaleDotElemTypeAttr>(tblgen_b_type))))
    return emitError(loc, "'ttng.tc_gen5_mma_scaled' op ""attribute 'b_type' failed to satisfy constraint: allowed 32-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6");

  if (tblgen_is_async && !((::llvm::isa<::mlir::UnitAttr>(tblgen_is_async))))
    return emitError(loc, "'ttng.tc_gen5_mma_scaled' op ""attribute 'is_async' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> TCGen5MMAScaledOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange TCGen5MMAScaledOp::getAccDepMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange TCGen5MMAScaledOp::getBarriersMutable() {
  auto range = getODSOperandIndexAndLength(8);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(8u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange TCGen5MMAScaledOp::getBarrierPredsMutable() {
  auto range = getODSOperandIndexAndLength(9);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(9u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> TCGen5MMAScaledOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::llvm::LogicalResult TCGen5MMAScaledOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.a_type;
       auto attr = dict.get("a_type");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `a_type` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.b_type;
       auto attr = dict.get("b_type");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `b_type` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.is_async;
       auto attr = dict.get("is_async");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `is_async` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute TCGen5MMAScaledOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.a_type;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("a_type",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.b_type;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("b_type",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.is_async;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("is_async",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TCGen5MMAScaledOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.a_type.getAsOpaquePointer()), 
    llvm::hash_value(prop.b_type.getAsOpaquePointer()), 
    llvm::hash_value(prop.is_async.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> TCGen5MMAScaledOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "a_type")
      return prop.a_type;

    if (name == "b_type")
      return prop.b_type;

    if (name == "is_async")
      return prop.is_async;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void TCGen5MMAScaledOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "a_type") {
       prop.a_type = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.a_type)>>(value);
       return;
    }

    if (name == "b_type") {
       prop.b_type = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.b_type)>>(value);
       return;
    }

    if (name == "is_async") {
       prop.is_async = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.is_async)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void TCGen5MMAScaledOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.a_type) attrs.append("a_type", prop.a_type);

    if (prop.b_type) attrs.append("b_type", prop.b_type);

    if (prop.is_async) attrs.append("is_async", prop.is_async);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult TCGen5MMAScaledOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getATypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps8(attr, "a_type", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getBTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps8(attr, "b_type", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getIsAsyncAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(attr, "is_async", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult TCGen5MMAScaledOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.a_type)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.b_type)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.is_async)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void TCGen5MMAScaledOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.a_type);
  writer.writeAttribute(prop.b_type);

  writer.writeOptionalAttribute(prop.is_async);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::triton::ScaleDotElemType TCGen5MMAScaledOp::getAType() {
  auto attr = getATypeAttr();
  return attr.getValue();
}

::mlir::triton::ScaleDotElemType TCGen5MMAScaledOp::getBType() {
  auto attr = getBTypeAttr();
  return attr.getValue();
}

bool TCGen5MMAScaledOp::getIsAsync() {
  auto attr = getIsAsyncAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

void TCGen5MMAScaledOp::setAType(::mlir::triton::ScaleDotElemType attrValue) {
  getProperties().a_type = ::mlir::triton::ScaleDotElemTypeAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void TCGen5MMAScaledOp::setBType(::mlir::triton::ScaleDotElemType attrValue) {
  getProperties().b_type = ::mlir::triton::ScaleDotElemTypeAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void TCGen5MMAScaledOp::setIsAsync(bool attrValue) {
    auto &odsProp = getProperties().is_async;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, ::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemType a_type, ::mlir::triton::ScaleDotElemType b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, bool is_async) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, token, a, b, d, acc_dep, a_scale, b_scale, a_type, b_type, useD, pred, barriers, barrier_preds, is_async);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAScaledOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, ::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemType a_type, ::mlir::triton::ScaleDotElemType b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, bool is_async) {
  return create(builder, builder.getLoc(), token, a, b, d, acc_dep, a_scale, b_scale, a_type, b_type, useD, pred, barriers, barrier_preds, is_async);
}

void TCGen5MMAScaledOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemTypeAttr a_type, ::mlir::triton::ScaleDotElemTypeAttr b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(d);
  if (acc_dep)
    odsState.addOperands(acc_dep);
  odsState.addOperands(a_scale);
  odsState.addOperands(b_scale);
  odsState.addOperands(useD);
  odsState.addOperands(pred);
  odsState.addOperands(barriers);
  odsState.addOperands(barrier_preds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, (acc_dep ? 1 : 0), 1, 1, 1, 1, static_cast<int32_t>(barriers.size()), static_cast<int32_t>(barrier_preds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().a_type = a_type;
  odsState.getOrAddProperties<Properties>().b_type = b_type;
  if (is_async) {
    odsState.getOrAddProperties<Properties>().is_async = is_async;
  }
  if (token)
    odsState.addTypes(token);
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemTypeAttr a_type, ::mlir::triton::ScaleDotElemTypeAttr b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, token, a, b, d, acc_dep, a_scale, b_scale, a_type, b_type, useD, pred, barriers, barrier_preds, is_async);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAScaledOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type token, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemTypeAttr a_type, ::mlir::triton::ScaleDotElemTypeAttr b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async) {
  return create(builder, builder.getLoc(), token, a, b, d, acc_dep, a_scale, b_scale, a_type, b_type, useD, pred, barriers, barrier_preds, is_async);
}

void TCGen5MMAScaledOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemTypeAttr a_type, ::mlir::triton::ScaleDotElemTypeAttr b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(d);
  if (acc_dep)
    odsState.addOperands(acc_dep);
  odsState.addOperands(a_scale);
  odsState.addOperands(b_scale);
  odsState.addOperands(useD);
  odsState.addOperands(pred);
  odsState.addOperands(barriers);
  odsState.addOperands(barrier_preds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, (acc_dep ? 1 : 0), 1, 1, 1, 1, static_cast<int32_t>(barriers.size()), static_cast<int32_t>(barrier_preds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().a_type = a_type;
  odsState.getOrAddProperties<Properties>().b_type = b_type;
  if (is_async) {
    odsState.getOrAddProperties<Properties>().is_async = is_async;
  }
  odsState.addTypes(resultTypes);
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemTypeAttr a_type, ::mlir::triton::ScaleDotElemTypeAttr b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, a, b, d, acc_dep, a_scale, b_scale, a_type, b_type, useD, pred, barriers, barrier_preds, is_async);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAScaledOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemTypeAttr a_type, ::mlir::triton::ScaleDotElemTypeAttr b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/::mlir::UnitAttr is_async) {
  return create(builder, builder.getLoc(), resultTypes, a, b, d, acc_dep, a_scale, b_scale, a_type, b_type, useD, pred, barriers, barrier_preds, is_async);
}

void TCGen5MMAScaledOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemType a_type, ::mlir::triton::ScaleDotElemType b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/bool is_async) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(d);
  if (acc_dep)
    odsState.addOperands(acc_dep);
  odsState.addOperands(a_scale);
  odsState.addOperands(b_scale);
  odsState.addOperands(useD);
  odsState.addOperands(pred);
  odsState.addOperands(barriers);
  odsState.addOperands(barrier_preds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, (acc_dep ? 1 : 0), 1, 1, 1, 1, static_cast<int32_t>(barriers.size()), static_cast<int32_t>(barrier_preds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().a_type = ::mlir::triton::ScaleDotElemTypeAttr::get(odsBuilder.getContext(), a_type);
  odsState.getOrAddProperties<Properties>().b_type = ::mlir::triton::ScaleDotElemTypeAttr::get(odsBuilder.getContext(), b_type);
  if (is_async) {
    odsState.getOrAddProperties<Properties>().is_async = ((is_async) ? odsBuilder.getUnitAttr() : nullptr);
  }
  odsState.addTypes(resultTypes);
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemType a_type, ::mlir::triton::ScaleDotElemType b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/bool is_async) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, a, b, d, acc_dep, a_scale, b_scale, a_type, b_type, useD, pred, barriers, barrier_preds, is_async);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAScaledOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value d, /*optional*/::mlir::Value acc_dep, ::mlir::Value a_scale, ::mlir::Value b_scale, ::mlir::triton::ScaleDotElemType a_type, ::mlir::triton::ScaleDotElemType b_type, ::mlir::Value useD, ::mlir::Value pred, ::mlir::ValueRange barriers, ::mlir::ValueRange barrier_preds, /*optional*/bool is_async) {
  return create(builder, builder.getLoc(), resultTypes, a, b, d, acc_dep, a_scale, b_scale, a_type, b_type, useD, pred, barriers, barrier_preds, is_async);
}

void TCGen5MMAScaledOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 7u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<TCGen5MMAScaledOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAScaledOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TCGen5MMAScaledOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 7u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  odsState.addTypes(resultTypes);
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TCGen5MMAScaledOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TCGen5MMAScaledOp TCGen5MMAScaledOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TCGen5MMAScaledOp::verifyInvariantsImpl() {
  auto tblgen_a_type = getProperties().a_type; (void)tblgen_a_type;
  if (!tblgen_a_type) return emitOpError("requires attribute 'a_type'");
  auto tblgen_b_type = getProperties().b_type; (void)tblgen_b_type;
  if (!tblgen_b_type) return emitOpError("requires attribute 'b_type'");
  auto tblgen_is_async = getProperties().is_async; (void)tblgen_is_async;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps8(*this, tblgen_a_type, "a_type")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps8(*this, tblgen_b_type, "b_type")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps2(*this, tblgen_is_async, "is_async")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup7 = getODSOperands(7);

    for (auto v : valueGroup7) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup8 = getODSOperands(8);

    for (auto v : valueGroup8) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps9(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup9 = getODSOperands(9);

    for (auto v : valueGroup9) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps10(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("result group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps8(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult TCGen5MMAScaledOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult TCGen5MMAScaledOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand aRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> aOperands(&aRawOperand, 1);  ::llvm::SMLoc aOperandsLoc;
  (void)aOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand bRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bOperands(&bRawOperand, 1);  ::llvm::SMLoc bOperandsLoc;
  (void)bOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand dRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> dOperands(&dRawOperand, 1);  ::llvm::SMLoc dOperandsLoc;
  (void)dOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> acc_depOperands;
  ::llvm::SMLoc acc_depOperandsLoc;
  (void)acc_depOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> tokenTypes;
  ::mlir::OpAsmParser::UnresolvedOperand a_scaleRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> a_scaleOperands(&a_scaleRawOperand, 1);  ::llvm::SMLoc a_scaleOperandsLoc;
  (void)a_scaleOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand b_scaleRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> b_scaleOperands(&b_scaleRawOperand, 1);  ::llvm::SMLoc b_scaleOperandsLoc;
  (void)b_scaleOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand useDRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> useDOperands(&useDRawOperand, 1);  ::llvm::SMLoc useDOperandsLoc;
  (void)useDOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand predRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> predOperands(&predRawOperand, 1);  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::triton::ScaleDotElemTypeAttr a_typeAttr;
  ::mlir::triton::ScaleDotElemTypeAttr b_typeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> barriersOperands;
  ::llvm::SMLoc barriersOperandsLoc;
  (void)barriersOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> barrier_predsOperands;
  ::llvm::SMLoc barrier_predsOperandsLoc;
  (void)barrier_predsOperandsLoc;
  ::mlir::Type aRawType{};
  ::llvm::ArrayRef<::mlir::Type> aTypes(&aRawType, 1);
  ::mlir::Type bRawType{};
  ::llvm::ArrayRef<::mlir::Type> bTypes(&bRawType, 1);
  ::mlir::Type dRawType{};
  ::llvm::ArrayRef<::mlir::Type> dTypes(&dRawType, 1);
  ::mlir::Type a_scaleRawType{};
  ::llvm::ArrayRef<::mlir::Type> a_scaleTypes(&a_scaleRawType, 1);
  ::mlir::Type b_scaleRawType{};
  ::llvm::ArrayRef<::mlir::Type> b_scaleTypes(&b_scaleRawType, 1);
  ::llvm::SmallVector<::mlir::Type, 1> barriersTypes;

  aOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(aRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  bOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  dOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(dRawOperand))
    return ::mlir::failure();
  {
    acc_depOperandsLoc = parser.getCurrentLocation();
    ::std::optional<::mlir::OpAsmParser::UnresolvedOperand> acc_depOperand;
    ::mlir::Type tokenType;
    auto odsResult = parseToken(parser, acc_depOperand, tokenType);
    if (odsResult) return ::mlir::failure();
    if (acc_depOperand.has_value())
      acc_depOperands.push_back(*acc_depOperand);
    if (tokenType)
      tokenTypes.push_back(tokenType);
  }
  if (parser.parseComma())
    return ::mlir::failure();

  a_scaleOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(a_scaleRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  b_scaleOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(b_scaleRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  useDOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(useDRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  predOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(predRawOperand))
    return ::mlir::failure();
  if (parser.parseKeyword("lhs"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  {
    ::llvm::StringRef attrStr;
    ::mlir::NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseOptionalKeyword(&attrStr, {"e4m3","e5m2","e2m3","e3m2","e2m1","bf16","fp16"})) {
      ::mlir::StringAttr attrVal;
      ::mlir::OptionalParseResult parseResult =
        parser.parseOptionalAttribute(attrVal,
                                      parser.getBuilder().getNoneType(),
                                      "a_type", attrStorage);
      if (parseResult.has_value()) {
        if (failed(*parseResult))
          return ::mlir::failure();
        attrStr = attrVal.getValue();
      } else {
        return parser.emitError(loc, "expected string or keyword containing one of the following enum values for attribute 'a_type' [e4m3, e5m2, e2m3, e3m2, e2m1, bf16, fp16]");
      }
    }
    if (!attrStr.empty()) {
      auto attrOptional = ::mlir::triton::symbolizeScaleDotElemType(attrStr);
      if (!attrOptional)
        return parser.emitError(loc, "invalid ")
               << "a_type attribute specification: \"" << attrStr << '"';;

      a_typeAttr = ::mlir::triton::ScaleDotElemTypeAttr::get(parser.getBuilder().getContext(), *attrOptional);
        result.getOrAddProperties<TCGen5MMAScaledOp::Properties>().a_type = a_typeAttr;
    }
  }
  if (parser.parseKeyword("rhs"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  {
    ::llvm::StringRef attrStr;
    ::mlir::NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseOptionalKeyword(&attrStr, {"e4m3","e5m2","e2m3","e3m2","e2m1","bf16","fp16"})) {
      ::mlir::StringAttr attrVal;
      ::mlir::OptionalParseResult parseResult =
        parser.parseOptionalAttribute(attrVal,
                                      parser.getBuilder().getNoneType(),
                                      "b_type", attrStorage);
      if (parseResult.has_value()) {
        if (failed(*parseResult))
          return ::mlir::failure();
        attrStr = attrVal.getValue();
      } else {
        return parser.emitError(loc, "expected string or keyword containing one of the following enum values for attribute 'b_type' [e4m3, e5m2, e2m3, e3m2, e2m1, bf16, fp16]");
      }
    }
    if (!attrStr.empty()) {
      auto attrOptional = ::mlir::triton::symbolizeScaleDotElemType(attrStr);
      if (!attrOptional)
        return parser.emitError(loc, "invalid ")
               << "b_type attribute specification: \"" << attrStr << '"';;

      b_typeAttr = ::mlir::triton::ScaleDotElemTypeAttr::get(parser.getBuilder().getContext(), *attrOptional);
        result.getOrAddProperties<TCGen5MMAScaledOp::Properties>().b_type = b_typeAttr;
    }
  }
  {
    barriersOperandsLoc = parser.getCurrentLocation();
    barrier_predsOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseBarriersAndPreds(parser, barriersOperands, barrier_predsOperands);
    if (odsResult) return ::mlir::failure();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(aRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(bRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(dRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(a_scaleRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(b_scaleRawType))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  if (parser.parseTypeList(barriersTypes))
    return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, 1, static_cast<int32_t>(acc_depOperands.size()), 1, 1, 1, 1, static_cast<int32_t>(barriersOperands.size()), static_cast<int32_t>(barrier_predsOperands.size())}), result.getOrAddProperties<TCGen5MMAScaledOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::triton::gpu::AsyncTokenType>();
  ::mlir::Type odsBuildableType1 = parser.getBuilder().getIntegerType(1);
  result.addTypes(tokenTypes);
  if (parser.resolveOperands(aOperands, aTypes, aOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(bOperands, bTypes, bOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dOperands, dTypes, dOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(acc_depOperands, odsBuildableType0, acc_depOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(a_scaleOperands, a_scaleTypes, a_scaleOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(b_scaleOperands, b_scaleTypes, b_scaleOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(useDOperands, odsBuildableType1, useDOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType1, predOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(barriersOperands, barriersTypes, barriersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(barrier_predsOperands, odsBuildableType1, barrier_predsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void TCGen5MMAScaledOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getA();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getB();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getD();
  printToken(_odsPrinter, *this, getAccDep(), (getToken() ? getToken().getType() : ::mlir::Type()));
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getAScale();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getBScale();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getUseD();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getPred();
  _odsPrinter << ' ' << "lhs";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';

  {
    auto caseValue = getAType();
    auto caseValueStr = stringifyScaleDotElemType(caseValue);
    _odsPrinter << caseValueStr;
  }
  _odsPrinter << ' ' << "rhs";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';

  {
    auto caseValue = getBType();
    auto caseValueStr = stringifyScaleDotElemType(caseValue);
    _odsPrinter << caseValueStr;
  }
  printBarriersAndPreds(_odsPrinter, *this, getBarriers(), getBarrierPreds());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("a_type");
  elidedAttrs.push_back("b_type");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getIsAsyncAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("is_async");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getA().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getB().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getD().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getAScale().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getBScale().getType();
  if (!getBarriers().empty()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    _odsPrinter << getBarriers().getTypes();
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TCGen5MMAScaledOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TMAStoreWaitOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TMAStoreWaitOpGenericAdaptorBase::TMAStoreWaitOpGenericAdaptorBase(TMAStoreWaitOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

uint32_t TMAStoreWaitOpGenericAdaptorBase::getPendings() {
  auto attr = getPendingsAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
TMAStoreWaitOpAdaptor::TMAStoreWaitOpAdaptor(TMAStoreWaitOp op) : TMAStoreWaitOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TMAStoreWaitOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_pendings = getProperties().pendings; (void)tblgen_pendings;
  if (!tblgen_pendings) return emitError(loc, "'ttng.async_tma_store_wait' op ""requires attribute 'pendings'");

  if (tblgen_pendings && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_pendings))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_pendings).getType().isSignlessInteger(32)))))
    return emitError(loc, "'ttng.async_tma_store_wait' op ""attribute 'pendings' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

::llvm::LogicalResult TMAStoreWaitOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.pendings;
       auto attr = dict.get("pendings");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `pendings` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute TMAStoreWaitOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.pendings;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("pendings",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TMAStoreWaitOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.pendings.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> TMAStoreWaitOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "pendings")
      return prop.pendings;
  return std::nullopt;
}

void TMAStoreWaitOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "pendings") {
       prop.pendings = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.pendings)>>(value);
       return;
    }
}

void TMAStoreWaitOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.pendings) attrs.append("pendings", prop.pendings);
}

::llvm::LogicalResult TMAStoreWaitOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getPendingsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(attr, "pendings", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult TMAStoreWaitOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.pendings)))
    return ::mlir::failure();
  return ::mlir::success();
}

void TMAStoreWaitOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.pendings);
}

uint32_t TMAStoreWaitOp::getPendings() {
  auto attr = getPendingsAttr();
  return attr.getValue().getZExtValue();
}

void TMAStoreWaitOp::setPendings(uint32_t attrValue) {
  getProperties().pendings = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void TMAStoreWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr pendings) {
  odsState.getOrAddProperties<Properties>().pendings = pendings;
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr pendings) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, pendings);
  auto __res__ = ::llvm::dyn_cast<TMAStoreWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr pendings) {
  return create(builder, builder.getLoc(), pendings);
}

void TMAStoreWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr pendings) {
  odsState.getOrAddProperties<Properties>().pendings = pendings;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr pendings) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, pendings);
  auto __res__ = ::llvm::dyn_cast<TMAStoreWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr pendings) {
  return create(builder, builder.getLoc(), resultTypes, pendings);
}

void TMAStoreWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t pendings) {
  odsState.getOrAddProperties<Properties>().pendings = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), pendings);
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t pendings) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, pendings);
  auto __res__ = ::llvm::dyn_cast<TMAStoreWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, uint32_t pendings) {
  return create(builder, builder.getLoc(), pendings);
}

void TMAStoreWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t pendings) {
  odsState.getOrAddProperties<Properties>().pendings = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), pendings);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t pendings) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, pendings);
  auto __res__ = ::llvm::dyn_cast<TMAStoreWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t pendings) {
  return create(builder, builder.getLoc(), resultTypes, pendings);
}

void TMAStoreWaitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<TMAStoreWaitOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TMAStoreWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TMAStoreWaitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TMAStoreWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMAStoreWaitOp TMAStoreWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TMAStoreWaitOp::verifyInvariantsImpl() {
  auto tblgen_pendings = getProperties().pendings; (void)tblgen_pendings;
  if (!tblgen_pendings) return emitOpError("requires attribute 'pendings'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(*this, tblgen_pendings, "pendings")))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult TMAStoreWaitOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult TMAStoreWaitOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void TMAStoreWaitOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TMAStoreWaitOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TMEMAllocOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TMEMAllocOpGenericAdaptorBase::TMEMAllocOpGenericAdaptorBase(TMEMAllocOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> TMEMAllocOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

} // namespace detail
TMEMAllocOpAdaptor::TMEMAllocOpAdaptor(TMEMAllocOp op) : TMEMAllocOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TMEMAllocOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

void TMEMAllocOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "result");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "token");
}

std::pair<unsigned, unsigned> TMEMAllocOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange TMEMAllocOp::getSrcMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> TMEMAllocOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::llvm::LogicalResult TMEMAllocOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute TMEMAllocOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TMEMAllocOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> TMEMAllocOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void TMEMAllocOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void TMEMAllocOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult TMEMAllocOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void TMEMAllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, /*optional*/::mlir::Type token, /*optional*/::mlir::Value src) {
  if (src)
    odsState.addOperands(src);
  odsState.addTypes(result);
  if (token)
    odsState.addTypes(token);
}

TMEMAllocOp TMEMAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, /*optional*/::mlir::Type token, /*optional*/::mlir::Value src) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, token, src);
  auto __res__ = ::llvm::dyn_cast<TMEMAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMAllocOp TMEMAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, /*optional*/::mlir::Type token, /*optional*/::mlir::Value src) {
  return create(builder, builder.getLoc(), result, token, src);
}

void TMEMAllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value src) {
  if (src)
    odsState.addOperands(src);
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TMEMAllocOp TMEMAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value src) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, src);
  auto __res__ = ::llvm::dyn_cast<TMEMAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMAllocOp TMEMAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value src) {
  return create(builder, builder.getLoc(), resultTypes, src);
}

void TMEMAllocOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TMEMAllocOp TMEMAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TMEMAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMAllocOp TMEMAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TMEMAllocOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TMEMAllocOp TMEMAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TMEMAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMAllocOp TMEMAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TMEMAllocOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("result group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps8(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult TMEMAllocOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult TMEMAllocOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> srcOperands;
  ::llvm::SMLoc srcOperandsLoc;
  (void)srcOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  {
    srcOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      srcOperands.push_back(operand);
    }
  }
  if (!srcOperands.empty()) {
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(srcOperands, allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void TMEMAllocOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getSrc()) {
    _odsPrinter << ' ';
    if (::mlir::Value value = getSrc())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TMEMAllocOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TMEMCopyOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TMEMCopyOpGenericAdaptorBase::TMEMCopyOpGenericAdaptorBase(TMEMCopyOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> TMEMCopyOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

} // namespace detail
TMEMCopyOpAdaptor::TMEMCopyOpAdaptor(TMEMCopyOp op) : TMEMCopyOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TMEMCopyOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> TMEMCopyOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange TMEMCopyOp::getBarrierMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult TMEMCopyOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute TMEMCopyOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TMEMCopyOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> TMEMCopyOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void TMEMCopyOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void TMEMCopyOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult TMEMCopyOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void TMEMCopyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value barrier) {
  odsState.addOperands(src);
  odsState.addOperands(dst);
  if (barrier)
    odsState.addOperands(barrier);
}

TMEMCopyOp TMEMCopyOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value barrier) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, src, dst, barrier);
  auto __res__ = ::llvm::dyn_cast<TMEMCopyOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMCopyOp TMEMCopyOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value barrier) {
  return create(builder, builder.getLoc(), src, dst, barrier);
}

void TMEMCopyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value barrier) {
  odsState.addOperands(src);
  odsState.addOperands(dst);
  if (barrier)
    odsState.addOperands(barrier);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TMEMCopyOp TMEMCopyOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value barrier) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, src, dst, barrier);
  auto __res__ = ::llvm::dyn_cast<TMEMCopyOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMCopyOp TMEMCopyOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value dst, /*optional*/::mlir::Value barrier) {
  return create(builder, builder.getLoc(), resultTypes, src, dst, barrier);
}

void TMEMCopyOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TMEMCopyOp TMEMCopyOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TMEMCopyOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMCopyOp TMEMCopyOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TMEMCopyOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TMEMCopyOp TMEMCopyOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TMEMCopyOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMCopyOp TMEMCopyOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TMEMCopyOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult TMEMCopyOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult TMEMCopyOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand srcRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> srcOperands(&srcRawOperand, 1);  ::llvm::SMLoc srcOperandsLoc;
  (void)srcOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand dstRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> dstOperands(&dstRawOperand, 1);  ::llvm::SMLoc dstOperandsLoc;
  (void)dstOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> barrierOperands;
  ::llvm::SMLoc barrierOperandsLoc;
  (void)barrierOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> allOperandTypes;

  srcOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(srcRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  dstOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(dstRawOperand))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    barrierOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      barrierOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(allOperandTypes))
    return ::mlir::failure();
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(srcOperands, dstOperands, barrierOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void TMEMCopyOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSrc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getDst();
  if (getBarrier()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getBarrier())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperandTypes();
}

void TMEMCopyOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(1);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::nvidia_gpu::TensorMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TMEMCopyOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TMEMLoadOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TMEMLoadOpGenericAdaptorBase::TMEMLoadOpGenericAdaptorBase(TMEMLoadOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> TMEMLoadOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

} // namespace detail
TMEMLoadOpAdaptor::TMEMLoadOpAdaptor(TMEMLoadOp op) : TMEMLoadOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TMEMLoadOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

void TMEMLoadOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "result");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "token");
}

std::pair<unsigned, unsigned> TMEMLoadOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange TMEMLoadOp::getDepMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> TMEMLoadOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::llvm::LogicalResult TMEMLoadOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute TMEMLoadOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TMEMLoadOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> TMEMLoadOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void TMEMLoadOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void TMEMLoadOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult TMEMLoadOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void TMEMLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, /*optional*/::mlir::Type token, ::mlir::Value src, /*optional*/::mlir::Value dep) {
  odsState.addOperands(src);
  if (dep)
    odsState.addOperands(dep);
  odsState.addTypes(result);
  if (token)
    odsState.addTypes(token);
}

TMEMLoadOp TMEMLoadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, /*optional*/::mlir::Type token, ::mlir::Value src, /*optional*/::mlir::Value dep) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, token, src, dep);
  auto __res__ = ::llvm::dyn_cast<TMEMLoadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMLoadOp TMEMLoadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, /*optional*/::mlir::Type token, ::mlir::Value src, /*optional*/::mlir::Value dep) {
  return create(builder, builder.getLoc(), result, token, src, dep);
}

void TMEMLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, /*optional*/::mlir::Value dep) {
  odsState.addOperands(src);
  if (dep)
    odsState.addOperands(dep);
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TMEMLoadOp TMEMLoadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, /*optional*/::mlir::Value dep) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, src, dep);
  auto __res__ = ::llvm::dyn_cast<TMEMLoadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMLoadOp TMEMLoadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, /*optional*/::mlir::Value dep) {
  return create(builder, builder.getLoc(), resultTypes, src, dep);
}

void TMEMLoadOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TMEMLoadOp TMEMLoadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TMEMLoadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMLoadOp TMEMLoadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TMEMLoadOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TMEMLoadOp TMEMLoadOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TMEMLoadOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMLoadOp TMEMLoadOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TMEMLoadOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps11(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("result group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps8(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult TMEMLoadOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult TMEMLoadOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand srcRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> srcOperands(&srcRawOperand, 1);  ::llvm::SMLoc srcOperandsLoc;
  (void)srcOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> depOperands;
  ::llvm::SMLoc depOperandsLoc;
  (void)depOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> tokenTypes;
  ::mlir::Type srcRawType{};
  ::llvm::ArrayRef<::mlir::Type> srcTypes(&srcRawType, 1);
  ::mlir::Type resultRawType{};
  ::llvm::ArrayRef<::mlir::Type> resultTypes(&resultRawType, 1);

  srcOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(srcRawOperand))
    return ::mlir::failure();
  {
    depOperandsLoc = parser.getCurrentLocation();
    ::std::optional<::mlir::OpAsmParser::UnresolvedOperand> depOperand;
    ::mlir::Type tokenType;
    auto odsResult = parseToken(parser, depOperand, tokenType);
    if (odsResult) return ::mlir::failure();
    if (depOperand.has_value())
      depOperands.push_back(*depOperand);
    if (tokenType)
      tokenTypes.push_back(tokenType);
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(srcRawType))
    return ::mlir::failure();
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resultRawType = type;
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::triton::gpu::AsyncTokenType>();
  result.addTypes(resultTypes);
  result.addTypes(tokenTypes);
  if (parser.resolveOperands(srcOperands, srcTypes, srcOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(depOperands, odsBuildableType0, depOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void TMEMLoadOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSrc();
  printToken(_odsPrinter, *this, getDep(), (getToken() ? getToken().getType() : ::mlir::Type()));
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getSrc().getType();
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getResult().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void TMEMLoadOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::nvidia_gpu::TensorMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TMEMLoadOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TMEMStoreOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TMEMStoreOpGenericAdaptorBase::TMEMStoreOpGenericAdaptorBase(TMEMStoreOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> TMEMStoreOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true, false, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

} // namespace detail
TMEMStoreOpAdaptor::TMEMStoreOpAdaptor(TMEMStoreOp op) : TMEMStoreOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TMEMStoreOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> TMEMStoreOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true, false, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange TMEMStoreOp::getDepMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> TMEMStoreOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::llvm::LogicalResult TMEMStoreOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute TMEMStoreOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TMEMStoreOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> TMEMStoreOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void TMEMStoreOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void TMEMStoreOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult TMEMStoreOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void TMEMStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value dst, Value src, Value pred) {
      build(odsBuilder, odsState, Type(), dst, Value(), src, pred);
    
}

TMEMStoreOp TMEMStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value dst, Value src, Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, dst, src, pred);
  auto __res__ = ::llvm::dyn_cast<TMEMStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMStoreOp TMEMStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, Value dst, Value src, Value pred) {
  return create(builder, builder.getLoc(), dst, src, pred);
}

void TMEMStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type token, ::mlir::Value dst, /*optional*/::mlir::Value dep, ::mlir::Value src, ::mlir::Value pred) {
  odsState.addOperands(dst);
  if (dep)
    odsState.addOperands(dep);
  odsState.addOperands(src);
  odsState.addOperands(pred);
  if (token)
    odsState.addTypes(token);
}

TMEMStoreOp TMEMStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type token, ::mlir::Value dst, /*optional*/::mlir::Value dep, ::mlir::Value src, ::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, token, dst, dep, src, pred);
  auto __res__ = ::llvm::dyn_cast<TMEMStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMStoreOp TMEMStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type token, ::mlir::Value dst, /*optional*/::mlir::Value dep, ::mlir::Value src, ::mlir::Value pred) {
  return create(builder, builder.getLoc(), token, dst, dep, src, pred);
}

void TMEMStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, /*optional*/::mlir::Value dep, ::mlir::Value src, ::mlir::Value pred) {
  odsState.addOperands(dst);
  if (dep)
    odsState.addOperands(dep);
  odsState.addOperands(src);
  odsState.addOperands(pred);
  odsState.addTypes(resultTypes);
}

TMEMStoreOp TMEMStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value dst, /*optional*/::mlir::Value dep, ::mlir::Value src, ::mlir::Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, dst, dep, src, pred);
  auto __res__ = ::llvm::dyn_cast<TMEMStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMStoreOp TMEMStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value dst, /*optional*/::mlir::Value dep, ::mlir::Value src, ::mlir::Value pred) {
  return create(builder, builder.getLoc(), resultTypes, dst, dep, src, pred);
}

void TMEMStoreOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes(resultTypes);
}

TMEMStoreOp TMEMStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TMEMStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMStoreOp TMEMStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TMEMStoreOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  odsState.addTypes(resultTypes);
}

TMEMStoreOp TMEMStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TMEMStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMStoreOp TMEMStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TMEMStoreOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("result group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps8(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult TMEMStoreOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult TMEMStoreOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand srcRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> srcOperands(&srcRawOperand, 1);  ::llvm::SMLoc srcOperandsLoc;
  (void)srcOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand dstRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> dstOperands(&dstRawOperand, 1);  ::llvm::SMLoc dstOperandsLoc;
  (void)dstOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> depOperands;
  ::llvm::SMLoc depOperandsLoc;
  (void)depOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> tokenTypes;
  ::mlir::OpAsmParser::UnresolvedOperand predRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> predOperands(&predRawOperand, 1);  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::mlir::Type srcRawType{};
  ::llvm::ArrayRef<::mlir::Type> srcTypes(&srcRawType, 1);
  ::mlir::Type dstRawType{};
  ::llvm::ArrayRef<::mlir::Type> dstTypes(&dstRawType, 1);

  srcOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(srcRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  dstOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(dstRawOperand))
    return ::mlir::failure();
  {
    depOperandsLoc = parser.getCurrentLocation();
    ::std::optional<::mlir::OpAsmParser::UnresolvedOperand> depOperand;
    ::mlir::Type tokenType;
    auto odsResult = parseToken(parser, depOperand, tokenType);
    if (odsResult) return ::mlir::failure();
    if (depOperand.has_value())
      depOperands.push_back(*depOperand);
    if (tokenType)
      tokenTypes.push_back(tokenType);
  }
  if (parser.parseComma())
    return ::mlir::failure();

  predOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(predRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    srcRawType = type;
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  if (parser.parseType(dstRawType))
    return ::mlir::failure();
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::triton::gpu::AsyncTokenType>();
  ::mlir::Type odsBuildableType1 = parser.getBuilder().getIntegerType(1);
  result.addTypes(tokenTypes);
  if (parser.resolveOperands(dstOperands, dstTypes, dstOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(depOperands, odsBuildableType0, depOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(srcOperands, srcTypes, srcOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType1, predOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void TMEMStoreOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSrc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getDst();
  printToken(_odsPrinter, *this, getDep(), (getToken() ? getToken().getType() : ::mlir::Type()));
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getPred();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getSrc().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
   _odsPrinter << getDst().getType();
}

void TMEMStoreOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::nvidia_gpu::TensorMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TMEMStoreOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TMEMSubSliceOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TMEMSubSliceOpGenericAdaptorBase::TMEMSubSliceOpGenericAdaptorBase(TMEMSubSliceOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

uint32_t TMEMSubSliceOpGenericAdaptorBase::getN() {
  auto attr = getNAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
TMEMSubSliceOpAdaptor::TMEMSubSliceOpAdaptor(TMEMSubSliceOp op) : TMEMSubSliceOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TMEMSubSliceOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_N = getProperties().N; (void)tblgen_N;
  if (!tblgen_N) return emitError(loc, "'ttng.tmem_subslice' op ""requires attribute 'N'");

  if (tblgen_N && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_N))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_N).getType().isSignlessInteger(32)))))
    return emitError(loc, "'ttng.tmem_subslice' op ""attribute 'N' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

::llvm::LogicalResult TMEMSubSliceOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.N;
       auto attr = dict.get("N");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `N` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute TMEMSubSliceOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.N;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("N",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TMEMSubSliceOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.N.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> TMEMSubSliceOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "N")
      return prop.N;
  return std::nullopt;
}

void TMEMSubSliceOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "N") {
       prop.N = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.N)>>(value);
       return;
    }
}

void TMEMSubSliceOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.N) attrs.append("N", prop.N);
}

::llvm::LogicalResult TMEMSubSliceOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getNAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(attr, "N", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult TMEMSubSliceOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.N)))
    return ::mlir::failure();
  return ::mlir::success();
}

void TMEMSubSliceOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.N);
}

uint32_t TMEMSubSliceOp::getN() {
  auto attr = getNAttr();
  return attr.getValue().getZExtValue();
}

void TMEMSubSliceOp::setN(uint32_t attrValue) {
  getProperties().N = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value alloc, int offset, int size) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, offset, size);
  auto __res__ = ::llvm::dyn_cast<TMEMSubSliceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::ImplicitLocOpBuilder &builder, Value alloc, int offset, int size) {
  return create(builder, builder.getLoc(), alloc, offset, size);
}

void TMEMSubSliceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value src, ::mlir::IntegerAttr N) {
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().N = N;
  odsState.addTypes(result);
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value src, ::mlir::IntegerAttr N) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, src, N);
  auto __res__ = ::llvm::dyn_cast<TMEMSubSliceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value src, ::mlir::IntegerAttr N) {
  return create(builder, builder.getLoc(), result, src, N);
}

void TMEMSubSliceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr N) {
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().N = N;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr N) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, src, N);
  auto __res__ = ::llvm::dyn_cast<TMEMSubSliceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr N) {
  return create(builder, builder.getLoc(), resultTypes, src, N);
}

void TMEMSubSliceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value src, uint32_t N) {
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().N = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), N);
  odsState.addTypes(result);
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value src, uint32_t N) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, src, N);
  auto __res__ = ::llvm::dyn_cast<TMEMSubSliceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value src, uint32_t N) {
  return create(builder, builder.getLoc(), result, src, N);
}

void TMEMSubSliceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, uint32_t N) {
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().N = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), N);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, uint32_t N) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, src, N);
  auto __res__ = ::llvm::dyn_cast<TMEMSubSliceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, uint32_t N) {
  return create(builder, builder.getLoc(), resultTypes, src, N);
}

void TMEMSubSliceOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<TMEMSubSliceOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TMEMSubSliceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TMEMSubSliceOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TMEMSubSliceOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TMEMSubSliceOp TMEMSubSliceOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TMEMSubSliceOp::verifyInvariantsImpl() {
  auto tblgen_N = getProperties().N; (void)tblgen_N;
  if (!tblgen_N) return emitOpError("requires attribute 'N'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(*this, tblgen_N, "N")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult TMEMSubSliceOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult TMEMSubSliceOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand srcRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> srcOperands(&srcRawOperand, 1);  ::llvm::SMLoc srcOperandsLoc;
  (void)srcOperandsLoc;
  ::mlir::Type srcRawType{};
  ::llvm::ArrayRef<::mlir::Type> srcTypes(&srcRawType, 1);
  ::mlir::Type resultRawType{};
  ::llvm::ArrayRef<::mlir::Type> resultTypes(&resultRawType, 1);

  srcOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(srcRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(srcRawType))
    return ::mlir::failure();
  if (parser.parseArrow())
    return ::mlir::failure();

  if (parser.parseType(resultRawType))
    return ::mlir::failure();
  result.addTypes(resultTypes);
  if (parser.resolveOperands(srcOperands, srcTypes, srcOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void TMEMSubSliceOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSrc();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getSrc().getType();
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
   _odsPrinter << getResult().getType();
}

void TMEMSubSliceOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TMEMSubSliceOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TensormapCreateOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TensormapCreateOpGenericAdaptorBase::TensormapCreateOpGenericAdaptorBase(TensormapCreateOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> TensormapCreateOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

uint32_t TensormapCreateOpGenericAdaptorBase::getElemType() {
  auto attr = getElemTypeAttr();
  return attr.getValue().getZExtValue();
}

uint32_t TensormapCreateOpGenericAdaptorBase::getInterleaveLayout() {
  auto attr = getInterleaveLayoutAttr();
  return attr.getValue().getZExtValue();
}

uint32_t TensormapCreateOpGenericAdaptorBase::getSwizzleMode() {
  auto attr = getSwizzleModeAttr();
  return attr.getValue().getZExtValue();
}

uint32_t TensormapCreateOpGenericAdaptorBase::getFillMode() {
  auto attr = getFillModeAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
TensormapCreateOpAdaptor::TensormapCreateOpAdaptor(TensormapCreateOp op) : TensormapCreateOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TensormapCreateOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_elem_type = getProperties().elem_type; (void)tblgen_elem_type;
  if (!tblgen_elem_type) return emitError(loc, "'ttng.tensormap_create' op ""requires attribute 'elem_type'");
  auto tblgen_fill_mode = getProperties().fill_mode; (void)tblgen_fill_mode;
  if (!tblgen_fill_mode) return emitError(loc, "'ttng.tensormap_create' op ""requires attribute 'fill_mode'");
  auto tblgen_interleave_layout = getProperties().interleave_layout; (void)tblgen_interleave_layout;
  if (!tblgen_interleave_layout) return emitError(loc, "'ttng.tensormap_create' op ""requires attribute 'interleave_layout'");
  auto tblgen_swizzle_mode = getProperties().swizzle_mode; (void)tblgen_swizzle_mode;
  if (!tblgen_swizzle_mode) return emitError(loc, "'ttng.tensormap_create' op ""requires attribute 'swizzle_mode'");

  if (tblgen_elem_type && !((((::llvm::isa<::mlir::IntegerAttr>(tblgen_elem_type))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_elem_type).getType().isSignlessInteger(32)))) && ((!::llvm::cast<::mlir::IntegerAttr>(tblgen_elem_type).getValue().isNegative())) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_elem_type).getInt() <= 15))))
    return emitError(loc, "'ttng.tensormap_create' op ""attribute 'elem_type' failed to satisfy constraint: 32-bit signless integer attribute whose value is non-negative whose maximum value is 15");

  if (tblgen_interleave_layout && !((((::llvm::isa<::mlir::IntegerAttr>(tblgen_interleave_layout))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_interleave_layout).getType().isSignlessInteger(32)))) && ((!::llvm::cast<::mlir::IntegerAttr>(tblgen_interleave_layout).getValue().isNegative())) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_interleave_layout).getInt() <= 2))))
    return emitError(loc, "'ttng.tensormap_create' op ""attribute 'interleave_layout' failed to satisfy constraint: 32-bit signless integer attribute whose value is non-negative whose maximum value is 2");

  if (tblgen_swizzle_mode && !((((::llvm::isa<::mlir::IntegerAttr>(tblgen_swizzle_mode))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_swizzle_mode).getType().isSignlessInteger(32)))) && ((!::llvm::cast<::mlir::IntegerAttr>(tblgen_swizzle_mode).getValue().isNegative())) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_swizzle_mode).getInt() <= 3))))
    return emitError(loc, "'ttng.tensormap_create' op ""attribute 'swizzle_mode' failed to satisfy constraint: 32-bit signless integer attribute whose value is non-negative whose maximum value is 3");

  if (tblgen_fill_mode && !((((::llvm::isa<::mlir::IntegerAttr>(tblgen_fill_mode))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_fill_mode).getType().isSignlessInteger(32)))) && ((!::llvm::cast<::mlir::IntegerAttr>(tblgen_fill_mode).getValue().isNegative())) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_fill_mode).getInt() <= 1))))
    return emitError(loc, "'ttng.tensormap_create' op ""attribute 'fill_mode' failed to satisfy constraint: 32-bit signless integer attribute whose value is non-negative whose maximum value is 1");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> TensormapCreateOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange TensormapCreateOp::getBoxDimMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange TensormapCreateOp::getGlobalDimMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange TensormapCreateOp::getGlobalStrideMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange TensormapCreateOp::getElementStrideMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(5u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult TensormapCreateOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.elem_type;
       auto attr = dict.get("elem_type");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `elem_type` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.fill_mode;
       auto attr = dict.get("fill_mode");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fill_mode` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.interleave_layout;
       auto attr = dict.get("interleave_layout");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `interleave_layout` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.swizzle_mode;
       auto attr = dict.get("swizzle_mode");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `swizzle_mode` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute TensormapCreateOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.elem_type;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("elem_type",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.fill_mode;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fill_mode",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.interleave_layout;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("interleave_layout",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.swizzle_mode;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("swizzle_mode",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TensormapCreateOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.elem_type.getAsOpaquePointer()), 
    llvm::hash_value(prop.fill_mode.getAsOpaquePointer()), 
    llvm::hash_value(prop.interleave_layout.getAsOpaquePointer()), 
    llvm::hash_value(prop.swizzle_mode.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> TensormapCreateOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "elem_type")
      return prop.elem_type;

    if (name == "fill_mode")
      return prop.fill_mode;

    if (name == "interleave_layout")
      return prop.interleave_layout;

    if (name == "swizzle_mode")
      return prop.swizzle_mode;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void TensormapCreateOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "elem_type") {
       prop.elem_type = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.elem_type)>>(value);
       return;
    }

    if (name == "fill_mode") {
       prop.fill_mode = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fill_mode)>>(value);
       return;
    }

    if (name == "interleave_layout") {
       prop.interleave_layout = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.interleave_layout)>>(value);
       return;
    }

    if (name == "swizzle_mode") {
       prop.swizzle_mode = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.swizzle_mode)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void TensormapCreateOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.elem_type) attrs.append("elem_type", prop.elem_type);

    if (prop.fill_mode) attrs.append("fill_mode", prop.fill_mode);

    if (prop.interleave_layout) attrs.append("interleave_layout", prop.interleave_layout);

    if (prop.swizzle_mode) attrs.append("swizzle_mode", prop.swizzle_mode);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult TensormapCreateOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getElemTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps9(attr, "elem_type", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getFillModeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps12(attr, "fill_mode", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getInterleaveLayoutAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps10(attr, "interleave_layout", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getSwizzleModeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps11(attr, "swizzle_mode", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult TensormapCreateOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.elem_type)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.fill_mode)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.interleave_layout)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  if (::mlir::failed(reader.readAttribute(prop.swizzle_mode)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void TensormapCreateOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.elem_type);
  writer.writeAttribute(prop.fill_mode);
  writer.writeAttribute(prop.interleave_layout);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}
  writer.writeAttribute(prop.swizzle_mode);

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

uint32_t TensormapCreateOp::getElemType() {
  auto attr = getElemTypeAttr();
  return attr.getValue().getZExtValue();
}

uint32_t TensormapCreateOp::getInterleaveLayout() {
  auto attr = getInterleaveLayoutAttr();
  return attr.getValue().getZExtValue();
}

uint32_t TensormapCreateOp::getSwizzleMode() {
  auto attr = getSwizzleModeAttr();
  return attr.getValue().getZExtValue();
}

uint32_t TensormapCreateOp::getFillMode() {
  auto attr = getFillModeAttr();
  return attr.getValue().getZExtValue();
}

void TensormapCreateOp::setElemType(uint32_t attrValue) {
  getProperties().elem_type = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void TensormapCreateOp::setInterleaveLayout(uint32_t attrValue) {
  getProperties().interleave_layout = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void TensormapCreateOp::setSwizzleMode(uint32_t attrValue) {
  getProperties().swizzle_mode = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void TensormapCreateOp::setFillMode(uint32_t attrValue) {
  getProperties().fill_mode = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void TensormapCreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, ::mlir::IntegerAttr elem_type, ::mlir::IntegerAttr interleave_layout, ::mlir::IntegerAttr swizzle_mode, ::mlir::IntegerAttr fill_mode) {
  odsState.addOperands(desc_ptr);
  odsState.addOperands(global_address);
  odsState.addOperands(box_dim);
  odsState.addOperands(global_dim);
  odsState.addOperands(global_stride);
  odsState.addOperands(element_stride);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, static_cast<int32_t>(box_dim.size()), static_cast<int32_t>(global_dim.size()), static_cast<int32_t>(global_stride.size()), static_cast<int32_t>(element_stride.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().elem_type = elem_type;
  odsState.getOrAddProperties<Properties>().interleave_layout = interleave_layout;
  odsState.getOrAddProperties<Properties>().swizzle_mode = swizzle_mode;
  odsState.getOrAddProperties<Properties>().fill_mode = fill_mode;
}

TensormapCreateOp TensormapCreateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, ::mlir::IntegerAttr elem_type, ::mlir::IntegerAttr interleave_layout, ::mlir::IntegerAttr swizzle_mode, ::mlir::IntegerAttr fill_mode) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, desc_ptr, global_address, box_dim, global_dim, global_stride, element_stride, elem_type, interleave_layout, swizzle_mode, fill_mode);
  auto __res__ = ::llvm::dyn_cast<TensormapCreateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TensormapCreateOp TensormapCreateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, ::mlir::IntegerAttr elem_type, ::mlir::IntegerAttr interleave_layout, ::mlir::IntegerAttr swizzle_mode, ::mlir::IntegerAttr fill_mode) {
  return create(builder, builder.getLoc(), desc_ptr, global_address, box_dim, global_dim, global_stride, element_stride, elem_type, interleave_layout, swizzle_mode, fill_mode);
}

void TensormapCreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, ::mlir::IntegerAttr elem_type, ::mlir::IntegerAttr interleave_layout, ::mlir::IntegerAttr swizzle_mode, ::mlir::IntegerAttr fill_mode) {
  odsState.addOperands(desc_ptr);
  odsState.addOperands(global_address);
  odsState.addOperands(box_dim);
  odsState.addOperands(global_dim);
  odsState.addOperands(global_stride);
  odsState.addOperands(element_stride);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, static_cast<int32_t>(box_dim.size()), static_cast<int32_t>(global_dim.size()), static_cast<int32_t>(global_stride.size()), static_cast<int32_t>(element_stride.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().elem_type = elem_type;
  odsState.getOrAddProperties<Properties>().interleave_layout = interleave_layout;
  odsState.getOrAddProperties<Properties>().swizzle_mode = swizzle_mode;
  odsState.getOrAddProperties<Properties>().fill_mode = fill_mode;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TensormapCreateOp TensormapCreateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, ::mlir::IntegerAttr elem_type, ::mlir::IntegerAttr interleave_layout, ::mlir::IntegerAttr swizzle_mode, ::mlir::IntegerAttr fill_mode) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, desc_ptr, global_address, box_dim, global_dim, global_stride, element_stride, elem_type, interleave_layout, swizzle_mode, fill_mode);
  auto __res__ = ::llvm::dyn_cast<TensormapCreateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TensormapCreateOp TensormapCreateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, ::mlir::IntegerAttr elem_type, ::mlir::IntegerAttr interleave_layout, ::mlir::IntegerAttr swizzle_mode, ::mlir::IntegerAttr fill_mode) {
  return create(builder, builder.getLoc(), resultTypes, desc_ptr, global_address, box_dim, global_dim, global_stride, element_stride, elem_type, interleave_layout, swizzle_mode, fill_mode);
}

void TensormapCreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, uint32_t elem_type, uint32_t interleave_layout, uint32_t swizzle_mode, uint32_t fill_mode) {
  odsState.addOperands(desc_ptr);
  odsState.addOperands(global_address);
  odsState.addOperands(box_dim);
  odsState.addOperands(global_dim);
  odsState.addOperands(global_stride);
  odsState.addOperands(element_stride);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, static_cast<int32_t>(box_dim.size()), static_cast<int32_t>(global_dim.size()), static_cast<int32_t>(global_stride.size()), static_cast<int32_t>(element_stride.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().elem_type = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), elem_type);
  odsState.getOrAddProperties<Properties>().interleave_layout = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), interleave_layout);
  odsState.getOrAddProperties<Properties>().swizzle_mode = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), swizzle_mode);
  odsState.getOrAddProperties<Properties>().fill_mode = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), fill_mode);
}

TensormapCreateOp TensormapCreateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, uint32_t elem_type, uint32_t interleave_layout, uint32_t swizzle_mode, uint32_t fill_mode) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, desc_ptr, global_address, box_dim, global_dim, global_stride, element_stride, elem_type, interleave_layout, swizzle_mode, fill_mode);
  auto __res__ = ::llvm::dyn_cast<TensormapCreateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TensormapCreateOp TensormapCreateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, uint32_t elem_type, uint32_t interleave_layout, uint32_t swizzle_mode, uint32_t fill_mode) {
  return create(builder, builder.getLoc(), desc_ptr, global_address, box_dim, global_dim, global_stride, element_stride, elem_type, interleave_layout, swizzle_mode, fill_mode);
}

void TensormapCreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, uint32_t elem_type, uint32_t interleave_layout, uint32_t swizzle_mode, uint32_t fill_mode) {
  odsState.addOperands(desc_ptr);
  odsState.addOperands(global_address);
  odsState.addOperands(box_dim);
  odsState.addOperands(global_dim);
  odsState.addOperands(global_stride);
  odsState.addOperands(element_stride);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, static_cast<int32_t>(box_dim.size()), static_cast<int32_t>(global_dim.size()), static_cast<int32_t>(global_stride.size()), static_cast<int32_t>(element_stride.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().elem_type = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), elem_type);
  odsState.getOrAddProperties<Properties>().interleave_layout = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), interleave_layout);
  odsState.getOrAddProperties<Properties>().swizzle_mode = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), swizzle_mode);
  odsState.getOrAddProperties<Properties>().fill_mode = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), fill_mode);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TensormapCreateOp TensormapCreateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, uint32_t elem_type, uint32_t interleave_layout, uint32_t swizzle_mode, uint32_t fill_mode) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, desc_ptr, global_address, box_dim, global_dim, global_stride, element_stride, elem_type, interleave_layout, swizzle_mode, fill_mode);
  auto __res__ = ::llvm::dyn_cast<TensormapCreateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TensormapCreateOp TensormapCreateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value desc_ptr, ::mlir::Value global_address, ::mlir::ValueRange box_dim, ::mlir::ValueRange global_dim, ::mlir::ValueRange global_stride, ::mlir::ValueRange element_stride, uint32_t elem_type, uint32_t interleave_layout, uint32_t swizzle_mode, uint32_t fill_mode) {
  return create(builder, builder.getLoc(), resultTypes, desc_ptr, global_address, box_dim, global_dim, global_stride, element_stride, elem_type, interleave_layout, swizzle_mode, fill_mode);
}

void TensormapCreateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<TensormapCreateOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

TensormapCreateOp TensormapCreateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TensormapCreateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TensormapCreateOp TensormapCreateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TensormapCreateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TensormapCreateOp TensormapCreateOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TensormapCreateOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TensormapCreateOp TensormapCreateOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TensormapCreateOp::verifyInvariantsImpl() {
  auto tblgen_elem_type = getProperties().elem_type; (void)tblgen_elem_type;
  if (!tblgen_elem_type) return emitOpError("requires attribute 'elem_type'");
  auto tblgen_fill_mode = getProperties().fill_mode; (void)tblgen_fill_mode;
  if (!tblgen_fill_mode) return emitOpError("requires attribute 'fill_mode'");
  auto tblgen_interleave_layout = getProperties().interleave_layout; (void)tblgen_interleave_layout;
  if (!tblgen_interleave_layout) return emitOpError("requires attribute 'interleave_layout'");
  auto tblgen_swizzle_mode = getProperties().swizzle_mode; (void)tblgen_swizzle_mode;
  if (!tblgen_swizzle_mode) return emitOpError("requires attribute 'swizzle_mode'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps9(*this, tblgen_elem_type, "elem_type")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps10(*this, tblgen_interleave_layout, "interleave_layout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps11(*this, tblgen_swizzle_mode, "swizzle_mode")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps12(*this, tblgen_fill_mode, "fill_mode")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps12(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps12(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps13(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult TensormapCreateOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult TensormapCreateOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand desc_ptrRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> desc_ptrOperands(&desc_ptrRawOperand, 1);  ::llvm::SMLoc desc_ptrOperandsLoc;
  (void)desc_ptrOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand global_addressRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> global_addressOperands(&global_addressRawOperand, 1);  ::llvm::SMLoc global_addressOperandsLoc;
  (void)global_addressOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> box_dimOperands;
  ::llvm::SMLoc box_dimOperandsLoc;
  (void)box_dimOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> global_dimOperands;
  ::llvm::SMLoc global_dimOperandsLoc;
  (void)global_dimOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> global_strideOperands;
  ::llvm::SMLoc global_strideOperandsLoc;
  (void)global_strideOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> element_strideOperands;
  ::llvm::SMLoc element_strideOperandsLoc;
  (void)element_strideOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  desc_ptrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(desc_ptrRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  global_addressOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(global_addressRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();
  if (parser.parseLSquare())
    return ::mlir::failure();

  box_dimOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(box_dimOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();
  if (parser.parseLSquare())
    return ::mlir::failure();

  global_dimOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(global_dimOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();
  if (parser.parseLSquare())
    return ::mlir::failure();

  global_strideOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(global_strideOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();
  if (parser.parseLSquare())
    return ::mlir::failure();

  element_strideOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(element_strideOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, static_cast<int32_t>(box_dimOperands.size()), static_cast<int32_t>(global_dimOperands.size()), static_cast<int32_t>(global_strideOperands.size()), static_cast<int32_t>(element_strideOperands.size())}), result.getOrAddProperties<TensormapCreateOp::Properties>().operandSegmentSizes.begin());
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(desc_ptrOperands, global_addressOperands, box_dimOperands, global_dimOperands, global_strideOperands, element_strideOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void TensormapCreateOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getDescPtr();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getGlobalAddress();
  _odsPrinter << ",";
  _odsPrinter << ' ' << "[";
  _odsPrinter << getBoxDim();
  _odsPrinter << "]";
  _odsPrinter << ",";
  _odsPrinter << ' ' << "[";
  _odsPrinter << getGlobalDim();
  _odsPrinter << "]";
  _odsPrinter << ",";
  _odsPrinter << ' ' << "[";
  _odsPrinter << getGlobalStride();
  _odsPrinter << "]";
  _odsPrinter << ",";
  _odsPrinter << ' ' << "[";
  _odsPrinter << getElementStride();
  _odsPrinter << "]";
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void TensormapCreateOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Read::get(), 0, false, ::mlir::triton::GlobalMemory::get());
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TensormapCreateOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::TensormapFenceproxyAcquireOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
TensormapFenceproxyAcquireOpGenericAdaptorBase::TensormapFenceproxyAcquireOpGenericAdaptorBase(TensormapFenceproxyAcquireOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
TensormapFenceproxyAcquireOpAdaptor::TensormapFenceproxyAcquireOpAdaptor(TensormapFenceproxyAcquireOp op) : TensormapFenceproxyAcquireOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult TensormapFenceproxyAcquireOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult TensormapFenceproxyAcquireOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute TensormapFenceproxyAcquireOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code TensormapFenceproxyAcquireOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> TensormapFenceproxyAcquireOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void TensormapFenceproxyAcquireOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void TensormapFenceproxyAcquireOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult TensormapFenceproxyAcquireOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void TensormapFenceproxyAcquireOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value desc_ptr) {
  odsState.addOperands(desc_ptr);
}

TensormapFenceproxyAcquireOp TensormapFenceproxyAcquireOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value desc_ptr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, desc_ptr);
  auto __res__ = ::llvm::dyn_cast<TensormapFenceproxyAcquireOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TensormapFenceproxyAcquireOp TensormapFenceproxyAcquireOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value desc_ptr) {
  return create(builder, builder.getLoc(), desc_ptr);
}

void TensormapFenceproxyAcquireOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value desc_ptr) {
  odsState.addOperands(desc_ptr);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

TensormapFenceproxyAcquireOp TensormapFenceproxyAcquireOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value desc_ptr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, desc_ptr);
  auto __res__ = ::llvm::dyn_cast<TensormapFenceproxyAcquireOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TensormapFenceproxyAcquireOp TensormapFenceproxyAcquireOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value desc_ptr) {
  return create(builder, builder.getLoc(), resultTypes, desc_ptr);
}

void TensormapFenceproxyAcquireOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TensormapFenceproxyAcquireOp TensormapFenceproxyAcquireOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<TensormapFenceproxyAcquireOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TensormapFenceproxyAcquireOp TensormapFenceproxyAcquireOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void TensormapFenceproxyAcquireOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

TensormapFenceproxyAcquireOp TensormapFenceproxyAcquireOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<TensormapFenceproxyAcquireOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

TensormapFenceproxyAcquireOp TensormapFenceproxyAcquireOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult TensormapFenceproxyAcquireOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps12(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult TensormapFenceproxyAcquireOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult TensormapFenceproxyAcquireOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand desc_ptrRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> desc_ptrOperands(&desc_ptrRawOperand, 1);  ::llvm::SMLoc desc_ptrOperandsLoc;
  (void)desc_ptrOperandsLoc;
  ::mlir::Type desc_ptrRawType{};
  ::llvm::ArrayRef<::mlir::Type> desc_ptrTypes(&desc_ptrRawType, 1);

  desc_ptrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(desc_ptrRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(desc_ptrRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(desc_ptrOperands, desc_ptrTypes, desc_ptrOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void TensormapFenceproxyAcquireOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getDescPtr();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getDescPtr().getType();
}

void TensormapFenceproxyAcquireOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::TensormapFenceproxyAcquireOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::WaitBarrierOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WaitBarrierOpGenericAdaptorBase::WaitBarrierOpGenericAdaptorBase(WaitBarrierOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> WaitBarrierOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

} // namespace detail
WaitBarrierOpAdaptor::WaitBarrierOpAdaptor(WaitBarrierOp op) : WaitBarrierOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WaitBarrierOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> WaitBarrierOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange WaitBarrierOp::getPredMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange WaitBarrierOp::getDepsMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult WaitBarrierOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
    {

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute WaitBarrierOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WaitBarrierOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> WaitBarrierOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void WaitBarrierOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void WaitBarrierOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult WaitBarrierOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

::llvm::LogicalResult WaitBarrierOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void WaitBarrierOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

void WaitBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value alloc, Value phase) {
    build(odsBuilder, odsState, alloc, phase, /*pred=*/static_cast<mlir::Value>(nullptr), /*deps=*/{});
    
}

WaitBarrierOp WaitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value alloc, Value phase) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, phase);
  auto __res__ = ::llvm::dyn_cast<WaitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WaitBarrierOp WaitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, Value alloc, Value phase) {
  return create(builder, builder.getLoc(), alloc, phase);
}

void WaitBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value alloc, Value phase, Value pred) {
    build(odsBuilder, odsState, alloc, phase, pred, /*deps=*/{});
    
}

WaitBarrierOp WaitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value alloc, Value phase, Value pred) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, phase, pred);
  auto __res__ = ::llvm::dyn_cast<WaitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WaitBarrierOp WaitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, Value alloc, Value phase, Value pred) {
  return create(builder, builder.getLoc(), alloc, phase, pred);
}

void WaitBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value alloc, Value phase, ValueRange deps) {
    build(odsBuilder, odsState, alloc, phase, /*pred=*/static_cast<mlir::Value>(nullptr), deps);
    
}

WaitBarrierOp WaitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value alloc, Value phase, ValueRange deps) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, phase, deps);
  auto __res__ = ::llvm::dyn_cast<WaitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WaitBarrierOp WaitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, Value alloc, Value phase, ValueRange deps) {
  return create(builder, builder.getLoc(), alloc, phase, deps);
}

void WaitBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value alloc, ::mlir::Value phase, /*optional*/::mlir::Value pred, ::mlir::ValueRange deps) {
  odsState.addOperands(alloc);
  odsState.addOperands(phase);
  if (pred)
    odsState.addOperands(pred);
  odsState.addOperands(deps);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, (pred ? 1 : 0), static_cast<int32_t>(deps.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
}

WaitBarrierOp WaitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value alloc, ::mlir::Value phase, /*optional*/::mlir::Value pred, ::mlir::ValueRange deps) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, alloc, phase, pred, deps);
  auto __res__ = ::llvm::dyn_cast<WaitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WaitBarrierOp WaitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value alloc, ::mlir::Value phase, /*optional*/::mlir::Value pred, ::mlir::ValueRange deps) {
  return create(builder, builder.getLoc(), alloc, phase, pred, deps);
}

void WaitBarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::Value phase, /*optional*/::mlir::Value pred, ::mlir::ValueRange deps) {
  odsState.addOperands(alloc);
  odsState.addOperands(phase);
  if (pred)
    odsState.addOperands(pred);
  odsState.addOperands(deps);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, (pred ? 1 : 0), static_cast<int32_t>(deps.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WaitBarrierOp WaitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::Value phase, /*optional*/::mlir::Value pred, ::mlir::ValueRange deps) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, alloc, phase, pred, deps);
  auto __res__ = ::llvm::dyn_cast<WaitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WaitBarrierOp WaitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value alloc, ::mlir::Value phase, /*optional*/::mlir::Value pred, ::mlir::ValueRange deps) {
  return create(builder, builder.getLoc(), resultTypes, alloc, phase, pred, deps);
}

void WaitBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WaitBarrierOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WaitBarrierOp WaitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WaitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WaitBarrierOp WaitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WaitBarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WaitBarrierOp WaitBarrierOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WaitBarrierOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WaitBarrierOp WaitBarrierOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult WaitBarrierOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps9(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult WaitBarrierOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult WaitBarrierOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand allocRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> allocOperands(&allocRawOperand, 1);  ::llvm::SMLoc allocOperandsLoc;
  (void)allocOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand phaseRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> phaseOperands(&phaseRawOperand, 1);  ::llvm::SMLoc phaseOperandsLoc;
  (void)phaseOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> predOperands;
  ::llvm::SMLoc predOperandsLoc;
  (void)predOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> depsOperands;
  ::llvm::SMLoc depsOperandsLoc;
  (void)depsOperandsLoc;
  ::mlir::Type allocRawType{};
  ::llvm::ArrayRef<::mlir::Type> allocTypes(&allocRawType, 1);
  ::llvm::SmallVector<::mlir::Type, 1> depsTypes;

  allocOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(allocRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  phaseOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(phaseRawOperand))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    predOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      predOperands.push_back(operand);
    }
  }
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("deps"))) {

  depsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(depsOperands))
    return ::mlir::failure();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(allocRawType))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  if (parser.parseTypeList(depsTypes))
    return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, 1, static_cast<int32_t>(predOperands.size()), static_cast<int32_t>(depsOperands.size())}), result.getOrAddProperties<WaitBarrierOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(32);
  ::mlir::Type odsBuildableType1 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(allocOperands, allocTypes, allocOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(phaseOperands, odsBuildableType0, phaseOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(predOperands, odsBuildableType1, predOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(depsOperands, depsTypes, depsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void WaitBarrierOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getAlloc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getPhase();
  if (getPred()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getPred())
      _odsPrinter << value;
  }
  if (!getDeps().empty()) {
    _odsPrinter << ' ' << "deps";
    _odsPrinter << ' ';
    _odsPrinter << getDeps();
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getAlloc().getType();
  if (!getDeps().empty()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    _odsPrinter << getDeps().getTypes();
  }
}

void WaitBarrierOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Read::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
  {
    auto valueRange = getODSOperandIndexAndLength(0);
    for (unsigned idx = valueRange.first; idx < valueRange.first + valueRange.second; idx++) {
      effects.emplace_back(::mlir::MemoryEffects::Write::get(), &getOperation()->getOpOperand(idx), 0, false, ::mlir::triton::gpu::SharedMemory::get());
    }
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::WaitBarrierOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::WarpGroupDotOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WarpGroupDotOpGenericAdaptorBase::WarpGroupDotOpGenericAdaptorBase(WarpGroupDotOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> WarpGroupDotOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::triton::InputPrecisionAttr WarpGroupDotOpGenericAdaptorBase::getInputPrecisionAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::triton::InputPrecisionAttr>(getProperties().inputPrecision);
  return attr;
}

::mlir::triton::InputPrecision WarpGroupDotOpGenericAdaptorBase::getInputPrecision() {
  auto attr = getInputPrecisionAttr();
  return attr.getValue();
}

::mlir::IntegerAttr WarpGroupDotOpGenericAdaptorBase::getMaxNumImpreciseAccAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().maxNumImpreciseAcc);
  return attr;
}

uint32_t WarpGroupDotOpGenericAdaptorBase::getMaxNumImpreciseAcc() {
  auto attr = getMaxNumImpreciseAccAttr();
  return attr.getValue().getZExtValue();
}

::mlir::BoolAttr WarpGroupDotOpGenericAdaptorBase::getIsAsyncAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().isAsync);
  return attr;
}

bool WarpGroupDotOpGenericAdaptorBase::getIsAsync() {
  auto attr = getIsAsyncAttr();
  return attr.getValue();
}

} // namespace detail
WarpGroupDotOpAdaptor::WarpGroupDotOpAdaptor(WarpGroupDotOp op) : WarpGroupDotOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WarpGroupDotOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_inputPrecision = getProperties().inputPrecision; (void)tblgen_inputPrecision;
  auto tblgen_isAsync = getProperties().isAsync; (void)tblgen_isAsync;
  auto tblgen_maxNumImpreciseAcc = getProperties().maxNumImpreciseAcc; (void)tblgen_maxNumImpreciseAcc;

  if (tblgen_inputPrecision && !((::llvm::isa<::mlir::triton::InputPrecisionAttr>(tblgen_inputPrecision))))
    return emitError(loc, "'ttng.warp_group_dot' op ""attribute 'inputPrecision' failed to satisfy constraint: allowed 32-bit signless integer cases: 0, 1, 2");

  if (tblgen_maxNumImpreciseAcc && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_maxNumImpreciseAcc))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_maxNumImpreciseAcc).getType().isSignlessInteger(32)))))
    return emitError(loc, "'ttng.warp_group_dot' op ""attribute 'maxNumImpreciseAcc' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_isAsync && !((::llvm::isa<::mlir::BoolAttr>(tblgen_isAsync))))
    return emitError(loc, "'ttng.warp_group_dot' op ""attribute 'isAsync' failed to satisfy constraint: bool attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> WarpGroupDotOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange WarpGroupDotOp::getUseCMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult WarpGroupDotOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.inputPrecision;
       auto attr = dict.get("inputPrecision");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `inputPrecision` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.isAsync;
       auto attr = dict.get("isAsync");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `isAsync` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.maxNumImpreciseAcc;
       auto attr = dict.get("maxNumImpreciseAcc");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `maxNumImpreciseAcc` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WarpGroupDotOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.inputPrecision;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("inputPrecision",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.isAsync;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("isAsync",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.maxNumImpreciseAcc;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("maxNumImpreciseAcc",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WarpGroupDotOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.inputPrecision.getAsOpaquePointer()), 
    llvm::hash_value(prop.isAsync.getAsOpaquePointer()), 
    llvm::hash_value(prop.maxNumImpreciseAcc.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WarpGroupDotOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "inputPrecision")
      return prop.inputPrecision;

    if (name == "isAsync")
      return prop.isAsync;

    if (name == "maxNumImpreciseAcc")
      return prop.maxNumImpreciseAcc;
  return std::nullopt;
}

void WarpGroupDotOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "inputPrecision") {
       prop.inputPrecision = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.inputPrecision)>>(value);
       return;
    }

    if (name == "isAsync") {
       prop.isAsync = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.isAsync)>>(value);
       return;
    }

    if (name == "maxNumImpreciseAcc") {
       prop.maxNumImpreciseAcc = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.maxNumImpreciseAcc)>>(value);
       return;
    }
}

void WarpGroupDotOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.inputPrecision) attrs.append("inputPrecision", prop.inputPrecision);

    if (prop.isAsync) attrs.append("isAsync", prop.isAsync);

    if (prop.maxNumImpreciseAcc) attrs.append("maxNumImpreciseAcc", prop.maxNumImpreciseAcc);
}

::llvm::LogicalResult WarpGroupDotOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getInputPrecisionAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps13(attr, "inputPrecision", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getIsAsyncAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps5(attr, "isAsync", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getMaxNumImpreciseAccAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(attr, "maxNumImpreciseAcc", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WarpGroupDotOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.inputPrecision)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.isAsync)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.maxNumImpreciseAcc)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WarpGroupDotOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.inputPrecision);

  writer.writeOptionalAttribute(prop.isAsync);

  writer.writeOptionalAttribute(prop.maxNumImpreciseAcc);
}

::mlir::triton::InputPrecision WarpGroupDotOp::getInputPrecision() {
  auto attr = getInputPrecisionAttr();
  return attr.getValue();
}

uint32_t WarpGroupDotOp::getMaxNumImpreciseAcc() {
  auto attr = getMaxNumImpreciseAccAttr();
  return attr.getValue().getZExtValue();
}

bool WarpGroupDotOp::getIsAsync() {
  auto attr = getIsAsyncAttr();
  return attr.getValue();
}

void WarpGroupDotOp::setInputPrecision(::mlir::triton::InputPrecision attrValue) {
  getProperties().inputPrecision = ::mlir::triton::InputPrecisionAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void WarpGroupDotOp::setMaxNumImpreciseAcc(uint32_t attrValue) {
  getProperties().maxNumImpreciseAcc = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void WarpGroupDotOp::setIsAsync(bool attrValue) {
  getProperties().isAsync = ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue);
}

void WarpGroupDotOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type d, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecisionAttr inputPrecision, ::mlir::IntegerAttr maxNumImpreciseAcc, ::mlir::BoolAttr isAsync) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (useC)
    odsState.addOperands(useC);
  if (inputPrecision) {
    odsState.getOrAddProperties<Properties>().inputPrecision = inputPrecision;
  }
  if (maxNumImpreciseAcc) {
    odsState.getOrAddProperties<Properties>().maxNumImpreciseAcc = maxNumImpreciseAcc;
  }
  if (isAsync) {
    odsState.getOrAddProperties<Properties>().isAsync = isAsync;
  }
  odsState.addTypes(d);
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type d, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecisionAttr inputPrecision, ::mlir::IntegerAttr maxNumImpreciseAcc, ::mlir::BoolAttr isAsync) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, d, a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type d, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecisionAttr inputPrecision, ::mlir::IntegerAttr maxNumImpreciseAcc, ::mlir::BoolAttr isAsync) {
  return create(builder, builder.getLoc(), d, a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
}

void WarpGroupDotOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecisionAttr inputPrecision, ::mlir::IntegerAttr maxNumImpreciseAcc, ::mlir::BoolAttr isAsync) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (useC)
    odsState.addOperands(useC);
  if (inputPrecision) {
    odsState.getOrAddProperties<Properties>().inputPrecision = inputPrecision;
  }
  if (maxNumImpreciseAcc) {
    odsState.getOrAddProperties<Properties>().maxNumImpreciseAcc = maxNumImpreciseAcc;
  }
  if (isAsync) {
    odsState.getOrAddProperties<Properties>().isAsync = isAsync;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(WarpGroupDotOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::mlir::detail::reportFatalInferReturnTypesError(odsState);
        
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecisionAttr inputPrecision, ::mlir::IntegerAttr maxNumImpreciseAcc, ::mlir::BoolAttr isAsync) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecisionAttr inputPrecision, ::mlir::IntegerAttr maxNumImpreciseAcc, ::mlir::BoolAttr isAsync) {
  return create(builder, builder.getLoc(), a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
}

void WarpGroupDotOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecisionAttr inputPrecision, ::mlir::IntegerAttr maxNumImpreciseAcc, ::mlir::BoolAttr isAsync) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (useC)
    odsState.addOperands(useC);
  if (inputPrecision) {
    odsState.getOrAddProperties<Properties>().inputPrecision = inputPrecision;
  }
  if (maxNumImpreciseAcc) {
    odsState.getOrAddProperties<Properties>().maxNumImpreciseAcc = maxNumImpreciseAcc;
  }
  if (isAsync) {
    odsState.getOrAddProperties<Properties>().isAsync = isAsync;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecisionAttr inputPrecision, ::mlir::IntegerAttr maxNumImpreciseAcc, ::mlir::BoolAttr isAsync) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecisionAttr inputPrecision, ::mlir::IntegerAttr maxNumImpreciseAcc, ::mlir::BoolAttr isAsync) {
  return create(builder, builder.getLoc(), resultTypes, a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
}

void WarpGroupDotOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type d, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecision inputPrecision, uint32_t maxNumImpreciseAcc, bool isAsync) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (useC)
    odsState.addOperands(useC);
  odsState.getOrAddProperties<Properties>().inputPrecision = ::mlir::triton::InputPrecisionAttr::get(odsBuilder.getContext(), inputPrecision);
  odsState.getOrAddProperties<Properties>().maxNumImpreciseAcc = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), maxNumImpreciseAcc);
  odsState.getOrAddProperties<Properties>().isAsync = odsBuilder.getBoolAttr(isAsync);
  odsState.addTypes(d);
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type d, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecision inputPrecision, uint32_t maxNumImpreciseAcc, bool isAsync) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, d, a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type d, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecision inputPrecision, uint32_t maxNumImpreciseAcc, bool isAsync) {
  return create(builder, builder.getLoc(), d, a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
}

void WarpGroupDotOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecision inputPrecision, uint32_t maxNumImpreciseAcc, bool isAsync) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (useC)
    odsState.addOperands(useC);
  odsState.getOrAddProperties<Properties>().inputPrecision = ::mlir::triton::InputPrecisionAttr::get(odsBuilder.getContext(), inputPrecision);
  odsState.getOrAddProperties<Properties>().maxNumImpreciseAcc = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), maxNumImpreciseAcc);
  odsState.getOrAddProperties<Properties>().isAsync = odsBuilder.getBoolAttr(isAsync);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(WarpGroupDotOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::mlir::detail::reportFatalInferReturnTypesError(odsState);
        
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecision inputPrecision, uint32_t maxNumImpreciseAcc, bool isAsync) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecision inputPrecision, uint32_t maxNumImpreciseAcc, bool isAsync) {
  return create(builder, builder.getLoc(), a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
}

void WarpGroupDotOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecision inputPrecision, uint32_t maxNumImpreciseAcc, bool isAsync) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (useC)
    odsState.addOperands(useC);
  odsState.getOrAddProperties<Properties>().inputPrecision = ::mlir::triton::InputPrecisionAttr::get(odsBuilder.getContext(), inputPrecision);
  odsState.getOrAddProperties<Properties>().maxNumImpreciseAcc = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), maxNumImpreciseAcc);
  odsState.getOrAddProperties<Properties>().isAsync = odsBuilder.getBoolAttr(isAsync);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecision inputPrecision, uint32_t maxNumImpreciseAcc, bool isAsync) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::Value useC, ::mlir::triton::InputPrecision inputPrecision, uint32_t maxNumImpreciseAcc, bool isAsync) {
  return create(builder, builder.getLoc(), resultTypes, a, b, c, useC, inputPrecision, maxNumImpreciseAcc, isAsync);
}

void WarpGroupDotOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WarpGroupDotOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WarpGroupDotOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WarpGroupDotOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(WarpGroupDotOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), operands, attributes);
}

void WarpGroupDotOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

void WarpGroupDotOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties &>(properties));
  odsState.addAttributes(discardableAttributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(WarpGroupDotOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotOp WarpGroupDotOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), operands, properties, discardableAttributes);
}

void WarpGroupDotOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.inputPrecision)
    properties.inputPrecision = ::mlir::triton::InputPrecisionAttr::get(odsBuilder.getContext(), ::mlir::triton::InputPrecision::IEEE);
  if (!properties.maxNumImpreciseAcc)
    properties.maxNumImpreciseAcc = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), 0);
  if (!properties.isAsync)
    properties.isAsync = odsBuilder.getBoolAttr(false);
}

::llvm::LogicalResult WarpGroupDotOp::verifyInvariantsImpl() {
  auto tblgen_inputPrecision = getProperties().inputPrecision; (void)tblgen_inputPrecision;
  auto tblgen_isAsync = getProperties().isAsync; (void)tblgen_isAsync;
  auto tblgen_maxNumImpreciseAcc = getProperties().maxNumImpreciseAcc; (void)tblgen_maxNumImpreciseAcc;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps13(*this, tblgen_inputPrecision, "inputPrecision")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(*this, tblgen_maxNumImpreciseAcc, "maxNumImpreciseAcc")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps5(*this, tblgen_isAsync, "isAsync")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps14(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps15(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps15(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!((std::equal_to<>()((*this->getODSResults(0).begin()).getType(), (*this->getODSOperands(2).begin()).getType()))))
    return emitOpError("failed to verify that result's type matches accumulator's type");
  return ::mlir::success();
}

::llvm::LogicalResult WarpGroupDotOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult WarpGroupDotOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand aRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> aOperands(&aRawOperand, 1);  ::llvm::SMLoc aOperandsLoc;
  (void)aOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand bRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bOperands(&bRawOperand, 1);  ::llvm::SMLoc bOperandsLoc;
  (void)bOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand cRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> cOperands(&cRawOperand, 1);  ::llvm::SMLoc cOperandsLoc;
  (void)cOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> useCOperands;
  ::llvm::SMLoc useCOperandsLoc;
  (void)useCOperandsLoc;
  ::mlir::Type aRawType{};
  ::llvm::ArrayRef<::mlir::Type> aTypes(&aRawType, 1);
  ::mlir::Type bRawType{};
  ::llvm::ArrayRef<::mlir::Type> bTypes(&bRawType, 1);
  ::mlir::Type dRawType{};
  ::llvm::ArrayRef<::mlir::Type> dTypes(&dRawType, 1);

  aOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(aRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  bOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  cOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(cRawOperand))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    useCOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      useCOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::triton::gpu::TensorOrMemDesc type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    aRawType = type;
  }
  if (parser.parseStar())
    return ::mlir::failure();

  if (parser.parseType(bRawType))
    return ::mlir::failure();
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::RankedTensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    dRawType = type;
  }
  for (::mlir::Type type : dTypes) {
    (void)type;
    if (!(((::llvm::isa<::mlir::RankedTensorType>(type))) && ([](::mlir::Type elementType) { return (((::llvm::isa<::mlir::Float8E4M3FNType>(elementType))) || ((::llvm::isa<::mlir::Float8E4M3FNUZType>(elementType))) || ((::llvm::isa<::mlir::Float8E5M2Type>(elementType))) || ((::llvm::isa<::mlir::Float8E5M2FNUZType>(elementType))) || ((elementType.isF16())) || ((::llvm::isa<::mlir::BFloat16Type>(elementType))) || ((elementType.isF32())) || ((elementType.isF64()))) || (((elementType.isSignlessInteger(1))) || ((elementType.isSignlessInteger(4))) || ((elementType.isSignlessInteger(8))) || ((elementType.isSignlessInteger(16))) || ((elementType.isSignlessInteger(32))) || ((elementType.isSignlessInteger(64)))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType())))) {
      return parser.emitError(parser.getNameLoc()) << "'d' must be ranked tensor of floating-point or integer values, but got " << type;
    }
  }
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  result.addTypes(dTypes);
  if (parser.resolveOperands(aOperands, aTypes, aOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(bOperands, bTypes, bOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(cOperands, dTypes[0], cOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(useCOperands, odsBuildableType0, useCOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void WarpGroupDotOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getA();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getB();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getC();
  if (getUseC()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getUseC())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getInputPrecisionAttr();
     if(attr && (attr == ::mlir::triton::InputPrecisionAttr::get(odsBuilder.getContext(), ::mlir::triton::InputPrecision::IEEE)))
       elidedAttrs.push_back("inputPrecision");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getMaxNumImpreciseAccAttr();
     if(attr && (attr == odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), 0)))
       elidedAttrs.push_back("maxNumImpreciseAcc");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getIsAsyncAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("isAsync");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getA().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::gpu::TensorOrMemDesc>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "*";
  _odsPrinter << ' ';
   _odsPrinter << getB().getType();
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getD().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::RankedTensorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::WarpGroupDotOp)

namespace mlir {
namespace triton {
namespace nvidia_gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::nvidia_gpu::WarpGroupDotWaitOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WarpGroupDotWaitOpGenericAdaptorBase::WarpGroupDotWaitOpGenericAdaptorBase(WarpGroupDotWaitOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> WarpGroupDotWaitOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

uint32_t WarpGroupDotWaitOpGenericAdaptorBase::getPendings() {
  auto attr = getPendingsAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
WarpGroupDotWaitOpAdaptor::WarpGroupDotWaitOpAdaptor(WarpGroupDotWaitOp op) : WarpGroupDotWaitOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult WarpGroupDotWaitOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_pendings = getProperties().pendings; (void)tblgen_pendings;
  if (!tblgen_pendings) return emitError(loc, "'ttng.warp_group_dot_wait' op ""requires attribute 'pendings'");

  if (tblgen_pendings && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_pendings))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_pendings).getType().isSignlessInteger(32)))))
    return emitError(loc, "'ttng.warp_group_dot_wait' op ""attribute 'pendings' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> WarpGroupDotWaitOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange WarpGroupDotWaitOp::getInputsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> WarpGroupDotWaitOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::llvm::LogicalResult WarpGroupDotWaitOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.pendings;
       auto attr = dict.get("pendings");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `pendings` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute WarpGroupDotWaitOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.pendings;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("pendings",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code WarpGroupDotWaitOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.pendings.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> WarpGroupDotWaitOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "pendings")
      return prop.pendings;
  return std::nullopt;
}

void WarpGroupDotWaitOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "pendings") {
       prop.pendings = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.pendings)>>(value);
       return;
    }
}

void WarpGroupDotWaitOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.pendings) attrs.append("pendings", prop.pendings);
}

::llvm::LogicalResult WarpGroupDotWaitOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getPendingsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(attr, "pendings", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult WarpGroupDotWaitOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.pendings)))
    return ::mlir::failure();
  return ::mlir::success();
}

void WarpGroupDotWaitOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.pendings);
}

uint32_t WarpGroupDotWaitOp::getPendings() {
  auto attr = getPendingsAttr();
  return attr.getValue().getZExtValue();
}

void WarpGroupDotWaitOp::setPendings(uint32_t attrValue) {
  getProperties().pendings = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void WarpGroupDotWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outputs, ::mlir::ValueRange inputs, ::mlir::IntegerAttr pendings) {
  odsState.addOperands(inputs);
  odsState.getOrAddProperties<Properties>().pendings = pendings;
  odsState.addTypes(outputs);
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange outputs, ::mlir::ValueRange inputs, ::mlir::IntegerAttr pendings) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, outputs, inputs, pendings);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange outputs, ::mlir::ValueRange inputs, ::mlir::IntegerAttr pendings) {
  return create(builder, builder.getLoc(), outputs, inputs, pendings);
}

void WarpGroupDotWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange inputs, ::mlir::IntegerAttr pendings) {
  odsState.addOperands(inputs);
  odsState.getOrAddProperties<Properties>().pendings = pendings;

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(WarpGroupDotWaitOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::mlir::detail::reportFatalInferReturnTypesError(odsState);
        
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange inputs, ::mlir::IntegerAttr pendings) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, inputs, pendings);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange inputs, ::mlir::IntegerAttr pendings) {
  return create(builder, builder.getLoc(), inputs, pendings);
}

void WarpGroupDotWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outputs, ::mlir::ValueRange inputs, uint32_t pendings) {
  odsState.addOperands(inputs);
  odsState.getOrAddProperties<Properties>().pendings = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), pendings);
  odsState.addTypes(outputs);
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange outputs, ::mlir::ValueRange inputs, uint32_t pendings) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, outputs, inputs, pendings);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange outputs, ::mlir::ValueRange inputs, uint32_t pendings) {
  return create(builder, builder.getLoc(), outputs, inputs, pendings);
}

void WarpGroupDotWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange inputs, uint32_t pendings) {
  odsState.addOperands(inputs);
  odsState.getOrAddProperties<Properties>().pendings = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), pendings);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(WarpGroupDotWaitOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::mlir::detail::reportFatalInferReturnTypesError(odsState);
        
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange inputs, uint32_t pendings) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, inputs, pendings);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange inputs, uint32_t pendings) {
  return create(builder, builder.getLoc(), inputs, pendings);
}

void WarpGroupDotWaitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WarpGroupDotWaitOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void WarpGroupDotWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<WarpGroupDotWaitOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(WarpGroupDotWaitOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), operands, attributes);
}

void WarpGroupDotWaitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  odsState.addTypes(resultTypes);
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

void WarpGroupDotWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties &>(properties));
  odsState.addAttributes(discardableAttributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(WarpGroupDotWaitOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<WarpGroupDotWaitOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

WarpGroupDotWaitOp WarpGroupDotWaitOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), operands, properties, discardableAttributes);
}

::llvm::LogicalResult WarpGroupDotWaitOp::verifyInvariantsImpl() {
  auto tblgen_pendings = getProperties().pendings; (void)tblgen_pendings;
  if (!tblgen_pendings) return emitOpError("requires attribute 'pendings'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TritonNvidiaGPUOps1(*this, tblgen_pendings, "pendings")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps16(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TritonNvidiaGPUOps16(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!(((this->getODSOperands(0).getType()) == (this->getODSResults(0).getType()) && (this->getODSResults(0).getType()) == (this->getODSOperands(0).getType()))))
    return emitOpError("failed to verify that all of {inputs, outputs} have same type");
  return ::mlir::success();
}

::llvm::LogicalResult WarpGroupDotWaitOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult WarpGroupDotWaitOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> inputsOperands;
  ::llvm::SMLoc inputsOperandsLoc;
  (void)inputsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> inputsTypes;

  inputsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(inputsOperands))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(inputsTypes))
    return ::mlir::failure();
  if (parser.resolveOperands(inputsOperands, inputsTypes, inputsOperandsLoc, result.operands))
    return ::mlir::failure();

  ::llvm::SmallVector<::mlir::Type> inferredReturnTypes;
  if (::mlir::failed(WarpGroupDotWaitOp::inferReturnTypes(parser.getContext(),
      result.location, result.operands,
      result.attributes.getDictionary(parser.getContext()),
      result.getRawProperties(),
      result.regions, inferredReturnTypes)))
    return ::mlir::failure();
  result.addTypes(inferredReturnTypes);
  return ::mlir::success();
}

void WarpGroupDotWaitOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getInputs();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getInputs().getTypes();
}

} // namespace nvidia_gpu
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::nvidia_gpu::WarpGroupDotWaitOp)


#endif  // GET_OP_CLASSES

