/* Generated by wayland-scanner 1.24.0 */

#ifndef KDE_EXTERNAL_BRIGHTNESS_V1_CLIENT_PROTOCOL_H
#define KDE_EXTERNAL_BRIGHTNESS_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_kde_external_brightness_v1 The kde_external_brightness_v1 protocol
 * @section page_ifaces_kde_external_brightness_v1 Interfaces
 * - @subpage page_iface_kde_external_brightness_v1 - external brightness control
 * - @subpage page_iface_kde_external_brightness_device_v1 - brightness control device
 * @section page_copyright_kde_external_brightness_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 Xaver Hugl <xaver.hugl@gmail.com>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_external_brightness_device_v1;
struct kde_external_brightness_v1;

#ifndef KDE_EXTERNAL_BRIGHTNESS_V1_INTERFACE
#define KDE_EXTERNAL_BRIGHTNESS_V1_INTERFACE
/**
 * @page page_iface_kde_external_brightness_v1 kde_external_brightness_v1
 * @section page_iface_kde_external_brightness_v1_desc Description
 *
 * Some brightness control mechanisms are somewhat unstable, or require root
 * privileges, so putting them inside of the compositor is not desired.
 * This protocol is for outsourcing the actual brightness-setting to a
 * process outside of the compositor.
 * @section page_iface_kde_external_brightness_v1_api API
 * See @ref iface_kde_external_brightness_v1.
 */
/**
 * @defgroup iface_kde_external_brightness_v1 The kde_external_brightness_v1 interface
 *
 * Some brightness control mechanisms are somewhat unstable, or require root
 * privileges, so putting them inside of the compositor is not desired.
 * This protocol is for outsourcing the actual brightness-setting to a
 * process outside of the compositor.
 */
extern const struct wl_interface kde_external_brightness_v1_interface;
#endif
#ifndef KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_INTERFACE
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_INTERFACE
/**
 * @page page_iface_kde_external_brightness_device_v1 kde_external_brightness_device_v1
 * @section page_iface_kde_external_brightness_device_v1_desc Description
 *
 * After creating this object, the client should issue all relevant setup requests
 * (set_internal, set_edid, set_max_brightness, optionally set_observed_brightness)
 * and finish the sequence with commit.
 * Afterwards, for each change in values, the client must call commit again.
 * @section page_iface_kde_external_brightness_device_v1_api API
 * See @ref iface_kde_external_brightness_device_v1.
 */
/**
 * @defgroup iface_kde_external_brightness_device_v1 The kde_external_brightness_device_v1 interface
 *
 * After creating this object, the client should issue all relevant setup requests
 * (set_internal, set_edid, set_max_brightness, optionally set_observed_brightness)
 * and finish the sequence with commit.
 * Afterwards, for each change in values, the client must call commit again.
 */
extern const struct wl_interface kde_external_brightness_device_v1_interface;
#endif

#define KDE_EXTERNAL_BRIGHTNESS_V1_DESTROY 0
#define KDE_EXTERNAL_BRIGHTNESS_V1_CREATE_BRIGHTNESS_CONTROL 1


/**
 * @ingroup iface_kde_external_brightness_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_V1_CREATE_BRIGHTNESS_CONTROL_SINCE_VERSION 1

/** @ingroup iface_kde_external_brightness_v1 */
static inline void
kde_external_brightness_v1_set_user_data(struct kde_external_brightness_v1 *kde_external_brightness_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kde_external_brightness_v1, user_data);
}

/** @ingroup iface_kde_external_brightness_v1 */
static inline void *
kde_external_brightness_v1_get_user_data(struct kde_external_brightness_v1 *kde_external_brightness_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kde_external_brightness_v1);
}

static inline uint32_t
kde_external_brightness_v1_get_version(struct kde_external_brightness_v1 *kde_external_brightness_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_v1);
}

/**
 * @ingroup iface_kde_external_brightness_v1
 */
static inline void
kde_external_brightness_v1_destroy(struct kde_external_brightness_v1 *kde_external_brightness_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_external_brightness_v1,
			 KDE_EXTERNAL_BRIGHTNESS_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_kde_external_brightness_v1
 */
static inline struct kde_external_brightness_device_v1 *
kde_external_brightness_v1_create_brightness_control(struct kde_external_brightness_v1 *kde_external_brightness_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) kde_external_brightness_v1,
			 KDE_EXTERNAL_BRIGHTNESS_V1_CREATE_BRIGHTNESS_CONTROL, &kde_external_brightness_device_v1_interface, wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_v1), 0, NULL);

	return (struct kde_external_brightness_device_v1 *) id;
}

/**
 * @ingroup iface_kde_external_brightness_device_v1
 * @struct kde_external_brightness_device_v1_listener
 */
struct kde_external_brightness_device_v1_listener {
	/**
	 * requests the client to change the brightness to this value
	 *
	 * The client must ensure that if the brightness level changes
	 * due to external factors, that it either overwrites those changes
	 * with what the compositor last requested, or commit again with
	 * set_observed_brightness specifying the changed brightness.
	 * @param value the value to set the device to
	 */
	void (*requested_brightness)(void *data,
				     struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1,
				     uint32_t value);
};

/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
static inline int
kde_external_brightness_device_v1_add_listener(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1,
					       const struct kde_external_brightness_device_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) kde_external_brightness_device_v1,
				     (void (**)(void)) listener, data);
}

#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_DESTROY 0
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_INTERNAL 1
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_EDID 2
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_MAX_BRIGHTNESS 3
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_COMMIT 4
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_OBSERVED_BRIGHTNESS 5
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_USES_DDC_CI 6

/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_REQUESTED_BRIGHTNESS_SINCE_VERSION 1

/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_INTERNAL_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_EDID_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_MAX_BRIGHTNESS_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_OBSERVED_BRIGHTNESS_SINCE_VERSION 2
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_USES_DDC_CI_SINCE_VERSION 3

/** @ingroup iface_kde_external_brightness_device_v1 */
static inline void
kde_external_brightness_device_v1_set_user_data(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kde_external_brightness_device_v1, user_data);
}

/** @ingroup iface_kde_external_brightness_device_v1 */
static inline void *
kde_external_brightness_device_v1_get_user_data(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kde_external_brightness_device_v1);
}

static inline uint32_t
kde_external_brightness_device_v1_get_version(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_device_v1);
}

/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
static inline void
kde_external_brightness_device_v1_destroy(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_external_brightness_device_v1,
			 KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_device_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
static inline void
kde_external_brightness_device_v1_set_internal(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1, uint32_t internal)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_external_brightness_device_v1,
			 KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_INTERNAL, NULL, wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_device_v1), 0, internal);
}

/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
static inline void
kde_external_brightness_device_v1_set_edid(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1, const char *string)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_external_brightness_device_v1,
			 KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_EDID, NULL, wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_device_v1), 0, string);
}

/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
static inline void
kde_external_brightness_device_v1_set_max_brightness(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1, uint32_t value)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_external_brightness_device_v1,
			 KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_MAX_BRIGHTNESS, NULL, wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_device_v1), 0, value);
}

/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
static inline void
kde_external_brightness_device_v1_commit(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_external_brightness_device_v1,
			 KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_device_v1), 0);
}

/**
 * @ingroup iface_kde_external_brightness_device_v1
 *
 * The client can set this to notify the compositor of the device's initial brightness.
 * It can also set this again after the initial commit to notify the compositor that
 * the brightness level has changed due to external factors.
 * The compositor is free to use or ignore this value as it sees fit.
 */
static inline void
kde_external_brightness_device_v1_set_observed_brightness(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1, uint32_t value)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_external_brightness_device_v1,
			 KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_OBSERVED_BRIGHTNESS, NULL, wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_device_v1), 0, value);
}

/**
 * @ingroup iface_kde_external_brightness_device_v1
 *
 * The compositor can use this information to ignore this object if its commands
 * expose monitor issues. The compositor may also reduce the amount of brightness
 * requests given potentially slow response times and concerns about monitor EEPROM
 * longevity/wear-out.
 */
static inline void
kde_external_brightness_device_v1_set_uses_ddc_ci(struct kde_external_brightness_device_v1 *kde_external_brightness_device_v1, uint32_t value)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_external_brightness_device_v1,
			 KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_USES_DDC_CI, NULL, wl_proxy_get_version((struct wl_proxy *) kde_external_brightness_device_v1), 0, value);
}

#ifdef  __cplusplus
}
#endif

#endif
