/*-------------------------------------------------------------------------
 *
 * tab-complete.c
 *    Preprocessed tab-completion code.
 *
 * Portions Copyright (c) 1996-2025, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/bin/psql/gen_tabcomplete.pl
 *
 *-------------------------------------------------------------------------
 */

#define SWITCH_CONVERSION_APPLIED

#line 1 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
/*
 * psql - the PostgreSQL interactive terminal
 *
 * Copyright (c) 2000-2025, PostgreSQL Global Development Group
 *
 * src/bin/psql/tab-complete.in.c
 *
 * Note: this will compile and work as-is if SWITCH_CONVERSION_APPLIED
 * is not defined.  However, the expected usage is that it's first run
 * through gen_tabcomplete.pl, which will #define that symbol, fill in the
 * tcpatterns[] array, and convert the else-if chain in match_previous_words()
 * into a switch.  See comments for match_previous_words() and the header
 * comment in gen_tabcomplete.pl for more detail.
 */

/*----------------------------------------------------------------------
 * This file implements a somewhat more sophisticated readline "TAB
 * completion" in psql. It is not intended to be AI, to replace
 * learning SQL, or to relieve you from thinking about what you're
 * doing. Also it does not always give you all the syntactically legal
 * completions, only those that are the most common or the ones that
 * the programmer felt most like implementing.
 *
 * CAVEAT: Tab completion causes queries to be sent to the backend.
 * The number of tuples returned gets limited, in most default
 * installations to 1000, but if you still don't like this prospect,
 * you can turn off tab completion in your ~/.inputrc (or else
 * ${INPUTRC}) file so:
 *
 *	 $if psql
 *	 set disable-completion on
 *	 $endif
 *
 * See `man 3 readline' or `info readline' for the full details.
 *
 * BUGS:
 * - Quotes, parentheses, and other funny characters are not handled
 *	 all that gracefully.
 *----------------------------------------------------------------------
 */

#include "postgres_fe.h"

#include "input.h"
#include "tab-complete.h"

/* If we don't have this, we might as well forget about the whole thing: */
#ifdef USE_READLINE

#include <ctype.h>
#include <sys/stat.h>

#include "catalog/pg_am_d.h"
#include "catalog/pg_class_d.h"
#include "common.h"
#include "common/keywords.h"
#include "libpq-fe.h"
#include "mb/pg_wchar.h"
#include "pqexpbuffer.h"
#include "settings.h"
#include "stringutils.h"

/*
 * Ancient versions of libedit provide filename_completion_function()
 * instead of rl_filename_completion_function().  Likewise for
 * [rl_]completion_matches().
 */
#ifndef HAVE_RL_FILENAME_COMPLETION_FUNCTION
#define rl_filename_completion_function filename_completion_function
#endif

#ifndef HAVE_RL_COMPLETION_MATCHES
#define rl_completion_matches completion_matches
#endif

/*
 * Currently we assume that rl_filename_dequoting_function exists if
 * rl_filename_quoting_function does.  If that proves not to be the case,
 * we'd need to test for the former, or possibly both, in configure.
 */
#ifdef HAVE_RL_FILENAME_QUOTING_FUNCTION
#define USE_FILENAME_QUOTING_FUNCTIONS 1
#endif

/* word break characters */
#define WORD_BREAKS		"\t\n@><=;|&() "

/*
 * Since readline doesn't let us pass any state through to the tab completion
 * callback, we have to use this global variable to let get_previous_words()
 * get at the previous lines of the current command.  Ick.
 */
PQExpBuffer tab_completion_query_buf = NULL;

/*
 * In some situations, the query to find out what names are available to
 * complete with must vary depending on server version.  We handle this by
 * storing a list of queries, each tagged with the minimum server version
 * it will work for.  Each list must be stored in descending server version
 * order, so that the first satisfactory query is the one to use.
 *
 * When the query string is otherwise constant, an array of VersionedQuery
 * suffices.  Terminate the array with an entry having min_server_version = 0.
 * That entry's query string can be a query that works in all supported older
 * server versions, or NULL to give up and do no completion.
 */
typedef struct VersionedQuery
{
	int			min_server_version;
	const char *query;
} VersionedQuery;

/*
 * This struct is used to define "schema queries", which are custom-built
 * to obtain possibly-schema-qualified names of database objects.  There is
 * enough similarity in the structure that we don't want to repeat it each
 * time.  So we put the components of each query into this struct and
 * assemble them with the common boilerplate in _complete_from_query().
 *
 * We also use this struct to define queries that use completion_ref_object,
 * which is some object related to the one(s) we want to get the names of
 * (for example, the table we want the indexes of).  In that usage the
 * objects we're completing might not have a schema of their own, but the
 * reference object almost always does (passed in completion_ref_schema).
 *
 * As with VersionedQuery, we can use an array of these if the query details
 * must vary across versions.
 */
typedef struct SchemaQuery
{
	/*
	 * If not zero, minimum server version this struct applies to.  If not
	 * zero, there should be a following struct with a smaller minimum server
	 * version; use catname == NULL in the last entry if we should do nothing.
	 */
	int			min_server_version;

	/*
	 * Name of catalog or catalogs to be queried, with alias(es), eg.
	 * "pg_catalog.pg_class c".  Note that "pg_namespace n" and/or
	 * "pg_namespace nr" will be added automatically when needed.
	 */
	const char *catname;

	/*
	 * Selection condition --- only rows meeting this condition are candidates
	 * to display.  If catname mentions multiple tables, include the necessary
	 * join condition here.  For example, this might look like "c.relkind = "
	 * CppAsString2(RELKIND_RELATION).  Write NULL (not an empty string) if
	 * not needed.
	 */
	const char *selcondition;

	/*
	 * Visibility condition --- which rows are visible without schema
	 * qualification?  For example, "pg_catalog.pg_table_is_visible(c.oid)".
	 * NULL if not needed.
	 */
	const char *viscondition;

	/*
	 * Namespace --- name of field to join to pg_namespace.oid when there is
	 * schema qualification.  For example, "c.relnamespace".  NULL if we don't
	 * want to join to pg_namespace (then any schema part in the input word
	 * will be ignored).
	 */
	const char *namespace;

	/*
	 * Result --- the base object name to return.  For example, "c.relname".
	 */
	const char *result;

	/*
	 * In some cases, it's difficult to keep the query from returning the same
	 * object multiple times.  Specify use_distinct to filter out duplicates.
	 */
	bool		use_distinct;

	/*
	 * Additional literal strings (usually keywords) to be offered along with
	 * the query results.  Provide a NULL-terminated array of constant
	 * strings, or NULL if none.
	 */
	const char *const *keywords;

	/*
	 * If this query uses completion_ref_object/completion_ref_schema,
	 * populate the remaining fields, else leave them NULL.  When using this
	 * capability, catname must include the catalog that defines the
	 * completion_ref_object, and selcondition must include the join condition
	 * that connects it to the result's catalog.
	 *
	 * refname is the field that should be equated to completion_ref_object,
	 * for example "cr.relname".
	 */
	const char *refname;

	/*
	 * Visibility condition to use when completion_ref_schema is not set.  For
	 * example, "pg_catalog.pg_table_is_visible(cr.oid)".  NULL if not needed.
	 */
	const char *refviscondition;

	/*
	 * Name of field to join to pg_namespace.oid when completion_ref_schema is
	 * set.  For example, "cr.relnamespace".  NULL if we don't want to
	 * consider completion_ref_schema.
	 */
	const char *refnamespace;
} SchemaQuery;


/* Store maximum number of records we want from database queries
 * (implemented via SELECT ... LIMIT xx).
 */
static int	completion_max_records;

/*
 * Communication variables set by psql_completion (mostly in COMPLETE_WITH_FOO
 * macros) and then used by the completion callback functions.  Ugly but there
 * is no better way.
 */
static char completion_last_char;	/* last char of input word */
static const char *completion_charp;	/* to pass a string */
static const char *const *completion_charpp;	/* to pass a list of strings */
static const VersionedQuery *completion_vquery; /* to pass a VersionedQuery */
static const SchemaQuery *completion_squery;	/* to pass a SchemaQuery */
static char *completion_ref_object; /* name of reference object */
static char *completion_ref_schema; /* schema name of reference object */
static bool completion_case_sensitive;	/* completion is case sensitive */
static bool completion_verbatim;	/* completion is verbatim */
static bool completion_force_quote; /* true to force-quote filenames */

/*
 * A few macros to ease typing. You can use these to complete the given
 * string with
 * 1) The result from a query you pass it. (Perhaps one of those below?)
 *	  We support both simple and versioned queries.
 * 2) The result from a schema query you pass it.
 *	  We support both simple and versioned schema queries.
 * 3) The items from a null-pointer-terminated list (with or without
 *	  case-sensitive comparison); if the list is constant you can build it
 *	  with COMPLETE_WITH() or COMPLETE_WITH_CS().  The QUERY_LIST and
 *	  QUERY_PLUS forms combine such literal lists with a query result.
 * 4) The list of attributes of the given table (possibly schema-qualified).
 * 5) The list of arguments to the given function (possibly schema-qualified).
 *
 * The query is generally expected to return raw SQL identifiers; matching
 * to what the user typed is done in a quoting-aware fashion.  If what is
 * returned is not SQL identifiers, use one of the VERBATIM forms, in which
 * case the query results are matched to the user's text without double-quote
 * processing (so if quoting is needed, you must provide it in the query
 * results).
 */
#define COMPLETE_WITH_QUERY(query) \
	COMPLETE_WITH_QUERY_LIST(query, NULL)

#define COMPLETE_WITH_QUERY_LIST(query, list) \
do { \
	completion_charp = query; \
	completion_charpp = list; \
	completion_verbatim = false; \
	matches = rl_completion_matches(text, complete_from_query); \
} while (0)

#define COMPLETE_WITH_QUERY_PLUS(query, ...) \
do { \
	static const char *const list[] = { __VA_ARGS__, NULL }; \
	COMPLETE_WITH_QUERY_LIST(query, list); \
} while (0)

#define COMPLETE_WITH_QUERY_VERBATIM(query) \
	COMPLETE_WITH_QUERY_VERBATIM_LIST(query, NULL)

#define COMPLETE_WITH_QUERY_VERBATIM_LIST(query, list) \
do { \
	completion_charp = query; \
	completion_charpp = list; \
	completion_verbatim = true; \
	matches = rl_completion_matches(text, complete_from_query); \
} while (0)

#define COMPLETE_WITH_QUERY_VERBATIM_PLUS(query, ...) \
do { \
	static const char *const list[] = { __VA_ARGS__, NULL }; \
	COMPLETE_WITH_QUERY_VERBATIM_LIST(query, list); \
} while (0)

#define COMPLETE_WITH_VERSIONED_QUERY(query) \
	COMPLETE_WITH_VERSIONED_QUERY_LIST(query, NULL)

#define COMPLETE_WITH_VERSIONED_QUERY_LIST(query, list) \
do { \
	completion_vquery = query; \
	completion_charpp = list; \
	completion_verbatim = false; \
	matches = rl_completion_matches(text, complete_from_versioned_query); \
} while (0)

#define COMPLETE_WITH_VERSIONED_QUERY_PLUS(query, ...) \
do { \
	static const char *const list[] = { __VA_ARGS__, NULL }; \
	COMPLETE_WITH_VERSIONED_QUERY_LIST(query, list); \
} while (0)

#define COMPLETE_WITH_SCHEMA_QUERY(query) \
	COMPLETE_WITH_SCHEMA_QUERY_LIST(query, NULL)

#define COMPLETE_WITH_SCHEMA_QUERY_LIST(query, list) \
do { \
	completion_squery = &(query); \
	completion_charpp = list; \
	completion_verbatim = false; \
	matches = rl_completion_matches(text, complete_from_schema_query); \
} while (0)

#define COMPLETE_WITH_SCHEMA_QUERY_PLUS(query, ...) \
do { \
	static const char *const list[] = { __VA_ARGS__, NULL }; \
	COMPLETE_WITH_SCHEMA_QUERY_LIST(query, list); \
} while (0)

#define COMPLETE_WITH_SCHEMA_QUERY_VERBATIM(query) \
do { \
	completion_squery = &(query); \
	completion_charpp = NULL; \
	completion_verbatim = true; \
	matches = rl_completion_matches(text, complete_from_schema_query); \
} while (0)

#define COMPLETE_WITH_VERSIONED_SCHEMA_QUERY(query) \
	COMPLETE_WITH_VERSIONED_SCHEMA_QUERY_LIST(query, NULL)

#define COMPLETE_WITH_VERSIONED_SCHEMA_QUERY_LIST(query, list) \
do { \
	completion_squery = query; \
	completion_charpp = list; \
	completion_verbatim = false; \
	matches = rl_completion_matches(text, complete_from_versioned_schema_query); \
} while (0)

#define COMPLETE_WITH_VERSIONED_SCHEMA_QUERY_PLUS(query, ...) \
do { \
	static const char *const list[] = { __VA_ARGS__, NULL }; \
	COMPLETE_WITH_VERSIONED_SCHEMA_QUERY_LIST(query, list); \
} while (0)

/*
 * Caution: COMPLETE_WITH_CONST is not for general-purpose use; you probably
 * want COMPLETE_WITH() with one element, instead.
 */
#define COMPLETE_WITH_CONST(cs, con) \
do { \
	completion_case_sensitive = (cs); \
	completion_charp = (con); \
	matches = rl_completion_matches(text, complete_from_const); \
} while (0)

#define COMPLETE_WITH_LIST_INT(cs, list) \
do { \
	completion_case_sensitive = (cs); \
	completion_charpp = (list); \
	matches = rl_completion_matches(text, complete_from_list); \
} while (0)

#define COMPLETE_WITH_LIST(list) COMPLETE_WITH_LIST_INT(false, list)
#define COMPLETE_WITH_LIST_CS(list) COMPLETE_WITH_LIST_INT(true, list)

#define COMPLETE_WITH(...) \
do { \
	static const char *const list[] = { __VA_ARGS__, NULL }; \
	COMPLETE_WITH_LIST(list); \
} while (0)

#define COMPLETE_WITH_CS(...) \
do { \
	static const char *const list[] = { __VA_ARGS__, NULL }; \
	COMPLETE_WITH_LIST_CS(list); \
} while (0)

#define COMPLETE_WITH_ATTR(relation) \
	COMPLETE_WITH_ATTR_LIST(relation, NULL)

#define COMPLETE_WITH_ATTR_LIST(relation, list) \
do { \
	set_completion_reference(relation); \
	completion_squery = &(Query_for_list_of_attributes); \
	completion_charpp = list; \
	completion_verbatim = false; \
	matches = rl_completion_matches(text, complete_from_schema_query); \
} while (0)

#define COMPLETE_WITH_ATTR_PLUS(relation, ...) \
do { \
	static const char *const list[] = { __VA_ARGS__, NULL }; \
	COMPLETE_WITH_ATTR_LIST(relation, list); \
} while (0)

/*
 * libedit will typically include the literal's leading single quote in
 * "text", while readline will not.  Adapt our offered strings to fit.
 * But include a quote if there's not one just before "text", to get the
 * user off to the right start.
 */
#define COMPLETE_WITH_ENUM_VALUE(type) \
do { \
	set_completion_reference(type); \
	if (text[0] == '\'' || \
		start == 0 || rl_line_buffer[start - 1] != '\'') \
		completion_squery = &(Query_for_list_of_enum_values_quoted); \
	else \
		completion_squery = &(Query_for_list_of_enum_values_unquoted); \
	completion_charpp = NULL; \
	completion_verbatim = true; \
	matches = rl_completion_matches(text, complete_from_schema_query); \
} while (0)

/*
 * Timezone completion is mostly like enum label completion, but we work
 * a little harder since this is a more common use-case.
 */
#define COMPLETE_WITH_TIMEZONE_NAME() \
do { \
	static const char *const list[] = { "DEFAULT", NULL }; \
	if (text[0] == '\'') \
		completion_charp = Query_for_list_of_timezone_names_quoted_in; \
	else if (start == 0 || rl_line_buffer[start - 1] != '\'') \
		completion_charp = Query_for_list_of_timezone_names_quoted_out; \
	else \
		completion_charp = Query_for_list_of_timezone_names_unquoted; \
	completion_charpp = list;							  \
	completion_verbatim = true; \
	matches = rl_completion_matches(text, complete_from_query); \
} while (0)

#define COMPLETE_WITH_FUNCTION_ARG(function) \
do { \
	set_completion_reference(function); \
	completion_squery = &(Query_for_list_of_arguments); \
	completion_charpp = NULL; \
	completion_verbatim = true; \
	matches = rl_completion_matches(text, complete_from_schema_query); \
} while (0)

/*
 * Assembly instructions for schema queries
 *
 * Note that toast tables are not included in those queries to avoid
 * unnecessary bloat in the completions generated.
 */

static const SchemaQuery Query_for_constraint_of_table = {
	.catname = "pg_catalog.pg_constraint con, pg_catalog.pg_class c1",
	.selcondition = "con.conrelid=c1.oid",
	.result = "con.conname",
	.refname = "c1.relname",
	.refviscondition = "pg_catalog.pg_table_is_visible(c1.oid)",
	.refnamespace = "c1.relnamespace",
};

static const SchemaQuery Query_for_constraint_of_table_not_validated = {
	.catname = "pg_catalog.pg_constraint con, pg_catalog.pg_class c1",
	.selcondition = "con.conrelid=c1.oid and not con.convalidated",
	.result = "con.conname",
	.refname = "c1.relname",
	.refviscondition = "pg_catalog.pg_table_is_visible(c1.oid)",
	.refnamespace = "c1.relnamespace",
};

static const SchemaQuery Query_for_constraint_of_type = {
	.catname = "pg_catalog.pg_constraint con, pg_catalog.pg_type t",
	.selcondition = "con.contypid=t.oid",
	.result = "con.conname",
	.refname = "t.typname",
	.refviscondition = "pg_catalog.pg_type_is_visible(t.oid)",
	.refnamespace = "t.typnamespace",
};

static const SchemaQuery Query_for_index_of_table = {
	.catname = "pg_catalog.pg_class c1, pg_catalog.pg_class c2, pg_catalog.pg_index i",
	.selcondition = "c1.oid=i.indrelid and i.indexrelid=c2.oid",
	.result = "c2.relname",
	.refname = "c1.relname",
	.refviscondition = "pg_catalog.pg_table_is_visible(c1.oid)",
	.refnamespace = "c1.relnamespace",
};

static const SchemaQuery Query_for_unique_index_of_table = {
	.catname = "pg_catalog.pg_class c1, pg_catalog.pg_class c2, pg_catalog.pg_index i",
	.selcondition = "c1.oid=i.indrelid and i.indexrelid=c2.oid and i.indisunique",
	.result = "c2.relname",
	.refname = "c1.relname",
	.refviscondition = "pg_catalog.pg_table_is_visible(c1.oid)",
	.refnamespace = "c1.relnamespace",
};

static const SchemaQuery Query_for_list_of_aggregates[] = {
	{
		.min_server_version = 110000,
		.catname = "pg_catalog.pg_proc p",
		.selcondition = "p.prokind = 'a'",
		.viscondition = "pg_catalog.pg_function_is_visible(p.oid)",
		.namespace = "p.pronamespace",
		.result = "p.proname",
	},
	{
		.catname = "pg_catalog.pg_proc p",
		.selcondition = "p.proisagg",
		.viscondition = "pg_catalog.pg_function_is_visible(p.oid)",
		.namespace = "p.pronamespace",
		.result = "p.proname",
	}
};

static const SchemaQuery Query_for_list_of_arguments = {
	.catname = "pg_catalog.pg_proc p",
	.result = "pg_catalog.oidvectortypes(p.proargtypes)||')'",
	.refname = "p.proname",
	.refviscondition = "pg_catalog.pg_function_is_visible(p.oid)",
	.refnamespace = "p.pronamespace",
};

static const SchemaQuery Query_for_list_of_attributes = {
	.catname = "pg_catalog.pg_attribute a, pg_catalog.pg_class c",
	.selcondition = "c.oid = a.attrelid and a.attnum > 0 and not a.attisdropped",
	.result = "a.attname",
	.refname = "c.relname",
	.refviscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.refnamespace = "c.relnamespace",
};

static const SchemaQuery Query_for_list_of_attribute_numbers = {
	.catname = "pg_catalog.pg_attribute a, pg_catalog.pg_class c",
	.selcondition = "c.oid = a.attrelid and a.attnum > 0 and not a.attisdropped",
	.result = "a.attnum::pg_catalog.text",
	.refname = "c.relname",
	.refviscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.refnamespace = "c.relnamespace",
};

static const char *const Keywords_for_list_of_datatypes[] = {
	"bigint",
	"boolean",
	"character",
	"double precision",
	"integer",
	"real",
	"smallint",

	/*
	 * Note: currently there's no value in offering the following multiword
	 * type names, because tab completion cannot succeed for them: we can't
	 * disambiguate until somewhere in the second word, at which point we
	 * won't have the first word as context.  ("double precision" does work,
	 * as long as no other type name begins with "double".)  Leave them out to
	 * encourage users to use the PG-specific aliases, which we can complete.
	 */
#ifdef NOT_USED
	"bit varying",
	"character varying",
	"time with time zone",
	"time without time zone",
	"timestamp with time zone",
	"timestamp without time zone",
#endif
	NULL
};

static const SchemaQuery Query_for_list_of_datatypes = {
	.catname = "pg_catalog.pg_type t",
	/* selcondition --- ignore table rowtypes and array types */
	.selcondition = "(t.typrelid = 0 "
	" OR (SELECT c.relkind = " CppAsString2(RELKIND_COMPOSITE_TYPE)
	"     FROM pg_catalog.pg_class c WHERE c.oid = t.typrelid)) "
	"AND t.typname !~ '^_'",
	.viscondition = "pg_catalog.pg_type_is_visible(t.oid)",
	.namespace = "t.typnamespace",
	.result = "t.typname",
	.keywords = Keywords_for_list_of_datatypes,
};

static const SchemaQuery Query_for_list_of_composite_datatypes = {
	.catname = "pg_catalog.pg_type t",
	/* selcondition --- only get composite types */
	.selcondition = "(SELECT c.relkind = " CppAsString2(RELKIND_COMPOSITE_TYPE)
	" FROM pg_catalog.pg_class c WHERE c.oid = t.typrelid) "
	"AND t.typname !~ '^_'",
	.viscondition = "pg_catalog.pg_type_is_visible(t.oid)",
	.namespace = "t.typnamespace",
	.result = "t.typname",
};

static const SchemaQuery Query_for_list_of_domains = {
	.catname = "pg_catalog.pg_type t",
	.selcondition = "t.typtype = 'd'",
	.viscondition = "pg_catalog.pg_type_is_visible(t.oid)",
	.namespace = "t.typnamespace",
	.result = "t.typname",
};

static const SchemaQuery Query_for_list_of_enum_values_quoted = {
	.catname = "pg_catalog.pg_enum e, pg_catalog.pg_type t",
	.selcondition = "t.oid = e.enumtypid",
	.result = "pg_catalog.quote_literal(enumlabel)",
	.refname = "t.typname",
	.refviscondition = "pg_catalog.pg_type_is_visible(t.oid)",
	.refnamespace = "t.typnamespace",
};

static const SchemaQuery Query_for_list_of_enum_values_unquoted = {
	.catname = "pg_catalog.pg_enum e, pg_catalog.pg_type t",
	.selcondition = "t.oid = e.enumtypid",
	.result = "e.enumlabel",
	.refname = "t.typname",
	.refviscondition = "pg_catalog.pg_type_is_visible(t.oid)",
	.refnamespace = "t.typnamespace",
};

/* Note: this intentionally accepts aggregates as well as plain functions */
static const SchemaQuery Query_for_list_of_functions[] = {
	{
		.min_server_version = 110000,
		.catname = "pg_catalog.pg_proc p",
		.selcondition = "p.prokind != 'p'",
		.viscondition = "pg_catalog.pg_function_is_visible(p.oid)",
		.namespace = "p.pronamespace",
		.result = "p.proname",
	},
	{
		.catname = "pg_catalog.pg_proc p",
		.viscondition = "pg_catalog.pg_function_is_visible(p.oid)",
		.namespace = "p.pronamespace",
		.result = "p.proname",
	}
};

static const SchemaQuery Query_for_list_of_procedures[] = {
	{
		.min_server_version = 110000,
		.catname = "pg_catalog.pg_proc p",
		.selcondition = "p.prokind = 'p'",
		.viscondition = "pg_catalog.pg_function_is_visible(p.oid)",
		.namespace = "p.pronamespace",
		.result = "p.proname",
	},
	{
		/* not supported in older versions */
		.catname = NULL,
	}
};

static const SchemaQuery Query_for_list_of_routines = {
	.catname = "pg_catalog.pg_proc p",
	.viscondition = "pg_catalog.pg_function_is_visible(p.oid)",
	.namespace = "p.pronamespace",
	.result = "p.proname",
};

static const SchemaQuery Query_for_list_of_sequences = {
	.catname = "pg_catalog.pg_class c",
	.selcondition = "c.relkind IN (" CppAsString2(RELKIND_SEQUENCE) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

static const SchemaQuery Query_for_list_of_foreign_tables = {
	.catname = "pg_catalog.pg_class c",
	.selcondition = "c.relkind IN (" CppAsString2(RELKIND_FOREIGN_TABLE) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

static const SchemaQuery Query_for_list_of_tables = {
	.catname = "pg_catalog.pg_class c",
	.selcondition =
	"c.relkind IN (" CppAsString2(RELKIND_RELATION) ", "
	CppAsString2(RELKIND_PARTITIONED_TABLE) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

static const SchemaQuery Query_for_list_of_partitioned_tables = {
	.catname = "pg_catalog.pg_class c",
	.selcondition = "c.relkind IN (" CppAsString2(RELKIND_PARTITIONED_TABLE) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

static const SchemaQuery Query_for_list_of_tables_for_constraint = {
	.catname = "pg_catalog.pg_class c, pg_catalog.pg_constraint con",
	.selcondition = "c.oid=con.conrelid and c.relkind IN ("
	CppAsString2(RELKIND_RELATION) ", "
	CppAsString2(RELKIND_PARTITIONED_TABLE) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
	.use_distinct = true,
	.refname = "con.conname",
};

static const SchemaQuery Query_for_list_of_tables_for_policy = {
	.catname = "pg_catalog.pg_class c, pg_catalog.pg_policy p",
	.selcondition = "c.oid=p.polrelid",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
	.use_distinct = true,
	.refname = "p.polname",
};

static const SchemaQuery Query_for_list_of_tables_for_rule = {
	.catname = "pg_catalog.pg_class c, pg_catalog.pg_rewrite r",
	.selcondition = "c.oid=r.ev_class",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
	.use_distinct = true,
	.refname = "r.rulename",
};

static const SchemaQuery Query_for_list_of_tables_for_trigger = {
	.catname = "pg_catalog.pg_class c, pg_catalog.pg_trigger t",
	.selcondition = "c.oid=t.tgrelid",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
	.use_distinct = true,
	.refname = "t.tgname",
};

static const SchemaQuery Query_for_list_of_ts_configurations = {
	.catname = "pg_catalog.pg_ts_config c",
	.viscondition = "pg_catalog.pg_ts_config_is_visible(c.oid)",
	.namespace = "c.cfgnamespace",
	.result = "c.cfgname",
};

static const SchemaQuery Query_for_list_of_ts_dictionaries = {
	.catname = "pg_catalog.pg_ts_dict d",
	.viscondition = "pg_catalog.pg_ts_dict_is_visible(d.oid)",
	.namespace = "d.dictnamespace",
	.result = "d.dictname",
};

static const SchemaQuery Query_for_list_of_ts_parsers = {
	.catname = "pg_catalog.pg_ts_parser p",
	.viscondition = "pg_catalog.pg_ts_parser_is_visible(p.oid)",
	.namespace = "p.prsnamespace",
	.result = "p.prsname",
};

static const SchemaQuery Query_for_list_of_ts_templates = {
	.catname = "pg_catalog.pg_ts_template t",
	.viscondition = "pg_catalog.pg_ts_template_is_visible(t.oid)",
	.namespace = "t.tmplnamespace",
	.result = "t.tmplname",
};

static const SchemaQuery Query_for_list_of_views = {
	.catname = "pg_catalog.pg_class c",
	.selcondition = "c.relkind IN (" CppAsString2(RELKIND_VIEW) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

static const SchemaQuery Query_for_list_of_matviews = {
	.catname = "pg_catalog.pg_class c",
	.selcondition = "c.relkind IN (" CppAsString2(RELKIND_MATVIEW) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

static const SchemaQuery Query_for_list_of_indexes = {
	.catname = "pg_catalog.pg_class c",
	.selcondition =
	"c.relkind IN (" CppAsString2(RELKIND_INDEX) ", "
	CppAsString2(RELKIND_PARTITIONED_INDEX) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

static const SchemaQuery Query_for_list_of_partitioned_indexes = {
	.catname = "pg_catalog.pg_class c",
	.selcondition = "c.relkind = " CppAsString2(RELKIND_PARTITIONED_INDEX),
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};


/* All relations */
static const SchemaQuery Query_for_list_of_relations = {
	.catname = "pg_catalog.pg_class c",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

/* partitioned relations */
static const SchemaQuery Query_for_list_of_partitioned_relations = {
	.catname = "pg_catalog.pg_class c",
	.selcondition = "c.relkind IN (" CppAsString2(RELKIND_PARTITIONED_TABLE)
	", " CppAsString2(RELKIND_PARTITIONED_INDEX) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

static const SchemaQuery Query_for_list_of_operator_families = {
	.catname = "pg_catalog.pg_opfamily c",
	.viscondition = "pg_catalog.pg_opfamily_is_visible(c.oid)",
	.namespace = "c.opfnamespace",
	.result = "c.opfname",
};

/* Relations supporting INSERT, UPDATE or DELETE */
static const SchemaQuery Query_for_list_of_updatables = {
	.catname = "pg_catalog.pg_class c",
	.selcondition =
	"c.relkind IN (" CppAsString2(RELKIND_RELATION) ", "
	CppAsString2(RELKIND_FOREIGN_TABLE) ", "
	CppAsString2(RELKIND_VIEW) ", "
	CppAsString2(RELKIND_PARTITIONED_TABLE) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

/* Relations supporting MERGE */
static const SchemaQuery Query_for_list_of_mergetargets = {
	.catname = "pg_catalog.pg_class c",
	.selcondition =
	"c.relkind IN (" CppAsString2(RELKIND_RELATION) ", "
	CppAsString2(RELKIND_VIEW) ", "
	CppAsString2(RELKIND_PARTITIONED_TABLE) ") ",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

/* Relations supporting SELECT */
static const SchemaQuery Query_for_list_of_selectables = {
	.catname = "pg_catalog.pg_class c",
	.selcondition =
	"c.relkind IN (" CppAsString2(RELKIND_RELATION) ", "
	CppAsString2(RELKIND_SEQUENCE) ", "
	CppAsString2(RELKIND_VIEW) ", "
	CppAsString2(RELKIND_MATVIEW) ", "
	CppAsString2(RELKIND_FOREIGN_TABLE) ", "
	CppAsString2(RELKIND_PARTITIONED_TABLE) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

/* Relations supporting TRUNCATE */
static const SchemaQuery Query_for_list_of_truncatables = {
	.catname = "pg_catalog.pg_class c",
	.selcondition =
	"c.relkind IN (" CppAsString2(RELKIND_RELATION) ", "
	CppAsString2(RELKIND_FOREIGN_TABLE) ", "
	CppAsString2(RELKIND_PARTITIONED_TABLE) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

/* Relations supporting GRANT are currently same as those supporting SELECT */
#define Query_for_list_of_grantables Query_for_list_of_selectables

/* Relations supporting ANALYZE */
static const SchemaQuery Query_for_list_of_analyzables = {
	.catname = "pg_catalog.pg_class c",
	.selcondition =
	"c.relkind IN (" CppAsString2(RELKIND_RELATION) ", "
	CppAsString2(RELKIND_PARTITIONED_TABLE) ", "
	CppAsString2(RELKIND_MATVIEW) ", "
	CppAsString2(RELKIND_FOREIGN_TABLE) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

/* Relations supporting index creation */
static const SchemaQuery Query_for_list_of_indexables = {
	.catname = "pg_catalog.pg_class c",
	.selcondition =
	"c.relkind IN (" CppAsString2(RELKIND_RELATION) ", "
	CppAsString2(RELKIND_PARTITIONED_TABLE) ", "
	CppAsString2(RELKIND_MATVIEW) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

/*
 * Relations supporting VACUUM are currently same as those supporting
 * indexing.
 */
#define Query_for_list_of_vacuumables Query_for_list_of_indexables

/* Relations supporting CLUSTER */
static const SchemaQuery Query_for_list_of_clusterables = {
	.catname = "pg_catalog.pg_class c",
	.selcondition =
	"c.relkind IN (" CppAsString2(RELKIND_RELATION) ", "
	CppAsString2(RELKIND_PARTITIONED_TABLE) ", "
	CppAsString2(RELKIND_MATVIEW) ")",
	.viscondition = "pg_catalog.pg_table_is_visible(c.oid)",
	.namespace = "c.relnamespace",
	.result = "c.relname",
};

static const SchemaQuery Query_for_list_of_constraints_with_schema = {
	.catname = "pg_catalog.pg_constraint c",
	.selcondition = "c.conrelid <> 0",
	.namespace = "c.connamespace",
	.result = "c.conname",
};

static const SchemaQuery Query_for_list_of_statistics = {
	.catname = "pg_catalog.pg_statistic_ext s",
	.viscondition = "pg_catalog.pg_statistics_obj_is_visible(s.oid)",
	.namespace = "s.stxnamespace",
	.result = "s.stxname",
};

static const SchemaQuery Query_for_list_of_collations = {
	.catname = "pg_catalog.pg_collation c",
	.selcondition = "c.collencoding IN (-1, pg_catalog.pg_char_to_encoding(pg_catalog.getdatabaseencoding()))",
	.viscondition = "pg_catalog.pg_collation_is_visible(c.oid)",
	.namespace = "c.collnamespace",
	.result = "c.collname",
};

static const SchemaQuery Query_for_partition_of_table = {
	.catname = "pg_catalog.pg_class c1, pg_catalog.pg_class c2, pg_catalog.pg_inherits i",
	.selcondition = "c1.oid=i.inhparent and i.inhrelid=c2.oid and c2.relispartition",
	.viscondition = "pg_catalog.pg_table_is_visible(c2.oid)",
	.namespace = "c2.relnamespace",
	.result = "c2.relname",
	.refname = "c1.relname",
	.refviscondition = "pg_catalog.pg_table_is_visible(c1.oid)",
	.refnamespace = "c1.relnamespace",
};

static const SchemaQuery Query_for_rule_of_table = {
	.catname = "pg_catalog.pg_rewrite r, pg_catalog.pg_class c1",
	.selcondition = "r.ev_class=c1.oid",
	.result = "r.rulename",
	.refname = "c1.relname",
	.refviscondition = "pg_catalog.pg_table_is_visible(c1.oid)",
	.refnamespace = "c1.relnamespace",
};

static const SchemaQuery Query_for_trigger_of_table = {
	.catname = "pg_catalog.pg_trigger t, pg_catalog.pg_class c1",
	.selcondition = "t.tgrelid=c1.oid and not t.tgisinternal",
	.result = "t.tgname",
	.refname = "c1.relname",
	.refviscondition = "pg_catalog.pg_table_is_visible(c1.oid)",
	.refnamespace = "c1.relnamespace",
};


/*
 * Queries to get lists of names of various kinds of things, possibly
 * restricted to names matching a partially entered name.  Don't use
 * this method where the user might wish to enter a schema-qualified
 * name; make a SchemaQuery instead.
 *
 * In these queries, there must be a restriction clause of the form
 *		output LIKE '%s'
 * where "output" is the same string that the query returns.  The %s
 * will be replaced by a LIKE pattern to match the already-typed text.
 *
 * There can be a second '%s', which will be replaced by a suitably-escaped
 * version of the string provided in completion_ref_object.  If there is a
 * third '%s', it will be replaced by a suitably-escaped version of the string
 * provided in completion_ref_schema.  NOTE: using completion_ref_object
 * that way is usually the wrong thing, and using completion_ref_schema
 * that way is always the wrong thing.  Make a SchemaQuery instead.
 */

#define Query_for_list_of_template_databases \
"SELECT d.datname "\
"  FROM pg_catalog.pg_database d "\
" WHERE d.datname LIKE '%s' "\
"   AND (d.datistemplate OR pg_catalog.pg_has_role(d.datdba, 'USAGE'))"

#define Query_for_list_of_databases \
"SELECT datname FROM pg_catalog.pg_database "\
" WHERE datname LIKE '%s'"

#define Query_for_list_of_database_vars \
"SELECT conf FROM ("\
"       SELECT setdatabase, pg_catalog.split_part(pg_catalog.unnest(setconfig),'=',1) conf"\
"         FROM pg_db_role_setting "\
"       ) s, pg_database d "\
" WHERE s.setdatabase = d.oid "\
"   AND conf LIKE '%s'"\
"   AND d.datname LIKE '%s'"

#define Query_for_list_of_tablespaces \
"SELECT spcname FROM pg_catalog.pg_tablespace "\
" WHERE spcname LIKE '%s'"

#define Query_for_list_of_encodings \
" SELECT DISTINCT pg_catalog.pg_encoding_to_char(conforencoding) "\
"   FROM pg_catalog.pg_conversion "\
"  WHERE pg_catalog.pg_encoding_to_char(conforencoding) LIKE pg_catalog.upper('%s')"

#define Query_for_list_of_languages \
"SELECT lanname "\
"  FROM pg_catalog.pg_language "\
" WHERE lanname != 'internal' "\
"   AND lanname LIKE '%s'"

#define Query_for_list_of_schemas \
"SELECT nspname FROM pg_catalog.pg_namespace "\
" WHERE nspname LIKE '%s'"

/* Use COMPLETE_WITH_QUERY_VERBATIM with these queries for GUC names: */
#define Query_for_list_of_alter_system_set_vars \
"SELECT pg_catalog.lower(name) FROM pg_catalog.pg_settings "\
" WHERE context != 'internal' "\
"   AND pg_catalog.lower(name) LIKE pg_catalog.lower('%s')"

#define Query_for_list_of_set_vars \
"SELECT pg_catalog.lower(name) FROM pg_catalog.pg_settings "\
" WHERE context IN ('user', 'superuser') "\
"   AND pg_catalog.lower(name) LIKE pg_catalog.lower('%s')"

#define Query_for_list_of_show_vars \
"SELECT pg_catalog.lower(name) FROM pg_catalog.pg_settings "\
" WHERE pg_catalog.lower(name) LIKE pg_catalog.lower('%s')"

#define Query_for_list_of_roles \
" SELECT rolname "\
"   FROM pg_catalog.pg_roles "\
"  WHERE rolname LIKE '%s'"

/* add these to Query_for_list_of_roles in OWNER contexts */
#define Keywords_for_list_of_owner_roles \
"CURRENT_ROLE", "CURRENT_USER", "SESSION_USER"

/* add these to Query_for_list_of_roles in GRANT contexts */
#define Keywords_for_list_of_grant_roles \
Keywords_for_list_of_owner_roles, "PUBLIC"

#define Query_for_all_table_constraints \
"SELECT conname "\
"  FROM pg_catalog.pg_constraint c "\
" WHERE c.conrelid <> 0 "\
"       and conname LIKE '%s'"

#define Query_for_list_of_fdws \
" SELECT fdwname "\
"   FROM pg_catalog.pg_foreign_data_wrapper "\
"  WHERE fdwname LIKE '%s'"

#define Query_for_list_of_servers \
" SELECT srvname "\
"   FROM pg_catalog.pg_foreign_server "\
"  WHERE srvname LIKE '%s'"

#define Query_for_list_of_user_mappings \
" SELECT usename "\
"   FROM pg_catalog.pg_user_mappings "\
"  WHERE usename LIKE '%s'"

#define Query_for_list_of_user_vars \
"SELECT conf FROM ("\
"       SELECT rolname, pg_catalog.split_part(pg_catalog.unnest(rolconfig),'=',1) conf"\
"         FROM pg_catalog.pg_roles"\
"       ) s"\
"  WHERE s.conf like '%s' "\
"    AND s.rolname LIKE '%s'"

#define Query_for_list_of_access_methods \
" SELECT amname "\
"   FROM pg_catalog.pg_am "\
"  WHERE amname LIKE '%s'"

#define Query_for_list_of_index_access_methods \
" SELECT amname "\
"   FROM pg_catalog.pg_am "\
"  WHERE amname LIKE '%s' AND "\
"   amtype=" CppAsString2(AMTYPE_INDEX)

#define Query_for_list_of_table_access_methods \
" SELECT amname "\
"   FROM pg_catalog.pg_am "\
"  WHERE amname LIKE '%s' AND "\
"   amtype=" CppAsString2(AMTYPE_TABLE)

#define Query_for_list_of_extensions \
" SELECT extname "\
"   FROM pg_catalog.pg_extension "\
"  WHERE extname LIKE '%s'"

#define Query_for_list_of_available_extensions \
" SELECT name "\
"   FROM pg_catalog.pg_available_extensions "\
"  WHERE name LIKE '%s' AND installed_version IS NULL"

#define Query_for_list_of_available_extension_versions \
" SELECT version "\
"   FROM pg_catalog.pg_available_extension_versions "\
"  WHERE version LIKE '%s' AND name='%s'"

#define Query_for_list_of_prepared_statements \
" SELECT name "\
"   FROM pg_catalog.pg_prepared_statements "\
"  WHERE name LIKE '%s'"

#define Query_for_list_of_event_triggers \
" SELECT evtname "\
"   FROM pg_catalog.pg_event_trigger "\
"  WHERE evtname LIKE '%s'"

#define Query_for_list_of_tablesample_methods \
" SELECT proname "\
"   FROM pg_catalog.pg_proc "\
"  WHERE prorettype = 'pg_catalog.tsm_handler'::pg_catalog.regtype AND "\
"        proargtypes[0] = 'pg_catalog.internal'::pg_catalog.regtype AND "\
"        proname LIKE '%s'"

#define Query_for_list_of_policies \
" SELECT polname "\
"   FROM pg_catalog.pg_policy "\
"  WHERE polname LIKE '%s'"

#define Query_for_values_of_enum_GUC \
" SELECT val FROM ( "\
"   SELECT name, pg_catalog.unnest(enumvals) AS val "\
"     FROM pg_catalog.pg_settings "\
"    ) ss "\
"  WHERE val LIKE '%s'"\
"        and pg_catalog.lower(name)=pg_catalog.lower('%s')"

#define Query_for_list_of_channels \
" SELECT channel "\
"   FROM pg_catalog.pg_listening_channels() AS channel "\
"  WHERE channel LIKE '%s'"

#define Query_for_list_of_cursors \
" SELECT name "\
"   FROM pg_catalog.pg_cursors "\
"  WHERE name LIKE '%s'"

#define Query_for_list_of_timezone_names_unquoted \
" SELECT name "\
"   FROM pg_catalog.pg_timezone_names() "\
"  WHERE pg_catalog.lower(name) LIKE pg_catalog.lower('%s')"

#define Query_for_list_of_timezone_names_quoted_out \
"SELECT pg_catalog.quote_literal(name) AS name "\
"  FROM pg_catalog.pg_timezone_names() "\
" WHERE pg_catalog.lower(name) LIKE pg_catalog.lower('%s')"

#define Query_for_list_of_timezone_names_quoted_in \
"SELECT pg_catalog.quote_literal(name) AS name "\
"  FROM pg_catalog.pg_timezone_names() "\
" WHERE pg_catalog.quote_literal(pg_catalog.lower(name)) LIKE pg_catalog.lower('%s')"

/* Privilege options shared between GRANT and REVOKE */
#define Privilege_options_of_grant_and_revoke \
"SELECT", "INSERT", "UPDATE", "DELETE", "TRUNCATE", "REFERENCES", "TRIGGER", \
"CREATE", "CONNECT", "TEMPORARY", "EXECUTE", "USAGE", "SET", "ALTER SYSTEM", \
"MAINTAIN", "ALL"

/* ALTER PROCEDURE options */
#define Alter_procedure_options \
"DEPENDS ON EXTENSION", "EXTERNAL SECURITY", "NO DEPENDS ON EXTENSION", \
"OWNER TO", "RENAME TO", "RESET", "SECURITY", "SET"

/* ALTER ROUTINE options */
#define Alter_routine_options \
Alter_procedure_options, "COST", "IMMUTABLE", "LEAKPROOF", "NOT LEAKPROOF", \
"PARALLEL", "ROWS", "STABLE", "VOLATILE"

/* ALTER FUNCTION options */
#define Alter_function_options \
Alter_routine_options, "CALLED ON NULL INPUT", "RETURNS NULL ON NULL INPUT", \
"STRICT", "SUPPORT"

/* COPY options shared between FROM and TO */
#define Copy_common_options \
"DELIMITER", "ENCODING", "ESCAPE", "FORMAT", "HEADER", "NULL", "QUOTE"

/* COPY FROM options */
#define Copy_from_options \
Copy_common_options, "DEFAULT", "FORCE_NOT_NULL", "FORCE_NULL", "FREEZE", \
"LOG_VERBOSITY", "ON_ERROR", "REJECT_LIMIT"

/* COPY TO options */
#define Copy_to_options \
Copy_common_options, "FORCE_QUOTE"

/*
 * These object types were introduced later than our support cutoff of
 * server version 9.2.  We use the VersionedQuery infrastructure so that
 * we don't send certain-to-fail queries to older servers.
 */

static const VersionedQuery Query_for_list_of_publications[] = {
	{100000,
		" SELECT pubname "
		"   FROM pg_catalog.pg_publication "
		"  WHERE pubname LIKE '%s'"
	},
	{0, NULL}
};

static const VersionedQuery Query_for_list_of_subscriptions[] = {
	{100000,
		" SELECT s.subname "
		"   FROM pg_catalog.pg_subscription s, pg_catalog.pg_database d "
		"  WHERE s.subname LIKE '%s' "
		"    AND d.datname = pg_catalog.current_database() "
		"    AND s.subdbid = d.oid"
	},
	{0, NULL}
};

 /* Known command-starting keywords. */
static const char *const sql_commands[] = {
	"ABORT", "ALTER", "ANALYZE", "BEGIN", "CALL", "CHECKPOINT", "CLOSE", "CLUSTER",
	"COMMENT", "COMMIT", "COPY", "CREATE", "DEALLOCATE", "DECLARE",
	"DELETE FROM", "DISCARD", "DO", "DROP", "END", "EXECUTE", "EXPLAIN",
	"FETCH", "GRANT", "IMPORT FOREIGN SCHEMA", "INSERT INTO", "LISTEN", "LOAD", "LOCK",
	"MERGE INTO", "MOVE", "NOTIFY", "PREPARE",
	"REASSIGN", "REFRESH MATERIALIZED VIEW", "REINDEX", "RELEASE",
	"RESET", "REVOKE", "ROLLBACK",
	"SAVEPOINT", "SECURITY LABEL", "SELECT", "SET", "SHOW", "START",
	"TABLE", "TRUNCATE", "UNLISTEN", "UPDATE", "VACUUM", "VALUES", "WITH",
	NULL
};

/*
 * This is a list of all "things" in Pgsql, which can show up after CREATE or
 * DROP; and there is also a query to get a list of them.
 */

typedef struct
{
	const char *name;
	/* Provide at most one of these three types of query: */
	const char *query;			/* simple query, or NULL */
	const VersionedQuery *vquery;	/* versioned query, or NULL */
	const SchemaQuery *squery;	/* schema query, or NULL */
	const char *const *keywords;	/* keywords to be offered as well */
	const bits32 flags;			/* visibility flags, see below */
} pgsql_thing_t;

#define THING_NO_CREATE		(1 << 0)	/* should not show up after CREATE */
#define THING_NO_DROP		(1 << 1)	/* should not show up after DROP */
#define THING_NO_ALTER		(1 << 2)	/* should not show up after ALTER */
#define THING_NO_SHOW		(THING_NO_CREATE | THING_NO_DROP | THING_NO_ALTER)

/* When we have DROP USER etc, also offer MAPPING FOR */
static const char *const Keywords_for_user_thing[] = {
	"MAPPING FOR",
	NULL
};

static const pgsql_thing_t words_after_create[] = {
	{"ACCESS METHOD", NULL, NULL, NULL, NULL, THING_NO_ALTER},
	{"AGGREGATE", NULL, NULL, Query_for_list_of_aggregates},
	{"CAST", NULL, NULL, NULL}, /* Casts have complex structures for names, so
								 * skip it */
	{"COLLATION", NULL, NULL, &Query_for_list_of_collations},

	/*
	 * CREATE CONSTRAINT TRIGGER is not supported here because it is designed
	 * to be used only by pg_dump.
	 */
	{"CONFIGURATION", NULL, NULL, &Query_for_list_of_ts_configurations, NULL, THING_NO_SHOW},
	{"CONVERSION", "SELECT conname FROM pg_catalog.pg_conversion WHERE conname LIKE '%s'"},
	{"DATABASE", Query_for_list_of_databases},
	{"DEFAULT PRIVILEGES", NULL, NULL, NULL, NULL, THING_NO_CREATE | THING_NO_DROP},
	{"DICTIONARY", NULL, NULL, &Query_for_list_of_ts_dictionaries, NULL, THING_NO_SHOW},
	{"DOMAIN", NULL, NULL, &Query_for_list_of_domains},
	{"EVENT TRIGGER", NULL, NULL, NULL},
	{"EXTENSION", Query_for_list_of_extensions},
	{"FOREIGN DATA WRAPPER", NULL, NULL, NULL},
	{"FOREIGN TABLE", NULL, NULL, NULL},
	{"FUNCTION", NULL, NULL, Query_for_list_of_functions},
	{"GROUP", Query_for_list_of_roles},
	{"INDEX", NULL, NULL, &Query_for_list_of_indexes},
	{"LANGUAGE", Query_for_list_of_languages},
	{"LARGE OBJECT", NULL, NULL, NULL, NULL, THING_NO_CREATE | THING_NO_DROP},
	{"MATERIALIZED VIEW", NULL, NULL, &Query_for_list_of_matviews},
	{"OPERATOR", NULL, NULL, NULL}, /* Querying for this is probably not such
									 * a good idea. */
	{"OR REPLACE", NULL, NULL, NULL, NULL, THING_NO_DROP | THING_NO_ALTER},
	{"OWNED", NULL, NULL, NULL, NULL, THING_NO_CREATE | THING_NO_ALTER},	/* for DROP OWNED BY ... */
	{"PARSER", NULL, NULL, &Query_for_list_of_ts_parsers, NULL, THING_NO_SHOW},
	{"POLICY", NULL, NULL, NULL},
	{"PROCEDURE", NULL, NULL, Query_for_list_of_procedures},
	{"PUBLICATION", NULL, Query_for_list_of_publications},
	{"ROLE", Query_for_list_of_roles},
	{"ROUTINE", NULL, NULL, &Query_for_list_of_routines, NULL, THING_NO_CREATE},
	{"RULE", "SELECT rulename FROM pg_catalog.pg_rules WHERE rulename LIKE '%s'"},
	{"SCHEMA", Query_for_list_of_schemas},
	{"SEQUENCE", NULL, NULL, &Query_for_list_of_sequences},
	{"SERVER", Query_for_list_of_servers},
	{"STATISTICS", NULL, NULL, &Query_for_list_of_statistics},
	{"SUBSCRIPTION", NULL, Query_for_list_of_subscriptions},
	{"SYSTEM", NULL, NULL, NULL, NULL, THING_NO_CREATE | THING_NO_DROP},
	{"TABLE", NULL, NULL, &Query_for_list_of_tables},
	{"TABLESPACE", Query_for_list_of_tablespaces},
	{"TEMP", NULL, NULL, NULL, NULL, THING_NO_DROP | THING_NO_ALTER},	/* for CREATE TEMP TABLE
																		 * ... */
	{"TEMPLATE", NULL, NULL, &Query_for_list_of_ts_templates, NULL, THING_NO_SHOW},
	{"TEMPORARY", NULL, NULL, NULL, NULL, THING_NO_DROP | THING_NO_ALTER},	/* for CREATE TEMPORARY
																			 * TABLE ... */
	{"TEXT SEARCH", NULL, NULL, NULL},
	{"TRANSFORM", NULL, NULL, NULL, NULL, THING_NO_ALTER},
	{"TRIGGER", "SELECT tgname FROM pg_catalog.pg_trigger WHERE tgname LIKE '%s' AND NOT tgisinternal"},
	{"TYPE", NULL, NULL, &Query_for_list_of_datatypes},
	{"UNIQUE", NULL, NULL, NULL, NULL, THING_NO_DROP | THING_NO_ALTER}, /* for CREATE UNIQUE
																		 * INDEX ... */
	{"UNLOGGED", NULL, NULL, NULL, NULL, THING_NO_DROP | THING_NO_ALTER},	/* for CREATE UNLOGGED
																			 * TABLE ... */
	{"USER", Query_for_list_of_roles, NULL, NULL, Keywords_for_user_thing},
	{"USER MAPPING FOR", NULL, NULL, NULL},
	{"VIEW", NULL, NULL, &Query_for_list_of_views},
	{NULL}						/* end of list */
};

/*
 * The tcpatterns[] table provides the initial pattern-match rule for each
 * switch case in match_previous_words().  The contents of the table
 * are constructed by gen_tabcomplete.pl.
 */

/* Basic match rules appearing in tcpatterns[].kind */
enum TCPatternKind
{
	Match,
	MatchCS,
	HeadMatch,
	HeadMatchCS,
	TailMatch,
	TailMatchCS,
};

/* Things besides string literals that can appear in tcpatterns[].words */
#define MatchAny  NULL
#define MatchAnyExcept(pattern)  ("!" pattern)
#define MatchAnyN ""

/* One entry in tcpatterns[] */
typedef struct
{
	int			id;				/* case label used in match_previous_words */
	enum TCPatternKind kind;	/* match kind, see above */
	int			nwords;			/* length of words[] array */
	const char *const *words;	/* array of match words */
} TCPattern;

/* Macro emitted by gen_tabcomplete.pl to fill a tcpatterns[] entry */
#define TCPAT(id, kind, ...) \
	{ (id), (kind), VA_ARGS_NARGS(__VA_ARGS__), \
	  (const char * const []) { __VA_ARGS__ } }

#ifdef SWITCH_CONVERSION_APPLIED

static const TCPattern tcpatterns[] =
{
	TCPAT(1, TailMatch, "CREATE"),
	TCPAT(2, TailMatch, "CREATE", "OR", "REPLACE"),
	TCPAT(3, Match, "DROP"),
	TCPAT(4, Match, "ALTER", "TABLE"),
	TCPAT(5, Match, "ALTER"),
	TCPAT(6, TailMatch, "ALL", "IN", "TABLESPACE", MatchAny),
	TCPAT(7, TailMatch, "ALL", "IN", "TABLESPACE", MatchAny, "OWNED", "BY"),
	TCPAT(8, TailMatch, "ALL", "IN", "TABLESPACE", MatchAny, "OWNED", "BY", MatchAny),
	TCPAT(9, Match, "ALTER", "AGGREGATE|FUNCTION|PROCEDURE|ROUTINE", MatchAny),
	TCPAT(10, Match, "ALTER", "AGGREGATE", MatchAny, MatchAny),
	TCPAT(11, Match, "ALTER", "FUNCTION", MatchAny, MatchAny),
	TCPAT(12, Match, "ALTER", "PROCEDURE", MatchAny, MatchAny),
	TCPAT(13, Match, "ALTER", "ROUTINE", MatchAny, MatchAny),
	TCPAT(14, Match, "ALTER", "FUNCTION|ROUTINE", MatchAny, MatchAny, "PARALLEL"),
	TCPAT(15, Match, "ALTER", "FUNCTION|PROCEDURE|ROUTINE", MatchAny, MatchAny, "SECURITY"),
	TCPAT(15, Match, "ALTER", "FUNCTION|PROCEDURE|ROUTINE", MatchAny, MatchAny, "EXTERNAL", "SECURITY"),
	TCPAT(16, Match, "ALTER", "FUNCTION|PROCEDURE|ROUTINE", MatchAny, MatchAny, "RESET"),
	TCPAT(17, Match, "ALTER", "FUNCTION|PROCEDURE|ROUTINE", MatchAny, MatchAny, "SET"),
	TCPAT(18, Match, "ALTER", "PUBLICATION", MatchAny),
	TCPAT(19, Match, "ALTER", "PUBLICATION", MatchAny, "ADD"),
	TCPAT(20, Match, "ALTER", "PUBLICATION", MatchAny, "ADD|SET", "TABLE"),
	TCPAT(21, HeadMatch, "ALTER", "PUBLICATION", MatchAny, "ADD|SET", "TABLE"),
	TCPAT(22, Match, "ALTER", "PUBLICATION", MatchAny, MatchAnyN, "WHERE"),
	TCPAT(23, Match, "ALTER", "PUBLICATION", MatchAny, MatchAnyN, "WHERE", "("),
	TCPAT(24, HeadMatch, "ALTER", "PUBLICATION", MatchAny, "ADD|SET", "TABLE"),
	TCPAT(25, HeadMatch, "ALTER", "PUBLICATION", MatchAny, "ADD|SET", "TABLE"),
	TCPAT(26, Match, "ALTER", "PUBLICATION", MatchAny, "DROP"),
	TCPAT(27, Match, "ALTER", "PUBLICATION", MatchAny, "SET"),
	TCPAT(28, Match, "ALTER", "PUBLICATION", MatchAny, "ADD|DROP|SET", "TABLES", "IN", "SCHEMA"),
	TCPAT(29, Match, "ALTER", "PUBLICATION", MatchAny, MatchAnyN, "SET", "("),
	TCPAT(30, Match, "ALTER", "SUBSCRIPTION", MatchAny),
	TCPAT(31, Match, "ALTER", "SUBSCRIPTION", MatchAny, MatchAnyN, "REFRESH", "PUBLICATION"),
	TCPAT(32, Match, "ALTER", "SUBSCRIPTION", MatchAny, MatchAnyN, "REFRESH", "PUBLICATION", "WITH", "("),
	TCPAT(33, Match, "ALTER", "SUBSCRIPTION", MatchAny, "SET"),
	TCPAT(34, Match, "ALTER", "SUBSCRIPTION", MatchAny, MatchAnyN, "SET", "("),
	TCPAT(35, Match, "ALTER", "SUBSCRIPTION", MatchAny, MatchAnyN, "SKIP", "("),
	TCPAT(36, Match, "ALTER", "SUBSCRIPTION", MatchAny, MatchAnyN, "SET", "PUBLICATION"),
	TCPAT(37, Match, "ALTER", "SUBSCRIPTION", MatchAny, MatchAnyN, "ADD|DROP|SET", "PUBLICATION", MatchAny),
	TCPAT(38, Match, "ALTER", "SUBSCRIPTION", MatchAny, MatchAnyN, "ADD|DROP|SET", "PUBLICATION", MatchAny, "WITH", "("),
	TCPAT(39, Match, "ALTER", "SCHEMA", MatchAny),
	TCPAT(40, Match, "ALTER", "COLLATION", MatchAny),
	TCPAT(41, Match, "ALTER", "CONVERSION", MatchAny),
	TCPAT(42, Match, "ALTER", "DATABASE", MatchAny),
	TCPAT(43, Match, "ALTER", "DATABASE", MatchAny, "RESET"),
	TCPAT(44, Match, "ALTER", "DATABASE", MatchAny, "SET", "TABLESPACE"),
	TCPAT(45, Match, "ALTER", "EVENT", "TRIGGER"),
	TCPAT(46, Match, "ALTER", "EVENT", "TRIGGER", MatchAny),
	TCPAT(47, Match, "ALTER", "EVENT", "TRIGGER", MatchAny, "ENABLE"),
	TCPAT(48, Match, "ALTER", "EXTENSION", MatchAny),
	TCPAT(49, Match, "ALTER", "EXTENSION", MatchAny, "ADD|DROP"),
	TCPAT(50, Match, "ALTER", "EXTENSION", MatchAny, "ADD|DROP", "FOREIGN"),
	TCPAT(51, Match, "ALTER", "EXTENSION", MatchAny, "ADD|DROP", "OPERATOR"),
	TCPAT(52, Match, "ALTER", "EXTENSION", MatchAny, "ADD|DROP", "TEXT", "SEARCH"),
	TCPAT(53, Match, "ALTER", "EXTENSION", MatchAny, "UPDATE"),
	TCPAT(54, Match, "ALTER", "EXTENSION", MatchAny, "UPDATE", "TO"),
	TCPAT(55, Match, "ALTER", "FOREIGN"),
	TCPAT(56, Match, "ALTER", "FOREIGN", "DATA", "WRAPPER", MatchAny),
	TCPAT(57, Match, "ALTER", "FOREIGN", "DATA", "WRAPPER", MatchAny, "NO"),
	TCPAT(58, Match, "ALTER", "FOREIGN", "TABLE", MatchAny),
	TCPAT(59, Match, "ALTER", "INDEX"),
	TCPAT(60, Match, "ALTER", "INDEX", MatchAny),
	TCPAT(61, Match, "ALTER", "INDEX", MatchAny, "ATTACH"),
	TCPAT(62, Match, "ALTER", "INDEX", MatchAny, "ATTACH", "PARTITION"),
	TCPAT(63, Match, "ALTER", "INDEX", MatchAny, "ALTER"),
	TCPAT(64, Match, "ALTER", "INDEX", MatchAny, "ALTER", "COLUMN"),
	TCPAT(65, Match, "ALTER", "INDEX", MatchAny, "ALTER", "COLUMN", MatchAny),
	TCPAT(66, Match, "ALTER", "INDEX", MatchAny, "ALTER", "COLUMN", MatchAny, "SET"),
	TCPAT(67, Match, "ALTER", "INDEX", MatchAny, "ALTER", "COLUMN", MatchAny, "SET", "STATISTICS"),
	TCPAT(68, Match, "ALTER", "INDEX", MatchAny, "SET"),
	TCPAT(69, Match, "ALTER", "INDEX", MatchAny, "RESET"),
	TCPAT(70, Match, "ALTER", "INDEX", MatchAny, "RESET", "("),
	TCPAT(71, Match, "ALTER", "INDEX", MatchAny, "SET", "("),
	TCPAT(72, Match, "ALTER", "INDEX", MatchAny, "NO", "DEPENDS"),
	TCPAT(73, Match, "ALTER", "INDEX", MatchAny, "DEPENDS"),
	TCPAT(74, Match, "ALTER", "LANGUAGE", MatchAny),
	TCPAT(75, Match, "ALTER", "LARGE", "OBJECT", MatchAny),
	TCPAT(76, Match, "ALTER", "MATERIALIZED", "VIEW"),
	TCPAT(77, Match, "ALTER", "USER|ROLE", MatchAny),
	TCPAT(78, Match, "ALTER", "USER|ROLE", MatchAny, "RESET"),
	TCPAT(79, Match, "ALTER", "USER|ROLE", MatchAny, "WITH"),
	TCPAT(80, Match, "ALTER", "DEFAULT", "PRIVILEGES"),
	TCPAT(81, Match, "ALTER", "DEFAULT", "PRIVILEGES", "FOR"),
	TCPAT(82, Match, "ALTER", "DEFAULT", "PRIVILEGES", "IN"),
	TCPAT(83, Match, "ALTER", "DEFAULT", "PRIVILEGES", "FOR", "ROLE|USER", MatchAny),
	TCPAT(84, Match, "ALTER", "DEFAULT", "PRIVILEGES", "IN", "SCHEMA", MatchAny),
	TCPAT(85, Match, "ALTER", "DEFAULT", "PRIVILEGES", "IN", "SCHEMA", MatchAny, "FOR"),
	TCPAT(86, Match, "ALTER", "DEFAULT", "PRIVILEGES", "FOR", "ROLE|USER", MatchAny, "IN", "SCHEMA", MatchAny),
	TCPAT(86, Match, "ALTER", "DEFAULT", "PRIVILEGES", "IN", "SCHEMA", MatchAny, "FOR", "ROLE|USER", MatchAny),
	TCPAT(87, Match, "ALTER", "DOMAIN", MatchAny),
	TCPAT(88, Match, "ALTER", "DOMAIN", MatchAny, "ADD"),
	TCPAT(89, Match, "ALTER", "DOMAIN", MatchAny, "ADD", "CONSTRAINT", MatchAny),
	TCPAT(90, Match, "ALTER", "DOMAIN", MatchAny, "DROP"),
	TCPAT(91, Match, "ALTER", "DOMAIN", MatchAny, "DROP|RENAME|VALIDATE", "CONSTRAINT"),
	TCPAT(92, Match, "ALTER", "DOMAIN", MatchAny, "RENAME"),
	TCPAT(93, Match, "ALTER", "DOMAIN", MatchAny, "RENAME", "CONSTRAINT", MatchAny),
	TCPAT(94, Match, "ALTER", "DOMAIN", MatchAny, "SET"),
	TCPAT(95, Match, "ALTER", "SEQUENCE", MatchAny),
	TCPAT(96, TailMatch, "ALTER", "SEQUENCE", MatchAny, "AS"),
	TCPAT(97, Match, "ALTER", "SEQUENCE", MatchAny, "NO"),
	TCPAT(98, Match, "ALTER", "SEQUENCE", MatchAny, "SET"),
	TCPAT(99, Match, "ALTER", "SERVER", MatchAny),
	TCPAT(100, Match, "ALTER", "SERVER", MatchAny, "VERSION", MatchAny),
	TCPAT(101, Match, "ALTER", "SYSTEM"),
	TCPAT(102, Match, "ALTER", "SYSTEM", "SET|RESET"),
	TCPAT(103, Match, "ALTER", "SYSTEM", "SET", MatchAny),
	TCPAT(104, Match, "ALTER", "VIEW", MatchAny),
	TCPAT(105, Match, "ALTER", "VIEW", MatchAny, "RENAME"),
	TCPAT(106, Match, "ALTER", "VIEW", MatchAny, "ALTER|RENAME", "COLUMN"),
	TCPAT(107, Match, "ALTER", "VIEW", MatchAny, "ALTER", MatchAny),
	TCPAT(107, Match, "ALTER", "VIEW", MatchAny, "ALTER", "COLUMN", MatchAny),
	TCPAT(108, Match, "ALTER", "VIEW", MatchAny, "RENAME", MatchAnyExcept("TO")),
	TCPAT(109, Match, "ALTER", "VIEW", MatchAny, "RENAME", "COLUMN", MatchAnyExcept("TO")),
	TCPAT(110, Match, "ALTER", "VIEW", MatchAny, "RESET"),
	TCPAT(111, Match, "ALTER", "VIEW", MatchAny, "SET"),
	TCPAT(112, Match, "ALTER", "VIEW", MatchAny, "SET|RESET", "("),
	TCPAT(113, Match, "ALTER", "VIEW", MatchAny, "SET", "(", MatchAny),
	TCPAT(114, Match, "ALTER", "VIEW", MatchAny, "SET", "(", "check_option", "="),
	TCPAT(115, Match, "ALTER", "VIEW", MatchAny, "SET", "(", "security_barrier|security_invoker", "="),
	TCPAT(116, Match, "ALTER", "MATERIALIZED", "VIEW", MatchAny),
	TCPAT(117, Match, "ALTER", "MATERIALIZED", "VIEW", MatchAny, "RENAME"),
	TCPAT(118, Match, "ALTER", "MATERIALIZED", "VIEW", MatchAny, "ALTER|RENAME", "COLUMN"),
	TCPAT(119, Match, "ALTER", "MATERIALIZED", "VIEW", MatchAny, "RENAME", MatchAnyExcept("TO")),
	TCPAT(120, Match, "ALTER", "MATERIALIZED", "VIEW", MatchAny, "RENAME", "COLUMN", MatchAnyExcept("TO")),
	TCPAT(121, Match, "ALTER", "MATERIALIZED", "VIEW", MatchAny, "SET"),
	TCPAT(122, Match, "ALTER", "MATERIALIZED", "VIEW", MatchAny, "SET", "ACCESS", "METHOD"),
	TCPAT(123, Match, "ALTER", "POLICY"),
	TCPAT(124, Match, "ALTER", "POLICY", MatchAny),
	TCPAT(125, Match, "ALTER", "POLICY", MatchAny, "ON"),
	TCPAT(126, Match, "ALTER", "POLICY", MatchAny, "ON", MatchAny),
	TCPAT(127, Match, "ALTER", "POLICY", MatchAny, "ON", MatchAny, "TO"),
	TCPAT(128, Match, "ALTER", "POLICY", MatchAny, "ON", MatchAny, "USING"),
	TCPAT(129, Match, "ALTER", "POLICY", MatchAny, "ON", MatchAny, "WITH", "CHECK"),
	TCPAT(130, Match, "ALTER", "RULE", MatchAny),
	TCPAT(131, Match, "ALTER", "RULE", MatchAny, "ON"),
	TCPAT(132, Match, "ALTER", "RULE", MatchAny, "ON", MatchAny),
	TCPAT(133, Match, "ALTER", "STATISTICS", MatchAny),
	TCPAT(134, Match, "ALTER", "STATISTICS", MatchAny, "SET"),
	TCPAT(135, Match, "ALTER", "TRIGGER", MatchAny),
	TCPAT(136, Match, "ALTER", "TRIGGER", MatchAny, "ON"),
	TCPAT(137, Match, "ALTER", "TRIGGER", MatchAny, "ON", MatchAny),
	TCPAT(138, Match, "ALTER", "TABLE", MatchAny),
	TCPAT(139, Match, "ALTER", "TABLE", MatchAny, "ADD"),
	TCPAT(140, Match, "ALTER", "TABLE", MatchAny, "ADD", "COLUMN", MatchAny),
	TCPAT(140, Match, "ALTER", "TABLE", MatchAny, "ADD", MatchAnyExcept("COLUMN|CONSTRAINT|CHECK|UNIQUE|PRIMARY|EXCLUDE|FOREIGN")),
	TCPAT(141, Match, "ALTER", "TABLE", MatchAny, "ADD", "CONSTRAINT", MatchAny),
	TCPAT(142, Match, "ALTER", "TABLE", MatchAny, "ADD", "PRIMARY", "KEY"),
	TCPAT(142, Match, "ALTER", "TABLE", MatchAny, "ADD", "UNIQUE"),
	TCPAT(142, Match, "ALTER", "TABLE", MatchAny, "ADD", "CONSTRAINT", MatchAny, "PRIMARY", "KEY"),
	TCPAT(142, Match, "ALTER", "TABLE", MatchAny, "ADD", "CONSTRAINT", MatchAny, "UNIQUE"),
	TCPAT(143, Match, "ALTER", "TABLE", MatchAny, "ADD", "PRIMARY", "KEY", "USING", "INDEX"),
	TCPAT(144, Match, "ALTER", "TABLE", MatchAny, "ADD", "UNIQUE", "USING", "INDEX"),
	TCPAT(145, Match, "ALTER", "TABLE", MatchAny, "ADD", "CONSTRAINT", MatchAny, "PRIMARY", "KEY", "USING", "INDEX"),
	TCPAT(146, Match, "ALTER", "TABLE", MatchAny, "ADD", "CONSTRAINT", MatchAny, "UNIQUE", "USING", "INDEX"),
	TCPAT(147, Match, "ALTER", "TABLE", MatchAny, "ENABLE"),
	TCPAT(148, Match, "ALTER", "TABLE", MatchAny, "ENABLE", "REPLICA|ALWAYS"),
	TCPAT(149, Match, "ALTER", "TABLE", MatchAny, "ENABLE", "RULE"),
	TCPAT(150, Match, "ALTER", "TABLE", MatchAny, "ENABLE", MatchAny, "RULE"),
	TCPAT(151, Match, "ALTER", "TABLE", MatchAny, "ENABLE", "TRIGGER"),
	TCPAT(152, Match, "ALTER", "TABLE", MatchAny, "ENABLE", MatchAny, "TRIGGER"),
	TCPAT(153, Match, "ALTER", "TABLE", MatchAny, "INHERIT"),
	TCPAT(154, Match, "ALTER", "TABLE", MatchAny, "NO"),
	TCPAT(155, Match, "ALTER", "TABLE", MatchAny, "NO", "INHERIT"),
	TCPAT(156, Match, "ALTER", "TABLE", MatchAny, "DISABLE"),
	TCPAT(157, Match, "ALTER", "TABLE", MatchAny, "DISABLE", "RULE"),
	TCPAT(158, Match, "ALTER", "TABLE", MatchAny, "DISABLE", "TRIGGER"),
	TCPAT(159, Match, "ALTER", "TABLE", MatchAny, "ALTER"),
	TCPAT(160, Match, "ALTER", "TABLE", MatchAny, "RENAME"),
	TCPAT(161, Match, "ALTER", "TABLE", MatchAny, "ALTER|RENAME", "COLUMN"),
	TCPAT(162, Match, "ALTER", "TABLE", MatchAny, "RENAME", MatchAnyExcept("CONSTRAINT|TO")),
	TCPAT(163, Match, "ALTER", "TABLE", MatchAny, "RENAME", "COLUMN|CONSTRAINT", MatchAnyExcept("TO")),
	TCPAT(164, Match, "ALTER", "TABLE", MatchAny, "DROP"),
	TCPAT(165, Match, "ALTER", "TABLE", MatchAny, "DROP", "COLUMN"),
	TCPAT(166, Match, "ALTER", "TABLE", MatchAny, "ALTER|DROP|RENAME", "CONSTRAINT"),
	TCPAT(167, Match, "ALTER", "TABLE", MatchAny, "VALIDATE", "CONSTRAINT"),
	TCPAT(168, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny),
	TCPAT(168, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny),
	TCPAT(169, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "ADD"),
	TCPAT(169, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "ADD"),
	TCPAT(170, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "ADD", "GENERATED"),
	TCPAT(170, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "ADD", "GENERATED"),
	TCPAT(171, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "ADD", "GENERATED", "ALWAYS"),
	TCPAT(171, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "ADD", "GENERATED", "ALWAYS"),
	TCPAT(171, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "ADD", "GENERATED", "BY", "DEFAULT"),
	TCPAT(171, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "ADD", "GENERATED", "BY", "DEFAULT"),
	TCPAT(172, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "SET"),
	TCPAT(172, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "SET"),
	TCPAT(173, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "SET", "("),
	TCPAT(173, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "SET", "("),
	TCPAT(174, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "SET", "COMPRESSION"),
	TCPAT(174, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "SET", "COMPRESSION"),
	TCPAT(175, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "SET", "EXPRESSION"),
	TCPAT(175, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "SET", "EXPRESSION"),
	TCPAT(176, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "SET", "EXPRESSION", "AS"),
	TCPAT(176, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "SET", "EXPRESSION", "AS"),
	TCPAT(177, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "SET", "GENERATED"),
	TCPAT(177, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "SET", "GENERATED"),
	TCPAT(178, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "SET", "NO"),
	TCPAT(178, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "SET", "NO"),
	TCPAT(179, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "SET", "STORAGE"),
	TCPAT(179, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "SET", "STORAGE"),
	TCPAT(180, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "SET", "STATISTICS"),
	TCPAT(180, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "SET", "STATISTICS"),
	TCPAT(181, Match, "ALTER", "TABLE", MatchAny, "ALTER", "COLUMN", MatchAny, "DROP"),
	TCPAT(181, Match, "ALTER", "TABLE", MatchAny, "ALTER", MatchAny, "DROP"),
	TCPAT(182, Match, "ALTER", "TABLE", MatchAny, "CLUSTER"),
	TCPAT(183, Match, "ALTER", "TABLE", MatchAny, "CLUSTER", "ON"),
	TCPAT(184, Match, "ALTER", "TABLE", MatchAny, "SET"),
	TCPAT(185, Match, "ALTER", "TABLE", MatchAny, "SET", "ACCESS", "METHOD"),
	TCPAT(186, Match, "ALTER", "TABLE", MatchAny, "SET", "TABLESPACE"),
	TCPAT(187, Match, "ALTER", "TABLE", MatchAny, "SET", "WITHOUT"),
	TCPAT(188, Match, "ALTER", "TABLE", MatchAny, "RESET"),
	TCPAT(189, Match, "ALTER", "TABLE", MatchAny, "SET|RESET", "("),
	TCPAT(190, Match, "ALTER", "TABLE", MatchAny, "REPLICA", "IDENTITY", "USING", "INDEX"),
	TCPAT(191, Match, "ALTER", "TABLE", MatchAny, "REPLICA", "IDENTITY", "USING"),
	TCPAT(192, Match, "ALTER", "TABLE", MatchAny, "REPLICA", "IDENTITY"),
	TCPAT(193, Match, "ALTER", "TABLE", MatchAny, "REPLICA"),
	TCPAT(194, Match, "ALTER", "TABLE", MatchAny, "ATTACH", "PARTITION"),
	TCPAT(195, TailMatch, "ATTACH", "PARTITION", MatchAny),
	TCPAT(196, TailMatch, "FOR", "VALUES"),
	TCPAT(197, Match, "ALTER", "TABLE", MatchAny, "DETACH", "PARTITION"),
	TCPAT(198, Match, "ALTER", "TABLE", MatchAny, "DETACH", "PARTITION", MatchAny),
	TCPAT(199, Match, "ALTER", "TABLE", MatchAny, "OF"),
	TCPAT(200, Match, "ALTER", "TABLESPACE", MatchAny),
	TCPAT(201, Match, "ALTER", "TABLESPACE", MatchAny, "SET|RESET"),
	TCPAT(202, Match, "ALTER", "TABLESPACE", MatchAny, "SET|RESET", "("),
	TCPAT(203, Match, "ALTER", "TEXT", "SEARCH"),
	TCPAT(204, Match, "ALTER", "TEXT", "SEARCH", "TEMPLATE|PARSER", MatchAny),
	TCPAT(205, Match, "ALTER", "TEXT", "SEARCH", "DICTIONARY", MatchAny),
	TCPAT(206, Match, "ALTER", "TEXT", "SEARCH", "CONFIGURATION", MatchAny),
	TCPAT(207, Match, "ALTER", "TYPE", MatchAny),
	TCPAT(208, Match, "ALTER", "TYPE", MatchAny, "ADD"),
	TCPAT(209, Match, "ALTER", "TYPE", MatchAny, "RENAME"),
	TCPAT(210, Match, "ALTER", "TYPE", MatchAny, "RENAME", "ATTRIBUTE|VALUE", MatchAny),
	TCPAT(211, Match, "ALTER", "TYPE", MatchAny, "RENAME", "ATTRIBUTE", MatchAny, "TO", MatchAny),
	TCPAT(212, Match, "ALTER", "TYPE", MatchAny, "ALTER|DROP|RENAME", "ATTRIBUTE"),
	TCPAT(213, Match, "ALTER", "TYPE", MatchAny, "ADD", "ATTRIBUTE", MatchAny),
	TCPAT(214, Match, "ALTER", "TYPE", MatchAny, "ADD", "ATTRIBUTE", MatchAny, MatchAny),
	TCPAT(215, Match, "ALTER", "TYPE", MatchAny, "DROP", "ATTRIBUTE", MatchAny),
	TCPAT(216, Match, "ALTER", "TYPE", MatchAny, "ALTER", "ATTRIBUTE", MatchAny),
	TCPAT(217, Match, "ALTER", "TYPE", MatchAny, "ALTER", "ATTRIBUTE", MatchAny, "TYPE", MatchAny),
	TCPAT(218, Match, "ALTER", "TYPE", MatchAny, "RENAME", "VALUE"),
	TCPAT(219, Match, "ALTER", "TYPE", MatchAny, "SET"),
	TCPAT(220, Match, "ALTER", "TYPE", MatchAny, "SET", "("),
	TCPAT(221, Match, "ALTER", "GROUP", MatchAny),
	TCPAT(222, Match, "ALTER", "GROUP", MatchAny, "ADD|DROP"),
	TCPAT(223, Match, "ALTER", "GROUP", MatchAny, "ADD|DROP", "USER"),
	TCPAT(224, Match, "ANALYZE"),
	TCPAT(225, Match, "ANALYZE", "VERBOSE"),
	TCPAT(226, HeadMatch, "ANALYZE", "(*"),
	TCPAT(227, Match, "ANALYZE", "(*)"),
	TCPAT(228, Match, "ANALYZE", MatchAnyN, "("),
	TCPAT(229, HeadMatch, "ANALYZE"),
	TCPAT(230, Match, "BEGIN"),
	TCPAT(231, Match, "END|ABORT"),
	TCPAT(232, Match, "COMMIT"),
	TCPAT(233, Match, "RELEASE"),
	TCPAT(234, Match, "ROLLBACK"),
	TCPAT(235, Match, "ABORT|END|COMMIT|ROLLBACK", "AND"),
	TCPAT(236, Match, "CALL"),
	TCPAT(237, Match, "CALL", MatchAny),
	TCPAT(238, Match, "CLOSE"),
	TCPAT(239, Match, "CLUSTER"),
	TCPAT(240, Match, "CLUSTER", "VERBOSE"),
	TCPAT(240, Match, "CLUSTER", "(*)"),
	TCPAT(241, Match, "CLUSTER", MatchAnyExcept("VERBOSE|ON|(|(*)")),
	TCPAT(242, Match, "CLUSTER", "VERBOSE|(*)", MatchAny),
	TCPAT(243, Match, "CLUSTER", MatchAny, "USING"),
	TCPAT(243, Match, "CLUSTER", "VERBOSE|(*)", MatchAny, "USING"),
	TCPAT(244, HeadMatch, "CLUSTER", "(*"),
	TCPAT(245, Match, "COMMENT"),
	TCPAT(246, Match, "COMMENT", "ON"),
	TCPAT(247, Match, "COMMENT", "ON", "ACCESS", "METHOD"),
	TCPAT(248, Match, "COMMENT", "ON", "CONSTRAINT"),
	TCPAT(249, Match, "COMMENT", "ON", "CONSTRAINT", MatchAny),
	TCPAT(250, Match, "COMMENT", "ON", "CONSTRAINT", MatchAny, "ON"),
	TCPAT(251, Match, "COMMENT", "ON", "CONSTRAINT", MatchAny, "ON", "DOMAIN"),
	TCPAT(252, Match, "COMMENT", "ON", "EVENT", "TRIGGER"),
	TCPAT(253, Match, "COMMENT", "ON", "FOREIGN"),
	TCPAT(254, Match, "COMMENT", "ON", "FOREIGN", "TABLE"),
	TCPAT(255, Match, "COMMENT", "ON", "MATERIALIZED", "VIEW"),
	TCPAT(256, Match, "COMMENT", "ON", "POLICY"),
	TCPAT(257, Match, "COMMENT", "ON", "POLICY", MatchAny),
	TCPAT(258, Match, "COMMENT", "ON", "POLICY", MatchAny, "ON"),
	TCPAT(259, Match, "COMMENT", "ON", "PROCEDURAL", "LANGUAGE"),
	TCPAT(260, Match, "COMMENT", "ON", "RULE", MatchAny),
	TCPAT(261, Match, "COMMENT", "ON", "RULE", MatchAny, "ON"),
	TCPAT(262, Match, "COMMENT", "ON", "TEXT", "SEARCH"),
	TCPAT(263, Match, "COMMENT", "ON", "TEXT", "SEARCH", "CONFIGURATION"),
	TCPAT(264, Match, "COMMENT", "ON", "TEXT", "SEARCH", "DICTIONARY"),
	TCPAT(265, Match, "COMMENT", "ON", "TEXT", "SEARCH", "PARSER"),
	TCPAT(266, Match, "COMMENT", "ON", "TEXT", "SEARCH", "TEMPLATE"),
	TCPAT(267, Match, "COMMENT", "ON", "TRANSFORM", "FOR"),
	TCPAT(268, Match, "COMMENT", "ON", "TRANSFORM", "FOR", MatchAny),
	TCPAT(269, Match, "COMMENT", "ON", "TRANSFORM", "FOR", MatchAny, "LANGUAGE"),
	TCPAT(270, Match, "COMMENT", "ON", "TRIGGER", MatchAny),
	TCPAT(271, Match, "COMMENT", "ON", "TRIGGER", MatchAny, "ON"),
	TCPAT(272, Match, "COMMENT", "ON", MatchAny, MatchAnyExcept("IS")),
	TCPAT(272, Match, "COMMENT", "ON", MatchAny, MatchAny, MatchAnyExcept("IS")),
	TCPAT(272, Match, "COMMENT", "ON", MatchAny, MatchAny, MatchAny, MatchAnyExcept("IS")),
	TCPAT(272, Match, "COMMENT", "ON", MatchAny, MatchAny, MatchAny, MatchAny, MatchAnyExcept("IS")),
	TCPAT(273, Match, "COPY|\\copy"),
	TCPAT(274, Match, "COPY|\\copy", "("),
	TCPAT(275, Match, "COPY|\\copy", MatchAny),
	TCPAT(276, Match, "COPY", MatchAny, "FROM|TO"),
	TCPAT(277, Match, "\\copy", MatchAny, "FROM|TO"),
	TCPAT(278, Match, "COPY|\\copy", MatchAny, "TO", MatchAny),
	TCPAT(279, Match, "COPY|\\copy", MatchAny, "FROM", MatchAny),
	TCPAT(280, Match, "COPY|\\copy", MatchAny, "FROM", MatchAny, "WITH", "("),
	TCPAT(281, Match, "COPY|\\copy", MatchAny, "TO", MatchAny, "WITH", "("),
	TCPAT(282, Match, "COPY|\\copy", MatchAny, "FROM|TO", MatchAny, "WITH", "(", "FORMAT"),
	TCPAT(283, Match, "COPY|\\copy", MatchAny, "FROM", MatchAny, "WITH", "(", "ON_ERROR"),
	TCPAT(284, Match, "COPY|\\copy", MatchAny, "FROM", MatchAny, "WITH", "(", "LOG_VERBOSITY"),
	TCPAT(285, Match, "COPY|\\copy", MatchAny, "FROM", MatchAny, "WITH", MatchAny),
	TCPAT(286, Match, "CREATE", "ACCESS", "METHOD", MatchAny),
	TCPAT(287, Match, "CREATE", "ACCESS", "METHOD", MatchAny, "TYPE"),
	TCPAT(288, Match, "CREATE", "ACCESS", "METHOD", MatchAny, "TYPE", MatchAny),
	TCPAT(289, Match, "CREATE", "COLLATION", MatchAny),
	TCPAT(290, Match, "CREATE", "COLLATION", MatchAny, "FROM"),
	TCPAT(291, HeadMatch, "CREATE", "COLLATION", MatchAny, "(*"),
	TCPAT(292, Match, "CREATE", "DATABASE", MatchAny),
	TCPAT(293, Match, "CREATE", "DATABASE", MatchAny, "TEMPLATE"),
	TCPAT(294, Match, "CREATE", "DATABASE", MatchAny, "STRATEGY"),
	TCPAT(295, Match, "CREATE", "DOMAIN", MatchAny),
	TCPAT(296, Match, "CREATE", "DOMAIN", MatchAny, "AS"),
	TCPAT(297, Match, "CREATE", "DOMAIN", MatchAny, "AS", MatchAny),
	TCPAT(298, Match, "CREATE", "DOMAIN", MatchAny, "COLLATE"),
	TCPAT(299, Match, "CREATE", "EXTENSION"),
	TCPAT(300, Match, "CREATE", "EXTENSION", MatchAny),
	TCPAT(301, Match, "CREATE", "EXTENSION", MatchAny, "VERSION"),
	TCPAT(302, Match, "CREATE", "FOREIGN"),
	TCPAT(303, Match, "CREATE", "FOREIGN", "DATA", "WRAPPER", MatchAny),
	TCPAT(304, Match, "CREATE", "FOREIGN", "TABLE", MatchAny),
	TCPAT(305, TailMatch, "CREATE", "UNIQUE"),
	TCPAT(306, TailMatch, "CREATE|UNIQUE", "INDEX"),
	TCPAT(307, TailMatch, "INDEX|CONCURRENTLY", MatchAny, "ON"),
	TCPAT(307, TailMatch, "INDEX|CONCURRENTLY", "ON"),
	TCPAT(308, TailMatch, "CREATE|UNIQUE", "INDEX", "CONCURRENTLY"),
	TCPAT(309, TailMatch, "CREATE|UNIQUE", "INDEX", MatchAny),
	TCPAT(309, TailMatch, "CREATE|UNIQUE", "INDEX", "CONCURRENTLY", MatchAny),
	TCPAT(310, TailMatch, "INDEX", MatchAny, "ON", MatchAny),
	TCPAT(310, TailMatch, "INDEX|CONCURRENTLY", "ON", MatchAny),
	TCPAT(311, TailMatch, "INDEX", MatchAny, "ON", MatchAny, "("),
	TCPAT(311, TailMatch, "INDEX|CONCURRENTLY", "ON", MatchAny, "("),
	TCPAT(312, TailMatch, "ON", MatchAny, "USING", MatchAny, "("),
	TCPAT(313, TailMatch, "INDEX", MatchAny, MatchAny, "ON", MatchAny, "USING"),
	TCPAT(313, TailMatch, "INDEX", MatchAny, "ON", MatchAny, "USING"),
	TCPAT(313, TailMatch, "INDEX", "ON", MatchAny, "USING"),
	TCPAT(314, TailMatch, "ON", MatchAny, "USING", MatchAny),
	TCPAT(315, Match, "CREATE", "OR"),
	TCPAT(316, Match, "CREATE", "POLICY", MatchAny),
	TCPAT(317, Match, "CREATE", "POLICY", MatchAny, "ON"),
	TCPAT(318, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny),
	TCPAT(319, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "AS"),
	TCPAT(320, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "AS", MatchAny),
	TCPAT(321, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "FOR"),
	TCPAT(322, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "FOR", "INSERT"),
	TCPAT(323, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "FOR", "SELECT|DELETE"),
	TCPAT(324, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "FOR", "ALL|UPDATE"),
	TCPAT(325, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "TO"),
	TCPAT(326, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "USING"),
	TCPAT(327, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "AS", MatchAny, "FOR"),
	TCPAT(328, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "AS", MatchAny, "FOR", "INSERT"),
	TCPAT(329, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "AS", MatchAny, "FOR", "SELECT|DELETE"),
	TCPAT(330, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "AS", MatchAny, "FOR", "ALL|UPDATE"),
	TCPAT(331, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "AS", MatchAny, "TO"),
	TCPAT(332, Match, "CREATE", "POLICY", MatchAny, "ON", MatchAny, "AS", MatchAny, "USING"),
	TCPAT(333, Match, "CREATE", "PUBLICATION", MatchAny),
	TCPAT(334, Match, "CREATE", "PUBLICATION", MatchAny, "FOR"),
	TCPAT(335, Match, "CREATE", "PUBLICATION", MatchAny, "FOR", "ALL"),
	TCPAT(336, Match, "CREATE", "PUBLICATION", MatchAny, "FOR", "ALL", "TABLES"),
	TCPAT(337, Match, "CREATE", "PUBLICATION", MatchAny, "FOR", "TABLES"),
	TCPAT(338, Match, "CREATE", "PUBLICATION", MatchAny, "FOR", "TABLE", MatchAny),
	TCPAT(339, Match, "CREATE", "PUBLICATION", MatchAny, "FOR", "TABLE"),
	TCPAT(340, Match, "CREATE", "PUBLICATION", MatchAny, MatchAnyN, "WHERE"),
	TCPAT(341, Match, "CREATE", "PUBLICATION", MatchAny, MatchAnyN, "WHERE", "("),
	TCPAT(342, Match, "CREATE", "PUBLICATION", MatchAny, MatchAnyN, "WHERE", "(*)"),
	TCPAT(343, Match, "CREATE", "PUBLICATION", MatchAny, "FOR", "TABLES", "IN", "SCHEMA"),
	TCPAT(344, Match, "CREATE", "PUBLICATION", MatchAny, "FOR", "TABLES", "IN", "SCHEMA", MatchAny),
	TCPAT(345, Match, "CREATE", "PUBLICATION", MatchAnyN, "WITH", "("),
	TCPAT(346, Match, "CREATE", "RULE", MatchAny),
	TCPAT(346, Match, "CREATE", "OR", "REPLACE", "RULE", MatchAny),
	TCPAT(347, Match, "CREATE", "RULE", MatchAny, "AS"),
	TCPAT(347, Match, "CREATE", "OR", "REPLACE", "RULE", MatchAny, "AS"),
	TCPAT(348, Match, "CREATE", "RULE", MatchAny, "AS", "ON"),
	TCPAT(348, Match, "CREATE", "OR", "REPLACE", "RULE", MatchAny, "AS", "ON"),
	TCPAT(349, TailMatch, "AS", "ON", "SELECT|UPDATE|INSERT|DELETE"),
	TCPAT(350, TailMatch, "AS", "ON", "SELECT|UPDATE|INSERT|DELETE", "TO"),
	TCPAT(351, Match, "CREATE", "SCHEMA"),
	TCPAT(352, Match, "CREATE", "SCHEMA", "AUTHORIZATION"),
	TCPAT(352, Match, "CREATE", "SCHEMA", MatchAny, "AUTHORIZATION"),
	TCPAT(353, Match, "CREATE", "SCHEMA", "AUTHORIZATION", MatchAny),
	TCPAT(353, Match, "CREATE", "SCHEMA", MatchAny, "AUTHORIZATION", MatchAny),
	TCPAT(354, Match, "CREATE", "SCHEMA", MatchAny),
	TCPAT(355, TailMatch, "CREATE", "SEQUENCE", MatchAny),
	TCPAT(355, TailMatch, "CREATE", "TEMP|TEMPORARY", "SEQUENCE", MatchAny),
	TCPAT(356, TailMatch, "CREATE", "SEQUENCE", MatchAny, "AS"),
	TCPAT(356, TailMatch, "CREATE", "TEMP|TEMPORARY", "SEQUENCE", MatchAny, "AS"),
	TCPAT(357, TailMatch, "CREATE", "SEQUENCE", MatchAny, "NO"),
	TCPAT(357, TailMatch, "CREATE", "TEMP|TEMPORARY", "SEQUENCE", MatchAny, "NO"),
	TCPAT(358, Match, "CREATE", "SERVER", MatchAny),
	TCPAT(359, Match, "CREATE", "STATISTICS", MatchAny),
	TCPAT(360, Match, "CREATE", "STATISTICS", MatchAny, "("),
	TCPAT(361, Match, "CREATE", "STATISTICS", MatchAny, "(*)"),
	TCPAT(362, Match, "CREATE", "STATISTICS", MatchAny, MatchAnyN, "FROM"),
	TCPAT(363, TailMatch, "CREATE", "TEMP|TEMPORARY"),
	TCPAT(364, TailMatch, "CREATE", "UNLOGGED"),
	TCPAT(365, TailMatch, "PARTITION", "BY"),
	TCPAT(366, TailMatch, "PARTITION", "OF"),
	TCPAT(367, TailMatch, "PARTITION", "OF", MatchAny),
	TCPAT(368, TailMatch, "CREATE", "TABLE", MatchAny),
	TCPAT(368, TailMatch, "CREATE", "TEMP|TEMPORARY|UNLOGGED", "TABLE", MatchAny),
	TCPAT(369, TailMatch, "CREATE", "TABLE", MatchAny, "OF"),
	TCPAT(369, TailMatch, "CREATE", "TEMP|TEMPORARY|UNLOGGED", "TABLE", MatchAny, "OF"),
	TCPAT(370, TailMatch, "CREATE", "TABLE", MatchAny, "AS"),
	TCPAT(370, TailMatch, "CREATE", "TABLE", MatchAny, "(*)", "AS"),
	TCPAT(370, TailMatch, "CREATE", "TEMP|TEMPORARY|UNLOGGED", "TABLE", MatchAny, "AS"),
	TCPAT(370, TailMatch, "CREATE", "TEMP|TEMPORARY|UNLOGGED", "TABLE", MatchAny, "(*)", "AS"),
	TCPAT(371, TailMatch, "CREATE", "TABLE", MatchAny, "(*)"),
	TCPAT(372, TailMatch, "CREATE", "UNLOGGED", "TABLE", MatchAny, "(*)"),
	TCPAT(373, TailMatch, "CREATE", "TEMP|TEMPORARY", "TABLE", MatchAny, "(*)"),
	TCPAT(374, TailMatch, "CREATE", "TABLE", MatchAny, "(*)", "USING"),
	TCPAT(374, TailMatch, "CREATE", "TEMP|TEMPORARY|UNLOGGED", "TABLE", MatchAny, "(*)", "USING"),
	TCPAT(375, TailMatch, "CREATE", "TABLE", MatchAny, "(*)", "WITH", "("),
	TCPAT(375, TailMatch, "CREATE", "TEMP|TEMPORARY|UNLOGGED", "TABLE", MatchAny, "(*)", "WITH", "("),
	TCPAT(376, TailMatch, "CREATE", "TEMP|TEMPORARY", "TABLE", MatchAny, "(*)", "ON", "COMMIT"),
	TCPAT(377, Match, "CREATE", "TABLESPACE", MatchAny),
	TCPAT(378, Match, "CREATE", "TABLESPACE", MatchAny, "OWNER", MatchAny),
	TCPAT(379, Match, "CREATE", "TEXT", "SEARCH"),
	TCPAT(380, Match, "CREATE", "TEXT", "SEARCH", "CONFIGURATION|DICTIONARY|PARSER|TEMPLATE", MatchAny),
	TCPAT(381, Match, "CREATE", "TRANSFORM"),
	TCPAT(381, Match, "CREATE", "OR", "REPLACE", "TRANSFORM"),
	TCPAT(382, Match, "CREATE", "TRANSFORM", "FOR"),
	TCPAT(382, Match, "CREATE", "OR", "REPLACE", "TRANSFORM", "FOR"),
	TCPAT(383, Match, "CREATE", "TRANSFORM", "FOR", MatchAny),
	TCPAT(383, Match, "CREATE", "OR", "REPLACE", "TRANSFORM", "FOR", MatchAny),
	TCPAT(384, Match, "CREATE", "TRANSFORM", "FOR", MatchAny, "LANGUAGE"),
	TCPAT(384, Match, "CREATE", "OR", "REPLACE", "TRANSFORM", "FOR", MatchAny, "LANGUAGE"),
	TCPAT(385, Match, "CREATE", "SUBSCRIPTION", MatchAny),
	TCPAT(386, Match, "CREATE", "SUBSCRIPTION", MatchAny, "CONNECTION", MatchAny),
	TCPAT(387, Match, "CREATE", "SUBSCRIPTION", MatchAny, "CONNECTION", MatchAny, "PUBLICATION"),
	TCPAT(388, Match, "CREATE", "SUBSCRIPTION", MatchAnyN, "PUBLICATION", MatchAny),
	TCPAT(389, Match, "CREATE", "SUBSCRIPTION", MatchAnyN, "WITH", "("),
	TCPAT(390, TailMatch, "CREATE", "TRIGGER", MatchAny),
	TCPAT(390, TailMatch, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAny),
	TCPAT(391, TailMatch, "CREATE", "TRIGGER", MatchAny, "BEFORE|AFTER"),
	TCPAT(391, TailMatch, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAny, "BEFORE|AFTER"),
	TCPAT(392, TailMatch, "CREATE", "TRIGGER", MatchAny, "INSTEAD", "OF"),
	TCPAT(392, TailMatch, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAny, "INSTEAD", "OF"),
	TCPAT(393, TailMatch, "CREATE", "TRIGGER", MatchAny, "BEFORE|AFTER", MatchAny),
	TCPAT(393, TailMatch, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAny, "BEFORE|AFTER", MatchAny),
	TCPAT(393, TailMatch, "CREATE", "TRIGGER", MatchAny, "INSTEAD", "OF", MatchAny),
	TCPAT(393, TailMatch, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAny, "INSTEAD", "OF", MatchAny),
	TCPAT(394, TailMatch, "CREATE", "TRIGGER", MatchAny, "BEFORE|AFTER", MatchAny, "ON"),
	TCPAT(394, TailMatch, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAny, "BEFORE|AFTER", MatchAny, "ON"),
	TCPAT(395, TailMatch, "CREATE", "TRIGGER", MatchAny, "INSTEAD", "OF", MatchAny, "ON"),
	TCPAT(395, TailMatch, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAny, "INSTEAD", "OF", MatchAny, "ON"),
	TCPAT(396, Match, "CREATE", "TRIGGER", MatchAnyN, "ON", MatchAny),
	TCPAT(396, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "ON", MatchAny),
	TCPAT(397, Match, "CREATE", "TRIGGER", MatchAnyN, "DEFERRABLE"),
	TCPAT(397, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "DEFERRABLE"),
	TCPAT(397, Match, "CREATE", "TRIGGER", MatchAnyN, "INITIALLY", "IMMEDIATE|DEFERRED"),
	TCPAT(397, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "INITIALLY", "IMMEDIATE|DEFERRED"),
	TCPAT(398, Match, "CREATE", "TRIGGER", MatchAnyN, "REFERENCING"),
	TCPAT(398, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "REFERENCING"),
	TCPAT(399, Match, "CREATE", "TRIGGER", MatchAnyN, "OLD|NEW", "TABLE"),
	TCPAT(399, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "OLD|NEW", "TABLE"),
	TCPAT(400, Match, "CREATE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD", "TABLE", "AS", MatchAny),
	TCPAT(400, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD", "TABLE", "AS", MatchAny),
	TCPAT(400, Match, "CREATE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD", "TABLE", MatchAny),
	TCPAT(400, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD", "TABLE", MatchAny),
	TCPAT(401, Match, "CREATE", "TRIGGER", MatchAnyN, "REFERENCING", "NEW", "TABLE", "AS", MatchAny),
	TCPAT(401, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "REFERENCING", "NEW", "TABLE", "AS", MatchAny),
	TCPAT(401, Match, "CREATE", "TRIGGER", MatchAnyN, "REFERENCING", "NEW", "TABLE", MatchAny),
	TCPAT(401, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "REFERENCING", "NEW", "TABLE", MatchAny),
	TCPAT(402, Match, "CREATE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD|NEW", "TABLE", "AS", MatchAny, "OLD|NEW", "TABLE", "AS", MatchAny),
	TCPAT(402, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD|NEW", "TABLE", "AS", MatchAny, "OLD|NEW", "TABLE", "AS", MatchAny),
	TCPAT(402, Match, "CREATE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD|NEW", "TABLE", MatchAny, "OLD|NEW", "TABLE", "AS", MatchAny),
	TCPAT(402, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD|NEW", "TABLE", MatchAny, "OLD|NEW", "TABLE", "AS", MatchAny),
	TCPAT(402, Match, "CREATE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD|NEW", "TABLE", "AS", MatchAny, "OLD|NEW", "TABLE", MatchAny),
	TCPAT(402, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD|NEW", "TABLE", "AS", MatchAny, "OLD|NEW", "TABLE", MatchAny),
	TCPAT(402, Match, "CREATE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD|NEW", "TABLE", MatchAny, "OLD|NEW", "TABLE", MatchAny),
	TCPAT(402, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "REFERENCING", "OLD|NEW", "TABLE", MatchAny, "OLD|NEW", "TABLE", MatchAny),
	TCPAT(403, Match, "CREATE", "TRIGGER", MatchAnyN, "FOR"),
	TCPAT(403, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "FOR"),
	TCPAT(404, Match, "CREATE", "TRIGGER", MatchAnyN, "FOR", "EACH"),
	TCPAT(404, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "FOR", "EACH"),
	TCPAT(405, Match, "CREATE", "TRIGGER", MatchAnyN, "FOR", "EACH", "ROW|STATEMENT"),
	TCPAT(405, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "FOR", "EACH", "ROW|STATEMENT"),
	TCPAT(405, Match, "CREATE", "TRIGGER", MatchAnyN, "FOR", "ROW|STATEMENT"),
	TCPAT(405, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "FOR", "ROW|STATEMENT"),
	TCPAT(406, Match, "CREATE", "TRIGGER", MatchAnyN, "WHEN", "(*)"),
	TCPAT(406, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "WHEN", "(*)"),
	TCPAT(407, Match, "CREATE", "TRIGGER", MatchAnyN, "EXECUTE"),
	TCPAT(407, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "EXECUTE"),
	TCPAT(408, Match, "CREATE", "TRIGGER", MatchAnyN, "EXECUTE", "FUNCTION|PROCEDURE"),
	TCPAT(408, Match, "CREATE", "OR", "REPLACE", "TRIGGER", MatchAnyN, "EXECUTE", "FUNCTION|PROCEDURE"),
	TCPAT(409, Match, "CREATE", "ROLE|GROUP|USER", MatchAny),
	TCPAT(410, Match, "CREATE", "ROLE|GROUP|USER", MatchAny, "WITH"),
	TCPAT(411, Match, "CREATE", "ROLE|USER|GROUP", MatchAny, "IN"),
	TCPAT(412, Match, "CREATE", "TYPE", MatchAny),
	TCPAT(413, Match, "CREATE", "TYPE", MatchAny, "AS"),
	TCPAT(414, HeadMatch, "CREATE", "TYPE", MatchAny, "AS", "("),
	TCPAT(415, Match, "CREATE", "TYPE", MatchAny, "AS", "ENUM|RANGE"),
	TCPAT(416, HeadMatch, "CREATE", "TYPE", MatchAny, "("),
	TCPAT(417, HeadMatch, "CREATE", "TYPE", MatchAny, "AS", "RANGE", "("),
	TCPAT(418, TailMatch, "CREATE", "VIEW", MatchAny),
	TCPAT(418, TailMatch, "CREATE", "OR", "REPLACE", "VIEW", MatchAny),
	TCPAT(419, TailMatch, "CREATE", "VIEW", MatchAny, "AS"),
	TCPAT(419, TailMatch, "CREATE", "OR", "REPLACE", "VIEW", MatchAny, "AS"),
	TCPAT(420, TailMatch, "CREATE", "VIEW", MatchAny, "WITH"),
	TCPAT(420, TailMatch, "CREATE", "OR", "REPLACE", "VIEW", MatchAny, "WITH"),
	TCPAT(421, TailMatch, "CREATE", "VIEW", MatchAny, "WITH", "("),
	TCPAT(421, TailMatch, "CREATE", "OR", "REPLACE", "VIEW", MatchAny, "WITH", "("),
	TCPAT(422, TailMatch, "CREATE", "VIEW", MatchAny, "WITH", "(", "check_option"),
	TCPAT(422, TailMatch, "CREATE", "OR", "REPLACE", "VIEW", MatchAny, "WITH", "(", "check_option"),
	TCPAT(423, TailMatch, "CREATE", "VIEW", MatchAny, "WITH", "(", "check_option", "="),
	TCPAT(423, TailMatch, "CREATE", "OR", "REPLACE", "VIEW", MatchAny, "WITH", "(", "check_option", "="),
	TCPAT(424, TailMatch, "CREATE", "VIEW", MatchAny, "WITH", "(*)"),
	TCPAT(424, TailMatch, "CREATE", "OR", "REPLACE", "VIEW", MatchAny, "WITH", "(*)"),
	TCPAT(425, TailMatch, "CREATE", "VIEW", MatchAny, "WITH", "(*)", "AS"),
	TCPAT(425, TailMatch, "CREATE", "OR", "REPLACE", "VIEW", MatchAny, "WITH", "(*)", "AS"),
	TCPAT(426, Match, "CREATE", "MATERIALIZED"),
	TCPAT(427, Match, "CREATE", "MATERIALIZED", "VIEW", MatchAny),
	TCPAT(428, Match, "CREATE", "MATERIALIZED", "VIEW", MatchAny, "USING"),
	TCPAT(429, Match, "CREATE", "MATERIALIZED", "VIEW", MatchAny, "USING", MatchAny),
	TCPAT(430, Match, "CREATE", "MATERIALIZED", "VIEW", MatchAny, "AS"),
	TCPAT(430, Match, "CREATE", "MATERIALIZED", "VIEW", MatchAny, "USING", MatchAny, "AS"),
	TCPAT(431, Match, "CREATE", "EVENT"),
	TCPAT(432, Match, "CREATE", "EVENT", "TRIGGER", MatchAny),
	TCPAT(433, Match, "CREATE", "EVENT", "TRIGGER", MatchAny, "ON"),
	TCPAT(434, Match, "CREATE", "EVENT", "TRIGGER", MatchAny, "ON", MatchAny),
	TCPAT(435, Match, "CREATE", "EVENT", "TRIGGER", MatchAnyN, "WHEN|AND", MatchAny, "IN", "(*)"),
	TCPAT(436, Match, "CREATE", "EVENT", "TRIGGER", MatchAnyN, "EXECUTE", "FUNCTION|PROCEDURE"),
	TCPAT(437, Match, "DEALLOCATE"),
	TCPAT(438, Match, "DECLARE", MatchAny),
	TCPAT(439, Match, "DECLARE", MatchAnyN, "BINARY"),
	TCPAT(440, Match, "DECLARE", MatchAnyN, "ASENSITIVE|INSENSITIVE"),
	TCPAT(441, Match, "DECLARE", MatchAnyN, "SCROLL"),
	TCPAT(442, Match, "DECLARE", MatchAnyN, "NO"),
	TCPAT(443, Match, "DECLARE", MatchAnyN, "CURSOR"),
	TCPAT(444, Match, "DECLARE", MatchAnyN, "CURSOR", "WITH|WITHOUT"),
	TCPAT(445, Match, "DECLARE", MatchAnyN, "CURSOR", "WITH|WITHOUT", "HOLD"),
	TCPAT(446, Match, "DELETE"),
	TCPAT(447, TailMatch, "DELETE", "FROM"),
	TCPAT(448, TailMatch, "DELETE", "FROM", MatchAny),
	TCPAT(449, Match, "DISCARD"),
	TCPAT(450, Match, "DO"),
	TCPAT(451, Match, "DROP", "COLLATION|CONVERSION|DOMAIN|EXTENSION|LANGUAGE|PUBLICATION|SCHEMA|SEQUENCE|SERVER|SUBSCRIPTION|STATISTICS|TABLE|TYPE|VIEW", MatchAny),
	TCPAT(451, Match, "DROP", "ACCESS", "METHOD", MatchAny),
	TCPAT(451, Match, "DROP", "EVENT", "TRIGGER", MatchAny),
	TCPAT(451, Match, "DROP", "FOREIGN", "DATA", "WRAPPER", MatchAny),
	TCPAT(451, Match, "DROP", "FOREIGN", "TABLE", MatchAny),
	TCPAT(451, Match, "DROP", "TEXT", "SEARCH", "CONFIGURATION|DICTIONARY|PARSER|TEMPLATE", MatchAny),
	TCPAT(452, Match, "DROP", "AGGREGATE|FUNCTION|PROCEDURE|ROUTINE", MatchAny, MatchAny),
	TCPAT(453, Match, "DROP", "AGGREGATE|FUNCTION|PROCEDURE|ROUTINE", MatchAny),
	TCPAT(454, Match, "DROP", "AGGREGATE|FUNCTION|PROCEDURE|ROUTINE", MatchAny, "("),
	TCPAT(455, Match, "DROP", "FOREIGN"),
	TCPAT(456, Match, "DROP", "DATABASE", MatchAny),
	TCPAT(457, HeadMatch, "DROP", "DATABASE"),
	TCPAT(458, Match, "DROP", "INDEX"),
	TCPAT(459, Match, "DROP", "INDEX", "CONCURRENTLY"),
	TCPAT(460, Match, "DROP", "INDEX", MatchAny),
	TCPAT(461, Match, "DROP", "INDEX", "CONCURRENTLY", MatchAny),
	TCPAT(462, Match, "DROP", "MATERIALIZED"),
	TCPAT(463, Match, "DROP", "MATERIALIZED", "VIEW"),
	TCPAT(464, Match, "DROP", "MATERIALIZED", "VIEW", MatchAny),
	TCPAT(465, Match, "DROP", "OWNED"),
	TCPAT(466, Match, "DROP", "OWNED", "BY"),
	TCPAT(467, Match, "DROP", "OWNED", "BY", MatchAny),
	TCPAT(468, Match, "DROP", "TEXT", "SEARCH"),
	TCPAT(469, Match, "DROP", "TRIGGER", MatchAny),
	TCPAT(470, Match, "DROP", "TRIGGER", MatchAny, "ON"),
	TCPAT(471, Match, "DROP", "TRIGGER", MatchAny, "ON", MatchAny),
	TCPAT(472, Match, "DROP", "ACCESS"),
	TCPAT(473, Match, "DROP", "ACCESS", "METHOD"),
	TCPAT(474, Match, "DROP", "EVENT"),
	TCPAT(475, Match, "DROP", "EVENT", "TRIGGER"),
	TCPAT(476, Match, "DROP", "POLICY"),
	TCPAT(477, Match, "DROP", "POLICY", MatchAny),
	TCPAT(478, Match, "DROP", "POLICY", MatchAny, "ON"),
	TCPAT(479, Match, "DROP", "POLICY", MatchAny, "ON", MatchAny),
	TCPAT(480, Match, "DROP", "RULE", MatchAny),
	TCPAT(481, Match, "DROP", "RULE", MatchAny, "ON"),
	TCPAT(482, Match, "DROP", "RULE", MatchAny, "ON", MatchAny),
	TCPAT(483, Match, "DROP", "TRANSFORM"),
	TCPAT(484, Match, "DROP", "TRANSFORM", "FOR"),
	TCPAT(485, Match, "DROP", "TRANSFORM", "FOR", MatchAny),
	TCPAT(486, Match, "DROP", "TRANSFORM", "FOR", MatchAny, "LANGUAGE"),
	TCPAT(487, Match, "DROP", "TRANSFORM", "FOR", MatchAny, "LANGUAGE", MatchAny),
	TCPAT(488, Match, "EXECUTE"),
	TCPAT(489, Match, "EXPLAIN"),
	TCPAT(490, HeadMatch, "EXPLAIN", "(*"),
	TCPAT(491, Match, "EXPLAIN", "ANALYZE"),
	TCPAT(492, Match, "EXPLAIN", "(*)"),
	TCPAT(492, Match, "EXPLAIN", "VERBOSE"),
	TCPAT(492, Match, "EXPLAIN", "ANALYZE", "VERBOSE"),
	TCPAT(493, Match, "FETCH|MOVE"),
	TCPAT(494, Match, "FETCH|MOVE", "BACKWARD|FORWARD"),
	TCPAT(495, Match, "FETCH|MOVE", "ABSOLUTE|BACKWARD|FORWARD|RELATIVE", MatchAnyExcept("FROM|IN")),
	TCPAT(495, Match, "FETCH|MOVE", "ALL|NEXT|PRIOR|FIRST|LAST"),
	TCPAT(496, Match, "FETCH|MOVE", MatchAnyN, "FROM|IN"),
	TCPAT(497, TailMatch, "FOREIGN", "DATA", "WRAPPER"),
	TCPAT(498, Match, "CREATE", "SERVER", MatchAnyN, "FOREIGN", "DATA", "WRAPPER", MatchAny),
	TCPAT(499, TailMatch, "FOREIGN", "TABLE"),
	TCPAT(500, TailMatch, "FOREIGN", "SERVER"),
	TCPAT(501, TailMatch, "GRANT|REVOKE"),
	TCPAT(501, TailMatch, "REVOKE", "ADMIN|GRANT|INHERIT|SET", "OPTION", "FOR"),
	TCPAT(502, TailMatch, "GRANT|REVOKE", "ALTER"),
	TCPAT(502, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", "ALTER"),
	TCPAT(503, TailMatch, "REVOKE", "SET"),
	TCPAT(504, TailMatch, "GRANT", "SET"),
	TCPAT(504, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", "SET"),
	TCPAT(504, TailMatch, "GRANT|REVOKE", "ALTER", "SYSTEM"),
	TCPAT(504, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", "ALTER", "SYSTEM"),
	TCPAT(505, TailMatch, "GRANT|REVOKE", MatchAny, "ON", "PARAMETER"),
	TCPAT(505, TailMatch, "GRANT|REVOKE", MatchAny, MatchAny, "ON", "PARAMETER"),
	TCPAT(505, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, "ON", "PARAMETER"),
	TCPAT(505, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, MatchAny, "ON", "PARAMETER"),
	TCPAT(506, TailMatch, "GRANT", MatchAny, "ON", "PARAMETER", MatchAny),
	TCPAT(506, TailMatch, "GRANT", MatchAny, MatchAny, "ON", "PARAMETER", MatchAny),
	TCPAT(507, TailMatch, "REVOKE", MatchAny, "ON", "PARAMETER", MatchAny),
	TCPAT(507, TailMatch, "REVOKE", MatchAny, MatchAny, "ON", "PARAMETER", MatchAny),
	TCPAT(507, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, "ON", "PARAMETER", MatchAny),
	TCPAT(507, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, MatchAny, "ON", "PARAMETER", MatchAny),
	TCPAT(508, TailMatch, "GRANT|REVOKE", MatchAny),
	TCPAT(508, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny),
	TCPAT(509, TailMatch, "GRANT|REVOKE", MatchAny, "ON"),
	TCPAT(509, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, "ON"),
	TCPAT(510, TailMatch, "GRANT|REVOKE", MatchAny, "ON", "ALL"),
	TCPAT(510, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, "ON", "ALL"),
	TCPAT(511, TailMatch, "GRANT|REVOKE", MatchAny, "ON", "FOREIGN"),
	TCPAT(511, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, "ON", "FOREIGN"),
	TCPAT(512, TailMatch, "GRANT|REVOKE", MatchAny, "ON", MatchAny),
	TCPAT(512, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, "ON", MatchAny),
	TCPAT(513, Match, "GRANT", MatchAnyN, "TO"),
	TCPAT(513, Match, "REVOKE", MatchAnyN, "FROM"),
	TCPAT(514, Match, "GRANT", MatchAnyN, "TO", MatchAny),
	TCPAT(515, Match, "GRANT", MatchAnyN, "TO", MatchAny, "WITH"),
	TCPAT(516, Match, "GRANT", MatchAnyN, "TO", MatchAny, "WITH", "ADMIN|INHERIT|SET"),
	TCPAT(517, Match, "GRANT", MatchAnyN, "TO", MatchAny, "WITH", MatchAny, "OPTION"),
	TCPAT(518, Match, "GRANT", MatchAnyN, "TO", MatchAny, "WITH", MatchAny, "OPTION", "GRANTED", "BY"),
	TCPAT(519, Match, "ALTER", "DEFAULT", "PRIVILEGES", MatchAnyN, "TO|FROM"),
	TCPAT(520, Match, "ALTER", "DEFAULT", "PRIVILEGES", MatchAnyN, "TO", MatchAny),
	TCPAT(521, Match, "GRANT", MatchAnyN, "ON", MatchAny, MatchAny),
	TCPAT(522, Match, "REVOKE", MatchAnyN, "ON", MatchAny, MatchAny),
	TCPAT(523, TailMatch, "GRANT|REVOKE", MatchAny, "ON", "ALL", MatchAny, "IN", "SCHEMA", MatchAny),
	TCPAT(523, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, "ON", "ALL", MatchAny, "IN", "SCHEMA", MatchAny),
	TCPAT(524, TailMatch, "GRANT|REVOKE", MatchAny, "ON", "FOREIGN", "DATA", "WRAPPER", MatchAny),
	TCPAT(524, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, "ON", "FOREIGN", "DATA", "WRAPPER", MatchAny),
	TCPAT(525, TailMatch, "GRANT|REVOKE", MatchAny, "ON", "FOREIGN", "SERVER", MatchAny),
	TCPAT(525, TailMatch, "REVOKE", "GRANT", "OPTION", "FOR", MatchAny, "ON", "FOREIGN", "SERVER", MatchAny),
	TCPAT(526, TailMatch, "FROM", MatchAny, "GROUP"),
	TCPAT(527, Match, "IMPORT"),
	TCPAT(528, Match, "IMPORT", "FOREIGN"),
	TCPAT(529, Match, "IMPORT", "FOREIGN", "SCHEMA", MatchAny),
	TCPAT(530, TailMatch, "LIMIT", "TO", "(*)"),
	TCPAT(530, TailMatch, "EXCEPT", "(*)"),
	TCPAT(531, TailMatch, "FROM", "SERVER", MatchAny),
	TCPAT(532, TailMatch, "FROM", "SERVER", MatchAny, "INTO"),
	TCPAT(533, TailMatch, "FROM", "SERVER", MatchAny, "INTO", MatchAny),
	TCPAT(534, TailMatch, "NOT", "MATCHED", "THEN", "INSERT"),
	TCPAT(535, TailMatch, "INSERT"),
	TCPAT(536, TailMatch, "INSERT", "INTO"),
	TCPAT(537, TailMatch, "INSERT", "INTO", MatchAny, "("),
	TCPAT(538, TailMatch, "INSERT", "INTO", MatchAny),
	TCPAT(539, TailMatch, "INSERT", "INTO", MatchAny, MatchAny),
	TCPAT(540, TailMatch, "OVERRIDING"),
	TCPAT(541, TailMatch, "OVERRIDING", MatchAny, "VALUE"),
	TCPAT(542, TailMatch, "VALUES"),
	TCPAT(543, Match, "LOCK"),
	TCPAT(544, Match, "LOCK", "TABLE"),
	TCPAT(545, Match, "LOCK", "TABLE", "ONLY"),
	TCPAT(545, Match, "LOCK", "ONLY"),
	TCPAT(546, Match, "LOCK", MatchAnyExcept("TABLE|ONLY")),
	TCPAT(546, Match, "LOCK", "TABLE", MatchAnyExcept("ONLY")),
	TCPAT(546, Match, "LOCK", "ONLY", MatchAny),
	TCPAT(546, Match, "LOCK", "TABLE", "ONLY", MatchAny),
	TCPAT(547, Match, "LOCK", MatchAnyN, "IN"),
	TCPAT(548, Match, "LOCK", MatchAnyN, "IN", "ACCESS|ROW"),
	TCPAT(549, Match, "LOCK", MatchAnyN, "IN", "SHARE"),
	TCPAT(550, Match, "LOCK", MatchAnyN, "MODE"),
	TCPAT(551, TailMatch, "MERGE"),
	TCPAT(552, TailMatch, "MERGE", "INTO"),
	TCPAT(553, TailMatch, "MERGE", "INTO", MatchAny),
	TCPAT(554, TailMatch, "MERGE", "INTO", MatchAny, "AS", MatchAny),
	TCPAT(554, TailMatch, "MERGE", "INTO", MatchAny, MatchAnyExcept("USING|AS")),
	TCPAT(555, TailMatch, "MERGE", "INTO", MatchAny, "USING"),
	TCPAT(555, TailMatch, "MERGE", "INTO", MatchAny, "AS", MatchAny, "USING"),
	TCPAT(555, TailMatch, "MERGE", "INTO", MatchAny, MatchAny, "USING"),
	TCPAT(556, TailMatch, "MERGE", "INTO", MatchAny, "USING", MatchAny),
	TCPAT(556, TailMatch, "MERGE", "INTO", MatchAny, "AS", MatchAny, "USING", MatchAny),
	TCPAT(556, TailMatch, "MERGE", "INTO", MatchAny, MatchAny, "USING", MatchAny),
	TCPAT(557, TailMatch, "MERGE", "INTO", MatchAny, "USING", MatchAny, "AS", MatchAny),
	TCPAT(557, TailMatch, "MERGE", "INTO", MatchAny, "AS", MatchAny, "USING", MatchAny, "AS", MatchAny),
	TCPAT(557, TailMatch, "MERGE", "INTO", MatchAny, MatchAny, "USING", MatchAny, "AS", MatchAny),
	TCPAT(557, TailMatch, "MERGE", "INTO", MatchAny, "USING", MatchAny, MatchAnyExcept("ON|AS")),
	TCPAT(557, TailMatch, "MERGE", "INTO", MatchAny, "AS", MatchAny, "USING", MatchAny, MatchAnyExcept("ON|AS")),
	TCPAT(557, TailMatch, "MERGE", "INTO", MatchAny, MatchAny, "USING", MatchAny, MatchAnyExcept("ON|AS")),
	TCPAT(558, TailMatch, "INTO", MatchAny, "USING", MatchAny, "ON"),
	TCPAT(559, TailMatch, "INTO", MatchAny, "AS", MatchAny, "USING", MatchAny, "AS", MatchAny, "ON"),
	TCPAT(560, TailMatch, "INTO", MatchAny, MatchAny, "USING", MatchAny, MatchAny, "ON"),
	TCPAT(561, TailMatch, "USING", MatchAny, "ON", MatchAny),
	TCPAT(561, TailMatch, "USING", MatchAny, "AS", MatchAny, "ON", MatchAny),
	TCPAT(561, TailMatch, "USING", MatchAny, MatchAny, "ON", MatchAny),
	TCPAT(561, TailMatch, "USING", MatchAny, "ON", MatchAny, MatchAnyExcept("WHEN"), MatchAnyExcept("WHEN")),
	TCPAT(561, TailMatch, "USING", MatchAny, "AS", MatchAny, "ON", MatchAny, MatchAnyExcept("WHEN"), MatchAnyExcept("WHEN")),
	TCPAT(561, TailMatch, "USING", MatchAny, MatchAny, "ON", MatchAny, MatchAnyExcept("WHEN"), MatchAnyExcept("WHEN")),
	TCPAT(562, TailMatch, "USING", MatchAny, "ON", MatchAny, "WHEN"),
	TCPAT(562, TailMatch, "USING", MatchAny, "AS", MatchAny, "ON", MatchAny, "WHEN"),
	TCPAT(562, TailMatch, "USING", MatchAny, MatchAny, "ON", MatchAny, "WHEN"),
	TCPAT(562, TailMatch, "USING", MatchAny, "ON", MatchAny, MatchAny, MatchAny, "WHEN"),
	TCPAT(562, TailMatch, "USING", MatchAny, "AS", MatchAny, "ON", MatchAny, MatchAny, MatchAny, "WHEN"),
	TCPAT(562, TailMatch, "USING", MatchAny, MatchAny, "ON", MatchAny, MatchAny, MatchAny, "WHEN"),
	TCPAT(563, TailMatch, "WHEN", "MATCHED"),
	TCPAT(563, TailMatch, "WHEN", "NOT", "MATCHED", "BY", "SOURCE|TARGET"),
	TCPAT(564, TailMatch, "WHEN", "NOT", "MATCHED"),
	TCPAT(565, TailMatch, "WHEN", "NOT", "MATCHED", "BY"),
	TCPAT(566, TailMatch, "WHEN", "MATCHED", "THEN"),
	TCPAT(566, TailMatch, "WHEN", "NOT", "MATCHED", "BY", "SOURCE", "THEN"),
	TCPAT(567, TailMatch, "WHEN", "NOT", "MATCHED", "THEN"),
	TCPAT(567, TailMatch, "WHEN", "NOT", "MATCHED", "BY", "TARGET", "THEN"),
	TCPAT(568, TailMatch, "NOTIFY"),
	TCPAT(569, TailMatch, "OPTIONS"),
	TCPAT(570, TailMatch, "OWNER", "TO"),
	TCPAT(571, TailMatch, "FROM", MatchAny, "ORDER"),
	TCPAT(572, TailMatch, "FROM", MatchAny, "ORDER", "BY"),
	TCPAT(573, Match, "PREPARE", MatchAny, "AS"),
	TCPAT(574, Match, "REASSIGN"),
	TCPAT(575, Match, "REASSIGN", "OWNED"),
	TCPAT(576, Match, "REASSIGN", "OWNED", "BY"),
	TCPAT(577, Match, "REASSIGN", "OWNED", "BY", MatchAny),
	TCPAT(578, Match, "REASSIGN", "OWNED", "BY", MatchAny, "TO"),
	TCPAT(579, Match, "REFRESH"),
	TCPAT(580, Match, "REFRESH", "MATERIALIZED"),
	TCPAT(581, Match, "REFRESH", "MATERIALIZED", "VIEW"),
	TCPAT(582, Match, "REFRESH", "MATERIALIZED", "VIEW", "CONCURRENTLY"),
	TCPAT(583, Match, "REFRESH", "MATERIALIZED", "VIEW", MatchAny),
	TCPAT(584, Match, "REFRESH", "MATERIALIZED", "VIEW", "CONCURRENTLY", MatchAny),
	TCPAT(585, Match, "REFRESH", "MATERIALIZED", "VIEW", MatchAny, "WITH"),
	TCPAT(586, Match, "REFRESH", "MATERIALIZED", "VIEW", "CONCURRENTLY", MatchAny, "WITH"),
	TCPAT(587, Match, "REFRESH", "MATERIALIZED", "VIEW", MatchAny, "WITH", "NO"),
	TCPAT(588, Match, "REFRESH", "MATERIALIZED", "VIEW", "CONCURRENTLY", MatchAny, "WITH", "NO"),
	TCPAT(589, Match, "REINDEX"),
	TCPAT(589, Match, "REINDEX", "(*)"),
	TCPAT(590, Match, "REINDEX", "TABLE"),
	TCPAT(590, Match, "REINDEX", "(*)", "TABLE"),
	TCPAT(591, Match, "REINDEX", "INDEX"),
	TCPAT(591, Match, "REINDEX", "(*)", "INDEX"),
	TCPAT(592, Match, "REINDEX", "SCHEMA"),
	TCPAT(592, Match, "REINDEX", "(*)", "SCHEMA"),
	TCPAT(593, Match, "REINDEX", "SYSTEM|DATABASE"),
	TCPAT(593, Match, "REINDEX", "(*)", "SYSTEM|DATABASE"),
	TCPAT(594, Match, "REINDEX", "TABLE", "CONCURRENTLY"),
	TCPAT(594, Match, "REINDEX", "(*)", "TABLE", "CONCURRENTLY"),
	TCPAT(595, Match, "REINDEX", "INDEX", "CONCURRENTLY"),
	TCPAT(595, Match, "REINDEX", "(*)", "INDEX", "CONCURRENTLY"),
	TCPAT(596, Match, "REINDEX", "SCHEMA", "CONCURRENTLY"),
	TCPAT(596, Match, "REINDEX", "(*)", "SCHEMA", "CONCURRENTLY"),
	TCPAT(597, Match, "REINDEX", "SYSTEM|DATABASE", "CONCURRENTLY"),
	TCPAT(597, Match, "REINDEX", "(*)", "SYSTEM|DATABASE", "CONCURRENTLY"),
	TCPAT(598, HeadMatch, "REINDEX", "(*"),
	TCPAT(599, Match, "SECURITY"),
	TCPAT(600, Match, "SECURITY", "LABEL"),
	TCPAT(601, Match, "SECURITY", "LABEL", "FOR", MatchAny),
	TCPAT(602, Match, "SECURITY", "LABEL", "ON"),
	TCPAT(602, Match, "SECURITY", "LABEL", "FOR", MatchAny, "ON"),
	TCPAT(603, Match, "SECURITY", "LABEL", "ON", MatchAny, MatchAny),
	TCPAT(604, TailMatch, "SET|RESET"),
	TCPAT(605, Match, "SHOW"),
	TCPAT(606, Match, "SHOW", "SESSION"),
	TCPAT(607, Match, "SET", "TRANSACTION"),
	TCPAT(608, Match, "BEGIN|START", "TRANSACTION"),
	TCPAT(608, Match, "BEGIN", "WORK"),
	TCPAT(608, Match, "BEGIN"),
	TCPAT(608, Match, "SET", "SESSION", "CHARACTERISTICS", "AS", "TRANSACTION"),
	TCPAT(609, Match, "SET|BEGIN|START", "TRANSACTION|WORK", "NOT"),
	TCPAT(609, Match, "BEGIN", "NOT"),
	TCPAT(609, Match, "SET", "SESSION", "CHARACTERISTICS", "AS", "TRANSACTION", "NOT"),
	TCPAT(610, Match, "SET|BEGIN|START", "TRANSACTION|WORK", "ISOLATION"),
	TCPAT(610, Match, "BEGIN", "ISOLATION"),
	TCPAT(610, Match, "SET", "SESSION", "CHARACTERISTICS", "AS", "TRANSACTION", "ISOLATION"),
	TCPAT(611, Match, "SET|BEGIN|START", "TRANSACTION|WORK", "ISOLATION", "LEVEL"),
	TCPAT(611, Match, "BEGIN", "ISOLATION", "LEVEL"),
	TCPAT(611, Match, "SET", "SESSION", "CHARACTERISTICS", "AS", "TRANSACTION", "ISOLATION", "LEVEL"),
	TCPAT(612, Match, "SET|BEGIN|START", "TRANSACTION|WORK", "ISOLATION", "LEVEL", "READ"),
	TCPAT(612, Match, "BEGIN", "ISOLATION", "LEVEL", "READ"),
	TCPAT(612, Match, "SET", "SESSION", "CHARACTERISTICS", "AS", "TRANSACTION", "ISOLATION", "LEVEL", "READ"),
	TCPAT(613, Match, "SET|BEGIN|START", "TRANSACTION|WORK", "ISOLATION", "LEVEL", "REPEATABLE"),
	TCPAT(613, Match, "BEGIN", "ISOLATION", "LEVEL", "REPEATABLE"),
	TCPAT(613, Match, "SET", "SESSION", "CHARACTERISTICS", "AS", "TRANSACTION", "ISOLATION", "LEVEL", "REPEATABLE"),
	TCPAT(614, Match, "SET|BEGIN|START", "TRANSACTION|WORK", "READ"),
	TCPAT(614, Match, "BEGIN", "READ"),
	TCPAT(614, Match, "SET", "SESSION", "CHARACTERISTICS", "AS", "TRANSACTION", "READ"),
	TCPAT(615, Match, "SET", "CONSTRAINTS"),
	TCPAT(616, Match, "SET", "CONSTRAINTS", MatchAny),
	TCPAT(617, Match, "SET", "ROLE"),
	TCPAT(618, Match, "SET", "SESSION"),
	TCPAT(619, Match, "SET", "SESSION", "AUTHORIZATION"),
	TCPAT(620, Match, "RESET", "SESSION"),
	TCPAT(621, Match, "SET", MatchAny),
	TCPAT(622, Match, "ALTER", "DATABASE|FUNCTION|PROCEDURE|ROLE|ROUTINE|USER", MatchAnyN, "SET", MatchAnyExcept("SCHEMA")),
	TCPAT(623, TailMatch, "SET", MatchAny, "TO|="),
	TCPAT(624, Match, "START"),
	TCPAT(625, Match, "TABLE"),
	TCPAT(626, TailMatch, "TABLESAMPLE"),
	TCPAT(627, TailMatch, "TABLESAMPLE", MatchAny),
	TCPAT(628, Match, "TRUNCATE"),
	TCPAT(629, Match, "TRUNCATE", "TABLE"),
	TCPAT(630, Match, "TRUNCATE", MatchAnyN, "ONLY"),
	TCPAT(631, Match, "TRUNCATE", MatchAny),
	TCPAT(631, Match, "TRUNCATE", "TABLE|ONLY", MatchAny),
	TCPAT(631, Match, "TRUNCATE", "TABLE", "ONLY", MatchAny),
	TCPAT(632, Match, "TRUNCATE", MatchAnyN, "IDENTITY"),
	TCPAT(633, Match, "UNLISTEN"),
	TCPAT(634, TailMatch, "UPDATE"),
	TCPAT(635, TailMatch, "UPDATE", MatchAny),
	TCPAT(636, TailMatch, "UPDATE", MatchAny, "SET"),
	TCPAT(637, TailMatch, "UPDATE", MatchAny, "SET", MatchAnyExcept("*=")),
	TCPAT(638, Match, "ALTER|CREATE|DROP", "USER", "MAPPING"),
	TCPAT(639, Match, "CREATE", "USER", "MAPPING", "FOR"),
	TCPAT(640, Match, "ALTER|DROP", "USER", "MAPPING", "FOR"),
	TCPAT(641, Match, "CREATE|ALTER|DROP", "USER", "MAPPING", "FOR", MatchAny),
	TCPAT(642, Match, "CREATE|ALTER", "USER", "MAPPING", "FOR", MatchAny, "SERVER", MatchAny),
	TCPAT(643, Match, "VACUUM"),
	TCPAT(644, HeadMatch, "VACUUM", "(*"),
	TCPAT(645, Match, "VACUUM", "(*)"),
	TCPAT(646, Match, "VACUUM", "FULL"),
	TCPAT(647, Match, "VACUUM", MatchAnyN, "FREEZE"),
	TCPAT(648, Match, "VACUUM", MatchAnyN, "VERBOSE"),
	TCPAT(649, Match, "VACUUM", MatchAnyN, "ANALYZE"),
	TCPAT(650, Match, "VACUUM", MatchAnyN, "("),
	TCPAT(651, HeadMatch, "VACUUM"),
	TCPAT(652, Match, "WITH"),
	TCPAT(653, TailMatch, MatchAny, "WHERE"),
	TCPAT(654, TailMatch, "FROM"),
	TCPAT(655, TailMatch, "JOIN"),
	TCPAT(656, TailMatch, "JOIN", MatchAny),
	TCPAT(657, TailMatch, "JOIN", MatchAny, MatchAny),
	TCPAT(658, TailMatch, "JOIN", "LATERAL", MatchAny, MatchAny),
	TCPAT(659, TailMatch, "JOIN", MatchAny, "USING"),
	TCPAT(659, TailMatch, "JOIN", MatchAny, MatchAny, "USING"),
	TCPAT(659, TailMatch, "JOIN", "LATERAL", MatchAny, MatchAny, "USING"),
	TCPAT(660, TailMatch, "JOIN", MatchAny, "USING", "("),
	TCPAT(661, TailMatch, "JOIN", MatchAny, MatchAny, "USING", "("),
	TCPAT(662, TailMatch, "AT"),
	TCPAT(663, TailMatch, "AT", "TIME", "ZONE"),
	TCPAT(664, TailMatchCS, "\\?"),
	TCPAT(665, TailMatchCS, "\\connect|\\c"),
	TCPAT(666, TailMatchCS, "\\connect|\\c", MatchAny),
	TCPAT(667, TailMatchCS, "\\da*"),
	TCPAT(668, TailMatchCS, "\\dAc*", MatchAny),
	TCPAT(668, TailMatchCS, "\\dAf*", MatchAny),
	TCPAT(669, TailMatchCS, "\\dAo*", MatchAny),
	TCPAT(669, TailMatchCS, "\\dAp*", MatchAny),
	TCPAT(670, TailMatchCS, "\\dA*"),
	TCPAT(671, TailMatchCS, "\\db*"),
	TCPAT(672, TailMatchCS, "\\dconfig*"),
	TCPAT(673, TailMatchCS, "\\dD*"),
	TCPAT(674, TailMatchCS, "\\des*"),
	TCPAT(675, TailMatchCS, "\\deu*"),
	TCPAT(676, TailMatchCS, "\\dew*"),
	TCPAT(677, TailMatchCS, "\\df*"),
	TCPAT(678, HeadMatchCS, "\\df*"),
	TCPAT(679, TailMatchCS, "\\dFd*"),
	TCPAT(680, TailMatchCS, "\\dFp*"),
	TCPAT(681, TailMatchCS, "\\dFt*"),
	TCPAT(682, TailMatchCS, "\\dF*"),
	TCPAT(683, TailMatchCS, "\\di*"),
	TCPAT(684, TailMatchCS, "\\dL*"),
	TCPAT(685, TailMatchCS, "\\dn*"),
	TCPAT(686, HeadMatchCS, "\\do*", MatchAny),
	TCPAT(687, TailMatchCS, "\\dp"),
	TCPAT(687, TailMatchCS, "\\z"),
	TCPAT(688, TailMatchCS, "\\dPi*"),
	TCPAT(689, TailMatchCS, "\\dPt*"),
	TCPAT(690, TailMatchCS, "\\dP*"),
	TCPAT(691, TailMatchCS, "\\dRp*"),
	TCPAT(692, TailMatchCS, "\\dRs*"),
	TCPAT(693, TailMatchCS, "\\ds*"),
	TCPAT(694, TailMatchCS, "\\dt*"),
	TCPAT(695, TailMatchCS, "\\dT*"),
	TCPAT(696, TailMatchCS, "\\du*"),
	TCPAT(696, TailMatchCS, "\\dg*"),
	TCPAT(696, TailMatchCS, "\\drg*"),
	TCPAT(697, TailMatchCS, "\\dv*"),
	TCPAT(698, TailMatchCS, "\\dx*"),
	TCPAT(699, TailMatchCS, "\\dX*"),
	TCPAT(700, TailMatchCS, "\\dm*"),
	TCPAT(701, TailMatchCS, "\\dE*"),
	TCPAT(702, TailMatchCS, "\\dy*"),
	TCPAT(703, TailMatchCS, "\\d*"),
	TCPAT(704, TailMatchCS, "\\ef"),
	TCPAT(705, TailMatchCS, "\\ev"),
	TCPAT(706, TailMatchCS, "\\encoding"),
	TCPAT(707, TailMatchCS, "\\h|\\help"),
	TCPAT(708, TailMatchCS, "\\h|\\help", MatchAny),
	TCPAT(709, TailMatchCS, "\\h|\\help", MatchAny, MatchAny),
	TCPAT(710, TailMatchCS, "\\h|\\help", MatchAny, MatchAny, MatchAny),
	TCPAT(711, TailMatchCS, "\\l*"),
	TCPAT(712, TailMatchCS, "\\password"),
	TCPAT(713, TailMatchCS, "\\pset"),
	TCPAT(714, TailMatchCS, "\\pset", MatchAny),
	TCPAT(715, TailMatchCS, "\\unset"),
	TCPAT(716, TailMatchCS, "\\set"),
	TCPAT(717, TailMatchCS, "\\set", MatchAny),
	TCPAT(718, TailMatchCS, "\\sf*"),
	TCPAT(719, TailMatchCS, "\\sv*"),
	TCPAT(720, TailMatchCS, "\\cd|\\e|\\edit|\\g|\\gx|\\i|\\include|" "\\ir|\\include_relative|\\o|\\out|" "\\s|\\w|\\write|\\lo_import"),
#line 1382 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
};

#endif							/* SWITCH_CONVERSION_APPLIED */

/* Storage parameters for CREATE TABLE and ALTER TABLE */
static const char *const table_storage_parameters[] = {
	"autovacuum_analyze_scale_factor",
	"autovacuum_analyze_threshold",
	"autovacuum_enabled",
	"autovacuum_freeze_max_age",
	"autovacuum_freeze_min_age",
	"autovacuum_freeze_table_age",
	"autovacuum_multixact_freeze_max_age",
	"autovacuum_multixact_freeze_min_age",
	"autovacuum_multixact_freeze_table_age",
	"autovacuum_vacuum_cost_delay",
	"autovacuum_vacuum_cost_limit",
	"autovacuum_vacuum_insert_scale_factor",
	"autovacuum_vacuum_insert_threshold",
	"autovacuum_vacuum_max_threshold",
	"autovacuum_vacuum_scale_factor",
	"autovacuum_vacuum_threshold",
	"fillfactor",
	"log_autovacuum_min_duration",
	"parallel_workers",
	"toast.autovacuum_enabled",
	"toast.autovacuum_freeze_max_age",
	"toast.autovacuum_freeze_min_age",
	"toast.autovacuum_freeze_table_age",
	"toast.autovacuum_multixact_freeze_max_age",
	"toast.autovacuum_multixact_freeze_min_age",
	"toast.autovacuum_multixact_freeze_table_age",
	"toast.autovacuum_vacuum_cost_delay",
	"toast.autovacuum_vacuum_cost_limit",
	"toast.autovacuum_vacuum_insert_scale_factor",
	"toast.autovacuum_vacuum_insert_threshold",
	"toast.autovacuum_vacuum_max_threshold",
	"toast.autovacuum_vacuum_scale_factor",
	"toast.autovacuum_vacuum_threshold",
	"toast.log_autovacuum_min_duration",
	"toast.vacuum_index_cleanup",
	"toast.vacuum_max_eager_freeze_failure_rate",
	"toast.vacuum_truncate",
	"toast_tuple_target",
	"user_catalog_table",
	"vacuum_index_cleanup",
	"vacuum_max_eager_freeze_failure_rate",
	"vacuum_truncate",
	NULL
};

/* Optional parameters for CREATE VIEW and ALTER VIEW */
static const char *const view_optional_parameters[] = {
	"check_option",
	"security_barrier",
	"security_invoker",
	NULL
};

/* Forward declaration of functions */
static char **psql_completion(const char *text, int start, int end);
static char **match_previous_words(int pattern_id,
								   const char *text, int start, int end,
								   char **previous_words,
								   int previous_words_count);
static char *create_command_generator(const char *text, int state);
static char *drop_command_generator(const char *text, int state);
static char *alter_command_generator(const char *text, int state);
static char *complete_from_query(const char *text, int state);
static char *complete_from_versioned_query(const char *text, int state);
static char *complete_from_schema_query(const char *text, int state);
static char *complete_from_versioned_schema_query(const char *text, int state);
static char *_complete_from_query(const char *simple_query,
								  const SchemaQuery *schema_query,
								  const char *const *keywords,
								  bool verbatim,
								  const char *text, int state);
static void set_completion_reference(const char *word);
static void set_completion_reference_verbatim(const char *word);
static char *complete_from_list(const char *text, int state);
static char *complete_from_const(const char *text, int state);
static void append_variable_names(char ***varnames, int *nvars,
								  int *maxvars, const char *varname,
								  const char *prefix, const char *suffix);
static char **complete_from_variables(const char *text,
									  const char *prefix, const char *suffix, bool need_value);
static char *complete_from_files(const char *text, int state);

static char *pg_strdup_keyword_case(const char *s, const char *ref);
static char *escape_string(const char *text);
static char *make_like_pattern(const char *word);
static void parse_identifier(const char *ident,
							 char **schemaname, char **objectname,
							 bool *schemaquoted, bool *objectquoted);
static char *requote_identifier(const char *schemaname, const char *objectname,
								bool quote_schema, bool quote_object);
static bool identifier_needs_quotes(const char *ident);
static PGresult *exec_query(const char *query);

static char **get_previous_words(int point, char **buffer, int *nwords);

static char *get_guctype(const char *varname);

#ifdef USE_FILENAME_QUOTING_FUNCTIONS
static char *quote_file_name(char *fname, int match_type, char *quote_pointer);
static char *dequote_file_name(char *fname, int quote_char);
#endif


/*
 * Initialize the readline library for our purposes.
 */
void
initialize_readline(void)
{
	rl_readline_name = (char *) pset.progname;
	rl_attempted_completion_function = psql_completion;

#ifdef USE_FILENAME_QUOTING_FUNCTIONS
	rl_filename_quoting_function = quote_file_name;
	rl_filename_dequoting_function = dequote_file_name;
#endif

	rl_basic_word_break_characters = WORD_BREAKS;

	/*
	 * Ideally we'd include '"' in rl_completer_quote_characters too, which
	 * should allow us to complete quoted identifiers that include spaces.
	 * However, the library support for rl_completer_quote_characters is
	 * presently too inconsistent to want to mess with that.  (Note in
	 * particular that libedit has this variable but completely ignores it.)
	 */
	rl_completer_quote_characters = "'";

	/*
	 * Set rl_filename_quote_characters to "all possible characters",
	 * otherwise Readline will skip filename quoting if it thinks a filename
	 * doesn't need quoting.  Readline actually interprets this as bytes, so
	 * there are no encoding considerations here.
	 */
#ifdef HAVE_RL_FILENAME_QUOTE_CHARACTERS
	{
		unsigned char *fqc = (unsigned char *) pg_malloc(256);

		for (int i = 0; i < 255; i++)
			fqc[i] = (unsigned char) (i + 1);
		fqc[255] = '\0';
		rl_filename_quote_characters = (const char *) fqc;
	}
#endif

	completion_max_records = 1000;

	/*
	 * There is a variable rl_completion_query_items for this but apparently
	 * it's not defined everywhere.
	 */
}

/*
 * Check if 'word' matches any of the '|'-separated strings in 'pattern',
 * using case-insensitive or case-sensitive comparisons.
 *
 * If pattern is NULL, it's a wild card that matches any word.
 * If pattern begins with '!', the result is negated, ie we check that 'word'
 * does *not* match any alternative appearing in the rest of 'pattern'.
 * Any alternative can contain '*' which is a wild card, i.e., it can match
 * any substring; however, we allow at most one '*' per alternative.
 *
 * For readability, callers should use the macros MatchAny and MatchAnyExcept
 * to invoke those two special cases for 'pattern'.  (But '|' and '*' must
 * just be written directly in patterns.)  There is also MatchAnyN, but that
 * is supported only in Matches/MatchesCS and is not handled here.
 */
static bool
word_matches(const char *pattern,
			 const char *word,
			 bool case_sensitive)
{
	size_t		wordlen;

#define cimatch(s1, s2, n) \
	(case_sensitive ? strncmp(s1, s2, n) == 0 : pg_strncasecmp(s1, s2, n) == 0)

	/* NULL pattern matches anything. */
	if (pattern == NULL)
		return true;

	/* Handle negated patterns from the MatchAnyExcept macro. */
	if (*pattern == '!')
		return !word_matches(pattern + 1, word, case_sensitive);

	/* Else consider each alternative in the pattern. */
	wordlen = strlen(word);
	for (;;)
	{
		const char *star = NULL;
		const char *c;

		/* Find end of current alternative, and locate any wild card. */
		c = pattern;
		while (*c != '\0' && *c != '|')
		{
			if (*c == '*')
				star = c;
			c++;
		}
		/* Was there a wild card? */
		if (star)
		{
			/* Yes, wildcard match? */
			size_t		beforelen = star - pattern,
						afterlen = c - star - 1;

			if (wordlen >= (beforelen + afterlen) &&
				cimatch(word, pattern, beforelen) &&
				cimatch(word + wordlen - afterlen, star + 1, afterlen))
				return true;
		}
		else
		{
			/* No, plain match? */
			if (wordlen == (c - pattern) &&
				cimatch(word, pattern, wordlen))
				return true;
		}
		/* Out of alternatives? */
		if (*c == '\0')
			break;
		/* Nope, try next alternative. */
		pattern = c + 1;
	}

	return false;
}

/*
 * Implementation of TailMatches and TailMatchesCS tests: do the last N words
 * in previous_words match the pattern arguments?
 *
 * The array indexing might look backwards, but remember that
 * previous_words[0] contains the *last* word on the line, not the first.
 */
static bool
TailMatchesArray(bool case_sensitive,
				 int previous_words_count, char **previous_words,
				 int narg, const char *const *args)
{
	if (previous_words_count < narg)
		return false;

	for (int argno = 0; argno < narg; argno++)
	{
		const char *arg = args[argno];

		if (!word_matches(arg, previous_words[narg - argno - 1],
						  case_sensitive))
			return false;
	}

	return true;
}

/*
 * As above, but the pattern is passed as a variadic argument list.
 */
static bool
TailMatchesImpl(bool case_sensitive,
				int previous_words_count, char **previous_words,
				int narg,...)
{
	const char *argarray[64];
	va_list		args;

	Assert(narg <= lengthof(argarray));

	if (previous_words_count < narg)
		return false;

	va_start(args, narg);
	for (int argno = 0; argno < narg; argno++)
		argarray[argno] = va_arg(args, const char *);
	va_end(args);

	return TailMatchesArray(case_sensitive,
							previous_words_count, previous_words,
							narg, argarray);
}

/*
 * Implementation of HeadMatches and HeadMatchesCS tests: do the first N
 * words in previous_words match the pattern arguments?
 */
static bool
HeadMatchesArray(bool case_sensitive,
				 int previous_words_count, char **previous_words,
				 int narg, const char *const *args)
{
	if (previous_words_count < narg)
		return false;

	for (int argno = 0; argno < narg; argno++)
	{
		const char *arg = args[argno];

		if (!word_matches(arg, previous_words[previous_words_count - argno - 1],
						  case_sensitive))
			return false;
	}

	return true;
}

/*
 * As above, but the pattern is passed as a variadic argument list.
 */
static bool
HeadMatchesImpl(bool case_sensitive,
				int previous_words_count, char **previous_words,
				int narg,...)
{
	const char *argarray[64];
	va_list		args;

	Assert(narg <= lengthof(argarray));

	if (previous_words_count < narg)
		return false;

	va_start(args, narg);
	for (int argno = 0; argno < narg; argno++)
		argarray[argno] = va_arg(args, const char *);
	va_end(args);

	return HeadMatchesArray(case_sensitive,
							previous_words_count, previous_words,
							narg, argarray);
}

/*
 * Implementation of Matches and MatchesCS tests: do all of the words
 * in previous_words match the pattern arguments?
 *
 * This supports an additional kind of wildcard: MatchAnyN (represented as "")
 * can match any number of words, including zero, in the middle of the list.
 */
static bool
MatchesArray(bool case_sensitive,
			 int previous_words_count, char **previous_words,
			 int narg, const char *const *args)
{
	int			match_any_pos = -1;

	/* Even with MatchAnyN, there must be at least N-1 words */
	if (previous_words_count < narg - 1)
		return false;

	/* Check for MatchAnyN */
	for (int argno = 0; argno < narg; argno++)
	{
		const char *arg = args[argno];

		if (arg != NULL && arg[0] == '\0')
		{
			match_any_pos = argno;
			break;
		}
	}

	if (match_any_pos < 0)
	{
		/* Standard case without MatchAnyN */
		if (previous_words_count != narg)
			return false;

		/* Either Head or Tail match will do for the rest */
		if (!HeadMatchesArray(case_sensitive,
							  previous_words_count, previous_words,
							  narg, args))
			return false;
	}
	else
	{
		/* Match against head */
		if (!HeadMatchesArray(case_sensitive,
							  previous_words_count, previous_words,
							  match_any_pos, args))
			return false;

		/* Match against tail */
		if (!TailMatchesArray(case_sensitive,
							  previous_words_count, previous_words,
							  narg - match_any_pos - 1,
							  args + match_any_pos + 1))
			return false;
	}

	return true;
}

/*
 * As above, but the pattern is passed as a variadic argument list.
 */
static bool
MatchesImpl(bool case_sensitive,
			int previous_words_count, char **previous_words,
			int narg,...)
{
	const char *argarray[64];
	va_list		args;

	Assert(narg <= lengthof(argarray));

	/* Even with MatchAnyN, there must be at least N-1 words */
	if (previous_words_count < narg - 1)
		return false;

	va_start(args, narg);
	for (int argno = 0; argno < narg; argno++)
		argarray[argno] = va_arg(args, const char *);
	va_end(args);

	return MatchesArray(case_sensitive,
						previous_words_count, previous_words,
						narg, argarray);
}

/*
 * Check if the final character of 's' is 'c'.
 */
static bool
ends_with(const char *s, char c)
{
	size_t		length = strlen(s);

	return (length > 0 && s[length - 1] == c);
}

/*
 * The completion function.
 *
 * According to readline spec this gets passed the text entered so far and its
 * start and end positions in the readline buffer. The return value is some
 * partially obscure list format that can be generated by readline's
 * rl_completion_matches() function, so we don't have to worry about it.
 */
static char **
psql_completion(const char *text, int start, int end)
{
	/* This is the variable we'll return. */
	char	  **matches = NULL;

	/* Workspace for parsed words. */
	char	   *words_buffer;

	/* This array will contain pointers to parsed words. */
	char	  **previous_words;

	/* The number of words found on the input line. */
	int			previous_words_count;

	/*
	 * For compactness, we use these macros to reference previous_words[].
	 * Caution: do not access a previous_words[] entry without having checked
	 * previous_words_count to be sure it's valid.  In most cases below, that
	 * check is implicit in a TailMatches() or similar macro, but in some
	 * places we have to check it explicitly.
	 */
#define prev_wd   (previous_words[0])
#define prev2_wd  (previous_words[1])
#define prev3_wd  (previous_words[2])
#define prev4_wd  (previous_words[3])
#define prev5_wd  (previous_words[4])
#define prev6_wd  (previous_words[5])
#define prev7_wd  (previous_words[6])
#define prev8_wd  (previous_words[7])
#define prev9_wd  (previous_words[8])

	/* Match the last N words before point, case-insensitively. */
#define TailMatches(...) \
	TailMatchesImpl(false, previous_words_count, previous_words, \
					VA_ARGS_NARGS(__VA_ARGS__), __VA_ARGS__)

	/* Match the last N words before point, case-sensitively. */
#define TailMatchesCS(...) \
	TailMatchesImpl(true, previous_words_count, previous_words, \
					VA_ARGS_NARGS(__VA_ARGS__), __VA_ARGS__)

	/* Match N words representing all of the line, case-insensitively. */
#define Matches(...) \
	MatchesImpl(false, previous_words_count, previous_words, \
				VA_ARGS_NARGS(__VA_ARGS__), __VA_ARGS__)

	/* Match N words representing all of the line, case-sensitively. */
#define MatchesCS(...) \
	MatchesImpl(true, previous_words_count, previous_words, \
				VA_ARGS_NARGS(__VA_ARGS__), __VA_ARGS__)

	/* Match the first N words on the line, case-insensitively. */
#define HeadMatches(...) \
	HeadMatchesImpl(false, previous_words_count, previous_words, \
					VA_ARGS_NARGS(__VA_ARGS__), __VA_ARGS__)

	/* Match the first N words on the line, case-sensitively. */
#define HeadMatchesCS(...) \
	HeadMatchesImpl(true, previous_words_count, previous_words, \
					VA_ARGS_NARGS(__VA_ARGS__), __VA_ARGS__)

	/* psql's backslash commands. */
	static const char *const backslash_commands[] = {
		"\\a",
		"\\bind", "\\bind_named",
		"\\connect", "\\conninfo", "\\C", "\\cd", "\\close_prepared", "\\copy",
		"\\copyright", "\\crosstabview",
		"\\d", "\\da", "\\dA", "\\dAc", "\\dAf", "\\dAo", "\\dAp",
		"\\db", "\\dc", "\\dconfig", "\\dC", "\\dd", "\\ddp", "\\dD",
		"\\des", "\\det", "\\deu", "\\dew", "\\dE", "\\df",
		"\\dF", "\\dFd", "\\dFp", "\\dFt", "\\dg", "\\di", "\\dl", "\\dL",
		"\\dm", "\\dn", "\\do", "\\dO", "\\dp", "\\dP", "\\dPi", "\\dPt",
		"\\drds", "\\drg", "\\dRs", "\\dRp", "\\ds",
		"\\dt", "\\dT", "\\dv", "\\du", "\\dx", "\\dX", "\\dy",
		"\\echo", "\\edit", "\\ef", "\\elif", "\\else", "\\encoding",
		"\\endif", "\\endpipeline", "\\errverbose", "\\ev",
		"\\f", "\\flush", "\\flushrequest",
		"\\g", "\\gdesc", "\\getenv", "\\getresults", "\\gexec", "\\gset", "\\gx",
		"\\help", "\\html",
		"\\if", "\\include", "\\include_relative", "\\ir",
		"\\list", "\\lo_import", "\\lo_export", "\\lo_list", "\\lo_unlink",
		"\\out",
		"\\parse", "\\password", "\\print", "\\prompt", "\\pset",
		"\\qecho", "\\quit",
		"\\reset", "\\restrict",
		"\\s", "\\sendpipeline", "\\set", "\\setenv", "\\sf",
		"\\startpipeline", "\\sv", "\\syncpipeline",
		"\\t", "\\T", "\\timing",
		"\\unrestrict", "\\unset",
		"\\x",
		"\\warn", "\\watch", "\\write",
		"\\z",
		"\\!", "\\?",
		NULL
	};

	/*
	 * Temporary workaround for a bug in recent (2019) libedit: it incorrectly
	 * de-escapes the input "text", causing us to fail to recognize backslash
	 * commands.  So get the string to look at from rl_line_buffer instead.
	 */
	char	   *text_copy = pnstrdup(rl_line_buffer + start, end - start);
	text = text_copy;

	/* Remember last char of the given input word. */
	completion_last_char = (end > start) ? text[end - start - 1] : '\0';

	/* We usually want the append character to be a space. */
	rl_completion_append_character = ' ';

	/* Clear a few things. */
	completion_charp = NULL;
	completion_charpp = NULL;
	completion_vquery = NULL;
	completion_squery = NULL;
	completion_ref_object = NULL;
	completion_ref_schema = NULL;

	/*
	 * Scan the input line to extract the words before our current position.
	 * According to those we'll make some smart decisions on what the user is
	 * probably intending to type.
	 */
	previous_words = get_previous_words(start,
										&words_buffer,
										&previous_words_count);

	/* If current word is a backslash command, offer completions for that */
	if (text[0] == '\\')
		COMPLETE_WITH_LIST_CS(backslash_commands);

	/* If current word is a variable interpolation, handle that case */
	else if (text[0] == ':' && text[1] != ':')
	{
		if (text[1] == '\'')
			matches = complete_from_variables(text, ":'", "'", true);
		else if (text[1] == '"')
			matches = complete_from_variables(text, ":\"", "\"", true);
		else if (text[1] == '{' && text[2] == '?')
			matches = complete_from_variables(text, ":{?", "}", true);
		else
			matches = complete_from_variables(text, ":", "", true);
	}

	/* If no previous word, suggest one of the basic sql commands */
	else if (previous_words_count == 0)
		COMPLETE_WITH_LIST(sql_commands);

	/* Else try completions based on matching patterns of previous words */
	else
	{
#ifdef SWITCH_CONVERSION_APPLIED
		/*
		 * If we have transformed match_previous_words into a switch, iterate
		 * through tcpatterns[] to see which pattern ids match.
		 *
		 * For now, we have to try the patterns in the order they are stored
		 * (matching the order of switch cases in match_previous_words),
		 * because some of the logic in match_previous_words assumes that
		 * previous matches have been eliminated.  This is fairly
		 * unprincipled, and it is likely that there are undesirable as well
		 * as desirable interactions hidden in the order of the pattern
		 * checks.  TODO: think about a better way to manage that.
		 */
		for (int tindx = 0; tindx < lengthof(tcpatterns); tindx++)
		{
			const TCPattern *tcpat = tcpatterns + tindx;
			bool		match = false;

			switch (tcpat->kind)
			{
				case Match:
					match = MatchesArray(false,
										 previous_words_count,
										 previous_words,
										 tcpat->nwords, tcpat->words);
					break;
				case MatchCS:
					match = MatchesArray(true,
										 previous_words_count,
										 previous_words,
										 tcpat->nwords, tcpat->words);
					break;
				case HeadMatch:
					match = HeadMatchesArray(false,
											 previous_words_count,
											 previous_words,
											 tcpat->nwords, tcpat->words);
					break;
				case HeadMatchCS:
					match = HeadMatchesArray(true,
											 previous_words_count,
											 previous_words,
											 tcpat->nwords, tcpat->words);
					break;
				case TailMatch:
					match = TailMatchesArray(false,
											 previous_words_count,
											 previous_words,
											 tcpat->nwords, tcpat->words);
					break;
				case TailMatchCS:
					match = TailMatchesArray(true,
											 previous_words_count,
											 previous_words,
											 tcpat->nwords, tcpat->words);
					break;
			}
			if (match)
			{
				matches = match_previous_words(tcpat->id, text, start, end,
											   previous_words,
											   previous_words_count);
				if (matches != NULL)
					break;
			}
		}
#else							/* !SWITCH_CONVERSION_APPLIED */
		/*
		 * If gen_tabcomplete.pl hasn't been applied to this code, just let
		 * match_previous_words scan through all its patterns.
		 */
		matches = match_previous_words(0, text, start, end,
									   previous_words,
									   previous_words_count);
#endif							/* SWITCH_CONVERSION_APPLIED */
	}

	/*
	 * Finally, we look through the list of "things", such as TABLE, INDEX and
	 * check if that was the previous word. If so, execute the query to get a
	 * list of them.
	 */
	if (matches == NULL && previous_words_count > 0)
	{
		const pgsql_thing_t *wac;

		for (wac = words_after_create; wac->name != NULL; wac++)
		{
			if (pg_strcasecmp(prev_wd, wac->name) == 0)
			{
				if (wac->query)
					COMPLETE_WITH_QUERY_LIST(wac->query,
											 wac->keywords);
				else if (wac->vquery)
					COMPLETE_WITH_VERSIONED_QUERY_LIST(wac->vquery,
													   wac->keywords);
				else if (wac->squery)
					COMPLETE_WITH_VERSIONED_SCHEMA_QUERY_LIST(wac->squery,
															  wac->keywords);
				break;
			}
		}
	}

	/*
	 * If we still don't have anything to match we have to fabricate some sort
	 * of default list. If we were to just return NULL, readline automatically
	 * attempts filename completion, and that's usually no good.
	 */
	if (matches == NULL)
	{
		COMPLETE_WITH_CONST(true, "");
		/* Also, prevent Readline from appending stuff to the non-match */
		rl_completion_append_character = '\0';
#ifdef HAVE_RL_COMPLETION_SUPPRESS_QUOTE
		rl_completion_suppress_quote = 1;
#endif
	}

	/* free storage */
	free(previous_words);
	free(words_buffer);
	free(text_copy);
	free(completion_ref_object);
	completion_ref_object = NULL;
	free(completion_ref_schema);
	completion_ref_schema = NULL;

	/* Return our Grand List O' Matches */
	return matches;
}

/*
 * Subroutine to try matches based on previous_words.
 *
 * This can operate in one of two modes.  As presented, the body of the
 * function is a long if-else-if chain that sequentially tries each known
 * match rule.  That works, but some C compilers have trouble with such a long
 * else-if chain, either taking extra time to compile or failing altogether.
 * Therefore, we prefer to transform the else-if chain into a switch, and then
 * each call of this function considers just one match rule (under control of
 * a loop in psql_completion()).  Compilers tend to be more ready to deal
 * with many-arm switches than many-arm else-if chains.
 *
 * Each if-condition in this function must begin with a call of one of the
 * functions Matches, HeadMatches, TailMatches, MatchesCS, HeadMatchesCS, or
 * TailMatchesCS.  The preprocessor gen_tabcomplete.pl strips out those
 * calls and converts them into entries in tcpatterns[], which are evaluated
 * by the calling loop in psql_completion().  Successful matches result in
 * calls to this function with the appropriate pattern_id, causing just the
 * corresponding switch case to be executed.
 *
 * If-conditions in this function can be more complex than a single *Matches
 * function call in one of two ways (but not both!).  They can be OR's
 * of *Matches calls, such as
 *  else if (Matches("ALTER", "VIEW", MatchAny, "ALTER", MatchAny) ||
 *           Matches("ALTER", "VIEW", MatchAny, "ALTER", "COLUMN", MatchAny))
 * or they can be a *Matches call AND'ed with some other condition, e.g.
 *  else if (Matches("CREATE", "PUBLICATION", MatchAny, "FOR", "TABLE", MatchAny) &&
 *           !ends_with(prev_wd, ','))
 * The former case is transformed into multiple tcpatterns[] entries and
 * multiple case labels for the same bit of code.  The latter case is
 * transformed into a case label and a contained if-statement.
 *
 * This is split out of psql_completion() primarily to separate code that
 * gen_tabcomplete.pl should process from code that it should not, although
 * doing so also helps to avoid extra indentation of this code.
 *
 * Returns a matches list, or NULL if no match.
 */
static char **
match_previous_words(int pattern_id,
					 const char *text, int start, int end,
					 char **previous_words, int previous_words_count)
{
	/* This is the variable we'll return. */
	char	  **matches = NULL;

	/* Dummy statement, allowing all the match rules to look like "else if" */
	if (0)
	{
		/* skip */
	}

	/* gen_tabcomplete.pl begins special processing here */
	switch (pattern_id)
	{
#line 2166 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"

/* CREATE */
	/* complete with something you can create */
	case 1:
	{
		/* only some object types can be created as part of CREATE SCHEMA */
		if (HeadMatches("CREATE", "SCHEMA"))
			COMPLETE_WITH("TABLE", "VIEW", "INDEX", "SEQUENCE", "TRIGGER",
			/* for INDEX and TABLE/SEQUENCE, respectively */
						  "UNIQUE", "UNLOGGED");
		else
			matches = rl_completion_matches(text, create_command_generator);
	}
	/* complete with something you can create or replace */
	break; case 2:
		COMPLETE_WITH("FUNCTION", "PROCEDURE", "LANGUAGE", "RULE", "VIEW",
					  "AGGREGATE", "TRANSFORM", "TRIGGER");

/* DROP, but not DROP embedded in other commands */
	/* complete with something you can drop */
	break; case 3:
		matches = rl_completion_matches(text, drop_command_generator);

/* ALTER */

	/* ALTER TABLE */
	break; case 4:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_tables,
										"ALL IN TABLESPACE");

	/* ALTER something */
	break; case 5:
		matches = rl_completion_matches(text, alter_command_generator);
	/* ALTER TABLE,INDEX,MATERIALIZED VIEW ALL IN TABLESPACE xxx */
	break; case 6:
		COMPLETE_WITH("SET TABLESPACE", "OWNED BY");
	/* ALTER TABLE,INDEX,MATERIALIZED VIEW ALL IN TABLESPACE xxx OWNED BY */
	break; case 7:
		COMPLETE_WITH_QUERY(Query_for_list_of_roles);
	/* ALTER TABLE,INDEX,MATERIALIZED VIEW ALL IN TABLESPACE xxx OWNED BY xxx */
	break; case 8:
		COMPLETE_WITH("SET TABLESPACE");
	/* ALTER AGGREGATE,FUNCTION,PROCEDURE,ROUTINE <name> */
	break; case 9:
		COMPLETE_WITH("(");
	/* ALTER AGGREGATE <name> (...) */
	break; case 10:
	{
		if (ends_with(prev_wd, ')'))
			COMPLETE_WITH("OWNER TO", "RENAME TO", "SET SCHEMA");
		else
			COMPLETE_WITH_FUNCTION_ARG(prev2_wd);
	}
	/* ALTER FUNCTION <name> (...) */
	break; case 11:
	{
		if (ends_with(prev_wd, ')'))
			COMPLETE_WITH(Alter_function_options);
		else
			COMPLETE_WITH_FUNCTION_ARG(prev2_wd);
	}
	/* ALTER PROCEDURE <name> (...) */
	break; case 12:
	{
		if (ends_with(prev_wd, ')'))
			COMPLETE_WITH(Alter_procedure_options);
		else
			COMPLETE_WITH_FUNCTION_ARG(prev2_wd);
	}
	/* ALTER ROUTINE <name> (...) */
	break; case 13:
	{
		if (ends_with(prev_wd, ')'))
			COMPLETE_WITH(Alter_routine_options);
		else
			COMPLETE_WITH_FUNCTION_ARG(prev2_wd);
	}
	/* ALTER FUNCTION|ROUTINE <name> (...) PARALLEL */
	break; case 14:
		COMPLETE_WITH("RESTRICTED", "SAFE", "UNSAFE");
	/* ALTER FUNCTION|PROCEDURE|ROUTINE <name> (...) [EXTERNAL] SECURITY */
	break; case 15:
#line 2249 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("DEFINER", "INVOKER");
	/* ALTER FUNCTION|PROCEDURE|ROUTINE <name> (...) RESET */
	break; case 16:
		COMPLETE_WITH_QUERY_VERBATIM_PLUS(Query_for_list_of_set_vars,
										  "ALL");
	/* ALTER FUNCTION|PROCEDURE|ROUTINE <name> (...) SET */
	break; case 17:
		COMPLETE_WITH_QUERY_VERBATIM_PLUS(Query_for_list_of_set_vars,
										  "SCHEMA");

	/* ALTER PUBLICATION <name> */
	break; case 18:
		COMPLETE_WITH("ADD", "DROP", "OWNER TO", "RENAME TO", "SET");
	/* ALTER PUBLICATION <name> ADD */
	break; case 19:
		COMPLETE_WITH("TABLES IN SCHEMA", "TABLE");
	break; case 20:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);
	break; case 21:
#line 2268 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (ends_with(prev_wd, ','))
#line 2269 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);

	/*
	 * "ALTER PUBLICATION <name> SET TABLE <name> WHERE (" - complete with
	 * table attributes
	 *
	 * "ALTER PUBLICATION <name> ADD TABLE <name> WHERE (" - complete with
	 * table attributes
	 */
	break; case 22:
		COMPLETE_WITH("(");
	break; case 23:
		COMPLETE_WITH_ATTR(prev3_wd);
	break; case 24:
#line 2283 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("WHERE", "(*)"))
#line 2284 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH(",", "WHERE (");
	break; case 25:
		COMPLETE_WITH(",");
	/* ALTER PUBLICATION <name> DROP */
	break; case 26:
		COMPLETE_WITH("TABLES IN SCHEMA", "TABLE");
	/* ALTER PUBLICATION <name> SET */
	break; case 27:
		COMPLETE_WITH("(", "TABLES IN SCHEMA", "TABLE");
	break; case 28:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_schemas
								 " AND nspname NOT LIKE E'pg\\\\_%%'",
								 "CURRENT_SCHEMA");
	/* ALTER PUBLICATION <name> SET ( */
	break; case 29:
		COMPLETE_WITH("publish", "publish_generated_columns", "publish_via_partition_root");
	/* ALTER SUBSCRIPTION <name> */
	break; case 30:
		COMPLETE_WITH("CONNECTION", "ENABLE", "DISABLE", "OWNER TO",
					  "RENAME TO", "REFRESH PUBLICATION", "SET", "SKIP (",
					  "ADD PUBLICATION", "DROP PUBLICATION");
	/* ALTER SUBSCRIPTION <name> REFRESH PUBLICATION */
	break; case 31:
		COMPLETE_WITH("WITH (");
	/* ALTER SUBSCRIPTION <name> REFRESH PUBLICATION WITH ( */
	break; case 32:
		COMPLETE_WITH("copy_data");
	/* ALTER SUBSCRIPTION <name> SET */
	break; case 33:
		COMPLETE_WITH("(", "PUBLICATION");
	/* ALTER SUBSCRIPTION <name> SET ( */
	break; case 34:
		COMPLETE_WITH("binary", "disable_on_error", "failover", "origin",
					  "password_required", "run_as_owner", "slot_name",
					  "streaming", "synchronous_commit", "two_phase");
	/* ALTER SUBSCRIPTION <name> SKIP ( */
	break; case 35:
		COMPLETE_WITH("lsn");
	/* ALTER SUBSCRIPTION <name> SET PUBLICATION */
	break; case 36:
	{
		/* complete with nothing here as this refers to remote publications */
	}
	/* ALTER SUBSCRIPTION <name> ADD|DROP|SET PUBLICATION <name> */
	break; case 37:
#line 2330 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("WITH (");
	/* ALTER SUBSCRIPTION <name> ADD|DROP|SET PUBLICATION <name> WITH ( */
	break; case 38:
#line 2334 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("copy_data", "refresh");

	/* ALTER SCHEMA <name> */
	break; case 39:
		COMPLETE_WITH("OWNER TO", "RENAME TO");

	/* ALTER COLLATION <name> */
	break; case 40:
		COMPLETE_WITH("OWNER TO", "REFRESH VERSION", "RENAME TO", "SET SCHEMA");

	/* ALTER CONVERSION <name> */
	break; case 41:
		COMPLETE_WITH("OWNER TO", "RENAME TO", "SET SCHEMA");

	/* ALTER DATABASE <name> */
	break; case 42:
		COMPLETE_WITH("RESET", "SET", "OWNER TO", "REFRESH COLLATION VERSION", "RENAME TO",
					  "IS_TEMPLATE", "ALLOW_CONNECTIONS",
					  "CONNECTION LIMIT");

	/* ALTER DATABASE <name> RESET */
	break; case 43:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_database_vars, "ALL");
	}

	/* ALTER DATABASE <name> SET TABLESPACE */
	break; case 44:
		COMPLETE_WITH_QUERY(Query_for_list_of_tablespaces);

	/* ALTER EVENT TRIGGER */
	break; case 45:
		COMPLETE_WITH_QUERY(Query_for_list_of_event_triggers);

	/* ALTER EVENT TRIGGER <name> */
	break; case 46:
		COMPLETE_WITH("DISABLE", "ENABLE", "OWNER TO", "RENAME TO");

	/* ALTER EVENT TRIGGER <name> ENABLE */
	break; case 47:
		COMPLETE_WITH("REPLICA", "ALWAYS");

	/* ALTER EXTENSION <name> */
	break; case 48:
		COMPLETE_WITH("ADD", "DROP", "UPDATE", "SET SCHEMA");

	/* ALTER EXTENSION <name> ADD|DROP */
	break; case 49:
		COMPLETE_WITH("ACCESS METHOD", "AGGREGATE", "CAST", "COLLATION",
					  "CONVERSION", "DOMAIN", "EVENT TRIGGER", "FOREIGN",
					  "FUNCTION", "MATERIALIZED VIEW", "OPERATOR",
					  "LANGUAGE", "PROCEDURE", "ROUTINE", "SCHEMA",
					  "SEQUENCE", "SERVER", "TABLE", "TEXT SEARCH",
					  "TRANSFORM FOR", "TYPE", "VIEW");

	/* ALTER EXTENSION <name> ADD|DROP FOREIGN */
	break; case 50:
		COMPLETE_WITH("DATA WRAPPER", "TABLE");

	/* ALTER EXTENSION <name> ADD|DROP OPERATOR */
	break; case 51:
		COMPLETE_WITH("CLASS", "FAMILY");

	/* ALTER EXTENSION <name> ADD|DROP TEXT SEARCH */
	break; case 52:
		COMPLETE_WITH("CONFIGURATION", "DICTIONARY", "PARSER", "TEMPLATE");

	/* ALTER EXTENSION <name> UPDATE */
	break; case 53:
		COMPLETE_WITH("TO");

	/* ALTER EXTENSION <name> UPDATE TO */
	break; case 54:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_QUERY(Query_for_list_of_available_extension_versions);
	}

	/* ALTER FOREIGN */
	break; case 55:
		COMPLETE_WITH("DATA WRAPPER", "TABLE");

	/* ALTER FOREIGN DATA WRAPPER <name> */
	break; case 56:
		COMPLETE_WITH("HANDLER", "VALIDATOR", "NO",
					  "OPTIONS", "OWNER TO", "RENAME TO");
	break; case 57:
		COMPLETE_WITH("HANDLER", "VALIDATOR");

	/* ALTER FOREIGN TABLE <name> */
	break; case 58:
		COMPLETE_WITH("ADD", "ALTER", "DISABLE TRIGGER", "DROP", "ENABLE",
					  "INHERIT", "NO INHERIT", "OPTIONS", "OWNER TO",
					  "RENAME", "SET", "VALIDATE CONSTRAINT");

	/* ALTER INDEX */
	break; case 59:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_indexes,
										"ALL IN TABLESPACE");
	/* ALTER INDEX <name> */
	break; case 60:
		COMPLETE_WITH("ALTER COLUMN", "OWNER TO", "RENAME TO", "SET",
					  "RESET", "ATTACH PARTITION",
					  "DEPENDS ON EXTENSION", "NO DEPENDS ON EXTENSION");
	break; case 61:
		COMPLETE_WITH("PARTITION");
	break; case 62:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_indexes);
	/* ALTER INDEX <name> ALTER */
	break; case 63:
		COMPLETE_WITH("COLUMN");
	/* ALTER INDEX <name> ALTER COLUMN */
	break; case 64:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_SCHEMA_QUERY_VERBATIM(Query_for_list_of_attribute_numbers);
	}
	/* ALTER INDEX <name> ALTER COLUMN <colnum> */
	break; case 65:
		COMPLETE_WITH("SET STATISTICS");
	/* ALTER INDEX <name> ALTER COLUMN <colnum> SET */
	break; case 66:
		COMPLETE_WITH("STATISTICS");
	/* ALTER INDEX <name> ALTER COLUMN <colnum> SET STATISTICS */
	break; case 67:
	{
		/* Enforce no completion here, as an integer has to be specified */
	}
	/* ALTER INDEX <name> SET */
	break; case 68:
		COMPLETE_WITH("(", "TABLESPACE");
	/* ALTER INDEX <name> RESET */
	break; case 69:
		COMPLETE_WITH("(");
	/* ALTER INDEX <foo> SET|RESET ( */
	break; case 70:
		COMPLETE_WITH("fillfactor",
					  "deduplicate_items",	/* BTREE */
					  "fastupdate", "gin_pending_list_limit",	/* GIN */
					  "buffering",	/* GiST */
					  "pages_per_range", "autosummarize"	/* BRIN */
			);
	break; case 71:
		COMPLETE_WITH("fillfactor =",
					  "deduplicate_items =",	/* BTREE */
					  "fastupdate =", "gin_pending_list_limit =",	/* GIN */
					  "buffering =",	/* GiST */
					  "pages_per_range =", "autosummarize ="	/* BRIN */
			);
	break; case 72:
		COMPLETE_WITH("ON EXTENSION");
	break; case 73:
		COMPLETE_WITH("ON EXTENSION");

	/* ALTER LANGUAGE <name> */
	break; case 74:
		COMPLETE_WITH("OWNER TO", "RENAME TO");

	/* ALTER LARGE OBJECT <oid> */
	break; case 75:
		COMPLETE_WITH("OWNER TO");

	/* ALTER MATERIALIZED VIEW */
	break; case 76:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_matviews,
										"ALL IN TABLESPACE");

	/* ALTER USER,ROLE <name> */
	break; case 77:
#line 2504 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("USER", "MAPPING"))
#line 2505 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("BYPASSRLS", "CONNECTION LIMIT", "CREATEDB", "CREATEROLE",
					  "ENCRYPTED PASSWORD", "INHERIT", "LOGIN", "NOBYPASSRLS",
					  "NOCREATEDB", "NOCREATEROLE", "NOINHERIT",
					  "NOLOGIN", "NOREPLICATION", "NOSUPERUSER", "PASSWORD",
					  "RENAME TO", "REPLICATION", "RESET", "SET", "SUPERUSER",
					  "VALID UNTIL", "WITH");

	/* ALTER USER,ROLE <name> RESET */
	break; case 78:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_user_vars, "ALL");
	}

	/* ALTER USER,ROLE <name> WITH */
	break; case 79:
		/* Similar to the above, but don't complete "WITH" again. */
		COMPLETE_WITH("BYPASSRLS", "CONNECTION LIMIT", "CREATEDB", "CREATEROLE",
					  "ENCRYPTED PASSWORD", "INHERIT", "LOGIN", "NOBYPASSRLS",
					  "NOCREATEDB", "NOCREATEROLE", "NOINHERIT",
					  "NOLOGIN", "NOREPLICATION", "NOSUPERUSER", "PASSWORD",
					  "RENAME TO", "REPLICATION", "RESET", "SET", "SUPERUSER",
					  "VALID UNTIL");

	/* ALTER DEFAULT PRIVILEGES */
	break; case 80:
		COMPLETE_WITH("FOR", "GRANT", "IN SCHEMA", "REVOKE");
	/* ALTER DEFAULT PRIVILEGES FOR */
	break; case 81:
		COMPLETE_WITH("ROLE");
	/* ALTER DEFAULT PRIVILEGES IN */
	break; case 82:
		COMPLETE_WITH("SCHEMA");
	/* ALTER DEFAULT PRIVILEGES FOR ROLE|USER ... */
	break; case 83:
#line 2541 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("GRANT", "REVOKE", "IN SCHEMA");
	/* ALTER DEFAULT PRIVILEGES IN SCHEMA ... */
	break; case 84:
#line 2545 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("GRANT", "REVOKE", "FOR ROLE");
	/* ALTER DEFAULT PRIVILEGES IN SCHEMA ... FOR */
	break; case 85:
#line 2549 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ROLE");
	/* ALTER DEFAULT PRIVILEGES FOR ROLE|USER ... IN SCHEMA ... */
	/* ALTER DEFAULT PRIVILEGES IN SCHEMA ... FOR ROLE|USER ... */
	break; case 86:
#line 2556 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("GRANT", "REVOKE");
	/* ALTER DOMAIN <name> */
	break; case 87:
		COMPLETE_WITH("ADD", "DROP", "OWNER TO", "RENAME", "SET",
					  "VALIDATE CONSTRAINT");
	/* ALTER DOMAIN <sth> ADD */
	break; case 88:
		COMPLETE_WITH("CONSTRAINT", "NOT NULL", "CHECK (");
	/* ALTER DOMAIN <sth> ADD CONSTRAINT <sth> */
	break; case 89:
		COMPLETE_WITH("NOT NULL", "CHECK (");
	/* ALTER DOMAIN <sth> DROP */
	break; case 90:
		COMPLETE_WITH("CONSTRAINT", "DEFAULT", "NOT NULL");
	/* ALTER DOMAIN <sth> DROP|RENAME|VALIDATE CONSTRAINT */
	break; case 91:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_constraint_of_type);
	}
	/* ALTER DOMAIN <sth> RENAME */
	break; case 92:
		COMPLETE_WITH("CONSTRAINT", "TO");
	/* ALTER DOMAIN <sth> RENAME CONSTRAINT <sth> */
	break; case 93:
		COMPLETE_WITH("TO");

	/* ALTER DOMAIN <sth> SET */
	break; case 94:
		COMPLETE_WITH("DEFAULT", "NOT NULL", "SCHEMA");
	/* ALTER SEQUENCE <name> */
	break; case 95:
		COMPLETE_WITH("AS", "INCREMENT", "MINVALUE", "MAXVALUE", "RESTART",
					  "START", "NO", "CACHE", "CYCLE", "SET", "OWNED BY",
					  "OWNER TO", "RENAME TO");
	/* ALTER SEQUENCE <name> AS */
	break; case 96:
		COMPLETE_WITH_CS("smallint", "integer", "bigint");
	/* ALTER SEQUENCE <name> NO */
	break; case 97:
		COMPLETE_WITH("MINVALUE", "MAXVALUE", "CYCLE");
	/* ALTER SEQUENCE <name> SET */
	break; case 98:
		COMPLETE_WITH("SCHEMA", "LOGGED", "UNLOGGED");
	/* ALTER SERVER <name> */
	break; case 99:
		COMPLETE_WITH("VERSION", "OPTIONS", "OWNER TO", "RENAME TO");
	/* ALTER SERVER <name> VERSION <version> */
	break; case 100:
		COMPLETE_WITH("OPTIONS");
	/* ALTER SYSTEM SET, RESET, RESET ALL */
	break; case 101:
		COMPLETE_WITH("SET", "RESET");
	break; case 102:
		COMPLETE_WITH_QUERY_VERBATIM_PLUS(Query_for_list_of_alter_system_set_vars,
										  "ALL");
	break; case 103:
		COMPLETE_WITH("TO");
	/* ALTER VIEW <name> */
	break; case 104:
		COMPLETE_WITH("ALTER COLUMN", "OWNER TO", "RENAME", "RESET", "SET");
	/* ALTER VIEW xxx RENAME */
	break; case 105:
		COMPLETE_WITH_ATTR_PLUS(prev2_wd, "COLUMN", "TO");
	break; case 106:
		COMPLETE_WITH_ATTR(prev3_wd);
	/* ALTER VIEW xxx ALTER [ COLUMN ] yyy */
	break; case 107:
#line 2625 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("SET DEFAULT", "DROP DEFAULT");
	/* ALTER VIEW xxx RENAME yyy */
	break; case 108:
		COMPLETE_WITH("TO");
	/* ALTER VIEW xxx RENAME COLUMN yyy */
	break; case 109:
		COMPLETE_WITH("TO");
	/* ALTER VIEW xxx RESET ( */
	break; case 110:
		COMPLETE_WITH("(");
	/* Complete ALTER VIEW xxx SET with "(" or "SCHEMA" */
	break; case 111:
		COMPLETE_WITH("(", "SCHEMA");
	/* ALTER VIEW xxx SET|RESET ( yyy [= zzz] ) */
	break; case 112:
		COMPLETE_WITH_LIST(view_optional_parameters);
	break; case 113:
		COMPLETE_WITH("=");
	break; case 114:
		COMPLETE_WITH("local", "cascaded");
	break; case 115:
		COMPLETE_WITH("true", "false");

	/* ALTER MATERIALIZED VIEW <name> */
	break; case 116:
		COMPLETE_WITH("ALTER COLUMN", "CLUSTER ON", "DEPENDS ON EXTENSION",
					  "NO DEPENDS ON EXTENSION", "OWNER TO", "RENAME",
					  "RESET (", "SET");
	/* ALTER MATERIALIZED VIEW xxx RENAME */
	break; case 117:
		COMPLETE_WITH_ATTR_PLUS(prev2_wd, "COLUMN", "TO");
	break; case 118:
		COMPLETE_WITH_ATTR(prev3_wd);
	/* ALTER MATERIALIZED VIEW xxx RENAME yyy */
	break; case 119:
		COMPLETE_WITH("TO");
	/* ALTER MATERIALIZED VIEW xxx RENAME COLUMN yyy */
	break; case 120:
		COMPLETE_WITH("TO");
	/* ALTER MATERIALIZED VIEW xxx SET */
	break; case 121:
		COMPLETE_WITH("(", "ACCESS METHOD", "SCHEMA", "TABLESPACE", "WITHOUT CLUSTER");
	/* ALTER MATERIALIZED VIEW xxx SET ACCESS METHOD */
	break; case 122:
		COMPLETE_WITH_QUERY(Query_for_list_of_table_access_methods);

	/* ALTER POLICY <name> */
	break; case 123:
		COMPLETE_WITH_QUERY(Query_for_list_of_policies);
	/* ALTER POLICY <name> ON */
	break; case 124:
		COMPLETE_WITH("ON");
	/* ALTER POLICY <name> ON <table> */
	break; case 125:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables_for_policy);
	}
	/* ALTER POLICY <name> ON <table> - show options */
	break; case 126:
		COMPLETE_WITH("RENAME TO", "TO", "USING (", "WITH CHECK (");
	/* ALTER POLICY <name> ON <table> TO <role> */
	break; case 127:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
								 Keywords_for_list_of_grant_roles);
	/* ALTER POLICY <name> ON <table> USING ( */
	break; case 128:
		COMPLETE_WITH("(");
	/* ALTER POLICY <name> ON <table> WITH CHECK ( */
	break; case 129:
		COMPLETE_WITH("(");

	/* ALTER RULE <name>, add ON */
	break; case 130:
		COMPLETE_WITH("ON");

	/* If we have ALTER RULE <name> ON, then add the correct tablename */
	break; case 131:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables_for_rule);
	}

	/* ALTER RULE <name> ON <name> */
	break; case 132:
		COMPLETE_WITH("RENAME TO");

	/* ALTER STATISTICS <name> */
	break; case 133:
		COMPLETE_WITH("OWNER TO", "RENAME TO", "SET SCHEMA", "SET STATISTICS");
	/* ALTER STATISTICS <name> SET */
	break; case 134:
		COMPLETE_WITH("SCHEMA", "STATISTICS");

	/* ALTER TRIGGER <name>, add ON */
	break; case 135:
		COMPLETE_WITH("ON");

	break; case 136:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables_for_trigger);
	}

	/* ALTER TRIGGER <name> ON <name> */
	break; case 137:
		COMPLETE_WITH("RENAME TO", "DEPENDS ON EXTENSION",
					  "NO DEPENDS ON EXTENSION");

	/*
	 * If we detect ALTER TABLE <name>, suggest sub commands
	 */
	break; case 138:
		COMPLETE_WITH("ADD", "ALTER", "CLUSTER ON", "DISABLE", "DROP",
					  "ENABLE", "INHERIT", "NO", "RENAME", "RESET",
					  "OWNER TO", "SET", "VALIDATE CONSTRAINT",
					  "REPLICA IDENTITY", "ATTACH PARTITION",
					  "DETACH PARTITION", "FORCE ROW LEVEL SECURITY",
					  "OF", "NOT OF");
	/* ALTER TABLE xxx ADD */
	break; case 139:
	{
		/* make sure to keep this list and the !Matches() below in sync */
		COMPLETE_WITH("COLUMN", "CONSTRAINT", "CHECK", "UNIQUE", "PRIMARY KEY",
					  "EXCLUDE", "FOREIGN KEY");
	}
	/* ALTER TABLE xxx ADD [COLUMN] yyy */
	break; case 140:
#line 2754 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
	/* ALTER TABLE xxx ADD CONSTRAINT yyy */
	break; case 141:
		COMPLETE_WITH("CHECK", "UNIQUE", "PRIMARY KEY", "EXCLUDE", "FOREIGN KEY");
	/* ALTER TABLE xxx ADD [CONSTRAINT yyy] (PRIMARY KEY|UNIQUE) */
	break; case 142:
#line 2763 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("(", "USING INDEX");
	/* ALTER TABLE xxx ADD PRIMARY KEY USING INDEX */
	break; case 143:
	{
		set_completion_reference(prev6_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_unique_index_of_table);
	}
	/* ALTER TABLE xxx ADD UNIQUE USING INDEX */
	break; case 144:
	{
		set_completion_reference(prev5_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_unique_index_of_table);
	}
	/* ALTER TABLE xxx ADD CONSTRAINT yyy PRIMARY KEY USING INDEX */
	break; case 145:
#line 2779 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		set_completion_reference(prev8_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_unique_index_of_table);
	}
	/* ALTER TABLE xxx ADD CONSTRAINT yyy UNIQUE USING INDEX */
	break; case 146:
#line 2786 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		set_completion_reference(prev7_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_unique_index_of_table);
	}
	/* ALTER TABLE xxx ENABLE */
	break; case 147:
		COMPLETE_WITH("ALWAYS", "REPLICA", "ROW LEVEL SECURITY", "RULE",
					  "TRIGGER");
	break; case 148:
		COMPLETE_WITH("RULE", "TRIGGER");
	break; case 149:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_rule_of_table);
	}
	break; case 150:
	{
		set_completion_reference(prev4_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_rule_of_table);
	}
	break; case 151:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_trigger_of_table);
	}
	break; case 152:
	{
		set_completion_reference(prev4_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_trigger_of_table);
	}
	/* ALTER TABLE xxx INHERIT */
	break; case 153:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);
	/* ALTER TABLE xxx NO */
	break; case 154:
		COMPLETE_WITH("FORCE ROW LEVEL SECURITY", "INHERIT");
	/* ALTER TABLE xxx NO INHERIT */
	break; case 155:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);
	/* ALTER TABLE xxx DISABLE */
	break; case 156:
		COMPLETE_WITH("ROW LEVEL SECURITY", "RULE", "TRIGGER");
	break; case 157:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_rule_of_table);
	}
	break; case 158:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_trigger_of_table);
	}

	/* ALTER TABLE xxx ALTER */
	break; case 159:
		COMPLETE_WITH_ATTR_PLUS(prev2_wd, "COLUMN", "CONSTRAINT");

	/* ALTER TABLE xxx RENAME */
	break; case 160:
		COMPLETE_WITH_ATTR_PLUS(prev2_wd, "COLUMN", "CONSTRAINT", "TO");
	break; case 161:
		COMPLETE_WITH_ATTR(prev3_wd);

	/* ALTER TABLE xxx RENAME yyy */
	break; case 162:
		COMPLETE_WITH("TO");

	/* ALTER TABLE xxx RENAME COLUMN/CONSTRAINT yyy */
	break; case 163:
		COMPLETE_WITH("TO");

	/* If we have ALTER TABLE <sth> DROP, provide COLUMN or CONSTRAINT */
	break; case 164:
		COMPLETE_WITH("COLUMN", "CONSTRAINT");
	/* If we have ALTER TABLE <sth> DROP COLUMN, provide list of columns */
	break; case 165:
		COMPLETE_WITH_ATTR(prev3_wd);
	/* ALTER TABLE <sth> ALTER|DROP|RENAME CONSTRAINT <constraint> */
	break; case 166:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_constraint_of_table);
	}
	/* ALTER TABLE <sth> VALIDATE CONSTRAINT <non-validated constraint> */
	break; case 167:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_constraint_of_table_not_validated);
	}
	/* ALTER TABLE ALTER [COLUMN] <foo> */
	break; case 168:
#line 2878 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("TYPE", "SET", "RESET", "RESTART", "ADD", "DROP");
	/* ALTER TABLE ALTER [COLUMN] <foo> ADD */
	break; case 169:
#line 2882 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("GENERATED");
	/* ALTER TABLE ALTER [COLUMN] <foo> ADD GENERATED */
	break; case 170:
#line 2886 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ALWAYS", "BY DEFAULT");
	/* ALTER TABLE ALTER [COLUMN] <foo> ADD GENERATED */
	break; case 171:
#line 2892 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("AS IDENTITY");
	/* ALTER TABLE ALTER [COLUMN] <foo> SET */
	break; case 172:
#line 2896 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("(", "COMPRESSION", "DATA TYPE", "DEFAULT", "EXPRESSION", "GENERATED", "NOT NULL",
					  "STATISTICS", "STORAGE",
		/* a subset of ALTER SEQUENCE options */
					  "INCREMENT", "MINVALUE", "MAXVALUE", "START", "NO", "CACHE", "CYCLE");
	/* ALTER TABLE ALTER [COLUMN] <foo> SET ( */
	break; case 173:
#line 2903 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("n_distinct", "n_distinct_inherited");
	/* ALTER TABLE ALTER [COLUMN] <foo> SET COMPRESSION */
	break; case 174:
#line 2907 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("DEFAULT", "PGLZ", "LZ4");
	/* ALTER TABLE ALTER [COLUMN] <foo> SET EXPRESSION */
	break; case 175:
#line 2911 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("AS");
	/* ALTER TABLE ALTER [COLUMN] <foo> SET EXPRESSION AS */
	break; case 176:
#line 2915 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("(");
	/* ALTER TABLE ALTER [COLUMN] <foo> SET GENERATED */
	break; case 177:
#line 2919 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ALWAYS", "BY DEFAULT");
	/* ALTER TABLE ALTER [COLUMN] <foo> SET NO */
	break; case 178:
#line 2923 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("MINVALUE", "MAXVALUE", "CYCLE");
	/* ALTER TABLE ALTER [COLUMN] <foo> SET STORAGE */
	break; case 179:
#line 2927 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("DEFAULT", "PLAIN", "EXTERNAL", "EXTENDED", "MAIN");
	/* ALTER TABLE ALTER [COLUMN] <foo> SET STATISTICS */
	break; case 180:
#line 2931 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		/* Enforce no completion here, as an integer has to be specified */
	}
	/* ALTER TABLE ALTER [COLUMN] <foo> DROP */
	break; case 181:
#line 2937 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("DEFAULT", "EXPRESSION", "IDENTITY", "NOT NULL");
	break; case 182:
		COMPLETE_WITH("ON");
	break; case 183:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_index_of_table);
	}
	/* If we have ALTER TABLE <sth> SET, provide list of attributes and '(' */
	break; case 184:
		COMPLETE_WITH("(", "ACCESS METHOD", "LOGGED", "SCHEMA",
					  "TABLESPACE", "UNLOGGED", "WITH", "WITHOUT");

	/*
	 * If we have ALTER TABLE <sth> SET ACCESS METHOD provide a list of table
	 * AMs.
	 */
	break; case 185:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_table_access_methods,
								 "DEFAULT");

	/*
	 * If we have ALTER TABLE <sth> SET TABLESPACE provide a list of
	 * tablespaces
	 */
	break; case 186:
		COMPLETE_WITH_QUERY(Query_for_list_of_tablespaces);
	/* If we have ALTER TABLE <sth> SET WITHOUT provide CLUSTER or OIDS */
	break; case 187:
		COMPLETE_WITH("CLUSTER", "OIDS");
	/* ALTER TABLE <foo> RESET */
	break; case 188:
		COMPLETE_WITH("(");
	/* ALTER TABLE <foo> SET|RESET ( */
	break; case 189:
		COMPLETE_WITH_LIST(table_storage_parameters);
	break; case 190:
	{
		set_completion_reference(prev5_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_index_of_table);
	}
	break; case 191:
		COMPLETE_WITH("INDEX");
	break; case 192:
		COMPLETE_WITH("FULL", "NOTHING", "DEFAULT", "USING");
	break; case 193:
		COMPLETE_WITH("IDENTITY");

	/*
	 * If we have ALTER TABLE <foo> ATTACH PARTITION, provide a list of
	 * tables.
	 */
	break; case 194:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);
	/* Limited completion support for partition bound specification */
	break; case 195:
		COMPLETE_WITH("FOR VALUES", "DEFAULT");
	break; case 196:
		COMPLETE_WITH("FROM (", "IN (", "WITH (");

	/*
	 * If we have ALTER TABLE <foo> DETACH PARTITION, provide a list of
	 * partitions of <foo>.
	 */
	break; case 197:
	{
		set_completion_reference(prev3_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_partition_of_table);
	}
	break; case 198:
		COMPLETE_WITH("CONCURRENTLY", "FINALIZE");

	/* ALTER TABLE <name> OF */
	break; case 199:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_composite_datatypes);

	/* ALTER TABLESPACE <foo> with RENAME TO, OWNER TO, SET, RESET */
	break; case 200:
		COMPLETE_WITH("RENAME TO", "OWNER TO", "SET", "RESET");
	/* ALTER TABLESPACE <foo> SET|RESET */
	break; case 201:
		COMPLETE_WITH("(");
	/* ALTER TABLESPACE <foo> SET|RESET ( */
	break; case 202:
		COMPLETE_WITH("seq_page_cost", "random_page_cost",
					  "effective_io_concurrency", "maintenance_io_concurrency");

	/* ALTER TEXT SEARCH */
	break; case 203:
		COMPLETE_WITH("CONFIGURATION", "DICTIONARY", "PARSER", "TEMPLATE");
	break; case 204:
		COMPLETE_WITH("RENAME TO", "SET SCHEMA");
	break; case 205:
		COMPLETE_WITH("(", "OWNER TO", "RENAME TO", "SET SCHEMA");
	break; case 206:
		COMPLETE_WITH("ADD MAPPING FOR", "ALTER MAPPING",
					  "DROP MAPPING FOR",
					  "OWNER TO", "RENAME TO", "SET SCHEMA");

	/* complete ALTER TYPE <foo> with actions */
	break; case 207:
		COMPLETE_WITH("ADD ATTRIBUTE", "ADD VALUE", "ALTER ATTRIBUTE",
					  "DROP ATTRIBUTE",
					  "OWNER TO", "RENAME", "SET SCHEMA", "SET (");
	/* complete ALTER TYPE <foo> ADD with actions */
	break; case 208:
		COMPLETE_WITH("ATTRIBUTE", "VALUE");
	/* ALTER TYPE <foo> RENAME	*/
	break; case 209:
		COMPLETE_WITH("ATTRIBUTE", "TO", "VALUE");
	/* ALTER TYPE xxx RENAME (ATTRIBUTE|VALUE) yyy */
	break; case 210:
		COMPLETE_WITH("TO");
	/* ALTER TYPE xxx RENAME ATTRIBUTE yyy TO zzz */
	break; case 211:
		COMPLETE_WITH("CASCADE", "RESTRICT");

	/*
	 * If we have ALTER TYPE <sth> ALTER/DROP/RENAME ATTRIBUTE, provide list
	 * of attributes
	 */
	break; case 212:
		COMPLETE_WITH_ATTR(prev3_wd);
	/* complete ALTER TYPE ADD ATTRIBUTE <foo> with list of types */
	break; case 213:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
	/* complete ALTER TYPE ADD ATTRIBUTE <foo> <footype> with CASCADE/RESTRICT */
	break; case 214:
		COMPLETE_WITH("CASCADE", "RESTRICT");
	/* complete ALTER TYPE DROP ATTRIBUTE <foo> with CASCADE/RESTRICT */
	break; case 215:
		COMPLETE_WITH("CASCADE", "RESTRICT");
	/* ALTER TYPE ALTER ATTRIBUTE <foo> */
	break; case 216:
		COMPLETE_WITH("TYPE");
	/* ALTER TYPE ALTER ATTRIBUTE <foo> TYPE <footype> */
	break; case 217:
		COMPLETE_WITH("CASCADE", "RESTRICT");
	/* complete ALTER TYPE <sth> RENAME VALUE with list of enum values */
	break; case 218:
		COMPLETE_WITH_ENUM_VALUE(prev3_wd);
	/* ALTER TYPE <foo> SET */
	break; case 219:
		COMPLETE_WITH("(", "SCHEMA");
	/* complete ALTER TYPE <foo> SET ( with settable properties */
	break; case 220:
		COMPLETE_WITH("ANALYZE", "RECEIVE", "SEND", "STORAGE", "SUBSCRIPT",
					  "TYPMOD_IN", "TYPMOD_OUT");

	/* complete ALTER GROUP <foo> */
	break; case 221:
		COMPLETE_WITH("ADD USER", "DROP USER", "RENAME TO");
	/* complete ALTER GROUP <foo> ADD|DROP with USER */
	break; case 222:
		COMPLETE_WITH("USER");
	/* complete ALTER GROUP <foo> ADD|DROP USER with a user name */
	break; case 223:
		COMPLETE_WITH_QUERY(Query_for_list_of_roles);

/*
 * ANALYZE [ ( option [, ...] ) ] [ [ ONLY ] table_and_columns [, ...] ]
 * ANALYZE [ VERBOSE ] [ [ ONLY ] table_and_columns [, ...] ]
 */
	break; case 224:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_analyzables,
										"(", "VERBOSE", "ONLY");
	break; case 225:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_analyzables,
										"ONLY");
	break; case 226:
#line 3107 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!HeadMatches("ANALYZE", "(*)"))
#line 3108 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		/*
		 * This fires if we're in an unfinished parenthesized option list.
		 * get_previous_words treats a completed parenthesized option list as
		 * one word, so the above test is correct.
		 */
		if (ends_with(prev_wd, '(') || ends_with(prev_wd, ','))
			COMPLETE_WITH("VERBOSE", "SKIP_LOCKED", "BUFFER_USAGE_LIMIT");
		else if (TailMatches("VERBOSE|SKIP_LOCKED"))
			COMPLETE_WITH("ON", "OFF");
	}
	break; case 227:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_analyzables,
										"ONLY");
	break; case 228:
		/* "ANALYZE (" should be caught above, so assume we want columns */
		COMPLETE_WITH_ATTR(prev2_wd);
	break; case 229:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_analyzables);

/* BEGIN */
	break; case 230:
		COMPLETE_WITH("WORK", "TRANSACTION", "ISOLATION LEVEL", "READ", "DEFERRABLE", "NOT DEFERRABLE");
/* END, ABORT */
	break; case 231:
		COMPLETE_WITH("AND", "WORK", "TRANSACTION");
/* COMMIT */
	break; case 232:
		COMPLETE_WITH("AND", "WORK", "TRANSACTION", "PREPARED");
/* RELEASE SAVEPOINT */
	break; case 233:
		COMPLETE_WITH("SAVEPOINT");
/* ROLLBACK */
	break; case 234:
		COMPLETE_WITH("AND", "WORK", "TRANSACTION", "TO SAVEPOINT", "PREPARED");
	break; case 235:
		COMPLETE_WITH("CHAIN");
/* CALL */
	break; case 236:
		COMPLETE_WITH_VERSIONED_SCHEMA_QUERY(Query_for_list_of_procedures);
	break; case 237:
		COMPLETE_WITH("(");
/* CLOSE */
	break; case 238:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_cursors,
								 "ALL");
/* CLUSTER */
	break; case 239:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_clusterables,
										"VERBOSE");
	break; case 240:
#line 3160 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_clusterables);
	/* If we have CLUSTER <sth>, then add "USING" */
	break; case 241:
		COMPLETE_WITH("USING");
	/* If we have CLUSTER VERBOSE <sth>, then add "USING" */
	break; case 242:
		COMPLETE_WITH("USING");
	/* If we have CLUSTER <sth> USING, then add the index as well */
	break; case 243:
#line 3170 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_index_of_table);
	}
	break; case 244:
#line 3175 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!HeadMatches("CLUSTER", "(*)"))
#line 3176 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		/*
		 * This fires if we're in an unfinished parenthesized option list.
		 * get_previous_words treats a completed parenthesized option list as
		 * one word, so the above test is correct.
		 */
		if (ends_with(prev_wd, '(') || ends_with(prev_wd, ','))
			COMPLETE_WITH("VERBOSE");
	}

/* COMMENT */
	break; case 245:
		COMPLETE_WITH("ON");
	break; case 246:
		COMPLETE_WITH("ACCESS METHOD", "AGGREGATE", "CAST", "COLLATION",
					  "COLUMN", "CONSTRAINT", "CONVERSION", "DATABASE",
					  "DOMAIN", "EXTENSION", "EVENT TRIGGER",
					  "FOREIGN DATA WRAPPER", "FOREIGN TABLE",
					  "FUNCTION", "INDEX", "LANGUAGE", "LARGE OBJECT",
					  "MATERIALIZED VIEW", "OPERATOR", "POLICY",
					  "PROCEDURE", "PROCEDURAL LANGUAGE", "PUBLICATION", "ROLE",
					  "ROUTINE", "RULE", "SCHEMA", "SEQUENCE", "SERVER",
					  "STATISTICS", "SUBSCRIPTION", "TABLE",
					  "TABLESPACE", "TEXT SEARCH", "TRANSFORM FOR",
					  "TRIGGER", "TYPE", "VIEW");
	break; case 247:
		COMPLETE_WITH_QUERY(Query_for_list_of_access_methods);
	break; case 248:
		COMPLETE_WITH_QUERY(Query_for_all_table_constraints);
	break; case 249:
		COMPLETE_WITH("ON");
	break; case 250:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_tables_for_constraint,
										"DOMAIN");
	}
	break; case 251:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_domains);
	break; case 252:
		COMPLETE_WITH_QUERY(Query_for_list_of_event_triggers);
	break; case 253:
		COMPLETE_WITH("DATA WRAPPER", "TABLE");
	break; case 254:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_foreign_tables);
	break; case 255:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_matviews);
	break; case 256:
		COMPLETE_WITH_QUERY(Query_for_list_of_policies);
	break; case 257:
		COMPLETE_WITH("ON");
	break; case 258:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables_for_policy);
	}
	break; case 259:
		COMPLETE_WITH_QUERY(Query_for_list_of_languages);
	break; case 260:
		COMPLETE_WITH("ON");
	break; case 261:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables_for_rule);
	}
	break; case 262:
		COMPLETE_WITH("CONFIGURATION", "DICTIONARY", "PARSER", "TEMPLATE");
	break; case 263:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_ts_configurations);
	break; case 264:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_ts_dictionaries);
	break; case 265:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_ts_parsers);
	break; case 266:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_ts_templates);
	break; case 267:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
	break; case 268:
		COMPLETE_WITH("LANGUAGE");
	break; case 269:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_QUERY(Query_for_list_of_languages);
	}
	break; case 270:
		COMPLETE_WITH("ON");
	break; case 271:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables_for_trigger);
	}
	break; case 272:
#line 3271 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("IS");

/* COPY */

	/*
	 * If we have COPY, offer list of tables or "(" (Also cover the analogous
	 * backslash command).
	 */
	break; case 273:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_tables, "(");
	/* Complete COPY ( with legal query commands */
	break; case 274:
		COMPLETE_WITH("SELECT", "TABLE", "VALUES", "INSERT INTO", "UPDATE", "DELETE FROM", "MERGE INTO", "WITH");
	/* Complete COPY <sth> */
	break; case 275:
		COMPLETE_WITH("FROM", "TO");
	/* Complete COPY <sth> FROM|TO with filename */
	break; case 276:
	{
		completion_charp = "";
		completion_force_quote = true;	/* COPY requires quoted filename */
		matches = rl_completion_matches(text, complete_from_files);
	}
	break; case 277:
	{
		completion_charp = "";
		completion_force_quote = false;
		matches = rl_completion_matches(text, complete_from_files);
	}

	/* Complete COPY <sth> TO <sth> */
	break; case 278:
		COMPLETE_WITH("WITH (");

	/* Complete COPY <sth> FROM <sth> */
	break; case 279:
		COMPLETE_WITH("WITH (", "WHERE");

	/* Complete COPY <sth> FROM filename WITH ( */
	break; case 280:
		COMPLETE_WITH(Copy_from_options);

	/* Complete COPY <sth> TO filename WITH ( */
	break; case 281:
		COMPLETE_WITH(Copy_to_options);

	/* Complete COPY <sth> FROM|TO filename WITH (FORMAT */
	break; case 282:
		COMPLETE_WITH("binary", "csv", "text");

	/* Complete COPY <sth> FROM filename WITH (ON_ERROR */
	break; case 283:
		COMPLETE_WITH("stop", "ignore");

	/* Complete COPY <sth> FROM filename WITH (LOG_VERBOSITY */
	break; case 284:
		COMPLETE_WITH("silent", "default", "verbose");

	/* Complete COPY <sth> FROM <sth> WITH (<options>) */
	break; case 285:
		COMPLETE_WITH("WHERE");

	/* CREATE ACCESS METHOD */
	/* Complete "CREATE ACCESS METHOD <name>" */
	break; case 286:
		COMPLETE_WITH("TYPE");
	/* Complete "CREATE ACCESS METHOD <name> TYPE" */
	break; case 287:
		COMPLETE_WITH("INDEX", "TABLE");
	/* Complete "CREATE ACCESS METHOD <name> TYPE <type>" */
	break; case 288:
		COMPLETE_WITH("HANDLER");

	/* CREATE COLLATION */
	break; case 289:
		COMPLETE_WITH("(", "FROM");
	break; case 290:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_collations);
	break; case 291:
	{
		if (TailMatches("(|*,"))
			COMPLETE_WITH("LOCALE =", "LC_COLLATE =", "LC_CTYPE =",
						  "PROVIDER =", "DETERMINISTIC =");
		else if (TailMatches("PROVIDER", "="))
			COMPLETE_WITH("libc", "icu");
		else if (TailMatches("DETERMINISTIC", "="))
			COMPLETE_WITH("true", "false");
	}

	/* CREATE DATABASE */
	break; case 292:
		COMPLETE_WITH("OWNER", "TEMPLATE", "ENCODING", "TABLESPACE",
					  "IS_TEMPLATE", "STRATEGY",
					  "ALLOW_CONNECTIONS", "CONNECTION LIMIT",
					  "LC_COLLATE", "LC_CTYPE", "LOCALE", "OID",
					  "LOCALE_PROVIDER", "ICU_LOCALE");

	break; case 293:
		COMPLETE_WITH_QUERY(Query_for_list_of_template_databases);
	break; case 294:
		COMPLETE_WITH("WAL_LOG", "FILE_COPY");

	/* CREATE DOMAIN */
	break; case 295:
		COMPLETE_WITH("AS");
	break; case 296:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
	break; case 297:
		COMPLETE_WITH("COLLATE", "DEFAULT", "CONSTRAINT",
					  "NOT NULL", "NULL", "CHECK (");
	break; case 298:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_collations);

	/* CREATE EXTENSION */
	/* Complete with available extensions rather than installed ones. */
	break; case 299:
		COMPLETE_WITH_QUERY(Query_for_list_of_available_extensions);
	/* CREATE EXTENSION <name> */
	break; case 300:
		COMPLETE_WITH("WITH SCHEMA", "CASCADE", "VERSION");
	/* CREATE EXTENSION <name> VERSION */
	break; case 301:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_QUERY(Query_for_list_of_available_extension_versions);
	}

	/* CREATE FOREIGN */
	break; case 302:
		COMPLETE_WITH("DATA WRAPPER", "TABLE");

	/* CREATE FOREIGN DATA WRAPPER */
	break; case 303:
		COMPLETE_WITH("HANDLER", "VALIDATOR", "OPTIONS");

	/* CREATE FOREIGN TABLE */
	break; case 304:
		COMPLETE_WITH("(", "PARTITION OF");

	/* CREATE INDEX --- is allowed inside CREATE SCHEMA, so use TailMatches */
	/* First off we complete CREATE UNIQUE with "INDEX" */
	break; case 305:
		COMPLETE_WITH("INDEX");

	/*
	 * If we have CREATE|UNIQUE INDEX, then add "ON", "CONCURRENTLY", and
	 * existing indexes
	 */
	break; case 306:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_indexes,
										"ON", "CONCURRENTLY");

	/*
	 * Complete ... INDEX|CONCURRENTLY [<name>] ON with a list of relations
	 * that indexes can be created on
	 */
	break; case 307:
#line 3429 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_indexables);

	/*
	 * Complete CREATE|UNIQUE INDEX CONCURRENTLY with "ON" and existing
	 * indexes
	 */
	break; case 308:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_indexes,
										"ON");
	/* Complete CREATE|UNIQUE INDEX [CONCURRENTLY] <sth> with "ON" */
	break; case 309:
#line 3441 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ON");

	/*
	 * Complete INDEX <name> ON <table> with a list of table columns (which
	 * should really be in parens)
	 */
	break; case 310:
#line 3449 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("(", "USING");
	break; case 311:
#line 3452 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_ATTR(prev2_wd);
	/* same if you put in USING */
	break; case 312:
		COMPLETE_WITH_ATTR(prev4_wd);
	/* Complete USING with an index method */
	break; case 313:
#line 3460 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY(Query_for_list_of_index_access_methods);
	break; case 314:
#line 3463 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("POLICY", MatchAny, MatchAny, MatchAny, MatchAny, MatchAny) && !TailMatches("FOR", MatchAny, MatchAny, MatchAny))
#line 3464 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("(");

	/* CREATE OR REPLACE */
	break; case 315:
		COMPLETE_WITH("REPLACE");

	/* CREATE POLICY */
	/* Complete "CREATE POLICY <name> ON" */
	break; case 316:
		COMPLETE_WITH("ON");
	/* Complete "CREATE POLICY <name> ON <table>" */
	break; case 317:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);
	/* Complete "CREATE POLICY <name> ON <table> AS|FOR|TO|USING|WITH CHECK" */
	break; case 318:
		COMPLETE_WITH("AS", "FOR", "TO", "USING (", "WITH CHECK (");
	/* CREATE POLICY <name> ON <table> AS PERMISSIVE|RESTRICTIVE */
	break; case 319:
		COMPLETE_WITH("PERMISSIVE", "RESTRICTIVE");

	/*
	 * CREATE POLICY <name> ON <table> AS PERMISSIVE|RESTRICTIVE
	 * FOR|TO|USING|WITH CHECK
	 */
	break; case 320:
		COMPLETE_WITH("FOR", "TO", "USING", "WITH CHECK");
	/* CREATE POLICY <name> ON <table> FOR ALL|SELECT|INSERT|UPDATE|DELETE */
	break; case 321:
		COMPLETE_WITH("ALL", "SELECT", "INSERT", "UPDATE", "DELETE");
	/* Complete "CREATE POLICY <name> ON <table> FOR INSERT TO|WITH CHECK" */
	break; case 322:
		COMPLETE_WITH("TO", "WITH CHECK (");
	/* Complete "CREATE POLICY <name> ON <table> FOR SELECT|DELETE TO|USING" */
	break; case 323:
		COMPLETE_WITH("TO", "USING (");
	/* CREATE POLICY <name> ON <table> FOR ALL|UPDATE TO|USING|WITH CHECK */
	break; case 324:
		COMPLETE_WITH("TO", "USING (", "WITH CHECK (");
	/* Complete "CREATE POLICY <name> ON <table> TO <role>" */
	break; case 325:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
								 Keywords_for_list_of_grant_roles);
	/* Complete "CREATE POLICY <name> ON <table> USING (" */
	break; case 326:
		COMPLETE_WITH("(");

	/*
	 * CREATE POLICY <name> ON <table> AS PERMISSIVE|RESTRICTIVE FOR
	 * ALL|SELECT|INSERT|UPDATE|DELETE
	 */
	break; case 327:
		COMPLETE_WITH("ALL", "SELECT", "INSERT", "UPDATE", "DELETE");

	/*
	 * Complete "CREATE POLICY <name> ON <table> AS PERMISSIVE|RESTRICTIVE FOR
	 * INSERT TO|WITH CHECK"
	 */
	break; case 328:
		COMPLETE_WITH("TO", "WITH CHECK (");

	/*
	 * Complete "CREATE POLICY <name> ON <table> AS PERMISSIVE|RESTRICTIVE FOR
	 * SELECT|DELETE TO|USING"
	 */
	break; case 329:
		COMPLETE_WITH("TO", "USING (");

	/*
	 * CREATE POLICY <name> ON <table> AS PERMISSIVE|RESTRICTIVE FOR
	 * ALL|UPDATE TO|USING|WITH CHECK
	 */
	break; case 330:
		COMPLETE_WITH("TO", "USING (", "WITH CHECK (");

	/*
	 * Complete "CREATE POLICY <name> ON <table> AS PERMISSIVE|RESTRICTIVE TO
	 * <role>"
	 */
	break; case 331:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
								 Keywords_for_list_of_grant_roles);

	/*
	 * Complete "CREATE POLICY <name> ON <table> AS PERMISSIVE|RESTRICTIVE
	 * USING ("
	 */
	break; case 332:
		COMPLETE_WITH("(");


/* CREATE PUBLICATION */
	break; case 333:
		COMPLETE_WITH("FOR TABLE", "FOR ALL TABLES", "FOR TABLES IN SCHEMA", "WITH (");
	break; case 334:
		COMPLETE_WITH("TABLE", "ALL TABLES", "TABLES IN SCHEMA");
	break; case 335:
		COMPLETE_WITH("TABLES");
	break; case 336:
		COMPLETE_WITH("WITH (");
	break; case 337:
		COMPLETE_WITH("IN SCHEMA");
	break; case 338:
#line 3565 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!ends_with(prev_wd, ','))
		COMPLETE_WITH("WHERE (", "WITH (");
	/* Complete "CREATE PUBLICATION <name> FOR TABLE" with "<table>, ..." */
	break; case 339:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);

	/*
	 * "CREATE PUBLICATION <name> FOR TABLE <name> WHERE (" - complete with
	 * table attributes
	 */
	break; case 340:
		COMPLETE_WITH("(");
	break; case 341:
		COMPLETE_WITH_ATTR(prev3_wd);
	break; case 342:
		COMPLETE_WITH(" WITH (");

	/*
	 * Complete "CREATE PUBLICATION <name> FOR TABLES IN SCHEMA <schema>, ..."
	 */
	break; case 343:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_schemas
								 " AND nspname NOT LIKE E'pg\\\\_%%'",
								 "CURRENT_SCHEMA");
	break; case 344:
#line 3589 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if ((!ends_with(prev_wd, ',')))
		COMPLETE_WITH("WITH (");
	/* Complete "CREATE PUBLICATION <name> [...] WITH" */
	break; case 345:
		COMPLETE_WITH("publish", "publish_generated_columns", "publish_via_partition_root");

/* CREATE RULE */
	/* Complete "CREATE [ OR REPLACE ] RULE <sth>" with "AS ON" */
	break; case 346:
#line 3599 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("AS ON");
	/* Complete "CREATE [ OR REPLACE ] RULE <sth> AS" with "ON" */
	break; case 347:
#line 3603 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ON");

	/*
	 * Complete "CREATE [ OR REPLACE ] RULE <sth> AS ON" with
	 * SELECT|UPDATE|INSERT|DELETE
	 */
	break; case 348:
#line 3611 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("SELECT", "UPDATE", "INSERT", "DELETE");
	/* Complete "AS ON SELECT|UPDATE|INSERT|DELETE" with a "TO" */
	break; case 349:
		COMPLETE_WITH("TO");
	/* Complete "AS ON <sth> TO" with a table name */
	break; case 350:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);

/* CREATE SCHEMA [ <name> ] [ AUTHORIZATION ] */
	break; case 351:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_schemas,
								 "AUTHORIZATION");
	break; case 352:
#line 3625 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
								 Keywords_for_list_of_owner_roles);
	break; case 353:
#line 3629 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("CREATE", "GRANT");
	break; case 354:
		COMPLETE_WITH("AUTHORIZATION", "CREATE", "GRANT");

/* CREATE SEQUENCE --- is allowed inside CREATE SCHEMA, so use TailMatches */
	break; case 355:
#line 3636 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("AS", "INCREMENT BY", "MINVALUE", "MAXVALUE", "NO",
					  "CACHE", "CYCLE", "OWNED BY", "START WITH");
	break; case 356:
#line 3640 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_CS("smallint", "integer", "bigint");
	break; case 357:
#line 3643 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("MINVALUE", "MAXVALUE", "CYCLE");

/* CREATE SERVER <name> */
	break; case 358:
		COMPLETE_WITH("TYPE", "VERSION", "FOREIGN DATA WRAPPER");

/* CREATE STATISTICS <name> */
	break; case 359:
		COMPLETE_WITH("(", "ON");
	break; case 360:
		COMPLETE_WITH("ndistinct", "dependencies", "mcv");
	break; case 361:
		COMPLETE_WITH("ON");
	break; case 362:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);

/* CREATE TABLE --- is allowed inside CREATE SCHEMA, so use TailMatches */
	/* Complete "CREATE TEMP/TEMPORARY" with the possible temp objects */
	break; case 363:
		COMPLETE_WITH("SEQUENCE", "TABLE", "VIEW");
	/* Complete "CREATE UNLOGGED" with TABLE or SEQUENCE */
	break; case 364:
		COMPLETE_WITH("TABLE", "SEQUENCE");
	/* Complete PARTITION BY with RANGE ( or LIST ( or ... */
	break; case 365:
		COMPLETE_WITH("RANGE (", "LIST (", "HASH (");
	/* If we have xxx PARTITION OF, provide a list of partitioned tables */
	break; case 366:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_partitioned_tables);
	/* Limited completion support for partition bound specification */
	break; case 367:
		COMPLETE_WITH("FOR VALUES", "DEFAULT");
	/* Complete CREATE TABLE <name> with '(', AS, OF or PARTITION OF */
	break; case 368:
#line 3678 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("(", "AS", "OF", "PARTITION OF");
	/* Complete CREATE TABLE <name> OF with list of composite types */
	break; case 369:
#line 3682 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_composite_datatypes);
	/* Complete CREATE TABLE <name> [ (...) ] AS with list of keywords */
	break; case 370:
#line 3688 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("EXECUTE", "SELECT", "TABLE", "VALUES", "WITH");
	/* Complete CREATE TABLE name (...) with supported options */
	break; case 371:
		COMPLETE_WITH("AS", "INHERITS (", "PARTITION BY", "USING", "TABLESPACE", "WITH (");
	break; case 372:
		COMPLETE_WITH("AS", "INHERITS (", "USING", "TABLESPACE", "WITH (");
	break; case 373:
		COMPLETE_WITH("AS", "INHERITS (", "ON COMMIT", "PARTITION BY", "USING",
					  "TABLESPACE", "WITH (");
	/* Complete CREATE TABLE (...) USING with table access methods */
	break; case 374:
#line 3700 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY(Query_for_list_of_table_access_methods);
	/* Complete CREATE TABLE (...) WITH with storage parameters */
	break; case 375:
#line 3704 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_LIST(table_storage_parameters);
	/* Complete CREATE TABLE ON COMMIT with actions */
	break; case 376:
		COMPLETE_WITH("DELETE ROWS", "DROP", "PRESERVE ROWS");

/* CREATE TABLESPACE */
	break; case 377:
		COMPLETE_WITH("OWNER", "LOCATION");
	/* Complete CREATE TABLESPACE name OWNER name with "LOCATION" */
	break; case 378:
		COMPLETE_WITH("LOCATION");

/* CREATE TEXT SEARCH */
	break; case 379:
		COMPLETE_WITH("CONFIGURATION", "DICTIONARY", "PARSER", "TEMPLATE");
	break; case 380:
		COMPLETE_WITH("(");

/* CREATE TRANSFORM */
	break; case 381:
#line 3725 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("FOR");
	break; case 382:
#line 3728 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
	break; case 383:
#line 3731 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("LANGUAGE");
	break; case 384:
#line 3734 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_QUERY(Query_for_list_of_languages);
	}

/* CREATE SUBSCRIPTION */
	break; case 385:
		COMPLETE_WITH("CONNECTION");
	break; case 386:
		COMPLETE_WITH("PUBLICATION");
	break; case 387:
#line 3746 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		/* complete with nothing here as this refers to remote publications */
	}
	break; case 388:
		COMPLETE_WITH("WITH (");
	/* Complete "CREATE SUBSCRIPTION <name> ...  WITH ( <opt>" */
	break; case 389:
		COMPLETE_WITH("binary", "connect", "copy_data", "create_slot",
					  "disable_on_error", "enabled", "failover", "origin",
					  "password_required", "run_as_owner", "slot_name",
					  "streaming", "synchronous_commit", "two_phase");

/* CREATE TRIGGER --- is allowed inside CREATE SCHEMA, so use TailMatches */

	/*
	 * Complete CREATE [ OR REPLACE ] TRIGGER <name> with BEFORE|AFTER|INSTEAD
	 * OF.
	 */
	break; case 390:
#line 3766 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("BEFORE", "AFTER", "INSTEAD OF");

	/*
	 * Complete CREATE [ OR REPLACE ] TRIGGER <name> BEFORE,AFTER with an
	 * event.
	 */
	break; case 391:
#line 3774 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("INSERT", "DELETE", "UPDATE", "TRUNCATE");
	/* Complete CREATE [ OR REPLACE ] TRIGGER <name> INSTEAD OF with an event */
	break; case 392:
#line 3778 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("INSERT", "DELETE", "UPDATE");

	/*
	 * Complete CREATE [ OR REPLACE ] TRIGGER <name> BEFORE,AFTER sth with
	 * OR|ON.
	 */
	break; case 393:
#line 3788 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ON", "OR");

	/*
	 * Complete CREATE [ OR REPLACE ] TRIGGER <name> BEFORE,AFTER event ON
	 * with a list of tables.  EXECUTE FUNCTION is the recommended grammar
	 * instead of EXECUTE PROCEDURE in version 11 and upwards.
	 */
	break; case 394:
#line 3797 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);

	/*
	 * Complete CREATE [ OR REPLACE ] TRIGGER ... INSTEAD OF event ON with a
	 * list of views.
	 */
	break; case 395:
#line 3805 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_views);
	break; case 396:
#line 3810 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (pset.sversion >= 110000)
			COMPLETE_WITH("NOT DEFERRABLE", "DEFERRABLE", "INITIALLY",
						  "REFERENCING", "FOR", "WHEN (", "EXECUTE FUNCTION");
		else
			COMPLETE_WITH("NOT DEFERRABLE", "DEFERRABLE", "INITIALLY",
						  "REFERENCING", "FOR", "WHEN (", "EXECUTE PROCEDURE");
	}
	break; case 397:
#line 3826 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (pset.sversion >= 110000)
			COMPLETE_WITH("REFERENCING", "FOR", "WHEN (", "EXECUTE FUNCTION");
		else
			COMPLETE_WITH("REFERENCING", "FOR", "WHEN (", "EXECUTE PROCEDURE");
	}
	break; case 398:
#line 3836 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("OLD TABLE", "NEW TABLE");
	break; case 399:
#line 3841 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("AS");
	break; case 400:
#line 3850 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (pset.sversion >= 110000)
			COMPLETE_WITH("NEW TABLE", "FOR", "WHEN (", "EXECUTE FUNCTION");
		else
			COMPLETE_WITH("NEW TABLE", "FOR", "WHEN (", "EXECUTE PROCEDURE");
	}
	break; case 401:
#line 3864 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (pset.sversion >= 110000)
			COMPLETE_WITH("OLD TABLE", "FOR", "WHEN (", "EXECUTE FUNCTION");
		else
			COMPLETE_WITH("OLD TABLE", "FOR", "WHEN (", "EXECUTE PROCEDURE");
	}
	break; case 402:
#line 3886 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (pset.sversion >= 110000)
			COMPLETE_WITH("FOR", "WHEN (", "EXECUTE FUNCTION");
		else
			COMPLETE_WITH("FOR", "WHEN (", "EXECUTE PROCEDURE");
	}
	break; case 403:
#line 3896 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("EACH", "ROW", "STATEMENT");
	break; case 404:
#line 3901 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ROW", "STATEMENT");
	break; case 405:
#line 3910 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (pset.sversion >= 110000)
			COMPLETE_WITH("WHEN (", "EXECUTE FUNCTION");
		else
			COMPLETE_WITH("WHEN (", "EXECUTE PROCEDURE");
	}
	break; case 406:
#line 3920 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (pset.sversion >= 110000)
			COMPLETE_WITH("EXECUTE FUNCTION");
		else
			COMPLETE_WITH("EXECUTE PROCEDURE");
	}

	/*
	 * Complete CREATE [ OR REPLACE ] TRIGGER ... EXECUTE with
	 * PROCEDURE|FUNCTION.
	 */
	break; case 407:
#line 3935 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (pset.sversion >= 110000)
			COMPLETE_WITH("FUNCTION");
		else
			COMPLETE_WITH("PROCEDURE");
	}
	break; case 408:
#line 3945 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_VERSIONED_SCHEMA_QUERY(Query_for_list_of_functions);

/* CREATE ROLE,USER,GROUP <name> */
	break; case 409:
#line 3949 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("USER", "MAPPING"))
#line 3950 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ADMIN", "BYPASSRLS", "CONNECTION LIMIT", "CREATEDB",
					  "CREATEROLE", "ENCRYPTED PASSWORD", "IN", "INHERIT",
					  "LOGIN", "NOBYPASSRLS",
					  "NOCREATEDB", "NOCREATEROLE", "NOINHERIT",
					  "NOLOGIN", "NOREPLICATION", "NOSUPERUSER", "PASSWORD",
					  "REPLICATION", "ROLE", "SUPERUSER", "SYSID",
					  "VALID UNTIL", "WITH");

/* CREATE ROLE,USER,GROUP <name> WITH */
	break; case 410:
		/* Similar to the above, but don't complete "WITH" again. */
		COMPLETE_WITH("ADMIN", "BYPASSRLS", "CONNECTION LIMIT", "CREATEDB",
					  "CREATEROLE", "ENCRYPTED PASSWORD", "IN", "INHERIT",
					  "LOGIN", "NOBYPASSRLS",
					  "NOCREATEDB", "NOCREATEROLE", "NOINHERIT",
					  "NOLOGIN", "NOREPLICATION", "NOSUPERUSER", "PASSWORD",
					  "REPLICATION", "ROLE", "SUPERUSER", "SYSID",
					  "VALID UNTIL");

	/* complete CREATE ROLE,USER,GROUP <name> IN with ROLE,GROUP */
	break; case 411:
		COMPLETE_WITH("GROUP", "ROLE");

/* CREATE TYPE */
	break; case 412:
		COMPLETE_WITH("(", "AS");
	break; case 413:
		COMPLETE_WITH("ENUM", "RANGE", "(");
	break; case 414:
	{
		if (TailMatches("(|*,", MatchAny))
			COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
		else if (TailMatches("(|*,", MatchAny, MatchAnyExcept("*)")))
			COMPLETE_WITH("COLLATE", ",", ")");
	}
	break; case 415:
		COMPLETE_WITH("(");
	break; case 416:
	{
		if (TailMatches("(|*,"))
			COMPLETE_WITH("INPUT", "OUTPUT", "RECEIVE", "SEND",
						  "TYPMOD_IN", "TYPMOD_OUT", "ANALYZE", "SUBSCRIPT",
						  "INTERNALLENGTH", "PASSEDBYVALUE", "ALIGNMENT",
						  "STORAGE", "LIKE", "CATEGORY", "PREFERRED",
						  "DEFAULT", "ELEMENT", "DELIMITER",
						  "COLLATABLE");
		else if (TailMatches("(*|*,", MatchAnyExcept("*=")))
			COMPLETE_WITH("=");
		else if (TailMatches("=", MatchAnyExcept("*)")))
			COMPLETE_WITH(",", ")");
	}
	break; case 417:
	{
		if (TailMatches("(|*,"))
			COMPLETE_WITH("SUBTYPE", "SUBTYPE_OPCLASS", "COLLATION",
						  "CANONICAL", "SUBTYPE_DIFF",
						  "MULTIRANGE_TYPE_NAME");
		else if (TailMatches("(*|*,", MatchAnyExcept("*=")))
			COMPLETE_WITH("=");
		else if (TailMatches("=", MatchAnyExcept("*)")))
			COMPLETE_WITH(",", ")");
	}

/* CREATE VIEW --- is allowed inside CREATE SCHEMA, so use TailMatches */
	/* Complete CREATE [ OR REPLACE ] VIEW <name> with AS or WITH */
	break; case 418:
#line 4017 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("AS", "WITH");
	/* Complete "CREATE [ OR REPLACE ] VIEW <sth> AS with "SELECT" */
	break; case 419:
#line 4021 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("SELECT");
	/* CREATE [ OR REPLACE ] VIEW <name> WITH ( yyy [= zzz] ) */
	break; case 420:
#line 4025 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("(");
	break; case 421:
#line 4028 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_LIST(view_optional_parameters);
	break; case 422:
#line 4031 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("=");
	break; case 423:
#line 4034 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("local", "cascaded");
	/* CREATE [ OR REPLACE ] VIEW <name> WITH ( ... ) AS */
	break; case 424:
#line 4038 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("AS");
	/* CREATE [ OR REPLACE ] VIEW <name> WITH ( ... ) AS SELECT */
	break; case 425:
#line 4042 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("SELECT");

/* CREATE MATERIALIZED VIEW */
	break; case 426:
		COMPLETE_WITH("VIEW");
	/* Complete CREATE MATERIALIZED VIEW <name> with AS or USING */
	break; case 427:
		COMPLETE_WITH("AS", "USING");

	/*
	 * Complete CREATE MATERIALIZED VIEW <name> USING with list of access
	 * methods
	 */
	break; case 428:
		COMPLETE_WITH_QUERY(Query_for_list_of_table_access_methods);
	/* Complete CREATE MATERIALIZED VIEW <name> USING <access method> with AS */
	break; case 429:
		COMPLETE_WITH("AS");

	/*
	 * Complete CREATE MATERIALIZED VIEW <name> [USING <access method> ] AS
	 * with "SELECT"
	 */
	break; case 430:
#line 4067 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("SELECT");

/* CREATE EVENT TRIGGER */
	break; case 431:
		COMPLETE_WITH("TRIGGER");
	/* Complete CREATE EVENT TRIGGER <name> with ON */
	break; case 432:
		COMPLETE_WITH("ON");
	/* Complete CREATE EVENT TRIGGER <name> ON with event_type */
	break; case 433:
		COMPLETE_WITH("ddl_command_start", "ddl_command_end", "login",
					  "sql_drop", "table_rewrite");

	/*
	 * Complete CREATE EVENT TRIGGER <name> ON <event_type>.  EXECUTE FUNCTION
	 * is the recommended grammar instead of EXECUTE PROCEDURE in version 11
	 * and upwards.
	 */
	break; case 434:
	{
		if (pset.sversion >= 110000)
			COMPLETE_WITH("WHEN TAG IN (", "EXECUTE FUNCTION");
		else
			COMPLETE_WITH("WHEN TAG IN (", "EXECUTE PROCEDURE");
	}
	break; case 435:
	{
		if (pset.sversion >= 110000)
			COMPLETE_WITH("EXECUTE FUNCTION");
		else
			COMPLETE_WITH("EXECUTE PROCEDURE");
	}
	break; case 436:
		COMPLETE_WITH_VERSIONED_SCHEMA_QUERY(Query_for_list_of_functions);

/* DEALLOCATE */
	break; case 437:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_prepared_statements,
								 "ALL");

/* DECLARE */

	/*
	 * Complete DECLARE <name> with one of BINARY, ASENSITIVE, INSENSITIVE,
	 * SCROLL, NO SCROLL, and CURSOR.
	 */
	break; case 438:
		COMPLETE_WITH("BINARY", "ASENSITIVE", "INSENSITIVE", "SCROLL", "NO SCROLL",
					  "CURSOR");

	/*
	 * Complete DECLARE ... <option> with other options. The PostgreSQL parser
	 * allows DECLARE options to be specified in any order. But the
	 * tab-completion follows the ordering of them that the SQL standard
	 * provides, like the syntax of DECLARE command in the documentation
	 * indicates.
	 */
	break; case 439:
		COMPLETE_WITH("ASENSITIVE", "INSENSITIVE", "SCROLL", "NO SCROLL", "CURSOR");
	break; case 440:
		COMPLETE_WITH("SCROLL", "NO SCROLL", "CURSOR");
	break; case 441:
		COMPLETE_WITH("CURSOR");
	/* Complete DECLARE ... [options] NO with SCROLL */
	break; case 442:
		COMPLETE_WITH("SCROLL");

	/*
	 * Complete DECLARE ... CURSOR with one of WITH HOLD, WITHOUT HOLD, and
	 * FOR
	 */
	break; case 443:
		COMPLETE_WITH("WITH HOLD", "WITHOUT HOLD", "FOR");
	/* Complete DECLARE ... CURSOR WITH|WITHOUT with HOLD */
	break; case 444:
		COMPLETE_WITH("HOLD");
	/* Complete DECLARE ... CURSOR WITH|WITHOUT HOLD with FOR */
	break; case 445:
		COMPLETE_WITH("FOR");

/* DELETE --- can be inside EXPLAIN, RULE, etc */
	/* Complete DELETE with "FROM" */
	break; case 446:
		COMPLETE_WITH("FROM");
	/* Complete DELETE FROM with a list of tables */
	break; case 447:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_updatables);
	/* Complete DELETE FROM <table> */
	break; case 448:
		COMPLETE_WITH("USING", "WHERE");
	/* XXX: implement tab completion for DELETE ... USING */

/* DISCARD */
	break; case 449:
		COMPLETE_WITH("ALL", "PLANS", "SEQUENCES", "TEMP");

/* DO */
	break; case 450:
		COMPLETE_WITH("LANGUAGE");

/* DROP */
	/* Complete DROP object with CASCADE / RESTRICT */
	break; case 451:
#line 4177 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("CASCADE", "RESTRICT");
	break; case 452:
#line 4179 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (ends_with(prev_wd, ')'))
#line 4180 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("CASCADE", "RESTRICT");

	/* help completing some of the variants */
	break; case 453:
		COMPLETE_WITH("(");
	break; case 454:
		COMPLETE_WITH_FUNCTION_ARG(prev2_wd);
	break; case 455:
		COMPLETE_WITH("DATA WRAPPER", "TABLE");
	break; case 456:
		COMPLETE_WITH("WITH (");
	break; case 457:
#line 4191 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if ((ends_with(prev_wd, '(')))
		COMPLETE_WITH("FORCE");

	/* DROP INDEX */
	break; case 458:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_indexes,
										"CONCURRENTLY");
	break; case 459:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_indexes);
	break; case 460:
		COMPLETE_WITH("CASCADE", "RESTRICT");
	break; case 461:
		COMPLETE_WITH("CASCADE", "RESTRICT");

	/* DROP MATERIALIZED VIEW */
	break; case 462:
		COMPLETE_WITH("VIEW");
	break; case 463:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_matviews);
	break; case 464:
		COMPLETE_WITH("CASCADE", "RESTRICT");

	/* DROP OWNED BY */
	break; case 465:
		COMPLETE_WITH("BY");
	break; case 466:
		COMPLETE_WITH_QUERY(Query_for_list_of_roles);
	break; case 467:
		COMPLETE_WITH("CASCADE", "RESTRICT");

	/* DROP TEXT SEARCH */
	break; case 468:
		COMPLETE_WITH("CONFIGURATION", "DICTIONARY", "PARSER", "TEMPLATE");

	/* DROP TRIGGER */
	break; case 469:
		COMPLETE_WITH("ON");
	break; case 470:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables_for_trigger);
	}
	break; case 471:
		COMPLETE_WITH("CASCADE", "RESTRICT");

	/* DROP ACCESS METHOD */
	break; case 472:
		COMPLETE_WITH("METHOD");
	break; case 473:
		COMPLETE_WITH_QUERY(Query_for_list_of_access_methods);

	/* DROP EVENT TRIGGER */
	break; case 474:
		COMPLETE_WITH("TRIGGER");
	break; case 475:
		COMPLETE_WITH_QUERY(Query_for_list_of_event_triggers);

	/* DROP POLICY <name>  */
	break; case 476:
		COMPLETE_WITH_QUERY(Query_for_list_of_policies);
	/* DROP POLICY <name> ON */
	break; case 477:
		COMPLETE_WITH("ON");
	/* DROP POLICY <name> ON <table> */
	break; case 478:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables_for_policy);
	}
	break; case 479:
		COMPLETE_WITH("CASCADE", "RESTRICT");

	/* DROP RULE */
	break; case 480:
		COMPLETE_WITH("ON");
	break; case 481:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables_for_rule);
	}
	break; case 482:
		COMPLETE_WITH("CASCADE", "RESTRICT");

	/* DROP TRANSFORM */
	break; case 483:
		COMPLETE_WITH("FOR");
	break; case 484:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
	break; case 485:
		COMPLETE_WITH("LANGUAGE");
	break; case 486:
	{
		set_completion_reference(prev2_wd);
		COMPLETE_WITH_QUERY(Query_for_list_of_languages);
	}
	break; case 487:
		COMPLETE_WITH("CASCADE", "RESTRICT");

/* EXECUTE */
	break; case 488:
		COMPLETE_WITH_QUERY(Query_for_list_of_prepared_statements);

/*
 * EXPLAIN [ ( option [, ...] ) ] statement
 * EXPLAIN [ ANALYZE ] [ VERBOSE ] statement
 */
	break; case 489:
		COMPLETE_WITH("SELECT", "INSERT INTO", "DELETE FROM", "UPDATE", "DECLARE",
					  "MERGE INTO", "EXECUTE", "ANALYZE", "VERBOSE");
	break; case 490:
#line 4301 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!HeadMatches("EXPLAIN", "(*)"))
#line 4302 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		/*
		 * This fires if we're in an unfinished parenthesized option list.
		 * get_previous_words treats a completed parenthesized option list as
		 * one word, so the above test is correct.
		 */
		if (ends_with(prev_wd, '(') || ends_with(prev_wd, ','))
			COMPLETE_WITH("ANALYZE", "VERBOSE", "COSTS", "SETTINGS", "GENERIC_PLAN",
						  "BUFFERS", "SERIALIZE", "WAL", "TIMING", "SUMMARY",
						  "MEMORY", "FORMAT");
		else if (TailMatches("ANALYZE|VERBOSE|COSTS|SETTINGS|GENERIC_PLAN|BUFFERS|WAL|TIMING|SUMMARY|MEMORY"))
			COMPLETE_WITH("ON", "OFF");
		else if (TailMatches("SERIALIZE"))
			COMPLETE_WITH("TEXT", "NONE", "BINARY");
		else if (TailMatches("FORMAT"))
			COMPLETE_WITH("TEXT", "XML", "JSON", "YAML");
	}
	break; case 491:
		COMPLETE_WITH("SELECT", "INSERT INTO", "DELETE FROM", "UPDATE", "DECLARE",
					  "MERGE INTO", "EXECUTE", "VERBOSE");
	break; case 492:
#line 4325 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("SELECT", "INSERT INTO", "DELETE FROM", "UPDATE", "DECLARE",
					  "MERGE INTO", "EXECUTE");

/* FETCH && MOVE */

	/*
	 * Complete FETCH with one of ABSOLUTE, BACKWARD, FORWARD, RELATIVE, ALL,
	 * NEXT, PRIOR, FIRST, LAST, FROM, IN, and a list of cursors
	 */
	break; case 493:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_cursors,
								 "ABSOLUTE",
								 "BACKWARD",
								 "FORWARD",
								 "RELATIVE",
								 "ALL",
								 "NEXT",
								 "PRIOR",
								 "FIRST",
								 "LAST",
								 "FROM",
								 "IN");

	/*
	 * Complete FETCH BACKWARD or FORWARD with one of ALL, FROM, IN, and a
	 * list of cursors
	 */
	break; case 494:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_cursors,
								 "ALL",
								 "FROM",
								 "IN");

	/*
	 * Complete FETCH <direction> with "FROM" or "IN". These are equivalent,
	 * but we may as well tab-complete both: perhaps some users prefer one
	 * variant or the other.
	 */
	break; case 495:
#line 4366 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_cursors,
								 "FROM",
								 "IN");
	/* Complete FETCH <direction> "FROM" or "IN" with a list of cursors */
	break; case 496:
		COMPLETE_WITH_QUERY(Query_for_list_of_cursors);

/* FOREIGN DATA WRAPPER */
	/* applies in ALTER/DROP FDW and in CREATE SERVER */
	break; case 497:
#line 4376 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("CREATE", MatchAny, MatchAny, MatchAny))
#line 4377 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY(Query_for_list_of_fdws);
	/* applies in CREATE SERVER */
	break; case 498:
		COMPLETE_WITH("OPTIONS");

/* FOREIGN TABLE */
	break; case 499:
#line 4384 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("CREATE", MatchAny, MatchAny))
#line 4385 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_foreign_tables);

/* FOREIGN SERVER */
	break; case 500:
		COMPLETE_WITH_QUERY(Query_for_list_of_servers);

/*
 * GRANT and REVOKE are allowed inside CREATE SCHEMA and
 * ALTER DEFAULT PRIVILEGES, so use TailMatches
 */
	/* Complete GRANT/REVOKE with a list of roles and privileges */
	break; case 501:
#line 4398 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		/*
		 * With ALTER DEFAULT PRIVILEGES, restrict completion to grantable
		 * privileges (can't grant roles)
		 */
		if (HeadMatches("ALTER", "DEFAULT", "PRIVILEGES"))
		{
			if (TailMatches("GRANT") ||
				TailMatches("REVOKE", "GRANT", "OPTION", "FOR"))
				COMPLETE_WITH("SELECT", "INSERT", "UPDATE",
							  "DELETE", "TRUNCATE", "REFERENCES", "TRIGGER",
							  "CREATE", "EXECUTE", "USAGE", "MAINTAIN", "ALL");
			else if (TailMatches("REVOKE"))
				COMPLETE_WITH("SELECT", "INSERT", "UPDATE",
							  "DELETE", "TRUNCATE", "REFERENCES", "TRIGGER",
							  "CREATE", "EXECUTE", "USAGE", "MAINTAIN", "ALL",
							  "GRANT OPTION FOR");
		}
		else if (TailMatches("GRANT"))
			COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
									 Privilege_options_of_grant_and_revoke);
		else if (TailMatches("REVOKE"))
			COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
									 Privilege_options_of_grant_and_revoke,
									 "GRANT OPTION FOR",
									 "ADMIN OPTION FOR",
									 "INHERIT OPTION FOR",
									 "SET OPTION FOR");
		else if (TailMatches("REVOKE", "GRANT", "OPTION", "FOR"))
			COMPLETE_WITH(Privilege_options_of_grant_and_revoke);
		else if (TailMatches("REVOKE", "ADMIN|INHERIT|SET", "OPTION", "FOR"))
			COMPLETE_WITH_QUERY(Query_for_list_of_roles);
	}

	break; case 502:
#line 4434 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("SYSTEM");

	break; case 503:
		COMPLETE_WITH("ON PARAMETER", "OPTION FOR");
	break; case 504:
#line 4442 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ON PARAMETER");

	break; case 505:
#line 4448 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY_VERBATIM(Query_for_list_of_alter_system_set_vars);

	break; case 506:
#line 4452 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("TO");

	break; case 507:
#line 4458 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("FROM");

	/*
	 * Complete GRANT/REVOKE <privilege> with "ON", GRANT/REVOKE <role> with
	 * TO/FROM
	 */
	break; case 508:
#line 4466 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (TailMatches("SELECT|INSERT|UPDATE|DELETE|TRUNCATE|REFERENCES|TRIGGER|CREATE|CONNECT|TEMPORARY|TEMP|EXECUTE|USAGE|MAINTAIN|ALL"))
			COMPLETE_WITH("ON");
		else if (TailMatches("GRANT", MatchAny))
			COMPLETE_WITH("TO");
		else
			COMPLETE_WITH("FROM");
	}

	/*
	 * Complete GRANT/REVOKE <sth> ON with a list of appropriate relations.
	 *
	 * Note: GRANT/REVOKE can get quite complex; tab-completion as implemented
	 * here will only work if the privilege list contains exactly one
	 * privilege.
	 */
	break; case 509:
#line 4484 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		/*
		 * With ALTER DEFAULT PRIVILEGES, restrict completion to the kinds of
		 * objects supported.
		 */
		if (HeadMatches("ALTER", "DEFAULT", "PRIVILEGES"))
			COMPLETE_WITH("TABLES", "SEQUENCES", "FUNCTIONS", "PROCEDURES", "ROUTINES", "TYPES", "SCHEMAS", "LARGE OBJECTS");
		else
			COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_grantables,
											"ALL FUNCTIONS IN SCHEMA",
											"ALL PROCEDURES IN SCHEMA",
											"ALL ROUTINES IN SCHEMA",
											"ALL SEQUENCES IN SCHEMA",
											"ALL TABLES IN SCHEMA",
											"DATABASE",
											"DOMAIN",
											"FOREIGN DATA WRAPPER",
											"FOREIGN SERVER",
											"FUNCTION",
											"LANGUAGE",
											"LARGE OBJECT",
											"PARAMETER",
											"PROCEDURE",
											"ROUTINE",
											"SCHEMA",
											"SEQUENCE",
											"TABLE",
											"TABLESPACE",
											"TYPE");
	}
	break; case 510:
#line 4516 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("FUNCTIONS IN SCHEMA",
					  "PROCEDURES IN SCHEMA",
					  "ROUTINES IN SCHEMA",
					  "SEQUENCES IN SCHEMA",
					  "TABLES IN SCHEMA");
	break; case 511:
#line 4523 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("DATA WRAPPER", "SERVER");

	/*
	 * Complete "GRANT/REVOKE * ON DATABASE/DOMAIN/..." with a list of
	 * appropriate objects.
	 *
	 * Complete "GRANT/REVOKE * ON *" with "TO/FROM".
	 */
	break; case 512:
#line 4533 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (TailMatches("DATABASE"))
			COMPLETE_WITH_QUERY(Query_for_list_of_databases);
		else if (TailMatches("DOMAIN"))
			COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_domains);
		else if (TailMatches("FUNCTION"))
			COMPLETE_WITH_VERSIONED_SCHEMA_QUERY(Query_for_list_of_functions);
		else if (TailMatches("LANGUAGE"))
			COMPLETE_WITH_QUERY(Query_for_list_of_languages);
		else if (TailMatches("PROCEDURE"))
			COMPLETE_WITH_VERSIONED_SCHEMA_QUERY(Query_for_list_of_procedures);
		else if (TailMatches("ROUTINE"))
			COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_routines);
		else if (TailMatches("SCHEMA"))
			COMPLETE_WITH_QUERY(Query_for_list_of_schemas);
		else if (TailMatches("SEQUENCE"))
			COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_sequences);
		else if (TailMatches("TABLE"))
			COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_grantables);
		else if (TailMatches("TABLESPACE"))
			COMPLETE_WITH_QUERY(Query_for_list_of_tablespaces);
		else if (TailMatches("TYPE"))
			COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
		else if (TailMatches("GRANT", MatchAny, MatchAny, MatchAny))
			COMPLETE_WITH("TO");
		else
			COMPLETE_WITH("FROM");
	}

	/*
	 * Complete "GRANT/REVOKE ... TO/FROM" with username, PUBLIC,
	 * CURRENT_ROLE, CURRENT_USER, or SESSION_USER.
	 */
	break; case 513:
#line 4568 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
								 Keywords_for_list_of_grant_roles);

	/*
	 * Offer grant options after that.
	 */
	break; case 514:
		COMPLETE_WITH("WITH ADMIN",
					  "WITH INHERIT",
					  "WITH SET",
					  "WITH GRANT OPTION",
					  "GRANTED BY");
	break; case 515:
		COMPLETE_WITH("ADMIN",
					  "INHERIT",
					  "SET",
					  "GRANT OPTION");
	break; case 516:
		COMPLETE_WITH("OPTION", "TRUE", "FALSE");
	break; case 517:
		COMPLETE_WITH("GRANTED BY");
	break; case 518:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
								 Keywords_for_list_of_grant_roles);
	/* Complete "ALTER DEFAULT PRIVILEGES ... GRANT/REVOKE ... TO/FROM */
	break; case 519:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
								 Keywords_for_list_of_grant_roles);
	/* Offer WITH GRANT OPTION after that */
	break; case 520:
		COMPLETE_WITH("WITH GRANT OPTION");
	/* Complete "GRANT/REVOKE ... ON * *" with TO/FROM */
	break; case 521:
		COMPLETE_WITH("TO");
	break; case 522:
		COMPLETE_WITH("FROM");

	/* Complete "GRANT/REVOKE * ON ALL * IN SCHEMA *" with TO/FROM */
	break; case 523:
#line 4608 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (TailMatches("GRANT", MatchAny, MatchAny, MatchAny, MatchAny, MatchAny, MatchAny, MatchAny))
			COMPLETE_WITH("TO");
		else
			COMPLETE_WITH("FROM");
	}

	/* Complete "GRANT/REVOKE * ON FOREIGN DATA WRAPPER *" with TO/FROM */
	break; case 524:
#line 4618 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (TailMatches("GRANT", MatchAny, MatchAny, MatchAny, MatchAny, MatchAny, MatchAny))
			COMPLETE_WITH("TO");
		else
			COMPLETE_WITH("FROM");
	}

	/* Complete "GRANT/REVOKE * ON FOREIGN SERVER *" with TO/FROM */
	break; case 525:
#line 4628 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		if (TailMatches("GRANT", MatchAny, MatchAny, MatchAny, MatchAny, MatchAny))
			COMPLETE_WITH("TO");
		else
			COMPLETE_WITH("FROM");
	}

/* GROUP BY */
	break; case 526:
		COMPLETE_WITH("BY");

/* IMPORT FOREIGN SCHEMA */
	break; case 527:
		COMPLETE_WITH("FOREIGN SCHEMA");
	break; case 528:
		COMPLETE_WITH("SCHEMA");
	break; case 529:
		COMPLETE_WITH("EXCEPT (", "FROM SERVER", "LIMIT TO (");
	break; case 530:
#line 4648 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("FROM SERVER");
	break; case 531:
		COMPLETE_WITH("INTO");
	break; case 532:
		COMPLETE_WITH_QUERY(Query_for_list_of_schemas);
	break; case 533:
		COMPLETE_WITH("OPTIONS (");

/* INSERT --- can be inside EXPLAIN, RULE, etc */
	/* Complete NOT MATCHED THEN INSERT */
	break; case 534:
		COMPLETE_WITH("VALUES", "(");
	/* Complete INSERT with "INTO" */
	break; case 535:
		COMPLETE_WITH("INTO");
	/* Complete INSERT INTO with table names */
	break; case 536:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_updatables);
	/* Complete "INSERT INTO <table> (" with attribute names */
	break; case 537:
		COMPLETE_WITH_ATTR(prev2_wd);

	/*
	 * Complete INSERT INTO <table> with "(" or "VALUES" or "SELECT" or
	 * "TABLE" or "DEFAULT VALUES" or "OVERRIDING"
	 */
	break; case 538:
		COMPLETE_WITH("(", "DEFAULT VALUES", "SELECT", "TABLE", "VALUES", "OVERRIDING");

	/*
	 * Complete INSERT INTO <table> (attribs) with "VALUES" or "SELECT" or
	 * "TABLE" or "OVERRIDING"
	 */
	break; case 539:
#line 4682 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (ends_with(prev_wd, ')'))
#line 4683 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("SELECT", "TABLE", "VALUES", "OVERRIDING");

	/* Complete OVERRIDING */
	break; case 540:
		COMPLETE_WITH("SYSTEM VALUE", "USER VALUE");

	/* Complete after OVERRIDING clause */
	break; case 541:
		COMPLETE_WITH("SELECT", "TABLE", "VALUES");

	/* Insert an open parenthesis after "VALUES" */
	break; case 542:
#line 4694 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("DEFAULT", "VALUES"))
		COMPLETE_WITH("(");

/* LOCK */
	/* Complete LOCK [TABLE] [ONLY] with a list of tables */
	break; case 543:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_tables,
										"TABLE", "ONLY");
	break; case 544:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_tables,
										"ONLY");
	break; case 545:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);
	/* For the following, handle the case of a single table only for now */

	/* Complete LOCK [TABLE] [ONLY] <table> with IN or NOWAIT */
	break; case 546:
#line 4714 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("IN", "NOWAIT");

	/* Complete LOCK [TABLE] [ONLY] <table> IN with a lock mode */
	break; case 547:
		COMPLETE_WITH("ACCESS SHARE MODE",
					  "ROW SHARE MODE", "ROW EXCLUSIVE MODE",
					  "SHARE UPDATE EXCLUSIVE MODE", "SHARE MODE",
					  "SHARE ROW EXCLUSIVE MODE",
					  "EXCLUSIVE MODE", "ACCESS EXCLUSIVE MODE");

	/*
	 * Complete LOCK [TABLE][ONLY] <table> IN ACCESS|ROW with rest of lock
	 * mode
	 */
	break; case 548:
		COMPLETE_WITH("EXCLUSIVE MODE", "SHARE MODE");

	/* Complete LOCK [TABLE] [ONLY] <table> IN SHARE with rest of lock mode */
	break; case 549:
		COMPLETE_WITH("MODE", "ROW EXCLUSIVE MODE",
					  "UPDATE EXCLUSIVE MODE");

	/* Complete LOCK [TABLE] [ONLY] <table> [IN lockmode MODE] with "NOWAIT" */
	break; case 550:
		COMPLETE_WITH("NOWAIT");

/* MERGE --- can be inside EXPLAIN */
	break; case 551:
		COMPLETE_WITH("INTO");
	break; case 552:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_mergetargets);

	/* Complete MERGE INTO <table> [[AS] <alias>] with USING */
	break; case 553:
		COMPLETE_WITH("USING", "AS");
	break; case 554:
#line 4751 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("USING");

	/*
	 * Complete MERGE INTO ... USING with a list of relations supporting
	 * SELECT
	 */
	break; case 555:
#line 4760 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_selectables);

	/*
	 * Complete MERGE INTO <table> [[AS] <alias>] USING <relations> [[AS]
	 * alias] with ON
	 */
	break; case 556:
#line 4769 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("AS", "ON");
	break; case 557:
#line 4776 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ON");

	/* Complete MERGE INTO ... ON with target table attributes */
	break; case 558:
		COMPLETE_WITH_ATTR(prev4_wd);
	break; case 559:
		COMPLETE_WITH_ATTR(prev8_wd);
	break; case 560:
		COMPLETE_WITH_ATTR(prev6_wd);

	/*
	 * Complete ... USING <relation> [[AS] alias] ON join condition
	 * (consisting of one or three words typically used) with WHEN [NOT]
	 * MATCHED
	 */
	break; case 561:
#line 4797 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("WHEN MATCHED", "WHEN NOT MATCHED");
	break; case 562:
#line 4804 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("MATCHED", "NOT MATCHED");

	/*
	 * Complete ... WHEN MATCHED and WHEN NOT MATCHED BY SOURCE|TARGET with
	 * THEN/AND
	 */
	break; case 563:
#line 4812 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("THEN", "AND");

	/* Complete ... WHEN NOT MATCHED with BY/THEN/AND */
	break; case 564:
		COMPLETE_WITH("BY", "THEN", "AND");

	/* Complete ... WHEN NOT MATCHED BY with SOURCE/TARGET */
	break; case 565:
		COMPLETE_WITH("SOURCE", "TARGET");

	/*
	 * Complete ... WHEN MATCHED THEN and WHEN NOT MATCHED BY SOURCE THEN with
	 * UPDATE SET/DELETE/DO NOTHING
	 */
	break; case 566:
#line 4828 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("UPDATE SET", "DELETE", "DO NOTHING");

	/*
	 * Complete ... WHEN NOT MATCHED [BY TARGET] THEN with INSERT/DO NOTHING
	 */
	break; case 567:
#line 4835 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("INSERT", "DO NOTHING");

/* NOTIFY --- can be inside EXPLAIN, RULE, etc */
	break; case 568:
		COMPLETE_WITH_QUERY(Query_for_list_of_channels);

/* OPTIONS */
	break; case 569:
		COMPLETE_WITH("(");

/* OWNER TO  - complete with available roles */
	break; case 570:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
								 Keywords_for_list_of_owner_roles);

/* ORDER BY */
	break; case 571:
		COMPLETE_WITH("BY");
	break; case 572:
		COMPLETE_WITH_ATTR(prev3_wd);

/* PREPARE xx AS */
	break; case 573:
		COMPLETE_WITH("SELECT", "UPDATE", "INSERT INTO", "DELETE FROM");

/*
 * PREPARE TRANSACTION is missing on purpose. It's intended for transaction
 * managers, not for manual use in interactive sessions.
 */

/* REASSIGN OWNED BY xxx TO yyy */
	break; case 574:
		COMPLETE_WITH("OWNED BY");
	break; case 575:
		COMPLETE_WITH("BY");
	break; case 576:
		COMPLETE_WITH_QUERY(Query_for_list_of_roles);
	break; case 577:
		COMPLETE_WITH("TO");
	break; case 578:
		COMPLETE_WITH_QUERY(Query_for_list_of_roles);

/* REFRESH MATERIALIZED VIEW */
	break; case 579:
		COMPLETE_WITH("MATERIALIZED VIEW");
	break; case 580:
		COMPLETE_WITH("VIEW");
	break; case 581:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_matviews,
										"CONCURRENTLY");
	break; case 582:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_matviews);
	break; case 583:
		COMPLETE_WITH("WITH");
	break; case 584:
		COMPLETE_WITH("WITH");
	break; case 585:
		COMPLETE_WITH("NO DATA", "DATA");
	break; case 586:
		COMPLETE_WITH("NO DATA", "DATA");
	break; case 587:
		COMPLETE_WITH("DATA");
	break; case 588:
		COMPLETE_WITH("DATA");

/* REINDEX */
	break; case 589:
#line 4903 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("TABLE", "INDEX", "SYSTEM", "SCHEMA", "DATABASE");
	break; case 590:
#line 4906 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_indexables,
										"CONCURRENTLY");
	break; case 591:
#line 4910 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_indexes,
										"CONCURRENTLY");
	break; case 592:
#line 4914 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_schemas,
								 "CONCURRENTLY");
	break; case 593:
#line 4918 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_databases,
								 "CONCURRENTLY");
	break; case 594:
#line 4922 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_indexables);
	break; case 595:
#line 4925 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_indexes);
	break; case 596:
#line 4928 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY(Query_for_list_of_schemas);
	break; case 597:
#line 4931 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY(Query_for_list_of_databases);
	break; case 598:
#line 4933 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!HeadMatches("REINDEX", "(*)"))
#line 4934 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		/*
		 * This fires if we're in an unfinished parenthesized option list.
		 * get_previous_words treats a completed parenthesized option list as
		 * one word, so the above test is correct.
		 */
		if (ends_with(prev_wd, '(') || ends_with(prev_wd, ','))
			COMPLETE_WITH("CONCURRENTLY", "TABLESPACE", "VERBOSE");
		else if (TailMatches("TABLESPACE"))
			COMPLETE_WITH_QUERY(Query_for_list_of_tablespaces);
	}

/* SECURITY LABEL */
	break; case 599:
		COMPLETE_WITH("LABEL");
	break; case 600:
		COMPLETE_WITH("ON", "FOR");
	break; case 601:
		COMPLETE_WITH("ON");
	break; case 602:
#line 4955 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("TABLE", "COLUMN", "AGGREGATE", "DATABASE", "DOMAIN",
					  "EVENT TRIGGER", "FOREIGN TABLE", "FUNCTION",
					  "LARGE OBJECT", "MATERIALIZED VIEW", "LANGUAGE",
					  "PUBLICATION", "PROCEDURE", "ROLE", "ROUTINE", "SCHEMA",
					  "SEQUENCE", "SUBSCRIPTION", "TABLESPACE", "TYPE", "VIEW");
	break; case 603:
		COMPLETE_WITH("IS");

/* SELECT */
	/* naah . . . */

/* SET, RESET, SHOW */
	/* Complete with a variable name */
	break; case 604:
#line 4970 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("UPDATE", MatchAny, "SET") && !TailMatches("ALTER", "DATABASE|USER|ROLE", MatchAny, "RESET"))
#line 4971 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY_VERBATIM_PLUS(Query_for_list_of_set_vars,
										  "CONSTRAINTS",
										  "TRANSACTION",
										  "SESSION",
										  "ROLE",
										  "TABLESPACE",
										  "ALL");
	break; case 605:
		COMPLETE_WITH_QUERY_VERBATIM_PLUS(Query_for_list_of_show_vars,
										  "SESSION AUTHORIZATION",
										  "ALL");
	break; case 606:
		COMPLETE_WITH("AUTHORIZATION");
	/* Complete "SET TRANSACTION" */
	break; case 607:
		COMPLETE_WITH("SNAPSHOT", "ISOLATION LEVEL", "READ", "DEFERRABLE", "NOT DEFERRABLE");
	break; case 608:
#line 4991 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ISOLATION LEVEL", "READ", "DEFERRABLE", "NOT DEFERRABLE");
	break; case 609:
#line 4995 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("DEFERRABLE");
	break; case 610:
#line 4999 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("LEVEL");
	break; case 611:
#line 5003 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("READ", "REPEATABLE READ", "SERIALIZABLE");
	break; case 612:
#line 5007 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("UNCOMMITTED", "COMMITTED");
	break; case 613:
#line 5011 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("READ");
	break; case 614:
#line 5015 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ONLY", "WRITE");
	/* SET CONSTRAINTS */
	break; case 615:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_constraints_with_schema,
										"ALL");
	/* Complete SET CONSTRAINTS <foo> with DEFERRED|IMMEDIATE */
	break; case 616:
		COMPLETE_WITH("DEFERRED", "IMMEDIATE");
	/* Complete SET ROLE */
	break; case 617:
		COMPLETE_WITH_QUERY(Query_for_list_of_roles);
	/* Complete SET SESSION with AUTHORIZATION or CHARACTERISTICS... */
	break; case 618:
		COMPLETE_WITH("AUTHORIZATION", "CHARACTERISTICS AS TRANSACTION");
	/* Complete SET SESSION AUTHORIZATION with username */
	break; case 619:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
								 "DEFAULT");
	/* Complete RESET SESSION with AUTHORIZATION */
	break; case 620:
		COMPLETE_WITH("AUTHORIZATION");
	/* Complete SET <var> with "TO" */
	break; case 621:
		COMPLETE_WITH("TO");

	/*
	 * Complete ALTER DATABASE|FUNCTION|PROCEDURE|ROLE|ROUTINE|USER ... SET
	 * <name>
	 */
	break; case 622:
		COMPLETE_WITH("FROM CURRENT", "TO");

	/*
	 * Suggest possible variable values in SET variable TO|=, along with the
	 * preceding ALTER syntaxes.
	 */
	break; case 623:
#line 5052 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("UPDATE", MatchAny, "SET", MatchAny, "TO|="))
#line 5053 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		/* special cased code for individual GUCs */
		if (TailMatches("DateStyle", "TO|="))
			COMPLETE_WITH("ISO", "SQL", "Postgres", "German",
						  "YMD", "DMY", "MDY",
						  "US", "European", "NonEuropean",
						  "DEFAULT");
		else if (TailMatches("search_path", "TO|="))
		{
			/* Here, we want to allow pg_catalog, so use narrower exclusion */
			COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_schemas
									 " AND nspname NOT LIKE E'pg\\\\_toast%%'"
									 " AND nspname NOT LIKE E'pg\\\\_temp%%'",
									 "DEFAULT");
		}
		else if (TailMatches("TimeZone", "TO|="))
			COMPLETE_WITH_TIMEZONE_NAME();
		else
		{
			/* generic, type based, GUC support */
			char	   *guctype = get_guctype(prev2_wd);

			/*
			 * Note: if we don't recognize the GUC name, it's important to not
			 * offer any completions, as most likely we've misinterpreted the
			 * context and this isn't a GUC-setting command at all.
			 */
			if (guctype)
			{
				if (strcmp(guctype, "enum") == 0)
				{
					set_completion_reference_verbatim(prev2_wd);
					COMPLETE_WITH_QUERY_PLUS(Query_for_values_of_enum_GUC,
											 "DEFAULT");
				}
				else if (strcmp(guctype, "bool") == 0)
					COMPLETE_WITH("on", "off", "true", "false", "yes", "no",
								  "1", "0", "DEFAULT");
				else
					COMPLETE_WITH("DEFAULT");

				free(guctype);
			}
		}
	}

/* START TRANSACTION */
	break; case 624:
		COMPLETE_WITH("TRANSACTION");

/* TABLE, but not TABLE embedded in other commands */
	break; case 625:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_selectables);

/* TABLESAMPLE */
	break; case 626:
		COMPLETE_WITH_QUERY(Query_for_list_of_tablesample_methods);
	break; case 627:
		COMPLETE_WITH("(");

/* TRUNCATE */
	break; case 628:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_truncatables,
										"TABLE", "ONLY");
	break; case 629:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_truncatables,
										"ONLY");
	break; case 630:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_truncatables);
	break; case 631:
#line 5125 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("RESTART IDENTITY", "CONTINUE IDENTITY", "CASCADE", "RESTRICT");
	break; case 632:
		COMPLETE_WITH("CASCADE", "RESTRICT");

/* UNLISTEN */
	break; case 633:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_channels, "*");

/* UPDATE --- can be inside EXPLAIN, RULE, etc */
	/* If prev. word is UPDATE suggest a list of tables */
	break; case 634:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_updatables);
	/* Complete UPDATE <table> with "SET" */
	break; case 635:
		COMPLETE_WITH("SET");
	/* Complete UPDATE <table> SET with list of attributes */
	break; case 636:
		COMPLETE_WITH_ATTR(prev2_wd);
	/* UPDATE <table> SET <attr> = */
	break; case 637:
		COMPLETE_WITH("=");

/* USER MAPPING */
	break; case 638:
		COMPLETE_WITH("FOR");
	break; case 639:
		COMPLETE_WITH_QUERY_PLUS(Query_for_list_of_roles,
								 "CURRENT_ROLE",
								 "CURRENT_USER",
								 "PUBLIC",
								 "USER");
	break; case 640:
		COMPLETE_WITH_QUERY(Query_for_list_of_user_mappings);
	break; case 641:
		COMPLETE_WITH("SERVER");
	break; case 642:
		COMPLETE_WITH("OPTIONS");

/*
 * VACUUM [ ( option [, ...] ) ] [ [ ONLY ] table_and_columns [, ...] ]
 * VACUUM [ FULL ] [ FREEZE ] [ VERBOSE ] [ ANALYZE ] [ [ ONLY ] table_and_columns [, ...] ]
 */
	break; case 643:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_vacuumables,
										"(",
										"FULL",
										"FREEZE",
										"VERBOSE",
										"ANALYZE",
										"ONLY");
	break; case 644:
#line 5176 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!HeadMatches("VACUUM", "(*)"))
#line 5177 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		/*
		 * This fires if we're in an unfinished parenthesized option list.
		 * get_previous_words treats a completed parenthesized option list as
		 * one word, so the above test is correct.
		 */
		if (ends_with(prev_wd, '(') || ends_with(prev_wd, ','))
			COMPLETE_WITH("FULL", "FREEZE", "ANALYZE", "VERBOSE",
						  "DISABLE_PAGE_SKIPPING", "SKIP_LOCKED",
						  "INDEX_CLEANUP", "PROCESS_MAIN", "PROCESS_TOAST",
						  "TRUNCATE", "PARALLEL", "SKIP_DATABASE_STATS",
						  "ONLY_DATABASE_STATS", "BUFFER_USAGE_LIMIT");
		else if (TailMatches("FULL|FREEZE|ANALYZE|VERBOSE|DISABLE_PAGE_SKIPPING|SKIP_LOCKED|PROCESS_MAIN|PROCESS_TOAST|TRUNCATE|SKIP_DATABASE_STATS|ONLY_DATABASE_STATS"))
			COMPLETE_WITH("ON", "OFF");
		else if (TailMatches("INDEX_CLEANUP"))
			COMPLETE_WITH("AUTO", "ON", "OFF");
	}
	break; case 645:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_vacuumables,
										"ONLY");
	break; case 646:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_vacuumables,
										"FREEZE",
										"VERBOSE",
										"ANALYZE",
										"ONLY");
	break; case 647:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_vacuumables,
										"VERBOSE",
										"ANALYZE",
										"ONLY");
	break; case 648:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_vacuumables,
										"ANALYZE",
										"ONLY");
	break; case 649:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_vacuumables,
										"ONLY");
	break; case 650:
		/* "VACUUM (" should be caught above, so assume we want columns */
		COMPLETE_WITH_ATTR(prev2_wd);
	break; case 651:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_vacuumables);

/* WITH [RECURSIVE] */

	/*
	 * Only match when WITH is the first word, as WITH may appear in many
	 * other contexts.
	 */
	break; case 652:
		COMPLETE_WITH("RECURSIVE");

/* WHERE */
	/* Simple case of the word before the where being the table name */
	break; case 653:
		COMPLETE_WITH_ATTR(prev2_wd);

/* ... FROM ... */
/* TODO: also include SRF ? */
	break; case 654:
#line 5237 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!Matches("COPY|\\copy", MatchAny, "FROM"))
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_selectables);

/* ... JOIN ... */
	break; case 655:
		COMPLETE_WITH_SCHEMA_QUERY_PLUS(Query_for_list_of_selectables, "LATERAL");
	break; case 656:
#line 5243 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("CROSS|NATURAL", "JOIN", MatchAny))
		COMPLETE_WITH("ON", "USING (");
	break; case 657:
#line 5246 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("CROSS|NATURAL", "JOIN", MatchAny, MatchAny) && !TailMatches("ON|USING"))
#line 5247 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ON", "USING (");
	break; case 658:
#line 5249 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatches("CROSS|NATURAL", "JOIN", "LATERAL", MatchAny, MatchAny) && !TailMatches("ON|USING"))
#line 5250 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("ON", "USING (");
	break; case 659:
#line 5254 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH("(");
	break; case 660:
		COMPLETE_WITH_ATTR(prev3_wd);
	break; case 661:
		COMPLETE_WITH_ATTR(prev4_wd);

/* ... AT [ LOCAL | TIME ZONE ] ... */
	break; case 662:
		COMPLETE_WITH("LOCAL", "TIME ZONE");
	break; case 663:
		COMPLETE_WITH_TIMEZONE_NAME();

/* Backslash commands */
/* TODO:  \dc \dd \dl */
	break; case 664:
		COMPLETE_WITH_CS("commands", "options", "variables");
	break; case 665:
	{
		if (!recognized_connection_string(text))
			COMPLETE_WITH_QUERY(Query_for_list_of_databases);
	}
	break; case 666:
	{
		if (!recognized_connection_string(prev_wd))
			COMPLETE_WITH_QUERY(Query_for_list_of_roles);
	}
	break; case 667:
		COMPLETE_WITH_VERSIONED_SCHEMA_QUERY(Query_for_list_of_aggregates);
	break; case 668:
#line 5284 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
	break; case 669:
#line 5287 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_operator_families);
	break; case 670:
		COMPLETE_WITH_QUERY(Query_for_list_of_access_methods);
	break; case 671:
		COMPLETE_WITH_QUERY(Query_for_list_of_tablespaces);
	break; case 672:
		COMPLETE_WITH_QUERY_VERBATIM(Query_for_list_of_show_vars);
	break; case 673:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_domains);
	break; case 674:
		COMPLETE_WITH_QUERY(Query_for_list_of_servers);
	break; case 675:
		COMPLETE_WITH_QUERY(Query_for_list_of_user_mappings);
	break; case 676:
		COMPLETE_WITH_QUERY(Query_for_list_of_fdws);
	break; case 677:
		COMPLETE_WITH_VERSIONED_SCHEMA_QUERY(Query_for_list_of_functions);
	break; case 678:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);

	break; case 679:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_ts_dictionaries);
	break; case 680:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_ts_parsers);
	break; case 681:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_ts_templates);
	/* must be at end of \dF alternatives: */
	break; case 682:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_ts_configurations);

	break; case 683:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_indexes);
	break; case 684:
		COMPLETE_WITH_QUERY(Query_for_list_of_languages);
	break; case 685:
		COMPLETE_WITH_QUERY(Query_for_list_of_schemas);
	/* no support for completing operators, but we can complete types: */
	break; case 686:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
	break; case 687:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_grantables);
	break; case 688:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_partitioned_indexes);
	break; case 689:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_partitioned_tables);
	break; case 690:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_partitioned_relations);
	break; case 691:
		COMPLETE_WITH_VERSIONED_QUERY(Query_for_list_of_publications);
	break; case 692:
		COMPLETE_WITH_VERSIONED_QUERY(Query_for_list_of_subscriptions);
	break; case 693:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_sequences);
	break; case 694:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_tables);
	break; case 695:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_datatypes);
	break; case 696:
#line 5347 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
		COMPLETE_WITH_QUERY(Query_for_list_of_roles);
	break; case 697:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_views);
	break; case 698:
		COMPLETE_WITH_QUERY(Query_for_list_of_extensions);
	break; case 699:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_statistics);
	break; case 700:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_matviews);
	break; case 701:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_foreign_tables);
	break; case 702:
		COMPLETE_WITH_QUERY(Query_for_list_of_event_triggers);

	/* must be at end of \d alternatives: */
	break; case 703:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_relations);

	break; case 704:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_routines);
	break; case 705:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_views);

	break; case 706:
		COMPLETE_WITH_QUERY_VERBATIM(Query_for_list_of_encodings);
	break; case 707:
		COMPLETE_WITH_LIST(sql_commands);
	break; case 708:
	{
		if (TailMatches("DROP"))
			matches = rl_completion_matches(text, drop_command_generator);
		else if (TailMatches("ALTER"))
			matches = rl_completion_matches(text, alter_command_generator);

		/*
		 * CREATE is recognized by tail match elsewhere, so doesn't need to be
		 * repeated here
		 */
	}
	break; case 709:
	{
		if (TailMatches("CREATE|DROP", "ACCESS"))
			COMPLETE_WITH("METHOD");
		else if (TailMatches("ALTER", "DEFAULT"))
			COMPLETE_WITH("PRIVILEGES");
		else if (TailMatches("CREATE|ALTER|DROP", "EVENT"))
			COMPLETE_WITH("TRIGGER");
		else if (TailMatches("CREATE|ALTER|DROP", "FOREIGN"))
			COMPLETE_WITH("DATA WRAPPER", "TABLE");
		else if (TailMatches("ALTER", "LARGE"))
			COMPLETE_WITH("OBJECT");
		else if (TailMatches("CREATE|ALTER|DROP", "MATERIALIZED"))
			COMPLETE_WITH("VIEW");
		else if (TailMatches("CREATE|ALTER|DROP", "TEXT"))
			COMPLETE_WITH("SEARCH");
		else if (TailMatches("CREATE|ALTER|DROP", "USER"))
			COMPLETE_WITH("MAPPING FOR");
	}
	break; case 710:
	{
		if (TailMatches("CREATE|ALTER|DROP", "FOREIGN", "DATA"))
			COMPLETE_WITH("WRAPPER");
		else if (TailMatches("CREATE|ALTER|DROP", "TEXT", "SEARCH"))
			COMPLETE_WITH("CONFIGURATION", "DICTIONARY", "PARSER", "TEMPLATE");
		else if (TailMatches("CREATE|ALTER|DROP", "USER", "MAPPING"))
			COMPLETE_WITH("FOR");
	}
	break; case 711:
#line 5414 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	if (!TailMatchesCS("\\lo*"))
		COMPLETE_WITH_QUERY(Query_for_list_of_databases);
	break; case 712:
		COMPLETE_WITH_QUERY(Query_for_list_of_roles);
	break; case 713:
		COMPLETE_WITH_CS("border", "columns", "csv_fieldsep", "expanded",
						 "fieldsep", "fieldsep_zero", "footer", "format",
						 "linestyle", "null", "numericlocale",
						 "pager", "pager_min_lines",
						 "recordsep", "recordsep_zero",
						 "tableattr", "title", "tuples_only",
						 "unicode_border_linestyle",
						 "unicode_column_linestyle",
						 "unicode_header_linestyle",
						 "xheader_width");
	break; case 714:
	{
		if (TailMatchesCS("format"))
			COMPLETE_WITH_CS("aligned", "asciidoc", "csv", "html", "latex",
							 "latex-longtable", "troff-ms", "unaligned",
							 "wrapped");
		else if (TailMatchesCS("xheader_width"))
			COMPLETE_WITH_CS("full", "column", "page");
		else if (TailMatchesCS("linestyle"))
			COMPLETE_WITH_CS("ascii", "old-ascii", "unicode");
		else if (TailMatchesCS("pager"))
			COMPLETE_WITH_CS("on", "off", "always");
		else if (TailMatchesCS("unicode_border_linestyle|"
							   "unicode_column_linestyle|"
							   "unicode_header_linestyle"))
			COMPLETE_WITH_CS("single", "double");
	}
	break; case 715:
		matches = complete_from_variables(text, "", "", true);
	break; case 716:
		matches = complete_from_variables(text, "", "", false);
	break; case 717:
	{
		if (TailMatchesCS("AUTOCOMMIT|ON_ERROR_STOP|QUIET|SHOW_ALL_RESULTS|"
						  "SINGLELINE|SINGLESTEP"))
			COMPLETE_WITH_CS("on", "off");
		else if (TailMatchesCS("COMP_KEYWORD_CASE"))
			COMPLETE_WITH_CS("lower", "upper",
							 "preserve-lower", "preserve-upper");
		else if (TailMatchesCS("ECHO"))
			COMPLETE_WITH_CS("errors", "queries", "all", "none");
		else if (TailMatchesCS("ECHO_HIDDEN"))
			COMPLETE_WITH_CS("noexec", "off", "on");
		else if (TailMatchesCS("HISTCONTROL"))
			COMPLETE_WITH_CS("ignorespace", "ignoredups",
							 "ignoreboth", "none");
		else if (TailMatchesCS("ON_ERROR_ROLLBACK"))
			COMPLETE_WITH_CS("on", "off", "interactive");
		else if (TailMatchesCS("SHOW_CONTEXT"))
			COMPLETE_WITH_CS("never", "errors", "always");
		else if (TailMatchesCS("VERBOSITY"))
			COMPLETE_WITH_CS("default", "verbose", "terse", "sqlstate");
	}
	break; case 718:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_routines);
	break; case 719:
		COMPLETE_WITH_SCHEMA_QUERY(Query_for_list_of_views);
	break; case 720:
#line 5479 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"
	{
		completion_charp = "\\";
		completion_force_quote = false;
		matches = rl_completion_matches(text, complete_from_files);
	}

	/* gen_tabcomplete.pl ends special processing here */
	break;
	default:
		Assert(false);
		break;
	}
#line 5487 "/build/postgresql/src/build/../postgresql-18.3/src/bin/psql/tab-complete.in.c"

	return matches;
}


/*
 * GENERATOR FUNCTIONS
 *
 * These functions do all the actual work of completing the input. They get
 * passed the text so far and the count how many times they have been called
 * so far with the same text.
 * If you read the above carefully, you'll see that these don't get called
 * directly but through the readline interface.
 * The return value is expected to be the full completion of the text, going
 * through a list each time, or NULL if there are no more matches. The string
 * will be free()'d by readline, so you must run it through strdup() or
 * something of that sort.
 */

/*
 * Common routine for create_command_generator and drop_command_generator.
 * Entries that have 'excluded' flags are not returned.
 */
static char *
create_or_drop_command_generator(const char *text, int state, bits32 excluded)
{
	static int	list_index,
				string_length;
	const char *name;

	/* If this is the first time for this completion, init some values */
	if (state == 0)
	{
		list_index = 0;
		string_length = strlen(text);
	}

	/* find something that matches */
	while ((name = words_after_create[list_index++].name))
	{
		if ((pg_strncasecmp(name, text, string_length) == 0) &&
			!(words_after_create[list_index - 1].flags & excluded))
			return pg_strdup_keyword_case(name, text);
	}
	/* if nothing matches, return NULL */
	return NULL;
}

/*
 * This one gives you one from a list of things you can put after CREATE
 * as defined above.
 */
static char *
create_command_generator(const char *text, int state)
{
	return create_or_drop_command_generator(text, state, THING_NO_CREATE);
}

/*
 * This function gives you a list of things you can put after a DROP command.
 */
static char *
drop_command_generator(const char *text, int state)
{
	return create_or_drop_command_generator(text, state, THING_NO_DROP);
}

/*
 * This function gives you a list of things you can put after an ALTER command.
 */
static char *
alter_command_generator(const char *text, int state)
{
	return create_or_drop_command_generator(text, state, THING_NO_ALTER);
}

/*
 * These functions generate lists using server queries.
 * They are all wrappers for _complete_from_query.
 */

static char *
complete_from_query(const char *text, int state)
{
	/* query is assumed to work for any server version */
	return _complete_from_query(completion_charp, NULL, completion_charpp,
								completion_verbatim, text, state);
}

static char *
complete_from_versioned_query(const char *text, int state)
{
	const VersionedQuery *vquery = completion_vquery;

	/* Find appropriate array element */
	while (pset.sversion < vquery->min_server_version)
		vquery++;
	/* Fail completion if server is too old */
	if (vquery->query == NULL)
		return NULL;

	return _complete_from_query(vquery->query, NULL, completion_charpp,
								completion_verbatim, text, state);
}

static char *
complete_from_schema_query(const char *text, int state)
{
	/* query is assumed to work for any server version */
	return _complete_from_query(NULL, completion_squery, completion_charpp,
								completion_verbatim, text, state);
}

static char *
complete_from_versioned_schema_query(const char *text, int state)
{
	const SchemaQuery *squery = completion_squery;

	/* Find appropriate array element */
	while (pset.sversion < squery->min_server_version)
		squery++;
	/* Fail completion if server is too old */
	if (squery->catname == NULL)
		return NULL;

	return _complete_from_query(NULL, squery, completion_charpp,
								completion_verbatim, text, state);
}


/*
 * This creates a list of matching things, according to a query described by
 * the initial arguments.  The caller has already done any work needed to
 * select the appropriate query for the server's version.
 *
 * The query can be one of two kinds:
 *
 * 1. A simple query, which must contain a restriction clause of the form
 *		output LIKE '%s'
 * where "output" is the same string that the query returns.  The %s
 * will be replaced by a LIKE pattern to match the already-typed text.
 * There can be a second '%s', which will be replaced by a suitably-escaped
 * version of the string provided in completion_ref_object.  If there is a
 * third '%s', it will be replaced by a suitably-escaped version of the string
 * provided in completion_ref_schema.  Those strings should be set up
 * by calling set_completion_reference or set_completion_reference_verbatim.
 * Simple queries should return a single column of matches.  If "verbatim"
 * is true, the matches are returned as-is; otherwise, they are taken to
 * be SQL identifiers and quoted if necessary.
 *
 * 2. A schema query used for completion of both schema and relation names.
 * This is represented by a SchemaQuery object; see that typedef for details.
 *
 * See top of file for examples of both kinds of query.
 *
 * In addition to the query itself, we accept a null-terminated array of
 * literal keywords, which will be returned if they match the input-so-far
 * (case insensitively).  (These are in addition to keywords specified
 * within the schema_query, if any.)
 *
 * If "verbatim" is true, then we use the given text as-is to match the
 * query results; otherwise we parse it as a possibly-qualified identifier,
 * and reconstruct suitable quoting afterward.
 *
 * "text" and "state" are supplied by Readline.  "text" is the word we are
 * trying to complete.  "state" is zero on first call, nonzero later.
 *
 * readline will call this repeatedly with the same text and varying
 * state.  On each call, we are supposed to return a malloc'd string
 * that is a candidate completion.  Return NULL when done.
 */
static char *
_complete_from_query(const char *simple_query,
					 const SchemaQuery *schema_query,
					 const char *const *keywords,
					 bool verbatim,
					 const char *text, int state)
{
	static int	list_index,
				num_schema_only,
				num_query_other,
				num_keywords;
	static PGresult *result = NULL;
	static bool non_empty_object;
	static bool schemaquoted;
	static bool objectquoted;

	/*
	 * If this is the first time for this completion, we fetch a list of our
	 * "things" from the backend.
	 */
	if (state == 0)
	{
		PQExpBufferData query_buffer;
		char	   *schemaname;
		char	   *objectname;
		char	   *e_object_like;
		char	   *e_schemaname;
		char	   *e_ref_object;
		char	   *e_ref_schema;

		/* Reset static state, ensuring no memory leaks */
		list_index = 0;
		num_schema_only = 0;
		num_query_other = 0;
		num_keywords = 0;
		PQclear(result);
		result = NULL;

		/* Parse text, splitting into schema and object name if needed */
		if (verbatim)
		{
			objectname = pg_strdup(text);
			schemaname = NULL;
		}
		else
		{
			parse_identifier(text,
							 &schemaname, &objectname,
							 &schemaquoted, &objectquoted);
		}

		/* Remember whether the user has typed anything in the object part */
		non_empty_object = (*objectname != '\0');

		/*
		 * Convert objectname to a LIKE prefix pattern (e.g. 'foo%'), and set
		 * up suitably-escaped copies of all the strings we need.
		 */
		e_object_like = make_like_pattern(objectname);

		if (schemaname)
			e_schemaname = escape_string(schemaname);
		else
			e_schemaname = NULL;

		if (completion_ref_object)
			e_ref_object = escape_string(completion_ref_object);
		else
			e_ref_object = NULL;

		if (completion_ref_schema)
			e_ref_schema = escape_string(completion_ref_schema);
		else
			e_ref_schema = NULL;

		initPQExpBuffer(&query_buffer);

		if (schema_query)
		{
			Assert(simple_query == NULL);

			/*
			 * We issue different queries depending on whether the input is
			 * already qualified or not.  schema_query gives us the pieces to
			 * assemble.
			 */
			if (schemaname == NULL || schema_query->namespace == NULL)
			{
				/* Get unqualified names matching the input-so-far */
				appendPQExpBufferStr(&query_buffer, "SELECT ");
				if (schema_query->use_distinct)
					appendPQExpBufferStr(&query_buffer, "DISTINCT ");
				appendPQExpBuffer(&query_buffer,
								  "%s, NULL::pg_catalog.text FROM %s",
								  schema_query->result,
								  schema_query->catname);
				if (schema_query->refnamespace && completion_ref_schema)
					appendPQExpBufferStr(&query_buffer,
										 ", pg_catalog.pg_namespace nr");
				appendPQExpBufferStr(&query_buffer, " WHERE ");
				if (schema_query->selcondition)
					appendPQExpBuffer(&query_buffer, "%s AND ",
									  schema_query->selcondition);
				appendPQExpBuffer(&query_buffer, "(%s) LIKE '%s'",
								  schema_query->result,
								  e_object_like);
				if (schema_query->viscondition)
					appendPQExpBuffer(&query_buffer, " AND %s",
									  schema_query->viscondition);
				if (schema_query->refname)
				{
					Assert(completion_ref_object);
					appendPQExpBuffer(&query_buffer, " AND %s = '%s'",
									  schema_query->refname, e_ref_object);
					if (schema_query->refnamespace && completion_ref_schema)
						appendPQExpBuffer(&query_buffer,
										  " AND %s = nr.oid AND nr.nspname = '%s'",
										  schema_query->refnamespace,
										  e_ref_schema);
					else if (schema_query->refviscondition)
						appendPQExpBuffer(&query_buffer,
										  " AND %s",
										  schema_query->refviscondition);
				}

				/*
				 * When fetching relation names, suppress system catalogs
				 * unless the input-so-far begins with "pg_".  This is a
				 * compromise between not offering system catalogs for
				 * completion at all, and having them swamp the result when
				 * the input is just "p".
				 */
				if (strcmp(schema_query->catname,
						   "pg_catalog.pg_class c") == 0 &&
					strncmp(objectname, "pg_", 3) != 0)
				{
					appendPQExpBufferStr(&query_buffer,
										 " AND c.relnamespace <> (SELECT oid FROM"
										 " pg_catalog.pg_namespace WHERE nspname = 'pg_catalog')");
				}

				/*
				 * If the target object type can be schema-qualified, add in
				 * schema names matching the input-so-far.
				 */
				if (schema_query->namespace)
				{
					appendPQExpBuffer(&query_buffer, "\nUNION ALL\n"
									  "SELECT NULL::pg_catalog.text, n.nspname "
									  "FROM pg_catalog.pg_namespace n "
									  "WHERE n.nspname LIKE '%s'",
									  e_object_like);

					/*
					 * Likewise, suppress system schemas unless the
					 * input-so-far begins with "pg_".
					 */
					if (strncmp(objectname, "pg_", 3) != 0)
						appendPQExpBufferStr(&query_buffer,
											 " AND n.nspname NOT LIKE E'pg\\\\_%'");

					/*
					 * Since we're matching these schema names to the object
					 * name, handle their quoting using the object name's
					 * quoting state.
					 */
					schemaquoted = objectquoted;
				}
			}
			else
			{
				/* Input is qualified, so produce only qualified names */
				appendPQExpBufferStr(&query_buffer, "SELECT ");
				if (schema_query->use_distinct)
					appendPQExpBufferStr(&query_buffer, "DISTINCT ");
				appendPQExpBuffer(&query_buffer, "%s, n.nspname "
								  "FROM %s, pg_catalog.pg_namespace n",
								  schema_query->result,
								  schema_query->catname);
				if (schema_query->refnamespace && completion_ref_schema)
					appendPQExpBufferStr(&query_buffer,
										 ", pg_catalog.pg_namespace nr");
				appendPQExpBuffer(&query_buffer, " WHERE %s = n.oid AND ",
								  schema_query->namespace);
				if (schema_query->selcondition)
					appendPQExpBuffer(&query_buffer, "%s AND ",
									  schema_query->selcondition);
				appendPQExpBuffer(&query_buffer, "(%s) LIKE '%s' AND ",
								  schema_query->result,
								  e_object_like);
				appendPQExpBuffer(&query_buffer, "n.nspname = '%s'",
								  e_schemaname);
				if (schema_query->refname)
				{
					Assert(completion_ref_object);
					appendPQExpBuffer(&query_buffer, " AND %s = '%s'",
									  schema_query->refname, e_ref_object);
					if (schema_query->refnamespace && completion_ref_schema)
						appendPQExpBuffer(&query_buffer,
										  " AND %s = nr.oid AND nr.nspname = '%s'",
										  schema_query->refnamespace,
										  e_ref_schema);
					else if (schema_query->refviscondition)
						appendPQExpBuffer(&query_buffer,
										  " AND %s",
										  schema_query->refviscondition);
				}
			}
		}
		else
		{
			Assert(simple_query);
			/* simple_query is an sprintf-style format string */
			appendPQExpBuffer(&query_buffer, simple_query,
							  e_object_like,
							  e_ref_object, e_ref_schema);
		}

		/* Limit the number of records in the result */
		appendPQExpBuffer(&query_buffer, "\nLIMIT %d",
						  completion_max_records);

		/* Finally, we can issue the query */
		result = exec_query(query_buffer.data);

		/* Clean up */
		termPQExpBuffer(&query_buffer);
		free(schemaname);
		free(objectname);
		free(e_object_like);
		free(e_schemaname);
		free(e_ref_object);
		free(e_ref_schema);
	}

	/* Return the next result, if any, but not if the query failed */
	if (result && PQresultStatus(result) == PGRES_TUPLES_OK)
	{
		int			nskip;

		while (list_index < PQntuples(result))
		{
			const char *item = NULL;
			const char *nsp = NULL;

			if (!PQgetisnull(result, list_index, 0))
				item = PQgetvalue(result, list_index, 0);
			if (PQnfields(result) > 1 &&
				!PQgetisnull(result, list_index, 1))
				nsp = PQgetvalue(result, list_index, 1);
			list_index++;

			/* In verbatim mode, we return all the items as-is */
			if (verbatim)
			{
				num_query_other++;
				return pg_strdup(item);
			}

			/*
			 * In normal mode, a name requiring quoting will be returned only
			 * if the input was empty or quoted.  Otherwise the user might see
			 * completion inserting a quote she didn't type, which is
			 * surprising.  This restriction also dodges some odd behaviors of
			 * some versions of readline/libedit.
			 */
			if (non_empty_object)
			{
				if (item && !objectquoted && identifier_needs_quotes(item))
					continue;
				if (nsp && !schemaquoted && identifier_needs_quotes(nsp))
					continue;
			}

			/* Count schema-only results for hack below */
			if (item == NULL && nsp != NULL)
				num_schema_only++;
			else
				num_query_other++;

			return requote_identifier(nsp, item, schemaquoted, objectquoted);
		}

		/*
		 * When the query result is exhausted, check for hard-wired keywords.
		 * These will only be returned if they match the input-so-far,
		 * ignoring case.
		 */
		nskip = list_index - PQntuples(result);
		if (schema_query && schema_query->keywords)
		{
			const char *const *itemp = schema_query->keywords;

			while (*itemp)
			{
				const char *item = *itemp++;

				if (nskip-- > 0)
					continue;
				list_index++;
				if (pg_strncasecmp(text, item, strlen(text)) == 0)
				{
					num_keywords++;
					return pg_strdup_keyword_case(item, text);
				}
			}
		}
		if (keywords)
		{
			const char *const *itemp = keywords;

			while (*itemp)
			{
				const char *item = *itemp++;

				if (nskip-- > 0)
					continue;
				list_index++;
				if (pg_strncasecmp(text, item, strlen(text)) == 0)
				{
					num_keywords++;
					return pg_strdup_keyword_case(item, text);
				}
			}
		}
	}

	/*
	 * Hack: if we returned only bare schema names, don't let Readline add a
	 * space afterwards.  Otherwise the schema will stop being part of the
	 * completion subject text, which is not what we want.
	 */
	if (num_schema_only > 0 && num_query_other == 0 && num_keywords == 0)
		rl_completion_append_character = '\0';

	/* No more matches, so free the result structure and return null */
	PQclear(result);
	result = NULL;
	return NULL;
}


/*
 * Set up completion_ref_object and completion_ref_schema
 * by parsing the given word.  These variables can then be
 * used in a query passed to _complete_from_query.
 */
static void
set_completion_reference(const char *word)
{
	bool		schemaquoted,
				objectquoted;

	parse_identifier(word,
					 &completion_ref_schema, &completion_ref_object,
					 &schemaquoted, &objectquoted);
}

/*
 * Set up completion_ref_object when it should just be
 * the given word verbatim.
 */
static void
set_completion_reference_verbatim(const char *word)
{
	completion_ref_schema = NULL;
	completion_ref_object = pg_strdup(word);
}


/*
 * This function returns in order one of a fixed, NULL pointer terminated list
 * of strings (if matching). This can be used if there are only a fixed number
 * SQL words that can appear at certain spot.
 */
static char *
complete_from_list(const char *text, int state)
{
	static int	string_length,
				list_index,
				matches;
	static bool casesensitive;
	const char *item;

	/* need to have a list */
	Assert(completion_charpp != NULL);

	/* Initialization */
	if (state == 0)
	{
		list_index = 0;
		string_length = strlen(text);
		casesensitive = completion_case_sensitive;
		matches = 0;
	}

	while ((item = completion_charpp[list_index++]))
	{
		/* First pass is case sensitive */
		if (casesensitive && strncmp(text, item, string_length) == 0)
		{
			matches++;
			return pg_strdup(item);
		}

		/* Second pass is case insensitive, don't bother counting matches */
		if (!casesensitive && pg_strncasecmp(text, item, string_length) == 0)
		{
			if (completion_case_sensitive)
				return pg_strdup(item);
			else

				/*
				 * If case insensitive matching was requested initially,
				 * adjust the case according to setting.
				 */
				return pg_strdup_keyword_case(item, text);
		}
	}

	/*
	 * No matches found. If we're not case insensitive already, lets switch to
	 * being case insensitive and try again
	 */
	if (casesensitive && matches == 0)
	{
		casesensitive = false;
		list_index = 0;
		state++;
		return complete_from_list(text, state);
	}

	/* If no more matches, return null. */
	return NULL;
}


/*
 * This function returns one fixed string the first time even if it doesn't
 * match what's there, and nothing the second time.  The string
 * to be used must be in completion_charp.
 *
 * If the given string is "", this has the effect of preventing readline
 * from doing any completion.  (Without this, readline tries to do filename
 * completion which is seldom the right thing.)
 *
 * If the given string is not empty, readline will replace whatever the
 * user typed with that string.  This behavior might be useful if it's
 * completely certain that we know what must appear at a certain spot,
 * so that it's okay to overwrite misspellings.  In practice, given the
 * relatively lame parsing technology used in this file, the level of
 * certainty is seldom that high, so that you probably don't want to
 * use this.  Use complete_from_list with a one-element list instead;
 * that won't try to auto-correct "misspellings".
 */
static char *
complete_from_const(const char *text, int state)
{
	Assert(completion_charp != NULL);
	if (state == 0)
	{
		if (completion_case_sensitive)
			return pg_strdup(completion_charp);
		else

			/*
			 * If case insensitive matching was requested initially, adjust
			 * the case according to setting.
			 */
			return pg_strdup_keyword_case(completion_charp, text);
	}
	else
		return NULL;
}


/*
 * This function appends the variable name with prefix and suffix to
 * the variable names array.
 */
static void
append_variable_names(char ***varnames, int *nvars,
					  int *maxvars, const char *varname,
					  const char *prefix, const char *suffix)
{
	if (*nvars >= *maxvars)
	{
		*maxvars *= 2;
		*varnames = (char **) pg_realloc(*varnames,
										 ((*maxvars) + 1) * sizeof(char *));
	}

	(*varnames)[(*nvars)++] = psprintf("%s%s%s", prefix, varname, suffix);
}


/*
 * This function supports completion with the name of a psql variable.
 * The variable names can be prefixed and suffixed with additional text
 * to support quoting usages. If need_value is true, only variables
 * that are currently set are included; otherwise, special variables
 * (those that have hooks) are included even if currently unset.
 */
static char **
complete_from_variables(const char *text, const char *prefix, const char *suffix,
						bool need_value)
{
	char	  **matches;
	char	  **varnames;
	int			nvars = 0;
	int			maxvars = 100;
	int			i;
	struct _variable *ptr;

	varnames = (char **) pg_malloc((maxvars + 1) * sizeof(char *));

	for (ptr = pset.vars->next; ptr; ptr = ptr->next)
	{
		if (need_value && !(ptr->value))
			continue;
		append_variable_names(&varnames, &nvars, &maxvars, ptr->name,
							  prefix, suffix);
	}

	varnames[nvars] = NULL;
	COMPLETE_WITH_LIST_CS((const char *const *) varnames);

	for (i = 0; i < nvars; i++)
		free(varnames[i]);
	free(varnames);

	return matches;
}


/*
 * This function wraps rl_filename_completion_function() to strip quotes from
 * the input before searching for matches and to quote any matches for which
 * the consuming command will require it.
 *
 * Caller must set completion_charp to a zero- or one-character string
 * containing the escape character.  This is necessary since \copy has no
 * escape character, but every other backslash command recognizes "\" as an
 * escape character.
 *
 * Caller must also set completion_force_quote to indicate whether to force
 * quotes around the result.  (The SQL COPY command requires that.)
 */
static char *
complete_from_files(const char *text, int state)
{
#ifdef USE_FILENAME_QUOTING_FUNCTIONS

	/*
	 * If we're using a version of Readline that supports filename quoting
	 * hooks, rely on those, and invoke rl_filename_completion_function()
	 * without messing with its arguments.  Readline does stuff internally
	 * that does not work well at all if we try to handle dequoting here.
	 * Instead, Readline will call quote_file_name() and dequote_file_name()
	 * (see below) at appropriate times.
	 *
	 * ... or at least, mostly it will.  There are some paths involving
	 * unmatched file names in which Readline never calls quote_file_name(),
	 * and if left to its own devices it will incorrectly append a quote
	 * anyway.  Set rl_completion_suppress_quote to prevent that.  If we do
	 * get to quote_file_name(), we'll clear this again.  (Yes, this seems
	 * like it's working around Readline bugs.)
	 */
#ifdef HAVE_RL_COMPLETION_SUPPRESS_QUOTE
	rl_completion_suppress_quote = 1;
#endif

	/* If user typed a quote, force quoting (never remove user's quote) */
	if (*text == '\'')
		completion_force_quote = true;

	return rl_filename_completion_function(text, state);
#else

	/*
	 * Otherwise, we have to do the best we can.
	 */
	static const char *unquoted_text;
	char	   *unquoted_match;
	char	   *ret = NULL;

	/* If user typed a quote, force quoting (never remove user's quote) */
	if (*text == '\'')
		completion_force_quote = true;

	if (state == 0)
	{
		/* Initialization: stash the unquoted input. */
		unquoted_text = strtokx(text, "", NULL, "'", *completion_charp,
								false, true, pset.encoding);
		/* expect a NULL return for the empty string only */
		if (!unquoted_text)
		{
			Assert(*text == '\0');
			unquoted_text = text;
		}
	}

	unquoted_match = rl_filename_completion_function(unquoted_text, state);
	if (unquoted_match)
	{
		struct stat statbuf;
		bool		is_dir = (stat(unquoted_match, &statbuf) == 0 &&
							  S_ISDIR(statbuf.st_mode) != 0);

		/* Re-quote the result, if needed. */
		ret = quote_if_needed(unquoted_match, " \t\r\n\"`",
							  '\'', *completion_charp,
							  completion_force_quote,
							  pset.encoding);
		if (ret)
			free(unquoted_match);
		else
			ret = unquoted_match;

		/*
		 * If it's a directory, replace trailing quote with a slash; this is
		 * usually more convenient.  (If we didn't quote, leave this to
		 * libedit.)
		 */
		if (*ret == '\'' && is_dir)
		{
			char	   *retend = ret + strlen(ret) - 1;

			Assert(*retend == '\'');
			*retend = '/';
			/* Prevent libedit from adding a space, too */
			rl_completion_append_character = '\0';
		}
	}

	return ret;
#endif							/* USE_FILENAME_QUOTING_FUNCTIONS */
}


/* HELPER FUNCTIONS */


/*
 * Make a pg_strdup copy of s and convert the case according to
 * COMP_KEYWORD_CASE setting, using ref as the text that was already entered.
 */
static char *
pg_strdup_keyword_case(const char *s, const char *ref)
{
	char	   *ret,
			   *p;
	unsigned char first = ref[0];

	ret = pg_strdup(s);

	if (pset.comp_case == PSQL_COMP_CASE_LOWER ||
		((pset.comp_case == PSQL_COMP_CASE_PRESERVE_LOWER ||
		  pset.comp_case == PSQL_COMP_CASE_PRESERVE_UPPER) && islower(first)) ||
		(pset.comp_case == PSQL_COMP_CASE_PRESERVE_LOWER && !isalpha(first)))
	{
		for (p = ret; *p; p++)
			*p = pg_tolower((unsigned char) *p);
	}
	else
	{
		for (p = ret; *p; p++)
			*p = pg_toupper((unsigned char) *p);
	}

	return ret;
}


/*
 * escape_string - Escape argument for use as string literal.
 *
 * The returned value has to be freed.
 */
static char *
escape_string(const char *text)
{
	size_t		text_length;
	char	   *result;

	text_length = strlen(text);

	result = pg_malloc(text_length * 2 + 1);
	PQescapeStringConn(pset.db, result, text, text_length, NULL);

	return result;
}


/*
 * make_like_pattern - Convert argument to a LIKE prefix pattern.
 *
 * We escape _ and % in the given text by backslashing, append a % to
 * represent "any subsequent characters", and then pass the string through
 * escape_string() so it's ready to insert in a query.  The result needs
 * to be freed.
 */
static char *
make_like_pattern(const char *word)
{
	char	   *result;
	char	   *buffer = pg_malloc(strlen(word) * 2 + 2);
	char	   *bptr = buffer;

	while (*word)
	{
		if (*word == '_' || *word == '%')
			*bptr++ = '\\';
		if (IS_HIGHBIT_SET(*word))
		{
			/*
			 * Transfer multibyte characters without further processing, to
			 * avoid getting confused in unsafe client encodings.
			 */
			int			chlen = PQmblenBounded(word, pset.encoding);

			while (chlen-- > 0)
				*bptr++ = *word++;
		}
		else
			*bptr++ = *word++;
	}
	*bptr++ = '%';
	*bptr = '\0';

	result = escape_string(buffer);
	free(buffer);
	return result;
}


/*
 * parse_identifier - Parse a possibly-schema-qualified SQL identifier.
 *
 * This involves splitting off the schema name if present, de-quoting,
 * and downcasing any unquoted text.  We are a bit laxer than the backend
 * in that we allow just portions of a name to be quoted --- that's because
 * psql metacommands have traditionally behaved that way.
 *
 * Outputs are a malloc'd schema name (NULL if none), malloc'd object name,
 * and booleans telling whether any part of the schema and object name was
 * double-quoted.
 */
static void
parse_identifier(const char *ident,
				 char **schemaname, char **objectname,
				 bool *schemaquoted, bool *objectquoted)
{
	size_t		buflen = strlen(ident) + 1;
	bool		enc_is_single_byte = (pg_encoding_max_length(pset.encoding) == 1);
	char	   *sname;
	char	   *oname;
	char	   *optr;
	bool		inquotes;

	/* Initialize, making a certainly-large-enough output buffer */
	sname = NULL;
	oname = pg_malloc(buflen);
	*schemaquoted = *objectquoted = false;
	/* Scan */
	optr = oname;
	inquotes = false;
	while (*ident)
	{
		unsigned char ch = (unsigned char) *ident++;

		if (ch == '"')
		{
			if (inquotes && *ident == '"')
			{
				/* two quote marks within a quoted identifier = emit quote */
				*optr++ = '"';
				ident++;
			}
			else
			{
				inquotes = !inquotes;
				*objectquoted = true;
			}
		}
		else if (ch == '.' && !inquotes)
		{
			/* Found a schema name, transfer it to sname / *schemaquoted */
			*optr = '\0';
			free(sname);		/* drop any catalog name */
			sname = oname;
			oname = pg_malloc(buflen);
			optr = oname;
			*schemaquoted = *objectquoted;
			*objectquoted = false;
		}
		else if (!enc_is_single_byte && IS_HIGHBIT_SET(ch))
		{
			/*
			 * Transfer multibyte characters without further processing.  They
			 * wouldn't be affected by our downcasing rule anyway, and this
			 * avoids possibly doing the wrong thing in unsafe client
			 * encodings.
			 */
			int			chlen = PQmblenBounded(ident - 1, pset.encoding);

			*optr++ = (char) ch;
			while (--chlen > 0)
				*optr++ = *ident++;
		}
		else
		{
			if (!inquotes)
			{
				/*
				 * This downcasing transformation should match the backend's
				 * downcase_identifier() as best we can.  We do not know the
				 * backend's locale, though, so it's necessarily approximate.
				 * We assume that psql is operating in the same locale and
				 * encoding as the backend.
				 */
				if (ch >= 'A' && ch <= 'Z')
					ch += 'a' - 'A';
				else if (enc_is_single_byte && IS_HIGHBIT_SET(ch) && isupper(ch))
					ch = tolower(ch);
			}
			*optr++ = (char) ch;
		}
	}

	*optr = '\0';
	*schemaname = sname;
	*objectname = oname;
}


/*
 * requote_identifier - Reconstruct a possibly-schema-qualified SQL identifier.
 *
 * Build a malloc'd string containing the identifier, with quoting applied
 * as necessary.  This is more or less the inverse of parse_identifier;
 * in particular, if an input component was quoted, we'll quote the output
 * even when that isn't strictly required.
 *
 * Unlike parse_identifier, we handle the case where a schema and no
 * object name is provided, producing just "schema.".
 */
static char *
requote_identifier(const char *schemaname, const char *objectname,
				   bool quote_schema, bool quote_object)
{
	char	   *result;
	size_t		buflen = 1;		/* count the trailing \0 */
	char	   *ptr;

	/*
	 * We could use PQescapeIdentifier for some of this, but not all, and it
	 * adds more notational cruft than it seems worth.
	 */
	if (schemaname)
	{
		buflen += strlen(schemaname) + 1;	/* +1 for the dot */
		if (!quote_schema)
			quote_schema = identifier_needs_quotes(schemaname);
		if (quote_schema)
		{
			buflen += 2;		/* account for quote marks */
			for (const char *p = schemaname; *p; p++)
			{
				if (*p == '"')
					buflen++;
			}
		}
	}
	if (objectname)
	{
		buflen += strlen(objectname);
		if (!quote_object)
			quote_object = identifier_needs_quotes(objectname);
		if (quote_object)
		{
			buflen += 2;		/* account for quote marks */
			for (const char *p = objectname; *p; p++)
			{
				if (*p == '"')
					buflen++;
			}
		}
	}
	result = pg_malloc(buflen);
	ptr = result;
	if (schemaname)
	{
		if (quote_schema)
			*ptr++ = '"';
		for (const char *p = schemaname; *p; p++)
		{
			*ptr++ = *p;
			if (*p == '"')
				*ptr++ = '"';
		}
		if (quote_schema)
			*ptr++ = '"';
		*ptr++ = '.';
	}
	if (objectname)
	{
		if (quote_object)
			*ptr++ = '"';
		for (const char *p = objectname; *p; p++)
		{
			*ptr++ = *p;
			if (*p == '"')
				*ptr++ = '"';
		}
		if (quote_object)
			*ptr++ = '"';
	}
	*ptr = '\0';
	return result;
}


/*
 * Detect whether an identifier must be double-quoted.
 *
 * Note we'll quote anything that's not ASCII; the backend's quote_ident()
 * does the same.  Perhaps this could be relaxed in future.
 */
static bool
identifier_needs_quotes(const char *ident)
{
	int			kwnum;

	/* Check syntax. */
	if (!((ident[0] >= 'a' && ident[0] <= 'z') || ident[0] == '_'))
		return true;
	if (strspn(ident, "abcdefghijklmnopqrstuvwxyz0123456789_$") != strlen(ident))
		return true;

	/*
	 * Check for keyword.  We quote keywords except for unreserved ones.
	 *
	 * It is possible that our keyword list doesn't quite agree with the
	 * server's, but this should be close enough for tab-completion purposes.
	 *
	 * Note: ScanKeywordLookup() does case-insensitive comparison, but that's
	 * fine, since we already know we have all-lower-case.
	 */
	kwnum = ScanKeywordLookup(ident, &ScanKeywords);

	if (kwnum >= 0 && ScanKeywordCategories[kwnum] != UNRESERVED_KEYWORD)
		return true;

	return false;
}


/*
 * Execute a query, returning NULL if there was any error.
 * This should be the preferred way of talking to the database in this file.
 */
static PGresult *
exec_query(const char *query)
{
	PGresult   *result;

	if (query == NULL || !pset.db || PQstatus(pset.db) != CONNECTION_OK)
		return NULL;

	result = PQexec(pset.db, query);

	if (PQresultStatus(result) != PGRES_TUPLES_OK)
	{
		/*
		 * Printing an error while the user is typing would be quite annoying,
		 * so we don't.  This does complicate debugging of this code; but you
		 * can look in the server log instead.
		 */
#ifdef NOT_USED
		pg_log_error("tab completion query failed: %s\nQuery was:\n%s",
					 PQerrorMessage(pset.db), query);
#endif
		PQclear(result);
		result = NULL;
	}

	return result;
}


/*
 * Parse all the word(s) before point.
 *
 * Returns a malloc'd array of character pointers that point into the malloc'd
 * data array returned to *buffer; caller must free() both of these when done.
 * *nwords receives the number of words found, ie, the valid length of the
 * return array.
 *
 * Words are returned right to left, that is, previous_words[0] gets the last
 * word before point, previous_words[1] the next-to-last, etc.
 */
static char **
get_previous_words(int point, char **buffer, int *nwords)
{
	char	  **previous_words;
	char	   *buf;
	char	   *outptr;
	int			words_found = 0;
	int			i;

	/*
	 * If we have anything in tab_completion_query_buf, paste it together with
	 * rl_line_buffer to construct the full query.  Otherwise we can just use
	 * rl_line_buffer as the input string.
	 */
	if (tab_completion_query_buf && tab_completion_query_buf->len > 0)
	{
		i = tab_completion_query_buf->len;
		buf = pg_malloc(point + i + 2);
		memcpy(buf, tab_completion_query_buf->data, i);
		buf[i++] = '\n';
		memcpy(buf + i, rl_line_buffer, point);
		i += point;
		buf[i] = '\0';
		/* Readjust point to reference appropriate offset in buf */
		point = i;
	}
	else
		buf = rl_line_buffer;

	/*
	 * Allocate an array of string pointers and a buffer to hold the strings
	 * themselves.  The worst case is that the line contains only
	 * non-whitespace WORD_BREAKS characters, making each one a separate word.
	 * This is usually much more space than we need, but it's cheaper than
	 * doing a separate malloc() for each word.
	 */
	previous_words = (char **) pg_malloc(point * sizeof(char *));
	*buffer = outptr = (char *) pg_malloc(point * 2);

	/*
	 * First we look for a non-word char before the current point.  (This is
	 * probably useless, if readline is on the same page as we are about what
	 * is a word, but if so it's cheap.)
	 */
	for (i = point - 1; i >= 0; i--)
	{
		if (strchr(WORD_BREAKS, buf[i]))
			break;
	}
	point = i;

	/*
	 * Now parse words, working backwards, until we hit start of line.  The
	 * backwards scan has some interesting but intentional properties
	 * concerning parenthesis handling.
	 */
	while (point >= 0)
	{
		int			start,
					end;
		bool		inquotes = false;
		int			parentheses = 0;

		/* now find the first non-space which then constitutes the end */
		end = -1;
		for (i = point; i >= 0; i--)
		{
			if (!isspace((unsigned char) buf[i]))
			{
				end = i;
				break;
			}
		}
		/* if no end found, we're done */
		if (end < 0)
			break;

		/*
		 * Otherwise we now look for the start.  The start is either the last
		 * character before any word-break character going backwards from the
		 * end, or it's simply character 0.  We also handle open quotes and
		 * parentheses.
		 */
		for (start = end; start > 0; start--)
		{
			if (buf[start] == '"')
				inquotes = !inquotes;
			if (!inquotes)
			{
				if (buf[start] == ')')
					parentheses++;
				else if (buf[start] == '(')
				{
					if (--parentheses <= 0)
						break;
				}
				else if (parentheses == 0 &&
						 strchr(WORD_BREAKS, buf[start - 1]))
					break;
			}
		}

		/* Return the word located at start to end inclusive */
		previous_words[words_found++] = outptr;
		i = end - start + 1;
		memcpy(outptr, &buf[start], i);
		outptr += i;
		*outptr++ = '\0';

		/* Continue searching */
		point = start - 1;
	}

	/* Release parsing input workspace, if we made one above */
	if (buf != rl_line_buffer)
		free(buf);

	*nwords = words_found;
	return previous_words;
}

/*
 * Look up the type for the GUC variable with the passed name.
 *
 * Returns NULL if the variable is unknown. Otherwise the returned string,
 * containing the type, has to be freed.
 */
static char *
get_guctype(const char *varname)
{
	PQExpBufferData query_buffer;
	char	   *e_varname;
	PGresult   *result;
	char	   *guctype = NULL;

	e_varname = escape_string(varname);

	initPQExpBuffer(&query_buffer);
	appendPQExpBuffer(&query_buffer,
					  "SELECT vartype FROM pg_catalog.pg_settings "
					  "WHERE pg_catalog.lower(name) = pg_catalog.lower('%s')",
					  e_varname);

	result = exec_query(query_buffer.data);
	termPQExpBuffer(&query_buffer);
	free(e_varname);

	if (PQresultStatus(result) == PGRES_TUPLES_OK && PQntuples(result) > 0)
		guctype = pg_strdup(PQgetvalue(result, 0, 0));

	PQclear(result);

	return guctype;
}

#ifdef USE_FILENAME_QUOTING_FUNCTIONS

/*
 * Quote a filename according to SQL rules, returning a malloc'd string.
 * completion_charp must point to escape character or '\0', and
 * completion_force_quote must be set correctly, as per comments for
 * complete_from_files().
 */
static char *
quote_file_name(char *fname, int match_type, char *quote_pointer)
{
	char	   *s;
	struct stat statbuf;

	/* Quote if needed. */
	s = quote_if_needed(fname, " \t\r\n\"`",
						'\'', *completion_charp,
						completion_force_quote,
						pset.encoding);
	if (!s)
		s = pg_strdup(fname);

	/*
	 * However, some of the time we have to strip the trailing quote from what
	 * we send back.  Never strip the trailing quote if the user already typed
	 * one; otherwise, suppress the trailing quote if we have multiple/no
	 * matches (because we don't want to add a quote if the input is seemingly
	 * unfinished), or if the input was already quoted (because Readline will
	 * do arguably-buggy things otherwise), or if the file does not exist, or
	 * if it's a directory.
	 */
	if (*s == '\'' &&
		completion_last_char != '\'' &&
		(match_type != SINGLE_MATCH ||
		 (quote_pointer && *quote_pointer == '\'') ||
		 stat(fname, &statbuf) != 0 ||
		 S_ISDIR(statbuf.st_mode)))
	{
		char	   *send = s + strlen(s) - 1;

		Assert(*send == '\'');
		*send = '\0';
	}

	/*
	 * And now we can let Readline do its thing with possibly adding a quote
	 * on its own accord.  (This covers some additional cases beyond those
	 * dealt with above.)
	 */
#ifdef HAVE_RL_COMPLETION_SUPPRESS_QUOTE
	rl_completion_suppress_quote = 0;
#endif

	/*
	 * If user typed a leading quote character other than single quote (i.e.,
	 * double quote), zap it, so that we replace it with the correct single
	 * quote.
	 */
	if (quote_pointer && *quote_pointer != '\'')
		*quote_pointer = '\0';

	return s;
}

/*
 * Dequote a filename, if it's quoted.
 * completion_charp must point to escape character or '\0', as per
 * comments for complete_from_files().
 */
static char *
dequote_file_name(char *fname, int quote_char)
{
	char	   *unquoted_fname;

	/*
	 * If quote_char is set, it's not included in "fname".  We have to add it
	 * or strtokx will not interpret the string correctly (notably, it won't
	 * recognize escapes).
	 */
	if (quote_char == '\'')
	{
		char	   *workspace = (char *) pg_malloc(strlen(fname) + 2);

		workspace[0] = quote_char;
		strcpy(workspace + 1, fname);
		unquoted_fname = strtokx(workspace, "", NULL, "'", *completion_charp,
								 false, true, pset.encoding);
		free(workspace);
	}
	else
		unquoted_fname = strtokx(fname, "", NULL, "'", *completion_charp,
								 false, true, pset.encoding);

	/* expect a NULL return for the empty string only */
	if (!unquoted_fname)
	{
		Assert(*fname == '\0');
		unquoted_fname = fname;
	}

	/* readline expects a malloc'd result that it is to free */
	return pg_strdup(unquoted_fname);
}

#endif							/* USE_FILENAME_QUOTING_FUNCTIONS */

#endif							/* USE_READLINE */
