/**
 * @file bcsc_c.h
 *
 * @copyright 2004-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Mathieu Faverge
 * @author Pierre Ramet
 * @author Xavier Lacoste
 * @author Vincent Bridonneau
 * @date 2024-07-05
 *
 * @generated from /build/pastix/src/pastix-6.4.0/bcsc/bcsc_z.h, normal z -> c, Thu Oct 23 06:51:46 2025
 *
 **/
#ifndef _bcsc_c_h_
#define _bcsc_c_h_

/**
 * @addtogroup bcsc_internal
 * @{
 *
 *    @name PastixComplex32 initialization functions
 *    @{
 */
void bcsc_cinit( const spmatrix_t     *spm,
                 const pastix_order_t *ord,
                 const SolverMatrix   *solvmtx,
                 int                   initAt,
                 pastix_bcsc_t        *bcsc,
                 pastix_int_t          valuesize );

#if defined(PASTIX_WITH_MPI)
void bcsc_cstore_data( const spmatrix_t     *spm,
                       const pastix_order_t *ord,
                       const pastix_int_t   *col2cblk,
                       bcsc_handle_comm_t   *bcsc_comm );
#endif

/**
 *   @}
 * @}
 *
 * @addtogroup bcsc
 * @{
 *
 *    @name PastixComplex32 vector(s) operations
 *    @{
 */
void bvec_caxpy_seq( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     pastix_complex32_t        alpha,
                     const pastix_complex32_t *x,
                     pastix_complex32_t       *y );
void bvec_caxpy_smp( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     pastix_complex32_t        alpha,
                     const pastix_complex32_t *x,
                     pastix_complex32_t       *y );

void bvec_ccopy_seq( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     const pastix_complex32_t *x,
                     pastix_complex32_t       *y );
void bvec_ccopy_smp( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     const pastix_complex32_t *x,
                     pastix_complex32_t       *y );

#if defined(PRECISION_z) || defined(PRECISION_c)
pastix_complex32_t bvec_cdotc_seq( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const pastix_complex32_t *x,
                                   const pastix_complex32_t *y );
pastix_complex32_t bvec_cdotc_smp( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const pastix_complex32_t *x,
                                   const pastix_complex32_t *y );
#endif

pastix_complex32_t bvec_cdotu_seq( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const pastix_complex32_t *x,
                                   const pastix_complex32_t *y );
pastix_complex32_t bvec_cdotu_smp( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const pastix_complex32_t *x,
                                   const pastix_complex32_t *y );

void bvec_cgemv_seq( pastix_data_t            *pastix_data,
                     pastix_int_t              m,
                     pastix_int_t              n,
                     pastix_complex32_t        alpha,
                     const pastix_complex32_t *A,
                     pastix_int_t              lda,
                     const pastix_complex32_t *x,
                     pastix_complex32_t        beta,
                     pastix_complex32_t       *y );
void bvec_cgemv_smp( pastix_data_t            *pastix_data,
                     pastix_int_t              m,
                     pastix_int_t              n,
                     pastix_complex32_t        alpha,
                     const pastix_complex32_t *A,
                     pastix_int_t              lda,
                     const pastix_complex32_t *x,
                     pastix_complex32_t        beta,
                     pastix_complex32_t       *y );

float bvec_cnrm2_seq( pastix_data_t            *pastix_data,
                       pastix_int_t              n,
                       const pastix_complex32_t *x );
float bvec_cnrm2_smp( pastix_data_t            *pastix_data,
                       pastix_int_t              n,
                       const pastix_complex32_t *x );

void bvec_cscal_seq( pastix_data_t      *pastix_data,
                     pastix_int_t        n,
                     pastix_complex32_t  alpha,
                     pastix_complex32_t *x );
void bvec_cscal_smp( pastix_data_t      *pastix_data,
                     pastix_int_t        n,
                     pastix_complex32_t  alpha,
                     pastix_complex32_t *x );

#if defined( PASTIX_WITH_MPI )
int bvec_cexchange_data_rep( pastix_data_t      *pastix_data,
                             pastix_int_t        nrhs,
                             pastix_complex32_t *b,
                             pastix_int_t        ldb,
                             pastix_rhs_t        Pb );
int bvec_callocate_buf_dst( bvec_handle_comm_t *rhs_comm );
int bvec_cexchange_data_dst( pastix_data_t      *pastix_data,
                             pastix_dir_t        dir,
                             pastix_int_t        nrhs,
                             pastix_complex32_t *b,
                             pastix_int_t        ldb,
                             pastix_rhs_t        Pb,
                             const pastix_int_t *glob2loc );
#endif

int bvec_clapmr( pastix_data_t      *pastix_data,
                 pastix_dir_t        dir,
                 pastix_int_t        m,
                 pastix_int_t        n,
                 pastix_complex32_t *A,
                 pastix_int_t        lda,
                 pastix_rhs_t        PA );

/**
 *    @}
 *
 *    @name PastixComplex32 matrix operations
 *    @{
 */
float bcsc_cnorm( pastix_normtype_t    ntype,
                   const pastix_bcsc_t *bcsc );

void bcsc_cspsv( pastix_data_t      *pastix_data,
                 pastix_complex32_t *b,
                 pastix_complex32_t *work );

void bcsc_cspmv( const pastix_data_t      *pastix_data,
                 pastix_trans_t            trans,
                 pastix_complex32_t        alpha,
                 const pastix_complex32_t *x,
                 pastix_complex32_t        beta,
                 pastix_complex32_t       *y );

void bcsc_cspmv_seq( const pastix_data_t      *pastix_data,
                     pastix_trans_t            trans,
                     pastix_complex32_t        alpha,
                     const pastix_complex32_t *x,
                     pastix_complex32_t        beta,
                     pastix_complex32_t       *y );
void bcsc_cspmv_smp( const pastix_data_t      *pastix_data,
                     pastix_trans_t            trans,
                     pastix_complex32_t        alpha,
                     const pastix_complex32_t *x,
                     pastix_complex32_t        beta,
                     pastix_complex32_t       *y );

/**
 *    @}
 *
 *    @name PastixComplex32 MPI vector operations
 *    @{
 */
const pastix_complex32_t *bvec_cgather_remote( const pastix_data_t      *pastix_data,
                                               const pastix_complex32_t *y );
void bvec_cnullify_remote( const pastix_data_t *pastix_data,
                           pastix_complex32_t  *y );
void bvec_callreduce( const pastix_data_t *pastix_data,
                      pastix_complex32_t  *y );
/**
 *    @}
 * @}
 */
#endif /* _bcsc_c_h_ */
