#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkFunctor_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAbstractAccumulator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAbstractArrayMeasurement_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkArithmeticMeanArrayMeasurement_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkEntropyArrayMeasurement_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGeometricMeanArrayMeasurement_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHarmonicMeanArrayMeasurement_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMaxAccumulator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMaxArrayMeasurement_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkQuantileAccumulator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkQuantileArrayMeasurement_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkResampleToHyperTreeGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStandardDeviationArrayMeasurement_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkArithmeticAccumulator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBinsAccumulator_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersHyperTreeGridADRCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkFunctor_Init(csi);
  vtkAbstractAccumulator_Init(csi);
  vtkAbstractArrayMeasurement_Init(csi);
  vtkArithmeticMeanArrayMeasurement_Init(csi);
  vtkEntropyArrayMeasurement_Init(csi);
  vtkGeometricMeanArrayMeasurement_Init(csi);
  vtkHarmonicMeanArrayMeasurement_Init(csi);
  vtkMaxAccumulator_Init(csi);
  vtkMaxArrayMeasurement_Init(csi);
  vtkQuantileAccumulator_Init(csi);
  vtkQuantileArrayMeasurement_Init(csi);
  vtkResampleToHyperTreeGrid_Init(csi);
  vtkStandardDeviationArrayMeasurement_Init(csi);
  vtkArithmeticAccumulator_Init(csi);
  vtkBinsAccumulator_Init(csi);
}
