// python wrapper for vtkSMProxyConfigurationWriter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMProxyConfigurationWriter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMProxyConfigurationWriter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMProxyConfigurationWriter_ClassNew(); }


static PyObject *
PyvtkSMProxyConfigurationWriter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMProxyConfigurationWriter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMProxyConfigurationWriter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMProxyConfigurationWriter *tempr = vtkSMProxyConfigurationWriter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProxyConfigurationWriter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMProxyConfigurationWriter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMProxyConfigurationWriter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMProxyConfigurationWriter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_SetProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->SetProxy(temp0);
    }
    else
    {
      op->vtkSMProxyConfigurationWriter::SetProxy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_GetProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->GetProxy() :
      op->vtkSMProxyConfigurationWriter::GetProxy());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_SetPropertyIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPropertyIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  vtkSMPropertyIterator *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMPropertyIterator"))
  {
    if (ap.IsBound())
    {
      op->SetPropertyIterator(temp0);
    }
    else
    {
      op->vtkSMProxyConfigurationWriter::SetPropertyIterator(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_GetPropertyIterator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPropertyIterator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMPropertyIterator *tempr = (ap.IsBound() ?
      op->GetPropertyIterator() :
      op->vtkSMProxyConfigurationWriter::GetPropertyIterator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkSMProxyConfigurationWriter::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkSMProxyConfigurationWriter::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_SetFileIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileIdentifier(temp0);
    }
    else
    {
      op->vtkSMProxyConfigurationWriter::SetFileIdentifier(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_GetFileIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileIdentifier() :
      op->vtkSMProxyConfigurationWriter::GetFileIdentifier());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_SetFileDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileDescription(temp0);
    }
    else
    {
      op->vtkSMProxyConfigurationWriter::SetFileDescription(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_GetFileDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileDescription() :
      op->vtkSMProxyConfigurationWriter::GetFileDescription());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_SetFileExtension(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileExtension");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileExtension(temp0);
    }
    else
    {
      op->vtkSMProxyConfigurationWriter::SetFileExtension(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_GetFileExtension(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileExtension");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileExtension() :
      op->vtkSMProxyConfigurationWriter::GetFileExtension());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_GetWriterVersion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriterVersion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetWriterVersion() :
      op->vtkSMProxyConfigurationWriter::GetWriterVersion());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMProxyConfigurationWriter_WriteConfiguration_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteConfiguration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->WriteConfiguration() :
      op->vtkSMProxyConfigurationWriter::WriteConfiguration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMProxyConfigurationWriter_WriteConfiguration_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteConfiguration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMProxyConfigurationWriter *op = static_cast<vtkSMProxyConfigurationWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->WriteConfiguration(temp0) :
      op->vtkSMProxyConfigurationWriter::WriteConfiguration(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMProxyConfigurationWriter_WriteConfiguration(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMProxyConfigurationWriter_WriteConfiguration_s1(self, args);
    case 1:
      return PyvtkSMProxyConfigurationWriter_WriteConfiguration_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "WriteConfiguration");
  return nullptr;
}

static PyMethodDef PyvtkSMProxyConfigurationWriter_Methods[] = {
  {"IsTypeOf", PyvtkSMProxyConfigurationWriter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMProxyConfigurationWriter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMProxyConfigurationWriter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMProxyConfigurationWriter\nC++: static vtkSMProxyConfigurationWriter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMProxyConfigurationWriter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMProxyConfigurationWriter\nC++: vtkSMProxyConfigurationWriter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMProxyConfigurationWriter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMProxyConfigurationWriter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetProxy", PyvtkSMProxyConfigurationWriter_SetProxy, METH_VARARGS,
   "SetProxy(self, proxy:vtkSMProxy) -> None\nC++: virtual void SetProxy(vtkSMProxy *proxy)\n\nSet the proxy to write out.\n"},
  {"GetProxy", PyvtkSMProxyConfigurationWriter_GetProxy, METH_VARARGS,
   "GetProxy(self) -> vtkSMProxy\nC++: virtual vtkSMProxy *GetProxy()\n\n"},
  {"SetPropertyIterator", PyvtkSMProxyConfigurationWriter_SetPropertyIterator, METH_VARARGS,
   "SetPropertyIterator(self, iter:vtkSMPropertyIterator) -> None\nC++: virtual void SetPropertyIterator(vtkSMPropertyIterator *iter)\n\nSet the ieterator used to traverse properties during the write.\nIf no iterator is set then all properties are written.\n"},
  {"GetPropertyIterator", PyvtkSMProxyConfigurationWriter_GetPropertyIterator, METH_VARARGS,
   "GetPropertyIterator(self) -> vtkSMPropertyIterator\nC++: virtual vtkSMPropertyIterator *GetPropertyIterator()\n\n"},
  {"SetFileName", PyvtkSMProxyConfigurationWriter_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nSet/Get the file name.\n"},
  {"GetFileName", PyvtkSMProxyConfigurationWriter_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"SetFileIdentifier", PyvtkSMProxyConfigurationWriter_SetFileIdentifier, METH_VARARGS,
   "SetFileIdentifier(self, _arg:str) -> None\nC++: virtual void SetFileIdentifier(const char *_arg)\n\nSet/get file meta data.\n"},
  {"GetFileIdentifier", PyvtkSMProxyConfigurationWriter_GetFileIdentifier, METH_VARARGS,
   "GetFileIdentifier(self) -> str\nC++: virtual char *GetFileIdentifier()\n\n"},
  {"SetFileDescription", PyvtkSMProxyConfigurationWriter_SetFileDescription, METH_VARARGS,
   "SetFileDescription(self, _arg:str) -> None\nC++: virtual void SetFileDescription(const char *_arg)\n\n"},
  {"GetFileDescription", PyvtkSMProxyConfigurationWriter_GetFileDescription, METH_VARARGS,
   "GetFileDescription(self) -> str\nC++: virtual char *GetFileDescription()\n\n"},
  {"SetFileExtension", PyvtkSMProxyConfigurationWriter_SetFileExtension, METH_VARARGS,
   "SetFileExtension(self, _arg:str) -> None\nC++: virtual void SetFileExtension(const char *_arg)\n\n"},
  {"GetFileExtension", PyvtkSMProxyConfigurationWriter_GetFileExtension, METH_VARARGS,
   "GetFileExtension(self) -> str\nC++: virtual char *GetFileExtension()\n\n"},
  {"GetWriterVersion", PyvtkSMProxyConfigurationWriter_GetWriterVersion, METH_VARARGS,
   "GetWriterVersion(self) -> str\nC++: virtual const char *GetWriterVersion()\n\nReturn the writer version string.\n"},
  {"WriteConfiguration", PyvtkSMProxyConfigurationWriter_WriteConfiguration, METH_VARARGS,
   "WriteConfiguration(self) -> int\nC++: virtual int WriteConfiguration()\nWriteConfiguration(self, fileName:str) -> int\nC++: virtual int WriteConfiguration(const char *fileName)\n\nWrite the proxy's state directly to an XML file, in PV state\nformat.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMProxyConfigurationWriter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("proxy"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyConfigurationWriter_GetProxy(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMProxyConfigurationWriter_SetProxy(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMProxyConfigurationWriter_SetProxy(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProxy/SetProxy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("property_iterator"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyConfigurationWriter_GetPropertyIterator(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMProxyConfigurationWriter_SetPropertyIterator(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMProxyConfigurationWriter_SetPropertyIterator(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPropertyIterator/SetPropertyIterator\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyConfigurationWriter_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMProxyConfigurationWriter_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMProxyConfigurationWriter_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_identifier"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyConfigurationWriter_GetFileIdentifier(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMProxyConfigurationWriter_SetFileIdentifier(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMProxyConfigurationWriter_SetFileIdentifier(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileIdentifier/SetFileIdentifier\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_description"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyConfigurationWriter_GetFileDescription(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMProxyConfigurationWriter_SetFileDescription(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMProxyConfigurationWriter_SetFileDescription(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileDescription/SetFileDescription\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_extension"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyConfigurationWriter_GetFileExtension(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMProxyConfigurationWriter_SetFileExtension(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMProxyConfigurationWriter_SetFileExtension(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileExtension/SetFileExtension\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("writer_version"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMProxyConfigurationWriter_GetWriterVersion(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetWriterVersion\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMProxyConfigurationWriter_Doc =
  "vtkSMProxyConfigurationWriter - Base readers of a vtkSMProxy's\nvtkSMProperty's.\n\n"
  "Superclass: vtkSMObject\n\n"
  "vtkSMProxyConfigurationWriter writes state for properties for a\n"
  "single proxy. Internally the ParaView state machinery is employed.\n\n"
  "The notion of proxy configuration is similar to state but lighter as\n"
  "the proxy its domains and and its server side objects are assumed to\n"
  "already exist. Configuration also provides subseting mechanism so\n"
  "that properties may be excluded if needed.\n\n"
  "Subsetting is achieved through a specialized iterator derived from\n"
  "vtkSMPropertyIterator.\n\n"
  "@sa\n"
  "vtkSMProxyConfigurationReader, vtkSMPropertyIterator,\n"
  "vtkSMNamedPropertyIterator\n\n"
  "@par Thanks: This class was contribued by SciberQuest Inc.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMProxyConfigurationWriter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingMisc.vtkSMProxyConfigurationWriter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMProxyConfigurationWriter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMProxyConfigurationWriter_StaticNew()
{
  return vtkSMProxyConfigurationWriter::New();
}

PyObject *PyvtkSMProxyConfigurationWriter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMProxyConfigurationWriter_Type, PyvtkSMProxyConfigurationWriter_Methods,
    "vtkSMProxyConfigurationWriter",
 &PyvtkSMProxyConfigurationWriter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMProxyConfigurationWriter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMProxyConfigurationWriter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMProxyConfigurationWriter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMProxyConfigurationWriter", o) != 0)
  {
    Py_DECREF(o);
  }

}

