/* ExtendedBehavior.c generated by valac 0.56.17, the Vala compiler
 * generated from ExtendedBehavior.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. <https://elementary.io>
 * Copyright 2024 Corentin Noël <tintou@noel.tf>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "pantheon-wayland.h"
#include <wayland-client.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "pantheon-desktop-shell-client-protocol.h"
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gdk/wayland/gdkwayland.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _wl_proxy_destroy0(var) ((var == NULL) ? NULL : (var = (wl_proxy_destroy (var), NULL)))
#define _wl_registry_destroy0(var) ((var == NULL) ? NULL : (var = (wl_registry_destroy (var), NULL)))

static struct wl_registry_listener pantheon_wayland_extended_behavior_registry_listener;
static struct wl_registry_listener pantheon_wayland_extended_behavior_registry_listener = {0};

static void pantheon_wayland_extended_behavior_registry_handle_global (PantheonWaylandExtendedBehavior* self,
                                                                struct wl_registry* wl_registry,
                                                                guint32 name,
                                                                const gchar* interface,
                                                                guint32 version);
static void _pantheon_wayland_extended_behavior_registry_handle_global_wl_registrylistenerglobal (void* data,
                                                                                           struct wl_registry* wl_registry,
                                                                                           guint32 name,
                                                                                           const gchar* interface,
                                                                                           guint32 version);
static GType pantheon_wayland_extended_behavior_get_type_once (void);

static void
pantheon_wayland_extended_behavior_registry_handle_global (PantheonWaylandExtendedBehavior* self,
                                                           struct wl_registry* wl_registry,
                                                           guint32 name,
                                                           const gchar* interface,
                                                           guint32 version)
{
	g_return_if_fail (wl_registry != NULL);
	g_return_if_fail (interface != NULL);
	if (g_strcmp0 (interface, "io_elementary_pantheon_shell_v1") == 0) {
		struct io_elementary_pantheon_shell_v1* desktop_shell = NULL;
		gpointer _tmp0_;
		GdkSurface* surface = NULL;
		GdkSurface* _tmp1_;
		GdkSurface* _tmp2_;
		_tmp0_ = wl_registry_bind (wl_registry, name, &io_elementary_pantheon_shell_v1_interface, MIN (version, (guint32) 1));
		desktop_shell = (struct io_elementary_pantheon_shell_v1*) _tmp0_;
		_tmp1_ = gtk_native_get_surface ((GtkNative*) self);
		surface = _tmp1_;
		_tmp2_ = surface;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_wayland_surface_get_type ())) {
			struct wl_surface* wl_surface = NULL;
			GdkSurface* _tmp3_;
			struct wl_surface* _tmp4_;
			struct io_elementary_pantheon_shell_v1* _tmp5_;
			struct wl_surface* _tmp6_;
			struct io_elementary_pantheon_extended_behavior_v1* _tmp7_;
			_tmp3_ = surface;
			_tmp4_ = gdk_wayland_surface_get_wl_surface (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gdk_wayland_surface_get_type (), GdkWaylandSurface));
			wl_surface = _tmp4_;
			_tmp5_ = desktop_shell;
			_tmp6_ = wl_surface;
			_tmp7_ = io_elementary_pantheon_shell_v1_get_extended_behavior (_tmp5_, _tmp6_);
			g_object_set_data_full ((GObject*) self, "-pantheon-wayland-extended-behavior", _tmp7_, wl_proxy_destroy);
		}
		_wl_proxy_destroy0 (desktop_shell);
	}
}

/**
     * Connects to the pantheon wayland shell protocol and does the required setup.
     * This has to be called before any of the other methods.
     */
static void
_pantheon_wayland_extended_behavior_registry_handle_global_wl_registrylistenerglobal (void* data,
                                                                                      struct wl_registry* wl_registry,
                                                                                      guint32 name,
                                                                                      const gchar* interface,
                                                                                      guint32 version)
{
	pantheon_wayland_extended_behavior_registry_handle_global (data, wl_registry, name, interface, version);
}

void
pantheon_wayland_extended_behavior_connect_to_shell (PantheonWaylandExtendedBehavior* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	pantheon_wayland_extended_behavior_registry_listener.global = _pantheon_wayland_extended_behavior_registry_handle_global_wl_registrylistenerglobal;
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	display = _tmp0_;
	_tmp1_ = display;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gdk_wayland_display_get_type ())) {
		struct wl_display* wl_display = NULL;
		GdkDisplay* _tmp2_;
		struct wl_display* _tmp3_;
		struct wl_registry* wl_registry = NULL;
		struct wl_display* _tmp4_;
		struct wl_registry* _tmp5_;
		struct wl_registry* _tmp6_;
		struct wl_registry_listener _tmp7_;
		struct wl_display* _tmp8_;
		_tmp2_ = display;
		_tmp3_ = gdk_wayland_display_get_wl_display (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gdk_wayland_display_get_type (), GdkWaylandDisplay));
		wl_display = _tmp3_;
		_tmp4_ = wl_display;
		_tmp5_ = wl_display_get_registry (_tmp4_);
		wl_registry = _tmp5_;
		_tmp6_ = wl_registry;
		_tmp7_ = pantheon_wayland_extended_behavior_registry_listener;
		wl_registry_add_listener (_tmp6_, &_tmp7_, self);
		_tmp8_ = wl_display;
		if (wl_display_roundtrip (_tmp8_) < 0) {
			_wl_registry_destroy0 (wl_registry);
			return;
		}
		_wl_registry_destroy0 (wl_registry);
	} else {
		g_debug ("ExtendedBehavior.vala:43: Not running under wayland, not initializing " \
"pantheon shell connection.");
	}
}

/**
     * Tells the wm to keep the surface above other surfaces.
     * Should only be called after {@link connect_to_shell}.
     */
void
pantheon_wayland_extended_behavior_set_keep_above (PantheonWaylandExtendedBehavior* self)
{
	struct io_elementary_pantheon_extended_behavior_v1* extended_behavior = NULL;
	gconstpointer _tmp0_;
	struct io_elementary_pantheon_extended_behavior_v1* _tmp1_;
	_tmp0_ = g_object_get_data ((GObject*) self, "-pantheon-wayland-extended-behavior");
	extended_behavior = (struct io_elementary_pantheon_extended_behavior_v1*) _tmp0_;
	_tmp1_ = extended_behavior;
	if (_tmp1_ != NULL) {
		struct io_elementary_pantheon_extended_behavior_v1* _tmp2_;
		_tmp2_ = extended_behavior;
		io_elementary_pantheon_extended_behavior_v1_set_keep_above (_tmp2_);
	} else {
		g_warning ("ExtendedBehavior.vala:56: Couldn't set above: ExtendedBehavior surface" \
" was null. Did you forget to call connect_to_shell?");
	}
}

/**
     * Tells the wm to keep this surface centered. It will also stay centered if it resizes.
     * Note though that it can still be moved with Super + Mouse drag, or by the surface itself,
     * e.g. via a WindowHandle
     * Should only be called after {@link connect_to_shell}.
     */
void
pantheon_wayland_extended_behavior_make_centered (PantheonWaylandExtendedBehavior* self)
{
	struct io_elementary_pantheon_extended_behavior_v1* extended_behavior = NULL;
	gconstpointer _tmp0_;
	struct io_elementary_pantheon_extended_behavior_v1* _tmp1_;
	_tmp0_ = g_object_get_data ((GObject*) self, "-pantheon-wayland-extended-behavior");
	extended_behavior = (struct io_elementary_pantheon_extended_behavior_v1*) _tmp0_;
	_tmp1_ = extended_behavior;
	if (_tmp1_ != NULL) {
		struct io_elementary_pantheon_extended_behavior_v1* _tmp2_;
		_tmp2_ = extended_behavior;
		io_elementary_pantheon_extended_behavior_v1_make_centered (_tmp2_);
	} else {
		g_warning ("ExtendedBehavior.vala:71: Couldn't make centered: ExtendedBehavior sur" \
"face was null. Did you forget to call connect_to_shell?");
	}
}

/**
     * Tells the wm to give this surface keyboard focus.
     * Should only be called after {@link connect_to_shell}.
     */
void
pantheon_wayland_extended_behavior_focus (PantheonWaylandExtendedBehavior* self)
{
	struct io_elementary_pantheon_extended_behavior_v1* extended_behavior = NULL;
	gconstpointer _tmp0_;
	struct io_elementary_pantheon_extended_behavior_v1* _tmp1_;
	_tmp0_ = g_object_get_data ((GObject*) self, "-pantheon-wayland-extended-behavior");
	extended_behavior = (struct io_elementary_pantheon_extended_behavior_v1*) _tmp0_;
	_tmp1_ = extended_behavior;
	if (_tmp1_ != NULL) {
		struct io_elementary_pantheon_extended_behavior_v1* _tmp2_;
		_tmp2_ = extended_behavior;
		io_elementary_pantheon_extended_behavior_v1_focus (_tmp2_);
	} else {
		g_warning ("ExtendedBehavior.vala:84: Couldn't focus: ExtendedBehavior surface was" \
" null. Did you forget to call connect_to_shell?");
	}
}

static void
pantheon_wayland_extended_behavior_default_init (PantheonWaylandExtendedBehaviorIface * iface,
                                                 gpointer iface_data)
{
}

/**
 * This interface is used for certain special behavior of surfaces on a pantheon wayland
 * session.
 */
static GType
pantheon_wayland_extended_behavior_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonWaylandExtendedBehaviorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_wayland_extended_behavior_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pantheon_wayland_extended_behavior_type_id;
	pantheon_wayland_extended_behavior_type_id = g_type_register_static (G_TYPE_INTERFACE, "PantheonWaylandExtendedBehavior", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pantheon_wayland_extended_behavior_type_id, gtk_widget_get_type ());
	g_type_interface_add_prerequisite (pantheon_wayland_extended_behavior_type_id, gtk_native_get_type ());
	return pantheon_wayland_extended_behavior_type_id;
}

GType
pantheon_wayland_extended_behavior_get_type (void)
{
	static volatile gsize pantheon_wayland_extended_behavior_type_id__once = 0;
	if (g_once_init_enter (&pantheon_wayland_extended_behavior_type_id__once)) {
		GType pantheon_wayland_extended_behavior_type_id;
		pantheon_wayland_extended_behavior_type_id = pantheon_wayland_extended_behavior_get_type_once ();
		g_once_init_leave (&pantheon_wayland_extended_behavior_type_id__once, pantheon_wayland_extended_behavior_type_id);
	}
	return pantheon_wayland_extended_behavior_type_id__once;
}

