/* PhotoCanvas.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PhotoCanvas.vala, do not modify */

/*
* Copyright 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* This file is the master unit file for the EditingTools unit.  It should be edited to include
 * whatever code is deemed necessary.
 *
 * The init () and terminate () methods are mandatory.
 *
 * If the unit needs to be configured prior to initialization, add the proper parameters to
 * the preconfigure () method, implement it, and ensure in init () that it's been called.
 */
/* The PhotoCanvas is an interface object between an EditingTool and its host.  It provides objects*/
/* and primitives for an EditingTool to obtain information about the image, to draw on the host's*/
/* canvas, and to be signalled when the canvas and its pixbuf changes (is resized).*/

#include "io.elementary.photos.h"
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	EDITING_TOOLS_PHOTO_CANVAS_0_PROPERTY,
	EDITING_TOOLS_PHOTO_CANVAS_DEFAULT_CTX_PROPERTY,
	EDITING_TOOLS_PHOTO_CANVAS_SURFACE_DIM_PROPERTY,
	EDITING_TOOLS_PHOTO_CANVAS_SCALED_PIXBUF_PROPERTY,
	EDITING_TOOLS_PHOTO_CANVAS_SCALED_POSITION_PROPERTY,
	EDITING_TOOLS_PHOTO_CANVAS_DRAWING_WINDOW_PROPERTY,
	EDITING_TOOLS_PHOTO_CANVAS_CONTAINER_PROPERTY,
	EDITING_TOOLS_PHOTO_CANVAS_PHOTO_PROPERTY,
	EDITING_TOOLS_PHOTO_CANVAS_NUM_PROPERTIES
};
static GParamSpec* editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_NUM_PROPERTIES];
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
enum  {
	EDITING_TOOLS_PHOTO_CANVAS_NEW_SURFACE_SIGNAL,
	EDITING_TOOLS_PHOTO_CANVAS_RESIZED_SCALED_PIXBUF_SIGNAL,
	EDITING_TOOLS_PHOTO_CANVAS_NUM_SIGNALS
};
static guint editing_tools_photo_canvas_signals[EDITING_TOOLS_PHOTO_CANVAS_NUM_SIGNALS] = {0};

struct _EditingToolsPhotoCanvasPrivate {
	cairo_t* _default_ctx;
	Dimensions _surface_dim;
	GdkPixbuf* _scaled_pixbuf;
	GdkRectangle _scaled_position;
	GdkWindow* _drawing_window;
	GtkWindow* _container;
	Photo* _photo;
	cairo_surface_t* scaled;
};

static gint EditingToolsPhotoCanvas_private_offset;
static gpointer editing_tools_photo_canvas_parent_class = NULL;

static void editing_tools_photo_canvas_active_to_unscaled_point (EditingToolsPhotoCanvas* self,
                                                          GdkPoint* active_point,
                                                          GdkPoint* result);
static cairo_surface_t* editing_tools_photo_canvas_pixbuf_to_surface (EditingToolsPhotoCanvas* self,
                                                               cairo_t* default_ctx,
                                                               GdkPixbuf* pixbuf,
                                                               GdkRectangle* pos);
static void editing_tools_photo_canvas_real_repaint (EditingToolsPhotoCanvas* self);
VALA_EXTERN void set_source_color_from_string (cairo_t* ctx,
                                   const gchar* spec);
static GtkStyleContext* editing_tools_photo_canvas_real_get_style_context (EditingToolsPhotoCanvas* self);
static gboolean _dimensions_equal (const Dimensions * s1,
                            const Dimensions * s2);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static void g_cclosure_user_marshal_VOID__BOXED_BOXED (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOXED_OBJECT_BOXED (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static GObject * editing_tools_photo_canvas_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void editing_tools_photo_canvas_finalize (GObject * obj);
static GType editing_tools_photo_canvas_get_type_once (void);
static void _vala_editing_tools_photo_canvas_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_editing_tools_photo_canvas_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
editing_tools_photo_canvas_get_instance_private (EditingToolsPhotoCanvas* self)
{
	return G_STRUCT_MEMBER_P (self, EditingToolsPhotoCanvas_private_offset);
}

EditingToolsPhotoCanvas*
editing_tools_photo_canvas_construct (GType object_type,
                                      GtkWindow* container,
                                      GdkWindow* drawing_window,
                                      Photo* photo,
                                      cairo_t* default_ctx,
                                      Dimensions* surface_dim,
                                      GdkPixbuf* scaled_pixbuf,
                                      GdkRectangle* scaled_position)
{
	EditingToolsPhotoCanvas * self = NULL;
	Dimensions _tmp0_;
	GdkRectangle _tmp1_;
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (drawing_window != NULL, NULL);
	g_return_val_if_fail (photo != NULL, NULL);
	g_return_val_if_fail (default_ctx != NULL, NULL);
	g_return_val_if_fail (surface_dim != NULL, NULL);
	g_return_val_if_fail (scaled_pixbuf != NULL, NULL);
	g_return_val_if_fail (scaled_position != NULL, NULL);
	_tmp0_ = *surface_dim;
	_tmp1_ = *scaled_position;
	self = (EditingToolsPhotoCanvas*) g_object_new (object_type, "container", container, "drawing-window", drawing_window, "photo", photo, "default-ctx", default_ctx, "surface-dim", &_tmp0_, "scaled-position", &_tmp1_, "scaled-pixbuf", scaled_pixbuf, NULL);
	return self;
}

void
editing_tools_photo_canvas_unscaled_to_raw_rect (EditingToolsPhotoCanvas* self,
                                                 GdkRectangle* rectangle,
                                                 GdkRectangle* result)
{
	Photo* _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (rectangle != NULL);
	_tmp0_ = self->priv->_photo;
	_tmp1_ = *rectangle;
	photo_unscaled_to_raw_rect (_tmp0_, &_tmp1_, &_tmp2_);
	*result = _tmp2_;
	return;
}

static void
editing_tools_photo_canvas_active_to_unscaled_point (EditingToolsPhotoCanvas* self,
                                                     GdkPoint* active_point,
                                                     GdkPoint* result)
{
	Dimensions unscaled_dims = {0};
	Photo* _tmp0_;
	Dimensions _tmp1_ = {0};
	gdouble scale_factor_x = 0.0;
	Dimensions _tmp2_;
	GdkRectangle _tmp3_;
	gdouble scale_factor_y = 0.0;
	Dimensions _tmp4_;
	GdkRectangle _tmp5_;
	GdkPoint _result_ = {0};
	GdkPoint _tmp6_ = {0};
	GdkPoint _tmp7_;
	GdkPoint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (active_point != NULL);
	_tmp0_ = self->priv->_photo;
	media_source_get_dimensions ((MediaSource*) _tmp0_, PHOTO_EXCEPTION_NONE, &_tmp1_);
	unscaled_dims = _tmp1_;
	_tmp2_ = unscaled_dims;
	_tmp3_ = self->priv->_scaled_position;
	scale_factor_x = ((gdouble) _tmp2_.width) / ((gdouble) _tmp3_.width);
	_tmp4_ = unscaled_dims;
	_tmp5_ = self->priv->_scaled_position;
	scale_factor_y = ((gdouble) _tmp4_.height) / ((gdouble) _tmp5_.height);
	_tmp6_.x = 0;
	_result_ = _tmp6_;
	_tmp7_ = *active_point;
	_result_.x = (gint) ((((gdouble) _tmp7_.x) * scale_factor_x) + 0.5);
	_tmp8_ = *active_point;
	_result_.y = (gint) ((((gdouble) _tmp8_.y) * scale_factor_y) + 0.5);
	*result = _result_;
	return;
}

void
editing_tools_photo_canvas_active_to_unscaled_rect (EditingToolsPhotoCanvas* self,
                                                    GdkRectangle* active_rect,
                                                    GdkRectangle* result)
{
	GdkPoint upper_left = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint lower_right = {0};
	GdkPoint _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkPoint _tmp4_;
	GdkRectangle _tmp5_;
	GdkPoint _tmp6_;
	GdkRectangle _tmp7_;
	GdkPoint _tmp8_;
	GdkPoint _tmp9_ = {0};
	GdkPoint _tmp10_;
	GdkPoint _tmp11_ = {0};
	GdkRectangle unscaled_rect = {0};
	GdkPoint _tmp12_;
	GdkPoint _tmp13_;
	GdkPoint _tmp14_;
	GdkPoint _tmp15_;
	GdkPoint _tmp16_;
	GdkPoint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (active_rect != NULL);
	_tmp0_.x = 0;
	upper_left = _tmp0_;
	_tmp1_.x = 0;
	lower_right = _tmp1_;
	_tmp2_ = *active_rect;
	upper_left.x = _tmp2_.x;
	_tmp3_ = *active_rect;
	upper_left.y = _tmp3_.y;
	_tmp4_ = upper_left;
	_tmp5_ = *active_rect;
	lower_right.x = _tmp4_.x + _tmp5_.width;
	_tmp6_ = upper_left;
	_tmp7_ = *active_rect;
	lower_right.y = _tmp6_.y + _tmp7_.height;
	_tmp8_ = upper_left;
	editing_tools_photo_canvas_active_to_unscaled_point (self, &_tmp8_, &_tmp9_);
	upper_left = _tmp9_;
	_tmp10_ = lower_right;
	editing_tools_photo_canvas_active_to_unscaled_point (self, &_tmp10_, &_tmp11_);
	lower_right = _tmp11_;
	memset (&unscaled_rect, 0, sizeof (GdkRectangle));
	_tmp12_ = upper_left;
	unscaled_rect.x = _tmp12_.x;
	_tmp13_ = upper_left;
	unscaled_rect.y = _tmp13_.y;
	_tmp14_ = lower_right;
	_tmp15_ = upper_left;
	unscaled_rect.width = _tmp14_.x - _tmp15_.x;
	_tmp16_ = lower_right;
	_tmp17_ = upper_left;
	unscaled_rect.height = _tmp16_.y - _tmp17_.y;
	*result = unscaled_rect;
	return;
}

void
editing_tools_photo_canvas_user_to_active_point (EditingToolsPhotoCanvas* self,
                                                 GdkPoint* user_point,
                                                 GdkPoint* result)
{
	GdkPoint _result_ = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_;
	GdkRectangle _tmp2_;
	GdkPoint _tmp3_;
	GdkRectangle _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user_point != NULL);
	_tmp0_.x = 0;
	_result_ = _tmp0_;
	_tmp1_ = *user_point;
	_tmp2_ = self->priv->_scaled_position;
	_result_.x = _tmp1_.x - _tmp2_.x;
	_tmp3_ = *user_point;
	_tmp4_ = self->priv->_scaled_position;
	_result_.y = _tmp3_.y - _tmp4_.y;
	*result = _result_;
	return;
}

void
editing_tools_photo_canvas_user_to_active_rect (EditingToolsPhotoCanvas* self,
                                                GdkRectangle* user_rect,
                                                GdkRectangle* result)
{
	GdkPoint upper_left = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint lower_right = {0};
	GdkPoint _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkPoint _tmp4_;
	GdkRectangle _tmp5_;
	GdkPoint _tmp6_;
	GdkRectangle _tmp7_;
	GdkPoint _tmp8_;
	GdkPoint _tmp9_ = {0};
	GdkPoint _tmp10_;
	GdkPoint _tmp11_ = {0};
	GdkRectangle active_rect = {0};
	GdkPoint _tmp12_;
	GdkPoint _tmp13_;
	GdkPoint _tmp14_;
	GdkPoint _tmp15_;
	GdkPoint _tmp16_;
	GdkPoint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user_rect != NULL);
	_tmp0_.x = 0;
	upper_left = _tmp0_;
	_tmp1_.x = 0;
	lower_right = _tmp1_;
	_tmp2_ = *user_rect;
	upper_left.x = _tmp2_.x;
	_tmp3_ = *user_rect;
	upper_left.y = _tmp3_.y;
	_tmp4_ = upper_left;
	_tmp5_ = *user_rect;
	lower_right.x = _tmp4_.x + _tmp5_.width;
	_tmp6_ = upper_left;
	_tmp7_ = *user_rect;
	lower_right.y = _tmp6_.y + _tmp7_.height;
	_tmp8_ = upper_left;
	editing_tools_photo_canvas_user_to_active_point (self, &_tmp8_, &_tmp9_);
	upper_left = _tmp9_;
	_tmp10_ = lower_right;
	editing_tools_photo_canvas_user_to_active_point (self, &_tmp10_, &_tmp11_);
	lower_right = _tmp11_;
	memset (&active_rect, 0, sizeof (GdkRectangle));
	_tmp12_ = upper_left;
	active_rect.x = _tmp12_.x;
	_tmp13_ = upper_left;
	active_rect.y = _tmp13_.y;
	_tmp14_ = lower_right;
	_tmp15_ = upper_left;
	active_rect.width = _tmp14_.x - _tmp15_.x;
	_tmp16_ = lower_right;
	_tmp17_ = upper_left;
	active_rect.height = _tmp16_.y - _tmp17_.y;
	*result = active_rect;
	return;
}

void
editing_tools_photo_canvas_get_scaling (EditingToolsPhotoCanvas* self,
                                        Scaling* result)
{
	Dimensions _tmp0_;
	Scaling _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_surface_dim;
	scaling_for_viewport (&_tmp0_, FALSE, &_tmp1_);
	*result = _tmp1_;
	return;
}

void
editing_tools_photo_canvas_set_surface (EditingToolsPhotoCanvas* self,
                                        cairo_t* default_ctx,
                                        Dimensions* surface_dim)
{
	Dimensions _tmp0_;
	Dimensions _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (default_ctx != NULL);
	g_return_if_fail (surface_dim != NULL);
	editing_tools_photo_canvas_set_default_ctx (self, default_ctx);
	_tmp0_ = *surface_dim;
	editing_tools_photo_canvas_set_surface_dim (self, &_tmp0_);
	_tmp1_ = *surface_dim;
	g_signal_emit (self, editing_tools_photo_canvas_signals[EDITING_TOOLS_PHOTO_CANVAS_NEW_SURFACE_SIGNAL], 0, default_ctx, &_tmp1_);
}

void
editing_tools_photo_canvas_resized_pixbuf (EditingToolsPhotoCanvas* self,
                                           Dimensions* old_dim,
                                           GdkPixbuf* scaled,
                                           GdkRectangle* scaled_position)
{
	cairo_t* _tmp0_;
	GdkRectangle _tmp1_;
	cairo_surface_t* _tmp2_;
	GdkRectangle _tmp3_;
	Dimensions _tmp4_;
	GdkRectangle _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_dim != NULL);
	g_return_if_fail (scaled != NULL);
	g_return_if_fail (scaled_position != NULL);
	_tmp0_ = self->priv->_default_ctx;
	_tmp1_ = *scaled_position;
	_tmp2_ = editing_tools_photo_canvas_pixbuf_to_surface (self, _tmp0_, scaled, &_tmp1_);
	_cairo_surface_destroy0 (self->priv->scaled);
	self->priv->scaled = _tmp2_;
	editing_tools_photo_canvas_set_scaled_pixbuf (self, scaled);
	_tmp3_ = *scaled_position;
	editing_tools_photo_canvas_set_scaled_position (self, &_tmp3_);
	_tmp4_ = *old_dim;
	_tmp5_ = *scaled_position;
	g_signal_emit (self, editing_tools_photo_canvas_signals[EDITING_TOOLS_PHOTO_CANVAS_RESIZED_SCALED_PIXBUF_SIGNAL], 0, &_tmp4_, scaled, &_tmp5_);
}

static void
editing_tools_photo_canvas_real_repaint (EditingToolsPhotoCanvas* self)
{
	g_critical ("Type `%s' does not implement abstract method `editing_tools_photo_canvas_repaint'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
editing_tools_photo_canvas_repaint (EditingToolsPhotoCanvas* self)
{
	EditingToolsPhotoCanvasClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = EDITING_TOOLS_PHOTO_CANVAS_GET_CLASS (self);
	if (_klass_->repaint) {
		_klass_->repaint (self);
	}
}

void
editing_tools_photo_canvas_paint_pixbuf (EditingToolsPhotoCanvas* self,
                                         GdkPixbuf* pixbuf)
{
	cairo_t* _tmp0_;
	GtkStyleContext* _tmp1_;
	cairo_t* _tmp2_;
	Dimensions _tmp3_;
	Dimensions _tmp4_;
	cairo_t* _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	cairo_t* _tmp8_;
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = self->priv->_default_ctx;
	cairo_save (_tmp0_);
	_tmp1_ = editing_tools_photo_canvas_get_style_context (self);
	_tmp2_ = self->priv->_default_ctx;
	_tmp3_ = self->priv->_surface_dim;
	_tmp4_ = self->priv->_surface_dim;
	gtk_render_background (_tmp1_, _tmp2_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp3_.width, (gdouble) _tmp4_.height);
	_tmp5_ = self->priv->_default_ctx;
	_tmp6_ = self->priv->_scaled_position;
	_tmp7_ = self->priv->_scaled_position;
	gdk_cairo_set_source_pixbuf (_tmp5_, pixbuf, (gdouble) _tmp6_.x, (gdouble) _tmp7_.y);
	_tmp8_ = self->priv->_default_ctx;
	_tmp9_ = self->priv->_scaled_position;
	_tmp10_ = self->priv->_scaled_position;
	cairo_rectangle (_tmp8_, (gdouble) _tmp9_.x, (gdouble) _tmp10_.y, (gdouble) gdk_pixbuf_get_width (pixbuf), (gdouble) gdk_pixbuf_get_height (pixbuf));
	_tmp11_ = self->priv->_default_ctx;
	cairo_fill (_tmp11_);
	_tmp12_ = self->priv->_default_ctx;
	cairo_restore (_tmp12_);
}

void
editing_tools_photo_canvas_paint_surface (EditingToolsPhotoCanvas* self,
                                          cairo_surface_t* surface,
                                          gboolean over)
{
	cairo_t* _tmp0_;
	cairo_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	_tmp0_ = self->priv->_default_ctx;
	cairo_save (_tmp0_);
	if (over == FALSE) {
		cairo_t* _tmp1_;
		_tmp1_ = self->priv->_default_ctx;
		cairo_set_operator (_tmp1_, CAIRO_OPERATOR_SOURCE);
	} else {
		cairo_t* _tmp2_;
		_tmp2_ = self->priv->_default_ctx;
		cairo_set_operator (_tmp2_, CAIRO_OPERATOR_OVER);
	}
	_tmp3_ = self->priv->_default_ctx;
	_tmp4_ = self->priv->scaled;
	_tmp5_ = self->priv->_scaled_position;
	_tmp6_ = self->priv->_scaled_position;
	cairo_set_source_surface (_tmp3_, _tmp4_, (gdouble) _tmp5_.x, (gdouble) _tmp6_.y);
	_tmp7_ = self->priv->_default_ctx;
	cairo_paint (_tmp7_);
	_tmp8_ = self->priv->_default_ctx;
	_tmp9_ = self->priv->_scaled_position;
	_tmp10_ = self->priv->_scaled_position;
	cairo_set_source_surface (_tmp8_, surface, (gdouble) _tmp9_.x, (gdouble) _tmp10_.y);
	_tmp11_ = self->priv->_default_ctx;
	cairo_paint (_tmp11_);
	_tmp12_ = self->priv->_default_ctx;
	cairo_restore (_tmp12_);
}

void
editing_tools_photo_canvas_paint_surface_area (EditingToolsPhotoCanvas* self,
                                               cairo_surface_t* surface,
                                               Box* source_area,
                                               gboolean over)
{
	cairo_t* _tmp0_;
	cairo_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	cairo_t* _tmp7_;
	GdkRectangle _tmp8_;
	Box _tmp9_;
	GdkRectangle _tmp10_;
	Box _tmp11_;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	GdkRectangle _tmp14_;
	GdkRectangle _tmp15_;
	cairo_t* _tmp16_;
	GdkRectangle _tmp17_;
	Box _tmp18_;
	GdkRectangle _tmp19_;
	Box _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (source_area != NULL);
	_tmp0_ = self->priv->_default_ctx;
	cairo_save (_tmp0_);
	if (over == FALSE) {
		cairo_t* _tmp1_;
		_tmp1_ = self->priv->_default_ctx;
		cairo_set_operator (_tmp1_, CAIRO_OPERATOR_SOURCE);
	} else {
		cairo_t* _tmp2_;
		_tmp2_ = self->priv->_default_ctx;
		cairo_set_operator (_tmp2_, CAIRO_OPERATOR_OVER);
	}
	_tmp3_ = self->priv->_default_ctx;
	_tmp4_ = self->priv->scaled;
	_tmp5_ = self->priv->_scaled_position;
	_tmp6_ = self->priv->_scaled_position;
	cairo_set_source_surface (_tmp3_, _tmp4_, (gdouble) _tmp5_.x, (gdouble) _tmp6_.y);
	_tmp7_ = self->priv->_default_ctx;
	_tmp8_ = self->priv->_scaled_position;
	_tmp9_ = *source_area;
	_tmp10_ = self->priv->_scaled_position;
	_tmp11_ = *source_area;
	cairo_rectangle (_tmp7_, (gdouble) (_tmp8_.x + _tmp9_.left), (gdouble) (_tmp10_.y + _tmp11_.top), (gdouble) box_get_width (source_area), (gdouble) box_get_height (source_area));
	_tmp12_ = self->priv->_default_ctx;
	cairo_fill (_tmp12_);
	_tmp13_ = self->priv->_default_ctx;
	_tmp14_ = self->priv->_scaled_position;
	_tmp15_ = self->priv->_scaled_position;
	cairo_set_source_surface (_tmp13_, surface, (gdouble) _tmp14_.x, (gdouble) _tmp15_.y);
	_tmp16_ = self->priv->_default_ctx;
	_tmp17_ = self->priv->_scaled_position;
	_tmp18_ = *source_area;
	_tmp19_ = self->priv->_scaled_position;
	_tmp20_ = *source_area;
	cairo_rectangle (_tmp16_, (gdouble) (_tmp17_.x + _tmp18_.left), (gdouble) (_tmp19_.y + _tmp20_.top), (gdouble) box_get_width (source_area), (gdouble) box_get_height (source_area));
	_tmp21_ = self->priv->_default_ctx;
	cairo_fill (_tmp21_);
	_tmp22_ = self->priv->_default_ctx;
	cairo_restore (_tmp22_);
}

void
editing_tools_photo_canvas_draw_box (EditingToolsPhotoCanvas* self,
                                     cairo_t* ctx,
                                     Box* box)
{
	GdkRectangle rect = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (box != NULL);
	box_get_rectangle (box, &_tmp0_);
	rect = _tmp0_;
	_tmp1_ = self->priv->_scaled_position;
	rect.x = rect.x + _tmp1_.x;
	_tmp2_ = self->priv->_scaled_position;
	rect.y = rect.y + _tmp2_.y;
	_tmp3_ = rect;
	_tmp4_ = rect;
	_tmp5_ = rect;
	_tmp6_ = rect;
	cairo_rectangle (ctx, _tmp3_.x + 0.5, _tmp4_.y + 0.5, (gdouble) (_tmp5_.width - 1), (gdouble) (_tmp6_.height - 1));
	cairo_stroke (ctx);
}

void
editing_tools_photo_canvas_draw_text (EditingToolsPhotoCanvas* self,
                                      cairo_t* ctx,
                                      const gchar* text,
                                      gint x,
                                      gint y,
                                      gboolean use_scaled_pos)
{
	cairo_text_extents_t extents = {0};
	cairo_text_extents_t _tmp2_ = {0};
	cairo_text_extents_t _tmp3_;
	gint pane_border = 0;
	cairo_text_extents_t _tmp4_;
	cairo_text_extents_t _tmp5_;
	cairo_text_extents_t _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (text != NULL);
	if (use_scaled_pos) {
		GdkRectangle _tmp0_;
		GdkRectangle _tmp1_;
		_tmp0_ = self->priv->_scaled_position;
		x = x + _tmp0_.x;
		_tmp1_ = self->priv->_scaled_position;
		y = y + _tmp1_.y;
	}
	cairo_text_extents (ctx, text, &_tmp2_);
	extents = _tmp2_;
	_tmp3_ = extents;
	x = x - (((gint) _tmp3_.width) / 2);
	set_source_color_from_string (ctx, RESOURCES_ONIMAGE_FONT_BACKGROUND);
	pane_border = 5;
	_tmp4_ = extents;
	_tmp5_ = extents;
	_tmp6_ = extents;
	cairo_rectangle (ctx, (gdouble) (x - pane_border), (y - pane_border) - _tmp4_.height, _tmp5_.width + (2 * pane_border), _tmp6_.height + (2 * pane_border));
	cairo_fill (ctx);
	cairo_move_to (ctx, (gdouble) x, (gdouble) y);
	set_source_color_from_string (ctx, RESOURCES_ONIMAGE_FONT_COLOR);
	cairo_show_text (ctx, text);
}

/**
     * Draw a horizontal line into the specified Cairo context at the specified position, taking
     * into account the scaled position of the image unless directed otherwise.
     *
     * @param ctx The drawing context of the surface we're drawing to.
     * @param x The horizontal position to place the line at.
     * @param y The vertical position to place the line at.
     * @param width The length of the line.
     * @param use_scaled_pos Whether to use absolute window positioning or take into account the
     *      position of the scaled image.
     */
void
editing_tools_photo_canvas_draw_horizontal_line (EditingToolsPhotoCanvas* self,
                                                 cairo_t* ctx,
                                                 gint x,
                                                 gint y,
                                                 gint width,
                                                 gboolean use_scaled_pos)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	if (use_scaled_pos) {
		GdkRectangle _tmp0_;
		GdkRectangle _tmp1_;
		_tmp0_ = self->priv->_scaled_position;
		x = x + _tmp0_.x;
		_tmp1_ = self->priv->_scaled_position;
		y = y + _tmp1_.y;
	}
	cairo_move_to (ctx, x + 0.5, y + 0.5);
	cairo_line_to (ctx, (gdouble) ((x + width) - 1), y + 0.5);
	cairo_stroke (ctx);
}

/**
     * Draw a vertical line into the specified Cairo context at the specified position, taking
     * into account the scaled position of the image unless directed otherwise.
     *
     * @param ctx The drawing context of the surface we're drawing to.
     * @param x The horizontal position to place the line at.
     * @param y The vertical position to place the line at.
     * @param width The length of the line.
     * @param use_scaled_pos Whether to use absolute window positioning or take into account the
     *      position of the scaled image.
     */
void
editing_tools_photo_canvas_draw_vertical_line (EditingToolsPhotoCanvas* self,
                                               cairo_t* ctx,
                                               gint x,
                                               gint y,
                                               gint height,
                                               gboolean use_scaled_pos)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	if (use_scaled_pos) {
		GdkRectangle _tmp0_;
		GdkRectangle _tmp1_;
		_tmp0_ = self->priv->_scaled_position;
		x = x + _tmp0_.x;
		_tmp1_ = self->priv->_scaled_position;
		y = y + _tmp1_.y;
	}
	cairo_move_to (ctx, x + 0.5, y + 0.5);
	cairo_line_to (ctx, x + 0.5, (gdouble) ((y + height) - 1));
	cairo_stroke (ctx);
}

void
editing_tools_photo_canvas_draw_circle (EditingToolsPhotoCanvas* self,
                                        cairo_t* ctx,
                                        gint active_center_x,
                                        gint active_center_y,
                                        gint radius)
{
	gint center_x = 0;
	GdkRectangle _tmp0_;
	gint center_y = 0;
	GdkRectangle _tmp1_;
	gint scale_factor = 0;
	GtkWindow* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	_tmp0_ = self->priv->_scaled_position;
	center_x = active_center_x + _tmp0_.x;
	_tmp1_ = self->priv->_scaled_position;
	center_y = active_center_y + _tmp1_.y;
	_tmp2_ = self->priv->_container;
	_tmp3_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp2_);
	_tmp4_ = _tmp3_;
	scale_factor = _tmp4_;
	cairo_arc (ctx, (gdouble) (center_x * scale_factor), (gdouble) (center_y * scale_factor), (gdouble) (radius * scale_factor), (gdouble) 0, 2 * G_PI);
	cairo_stroke (ctx);
}

void
editing_tools_photo_canvas_invalidate_area (EditingToolsPhotoCanvas* self,
                                            Box* area)
{
	GdkRectangle rect = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkWindow* _tmp3_;
	GdkRectangle _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (area != NULL);
	box_get_rectangle (area, &_tmp0_);
	rect = _tmp0_;
	_tmp1_ = self->priv->_scaled_position;
	rect.x = rect.x + _tmp1_.x;
	_tmp2_ = self->priv->_scaled_position;
	rect.y = rect.y + _tmp2_.y;
	_tmp3_ = self->priv->_drawing_window;
	_tmp4_ = rect;
	gdk_window_invalidate_rect (_tmp3_, &_tmp4_, FALSE);
}

static cairo_surface_t*
editing_tools_photo_canvas_pixbuf_to_surface (EditingToolsPhotoCanvas* self,
                                              cairo_t* default_ctx,
                                              GdkPixbuf* pixbuf,
                                              GdkRectangle* pos)
{
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_t* ctx = NULL;
	cairo_t* _tmp4_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (default_ctx != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	g_return_val_if_fail (pos != NULL, NULL);
	_tmp0_ = cairo_get_target (default_ctx);
	_tmp1_ = *pos;
	_tmp2_ = *pos;
	_tmp3_ = cairo_surface_create_similar (_tmp0_, CAIRO_CONTENT_COLOR_ALPHA, _tmp1_.width, _tmp2_.height);
	surface = _tmp3_;
	_tmp4_ = cairo_create (surface);
	ctx = _tmp4_;
	gdk_cairo_set_source_pixbuf (ctx, pixbuf, (gdouble) 0, (gdouble) 0);
	cairo_paint (ctx);
	result = surface;
	_cairo_destroy0 (ctx);
	return result;
}

/**
     * Returns the style context associated to this.
     *
     * @return a StyleContext. This memory is owned by this and must not be freed.
     */
static GtkStyleContext*
editing_tools_photo_canvas_real_get_style_context (EditingToolsPhotoCanvas* self)
{
	g_critical ("Type `%s' does not implement abstract method `editing_tools_photo_canvas_get_style_context'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GtkStyleContext*
editing_tools_photo_canvas_get_style_context (EditingToolsPhotoCanvas* self)
{
	EditingToolsPhotoCanvasClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = EDITING_TOOLS_PHOTO_CANVAS_GET_CLASS (self);
	if (_klass_->get_style_context) {
		return _klass_->get_style_context (self);
	}
	return NULL;
}

cairo_t*
editing_tools_photo_canvas_get_default_ctx (EditingToolsPhotoCanvas* self)
{
	cairo_t* result;
	cairo_t* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_ctx;
	result = _tmp0_;
	return result;
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

void
editing_tools_photo_canvas_set_default_ctx (EditingToolsPhotoCanvas* self,
                                            cairo_t* value)
{
	cairo_t* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_photo_canvas_get_default_ctx (self);
	if (old_value != value) {
		cairo_t* _tmp0_;
		_tmp0_ = _cairo_reference0 (value);
		_cairo_destroy0 (self->priv->_default_ctx);
		self->priv->_default_ctx = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_DEFAULT_CTX_PROPERTY]);
	}
}

void
editing_tools_photo_canvas_get_surface_dim (EditingToolsPhotoCanvas* self,
                                            Dimensions * result)
{
	Dimensions _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_surface_dim;
	*result = _tmp0_;
	return;
}

static gboolean
_dimensions_equal (const Dimensions * s1,
                   const Dimensions * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

void
editing_tools_photo_canvas_set_surface_dim (EditingToolsPhotoCanvas* self,
                                            Dimensions * value)
{
	Dimensions old_value;
	g_return_if_fail (self != NULL);
	editing_tools_photo_canvas_get_surface_dim (self, &old_value);
	if (_dimensions_equal (value, &old_value) != TRUE) {
		Dimensions _tmp0_;
		_tmp0_ = *value;
		self->priv->_surface_dim = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_SURFACE_DIM_PROPERTY]);
	}
}

GdkPixbuf*
editing_tools_photo_canvas_get_scaled_pixbuf (EditingToolsPhotoCanvas* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scaled_pixbuf;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
editing_tools_photo_canvas_set_scaled_pixbuf (EditingToolsPhotoCanvas* self,
                                              GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_photo_canvas_get_scaled_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_scaled_pixbuf);
		self->priv->_scaled_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_SCALED_PIXBUF_PROPERTY]);
	}
}

void
editing_tools_photo_canvas_get_scaled_position (EditingToolsPhotoCanvas* self,
                                                GdkRectangle * result)
{
	GdkRectangle _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_scaled_position;
	*result = _tmp0_;
	return;
}

static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

void
editing_tools_photo_canvas_set_scaled_position (EditingToolsPhotoCanvas* self,
                                                GdkRectangle * value)
{
	GdkRectangle old_value;
	g_return_if_fail (self != NULL);
	editing_tools_photo_canvas_get_scaled_position (self, &old_value);
	if (_cairo_rectangle_int_equal (value, &old_value) != TRUE) {
		GdkRectangle _tmp0_;
		_tmp0_ = *value;
		self->priv->_scaled_position = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_SCALED_POSITION_PROPERTY]);
	}
}

GdkWindow*
editing_tools_photo_canvas_get_drawing_window (EditingToolsPhotoCanvas* self)
{
	GdkWindow* result;
	GdkWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_drawing_window;
	result = _tmp0_;
	return result;
}

static void
editing_tools_photo_canvas_set_drawing_window (EditingToolsPhotoCanvas* self,
                                               GdkWindow* value)
{
	GdkWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_photo_canvas_get_drawing_window (self);
	if (old_value != value) {
		GdkWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_drawing_window);
		self->priv->_drawing_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_DRAWING_WINDOW_PROPERTY]);
	}
}

GtkWindow*
editing_tools_photo_canvas_get_container (EditingToolsPhotoCanvas* self)
{
	GtkWindow* result;
	GtkWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_container;
	result = _tmp0_;
	return result;
}

static void
editing_tools_photo_canvas_set_container (EditingToolsPhotoCanvas* self,
                                          GtkWindow* value)
{
	GtkWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_photo_canvas_get_container (self);
	if (old_value != value) {
		GtkWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_container);
		self->priv->_container = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_CONTAINER_PROPERTY]);
	}
}

Photo*
editing_tools_photo_canvas_get_photo (EditingToolsPhotoCanvas* self)
{
	Photo* result;
	Photo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_photo;
	result = _tmp0_;
	return result;
}

static void
editing_tools_photo_canvas_set_photo (EditingToolsPhotoCanvas* self,
                                      Photo* value)
{
	Photo* old_value;
	g_return_if_fail (self != NULL);
	old_value = editing_tools_photo_canvas_get_photo (self);
	if (old_value != value) {
		Photo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_photo);
		self->priv->_photo = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_PHOTO_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__BOXED_BOXED (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXED_BOXED) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXED_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__BOXED_OBJECT_BOXED (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXED_OBJECT_BOXED) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__BOXED_OBJECT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_OBJECT_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_object (param_values + 2), g_value_get_boxed (param_values + 3), data2);
}

static GObject *
editing_tools_photo_canvas_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	EditingToolsPhotoCanvas * self;
	cairo_t* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkRectangle _tmp2_;
	cairo_surface_t* _tmp3_;
	parent_class = G_OBJECT_CLASS (editing_tools_photo_canvas_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_TYPE_PHOTO_CANVAS, EditingToolsPhotoCanvas);
	_tmp0_ = self->priv->_default_ctx;
	_tmp1_ = self->priv->_scaled_pixbuf;
	_tmp2_ = self->priv->_scaled_position;
	_tmp3_ = editing_tools_photo_canvas_pixbuf_to_surface (self, _tmp0_, _tmp1_, &_tmp2_);
	_cairo_surface_destroy0 (self->priv->scaled);
	self->priv->scaled = _tmp3_;
	return obj;
}

static void
editing_tools_photo_canvas_class_init (EditingToolsPhotoCanvasClass * klass,
                                       gpointer klass_data)
{
	editing_tools_photo_canvas_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EditingToolsPhotoCanvas_private_offset);
	((EditingToolsPhotoCanvasClass *) klass)->repaint = (void (*) (EditingToolsPhotoCanvas*)) editing_tools_photo_canvas_real_repaint;
	((EditingToolsPhotoCanvasClass *) klass)->get_style_context = (GtkStyleContext* (*) (EditingToolsPhotoCanvas*)) editing_tools_photo_canvas_real_get_style_context;
	G_OBJECT_CLASS (klass)->get_property = _vala_editing_tools_photo_canvas_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_editing_tools_photo_canvas_set_property;
	G_OBJECT_CLASS (klass)->constructor = editing_tools_photo_canvas_constructor;
	G_OBJECT_CLASS (klass)->finalize = editing_tools_photo_canvas_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_PHOTO_CANVAS_DEFAULT_CTX_PROPERTY, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_DEFAULT_CTX_PROPERTY] = g_param_spec_boxed ("default-ctx", "default-ctx", "default-ctx", cairo_gobject_context_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_PHOTO_CANVAS_SURFACE_DIM_PROPERTY, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_SURFACE_DIM_PROPERTY] = g_param_spec_boxed ("surface-dim", "surface-dim", "surface-dim", TYPE_DIMENSIONS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_PHOTO_CANVAS_SCALED_PIXBUF_PROPERTY, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_SCALED_PIXBUF_PROPERTY] = g_param_spec_object ("scaled-pixbuf", "scaled-pixbuf", "scaled-pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_PHOTO_CANVAS_SCALED_POSITION_PROPERTY, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_SCALED_POSITION_PROPERTY] = g_param_spec_boxed ("scaled-position", "scaled-position", "scaled-position", gdk_rectangle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_PHOTO_CANVAS_DRAWING_WINDOW_PROPERTY, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_DRAWING_WINDOW_PROPERTY] = g_param_spec_object ("drawing-window", "drawing-window", "drawing-window", gdk_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_PHOTO_CANVAS_CONTAINER_PROPERTY, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_CONTAINER_PROPERTY] = g_param_spec_object ("container", "container", "container", gtk_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITING_TOOLS_PHOTO_CANVAS_PHOTO_PROPERTY, editing_tools_photo_canvas_properties[EDITING_TOOLS_PHOTO_CANVAS_PHOTO_PROPERTY] = g_param_spec_object ("photo", "photo", "photo", TYPE_PHOTO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	editing_tools_photo_canvas_signals[EDITING_TOOLS_PHOTO_CANVAS_NEW_SURFACE_SIGNAL] = g_signal_new ("new-surface", EDITING_TOOLS_TYPE_PHOTO_CANVAS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_BOXED, G_TYPE_NONE, 2, cairo_gobject_context_get_type (), TYPE_DIMENSIONS);
	editing_tools_photo_canvas_signals[EDITING_TOOLS_PHOTO_CANVAS_RESIZED_SCALED_PIXBUF_SIGNAL] = g_signal_new ("resized-scaled-pixbuf", EDITING_TOOLS_TYPE_PHOTO_CANVAS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_OBJECT_BOXED, G_TYPE_NONE, 3, TYPE_DIMENSIONS, gdk_pixbuf_get_type (), gdk_rectangle_get_type ());
}

static void
editing_tools_photo_canvas_instance_init (EditingToolsPhotoCanvas * self,
                                          gpointer klass)
{
	self->priv = editing_tools_photo_canvas_get_instance_private (self);
}

static void
editing_tools_photo_canvas_finalize (GObject * obj)
{
	EditingToolsPhotoCanvas * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_TYPE_PHOTO_CANVAS, EditingToolsPhotoCanvas);
	_cairo_destroy0 (self->priv->_default_ctx);
	_g_object_unref0 (self->priv->_scaled_pixbuf);
	_g_object_unref0 (self->priv->_drawing_window);
	_g_object_unref0 (self->priv->_container);
	_g_object_unref0 (self->priv->_photo);
	_cairo_surface_destroy0 (self->priv->scaled);
	G_OBJECT_CLASS (editing_tools_photo_canvas_parent_class)->finalize (obj);
}

static GType
editing_tools_photo_canvas_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditingToolsPhotoCanvasClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) editing_tools_photo_canvas_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditingToolsPhotoCanvas), 0, (GInstanceInitFunc) editing_tools_photo_canvas_instance_init, NULL };
	GType editing_tools_photo_canvas_type_id;
	editing_tools_photo_canvas_type_id = g_type_register_static (G_TYPE_OBJECT, "EditingToolsPhotoCanvas", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	EditingToolsPhotoCanvas_private_offset = g_type_add_instance_private (editing_tools_photo_canvas_type_id, sizeof (EditingToolsPhotoCanvasPrivate));
	return editing_tools_photo_canvas_type_id;
}

GType
editing_tools_photo_canvas_get_type (void)
{
	static volatile gsize editing_tools_photo_canvas_type_id__once = 0;
	if (g_once_init_enter (&editing_tools_photo_canvas_type_id__once)) {
		GType editing_tools_photo_canvas_type_id;
		editing_tools_photo_canvas_type_id = editing_tools_photo_canvas_get_type_once ();
		g_once_init_leave (&editing_tools_photo_canvas_type_id__once, editing_tools_photo_canvas_type_id);
	}
	return editing_tools_photo_canvas_type_id__once;
}

static void
_vala_editing_tools_photo_canvas_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	EditingToolsPhotoCanvas * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, EDITING_TOOLS_TYPE_PHOTO_CANVAS, EditingToolsPhotoCanvas);
	switch (property_id) {
		case EDITING_TOOLS_PHOTO_CANVAS_DEFAULT_CTX_PROPERTY:
		g_value_set_boxed (value, editing_tools_photo_canvas_get_default_ctx (self));
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_SURFACE_DIM_PROPERTY:
		{
			Dimensions boxed;
			editing_tools_photo_canvas_get_surface_dim (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_SCALED_PIXBUF_PROPERTY:
		g_value_set_object (value, editing_tools_photo_canvas_get_scaled_pixbuf (self));
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_SCALED_POSITION_PROPERTY:
		{
			GdkRectangle boxed;
			editing_tools_photo_canvas_get_scaled_position (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_DRAWING_WINDOW_PROPERTY:
		g_value_set_object (value, editing_tools_photo_canvas_get_drawing_window (self));
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_CONTAINER_PROPERTY:
		g_value_set_object (value, editing_tools_photo_canvas_get_container (self));
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_PHOTO_PROPERTY:
		g_value_set_object (value, editing_tools_photo_canvas_get_photo (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_editing_tools_photo_canvas_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	EditingToolsPhotoCanvas * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, EDITING_TOOLS_TYPE_PHOTO_CANVAS, EditingToolsPhotoCanvas);
	switch (property_id) {
		case EDITING_TOOLS_PHOTO_CANVAS_DEFAULT_CTX_PROPERTY:
		editing_tools_photo_canvas_set_default_ctx (self, g_value_get_boxed (value));
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_SURFACE_DIM_PROPERTY:
		editing_tools_photo_canvas_set_surface_dim (self, g_value_get_boxed (value));
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_SCALED_PIXBUF_PROPERTY:
		editing_tools_photo_canvas_set_scaled_pixbuf (self, g_value_get_object (value));
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_SCALED_POSITION_PROPERTY:
		editing_tools_photo_canvas_set_scaled_position (self, g_value_get_boxed (value));
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_DRAWING_WINDOW_PROPERTY:
		editing_tools_photo_canvas_set_drawing_window (self, g_value_get_object (value));
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_CONTAINER_PROPERTY:
		editing_tools_photo_canvas_set_container (self, g_value_get_object (value));
		break;
		case EDITING_TOOLS_PHOTO_CANVAS_PHOTO_PROPERTY:
		editing_tools_photo_canvas_set_photo (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

