/* OverlayBar.c generated by valac 0.56.18, the Vala compiler
 * generated from OverlayBar.vala, do not modify */

#include <granite.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "pantheon-files-core.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define FILES_VIEW_OVERLAY_BAR_IMAGE_LOADER_BUFFER_SIZE 8192
#define FILES_VIEW_OVERLAY_BAR_STATUS_UPDATE_DELAY 200
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_VIEW_TYPE_OVERLAY_BAR (files_view_overlay_bar_get_type ())
#define FILES_VIEW_OVERLAY_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_OVERLAY_BAR, FilesViewOverlayBar))
#define FILES_VIEW_OVERLAY_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_OVERLAY_BAR, FilesViewOverlayBarClass))
#define FILES_VIEW_IS_OVERLAY_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_OVERLAY_BAR))
#define FILES_VIEW_IS_OVERLAY_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_OVERLAY_BAR))
#define FILES_VIEW_OVERLAY_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_OVERLAY_BAR, FilesViewOverlayBarClass))

typedef struct _FilesViewOverlayBar FilesViewOverlayBar;
typedef struct _FilesViewOverlayBarClass FilesViewOverlayBarClass;
typedef struct _FilesViewOverlayBarPrivate FilesViewOverlayBarPrivate;

#define FILES_TYPE_DEEP_COUNT (files_deep_count_get_type ())
#define FILES_DEEP_COUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_DEEP_COUNT, FilesDeepCount))
#define FILES_DEEP_COUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_DEEP_COUNT, FilesDeepCountClass))
#define FILES_IS_DEEP_COUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_DEEP_COUNT))
#define FILES_IS_DEEP_COUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_DEEP_COUNT))
#define FILES_DEEP_COUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_DEEP_COUNT, FilesDeepCountClass))

typedef struct _FilesDeepCount FilesDeepCount;
typedef struct _FilesDeepCountClass FilesDeepCountClass;
enum  {
	FILES_VIEW_OVERLAY_BAR_0_PROPERTY,
	FILES_VIEW_OVERLAY_BAR_NUM_PROPERTIES
};
static GParamSpec* files_view_overlay_bar_properties[FILES_VIEW_OVERLAY_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block58Data Block58Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FilesDeepCountPrivate FilesDeepCountPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FilesViewOverlayBarLoadResolutionData FilesViewOverlayBarLoadResolutionData;
typedef struct _FilesViewOverlayBarReadImageStreamData FilesViewOverlayBarReadImageStreamData;

struct _FilesViewOverlayBar {
	GraniteWidgetsOverlayBar parent_instance;
	FilesViewOverlayBarPrivate * priv;
};

struct _FilesViewOverlayBarClass {
	GraniteWidgetsOverlayBarClass parent_class;
};

struct _FilesViewOverlayBarPrivate {
	GCancellable* cancellable;
	gboolean image_size_loaded;
	guint folders_count;
	guint files_count;
	guint64 files_size;
	FilesFile* goffile;
	GList* selected_files;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	GFileInputStream* stream;
	GdkPixbufLoader* loader;
	guint update_timeout_id;
	FilesDeepCount* deep_counter;
	guint deep_count_timeout_id;
};

struct _Block58Data {
	int _ref_count_;
	FilesViewOverlayBar* self;
	GList* files;
};

struct _FilesDeepCount {
	GObject parent_instance;
	FilesDeepCountPrivate * priv;
	gint file_not_read;
	guint64 total_size;
	guint files_count;
	guint dirs_count;
	guint directories_count;
};

struct _FilesDeepCountClass {
	GObjectClass parent_class;
};

struct _FilesViewOverlayBarLoadResolutionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesViewOverlayBar* self;
	FilesFile* goffile;
	GFile* file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GFile* _tmp4_;
	GCancellable* _tmp5_;
	GFileInputStream* _tmp6_;
	GFileInputStream* _tmp7_;
	GFileInputStream* _tmp8_;
	GdkPixbufLoader* _tmp9_;
	const gchar* _tmp10_;
	GdkPixbufLoader* _tmp11_;
	GdkPixbufLoader* _tmp12_;
	GdkPixbufLoader* _tmp13_;
	GCancellable* _tmp14_;
	GdkPixbufLoader* _tmp15_;
	GFileInputStream* _tmp16_;
	GCancellable* _tmp17_;
	GError* e;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GFileInputStream* _tmp20_;
	GError* _vala1_e;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GdkPixbufLoader* _tmp23_;
	GError* _vala2_e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GError* _inner_error0_;
};

struct _FilesViewOverlayBarReadImageStreamData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesViewOverlayBar* self;
	GdkPixbufLoader* loader;
	GFileInputStream* stream;
	GCancellable* cancellable;
	gssize read;
	guint count;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gssize _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint _tmp4_;
	FilesFile* _tmp5_;
	FilesFile* _tmp6_;
	FilesFile* _tmp7_;
	const gchar* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	GError* e;
	GError* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _vala1_e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _vala2_e;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

static gint FilesViewOverlayBar_private_offset;
static gpointer files_view_overlay_bar_parent_class = NULL;

VALA_EXTERN GType files_view_overlay_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewOverlayBar, g_object_unref)
VALA_EXTERN GType files_deep_count_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesDeepCount, g_object_unref)
VALA_EXTERN void files_view_overlay_bar_cancel (FilesViewOverlayBar* self);
VALA_EXTERN FilesViewOverlayBar* files_view_overlay_bar_new (GtkOverlay* overlay);
VALA_EXTERN FilesViewOverlayBar* files_view_overlay_bar_construct (GType object_type,
                                                       GtkOverlay* overlay);
VALA_EXTERN void files_view_overlay_bar_selection_changed (FilesViewOverlayBar* self,
                                               GList* files);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
static gboolean __lambda38_ (Block58Data* _data58_);
static void files_view_overlay_bar_real_update (FilesViewOverlayBar* self,
                                         GList* files);
static gboolean ___lambda38__gsource_func (gpointer self);
VALA_EXTERN void files_view_overlay_bar_reset_selection (FilesViewOverlayBar* self);
static void files_view_overlay_bar_deep_count_cancel (FilesViewOverlayBar* self);
static void files_view_overlay_bar_cancel_cancellable (FilesViewOverlayBar* self);
static void files_view_overlay_bar_scan_list (FilesViewOverlayBar* self,
                                       GList* files);
static gchar* files_view_overlay_bar_update_status (FilesViewOverlayBar* self);
VALA_EXTERN guint64 files_view_properties_window_file_real_size (FilesFile* gof);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static void files_view_overlay_bar_load_resolution (FilesViewOverlayBar* self,
                                             FilesFile* goffile,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void files_view_overlay_bar_load_resolution_finish (FilesViewOverlayBar* self,
                                                    GAsyncResult* _res_);
static void files_view_overlay_bar_schedule_deep_count (FilesViewOverlayBar* self);
static gboolean __lambda146_ (FilesViewOverlayBar* self);
VALA_EXTERN FilesDeepCount* files_deep_count_new (GFile* _file);
VALA_EXTERN FilesDeepCount* files_deep_count_construct (GType object_type,
                                            GFile* _file);
static void files_view_overlay_bar_update_status_after_deep_count (FilesViewOverlayBar* self);
static void _files_view_overlay_bar_update_status_after_deep_count_files_deep_count_finished (FilesDeepCount* _sender,
                                                                                       gpointer self);
static void __lambda147_ (FilesViewOverlayBar* self);
VALA_EXTERN void files_deep_count_cancel (FilesDeepCount* self);
static void ___lambda147__g_cancellable_cancelled (GCancellable* _sender,
                                            gpointer self);
static gboolean ___lambda146__gsource_func (gpointer self);
static void files_view_overlay_bar_load_resolution_data_free (gpointer _data);
static gboolean files_view_overlay_bar_load_resolution_co (FilesViewOverlayBarLoadResolutionData* _data_);
static void files_view_overlay_bar_on_size_prepared (FilesViewOverlayBar* self,
                                              gint width,
                                              gint height);
static void files_view_overlay_bar_load_resolution_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void _files_view_overlay_bar_on_size_prepared_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender,
                                                                               gint width,
                                                                               gint height,
                                                                               gpointer self);
static void files_view_overlay_bar_read_image_stream (FilesViewOverlayBar* self,
                                               GdkPixbufLoader* loader,
                                               GFileInputStream* stream,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void files_view_overlay_bar_read_image_stream_finish (FilesViewOverlayBar* self,
                                                      GAsyncResult* _res_);
static void files_view_overlay_bar_read_image_stream_data_free (gpointer _data);
static gboolean files_view_overlay_bar_read_image_stream_co (FilesViewOverlayBarReadImageStreamData* _data_);
static void files_view_overlay_bar_read_image_stream_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static GObject * files_view_overlay_bar_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _files_view_overlay_bar_cancel_gtk_widget_hide (GtkWidget* _sender,
                                                     gpointer self);
static void files_view_overlay_bar_finalize (GObject * obj);
static GType files_view_overlay_bar_get_type_once (void);

static inline gpointer
files_view_overlay_bar_get_instance_private (FilesViewOverlayBar* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewOverlayBar_private_offset);
}

FilesViewOverlayBar*
files_view_overlay_bar_construct (GType object_type,
                                  GtkOverlay* overlay)
{
	FilesViewOverlayBar * self = NULL;
	g_return_val_if_fail (overlay != NULL, NULL);
	self = (FilesViewOverlayBar*) granite_widgets_overlay_bar_construct (object_type, overlay);
	return self;
}

FilesViewOverlayBar*
files_view_overlay_bar_new (GtkOverlay* overlay)
{
	return files_view_overlay_bar_construct (FILES_VIEW_TYPE_OVERLAY_BAR, overlay);
}

static Block58Data*
block58_data_ref (Block58Data* _data58_)
{
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}

static void
block58_data_unref (void * _userdata_)
{
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		FilesViewOverlayBar* self;
		self = _data58_->self;
		_g_object_unref0 (self);
		g_slice_free (Block58Data, _data58_);
	}
}

static gboolean
__lambda38_ (Block58Data* _data58_)
{
	FilesViewOverlayBar* self;
	GList* _tmp1_;
	gboolean result;
	self = _data58_->self;
	if (_data58_->files != NULL) {
		GList* _tmp0_;
		_tmp0_ = g_list_copy (_data58_->files);
		(self->priv->selected_files == NULL) ? NULL : (self->priv->selected_files = (g_list_free (self->priv->selected_files), NULL));
		self->priv->selected_files = _tmp0_;
	} else {
		(self->priv->selected_files == NULL) ? NULL : (self->priv->selected_files = (g_list_free (self->priv->selected_files), NULL));
		self->priv->selected_files = NULL;
	}
	_tmp1_ = self->priv->selected_files;
	files_view_overlay_bar_real_update (self, _tmp1_);
	self->priv->update_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda38_ (self);
	return result;
}

void
files_view_overlay_bar_selection_changed (FilesViewOverlayBar* self,
                                          GList* files)
{
	Block58Data* _data58_;
	g_return_if_fail (self != NULL);
	_data58_ = g_slice_new0 (Block58Data);
	_data58_->_ref_count_ = 1;
	_data58_->self = g_object_ref (self);
	_data58_->files = files;
	files_view_overlay_bar_cancel (self);
	gtk_widget_set_visible ((GtkWidget*) self, FALSE);
	self->priv->update_timeout_id = g_timeout_add_full (G_PRIORITY_LOW, (guint) FILES_VIEW_OVERLAY_BAR_STATUS_UPDATE_DELAY, ___lambda38__gsource_func, block58_data_ref (_data58_), block58_data_unref);
	block58_data_unref (_data58_);
	_data58_ = NULL;
}

void
files_view_overlay_bar_reset_selection (FilesViewOverlayBar* self)
{
	g_return_if_fail (self != NULL);
	(self->priv->selected_files == NULL) ? NULL : (self->priv->selected_files = (g_list_free (self->priv->selected_files), NULL));
	self->priv->selected_files = NULL;
}

/**
         * Function to be called when view is going to be destroyed or going to show another folder
         * and on a selection change.
         */
void
files_view_overlay_bar_cancel (FilesViewOverlayBar* self)
{
	g_return_if_fail (self != NULL);
	files_view_overlay_bar_deep_count_cancel (self);
	if (self->priv->update_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->update_timeout_id);
		self->priv->update_timeout_id = (guint) 0;
	}
	files_view_overlay_bar_cancel_cancellable (self);
	granite_widgets_overlay_bar_set_active ((GraniteWidgetsOverlayBar*) self, FALSE);
}

static void
files_view_overlay_bar_deep_count_cancel (FilesViewOverlayBar* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->deep_count_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->deep_count_timeout_id);
		self->priv->deep_count_timeout_id = (guint) 0;
	}
}

static void
files_view_overlay_bar_cancel_cancellable (FilesViewOverlayBar* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
		_g_object_unref0 (self->priv->cancellable);
		self->priv->cancellable = NULL;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
files_view_overlay_bar_real_update (FilesViewOverlayBar* self,
                                    GList* files)
{
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->goffile);
	self->priv->goffile = NULL;
	self->priv->folders_count = (guint) 0;
	self->priv->files_count = (guint) 0;
	self->priv->files_size = (guint64) 0;
	granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, "");
	if (files != NULL) {
		gboolean _tmp0_ = FALSE;
		if (files != NULL) {
			gconstpointer _tmp1_;
			_tmp1_ = files->data;
			_tmp0_ = ((FilesFile*) _tmp1_) != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			GList* _tmp2_;
			gchar* s = NULL;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp2_ = files->next;
			if (_tmp2_ == NULL) {
				GList* _tmp3_;
				gconstpointer _tmp4_;
				FilesFile* _tmp5_;
				_tmp3_ = g_list_first (files);
				_tmp4_ = _tmp3_->data;
				_tmp5_ = _g_object_ref0 ((FilesFile*) _tmp4_);
				_g_object_unref0 (self->priv->goffile);
				self->priv->goffile = _tmp5_;
			} else {
				files_view_overlay_bar_scan_list (self, files);
			}
			_tmp6_ = files_view_overlay_bar_update_status (self);
			s = _tmp6_;
			_tmp7_ = granite_widgets_overlay_bar_get_label ((GraniteWidgetsOverlayBar*) self);
			_tmp8_ = _tmp7_;
			if (g_strcmp0 (_tmp8_, "") == 0) {
				const gchar* _tmp9_;
				_tmp9_ = s;
				granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp9_);
			}
			_g_free0 (s);
		}
	}
	_tmp10_ = granite_widgets_overlay_bar_get_label ((GraniteWidgetsOverlayBar*) self);
	_tmp11_ = _tmp10_;
	gtk_widget_set_visible ((GtkWidget*) self, g_strcmp0 (_tmp11_, "") != 0);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gchar*
files_view_overlay_bar_update_status (FilesViewOverlayBar* self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	FilesFile* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	str = _tmp0_;
	granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, "");
	_tmp1_ = self->priv->goffile;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		FilesFile* _tmp3_;
		_tmp3_ = self->priv->goffile;
		if (files_file_is_network_uri_scheme (_tmp3_)) {
			_tmp2_ = TRUE;
		} else {
			FilesFile* _tmp4_;
			_tmp4_ = self->priv->goffile;
			_tmp2_ = files_file_is_root_network_folder (_tmp4_);
		}
		if (_tmp2_) {
			FilesFile* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = self->priv->goffile;
			_tmp6_ = files_file_get_display_target_uri (_tmp5_);
			_g_free0 (str);
			str = _tmp6_;
		} else {
			FilesFile* _tmp7_;
			_tmp7_ = self->priv->goffile;
			if (!files_file_is_folder (_tmp7_)) {
				gchar* type = NULL;
				FilesFile* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				FilesFile* _tmp11_;
				const gchar* _tmp12_;
				FilesFile* _tmp16_;
				GFileInfo* _tmp17_;
				const gchar* _tmp18_;
				FilesFile* _tmp19_;
				const gchar* _tmp20_;
				FilesFile* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				const gchar* _tmp26_;
				_tmp8_ = self->priv->goffile;
				_tmp9_ = files_file_get_ftype (_tmp8_);
				_tmp10_ = g_strdup (_tmp9_);
				type = _tmp10_;
				_tmp11_ = self->priv->goffile;
				_tmp12_ = _tmp11_->format_size;
				if (g_strcmp0 (_tmp12_, "") == 0) {
					FilesFile* _tmp13_;
					FilesFile* _tmp14_;
					gchar* _tmp15_;
					_tmp13_ = self->priv->goffile;
					_tmp14_ = self->priv->goffile;
					_tmp15_ = g_format_size_full (files_view_properties_window_file_real_size (_tmp14_), G_FORMAT_SIZE_DEFAULT);
					_g_free0 (_tmp13_->format_size);
					_tmp13_->format_size = _tmp15_;
				}
				_tmp16_ = self->priv->goffile;
				_tmp17_ = _tmp16_->info;
				_tmp18_ = g_file_info_get_name (_tmp17_);
				_tmp19_ = self->priv->goffile;
				_tmp20_ = _tmp19_->formated_type;
				_tmp21_ = self->priv->goffile;
				_tmp22_ = _tmp21_->format_size;
				_tmp23_ = g_strdup_printf ("%s - %s (%s)", _tmp18_, _tmp20_, _tmp22_);
				_g_free0 (str);
				str = _tmp23_;
				_tmp26_ = type;
				if (_tmp26_ != NULL) {
					const gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp27_ = type;
					_tmp28_ = string_substring (_tmp27_, (glong) 0, (glong) 6);
					_tmp29_ = _tmp28_;
					_tmp25_ = g_strcmp0 (_tmp29_, "image/") == 0;
					_g_free0 (_tmp29_);
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					gboolean _tmp30_ = FALSE;
					FilesFile* _tmp31_;
					_tmp31_ = self->priv->goffile;
					if (_tmp31_->width > 0) {
						_tmp30_ = TRUE;
					} else {
						gboolean _tmp32_ = FALSE;
						const gchar* _tmp33_;
						_tmp33_ = type;
						if (_vala_string_array_contains (FILES_SKIP_IMAGES, G_N_ELEMENTS (FILES_SKIP_IMAGES), _tmp33_)) {
							_tmp32_ = TRUE;
						} else {
							FilesFile* _tmp34_;
							_tmp34_ = self->priv->goffile;
							_tmp32_ = _tmp34_->width < 0;
						}
						_tmp30_ = !_tmp32_;
					}
					_tmp24_ = _tmp30_;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					FilesFile* _tmp35_;
					_tmp35_ = self->priv->goffile;
					files_view_overlay_bar_load_resolution (self, _tmp35_, NULL, NULL);
				}
				_g_free0 (type);
			} else {
				FilesFile* _tmp36_;
				GFileInfo* _tmp37_;
				const gchar* _tmp38_;
				FilesFile* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp36_ = self->priv->goffile;
				_tmp37_ = _tmp36_->info;
				_tmp38_ = g_file_info_get_name (_tmp37_);
				_tmp39_ = self->priv->goffile;
				_tmp40_ = _tmp39_->formated_type;
				_tmp41_ = g_strdup_printf ("%s - %s", _tmp38_, _tmp40_);
				_g_free0 (str);
				str = _tmp41_;
				files_view_overlay_bar_schedule_deep_count (self);
			}
		}
	} else {
		gchar* fsize = NULL;
		gchar* _tmp42_;
		_tmp42_ = g_format_size_full (self->priv->files_size, G_FORMAT_SIZE_DEFAULT);
		fsize = _tmp42_;
		if (self->priv->folders_count > ((guint) 1)) {
			gchar* _tmp43_;
			_tmp43_ = g_strdup_printf (_ ("%u folders"), self->priv->folders_count);
			_g_free0 (str);
			str = _tmp43_;
			if (self->priv->files_count > ((guint) 0)) {
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp44_ = str;
				_tmp45_ = fsize;
				_tmp46_ = g_strdup_printf (ngettext (" and %u other item (%s) selected", " and %u other items (%s) selected", (gulong) self->priv->files_count), self->priv->files_count, _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = g_strconcat (_tmp44_, _tmp47_, NULL);
				_g_free0 (str);
				str = _tmp48_;
				_g_free0 (_tmp47_);
			} else {
				const gchar* _tmp49_;
				gchar* _tmp50_;
				_tmp49_ = str;
				_tmp50_ = g_strconcat (_tmp49_, _ (" selected"), NULL);
				_g_free0 (str);
				str = _tmp50_;
			}
		} else {
			if (self->priv->folders_count == ((guint) 1)) {
				gchar* _tmp51_;
				_tmp51_ = g_strdup_printf (_ ("%u folder"), self->priv->folders_count);
				_g_free0 (str);
				str = _tmp51_;
				if (self->priv->files_count > ((guint) 0)) {
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					_tmp52_ = str;
					_tmp53_ = fsize;
					_tmp54_ = g_strdup_printf (ngettext (" and %u other item (%s) selected", " and %u other items (%s) selected", (gulong) self->priv->files_count), self->priv->files_count, _tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = g_strconcat (_tmp52_, _tmp55_, NULL);
					_g_free0 (str);
					str = _tmp56_;
					_g_free0 (_tmp55_);
				} else {
					const gchar* _tmp57_;
					gchar* _tmp58_;
					_tmp57_ = str;
					_tmp58_ = g_strconcat (_tmp57_, _ (" selected"), NULL);
					_g_free0 (str);
					str = _tmp58_;
				}
			} else {
				const gchar* _tmp59_;
				gchar* _tmp60_;
				_tmp59_ = fsize;
				_tmp60_ = g_strdup_printf (_ ("%u items selected (%s)"), self->priv->files_count, _tmp59_);
				_g_free0 (str);
				str = _tmp60_;
			}
		}
		_g_free0 (fsize);
	}
	result = str;
	return result;
}

static void
_files_view_overlay_bar_update_status_after_deep_count_files_deep_count_finished (FilesDeepCount* _sender,
                                                                                  gpointer self)
{
	files_view_overlay_bar_update_status_after_deep_count ((FilesViewOverlayBar*) self);
}

static void
__lambda147_ (FilesViewOverlayBar* self)
{
	FilesDeepCount* _tmp0_;
	_tmp0_ = self->priv->deep_counter;
	if (_tmp0_ != NULL) {
		FilesDeepCount* _tmp1_;
		guint _tmp2_;
		FilesDeepCount* _tmp3_;
		_tmp1_ = self->priv->deep_counter;
		g_signal_parse_name ("finished", FILES_TYPE_DEEP_COUNT, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _files_view_overlay_bar_update_status_after_deep_count_files_deep_count_finished, self);
		_tmp3_ = self->priv->deep_counter;
		files_deep_count_cancel (_tmp3_);
		_g_object_unref0 (self->priv->deep_counter);
		self->priv->deep_counter = NULL;
		_g_object_unref0 (self->priv->cancellable);
		self->priv->cancellable = NULL;
	}
	granite_widgets_overlay_bar_set_active ((GraniteWidgetsOverlayBar*) self, FALSE);
}

static void
___lambda147__g_cancellable_cancelled (GCancellable* _sender,
                                       gpointer self)
{
	__lambda147_ ((FilesViewOverlayBar*) self);
}

static gboolean
__lambda146_ (FilesViewOverlayBar* self)
{
	FilesFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	FilesDeepCount* _tmp3_;
	FilesDeepCount* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	gboolean result;
	_tmp0_ = self->priv->goffile;
	_tmp1_ = files_file_get_location (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = files_deep_count_new (_tmp2_);
	_g_object_unref0 (self->priv->deep_counter);
	self->priv->deep_counter = _tmp3_;
	_tmp4_ = self->priv->deep_counter;
	g_signal_connect_object (_tmp4_, "finished", (GCallback) _files_view_overlay_bar_update_status_after_deep_count_files_deep_count_finished, self, 0);
	files_view_overlay_bar_cancel_cancellable (self);
	_tmp5_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp5_;
	_tmp6_ = self->priv->cancellable;
	g_signal_connect_object (_tmp6_, "cancelled", (GCallback) ___lambda147__g_cancellable_cancelled, self, 0);
	self->priv->deep_count_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda146__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda146_ ((FilesViewOverlayBar*) self);
	return result;
}

static void
files_view_overlay_bar_schedule_deep_count (FilesViewOverlayBar* self)
{
	g_return_if_fail (self != NULL);
	files_view_overlay_bar_cancel (self);
	granite_widgets_overlay_bar_set_active ((GraniteWidgetsOverlayBar*) self, TRUE);
	files_view_overlay_bar_deep_count_cancel (self);
	self->priv->deep_count_timeout_id = g_timeout_add_full (G_PRIORITY_LOW, (guint) 1000, ___lambda146__gsource_func, g_object_ref (self), g_object_unref);
}

static void
files_view_overlay_bar_update_status_after_deep_count (FilesViewOverlayBar* self)
{
	gchar* str = NULL;
	FilesFile* _tmp0_;
	GFileInfo* _tmp1_;
	const gchar* _tmp2_;
	FilesFile* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FilesDeepCount* _tmp7_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = NULL;
	granite_widgets_overlay_bar_set_active ((GraniteWidgetsOverlayBar*) self, FALSE);
	_tmp0_ = self->priv->goffile;
	_tmp1_ = _tmp0_->info;
	_tmp2_ = g_file_info_get_name (_tmp1_);
	_tmp3_ = self->priv->goffile;
	_tmp4_ = _tmp3_->formated_type;
	_tmp5_ = g_strdup_printf ("%s - %s (", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->deep_counter;
	if (_tmp7_ != NULL) {
		FilesDeepCount* _tmp8_;
		gboolean _tmp19_ = FALSE;
		FilesDeepCount* _tmp20_;
		FilesDeepCount* _tmp32_;
		_tmp8_ = self->priv->deep_counter;
		if (_tmp8_->dirs_count > ((guint) 0)) {
			FilesDeepCount* _tmp9_;
			gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			FilesDeepCount* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp9_ = self->priv->deep_counter;
			_tmp10_ = g_strdup (ngettext ("%u sub-folder, ", "%u sub-folders, ", (gulong) _tmp9_->dirs_count));
			_g_free0 (str);
			str = _tmp10_;
			_tmp11_ = granite_widgets_overlay_bar_get_label ((GraniteWidgetsOverlayBar*) self);
			_tmp12_ = _tmp11_;
			_tmp13_ = str;
			_tmp14_ = self->priv->deep_counter;
			_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_->dirs_count);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp18_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp16_);
		}
		_tmp20_ = self->priv->deep_counter;
		if (_tmp20_->files_count > ((guint) 0)) {
			_tmp19_ = TRUE;
		} else {
			FilesDeepCount* _tmp21_;
			_tmp21_ = self->priv->deep_counter;
			_tmp19_ = _tmp21_->file_not_read == 0;
		}
		if (_tmp19_) {
			FilesDeepCount* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			FilesDeepCount* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp22_ = self->priv->deep_counter;
			_tmp23_ = g_strdup (ngettext ("%u file, ", "%u files, ", (gulong) _tmp22_->files_count));
			_g_free0 (str);
			str = _tmp23_;
			_tmp24_ = granite_widgets_overlay_bar_get_label ((GraniteWidgetsOverlayBar*) self);
			_tmp25_ = _tmp24_;
			_tmp26_ = str;
			_tmp27_ = self->priv->deep_counter;
			_tmp28_ = g_strdup_printf (_tmp26_, _tmp27_->files_count);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strconcat (_tmp25_, _tmp29_, NULL);
			_tmp31_ = _tmp30_;
			granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp31_);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
		}
		_tmp32_ = self->priv->deep_counter;
		if (_tmp32_->file_not_read == 0) {
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			FilesDeepCount* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp33_ = granite_widgets_overlay_bar_get_label ((GraniteWidgetsOverlayBar*) self);
			_tmp34_ = _tmp33_;
			_tmp35_ = self->priv->deep_counter;
			_tmp36_ = g_format_size_full (_tmp35_->total_size, G_FORMAT_SIZE_DEFAULT);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp39_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_tmp40_ = granite_widgets_overlay_bar_get_label ((GraniteWidgetsOverlayBar*) self);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp41_, ")", NULL);
			_tmp43_ = _tmp42_;
			granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp43_);
			_g_free0 (_tmp43_);
		} else {
			FilesDeepCount* _tmp44_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			FilesDeepCount* _tmp62_;
			gchar* _tmp63_;
			const gchar* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			FilesDeepCount* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			_tmp44_ = self->priv->deep_counter;
			if (_tmp44_->total_size > ((guint64) 0)) {
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				FilesDeepCount* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				_tmp45_ = granite_widgets_overlay_bar_get_label ((GraniteWidgetsOverlayBar*) self);
				_tmp46_ = _tmp45_;
				_tmp47_ = self->priv->deep_counter;
				_tmp48_ = g_format_size_full (_tmp47_->total_size, G_FORMAT_SIZE_DEFAULT);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strdup_printf (_ ("%s approx."), _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strconcat (_tmp46_, _tmp51_, NULL);
				_tmp53_ = _tmp52_;
				granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp53_);
				_g_free0 (_tmp53_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
			} else {
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				_tmp54_ = granite_widgets_overlay_bar_get_label ((GraniteWidgetsOverlayBar*) self);
				_tmp55_ = _tmp54_;
				_tmp56_ = g_strconcat (_tmp55_, _ ("unknown size"), NULL);
				_tmp57_ = _tmp56_;
				granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp57_);
				_g_free0 (_tmp57_);
			}
			_tmp58_ = granite_widgets_overlay_bar_get_label ((GraniteWidgetsOverlayBar*) self);
			_tmp59_ = _tmp58_;
			_tmp60_ = g_strconcat (_tmp59_, ") ", NULL);
			_tmp61_ = _tmp60_;
			granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp61_);
			_g_free0 (_tmp61_);
			_tmp62_ = self->priv->deep_counter;
			_tmp63_ = g_strdup (ngettext ("%u file not readable", "%u files not readable", (gulong) _tmp62_->file_not_read));
			_g_free0 (str);
			str = _tmp63_;
			_tmp64_ = granite_widgets_overlay_bar_get_label ((GraniteWidgetsOverlayBar*) self);
			_tmp65_ = _tmp64_;
			_tmp66_ = str;
			_tmp67_ = self->priv->deep_counter;
			_tmp68_ = g_strdup_printf (_tmp66_, _tmp67_->file_not_read);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strconcat (_tmp65_, _tmp69_, NULL);
			_tmp71_ = _tmp70_;
			granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp71_);
			_g_free0 (_tmp71_);
			_g_free0 (_tmp69_);
		}
	}
	_g_free0 (str);
}

static void
files_view_overlay_bar_scan_list (FilesViewOverlayBar* self,
                                  GList* files)
{
	g_return_if_fail (self != NULL);
	if (files == NULL) {
		return;
	}
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = files;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* gof = NULL;
			gof = (FilesFile*) gof_it->data;
			{
				gboolean _tmp0_ = FALSE;
				FilesFile* _tmp1_;
				_tmp1_ = gof;
				if (_tmp1_ != NULL) {
					FilesFile* _tmp2_;
					_tmp2_ = gof;
					_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, FILES_TYPE_FILE);
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					FilesFile* _tmp3_;
					_tmp3_ = gof;
					if (files_file_is_folder (_tmp3_)) {
						guint _tmp4_;
						_tmp4_ = self->priv->folders_count;
						self->priv->folders_count = _tmp4_ + 1;
					} else {
						guint _tmp5_;
						FilesFile* _tmp6_;
						_tmp5_ = self->priv->files_count;
						self->priv->files_count = _tmp5_ + 1;
						_tmp6_ = gof;
						self->priv->files_size = self->priv->files_size + files_view_properties_window_file_real_size (_tmp6_);
					}
				} else {
					g_warning ("OverlayBar.vala:269: Null file found in OverlayBar scan_list - this sh" \
"ould not happen");
				}
			}
		}
	}
}

static void
files_view_overlay_bar_load_resolution_data_free (gpointer _data)
{
	FilesViewOverlayBarLoadResolutionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->goffile);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesViewOverlayBarLoadResolutionData, _data_);
}

static void
files_view_overlay_bar_load_resolution (FilesViewOverlayBar* self,
                                        FilesFile* goffile,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	FilesViewOverlayBarLoadResolutionData* _data_;
	FilesViewOverlayBar* _tmp0_;
	FilesFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (goffile != NULL);
	_data_ = g_slice_new0 (FilesViewOverlayBarLoadResolutionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_view_overlay_bar_load_resolution_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (goffile);
	_g_object_unref0 (_data_->goffile);
	_data_->goffile = _tmp1_;
	files_view_overlay_bar_load_resolution_co (_data_);
}

static void
files_view_overlay_bar_load_resolution_finish (FilesViewOverlayBar* self,
                                               GAsyncResult* _res_)
{
	FilesViewOverlayBarLoadResolutionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
files_view_overlay_bar_load_resolution_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	FilesViewOverlayBarLoadResolutionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_view_overlay_bar_load_resolution_co (_data_);
}

static void
_files_view_overlay_bar_on_size_prepared_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender,
                                                                          gint width,
                                                                          gint height,
                                                                          gpointer self)
{
	files_view_overlay_bar_on_size_prepared ((FilesViewOverlayBar*) self, width, height);
}

static gboolean
files_view_overlay_bar_load_resolution_co (FilesViewOverlayBarLoadResolutionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->goffile->width > 0) {
		files_view_overlay_bar_on_size_prepared (_data_->self, _data_->goffile->width, _data_->goffile->height);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = files_file_get_location (_data_->goffile);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->file = _data_->_tmp2_;
	_data_->self->priv->image_size_loaded = FALSE;
	{
		_data_->_tmp4_ = _data_->file;
		_data_->_tmp5_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp4_, 0, _data_->_tmp5_, files_view_overlay_bar_load_resolution_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = g_file_read_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->_tmp3_;
		_data_->_tmp3_ = NULL;
		_g_object_unref0 (_data_->self->priv->stream);
		_data_->self->priv->stream = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->self->priv->stream;
		if (_data_->_tmp8_ == NULL) {
			g_error ("OverlayBar.vala:287: Could not read image file's size data");
		}
		_data_->_tmp10_ = files_file_get_ftype (_data_->goffile);
		_data_->_tmp11_ = gdk_pixbuf_loader_new_with_mime_type (_data_->_tmp10_, &_data_->_inner_error0_);
		_data_->_tmp9_ = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp3_);
			goto __catch0_g_error;
		}
		_data_->_tmp12_ = _data_->_tmp9_;
		_data_->_tmp9_ = NULL;
		_g_object_unref0 (_data_->self->priv->loader);
		_data_->self->priv->loader = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->self->priv->loader;
		g_signal_connect_object (_data_->_tmp13_, "size-prepared", (GCallback) _files_view_overlay_bar_on_size_prepared_gdk_pixbuf_loader_size_prepared, _data_->self, 0);
		files_view_overlay_bar_cancel_cancellable (_data_->self);
		_data_->_tmp14_ = g_cancellable_new ();
		_g_object_unref0 (_data_->self->priv->cancellable);
		_data_->self->priv->cancellable = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->self->priv->loader;
		_data_->_tmp16_ = _data_->self->priv->stream;
		_data_->_tmp17_ = _data_->self->priv->cancellable;
		_data_->_state_ = 2;
		files_view_overlay_bar_read_image_stream (_data_->self, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp17_, files_view_overlay_bar_load_resolution_ready, _data_);
		return FALSE;
		_state_2:
		files_view_overlay_bar_read_image_stream_finish (_data_->self, _data_->_res_);
		_g_object_unref0 (_data_->_tmp9_);
		_g_object_unref0 (_data_->_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning ("OverlayBar.vala:298: Error loading image resolution in OverlayBar: %s", _data_->_tmp19_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp20_ = _data_->self->priv->stream;
		g_input_stream_close ((GInputStream*) _data_->_tmp20_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp21_ = _data_->_vala1_e;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_debug ("OverlayBar.vala:304: Error closing stream in load resolution: %s", _data_->_tmp22_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp23_ = _data_->self->priv->loader;
		gdk_pixbuf_loader_close (_data_->_tmp23_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp24_ = _data_->_vala2_e;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_debug ("OverlayBar.vala:309: Error closing loader in load resolution: %s", _data_->_tmp25_);
		_g_error_free0 (_data_->_vala2_e);
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->cancellable);
	_data_->self->priv->cancellable = NULL;
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_view_overlay_bar_on_size_prepared (FilesViewOverlayBar* self,
                                         gint width,
                                         gint height)
{
	FilesFile* _tmp0_;
	FilesFile* _tmp1_;
	FilesFile* _tmp2_;
	FilesFile* _tmp3_;
	const gchar* _tmp4_;
	FilesFile* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->goffile;
	if (_tmp0_ == NULL) {
		return;
	}
	self->priv->image_size_loaded = TRUE;
	_tmp1_ = self->priv->goffile;
	_tmp1_->width = width;
	_tmp2_ = self->priv->goffile;
	_tmp2_->height = height;
	_tmp3_ = self->priv->goffile;
	_tmp4_ = _tmp3_->formated_type;
	_tmp5_ = self->priv->goffile;
	_tmp6_ = _tmp5_->format_size;
	_tmp7_ = g_strdup_printf ("%s (%s — %i × %i)", _tmp4_, _tmp6_, width, height);
	_tmp8_ = _tmp7_;
	granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp8_);
	_g_free0 (_tmp8_);
}

static void
files_view_overlay_bar_read_image_stream_data_free (gpointer _data)
{
	FilesViewOverlayBarReadImageStreamData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->loader);
	_g_object_unref0 (_data_->stream);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesViewOverlayBarReadImageStreamData, _data_);
}

static void
files_view_overlay_bar_read_image_stream (FilesViewOverlayBar* self,
                                          GdkPixbufLoader* loader,
                                          GFileInputStream* stream,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	FilesViewOverlayBarReadImageStreamData* _data_;
	FilesViewOverlayBar* _tmp0_;
	GdkPixbufLoader* _tmp1_;
	GFileInputStream* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (loader != NULL);
	g_return_if_fail (stream != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (FilesViewOverlayBarReadImageStreamData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_view_overlay_bar_read_image_stream_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (loader);
	_g_object_unref0 (_data_->loader);
	_data_->loader = _tmp1_;
	_tmp2_ = _g_object_ref0 (stream);
	_g_object_unref0 (_data_->stream);
	_data_->stream = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	files_view_overlay_bar_read_image_stream_co (_data_);
}

static void
files_view_overlay_bar_read_image_stream_finish (FilesViewOverlayBar* self,
                                                 GAsyncResult* _res_)
{
	FilesViewOverlayBarReadImageStreamData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
files_view_overlay_bar_read_image_stream_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	FilesViewOverlayBarReadImageStreamData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_view_overlay_bar_read_image_stream_co (_data_);
}

static gboolean
files_view_overlay_bar_read_image_stream_co (FilesViewOverlayBarReadImageStreamData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->read = (gssize) 1;
	_data_->count = (guint) 0;
	while (TRUE) {
		if (!_data_->self->priv->image_size_loaded) {
			_data_->_tmp1_ = _data_->read > ((gssize) 0);
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (_data_->_tmp1_) {
			_data_->_tmp0_ = !g_cancellable_is_cancelled (_data_->cancellable);
		} else {
			_data_->_tmp0_ = FALSE;
		}
		if (!_data_->_tmp0_) {
			break;
		}
		{
			_data_->_tmp3_ = _data_->self->priv->buffer;
			_data_->_tmp3__length1 = _data_->self->priv->buffer_length1;
			_data_->_state_ = 1;
			g_input_stream_read_async ((GInputStream*) _data_->stream, _data_->_tmp3_, (gsize) _data_->_tmp3__length1, 0, _data_->cancellable, files_view_overlay_bar_read_image_stream_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp2_ = g_input_stream_read_finish ((GInputStream*) _data_->stream, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				if (_data_->_inner_error0_->domain == GDK_PIXBUF_ERROR) {
					goto __catch0_gdk_pixbuf_error;
				}
				if (_data_->_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				goto __catch0_g_error;
			}
			_data_->read = _data_->_tmp2_;
			_data_->_tmp4_ = _data_->count;
			_data_->count = _data_->_tmp4_ + 1;
			if (_data_->count > ((guint) 100)) {
				_data_->_tmp5_ = _data_->self->priv->goffile;
				_data_->_tmp5_->width = -1;
				_data_->_tmp6_ = _data_->self->priv->goffile;
				_data_->_tmp6_->height = -1;
				_data_->_tmp7_ = _data_->self->priv->goffile;
				_data_->_tmp8_ = files_file_get_ftype (_data_->_tmp7_);
				g_critical ("OverlayBar.vala:337: Could not determine resolution of file type %s", _data_->_tmp8_);
				break;
			}
			_data_->_tmp9_ = _data_->self->priv->buffer;
			_data_->_tmp9__length1 = _data_->self->priv->buffer_length1;
			gdk_pixbuf_loader_write (_data_->loader, _data_->_tmp9_, (gsize) _data_->_tmp9__length1, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				if (_data_->_inner_error0_->domain == GDK_PIXBUF_ERROR) {
					goto __catch0_gdk_pixbuf_error;
				}
				if (_data_->_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp10_ = _data_->e;
			if (!g_error_matches (_data_->_tmp10_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				_data_->_tmp11_ = _data_->e;
				_data_->_tmp12_ = _data_->_tmp11_->message;
				g_warning ("OverlayBar.vala:345: %s", _data_->_tmp12_);
			}
			_g_error_free0 (_data_->e);
		}
		goto __finally0;
		__catch0_gdk_pixbuf_error:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp13_ = _data_->_vala1_e;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			g_warning ("OverlayBar.vala:350: %s", _data_->_tmp14_);
			_g_error_free0 (_data_->_vala1_e);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_vala2_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp15_ = _data_->_vala2_e;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			g_warning ("OverlayBar.vala:352: %s", _data_->_tmp16_);
			_g_error_free0 (_data_->_vala2_e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_files_view_overlay_bar_cancel_gtk_widget_hide (GtkWidget* _sender,
                                                gpointer self)
{
	files_view_overlay_bar_cancel ((FilesViewOverlayBar*) self);
}

static GObject *
files_view_overlay_bar_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesViewOverlayBar * self;
	guint8* _tmp0_;
	parent_class = G_OBJECT_CLASS (files_view_overlay_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_OVERLAY_BAR, FilesViewOverlayBar);
	_tmp0_ = g_new0 (guint8, FILES_VIEW_OVERLAY_BAR_IMAGE_LOADER_BUFFER_SIZE);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = _tmp0_;
	self->priv->buffer_length1 = FILES_VIEW_OVERLAY_BAR_IMAGE_LOADER_BUFFER_SIZE;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, "");
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) _files_view_overlay_bar_cancel_gtk_widget_hide, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	return obj;
}

static void
files_view_overlay_bar_class_init (FilesViewOverlayBarClass * klass,
                                   gpointer klass_data)
{
	files_view_overlay_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewOverlayBar_private_offset);
	G_OBJECT_CLASS (klass)->constructor = files_view_overlay_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_view_overlay_bar_finalize;
}

static void
files_view_overlay_bar_instance_init (FilesViewOverlayBar * self,
                                      gpointer klass)
{
	self->priv = files_view_overlay_bar_get_instance_private (self);
	self->priv->cancellable = NULL;
	self->priv->image_size_loaded = FALSE;
	self->priv->folders_count = (guint) 0;
	self->priv->files_count = (guint) 0;
	self->priv->files_size = (guint64) 0;
	self->priv->goffile = NULL;
	self->priv->selected_files = NULL;
	self->priv->update_timeout_id = (guint) 0;
	self->priv->deep_counter = NULL;
	self->priv->deep_count_timeout_id = (guint) 0;
}

static void
files_view_overlay_bar_finalize (GObject * obj)
{
	FilesViewOverlayBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_OVERLAY_BAR, FilesViewOverlayBar);
	files_view_overlay_bar_cancel (self);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->goffile);
	(self->priv->selected_files == NULL) ? NULL : (self->priv->selected_files = (g_list_free (self->priv->selected_files), NULL));
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	_g_object_unref0 (self->priv->stream);
	_g_object_unref0 (self->priv->loader);
	_g_object_unref0 (self->priv->deep_counter);
	G_OBJECT_CLASS (files_view_overlay_bar_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_overlay_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewOverlayBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_overlay_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewOverlayBar), 0, (GInstanceInitFunc) files_view_overlay_bar_instance_init, NULL };
	GType files_view_overlay_bar_type_id;
	files_view_overlay_bar_type_id = g_type_register_static (GRANITE_WIDGETS_TYPE_OVERLAY_BAR, "FilesViewOverlayBar", &g_define_type_info, 0);
	FilesViewOverlayBar_private_offset = g_type_add_instance_private (files_view_overlay_bar_type_id, sizeof (FilesViewOverlayBarPrivate));
	return files_view_overlay_bar_type_id;
}

GType
files_view_overlay_bar_get_type (void)
{
	static volatile gsize files_view_overlay_bar_type_id__once = 0;
	if (g_once_init_enter (&files_view_overlay_bar_type_id__once)) {
		GType files_view_overlay_bar_type_id;
		files_view_overlay_bar_type_id = files_view_overlay_bar_get_type_once ();
		g_once_init_leave (&files_view_overlay_bar_type_id__once, files_view_overlay_bar_type_id);
	}
	return files_view_overlay_bar_type_id__once;
}

