/* AbstractPropertiesDialog.c generated by valac 0.56.18, the Vala compiler
 * generated from AbstractPropertiesDialog.vala, do not modify */

/*
* Copyright (c) 2011 Marlin Developers (http://launchpad.net/marlin)
* Copyright (c) 2015-2018 elementary LLC <https://elementary.io>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation, Inc.,; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1335 USA.
*
* Authored by: ammonkey <am.monkeyd@gmail.com>
*/

#include <granite.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG (files_view_abstract_properties_dialog_get_type ())
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialog))
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialogClass))
#define FILES_VIEW_IS_ABSTRACT_PROPERTIES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG))
#define FILES_VIEW_IS_ABSTRACT_PROPERTIES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG))
#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialogClass))

typedef struct _FilesViewAbstractPropertiesDialog FilesViewAbstractPropertiesDialog;
typedef struct _FilesViewAbstractPropertiesDialogClass FilesViewAbstractPropertiesDialogClass;
typedef struct _FilesViewAbstractPropertiesDialogPrivate FilesViewAbstractPropertiesDialogPrivate;
enum  {
	FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_0_PROPERTY,
	FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* files_view_abstract_properties_dialog_properties[FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_NUM_PROPERTIES];
typedef enum  {
	FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_PANEL_TYPE_INFO,
	FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_PANEL_TYPE_PERMISSIONS
} FilesViewAbstractPropertiesDialogPanelType;

#define FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_TYPE_PANEL_TYPE (files_view_abstract_properties_dialog_panel_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FilesViewAbstractPropertiesDialog {
	GraniteDialog parent_instance;
	FilesViewAbstractPropertiesDialogPrivate * priv;
	GtkGrid* info_grid;
	GtkGrid* layout;
	GtkStack* stack;
	GtkWidget* header_title;
};

struct _FilesViewAbstractPropertiesDialogClass {
	GraniteDialogClass parent_class;
};

static gpointer files_view_abstract_properties_dialog_parent_class = NULL;

VALA_EXTERN GType files_view_abstract_properties_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewAbstractPropertiesDialog, g_object_unref)
VALA_EXTERN GType files_view_abstract_properties_dialog_panel_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FilesViewAbstractPropertiesDialog* files_view_abstract_properties_dialog_construct (GType object_type,
                                                                                    const gchar* _title,
                                                                                    GtkWindow* parent);
VALA_EXTERN void files_view_abstract_properties_dialog_create_header_title (FilesViewAbstractPropertiesDialog* self);
VALA_EXTERN void files_view_abstract_properties_dialog_overlay_emblems (FilesViewAbstractPropertiesDialog* self,
                                                            GtkImage* file_icon,
                                                            GList* emblems_list);
VALA_EXTERN void files_view_abstract_properties_dialog_create_storage_bar (FilesViewAbstractPropertiesDialog* self,
                                                               GFileInfo* file_info,
                                                               gint line);
VALA_EXTERN GtkLabel* files_make_key_label (const gchar* label);
VALA_EXTERN GtkLabel* files_make_value_label (const gchar* label);
static GObject * files_view_abstract_properties_dialog_constructor (GType type,
                                                             guint n_construct_properties,
                                                             GObjectConstructParam * construct_properties);
static void _files_view_abstract_properties_dialog___lambda39_ (FilesViewAbstractPropertiesDialog* self,
                                                         GtkDialog* source,
                                                         gint type);
static void __files_view_abstract_properties_dialog___lambda39__gtk_dialog_response (GtkDialog* _sender,
                                                                              gint response_id,
                                                                              gpointer self);
static void files_view_abstract_properties_dialog_finalize (GObject * obj);
static GType files_view_abstract_properties_dialog_get_type_once (void);

 G_GNUC_NO_INLINE static GType
files_view_abstract_properties_dialog_panel_type_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_PANEL_TYPE_INFO, "FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_PANEL_TYPE_INFO", "info"}, {FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_PANEL_TYPE_PERMISSIONS, "FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_PANEL_TYPE_PERMISSIONS", "permissions"}, {0, NULL, NULL}};
	GType files_view_abstract_properties_dialog_panel_type_type_id;
	files_view_abstract_properties_dialog_panel_type_type_id = g_enum_register_static ("FilesViewAbstractPropertiesDialogPanelType", values);
	return files_view_abstract_properties_dialog_panel_type_type_id;
}

GType
files_view_abstract_properties_dialog_panel_type_get_type (void)
{
	static volatile gsize files_view_abstract_properties_dialog_panel_type_type_id__once = 0;
	if (g_once_init_enter (&files_view_abstract_properties_dialog_panel_type_type_id__once)) {
		GType files_view_abstract_properties_dialog_panel_type_type_id;
		files_view_abstract_properties_dialog_panel_type_type_id = files_view_abstract_properties_dialog_panel_type_get_type_once ();
		g_once_init_leave (&files_view_abstract_properties_dialog_panel_type_type_id__once, files_view_abstract_properties_dialog_panel_type_type_id);
	}
	return files_view_abstract_properties_dialog_panel_type_type_id__once;
}

FilesViewAbstractPropertiesDialog*
files_view_abstract_properties_dialog_construct (GType object_type,
                                                 const gchar* _title,
                                                 GtkWindow* parent)
{
	FilesViewAbstractPropertiesDialog * self = NULL;
	g_return_val_if_fail (_title != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (FilesViewAbstractPropertiesDialog*) g_object_new (object_type, "title", _title, "transient-for", parent, "destroy-with-parent", TRUE, NULL);
	return self;
}

void
files_view_abstract_properties_dialog_create_header_title (FilesViewAbstractPropertiesDialog* self)
{
	GtkWidget* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkGrid* _tmp8_;
	GtkWidget* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->header_title;
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
	gtk_style_context_add_class (_tmp1_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp2_ = self->header_title;
	gtk_widget_set_hexpand (_tmp2_, TRUE);
	_tmp3_ = self->header_title;
	gtk_widget_set_margin_top (_tmp3_, 6);
	_tmp4_ = self->header_title;
	gtk_widget_set_valign (_tmp4_, GTK_ALIGN_CENTER);
	_tmp5_ = self->header_title;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_label_get_type ())) {
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		_tmp6_ = self->header_title;
		gtk_widget_set_halign (_tmp6_, GTK_ALIGN_START);
		_tmp7_ = self->header_title;
		gtk_label_set_selectable (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_label_get_type (), GtkLabel), TRUE);
	}
	_tmp8_ = self->layout;
	_tmp9_ = self->header_title;
	gtk_grid_attach (_tmp8_, _tmp9_, 1, 0, 1, 1);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
files_view_abstract_properties_dialog_overlay_emblems (FilesViewAbstractPropertiesDialog* self,
                                                       GtkImage* file_icon,
                                                       GList* emblems_list)
{
	GtkOverlay* file_overlay = NULL;
	GtkWidget* _tmp0_;
	GtkOverlay* _tmp1_ = NULL;
	GtkGrid* _tmp2_;
	GtkOverlay* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_icon != NULL);
	_tmp0_ = _g_object_ref0 ((GtkWidget*) file_icon);
	_tmp1_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_set ((GtkContainer*) _tmp1_, "child", _tmp0_, NULL);
	_g_object_unref0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	file_overlay = _tmp1_;
	_tmp2_ = self->layout;
	_tmp3_ = file_overlay;
	gtk_grid_attach (_tmp2_, (GtkWidget*) _tmp3_, 0, 0, 1, 1);
	if (emblems_list != NULL) {
		gint pos = 0;
		GtkBox* emblem_box = NULL;
		GtkBox* _tmp4_ = NULL;
		GtkOverlay* _tmp11_;
		GtkBox* _tmp12_;
		pos = 0;
		_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_END);
		gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_END);
		g_object_ref_sink (_tmp4_);
		emblem_box = _tmp4_;
		{
			GList* emblem_name_collection = NULL;
			GList* emblem_name_it = NULL;
			emblem_name_collection = emblems_list;
			for (emblem_name_it = emblem_name_collection; emblem_name_it != NULL; emblem_name_it = emblem_name_it->next) {
				gchar* _tmp5_;
				gchar* emblem_name = NULL;
				_tmp5_ = g_strdup ((const gchar*) emblem_name_it->data);
				emblem_name = _tmp5_;
				{
					GtkImage* emblem = NULL;
					const gchar* _tmp6_;
					GtkImage* _tmp7_;
					GtkBox* _tmp8_;
					GtkImage* _tmp9_;
					gint _tmp10_;
					_tmp6_ = emblem_name;
					_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp6_, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
					g_object_ref_sink (_tmp7_);
					emblem = _tmp7_;
					_tmp8_ = emblem_box;
					_tmp9_ = emblem;
					gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
					_tmp10_ = pos;
					pos = _tmp10_ + 1;
					if (pos > 3) {
						_g_object_unref0 (emblem);
						_g_free0 (emblem_name);
						break;
					}
					_g_object_unref0 (emblem);
					_g_free0 (emblem_name);
				}
			}
		}
		_tmp11_ = file_overlay;
		_tmp12_ = emblem_box;
		gtk_overlay_add_overlay (_tmp11_, (GtkWidget*) _tmp12_);
		_g_object_unref0 (emblem_box);
	}
	_g_object_unref0 (file_overlay);
}

void
files_view_abstract_properties_dialog_create_storage_bar (FilesViewAbstractPropertiesDialog* self,
                                                          GFileInfo* file_info,
                                                          gint line)
{
	GraniteHeaderLabel* storage_header = NULL;
	GraniteHeaderLabel* _tmp0_;
	GtkGrid* _tmp1_;
	GraniteHeaderLabel* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_info != NULL);
	_tmp0_ = granite_header_label_new (_ ("Device Usage"));
	g_object_ref_sink (_tmp0_);
	storage_header = _tmp0_;
	_tmp1_ = self->info_grid;
	_tmp2_ = storage_header;
	gtk_grid_attach (_tmp1_, (GtkWidget*) _tmp2_, 0, line, 1, 1);
	if (file_info != NULL) {
		_tmp5_ = g_file_info_has_attribute (file_info, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = g_file_info_has_attribute (file_info, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = g_file_info_has_attribute (file_info, G_FILE_ATTRIBUTE_FILESYSTEM_USED);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		guint64 fs_capacity = 0ULL;
		guint64 fs_used = 0ULL;
		guint64 fs_available = 0ULL;
		guint64 fs_reserved = 0ULL;
		GtkLevelBar* storage_levelbar = NULL;
		GtkLevelBar* _tmp6_ = NULL;
		GtkLevelBar* _tmp7_;
		GtkLevelBar* _tmp8_;
		GtkLevelBar* _tmp9_;
		GtkLevelBar* _tmp10_;
		GtkStyleContext* _tmp11_;
		GtkLabel* storage_label = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GtkLabel* _tmp18_;
		GtkLabel* _tmp19_;
		GtkGrid* _tmp20_;
		GtkLevelBar* _tmp21_;
		GtkGrid* _tmp22_;
		GtkLabel* _tmp23_;
		fs_capacity = g_file_info_get_attribute_uint64 (file_info, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE);
		fs_used = g_file_info_get_attribute_uint64 (file_info, G_FILE_ATTRIBUTE_FILESYSTEM_USED);
		fs_available = g_file_info_get_attribute_uint64 (file_info, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
		fs_reserved = (fs_capacity - fs_used) - fs_available;
		_tmp6_ = (GtkLevelBar*) gtk_level_bar_new_for_interval ((gdouble) 0, (gdouble) fs_capacity);
		gtk_level_bar_set_value (_tmp6_, (gdouble) (fs_used + fs_reserved));
		gtk_widget_set_hexpand ((GtkWidget*) _tmp6_, TRUE);
		g_object_ref_sink (_tmp6_);
		storage_levelbar = _tmp6_;
		_tmp7_ = storage_levelbar;
		gtk_level_bar_add_offset_value (_tmp7_, GTK_LEVEL_BAR_OFFSET_LOW, 0.6 * fs_capacity);
		_tmp8_ = storage_levelbar;
		gtk_level_bar_add_offset_value (_tmp8_, GTK_LEVEL_BAR_OFFSET_HIGH, 0.9 * fs_capacity);
		_tmp9_ = storage_levelbar;
		gtk_level_bar_add_offset_value (_tmp9_, GTK_LEVEL_BAR_OFFSET_FULL, (gdouble) fs_capacity);
		_tmp10_ = storage_levelbar;
		_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
		gtk_style_context_add_class (_tmp11_, "inverted");
		_tmp12_ = g_format_size_full ((fs_capacity - fs_used) + fs_reserved, G_FORMAT_SIZE_DEFAULT);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_format_size_full (fs_capacity, G_FORMAT_SIZE_DEFAULT);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf (_ ("%s free out of %s"), _tmp13_, _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
		g_object_ref_sink (_tmp18_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		storage_label = _tmp19_;
		_tmp20_ = self->info_grid;
		_tmp21_ = storage_levelbar;
		gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, line + 1, 4, 1);
		_tmp22_ = self->info_grid;
		_tmp23_ = storage_label;
		gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 0, line + 2, 4, 1);
		_g_object_unref0 (storage_label);
		_g_object_unref0 (storage_levelbar);
	} else {
		GtkLabel* capacity_label = NULL;
		GtkLabel* _tmp24_;
		GtkLabel* capacity_value = NULL;
		GtkLabel* _tmp25_;
		GtkLabel* available_label = NULL;
		GtkLabel* _tmp26_;
		GtkLabel* available_value = NULL;
		GtkLabel* _tmp27_;
		GtkLabel* used_label = NULL;
		GtkLabel* _tmp28_;
		GtkLabel* used_value = NULL;
		GtkLabel* _tmp29_;
		GtkGrid* _tmp30_;
		GtkLabel* _tmp31_;
		GtkGrid* _tmp32_;
		GtkLabel* _tmp33_;
		GtkLabel* _tmp34_;
		GtkGrid* _tmp35_;
		GtkLabel* _tmp36_;
		GtkGrid* _tmp37_;
		GtkLabel* _tmp38_;
		GtkLabel* _tmp39_;
		GtkGrid* _tmp40_;
		GtkLabel* _tmp41_;
		GtkGrid* _tmp42_;
		GtkLabel* _tmp43_;
		GtkLabel* _tmp44_;
		_tmp24_ = files_make_key_label (_ ("Capacity:"));
		capacity_label = _tmp24_;
		_tmp25_ = files_make_value_label (_ ("Unknown"));
		capacity_value = _tmp25_;
		_tmp26_ = files_make_key_label (_ ("Available:"));
		available_label = _tmp26_;
		_tmp27_ = files_make_value_label (_ ("Unknown"));
		available_value = _tmp27_;
		_tmp28_ = files_make_key_label (_ ("Used:"));
		used_label = _tmp28_;
		_tmp29_ = files_make_value_label (_ ("Unknown"));
		used_value = _tmp29_;
		_tmp30_ = self->info_grid;
		_tmp31_ = capacity_label;
		gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 0, line + 1, 1, 1);
		_tmp32_ = self->info_grid;
		_tmp33_ = capacity_value;
		_tmp34_ = capacity_label;
		gtk_grid_attach_next_to (_tmp32_, (GtkWidget*) _tmp33_, (GtkWidget*) _tmp34_, GTK_POS_RIGHT, 1, 1);
		_tmp35_ = self->info_grid;
		_tmp36_ = available_label;
		gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, 0, line + 2, 1, 1);
		_tmp37_ = self->info_grid;
		_tmp38_ = available_value;
		_tmp39_ = available_label;
		gtk_grid_attach_next_to (_tmp37_, (GtkWidget*) _tmp38_, (GtkWidget*) _tmp39_, GTK_POS_RIGHT, 1, 1);
		_tmp40_ = self->info_grid;
		_tmp41_ = used_label;
		gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 0, line + 3, 1, 1);
		_tmp42_ = self->info_grid;
		_tmp43_ = used_value;
		_tmp44_ = used_label;
		gtk_grid_attach_next_to (_tmp42_, (GtkWidget*) _tmp43_, (GtkWidget*) _tmp44_, GTK_POS_RIGHT, 1, 1);
		_g_object_unref0 (used_value);
		_g_object_unref0 (used_label);
		_g_object_unref0 (available_value);
		_g_object_unref0 (available_label);
		_g_object_unref0 (capacity_value);
		_g_object_unref0 (capacity_label);
	}
	_g_object_unref0 (storage_header);
}

static void
_files_view_abstract_properties_dialog___lambda39_ (FilesViewAbstractPropertiesDialog* self,
                                                    GtkDialog* source,
                                                    gint type)
{
	g_return_if_fail (source != NULL);
	switch (type) {
		case GTK_RESPONSE_CLOSE:
		{
			gtk_widget_destroy ((GtkWidget*) self);
			break;
		}
		default:
		break;
	}
}

static void
__files_view_abstract_properties_dialog___lambda39__gtk_dialog_response (GtkDialog* _sender,
                                                                         gint response_id,
                                                                         gpointer self)
{
	_files_view_abstract_properties_dialog___lambda39_ ((FilesViewAbstractPropertiesDialog*) self, _sender, response_id);
}

static GObject *
files_view_abstract_properties_dialog_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesViewAbstractPropertiesDialog * self;
	GraniteHeaderLabel* info_header = NULL;
	GraniteHeaderLabel* _tmp0_;
	GtkGrid* _tmp1_ = NULL;
	GtkGrid* _tmp2_;
	GraniteHeaderLabel* _tmp3_;
	GtkStack* _tmp4_;
	GtkStack* _tmp5_;
	GtkGrid* _tmp6_;
	gchar* _tmp7_;
	GtkGrid* _tmp8_ = NULL;
	GtkGrid* _tmp9_;
	GtkStack* _tmp10_;
	GtkBox* _tmp11_;
	GtkGrid* _tmp12_;
	parent_class = G_OBJECT_CLASS (files_view_abstract_properties_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialog);
	g_object_set ((GtkWindow*) self, "default-width", 220, NULL);
	_tmp0_ = granite_header_label_new (_ ("Info"));
	g_object_ref_sink (_tmp0_);
	info_header = _tmp0_;
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp1_, 6);
	gtk_grid_set_row_spacing (_tmp1_, 6);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->info_grid);
	self->info_grid = _tmp1_;
	_tmp2_ = self->info_grid;
	_tmp3_ = info_header;
	gtk_grid_attach (_tmp2_, (GtkWidget*) _tmp3_, 0, 0, 2, 1);
	_tmp4_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->stack);
	self->stack = _tmp4_;
	_tmp5_ = self->stack;
	_tmp6_ = self->info_grid;
	_tmp7_ = g_enum_to_string (FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_TYPE_PANEL_TYPE, FILES_VIEW_ABSTRACT_PROPERTIES_DIALOG_PANEL_TYPE_INFO);
	gtk_stack_add_titled (_tmp5_, (GtkWidget*) _tmp6_, _tmp7_, _ ("General"));
	_g_free0 (_tmp7_);
	_tmp8_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp8_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp8_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp8_, 12);
	gtk_grid_set_column_spacing (_tmp8_, 12);
	gtk_grid_set_row_spacing (_tmp8_, 6);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp8_, TRUE);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->layout);
	self->layout = _tmp8_;
	_tmp9_ = self->layout;
	_tmp10_ = self->stack;
	gtk_grid_attach (_tmp9_, (GtkWidget*) _tmp10_, 0, 2, 2, 1);
	_tmp11_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp12_ = self->layout;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Close"), (gint) GTK_RESPONSE_CLOSE);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __files_view_abstract_properties_dialog___lambda39__gtk_dialog_response, self, 0);
	_g_object_unref0 (info_header);
	return obj;
}

static void
files_view_abstract_properties_dialog_class_init (FilesViewAbstractPropertiesDialogClass * klass,
                                                  gpointer klass_data)
{
	files_view_abstract_properties_dialog_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = files_view_abstract_properties_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_view_abstract_properties_dialog_finalize;
}

static void
files_view_abstract_properties_dialog_instance_init (FilesViewAbstractPropertiesDialog * self,
                                                     gpointer klass)
{
}

static void
files_view_abstract_properties_dialog_finalize (GObject * obj)
{
	FilesViewAbstractPropertiesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_ABSTRACT_PROPERTIES_DIALOG, FilesViewAbstractPropertiesDialog);
	_g_object_unref0 (self->info_grid);
	_g_object_unref0 (self->layout);
	_g_object_unref0 (self->stack);
	_g_object_unref0 (self->header_title);
	G_OBJECT_CLASS (files_view_abstract_properties_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_abstract_properties_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewAbstractPropertiesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_abstract_properties_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewAbstractPropertiesDialog), 0, (GInstanceInitFunc) files_view_abstract_properties_dialog_instance_init, NULL };
	GType files_view_abstract_properties_dialog_type_id;
	files_view_abstract_properties_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "FilesViewAbstractPropertiesDialog", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return files_view_abstract_properties_dialog_type_id;
}

GType
files_view_abstract_properties_dialog_get_type (void)
{
	static volatile gsize files_view_abstract_properties_dialog_type_id__once = 0;
	if (g_once_init_enter (&files_view_abstract_properties_dialog_type_id__once)) {
		GType files_view_abstract_properties_dialog_type_id;
		files_view_abstract_properties_dialog_type_id = files_view_abstract_properties_dialog_get_type_once ();
		g_once_init_leave (&files_view_abstract_properties_dialog_type_id__once, files_view_abstract_properties_dialog_type_id);
	}
	return files_view_abstract_properties_dialog_type_id__once;
}

