/* BreadcrumbElement.c generated by valac 0.56.18, the Vala compiler
 * generated from BreadcrumbElement.vala, do not modify */

#include "pantheon-files-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_ICON_MARGIN 3
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_0_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_NATURAL_WIDTH_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_REAL_WIDTH_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_FOR_DISPLAY_PROPERTY,
	FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_NUM_PROPERTIES
};
static GParamSpec* files_view_chrome_breadcrumb_element_properties[FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_NUM_PROPERTIES];
#define _files_view_chrome_breadcrumb_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (files_view_chrome_breadcrumb_icon_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_path_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_path_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _FilesViewChromeBreadcrumbElementPrivate {
	FilesViewChromeBreadcrumbIconInfo* icon_info;
	gchar* _text;
	gdouble text_width;
	gdouble text_half_height;
	gchar* _text_for_display;
	GtkBorder padding;
	PangoLayout* layout;
	GtkWidget* widget;
};

static gint FilesViewChromeBreadcrumbElement_private_offset;
static gpointer files_view_chrome_breadcrumb_element_parent_class = NULL;

static void files_view_chrome_breadcrumb_element_set_text (FilesViewChromeBreadcrumbElement* self,
                                                    const gchar* value);
static cairo_surface_t* files_view_chrome_breadcrumb_element_get_mask (FilesViewChromeBreadcrumbElement* self,
                                                                gdouble x1,
                                                                gdouble y1,
                                                                gdouble x2,
                                                                gdouble y2,
                                                                gint scale,
                                                                cairo_path_t* clip_path);
static void files_view_chrome_breadcrumb_element_update_text_width (FilesViewChromeBreadcrumbElement* self);
static void files_view_chrome_breadcrumb_element_finalize (GObject * obj);
static GType files_view_chrome_breadcrumb_element_get_type_once (void);
static void _vala_files_view_chrome_breadcrumb_element_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_files_view_chrome_breadcrumb_element_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
files_view_chrome_breadcrumb_element_get_instance_private (FilesViewChromeBreadcrumbElement* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewChromeBreadcrumbElement_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FilesViewChromeBreadcrumbElement*
files_view_chrome_breadcrumb_element_construct (GType object_type,
                                                const gchar* text_,
                                                GtkWidget* widget_,
                                                GtkStyleContext* button_context)
{
	FilesViewChromeBreadcrumbElement * self = NULL;
	GtkWidget* _tmp0_;
	GtkBorder _tmp1_ = {0};
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (text_ != NULL, NULL);
	g_return_val_if_fail (widget_ != NULL, NULL);
	g_return_val_if_fail (button_context != NULL, NULL);
	self = (FilesViewChromeBreadcrumbElement*) g_object_new (object_type, NULL);
	files_view_chrome_breadcrumb_element_set_text (self, text_);
	_tmp0_ = _g_object_ref0 (widget_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp0_;
	gtk_style_context_get_padding (button_context, gtk_style_context_get_state (button_context), &_tmp1_);
	self->priv->padding = _tmp1_;
	_tmp2_ = self->priv->_text;
	_tmp3_ = g_uri_unescape_string (_tmp2_, NULL);
	_tmp4_ = _tmp3_;
	files_view_chrome_breadcrumb_element_set_text_for_display (self, _tmp4_);
	_g_free0 (_tmp4_);
	return self;
}

FilesViewChromeBreadcrumbElement*
files_view_chrome_breadcrumb_element_new (const gchar* text_,
                                          GtkWidget* widget_,
                                          GtkStyleContext* button_context)
{
	return files_view_chrome_breadcrumb_element_construct (FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT, text_, widget_, button_context);
}

static gpointer
_files_view_chrome_breadcrumb_icon_info_ref0 (gpointer self)
{
	return self ? files_view_chrome_breadcrumb_icon_info_ref (self) : NULL;
}

void
files_view_chrome_breadcrumb_element_set_icon (FilesViewChromeBreadcrumbElement* self,
                                               FilesViewChromeBreadcrumbIconInfo* icon_info)
{
	FilesViewChromeBreadcrumbIconInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_info != NULL);
	_tmp0_ = _files_view_chrome_breadcrumb_icon_info_ref0 (icon_info);
	_files_view_chrome_breadcrumb_icon_info_unref0 (self->priv->icon_info);
	self->priv->icon_info = _tmp0_;
}

static cairo_surface_t*
files_view_chrome_breadcrumb_element_get_mask (FilesViewChromeBreadcrumbElement* self,
                                               gdouble x1,
                                               gdouble y1,
                                               gdouble x2,
                                               gdouble y2,
                                               gint scale,
                                               cairo_path_t* clip_path)
{
	gint w = 0;
	gint h = 0;
	cairo_surface_t* mask = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (clip_path == NULL) {
		result = NULL;
		return result;
	}
	w = ((gint) (ceil (x2) - floor (x1))) * scale;
	h = ((gint) (ceil (y2) - floor (y1))) * scale;
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_A8, w, h);
	mask = _tmp0_;
	_tmp1_ = mask;
	_tmp2_ = cairo_create (_tmp1_);
	cr = _tmp2_;
	_tmp3_ = cr;
	cairo_translate (_tmp3_, -x1, -y1);
	_tmp4_ = cr;
	cairo_set_source_rgb (_tmp4_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp5_ = cr;
	cairo_append_path (_tmp5_, clip_path);
	_tmp6_ = cr;
	cairo_fill (_tmp6_);
	result = mask;
	_cairo_destroy0 (cr);
	return result;
}

gdouble
files_view_chrome_breadcrumb_element_draw (FilesViewChromeBreadcrumbElement* self,
                                           cairo_t* cr,
                                           gdouble x,
                                           gdouble y,
                                           gdouble height,
                                           GtkWidget* widget)
{
	GtkStyleContext* button_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStateFlags state = 0U;
	GtkStyleContext* _tmp1_;
	gboolean is_rtl = FALSE;
	gint scale = 0;
	gint _tmp2_;
	gint _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp6_;
	GtkBorder _tmp7_ = {0};
	gdouble line_width = 0.0;
	gdouble half_height = 0.0;
	gdouble y_half_height = 0.0;
	gdouble y_height = 0.0;
	gdouble width = 0.0;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble frame_width = 0.0;
	GtkBorder _tmp10_;
	cairo_path_t* clip_path = NULL;
	gdouble clip_x1 = 0.0;
	gdouble clip_y1 = 0.0;
	gdouble clip_x2 = 0.0;
	gdouble clip_y2 = 0.0;
	gint _tmp20_ = 0;
	FilesViewChromeBreadcrumbIconInfo* _tmp21_;
	gint iw = 0;
	gboolean room_for_text = FALSE;
	gboolean _tmp23_ = FALSE;
	FilesViewChromeBreadcrumbIconInfo* _tmp24_;
	gboolean room_for_icon = FALSE;
	gdouble layout_width = 0.0;
	GtkBorder _tmp25_;
	GtkBorder _tmp26_;
	GdkPixbuf* _tmp31_ = NULL;
	FilesViewChromeBreadcrumbIconInfo* _tmp32_;
	GdkPixbuf* icon_to_draw = NULL;
	GdkPixbuf* _tmp36_;
	gboolean _tmp37_ = FALSE;
	GdkPixbuf* _tmp38_;
	cairo_surface_t* mask = NULL;
	cairo_path_t* _tmp41_;
	cairo_surface_t* _tmp42_;
	cairo_pattern_t* group = NULL;
	cairo_pattern_t* _tmp63_;
	cairo_pattern_t* _tmp64_;
	cairo_surface_t* _tmp65_;
	GtkStyleContext* _tmp75_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (cr != NULL, 0.0);
	g_return_val_if_fail (widget != NULL, 0.0);
	_tmp0_ = gtk_widget_get_style_context (widget);
	button_context = _tmp0_;
	_tmp1_ = button_context;
	state = gtk_style_context_get_state (_tmp1_);
	is_rtl = (state & GTK_STATE_FLAG_DIR_RTL) == GTK_STATE_FLAG_DIR_RTL;
	_tmp2_ = gtk_widget_get_scale_factor (widget);
	_tmp3_ = _tmp2_;
	scale = _tmp3_;
	_tmp4_ = button_context;
	gtk_style_context_save (_tmp4_);
	if (self->pressed) {
		GtkStyleContext* _tmp5_;
		state |= GTK_STATE_FLAG_ACTIVE;
		_tmp5_ = button_context;
		gtk_style_context_set_state (_tmp5_, state);
	}
	_tmp6_ = button_context;
	gtk_style_context_get_padding (_tmp6_, state, &_tmp7_);
	self->priv->padding = _tmp7_;
	line_width = cairo_get_line_width (cr);
	cairo_restore (cr);
	cairo_save (cr);
	cairo_rectangle (cr, 0.0, 0.0, (gdouble) gtk_widget_get_allocated_width (widget), (gdouble) gtk_widget_get_allocated_height (widget));
	cairo_clip (cr);
	half_height = height / 2;
	y_half_height = y + half_height;
	y_height = y + height;
	cairo_set_source_rgb (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp8_ = files_view_chrome_breadcrumb_element_get_real_width (self);
	_tmp9_ = _tmp8_;
	width = _tmp9_;
	_tmp10_ = self->priv->padding;
	frame_width = width - _tmp10_.right;
	clip_path = NULL;
	clip_x1 = (gdouble) 0;
	clip_y1 = (gdouble) 0;
	clip_x2 = (gdouble) 0;
	clip_y2 = (gdouble) 0;
	if (self->offset > 0.0) {
		gdouble x_frame_width = 0.0;
		gdouble x_half_height = 0.0;
		gdouble x_frame_width_half_height = 0.0;
		cairo_path_t* _tmp11_;
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		if (is_rtl) {
			x_frame_width = (x - frame_width) - line_width;
			x_half_height = x + half_height;
			x_frame_width_half_height = x_frame_width - half_height;
		} else {
			x_frame_width = (x + frame_width) + line_width;
			x_half_height = x - half_height;
			x_frame_width_half_height = x_frame_width + half_height;
		}
		cairo_new_path (cr);
		cairo_move_to (cr, x_half_height, y);
		cairo_line_to (cr, x, y_half_height);
		cairo_line_to (cr, x_half_height, y_height);
		cairo_line_to (cr, x_frame_width, y_height);
		cairo_line_to (cr, x_frame_width_half_height, y_half_height);
		cairo_line_to (cr, x_frame_width, y);
		cairo_close_path (cr);
		_tmp11_ = cairo_copy_path (cr);
		_cairo_path_destroy0 (clip_path);
		clip_path = _tmp11_;
		cairo_clip (cr);
		cairo_clip_extents (cr, &_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
		clip_x1 = _tmp12_;
		clip_y1 = _tmp13_;
		clip_x2 = _tmp14_;
		clip_y2 = _tmp15_;
	}
	if (self->pressed) {
		gdouble base_x = 0.0;
		gdouble left_x = 0.0;
		gdouble right_x = 0.0;
		gdouble arrow_right_x = 0.0;
		gdouble top_y = 0.0;
		GtkBorder _tmp16_;
		gdouble bottom_y = 0.0;
		GtkBorder _tmp17_;
		gdouble arrow_y = 0.0;
		GtkStyleContext* _tmp18_;
		GtkStyleContext* _tmp19_;
		cairo_save (cr);
		base_x = x;
		if (is_rtl) {
			left_x = (base_x + half_height) - line_width;
			right_x = base_x - frame_width;
			arrow_right_x = right_x - half_height;
		} else {
			left_x = base_x - half_height;
			right_x = (base_x + frame_width) + line_width;
			arrow_right_x = right_x + half_height;
		}
		_tmp16_ = self->priv->padding;
		top_y = (y + _tmp16_.top) - line_width;
		_tmp17_ = self->priv->padding;
		bottom_y = (y_height - _tmp17_.bottom) + line_width;
		arrow_y = y_half_height;
		cairo_move_to (cr, left_x, top_y);
		cairo_line_to (cr, base_x, arrow_y);
		cairo_line_to (cr, left_x, bottom_y);
		cairo_line_to (cr, right_x, bottom_y);
		cairo_line_to (cr, arrow_right_x, arrow_y);
		cairo_line_to (cr, right_x, top_y);
		cairo_close_path (cr);
		cairo_clip (cr);
		_tmp18_ = button_context;
		gtk_render_background (_tmp18_, cr, left_x, y, (width + height) + (2 * line_width), height);
		_tmp19_ = button_context;
		gtk_render_frame (_tmp19_, cr, (gdouble) 0, y, (gdouble) gtk_widget_get_allocated_width (widget), height);
		cairo_restore (cr);
	}
	_tmp21_ = self->priv->icon_info;
	if (_tmp21_ != NULL) {
		FilesViewChromeBreadcrumbIconInfo* _tmp22_;
		_tmp22_ = self->priv->icon_info;
		_tmp20_ = _tmp22_->icon_width + (2 * FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_ICON_MARGIN);
	} else {
		_tmp20_ = 0;
	}
	iw = _tmp20_;
	room_for_text = self->text_is_displayed;
	_tmp24_ = self->priv->icon_info;
	if (_tmp24_ != NULL) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = FALSE;
	}
	room_for_icon = _tmp23_;
	_tmp25_ = self->priv->padding;
	_tmp26_ = self->priv->padding;
	layout_width = (width - _tmp25_.left) - _tmp26_.right;
	if (is_rtl) {
		GtkBorder _tmp27_;
		_tmp27_ = self->priv->padding;
		x = x - _tmp27_.left;
		x = x + ((self->offset * round ((self->offset * (width + half_height)) * scale)) / scale);
	} else {
		GtkBorder _tmp28_;
		_tmp28_ = self->priv->padding;
		x = x + _tmp28_.left;
		x = x - ((self->offset * round ((self->offset * (width + half_height)) * scale)) / scale);
	}
	if (layout_width < ((gdouble) iw)) {
		room_for_icon = FALSE;
		iw = 0;
		if (layout_width >= ((gdouble) 0)) {
			PangoLayout* _tmp29_;
			_tmp29_ = self->priv->layout;
			pango_layout_set_width (_tmp29_, pango_units_from_double (layout_width));
		} else {
			room_for_text = FALSE;
		}
	} else {
		layout_width -= (gdouble) iw;
		if (layout_width >= ((gdouble) 0)) {
			PangoLayout* _tmp30_;
			_tmp30_ = self->priv->layout;
			pango_layout_set_width (_tmp30_, pango_units_from_double (layout_width));
		} else {
			room_for_text = FALSE;
		}
	}
	_tmp32_ = self->priv->icon_info;
	if (_tmp32_ != NULL) {
		FilesViewChromeBreadcrumbIconInfo* _tmp33_;
		GtkStyleContext* _tmp34_;
		GdkPixbuf* _tmp35_;
		_tmp33_ = self->priv->icon_info;
		_tmp34_ = button_context;
		_tmp35_ = files_view_chrome_breadcrumb_icon_info_render_icon (_tmp33_, _tmp34_);
		_g_object_unref0 (_tmp31_);
		_tmp31_ = _tmp35_;
	} else {
		_g_object_unref0 (_tmp31_);
		_tmp31_ = NULL;
	}
	_tmp36_ = _g_object_ref0 (_tmp31_);
	icon_to_draw = _tmp36_;
	_tmp38_ = icon_to_draw;
	if (_tmp38_ != NULL) {
		_tmp37_ = (state & GTK_STATE_FLAG_BACKDROP) > 0;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		GdkPixbuf* _tmp39_;
		GdkPixbuf* _tmp40_;
		_tmp39_ = icon_to_draw;
		_tmp40_ = pf_pixbuf_utils_lucent (_tmp39_, (guint) 50);
		_g_object_unref0 (icon_to_draw);
		icon_to_draw = _tmp40_;
	}
	cairo_save (cr);
	_tmp41_ = clip_path;
	_tmp42_ = files_view_chrome_breadcrumb_element_get_mask (self, clip_x1, clip_y1, clip_x2, clip_y2, scale, _tmp41_);
	mask = _tmp42_;
	cairo_push_group (cr);
	if (is_rtl) {
		GdkPixbuf* _tmp43_;
		_tmp43_ = icon_to_draw;
		if (_tmp43_ == NULL) {
			if (room_for_text) {
				GtkStyleContext* _tmp44_;
				PangoLayout* _tmp45_;
				_tmp44_ = button_context;
				_tmp45_ = self->priv->layout;
				gtk_render_layout (_tmp44_, cr, x - width, y_half_height - self->priv->text_half_height, _tmp45_);
			}
		} else {
			gboolean _tmp50_ = FALSE;
			if (room_for_icon) {
				gdouble draw_scale = 0.0;
				GtkStyleContext* _tmp46_;
				GdkPixbuf* _tmp47_;
				FilesViewChromeBreadcrumbIconInfo* _tmp48_;
				FilesViewChromeBreadcrumbIconInfo* _tmp49_;
				cairo_save (cr);
				draw_scale = 1.0 / scale;
				cairo_scale (cr, draw_scale, draw_scale);
				_tmp46_ = button_context;
				_tmp47_ = icon_to_draw;
				_tmp48_ = self->priv->icon_info;
				_tmp49_ = self->priv->icon_info;
				gtk_render_icon (_tmp46_, cr, _tmp47_, round (((x - FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_ICON_MARGIN) - _tmp48_->icon_width) * scale), round ((y_half_height - (_tmp49_->icon_height / 2)) * scale));
				cairo_restore (cr);
			}
			if (self->text_is_displayed) {
				_tmp50_ = room_for_text;
			} else {
				_tmp50_ = FALSE;
			}
			if (_tmp50_) {
				GtkStyleContext* _tmp51_;
				PangoLayout* _tmp52_;
				_tmp51_ = button_context;
				_tmp52_ = self->priv->layout;
				gtk_render_layout (_tmp51_, cr, x - width, y_half_height - self->priv->text_half_height, _tmp52_);
			}
		}
	} else {
		GdkPixbuf* _tmp53_;
		cairo_save (cr);
		_tmp53_ = icon_to_draw;
		if (_tmp53_ == NULL) {
			if (room_for_text) {
				GtkStyleContext* _tmp54_;
				PangoLayout* _tmp55_;
				_tmp54_ = button_context;
				_tmp55_ = self->priv->layout;
				gtk_render_layout (_tmp54_, cr, x, y_half_height - self->priv->text_half_height, _tmp55_);
			}
		} else {
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			if (room_for_icon) {
				gdouble draw_scale = 0.0;
				GtkStyleContext* _tmp56_;
				GdkPixbuf* _tmp57_;
				FilesViewChromeBreadcrumbIconInfo* _tmp58_;
				cairo_save (cr);
				draw_scale = 1.0 / scale;
				cairo_scale (cr, draw_scale, draw_scale);
				_tmp56_ = button_context;
				_tmp57_ = icon_to_draw;
				_tmp58_ = self->priv->icon_info;
				gtk_render_icon (_tmp56_, cr, _tmp57_, round ((x + FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_ICON_MARGIN) * scale), round ((y_half_height - (_tmp58_->icon_height / 2)) * scale));
				cairo_restore (cr);
			}
			if (self->text_is_displayed) {
				_tmp60_ = room_for_text;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				_tmp59_ = x > ((gdouble) 0);
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				GtkStyleContext* _tmp61_;
				PangoLayout* _tmp62_;
				_tmp61_ = button_context;
				_tmp62_ = self->priv->layout;
				gtk_render_layout (_tmp61_, cr, x + iw, y_half_height - self->priv->text_half_height, _tmp62_);
			}
		}
		cairo_restore (cr);
	}
	_tmp63_ = cairo_pop_group (cr);
	group = _tmp63_;
	_tmp64_ = group;
	cairo_set_source (cr, _tmp64_);
	_tmp65_ = mask;
	if (_tmp65_ != NULL) {
		cairo_surface_t* _tmp66_;
		_tmp66_ = mask;
		cairo_mask_surface (cr, _tmp66_, clip_x1, clip_y1);
	} else {
		cairo_paint (cr);
	}
	cairo_restore (cr);
	if (is_rtl) {
		x = x - frame_width;
	} else {
		x = x + frame_width;
	}
	if (is_rtl) {
		GtkStyleContext* _tmp67_;
		GtkStyleContext* _tmp68_;
		GtkStyleContext* _tmp69_;
		GtkStyleContext* _tmp70_;
		cairo_save (cr);
		cairo_translate (cr, x + (height / 4), y_half_height);
		cairo_rectangle (cr, (gdouble) 0, ((-height) / 2) + line_width, -height, height - (2 * line_width));
		cairo_clip (cr);
		cairo_rotate (cr, G_PI_4);
		_tmp67_ = button_context;
		gtk_style_context_save (_tmp67_);
		_tmp68_ = button_context;
		gtk_style_context_add_class (_tmp68_, "noradius-button");
		_tmp69_ = button_context;
		gtk_render_frame (_tmp69_, cr, (-height) / 2, (-height) / 2, height, height);
		_tmp70_ = button_context;
		gtk_style_context_restore (_tmp70_);
		cairo_restore (cr);
	} else {
		GtkStyleContext* _tmp71_;
		GtkStyleContext* _tmp72_;
		GtkStyleContext* _tmp73_;
		GtkStyleContext* _tmp74_;
		cairo_save (cr);
		cairo_translate (cr, x - (height / 4), y + (height / 2));
		cairo_rectangle (cr, (gdouble) 0, ((-height) / 2) + line_width, height, height - (2 * line_width));
		cairo_clip (cr);
		cairo_rotate (cr, G_PI_4);
		_tmp71_ = button_context;
		gtk_style_context_save (_tmp71_);
		_tmp72_ = button_context;
		gtk_style_context_add_class (_tmp72_, "noradius-button");
		_tmp73_ = button_context;
		gtk_render_frame (_tmp73_, cr, (-height) / 2, (-height) / 2, height, height);
		_tmp74_ = button_context;
		gtk_style_context_restore (_tmp74_);
		cairo_restore (cr);
	}
	if (is_rtl) {
		x = x - half_height;
	} else {
		x = x + half_height;
	}
	_tmp75_ = button_context;
	gtk_style_context_restore (_tmp75_);
	result = x;
	_cairo_pattern_destroy0 (group);
	_cairo_surface_destroy0 (mask);
	_g_object_unref0 (icon_to_draw);
	_g_object_unref0 (_tmp31_);
	_cairo_path_destroy0 (clip_path);
	return result;
}

static void
files_view_chrome_breadcrumb_element_update_text_width (FilesViewChromeBreadcrumbElement* self)
{
	GtkWidget* _tmp0_;
	const gchar* _tmp1_;
	PangoLayout* _tmp2_;
	PangoLayout* _tmp3_;
	gint width = 0;
	gint height = 0;
	PangoLayout* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widget;
	_tmp1_ = self->priv->_text_for_display;
	_tmp2_ = gtk_widget_create_pango_layout (_tmp0_, _tmp1_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp2_;
	_tmp3_ = self->priv->layout;
	pango_layout_set_ellipsize (_tmp3_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp4_ = self->priv->layout;
	pango_layout_get_size (_tmp4_, &_tmp5_, &_tmp6_);
	width = _tmp5_;
	height = _tmp6_;
	self->priv->text_width = pango_units_to_double (width);
	self->priv->text_half_height = pango_units_to_double (height) / 2;
}

/** To help testing **/
gchar*
files_view_chrome_breadcrumb_element_get_icon_name (FilesViewChromeBreadcrumbElement* self)
{
	FilesViewChromeBreadcrumbIconInfo* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->icon_info;
	if (_tmp0_ != NULL) {
		FilesViewChromeBreadcrumbIconInfo* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->icon_info;
		_tmp2_ = _tmp1_->path;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("null");
		result = _tmp4_;
		return result;
	}
}

const gchar*
files_view_chrome_breadcrumb_element_get_text (FilesViewChromeBreadcrumbElement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_breadcrumb_element_set_text (FilesViewChromeBreadcrumbElement* self,
                                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_breadcrumb_element_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_breadcrumb_element_properties[FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_PROPERTY]);
	}
}

gdouble
files_view_chrome_breadcrumb_element_get_natural_width (FilesViewChromeBreadcrumbElement* self)
{
	gdouble result;
	FilesViewChromeBreadcrumbIconInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->icon_info;
	if (_tmp0_ != NULL) {
		FilesViewChromeBreadcrumbIconInfo* _tmp1_;
		GtkBorder _tmp2_;
		GtkBorder _tmp3_;
		_tmp1_ = self->priv->icon_info;
		_tmp2_ = self->priv->padding;
		_tmp3_ = self->priv->padding;
		result = (((self->priv->text_width + _tmp1_->icon_width) + (2 * FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_ICON_MARGIN)) + _tmp2_.left) + _tmp3_.right;
		return result;
	} else {
		GtkBorder _tmp4_;
		GtkBorder _tmp5_;
		_tmp4_ = self->priv->padding;
		_tmp5_ = self->priv->padding;
		result = (self->priv->text_width + _tmp4_.left) + _tmp5_.right;
		return result;
	}
}

gdouble
files_view_chrome_breadcrumb_element_get_real_width (FilesViewChromeBreadcrumbElement* self)
{
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	if (self->display_width > ((gdouble) 0)) {
		_tmp0_ = self->display_width;
	} else {
		gdouble _tmp1_;
		gdouble _tmp2_;
		_tmp1_ = files_view_chrome_breadcrumb_element_get_natural_width (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

const gchar*
files_view_chrome_breadcrumb_element_get_text_for_display (FilesViewChromeBreadcrumbElement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text_for_display;
	result = _tmp0_;
	return result;
}

void
files_view_chrome_breadcrumb_element_set_text_for_display (FilesViewChromeBreadcrumbElement* self,
                                                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_text_for_display);
	self->priv->_text_for_display = _tmp0_;
	files_view_chrome_breadcrumb_element_update_text_width (self);
	g_object_notify_by_pspec ((GObject *) self, files_view_chrome_breadcrumb_element_properties[FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_FOR_DISPLAY_PROPERTY]);
}

static void
files_view_chrome_breadcrumb_element_class_init (FilesViewChromeBreadcrumbElementClass * klass,
                                                 gpointer klass_data)
{
	files_view_chrome_breadcrumb_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewChromeBreadcrumbElement_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_chrome_breadcrumb_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_chrome_breadcrumb_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = files_view_chrome_breadcrumb_element_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_PROPERTY, files_view_chrome_breadcrumb_element_properties[FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_NATURAL_WIDTH_PROPERTY, files_view_chrome_breadcrumb_element_properties[FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_NATURAL_WIDTH_PROPERTY] = g_param_spec_double ("natural-width", "natural-width", "natural-width", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_REAL_WIDTH_PROPERTY, files_view_chrome_breadcrumb_element_properties[FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_REAL_WIDTH_PROPERTY] = g_param_spec_double ("real-width", "real-width", "real-width", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_FOR_DISPLAY_PROPERTY, files_view_chrome_breadcrumb_element_properties[FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_FOR_DISPLAY_PROPERTY] = g_param_spec_string ("text-for-display", "text-for-display", "text-for-display", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
files_view_chrome_breadcrumb_element_instance_init (FilesViewChromeBreadcrumbElement * self,
                                                    gpointer klass)
{
	gchar* _tmp0_;
	self->priv = files_view_chrome_breadcrumb_element_get_instance_private (self);
	self->priv->icon_info = NULL;
	self->offset = (gdouble) 0;
	self->x = (gdouble) 0;
	self->display_width = (gdouble) -1;
	self->hidden = FALSE;
	self->display = TRUE;
	self->can_shrink = TRUE;
	self->pressed = FALSE;
	self->text_is_displayed = TRUE;
	_tmp0_ = g_strdup ("");
	self->priv->_text_for_display = _tmp0_;
}

static void
files_view_chrome_breadcrumb_element_finalize (GObject * obj)
{
	FilesViewChromeBreadcrumbElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT, FilesViewChromeBreadcrumbElement);
	_files_view_chrome_breadcrumb_icon_info_unref0 (self->priv->icon_info);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_text_for_display);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->widget);
	G_OBJECT_CLASS (files_view_chrome_breadcrumb_element_parent_class)->finalize (obj);
}

/***
    Copyright (c) 2011 Lucas Baudin <xapantu@gmail.com>

    Marlin is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    Marlin is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; see the file COPYING.  If not,
    write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor
    Boston, MA 02110-1335 USA.

***/
 G_GNUC_NO_INLINE static GType
files_view_chrome_breadcrumb_element_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewChromeBreadcrumbElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_chrome_breadcrumb_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewChromeBreadcrumbElement), 0, (GInstanceInitFunc) files_view_chrome_breadcrumb_element_instance_init, NULL };
	GType files_view_chrome_breadcrumb_element_type_id;
	files_view_chrome_breadcrumb_element_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesViewChromeBreadcrumbElement", &g_define_type_info, 0);
	FilesViewChromeBreadcrumbElement_private_offset = g_type_add_instance_private (files_view_chrome_breadcrumb_element_type_id, sizeof (FilesViewChromeBreadcrumbElementPrivate));
	return files_view_chrome_breadcrumb_element_type_id;
}

GType
files_view_chrome_breadcrumb_element_get_type (void)
{
	static volatile gsize files_view_chrome_breadcrumb_element_type_id__once = 0;
	if (g_once_init_enter (&files_view_chrome_breadcrumb_element_type_id__once)) {
		GType files_view_chrome_breadcrumb_element_type_id;
		files_view_chrome_breadcrumb_element_type_id = files_view_chrome_breadcrumb_element_get_type_once ();
		g_once_init_leave (&files_view_chrome_breadcrumb_element_type_id__once, files_view_chrome_breadcrumb_element_type_id);
	}
	return files_view_chrome_breadcrumb_element_type_id__once;
}

static void
_vala_files_view_chrome_breadcrumb_element_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	FilesViewChromeBreadcrumbElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT, FilesViewChromeBreadcrumbElement);
	switch (property_id) {
		case FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_PROPERTY:
		g_value_set_string (value, files_view_chrome_breadcrumb_element_get_text (self));
		break;
		case FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_NATURAL_WIDTH_PROPERTY:
		g_value_set_double (value, files_view_chrome_breadcrumb_element_get_natural_width (self));
		break;
		case FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_REAL_WIDTH_PROPERTY:
		g_value_set_double (value, files_view_chrome_breadcrumb_element_get_real_width (self));
		break;
		case FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_FOR_DISPLAY_PROPERTY:
		g_value_set_string (value, files_view_chrome_breadcrumb_element_get_text_for_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_chrome_breadcrumb_element_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	FilesViewChromeBreadcrumbElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT, FilesViewChromeBreadcrumbElement);
	switch (property_id) {
		case FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_PROPERTY:
		files_view_chrome_breadcrumb_element_set_text (self, g_value_get_string (value));
		break;
		case FILES_VIEW_CHROME_BREADCRUMB_ELEMENT_TEXT_FOR_DISPLAY_PROPERTY:
		files_view_chrome_breadcrumb_element_set_text_for_display (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

