/* BookmarkList.c generated by valac 0.56.18, the Vala compiler
 * generated from BookmarkList.vala, do not modify */

#include "pantheon-files-core.h"
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	FILES_BOOKMARK_LIST_JOB_TYPE_LOAD = 1,
	FILES_BOOKMARK_LIST_JOB_TYPE_SAVE = 2
} FilesBookmarkListJobType;

#define FILES_BOOKMARK_LIST_TYPE_JOB_TYPE (files_bookmark_list_job_type_get_type ())
enum  {
	FILES_BOOKMARK_LIST_0_PROPERTY,
	FILES_BOOKMARK_LIST_LIST_PROPERTY,
	FILES_BOOKMARK_LIST_NUM_PROPERTIES
};
static GParamSpec* files_bookmark_list_properties[FILES_BOOKMARK_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _files_bookmark_unref0(var) ((var == NULL) ? NULL : (var = (files_bookmark_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	FILES_BOOKMARK_LIST_CONTENTS_CHANGED_SIGNAL,
	FILES_BOOKMARK_LIST_LOADED_SIGNAL,
	FILES_BOOKMARK_LIST_DELETED_SIGNAL,
	FILES_BOOKMARK_LIST_NUM_SIGNALS
};
static guint files_bookmark_list_signals[FILES_BOOKMARK_LIST_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FilesBookmarkListPrivate {
	GList* _list;
	GFileMonitor* monitor;
	GQueue* pending_ops;
	FilesCallWhenReady* call_when_ready;
};

struct _Block1Data {
	int _ref_count_;
	FilesBookmarkList* self;
	guint index;
};

struct _Block2Data {
	int _ref_count_;
	FilesBookmarkList* self;
	GFile* file;
};

struct _Block3Data {
	int _ref_count_;
	FilesBookmarkList* self;
	GList* files;
};

struct _Block4Data {
	int _ref_count_;
	FilesBookmarkList* self;
	GFile* file;
	GString* sb;
};

static gint FilesBookmarkList_private_offset;
static gpointer files_bookmark_list_parent_class = NULL;
static GFile* files_bookmark_list_bookmarks_file;
static GFile* files_bookmark_list_bookmarks_file = NULL;
static FilesBookmarkList* files_bookmark_list_instance;
static FilesBookmarkList* files_bookmark_list_instance = NULL;

static GType files_bookmark_list_job_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static FilesBookmarkList* files_bookmark_list_new (void);
static FilesBookmarkList* files_bookmark_list_construct (GType object_type);
static void files_bookmark_list_set_list (FilesBookmarkList* self,
                                   GList* value);
static void _files_bookmark_unref0_ (gpointer var);
static inline void _g_list_free__files_bookmark_unref0_ (GList* self);
static void files_bookmark_list_load_bookmarks_file (FilesBookmarkList* self);
static void files_bookmark_list_add_special_directories (FilesBookmarkList* self);
static void files_bookmark_list_save_bookmarks_file (FilesBookmarkList* self);
static void files_bookmark_list_append_internal (FilesBookmarkList* self,
                                          FilesBookmark* bookmark);
static void files_bookmark_list_insert_item_internal (FilesBookmarkList* self,
                                               FilesBookmark* bm,
                                               guint index);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda24_ (Block1Data* _data1_,
                  const gchar* uri);
static void ___lambda24__gfunc (gconstpointer data,
                         gpointer self);
static void files_bookmark_list_stop_monitoring_bookmark (FilesBookmarkList* self,
                                                   FilesBookmark* bookmark);
static void files_bookmark_list_start_monitoring_bookmark (FilesBookmarkList* self,
                                                    FilesBookmark* bookmark);
static void files_bookmark_list_schedule_job (FilesBookmarkList* self,
                                       FilesBookmarkListJobType job);
static void files_bookmark_list_process_next_op (FilesBookmarkList* self);
static void files_bookmark_list_load_bookmarks_file_async (FilesBookmarkList* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static GFile* files_bookmark_list_get_bookmarks_file (void);
static void __lambda20_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* res);
static void files_bookmark_list_bookmark_list_from_string (FilesBookmarkList* self,
                                                    const gchar* contents);
static GList* files_bookmark_list_get_gof_file_list (FilesBookmarkList* self);
static void files_bookmark_list_files_ready (FilesBookmarkList* self,
                                      GList* files);
static void _files_bookmark_list_files_ready_filescallwhenreadycall_when_ready_func (GList* files,
                                                                              gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void files_bookmark_list_op_processed_call_back (FilesBookmarkList* self);
static void ___lambda20__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda21_ (Block3Data* _data3_,
                  FilesBookmark* bm);
static void ___lambda21__gfunc (gconstpointer data,
                         gpointer self);
static void _files_bookmark_list_stop_monitoring_bookmark_gfunc (gconstpointer data,
                                                          gpointer self);
static void _files_bookmark_list_start_monitoring_bookmark_gfunc (gconstpointer data,
                                                           gpointer self);
static void files_bookmark_list_save_bookmarks_file_async (FilesBookmarkList* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda22_ (Block4Data* _data4_,
                  FilesBookmark* bookmark);
static void ___lambda22__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda23_ (Block4Data* _data4_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda23__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void files_bookmark_list_bookmarks_file_changed_call_back (FilesBookmarkList* self,
                                                           GFile* file,
                                                           GFile* other_file,
                                                           GFileMonitorEvent event_type);
static void files_bookmark_list_bookmark_in_list_changed_callback (FilesBookmarkList* self,
                                                            FilesBookmark* bookmark);
static void files_bookmark_list_bookmark_in_list_to_be_deleted_callback (FilesBookmarkList* self,
                                                                  FilesBookmark* bookmark);
static void files_bookmark_list_start_monitoring_bookmarks_file (FilesBookmarkList* self);
static void _files_bookmark_list_bookmarks_file_changed_call_back_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                   GFile* file,
                                                                                   GFile* other_file,
                                                                                   GFileMonitorEvent event_type,
                                                                                   gpointer self);
static void files_bookmark_list_stop_monitoring_bookmarks_file (FilesBookmarkList* self);
static void _files_bookmark_list_bookmark_in_list_changed_callback_files_bookmark_contents_changed (FilesBookmark* _sender,
                                                                                             gpointer self);
static void _files_bookmark_list_bookmark_in_list_to_be_deleted_callback_files_bookmark_deleted (FilesBookmark* _sender,
                                                                                          gpointer self);
static void files_bookmark_list_finalize (GObject * obj);
static GType files_bookmark_list_get_type_once (void);
static void _vala_files_bookmark_list_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_files_bookmark_list_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
files_bookmark_list_get_instance_private (FilesBookmarkList* self)
{
	return G_STRUCT_MEMBER_P (self, FilesBookmarkList_private_offset);
}

 G_GNUC_NO_INLINE static GType
files_bookmark_list_job_type_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_BOOKMARK_LIST_JOB_TYPE_LOAD, "FILES_BOOKMARK_LIST_JOB_TYPE_LOAD", "load"}, {FILES_BOOKMARK_LIST_JOB_TYPE_SAVE, "FILES_BOOKMARK_LIST_JOB_TYPE_SAVE", "save"}, {0, NULL, NULL}};
	GType files_bookmark_list_job_type_type_id;
	files_bookmark_list_job_type_type_id = g_enum_register_static ("FilesBookmarkListJobType", values);
	return files_bookmark_list_job_type_type_id;
}

static GType
files_bookmark_list_job_type_get_type (void)
{
	static volatile gsize files_bookmark_list_job_type_type_id__once = 0;
	if (g_once_init_enter (&files_bookmark_list_job_type_type_id__once)) {
		GType files_bookmark_list_job_type_type_id;
		files_bookmark_list_job_type_type_id = files_bookmark_list_job_type_get_type_once ();
		g_once_init_leave (&files_bookmark_list_job_type_type_id__once, files_bookmark_list_job_type_type_id);
	}
	return files_bookmark_list_job_type_type_id__once;
}

static void
_files_bookmark_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (files_bookmark_unref (var), NULL));
}

static inline void
_g_list_free__files_bookmark_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _files_bookmark_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static FilesBookmarkList*
files_bookmark_list_construct (GType object_type)
{
	FilesBookmarkList * self = NULL;
	GList* _tmp0_;
	GQueue* _tmp1_;
	gchar* user_home = NULL;
	gchar* _tmp2_;
	gchar* config_dir = NULL;
	const gchar* _tmp3_;
	gchar* filename = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* file = NULL;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GError* _inner_error0_ = NULL;
	self = (FilesBookmarkList*) g_object_new (object_type, NULL);
	_tmp0_ = NULL;
	files_bookmark_list_set_list (self, _tmp0_);
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (_g_list_free__files_bookmark_unref0_ (_tmp0_), NULL));
	_tmp1_ = g_queue_new ();
	(self->priv->pending_ops == NULL) ? NULL : (self->priv->pending_ops = (g_queue_free (self->priv->pending_ops), NULL));
	self->priv->pending_ops = _tmp1_;
	_tmp2_ = pf_user_utils_get_real_user_home ();
	user_home = _tmp2_;
	_tmp3_ = user_home;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = user_home;
		_tmp5_ = g_build_filename (_tmp4_, ".config", NULL);
		_g_free0 (config_dir);
		config_dir = _tmp5_;
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_get_user_config_dir ();
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (config_dir);
		config_dir = _tmp7_;
	}
	_tmp8_ = config_dir;
	_tmp9_ = g_build_filename (_tmp8_, "gtk-3.0", "bookmarks", NULL, NULL);
	filename = _tmp9_;
	_tmp10_ = filename;
	_tmp11_ = g_file_new_for_path (_tmp10_);
	file = _tmp11_;
	_tmp12_ = file;
	if (!g_file_query_exists (_tmp12_, NULL)) {
		gchar* old_filename = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		GFile* old_file = NULL;
		const gchar* _tmp25_;
		GFile* _tmp26_;
		GFile* _tmp27_;
		{
			GFile* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			_tmp13_ = file;
			_tmp14_ = g_file_get_parent (_tmp13_);
			_tmp15_ = _tmp14_;
			g_file_make_directory_with_parents (_tmp15_, NULL, &_inner_error0_);
			_g_object_unref0 (_tmp15_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = _error_;
			_tmp17_ = _tmp16_->message;
			g_warning ("BookmarkList.vala:74: Could not create bookmarks directory: %s", _tmp17_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (filename);
			_g_free0 (config_dir);
			_g_free0 (user_home);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			GFile* _tmp18_;
			GFileOutputStream* _tmp19_;
			GFileOutputStream* _tmp20_;
			_tmp18_ = file;
			_tmp19_ = g_file_create (_tmp18_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			_tmp20_ = _tmp19_;
			_g_object_unref0 (_tmp20_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp21_;
			const gchar* _tmp22_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp21_ = _error_;
			_tmp22_ = _tmp21_->message;
			g_critical ("BookmarkList.vala:81: Could not create bookmarks file: %s", _tmp22_);
			_g_error_free0 (_error_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (filename);
			_g_free0 (config_dir);
			_g_free0 (user_home);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp23_ = g_get_home_dir ();
		_tmp24_ = g_build_filename (_tmp23_, ".gtk-bookmarks", NULL, NULL);
		old_filename = _tmp24_;
		_tmp25_ = old_filename;
		_tmp26_ = g_file_new_for_path (_tmp25_);
		old_file = _tmp26_;
		_tmp27_ = old_file;
		if (g_file_query_exists (_tmp27_, NULL)) {
			GFile* _tmp28_;
			GFile* _tmp29_;
			GFile* _tmp30_;
			GFile* _tmp31_;
			_tmp28_ = old_file;
			_tmp29_ = _g_object_ref0 (_tmp28_);
			_g_object_unref0 (files_bookmark_list_bookmarks_file);
			files_bookmark_list_bookmarks_file = _tmp29_;
			files_bookmark_list_load_bookmarks_file (self);
			_tmp30_ = file;
			_tmp31_ = _g_object_ref0 (_tmp30_);
			_g_object_unref0 (files_bookmark_list_bookmarks_file);
			files_bookmark_list_bookmarks_file = _tmp31_;
		} else {
			GFile* _tmp32_;
			GFile* _tmp33_;
			_tmp32_ = file;
			_tmp33_ = _g_object_ref0 (_tmp32_);
			_g_object_unref0 (files_bookmark_list_bookmarks_file);
			files_bookmark_list_bookmarks_file = _tmp33_;
			files_bookmark_list_add_special_directories (self);
		}
		files_bookmark_list_save_bookmarks_file (self);
		_g_object_unref0 (old_file);
		_g_free0 (old_filename);
	} else {
		GFile* _tmp34_;
		GFile* _tmp35_;
		_tmp34_ = file;
		_tmp35_ = _g_object_ref0 (_tmp34_);
		_g_object_unref0 (files_bookmark_list_bookmarks_file);
		files_bookmark_list_bookmarks_file = _tmp35_;
		files_bookmark_list_load_bookmarks_file (self);
	}
	_g_object_unref0 (file);
	_g_free0 (filename);
	_g_free0 (config_dir);
	_g_free0 (user_home);
	return self;
}

static FilesBookmarkList*
files_bookmark_list_new (void)
{
	return files_bookmark_list_construct (FILES_TYPE_BOOKMARK_LIST);
}

static void
files_bookmark_list_add_special_directories (FilesBookmarkList* self)
{
	static const GUserDirectory DIRECTORIES[7] = {G_USER_DIRECTORY_DOCUMENTS, G_USER_DIRECTORY_DOWNLOAD, G_USER_DIRECTORY_MUSIC, G_USER_DIRECTORY_PUBLIC_SHARE, G_USER_DIRECTORY_PICTURES, G_USER_DIRECTORY_TEMPLATES, G_USER_DIRECTORY_VIDEOS};
	g_return_if_fail (self != NULL);
	{
		GUserDirectory* directory_collection = NULL;
		gint directory_collection_length1 = 0;
		gint _directory_collection_size_ = 0;
		gint directory_it = 0;
		directory_collection = DIRECTORIES;
		directory_collection_length1 = G_N_ELEMENTS (DIRECTORIES);
		for (directory_it = 0; directory_it < directory_collection_length1; directory_it = directory_it + 1) {
			GUserDirectory directory = 0;
			directory = directory_collection[directory_it];
			{
				const gchar* dir_s = NULL;
				const gchar* _tmp0_;
				const gchar* _tmp1_;
				_tmp0_ = g_get_user_special_dir (directory);
				dir_s = _tmp0_;
				_tmp1_ = dir_s;
				if (_tmp1_ != NULL) {
					FilesFile* gof_file = NULL;
					const gchar* _tmp2_;
					GFile* _tmp3_;
					GFile* _tmp4_;
					FilesFile* _tmp5_;
					FilesFile* _tmp6_;
					FilesBookmark* bookmark = NULL;
					FilesFile* _tmp7_;
					FilesBookmark* _tmp8_;
					FilesBookmark* _tmp9_;
					_tmp2_ = dir_s;
					_tmp3_ = g_file_new_for_path (_tmp2_);
					_tmp4_ = _tmp3_;
					_tmp5_ = files_file_get (_tmp4_);
					_tmp6_ = _tmp5_;
					_g_object_unref0 (_tmp4_);
					gof_file = _tmp6_;
					_tmp7_ = gof_file;
					_tmp8_ = files_bookmark_new (_tmp7_, "");
					bookmark = _tmp8_;
					_tmp9_ = bookmark;
					files_bookmark_list_append_internal (self, _tmp9_);
					_files_bookmark_unref0 (bookmark);
					_g_object_unref0 (gof_file);
				}
			}
		}
	}
	files_bookmark_list_save_bookmarks_file (self);
}

FilesBookmarkList*
files_bookmark_list_get_instance (void)
{
	FilesBookmarkList* _tmp0_;
	FilesBookmarkList* _tmp2_;
	FilesBookmarkList* _tmp3_;
	FilesBookmarkList* result;
	_tmp0_ = files_bookmark_list_instance;
	if (_tmp0_ == NULL) {
		FilesBookmarkList* _tmp1_;
		_tmp1_ = files_bookmark_list_new ();
		_g_object_unref0 (files_bookmark_list_instance);
		files_bookmark_list_instance = _tmp1_;
	}
	_tmp2_ = files_bookmark_list_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

FilesBookmark*
files_bookmark_list_insert_uri (FilesBookmarkList* self,
                                const gchar* uri,
                                guint index,
                                const gchar* custom_name)
{
	FilesBookmark* bm = NULL;
	FilesBookmark* _tmp0_;
	FilesBookmark* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (custom_name != NULL, NULL);
	_tmp0_ = files_bookmark_new_from_uri (uri, custom_name);
	bm = _tmp0_;
	files_bookmark_list_insert_item_internal (self, bm, index);
	files_bookmark_list_save_bookmarks_file (self);
	result = bm;
	return result;
}

FilesBookmark*
files_bookmark_list_insert_uri_at_end (FilesBookmarkList* self,
                                       const gchar* uri,
                                       const gchar* custom_name)
{
	FilesBookmark* bm = NULL;
	FilesBookmark* _tmp0_;
	FilesBookmark* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (custom_name != NULL, NULL);
	_tmp0_ = files_bookmark_new_from_uri (uri, custom_name);
	bm = _tmp0_;
	files_bookmark_list_append_internal (self, bm);
	files_bookmark_list_save_bookmarks_file (self);
	result = bm;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FilesBookmarkList* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda24_ (Block1Data* _data1_,
             const gchar* uri)
{
	FilesBookmarkList* self;
	FilesBookmark* _tmp0_;
	FilesBookmark* _tmp1_;
	guint _tmp2_;
	self = _data1_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = files_bookmark_new_from_uri (uri, "");
	_tmp1_ = _tmp0_;
	files_bookmark_list_insert_item_internal (self, _tmp1_, _data1_->index);
	_files_bookmark_unref0 (_tmp1_);
	_tmp2_ = _data1_->index;
	_data1_->index = _tmp2_ + 1;
}

static void
___lambda24__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda24_ (self, (const gchar*) data);
}

void
files_bookmark_list_insert_uris (FilesBookmarkList* self,
                                 GList* uris,
                                 guint index)
{
	Block1Data* _data1_;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->index = index;
	_tmp0_ = self->priv->_list;
	if (_data1_->index > g_list_length (_tmp0_)) {
		g_critical ("BookmarkList.vala:154: Bookmarklist: Attempt to insert uri at out of r" \
"ange index");
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	g_list_foreach (uris, ___lambda24__gfunc, _data1_);
	files_bookmark_list_save_bookmarks_file (self);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

gboolean
files_bookmark_list_contains (FilesBookmarkList* self,
                              FilesBookmark* bm)
{
	GList* _tmp0_;
	GCompareFunc _tmp1_;
	GList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bm != NULL, FALSE);
	_tmp0_ = self->priv->_list;
	_tmp1_ = files_bookmark_compare_with;
	_tmp2_ = g_list_find_custom (_tmp0_, bm, _tmp1_);
	result = _tmp2_ != NULL;
	return result;
}

void
files_bookmark_list_delete_item_at (FilesBookmarkList* self,
                                    guint index)
{
	GList* _tmp0_;
	GList* node = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list;
	_vala_assert (index < g_list_length (_tmp0_), "index < list.length ()");
	_tmp1_ = self->priv->_list;
	_tmp2_ = g_list_nth (_tmp1_, index);
	node = _tmp2_;
	_tmp3_ = self->priv->_list;
	files_bookmark_list_set_list (self, g_list_remove_link (_tmp3_, node));
	_tmp4_ = node->data;
	files_bookmark_list_stop_monitoring_bookmark (self, (FilesBookmark*) _tmp4_);
	files_bookmark_list_save_bookmarks_file (self);
}

void
files_bookmark_list_rename_item_with_uri (FilesBookmarkList* self,
                                          const gchar* uri,
                                          const gchar* new_name)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (new_name != NULL);
	_tmp0_ = self->priv->_list;
	{
		GList* bookmark_collection = NULL;
		GList* bookmark_it = NULL;
		bookmark_collection = _tmp0_;
		for (bookmark_it = bookmark_collection; bookmark_it != NULL; bookmark_it = bookmark_it->next) {
			FilesBookmark* bookmark = NULL;
			bookmark = (FilesBookmark*) bookmark_it->data;
			{
				FilesBookmark* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp1_ = bookmark;
				_tmp2_ = files_bookmark_get_uri (_tmp1_);
				_tmp3_ = _tmp2_;
				if (g_strcmp0 (uri, _tmp3_) == 0) {
					gchar* _tmp4_;
					gchar* _tmp5_;
					gboolean _tmp6_;
					_tmp4_ = g_path_get_basename (uri);
					_tmp5_ = _tmp4_;
					_tmp6_ = g_strcmp0 (new_name, _tmp5_) == 0;
					_g_free0 (_tmp5_);
					if (_tmp6_) {
						FilesBookmark* _tmp7_;
						_tmp7_ = bookmark;
						files_bookmark_set_custom_name (_tmp7_, "");
					} else {
						FilesBookmark* _tmp8_;
						_tmp8_ = bookmark;
						files_bookmark_set_custom_name (_tmp8_, new_name);
					}
					files_bookmark_list_save_bookmarks_file (self);
					return;
				}
			}
		}
	}
}

void
files_bookmark_list_delete_items_with_uri (FilesBookmarkList* self,
                                           const gchar* uri)
{
	gboolean list_changed = FALSE;
	GList* node = NULL;
	GList* _tmp0_;
	GList* next = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	list_changed = FALSE;
	_tmp0_ = self->priv->_list;
	node = _tmp0_;
	_tmp1_ = node;
	_tmp2_ = _tmp1_->next;
	next = _tmp2_;
	{
		GList* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->_list;
		node = _tmp3_;
		_tmp4_ = TRUE;
		while (TRUE) {
			GList* _tmp6_;
			GList* _tmp7_;
			GList* _tmp8_;
			GList* _tmp9_;
			gconstpointer _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			if (!_tmp4_) {
				GList* _tmp5_;
				_tmp5_ = next;
				node = _tmp5_;
			}
			_tmp4_ = FALSE;
			_tmp6_ = node;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = node;
			_tmp8_ = _tmp7_->next;
			next = _tmp8_;
			_tmp9_ = node;
			_tmp10_ = _tmp9_->data;
			_tmp11_ = files_bookmark_get_uri ((FilesBookmark*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 (uri, _tmp12_) == 0) {
				GList* _tmp13_;
				GList* _tmp14_;
				GList* _tmp15_;
				gconstpointer _tmp16_;
				_tmp13_ = self->priv->_list;
				_tmp14_ = node;
				files_bookmark_list_set_list (self, g_list_remove_link (_tmp13_, _tmp14_));
				_tmp15_ = node;
				_tmp16_ = _tmp15_->data;
				files_bookmark_list_stop_monitoring_bookmark (self, (FilesBookmark*) _tmp16_);
				list_changed = TRUE;
			}
		}
	}
	if (list_changed) {
		files_bookmark_list_save_bookmarks_file (self);
	}
}

guint
files_bookmark_list_length (FilesBookmarkList* self)
{
	GList* _tmp0_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_list;
	result = g_list_length (_tmp0_);
	return result;
}

FilesBookmark*
files_bookmark_list_item_at (FilesBookmarkList* self,
                             guint index)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	FilesBookmark* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_list;
	_vala_assert (index < g_list_length (_tmp0_), "index < list.length ()");
	_tmp1_ = self->priv->_list;
	_tmp2_ = g_list_nth_data (_tmp1_, index);
	result = (FilesBookmark*) _tmp2_;
	return result;
}

static gpointer
_files_bookmark_ref0 (gpointer self)
{
	return self ? files_bookmark_ref (self) : NULL;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

void
files_bookmark_list_move_item_uri (FilesBookmarkList* self,
                                   const gchar* uri,
                                   gint step)
{
	gboolean list_changed = FALSE;
	gint index = 0;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	list_changed = FALSE;
	index = 0;
	_tmp0_ = self->priv->_list;
	{
		GList* bm_collection = NULL;
		GList* bm_it = NULL;
		bm_collection = _tmp0_;
		for (bm_it = bm_collection; bm_it != NULL; bm_it = bm_it->next) {
			FilesBookmark* _tmp1_;
			FilesBookmark* bm = NULL;
			_tmp1_ = _files_bookmark_ref0 ((FilesBookmark*) bm_it->data);
			bm = _tmp1_;
			{
				FilesBookmark* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				gint _tmp10_;
				_tmp2_ = bm;
				_tmp3_ = files_bookmark_get_uri (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (uri, _tmp4_) == 0) {
					GList* _tmp5_;
					FilesBookmark* _tmp6_;
					GList* _tmp7_;
					FilesBookmark* _tmp8_;
					FilesBookmark* _tmp9_;
					_tmp5_ = self->priv->_list;
					_tmp6_ = bm;
					files_bookmark_list_set_list (self, vala_g_list_remove_full (_tmp5_, _tmp6_, _files_bookmark_unref0_));
					_tmp7_ = self->priv->_list;
					_tmp8_ = bm;
					_tmp9_ = _files_bookmark_ref0 (_tmp8_);
					files_bookmark_list_set_list (self, g_list_insert (_tmp7_, _tmp9_, index + step));
					list_changed = TRUE;
					_files_bookmark_unref0 (bm);
					break;
				}
				_tmp10_ = index;
				index = _tmp10_ + 1;
				_files_bookmark_unref0 (bm);
			}
		}
	}
	if (list_changed) {
		files_bookmark_list_save_bookmarks_file (self);
	}
}

static void
files_bookmark_list_append_internal (FilesBookmarkList* self,
                                     FilesBookmark* bookmark)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	files_bookmark_list_insert_item_internal (self, bookmark, (guint) -1);
}

static void
files_bookmark_list_insert_item_internal (FilesBookmarkList* self,
                                          FilesBookmark* bm,
                                          guint index)
{
	gchar* path = NULL;
	FilesFile* _tmp0_;
	FilesFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	GList* _tmp11_;
	FilesBookmark* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	if (files_bookmark_list_contains (self, bm)) {
		return;
	}
	_tmp0_ = files_bookmark_get_gof_file (bm);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_file_get_location (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_path (_tmp3_);
	path = _tmp4_;
	_tmp6_ = path;
	_tmp7_ = pf_user_utils_get_real_user_home ();
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp6_, _tmp8_) == 0;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = path;
		_tmp5_ = g_strcmp0 (_tmp10_, G_DIR_SEPARATOR_S) == 0;
	}
	if (_tmp5_) {
		_g_free0 (path);
		return;
	}
	_tmp11_ = self->priv->_list;
	_tmp12_ = _files_bookmark_ref0 (bm);
	files_bookmark_list_set_list (self, g_list_insert (_tmp11_, _tmp12_, (gint) index));
	files_bookmark_list_start_monitoring_bookmark (self, bm);
	_g_free0 (path);
}

static void
files_bookmark_list_load_bookmarks_file (FilesBookmarkList* self)
{
	g_return_if_fail (self != NULL);
	files_bookmark_list_schedule_job (self, FILES_BOOKMARK_LIST_JOB_TYPE_LOAD);
}

static void
files_bookmark_list_save_bookmarks_file (FilesBookmarkList* self)
{
	g_return_if_fail (self != NULL);
	files_bookmark_list_schedule_job (self, FILES_BOOKMARK_LIST_JOB_TYPE_SAVE);
}

static void
files_bookmark_list_schedule_job (FilesBookmarkList* self,
                                  FilesBookmarkListJobType job)
{
	GQueue* _tmp0_;
	GQueue* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending_ops;
	g_queue_push_head (_tmp0_, (gpointer) ((gintptr) job));
	_tmp1_ = self->priv->pending_ops;
	if (_tmp1_->length == ((guint) 1)) {
		files_bookmark_list_process_next_op (self);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FilesBookmarkList* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->file);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_files_bookmark_list_files_ready_filescallwhenreadycall_when_ready_func (GList* files,
                                                                         gpointer self)
{
	files_bookmark_list_files_ready ((FilesBookmarkList*) self, files);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
__lambda20_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* res)
{
	FilesBookmarkList* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_ = 0;
		g_file_load_contents_finish (_data2_->file, res, &_tmp0_, &_tmp1_, NULL, &_inner_error0_);
		contents = (g_free (contents), NULL);
		contents = _tmp0_;
		contents_length1 = _tmp1_;
		_contents_size_ = contents_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			contents = (g_free (contents), NULL);
			goto __catch0_g_error;
		}
		if (contents != NULL) {
			GList* _tmp2_;
			GList* _tmp3_;
			FilesCallWhenReady* _tmp4_;
			files_bookmark_list_bookmark_list_from_string (self, (const gchar*) contents);
			_tmp2_ = files_bookmark_list_get_gof_file_list (self);
			_tmp3_ = _tmp2_;
			_tmp4_ = files_call_when_ready_new (_tmp3_, _files_bookmark_list_files_ready_filescallwhenreadycall_when_ready_func, self);
			_g_object_unref0 (self->priv->call_when_ready);
			self->priv->call_when_ready = _tmp4_;
			(_tmp3_ == NULL) ? NULL : (_tmp3_ = (_g_list_free__g_object_unref0_ (_tmp3_), NULL));
			g_signal_emit (self, files_bookmark_list_signals[FILES_BOOKMARK_LIST_LOADED_SIGNAL], 0);
		}
		contents = (g_free (contents), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_critical ("BookmarkList.vala:291: Error loadinging bookmark file %s", _tmp6_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	files_bookmark_list_op_processed_call_back (self);
}

static void
___lambda20__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda20_ (self, source_object, res);
	block2_data_unref (self);
}

static void
files_bookmark_list_load_bookmarks_file_async (FilesBookmarkList* self)
{
	Block2Data* _data2_;
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = files_bookmark_list_get_bookmarks_file ();
	_data2_->file = _tmp0_;
	g_file_load_contents_async (_data2_->file, NULL, ___lambda20__gasync_ready_callback, block2_data_ref (_data2_));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		FilesBookmarkList* self;
		self = _data3_->self;
		(_data3_->files == NULL) ? NULL : (_data3_->files = (_g_list_free__g_object_unref0_ (_data3_->files), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda21_ (Block3Data* _data3_,
             FilesBookmark* bm)
{
	FilesBookmarkList* self;
	FilesFile* _tmp0_;
	FilesFile* _tmp1_;
	FilesFile* _tmp2_;
	self = _data3_->self;
	g_return_if_fail (bm != NULL);
	_tmp0_ = files_bookmark_get_gof_file (bm);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data3_->files = g_list_prepend (_data3_->files, _tmp2_);
}

static void
___lambda21__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda21_ (self, (FilesBookmark*) data);
}

static GList*
files_bookmark_list_get_gof_file_list (FilesBookmarkList* self)
{
	Block3Data* _data3_;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->files = NULL;
	_tmp0_ = self->priv->_list;
	g_list_foreach (_tmp0_, ___lambda21__gfunc, _data3_);
	_tmp1_ = _data3_->files;
	_data3_->files = NULL;
	result = _tmp1_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

static void
files_bookmark_list_files_ready (FilesBookmarkList* self,
                                 GList* files)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->call_when_ready);
	self->priv->call_when_ready = NULL;
}

static void
_files_bookmark_list_stop_monitoring_bookmark_gfunc (gconstpointer data,
                                                     gpointer self)
{
	files_bookmark_list_stop_monitoring_bookmark ((FilesBookmarkList*) self, (FilesBookmark*) data);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_files_bookmark_list_start_monitoring_bookmark_gfunc (gconstpointer data,
                                                      gpointer self)
{
	files_bookmark_list_start_monitoring_bookmark ((FilesBookmarkList*) self, (FilesBookmark*) data);
}

static void
files_bookmark_list_bookmark_list_from_string (FilesBookmarkList* self,
                                               const gchar* contents)
{
	GList* _tmp0_;
	guint count = 0U;
	gboolean change_made = FALSE;
	gchar** lines = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GList* _tmp36_;
	gboolean _tmp37_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	_tmp0_ = self->priv->_list;
	g_list_foreach (_tmp0_, _files_bookmark_list_stop_monitoring_bookmark_gfunc, self);
	count = (guint) 0;
	change_made = FALSE;
	_tmp2_ = _tmp1_ = g_strsplit (contents, "\n", 0);
	lines = _tmp2_;
	lines_length1 = _vala_array_length (_tmp1_);
	_lines_size_ = lines_length1;
	_tmp3_ = lines;
	_tmp3__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp3_;
		line_collection_length1 = _tmp3__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp4_;
			gchar* line = NULL;
			_tmp4_ = g_strdup (line_collection[line_it]);
			line = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp6_;
				gchar** parts = NULL;
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gchar** _tmp10_;
				gint parts_length1;
				gint _parts_size_;
				gchar* uri = NULL;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_ = NULL;
				gchar** _tmp15_;
				gint _tmp15__length1;
				gchar* custom_name = NULL;
				gchar* _tmp18_;
				gboolean _tmp19_ = FALSE;
				const gchar* _tmp20_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				FilesBookmark* _tmp33_;
				FilesBookmark* _tmp34_;
				guint _tmp35_;
				_tmp6_ = line;
				if (string_get (_tmp6_, (glong) 0) == '\0') {
					_tmp5_ = TRUE;
				} else {
					const gchar* _tmp7_;
					_tmp7_ = line;
					_tmp5_ = string_get (_tmp7_, (glong) 0) == ' ';
				}
				if (_tmp5_) {
					_g_free0 (line);
					continue;
				}
				_tmp8_ = line;
				_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 2);
				parts = _tmp10_;
				parts_length1 = _vala_array_length (_tmp9_);
				_parts_size_ = parts_length1;
				_tmp11_ = parts;
				_tmp11__length1 = parts_length1;
				_tmp12_ = _tmp11_[0];
				_tmp13_ = g_strdup (_tmp12_);
				uri = _tmp13_;
				_tmp15_ = parts;
				_tmp15__length1 = parts_length1;
				if (_tmp15__length1 == 2) {
					gchar** _tmp16_;
					gint _tmp16__length1;
					const gchar* _tmp17_;
					_tmp16_ = parts;
					_tmp16__length1 = parts_length1;
					_tmp17_ = _tmp16_[1];
					_tmp14_ = _tmp17_;
				} else {
					_tmp14_ = "";
				}
				_tmp18_ = g_strdup (_tmp14_);
				custom_name = _tmp18_;
				_tmp20_ = custom_name;
				if (g_strcmp0 (_tmp20_, "") != 0) {
					gboolean _tmp21_ = FALSE;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gboolean _tmp25_;
					_tmp22_ = custom_name;
					_tmp23_ = string_strip (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strcmp0 (_tmp24_, "") == 0;
					_g_free0 (_tmp24_);
					if (_tmp25_) {
						_tmp21_ = TRUE;
					} else {
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp26_ = custom_name;
						_tmp27_ = uri;
						_tmp28_ = g_path_get_basename (_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp21_ = g_strcmp0 (_tmp26_, _tmp29_) == 0;
						_g_free0 (_tmp29_);
					}
					_tmp19_ = _tmp21_;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					gchar* _tmp30_;
					_tmp30_ = g_strdup ("");
					_g_free0 (custom_name);
					custom_name = _tmp30_;
					change_made = TRUE;
				}
				_tmp31_ = uri;
				_tmp32_ = custom_name;
				_tmp33_ = files_bookmark_new_from_uri (_tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				files_bookmark_list_append_internal (self, _tmp34_);
				_files_bookmark_unref0 (_tmp34_);
				_tmp35_ = count;
				count = _tmp35_ + 1;
				_g_free0 (custom_name);
				_g_free0 (uri);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	_tmp36_ = self->priv->_list;
	g_list_foreach (_tmp36_, _files_bookmark_list_start_monitoring_bookmark_gfunc, self);
	if (change_made) {
		_tmp37_ = TRUE;
	} else {
		GList* _tmp38_;
		_tmp38_ = self->priv->_list;
		_tmp37_ = g_list_length (_tmp38_) > count;
	}
	if (_tmp37_) {
		files_bookmark_list_save_bookmarks_file (self);
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		FilesBookmarkList* self;
		self = _data4_->self;
		_g_string_free0 (_data4_->sb);
		_g_object_unref0 (_data4_->file);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda22_ (Block4Data* _data4_,
             FilesBookmark* bookmark)
{
	FilesBookmarkList* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	self = _data4_->self;
	g_return_if_fail (bookmark != NULL);
	_tmp0_ = files_bookmark_get_uri (bookmark);
	_tmp1_ = _tmp0_;
	g_string_append (_data4_->sb, _tmp1_);
	_tmp2_ = files_bookmark_get_custom_name (bookmark);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_strip (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "") != 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = files_bookmark_get_custom_name (bookmark);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (" ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		g_string_append (_data4_->sb, _tmp10_);
		_g_free0 (_tmp10_);
	}
	g_string_append (_data4_->sb, "\n");
}

static void
___lambda22__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda22_ (self, (FilesBookmark*) data);
}

static guint8*
g_string_get_data (GString* self,
                   gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	const gchar* _tmp0_;
	gint res_length1;
	gint _res_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->str;
	res = (guint8*) _tmp0_;
	res_length1 = -1;
	_res_size_ = res_length1;
	res_length1 = (gint) self->len;
	_tmp1_ = res;
	_tmp1__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static void
__lambda23_ (Block4Data* _data4_,
             GObject* obj,
             GAsyncResult* res)
{
	FilesBookmarkList* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		g_file_replace_contents_finish (_data4_->file, res, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_signal_emit (self, files_bookmark_list_signals[FILES_BOOKMARK_LIST_CONTENTS_CHANGED_SIGNAL], 0);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = _error_;
		_tmp1_ = _tmp0_->message;
		g_warning ("BookmarkList.vala:369: Error replacing bookmarks file contents %s", _tmp1_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	files_bookmark_list_op_processed_call_back (self);
}

static void
___lambda23__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda23_ (self, source_object, res);
	block4_data_unref (self);
}

static void
files_bookmark_list_save_bookmarks_file_async (FilesBookmarkList* self)
{
	Block4Data* _data4_;
	GFile* _tmp0_;
	GString* _tmp1_;
	GList* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	guint8* _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = files_bookmark_list_get_bookmarks_file ();
	_data4_->file = _tmp0_;
	_tmp1_ = g_string_new ("");
	_data4_->sb = _tmp1_;
	_tmp2_ = self->priv->_list;
	g_list_foreach (_tmp2_, ___lambda22__gfunc, _data4_);
	_tmp3_ = g_string_get_data (_data4_->sb, &_tmp4_);
	_tmp3__length1 = _tmp4_;
	_tmp5_ = _tmp3_;
	_tmp5__length1 = _tmp3__length1;
	g_file_replace_contents_async (_data4_->file, (const char*) _tmp5_, (gsize) _tmp5__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, ___lambda23__gasync_ready_callback, block4_data_ref (_data4_));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static GFile*
files_bookmark_list_get_bookmarks_file (void)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	_tmp0_ = files_bookmark_list_bookmarks_file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
files_bookmark_list_bookmarks_file_changed_call_back (FilesBookmarkList* self,
                                                      GFile* file,
                                                      GFile* other_file,
                                                      GFileMonitorEvent event_type)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (event_type == G_FILE_MONITOR_EVENT_CHANGED) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event_type == G_FILE_MONITOR_EVENT_CREATED;
	}
	if (_tmp0_) {
		files_bookmark_list_load_bookmarks_file (self);
	}
}

static void
files_bookmark_list_bookmark_in_list_changed_callback (FilesBookmarkList* self,
                                                       FilesBookmark* bookmark)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	files_bookmark_list_save_bookmarks_file (self);
}

static void
files_bookmark_list_bookmark_in_list_to_be_deleted_callback (FilesBookmarkList* self,
                                                             FilesBookmark* bookmark)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	_tmp0_ = files_bookmark_get_uri (bookmark);
	_tmp1_ = _tmp0_;
	files_bookmark_list_delete_items_with_uri (self, _tmp1_);
}

static void
_files_bookmark_list_bookmarks_file_changed_call_back_g_file_monitor_changed (GFileMonitor* _sender,
                                                                              GFile* file,
                                                                              GFile* other_file,
                                                                              GFileMonitorEvent event_type,
                                                                              gpointer self)
{
	files_bookmark_list_bookmarks_file_changed_call_back ((FilesBookmarkList*) self, file, other_file, event_type);
}

static void
files_bookmark_list_start_monitoring_bookmarks_file (FilesBookmarkList* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_bookmark_list_get_bookmarks_file ();
	file = _tmp0_;
	{
		GFileMonitor* _tmp1_ = NULL;
		GFileMonitor* _tmp2_;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		_tmp2_ = g_file_monitor (file, G_FILE_MONITOR_SEND_MOVED, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp3_;
		_tmp4_ = self->priv->monitor;
		g_file_monitor_set_rate_limit (_tmp4_, 1000);
		_tmp5_ = self->priv->monitor;
		g_signal_connect_object (_tmp5_, "changed", (GCallback) _files_bookmark_list_bookmarks_file_changed_call_back_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning ("BookmarkList.vala:407: Error starting to monitor bookmarks file: %s", _tmp7_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

static void
files_bookmark_list_stop_monitoring_bookmarks_file (FilesBookmarkList* self)
{
	GFileMonitor* _tmp0_;
	GFileMonitor* _tmp1_;
	GFileMonitor* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->monitor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->monitor;
	g_file_monitor_cancel (_tmp1_);
	_tmp2_ = self->priv->monitor;
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _files_bookmark_list_bookmarks_file_changed_call_back_g_file_monitor_changed, self);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = NULL;
}

static void
_files_bookmark_list_bookmark_in_list_changed_callback_files_bookmark_contents_changed (FilesBookmark* _sender,
                                                                                        gpointer self)
{
	files_bookmark_list_bookmark_in_list_changed_callback ((FilesBookmarkList*) self, _sender);
}

static void
_files_bookmark_list_bookmark_in_list_to_be_deleted_callback_files_bookmark_deleted (FilesBookmark* _sender,
                                                                                     gpointer self)
{
	files_bookmark_list_bookmark_in_list_to_be_deleted_callback ((FilesBookmarkList*) self, _sender);
}

static void
files_bookmark_list_start_monitoring_bookmark (FilesBookmarkList* self,
                                               FilesBookmark* bookmark)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	g_signal_connect_object (bookmark, "contents-changed", (GCallback) _files_bookmark_list_bookmark_in_list_changed_callback_files_bookmark_contents_changed, self, 0);
	g_signal_connect_object (bookmark, "deleted", (GCallback) _files_bookmark_list_bookmark_in_list_to_be_deleted_callback_files_bookmark_deleted, self, 0);
}

static void
files_bookmark_list_stop_monitoring_bookmark (FilesBookmarkList* self,
                                              FilesBookmark* bookmark)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	g_signal_parse_name ("contents-changed", FILES_TYPE_BOOKMARK, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (bookmark, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _files_bookmark_list_bookmark_in_list_changed_callback_files_bookmark_contents_changed, self);
	g_signal_parse_name ("deleted", FILES_TYPE_BOOKMARK, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (bookmark, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _files_bookmark_list_bookmark_in_list_to_be_deleted_callback_files_bookmark_deleted, self);
}

static void
files_bookmark_list_process_next_op (FilesBookmarkList* self)
{
	FilesBookmarkListJobType pending = 0;
	GQueue* _tmp0_;
	gpointer _tmp1_;
	GQueue* _tmp2_;
	GQueue* _tmp3_;
	g_return_if_fail (self != NULL);
	files_bookmark_list_stop_monitoring_bookmarks_file (self);
	_tmp0_ = self->priv->pending_ops;
	_tmp1_ = g_queue_pop_tail (_tmp0_);
	pending = (FilesBookmarkListJobType) ((gintptr) _tmp1_);
	_tmp2_ = self->priv->pending_ops;
	g_queue_clear (_tmp2_);
	_tmp3_ = self->priv->pending_ops;
	g_queue_push_head (_tmp3_, (gpointer) ((gintptr) pending));
	switch (pending) {
		case FILES_BOOKMARK_LIST_JOB_TYPE_LOAD:
		{
			files_bookmark_list_load_bookmarks_file_async (self);
			break;
		}
		case FILES_BOOKMARK_LIST_JOB_TYPE_SAVE:
		{
			files_bookmark_list_save_bookmarks_file_async (self);
			break;
		}
		default:
		{
			g_warning ("BookmarkList.vala:449: Invalid booklist operation");
			files_bookmark_list_op_processed_call_back (self);
			break;
		}
	}
}

static void
files_bookmark_list_op_processed_call_back (FilesBookmarkList* self)
{
	GQueue* _tmp0_;
	GQueue* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending_ops;
	g_queue_pop_tail (_tmp0_);
	_tmp1_ = self->priv->pending_ops;
	if (!g_queue_is_empty (_tmp1_)) {
		files_bookmark_list_process_next_op (self);
	} else {
		files_bookmark_list_start_monitoring_bookmarks_file (self);
	}
}

GList*
files_bookmark_list_get_list (FilesBookmarkList* self)
{
	GList* result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_list;
	result = _tmp0_;
	return result;
}

static void
files_bookmark_list_set_list (FilesBookmarkList* self,
                              GList* value)
{
	GList* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_bookmark_list_get_list (self);
	if (old_value != value) {
		self->priv->_list = value;
		g_object_notify_by_pspec ((GObject *) self, files_bookmark_list_properties[FILES_BOOKMARK_LIST_LIST_PROPERTY]);
	}
}

static void
files_bookmark_list_class_init (FilesBookmarkListClass * klass,
                                gpointer klass_data)
{
	files_bookmark_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesBookmarkList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_bookmark_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_bookmark_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = files_bookmark_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_BOOKMARK_LIST_LIST_PROPERTY, files_bookmark_list_properties[FILES_BOOKMARK_LIST_LIST_PROPERTY] = g_param_spec_pointer ("list", "list", "list", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	files_bookmark_list_signals[FILES_BOOKMARK_LIST_CONTENTS_CHANGED_SIGNAL] = g_signal_new ("contents-changed", FILES_TYPE_BOOKMARK_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_bookmark_list_signals[FILES_BOOKMARK_LIST_LOADED_SIGNAL] = g_signal_new ("loaded", FILES_TYPE_BOOKMARK_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_bookmark_list_signals[FILES_BOOKMARK_LIST_DELETED_SIGNAL] = g_signal_new ("deleted", FILES_TYPE_BOOKMARK_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
files_bookmark_list_instance_init (FilesBookmarkList * self,
                                   gpointer klass)
{
	self->priv = files_bookmark_list_get_instance_private (self);
}

static void
files_bookmark_list_finalize (GObject * obj)
{
	FilesBookmarkList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_BOOKMARK_LIST, FilesBookmarkList);
	_g_object_unref0 (self->priv->monitor);
	(self->priv->pending_ops == NULL) ? NULL : (self->priv->pending_ops = (g_queue_free (self->priv->pending_ops), NULL));
	_g_object_unref0 (self->priv->call_when_ready);
	G_OBJECT_CLASS (files_bookmark_list_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_bookmark_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesBookmarkListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_bookmark_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesBookmarkList), 0, (GInstanceInitFunc) files_bookmark_list_instance_init, NULL };
	GType files_bookmark_list_type_id;
	files_bookmark_list_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesBookmarkList", &g_define_type_info, 0);
	FilesBookmarkList_private_offset = g_type_add_instance_private (files_bookmark_list_type_id, sizeof (FilesBookmarkListPrivate));
	return files_bookmark_list_type_id;
}

GType
files_bookmark_list_get_type (void)
{
	static volatile gsize files_bookmark_list_type_id__once = 0;
	if (g_once_init_enter (&files_bookmark_list_type_id__once)) {
		GType files_bookmark_list_type_id;
		files_bookmark_list_type_id = files_bookmark_list_get_type_once ();
		g_once_init_leave (&files_bookmark_list_type_id__once, files_bookmark_list_type_id);
	}
	return files_bookmark_list_type_id__once;
}

static void
_vala_files_bookmark_list_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	FilesBookmarkList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_BOOKMARK_LIST, FilesBookmarkList);
	switch (property_id) {
		case FILES_BOOKMARK_LIST_LIST_PROPERTY:
		g_value_set_pointer (value, files_bookmark_list_get_list (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_bookmark_list_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	FilesBookmarkList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_BOOKMARK_LIST, FilesBookmarkList);
	switch (property_id) {
		case FILES_BOOKMARK_LIST_LIST_PROPERTY:
		files_bookmark_list_set_list (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

