// This file is generated by Imported_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef node_inspector_protocol_Runtime_imported_h
#define node_inspector_protocol_Runtime_imported_h

#include "src/node/inspector/protocol/Protocol.h"
#include <v8-inspector-protocol.h>

#ifndef node_inspector_protocol_imported_imported_h

namespace crdtp {

template <typename T>
struct ProtocolTypeTraits<
    std::unique_ptr<T>,
    typename std::enable_if<
        std::is_base_of<v8_inspector::protocol::Exported, T>::value>::type> {
  static bool Deserialize(DeserializerState* state, std::unique_ptr<T>* value) {
    if (state->tokenizer()->TokenTag() != cbor::CBORTokenTag::ENVELOPE) {
      state->RegisterError(Error::CBOR_INVALID_ENVELOPE);
      return false;
    }
    span<uint8_t> env = state->tokenizer()->GetEnvelope();
    auto res = T::fromBinary(env.data(), env.size());
    if (!res) {
      // TODO(caseq): properly plumb an error rather than returning a bogus code.
      state->RegisterError(Error::MESSAGE_MUST_BE_AN_OBJECT);
      return false;
    }
    *value = std::move(res);
    return true;
  }
  static void Serialize(const std::unique_ptr<T>& value, std::vector<uint8_t>* bytes) {
    // Use virtual method, so that outgoing protocol objects could be retained
    // by a pointer to ProtocolObject.
    value->AppendSerialized(bytes);
  }
};

template <typename T>
struct ProtocolTypeTraits<
    T,
    typename std::enable_if<
        std::is_base_of<v8_inspector::protocol::Exported, T>::value>::type> {
  static void Serialize(const T& value, std::vector<uint8_t>* bytes) {
    // Use virtual method, so that outgoing protocol objects could be retained
    // by a pointer to ProtocolObject.
    value.AppendSerialized(bytes);
  }
};

}  // namespace crdtp

#endif  // node_inspector_protocol_imported_imported_h

namespace node {
namespace inspector {
namespace protocol {

using Exported = v8_inspector::protocol::Exported;

#ifndef node_inspector_protocol_imported_imported_h
#define node_inspector_protocol_imported_imported_h

class  ImportedValue : public Value {
public:
    static std::unique_ptr<ImportedValue> fromExported(const Exported* value) {
        return std::unique_ptr<ImportedValue>(new ImportedValue(value));
    }

    void AppendSerialized(std::vector<uint8_t>* output) const override {
        m_exported->AppendSerialized(output);
    }

    std::unique_ptr<Value> clone() const override {
        return std::unique_ptr<Value>(new ImportedValue(m_exported));
    }

private:
    explicit ImportedValue(const Exported* exported) : Value(TypeImported), m_exported(exported) { }
    const Exported* m_exported;
};

#endif // !defined(node_inspector_protocol_imported_imported_h)


template<>
struct ValueConversions<v8_inspector::protocol::Runtime::API::StackTrace> {
    static std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> fromValue(protocol::Value* value, ErrorSupport* errors)
    {
        if (!value) {
            errors->AddError("value expected");
            return nullptr;
        }

        std::vector<uint8_t> binary;
        value->AppendSerialized(&binary);
        auto result = v8_inspector::protocol::Runtime::API::StackTrace::fromBinary(binary.data(), binary.size());
        if (!result)
            errors->AddError("cannot parse");
        return result;
    }

    static std::unique_ptr<protocol::Value> toValue(const v8_inspector::protocol::Runtime::API::StackTrace* exported)
    {
        return ImportedValue::fromExported(exported);
    }
};


} // namespace node
} // namespace inspector
} // namespace protocol

#endif // !defined(node_inspector_protocol_Runtime_imported_h)
