#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0065\x0073";
static constexpr OUStringLiteral langDefaultName = u"\x0053\x0070\x0061\x006e\x0069\x0073\x0068";
static constexpr OUStringLiteral countryID = u"\x0055\x0059";
static constexpr OUStringLiteral countryDefaultName = u"\x0055\x0072\x0075\x0067\x0075\x0061\x0079";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_es_UY(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}


static constexpr OUStringLiteral LC_CTYPE_Unoid = u"\x0067\x0065\x006e\x0065\x0072\x0069\x0063";
static constexpr OUStringLiteral dateSeparator = u"\x002f";
static constexpr OUStringLiteral thousandSeparator = u"\x002e";
static constexpr OUStringLiteral decimalSeparator = u"\x002c";
static constexpr OUStringLiteral decimalSeparatorAlternative = u"";
static constexpr OUStringLiteral timeSeparator = u"\x003a";
static constexpr OUStringLiteral time100SecSeparator = u"\x002c";
static constexpr OUStringLiteral listSeparator = u"\x003b";
static constexpr OUStringLiteral LongDateDayOfWeekSeparator = u"\x002c\x0020";
static constexpr OUStringLiteral LongDateDaySeparator = u"\x0020";
static constexpr OUStringLiteral LongDateMonthSeparator = u"\x0020";
static constexpr OUStringLiteral LongDateYearSeparator = u"\x0020";
static constexpr OUStringLiteral quotationStart = u"\x2018";
static constexpr OUStringLiteral quotationEnd = u"\x2019";
static constexpr OUStringLiteral doubleQuotationStart = u"\x201c";
static constexpr OUStringLiteral doubleQuotationEnd = u"\x201d";
static constexpr OUStringLiteral timeAM = u"\x0061\x002e\x006d\x002e";
static constexpr OUStringLiteral timePM = u"\x0070\x002e\x006d\x002e";
static constexpr OUStringLiteral measurementSystem = u"\x004d\x0065\x0074\x0072\x0069\x0063";

static constexpr OUString LCType[] = {
	LC_CTYPE_Unoid,
	dateSeparator,
	thousandSeparator,
	decimalSeparator,
	timeSeparator,
	time100SecSeparator,
	listSeparator,
	quotationStart,
	quotationEnd,
	doubleQuotationStart,
	doubleQuotationEnd,
	timeAM,
	timePM,
	measurementSystem,
	LongDateDayOfWeekSeparator,
	LongDateDaySeparator,
	LongDateMonthSeparator,
	LongDateYearSeparator,
	decimalSeparatorAlternative
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLocaleItem_es_UY(sal_Int16& count)
{
	count = std::size(LCType);
	return (OUString const *)LCType;
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x24, 0x2d, 0x33, 0x38, 0x30, 0x41, 0x5d, 0x0};
extern OUString const * getAllFormats0_es_AR(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_es_UY(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_es_AR(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_es_AR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_es_UY(sal_Int16& count)
{
	return getDateAcceptancePatterns_es_AR(count);
}
extern const OUString *  getCollatorImplementation_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_es_UY(sal_Int16& count)
{
	return getCollatorImplementation_en_US(count);
}
extern const OUString *  getCollationOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_es_UY(sal_Int16& count)
{
	return getCollationOptions_en_US(count);
}
extern const OUString *  getSearchOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_es_UY(sal_Int16& count)
{
	return getSearchOptions_en_US(count);
}
extern const OUString *  getIndexAlgorithm_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_es_UY(sal_Int16& count)
{
	return getIndexAlgorithm_es_ES(count);
}
extern const OUString *  getUnicodeScripts_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_es_UY(sal_Int16& count)
{
	return getUnicodeScripts_es_ES(count);
}
extern const OUString *  getFollowPageWords_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_es_UY(sal_Int16& count)
{
	return getFollowPageWords_es_ES(count);
}
extern const OUString *  getAllCalendars_es_AR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_es_UY(sal_Int16& count)
{
	return getAllCalendars_es_AR(count);
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0055\x0059\x0055";
static constexpr OUStringLiteral currencySymbol0 = u"\x0024";
static constexpr OUStringLiteral bankSymbol0 = u"\x0055\x0059\x0055";
static constexpr OUStringLiteral currencyName0 = u"\x0050\x0065\x0073\x006f\x0020\x0055\x0072\x0075\x0067\x0075\x0061\x0079\x006f";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_es_UY(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_es_UY(sal_Int16& count)
{
	return getTransliterations_en_US(count);
}
extern const OUString *  getForbiddenCharacters_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_es_UY(sal_Int16& count)
{
	return getForbiddenCharacters_es_ES(count);
}
extern const OUString *  getBreakIteratorRules_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_es_UY(sal_Int16& count)
{
	return getBreakIteratorRules_es_ES(count);
}
extern const OUString *  getReservedWords_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_es_UY(sal_Int16& count)
{
	return getReservedWords_es_ES(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_es_UY(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_en_US(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_es_UY(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_US(nStyles, nLevels, nAttributes);
}
} // extern "C"

