/* parsed class NV91C0 */

#include "nvtypes.h"
#include "cl91c0.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nv91c0_SET_OBJECT {
    uint32_t class_id;
    uint32_t engine_id;
};

static inline void
__NV91C0_SET_OBJECT(uint32_t *val_out, struct nv_nv91c0_SET_OBJECT st)
{
    uint32_t val = 0;
    
    assert(st.class_id < (1ULL << 16));
    val |= st.class_id << 0;
    
    assert(st.engine_id < (1ULL << 5));
    val |= st.engine_id << 16;
    *val_out = val;
}

#define V_NV91C0_SET_OBJECT(val, args...) { \
    struct nv_nv91c0_SET_OBJECT __data = args; \
    __NV91C0_SET_OBJECT(&val, __data); \
}

#define VA_NV91C0_SET_OBJECT V_NV91C0_SET_OBJECT

#define P_NV91C0_SET_OBJECT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_OBJECT(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_OBJECT, nvk_p_ret); \
} while(0)

struct nv_nv91c0_NO_OPERATION {
    uint32_t v;
};

static inline void
__NV91C0_NO_OPERATION(uint32_t *val_out, struct nv_nv91c0_NO_OPERATION st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_NO_OPERATION(val, args...) { \
    struct nv_nv91c0_NO_OPERATION __data = { .v = (args) }; \
    __NV91C0_NO_OPERATION(&val, __data); \
}

#define VA_NV91C0_NO_OPERATION V_NV91C0_NO_OPERATION

#define P_NV91C0_NO_OPERATION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_NO_OPERATION(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_NO_OPERATION, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_NOTIFY_A {
    uint32_t address_upper;
};

static inline void
__NV91C0_SET_NOTIFY_A(uint32_t *val_out, struct nv_nv91c0_SET_NOTIFY_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_NOTIFY_A(val, args...) { \
    struct nv_nv91c0_SET_NOTIFY_A __data = { .address_upper = (args) }; \
    __NV91C0_SET_NOTIFY_A(&val, __data); \
}

#define VA_NV91C0_SET_NOTIFY_A V_NV91C0_SET_NOTIFY_A

#define P_NV91C0_SET_NOTIFY_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_NOTIFY_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_NOTIFY_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_NOTIFY_B {
    uint32_t address_lower;
};

static inline void
__NV91C0_SET_NOTIFY_B(uint32_t *val_out, struct nv_nv91c0_SET_NOTIFY_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NV91C0_SET_NOTIFY_B(val, args...) { \
    struct nv_nv91c0_SET_NOTIFY_B __data = { .address_lower = (args) }; \
    __NV91C0_SET_NOTIFY_B(&val, __data); \
}

#define VA_NV91C0_SET_NOTIFY_B V_NV91C0_SET_NOTIFY_B

#define P_NV91C0_SET_NOTIFY_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_NOTIFY_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_NOTIFY_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_NOTIFY {
    uint32_t type;
};

static inline void
__NV91C0_NOTIFY(uint32_t *val_out, struct nv_nv91c0_NOTIFY st)
{
    uint32_t val = 0;
    
    val |= st.type;
    *val_out = val;
}

#define V_NV91C0_NOTIFY(val, args...) { \
    UNUSED uint32_t TYPE_WRITE_ONLY = NV91C0_NOTIFY_TYPE_WRITE_ONLY; \
    UNUSED uint32_t TYPE_WRITE_THEN_AWAKEN = NV91C0_NOTIFY_TYPE_WRITE_THEN_AWAKEN; \
    struct nv_nv91c0_NOTIFY __data = { .type = (args) }; \
    __NV91C0_NOTIFY(&val, __data); \
}

#define VA_NV91C0_NOTIFY V_NV91C0_NOTIFY

#define P_NV91C0_NOTIFY(push, args...) do { \
    UNUSED uint32_t TYPE_WRITE_ONLY = NV91C0_NOTIFY_TYPE_WRITE_ONLY; \
    UNUSED uint32_t TYPE_WRITE_THEN_AWAKEN = NV91C0_NOTIFY_TYPE_WRITE_THEN_AWAKEN; \
    uint32_t nvk_p_ret; \
    V_NV91C0_NOTIFY(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_NOTIFY, nvk_p_ret); \
} while(0)

struct nv_nv91c0_WAIT_FOR_IDLE {
    uint32_t v;
};

static inline void
__NV91C0_WAIT_FOR_IDLE(uint32_t *val_out, struct nv_nv91c0_WAIT_FOR_IDLE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_WAIT_FOR_IDLE(val, args...) { \
    struct nv_nv91c0_WAIT_FOR_IDLE __data = { .v = (args) }; \
    __NV91C0_WAIT_FOR_IDLE(&val, __data); \
}

#define VA_NV91C0_WAIT_FOR_IDLE V_NV91C0_WAIT_FOR_IDLE

#define P_NV91C0_WAIT_FOR_IDLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_WAIT_FOR_IDLE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_WAIT_FOR_IDLE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_LOAD_MME_INSTRUCTION_RAM_POINTER {
    uint32_t v;
};

static inline void
__NV91C0_LOAD_MME_INSTRUCTION_RAM_POINTER(uint32_t *val_out, struct nv_nv91c0_LOAD_MME_INSTRUCTION_RAM_POINTER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_LOAD_MME_INSTRUCTION_RAM_POINTER(val, args...) { \
    struct nv_nv91c0_LOAD_MME_INSTRUCTION_RAM_POINTER __data = { .v = (args) }; \
    __NV91C0_LOAD_MME_INSTRUCTION_RAM_POINTER(&val, __data); \
}

#define VA_NV91C0_LOAD_MME_INSTRUCTION_RAM_POINTER V_NV91C0_LOAD_MME_INSTRUCTION_RAM_POINTER

#define P_NV91C0_LOAD_MME_INSTRUCTION_RAM_POINTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_LOAD_MME_INSTRUCTION_RAM_POINTER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_LOAD_MME_INSTRUCTION_RAM_POINTER, nvk_p_ret); \
} while(0)

struct nv_nv91c0_LOAD_MME_INSTRUCTION_RAM {
    uint32_t v;
};

static inline void
__NV91C0_LOAD_MME_INSTRUCTION_RAM(uint32_t *val_out, struct nv_nv91c0_LOAD_MME_INSTRUCTION_RAM st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_LOAD_MME_INSTRUCTION_RAM(val, args...) { \
    struct nv_nv91c0_LOAD_MME_INSTRUCTION_RAM __data = { .v = (args) }; \
    __NV91C0_LOAD_MME_INSTRUCTION_RAM(&val, __data); \
}

#define VA_NV91C0_LOAD_MME_INSTRUCTION_RAM V_NV91C0_LOAD_MME_INSTRUCTION_RAM

#define P_NV91C0_LOAD_MME_INSTRUCTION_RAM(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_LOAD_MME_INSTRUCTION_RAM(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_LOAD_MME_INSTRUCTION_RAM, nvk_p_ret); \
} while(0)

struct nv_nv91c0_LOAD_MME_START_ADDRESS_RAM_POINTER {
    uint32_t v;
};

static inline void
__NV91C0_LOAD_MME_START_ADDRESS_RAM_POINTER(uint32_t *val_out, struct nv_nv91c0_LOAD_MME_START_ADDRESS_RAM_POINTER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_LOAD_MME_START_ADDRESS_RAM_POINTER(val, args...) { \
    struct nv_nv91c0_LOAD_MME_START_ADDRESS_RAM_POINTER __data = { .v = (args) }; \
    __NV91C0_LOAD_MME_START_ADDRESS_RAM_POINTER(&val, __data); \
}

#define VA_NV91C0_LOAD_MME_START_ADDRESS_RAM_POINTER V_NV91C0_LOAD_MME_START_ADDRESS_RAM_POINTER

#define P_NV91C0_LOAD_MME_START_ADDRESS_RAM_POINTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_LOAD_MME_START_ADDRESS_RAM_POINTER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_LOAD_MME_START_ADDRESS_RAM_POINTER, nvk_p_ret); \
} while(0)

struct nv_nv91c0_LOAD_MME_START_ADDRESS_RAM {
    uint32_t v;
};

static inline void
__NV91C0_LOAD_MME_START_ADDRESS_RAM(uint32_t *val_out, struct nv_nv91c0_LOAD_MME_START_ADDRESS_RAM st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_LOAD_MME_START_ADDRESS_RAM(val, args...) { \
    struct nv_nv91c0_LOAD_MME_START_ADDRESS_RAM __data = { .v = (args) }; \
    __NV91C0_LOAD_MME_START_ADDRESS_RAM(&val, __data); \
}

#define VA_NV91C0_LOAD_MME_START_ADDRESS_RAM V_NV91C0_LOAD_MME_START_ADDRESS_RAM

#define P_NV91C0_LOAD_MME_START_ADDRESS_RAM(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_LOAD_MME_START_ADDRESS_RAM(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_LOAD_MME_START_ADDRESS_RAM, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_MME_SHADOW_RAM_CONTROL {
    uint32_t mode;
};

static inline void
__NV91C0_SET_MME_SHADOW_RAM_CONTROL(uint32_t *val_out, struct nv_nv91c0_SET_MME_SHADOW_RAM_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NV91C0_SET_MME_SHADOW_RAM_CONTROL(val, args...) { \
    UNUSED uint32_t MODE_METHOD_TRACK = NV91C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK; \
    UNUSED uint32_t MODE_METHOD_TRACK_WITH_FILTER = NV91C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER; \
    UNUSED uint32_t MODE_METHOD_PASSTHROUGH = NV91C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH; \
    UNUSED uint32_t MODE_METHOD_REPLAY = NV91C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY; \
    struct nv_nv91c0_SET_MME_SHADOW_RAM_CONTROL __data = { .mode = (args) }; \
    __NV91C0_SET_MME_SHADOW_RAM_CONTROL(&val, __data); \
}

#define VA_NV91C0_SET_MME_SHADOW_RAM_CONTROL V_NV91C0_SET_MME_SHADOW_RAM_CONTROL

#define P_NV91C0_SET_MME_SHADOW_RAM_CONTROL(push, args...) do { \
    UNUSED uint32_t MODE_METHOD_TRACK = NV91C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK; \
    UNUSED uint32_t MODE_METHOD_TRACK_WITH_FILTER = NV91C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER; \
    UNUSED uint32_t MODE_METHOD_PASSTHROUGH = NV91C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH; \
    UNUSED uint32_t MODE_METHOD_REPLAY = NV91C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_MME_SHADOW_RAM_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_MME_SHADOW_RAM_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_GLOBAL_RENDER_ENABLE_A {
    uint32_t offset_upper;
};

static inline void
__NV91C0_SET_GLOBAL_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nv91c0_SET_GLOBAL_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_GLOBAL_RENDER_ENABLE_A(val, args...) { \
    struct nv_nv91c0_SET_GLOBAL_RENDER_ENABLE_A __data = { .offset_upper = (args) }; \
    __NV91C0_SET_GLOBAL_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NV91C0_SET_GLOBAL_RENDER_ENABLE_A V_NV91C0_SET_GLOBAL_RENDER_ENABLE_A

#define P_NV91C0_SET_GLOBAL_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_GLOBAL_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_GLOBAL_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_GLOBAL_RENDER_ENABLE_B {
    uint32_t offset_lower;
};

static inline void
__NV91C0_SET_GLOBAL_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nv91c0_SET_GLOBAL_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NV91C0_SET_GLOBAL_RENDER_ENABLE_B(val, args...) { \
    struct nv_nv91c0_SET_GLOBAL_RENDER_ENABLE_B __data = { .offset_lower = (args) }; \
    __NV91C0_SET_GLOBAL_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NV91C0_SET_GLOBAL_RENDER_ENABLE_B V_NV91C0_SET_GLOBAL_RENDER_ENABLE_B

#define P_NV91C0_SET_GLOBAL_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_GLOBAL_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_GLOBAL_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_GLOBAL_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NV91C0_SET_GLOBAL_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nv91c0_SET_GLOBAL_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NV91C0_SET_GLOBAL_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NV91C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NV91C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NV91C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NV91C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NV91C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nv91c0_SET_GLOBAL_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NV91C0_SET_GLOBAL_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NV91C0_SET_GLOBAL_RENDER_ENABLE_C V_NV91C0_SET_GLOBAL_RENDER_ENABLE_C

#define P_NV91C0_SET_GLOBAL_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NV91C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NV91C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NV91C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NV91C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NV91C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_GLOBAL_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_GLOBAL_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SEND_GO_IDLE {
    uint32_t v;
};

static inline void
__NV91C0_SEND_GO_IDLE(uint32_t *val_out, struct nv_nv91c0_SEND_GO_IDLE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SEND_GO_IDLE(val, args...) { \
    struct nv_nv91c0_SEND_GO_IDLE __data = { .v = (args) }; \
    __NV91C0_SEND_GO_IDLE(&val, __data); \
}

#define VA_NV91C0_SEND_GO_IDLE V_NV91C0_SEND_GO_IDLE

#define P_NV91C0_SEND_GO_IDLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SEND_GO_IDLE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SEND_GO_IDLE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_PM_TRIGGER {
    uint32_t v;
};

static inline void
__NV91C0_PM_TRIGGER(uint32_t *val_out, struct nv_nv91c0_PM_TRIGGER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_PM_TRIGGER(val, args...) { \
    struct nv_nv91c0_PM_TRIGGER __data = { .v = (args) }; \
    __NV91C0_PM_TRIGGER(&val, __data); \
}

#define VA_NV91C0_PM_TRIGGER V_NV91C0_PM_TRIGGER

#define P_NV91C0_PM_TRIGGER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_PM_TRIGGER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_PM_TRIGGER, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_INSTRUMENTATION_METHOD_HEADER {
    uint32_t v;
};

static inline void
__NV91C0_SET_INSTRUMENTATION_METHOD_HEADER(uint32_t *val_out, struct nv_nv91c0_SET_INSTRUMENTATION_METHOD_HEADER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_INSTRUMENTATION_METHOD_HEADER(val, args...) { \
    struct nv_nv91c0_SET_INSTRUMENTATION_METHOD_HEADER __data = { .v = (args) }; \
    __NV91C0_SET_INSTRUMENTATION_METHOD_HEADER(&val, __data); \
}

#define VA_NV91C0_SET_INSTRUMENTATION_METHOD_HEADER V_NV91C0_SET_INSTRUMENTATION_METHOD_HEADER

#define P_NV91C0_SET_INSTRUMENTATION_METHOD_HEADER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_INSTRUMENTATION_METHOD_HEADER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_INSTRUMENTATION_METHOD_HEADER, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_INSTRUMENTATION_METHOD_DATA {
    uint32_t v;
};

static inline void
__NV91C0_SET_INSTRUMENTATION_METHOD_DATA(uint32_t *val_out, struct nv_nv91c0_SET_INSTRUMENTATION_METHOD_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_INSTRUMENTATION_METHOD_DATA(val, args...) { \
    struct nv_nv91c0_SET_INSTRUMENTATION_METHOD_DATA __data = { .v = (args) }; \
    __NV91C0_SET_INSTRUMENTATION_METHOD_DATA(&val, __data); \
}

#define VA_NV91C0_SET_INSTRUMENTATION_METHOD_DATA V_NV91C0_SET_INSTRUMENTATION_METHOD_DATA

#define P_NV91C0_SET_INSTRUMENTATION_METHOD_DATA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_INSTRUMENTATION_METHOD_DATA(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_INSTRUMENTATION_METHOD_DATA, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE {
    uint32_t v;
};

static inline void
__NV91C0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 24));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE(val, args...) { \
    struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE __data = { .v = (args) }; \
    __NV91C0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE V_NV91C0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE

#define P_NV91C0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_LOCAL_MEMORY_LOW_SIZE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE {
    uint32_t v;
};

static inline void
__NV91C0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 24));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE(val, args...) { \
    struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE __data = { .v = (args) }; \
    __NV91C0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE V_NV91C0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE

#define P_NV91C0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_LOCAL_MEMORY_HIGH_SIZE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE {
    uint32_t v;
};

static inline void
__NV91C0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 21));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE(val, args...) { \
    struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE __data = { .v = (args) }; \
    __NV91C0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE V_NV91C0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE

#define P_NV91C0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_LOCAL_MEMORY_CRS_SIZE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_BINDING_CONTROL_TEXTURE {
    uint32_t max_active_samplers;
    uint32_t max_active_headers;
};

static inline void
__NV91C0_SET_BINDING_CONTROL_TEXTURE(uint32_t *val_out, struct nv_nv91c0_SET_BINDING_CONTROL_TEXTURE st)
{
    uint32_t val = 0;
    
    assert(st.max_active_samplers < (1ULL << 4));
    val |= st.max_active_samplers << 0;
    
    assert(st.max_active_headers < (1ULL << 4));
    val |= st.max_active_headers << 4;
    *val_out = val;
}

#define V_NV91C0_SET_BINDING_CONTROL_TEXTURE(val, args...) { \
    UNUSED uint32_t MAX_ACTIVE_SAMPLERS__1 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__1; \
    UNUSED uint32_t MAX_ACTIVE_SAMPLERS__2 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__2; \
    UNUSED uint32_t MAX_ACTIVE_SAMPLERS__4 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__4; \
    UNUSED uint32_t MAX_ACTIVE_SAMPLERS__8 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__8; \
    UNUSED uint32_t MAX_ACTIVE_SAMPLERS__16 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__16; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__1 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__1; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__2 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__2; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__4 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__4; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__8 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__8; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__16 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__16; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__32 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__32; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__64 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__64; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__128 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__128; \
    struct nv_nv91c0_SET_BINDING_CONTROL_TEXTURE __data = args; \
    __NV91C0_SET_BINDING_CONTROL_TEXTURE(&val, __data); \
}

#define VA_NV91C0_SET_BINDING_CONTROL_TEXTURE V_NV91C0_SET_BINDING_CONTROL_TEXTURE

#define P_NV91C0_SET_BINDING_CONTROL_TEXTURE(push, args...) do { \
    UNUSED uint32_t MAX_ACTIVE_SAMPLERS__1 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__1; \
    UNUSED uint32_t MAX_ACTIVE_SAMPLERS__2 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__2; \
    UNUSED uint32_t MAX_ACTIVE_SAMPLERS__4 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__4; \
    UNUSED uint32_t MAX_ACTIVE_SAMPLERS__8 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__8; \
    UNUSED uint32_t MAX_ACTIVE_SAMPLERS__16 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__16; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__1 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__1; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__2 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__2; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__4 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__4; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__8 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__8; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__16 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__16; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__32 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__32; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__64 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__64; \
    UNUSED uint32_t MAX_ACTIVE_HEADERS__128 = NV91C0_SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__128; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_BINDING_CONTROL_TEXTURE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_BINDING_CONTROL_TEXTURE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_SHARED_MEMORY_WINDOW {
    uint32_t base_address;
};

static inline void
__NV91C0_SET_SHADER_SHARED_MEMORY_WINDOW(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_SHARED_MEMORY_WINDOW st)
{
    uint32_t val = 0;
    
    val |= st.base_address;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_SHARED_MEMORY_WINDOW(val, args...) { \
    struct nv_nv91c0_SET_SHADER_SHARED_MEMORY_WINDOW __data = { .base_address = (args) }; \
    __NV91C0_SET_SHADER_SHARED_MEMORY_WINDOW(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_SHARED_MEMORY_WINDOW V_NV91C0_SET_SHADER_SHARED_MEMORY_WINDOW

#define P_NV91C0_SET_SHADER_SHARED_MEMORY_WINDOW(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_SHARED_MEMORY_WINDOW(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_SHARED_MEMORY_WINDOW, nvk_p_ret); \
} while(0)

struct nv_nv91c0_INVALIDATE_SHADER_CACHES {
    uint32_t instruction;
    uint32_t data;
    uint32_t uniform;
    uint32_t constant;
    uint32_t locks;
    uint32_t flush_data;
};

static inline void
__NV91C0_INVALIDATE_SHADER_CACHES(uint32_t *val_out, struct nv_nv91c0_INVALIDATE_SHADER_CACHES st)
{
    uint32_t val = 0;
    
    assert(st.instruction < (1ULL << 1));
    val |= st.instruction << 0;
    
    assert(st.data < (1ULL << 1));
    val |= st.data << 4;
    
    assert(st.uniform < (1ULL << 1));
    val |= st.uniform << 8;
    
    assert(st.constant < (1ULL << 1));
    val |= st.constant << 12;
    
    assert(st.locks < (1ULL << 1));
    val |= st.locks << 1;
    
    assert(st.flush_data < (1ULL << 1));
    val |= st.flush_data << 2;
    *val_out = val;
}

#define V_NV91C0_INVALIDATE_SHADER_CACHES(val, args...) { \
    UNUSED uint32_t INSTRUCTION_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE; \
    UNUSED uint32_t DATA_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_DATA_FALSE; \
    UNUSED uint32_t DATA_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_DATA_TRUE; \
    UNUSED uint32_t UNIFORM_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_UNIFORM_FALSE; \
    UNUSED uint32_t UNIFORM_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_UNIFORM_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE; \
    UNUSED uint32_t LOCKS_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_LOCKS_FALSE; \
    UNUSED uint32_t LOCKS_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_LOCKS_TRUE; \
    UNUSED uint32_t FLUSH_DATA_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE; \
    UNUSED uint32_t FLUSH_DATA_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE; \
    struct nv_nv91c0_INVALIDATE_SHADER_CACHES __data = args; \
    __NV91C0_INVALIDATE_SHADER_CACHES(&val, __data); \
}

#define VA_NV91C0_INVALIDATE_SHADER_CACHES V_NV91C0_INVALIDATE_SHADER_CACHES

#define P_NV91C0_INVALIDATE_SHADER_CACHES(push, args...) do { \
    UNUSED uint32_t INSTRUCTION_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE; \
    UNUSED uint32_t DATA_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_DATA_FALSE; \
    UNUSED uint32_t DATA_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_DATA_TRUE; \
    UNUSED uint32_t UNIFORM_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_UNIFORM_FALSE; \
    UNUSED uint32_t UNIFORM_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_UNIFORM_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE; \
    UNUSED uint32_t LOCKS_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_LOCKS_FALSE; \
    UNUSED uint32_t LOCKS_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_LOCKS_TRUE; \
    UNUSED uint32_t FLUSH_DATA_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE; \
    UNUSED uint32_t FLUSH_DATA_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_INVALIDATE_SHADER_CACHES(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_INVALIDATE_SHADER_CACHES, nvk_p_ret); \
} while(0)

struct nv_nv91c0_BIND_TEXTURE_SAMPLER {
    uint32_t valid;
    uint32_t sampler_slot;
    uint32_t index;
};

static inline void
__NV91C0_BIND_TEXTURE_SAMPLER(uint32_t *val_out, struct nv_nv91c0_BIND_TEXTURE_SAMPLER st)
{
    uint32_t val = 0;
    
    assert(st.valid < (1ULL << 1));
    val |= st.valid << 0;
    
    assert(st.sampler_slot < (1ULL << 8));
    val |= st.sampler_slot << 4;
    
    assert(st.index < (1ULL << 13));
    val |= st.index << 12;
    *val_out = val;
}

#define V_NV91C0_BIND_TEXTURE_SAMPLER(val, args...) { \
    UNUSED uint32_t VALID_FALSE = NV91C0_BIND_TEXTURE_SAMPLER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV91C0_BIND_TEXTURE_SAMPLER_VALID_TRUE; \
    struct nv_nv91c0_BIND_TEXTURE_SAMPLER __data = args; \
    __NV91C0_BIND_TEXTURE_SAMPLER(&val, __data); \
}

#define VA_NV91C0_BIND_TEXTURE_SAMPLER V_NV91C0_BIND_TEXTURE_SAMPLER

#define P_NV91C0_BIND_TEXTURE_SAMPLER(push, args...) do { \
    UNUSED uint32_t VALID_FALSE = NV91C0_BIND_TEXTURE_SAMPLER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV91C0_BIND_TEXTURE_SAMPLER_VALID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_BIND_TEXTURE_SAMPLER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_BIND_TEXTURE_SAMPLER, nvk_p_ret); \
} while(0)

struct nv_nv91c0_BIND_TEXTURE_HEADER {
    uint32_t valid;
    uint32_t texture_slot;
    uint32_t index;
};

static inline void
__NV91C0_BIND_TEXTURE_HEADER(uint32_t *val_out, struct nv_nv91c0_BIND_TEXTURE_HEADER st)
{
    uint32_t val = 0;
    
    assert(st.valid < (1ULL << 1));
    val |= st.valid << 0;
    
    assert(st.texture_slot < (1ULL << 8));
    val |= st.texture_slot << 1;
    
    assert(st.index < (1ULL << 22));
    val |= st.index << 9;
    *val_out = val;
}

#define V_NV91C0_BIND_TEXTURE_HEADER(val, args...) { \
    UNUSED uint32_t VALID_FALSE = NV91C0_BIND_TEXTURE_HEADER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV91C0_BIND_TEXTURE_HEADER_VALID_TRUE; \
    struct nv_nv91c0_BIND_TEXTURE_HEADER __data = args; \
    __NV91C0_BIND_TEXTURE_HEADER(&val, __data); \
}

#define VA_NV91C0_BIND_TEXTURE_HEADER V_NV91C0_BIND_TEXTURE_HEADER

#define P_NV91C0_BIND_TEXTURE_HEADER(push, args...) do { \
    UNUSED uint32_t VALID_FALSE = NV91C0_BIND_TEXTURE_HEADER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV91C0_BIND_TEXTURE_HEADER_VALID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_BIND_TEXTURE_HEADER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_BIND_TEXTURE_HEADER, nvk_p_ret); \
} while(0)

struct nv_nv91c0_BIND_EXTRA_TEXTURE_SAMPLER {
    uint32_t valid;
    uint32_t sampler_slot;
    uint32_t index;
};

static inline void
__NV91C0_BIND_EXTRA_TEXTURE_SAMPLER(uint32_t *val_out, struct nv_nv91c0_BIND_EXTRA_TEXTURE_SAMPLER st)
{
    uint32_t val = 0;
    
    assert(st.valid < (1ULL << 1));
    val |= st.valid << 0;
    
    assert(st.sampler_slot < (1ULL << 8));
    val |= st.sampler_slot << 4;
    
    assert(st.index < (1ULL << 13));
    val |= st.index << 12;
    *val_out = val;
}

#define V_NV91C0_BIND_EXTRA_TEXTURE_SAMPLER(val, args...) { \
    UNUSED uint32_t VALID_FALSE = NV91C0_BIND_EXTRA_TEXTURE_SAMPLER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV91C0_BIND_EXTRA_TEXTURE_SAMPLER_VALID_TRUE; \
    struct nv_nv91c0_BIND_EXTRA_TEXTURE_SAMPLER __data = args; \
    __NV91C0_BIND_EXTRA_TEXTURE_SAMPLER(&val, __data); \
}

#define VA_NV91C0_BIND_EXTRA_TEXTURE_SAMPLER V_NV91C0_BIND_EXTRA_TEXTURE_SAMPLER

#define P_NV91C0_BIND_EXTRA_TEXTURE_SAMPLER(push, args...) do { \
    UNUSED uint32_t VALID_FALSE = NV91C0_BIND_EXTRA_TEXTURE_SAMPLER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV91C0_BIND_EXTRA_TEXTURE_SAMPLER_VALID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_BIND_EXTRA_TEXTURE_SAMPLER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_BIND_EXTRA_TEXTURE_SAMPLER, nvk_p_ret); \
} while(0)

struct nv_nv91c0_BIND_EXTRA_TEXTURE_HEADER {
    uint32_t valid;
    uint32_t texture_slot;
    uint32_t index;
};

static inline void
__NV91C0_BIND_EXTRA_TEXTURE_HEADER(uint32_t *val_out, struct nv_nv91c0_BIND_EXTRA_TEXTURE_HEADER st)
{
    uint32_t val = 0;
    
    assert(st.valid < (1ULL << 1));
    val |= st.valid << 0;
    
    assert(st.texture_slot < (1ULL << 8));
    val |= st.texture_slot << 1;
    
    assert(st.index < (1ULL << 22));
    val |= st.index << 9;
    *val_out = val;
}

#define V_NV91C0_BIND_EXTRA_TEXTURE_HEADER(val, args...) { \
    UNUSED uint32_t VALID_FALSE = NV91C0_BIND_EXTRA_TEXTURE_HEADER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV91C0_BIND_EXTRA_TEXTURE_HEADER_VALID_TRUE; \
    struct nv_nv91c0_BIND_EXTRA_TEXTURE_HEADER __data = args; \
    __NV91C0_BIND_EXTRA_TEXTURE_HEADER(&val, __data); \
}

#define VA_NV91C0_BIND_EXTRA_TEXTURE_HEADER V_NV91C0_BIND_EXTRA_TEXTURE_HEADER

#define P_NV91C0_BIND_EXTRA_TEXTURE_HEADER(push, args...) do { \
    UNUSED uint32_t VALID_FALSE = NV91C0_BIND_EXTRA_TEXTURE_HEADER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV91C0_BIND_EXTRA_TEXTURE_HEADER_VALID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_BIND_EXTRA_TEXTURE_HEADER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_BIND_EXTRA_TEXTURE_HEADER, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CTA_RASTER_SIZE_A {
    uint32_t width;
    uint32_t height;
};

static inline void
__NV91C0_SET_CTA_RASTER_SIZE_A(uint32_t *val_out, struct nv_nv91c0_SET_CTA_RASTER_SIZE_A st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 16));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 16));
    val |= st.height << 16;
    *val_out = val;
}

#define V_NV91C0_SET_CTA_RASTER_SIZE_A(val, args...) { \
    struct nv_nv91c0_SET_CTA_RASTER_SIZE_A __data = args; \
    __NV91C0_SET_CTA_RASTER_SIZE_A(&val, __data); \
}

#define VA_NV91C0_SET_CTA_RASTER_SIZE_A V_NV91C0_SET_CTA_RASTER_SIZE_A

#define P_NV91C0_SET_CTA_RASTER_SIZE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CTA_RASTER_SIZE_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CTA_RASTER_SIZE_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CTA_RASTER_SIZE_B {
    uint32_t depth;
    uint32_t width_upper;
};

static inline void
__NV91C0_SET_CTA_RASTER_SIZE_B(uint32_t *val_out, struct nv_nv91c0_SET_CTA_RASTER_SIZE_B st)
{
    uint32_t val = 0;
    
    assert(st.depth < (1ULL << 16));
    val |= st.depth << 0;
    
    assert(st.width_upper < (1ULL << 16));
    val |= st.width_upper << 16;
    *val_out = val;
}

#define V_NV91C0_SET_CTA_RASTER_SIZE_B(val, args...) { \
    struct nv_nv91c0_SET_CTA_RASTER_SIZE_B __data = args; \
    __NV91C0_SET_CTA_RASTER_SIZE_B(&val, __data); \
}

#define VA_NV91C0_SET_CTA_RASTER_SIZE_B V_NV91C0_SET_CTA_RASTER_SIZE_B

#define P_NV91C0_SET_CTA_RASTER_SIZE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CTA_RASTER_SIZE_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CTA_RASTER_SIZE_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(uint32_t *val_out, struct nv_nv91c0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(val, args...) { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE; \
    struct nv_nv91c0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI __data = args; \
    __NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(&val, __data); \
}

#define VA_NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI V_NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI

#define P_NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_SHARED_MEMORY_SIZE {
    uint32_t v;
};

static inline void
__NV91C0_SET_SHADER_SHARED_MEMORY_SIZE(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_SHARED_MEMORY_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 18));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_SHARED_MEMORY_SIZE(val, args...) { \
    struct nv_nv91c0_SET_SHADER_SHARED_MEMORY_SIZE __data = { .v = (args) }; \
    __NV91C0_SET_SHADER_SHARED_MEMORY_SIZE(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_SHARED_MEMORY_SIZE V_NV91C0_SET_SHADER_SHARED_MEMORY_SIZE

#define P_NV91C0_SET_SHADER_SHARED_MEMORY_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_SHARED_MEMORY_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_SHARED_MEMORY_SIZE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CTA_THREAD_COUNT {
    uint32_t v;
};

static inline void
__NV91C0_SET_CTA_THREAD_COUNT(uint32_t *val_out, struct nv_nv91c0_SET_CTA_THREAD_COUNT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_SET_CTA_THREAD_COUNT(val, args...) { \
    struct nv_nv91c0_SET_CTA_THREAD_COUNT __data = { .v = (args) }; \
    __NV91C0_SET_CTA_THREAD_COUNT(&val, __data); \
}

#define VA_NV91C0_SET_CTA_THREAD_COUNT V_NV91C0_SET_CTA_THREAD_COUNT

#define P_NV91C0_SET_CTA_THREAD_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CTA_THREAD_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CTA_THREAD_COUNT, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CTA_BARRIER_COUNT {
    uint32_t v;
};

static inline void
__NV91C0_SET_CTA_BARRIER_COUNT(uint32_t *val_out, struct nv_nv91c0_SET_CTA_BARRIER_COUNT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_SET_CTA_BARRIER_COUNT(val, args...) { \
    struct nv_nv91c0_SET_CTA_BARRIER_COUNT __data = { .v = (args) }; \
    __NV91C0_SET_CTA_BARRIER_COUNT(&val, __data); \
}

#define VA_NV91C0_SET_CTA_BARRIER_COUNT V_NV91C0_SET_CTA_BARRIER_COUNT

#define P_NV91C0_SET_CTA_BARRIER_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CTA_BARRIER_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CTA_BARRIER_COUNT, nvk_p_ret); \
} while(0)

struct nv_nv91c0_TEST_FOR_COMPUTE {
    uint32_t v;
};

static inline void
__NV91C0_TEST_FOR_COMPUTE(uint32_t *val_out, struct nv_nv91c0_TEST_FOR_COMPUTE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_TEST_FOR_COMPUTE(val, args...) { \
    struct nv_nv91c0_TEST_FOR_COMPUTE __data = { .v = (args) }; \
    __NV91C0_TEST_FOR_COMPUTE(&val, __data); \
}

#define VA_NV91C0_TEST_FOR_COMPUTE V_NV91C0_TEST_FOR_COMPUTE

#define P_NV91C0_TEST_FOR_COMPUTE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_TEST_FOR_COMPUTE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_TEST_FOR_COMPUTE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_BEGIN_GRID {
    uint32_t v;
};

static inline void
__NV91C0_BEGIN_GRID(uint32_t *val_out, struct nv_nv91c0_BEGIN_GRID st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_BEGIN_GRID(val, args...) { \
    struct nv_nv91c0_BEGIN_GRID __data = { .v = (args) }; \
    __NV91C0_BEGIN_GRID(&val, __data); \
}

#define VA_NV91C0_BEGIN_GRID V_NV91C0_BEGIN_GRID

#define P_NV91C0_BEGIN_GRID(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_BEGIN_GRID(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_BEGIN_GRID, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_WORK_DISTRIBUTION {
    uint32_t max_batch_size;
    uint32_t fixed_mode;
    uint32_t max_standby_ctas;
};

static inline void
__NV91C0_SET_WORK_DISTRIBUTION(uint32_t *val_out, struct nv_nv91c0_SET_WORK_DISTRIBUTION st)
{
    uint32_t val = 0;
    
    assert(st.max_batch_size < (1ULL << 4));
    val |= st.max_batch_size << 13;
    
    assert(st.fixed_mode < (1ULL << 1));
    val |= st.fixed_mode << 4;
    
    assert(st.max_standby_ctas < (1ULL << 8));
    val |= st.max_standby_ctas << 5;
    *val_out = val;
}

#define V_NV91C0_SET_WORK_DISTRIBUTION(val, args...) { \
    UNUSED uint32_t FIXED_MODE_FALSE = NV91C0_SET_WORK_DISTRIBUTION_FIXED_MODE_FALSE; \
    UNUSED uint32_t FIXED_MODE_TRUE = NV91C0_SET_WORK_DISTRIBUTION_FIXED_MODE_TRUE; \
    struct nv_nv91c0_SET_WORK_DISTRIBUTION __data = args; \
    __NV91C0_SET_WORK_DISTRIBUTION(&val, __data); \
}

#define VA_NV91C0_SET_WORK_DISTRIBUTION V_NV91C0_SET_WORK_DISTRIBUTION

#define P_NV91C0_SET_WORK_DISTRIBUTION(push, args...) do { \
    UNUSED uint32_t FIXED_MODE_FALSE = NV91C0_SET_WORK_DISTRIBUTION_FIXED_MODE_FALSE; \
    UNUSED uint32_t FIXED_MODE_TRUE = NV91C0_SET_WORK_DISTRIBUTION_FIXED_MODE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_WORK_DISTRIBUTION(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_WORK_DISTRIBUTION, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CTA_REGISTER_COUNT {
    uint32_t v;
};

static inline void
__NV91C0_SET_CTA_REGISTER_COUNT(uint32_t *val_out, struct nv_nv91c0_SET_CTA_REGISTER_COUNT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_SET_CTA_REGISTER_COUNT(val, args...) { \
    struct nv_nv91c0_SET_CTA_REGISTER_COUNT __data = { .v = (args) }; \
    __NV91C0_SET_CTA_REGISTER_COUNT(&val, __data); \
}

#define VA_NV91C0_SET_CTA_REGISTER_COUNT V_NV91C0_SET_CTA_REGISTER_COUNT

#define P_NV91C0_SET_CTA_REGISTER_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CTA_REGISTER_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CTA_REGISTER_COUNT, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_GA_TO_VA_MAPPING_MODE {
    uint32_t v;
};

static inline void
__NV91C0_SET_GA_TO_VA_MAPPING_MODE(uint32_t *val_out, struct nv_nv91c0_SET_GA_TO_VA_MAPPING_MODE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_SET_GA_TO_VA_MAPPING_MODE(val, args...) { \
    UNUSED uint32_t V_DISABLE = NV91C0_SET_GA_TO_VA_MAPPING_MODE_V_DISABLE; \
    UNUSED uint32_t V_ENABLE = NV91C0_SET_GA_TO_VA_MAPPING_MODE_V_ENABLE; \
    struct nv_nv91c0_SET_GA_TO_VA_MAPPING_MODE __data = { .v = (args) }; \
    __NV91C0_SET_GA_TO_VA_MAPPING_MODE(&val, __data); \
}

#define VA_NV91C0_SET_GA_TO_VA_MAPPING_MODE V_NV91C0_SET_GA_TO_VA_MAPPING_MODE

#define P_NV91C0_SET_GA_TO_VA_MAPPING_MODE(push, args...) do { \
    UNUSED uint32_t V_DISABLE = NV91C0_SET_GA_TO_VA_MAPPING_MODE_V_DISABLE; \
    UNUSED uint32_t V_ENABLE = NV91C0_SET_GA_TO_VA_MAPPING_MODE_V_ENABLE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_GA_TO_VA_MAPPING_MODE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_GA_TO_VA_MAPPING_MODE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_LOAD_GA_TO_VA_MAPPING_ENTRY {
    uint32_t virtual_address_upper;
    uint32_t generic_address_upper;
    uint32_t read_enable;
    uint32_t write_enable;
};

static inline void
__NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY(uint32_t *val_out, struct nv_nv91c0_LOAD_GA_TO_VA_MAPPING_ENTRY st)
{
    uint32_t val = 0;
    
    assert(st.virtual_address_upper < (1ULL << 8));
    val |= st.virtual_address_upper << 0;
    
    assert(st.generic_address_upper < (1ULL << 8));
    val |= st.generic_address_upper << 16;
    
    assert(st.read_enable < (1ULL << 1));
    val |= st.read_enable << 30;
    
    assert(st.write_enable < (1ULL << 1));
    val |= st.write_enable << 31;
    *val_out = val;
}

#define V_NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY(val, args...) { \
    UNUSED uint32_t READ_ENABLE_FALSE = NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY_READ_ENABLE_FALSE; \
    UNUSED uint32_t READ_ENABLE_TRUE = NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY_READ_ENABLE_TRUE; \
    UNUSED uint32_t WRITE_ENABLE_FALSE = NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY_WRITE_ENABLE_FALSE; \
    UNUSED uint32_t WRITE_ENABLE_TRUE = NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY_WRITE_ENABLE_TRUE; \
    struct nv_nv91c0_LOAD_GA_TO_VA_MAPPING_ENTRY __data = args; \
    __NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY(&val, __data); \
}

#define VA_NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY V_NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY

#define P_NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY(push, args...) do { \
    UNUSED uint32_t READ_ENABLE_FALSE = NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY_READ_ENABLE_FALSE; \
    UNUSED uint32_t READ_ENABLE_TRUE = NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY_READ_ENABLE_TRUE; \
    UNUSED uint32_t WRITE_ENABLE_FALSE = NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY_WRITE_ENABLE_FALSE; \
    UNUSED uint32_t WRITE_ENABLE_TRUE = NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY_WRITE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_LOAD_GA_TO_VA_MAPPING_ENTRY, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_TEX_HEADER_EXTENDED_DIMENSIONS {
    uint32_t enable;
};

static inline void
__NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS(uint32_t *val_out, struct nv_nv91c0_SET_TEX_HEADER_EXTENDED_DIMENSIONS st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS_ENABLE_TRUE; \
    struct nv_nv91c0_SET_TEX_HEADER_EXTENDED_DIMENSIONS __data = { .enable = (args) }; \
    __NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS(&val, __data); \
}

#define VA_NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS V_NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS

#define P_NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_L1_CONFIGURATION {
    uint32_t directly_addressable_memory;
};

static inline void
__NV91C0_SET_L1_CONFIGURATION(uint32_t *val_out, struct nv_nv91c0_SET_L1_CONFIGURATION st)
{
    uint32_t val = 0;
    
    assert(st.directly_addressable_memory < (1ULL << 3));
    val |= st.directly_addressable_memory << 0;
    *val_out = val;
}

#define V_NV91C0_SET_L1_CONFIGURATION(val, args...) { \
    UNUSED uint32_t DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB = NV91C0_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB; \
    UNUSED uint32_t DIRECTLY_ADDRESSABLE_MEMORY_SIZE_32KB = NV91C0_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_32KB; \
    UNUSED uint32_t DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB = NV91C0_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB; \
    struct nv_nv91c0_SET_L1_CONFIGURATION __data = { .directly_addressable_memory = (args) }; \
    __NV91C0_SET_L1_CONFIGURATION(&val, __data); \
}

#define VA_NV91C0_SET_L1_CONFIGURATION V_NV91C0_SET_L1_CONFIGURATION

#define P_NV91C0_SET_L1_CONFIGURATION(push, args...) do { \
    UNUSED uint32_t DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB = NV91C0_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB; \
    UNUSED uint32_t DIRECTLY_ADDRESSABLE_MEMORY_SIZE_32KB = NV91C0_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_32KB; \
    UNUSED uint32_t DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB = NV91C0_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_L1_CONFIGURATION(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_L1_CONFIGURATION, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_RENDER_ENABLE_CONTROL {
    uint32_t conditional_load_constant_buffer;
};

static inline void
__NV91C0_SET_RENDER_ENABLE_CONTROL(uint32_t *val_out, struct nv_nv91c0_SET_RENDER_ENABLE_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.conditional_load_constant_buffer < (1ULL << 1));
    val |= st.conditional_load_constant_buffer << 0;
    *val_out = val;
}

#define V_NV91C0_SET_RENDER_ENABLE_CONTROL(val, args...) { \
    UNUSED uint32_t CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE = NV91C0_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE; \
    UNUSED uint32_t CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE = NV91C0_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE; \
    struct nv_nv91c0_SET_RENDER_ENABLE_CONTROL __data = { .conditional_load_constant_buffer = (args) }; \
    __NV91C0_SET_RENDER_ENABLE_CONTROL(&val, __data); \
}

#define VA_NV91C0_SET_RENDER_ENABLE_CONTROL V_NV91C0_SET_RENDER_ENABLE_CONTROL

#define P_NV91C0_SET_RENDER_ENABLE_CONTROL(push, args...) do { \
    UNUSED uint32_t CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE = NV91C0_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE; \
    UNUSED uint32_t CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE = NV91C0_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_RENDER_ENABLE_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_RENDER_ENABLE_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nv91c0_WAIT_REF_COUNT {
    uint32_t ref_cnt;
    uint32_t flush_sys_mem;
};

static inline void
__NV91C0_WAIT_REF_COUNT(uint32_t *val_out, struct nv_nv91c0_WAIT_REF_COUNT st)
{
    uint32_t val = 0;
    
    assert(st.ref_cnt < (1ULL << 4));
    val |= st.ref_cnt << 8;
    
    assert(st.flush_sys_mem < (1ULL << 1));
    val |= st.flush_sys_mem << 0;
    *val_out = val;
}

#define V_NV91C0_WAIT_REF_COUNT(val, args...) { \
    UNUSED uint32_t FLUSH_SYS_MEM_FALSE = NV91C0_WAIT_REF_COUNT_FLUSH_SYS_MEM_FALSE; \
    UNUSED uint32_t FLUSH_SYS_MEM_TRUE = NV91C0_WAIT_REF_COUNT_FLUSH_SYS_MEM_TRUE; \
    struct nv_nv91c0_WAIT_REF_COUNT __data = args; \
    __NV91C0_WAIT_REF_COUNT(&val, __data); \
}

#define VA_NV91C0_WAIT_REF_COUNT V_NV91C0_WAIT_REF_COUNT

#define P_NV91C0_WAIT_REF_COUNT(push, args...) do { \
    UNUSED uint32_t FLUSH_SYS_MEM_FALSE = NV91C0_WAIT_REF_COUNT_FLUSH_SYS_MEM_FALSE; \
    UNUSED uint32_t FLUSH_SYS_MEM_TRUE = NV91C0_WAIT_REF_COUNT_FLUSH_SYS_MEM_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_WAIT_REF_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_WAIT_REF_COUNT, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_LAUNCH_ID {
    uint32_t ref_cnt;
};

static inline void
__NV91C0_SET_LAUNCH_ID(uint32_t *val_out, struct nv_nv91c0_SET_LAUNCH_ID st)
{
    uint32_t val = 0;
    
    assert(st.ref_cnt < (1ULL << 4));
    val |= st.ref_cnt << 0;
    *val_out = val;
}

#define V_NV91C0_SET_LAUNCH_ID(val, args...) { \
    struct nv_nv91c0_SET_LAUNCH_ID __data = { .ref_cnt = (args) }; \
    __NV91C0_SET_LAUNCH_ID(&val, __data); \
}

#define VA_NV91C0_SET_LAUNCH_ID V_NV91C0_SET_LAUNCH_ID

#define P_NV91C0_SET_LAUNCH_ID(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_LAUNCH_ID(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_LAUNCH_ID, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CTA_THREAD_DIMENSION_A {
    uint32_t d0;
    uint32_t d1;
};

static inline void
__NV91C0_SET_CTA_THREAD_DIMENSION_A(uint32_t *val_out, struct nv_nv91c0_SET_CTA_THREAD_DIMENSION_A st)
{
    uint32_t val = 0;
    
    assert(st.d0 < (1ULL << 16));
    val |= st.d0 << 0;
    
    assert(st.d1 < (1ULL << 16));
    val |= st.d1 << 16;
    *val_out = val;
}

#define V_NV91C0_SET_CTA_THREAD_DIMENSION_A(val, args...) { \
    struct nv_nv91c0_SET_CTA_THREAD_DIMENSION_A __data = args; \
    __NV91C0_SET_CTA_THREAD_DIMENSION_A(&val, __data); \
}

#define VA_NV91C0_SET_CTA_THREAD_DIMENSION_A V_NV91C0_SET_CTA_THREAD_DIMENSION_A

#define P_NV91C0_SET_CTA_THREAD_DIMENSION_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CTA_THREAD_DIMENSION_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CTA_THREAD_DIMENSION_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CTA_THREAD_DIMENSION_B {
    uint32_t d2;
};

static inline void
__NV91C0_SET_CTA_THREAD_DIMENSION_B(uint32_t *val_out, struct nv_nv91c0_SET_CTA_THREAD_DIMENSION_B st)
{
    uint32_t val = 0;
    
    assert(st.d2 < (1ULL << 16));
    val |= st.d2 << 0;
    *val_out = val;
}

#define V_NV91C0_SET_CTA_THREAD_DIMENSION_B(val, args...) { \
    struct nv_nv91c0_SET_CTA_THREAD_DIMENSION_B __data = { .d2 = (args) }; \
    __NV91C0_SET_CTA_THREAD_DIMENSION_B(&val, __data); \
}

#define VA_NV91C0_SET_CTA_THREAD_DIMENSION_B V_NV91C0_SET_CTA_THREAD_DIMENSION_B

#define P_NV91C0_SET_CTA_THREAD_DIMENSION_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CTA_THREAD_DIMENSION_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CTA_THREAD_DIMENSION_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CTA_PROGRAM_START {
    uint32_t offset;
};

static inline void
__NV91C0_SET_CTA_PROGRAM_START(uint32_t *val_out, struct nv_nv91c0_SET_CTA_PROGRAM_START st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NV91C0_SET_CTA_PROGRAM_START(val, args...) { \
    struct nv_nv91c0_SET_CTA_PROGRAM_START __data = { .offset = (args) }; \
    __NV91C0_SET_CTA_PROGRAM_START(&val, __data); \
}

#define VA_NV91C0_SET_CTA_PROGRAM_START V_NV91C0_SET_CTA_PROGRAM_START

#define P_NV91C0_SET_CTA_PROGRAM_START(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CTA_PROGRAM_START(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CTA_PROGRAM_START, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON00 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON00(uint32_t *val_out, struct nv_nv91c0_SET_FALCON00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON00(val, args...) { \
    struct nv_nv91c0_SET_FALCON00 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON00(&val, __data); \
}

#define VA_NV91C0_SET_FALCON00 V_NV91C0_SET_FALCON00

#define P_NV91C0_SET_FALCON00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON00(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON00, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON01 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON01(uint32_t *val_out, struct nv_nv91c0_SET_FALCON01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON01(val, args...) { \
    struct nv_nv91c0_SET_FALCON01 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON01(&val, __data); \
}

#define VA_NV91C0_SET_FALCON01 V_NV91C0_SET_FALCON01

#define P_NV91C0_SET_FALCON01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON01(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON01, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON02 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON02(uint32_t *val_out, struct nv_nv91c0_SET_FALCON02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON02(val, args...) { \
    struct nv_nv91c0_SET_FALCON02 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON02(&val, __data); \
}

#define VA_NV91C0_SET_FALCON02 V_NV91C0_SET_FALCON02

#define P_NV91C0_SET_FALCON02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON02(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON02, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON03 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON03(uint32_t *val_out, struct nv_nv91c0_SET_FALCON03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON03(val, args...) { \
    struct nv_nv91c0_SET_FALCON03 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON03(&val, __data); \
}

#define VA_NV91C0_SET_FALCON03 V_NV91C0_SET_FALCON03

#define P_NV91C0_SET_FALCON03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON03(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON03, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON04 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON04(uint32_t *val_out, struct nv_nv91c0_SET_FALCON04 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON04(val, args...) { \
    struct nv_nv91c0_SET_FALCON04 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON04(&val, __data); \
}

#define VA_NV91C0_SET_FALCON04 V_NV91C0_SET_FALCON04

#define P_NV91C0_SET_FALCON04(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON04(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON04, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON05 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON05(uint32_t *val_out, struct nv_nv91c0_SET_FALCON05 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON05(val, args...) { \
    struct nv_nv91c0_SET_FALCON05 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON05(&val, __data); \
}

#define VA_NV91C0_SET_FALCON05 V_NV91C0_SET_FALCON05

#define P_NV91C0_SET_FALCON05(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON05(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON05, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON06 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON06(uint32_t *val_out, struct nv_nv91c0_SET_FALCON06 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON06(val, args...) { \
    struct nv_nv91c0_SET_FALCON06 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON06(&val, __data); \
}

#define VA_NV91C0_SET_FALCON06 V_NV91C0_SET_FALCON06

#define P_NV91C0_SET_FALCON06(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON06(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON06, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON07 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON07(uint32_t *val_out, struct nv_nv91c0_SET_FALCON07 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON07(val, args...) { \
    struct nv_nv91c0_SET_FALCON07 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON07(&val, __data); \
}

#define VA_NV91C0_SET_FALCON07 V_NV91C0_SET_FALCON07

#define P_NV91C0_SET_FALCON07(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON07(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON07, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON08 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON08(uint32_t *val_out, struct nv_nv91c0_SET_FALCON08 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON08(val, args...) { \
    struct nv_nv91c0_SET_FALCON08 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON08(&val, __data); \
}

#define VA_NV91C0_SET_FALCON08 V_NV91C0_SET_FALCON08

#define P_NV91C0_SET_FALCON08(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON08(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON08, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON09 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON09(uint32_t *val_out, struct nv_nv91c0_SET_FALCON09 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON09(val, args...) { \
    struct nv_nv91c0_SET_FALCON09 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON09(&val, __data); \
}

#define VA_NV91C0_SET_FALCON09 V_NV91C0_SET_FALCON09

#define P_NV91C0_SET_FALCON09(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON09(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON09, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON10 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON10(uint32_t *val_out, struct nv_nv91c0_SET_FALCON10 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON10(val, args...) { \
    struct nv_nv91c0_SET_FALCON10 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON10(&val, __data); \
}

#define VA_NV91C0_SET_FALCON10 V_NV91C0_SET_FALCON10

#define P_NV91C0_SET_FALCON10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON10(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON10, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON11 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON11(uint32_t *val_out, struct nv_nv91c0_SET_FALCON11 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON11(val, args...) { \
    struct nv_nv91c0_SET_FALCON11 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON11(&val, __data); \
}

#define VA_NV91C0_SET_FALCON11 V_NV91C0_SET_FALCON11

#define P_NV91C0_SET_FALCON11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON11(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON11, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON12 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON12(uint32_t *val_out, struct nv_nv91c0_SET_FALCON12 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON12(val, args...) { \
    struct nv_nv91c0_SET_FALCON12 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON12(&val, __data); \
}

#define VA_NV91C0_SET_FALCON12 V_NV91C0_SET_FALCON12

#define P_NV91C0_SET_FALCON12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON12(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON12, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON13 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON13(uint32_t *val_out, struct nv_nv91c0_SET_FALCON13 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON13(val, args...) { \
    struct nv_nv91c0_SET_FALCON13 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON13(&val, __data); \
}

#define VA_NV91C0_SET_FALCON13 V_NV91C0_SET_FALCON13

#define P_NV91C0_SET_FALCON13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON13(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON13, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON14 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON14(uint32_t *val_out, struct nv_nv91c0_SET_FALCON14 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON14(val, args...) { \
    struct nv_nv91c0_SET_FALCON14 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON14(&val, __data); \
}

#define VA_NV91C0_SET_FALCON14 V_NV91C0_SET_FALCON14

#define P_NV91C0_SET_FALCON14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON14(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON14, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON15 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON15(uint32_t *val_out, struct nv_nv91c0_SET_FALCON15 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON15(val, args...) { \
    struct nv_nv91c0_SET_FALCON15 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON15(&val, __data); \
}

#define VA_NV91C0_SET_FALCON15 V_NV91C0_SET_FALCON15

#define P_NV91C0_SET_FALCON15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON15(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON15, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON16 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON16(uint32_t *val_out, struct nv_nv91c0_SET_FALCON16 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON16(val, args...) { \
    struct nv_nv91c0_SET_FALCON16 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON16(&val, __data); \
}

#define VA_NV91C0_SET_FALCON16 V_NV91C0_SET_FALCON16

#define P_NV91C0_SET_FALCON16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON16(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON16, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON17 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON17(uint32_t *val_out, struct nv_nv91c0_SET_FALCON17 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON17(val, args...) { \
    struct nv_nv91c0_SET_FALCON17 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON17(&val, __data); \
}

#define VA_NV91C0_SET_FALCON17 V_NV91C0_SET_FALCON17

#define P_NV91C0_SET_FALCON17(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON17(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON17, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON18 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON18(uint32_t *val_out, struct nv_nv91c0_SET_FALCON18 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON18(val, args...) { \
    struct nv_nv91c0_SET_FALCON18 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON18(&val, __data); \
}

#define VA_NV91C0_SET_FALCON18 V_NV91C0_SET_FALCON18

#define P_NV91C0_SET_FALCON18(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON18(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON18, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON19 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON19(uint32_t *val_out, struct nv_nv91c0_SET_FALCON19 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON19(val, args...) { \
    struct nv_nv91c0_SET_FALCON19 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON19(&val, __data); \
}

#define VA_NV91C0_SET_FALCON19 V_NV91C0_SET_FALCON19

#define P_NV91C0_SET_FALCON19(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON19(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON19, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON20 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON20(uint32_t *val_out, struct nv_nv91c0_SET_FALCON20 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON20(val, args...) { \
    struct nv_nv91c0_SET_FALCON20 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON20(&val, __data); \
}

#define VA_NV91C0_SET_FALCON20 V_NV91C0_SET_FALCON20

#define P_NV91C0_SET_FALCON20(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON20(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON20, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON21 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON21(uint32_t *val_out, struct nv_nv91c0_SET_FALCON21 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON21(val, args...) { \
    struct nv_nv91c0_SET_FALCON21 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON21(&val, __data); \
}

#define VA_NV91C0_SET_FALCON21 V_NV91C0_SET_FALCON21

#define P_NV91C0_SET_FALCON21(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON21(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON21, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON22 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON22(uint32_t *val_out, struct nv_nv91c0_SET_FALCON22 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON22(val, args...) { \
    struct nv_nv91c0_SET_FALCON22 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON22(&val, __data); \
}

#define VA_NV91C0_SET_FALCON22 V_NV91C0_SET_FALCON22

#define P_NV91C0_SET_FALCON22(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON22(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON22, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON23 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON23(uint32_t *val_out, struct nv_nv91c0_SET_FALCON23 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON23(val, args...) { \
    struct nv_nv91c0_SET_FALCON23 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON23(&val, __data); \
}

#define VA_NV91C0_SET_FALCON23 V_NV91C0_SET_FALCON23

#define P_NV91C0_SET_FALCON23(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON23(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON23, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON24 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON24(uint32_t *val_out, struct nv_nv91c0_SET_FALCON24 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON24(val, args...) { \
    struct nv_nv91c0_SET_FALCON24 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON24(&val, __data); \
}

#define VA_NV91C0_SET_FALCON24 V_NV91C0_SET_FALCON24

#define P_NV91C0_SET_FALCON24(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON24(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON24, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON25 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON25(uint32_t *val_out, struct nv_nv91c0_SET_FALCON25 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON25(val, args...) { \
    struct nv_nv91c0_SET_FALCON25 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON25(&val, __data); \
}

#define VA_NV91C0_SET_FALCON25 V_NV91C0_SET_FALCON25

#define P_NV91C0_SET_FALCON25(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON25(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON25, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON26 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON26(uint32_t *val_out, struct nv_nv91c0_SET_FALCON26 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON26(val, args...) { \
    struct nv_nv91c0_SET_FALCON26 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON26(&val, __data); \
}

#define VA_NV91C0_SET_FALCON26 V_NV91C0_SET_FALCON26

#define P_NV91C0_SET_FALCON26(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON26(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON26, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON27 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON27(uint32_t *val_out, struct nv_nv91c0_SET_FALCON27 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON27(val, args...) { \
    struct nv_nv91c0_SET_FALCON27 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON27(&val, __data); \
}

#define VA_NV91C0_SET_FALCON27 V_NV91C0_SET_FALCON27

#define P_NV91C0_SET_FALCON27(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON27(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON27, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON28 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON28(uint32_t *val_out, struct nv_nv91c0_SET_FALCON28 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON28(val, args...) { \
    struct nv_nv91c0_SET_FALCON28 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON28(&val, __data); \
}

#define VA_NV91C0_SET_FALCON28 V_NV91C0_SET_FALCON28

#define P_NV91C0_SET_FALCON28(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON28(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON28, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON29 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON29(uint32_t *val_out, struct nv_nv91c0_SET_FALCON29 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON29(val, args...) { \
    struct nv_nv91c0_SET_FALCON29 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON29(&val, __data); \
}

#define VA_NV91C0_SET_FALCON29 V_NV91C0_SET_FALCON29

#define P_NV91C0_SET_FALCON29(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON29(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON29, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON30 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON30(uint32_t *val_out, struct nv_nv91c0_SET_FALCON30 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON30(val, args...) { \
    struct nv_nv91c0_SET_FALCON30 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON30(&val, __data); \
}

#define VA_NV91C0_SET_FALCON30 V_NV91C0_SET_FALCON30

#define P_NV91C0_SET_FALCON30(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON30(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON30, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FALCON31 {
    uint32_t v;
};

static inline void
__NV91C0_SET_FALCON31(uint32_t *val_out, struct nv_nv91c0_SET_FALCON31 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_FALCON31(val, args...) { \
    struct nv_nv91c0_SET_FALCON31 __data = { .v = (args) }; \
    __NV91C0_SET_FALCON31(&val, __data); \
}

#define VA_NV91C0_SET_FALCON31 V_NV91C0_SET_FALCON31

#define P_NV91C0_SET_FALCON31(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FALCON31(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FALCON31, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_MAX_SM_COUNT {
    uint32_t v;
};

static inline void
__NV91C0_SET_MAX_SM_COUNT(uint32_t *val_out, struct nv_nv91c0_SET_MAX_SM_COUNT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 9));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_SET_MAX_SM_COUNT(val, args...) { \
    struct nv_nv91c0_SET_MAX_SM_COUNT __data = { .v = (args) }; \
    __NV91C0_SET_MAX_SM_COUNT(&val, __data); \
}

#define VA_NV91C0_SET_MAX_SM_COUNT V_NV91C0_SET_MAX_SM_COUNT

#define P_NV91C0_SET_MAX_SM_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_MAX_SM_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_MAX_SM_COUNT, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_WINDOW {
    uint32_t base_address;
};

static inline void
__NV91C0_SET_SHADER_LOCAL_MEMORY_WINDOW(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_WINDOW st)
{
    uint32_t val = 0;
    
    val |= st.base_address;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_LOCAL_MEMORY_WINDOW(val, args...) { \
    struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_WINDOW __data = { .base_address = (args) }; \
    __NV91C0_SET_SHADER_LOCAL_MEMORY_WINDOW(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_LOCAL_MEMORY_WINDOW V_NV91C0_SET_SHADER_LOCAL_MEMORY_WINDOW

#define P_NV91C0_SET_SHADER_LOCAL_MEMORY_WINDOW(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_LOCAL_MEMORY_WINDOW(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_LOCAL_MEMORY_WINDOW, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_GRID_PARAM {
    uint32_t v;
};

static inline void
__NV91C0_SET_GRID_PARAM(uint32_t *val_out, struct nv_nv91c0_SET_GRID_PARAM st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_GRID_PARAM(val, args...) { \
    struct nv_nv91c0_SET_GRID_PARAM __data = { .v = (args) }; \
    __NV91C0_SET_GRID_PARAM(&val, __data); \
}

#define VA_NV91C0_SET_GRID_PARAM V_NV91C0_SET_GRID_PARAM

#define P_NV91C0_SET_GRID_PARAM(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_GRID_PARAM(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_GRID_PARAM, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_A {
    uint32_t address_upper;
};

static inline void
__NV91C0_SET_SHADER_LOCAL_MEMORY_A(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_LOCAL_MEMORY_A(val, args...) { \
    struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_A __data = { .address_upper = (args) }; \
    __NV91C0_SET_SHADER_LOCAL_MEMORY_A(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_LOCAL_MEMORY_A V_NV91C0_SET_SHADER_LOCAL_MEMORY_A

#define P_NV91C0_SET_SHADER_LOCAL_MEMORY_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_LOCAL_MEMORY_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_LOCAL_MEMORY_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_B {
    uint32_t address_lower;
};

static inline void
__NV91C0_SET_SHADER_LOCAL_MEMORY_B(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_LOCAL_MEMORY_B(val, args...) { \
    struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_B __data = { .address_lower = (args) }; \
    __NV91C0_SET_SHADER_LOCAL_MEMORY_B(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_LOCAL_MEMORY_B V_NV91C0_SET_SHADER_LOCAL_MEMORY_B

#define P_NV91C0_SET_SHADER_LOCAL_MEMORY_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_LOCAL_MEMORY_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_LOCAL_MEMORY_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_C {
    uint32_t size_upper;
};

static inline void
__NV91C0_SET_SHADER_LOCAL_MEMORY_C(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_C st)
{
    uint32_t val = 0;
    
    assert(st.size_upper < (1ULL << 6));
    val |= st.size_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_LOCAL_MEMORY_C(val, args...) { \
    struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_C __data = { .size_upper = (args) }; \
    __NV91C0_SET_SHADER_LOCAL_MEMORY_C(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_LOCAL_MEMORY_C V_NV91C0_SET_SHADER_LOCAL_MEMORY_C

#define P_NV91C0_SET_SHADER_LOCAL_MEMORY_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_LOCAL_MEMORY_C(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_LOCAL_MEMORY_C, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_D {
    uint32_t size_lower;
};

static inline void
__NV91C0_SET_SHADER_LOCAL_MEMORY_D(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_D st)
{
    uint32_t val = 0;
    
    val |= st.size_lower;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_LOCAL_MEMORY_D(val, args...) { \
    struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_D __data = { .size_lower = (args) }; \
    __NV91C0_SET_SHADER_LOCAL_MEMORY_D(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_LOCAL_MEMORY_D V_NV91C0_SET_SHADER_LOCAL_MEMORY_D

#define P_NV91C0_SET_SHADER_LOCAL_MEMORY_D(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_LOCAL_MEMORY_D(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_LOCAL_MEMORY_D, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_E {
    uint32_t default_size_per_warp;
};

static inline void
__NV91C0_SET_SHADER_LOCAL_MEMORY_E(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_E st)
{
    uint32_t val = 0;
    
    assert(st.default_size_per_warp < (1ULL << 26));
    val |= st.default_size_per_warp << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_LOCAL_MEMORY_E(val, args...) { \
    struct nv_nv91c0_SET_SHADER_LOCAL_MEMORY_E __data = { .default_size_per_warp = (args) }; \
    __NV91C0_SET_SHADER_LOCAL_MEMORY_E(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_LOCAL_MEMORY_E V_NV91C0_SET_SHADER_LOCAL_MEMORY_E

#define P_NV91C0_SET_SHADER_LOCAL_MEMORY_E(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_LOCAL_MEMORY_E(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_LOCAL_MEMORY_E, nvk_p_ret); \
} while(0)

struct nv_nv91c0_END_GRID {
    uint32_t v;
};

static inline void
__NV91C0_END_GRID(uint32_t *val_out, struct nv_nv91c0_END_GRID st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_END_GRID(val, args...) { \
    struct nv_nv91c0_END_GRID __data = { .v = (args) }; \
    __NV91C0_END_GRID(&val, __data); \
}

#define VA_NV91C0_END_GRID V_NV91C0_END_GRID

#define P_NV91C0_END_GRID(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_END_GRID(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_END_GRID, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_LAUNCH_SIZE {
    uint32_t v;
};

static inline void
__NV91C0_SET_LAUNCH_SIZE(uint32_t *val_out, struct nv_nv91c0_SET_LAUNCH_SIZE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_LAUNCH_SIZE(val, args...) { \
    struct nv_nv91c0_SET_LAUNCH_SIZE __data = { .v = (args) }; \
    __NV91C0_SET_LAUNCH_SIZE(&val, __data); \
}

#define VA_NV91C0_SET_LAUNCH_SIZE V_NV91C0_SET_LAUNCH_SIZE

#define P_NV91C0_SET_LAUNCH_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_LAUNCH_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_LAUNCH_SIZE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_API_VISIBLE_CALL_LIMIT {
    uint32_t cta;
};

static inline void
__NV91C0_SET_API_VISIBLE_CALL_LIMIT(uint32_t *val_out, struct nv_nv91c0_SET_API_VISIBLE_CALL_LIMIT st)
{
    uint32_t val = 0;
    
    assert(st.cta < (1ULL << 4));
    val |= st.cta << 0;
    *val_out = val;
}

#define V_NV91C0_SET_API_VISIBLE_CALL_LIMIT(val, args...) { \
    UNUSED uint32_t CTA__0 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__0; \
    UNUSED uint32_t CTA__1 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__1; \
    UNUSED uint32_t CTA__2 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__2; \
    UNUSED uint32_t CTA__4 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__4; \
    UNUSED uint32_t CTA__8 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__8; \
    UNUSED uint32_t CTA__16 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__16; \
    UNUSED uint32_t CTA__32 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__32; \
    UNUSED uint32_t CTA__64 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__64; \
    UNUSED uint32_t CTA__128 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__128; \
    UNUSED uint32_t CTA_NO_CHECK = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA_NO_CHECK; \
    struct nv_nv91c0_SET_API_VISIBLE_CALL_LIMIT __data = { .cta = (args) }; \
    __NV91C0_SET_API_VISIBLE_CALL_LIMIT(&val, __data); \
}

#define VA_NV91C0_SET_API_VISIBLE_CALL_LIMIT V_NV91C0_SET_API_VISIBLE_CALL_LIMIT

#define P_NV91C0_SET_API_VISIBLE_CALL_LIMIT(push, args...) do { \
    UNUSED uint32_t CTA__0 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__0; \
    UNUSED uint32_t CTA__1 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__1; \
    UNUSED uint32_t CTA__2 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__2; \
    UNUSED uint32_t CTA__4 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__4; \
    UNUSED uint32_t CTA__8 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__8; \
    UNUSED uint32_t CTA__16 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__16; \
    UNUSED uint32_t CTA__32 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__32; \
    UNUSED uint32_t CTA__64 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__64; \
    UNUSED uint32_t CTA__128 = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA__128; \
    UNUSED uint32_t CTA_NO_CHECK = NV91C0_SET_API_VISIBLE_CALL_LIMIT_CTA_NO_CHECK; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_API_VISIBLE_CALL_LIMIT(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_API_VISIBLE_CALL_LIMIT, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_CACHE_CONTROL {
    uint32_t icache_prefetch_enable;
};

static inline void
__NV91C0_SET_SHADER_CACHE_CONTROL(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_CACHE_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.icache_prefetch_enable < (1ULL << 1));
    val |= st.icache_prefetch_enable << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_CACHE_CONTROL(val, args...) { \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_FALSE = NV91C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE; \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_TRUE = NV91C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE; \
    struct nv_nv91c0_SET_SHADER_CACHE_CONTROL __data = { .icache_prefetch_enable = (args) }; \
    __NV91C0_SET_SHADER_CACHE_CONTROL(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_CACHE_CONTROL V_NV91C0_SET_SHADER_CACHE_CONTROL

#define P_NV91C0_SET_SHADER_CACHE_CONTROL(push, args...) do { \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_FALSE = NV91C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE; \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_TRUE = NV91C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_CACHE_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_CACHE_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SM_TIMEOUT_INTERVAL {
    uint32_t counter_bit;
};

static inline void
__NV91C0_SET_SM_TIMEOUT_INTERVAL(uint32_t *val_out, struct nv_nv91c0_SET_SM_TIMEOUT_INTERVAL st)
{
    uint32_t val = 0;
    
    assert(st.counter_bit < (1ULL << 6));
    val |= st.counter_bit << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SM_TIMEOUT_INTERVAL(val, args...) { \
    struct nv_nv91c0_SET_SM_TIMEOUT_INTERVAL __data = { .counter_bit = (args) }; \
    __NV91C0_SET_SM_TIMEOUT_INTERVAL(&val, __data); \
}

#define VA_NV91C0_SET_SM_TIMEOUT_INTERVAL V_NV91C0_SET_SM_TIMEOUT_INTERVAL

#define P_NV91C0_SET_SM_TIMEOUT_INTERVAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SM_TIMEOUT_INTERVAL(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SM_TIMEOUT_INTERVAL, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP12 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP12(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP12 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP12(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP12 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP12(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP12 V_NV91C0_SET_SPARE_NOOP12

#define P_NV91C0_SET_SPARE_NOOP12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP12(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP12, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP13 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP13(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP13 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP13(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP13 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP13(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP13 V_NV91C0_SET_SPARE_NOOP13

#define P_NV91C0_SET_SPARE_NOOP13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP13(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP13, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP14 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP14(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP14 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP14(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP14 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP14(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP14 V_NV91C0_SET_SPARE_NOOP14

#define P_NV91C0_SET_SPARE_NOOP14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP14(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP14, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP15 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP15(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP15 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP15(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP15 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP15(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP15 V_NV91C0_SET_SPARE_NOOP15

#define P_NV91C0_SET_SPARE_NOOP15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP15(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP15, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_FORCE_ONE_TEXTURE_UNIT {
    uint32_t enable;
};

static inline void
__NV91C0_SET_FORCE_ONE_TEXTURE_UNIT(uint32_t *val_out, struct nv_nv91c0_SET_FORCE_ONE_TEXTURE_UNIT st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NV91C0_SET_FORCE_ONE_TEXTURE_UNIT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NV91C0_SET_FORCE_ONE_TEXTURE_UNIT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NV91C0_SET_FORCE_ONE_TEXTURE_UNIT_ENABLE_TRUE; \
    struct nv_nv91c0_SET_FORCE_ONE_TEXTURE_UNIT __data = { .enable = (args) }; \
    __NV91C0_SET_FORCE_ONE_TEXTURE_UNIT(&val, __data); \
}

#define VA_NV91C0_SET_FORCE_ONE_TEXTURE_UNIT V_NV91C0_SET_FORCE_ONE_TEXTURE_UNIT

#define P_NV91C0_SET_FORCE_ONE_TEXTURE_UNIT(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NV91C0_SET_FORCE_ONE_TEXTURE_UNIT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NV91C0_SET_FORCE_ONE_TEXTURE_UNIT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_FORCE_ONE_TEXTURE_UNIT(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_FORCE_ONE_TEXTURE_UNIT, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP00 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP00(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP00(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP00 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP00(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP00 V_NV91C0_SET_SPARE_NOOP00

#define P_NV91C0_SET_SPARE_NOOP00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP00(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP00, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP01 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP01(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP01(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP01 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP01(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP01 V_NV91C0_SET_SPARE_NOOP01

#define P_NV91C0_SET_SPARE_NOOP01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP01(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP01, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP02 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP02(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP02(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP02 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP02(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP02 V_NV91C0_SET_SPARE_NOOP02

#define P_NV91C0_SET_SPARE_NOOP02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP02(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP02, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP03 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP03(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP03(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP03 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP03(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP03 V_NV91C0_SET_SPARE_NOOP03

#define P_NV91C0_SET_SPARE_NOOP03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP03(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP03, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP04 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP04(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP04 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP04(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP04 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP04(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP04 V_NV91C0_SET_SPARE_NOOP04

#define P_NV91C0_SET_SPARE_NOOP04(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP04(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP04, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP05 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP05(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP05 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP05(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP05 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP05(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP05 V_NV91C0_SET_SPARE_NOOP05

#define P_NV91C0_SET_SPARE_NOOP05(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP05(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP05, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP06 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP06(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP06 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP06(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP06 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP06(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP06 V_NV91C0_SET_SPARE_NOOP06

#define P_NV91C0_SET_SPARE_NOOP06(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP06(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP06, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP07 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP07(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP07 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP07(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP07 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP07(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP07 V_NV91C0_SET_SPARE_NOOP07

#define P_NV91C0_SET_SPARE_NOOP07(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP07(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP07, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP08 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP08(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP08 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP08(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP08 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP08(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP08 V_NV91C0_SET_SPARE_NOOP08

#define P_NV91C0_SET_SPARE_NOOP08(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP08(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP08, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP09 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP09(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP09 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP09(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP09 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP09(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP09 V_NV91C0_SET_SPARE_NOOP09

#define P_NV91C0_SET_SPARE_NOOP09(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP09(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP09, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP10 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP10(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP10 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP10(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP10 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP10(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP10 V_NV91C0_SET_SPARE_NOOP10

#define P_NV91C0_SET_SPARE_NOOP10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP10(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP10, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE_NOOP11 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE_NOOP11(uint32_t *val_out, struct nv_nv91c0_SET_SPARE_NOOP11 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE_NOOP11(val, args...) { \
    struct nv_nv91c0_SET_SPARE_NOOP11 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE_NOOP11(&val, __data); \
}

#define VA_NV91C0_SET_SPARE_NOOP11 V_NV91C0_SET_SPARE_NOOP11

#define P_NV91C0_SET_SPARE_NOOP11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE_NOOP11(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE_NOOP11, nvk_p_ret); \
} while(0)

struct nv_nv91c0_UNBIND_ALL {
    uint32_t texture_headers;
    uint32_t texture_samplers;
    uint32_t constant_buffers;
};

static inline void
__NV91C0_UNBIND_ALL(uint32_t *val_out, struct nv_nv91c0_UNBIND_ALL st)
{
    uint32_t val = 0;
    
    assert(st.texture_headers < (1ULL << 1));
    val |= st.texture_headers << 0;
    
    assert(st.texture_samplers < (1ULL << 1));
    val |= st.texture_samplers << 4;
    
    assert(st.constant_buffers < (1ULL << 1));
    val |= st.constant_buffers << 8;
    *val_out = val;
}

#define V_NV91C0_UNBIND_ALL(val, args...) { \
    UNUSED uint32_t TEXTURE_HEADERS_FALSE = NV91C0_UNBIND_ALL_TEXTURE_HEADERS_FALSE; \
    UNUSED uint32_t TEXTURE_HEADERS_TRUE = NV91C0_UNBIND_ALL_TEXTURE_HEADERS_TRUE; \
    UNUSED uint32_t TEXTURE_SAMPLERS_FALSE = NV91C0_UNBIND_ALL_TEXTURE_SAMPLERS_FALSE; \
    UNUSED uint32_t TEXTURE_SAMPLERS_TRUE = NV91C0_UNBIND_ALL_TEXTURE_SAMPLERS_TRUE; \
    UNUSED uint32_t CONSTANT_BUFFERS_FALSE = NV91C0_UNBIND_ALL_CONSTANT_BUFFERS_FALSE; \
    UNUSED uint32_t CONSTANT_BUFFERS_TRUE = NV91C0_UNBIND_ALL_CONSTANT_BUFFERS_TRUE; \
    struct nv_nv91c0_UNBIND_ALL __data = args; \
    __NV91C0_UNBIND_ALL(&val, __data); \
}

#define VA_NV91C0_UNBIND_ALL V_NV91C0_UNBIND_ALL

#define P_NV91C0_UNBIND_ALL(push, args...) do { \
    UNUSED uint32_t TEXTURE_HEADERS_FALSE = NV91C0_UNBIND_ALL_TEXTURE_HEADERS_FALSE; \
    UNUSED uint32_t TEXTURE_HEADERS_TRUE = NV91C0_UNBIND_ALL_TEXTURE_HEADERS_TRUE; \
    UNUSED uint32_t TEXTURE_SAMPLERS_FALSE = NV91C0_UNBIND_ALL_TEXTURE_SAMPLERS_FALSE; \
    UNUSED uint32_t TEXTURE_SAMPLERS_TRUE = NV91C0_UNBIND_ALL_TEXTURE_SAMPLERS_TRUE; \
    UNUSED uint32_t CONSTANT_BUFFERS_FALSE = NV91C0_UNBIND_ALL_CONSTANT_BUFFERS_FALSE; \
    UNUSED uint32_t CONSTANT_BUFFERS_TRUE = NV91C0_UNBIND_ALL_CONSTANT_BUFFERS_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_UNBIND_ALL(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_UNBIND_ALL, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SAMPLER_BINDING {
    uint32_t v;
};

static inline void
__NV91C0_SET_SAMPLER_BINDING(uint32_t *val_out, struct nv_nv91c0_SET_SAMPLER_BINDING st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SAMPLER_BINDING(val, args...) { \
    UNUSED uint32_t V_INDEPENDENTLY = NV91C0_SET_SAMPLER_BINDING_V_INDEPENDENTLY; \
    UNUSED uint32_t V_VIA_HEADER_BINDING = NV91C0_SET_SAMPLER_BINDING_V_VIA_HEADER_BINDING; \
    struct nv_nv91c0_SET_SAMPLER_BINDING __data = { .v = (args) }; \
    __NV91C0_SET_SAMPLER_BINDING(&val, __data); \
}

#define VA_NV91C0_SET_SAMPLER_BINDING V_NV91C0_SET_SAMPLER_BINDING

#define P_NV91C0_SET_SAMPLER_BINDING(push, args...) do { \
    UNUSED uint32_t V_INDEPENDENTLY = NV91C0_SET_SAMPLER_BINDING_V_INDEPENDENTLY; \
    UNUSED uint32_t V_VIA_HEADER_BINDING = NV91C0_SET_SAMPLER_BINDING_V_VIA_HEADER_BINDING; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SAMPLER_BINDING(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SAMPLER_BINDING, nvk_p_ret); \
} while(0)

struct nv_nv91c0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(uint32_t *val_out, struct nv_nv91c0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(val, args...) { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE; \
    struct nv_nv91c0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI __data = args; \
    __NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(&val, __data); \
}

#define VA_NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI V_NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI

#define P_NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_SCHEDULING {
    uint32_t mode;
};

static inline void
__NV91C0_SET_SHADER_SCHEDULING(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_SCHEDULING st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 1));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_SCHEDULING(val, args...) { \
    UNUSED uint32_t MODE_OLDEST_THREAD_FIRST = NV91C0_SET_SHADER_SCHEDULING_MODE_OLDEST_THREAD_FIRST; \
    UNUSED uint32_t MODE_ROUND_ROBIN = NV91C0_SET_SHADER_SCHEDULING_MODE_ROUND_ROBIN; \
    struct nv_nv91c0_SET_SHADER_SCHEDULING __data = { .mode = (args) }; \
    __NV91C0_SET_SHADER_SCHEDULING(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_SCHEDULING V_NV91C0_SET_SHADER_SCHEDULING

#define P_NV91C0_SET_SHADER_SCHEDULING(push, args...) do { \
    UNUSED uint32_t MODE_OLDEST_THREAD_FIRST = NV91C0_SET_SHADER_SCHEDULING_MODE_OLDEST_THREAD_FIRST; \
    UNUSED uint32_t MODE_ROUND_ROBIN = NV91C0_SET_SHADER_SCHEDULING_MODE_ROUND_ROBIN; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_SCHEDULING(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_SCHEDULING, nvk_p_ret); \
} while(0)

struct nv_nv91c0_INVALIDATE_SAMPLER_CACHE {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NV91C0_INVALIDATE_SAMPLER_CACHE(uint32_t *val_out, struct nv_nv91c0_INVALIDATE_SAMPLER_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NV91C0_INVALIDATE_SAMPLER_CACHE(val, args...) { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_SAMPLER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_SAMPLER_CACHE_LINES_ONE; \
    struct nv_nv91c0_INVALIDATE_SAMPLER_CACHE __data = args; \
    __NV91C0_INVALIDATE_SAMPLER_CACHE(&val, __data); \
}

#define VA_NV91C0_INVALIDATE_SAMPLER_CACHE V_NV91C0_INVALIDATE_SAMPLER_CACHE

#define P_NV91C0_INVALIDATE_SAMPLER_CACHE(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_SAMPLER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_SAMPLER_CACHE_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_INVALIDATE_SAMPLER_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_INVALIDATE_SAMPLER_CACHE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_INVALIDATE_TEXTURE_HEADER_CACHE {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE(uint32_t *val_out, struct nv_nv91c0_INVALIDATE_TEXTURE_HEADER_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE(val, args...) { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE; \
    struct nv_nv91c0_INVALIDATE_TEXTURE_HEADER_CACHE __data = args; \
    __NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE(&val, __data); \
}

#define VA_NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE V_NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE

#define P_NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_INVALIDATE_TEXTURE_HEADER_CACHE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_INVALIDATE_TEXTURE_DATA_CACHE {
    uint32_t lines;
    uint32_t tag;
    uint32_t levels;
};

static inline void
__NV91C0_INVALIDATE_TEXTURE_DATA_CACHE(uint32_t *val_out, struct nv_nv91c0_INVALIDATE_TEXTURE_DATA_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    
    assert(st.levels < (1ULL << 2));
    val |= st.levels << 1;
    *val_out = val;
}

#define V_NV91C0_INVALIDATE_TEXTURE_DATA_CACHE(val, args...) { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE; \
    UNUSED uint32_t LEVELS_L1_ONLY = NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_LEVELS_L1_ONLY; \
    struct nv_nv91c0_INVALIDATE_TEXTURE_DATA_CACHE __data = args; \
    __NV91C0_INVALIDATE_TEXTURE_DATA_CACHE(&val, __data); \
}

#define VA_NV91C0_INVALIDATE_TEXTURE_DATA_CACHE V_NV91C0_INVALIDATE_TEXTURE_DATA_CACHE

#define P_NV91C0_INVALIDATE_TEXTURE_DATA_CACHE(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE; \
    UNUSED uint32_t LEVELS_L1_ONLY = NV91C0_INVALIDATE_TEXTURE_DATA_CACHE_LEVELS_L1_ONLY; \
    uint32_t nvk_p_ret; \
    V_NV91C0_INVALIDATE_TEXTURE_DATA_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_INVALIDATE_TEXTURE_DATA_CACHE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_GLOBAL_COLOR_KEY {
    uint32_t enable;
};

static inline void
__NV91C0_SET_GLOBAL_COLOR_KEY(uint32_t *val_out, struct nv_nv91c0_SET_GLOBAL_COLOR_KEY st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NV91C0_SET_GLOBAL_COLOR_KEY(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NV91C0_SET_GLOBAL_COLOR_KEY_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NV91C0_SET_GLOBAL_COLOR_KEY_ENABLE_TRUE; \
    struct nv_nv91c0_SET_GLOBAL_COLOR_KEY __data = { .enable = (args) }; \
    __NV91C0_SET_GLOBAL_COLOR_KEY(&val, __data); \
}

#define VA_NV91C0_SET_GLOBAL_COLOR_KEY V_NV91C0_SET_GLOBAL_COLOR_KEY

#define P_NV91C0_SET_GLOBAL_COLOR_KEY(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NV91C0_SET_GLOBAL_COLOR_KEY_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NV91C0_SET_GLOBAL_COLOR_KEY_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_GLOBAL_COLOR_KEY(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_GLOBAL_COLOR_KEY, nvk_p_ret); \
} while(0)

struct nv_nv91c0_INVALIDATE_SAMPLER_CACHE_NO_WFI {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI(uint32_t *val_out, struct nv_nv91c0_INVALIDATE_SAMPLER_CACHE_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI(val, args...) { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE; \
    struct nv_nv91c0_INVALIDATE_SAMPLER_CACHE_NO_WFI __data = args; \
    __NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI(&val, __data); \
}

#define VA_NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI V_NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI

#define P_NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_INVALIDATE_SAMPLER_CACHE_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nv91c0_PERFMON_TRANSFER {
    uint32_t v;
};

static inline void
__NV91C0_PERFMON_TRANSFER(uint32_t *val_out, struct nv_nv91c0_PERFMON_TRANSFER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_PERFMON_TRANSFER(val, args...) { \
    struct nv_nv91c0_PERFMON_TRANSFER __data = { .v = (args) }; \
    __NV91C0_PERFMON_TRANSFER(&val, __data); \
}

#define VA_NV91C0_PERFMON_TRANSFER V_NV91C0_PERFMON_TRANSFER

#define P_NV91C0_PERFMON_TRANSFER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_PERFMON_TRANSFER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_PERFMON_TRANSFER, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_EXCEPTIONS {
    uint32_t enable;
};

static inline void
__NV91C0_SET_SHADER_EXCEPTIONS(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_EXCEPTIONS st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_EXCEPTIONS(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NV91C0_SET_SHADER_EXCEPTIONS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NV91C0_SET_SHADER_EXCEPTIONS_ENABLE_TRUE; \
    struct nv_nv91c0_SET_SHADER_EXCEPTIONS __data = { .enable = (args) }; \
    __NV91C0_SET_SHADER_EXCEPTIONS(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_EXCEPTIONS V_NV91C0_SET_SHADER_EXCEPTIONS

#define P_NV91C0_SET_SHADER_EXCEPTIONS(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NV91C0_SET_SHADER_EXCEPTIONS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NV91C0_SET_SHADER_EXCEPTIONS_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_EXCEPTIONS(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_EXCEPTIONS, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_RENDER_ENABLE_A {
    uint32_t offset_upper;
};

static inline void
__NV91C0_SET_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nv91c0_SET_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_RENDER_ENABLE_A(val, args...) { \
    struct nv_nv91c0_SET_RENDER_ENABLE_A __data = { .offset_upper = (args) }; \
    __NV91C0_SET_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NV91C0_SET_RENDER_ENABLE_A V_NV91C0_SET_RENDER_ENABLE_A

#define P_NV91C0_SET_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_RENDER_ENABLE_B {
    uint32_t offset_lower;
};

static inline void
__NV91C0_SET_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nv91c0_SET_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NV91C0_SET_RENDER_ENABLE_B(val, args...) { \
    struct nv_nv91c0_SET_RENDER_ENABLE_B __data = { .offset_lower = (args) }; \
    __NV91C0_SET_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NV91C0_SET_RENDER_ENABLE_B V_NV91C0_SET_RENDER_ENABLE_B

#define P_NV91C0_SET_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NV91C0_SET_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nv91c0_SET_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NV91C0_SET_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NV91C0_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NV91C0_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NV91C0_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NV91C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NV91C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nv91c0_SET_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NV91C0_SET_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NV91C0_SET_RENDER_ENABLE_C V_NV91C0_SET_RENDER_ENABLE_C

#define P_NV91C0_SET_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NV91C0_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NV91C0_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NV91C0_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NV91C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NV91C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_TEX_SAMPLER_POOL_A {
    uint32_t offset_upper;
};

static inline void
__NV91C0_SET_TEX_SAMPLER_POOL_A(uint32_t *val_out, struct nv_nv91c0_SET_TEX_SAMPLER_POOL_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_TEX_SAMPLER_POOL_A(val, args...) { \
    struct nv_nv91c0_SET_TEX_SAMPLER_POOL_A __data = { .offset_upper = (args) }; \
    __NV91C0_SET_TEX_SAMPLER_POOL_A(&val, __data); \
}

#define VA_NV91C0_SET_TEX_SAMPLER_POOL_A V_NV91C0_SET_TEX_SAMPLER_POOL_A

#define P_NV91C0_SET_TEX_SAMPLER_POOL_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_TEX_SAMPLER_POOL_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_TEX_SAMPLER_POOL_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_TEX_SAMPLER_POOL_B {
    uint32_t offset_lower;
};

static inline void
__NV91C0_SET_TEX_SAMPLER_POOL_B(uint32_t *val_out, struct nv_nv91c0_SET_TEX_SAMPLER_POOL_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NV91C0_SET_TEX_SAMPLER_POOL_B(val, args...) { \
    struct nv_nv91c0_SET_TEX_SAMPLER_POOL_B __data = { .offset_lower = (args) }; \
    __NV91C0_SET_TEX_SAMPLER_POOL_B(&val, __data); \
}

#define VA_NV91C0_SET_TEX_SAMPLER_POOL_B V_NV91C0_SET_TEX_SAMPLER_POOL_B

#define P_NV91C0_SET_TEX_SAMPLER_POOL_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_TEX_SAMPLER_POOL_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_TEX_SAMPLER_POOL_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_TEX_SAMPLER_POOL_C {
    uint32_t maximum_index;
};

static inline void
__NV91C0_SET_TEX_SAMPLER_POOL_C(uint32_t *val_out, struct nv_nv91c0_SET_TEX_SAMPLER_POOL_C st)
{
    uint32_t val = 0;
    
    assert(st.maximum_index < (1ULL << 20));
    val |= st.maximum_index << 0;
    *val_out = val;
}

#define V_NV91C0_SET_TEX_SAMPLER_POOL_C(val, args...) { \
    struct nv_nv91c0_SET_TEX_SAMPLER_POOL_C __data = { .maximum_index = (args) }; \
    __NV91C0_SET_TEX_SAMPLER_POOL_C(&val, __data); \
}

#define VA_NV91C0_SET_TEX_SAMPLER_POOL_C V_NV91C0_SET_TEX_SAMPLER_POOL_C

#define P_NV91C0_SET_TEX_SAMPLER_POOL_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_TEX_SAMPLER_POOL_C(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_TEX_SAMPLER_POOL_C, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_TEX_HEADER_POOL_A {
    uint32_t offset_upper;
};

static inline void
__NV91C0_SET_TEX_HEADER_POOL_A(uint32_t *val_out, struct nv_nv91c0_SET_TEX_HEADER_POOL_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_TEX_HEADER_POOL_A(val, args...) { \
    struct nv_nv91c0_SET_TEX_HEADER_POOL_A __data = { .offset_upper = (args) }; \
    __NV91C0_SET_TEX_HEADER_POOL_A(&val, __data); \
}

#define VA_NV91C0_SET_TEX_HEADER_POOL_A V_NV91C0_SET_TEX_HEADER_POOL_A

#define P_NV91C0_SET_TEX_HEADER_POOL_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_TEX_HEADER_POOL_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_TEX_HEADER_POOL_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_TEX_HEADER_POOL_B {
    uint32_t offset_lower;
};

static inline void
__NV91C0_SET_TEX_HEADER_POOL_B(uint32_t *val_out, struct nv_nv91c0_SET_TEX_HEADER_POOL_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NV91C0_SET_TEX_HEADER_POOL_B(val, args...) { \
    struct nv_nv91c0_SET_TEX_HEADER_POOL_B __data = { .offset_lower = (args) }; \
    __NV91C0_SET_TEX_HEADER_POOL_B(&val, __data); \
}

#define VA_NV91C0_SET_TEX_HEADER_POOL_B V_NV91C0_SET_TEX_HEADER_POOL_B

#define P_NV91C0_SET_TEX_HEADER_POOL_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_TEX_HEADER_POOL_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_TEX_HEADER_POOL_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_TEX_HEADER_POOL_C {
    uint32_t maximum_index;
};

static inline void
__NV91C0_SET_TEX_HEADER_POOL_C(uint32_t *val_out, struct nv_nv91c0_SET_TEX_HEADER_POOL_C st)
{
    uint32_t val = 0;
    
    assert(st.maximum_index < (1ULL << 22));
    val |= st.maximum_index << 0;
    *val_out = val;
}

#define V_NV91C0_SET_TEX_HEADER_POOL_C(val, args...) { \
    struct nv_nv91c0_SET_TEX_HEADER_POOL_C __data = { .maximum_index = (args) }; \
    __NV91C0_SET_TEX_HEADER_POOL_C(&val, __data); \
}

#define VA_NV91C0_SET_TEX_HEADER_POOL_C V_NV91C0_SET_TEX_HEADER_POOL_C

#define P_NV91C0_SET_TEX_HEADER_POOL_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_TEX_HEADER_POOL_C(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_TEX_HEADER_POOL_C, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_PROGRAM_REGION_A {
    uint32_t address_upper;
};

static inline void
__NV91C0_SET_PROGRAM_REGION_A(uint32_t *val_out, struct nv_nv91c0_SET_PROGRAM_REGION_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_PROGRAM_REGION_A(val, args...) { \
    struct nv_nv91c0_SET_PROGRAM_REGION_A __data = { .address_upper = (args) }; \
    __NV91C0_SET_PROGRAM_REGION_A(&val, __data); \
}

#define VA_NV91C0_SET_PROGRAM_REGION_A V_NV91C0_SET_PROGRAM_REGION_A

#define P_NV91C0_SET_PROGRAM_REGION_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_PROGRAM_REGION_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_PROGRAM_REGION_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_PROGRAM_REGION_B {
    uint32_t address_lower;
};

static inline void
__NV91C0_SET_PROGRAM_REGION_B(uint32_t *val_out, struct nv_nv91c0_SET_PROGRAM_REGION_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NV91C0_SET_PROGRAM_REGION_B(val, args...) { \
    struct nv_nv91c0_SET_PROGRAM_REGION_B __data = { .address_lower = (args) }; \
    __NV91C0_SET_PROGRAM_REGION_B(&val, __data); \
}

#define VA_NV91C0_SET_PROGRAM_REGION_B V_NV91C0_SET_PROGRAM_REGION_B

#define P_NV91C0_SET_PROGRAM_REGION_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_PROGRAM_REGION_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_PROGRAM_REGION_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CUBEMAP_INTER_FACE_FILTERING {
    uint32_t mode;
};

static inline void
__NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING(uint32_t *val_out, struct nv_nv91c0_SET_CUBEMAP_INTER_FACE_FILTERING st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING(val, args...) { \
    UNUSED uint32_t MODE_USE_WRAP = NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING_MODE_USE_WRAP; \
    UNUSED uint32_t MODE_OVERRIDE_WRAP = NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING_MODE_OVERRIDE_WRAP; \
    UNUSED uint32_t MODE_AUTO_SPAN_SEAM = NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING_MODE_AUTO_SPAN_SEAM; \
    UNUSED uint32_t MODE_AUTO_CROSS_SEAM = NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING_MODE_AUTO_CROSS_SEAM; \
    struct nv_nv91c0_SET_CUBEMAP_INTER_FACE_FILTERING __data = { .mode = (args) }; \
    __NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING(&val, __data); \
}

#define VA_NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING V_NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING

#define P_NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING(push, args...) do { \
    UNUSED uint32_t MODE_USE_WRAP = NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING_MODE_USE_WRAP; \
    UNUSED uint32_t MODE_OVERRIDE_WRAP = NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING_MODE_OVERRIDE_WRAP; \
    UNUSED uint32_t MODE_AUTO_SPAN_SEAM = NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING_MODE_AUTO_SPAN_SEAM; \
    UNUSED uint32_t MODE_AUTO_CROSS_SEAM = NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING_MODE_AUTO_CROSS_SEAM; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CUBEMAP_INTER_FACE_FILTERING, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_CONTROL {
    uint32_t default_partial;
    uint32_t zero_times_anything_is_zero;
    uint32_t fp32_nan_behavior;
    uint32_t fp32_f2i_nan_behavior;
};

static inline void
__NV91C0_SET_SHADER_CONTROL(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.default_partial < (1ULL << 1));
    val |= st.default_partial << 0;
    
    assert(st.zero_times_anything_is_zero < (1ULL << 1));
    val |= st.zero_times_anything_is_zero << 16;
    
    assert(st.fp32_nan_behavior < (1ULL << 1));
    val |= st.fp32_nan_behavior << 1;
    
    assert(st.fp32_f2i_nan_behavior < (1ULL << 1));
    val |= st.fp32_f2i_nan_behavior << 2;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_CONTROL(val, args...) { \
    UNUSED uint32_t DEFAULT_PARTIAL_ZERO = NV91C0_SET_SHADER_CONTROL_DEFAULT_PARTIAL_ZERO; \
    UNUSED uint32_t DEFAULT_PARTIAL_INFINITY = NV91C0_SET_SHADER_CONTROL_DEFAULT_PARTIAL_INFINITY; \
    UNUSED uint32_t ZERO_TIMES_ANYTHING_IS_ZERO_FALSE = NV91C0_SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO_FALSE; \
    UNUSED uint32_t ZERO_TIMES_ANYTHING_IS_ZERO_TRUE = NV91C0_SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO_TRUE; \
    UNUSED uint32_t FP32_NAN_BEHAVIOR_LEGACY = NV91C0_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_LEGACY; \
    UNUSED uint32_t FP32_NAN_BEHAVIOR_FP64_COMPATIBLE = NV91C0_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_FP64_COMPATIBLE; \
    UNUSED uint32_t FP32_F2I_NAN_BEHAVIOR_PASS_ZERO = NV91C0_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_ZERO; \
    UNUSED uint32_t FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE = NV91C0_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE; \
    struct nv_nv91c0_SET_SHADER_CONTROL __data = args; \
    __NV91C0_SET_SHADER_CONTROL(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_CONTROL V_NV91C0_SET_SHADER_CONTROL

#define P_NV91C0_SET_SHADER_CONTROL(push, args...) do { \
    UNUSED uint32_t DEFAULT_PARTIAL_ZERO = NV91C0_SET_SHADER_CONTROL_DEFAULT_PARTIAL_ZERO; \
    UNUSED uint32_t DEFAULT_PARTIAL_INFINITY = NV91C0_SET_SHADER_CONTROL_DEFAULT_PARTIAL_INFINITY; \
    UNUSED uint32_t ZERO_TIMES_ANYTHING_IS_ZERO_FALSE = NV91C0_SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO_FALSE; \
    UNUSED uint32_t ZERO_TIMES_ANYTHING_IS_ZERO_TRUE = NV91C0_SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO_TRUE; \
    UNUSED uint32_t FP32_NAN_BEHAVIOR_LEGACY = NV91C0_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_LEGACY; \
    UNUSED uint32_t FP32_NAN_BEHAVIOR_FP64_COMPATIBLE = NV91C0_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_FP64_COMPATIBLE; \
    UNUSED uint32_t FP32_F2I_NAN_BEHAVIOR_PASS_ZERO = NV91C0_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_ZERO; \
    UNUSED uint32_t FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE = NV91C0_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nv91c0_BIND_CONSTANT_BUFFER {
    uint32_t valid;
    uint32_t shader_slot;
};

static inline void
__NV91C0_BIND_CONSTANT_BUFFER(uint32_t *val_out, struct nv_nv91c0_BIND_CONSTANT_BUFFER st)
{
    uint32_t val = 0;
    
    assert(st.valid < (1ULL << 1));
    val |= st.valid << 0;
    
    assert(st.shader_slot < (1ULL << 5));
    val |= st.shader_slot << 8;
    *val_out = val;
}

#define V_NV91C0_BIND_CONSTANT_BUFFER(val, args...) { \
    UNUSED uint32_t VALID_FALSE = NV91C0_BIND_CONSTANT_BUFFER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV91C0_BIND_CONSTANT_BUFFER_VALID_TRUE; \
    struct nv_nv91c0_BIND_CONSTANT_BUFFER __data = args; \
    __NV91C0_BIND_CONSTANT_BUFFER(&val, __data); \
}

#define VA_NV91C0_BIND_CONSTANT_BUFFER V_NV91C0_BIND_CONSTANT_BUFFER

#define P_NV91C0_BIND_CONSTANT_BUFFER(push, args...) do { \
    UNUSED uint32_t VALID_FALSE = NV91C0_BIND_CONSTANT_BUFFER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV91C0_BIND_CONSTANT_BUFFER_VALID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_BIND_CONSTANT_BUFFER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_BIND_CONSTANT_BUFFER, nvk_p_ret); \
} while(0)

struct nv_nv91c0_INVALIDATE_SHADER_CACHES_NO_WFI {
    uint32_t instruction;
    uint32_t global_data;
    uint32_t uniform;
    uint32_t constant;
};

static inline void
__NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI(uint32_t *val_out, struct nv_nv91c0_INVALIDATE_SHADER_CACHES_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.instruction < (1ULL << 1));
    val |= st.instruction << 0;
    
    assert(st.global_data < (1ULL << 1));
    val |= st.global_data << 4;
    
    assert(st.uniform < (1ULL << 1));
    val |= st.uniform << 8;
    
    assert(st.constant < (1ULL << 1));
    val |= st.constant << 12;
    *val_out = val;
}

#define V_NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI(val, args...) { \
    UNUSED uint32_t INSTRUCTION_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE; \
    UNUSED uint32_t GLOBAL_DATA_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE; \
    UNUSED uint32_t GLOBAL_DATA_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE; \
    UNUSED uint32_t UNIFORM_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_UNIFORM_FALSE; \
    UNUSED uint32_t UNIFORM_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_UNIFORM_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE; \
    struct nv_nv91c0_INVALIDATE_SHADER_CACHES_NO_WFI __data = args; \
    __NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI(&val, __data); \
}

#define VA_NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI V_NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI

#define P_NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI(push, args...) do { \
    UNUSED uint32_t INSTRUCTION_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE; \
    UNUSED uint32_t GLOBAL_DATA_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE; \
    UNUSED uint32_t GLOBAL_DATA_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE; \
    UNUSED uint32_t UNIFORM_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_UNIFORM_FALSE; \
    UNUSED uint32_t UNIFORM_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_UNIFORM_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_INVALIDATE_SHADER_CACHES_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nv91c0_INVALIDATE_CONSTANT_BUFFER_CACHE {
    uint32_t thru_l2;
};

static inline void
__NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE(uint32_t *val_out, struct nv_nv91c0_INVALIDATE_CONSTANT_BUFFER_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.thru_l2 < (1ULL << 1));
    val |= st.thru_l2 << 0;
    *val_out = val;
}

#define V_NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE(val, args...) { \
    UNUSED uint32_t THRU_L2_FALSE = NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_FALSE; \
    UNUSED uint32_t THRU_L2_TRUE = NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_TRUE; \
    struct nv_nv91c0_INVALIDATE_CONSTANT_BUFFER_CACHE __data = { .thru_l2 = (args) }; \
    __NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE(&val, __data); \
}

#define VA_NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE V_NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE

#define P_NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE(push, args...) do { \
    UNUSED uint32_t THRU_L2_FALSE = NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_FALSE; \
    UNUSED uint32_t THRU_L2_TRUE = NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_INVALIDATE_CONSTANT_BUFFER_CACHE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_RENDER_ENABLE_OVERRIDE {
    uint32_t mode;
};

static inline void
__NV91C0_SET_RENDER_ENABLE_OVERRIDE(uint32_t *val_out, struct nv_nv91c0_SET_RENDER_ENABLE_OVERRIDE st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NV91C0_SET_RENDER_ENABLE_OVERRIDE(val, args...) { \
    UNUSED uint32_t MODE_USE_RENDER_ENABLE = NV91C0_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE; \
    UNUSED uint32_t MODE_ALWAYS_RENDER = NV91C0_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER; \
    UNUSED uint32_t MODE_NEVER_RENDER = NV91C0_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER; \
    struct nv_nv91c0_SET_RENDER_ENABLE_OVERRIDE __data = { .mode = (args) }; \
    __NV91C0_SET_RENDER_ENABLE_OVERRIDE(&val, __data); \
}

#define VA_NV91C0_SET_RENDER_ENABLE_OVERRIDE V_NV91C0_SET_RENDER_ENABLE_OVERRIDE

#define P_NV91C0_SET_RENDER_ENABLE_OVERRIDE(push, args...) do { \
    UNUSED uint32_t MODE_USE_RENDER_ENABLE = NV91C0_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE; \
    UNUSED uint32_t MODE_ALWAYS_RENDER = NV91C0_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER; \
    UNUSED uint32_t MODE_NEVER_RENDER = NV91C0_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_RENDER_ENABLE_OVERRIDE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_RENDER_ENABLE_OVERRIDE, nvk_p_ret); \
} while(0)

struct nv_nv91c0_PIPE_NOP {
    uint32_t v;
};

static inline void
__NV91C0_PIPE_NOP(uint32_t *val_out, struct nv_nv91c0_PIPE_NOP st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_PIPE_NOP(val, args...) { \
    struct nv_nv91c0_PIPE_NOP __data = { .v = (args) }; \
    __NV91C0_PIPE_NOP(&val, __data); \
}

#define VA_NV91C0_PIPE_NOP V_NV91C0_PIPE_NOP

#define P_NV91C0_PIPE_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_PIPE_NOP(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_PIPE_NOP, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE00 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE00(uint32_t *val_out, struct nv_nv91c0_SET_SPARE00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE00(val, args...) { \
    struct nv_nv91c0_SET_SPARE00 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE00(&val, __data); \
}

#define VA_NV91C0_SET_SPARE00 V_NV91C0_SET_SPARE00

#define P_NV91C0_SET_SPARE00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE00(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE00, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE01 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE01(uint32_t *val_out, struct nv_nv91c0_SET_SPARE01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE01(val, args...) { \
    struct nv_nv91c0_SET_SPARE01 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE01(&val, __data); \
}

#define VA_NV91C0_SET_SPARE01 V_NV91C0_SET_SPARE01

#define P_NV91C0_SET_SPARE01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE01(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE01, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE02 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE02(uint32_t *val_out, struct nv_nv91c0_SET_SPARE02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE02(val, args...) { \
    struct nv_nv91c0_SET_SPARE02 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE02(&val, __data); \
}

#define VA_NV91C0_SET_SPARE02 V_NV91C0_SET_SPARE02

#define P_NV91C0_SET_SPARE02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE02(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE02, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SPARE03 {
    uint32_t v;
};

static inline void
__NV91C0_SET_SPARE03(uint32_t *val_out, struct nv_nv91c0_SET_SPARE03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SPARE03(val, args...) { \
    struct nv_nv91c0_SET_SPARE03 __data = { .v = (args) }; \
    __NV91C0_SET_SPARE03(&val, __data); \
}

#define VA_NV91C0_SET_SPARE03 V_NV91C0_SET_SPARE03

#define P_NV91C0_SET_SPARE03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SPARE03(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SPARE03, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_REPORT_SEMAPHORE_A {
    uint32_t offset_upper;
};

static inline void
__NV91C0_SET_REPORT_SEMAPHORE_A(uint32_t *val_out, struct nv_nv91c0_SET_REPORT_SEMAPHORE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_REPORT_SEMAPHORE_A(val, args...) { \
    struct nv_nv91c0_SET_REPORT_SEMAPHORE_A __data = { .offset_upper = (args) }; \
    __NV91C0_SET_REPORT_SEMAPHORE_A(&val, __data); \
}

#define VA_NV91C0_SET_REPORT_SEMAPHORE_A V_NV91C0_SET_REPORT_SEMAPHORE_A

#define P_NV91C0_SET_REPORT_SEMAPHORE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_REPORT_SEMAPHORE_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_REPORT_SEMAPHORE_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_REPORT_SEMAPHORE_B {
    uint32_t offset_lower;
};

static inline void
__NV91C0_SET_REPORT_SEMAPHORE_B(uint32_t *val_out, struct nv_nv91c0_SET_REPORT_SEMAPHORE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NV91C0_SET_REPORT_SEMAPHORE_B(val, args...) { \
    struct nv_nv91c0_SET_REPORT_SEMAPHORE_B __data = { .offset_lower = (args) }; \
    __NV91C0_SET_REPORT_SEMAPHORE_B(&val, __data); \
}

#define VA_NV91C0_SET_REPORT_SEMAPHORE_B V_NV91C0_SET_REPORT_SEMAPHORE_B

#define P_NV91C0_SET_REPORT_SEMAPHORE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_REPORT_SEMAPHORE_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_REPORT_SEMAPHORE_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_REPORT_SEMAPHORE_C {
    uint32_t payload;
};

static inline void
__NV91C0_SET_REPORT_SEMAPHORE_C(uint32_t *val_out, struct nv_nv91c0_SET_REPORT_SEMAPHORE_C st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NV91C0_SET_REPORT_SEMAPHORE_C(val, args...) { \
    struct nv_nv91c0_SET_REPORT_SEMAPHORE_C __data = { .payload = (args) }; \
    __NV91C0_SET_REPORT_SEMAPHORE_C(&val, __data); \
}

#define VA_NV91C0_SET_REPORT_SEMAPHORE_C V_NV91C0_SET_REPORT_SEMAPHORE_C

#define P_NV91C0_SET_REPORT_SEMAPHORE_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_REPORT_SEMAPHORE_C(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_REPORT_SEMAPHORE_C, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_REPORT_SEMAPHORE_D {
    uint32_t operation;
    uint32_t awaken_enable;
    uint32_t structure_size;
    uint32_t flush_disable;
};

static inline void
__NV91C0_SET_REPORT_SEMAPHORE_D(uint32_t *val_out, struct nv_nv91c0_SET_REPORT_SEMAPHORE_D st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 2));
    val |= st.operation << 0;
    
    assert(st.awaken_enable < (1ULL << 1));
    val |= st.awaken_enable << 20;
    
    assert(st.structure_size < (1ULL << 1));
    val |= st.structure_size << 28;
    
    assert(st.flush_disable < (1ULL << 1));
    val |= st.flush_disable << 2;
    *val_out = val;
}

#define V_NV91C0_SET_REPORT_SEMAPHORE_D(val, args...) { \
    UNUSED uint32_t OPERATION_RELEASE = NV91C0_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_TRAP = NV91C0_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NV91C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NV91C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t STRUCTURE_SIZE_FOUR_WORDS = NV91C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS; \
    UNUSED uint32_t STRUCTURE_SIZE_ONE_WORD = NV91C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NV91C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NV91C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE; \
    struct nv_nv91c0_SET_REPORT_SEMAPHORE_D __data = args; \
    __NV91C0_SET_REPORT_SEMAPHORE_D(&val, __data); \
}

#define VA_NV91C0_SET_REPORT_SEMAPHORE_D V_NV91C0_SET_REPORT_SEMAPHORE_D

#define P_NV91C0_SET_REPORT_SEMAPHORE_D(push, args...) do { \
    UNUSED uint32_t OPERATION_RELEASE = NV91C0_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_TRAP = NV91C0_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NV91C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NV91C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t STRUCTURE_SIZE_FOUR_WORDS = NV91C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS; \
    UNUSED uint32_t STRUCTURE_SIZE_ONE_WORD = NV91C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NV91C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NV91C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_REPORT_SEMAPHORE_D(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_REPORT_SEMAPHORE_D, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CONSTANT_BUFFER_SELECTOR_A {
    uint32_t size;
};

static inline void
__NV91C0_SET_CONSTANT_BUFFER_SELECTOR_A(uint32_t *val_out, struct nv_nv91c0_SET_CONSTANT_BUFFER_SELECTOR_A st)
{
    uint32_t val = 0;
    
    assert(st.size < (1ULL << 17));
    val |= st.size << 0;
    *val_out = val;
}

#define V_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_A(val, args...) { \
    struct nv_nv91c0_SET_CONSTANT_BUFFER_SELECTOR_A __data = { .size = (args) }; \
    __NV91C0_SET_CONSTANT_BUFFER_SELECTOR_A(&val, __data); \
}

#define VA_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_A V_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_A

#define P_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CONSTANT_BUFFER_SELECTOR_A, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CONSTANT_BUFFER_SELECTOR_B {
    uint32_t address_upper;
};

static inline void
__NV91C0_SET_CONSTANT_BUFFER_SELECTOR_B(uint32_t *val_out, struct nv_nv91c0_SET_CONSTANT_BUFFER_SELECTOR_B st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_B(val, args...) { \
    struct nv_nv91c0_SET_CONSTANT_BUFFER_SELECTOR_B __data = { .address_upper = (args) }; \
    __NV91C0_SET_CONSTANT_BUFFER_SELECTOR_B(&val, __data); \
}

#define VA_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_B V_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_B

#define P_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CONSTANT_BUFFER_SELECTOR_B, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_CONSTANT_BUFFER_SELECTOR_C {
    uint32_t address_lower;
};

static inline void
__NV91C0_SET_CONSTANT_BUFFER_SELECTOR_C(uint32_t *val_out, struct nv_nv91c0_SET_CONSTANT_BUFFER_SELECTOR_C st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_C(val, args...) { \
    struct nv_nv91c0_SET_CONSTANT_BUFFER_SELECTOR_C __data = { .address_lower = (args) }; \
    __NV91C0_SET_CONSTANT_BUFFER_SELECTOR_C(&val, __data); \
}

#define VA_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_C V_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_C

#define P_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_CONSTANT_BUFFER_SELECTOR_C(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_CONSTANT_BUFFER_SELECTOR_C, nvk_p_ret); \
} while(0)

struct nv_nv91c0_LOAD_CONSTANT_BUFFER_OFFSET {
    uint32_t v;
};

static inline void
__NV91C0_LOAD_CONSTANT_BUFFER_OFFSET(uint32_t *val_out, struct nv_nv91c0_LOAD_CONSTANT_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV91C0_LOAD_CONSTANT_BUFFER_OFFSET(val, args...) { \
    struct nv_nv91c0_LOAD_CONSTANT_BUFFER_OFFSET __data = { .v = (args) }; \
    __NV91C0_LOAD_CONSTANT_BUFFER_OFFSET(&val, __data); \
}

#define VA_NV91C0_LOAD_CONSTANT_BUFFER_OFFSET V_NV91C0_LOAD_CONSTANT_BUFFER_OFFSET

#define P_NV91C0_LOAD_CONSTANT_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_LOAD_CONSTANT_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_LOAD_CONSTANT_BUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nv91c0_LOAD_CONSTANT_BUFFER {
    uint32_t v;
};

static inline void
__NV91C0_LOAD_CONSTANT_BUFFER(uint32_t *val_out, struct nv_nv91c0_LOAD_CONSTANT_BUFFER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_LOAD_CONSTANT_BUFFER(val, args...) { \
    struct nv_nv91c0_LOAD_CONSTANT_BUFFER __data = { .v = (args) }; \
    __NV91C0_LOAD_CONSTANT_BUFFER(&val, __data); \
}

#define VA_NV91C0_LOAD_CONSTANT_BUFFER(i) V_NV91C0_LOAD_CONSTANT_BUFFER

#define P_NV91C0_LOAD_CONSTANT_BUFFER(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_LOAD_CONSTANT_BUFFER(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_LOAD_CONSTANT_BUFFER(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SU_LD_ST_TARGET_A {
    uint32_t offset_upper;
};

static inline void
__NV91C0_SET_SU_LD_ST_TARGET_A(uint32_t *val_out, struct nv_nv91c0_SET_SU_LD_ST_TARGET_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SU_LD_ST_TARGET_A(val, args...) { \
    struct nv_nv91c0_SET_SU_LD_ST_TARGET_A __data = { .offset_upper = (args) }; \
    __NV91C0_SET_SU_LD_ST_TARGET_A(&val, __data); \
}

#define VA_NV91C0_SET_SU_LD_ST_TARGET_A(i) V_NV91C0_SET_SU_LD_ST_TARGET_A

#define P_NV91C0_SET_SU_LD_ST_TARGET_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SU_LD_ST_TARGET_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SU_LD_ST_TARGET_A(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SU_LD_ST_TARGET_B {
    uint32_t offset_lower;
};

static inline void
__NV91C0_SET_SU_LD_ST_TARGET_B(uint32_t *val_out, struct nv_nv91c0_SET_SU_LD_ST_TARGET_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NV91C0_SET_SU_LD_ST_TARGET_B(val, args...) { \
    struct nv_nv91c0_SET_SU_LD_ST_TARGET_B __data = { .offset_lower = (args) }; \
    __NV91C0_SET_SU_LD_ST_TARGET_B(&val, __data); \
}

#define VA_NV91C0_SET_SU_LD_ST_TARGET_B(i) V_NV91C0_SET_SU_LD_ST_TARGET_B

#define P_NV91C0_SET_SU_LD_ST_TARGET_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SU_LD_ST_TARGET_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SU_LD_ST_TARGET_B(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SU_LD_ST_TARGET_C {
    uint32_t width;
};

static inline void
__NV91C0_SET_SU_LD_ST_TARGET_C(uint32_t *val_out, struct nv_nv91c0_SET_SU_LD_ST_TARGET_C st)
{
    uint32_t val = 0;
    
    val |= st.width;
    *val_out = val;
}

#define V_NV91C0_SET_SU_LD_ST_TARGET_C(val, args...) { \
    struct nv_nv91c0_SET_SU_LD_ST_TARGET_C __data = { .width = (args) }; \
    __NV91C0_SET_SU_LD_ST_TARGET_C(&val, __data); \
}

#define VA_NV91C0_SET_SU_LD_ST_TARGET_C(i) V_NV91C0_SET_SU_LD_ST_TARGET_C

#define P_NV91C0_SET_SU_LD_ST_TARGET_C(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SU_LD_ST_TARGET_C(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SU_LD_ST_TARGET_C(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SU_LD_ST_TARGET_D {
    uint32_t height;
    uint32_t layout_in_memory;
};

static inline void
__NV91C0_SET_SU_LD_ST_TARGET_D(uint32_t *val_out, struct nv_nv91c0_SET_SU_LD_ST_TARGET_D st)
{
    uint32_t val = 0;
    
    assert(st.height < (1ULL << 17));
    val |= st.height << 0;
    
    assert(st.layout_in_memory < (1ULL << 1));
    val |= st.layout_in_memory << 20;
    *val_out = val;
}

#define V_NV91C0_SET_SU_LD_ST_TARGET_D(val, args...) { \
    UNUSED uint32_t LAYOUT_IN_MEMORY_BLOCKLINEAR = NV91C0_SET_SU_LD_ST_TARGET_D_LAYOUT_IN_MEMORY_BLOCKLINEAR; \
    UNUSED uint32_t LAYOUT_IN_MEMORY_PITCH = NV91C0_SET_SU_LD_ST_TARGET_D_LAYOUT_IN_MEMORY_PITCH; \
    struct nv_nv91c0_SET_SU_LD_ST_TARGET_D __data = args; \
    __NV91C0_SET_SU_LD_ST_TARGET_D(&val, __data); \
}

#define VA_NV91C0_SET_SU_LD_ST_TARGET_D(i) V_NV91C0_SET_SU_LD_ST_TARGET_D

#define P_NV91C0_SET_SU_LD_ST_TARGET_D(push, idx, args...) do { \
    UNUSED uint32_t LAYOUT_IN_MEMORY_BLOCKLINEAR = NV91C0_SET_SU_LD_ST_TARGET_D_LAYOUT_IN_MEMORY_BLOCKLINEAR; \
    UNUSED uint32_t LAYOUT_IN_MEMORY_PITCH = NV91C0_SET_SU_LD_ST_TARGET_D_LAYOUT_IN_MEMORY_PITCH; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SU_LD_ST_TARGET_D(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SU_LD_ST_TARGET_D(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SU_LD_ST_TARGET_FORMAT {
    uint32_t type;
    uint32_t color;
    uint32_t zeta;
    uint32_t suq_pixfmt;
};

static inline void
__NV91C0_SET_SU_LD_ST_TARGET_FORMAT(uint32_t *val_out, struct nv_nv91c0_SET_SU_LD_ST_TARGET_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.type < (1ULL << 1));
    val |= st.type << 0;
    
    assert(st.color < (1ULL << 8));
    val |= st.color << 4;
    
    assert(st.zeta < (1ULL << 5));
    val |= st.zeta << 12;
    
    assert(st.suq_pixfmt < (1ULL << 9));
    val |= st.suq_pixfmt << 17;
    *val_out = val;
}

#define V_NV91C0_SET_SU_LD_ST_TARGET_FORMAT(val, args...) { \
    UNUSED uint32_t TYPE_COLOR = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_TYPE_COLOR; \
    UNUSED uint32_t TYPE_ZETA = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_TYPE_ZETA; \
    UNUSED uint32_t COLOR_DISABLED = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_DISABLED; \
    UNUSED uint32_t COLOR_RF32_GF32_BF32_AF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_GF32_BF32_AF32; \
    UNUSED uint32_t COLOR_RS32_GS32_BS32_AS32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32_GS32_BS32_AS32; \
    UNUSED uint32_t COLOR_RU32_GU32_BU32_AU32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32_GU32_BU32_AU32; \
    UNUSED uint32_t COLOR_RF32_GF32_BF32_X32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_GF32_BF32_X32; \
    UNUSED uint32_t COLOR_RS32_GS32_BS32_X32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32_GS32_BS32_X32; \
    UNUSED uint32_t COLOR_RU32_GU32_BU32_X32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32_GU32_BU32_X32; \
    UNUSED uint32_t COLOR_R16_G16_B16_A16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16_G16_B16_A16; \
    UNUSED uint32_t COLOR_RN16_GN16_BN16_AN16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN16_GN16_BN16_AN16; \
    UNUSED uint32_t COLOR_RS16_GS16_BS16_AS16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS16_GS16_BS16_AS16; \
    UNUSED uint32_t COLOR_RU16_GU16_BU16_AU16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU16_GU16_BU16_AU16; \
    UNUSED uint32_t COLOR_RF16_GF16_BF16_AF16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_GF16_BF16_AF16; \
    UNUSED uint32_t COLOR_RF32_GF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_GF32; \
    UNUSED uint32_t COLOR_RS32_GS32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32_GS32; \
    UNUSED uint32_t COLOR_RU32_GU32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32_GU32; \
    UNUSED uint32_t COLOR_RF16_GF16_BF16_X16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_GF16_BF16_X16; \
    UNUSED uint32_t COLOR_A8R8G8B8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8R8G8B8; \
    UNUSED uint32_t COLOR_A8RL8GL8BL8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8RL8GL8BL8; \
    UNUSED uint32_t COLOR_A2B10G10R10 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A2B10G10R10; \
    UNUSED uint32_t COLOR_AU2BU10GU10RU10 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AU2BU10GU10RU10; \
    UNUSED uint32_t COLOR_A8B8G8R8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8B8G8R8; \
    UNUSED uint32_t COLOR_A8BL8GL8RL8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8BL8GL8RL8; \
    UNUSED uint32_t COLOR_AN8BN8GN8RN8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AN8BN8GN8RN8; \
    UNUSED uint32_t COLOR_AS8BS8GS8RS8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AS8BS8GS8RS8; \
    UNUSED uint32_t COLOR_AU8BU8GU8RU8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AU8BU8GU8RU8; \
    UNUSED uint32_t COLOR_R16_G16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16_G16; \
    UNUSED uint32_t COLOR_RN16_GN16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN16_GN16; \
    UNUSED uint32_t COLOR_RS16_GS16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS16_GS16; \
    UNUSED uint32_t COLOR_RU16_GU16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU16_GU16; \
    UNUSED uint32_t COLOR_RF16_GF16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_GF16; \
    UNUSED uint32_t COLOR_A2R10G10B10 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A2R10G10B10; \
    UNUSED uint32_t COLOR_BF10GF11RF11 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_BF10GF11RF11; \
    UNUSED uint32_t COLOR_RS32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32; \
    UNUSED uint32_t COLOR_RU32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32; \
    UNUSED uint32_t COLOR_RF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32; \
    UNUSED uint32_t COLOR_X8R8G8B8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8R8G8B8; \
    UNUSED uint32_t COLOR_X8RL8GL8BL8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8RL8GL8BL8; \
    UNUSED uint32_t COLOR_R5G6B5 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R5G6B5; \
    UNUSED uint32_t COLOR_A1R5G5B5 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A1R5G5B5; \
    UNUSED uint32_t COLOR_G8R8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_G8R8; \
    UNUSED uint32_t COLOR_GN8RN8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_GN8RN8; \
    UNUSED uint32_t COLOR_GS8RS8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_GS8RS8; \
    UNUSED uint32_t COLOR_GU8RU8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_GU8RU8; \
    UNUSED uint32_t COLOR_R16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16; \
    UNUSED uint32_t COLOR_RN16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN16; \
    UNUSED uint32_t COLOR_RS16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS16; \
    UNUSED uint32_t COLOR_RU16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU16; \
    UNUSED uint32_t COLOR_RF16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16; \
    UNUSED uint32_t COLOR_R8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R8; \
    UNUSED uint32_t COLOR_RN8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN8; \
    UNUSED uint32_t COLOR_RS8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS8; \
    UNUSED uint32_t COLOR_RU8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU8; \
    UNUSED uint32_t COLOR_A8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8; \
    UNUSED uint32_t COLOR_X1R5G5B5 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_X1R5G5B5; \
    UNUSED uint32_t COLOR_X8B8G8R8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8B8G8R8; \
    UNUSED uint32_t COLOR_X8BL8GL8RL8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8BL8GL8RL8; \
    UNUSED uint32_t COLOR_Z1R5G5B5 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_Z1R5G5B5; \
    UNUSED uint32_t COLOR_O1R5G5B5 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_O1R5G5B5; \
    UNUSED uint32_t COLOR_Z8R8G8B8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_Z8R8G8B8; \
    UNUSED uint32_t COLOR_O8R8G8B8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_O8R8G8B8; \
    UNUSED uint32_t COLOR_R32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R32; \
    UNUSED uint32_t COLOR_A16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A16; \
    UNUSED uint32_t COLOR_AF16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AF16; \
    UNUSED uint32_t COLOR_AF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AF32; \
    UNUSED uint32_t COLOR_A8R8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8R8; \
    UNUSED uint32_t COLOR_R16_A16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16_A16; \
    UNUSED uint32_t COLOR_RF16_AF16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_AF16; \
    UNUSED uint32_t COLOR_RF32_AF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_AF32; \
    UNUSED uint32_t COLOR_B8G8R8A8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_B8G8R8A8; \
    UNUSED uint32_t ZETA_Z16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_Z16; \
    UNUSED uint32_t ZETA_Z24S8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_Z24S8; \
    UNUSED uint32_t ZETA_X8Z24 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_X8Z24; \
    UNUSED uint32_t ZETA_S8Z24 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_S8Z24; \
    UNUSED uint32_t ZETA_V8Z24 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_V8Z24; \
    UNUSED uint32_t ZETA_ZF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32; \
    UNUSED uint32_t ZETA_ZF32_X24S8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32_X24S8; \
    UNUSED uint32_t ZETA_X8Z24_X16V8S8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_X8Z24_X16V8S8; \
    UNUSED uint32_t ZETA_ZF32_X16V8X8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32_X16V8X8; \
    UNUSED uint32_t ZETA_ZF32_X16V8S8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32_X16V8S8; \
    struct nv_nv91c0_SET_SU_LD_ST_TARGET_FORMAT __data = args; \
    __NV91C0_SET_SU_LD_ST_TARGET_FORMAT(&val, __data); \
}

#define VA_NV91C0_SET_SU_LD_ST_TARGET_FORMAT(i) V_NV91C0_SET_SU_LD_ST_TARGET_FORMAT

#define P_NV91C0_SET_SU_LD_ST_TARGET_FORMAT(push, idx, args...) do { \
    UNUSED uint32_t TYPE_COLOR = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_TYPE_COLOR; \
    UNUSED uint32_t TYPE_ZETA = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_TYPE_ZETA; \
    UNUSED uint32_t COLOR_DISABLED = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_DISABLED; \
    UNUSED uint32_t COLOR_RF32_GF32_BF32_AF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_GF32_BF32_AF32; \
    UNUSED uint32_t COLOR_RS32_GS32_BS32_AS32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32_GS32_BS32_AS32; \
    UNUSED uint32_t COLOR_RU32_GU32_BU32_AU32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32_GU32_BU32_AU32; \
    UNUSED uint32_t COLOR_RF32_GF32_BF32_X32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_GF32_BF32_X32; \
    UNUSED uint32_t COLOR_RS32_GS32_BS32_X32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32_GS32_BS32_X32; \
    UNUSED uint32_t COLOR_RU32_GU32_BU32_X32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32_GU32_BU32_X32; \
    UNUSED uint32_t COLOR_R16_G16_B16_A16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16_G16_B16_A16; \
    UNUSED uint32_t COLOR_RN16_GN16_BN16_AN16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN16_GN16_BN16_AN16; \
    UNUSED uint32_t COLOR_RS16_GS16_BS16_AS16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS16_GS16_BS16_AS16; \
    UNUSED uint32_t COLOR_RU16_GU16_BU16_AU16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU16_GU16_BU16_AU16; \
    UNUSED uint32_t COLOR_RF16_GF16_BF16_AF16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_GF16_BF16_AF16; \
    UNUSED uint32_t COLOR_RF32_GF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_GF32; \
    UNUSED uint32_t COLOR_RS32_GS32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32_GS32; \
    UNUSED uint32_t COLOR_RU32_GU32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32_GU32; \
    UNUSED uint32_t COLOR_RF16_GF16_BF16_X16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_GF16_BF16_X16; \
    UNUSED uint32_t COLOR_A8R8G8B8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8R8G8B8; \
    UNUSED uint32_t COLOR_A8RL8GL8BL8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8RL8GL8BL8; \
    UNUSED uint32_t COLOR_A2B10G10R10 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A2B10G10R10; \
    UNUSED uint32_t COLOR_AU2BU10GU10RU10 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AU2BU10GU10RU10; \
    UNUSED uint32_t COLOR_A8B8G8R8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8B8G8R8; \
    UNUSED uint32_t COLOR_A8BL8GL8RL8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8BL8GL8RL8; \
    UNUSED uint32_t COLOR_AN8BN8GN8RN8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AN8BN8GN8RN8; \
    UNUSED uint32_t COLOR_AS8BS8GS8RS8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AS8BS8GS8RS8; \
    UNUSED uint32_t COLOR_AU8BU8GU8RU8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AU8BU8GU8RU8; \
    UNUSED uint32_t COLOR_R16_G16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16_G16; \
    UNUSED uint32_t COLOR_RN16_GN16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN16_GN16; \
    UNUSED uint32_t COLOR_RS16_GS16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS16_GS16; \
    UNUSED uint32_t COLOR_RU16_GU16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU16_GU16; \
    UNUSED uint32_t COLOR_RF16_GF16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_GF16; \
    UNUSED uint32_t COLOR_A2R10G10B10 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A2R10G10B10; \
    UNUSED uint32_t COLOR_BF10GF11RF11 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_BF10GF11RF11; \
    UNUSED uint32_t COLOR_RS32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32; \
    UNUSED uint32_t COLOR_RU32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32; \
    UNUSED uint32_t COLOR_RF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32; \
    UNUSED uint32_t COLOR_X8R8G8B8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8R8G8B8; \
    UNUSED uint32_t COLOR_X8RL8GL8BL8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8RL8GL8BL8; \
    UNUSED uint32_t COLOR_R5G6B5 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R5G6B5; \
    UNUSED uint32_t COLOR_A1R5G5B5 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A1R5G5B5; \
    UNUSED uint32_t COLOR_G8R8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_G8R8; \
    UNUSED uint32_t COLOR_GN8RN8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_GN8RN8; \
    UNUSED uint32_t COLOR_GS8RS8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_GS8RS8; \
    UNUSED uint32_t COLOR_GU8RU8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_GU8RU8; \
    UNUSED uint32_t COLOR_R16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16; \
    UNUSED uint32_t COLOR_RN16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN16; \
    UNUSED uint32_t COLOR_RS16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS16; \
    UNUSED uint32_t COLOR_RU16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU16; \
    UNUSED uint32_t COLOR_RF16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16; \
    UNUSED uint32_t COLOR_R8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R8; \
    UNUSED uint32_t COLOR_RN8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN8; \
    UNUSED uint32_t COLOR_RS8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS8; \
    UNUSED uint32_t COLOR_RU8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU8; \
    UNUSED uint32_t COLOR_A8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8; \
    UNUSED uint32_t COLOR_X1R5G5B5 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_X1R5G5B5; \
    UNUSED uint32_t COLOR_X8B8G8R8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8B8G8R8; \
    UNUSED uint32_t COLOR_X8BL8GL8RL8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8BL8GL8RL8; \
    UNUSED uint32_t COLOR_Z1R5G5B5 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_Z1R5G5B5; \
    UNUSED uint32_t COLOR_O1R5G5B5 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_O1R5G5B5; \
    UNUSED uint32_t COLOR_Z8R8G8B8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_Z8R8G8B8; \
    UNUSED uint32_t COLOR_O8R8G8B8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_O8R8G8B8; \
    UNUSED uint32_t COLOR_R32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R32; \
    UNUSED uint32_t COLOR_A16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A16; \
    UNUSED uint32_t COLOR_AF16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AF16; \
    UNUSED uint32_t COLOR_AF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_AF32; \
    UNUSED uint32_t COLOR_A8R8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8R8; \
    UNUSED uint32_t COLOR_R16_A16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16_A16; \
    UNUSED uint32_t COLOR_RF16_AF16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_AF16; \
    UNUSED uint32_t COLOR_RF32_AF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_AF32; \
    UNUSED uint32_t COLOR_B8G8R8A8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_COLOR_B8G8R8A8; \
    UNUSED uint32_t ZETA_Z16 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_Z16; \
    UNUSED uint32_t ZETA_Z24S8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_Z24S8; \
    UNUSED uint32_t ZETA_X8Z24 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_X8Z24; \
    UNUSED uint32_t ZETA_S8Z24 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_S8Z24; \
    UNUSED uint32_t ZETA_V8Z24 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_V8Z24; \
    UNUSED uint32_t ZETA_ZF32 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32; \
    UNUSED uint32_t ZETA_ZF32_X24S8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32_X24S8; \
    UNUSED uint32_t ZETA_X8Z24_X16V8S8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_X8Z24_X16V8S8; \
    UNUSED uint32_t ZETA_ZF32_X16V8X8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32_X16V8X8; \
    UNUSED uint32_t ZETA_ZF32_X16V8S8 = NV91C0_SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32_X16V8S8; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SU_LD_ST_TARGET_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SU_LD_ST_TARGET_FORMAT(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SU_LD_ST_TARGET_BLOCK_SIZE {
    uint32_t width;
    uint32_t height;
};

static inline void
__NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE(uint32_t *val_out, struct nv_nv91c0_SET_SU_LD_ST_TARGET_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 4));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 4));
    val |= st.height << 4;
    *val_out = val;
}

#define V_NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t WIDTH_ONE_GOB = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    struct nv_nv91c0_SET_SU_LD_ST_TARGET_BLOCK_SIZE __data = args; \
    __NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE(&val, __data); \
}

#define VA_NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE(i) V_NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE

#define P_NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE(push, idx, args...) do { \
    UNUSED uint32_t WIDTH_ONE_GOB = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SU_LD_ST_TARGET_BLOCK_SIZE(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_VALUE {
    uint32_t v;
};

static inline void
__NV91C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_VALUE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(val, args...) { \
    struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_VALUE __data = { .v = (args) }; \
    __NV91C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(i) V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE

#define P_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_EVENT {
    uint32_t event;
};

static inline void
__NV91C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_EVENT st)
{
    uint32_t val = 0;
    
    assert(st.event < (1ULL << 8));
    val |= st.event << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(val, args...) { \
    struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_EVENT __data = { .event = (args) }; \
    __NV91C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(i) V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT

#define P_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A {
    uint32_t event0;
    uint32_t bit_select0;
    uint32_t event1;
    uint32_t bit_select1;
    uint32_t event2;
    uint32_t bit_select2;
    uint32_t event3;
    uint32_t bit_select3;
};

static inline void
__NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A st)
{
    uint32_t val = 0;
    
    assert(st.event0 < (1ULL << 3));
    val |= st.event0 << 0;
    
    assert(st.bit_select0 < (1ULL << 3));
    val |= st.bit_select0 << 4;
    
    assert(st.event1 < (1ULL << 3));
    val |= st.event1 << 8;
    
    assert(st.bit_select1 < (1ULL << 3));
    val |= st.bit_select1 << 12;
    
    assert(st.event2 < (1ULL << 3));
    val |= st.event2 << 16;
    
    assert(st.bit_select2 < (1ULL << 3));
    val |= st.bit_select2 << 20;
    
    assert(st.event3 < (1ULL << 3));
    val |= st.event3 << 24;
    
    assert(st.bit_select3 < (1ULL << 3));
    val |= st.bit_select3 << 28;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(val, args...) { \
    struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A __data = args; \
    __NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(i) V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A

#define P_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B {
    uint32_t edge;
    uint32_t func;
};

static inline void
__NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B st)
{
    uint32_t val = 0;
    
    assert(st.edge < (1ULL << 1));
    val |= st.edge << 0;
    
    assert(st.func < (1ULL << 16));
    val |= st.func << 4;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(val, args...) { \
    struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B __data = args; \
    __NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(i) V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B

#define P_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL {
    uint32_t mask;
};

static inline void
__NV91C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(uint32_t *val_out, struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.mask < (1ULL << 8));
    val |= st.mask << 0;
    *val_out = val;
}

#define V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(val, args...) { \
    struct nv_nv91c0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL __data = { .mask = (args) }; \
    __NV91C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(&val, __data); \
}

#define VA_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL

#define P_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nv91c0_SET_MME_SHADOW_SCRATCH {
    uint32_t v;
};

static inline void
__NV91C0_SET_MME_SHADOW_SCRATCH(uint32_t *val_out, struct nv_nv91c0_SET_MME_SHADOW_SCRATCH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_SET_MME_SHADOW_SCRATCH(val, args...) { \
    struct nv_nv91c0_SET_MME_SHADOW_SCRATCH __data = { .v = (args) }; \
    __NV91C0_SET_MME_SHADOW_SCRATCH(&val, __data); \
}

#define VA_NV91C0_SET_MME_SHADOW_SCRATCH(i) V_NV91C0_SET_MME_SHADOW_SCRATCH

#define P_NV91C0_SET_MME_SHADOW_SCRATCH(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_SET_MME_SHADOW_SCRATCH(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_SET_MME_SHADOW_SCRATCH(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_CALL_MME_MACRO {
    uint32_t v;
};

static inline void
__NV91C0_CALL_MME_MACRO(uint32_t *val_out, struct nv_nv91c0_CALL_MME_MACRO st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_CALL_MME_MACRO(val, args...) { \
    struct nv_nv91c0_CALL_MME_MACRO __data = { .v = (args) }; \
    __NV91C0_CALL_MME_MACRO(&val, __data); \
}

#define VA_NV91C0_CALL_MME_MACRO(i) V_NV91C0_CALL_MME_MACRO

#define P_NV91C0_CALL_MME_MACRO(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_CALL_MME_MACRO(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_CALL_MME_MACRO(idx), nvk_p_ret); \
} while(0)

struct nv_nv91c0_CALL_MME_DATA {
    uint32_t v;
};

static inline void
__NV91C0_CALL_MME_DATA(uint32_t *val_out, struct nv_nv91c0_CALL_MME_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV91C0_CALL_MME_DATA(val, args...) { \
    struct nv_nv91c0_CALL_MME_DATA __data = { .v = (args) }; \
    __NV91C0_CALL_MME_DATA(&val, __data); \
}

#define VA_NV91C0_CALL_MME_DATA(i) V_NV91C0_CALL_MME_DATA

#define P_NV91C0_CALL_MME_DATA(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV91C0_CALL_MME_DATA(nvk_p_ret, args); \
    nv_push_val(push, NV91C0_CALL_MME_DATA(idx), nvk_p_ret); \
} while(0)


const char *P_PARSE_NV91C0_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NV91C0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
