// This file was generated by qtwaylandscanner
// source file is wayland-drm.xml

#include "qwayland-server-drm.h"

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")

namespace QtWaylandServer {

    int wl_drm::deferred_destroy_global_func(void *data) {
        auto object = static_cast<wl_drm *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->drm_destroy_global();
        return 0;
    }

    wl_drm::wl_drm(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    wl_drm::wl_drm(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    wl_drm::wl_drm(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    wl_drm::wl_drm()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    wl_drm::~wl_drm()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->drm_object = nullptr;

        if (m_resource)
            m_resource->drm_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_drm::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_drm::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_drm::Resource *wl_drm::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_drm::Resource *wl_drm::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_drm::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::wl_drm_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_drm::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_drm::interface()
    {
        return &::wl_drm_interface;
    }

    wl_drm::Resource *wl_drm::drm_allocate()
    {
        return new Resource;
    }

    void wl_drm::drm_destroy_global()
    {
    }

    void wl_drm::drm_bind_resource(Resource *)
    {
    }

    void wl_drm::drm_destroy_resource(Resource *)
    {
    }

    void wl_drm::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_drm *that = static_cast<wl_drm *>(data);
        that->add(client, id, version);
    }

    void wl_drm::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_drm *that = static_cast<wl_drm::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void wl_drm::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_drm *that = resource->drm_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->drm_destroy_resource(resource);

            that = resource->drm_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void wl_drm::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    wl_drm::Resource *wl_drm::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_drm_interface, version, id);
        return bind(handle);
    }

    wl_drm::Resource *wl_drm::bind(struct ::wl_resource *handle)
    {
        Resource *resource = drm_allocate();
        resource->drm_object = this;

        wl_resource_set_implementation(handle, &m_wl_drm_interface, resource, destroy_func);
        resource->handle = handle;
        drm_bind_resource(resource);
        return resource;
    }
    wl_drm::Resource *wl_drm::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_drm_interface, &m_wl_drm_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_drm_interface wl_drm::m_wl_drm_interface = {
        wl_drm::handle_authenticate,
        wl_drm::handle_create_buffer,
        wl_drm::handle_create_planar_buffer,
        wl_drm::handle_create_prime_buffer
    };

    void wl_drm::drm_authenticate(Resource *, uint32_t )
    {
    }

    void wl_drm::drm_create_buffer(Resource *, uint32_t, uint32_t , int32_t , int32_t , uint32_t , uint32_t )
    {
    }

    void wl_drm::drm_create_planar_buffer(Resource *, uint32_t, uint32_t , int32_t , int32_t , uint32_t , int32_t , int32_t , int32_t , int32_t , int32_t , int32_t )
    {
    }

    void wl_drm::drm_create_prime_buffer(Resource *, uint32_t, int32_t , int32_t , int32_t , uint32_t , int32_t , int32_t , int32_t , int32_t , int32_t , int32_t )
    {
    }


    void wl_drm::handle_authenticate(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->drm_object)) {
            return;
        }
        static_cast<wl_drm *>(r->drm_object)->drm_authenticate(
            r,
            id);
    }

    void wl_drm::handle_create_buffer(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        uint32_t name,
        int32_t width,
        int32_t height,
        uint32_t stride,
        uint32_t format)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->drm_object)) {
            return;
        }
        static_cast<wl_drm *>(r->drm_object)->drm_create_buffer(
            r,
            id,
            name,
            width,
            height,
            stride,
            format);
    }

    void wl_drm::handle_create_planar_buffer(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        uint32_t name,
        int32_t width,
        int32_t height,
        uint32_t format,
        int32_t offset0,
        int32_t stride0,
        int32_t offset1,
        int32_t stride1,
        int32_t offset2,
        int32_t stride2)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->drm_object)) {
            return;
        }
        static_cast<wl_drm *>(r->drm_object)->drm_create_planar_buffer(
            r,
            id,
            name,
            width,
            height,
            format,
            offset0,
            stride0,
            offset1,
            stride1,
            offset2,
            stride2);
    }

    void wl_drm::handle_create_prime_buffer(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        int32_t name,
        int32_t width,
        int32_t height,
        uint32_t format,
        int32_t offset0,
        int32_t stride0,
        int32_t offset1,
        int32_t stride1,
        int32_t offset2,
        int32_t stride2)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->drm_object)) {
        close(name);
            return;
        }
        static_cast<wl_drm *>(r->drm_object)->drm_create_prime_buffer(
            r,
            id,
            name,
            width,
            height,
            format,
            offset0,
            stride0,
            offset1,
            stride1,
            offset2,
            stride2);
    }

    void wl_drm::send_device(const QString &name)
    {
        Q_ASSERT_X(m_resource, "wl_drm::device", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_drm::device as it's not initialised");
            return;
        }
        send_device(
            m_resource->handle,
            name);
    }

    void wl_drm::send_device(struct ::wl_resource *resource, const QString &name)
    {
        wl_drm_send_device(
            resource,
            name.toUtf8().constData());
    }


    void wl_drm::send_format(uint32_t format)
    {
        Q_ASSERT_X(m_resource, "wl_drm::format", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_drm::format as it's not initialised");
            return;
        }
        send_format(
            m_resource->handle,
            format);
    }

    void wl_drm::send_format(struct ::wl_resource *resource, uint32_t format)
    {
        wl_drm_send_format(
            resource,
            format);
    }


    void wl_drm::send_authenticated()
    {
        Q_ASSERT_X(m_resource, "wl_drm::authenticated", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_drm::authenticated as it's not initialised");
            return;
        }
        send_authenticated(
            m_resource->handle);
    }

    void wl_drm::send_authenticated(struct ::wl_resource *resource)
    {
        wl_drm_send_authenticated(
            resource);
    }


    void wl_drm::send_capabilities(uint32_t value)
    {
        Q_ASSERT_X(m_resource, "wl_drm::capabilities", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_drm::capabilities as it's not initialised");
            return;
        }
        send_capabilities(
            m_resource->handle,
            value);
    }

    void wl_drm::send_capabilities(struct ::wl_resource *resource, uint32_t value)
    {
        wl_drm_send_capabilities(
            resource,
            value);
    }

}

QT_WARNING_POP
QT_END_NAMESPACE
