
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kpageview_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <kpageview.h>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPageView_Type = nullptr;
static PyTypeObject *Sbk_KPageView_TypeF(void)
{
    return _Sbk_KPageView_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KPageViewWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KPageViewWrapper::KPageViewWrapper(::QWidget * parent) : KPageView(parent)
{
}

void KPageViewWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPageView", funcName, gil, pyOverride, signal);
}

void KPageViewWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KPageView", funcName, gil, pyOverride, event);
}

::QAbstractItemView * KPageViewWrapper::createView()
{
    static const char *funcName = "createView";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPageView::createView();
    }
    return sbk_o_createView("KPageView", funcName, gil, pyOverride);
}

::QAbstractItemView * KPageViewWrapper::sbk_o_createView(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractItemView_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QAbstractItemView >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QAbstractItemView *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KPageViewWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KPageView", funcName, gil, pyOverride, event);
}

int KPageViewWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KPageView", funcName, gil, pyOverride);
}

void KPageViewWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPageView", funcName, gil, pyOverride, signal);
}

void KPageViewWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KPageView", funcName, gil, pyOverride, event);
}

bool KPageViewWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KPageView", funcName, gil, pyOverride, event);
}

bool KPageViewWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KPageView", funcName, gil, pyOverride, watched, event);
}

void KPageViewWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KPageView", funcName, gil, pyOverride, event);
}

bool KPageViewWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KPageView", funcName, gil, pyOverride, next);
}

void KPageViewWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KPageView", funcName, gil, pyOverride, event);
}

bool KPageViewWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KPageView", funcName, gil, pyOverride);
}

int KPageViewWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KPageView", funcName, gil, pyOverride, arg__1);
}

void KPageViewWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KPageView", funcName, gil, pyOverride, painter);
}

void KPageViewWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KPageView", funcName, gil, pyOverride, event);
}

::QVariant KPageViewWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KPageView", funcName, gil, pyOverride, arg__1);
}

void KPageViewWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KPageView", funcName, gil, pyOverride, event);
}

int KPageViewWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KPageView", funcName, gil, pyOverride, arg__1);
}

::QSize KPageViewWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KPageView", funcName, gil, pyOverride);
}

void KPageViewWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KPageView", funcName, gil, pyOverride, event);
}

bool KPageViewWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KPageView", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KPageViewWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KPageView", funcName, gil, pyOverride);
}

void KPageViewWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KPageView", funcName, gil, pyOverride, event);
}

::QPaintDevice * KPageViewWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KPageView", funcName, gil, pyOverride, offset);
}

void KPageViewWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KPageView", funcName, gil, pyOverride, visible);
}

::QPainter * KPageViewWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KPageView", funcName, gil, pyOverride);
}

void KPageViewWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KPageView", funcName, gil, pyOverride, event);
}

bool KPageViewWrapper::showPageHeader() const
{
    static const char *funcName = "showPageHeader";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPageView::showPageHeader();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KPageView", funcName, gil, pyOverride);
}

::QSize KPageViewWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KPageView", funcName, gil, pyOverride);
}

void KPageViewWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KPageView", funcName, gil, pyOverride, event);
}

void KPageViewWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KPageView", funcName, gil, pyOverride, event);
}

::QFlags<Qt::AlignmentFlag> KPageViewWrapper::viewPosition() const
{
    static const char *funcName = "viewPosition";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::KPageView::viewPosition();
    }
    return sbk_o_viewPosition("KPageView", funcName, gil, pyOverride);
}

::QFlags<Qt::AlignmentFlag> KPageViewWrapper::sbk_o_viewPosition(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return QFlags<Qt::AlignmentFlag>(0);
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QFlags<Qt::AlignmentFlag> >()), Py_TYPE(pyResult)->tp_name);
        return QFlags<Qt::AlignmentFlag>(0);
    }
    ::QFlags<Qt::AlignmentFlag> cppResult = QFlags<Qt::AlignmentFlag>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KPageViewWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPageView_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KPageView", funcName, gil, pyOverride, event);
}

const QMetaObject *KPageViewWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KPageView::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KPageViewWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KPageView::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KPageViewWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KPageViewWrapper *>(this));
    }
    return KPageView::qt_metacast(_clname);
}

KPageViewWrapper::~KPageViewWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KPageView_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPageView_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPageView >()))
        return -1;

    KPageViewWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KPageView", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPageView::KPageView(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KPageView(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KPageView(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KPageView(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KPageViewWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KPageViewWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KPageView >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KPageViewFunc_createView(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // createView()
        QAbstractItemView * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KPageView::createView()
            : cppSelf->createView();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractItemView_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageViewFunc_currentPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentPage()const
        QModelIndex cppResult = const_cast<const ::KPageView *>(cppSelf)->currentPage();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageViewFunc_faceType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // faceType()const
        KPageView::FaceType cppResult = const_cast<const ::KPageView *>(cppSelf)->faceType();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_FaceType_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageViewFunc_itemDelegate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // itemDelegate()const
        QAbstractItemDelegate * cppResult = const_cast<const ::KPageView *>(cppSelf)->itemDelegate();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractItemDelegate_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageViewFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // model()const
        QAbstractItemModel * cppResult = const_cast<const ::KPageView *>(cppSelf)->model();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageViewFunc_pageFooter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pageFooter()const
        QWidget * cppResult = const_cast<const ::KPageView *>(cppSelf)->pageFooter();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageViewFunc_pageHeader(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pageHeader()const
        QWidget * cppResult = const_cast<const ::KPageView *>(cppSelf)->pageHeader();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageViewFunc_setCurrentPage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageView::setCurrentPage(QModelIndex)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // setCurrentPage(QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentPage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentPage(QModelIndex)
            cppSelf->setCurrentPage(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageViewFunc_setDefaultWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageView::setDefaultWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDefaultWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDefaultWidget(QWidget*)
            cppSelf->setDefaultWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageViewFunc_setFaceType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageView::setFaceType(KPageView::FaceType)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_FaceType_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setFaceType(KPageView::FaceType)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFaceType", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);

    // Call function/method
    {
        ::KPageView::FaceType cppArg0{KPageView::Auto};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFaceType(KPageView::FaceType)
            cppSelf->setFaceType(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageViewFunc_setItemDelegate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageView::setItemDelegate(QAbstractItemDelegate*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractItemDelegate_IDX]), (pyArg)))) {
        overloadId = 0; // setItemDelegate(QAbstractItemDelegate*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setItemDelegate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemDelegate *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setItemDelegate(QAbstractItemDelegate*)
            cppSelf->setItemDelegate(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageViewFunc_setModel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageView::setModel(QAbstractItemModel*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX]), (pyArg)))) {
        overloadId = 0; // setModel(QAbstractItemModel*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setModel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemModel *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setModel(QAbstractItemModel*)
            cppSelf->setModel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageViewFunc_setPageFooter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageView::setPageFooter(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // setPageFooter(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPageFooter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPageFooter(QWidget*)
            cppSelf->setPageFooter(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageViewFunc_setPageHeader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPageView::setPageHeader(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // setPageHeader(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPageHeader", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPageHeader(QWidget*)
            cppSelf->setPageHeader(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPageViewFunc_showPageHeader(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showPageHeader()const
        bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KPageView *>(cppSelf)->::KPageView::showPageHeader()
            : const_cast<const ::KPageView *>(cppSelf)->showPageHeader();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPageViewFunc_viewPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // viewPosition()const
        QFlags<Qt::AlignmentFlag> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KPageView *>(cppSelf)->::KPageView::viewPosition()
            : const_cast<const ::KPageView *>(cppSelf)->viewPosition();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KPageView_PropertyStrings[] = {
    "faceType::",
    "pageFooter::",
    "pageHeader::",
    nullptr // Sentinel
};

static const char *Sbk_KPageView_EnumFlagInfo[] = {
    "FaceType:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPageView_methods[] = {
    {"createView", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_createView), METH_NOARGS, nullptr},
    {"currentPage", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_currentPage), METH_NOARGS, nullptr},
    {"faceType", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_faceType), METH_NOARGS, nullptr},
    {"itemDelegate", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_itemDelegate), METH_NOARGS, nullptr},
    {"model", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_model), METH_NOARGS, nullptr},
    {"pageFooter", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_pageFooter), METH_NOARGS, nullptr},
    {"pageHeader", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_pageHeader), METH_NOARGS, nullptr},
    {"setCurrentPage", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_setCurrentPage), METH_O, nullptr},
    {"setDefaultWidget", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_setDefaultWidget), METH_O, nullptr},
    {"setFaceType", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_setFaceType), METH_O, nullptr},
    {"setItemDelegate", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_setItemDelegate), METH_O, nullptr},
    {"setModel", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_setModel), METH_O, nullptr},
    {"setPageFooter", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_setPageFooter), METH_O, nullptr},
    {"setPageHeader", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_setPageHeader), METH_O, nullptr},
    {"showPageHeader", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_showPageHeader), METH_NOARGS, nullptr},
    {"viewPosition", reinterpret_cast<PyCFunction>(Sbk_KPageViewFunc_viewPosition), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KPageView_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KPageView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KPageViewWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KPageView_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPageView_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KPageViewSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KPageView *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPageView_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KPageView_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPageView_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPageView_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPageView_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPageView_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPageView_spec = {
    "1:KWidgetsAddons.KPageView",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPageView_slots
};

} //extern "C"

static void *Sbk_KPageView_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KPageView *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KPageView *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KPageView *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KPageView_FaceType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KPageView::FaceType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KPageView::FaceType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KPageView_FaceType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageView_FaceType_IDX])))
        return Enum_PythonToCpp_KPageView_FaceType;
    return {};
}

static PyObject *KPageView_FaceType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KPageView::FaceType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KPageView::FaceType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPageView_PythonToCpp_KPageView_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPageView_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPageView_PythonToCpp_KPageView_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPageView_TypeF()))
        return KPageView_PythonToCpp_KPageView_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPageView_PTR_CppToPython_KPageView(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KPageView *>(const_cast<void *>(cppIn)), Sbk_KPageView_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPageView_SignatureStrings[] = {
    "KWidgetsAddons.KPageView(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,pageHeader:QWidget=None,pageFooter:QWidget=None,faceType:KWidgetsAddons.KPageView.FaceType=None)",
    "KWidgetsAddons.KPageView.createView(self)->PySide6.QtWidgets.QAbstractItemView",
    "KWidgetsAddons.KPageView.currentPage(self)->PySide6.QtCore.QModelIndex",
    "KWidgetsAddons.KPageView.faceType(self)->KWidgetsAddons.KPageView.FaceType",
    "KWidgetsAddons.KPageView.itemDelegate(self)->PySide6.QtWidgets.QAbstractItemDelegate",
    "KWidgetsAddons.KPageView.model(self)->PySide6.QtCore.QAbstractItemModel",
    "KWidgetsAddons.KPageView.pageFooter(self)->PySide6.QtWidgets.QWidget",
    "KWidgetsAddons.KPageView.pageHeader(self)->PySide6.QtWidgets.QWidget",
    "KWidgetsAddons.KPageView.setCurrentPage(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])",
    "KWidgetsAddons.KPageView.setDefaultWidget(self,widget:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KPageView.setFaceType(self,faceType:KWidgetsAddons.KPageView.FaceType)",
    "KWidgetsAddons.KPageView.setItemDelegate(self,delegate:PySide6.QtWidgets.QAbstractItemDelegate)",
    "KWidgetsAddons.KPageView.setModel(self,model:PySide6.QtCore.QAbstractItemModel)",
    "KWidgetsAddons.KPageView.setPageFooter(self,footer:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KPageView.setPageHeader(self,header:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KPageView.showPageHeader(self)->bool",
    "KWidgetsAddons.KPageView.viewPosition(self)->PySide6.QtCore.Qt.AlignmentFlag",
    nullptr}; // Sentinel
#else
static constexpr size_t KPageView_SignatureByteSize = 367;
static constexpr uint8_t KPageView_SignatureBytes[367] = {
    0x78, 0xda, 0xa5, 0x94, 0xcb, 0x4e, 0xc3, 0x30, 0x10, 0x45, 0xf7, 0xfd, 0x0a, 0x96, 0x14, 0x19,
    0x2f, 0x59, 0x44, 0x2a, 0x52, 0xd5, 0x2a, 0xa2, 0x8a, 0x0a, 0xae, 0x78, 0x2d, 0x10, 0x0b, 0x37,
    0x9e, 0xa4, 0x96, 0x5c, 0x3b, 0xb2, 0x5d, 0x42, 0xfe, 0x9e, 0x3c, 0xfb, 0x48, 0xb1, 0x5b, 0xca,
    0x26, 0xb2, 0x9d, 0x9b, 0xa3, 0xb9, 0x9e, 0x3b, 0x89, 0xde, 0x39, 0x4b, 0xc1, 0x9a, 0x31, 0x63,
    0x4a, 0x1a, 0x1c, 0x11, 0x9a, 0xc2, 0x1b, 0x87, 0xfc, 0xda, 0x80, 0x48, 0x50, 0x46, 0x35, 0x48,
    0x1b, 0x90, 0xe2, 0x99, 0x33, 0xb8, 0xc3, 0x0b, 0xdb, 0xaa, 0xf1, 0xa2, 0x59, 0x8c, 0xe4, 0x46,
    0x88, 0xcc, 0x6a, 0x74, 0x13, 0x44, 0x50, 0xe4, 0x4a, 0xb3, 0x27, 0x29, 0x8a, 0xd1, 0xa3, 0x92,
    0x50, 0x7e, 0x9b, 0xc2, 0x03, 0x50, 0x06, 0x3a, 0xe8, 0xd4, 0xdb, 0xf3, 0x50, 0x29, 0xdb, 0x3f,
    0x4f, 0x68, 0x0c, 0x2f, 0x45, 0x06, 0x41, 0xe4, 0x28, 0x09, 0x87, 0xad, 0xa2, 0xd6, 0x0f, 0x07,
    0x4e, 0x5d, 0xac, 0x81, 0xda, 0x9d, 0x8b, 0xe1, 0xed, 0xfd, 0x2f, 0x06, 0xc6, 0x4b, 0x63, 0x35,
    0x8d, 0xed, 0xcc, 0xc2, 0xba, 0x92, 0x7a, 0x70, 0x1b, 0x5d, 0xdd, 0x42, 0xb5, 0x3f, 0xe6, 0x4d,
    0x94, 0x06, 0xbc, 0x98, 0x2b, 0x06, 0x62, 0x26, 0x19, 0x7c, 0xbb, 0x31, 0x9d, 0xbf, 0x8e, 0x71,
    0xd2, 0xa6, 0x1b, 0xc5, 0xcb, 0x9a, 0xa7, 0x20, 0x20, 0x2d, 0x6d, 0x9e, 0x69, 0xb1, 0x93, 0xbb,
    0xa1, 0xeb, 0xca, 0x83, 0xcb, 0xe0, 0x3e, 0xaa, 0x36, 0xeb, 0xe6, 0xec, 0xfa, 0xeb, 0x29, 0xad,
    0x59, 0xf8, 0x21, 0x4d, 0x78, 0xfe, 0x01, 0x31, 0x60, 0x27, 0xbd, 0xde, 0x21, 0x5e, 0x35, 0x29,
    0xb0, 0x45, 0xc6, 0x65, 0x8a, 0x5f, 0x25, 0x57, 0xf2, 0xc3, 0xdd, 0x4c, 0x74, 0xd5, 0x7f, 0x47,
    0x40, 0x1b, 0x6e, 0x6c, 0x89, 0xdc, 0xa9, 0x3e, 0x87, 0xde, 0x12, 0xa6, 0x90, 0xd0, 0x8d, 0x68,
    0xab, 0x6e, 0x8a, 0xc8, 0xeb, 0xb5, 0x7b, 0xac, 0xfc, 0xc0, 0x70, 0x3f, 0x48, 0x7f, 0x18, 0x1b,
    0x3f, 0x75, 0xd6, 0xcf, 0x14, 0x62, 0xed, 0x2e, 0x38, 0x33, 0x5a, 0x7e, 0xfe, 0x7c, 0x1b, 0x2f,
    0x54, 0x27, 0x2d, 0x38, 0x19, 0x31, 0x3f, 0x8f, 0x1c, 0xc6, 0x0c, 0x25, 0xcd, 0x2f, 0xe5, 0xc2,
    0x3b, 0x25, 0x87, 0x79, 0x43, 0xab, 0xe6, 0xc7, 0x75, 0x11, 0x6d, 0xa5, 0x72, 0x72, 0x14, 0xdf,
    0xa5, 0x52, 0x9e, 0x99, 0xf9, 0x2a, 0x1f, 0x44, 0x19, 0x6e, 0xcb, 0x3c, 0xba, 0x46, 0xd0, 0xe2,
    0xb1, 0xe0, 0xa9, 0x5c, 0x97, 0xd9, 0x0b, 0x05, 0x4d, 0x07, 0x3f, 0x1e, 0xc8, 0x17, 0x38
};
#endif

PyTypeObject *init_KPageView(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX].type;

    Shiboken::AutoDecRef Sbk_KPageView_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KPageView_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPageView",
        "KPageView*",
        &Sbk_KPageView_spec,
        &Shiboken::callCppDestructor< KPageView >,
        Sbk_KPageView_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KPageView_Type; // references _Sbk_KPageView_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPageView_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPageView_SignatureBytes, KPageView_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPageView_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPageView_PythonToCpp_KPageView_PTR,
        is_KPageView_PythonToCpp_KPageView_PTR_Convertible,
        KPageView_PTR_CppToPython_KPageView);

    Shiboken::Conversions::registerConverterName(converter, "KPageView");
    Shiboken::Conversions::registerConverterName(converter, "KPageView*");
    Shiboken::Conversions::registerConverterName(converter, "KPageView&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPageView).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KPageViewWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KPageView_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KPageView_TypeF(), &Sbk_KPageViewSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KPageView_TypeF(), &Sbk_KPageView_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KPageView_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'FaceType'.
    const char *FaceType_Initializer[] = {
        "Auto",
        "Plain",
        "List",
        "Tree",
        "Tabbed",
        "FlatList",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t FaceType_InitializerValues[] = {
        uint8_t(KPageView::FaceType::Auto),    //  0x00  0
        uint8_t(KPageView::FaceType::Plain),   //  0x01  1
        uint8_t(KPageView::FaceType::List),    //  0x02  2
        uint8_t(KPageView::FaceType::Tree),    //  0x03  3
        uint8_t(KPageView::FaceType::Tabbed),  //  0x04  4
        uint8_t(KPageView::FaceType::FlatList) //  0x05  5
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KPageView_TypeF(),
        "1:KWidgetsAddons.KPageView.FaceType",
        FaceType_Initializer, FaceType_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KPageView_FaceType_IDX].type = EType;
    // Register converter for enum 'KPageView::FaceType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KPageView_FaceType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KPageView_FaceType,
            is_Enum_PythonToCpp_KPageView_FaceType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KPageView::FaceType");
        Shiboken::Conversions::registerConverterAlias(converter, "FaceType");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'FaceType' enum.

    PySide::Signal::registerSignals(pyType, &::KPageView::staticMetaObject);
    qRegisterMetaType< ::KPageView::FaceType >("KPageView::FaceType");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KPageView::staticMetaObject, sizeof(KPageViewWrapper));

    return pyType;
}
