
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kpasswordlineedit_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <kpassword.h>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qlineedit.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPasswordLineEdit_Type = nullptr;
static PyTypeObject *Sbk_KPasswordLineEdit_TypeF(void)
{
    return _Sbk_KPasswordLineEdit_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KPasswordLineEditWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KPasswordLineEditWrapper::KPasswordLineEditWrapper(::QWidget * parent) : KPasswordLineEdit(parent)
{
}

void KPasswordLineEditWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPasswordLineEdit", funcName, gil, pyOverride, signal);
}

void KPasswordLineEditWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

int KPasswordLineEditWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KPasswordLineEdit", funcName, gil, pyOverride);
}

void KPasswordLineEditWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KPasswordLineEdit", funcName, gil, pyOverride, signal);
}

void KPasswordLineEditWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

bool KPasswordLineEditWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

bool KPasswordLineEditWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KPasswordLineEdit", funcName, gil, pyOverride, watched, event);
}

void KPasswordLineEditWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

bool KPasswordLineEditWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KPasswordLineEdit", funcName, gil, pyOverride, next);
}

void KPasswordLineEditWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

bool KPasswordLineEditWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KPasswordLineEdit", funcName, gil, pyOverride);
}

int KPasswordLineEditWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KPasswordLineEdit", funcName, gil, pyOverride, arg__1);
}

void KPasswordLineEditWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KPasswordLineEdit", funcName, gil, pyOverride, painter);
}

void KPasswordLineEditWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

::QVariant KPasswordLineEditWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KPasswordLineEdit", funcName, gil, pyOverride, arg__1);
}

void KPasswordLineEditWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

int KPasswordLineEditWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KPasswordLineEdit", funcName, gil, pyOverride, arg__1);
}

::QSize KPasswordLineEditWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KPasswordLineEdit", funcName, gil, pyOverride);
}

void KPasswordLineEditWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

bool KPasswordLineEditWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KPasswordLineEdit", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KPasswordLineEditWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KPasswordLineEdit", funcName, gil, pyOverride);
}

void KPasswordLineEditWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

::QPaintDevice * KPasswordLineEditWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KPasswordLineEdit", funcName, gil, pyOverride, offset);
}

void KPasswordLineEditWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KPasswordLineEdit", funcName, gil, pyOverride, visible);
}

::QPainter * KPasswordLineEditWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KPasswordLineEdit", funcName, gil, pyOverride);
}

void KPasswordLineEditWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

::QSize KPasswordLineEditWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KPasswordLineEdit", funcName, gil, pyOverride);
}

void KPasswordLineEditWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

void KPasswordLineEditWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPasswordLineEdit_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KPasswordLineEdit", funcName, gil, pyOverride, event);
}

const QMetaObject *KPasswordLineEditWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KPasswordLineEdit::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KPasswordLineEditWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KPasswordLineEdit::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KPasswordLineEditWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KPasswordLineEditWrapper *>(this));
    }
    return KPasswordLineEdit::qt_metacast(_clname);
}

KPasswordLineEditWrapper::~KPasswordLineEditWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KPasswordLineEdit_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPasswordLineEdit_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPasswordLineEdit >()))
        return -1;

    KPasswordLineEditWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KPasswordLineEdit", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPasswordLineEdit::KPasswordLineEdit(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KPasswordLineEdit(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KPasswordLineEdit(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KPasswordLineEdit(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KPasswordLineEditWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KPasswordLineEditWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KPasswordLineEdit >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KPasswordLineEditFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clear()
        cppSelf->clear();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordLineEditFunc_echoMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // echoMode()const
        QLineEdit::EchoMode cppResult = const_cast<const ::KPasswordLineEdit *>(cppSelf)->echoMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLineEdit_EchoMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordLineEditFunc_isClearButtonEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isClearButtonEnabled()const
        bool cppResult = const_cast<const ::KPasswordLineEdit *>(cppSelf)->isClearButtonEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordLineEditFunc_isReadOnly(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isReadOnly()const
        bool cppResult = const_cast<const ::KPasswordLineEdit *>(cppSelf)->isReadOnly();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordLineEditFunc_isRevealPasswordAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KPasswordLineEdit", "isRevealPasswordAvailable() const");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};

        // isRevealPasswordAvailable()const
        bool cppResult = const_cast<const ::KPasswordLineEdit *>(cppSelf)->isRevealPasswordAvailable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordLineEditFunc_lineEdit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // lineEdit()const
        QLineEdit * cppResult = const_cast<const ::KPasswordLineEdit *>(cppSelf)->lineEdit();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLineEdit_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordLineEditFunc_password(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // password()const
        QString cppResult = const_cast<const ::KPasswordLineEdit *>(cppSelf)->password();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordLineEditFunc_revealPasswordMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // revealPasswordMode()const
        KPassword::RevealMode cppResult = const_cast<const ::KPasswordLineEdit *>(cppSelf)->revealPasswordMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPassword_RevealMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPasswordLineEditFunc_setClearButtonEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordLineEdit::setClearButtonEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setClearButtonEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setClearButtonEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setClearButtonEnabled(bool)
            cppSelf->setClearButtonEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordLineEditFunc_setEchoMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordLineEdit::setEchoMode(QLineEdit::EchoMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLineEdit_EchoMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setEchoMode(QLineEdit::EchoMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEchoMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);

    // Call function/method
    {
        ::QLineEdit::EchoMode cppArg0{QLineEdit::Normal};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEchoMode(QLineEdit::EchoMode)
            cppSelf->setEchoMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordLineEditFunc_setPassword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordLineEdit::setPassword(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setPassword(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPassword", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPassword(QString)
            cppSelf->setPassword(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordLineEditFunc_setReadOnly(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordLineEdit::setReadOnly(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setReadOnly(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setReadOnly", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setReadOnly(bool)
            cppSelf->setReadOnly(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordLineEditFunc_setRevealPasswordAvailable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordLineEdit::setRevealPasswordAvailable(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRevealPasswordAvailable(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRevealPasswordAvailable", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KPasswordLineEdit", "setRevealPasswordAvailable(bool reveal)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRevealPasswordAvailable(bool)
            cppSelf->setRevealPasswordAvailable(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordLineEditFunc_setRevealPasswordMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPasswordLineEdit::setRevealPasswordMode(KPassword::RevealMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPassword_RevealMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setRevealPasswordMode(KPassword::RevealMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRevealPasswordMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);

    // Call function/method
    {
        ::KPassword::RevealMode cppArg0{KPassword::RevealMode::OnlyNew};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRevealPasswordMode(KPassword::RevealMode)
            cppSelf->setRevealPasswordMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KPasswordLineEditFunc_toggleEchoModeAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggleEchoModeAction()const
        QAction * cppResult = const_cast<const ::KPasswordLineEdit *>(cppSelf)->toggleEchoModeAction();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KPasswordLineEdit_PropertyStrings[] = {
    "clearButtonEnabled:isClearButtonEnabled:",
    "echoMode::",
    "password::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPasswordLineEdit_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_clear), METH_NOARGS, nullptr},
    {"echoMode", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_echoMode), METH_NOARGS, nullptr},
    {"isClearButtonEnabled", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_isClearButtonEnabled), METH_NOARGS, nullptr},
    {"isReadOnly", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_isReadOnly), METH_NOARGS, nullptr},
    {"isRevealPasswordAvailable", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_isRevealPasswordAvailable), METH_NOARGS, nullptr},
    {"lineEdit", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_lineEdit), METH_NOARGS, nullptr},
    {"password", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_password), METH_NOARGS, nullptr},
    {"revealPasswordMode", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_revealPasswordMode), METH_NOARGS, nullptr},
    {"setClearButtonEnabled", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_setClearButtonEnabled), METH_O, nullptr},
    {"setEchoMode", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_setEchoMode), METH_O, nullptr},
    {"setPassword", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_setPassword), METH_O, nullptr},
    {"setReadOnly", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_setReadOnly), METH_O, nullptr},
    {"setRevealPasswordAvailable", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_setRevealPasswordAvailable), METH_O, nullptr},
    {"setRevealPasswordMode", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_setRevealPasswordMode), METH_O, nullptr},
    {"toggleEchoModeAction", reinterpret_cast<PyCFunction>(Sbk_KPasswordLineEditFunc_toggleEchoModeAction), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KPasswordLineEdit_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KPasswordLineEdit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KPasswordLineEditWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KPasswordLineEdit_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPasswordLineEdit_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KPasswordLineEditSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KPasswordLineEdit *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPasswordLineEdit_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KPasswordLineEdit_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPasswordLineEdit_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPasswordLineEdit_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPasswordLineEdit_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPasswordLineEdit_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPasswordLineEdit_spec = {
    "1:KWidgetsAddons.KPasswordLineEdit",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPasswordLineEdit_slots
};

} //extern "C"

static void *Sbk_KPasswordLineEdit_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KPasswordLineEdit *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KPasswordLineEdit *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KPasswordLineEdit *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPasswordLineEdit_PythonToCpp_KPasswordLineEdit_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPasswordLineEdit_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPasswordLineEdit_PythonToCpp_KPasswordLineEdit_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPasswordLineEdit_TypeF()))
        return KPasswordLineEdit_PythonToCpp_KPasswordLineEdit_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPasswordLineEdit_PTR_CppToPython_KPasswordLineEdit(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KPasswordLineEdit *>(const_cast<void *>(cppIn)), Sbk_KPasswordLineEdit_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPasswordLineEdit_SignatureStrings[] = {
    "KWidgetsAddons.KPasswordLineEdit(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,password:QString=None,clearButtonEnabled:bool=None,echoMode:PySide6.QtWidgets.QLineEdit.EchoMode=None)",
    "KWidgetsAddons.KPasswordLineEdit.clear(self)",
    "KWidgetsAddons.KPasswordLineEdit.echoMode(self)->PySide6.QtWidgets.QLineEdit.EchoMode",
    "KWidgetsAddons.KPasswordLineEdit.isClearButtonEnabled(self)->bool",
    "KWidgetsAddons.KPasswordLineEdit.isReadOnly(self)->bool",
    "KWidgetsAddons.KPasswordLineEdit.isRevealPasswordAvailable(self)->bool",
    "KWidgetsAddons.KPasswordLineEdit.lineEdit(self)->PySide6.QtWidgets.QLineEdit",
    "KWidgetsAddons.KPasswordLineEdit.password(self)->QString",
    "KWidgetsAddons.KPasswordLineEdit.revealPasswordMode(self)->KWidgetsAddons.KPassword.RevealMode",
    "KWidgetsAddons.KPasswordLineEdit.setClearButtonEnabled(self,clear:bool)",
    "KWidgetsAddons.KPasswordLineEdit.setEchoMode(self,mode:PySide6.QtWidgets.QLineEdit.EchoMode)",
    "KWidgetsAddons.KPasswordLineEdit.setPassword(self,password:QString)",
    "KWidgetsAddons.KPasswordLineEdit.setReadOnly(self,readOnly:bool)",
    "KWidgetsAddons.KPasswordLineEdit.setRevealPasswordAvailable(self,reveal:bool)",
    "KWidgetsAddons.KPasswordLineEdit.setRevealPasswordMode(self,revealPasswordMode:KWidgetsAddons.KPassword.RevealMode)",
    "KWidgetsAddons.KPasswordLineEdit.toggleEchoModeAction(self)->PySide6.QtGui.QAction",
    nullptr}; // Sentinel
#else
static constexpr size_t KPasswordLineEdit_SignatureByteSize = 303;
static constexpr uint8_t KPasswordLineEdit_SignatureBytes[303] = {
    0x78, 0xda, 0x9d, 0x53, 0xcb, 0x6e, 0x83, 0x30, 0x10, 0xbc, 0xe7, 0x4b, 0x9a, 0x8a, 0xfa, 0xd8,
    0x83, 0xa5, 0x54, 0xa2, 0x15, 0xea, 0x81, 0x3e, 0xa0, 0x39, 0xf4, 0xec, 0xe0, 0x0d, 0xb5, 0xb4,
    0xb5, 0x23, 0x7b, 0x49, 0xc5, 0xdf, 0xb7, 0x60, 0xac, 0x12, 0xd1, 0x04, 0xd3, 0x1b, 0xb0, 0x3b,
    0xb3, 0x3b, 0x3b, 0x43, 0xfe, 0xae, 0x64, 0x0d, 0xe4, 0x52, 0x29, 0x8d, 0x76, 0x2c, 0x2f, 0x84,
    0x73, 0x5f, 0xc6, 0xca, 0x27, 0xa5, 0x21, 0x93, 0x8a, 0xae, 0x1c, 0xe0, 0x3e, 0x39, 0x08, 0x0b,
    0x9a, 0x78, 0xd1, 0x6e, 0x95, 0x84, 0x5b, 0x56, 0xd2, 0x80, 0x62, 0xa5, 0x7f, 0xd8, 0xe8, 0x06,
    0xf1, 0x40, 0x36, 0xb9, 0xe6, 0x39, 0xb4, 0x1d, 0xfe, 0x55, 0x63, 0xbb, 0x79, 0x31, 0x1a, 0x7e,
    0xb0, 0x9e, 0x91, 0x97, 0x5b, 0xb2, 0x4a, 0xd7, 0xfe, 0x6b, 0x85, 0x20, 0xec, 0x7d, 0x43, 0x64,
    0x74, 0xa6, 0xc5, 0x0e, 0x41, 0xf2, 0x9d, 0x31, 0xe8, 0x8b, 0x50, 0x7d, 0x98, 0x67, 0x23, 0xe1,
    0xaf, 0x81, 0x61, 0x31, 0x96, 0x0d, 0x4d, 0x3d, 0x64, 0xbd, 0xca, 0x67, 0x84, 0xb0, 0x7e, 0x62,
    0x2f, 0x27, 0xa2, 0x39, 0x6c, 0xe0, 0xfb, 0x6f, 0xee, 0x62, 0x16, 0x99, 0x67, 0x55, 0xee, 0x61,
    0x22, 0x3b, 0x4c, 0xe8, 0xd4, 0xc7, 0x30, 0xbc, 0x81, 0xe8, 0x8f, 0xbb, 0x1c, 0x77, 0x04, 0x81,
    0xa1, 0x90, 0x1e, 0x85, 0xc2, 0x6e, 0xfe, 0x32, 0x1a, 0x1c, 0xa7, 0xe2, 0xf2, 0x59, 0xe6, 0xc9,
    0x42, 0x30, 0x02, 0xd9, 0x90, 0x8f, 0x79, 0xa0, 0x3d, 0x91, 0x32, 0xb6, 0xe9, 0x1c, 0x94, 0x79,
    0xf5, 0x71, 0x2e, 0x39, 0xa0, 0x33, 0x36, 0xf9, 0xd4, 0xf6, 0x41, 0x5d, 0x47, 0xf1, 0x64, 0xe3,
    0x18, 0x25, 0x9f, 0xb1, 0x91, 0x8e, 0x23, 0x2f, 0xc6, 0xf7, 0x9b, 0xfc, 0x66, 0x71, 0x1c, 0x27,
    0x69, 0x4a, 0xec, 0xf0, 0xb6, 0x40, 0xe1, 0xa5, 0x58, 0x25, 0xde, 0xa8, 0x7f, 0xb3, 0xfd, 0x5e,
    0x6e, 0xea, 0x38, 0x8f, 0xb0, 0x3a, 0x62, 0x26, 0x99, 0xba, 0x46, 0x08, 0x77, 0x4f, 0x2b, 0x52,
    0x46, 0x4f, 0xc3, 0xfd, 0xd8, 0x28, 0x56, 0xfa, 0xe2, 0xea, 0x1b, 0xad, 0x02, 0xed, 0xea
};
#endif

PyTypeObject *init_KPasswordLineEdit(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX].type;

    Shiboken::AutoDecRef Sbk_KPasswordLineEdit_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KPasswordLineEdit_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPasswordLineEdit",
        "KPasswordLineEdit*",
        &Sbk_KPasswordLineEdit_spec,
        &Shiboken::callCppDestructor< KPasswordLineEdit >,
        Sbk_KPasswordLineEdit_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KPasswordLineEdit_TypeF(); // references _Sbk_KPasswordLineEdit_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPasswordLineEdit_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPasswordLineEdit_SignatureBytes, KPasswordLineEdit_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPasswordLineEdit_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPasswordLineEdit_PythonToCpp_KPasswordLineEdit_PTR,
        is_KPasswordLineEdit_PythonToCpp_KPasswordLineEdit_PTR_Convertible,
        KPasswordLineEdit_PTR_CppToPython_KPasswordLineEdit);

    Shiboken::Conversions::registerConverterName(converter, "KPasswordLineEdit");
    Shiboken::Conversions::registerConverterName(converter, "KPasswordLineEdit*");
    Shiboken::Conversions::registerConverterName(converter, "KPasswordLineEdit&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPasswordLineEdit).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KPasswordLineEditWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KPasswordLineEdit_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KPasswordLineEdit_TypeF(), &Sbk_KPasswordLineEditSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KPasswordLineEdit_TypeF(), &Sbk_KPasswordLineEdit_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KPasswordLineEdit::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KPasswordLineEdit::staticMetaObject, sizeof(KPasswordLineEditWrapper));

    return pyType;
}
