/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/client-go/applyconfigurations/core/v1"
)

// EndpointApplyConfiguration represents a declarative configuration of the Endpoint type for use
// with apply.
//
// Endpoint represents a single logical "backend" implementing a service.
type EndpointApplyConfiguration struct {
	// addresses of this endpoint. For EndpointSlices of addressType "IPv4" or "IPv6",
	// the values are IP addresses in canonical form. The syntax and semantics of
	// other addressType values are not defined. This must contain at least one
	// address but no more than 100. EndpointSlices generated by the EndpointSlice
	// controller will always have exactly 1 address. No semantics are defined for
	// additional addresses beyond the first, and kube-proxy does not look at them.
	Addresses []string `json:"addresses,omitempty"`
	// conditions contains information about the current status of the endpoint.
	Conditions *EndpointConditionsApplyConfiguration `json:"conditions,omitempty"`
	// hostname of this endpoint. This field may be used by consumers of
	// endpoints to distinguish endpoints from each other (e.g. in DNS names).
	// Multiple endpoints which use the same hostname should be considered
	// fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS
	// Label (RFC 1123) validation.
	Hostname *string `json:"hostname,omitempty"`
	// targetRef is a reference to a Kubernetes object that represents this
	// endpoint.
	TargetRef *corev1.ObjectReferenceApplyConfiguration `json:"targetRef,omitempty"`
	// deprecatedTopology contains topology information part of the v1beta1
	// API. This field is deprecated, and will be removed when the v1beta1
	// API is removed (no sooner than kubernetes v1.24).  While this field can
	// hold values, it is not writable through the v1 API, and any attempts to
	// write to it will be silently ignored. Topology information can be found
	// in the zone and nodeName fields instead.
	DeprecatedTopology map[string]string `json:"deprecatedTopology,omitempty"`
	// nodeName represents the name of the Node hosting this endpoint. This can
	// be used to determine endpoints local to a Node.
	NodeName *string `json:"nodeName,omitempty"`
	// zone is the name of the Zone this endpoint exists in.
	Zone *string `json:"zone,omitempty"`
	// hints contains information associated with how an endpoint should be
	// consumed.
	Hints *EndpointHintsApplyConfiguration `json:"hints,omitempty"`
}

// EndpointApplyConfiguration constructs a declarative configuration of the Endpoint type for use with
// apply.
func Endpoint() *EndpointApplyConfiguration {
	return &EndpointApplyConfiguration{}
}

// WithAddresses adds the given value to the Addresses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Addresses field.
func (b *EndpointApplyConfiguration) WithAddresses(values ...string) *EndpointApplyConfiguration {
	for i := range values {
		b.Addresses = append(b.Addresses, values[i])
	}
	return b
}

// WithConditions sets the Conditions field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Conditions field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithConditions(value *EndpointConditionsApplyConfiguration) *EndpointApplyConfiguration {
	b.Conditions = value
	return b
}

// WithHostname sets the Hostname field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Hostname field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithHostname(value string) *EndpointApplyConfiguration {
	b.Hostname = &value
	return b
}

// WithTargetRef sets the TargetRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TargetRef field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithTargetRef(value *corev1.ObjectReferenceApplyConfiguration) *EndpointApplyConfiguration {
	b.TargetRef = value
	return b
}

// WithDeprecatedTopology puts the entries into the DeprecatedTopology field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the DeprecatedTopology field,
// overwriting an existing map entries in DeprecatedTopology field with the same key.
func (b *EndpointApplyConfiguration) WithDeprecatedTopology(entries map[string]string) *EndpointApplyConfiguration {
	if b.DeprecatedTopology == nil && len(entries) > 0 {
		b.DeprecatedTopology = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.DeprecatedTopology[k] = v
	}
	return b
}

// WithNodeName sets the NodeName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeName field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithNodeName(value string) *EndpointApplyConfiguration {
	b.NodeName = &value
	return b
}

// WithZone sets the Zone field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Zone field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithZone(value string) *EndpointApplyConfiguration {
	b.Zone = &value
	return b
}

// WithHints sets the Hints field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Hints field is set to the value of the last call.
func (b *EndpointApplyConfiguration) WithHints(value *EndpointHintsApplyConfiguration) *EndpointApplyConfiguration {
	b.Hints = value
	return b
}
