/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package applyconfiguration

import (
	runtime "k8s.io/apimachinery/pkg/runtime"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	v1 "sigs.k8s.io/gateway-api-inference-extension/api/v1"
	v1alpha2 "sigs.k8s.io/gateway-api-inference-extension/apix/v1alpha2"
	apiv1 "sigs.k8s.io/gateway-api-inference-extension/client-go/applyconfiguration/api/v1"
	apixv1alpha2 "sigs.k8s.io/gateway-api-inference-extension/client-go/applyconfiguration/apix/v1alpha2"
	internal "sigs.k8s.io/gateway-api-inference-extension/client-go/applyconfiguration/internal"
)

// ForKind returns an apply configuration type for the given GroupVersionKind, or nil if no
// apply configuration type exists for the given GroupVersionKind.
func ForKind(kind schema.GroupVersionKind) interface{} {
	switch kind {
	// Group=inference.networking.k8s.io, Version=v1
	case v1.SchemeGroupVersion.WithKind("EndpointPickerRef"):
		return &apiv1.EndpointPickerRefApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("InferencePool"):
		return &apiv1.InferencePoolApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("InferencePoolSpec"):
		return &apiv1.InferencePoolSpecApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("InferencePoolStatus"):
		return &apiv1.InferencePoolStatusApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("LabelSelector"):
		return &apiv1.LabelSelectorApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("ParentReference"):
		return &apiv1.ParentReferenceApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("ParentStatus"):
		return &apiv1.ParentStatusApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("Port"):
		return &apiv1.PortApplyConfiguration{}

		// Group=inference.networking.x-k8s.io, Version=v1alpha2
	case v1alpha2.SchemeGroupVersion.WithKind("Extension"):
		return &apixv1alpha2.ExtensionApplyConfiguration{}
	case v1alpha2.SchemeGroupVersion.WithKind("InferenceObjective"):
		return &apixv1alpha2.InferenceObjectiveApplyConfiguration{}
	case v1alpha2.SchemeGroupVersion.WithKind("InferenceObjectiveSpec"):
		return &apixv1alpha2.InferenceObjectiveSpecApplyConfiguration{}
	case v1alpha2.SchemeGroupVersion.WithKind("InferenceObjectiveStatus"):
		return &apixv1alpha2.InferenceObjectiveStatusApplyConfiguration{}
	case v1alpha2.SchemeGroupVersion.WithKind("InferencePool"):
		return &apixv1alpha2.InferencePoolApplyConfiguration{}
	case v1alpha2.SchemeGroupVersion.WithKind("InferencePoolSpec"):
		return &apixv1alpha2.InferencePoolSpecApplyConfiguration{}
	case v1alpha2.SchemeGroupVersion.WithKind("InferencePoolStatus"):
		return &apixv1alpha2.InferencePoolStatusApplyConfiguration{}
	case v1alpha2.SchemeGroupVersion.WithKind("ParentGatewayReference"):
		return &apixv1alpha2.ParentGatewayReferenceApplyConfiguration{}
	case v1alpha2.SchemeGroupVersion.WithKind("PoolObjectReference"):
		return &apixv1alpha2.PoolObjectReferenceApplyConfiguration{}
	case v1alpha2.SchemeGroupVersion.WithKind("PoolStatus"):
		return &apixv1alpha2.PoolStatusApplyConfiguration{}

	}
	return nil
}

func NewTypeConverter(scheme *runtime.Scheme) managedfields.TypeConverter {
	return managedfields.NewSchemeTypeConverter(scheme, internal.Parser())
}
