{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The class structure for the GObject type.
-- 
-- 
-- === /C code/
-- >
-- >// Example of implementing a singleton using a constructor.
-- >static MySingleton *the_singleton = NULL;
-- >
-- >static GObject*
-- >my_singleton_constructor (GType                  type,
-- >                          guint                  n_construct_params,
-- >                          GObjectConstructParam *construct_params)
-- >{
-- >  GObject *object;
-- >  
-- >  if (!the_singleton)
-- >    {
-- >      object = G_OBJECT_CLASS (parent_class)->constructor (type,
-- >                                                           n_construct_params,
-- >                                                           construct_params);
-- >      the_singleton = MY_SINGLETON (object);
-- >    }
-- >  else
-- >    object = g_object_ref (G_OBJECT (the_singleton));
-- >
-- >  return object;
-- >}
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.ObjectClass
    ( 

-- * Exported types
    ObjectClass(..)                         ,
    newZeroObjectClass                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [findProperty]("GI.GObject.Structs.ObjectClass#g:method:findProperty"), [installProperty]("GI.GObject.Structs.ObjectClass#g:method:installProperty"), [overrideProperty]("GI.GObject.Structs.ObjectClass#g:method:overrideProperty").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveObjectClassMethod                ,
#endif

-- ** findProperty #method:findProperty#

#if defined(ENABLE_OVERLOADING)
    ObjectClassFindPropertyMethodInfo       ,
#endif
    objectClassFindProperty                 ,


-- ** installProperty #method:installProperty#

#if defined(ENABLE_OVERLOADING)
    ObjectClassInstallPropertyMethodInfo    ,
#endif
    objectClassInstallProperty              ,


-- ** overrideProperty #method:overrideProperty#

#if defined(ENABLE_OVERLOADING)
    ObjectClassOverridePropertyMethodInfo   ,
#endif
    objectClassOverrideProperty             ,




 -- * Properties


-- ** constructed #attr:constructed#
-- | the /@constructed@/ function is called by @/g_object_new()/@ as the
--  final step of the object creation process.  At the point of the call, all
--  construction properties have been set on the object.  The purpose of this
--  call is to allow for object initialisation steps that can only be performed
--  after construction properties have been set.  /@constructed@/ implementors
--  should chain up to the /@constructed@/ call of their parent class to allow it
--  to complete its initialisation.

    clearObjectClassConstructed             ,
    getObjectClassConstructed               ,
#if defined(ENABLE_OVERLOADING)
    objectClass_constructed                 ,
#endif
    setObjectClassConstructed               ,


-- ** dispatchPropertiesChanged #attr:dispatchPropertiesChanged#
-- | emits property change notification for a bunch
--  of properties. Overriding /@dispatchPropertiesChanged@/ should be rarely
--  needed.

    clearObjectClassDispatchPropertiesChanged,
    getObjectClassDispatchPropertiesChanged ,
#if defined(ENABLE_OVERLOADING)
    objectClass_dispatchPropertiesChanged   ,
#endif
    setObjectClassDispatchPropertiesChanged ,


-- ** dispose #attr:dispose#
-- | the /@dispose@/ function is supposed to drop all references to other
--  objects, but keep the instance otherwise intact, so that client method
--  invocations still work. It may be run multiple times (due to reference
--  loops). Before returning, /@dispose@/ should chain up to the /@dispose@/ method
--  of the parent class.

    clearObjectClassDispose                 ,
    getObjectClassDispose                   ,
#if defined(ENABLE_OVERLOADING)
    objectClass_dispose                     ,
#endif
    setObjectClassDispose                   ,


-- ** finalize #attr:finalize#
-- | instance finalization function, should finish the finalization of
--  the instance begun in /@dispose@/ and chain up to the /@finalize@/ method of the
--  parent class.

    clearObjectClassFinalize                ,
    getObjectClassFinalize                  ,
#if defined(ENABLE_OVERLOADING)
    objectClass_finalize                    ,
#endif
    setObjectClassFinalize                  ,


-- ** gTypeClass #attr:gTypeClass#
-- | the parent class

    getObjectClassGTypeClass                ,
#if defined(ENABLE_OVERLOADING)
    objectClass_gTypeClass                  ,
#endif


-- ** getProperty #attr:getProperty#
-- | the generic getter for all properties of this type. Should be
--  overridden for every type with properties.

    clearObjectClassGetProperty             ,
    getObjectClassGetProperty               ,
#if defined(ENABLE_OVERLOADING)
    objectClass_getProperty                 ,
#endif
    setObjectClassGetProperty               ,


-- ** notify #attr:notify#
-- | the class closure for the notify signal

    clearObjectClassNotify                  ,
    getObjectClassNotify                    ,
#if defined(ENABLE_OVERLOADING)
    objectClass_notify                      ,
#endif
    setObjectClassNotify                    ,


-- ** setProperty #attr:setProperty#
-- | the generic setter for all properties of this type. Should be
--  overridden for every type with properties. If implementations of
--  /@setProperty@/ don\'t emit property change notification explicitly, this will
--  be done implicitly by the type system. However, if the notify signal is
--  emitted explicitly, the type system will not emit it a second time.

    clearObjectClassSetProperty             ,
    getObjectClassSetProperty               ,
#if defined(ENABLE_OVERLOADING)
    objectClass_setProperty                 ,
#endif
    setObjectClassSetProperty               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass

#else
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass

#endif

-- | Memory-managed wrapper type.
newtype ObjectClass = ObjectClass (SP.ManagedPtr ObjectClass)
    deriving (Eq)

instance SP.ManagedPtrNewtype ObjectClass where
    toManagedPtr (ObjectClass p) = p

instance BoxedPtr ObjectClass where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 136 >=> B.ManagedPtr.wrapPtr ObjectClass)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr ObjectClass where
    boxedPtrCalloc = callocBytes 136


-- | Construct a t'ObjectClass' struct initialized to zero.
newZeroObjectClass :: MonadIO m => m ObjectClass
newZeroObjectClass = liftIO $ boxedPtrCalloc >>= wrapPtr ObjectClass

instance tag ~ 'AttrSet => Constructible ObjectClass tag where
    new _ attrs = do
        o <- newZeroObjectClass
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@g_type_class@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' objectClass #gTypeClass
-- @
getObjectClassGTypeClass :: MonadIO m => ObjectClass -> m GObject.TypeClass.TypeClass
getObjectClassGTypeClass s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr GObject.TypeClass.TypeClass)
    val' <- (newPtr GObject.TypeClass.TypeClass) val
    return val'

#if defined(ENABLE_OVERLOADING)
data ObjectClassGTypeClassFieldInfo
instance AttrInfo ObjectClassGTypeClassFieldInfo where
    type AttrBaseTypeConstraint ObjectClassGTypeClassFieldInfo = (~) ObjectClass
    type AttrAllowedOps ObjectClassGTypeClassFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint ObjectClassGTypeClassFieldInfo = (~) (Ptr GObject.TypeClass.TypeClass)
    type AttrTransferTypeConstraint ObjectClassGTypeClassFieldInfo = (~)(Ptr GObject.TypeClass.TypeClass)
    type AttrTransferType ObjectClassGTypeClassFieldInfo = (Ptr GObject.TypeClass.TypeClass)
    type AttrGetType ObjectClassGTypeClassFieldInfo = GObject.TypeClass.TypeClass
    type AttrLabel ObjectClassGTypeClassFieldInfo = "g_type_class"
    type AttrOrigin ObjectClassGTypeClassFieldInfo = ObjectClass
    attrGet = getObjectClassGTypeClass
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.gTypeClass"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#g:attr:gTypeClass"
        })

objectClass_gTypeClass :: AttrLabelProxy "gTypeClass"
objectClass_gTypeClass = AttrLabelProxy

#endif


-- | Get the value of the “@set_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' objectClass #setProperty
-- @
getObjectClassSetProperty :: MonadIO m => ObjectClass -> m (Maybe GObject.Callbacks.ObjectClassSetPropertyFieldCallback)
getObjectClassSetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr GObject.Callbacks.C_ObjectClassSetPropertyFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ObjectClassSetPropertyFieldCallback val'
        return val''
    return result

-- | Set the value of the “@set_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' objectClass [ #setProperty 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectClassSetProperty :: MonadIO m => ObjectClass -> FunPtr GObject.Callbacks.C_ObjectClassSetPropertyFieldCallback -> m ()
setObjectClassSetProperty s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr GObject.Callbacks.C_ObjectClassSetPropertyFieldCallback)

-- | Set the value of the “@set_property@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #setProperty
-- @
clearObjectClassSetProperty :: MonadIO m => ObjectClass -> m ()
clearObjectClassSetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ObjectClassSetPropertyFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ObjectClassSetPropertyFieldInfo
instance AttrInfo ObjectClassSetPropertyFieldInfo where
    type AttrBaseTypeConstraint ObjectClassSetPropertyFieldInfo = (~) ObjectClass
    type AttrAllowedOps ObjectClassSetPropertyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ObjectClassSetPropertyFieldInfo = (~) (FunPtr GObject.Callbacks.C_ObjectClassSetPropertyFieldCallback)
    type AttrTransferTypeConstraint ObjectClassSetPropertyFieldInfo = (~)GObject.Callbacks.ObjectClassSetPropertyFieldCallback
    type AttrTransferType ObjectClassSetPropertyFieldInfo = (FunPtr GObject.Callbacks.C_ObjectClassSetPropertyFieldCallback)
    type AttrGetType ObjectClassSetPropertyFieldInfo = Maybe GObject.Callbacks.ObjectClassSetPropertyFieldCallback
    type AttrLabel ObjectClassSetPropertyFieldInfo = "set_property"
    type AttrOrigin ObjectClassSetPropertyFieldInfo = ObjectClass
    attrGet = getObjectClassSetProperty
    attrSet = setObjectClassSetProperty
    attrConstruct = undefined
    attrClear = clearObjectClassSetProperty
    attrTransfer _ v = do
        GObject.Callbacks.mk_ObjectClassSetPropertyFieldCallback (GObject.Callbacks.wrap_ObjectClassSetPropertyFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.setProperty"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#g:attr:setProperty"
        })

objectClass_setProperty :: AttrLabelProxy "setProperty"
objectClass_setProperty = AttrLabelProxy

#endif


-- | Get the value of the “@get_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' objectClass #getProperty
-- @
getObjectClassGetProperty :: MonadIO m => ObjectClass -> m (Maybe GObject.Callbacks.ObjectClassGetPropertyFieldCallback)
getObjectClassGetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr GObject.Callbacks.C_ObjectClassGetPropertyFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ObjectClassGetPropertyFieldCallback val'
        return val''
    return result

-- | Set the value of the “@get_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' objectClass [ #getProperty 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectClassGetProperty :: MonadIO m => ObjectClass -> FunPtr GObject.Callbacks.C_ObjectClassGetPropertyFieldCallback -> m ()
setObjectClassGetProperty s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr GObject.Callbacks.C_ObjectClassGetPropertyFieldCallback)

-- | Set the value of the “@get_property@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #getProperty
-- @
clearObjectClassGetProperty :: MonadIO m => ObjectClass -> m ()
clearObjectClassGetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ObjectClassGetPropertyFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ObjectClassGetPropertyFieldInfo
instance AttrInfo ObjectClassGetPropertyFieldInfo where
    type AttrBaseTypeConstraint ObjectClassGetPropertyFieldInfo = (~) ObjectClass
    type AttrAllowedOps ObjectClassGetPropertyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ObjectClassGetPropertyFieldInfo = (~) (FunPtr GObject.Callbacks.C_ObjectClassGetPropertyFieldCallback)
    type AttrTransferTypeConstraint ObjectClassGetPropertyFieldInfo = (~)GObject.Callbacks.ObjectClassGetPropertyFieldCallback
    type AttrTransferType ObjectClassGetPropertyFieldInfo = (FunPtr GObject.Callbacks.C_ObjectClassGetPropertyFieldCallback)
    type AttrGetType ObjectClassGetPropertyFieldInfo = Maybe GObject.Callbacks.ObjectClassGetPropertyFieldCallback
    type AttrLabel ObjectClassGetPropertyFieldInfo = "get_property"
    type AttrOrigin ObjectClassGetPropertyFieldInfo = ObjectClass
    attrGet = getObjectClassGetProperty
    attrSet = setObjectClassGetProperty
    attrConstruct = undefined
    attrClear = clearObjectClassGetProperty
    attrTransfer _ v = do
        GObject.Callbacks.mk_ObjectClassGetPropertyFieldCallback (GObject.Callbacks.wrap_ObjectClassGetPropertyFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.getProperty"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#g:attr:getProperty"
        })

objectClass_getProperty :: AttrLabelProxy "getProperty"
objectClass_getProperty = AttrLabelProxy

#endif


-- | Get the value of the “@dispose@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' objectClass #dispose
-- @
getObjectClassDispose :: MonadIO m => ObjectClass -> m (Maybe GObject.Callbacks.ObjectClassDisposeFieldCallback)
getObjectClassDispose s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (FunPtr GObject.Callbacks.C_ObjectClassDisposeFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ObjectClassDisposeFieldCallback val'
        return val''
    return result

-- | Set the value of the “@dispose@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' objectClass [ #dispose 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectClassDispose :: MonadIO m => ObjectClass -> FunPtr GObject.Callbacks.C_ObjectClassDisposeFieldCallback -> m ()
setObjectClassDispose s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: FunPtr GObject.Callbacks.C_ObjectClassDisposeFieldCallback)

-- | Set the value of the “@dispose@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #dispose
-- @
clearObjectClassDispose :: MonadIO m => ObjectClass -> m ()
clearObjectClassDispose s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ObjectClassDisposeFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ObjectClassDisposeFieldInfo
instance AttrInfo ObjectClassDisposeFieldInfo where
    type AttrBaseTypeConstraint ObjectClassDisposeFieldInfo = (~) ObjectClass
    type AttrAllowedOps ObjectClassDisposeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ObjectClassDisposeFieldInfo = (~) (FunPtr GObject.Callbacks.C_ObjectClassDisposeFieldCallback)
    type AttrTransferTypeConstraint ObjectClassDisposeFieldInfo = (~)GObject.Callbacks.ObjectClassDisposeFieldCallback
    type AttrTransferType ObjectClassDisposeFieldInfo = (FunPtr GObject.Callbacks.C_ObjectClassDisposeFieldCallback)
    type AttrGetType ObjectClassDisposeFieldInfo = Maybe GObject.Callbacks.ObjectClassDisposeFieldCallback
    type AttrLabel ObjectClassDisposeFieldInfo = "dispose"
    type AttrOrigin ObjectClassDisposeFieldInfo = ObjectClass
    attrGet = getObjectClassDispose
    attrSet = setObjectClassDispose
    attrConstruct = undefined
    attrClear = clearObjectClassDispose
    attrTransfer _ v = do
        GObject.Callbacks.mk_ObjectClassDisposeFieldCallback (GObject.Callbacks.wrap_ObjectClassDisposeFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.dispose"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#g:attr:dispose"
        })

objectClass_dispose :: AttrLabelProxy "dispose"
objectClass_dispose = AttrLabelProxy

#endif


-- | Get the value of the “@finalize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' objectClass #finalize
-- @
getObjectClassFinalize :: MonadIO m => ObjectClass -> m (Maybe GObject.Callbacks.ObjectClassFinalizeFieldCallback)
getObjectClassFinalize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO (FunPtr GObject.Callbacks.C_ObjectClassFinalizeFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ObjectClassFinalizeFieldCallback val'
        return val''
    return result

-- | Set the value of the “@finalize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' objectClass [ #finalize 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectClassFinalize :: MonadIO m => ObjectClass -> FunPtr GObject.Callbacks.C_ObjectClassFinalizeFieldCallback -> m ()
setObjectClassFinalize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: FunPtr GObject.Callbacks.C_ObjectClassFinalizeFieldCallback)

-- | Set the value of the “@finalize@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #finalize
-- @
clearObjectClassFinalize :: MonadIO m => ObjectClass -> m ()
clearObjectClassFinalize s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ObjectClassFinalizeFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ObjectClassFinalizeFieldInfo
instance AttrInfo ObjectClassFinalizeFieldInfo where
    type AttrBaseTypeConstraint ObjectClassFinalizeFieldInfo = (~) ObjectClass
    type AttrAllowedOps ObjectClassFinalizeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ObjectClassFinalizeFieldInfo = (~) (FunPtr GObject.Callbacks.C_ObjectClassFinalizeFieldCallback)
    type AttrTransferTypeConstraint ObjectClassFinalizeFieldInfo = (~)GObject.Callbacks.ObjectClassFinalizeFieldCallback
    type AttrTransferType ObjectClassFinalizeFieldInfo = (FunPtr GObject.Callbacks.C_ObjectClassFinalizeFieldCallback)
    type AttrGetType ObjectClassFinalizeFieldInfo = Maybe GObject.Callbacks.ObjectClassFinalizeFieldCallback
    type AttrLabel ObjectClassFinalizeFieldInfo = "finalize"
    type AttrOrigin ObjectClassFinalizeFieldInfo = ObjectClass
    attrGet = getObjectClassFinalize
    attrSet = setObjectClassFinalize
    attrConstruct = undefined
    attrClear = clearObjectClassFinalize
    attrTransfer _ v = do
        GObject.Callbacks.mk_ObjectClassFinalizeFieldCallback (GObject.Callbacks.wrap_ObjectClassFinalizeFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.finalize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#g:attr:finalize"
        })

objectClass_finalize :: AttrLabelProxy "finalize"
objectClass_finalize = AttrLabelProxy

#endif


-- | Get the value of the “@dispatch_properties_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' objectClass #dispatchPropertiesChanged
-- @
getObjectClassDispatchPropertiesChanged :: MonadIO m => ObjectClass -> m (Maybe GObject.Callbacks.ObjectClassDispatchPropertiesChangedFieldCallback)
getObjectClassDispatchPropertiesChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO (FunPtr GObject.Callbacks.C_ObjectClassDispatchPropertiesChangedFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ObjectClassDispatchPropertiesChangedFieldCallback val'
        return val''
    return result

-- | Set the value of the “@dispatch_properties_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' objectClass [ #dispatchPropertiesChanged 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectClassDispatchPropertiesChanged :: MonadIO m => ObjectClass -> FunPtr GObject.Callbacks.C_ObjectClassDispatchPropertiesChangedFieldCallback -> m ()
setObjectClassDispatchPropertiesChanged s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: FunPtr GObject.Callbacks.C_ObjectClassDispatchPropertiesChangedFieldCallback)

-- | Set the value of the “@dispatch_properties_changed@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #dispatchPropertiesChanged
-- @
clearObjectClassDispatchPropertiesChanged :: MonadIO m => ObjectClass -> m ()
clearObjectClassDispatchPropertiesChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ObjectClassDispatchPropertiesChangedFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ObjectClassDispatchPropertiesChangedFieldInfo
instance AttrInfo ObjectClassDispatchPropertiesChangedFieldInfo where
    type AttrBaseTypeConstraint ObjectClassDispatchPropertiesChangedFieldInfo = (~) ObjectClass
    type AttrAllowedOps ObjectClassDispatchPropertiesChangedFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ObjectClassDispatchPropertiesChangedFieldInfo = (~) (FunPtr GObject.Callbacks.C_ObjectClassDispatchPropertiesChangedFieldCallback)
    type AttrTransferTypeConstraint ObjectClassDispatchPropertiesChangedFieldInfo = (~)GObject.Callbacks.ObjectClassDispatchPropertiesChangedFieldCallback
    type AttrTransferType ObjectClassDispatchPropertiesChangedFieldInfo = (FunPtr GObject.Callbacks.C_ObjectClassDispatchPropertiesChangedFieldCallback)
    type AttrGetType ObjectClassDispatchPropertiesChangedFieldInfo = Maybe GObject.Callbacks.ObjectClassDispatchPropertiesChangedFieldCallback
    type AttrLabel ObjectClassDispatchPropertiesChangedFieldInfo = "dispatch_properties_changed"
    type AttrOrigin ObjectClassDispatchPropertiesChangedFieldInfo = ObjectClass
    attrGet = getObjectClassDispatchPropertiesChanged
    attrSet = setObjectClassDispatchPropertiesChanged
    attrConstruct = undefined
    attrClear = clearObjectClassDispatchPropertiesChanged
    attrTransfer _ v = do
        GObject.Callbacks.mk_ObjectClassDispatchPropertiesChangedFieldCallback (GObject.Callbacks.wrap_ObjectClassDispatchPropertiesChangedFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.dispatchPropertiesChanged"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#g:attr:dispatchPropertiesChanged"
        })

objectClass_dispatchPropertiesChanged :: AttrLabelProxy "dispatchPropertiesChanged"
objectClass_dispatchPropertiesChanged = AttrLabelProxy

#endif


-- | Get the value of the “@notify@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' objectClass #notify
-- @
getObjectClassNotify :: MonadIO m => ObjectClass -> m (Maybe GObject.Callbacks.ObjectClassNotifyFieldCallback)
getObjectClassNotify s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO (FunPtr GObject.Callbacks.C_ObjectClassNotifyFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ObjectClassNotifyFieldCallback val'
        return val''
    return result

-- | Set the value of the “@notify@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' objectClass [ #notify 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectClassNotify :: MonadIO m => ObjectClass -> FunPtr GObject.Callbacks.C_ObjectClassNotifyFieldCallback -> m ()
setObjectClassNotify s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (val :: FunPtr GObject.Callbacks.C_ObjectClassNotifyFieldCallback)

-- | Set the value of the “@notify@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #notify
-- @
clearObjectClassNotify :: MonadIO m => ObjectClass -> m ()
clearObjectClassNotify s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ObjectClassNotifyFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ObjectClassNotifyFieldInfo
instance AttrInfo ObjectClassNotifyFieldInfo where
    type AttrBaseTypeConstraint ObjectClassNotifyFieldInfo = (~) ObjectClass
    type AttrAllowedOps ObjectClassNotifyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ObjectClassNotifyFieldInfo = (~) (FunPtr GObject.Callbacks.C_ObjectClassNotifyFieldCallback)
    type AttrTransferTypeConstraint ObjectClassNotifyFieldInfo = (~)GObject.Callbacks.ObjectClassNotifyFieldCallback
    type AttrTransferType ObjectClassNotifyFieldInfo = (FunPtr GObject.Callbacks.C_ObjectClassNotifyFieldCallback)
    type AttrGetType ObjectClassNotifyFieldInfo = Maybe GObject.Callbacks.ObjectClassNotifyFieldCallback
    type AttrLabel ObjectClassNotifyFieldInfo = "notify"
    type AttrOrigin ObjectClassNotifyFieldInfo = ObjectClass
    attrGet = getObjectClassNotify
    attrSet = setObjectClassNotify
    attrConstruct = undefined
    attrClear = clearObjectClassNotify
    attrTransfer _ v = do
        GObject.Callbacks.mk_ObjectClassNotifyFieldCallback (GObject.Callbacks.wrap_ObjectClassNotifyFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.notify"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#g:attr:notify"
        })

objectClass_notify :: AttrLabelProxy "notify"
objectClass_notify = AttrLabelProxy

#endif


-- | Get the value of the “@constructed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' objectClass #constructed
-- @
getObjectClassConstructed :: MonadIO m => ObjectClass -> m (Maybe GObject.Callbacks.ObjectClassConstructedFieldCallback)
getObjectClassConstructed s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO (FunPtr GObject.Callbacks.C_ObjectClassConstructedFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_ObjectClassConstructedFieldCallback val'
        return val''
    return result

-- | Set the value of the “@constructed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' objectClass [ #constructed 'Data.GI.Base.Attributes.:=' value ]
-- @
setObjectClassConstructed :: MonadIO m => ObjectClass -> FunPtr GObject.Callbacks.C_ObjectClassConstructedFieldCallback -> m ()
setObjectClassConstructed s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 72) (val :: FunPtr GObject.Callbacks.C_ObjectClassConstructedFieldCallback)

-- | Set the value of the “@constructed@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #constructed
-- @
clearObjectClassConstructed :: MonadIO m => ObjectClass -> m ()
clearObjectClassConstructed s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 72) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_ObjectClassConstructedFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ObjectClassConstructedFieldInfo
instance AttrInfo ObjectClassConstructedFieldInfo where
    type AttrBaseTypeConstraint ObjectClassConstructedFieldInfo = (~) ObjectClass
    type AttrAllowedOps ObjectClassConstructedFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ObjectClassConstructedFieldInfo = (~) (FunPtr GObject.Callbacks.C_ObjectClassConstructedFieldCallback)
    type AttrTransferTypeConstraint ObjectClassConstructedFieldInfo = (~)GObject.Callbacks.ObjectClassConstructedFieldCallback
    type AttrTransferType ObjectClassConstructedFieldInfo = (FunPtr GObject.Callbacks.C_ObjectClassConstructedFieldCallback)
    type AttrGetType ObjectClassConstructedFieldInfo = Maybe GObject.Callbacks.ObjectClassConstructedFieldCallback
    type AttrLabel ObjectClassConstructedFieldInfo = "constructed"
    type AttrOrigin ObjectClassConstructedFieldInfo = ObjectClass
    attrGet = getObjectClassConstructed
    attrSet = setObjectClassConstructed
    attrConstruct = undefined
    attrClear = clearObjectClassConstructed
    attrTransfer _ v = do
        GObject.Callbacks.mk_ObjectClassConstructedFieldCallback (GObject.Callbacks.wrap_ObjectClassConstructedFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.constructed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#g:attr:constructed"
        })

objectClass_constructed :: AttrLabelProxy "constructed"
objectClass_constructed = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ObjectClass
type instance O.AttributeList ObjectClass = ObjectClassAttributeList
type ObjectClassAttributeList = ('[ '("gTypeClass", ObjectClassGTypeClassFieldInfo), '("setProperty", ObjectClassSetPropertyFieldInfo), '("getProperty", ObjectClassGetPropertyFieldInfo), '("dispose", ObjectClassDisposeFieldInfo), '("finalize", ObjectClassFinalizeFieldInfo), '("dispatchPropertiesChanged", ObjectClassDispatchPropertiesChangedFieldInfo), '("notify", ObjectClassNotifyFieldInfo), '("constructed", ObjectClassConstructedFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method ObjectClass::find_property
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "oclass"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ObjectClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObjectClass" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the property to look up"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_object_class_find_property" g_object_class_find_property :: 
    Ptr ObjectClass ->                      -- oclass : TInterface (Name {namespace = "GObject", name = "ObjectClass"})
    CString ->                              -- property_name : TBasicType TUTF8
    IO (Ptr GParamSpec)

-- | Looks up the t'GI.GObject.Objects.ParamSpec.ParamSpec' for a property of a class.
objectClassFindProperty ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ObjectClass
    -- ^ /@oclass@/: a t'GI.GObject.Structs.ObjectClass.ObjectClass'
    -> T.Text
    -- ^ /@propertyName@/: the name of the property to look up
    -> m GParamSpec
    -- ^ __Returns:__ the t'GI.GObject.Objects.ParamSpec.ParamSpec' for the property, or
    --          'P.Nothing' if the class doesn\'t have a property of that name
objectClassFindProperty oclass propertyName = liftIO $ do
    oclass' <- unsafeManagedPtrGetPtr oclass
    propertyName' <- textToCString propertyName
    result <- g_object_class_find_property oclass' propertyName'
    checkUnexpectedReturnNULL "objectClassFindProperty" result
    result' <- B.GParamSpec.newGParamSpecFromPtr result
    touchManagedPtr oclass
    freeMem propertyName'
    return result'

#if defined(ENABLE_OVERLOADING)
data ObjectClassFindPropertyMethodInfo
instance (signature ~ (T.Text -> m GParamSpec), MonadIO m) => O.OverloadedMethod ObjectClassFindPropertyMethodInfo ObjectClass signature where
    overloadedMethod = objectClassFindProperty

instance O.OverloadedMethodInfo ObjectClassFindPropertyMethodInfo ObjectClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.objectClassFindProperty",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#v:objectClassFindProperty"
        })


#endif

-- XXX Could not generate method ObjectClass::install_properties
-- Not implemented: Don't know how to pack C array of type TCArray False (-1) 1 TParamSpec
-- method ObjectClass::install_property
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "oclass"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ObjectClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObjectClass" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the id for the new property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GParamSpec for the new property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_object_class_install_property" g_object_class_install_property :: 
    Ptr ObjectClass ->                      -- oclass : TInterface (Name {namespace = "GObject", name = "ObjectClass"})
    Word32 ->                               -- property_id : TBasicType TUInt
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    IO ()

-- | Installs a new property.
-- 
-- All properties should be installed during the class initializer.  It
-- is possible to install properties after that, but doing so is not
-- recommend, and specifically, is not guaranteed to be thread-safe vs.
-- use of properties on the same type on other threads.
-- 
-- Note that it is possible to redefine a property in a derived class,
-- by installing a property with the same name. This can be useful at times,
-- e.g. to change the range of allowed values or the default value.
objectClassInstallProperty ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ObjectClass
    -- ^ /@oclass@/: a t'GI.GObject.Structs.ObjectClass.ObjectClass'
    -> Word32
    -- ^ /@propertyId@/: the id for the new property
    -> GParamSpec
    -- ^ /@pspec@/: the t'GI.GObject.Objects.ParamSpec.ParamSpec' for the new property
    -> m ()
objectClassInstallProperty oclass propertyId pspec = liftIO $ do
    oclass' <- unsafeManagedPtrGetPtr oclass
    pspec' <- unsafeManagedPtrGetPtr pspec
    g_object_class_install_property oclass' propertyId pspec'
    touchManagedPtr oclass
    touchManagedPtr pspec
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectClassInstallPropertyMethodInfo
instance (signature ~ (Word32 -> GParamSpec -> m ()), MonadIO m) => O.OverloadedMethod ObjectClassInstallPropertyMethodInfo ObjectClass signature where
    overloadedMethod = objectClassInstallProperty

instance O.OverloadedMethodInfo ObjectClassInstallPropertyMethodInfo ObjectClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.objectClassInstallProperty",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#v:objectClassInstallProperty"
        })


#endif

-- XXX Could not generate method ObjectClass::list_properties
-- Not implemented: unpackCArray : Don't know how to unpack C Array of type TParamSpec
-- method ObjectClass::override_property
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "oclass"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ObjectClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObjectClass" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new property ID"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the name of a property registered in a parent class or\n in an interface of this class."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_object_class_override_property" g_object_class_override_property :: 
    Ptr ObjectClass ->                      -- oclass : TInterface (Name {namespace = "GObject", name = "ObjectClass"})
    Word32 ->                               -- property_id : TBasicType TUInt
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Registers /@propertyId@/ as referring to a property with the name
-- /@name@/ in a parent class or in an interface implemented by /@oclass@/.
-- This allows this class to \"override\" a property implementation in
-- a parent class or to provide the implementation of a property from
-- an interface.
-- 
-- Internally, overriding is implemented by creating a property of type
-- t'GI.GObject.Objects.ParamSpecOverride.ParamSpecOverride'; generally operations that query the properties of
-- the object class, such as 'GI.GObject.Structs.ObjectClass.objectClassFindProperty' or
-- 'GI.GObject.Structs.ObjectClass.objectClassListProperties' will return the overridden
-- property. However, in one case, the /@constructProperties@/ argument of
-- the /@constructor@/ virtual function, the t'GI.GObject.Objects.ParamSpecOverride.ParamSpecOverride' is passed
-- instead, so that the /@paramId@/ field of the t'GI.GObject.Objects.ParamSpec.ParamSpec' will be
-- correct.  For virtually all uses, this makes no difference. If you
-- need to get the overridden property, you can call
-- 'GI.GObject.Objects.ParamSpec.paramSpecGetRedirectTarget'.
-- 
-- /Since: 2.4/
objectClassOverrideProperty ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ObjectClass
    -- ^ /@oclass@/: a t'GI.GObject.Structs.ObjectClass.ObjectClass'
    -> Word32
    -- ^ /@propertyId@/: the new property ID
    -> T.Text
    -- ^ /@name@/: the name of a property registered in a parent class or
    --  in an interface of this class.
    -> m ()
objectClassOverrideProperty oclass propertyId name = liftIO $ do
    oclass' <- unsafeManagedPtrGetPtr oclass
    name' <- textToCString name
    g_object_class_override_property oclass' propertyId name'
    touchManagedPtr oclass
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data ObjectClassOverridePropertyMethodInfo
instance (signature ~ (Word32 -> T.Text -> m ()), MonadIO m) => O.OverloadedMethod ObjectClassOverridePropertyMethodInfo ObjectClass signature where
    overloadedMethod = objectClassOverrideProperty

instance O.OverloadedMethodInfo ObjectClassOverridePropertyMethodInfo ObjectClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ObjectClass.objectClassOverrideProperty",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ObjectClass.html#v:objectClassOverrideProperty"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveObjectClassMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveObjectClassMethod "findProperty" o = ObjectClassFindPropertyMethodInfo
    ResolveObjectClassMethod "installProperty" o = ObjectClassInstallPropertyMethodInfo
    ResolveObjectClassMethod "overrideProperty" o = ObjectClassOverridePropertyMethodInfo
    ResolveObjectClassMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveObjectClassMethod t ObjectClass, O.OverloadedMethod info ObjectClass p) => OL.IsLabel t (ObjectClass -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveObjectClassMethod t ObjectClass, O.OverloadedMethod info ObjectClass p, R.HasField t ObjectClass p) => R.HasField t ObjectClass p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveObjectClassMethod t ObjectClass, O.OverloadedMethodInfo info ObjectClass) => OL.IsLabel t (O.MethodProxy info ObjectClass) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


