/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbs2_physical_cc = R"doc(Signals DVB-S2 physical layer frames.

Input: QPSK, 8PSK, 16APSK or 32APSK modulated complex IQ values (XFECFRAME). 
Output: DVB-S2 PLFRAME.

Constructor Specific Documentation:

Create a DVB-S2 physical layer framer.

Args:
    framesize : FEC frame size (normal or short).
    rate : FEC code rate.
    constellation : DVB-S2 constellation.
    pilots : pilot symbols (on/off).
    goldcode : physical layer scrambler Gold code (0 to 262141 inclusive).)doc";


static const char* __doc_gr_dtv_dvbs2_physical_cc_dvbs2_physical_cc = R"doc()doc";


static const char* __doc_gr_dtv_dvbs2_physical_cc_make = R"doc(Signals DVB-S2 physical layer frames.

Input: QPSK, 8PSK, 16APSK or 32APSK modulated complex IQ values (XFECFRAME). 
Output: DVB-S2 PLFRAME.

Constructor Specific Documentation:

Create a DVB-S2 physical layer framer.

Args:
    framesize : FEC frame size (normal or short).
    rate : FEC code rate.
    constellation : DVB-S2 constellation.
    pilots : pilot symbols (on/off).
    goldcode : physical layer scrambler Gold code (0 to 262141 inclusive).)doc";
