/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_mpsk_snr_est = R"doc(A parent class for SNR estimators, specifically for M-PSK signals in AWGN channels.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_mpsk_snr_est_0 = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_mpsk_snr_est_1 = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_alpha = R"doc(Get the running-average coefficient.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_set_alpha = R"doc(Set the running-average coefficient.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_update = R"doc(Update the current registers.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_snr = R"doc(Use the register values to compute a new estimate.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_signal = R"doc(Returns the signal power estimate.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_noise = R"doc(Returns the noise power estimate.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_simple = R"doc(SNR Estimator using simple mean/variance estimates.

A very simple SNR estimator that just uses mean and variance estimates of an M-PSK constellation. This estimator is quick and cheap and accurate for high SNR (above 7 dB or so) but quickly starts to overestimate the SNR at low SNR.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_simple_mpsk_snr_est_simple_0 =
    R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_simple_mpsk_snr_est_simple_1 =
    R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_simple_update = R"doc(Update the current registers.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_simple_snr = R"doc(Use the register values to compute a new estimate.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_skew = R"doc(SNR Estimator using skewness correction.

This is an estimator that came from a discussion between Tom Rondeau and fred harris with no known paper reference. The idea is that at low SNR, the variance estimations will be affected because of fold-over around the decision boundaries, which results in a skewness to the samples. We estimate the skewness and use this as a correcting term.


This algorithm only appears to work well for BPSK signals.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_skew_mpsk_snr_est_skew_0 = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_skew_mpsk_snr_est_skew_1 = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_skew_update = R"doc(Update the current registers.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_skew_snr = R"doc(Use the register values to compute a new estimate.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_m2m4 = R"doc(SNR Estimator using 2nd and 4th-order moments.

An SNR estimator for M-PSK signals that uses 2nd (M2) and 4th (M4) order moments. This estimator uses knowledge of the kurtosis of the signal (  and noise ( ) to make its estimation. We use Beaulieu's approximations here to M-PSK signals and AWGN channels such that  and . These approximations significantly reduce the complexity of the calculations (and computations) required.


Reference: D. R. Pauluzzi and N. C. Beaulieu, \"A comparison of SNR
estimation techniques for the AWGN channel,\" IEEE Trans. Communications, Vol. 48, No. 10, pp. 1681-1691, 2000.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_m2m4_mpsk_snr_est_m2m4_0 = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_m2m4_mpsk_snr_est_m2m4_1 = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_m2m4_update = R"doc(Update the current registers.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_m2m4_snr = R"doc(Use the register values to compute a new estimate.)doc";


static const char* __doc_gr_digital_snr_est_m2m4 = R"doc()doc";


static const char* __doc_gr_digital_snr_est_m2m4_snr_est_m2m4_0 = R"doc()doc";


static const char* __doc_gr_digital_snr_est_m2m4_snr_est_m2m4_1 = R"doc()doc";


static const char* __doc_gr_digital_snr_est_m2m4_update = R"doc()doc";


static const char* __doc_gr_digital_snr_est_m2m4_snr = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_svr = R"doc(Signal-to-Variation Ratio SNR Estimator.

This estimator actually comes from an SNR estimator for M-PSK signals in fading channels, but this implementation is specifically for AWGN channels. The math was simplified to assume a signal and noise kurtosis (  and ) for M-PSK signals in AWGN. These approximations significantly reduce the complexity of the calculations (and computations) required.


Original paper: A. L. Brandao, L. B. Lopes, and D. C. McLernon, \"In-service
monitoring of multipath delay and cochannel interference for
indoor mobile communication systems,\" Proc. IEEE Int. Conf. Communications, vol. 3, pp. 1458-1462, May 1994.


Reference: D. R. Pauluzzi and N. C. Beaulieu, \"A comparison of SNR
estimation techniques for the AWGN channel,\" IEEE Trans. Communications, Vol. 48, No. 10, pp. 1681-1691, 2000.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_svr_mpsk_snr_est_svr_0 = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_svr_mpsk_snr_est_svr_1 = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_svr_update = R"doc(Update the current registers.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_svr_snr = R"doc(Use the register values to compute a new estimate.)doc";
