/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "ipc-git-repository.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_path,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_kind,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_details,
        guint arg_flags,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOXED_UINT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBoxedUintStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_remote,
        const gchar *const *arg_ref_specs,
        guint arg_flags,
        const gchar *arg_progress_path,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBoxedUintStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBoxedUintStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boxed (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_init,
        const gchar *arg_progress_path,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Builder.Git.Repository
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:IpcGitRepository
 * @title: IpcGitRepository
 * @short_description: Generated C code for the org.gnome.Builder.Git.Repository D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Builder-Git-Repository.top_of_page">org.gnome.Builder.Git.Repository</link> D-Bus interface in C.
 */

enum
{
  IPC__GIT_REPOSITORY_CHANGED,
  IPC__GIT_REPOSITORY_CLOSED,
};

static unsigned IPC__GIT_REPOSITORY_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.gnome.Builder.Git.Repository ---- */

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_path_is_ignored_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_path_is_ignored_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_path_is_ignored_IN_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_path_is_ignored_OUT_ARG_ignored =
{
  {
    -1,
    (gchar *) "ignored",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_path_is_ignored_OUT_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_path_is_ignored_OUT_ARG_ignored.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_path_is_ignored =
{
  {
    -1,
    (gchar *) "PathIsIgnored",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_path_is_ignored_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_git_repository_method_info_path_is_ignored_OUT_ARG_pointers,
    NULL
  },
  "handle-path-is-ignored",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_list_refs_by_kind_IN_ARG_kind =
{
  {
    -1,
    (gchar *) "kind",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_list_refs_by_kind_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_list_refs_by_kind_IN_ARG_kind.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_list_refs_by_kind_OUT_ARG_refs =
{
  {
    -1,
    (gchar *) "refs",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_list_refs_by_kind_OUT_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_list_refs_by_kind_OUT_ARG_refs.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_list_refs_by_kind =
{
  {
    -1,
    (gchar *) "ListRefsByKind",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_list_refs_by_kind_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_git_repository_method_info_list_refs_by_kind_OUT_ARG_pointers,
    NULL
  },
  "handle-list-refs-by-kind",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_list_status_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_list_status_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_list_status_IN_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_list_status_OUT_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "a(ayu)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_list_status_OUT_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_list_status_OUT_ARG_files.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_list_status =
{
  {
    -1,
    (gchar *) "ListStatus",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_list_status_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_git_repository_method_info_list_status_OUT_ARG_pointers,
    NULL
  },
  "handle-list-status",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_switch_branch_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_switch_branch_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_switch_branch_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_switch_branch =
{
  {
    -1,
    (gchar *) "SwitchBranch",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_switch_branch_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-switch-branch",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_create_change_monitor_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_create_change_monitor_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_create_change_monitor_IN_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_create_change_monitor_OUT_ARG_obj_path =
{
  {
    -1,
    (gchar *) "obj_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_create_change_monitor_OUT_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_create_change_monitor_OUT_ARG_obj_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_create_change_monitor =
{
  {
    -1,
    (gchar *) "CreateChangeMonitor",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_create_change_monitor_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_git_repository_method_info_create_change_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-create-change-monitor",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_blame_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_blame_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_blame_IN_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_blame_OUT_ARG_obj_path =
{
  {
    -1,
    (gchar *) "obj_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_blame_OUT_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_blame_OUT_ARG_obj_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_blame =
{
  {
    -1,
    (gchar *) "Blame",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_blame_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_git_repository_method_info_blame_OUT_ARG_pointers,
    NULL
  },
  "handle-blame",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_stage_file_IN_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_stage_file_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_stage_file_IN_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_stage_file =
{
  {
    -1,
    (gchar *) "StageFile",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_stage_file_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-stage-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_commit_IN_ARG_details =
{
  {
    -1,
    (gchar *) "details",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_commit_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_commit_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_commit_IN_ARG_details.parent_struct,
  &_ipc_git_repository_method_info_commit_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_commit =
{
  {
    -1,
    (gchar *) "Commit",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_commit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-commit",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_push_IN_ARG_remote =
{
  {
    -1,
    (gchar *) "remote",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_push_IN_ARG_ref_specs =
{
  {
    -1,
    (gchar *) "ref_specs",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_push_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_push_IN_ARG_progress_path =
{
  {
    -1,
    (gchar *) "progress_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_push_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_push_IN_ARG_remote.parent_struct,
  &_ipc_git_repository_method_info_push_IN_ARG_ref_specs.parent_struct,
  &_ipc_git_repository_method_info_push_IN_ARG_flags.parent_struct,
  &_ipc_git_repository_method_info_push_IN_ARG_progress_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_push =
{
  {
    -1,
    (gchar *) "Push",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_push_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-push",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_load_config_OUT_ARG_config_path =
{
  {
    -1,
    (gchar *) "config_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_load_config_OUT_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_load_config_OUT_ARG_config_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_load_config =
{
  {
    -1,
    (gchar *) "LoadConfig",
    NULL,
    (GDBusArgInfo **) &_ipc_git_repository_method_info_load_config_OUT_ARG_pointers,
    NULL
  },
  "handle-load-config",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_update_submodules_IN_ARG_init =
{
  {
    -1,
    (gchar *) "init",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_update_submodules_IN_ARG_progress_path =
{
  {
    -1,
    (gchar *) "progress_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_update_submodules_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_update_submodules_IN_ARG_init.parent_struct,
  &_ipc_git_repository_method_info_update_submodules_IN_ARG_progress_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_update_submodules =
{
  {
    -1,
    (gchar *) "UpdateSubmodules",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_update_submodules_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update-submodules",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_get_remote_url_IN_ARG_remote_name =
{
  {
    -1,
    (gchar *) "remote_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_get_remote_url_IN_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_get_remote_url_IN_ARG_remote_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_git_repository_method_info_get_remote_url_OUT_ARG_url =
{
  {
    -1,
    (gchar *) "url",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_git_repository_method_info_get_remote_url_OUT_ARG_pointers[] =
{
  &_ipc_git_repository_method_info_get_remote_url_OUT_ARG_url.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_git_repository_method_info_get_remote_url =
{
  {
    -1,
    (gchar *) "GetRemoteUrl",
    (GDBusArgInfo **) &_ipc_git_repository_method_info_get_remote_url_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_git_repository_method_info_get_remote_url_OUT_ARG_pointers,
    NULL
  },
  "handle-get-remote-url",
  FALSE
};

static const GDBusMethodInfo * const _ipc_git_repository_method_info_pointers[] =
{
  &_ipc_git_repository_method_info_close.parent_struct,
  &_ipc_git_repository_method_info_path_is_ignored.parent_struct,
  &_ipc_git_repository_method_info_list_refs_by_kind.parent_struct,
  &_ipc_git_repository_method_info_list_status.parent_struct,
  &_ipc_git_repository_method_info_switch_branch.parent_struct,
  &_ipc_git_repository_method_info_create_change_monitor.parent_struct,
  &_ipc_git_repository_method_info_blame.parent_struct,
  &_ipc_git_repository_method_info_stage_file.parent_struct,
  &_ipc_git_repository_method_info_commit.parent_struct,
  &_ipc_git_repository_method_info_push.parent_struct,
  &_ipc_git_repository_method_info_load_config.parent_struct,
  &_ipc_git_repository_method_info_update_submodules.parent_struct,
  &_ipc_git_repository_method_info_get_remote_url.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ipc_git_repository_signal_info_changed =
{
  {
    -1,
    (gchar *) "Changed",
    NULL,
    NULL
  },
  "changed"
};

static const _ExtendedGDBusSignalInfo _ipc_git_repository_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const GDBusSignalInfo * const _ipc_git_repository_signal_info_pointers[] =
{
  &_ipc_git_repository_signal_info_changed.parent_struct,
  &_ipc_git_repository_signal_info_closed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _ipc_git_repository_property_info_branch =
{
  {
    -1,
    (gchar *) "Branch",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "branch",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_git_repository_property_info_location =
{
  {
    -1,
    (gchar *) "Location",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "location",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_git_repository_property_info_workdir =
{
  {
    -1,
    (gchar *) "Workdir",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "workdir",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _ipc_git_repository_property_info_pointers[] =
{
  &_ipc_git_repository_property_info_branch.parent_struct,
  &_ipc_git_repository_property_info_location.parent_struct,
  &_ipc_git_repository_property_info_workdir.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ipc_git_repository_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Builder.Git.Repository",
    (GDBusMethodInfo **) &_ipc_git_repository_method_info_pointers,
    (GDBusSignalInfo **) &_ipc_git_repository_signal_info_pointers,
    (GDBusPropertyInfo **) &_ipc_git_repository_property_info_pointers,
    NULL
  },
  "git-repository",
};


/**
 * ipc_git_repository_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Builder-Git-Repository.top_of_page">org.gnome.Builder.Git.Repository</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ipc_git_repository_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ipc_git_repository_interface_info.parent_struct;
}

/**
 * ipc_git_repository_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #IpcGitRepository interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ipc_git_repository_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "branch");
  g_object_class_override_property (klass, property_id_begin++, "location");
  g_object_class_override_property (klass, property_id_begin++, "workdir");
  return property_id_begin - 1;
}


inline static void
ipc_git_repository_signal_marshal_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_signal_marshal_closed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_close (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_path_is_ignored (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_list_refs_by_kind (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_list_status (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_switch_branch (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_create_change_monitor (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_blame (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_stage_file (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_commit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_push (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOXED_UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_load_config (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_update_submodules (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ipc_git_repository_method_marshal_get_remote_url (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * IpcGitRepository:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Builder-Git-Repository.top_of_page">org.gnome.Builder.Git.Repository</link>.
 */

/**
 * IpcGitRepositoryIface:
 * @parent_iface: The parent interface.
 * @handle_blame: Handler for the #IpcGitRepository::handle-blame signal.
 * @handle_close: Handler for the #IpcGitRepository::handle-close signal.
 * @handle_commit: Handler for the #IpcGitRepository::handle-commit signal.
 * @handle_create_change_monitor: Handler for the #IpcGitRepository::handle-create-change-monitor signal.
 * @handle_get_remote_url: Handler for the #IpcGitRepository::handle-get-remote-url signal.
 * @handle_list_refs_by_kind: Handler for the #IpcGitRepository::handle-list-refs-by-kind signal.
 * @handle_list_status: Handler for the #IpcGitRepository::handle-list-status signal.
 * @handle_load_config: Handler for the #IpcGitRepository::handle-load-config signal.
 * @handle_path_is_ignored: Handler for the #IpcGitRepository::handle-path-is-ignored signal.
 * @handle_push: Handler for the #IpcGitRepository::handle-push signal.
 * @handle_stage_file: Handler for the #IpcGitRepository::handle-stage-file signal.
 * @handle_switch_branch: Handler for the #IpcGitRepository::handle-switch-branch signal.
 * @handle_update_submodules: Handler for the #IpcGitRepository::handle-update-submodules signal.
 * @get_branch: Getter for the #IpcGitRepository:branch property.
 * @get_location: Getter for the #IpcGitRepository:location property.
 * @get_workdir: Getter for the #IpcGitRepository:workdir property.
 * @changed: Handler for the #IpcGitRepository::changed signal.
 * @closed: Handler for the #IpcGitRepository::closed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Builder-Git-Repository.top_of_page">org.gnome.Builder.Git.Repository</link>.
 */

typedef IpcGitRepositoryIface IpcGitRepositoryInterface;
G_DEFINE_INTERFACE (IpcGitRepository, ipc_git_repository, G_TYPE_OBJECT)

static void
ipc_git_repository_default_init (IpcGitRepositoryIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * IpcGitRepository::handle-close:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_close,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcGitRepository::handle-path-is-ignored:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.PathIsIgnored">PathIsIgnored()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_path_is_ignored() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-path-is-ignored",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_path_is_ignored),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_path_is_ignored,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcGitRepository::handle-list-refs-by-kind:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_kind: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.ListRefsByKind">ListRefsByKind()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_list_refs_by_kind() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-refs-by-kind",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_list_refs_by_kind),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_list_refs_by_kind,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * IpcGitRepository::handle-list-status:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.ListStatus">ListStatus()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_list_status() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-status",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_list_status),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_list_status,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcGitRepository::handle-switch-branch:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.SwitchBranch">SwitchBranch()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_switch_branch() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-switch-branch",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_switch_branch),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_switch_branch,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcGitRepository::handle-create-change-monitor:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.CreateChangeMonitor">CreateChangeMonitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_create_change_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-change-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_create_change_monitor),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_create_change_monitor,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcGitRepository::handle-blame:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Blame">Blame()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_blame() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-blame",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_blame),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_blame,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcGitRepository::handle-stage-file:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.StageFile">StageFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_stage_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stage-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_stage_file),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_stage_file,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcGitRepository::handle-commit:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_details: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Commit">Commit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_commit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-commit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_commit),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_commit,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_UINT);

  /**
   * IpcGitRepository::handle-push:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_remote: Argument passed by remote caller.
   * @arg_ref_specs: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_progress_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Push">Push()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_push() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-push",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_push),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_push,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * IpcGitRepository::handle-load-config:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.LoadConfig">LoadConfig()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_load_config() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-load-config",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_load_config),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_load_config,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcGitRepository::handle-update-submodules:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_init: Argument passed by remote caller.
   * @arg_progress_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.UpdateSubmodules">UpdateSubmodules()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_update_submodules() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update-submodules",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_update_submodules),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_update_submodules,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /**
   * IpcGitRepository::handle-get-remote-url:
   * @object: A #IpcGitRepository.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_remote_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.GetRemoteUrl">GetRemoteUrl()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_git_repository_complete_get_remote_url() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-remote-url",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcGitRepositoryIface, handle_get_remote_url),
    g_signal_accumulator_true_handled,
    NULL,
      ipc_git_repository_method_marshal_get_remote_url,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * IpcGitRepository::changed:
   * @object: A #IpcGitRepository.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Builder-Git-Repository.Changed">"Changed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  IPC__GIT_REPOSITORY_SIGNALS[IPC__GIT_REPOSITORY_CHANGED] =
    g_signal_new ("changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (IpcGitRepositoryIface, changed),
      NULL,
      NULL,
      ipc_git_repository_signal_marshal_changed,
      G_TYPE_NONE,
      0);

  /**
   * IpcGitRepository::closed:
   * @object: A #IpcGitRepository.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Builder-Git-Repository.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  IPC__GIT_REPOSITORY_SIGNALS[IPC__GIT_REPOSITORY_CLOSED] =
    g_signal_new ("closed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (IpcGitRepositoryIface, closed),
      NULL,
      NULL,
      ipc_git_repository_signal_marshal_closed,
      G_TYPE_NONE,
      0);

  /* GObject properties for D-Bus properties: */
  /**
   * IpcGitRepository:branch:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Branch">"Branch"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("branch", "Branch", "Branch", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcGitRepository:location:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Location">"Location"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("location", "Location", "Location", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcGitRepository:workdir:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Workdir">"Workdir"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("workdir", "Workdir", "Workdir", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * ipc_git_repository_get_branch: (skip)
 * @object: A #IpcGitRepository.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Branch">"Branch"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ipc_git_repository_dup_branch() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ipc_git_repository_get_branch (IpcGitRepository *object)
{
  g_return_val_if_fail (IPC_IS_GIT_REPOSITORY (object), NULL);

  return IPC_GIT_REPOSITORY_GET_IFACE (object)->get_branch (object);
}

/**
 * ipc_git_repository_dup_branch: (skip)
 * @object: A #IpcGitRepository.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Branch">"Branch"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ipc_git_repository_dup_branch (IpcGitRepository *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "branch", &value, NULL);
  return value;
}

/**
 * ipc_git_repository_set_branch: (skip)
 * @object: A #IpcGitRepository.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Branch">"Branch"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ipc_git_repository_set_branch (IpcGitRepository *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "branch", value, NULL);
}

/**
 * ipc_git_repository_get_location: (skip)
 * @object: A #IpcGitRepository.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Location">"Location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ipc_git_repository_dup_location() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ipc_git_repository_get_location (IpcGitRepository *object)
{
  g_return_val_if_fail (IPC_IS_GIT_REPOSITORY (object), NULL);

  return IPC_GIT_REPOSITORY_GET_IFACE (object)->get_location (object);
}

/**
 * ipc_git_repository_dup_location: (skip)
 * @object: A #IpcGitRepository.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Location">"Location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ipc_git_repository_dup_location (IpcGitRepository *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "location", &value, NULL);
  return value;
}

/**
 * ipc_git_repository_set_location: (skip)
 * @object: A #IpcGitRepository.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Location">"Location"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ipc_git_repository_set_location (IpcGitRepository *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "location", value, NULL);
}

/**
 * ipc_git_repository_get_workdir: (skip)
 * @object: A #IpcGitRepository.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Workdir">"Workdir"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ipc_git_repository_dup_workdir() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ipc_git_repository_get_workdir (IpcGitRepository *object)
{
  g_return_val_if_fail (IPC_IS_GIT_REPOSITORY (object), NULL);

  return IPC_GIT_REPOSITORY_GET_IFACE (object)->get_workdir (object);
}

/**
 * ipc_git_repository_dup_workdir: (skip)
 * @object: A #IpcGitRepository.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Workdir">"Workdir"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ipc_git_repository_dup_workdir (IpcGitRepository *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "workdir", &value, NULL);
  return value;
}

/**
 * ipc_git_repository_set_workdir: (skip)
 * @object: A #IpcGitRepository.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Builder-Git-Repository.Workdir">"Workdir"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ipc_git_repository_set_workdir (IpcGitRepository *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "workdir", value, NULL);
}

/**
 * ipc_git_repository_emit_changed:
 * @object: A #IpcGitRepository.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Builder-Git-Repository.Changed">"Changed"</link> D-Bus signal.
 */
void
ipc_git_repository_emit_changed (
    IpcGitRepository *object)
{
  g_signal_emit (object, IPC__GIT_REPOSITORY_SIGNALS[IPC__GIT_REPOSITORY_CHANGED], 0);
}

/**
 * ipc_git_repository_emit_closed:
 * @object: A #IpcGitRepository.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Builder-Git-Repository.Closed">"Closed"</link> D-Bus signal.
 */
void
ipc_git_repository_emit_closed (
    IpcGitRepository *object)
{
  g_signal_emit (object, IPC__GIT_REPOSITORY_SIGNALS[IPC__GIT_REPOSITORY_CLOSED], 0);
}

/**
 * ipc_git_repository_call_close:
 * @proxy: A #IpcGitRepositoryProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_close_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_close_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_close (
    IpcGitRepository *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_close_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_close_finish (
    IpcGitRepository *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_close_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_close_sync (
    IpcGitRepository *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_path_is_ignored:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.PathIsIgnored">PathIsIgnored()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_path_is_ignored_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_path_is_ignored_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_path_is_ignored (
    IpcGitRepository *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PathIsIgnored",
    g_variant_new ("(^ay)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_path_is_ignored_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @out_ignored: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_path_is_ignored().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_path_is_ignored().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_path_is_ignored_finish (
    IpcGitRepository *proxy,
    gboolean *out_ignored,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_ignored);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_path_is_ignored_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @out_ignored: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.PathIsIgnored">PathIsIgnored()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_path_is_ignored() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_path_is_ignored_sync (
    IpcGitRepository *proxy,
    const gchar *arg_path,
    gboolean *out_ignored,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PathIsIgnored",
    g_variant_new ("(^ay)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_ignored);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_list_refs_by_kind:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_kind: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.ListRefsByKind">ListRefsByKind()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_list_refs_by_kind_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_list_refs_by_kind_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_list_refs_by_kind (
    IpcGitRepository *proxy,
    guint arg_kind,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListRefsByKind",
    g_variant_new ("(u)",
                   arg_kind),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_list_refs_by_kind_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @out_refs: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_list_refs_by_kind().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_list_refs_by_kind().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_list_refs_by_kind_finish (
    IpcGitRepository *proxy,
    gchar ***out_refs,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_refs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_list_refs_by_kind_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_kind: Argument to pass with the method invocation.
 * @out_refs: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.ListRefsByKind">ListRefsByKind()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_list_refs_by_kind() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_list_refs_by_kind_sync (
    IpcGitRepository *proxy,
    guint arg_kind,
    gchar ***out_refs,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListRefsByKind",
    g_variant_new ("(u)",
                   arg_kind),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_refs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_list_status:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.ListStatus">ListStatus()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_list_status_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_list_status_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_list_status (
    IpcGitRepository *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListStatus",
    g_variant_new ("(^ay)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_list_status_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @out_files: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_list_status().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_list_status().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_list_status_finish (
    IpcGitRepository *proxy,
    GVariant **out_files,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ayu))",
                 out_files);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_list_status_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @out_files: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.ListStatus">ListStatus()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_list_status() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_list_status_sync (
    IpcGitRepository *proxy,
    const gchar *arg_path,
    GVariant **out_files,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListStatus",
    g_variant_new ("(^ay)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ayu))",
                 out_files);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_switch_branch:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.SwitchBranch">SwitchBranch()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_switch_branch_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_switch_branch_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_switch_branch (
    IpcGitRepository *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SwitchBranch",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_switch_branch_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_switch_branch().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_switch_branch().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_switch_branch_finish (
    IpcGitRepository *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_switch_branch_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.SwitchBranch">SwitchBranch()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_switch_branch() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_switch_branch_sync (
    IpcGitRepository *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SwitchBranch",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_create_change_monitor:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.CreateChangeMonitor">CreateChangeMonitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_create_change_monitor_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_create_change_monitor_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_create_change_monitor (
    IpcGitRepository *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateChangeMonitor",
    g_variant_new ("(s)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_create_change_monitor_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @out_obj_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_create_change_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_create_change_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_create_change_monitor_finish (
    IpcGitRepository *proxy,
    gchar **out_obj_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_obj_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_create_change_monitor_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @out_obj_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.CreateChangeMonitor">CreateChangeMonitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_create_change_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_create_change_monitor_sync (
    IpcGitRepository *proxy,
    const gchar *arg_path,
    gchar **out_obj_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateChangeMonitor",
    g_variant_new ("(s)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_obj_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_blame:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Blame">Blame()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_blame_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_blame_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_blame (
    IpcGitRepository *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Blame",
    g_variant_new ("(s)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_blame_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @out_obj_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_blame().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_blame().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_blame_finish (
    IpcGitRepository *proxy,
    gchar **out_obj_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_obj_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_blame_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @out_obj_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Blame">Blame()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_blame() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_blame_sync (
    IpcGitRepository *proxy,
    const gchar *arg_path,
    gchar **out_obj_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Blame",
    g_variant_new ("(s)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_obj_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_stage_file:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.StageFile">StageFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_stage_file_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_stage_file_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_stage_file (
    IpcGitRepository *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StageFile",
    g_variant_new ("(^ay)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_stage_file_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_stage_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_stage_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_stage_file_finish (
    IpcGitRepository *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_stage_file_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.StageFile">StageFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_stage_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_stage_file_sync (
    IpcGitRepository *proxy,
    const gchar *arg_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StageFile",
    g_variant_new ("(^ay)",
                   arg_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_commit:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_details: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Commit">Commit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_commit_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_commit_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_commit (
    IpcGitRepository *proxy,
    GVariant *arg_details,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Commit",
    g_variant_new ("(@a{sv}u)",
                   arg_details,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_commit_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_commit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_commit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_commit_finish (
    IpcGitRepository *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_commit_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_details: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Commit">Commit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_commit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_commit_sync (
    IpcGitRepository *proxy,
    GVariant *arg_details,
    guint arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Commit",
    g_variant_new ("(@a{sv}u)",
                   arg_details,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_push:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_ref_specs: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_progress_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Push">Push()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_push_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_push_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_push (
    IpcGitRepository *proxy,
    const gchar *arg_remote,
    const gchar *const *arg_ref_specs,
    guint arg_flags,
    const gchar *arg_progress_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Push",
    g_variant_new ("(s^asuo)",
                   arg_remote,
                   arg_ref_specs,
                   arg_flags,
                   arg_progress_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_push_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_push().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_push().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_push_finish (
    IpcGitRepository *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_push_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_ref_specs: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_progress_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Push">Push()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_push() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_push_sync (
    IpcGitRepository *proxy,
    const gchar *arg_remote,
    const gchar *const *arg_ref_specs,
    guint arg_flags,
    const gchar *arg_progress_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Push",
    g_variant_new ("(s^asuo)",
                   arg_remote,
                   arg_ref_specs,
                   arg_flags,
                   arg_progress_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_load_config:
 * @proxy: A #IpcGitRepositoryProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.LoadConfig">LoadConfig()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_load_config_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_load_config_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_load_config (
    IpcGitRepository *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LoadConfig",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_load_config_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @out_config_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_load_config().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_load_config().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_load_config_finish (
    IpcGitRepository *proxy,
    gchar **out_config_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_config_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_load_config_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @out_config_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.LoadConfig">LoadConfig()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_load_config() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_load_config_sync (
    IpcGitRepository *proxy,
    gchar **out_config_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LoadConfig",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_config_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_update_submodules:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_init: Argument to pass with the method invocation.
 * @arg_progress_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.UpdateSubmodules">UpdateSubmodules()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_update_submodules_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_update_submodules_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_update_submodules (
    IpcGitRepository *proxy,
    gboolean arg_init,
    const gchar *arg_progress_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UpdateSubmodules",
    g_variant_new ("(bo)",
                   arg_init,
                   arg_progress_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_update_submodules_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_update_submodules().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_update_submodules().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_update_submodules_finish (
    IpcGitRepository *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_update_submodules_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_init: Argument to pass with the method invocation.
 * @arg_progress_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.UpdateSubmodules">UpdateSubmodules()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_update_submodules() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_update_submodules_sync (
    IpcGitRepository *proxy,
    gboolean arg_init,
    const gchar *arg_progress_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UpdateSubmodules",
    g_variant_new ("(bo)",
                   arg_init,
                   arg_progress_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_get_remote_url:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_remote_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.GetRemoteUrl">GetRemoteUrl()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_call_get_remote_url_finish() to get the result of the operation.
 *
 * See ipc_git_repository_call_get_remote_url_sync() for the synchronous, blocking version of this method.
 */
void
ipc_git_repository_call_get_remote_url (
    IpcGitRepository *proxy,
    const gchar *arg_remote_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetRemoteUrl",
    g_variant_new ("(s)",
                   arg_remote_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_git_repository_call_get_remote_url_finish:
 * @proxy: A #IpcGitRepositoryProxy.
 * @out_url: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_call_get_remote_url().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_git_repository_call_get_remote_url().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_get_remote_url_finish (
    IpcGitRepository *proxy,
    gchar **out_url,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_url);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_call_get_remote_url_sync:
 * @proxy: A #IpcGitRepositoryProxy.
 * @arg_remote_name: Argument to pass with the method invocation.
 * @out_url: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.GetRemoteUrl">GetRemoteUrl()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_call_get_remote_url() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_git_repository_call_get_remote_url_sync (
    IpcGitRepository *proxy,
    const gchar *arg_remote_name,
    gchar **out_url,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetRemoteUrl",
    g_variant_new ("(s)",
                   arg_remote_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_url);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_git_repository_complete_close:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_close (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_git_repository_complete_path_is_ignored:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @ignored: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.PathIsIgnored">PathIsIgnored()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_path_is_ignored (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean ignored)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   ignored));
}

/**
 * ipc_git_repository_complete_list_refs_by_kind:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @refs: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.ListRefsByKind">ListRefsByKind()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_list_refs_by_kind (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *refs)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   refs));
}

/**
 * ipc_git_repository_complete_list_status:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @files: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.ListStatus">ListStatus()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_list_status (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *files)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ayu))",
                   files));
}

/**
 * ipc_git_repository_complete_switch_branch:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.SwitchBranch">SwitchBranch()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_switch_branch (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_git_repository_complete_create_change_monitor:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @obj_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.CreateChangeMonitor">CreateChangeMonitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_create_change_monitor (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *obj_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   obj_path));
}

/**
 * ipc_git_repository_complete_blame:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @obj_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Blame">Blame()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_blame (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *obj_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   obj_path));
}

/**
 * ipc_git_repository_complete_stage_file:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.StageFile">StageFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_stage_file (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_git_repository_complete_commit:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Commit">Commit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_commit (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_git_repository_complete_push:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.Push">Push()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_push (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_git_repository_complete_load_config:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @config_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.LoadConfig">LoadConfig()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_load_config (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *config_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   config_path));
}

/**
 * ipc_git_repository_complete_update_submodules:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.UpdateSubmodules">UpdateSubmodules()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_update_submodules (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_git_repository_complete_get_remote_url:
 * @object: A #IpcGitRepository.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @url: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Builder-Git-Repository.GetRemoteUrl">GetRemoteUrl()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_git_repository_complete_get_remote_url (
    IpcGitRepository *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *url)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   url));
}

/* ------------------------------------------------------------------------ */

/**
 * IpcGitRepositoryProxy:
 *
 * The #IpcGitRepositoryProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IpcGitRepositoryProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IpcGitRepositoryProxy.
 */

struct _IpcGitRepositoryProxyPrivate
{
  GData *qdata;
};

static void ipc_git_repository_proxy_iface_init (IpcGitRepositoryIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IpcGitRepositoryProxy, ipc_git_repository_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (IpcGitRepositoryProxy)
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_GIT_REPOSITORY, ipc_git_repository_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IpcGitRepositoryProxy, ipc_git_repository_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_GIT_REPOSITORY, ipc_git_repository_proxy_iface_init))

#endif
static void
ipc_git_repository_proxy_finalize (GObject *object)
{
  IpcGitRepositoryProxy *proxy = IPC_GIT_REPOSITORY_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ipc_git_repository_proxy_parent_class)->finalize (object);
}

static void
ipc_git_repository_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _ipc_git_repository_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
ipc_git_repository_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Builder.Git.Repository: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
ipc_git_repository_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _ipc_git_repository_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Builder.Git.Repository", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) ipc_git_repository_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
ipc_git_repository_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ipc_git_repository_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], IPC_TYPE_GIT_REPOSITORY);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IPC_TYPE_GIT_REPOSITORY);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ipc_git_repository_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  IpcGitRepositoryProxy *proxy = IPC_GIT_REPOSITORY_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_git_repository_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_git_repository_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
ipc_git_repository_proxy_get_branch (IpcGitRepository *object)
{
  IpcGitRepositoryProxy *proxy = IPC_GIT_REPOSITORY_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Branch");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ipc_git_repository_proxy_get_location (IpcGitRepository *object)
{
  IpcGitRepositoryProxy *proxy = IPC_GIT_REPOSITORY_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Location");
  if (variant != NULL)
    {
      value = g_variant_get_bytestring (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ipc_git_repository_proxy_get_workdir (IpcGitRepository *object)
{
  IpcGitRepositoryProxy *proxy = IPC_GIT_REPOSITORY_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Workdir");
  if (variant != NULL)
    {
      value = g_variant_get_bytestring (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
ipc_git_repository_proxy_init (IpcGitRepositoryProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ipc_git_repository_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, IPC_TYPE_GIT_REPOSITORY_PROXY, IpcGitRepositoryProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ipc_git_repository_interface_info ());
}

static void
ipc_git_repository_proxy_class_init (IpcGitRepositoryProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ipc_git_repository_proxy_finalize;
  gobject_class->get_property = ipc_git_repository_proxy_get_property;
  gobject_class->set_property = ipc_git_repository_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ipc_git_repository_proxy_g_signal;
  proxy_class->g_properties_changed = ipc_git_repository_proxy_g_properties_changed;

  ipc_git_repository_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IpcGitRepositoryProxyPrivate));
#endif
}

static void
ipc_git_repository_proxy_iface_init (IpcGitRepositoryIface *iface)
{
  iface->get_branch = ipc_git_repository_proxy_get_branch;
  iface->get_location = ipc_git_repository_proxy_get_location;
  iface->get_workdir = ipc_git_repository_proxy_get_workdir;
}

/**
 * ipc_git_repository_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Builder-Git-Repository.top_of_page">org.gnome.Builder.Git.Repository</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_proxy_new_finish() to get the result of the operation.
 *
 * See ipc_git_repository_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ipc_git_repository_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IPC_TYPE_GIT_REPOSITORY_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Builder.Git.Repository", NULL);
}

/**
 * ipc_git_repository_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ipc_git_repository_proxy_new().
 *
 * Returns: (transfer full) (type IpcGitRepositoryProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcGitRepository *
ipc_git_repository_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IPC_GIT_REPOSITORY (ret);
  else
    return NULL;
}

/**
 * ipc_git_repository_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Builder-Git-Repository.top_of_page">org.gnome.Builder.Git.Repository</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IpcGitRepositoryProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcGitRepository *
ipc_git_repository_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IPC_TYPE_GIT_REPOSITORY_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Builder.Git.Repository", NULL);
  if (ret != NULL)
    return IPC_GIT_REPOSITORY (ret);
  else
    return NULL;
}


/**
 * ipc_git_repository_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ipc_git_repository_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_git_repository_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ipc_git_repository_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ipc_git_repository_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IPC_TYPE_GIT_REPOSITORY_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Builder.Git.Repository", NULL);
}

/**
 * ipc_git_repository_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_git_repository_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ipc_git_repository_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type IpcGitRepositoryProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcGitRepository *
ipc_git_repository_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IPC_GIT_REPOSITORY (ret);
  else
    return NULL;
}

/**
 * ipc_git_repository_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ipc_git_repository_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ipc_git_repository_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IpcGitRepositoryProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcGitRepository *
ipc_git_repository_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IPC_TYPE_GIT_REPOSITORY_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Builder.Git.Repository", NULL);
  if (ret != NULL)
    return IPC_GIT_REPOSITORY (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * IpcGitRepositorySkeleton:
 *
 * The #IpcGitRepositorySkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IpcGitRepositorySkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IpcGitRepositorySkeleton.
 */

struct _IpcGitRepositorySkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ipc_git_repository_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], IPC_TYPE_GIT_REPOSITORY);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IPC_TYPE_GIT_REPOSITORY);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ipc_git_repository_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_git_repository_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ipc_git_repository_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_git_repository_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ipc_git_repository_skeleton_vtable =
{
  _ipc_git_repository_skeleton_handle_method_call,
  _ipc_git_repository_skeleton_handle_get_property,
  _ipc_git_repository_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ipc_git_repository_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ipc_git_repository_interface_info ();
}

static GDBusInterfaceVTable *
ipc_git_repository_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ipc_git_repository_skeleton_vtable;
}

static GVariant *
ipc_git_repository_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_ipc_git_repository_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ipc_git_repository_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ipc_git_repository_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ipc_git_repository_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Builder.Git.Repository", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _ipc_git_repository_emit_changed (gpointer user_data);

static void
ipc_git_repository_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _ipc_git_repository_emit_changed (skeleton);
}

static void
_ipc_git_repository_on_signal_changed (
    IpcGitRepository *object)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Builder.Git.Repository", "Changed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ipc_git_repository_on_signal_closed (
    IpcGitRepository *object)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Builder.Git.Repository", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void ipc_git_repository_skeleton_iface_init (IpcGitRepositoryIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IpcGitRepositorySkeleton, ipc_git_repository_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (IpcGitRepositorySkeleton)
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_GIT_REPOSITORY, ipc_git_repository_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IpcGitRepositorySkeleton, ipc_git_repository_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_GIT_REPOSITORY, ipc_git_repository_skeleton_iface_init))

#endif
static void
ipc_git_repository_skeleton_finalize (GObject *object)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ipc_git_repository_skeleton_parent_class)->finalize (object);
}

static void
ipc_git_repository_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_ipc_git_repository_emit_changed (gpointer user_data)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Builder.Git.Repository",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_ipc_git_repository_schedule_emit_changed (IpcGitRepositorySkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
ipc_git_repository_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _ipc_git_repository_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _ipc_git_repository_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
ipc_git_repository_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _ipc_git_repository_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _ipc_git_repository_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
ipc_git_repository_skeleton_init (IpcGitRepositorySkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ipc_git_repository_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, IPC_TYPE_GIT_REPOSITORY_SKELETON, IpcGitRepositorySkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
}

static const gchar *
ipc_git_repository_skeleton_get_branch (IpcGitRepository *object)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ipc_git_repository_skeleton_get_location (IpcGitRepository *object)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ipc_git_repository_skeleton_get_workdir (IpcGitRepository *object)
{
  IpcGitRepositorySkeleton *skeleton = IPC_GIT_REPOSITORY_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
ipc_git_repository_skeleton_class_init (IpcGitRepositorySkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ipc_git_repository_skeleton_finalize;
  gobject_class->get_property = ipc_git_repository_skeleton_get_property;
  gobject_class->set_property = ipc_git_repository_skeleton_set_property;
  gobject_class->notify       = ipc_git_repository_skeleton_notify;


  ipc_git_repository_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ipc_git_repository_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ipc_git_repository_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ipc_git_repository_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ipc_git_repository_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IpcGitRepositorySkeletonPrivate));
#endif
}

static void
ipc_git_repository_skeleton_iface_init (IpcGitRepositoryIface *iface)
{
  iface->changed = _ipc_git_repository_on_signal_changed;
  iface->closed = _ipc_git_repository_on_signal_closed;
  iface->get_branch = ipc_git_repository_skeleton_get_branch;
  iface->get_location = ipc_git_repository_skeleton_get_location;
  iface->get_workdir = ipc_git_repository_skeleton_get_workdir;
}

/**
 * ipc_git_repository_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Builder-Git-Repository.top_of_page">org.gnome.Builder.Git.Repository</link>.
 *
 * Returns: (transfer full) (type IpcGitRepositorySkeleton): The skeleton object.
 */
IpcGitRepository *
ipc_git_repository_skeleton_new (void)
{
  return IPC_GIT_REPOSITORY (g_object_new (IPC_TYPE_GIT_REPOSITORY_SKELETON, NULL));
}

