/* gitg-ext-application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-ext-application.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg-ext.h"
#include <libgit2-glib/ggit.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_EXT_APPLICATION_REPOSITORY_CHANGED_EXTERNALLY_SIGNAL,
	GITG_EXT_APPLICATION_REPOSITORY_COMMITS_CHANGED_SIGNAL,
	GITG_EXT_APPLICATION_NUM_SIGNALS
};
static guint gitg_ext_application_signals[GITG_EXT_APPLICATION_NUM_SIGNALS] = {0};

static GType gitg_ext_application_get_type_once (void);

/**
 * Get the committer signature and verify that both its name and
 * e-mail are set. If not, the application will show an approppriate
 * error message and return null.
 */
GgitSignature*
gitg_ext_application_get_verified_committer (GitgExtApplication* self)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_verified_committer) {
		return _iface_->get_verified_committer (self);
	}
	return NULL;
}

/**
 * Set the current application main activity.
 *
 * @param id the id of the activity {@link UIElement.id}.
 *
 * @return the created new main activity, or ``null`` if no activity with the
 *         given id exists.
 */
GitgExtActivity*
gitg_ext_application_get_activity_by_id (GitgExtApplication* self,
                                         const gchar* id)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_activity_by_id) {
		return _iface_->get_activity_by_id (self, id);
	}
	return NULL;
}

GitgExtActivity*
gitg_ext_application_set_activity_by_id (GitgExtApplication* self,
                                         const gchar* id)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->set_activity_by_id) {
		return _iface_->set_activity_by_id (self, id);
	}
	return NULL;
}

void
gitg_ext_application_user_query (GitgExtApplication* self,
                                 GitgExtUserQuery* query)
{
	GitgExtApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->user_query) {
		_iface_->user_query (self, query);
	}
}

void
gitg_ext_application_user_query_async (GitgExtApplication* self,
                                       GitgExtUserQuery* query,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	GitgExtApplicationIface* _iface_;
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->user_query_async) {
		_iface_->user_query_async (self, query, _callback_, _user_data_);
	}
}

GtkResponseType
gitg_ext_application_user_query_finish (GitgExtApplication* self,
                                        GAsyncResult* _res_)
{
	GitgExtApplicationIface* _iface_;
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->user_query_finish) {
		return _iface_->user_query_finish (self, _res_);
	}
	return 0;
}

void
gitg_ext_application_show_infobar (GitgExtApplication* self,
                                   const gchar* primary_msg,
                                   const gchar* secondary_msg,
                                   GtkMessageType type)
{
	GitgExtApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->show_infobar) {
		_iface_->show_infobar (self, primary_msg, secondary_msg, type);
	}
}

GitgExtApplication*
gitg_ext_application_open_new (GitgExtApplication* self,
                               GgitRepository* repository,
                               const gchar* hint)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->open_new) {
		return _iface_->open_new (self, repository, hint);
	}
	return NULL;
}

void
gitg_ext_application_open_repository (GitgExtApplication* self,
                                      GFile* path)
{
	GitgExtApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->open_repository) {
		_iface_->open_repository (self, path);
	}
}

GitgRepository*
gitg_ext_application_get_repository (GitgExtApplication* self)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_repository) {
		return _iface_->get_repository (self);
	}
	return NULL;
}

void
gitg_ext_application_set_repository (GitgExtApplication* self,
                                     GitgRepository* value)
{
	GitgExtApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->set_repository) {
		_iface_->set_repository (self, value);
	}
}

GitgExtMessageBus*
gitg_ext_application_get_message_bus (GitgExtApplication* self)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_message_bus) {
		return _iface_->get_message_bus (self);
	}
	return NULL;
}

GitgExtActivity*
gitg_ext_application_get_current_activity (GitgExtApplication* self)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_current_activity) {
		return _iface_->get_current_activity (self);
	}
	return NULL;
}

GeeMap*
gitg_ext_application_get_environment (GitgExtApplication* self)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_environment) {
		return _iface_->get_environment (self);
	}
	return NULL;
}

GitgExtNotifications*
gitg_ext_application_get_notifications (GitgExtApplication* self)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_notifications) {
		return _iface_->get_notifications (self);
	}
	return NULL;
}

gboolean
gitg_ext_application_get_busy (GitgExtApplication* self)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_busy) {
		return _iface_->get_busy (self);
	}
	return FALSE;
}

void
gitg_ext_application_set_busy (GitgExtApplication* self,
                               gboolean value)
{
	GitgExtApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->set_busy) {
		_iface_->set_busy (self, value);
	}
}

GitgExtRemoteLookup*
gitg_ext_application_get_remote_lookup (GitgExtApplication* self)
{
	GitgExtApplicationIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_EXT_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_remote_lookup) {
		return _iface_->get_remote_lookup (self);
	}
	return NULL;
}

static void
gitg_ext_application_default_init (GitgExtApplicationIface * iface,
                                   gpointer iface_data)
{
	/**
	 * The currently open repository.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * An application wide message bus over which plugins can communicate.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("message-bus", "message-bus", "message-bus", GITG_EXT_TYPE_MESSAGE_BUS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The current application main activity.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("current-activity", "current-activity", "current-activity", GITG_EXT_TYPE_ACTIVITY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The environment with which the application was opened.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("environment", "environment", "environment", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Get the notifications manager for the application.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("notifications", "notifications", "notifications", GITG_EXT_TYPE_NOTIFICATIONS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_boolean ("busy", "busy", "busy", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_object ("remote-lookup", "remote-lookup", "remote-lookup", GITG_EXT_TYPE_REMOTE_LOOKUP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gitg_ext_application_signals[GITG_EXT_APPLICATION_REPOSITORY_CHANGED_EXTERNALLY_SIGNAL] = g_signal_new ("repository-changed-externally", GITG_EXT_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__FLAGS, G_TYPE_NONE, 1, GITG_EXT_TYPE_EXTERNAL_CHANGE_HINT);
	gitg_ext_application_signals[GITG_EXT_APPLICATION_REPOSITORY_COMMITS_CHANGED_SIGNAL] = g_signal_new ("repository-commits-changed", GITG_EXT_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

/**
 * Application is an interface to access the main gitg application.
 *
 * The application interface is provided to plugins to access the main gitg
 * application instance. It contains properties to access the currently open
 * repository as well as methods to open or create repositories.
 *
 */
 G_GNUC_NO_INLINE static GType
gitg_ext_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgExtApplicationIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ext_application_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gitg_ext_application_type_id;
	gitg_ext_application_type_id = g_type_register_static (G_TYPE_INTERFACE, "GitgExtApplication", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gitg_ext_application_type_id, G_TYPE_OBJECT);
	return gitg_ext_application_type_id;
}

GType
gitg_ext_application_get_type (void)
{
	static gsize gitg_ext_application_type_id__once = 0;
	if (g_once_init_enter (&gitg_ext_application_type_id__once)) {
		GType gitg_ext_application_type_id;
		gitg_ext_application_type_id = gitg_ext_application_get_type_once ();
		g_once_init_leave (&gitg_ext_application_type_id__once, gitg_ext_application_type_id);
	}
	return gitg_ext_application_type_id__once;
}

 G_GNUC_NO_INLINE static GType
gitg_ext_external_change_hint_get_type_once (void)
{
	static const GFlagsValue values[] = {{GITG_EXT_EXTERNAL_CHANGE_HINT_NONE, "GITG_EXT_EXTERNAL_CHANGE_HINT_NONE", "none"}, {GITG_EXT_EXTERNAL_CHANGE_HINT_REFS, "GITG_EXT_EXTERNAL_CHANGE_HINT_REFS", "refs"}, {GITG_EXT_EXTERNAL_CHANGE_HINT_INDEX, "GITG_EXT_EXTERNAL_CHANGE_HINT_INDEX", "index"}, {0, NULL, NULL}};
	GType gitg_ext_external_change_hint_type_id;
	gitg_ext_external_change_hint_type_id = g_flags_register_static ("GitgExtExternalChangeHint", values);
	return gitg_ext_external_change_hint_type_id;
}

GType
gitg_ext_external_change_hint_get_type (void)
{
	static gsize gitg_ext_external_change_hint_type_id__once = 0;
	if (g_once_init_enter (&gitg_ext_external_change_hint_type_id__once)) {
		GType gitg_ext_external_change_hint_type_id;
		gitg_ext_external_change_hint_type_id = gitg_ext_external_change_hint_get_type_once ();
		g_once_init_leave (&gitg_ext_external_change_hint_type_id__once, gitg_ext_external_change_hint_type_id);
	}
	return gitg_ext_external_change_hint_type_id__once;
}

