/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-bnr-dp-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_bnr_dp_boot_area_to_string:
 * @val: value, e.g. %FU_BNR_DP_BOOT_AREA_HIGH
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_bnr_dp_boot_area_to_string(FuBnrDpBootArea val)
{
    if (val == FU_BNR_DP_BOOT_AREA_LOW)
        return "low";
    if (val == FU_BNR_DP_BOOT_AREA_HIGH)
        return "high";
    return NULL;
}

/**
 * fu_bnr_dp_payload_flags_to_string:
 * @val: value, e.g. %FU_BNR_DP_PAYLOAD_FLAG_CRC_ERROR
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 *
 **/
static gchar *
fu_bnr_dp_payload_flags_to_string(FuBnrDpPayloadFlags val)
{
    const gchar *data[2] = {0};
    guint idx = 0;
    if (val == FU_BNR_DP_PAYLOAD_FLAG_BOOT_AREA)
        return g_strdup("boot-area");
    if (val & FU_BNR_DP_PAYLOAD_FLAG_CRC_ERROR)
        data[idx++] = "crc-error";
    return g_strjoinv(",", (gchar **)data);
}

/**
 * fu_bnr_dp_module_number_to_string:
 * @val: value, e.g. %FU_BNR_DP_MODULE_NUMBER_DISPLAY
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_bnr_dp_module_number_to_string(FuBnrDpModuleNumber val)
{
    if (val == FU_BNR_DP_MODULE_NUMBER_RECEIVER)
        return "receiver";
    if (val == FU_BNR_DP_MODULE_NUMBER_DISPLAY)
        return "display";
    if (val == FU_BNR_DP_MODULE_NUMBER_KEY_EXPANSION)
        return "key-expansion";
    return NULL;
}

/**
 * fu_bnr_dp_opcodes_to_string:
 * @val: value, e.g. %FU_BNR_DP_OPCODES_FW_VERSION
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_bnr_dp_opcodes_to_string(FuBnrDpOpcodes val)
{
    if (val == FU_BNR_DP_OPCODES_RESET)
        return "reset";
    if (val == FU_BNR_DP_OPCODES_FW_VERSION)
        return "fw-version";
    if (val == FU_BNR_DP_OPCODES_INFO_FLAGS)
        return "info-flags";
    if (val == FU_BNR_DP_OPCODES_FLASH_SAVE_HEADER_INFO)
        return "flash-save-header-info";
    if (val == FU_BNR_DP_OPCODES_FACTORY_DATA)
        return "factory-data";
    if (val == FU_BNR_DP_OPCODES_FLASH_USER)
        return "flash-user";
    if (val == FU_BNR_DP_OPCODES_FLASH_SERVICE)
        return "flash-service";
    return NULL;
}

/**
 * fu_bnr_dp_aux_error_to_string:
 * @val: value, e.g. %FU_BNR_DP_AUX_ERROR_UNKNOWN_COMMAND
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_bnr_dp_aux_error_to_string(FuBnrDpAuxError val)
{
    if (val == FU_BNR_DP_AUX_ERROR_IRQ_COLLISION)
        return "irq-collision";
    if (val == FU_BNR_DP_AUX_ERROR_UNKNOWN_COMMAND)
        return "unknown-command";
    if (val == FU_BNR_DP_AUX_ERROR_TIMEOUT)
        return "timeout";
    if (val == FU_BNR_DP_AUX_ERROR_BAD_PARAMETER)
        return "bad-parameter";
    if (val == FU_BNR_DP_AUX_ERROR_DEVICE_BUSY)
        return "device-busy";
    if (val == FU_BNR_DP_AUX_ERROR_DEVICE_FAILURE)
        return "device-failure";
    if (val == FU_BNR_DP_AUX_ERROR_DATA_FAILURE)
        return "data-failure";
    return NULL;
}



/**
 * fu_bnr_dp_info_flags_to_string:
 * @val: value, e.g. %FU_BNR_DP_INFO_FLAG_CRC_OK
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 *
 **/
static gchar *
fu_bnr_dp_info_flags_to_string(FuBnrDpInfoFlags val)
{
    const gchar *data[5] = {0};
    guint idx = 0;
    if (val == FU_BNR_DP_INFO_FLAG_BOOT_AREA)
        return g_strdup("boot-area");
    if (val & FU_BNR_DP_INFO_FLAG_CRC_OK)
        data[idx++] = "crc-ok";
    if (val & FU_BNR_DP_INFO_FLAG_PME_ENABLE)
        data[idx++] = "pme-enable";
    if (val & FU_BNR_DP_INFO_FLAG_ICT_ENABLE)
        data[idx++] = "ict-enable";
    if (val & FU_BNR_DP_INFO_FLAG_REC_ENABLE)
        data[idx++] = "rec-enable";
    return g_strjoinv(",", (gchar **)data);
}
/**
 * fu_struct_bnr_dp_payload_header_ref: (skip):
 **/
FuStructBnrDpPayloadHeader *
fu_struct_bnr_dp_payload_header_ref(FuStructBnrDpPayloadHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bnr_dp_payload_header_unref: (skip):
 **/
void
fu_struct_bnr_dp_payload_header_unref(FuStructBnrDpPayloadHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBnrDpPayloadHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bnr_dp_payload_header_new_internal: (skip):
 **/
static FuStructBnrDpPayloadHeader *
fu_struct_bnr_dp_payload_header_new_internal(void)
{
    FuStructBnrDpPayloadHeader *st = g_new0(FuStructBnrDpPayloadHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bnr_dp_payload_header_get_id: (skip):
 **/
static gchar *
fu_struct_bnr_dp_payload_header_get_id(const FuStructBnrDpPayloadHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 4, NULL);
}
/**
 * fu_struct_bnr_dp_payload_header_get_version: (skip):
 **/
gchar *
fu_struct_bnr_dp_payload_header_get_version(const FuStructBnrDpPayloadHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 4, 4, NULL);
}
/**
 * fu_struct_bnr_dp_payload_header_get_counter: (skip):
 **/
guint32
fu_struct_bnr_dp_payload_header_get_counter(const FuStructBnrDpPayloadHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_payload_header_get_flags: (skip):
 **/
FuBnrDpPayloadFlags
fu_struct_bnr_dp_payload_header_get_flags(const FuStructBnrDpPayloadHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_payload_header_get_crc: (skip):
 **/
guint16
fu_struct_bnr_dp_payload_header_get_crc(const FuStructBnrDpPayloadHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 14, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_bnr_dp_payload_header_set_version: (skip):
 **/
gboolean
fu_struct_bnr_dp_payload_header_set_version(FuStructBnrDpPayloadHeader *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 4, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructBnrDpPayloadHeader.version (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 4, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_bnr_dp_payload_header_set_counter: (skip):
 **/
void
fu_struct_bnr_dp_payload_header_set_counter(FuStructBnrDpPayloadHeader *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_payload_header_set_flags: (skip):
 **/
void
fu_struct_bnr_dp_payload_header_set_flags(FuStructBnrDpPayloadHeader *st, FuBnrDpPayloadFlags value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_payload_header_set_crc: (skip):
 **/
void
fu_struct_bnr_dp_payload_header_set_crc(FuStructBnrDpPayloadHeader *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 14, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_bnr_dp_payload_header_to_string: (skip):
 **/
static gchar *
fu_struct_bnr_dp_payload_header_to_string(const FuStructBnrDpPayloadHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBnrDpPayloadHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_bnr_dp_payload_header_get_version(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  version: %s\n", tmp);
    }
    g_string_append_printf(str, "  counter: 0x%x\n",
                           (guint) fu_struct_bnr_dp_payload_header_get_counter(st));
    {
        g_autofree gchar *tmp = fu_bnr_dp_payload_flags_to_string(fu_struct_bnr_dp_payload_header_get_flags(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  flags: 0x%x [%s]\n", (guint) fu_struct_bnr_dp_payload_header_get_flags(st), tmp);
        } else {
            g_string_append_printf(str, "  flags: 0x%x\n", (guint) fu_struct_bnr_dp_payload_header_get_flags(st));
        }
    }
    g_string_append_printf(str, "  crc: 0x%x\n",
                           (guint) fu_struct_bnr_dp_payload_header_get_crc(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_bnr_dp_payload_header_to_bytes: (skip):
 **/
GBytes *
fu_struct_bnr_dp_payload_header_to_bytes(const FuStructBnrDpPayloadHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return g_bytes_new(st->buf->data, st->buf->len);
}
static gboolean
fu_struct_bnr_dp_payload_header_validate_internal(FuStructBnrDpPayloadHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "DP0R", 4) != 0) {
        g_autofree gchar *str = fu_struct_bnr_dp_payload_header_get_id(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructBnrDpPayloadHeader.id was not valid, "
                    "expected 'DP0R' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_bnr_dp_payload_header_parse_internal(FuStructBnrDpPayloadHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_bnr_dp_payload_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_bnr_dp_payload_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_bnr_dp_payload_header_parse: (skip):
 **/
FuStructBnrDpPayloadHeader *
fu_struct_bnr_dp_payload_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructBnrDpPayloadHeader) st = fu_struct_bnr_dp_payload_header_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructBnrDpPayloadHeader: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 16);
    if (!fu_struct_bnr_dp_payload_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_bnr_dp_aux_command_ref: (skip):
 **/
FuStructBnrDpAuxCommand *
fu_struct_bnr_dp_aux_command_ref(FuStructBnrDpAuxCommand *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bnr_dp_aux_command_unref: (skip):
 **/
void
fu_struct_bnr_dp_aux_command_unref(FuStructBnrDpAuxCommand *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBnrDpAuxCommand refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bnr_dp_aux_command_new_internal: (skip):
 **/
static FuStructBnrDpAuxCommand *
fu_struct_bnr_dp_aux_command_new_internal(void)
{
    FuStructBnrDpAuxCommand *st = g_new0(FuStructBnrDpAuxCommand, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_bnr_dp_aux_command_set_module_number: (skip):
 **/
void
fu_struct_bnr_dp_aux_command_set_module_number(FuStructBnrDpAuxCommand *st, FuBnrDpModuleNumber value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_bnr_dp_aux_command_set_opcode: (skip):
 **/
void
fu_struct_bnr_dp_aux_command_set_opcode(FuStructBnrDpAuxCommand *st, FuBnrDpOpcodes value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_bnr_dp_aux_command_new: (skip):
 **/
FuStructBnrDpAuxCommand *
fu_struct_bnr_dp_aux_command_new(void)
{
    FuStructBnrDpAuxCommand *st = fu_struct_bnr_dp_aux_command_new_internal();
    st->buf = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st->buf, 2, 0x0);
    return st;
}
/**
 * fu_struct_bnr_dp_aux_request_ref: (skip):
 **/
FuStructBnrDpAuxRequest *
fu_struct_bnr_dp_aux_request_ref(FuStructBnrDpAuxRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bnr_dp_aux_request_unref: (skip):
 **/
void
fu_struct_bnr_dp_aux_request_unref(FuStructBnrDpAuxRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBnrDpAuxRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bnr_dp_aux_request_new_internal: (skip):
 **/
static FuStructBnrDpAuxRequest *
fu_struct_bnr_dp_aux_request_new_internal(void)
{
    FuStructBnrDpAuxRequest *st = g_new0(FuStructBnrDpAuxRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_bnr_dp_aux_request_set_data_len: (skip):
 **/
void
fu_struct_bnr_dp_aux_request_set_data_len(FuStructBnrDpAuxRequest *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_aux_request_set_offset: (skip):
 **/
void
fu_struct_bnr_dp_aux_request_set_offset(FuStructBnrDpAuxRequest *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_aux_request_set_command: (skip):
 **/
gboolean
fu_struct_bnr_dp_aux_request_set_command(FuStructBnrDpAuxRequest *st, const FuStructBnrDpAuxCommand *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_BNR_DP_AUX_COMMAND_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructBnrDpAuxCommand' (0x%x bytes) does not fit in "
                    "FuStructBnrDpAuxRequest.command (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_BNR_DP_AUX_COMMAND_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_BNR_DP_AUX_REQUEST_OFFSET_COMMAND, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_bnr_dp_aux_request_new: (skip):
 **/
FuStructBnrDpAuxRequest *
fu_struct_bnr_dp_aux_request_new(void)
{
    FuStructBnrDpAuxRequest *st = fu_struct_bnr_dp_aux_request_new_internal();
    st->buf = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st->buf, 6, 0x0);
    {
        g_autoptr(FuStructBnrDpAuxCommand) st_donor = fu_struct_bnr_dp_aux_command_new();
        memcpy(st->buf->data + 0x4, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    return st;
}
/**
 * fu_struct_bnr_dp_aux_tx_header_ref: (skip):
 **/
FuStructBnrDpAuxTxHeader *
fu_struct_bnr_dp_aux_tx_header_ref(FuStructBnrDpAuxTxHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bnr_dp_aux_tx_header_unref: (skip):
 **/
void
fu_struct_bnr_dp_aux_tx_header_unref(FuStructBnrDpAuxTxHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBnrDpAuxTxHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bnr_dp_aux_tx_header_new_internal: (skip):
 **/
static FuStructBnrDpAuxTxHeader *
fu_struct_bnr_dp_aux_tx_header_new_internal(void)
{
    FuStructBnrDpAuxTxHeader *st = g_new0(FuStructBnrDpAuxTxHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_bnr_dp_aux_tx_header_set_request: (skip):
 **/
gboolean
fu_struct_bnr_dp_aux_tx_header_set_request(FuStructBnrDpAuxTxHeader *st, const FuStructBnrDpAuxRequest *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_BNR_DP_AUX_REQUEST_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructBnrDpAuxRequest' (0x%x bytes) does not fit in "
                    "FuStructBnrDpAuxTxHeader.request (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_BNR_DP_AUX_REQUEST_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_BNR_DP_AUX_TX_HEADER_OFFSET_REQUEST, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_bnr_dp_aux_tx_header_set_checksum: (skip):
 **/
void
fu_struct_bnr_dp_aux_tx_header_set_checksum(FuStructBnrDpAuxTxHeader *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_bnr_dp_aux_tx_header_new: (skip):
 **/
FuStructBnrDpAuxTxHeader *
fu_struct_bnr_dp_aux_tx_header_new(void)
{
    FuStructBnrDpAuxTxHeader *st = fu_struct_bnr_dp_aux_tx_header_new_internal();
    st->buf = g_byte_array_sized_new(7);
    fu_byte_array_set_size(st->buf, 7, 0x0);
    {
        g_autoptr(FuStructBnrDpAuxRequest) st_donor = fu_struct_bnr_dp_aux_request_new();
        memcpy(st->buf->data + 0x0, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    return st;
}
/**
 * fu_struct_bnr_dp_aux_status_ref: (skip):
 **/
FuStructBnrDpAuxStatus *
fu_struct_bnr_dp_aux_status_ref(FuStructBnrDpAuxStatus *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bnr_dp_aux_status_unref: (skip):
 **/
void
fu_struct_bnr_dp_aux_status_unref(FuStructBnrDpAuxStatus *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBnrDpAuxStatus refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bnr_dp_aux_status_new_internal: (skip):
 **/
static FuStructBnrDpAuxStatus *
fu_struct_bnr_dp_aux_status_new_internal(void)
{
    FuStructBnrDpAuxStatus *st = g_new0(FuStructBnrDpAuxStatus, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bnr_dp_aux_status_get_error: (skip):
 **/
guint8
fu_struct_bnr_dp_aux_status_get_error(const FuStructBnrDpAuxStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}

/* setters */
/**
 * fu_struct_bnr_dp_aux_status_to_string: (skip):
 **/
static gchar *
fu_struct_bnr_dp_aux_status_to_string(const FuStructBnrDpAuxStatus *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBnrDpAuxStatus:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  error: 0x%x\n",
                           (guint) fu_struct_bnr_dp_aux_status_get_error(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_bnr_dp_aux_status_validate_internal(FuStructBnrDpAuxStatus *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_bnr_dp_aux_status_parse_internal(FuStructBnrDpAuxStatus *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_bnr_dp_aux_status_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_bnr_dp_aux_status_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_bnr_dp_aux_status_parse: (skip):
 **/
FuStructBnrDpAuxStatus *
fu_struct_bnr_dp_aux_status_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructBnrDpAuxStatus) st = fu_struct_bnr_dp_aux_status_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructBnrDpAuxStatus: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_bnr_dp_aux_status_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_bnr_dp_aux_response_ref: (skip):
 **/
FuStructBnrDpAuxResponse *
fu_struct_bnr_dp_aux_response_ref(FuStructBnrDpAuxResponse *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bnr_dp_aux_response_unref: (skip):
 **/
void
fu_struct_bnr_dp_aux_response_unref(FuStructBnrDpAuxResponse *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBnrDpAuxResponse refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bnr_dp_aux_response_new_internal: (skip):
 **/
static FuStructBnrDpAuxResponse *
fu_struct_bnr_dp_aux_response_new_internal(void)
{
    FuStructBnrDpAuxResponse *st = g_new0(FuStructBnrDpAuxResponse, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bnr_dp_aux_response_get_data_len: (skip):
 **/
guint16
fu_struct_bnr_dp_aux_response_get_data_len(const FuStructBnrDpAuxResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_bnr_dp_aux_response_to_string: (skip):
 **/
static gchar *
fu_struct_bnr_dp_aux_response_to_string(const FuStructBnrDpAuxResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBnrDpAuxResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_bnr_dp_aux_response_get_data_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_bnr_dp_aux_response_validate_internal(FuStructBnrDpAuxResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_bnr_dp_aux_rx_header_ref: (skip):
 **/
FuStructBnrDpAuxRxHeader *
fu_struct_bnr_dp_aux_rx_header_ref(FuStructBnrDpAuxRxHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bnr_dp_aux_rx_header_unref: (skip):
 **/
void
fu_struct_bnr_dp_aux_rx_header_unref(FuStructBnrDpAuxRxHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBnrDpAuxRxHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bnr_dp_aux_rx_header_new_internal: (skip):
 **/
static FuStructBnrDpAuxRxHeader *
fu_struct_bnr_dp_aux_rx_header_new_internal(void)
{
    FuStructBnrDpAuxRxHeader *st = g_new0(FuStructBnrDpAuxRxHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bnr_dp_aux_rx_header_get_response: (skip):
 **/
FuStructBnrDpAuxResponse *
fu_struct_bnr_dp_aux_rx_header_get_response(const FuStructBnrDpAuxRxHeader *st)
{
    g_autoptr(FuStructBnrDpAuxResponse) st_tmp = fu_struct_bnr_dp_aux_response_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_BNR_DP_AUX_RX_HEADER_OFFSET_RESPONSE, 6);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_bnr_dp_aux_rx_header_get_checksum: (skip):
 **/
guint8
fu_struct_bnr_dp_aux_rx_header_get_checksum(const FuStructBnrDpAuxRxHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}

/* setters */
/**
 * fu_struct_bnr_dp_aux_rx_header_to_string: (skip):
 **/
static gchar *
fu_struct_bnr_dp_aux_rx_header_to_string(const FuStructBnrDpAuxRxHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBnrDpAuxRxHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autoptr(FuStructBnrDpAuxResponse) st_tmp = fu_struct_bnr_dp_aux_rx_header_get_response(st);
        g_autofree gchar *tmp = fu_struct_bnr_dp_aux_response_to_string(st_tmp);
        g_string_append_printf(str, "  response: %s\n", tmp);
    }
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_bnr_dp_aux_rx_header_get_checksum(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_bnr_dp_aux_rx_header_validate_internal(FuStructBnrDpAuxRxHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x0,
            .len = 6,
        };
        FuStructBnrDpAuxResponse st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_bnr_dp_aux_response_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_bnr_dp_aux_rx_header_parse_internal(FuStructBnrDpAuxRxHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_bnr_dp_aux_rx_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_bnr_dp_aux_rx_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_bnr_dp_aux_rx_header_parse: (skip):
 **/
FuStructBnrDpAuxRxHeader *
fu_struct_bnr_dp_aux_rx_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructBnrDpAuxRxHeader) st = fu_struct_bnr_dp_aux_rx_header_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 7, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructBnrDpAuxRxHeader: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 7);
    if (!fu_struct_bnr_dp_aux_rx_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_bnr_dp_info_flags_ref: (skip):
 **/
FuStructBnrDpInfoFlags *
fu_struct_bnr_dp_info_flags_ref(FuStructBnrDpInfoFlags *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bnr_dp_info_flags_unref: (skip):
 **/
void
fu_struct_bnr_dp_info_flags_unref(FuStructBnrDpInfoFlags *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBnrDpInfoFlags refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bnr_dp_info_flags_new_internal: (skip):
 **/
static FuStructBnrDpInfoFlags *
fu_struct_bnr_dp_info_flags_new_internal(void)
{
    FuStructBnrDpInfoFlags *st = g_new0(FuStructBnrDpInfoFlags, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bnr_dp_info_flags_get_inner: (skip):
 **/
FuBnrDpInfoFlags
fu_struct_bnr_dp_info_flags_get_inner(const FuStructBnrDpInfoFlags *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_bnr_dp_info_flags_to_string: (skip):
 **/
static gchar *
fu_struct_bnr_dp_info_flags_to_string(const FuStructBnrDpInfoFlags *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBnrDpInfoFlags:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_bnr_dp_info_flags_to_string(fu_struct_bnr_dp_info_flags_get_inner(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  inner: 0x%x [%s]\n", (guint) fu_struct_bnr_dp_info_flags_get_inner(st), tmp);
        } else {
            g_string_append_printf(str, "  inner: 0x%x\n", (guint) fu_struct_bnr_dp_info_flags_get_inner(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_bnr_dp_info_flags_validate_internal(FuStructBnrDpInfoFlags *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_bnr_dp_info_flags_parse_internal(FuStructBnrDpInfoFlags *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_bnr_dp_info_flags_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_bnr_dp_info_flags_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_bnr_dp_info_flags_parse: (skip):
 **/
FuStructBnrDpInfoFlags *
fu_struct_bnr_dp_info_flags_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructBnrDpInfoFlags) st = fu_struct_bnr_dp_info_flags_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructBnrDpInfoFlags: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_struct_bnr_dp_info_flags_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_bnr_dp_factory_data_ref: (skip):
 **/
FuStructBnrDpFactoryData *
fu_struct_bnr_dp_factory_data_ref(FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_bnr_dp_factory_data_unref: (skip):
 **/
void
fu_struct_bnr_dp_factory_data_unref(FuStructBnrDpFactoryData *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBnrDpFactoryData refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_bnr_dp_factory_data_new_internal: (skip):
 **/
static FuStructBnrDpFactoryData *
fu_struct_bnr_dp_factory_data_new_internal(void)
{
    FuStructBnrDpFactoryData *st = g_new0(FuStructBnrDpFactoryData, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_bnr_dp_factory_data_get_id: (skip):
 **/
static gchar *
fu_struct_bnr_dp_factory_data_get_id(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 4, NULL);
}
/**
 * fu_struct_bnr_dp_factory_data_get_version_struct: (skip):
 **/
guint8
fu_struct_bnr_dp_factory_data_get_version_struct(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_bnr_dp_factory_data_get_version_data: (skip):
 **/
guint8
fu_struct_bnr_dp_factory_data_get_version_data(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_bnr_dp_factory_data_get_data_len: (skip):
 **/
guint16
fu_struct_bnr_dp_factory_data_get_data_len(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_factory_data_get_header_type: (skip):
 **/
guint16
fu_struct_bnr_dp_factory_data_get_header_type(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_factory_data_get_product_num: (skip):
 **/
guint32
fu_struct_bnr_dp_factory_data_get_product_num(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_factory_data_get_compat_id: (skip):
 **/
guint16
fu_struct_bnr_dp_factory_data_get_compat_id(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 14, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_factory_data_get_vendor_id: (skip):
 **/
guint32
fu_struct_bnr_dp_factory_data_get_vendor_id(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_factory_data_get_hw_rev: (skip):
 **/
gchar *
fu_struct_bnr_dp_factory_data_get_hw_rev(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 20, 5, NULL);
}
/**
 * fu_struct_bnr_dp_factory_data_get_serial: (skip):
 **/
gchar *
fu_struct_bnr_dp_factory_data_get_serial(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 25, 12, NULL);
}
/**
 * fu_struct_bnr_dp_factory_data_get_identification: (skip):
 **/
gchar *
fu_struct_bnr_dp_factory_data_get_identification(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 37, 41, NULL);
}
/**
 * fu_struct_bnr_dp_factory_data_get_hw_num: (skip):
 **/
gchar *
fu_struct_bnr_dp_factory_data_get_hw_num(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 78, 3, NULL);
}
/**
 * fu_struct_bnr_dp_factory_data_get_parent_product_num: (skip):
 **/
guint32
fu_struct_bnr_dp_factory_data_get_parent_product_num(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 81, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_bnr_dp_factory_data_get_parent_compat_id: (skip):
 **/
guint16
fu_struct_bnr_dp_factory_data_get_parent_compat_id(const FuStructBnrDpFactoryData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 85, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_bnr_dp_factory_data_to_string: (skip):
 **/
static gchar *
fu_struct_bnr_dp_factory_data_to_string(const FuStructBnrDpFactoryData *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBnrDpFactoryData:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version_struct: 0x%x\n",
                           (guint) fu_struct_bnr_dp_factory_data_get_version_struct(st));
    g_string_append_printf(str, "  version_data: 0x%x\n",
                           (guint) fu_struct_bnr_dp_factory_data_get_version_data(st));
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_bnr_dp_factory_data_get_data_len(st));
    g_string_append_printf(str, "  header_type: 0x%x\n",
                           (guint) fu_struct_bnr_dp_factory_data_get_header_type(st));
    g_string_append_printf(str, "  product_num: 0x%x\n",
                           (guint) fu_struct_bnr_dp_factory_data_get_product_num(st));
    g_string_append_printf(str, "  compat_id: 0x%x\n",
                           (guint) fu_struct_bnr_dp_factory_data_get_compat_id(st));
    g_string_append_printf(str, "  vendor_id: 0x%x\n",
                           (guint) fu_struct_bnr_dp_factory_data_get_vendor_id(st));
    {
        g_autofree gchar *tmp = fu_struct_bnr_dp_factory_data_get_hw_rev(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hw_rev: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_bnr_dp_factory_data_get_serial(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  serial: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_bnr_dp_factory_data_get_identification(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  identification: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_bnr_dp_factory_data_get_hw_num(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hw_num: %s\n", tmp);
    }
    g_string_append_printf(str, "  parent_product_num: 0x%x\n",
                           (guint) fu_struct_bnr_dp_factory_data_get_parent_product_num(st));
    g_string_append_printf(str, "  parent_compat_id: 0x%x\n",
                           (guint) fu_struct_bnr_dp_factory_data_get_parent_compat_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_bnr_dp_factory_data_validate_internal(FuStructBnrDpFactoryData *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "FACT", 4) != 0) {
        g_autofree gchar *str = fu_struct_bnr_dp_factory_data_get_id(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructBnrDpFactoryData.id was not valid, "
                    "expected 'FACT' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_bnr_dp_factory_data_parse_internal(FuStructBnrDpFactoryData *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_bnr_dp_factory_data_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_bnr_dp_factory_data_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_bnr_dp_factory_data_parse: (skip):
 **/
FuStructBnrDpFactoryData *
fu_struct_bnr_dp_factory_data_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructBnrDpFactoryData) st = fu_struct_bnr_dp_factory_data_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 87, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructBnrDpFactoryData: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 87);
    if (!fu_struct_bnr_dp_factory_data_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
