/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-asus-hid-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"



/**
 * fu_struct_asus_man_command_ref: (skip):
 **/
FuStructAsusManCommand *
fu_struct_asus_man_command_ref(FuStructAsusManCommand *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_asus_man_command_unref: (skip):
 **/
void
fu_struct_asus_man_command_unref(FuStructAsusManCommand *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAsusManCommand refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_asus_man_command_new_internal: (skip):
 **/
static FuStructAsusManCommand *
fu_struct_asus_man_command_new_internal(void)
{
    FuStructAsusManCommand *st = g_new0(FuStructAsusManCommand, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_asus_man_command_set_report_id: (skip):
 **/
static void
fu_struct_asus_man_command_set_report_id(FuStructAsusManCommand *st, FuAsusHidReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_asus_man_command_set_data: (skip):
 **/
static gboolean
fu_struct_asus_man_command_set_data(FuStructAsusManCommand *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 1, 0x0, 14);
        return TRUE;
    }
    len = strlen(value);
    if (len > 14) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructAsusManCommand.data (0x%x bytes)",
                    value, (guint) len, (guint) 14);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 1, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_asus_man_command_set_terminator: (skip):
 **/
static void
fu_struct_asus_man_command_set_terminator(FuStructAsusManCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[15] = value;
}
/**
 * fu_struct_asus_man_command_new: (skip):
 **/
FuStructAsusManCommand *
fu_struct_asus_man_command_new(void)
{
    FuStructAsusManCommand *st = fu_struct_asus_man_command_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    fu_struct_asus_man_command_set_report_id(st, FU_ASUS_HID_REPORT_ID_INFO);
    fu_struct_asus_man_command_set_data(st, "ASUSTech.Inc.", NULL);
    fu_struct_asus_man_command_set_terminator(st, 0);
    return st;
}
/**
 * fu_struct_asus_man_result_ref: (skip):
 **/
FuStructAsusManResult *
fu_struct_asus_man_result_ref(FuStructAsusManResult *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_asus_man_result_unref: (skip):
 **/
void
fu_struct_asus_man_result_unref(FuStructAsusManResult *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAsusManResult refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_asus_man_result_new_internal: (skip):
 **/
static FuStructAsusManResult *
fu_struct_asus_man_result_new_internal(void)
{
    FuStructAsusManResult *st = g_new0(FuStructAsusManResult, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_asus_man_result_get_data: (skip):
 **/
gchar *
fu_struct_asus_man_result_get_data(const FuStructAsusManResult *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 1, 31, NULL);
}

/* setters */
/**
 * fu_struct_asus_man_result_set_report_id: (skip):
 **/
static void
fu_struct_asus_man_result_set_report_id(FuStructAsusManResult *st, FuAsusHidReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_asus_man_result_set_data: (skip):
 **/
gboolean
fu_struct_asus_man_result_set_data(FuStructAsusManResult *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 1, 0x0, 31);
        return TRUE;
    }
    len = strlen(value);
    if (len > 31) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructAsusManResult.data (0x%x bytes)",
                    value, (guint) len, (guint) 31);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 1, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_asus_man_result_new: (skip):
 **/
FuStructAsusManResult *
fu_struct_asus_man_result_new(void)
{
    FuStructAsusManResult *st = fu_struct_asus_man_result_new_internal();
    st->buf = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st->buf, 32, 0x0);
    fu_struct_asus_man_result_set_report_id(st, FU_ASUS_HID_REPORT_ID_INFO);
    return st;
}
/**
 * fu_struct_asus_hid_command_ref: (skip):
 **/
FuStructAsusHidCommand *
fu_struct_asus_hid_command_ref(FuStructAsusHidCommand *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_asus_hid_command_unref: (skip):
 **/
void
fu_struct_asus_hid_command_unref(FuStructAsusHidCommand *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAsusHidCommand refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_asus_hid_command_new_internal: (skip):
 **/
static FuStructAsusHidCommand *
fu_struct_asus_hid_command_new_internal(void)
{
    FuStructAsusHidCommand *st = g_new0(FuStructAsusHidCommand, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_asus_hid_command_set_report_id: (skip):
 **/
static void
fu_struct_asus_hid_command_set_report_id(FuStructAsusHidCommand *st, FuAsusHidReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_asus_hid_command_set_cmd: (skip):
 **/
void
fu_struct_asus_hid_command_set_cmd(FuStructAsusHidCommand *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 1, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_asus_hid_command_set_length: (skip):
 **/
void
fu_struct_asus_hid_command_set_length(FuStructAsusHidCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_asus_hid_command_new: (skip):
 **/
FuStructAsusHidCommand *
fu_struct_asus_hid_command_new(void)
{
    FuStructAsusHidCommand *st = fu_struct_asus_hid_command_new_internal();
    st->buf = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st->buf, 6, 0x0);
    fu_struct_asus_hid_command_set_report_id(st, FU_ASUS_HID_REPORT_ID_INFO);
    return st;
}
/**
 * fu_struct_asus_hid_result_ref: (skip):
 **/
FuStructAsusHidResult *
fu_struct_asus_hid_result_ref(FuStructAsusHidResult *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_asus_hid_result_unref: (skip):
 **/
void
fu_struct_asus_hid_result_unref(FuStructAsusHidResult *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAsusHidResult refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_asus_hid_result_new_internal: (skip):
 **/
static FuStructAsusHidResult *
fu_struct_asus_hid_result_new_internal(void)
{
    FuStructAsusHidResult *st = g_new0(FuStructAsusHidResult, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_asus_hid_result_set_report_id: (skip):
 **/
static void
fu_struct_asus_hid_result_set_report_id(FuStructAsusHidResult *st, FuAsusHidReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_asus_hid_result_set_data: (skip):
 **/
gboolean
fu_struct_asus_hid_result_set_data(FuStructAsusHidResult *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 1, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_asus_hid_result_new: (skip):
 **/
FuStructAsusHidResult *
fu_struct_asus_hid_result_new(void)
{
    FuStructAsusHidResult *st = fu_struct_asus_hid_result_new_internal();
    st->buf = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st->buf, 32, 0x0);
    fu_struct_asus_hid_result_set_report_id(st, FU_ASUS_HID_REPORT_ID_INFO);
    return st;
}
/**
 * fu_struct_asus_hid_desc_ref: (skip):
 **/
FuStructAsusHidDesc *
fu_struct_asus_hid_desc_ref(FuStructAsusHidDesc *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_asus_hid_desc_unref: (skip):
 **/
void
fu_struct_asus_hid_desc_unref(FuStructAsusHidDesc *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAsusHidDesc refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_asus_hid_desc_new_internal: (skip):
 **/
static FuStructAsusHidDesc *
fu_struct_asus_hid_desc_new_internal(void)
{
    FuStructAsusHidDesc *st = g_new0(FuStructAsusHidDesc, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_asus_hid_desc_get_fga: (skip):
 **/
gchar *
fu_struct_asus_hid_desc_get_fga(const FuStructAsusHidDesc *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 8, NULL);
}
/**
 * fu_struct_asus_hid_desc_get_product: (skip):
 **/
gchar *
fu_struct_asus_hid_desc_get_product(const FuStructAsusHidDesc *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 9, 6, NULL);
}
/**
 * fu_struct_asus_hid_desc_get_version: (skip):
 **/
gchar *
fu_struct_asus_hid_desc_get_version(const FuStructAsusHidDesc *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 16, 8, NULL);
}

/* setters */
/**
 * fu_struct_asus_hid_desc_new: (skip):
 **/
static FuStructAsusHidDesc *
fu_struct_asus_hid_desc_new(void)
{
    FuStructAsusHidDesc *st = fu_struct_asus_hid_desc_new_internal();
    st->buf = g_byte_array_sized_new(25);
    fu_byte_array_set_size(st->buf, 25, 0x0);
    return st;
}
/**
 * fu_struct_asus_hid_desc_to_string: (skip):
 **/
static gchar *
fu_struct_asus_hid_desc_to_string(const FuStructAsusHidDesc *st)
{
    g_autoptr(GString) str = g_string_new("FuStructAsusHidDesc:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_asus_hid_desc_get_fga(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  fga: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_asus_hid_desc_get_product(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  product: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_asus_hid_desc_get_version(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  version: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_asus_hid_desc_validate_internal(FuStructAsusHidDesc *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_asus_hid_desc_parse_internal(FuStructAsusHidDesc *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_asus_hid_desc_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_asus_hid_desc_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_asus_hid_desc_parse_stream: (skip):
 **/
FuStructAsusHidDesc *
fu_struct_asus_hid_desc_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructAsusHidDesc) st = fu_struct_asus_hid_desc_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 25, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructAsusHidDesc failed read of 0x%x: ", (guint) 25);
        return NULL;
    }
    if (st->buf->len != 25) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructAsusHidDesc requested 0x%x and got 0x%x",
                    (guint) 25,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_asus_hid_desc_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_asus_hid_fw_info_ref: (skip):
 **/
FuStructAsusHidFwInfo *
fu_struct_asus_hid_fw_info_ref(FuStructAsusHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_asus_hid_fw_info_unref: (skip):
 **/
void
fu_struct_asus_hid_fw_info_unref(FuStructAsusHidFwInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAsusHidFwInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_asus_hid_fw_info_new_internal: (skip):
 **/
static FuStructAsusHidFwInfo *
fu_struct_asus_hid_fw_info_new_internal(void)
{
    FuStructAsusHidFwInfo *st = g_new0(FuStructAsusHidFwInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_asus_hid_fw_info_get_header: (skip):
 **/
FuStructAsusHidCommand *
fu_struct_asus_hid_fw_info_get_header(const FuStructAsusHidFwInfo *st)
{
    g_autoptr(FuStructAsusHidCommand) st_tmp = fu_struct_asus_hid_command_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_ASUS_HID_FW_INFO_OFFSET_HEADER, 6);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_asus_hid_fw_info_get_description: (skip):
 **/
FuStructAsusHidDesc *
fu_struct_asus_hid_fw_info_get_description(const FuStructAsusHidFwInfo *st)
{
    g_autoptr(FuStructAsusHidDesc) st_tmp = fu_struct_asus_hid_desc_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_ASUS_HID_FW_INFO_OFFSET_DESCRIPTION, 25);
    return g_steal_pointer(&st_tmp);
}

/* setters */
/**
 * fu_struct_asus_hid_fw_info_set_header: (skip):
 **/
gboolean
fu_struct_asus_hid_fw_info_set_header(FuStructAsusHidFwInfo *st, const FuStructAsusHidCommand *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_ASUS_HID_COMMAND_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructAsusHidCommand' (0x%x bytes) does not fit in "
                    "FuStructAsusHidFwInfo.header (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_ASUS_HID_COMMAND_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_ASUS_HID_FW_INFO_OFFSET_HEADER, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_asus_hid_fw_info_set_description: (skip):
 **/
gboolean
fu_struct_asus_hid_fw_info_set_description(FuStructAsusHidFwInfo *st, const FuStructAsusHidDesc *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_ASUS_HID_DESC_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructAsusHidDesc' (0x%x bytes) does not fit in "
                    "FuStructAsusHidFwInfo.description (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_ASUS_HID_DESC_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_ASUS_HID_FW_INFO_OFFSET_DESCRIPTION, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_asus_hid_fw_info_new: (skip):
 **/
FuStructAsusHidFwInfo *
fu_struct_asus_hid_fw_info_new(void)
{
    FuStructAsusHidFwInfo *st = fu_struct_asus_hid_fw_info_new_internal();
    st->buf = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st->buf, 32, 0x0);
    {
        g_autoptr(FuStructAsusHidCommand) st_donor = fu_struct_asus_hid_command_new();
        memcpy(st->buf->data + 0x0, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    {
        g_autoptr(FuStructAsusHidDesc) st_donor = fu_struct_asus_hid_desc_new();
        memcpy(st->buf->data + 0x7, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    return st;
}
/**
 * fu_struct_asus_hid_pre_update_command_ref: (skip):
 **/
FuStructAsusHidPreUpdateCommand *
fu_struct_asus_hid_pre_update_command_ref(FuStructAsusHidPreUpdateCommand *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_asus_hid_pre_update_command_unref: (skip):
 **/
void
fu_struct_asus_hid_pre_update_command_unref(FuStructAsusHidPreUpdateCommand *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAsusHidPreUpdateCommand refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_asus_hid_pre_update_command_new_internal: (skip):
 **/
static FuStructAsusHidPreUpdateCommand *
fu_struct_asus_hid_pre_update_command_new_internal(void)
{
    FuStructAsusHidPreUpdateCommand *st = g_new0(FuStructAsusHidPreUpdateCommand, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_asus_hid_pre_update_command_set_report_id: (skip):
 **/
static void
fu_struct_asus_hid_pre_update_command_set_report_id(FuStructAsusHidPreUpdateCommand *st, FuAsusHidReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_asus_hid_pre_update_command_set_cmd: (skip):
 **/
void
fu_struct_asus_hid_pre_update_command_set_cmd(FuStructAsusHidPreUpdateCommand *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 1, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_asus_hid_pre_update_command_set_length: (skip):
 **/
void
fu_struct_asus_hid_pre_update_command_set_length(FuStructAsusHidPreUpdateCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_asus_hid_pre_update_command_set_data: (skip):
 **/
gboolean
fu_struct_asus_hid_pre_update_command_set_data(FuStructAsusHidPreUpdateCommand *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 6, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_asus_hid_pre_update_command_new: (skip):
 **/
FuStructAsusHidPreUpdateCommand *
fu_struct_asus_hid_pre_update_command_new(void)
{
    FuStructAsusHidPreUpdateCommand *st = fu_struct_asus_hid_pre_update_command_new_internal();
    st->buf = g_byte_array_sized_new(64);
    fu_byte_array_set_size(st->buf, 64, 0x0);
    fu_struct_asus_hid_pre_update_command_set_report_id(st, FU_ASUS_HID_REPORT_ID_INFO);
    return st;
}
/**
 * fu_struct_asus_flash_reset_ref: (skip):
 **/
FuStructAsusFlashReset *
fu_struct_asus_flash_reset_ref(FuStructAsusFlashReset *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_asus_flash_reset_unref: (skip):
 **/
void
fu_struct_asus_flash_reset_unref(FuStructAsusFlashReset *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAsusFlashReset refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_asus_flash_reset_new_internal: (skip):
 **/
static FuStructAsusFlashReset *
fu_struct_asus_flash_reset_new_internal(void)
{
    FuStructAsusFlashReset *st = g_new0(FuStructAsusFlashReset, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_asus_flash_reset_set_command: (skip):
 **/
static void
fu_struct_asus_flash_reset_set_command(FuStructAsusFlashReset *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_asus_flash_reset_new: (skip):
 **/
FuStructAsusFlashReset *
fu_struct_asus_flash_reset_new(void)
{
    FuStructAsusFlashReset *st = fu_struct_asus_flash_reset_new_internal();
    st->buf = g_byte_array_sized_new(63);
    fu_byte_array_set_size(st->buf, 63, 0x0);
    fu_struct_asus_flash_reset_set_command(st, 0xc4);
    return st;
}
/**
 * fu_struct_asus_read_flash_command_ref: (skip):
 **/
FuStructAsusReadFlashCommand *
fu_struct_asus_read_flash_command_ref(FuStructAsusReadFlashCommand *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_asus_read_flash_command_unref: (skip):
 **/
void
fu_struct_asus_read_flash_command_unref(FuStructAsusReadFlashCommand *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAsusReadFlashCommand refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_asus_read_flash_command_new_internal: (skip):
 **/
static FuStructAsusReadFlashCommand *
fu_struct_asus_read_flash_command_new_internal(void)
{
    FuStructAsusReadFlashCommand *st = g_new0(FuStructAsusReadFlashCommand, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_asus_read_flash_command_get_offset: (skip):
 **/
guint32
fu_struct_asus_read_flash_command_get_offset(const FuStructAsusReadFlashCommand *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 1, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_asus_read_flash_command_get_datasz: (skip):
 **/
guint8
fu_struct_asus_read_flash_command_get_datasz(const FuStructAsusReadFlashCommand *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_asus_read_flash_command_get_data: (skip):
 **/
const guint8 *
fu_struct_asus_read_flash_command_get_data(const FuStructAsusReadFlashCommand *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 58;
    return st->buf->data + 5;
}

/* setters */
/**
 * fu_struct_asus_read_flash_command_set_command: (skip):
 **/
static void
fu_struct_asus_read_flash_command_set_command(FuStructAsusReadFlashCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_asus_read_flash_command_set_offset: (skip):
 **/
void
fu_struct_asus_read_flash_command_set_offset(FuStructAsusReadFlashCommand *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint24(st->buf->data + 1, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_asus_read_flash_command_set_datasz: (skip):
 **/
void
fu_struct_asus_read_flash_command_set_datasz(FuStructAsusReadFlashCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_asus_read_flash_command_set_data: (skip):
 **/
gboolean
fu_struct_asus_read_flash_command_set_data(FuStructAsusReadFlashCommand *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 5, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_asus_read_flash_command_new: (skip):
 **/
FuStructAsusReadFlashCommand *
fu_struct_asus_read_flash_command_new(void)
{
    FuStructAsusReadFlashCommand *st = fu_struct_asus_read_flash_command_new_internal();
    st->buf = g_byte_array_sized_new(63);
    fu_byte_array_set_size(st->buf, 63, 0x0);
    fu_struct_asus_read_flash_command_set_command(st, 0xd1);
    return st;
}
