/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-oprom-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_oprom_machine_type_to_string:
 * @val: value
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_oprom_machine_type_to_string(FuOpromMachineType val)
{
    if (val == FU_OPROM_MACHINE_TYPE_X64)
        return "x64";
    return NULL;
}

/**
 * fu_oprom_subsystem_to_string:
 * @val: value
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_oprom_subsystem_to_string(FuOpromSubsystem val)
{
    if (val == FU_OPROM_SUBSYSTEM_EFI_BOOT_SRV_DRV)
        return "efi-boot-srv-drv";
    return NULL;
}

/**
 * fu_oprom_compression_type_to_string:
 * @val: value
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_oprom_compression_type_to_string(FuOpromCompressionType val)
{
    if (val == FU_OPROM_COMPRESSION_TYPE_NONE)
        return "none";
    return NULL;
}

/**
 * fu_oprom_indicator_flags_to_string:
 * @val: value, e.g. %FU_OPROM_INDICATOR_FLAG_LAST
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_oprom_indicator_flags_to_string(FuOpromIndicatorFlags val)
{
    if (val == FU_OPROM_INDICATOR_FLAG_NONE)
        return "none";
    if (val == FU_OPROM_INDICATOR_FLAG_LAST)
        return "last";
    return NULL;
}
/**
 * fu_struct_oprom_ref: (skip):
 **/
FuStructOprom *
fu_struct_oprom_ref(FuStructOprom *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_oprom_unref: (skip):
 **/
void
fu_struct_oprom_unref(FuStructOprom *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructOprom refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_oprom_new_internal: (skip):
 **/
static FuStructOprom *
fu_struct_oprom_new_internal(void)
{
    FuStructOprom *st = g_new0(FuStructOprom, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_oprom_get_signature: (skip):
 **/
static guint16
fu_struct_oprom_get_signature(const FuStructOprom *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_image_size: (skip):
 **/
guint16
fu_struct_oprom_get_image_size(const FuStructOprom *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_init_func_entry_point: (skip):
 **/
guint32
fu_struct_oprom_get_init_func_entry_point(const FuStructOprom *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_subsystem: (skip):
 **/
FuOpromSubsystem
fu_struct_oprom_get_subsystem(const FuStructOprom *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_machine_type: (skip):
 **/
FuOpromMachineType
fu_struct_oprom_get_machine_type(const FuStructOprom *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_compression_type: (skip):
 **/
FuOpromCompressionType
fu_struct_oprom_get_compression_type(const FuStructOprom *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_efi_image_offset: (skip):
 **/
guint16
fu_struct_oprom_get_efi_image_offset(const FuStructOprom *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_pci_header_offset: (skip):
 **/
guint16
fu_struct_oprom_get_pci_header_offset(const FuStructOprom *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_get_expansion_header_offset: (skip):
 **/
guint16
fu_struct_oprom_get_expansion_header_offset(const FuStructOprom *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 26, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_oprom_set_signature: (skip):
 **/
static void
fu_struct_oprom_set_signature(FuStructOprom *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_image_size: (skip):
 **/
void
fu_struct_oprom_set_image_size(FuStructOprom *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_init_func_entry_point: (skip):
 **/
void
fu_struct_oprom_set_init_func_entry_point(FuStructOprom *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_subsystem: (skip):
 **/
void
fu_struct_oprom_set_subsystem(FuStructOprom *st, FuOpromSubsystem value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_machine_type: (skip):
 **/
void
fu_struct_oprom_set_machine_type(FuStructOprom *st, FuOpromMachineType value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_compression_type: (skip):
 **/
void
fu_struct_oprom_set_compression_type(FuStructOprom *st, FuOpromCompressionType value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_efi_image_offset: (skip):
 **/
void
fu_struct_oprom_set_efi_image_offset(FuStructOprom *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 22, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_pci_header_offset: (skip):
 **/
void
fu_struct_oprom_set_pci_header_offset(FuStructOprom *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_set_expansion_header_offset: (skip):
 **/
void
fu_struct_oprom_set_expansion_header_offset(FuStructOprom *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_new: (skip):
 **/
FuStructOprom *
fu_struct_oprom_new(void)
{
    FuStructOprom *st = fu_struct_oprom_new_internal();
    st->buf = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st->buf, 28, 0x0);
    fu_struct_oprom_set_signature(st, 0xAA55);
    fu_struct_oprom_set_pci_header_offset(st, 28);
    return st;
}
/**
 * fu_struct_oprom_to_string: (skip):
 **/
static gchar *
fu_struct_oprom_to_string(const FuStructOprom *st)
{
    g_autoptr(GString) str = g_string_new("FuStructOprom:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  image_size: 0x%x\n",
                           (guint) fu_struct_oprom_get_image_size(st));
    g_string_append_printf(str, "  init_func_entry_point: 0x%x\n",
                           (guint) fu_struct_oprom_get_init_func_entry_point(st));
    {
        const gchar *tmp = fu_oprom_subsystem_to_string(fu_struct_oprom_get_subsystem(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  subsystem: 0x%x [%s]\n", (guint) fu_struct_oprom_get_subsystem(st), tmp);
        } else {
            g_string_append_printf(str, "  subsystem: 0x%x\n", (guint) fu_struct_oprom_get_subsystem(st));
        }
    }
    {
        const gchar *tmp = fu_oprom_machine_type_to_string(fu_struct_oprom_get_machine_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  machine_type: 0x%x [%s]\n", (guint) fu_struct_oprom_get_machine_type(st), tmp);
        } else {
            g_string_append_printf(str, "  machine_type: 0x%x\n", (guint) fu_struct_oprom_get_machine_type(st));
        }
    }
    {
        const gchar *tmp = fu_oprom_compression_type_to_string(fu_struct_oprom_get_compression_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  compression_type: 0x%x [%s]\n", (guint) fu_struct_oprom_get_compression_type(st), tmp);
        } else {
            g_string_append_printf(str, "  compression_type: 0x%x\n", (guint) fu_struct_oprom_get_compression_type(st));
        }
    }
    g_string_append_printf(str, "  efi_image_offset: 0x%x\n",
                           (guint) fu_struct_oprom_get_efi_image_offset(st));
    g_string_append_printf(str, "  pci_header_offset: 0x%x\n",
                           (guint) fu_struct_oprom_get_pci_header_offset(st));
    g_string_append_printf(str, "  expansion_header_offset: 0x%x\n",
                           (guint) fu_struct_oprom_get_expansion_header_offset(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_oprom_validate_internal(FuStructOprom *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_oprom_get_signature(st) != 0xAA55) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructOprom.signature was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0xAA55,
                    (guint) fu_struct_oprom_get_signature(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_oprom_validate_stream: (skip):
 **/
gboolean
fu_struct_oprom_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructOprom) st = fu_struct_oprom_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 28, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructOprom failed read of 0x%x: ", (guint) 28);
        return FALSE;
    }
    if (st->buf->len != 28) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructOprom requested 0x%x and got 0x%x",
                    (guint) 28,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_oprom_validate_internal(st, error);
}
static gboolean
fu_struct_oprom_parse_internal(FuStructOprom *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_oprom_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_oprom_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_oprom_parse_stream: (skip):
 **/
FuStructOprom *
fu_struct_oprom_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructOprom) st = fu_struct_oprom_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 28, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructOprom failed read of 0x%x: ", (guint) 28);
        return NULL;
    }
    if (st->buf->len != 28) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructOprom requested 0x%x and got 0x%x",
                    (guint) 28,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_oprom_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_oprom_pci_ref: (skip):
 **/
FuStructOpromPci *
fu_struct_oprom_pci_ref(FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_oprom_pci_unref: (skip):
 **/
void
fu_struct_oprom_pci_unref(FuStructOpromPci *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructOpromPci refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_oprom_pci_new_internal: (skip):
 **/
static FuStructOpromPci *
fu_struct_oprom_pci_new_internal(void)
{
    FuStructOpromPci *st = g_new0(FuStructOpromPci, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_oprom_pci_get_signature: (skip):
 **/
static guint32
fu_struct_oprom_pci_get_signature(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_vendor_id: (skip):
 **/
guint16
fu_struct_oprom_pci_get_vendor_id(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_device_id: (skip):
 **/
guint16
fu_struct_oprom_pci_get_device_id(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_device_list_pointer: (skip):
 **/
guint16
fu_struct_oprom_pci_get_device_list_pointer(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_structure_length: (skip):
 **/
guint16
fu_struct_oprom_pci_get_structure_length(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_structure_revision: (skip):
 **/
guint8
fu_struct_oprom_pci_get_structure_revision(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[12];
}
/**
 * fu_struct_oprom_pci_get_class_code: (skip):
 **/
guint32
fu_struct_oprom_pci_get_class_code(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 13, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_image_length: (skip):
 **/
guint16
fu_struct_oprom_pci_get_image_length(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_image_revision: (skip):
 **/
guint16
fu_struct_oprom_pci_get_image_revision(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_code_type: (skip):
 **/
guint8
fu_struct_oprom_pci_get_code_type(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[20];
}
/**
 * fu_struct_oprom_pci_get_indicator: (skip):
 **/
FuOpromIndicatorFlags
fu_struct_oprom_pci_get_indicator(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[21];
}
/**
 * fu_struct_oprom_pci_get_max_runtime_image_length: (skip):
 **/
guint16
fu_struct_oprom_pci_get_max_runtime_image_length(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_conf_util_code_header_pointer: (skip):
 **/
guint16
fu_struct_oprom_pci_get_conf_util_code_header_pointer(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_get_dmtf_clp_entry_point_pointer: (skip):
 **/
guint16
fu_struct_oprom_pci_get_dmtf_clp_entry_point_pointer(const FuStructOpromPci *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 26, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_oprom_pci_set_signature: (skip):
 **/
static void
fu_struct_oprom_pci_set_signature(FuStructOpromPci *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_vendor_id: (skip):
 **/
void
fu_struct_oprom_pci_set_vendor_id(FuStructOpromPci *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_device_id: (skip):
 **/
void
fu_struct_oprom_pci_set_device_id(FuStructOpromPci *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_device_list_pointer: (skip):
 **/
void
fu_struct_oprom_pci_set_device_list_pointer(FuStructOpromPci *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_structure_length: (skip):
 **/
void
fu_struct_oprom_pci_set_structure_length(FuStructOpromPci *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_structure_revision: (skip):
 **/
void
fu_struct_oprom_pci_set_structure_revision(FuStructOpromPci *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[12] = value;
}
/**
 * fu_struct_oprom_pci_set_class_code: (skip):
 **/
void
fu_struct_oprom_pci_set_class_code(FuStructOpromPci *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint24(st->buf->data + 13, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_image_length: (skip):
 **/
void
fu_struct_oprom_pci_set_image_length(FuStructOpromPci *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_image_revision: (skip):
 **/
void
fu_struct_oprom_pci_set_image_revision(FuStructOpromPci *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 18, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_code_type: (skip):
 **/
void
fu_struct_oprom_pci_set_code_type(FuStructOpromPci *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[20] = value;
}
/**
 * fu_struct_oprom_pci_set_indicator: (skip):
 **/
void
fu_struct_oprom_pci_set_indicator(FuStructOpromPci *st, FuOpromIndicatorFlags value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[21] = value;
}
/**
 * fu_struct_oprom_pci_set_max_runtime_image_length: (skip):
 **/
void
fu_struct_oprom_pci_set_max_runtime_image_length(FuStructOpromPci *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 22, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_conf_util_code_header_pointer: (skip):
 **/
void
fu_struct_oprom_pci_set_conf_util_code_header_pointer(FuStructOpromPci *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_set_dmtf_clp_entry_point_pointer: (skip):
 **/
void
fu_struct_oprom_pci_set_dmtf_clp_entry_point_pointer(FuStructOpromPci *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_oprom_pci_new: (skip):
 **/
FuStructOpromPci *
fu_struct_oprom_pci_new(void)
{
    FuStructOpromPci *st = fu_struct_oprom_pci_new_internal();
    st->buf = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st->buf, 28, 0x0);
    fu_struct_oprom_pci_set_signature(st, 0x52494350);
    return st;
}
/**
 * fu_struct_oprom_pci_to_string: (skip):
 **/
static gchar *
fu_struct_oprom_pci_to_string(const FuStructOpromPci *st)
{
    g_autoptr(GString) str = g_string_new("FuStructOpromPci:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  vendor_id: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_vendor_id(st));
    g_string_append_printf(str, "  device_id: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_device_id(st));
    g_string_append_printf(str, "  device_list_pointer: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_device_list_pointer(st));
    g_string_append_printf(str, "  structure_length: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_structure_length(st));
    g_string_append_printf(str, "  structure_revision: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_structure_revision(st));
    g_string_append_printf(str, "  class_code: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_class_code(st));
    g_string_append_printf(str, "  image_length: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_image_length(st));
    g_string_append_printf(str, "  image_revision: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_image_revision(st));
    g_string_append_printf(str, "  code_type: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_code_type(st));
    {
        const gchar *tmp = fu_oprom_indicator_flags_to_string(fu_struct_oprom_pci_get_indicator(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  indicator: 0x%x [%s]\n", (guint) fu_struct_oprom_pci_get_indicator(st), tmp);
        } else {
            g_string_append_printf(str, "  indicator: 0x%x\n", (guint) fu_struct_oprom_pci_get_indicator(st));
        }
    }
    g_string_append_printf(str, "  max_runtime_image_length: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_max_runtime_image_length(st));
    g_string_append_printf(str, "  conf_util_code_header_pointer: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_conf_util_code_header_pointer(st));
    g_string_append_printf(str, "  dmtf_clp_entry_point_pointer: 0x%x\n",
                           (guint) fu_struct_oprom_pci_get_dmtf_clp_entry_point_pointer(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_oprom_pci_validate_internal(FuStructOpromPci *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_oprom_pci_get_signature(st) != 0x52494350) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructOpromPci.signature was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x52494350,
                    (guint) fu_struct_oprom_pci_get_signature(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_oprom_pci_parse_internal(FuStructOpromPci *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_oprom_pci_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_oprom_pci_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_oprom_pci_parse_stream: (skip):
 **/
FuStructOpromPci *
fu_struct_oprom_pci_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructOpromPci) st = fu_struct_oprom_pci_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 28, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructOpromPci failed read of 0x%x: ", (guint) 28);
        return NULL;
    }
    if (st->buf->len != 28) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructOpromPci requested 0x%x and got 0x%x",
                    (guint) 28,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_oprom_pci_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
