/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-dpaux-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/**
 * fu_struct_dpaux_dpcd_ref: (skip):
 **/
FuStructDpauxDpcd *
fu_struct_dpaux_dpcd_ref(FuStructDpauxDpcd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dpaux_dpcd_unref: (skip):
 **/
void
fu_struct_dpaux_dpcd_unref(FuStructDpauxDpcd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDpauxDpcd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_dpaux_dpcd_new_internal: (skip):
 **/
static FuStructDpauxDpcd *
fu_struct_dpaux_dpcd_new_internal(void)
{
    FuStructDpauxDpcd *st = g_new0(FuStructDpauxDpcd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_dpaux_dpcd_get_ieee_oui: (skip):
 **/
guint32
fu_struct_dpaux_dpcd_get_ieee_oui(const FuStructDpauxDpcd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_dpaux_dpcd_get_dev_id: (skip):
 **/
gchar *
fu_struct_dpaux_dpcd_get_dev_id(const FuStructDpauxDpcd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 3, 6, NULL);
}
/**
 * fu_struct_dpaux_dpcd_get_hw_rev: (skip):
 **/
guint8
fu_struct_dpaux_dpcd_get_hw_rev(const FuStructDpauxDpcd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_dpaux_dpcd_get_fw_ver: (skip):
 **/
guint32
fu_struct_dpaux_dpcd_get_fw_ver(const FuStructDpauxDpcd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 10, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_dpaux_dpcd_to_string: (skip):
 **/
static gchar *
fu_struct_dpaux_dpcd_to_string(const FuStructDpauxDpcd *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDpauxDpcd:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  ieee_oui: 0x%x\n",
                           (guint) fu_struct_dpaux_dpcd_get_ieee_oui(st));
    {
        g_autofree gchar *tmp = fu_struct_dpaux_dpcd_get_dev_id(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  dev_id: %s\n", tmp);
    }
    g_string_append_printf(str, "  hw_rev: 0x%x\n",
                           (guint) fu_struct_dpaux_dpcd_get_hw_rev(st));
    g_string_append_printf(str, "  fw_ver: 0x%x\n",
                           (guint) fu_struct_dpaux_dpcd_get_fw_ver(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_dpaux_dpcd_validate_internal(FuStructDpauxDpcd *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_dpaux_dpcd_parse_internal(FuStructDpauxDpcd *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_dpaux_dpcd_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_dpaux_dpcd_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_dpaux_dpcd_parse: (skip):
 **/
FuStructDpauxDpcd *
fu_struct_dpaux_dpcd_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructDpauxDpcd) st = fu_struct_dpaux_dpcd_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 13, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructDpauxDpcd: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 13);
    if (!fu_struct_dpaux_dpcd_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
