/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-dfu-firmware-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/**
 * fu_struct_dfu_ftr_ref: (skip):
 **/
FuStructDfuFtr *
fu_struct_dfu_ftr_ref(FuStructDfuFtr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dfu_ftr_unref: (skip):
 **/
void
fu_struct_dfu_ftr_unref(FuStructDfuFtr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDfuFtr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_dfu_ftr_new_internal: (skip):
 **/
static FuStructDfuFtr *
fu_struct_dfu_ftr_new_internal(void)
{
    FuStructDfuFtr *st = g_new0(FuStructDfuFtr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_dfu_ftr_get_release: (skip):
 **/
guint16
fu_struct_dfu_ftr_get_release(const FuStructDfuFtr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_get_pid: (skip):
 **/
guint16
fu_struct_dfu_ftr_get_pid(const FuStructDfuFtr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_get_vid: (skip):
 **/
guint16
fu_struct_dfu_ftr_get_vid(const FuStructDfuFtr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_get_ver: (skip):
 **/
guint16
fu_struct_dfu_ftr_get_ver(const FuStructDfuFtr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_get_sig: (skip):
 **/
static gchar *
fu_struct_dfu_ftr_get_sig(const FuStructDfuFtr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 8, 3, NULL);
}
/**
 * fu_struct_dfu_ftr_get_len: (skip):
 **/
guint8
fu_struct_dfu_ftr_get_len(const FuStructDfuFtr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[11];
}
/**
 * fu_struct_dfu_ftr_get_crc: (skip):
 **/
guint32
fu_struct_dfu_ftr_get_crc(const FuStructDfuFtr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_dfu_ftr_set_release: (skip):
 **/
void
fu_struct_dfu_ftr_set_release(FuStructDfuFtr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_set_pid: (skip):
 **/
void
fu_struct_dfu_ftr_set_pid(FuStructDfuFtr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_set_vid: (skip):
 **/
void
fu_struct_dfu_ftr_set_vid(FuStructDfuFtr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_set_ver: (skip):
 **/
void
fu_struct_dfu_ftr_set_ver(FuStructDfuFtr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_set_sig: (skip):
 **/
static gboolean
fu_struct_dfu_ftr_set_sig(FuStructDfuFtr *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 8, 0x0, 3);
        return TRUE;
    }
    len = strlen(value);
    if (len > 3) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructDfuFtr.sig (0x%x bytes)",
                    value, (guint) len, (guint) 3);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 8, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_dfu_ftr_set_len: (skip):
 **/
void
fu_struct_dfu_ftr_set_len(FuStructDfuFtr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[11] = value;
}
/**
 * fu_struct_dfu_ftr_set_crc: (skip):
 **/
void
fu_struct_dfu_ftr_set_crc(FuStructDfuFtr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_new: (skip):
 **/
FuStructDfuFtr *
fu_struct_dfu_ftr_new(void)
{
    FuStructDfuFtr *st = fu_struct_dfu_ftr_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    fu_struct_dfu_ftr_set_sig(st, "UFD", NULL);
    fu_struct_dfu_ftr_set_len(st, 16);
    return st;
}
/**
 * fu_struct_dfu_ftr_to_string: (skip):
 **/
static gchar *
fu_struct_dfu_ftr_to_string(const FuStructDfuFtr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDfuFtr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  release: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_release(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_pid(st));
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_vid(st));
    g_string_append_printf(str, "  ver: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_ver(st));
    g_string_append_printf(str, "  len: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_len(st));
    g_string_append_printf(str, "  crc: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_crc(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_dfu_ftr_validate_internal(FuStructDfuFtr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 8), "UFD", 3) != 0) {
        g_autofree gchar *str = fu_struct_dfu_ftr_get_sig(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructDfuFtr.sig was not valid, "
                    "expected 'UFD' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_dfu_ftr_validate_stream: (skip):
 **/
gboolean
fu_struct_dfu_ftr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructDfuFtr) st = fu_struct_dfu_ftr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 16, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructDfuFtr failed read of 0x%x: ", (guint) 16);
        return FALSE;
    }
    if (st->buf->len != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructDfuFtr requested 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_dfu_ftr_validate_internal(st, error);
}
static gboolean
fu_struct_dfu_ftr_parse_internal(FuStructDfuFtr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_dfu_ftr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_dfu_ftr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_dfu_ftr_parse_stream: (skip):
 **/
FuStructDfuFtr *
fu_struct_dfu_ftr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructDfuFtr) st = fu_struct_dfu_ftr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 16, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructDfuFtr failed read of 0x%x: ", (guint) 16);
        return NULL;
    }
    if (st->buf->len != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructDfuFtr requested 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_dfu_ftr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_dfuse_hdr_ref: (skip):
 **/
FuStructDfuseHdr *
fu_struct_dfuse_hdr_ref(FuStructDfuseHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dfuse_hdr_unref: (skip):
 **/
void
fu_struct_dfuse_hdr_unref(FuStructDfuseHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDfuseHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_dfuse_hdr_new_internal: (skip):
 **/
static FuStructDfuseHdr *
fu_struct_dfuse_hdr_new_internal(void)
{
    FuStructDfuseHdr *st = g_new0(FuStructDfuseHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_dfuse_hdr_get_sig: (skip):
 **/
static gchar *
fu_struct_dfuse_hdr_get_sig(const FuStructDfuseHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 5, NULL);
}
/**
 * fu_struct_dfuse_hdr_get_ver: (skip):
 **/
static guint8
fu_struct_dfuse_hdr_get_ver(const FuStructDfuseHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_dfuse_hdr_get_image_size: (skip):
 **/
guint32
fu_struct_dfuse_hdr_get_image_size(const FuStructDfuseHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_hdr_get_targets: (skip):
 **/
guint8
fu_struct_dfuse_hdr_get_targets(const FuStructDfuseHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}

/* setters */
/**
 * fu_struct_dfuse_hdr_set_sig: (skip):
 **/
static gboolean
fu_struct_dfuse_hdr_set_sig(FuStructDfuseHdr *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 5);
        return TRUE;
    }
    len = strlen(value);
    if (len > 5) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructDfuseHdr.sig (0x%x bytes)",
                    value, (guint) len, (guint) 5);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_dfuse_hdr_set_ver: (skip):
 **/
static void
fu_struct_dfuse_hdr_set_ver(FuStructDfuseHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_dfuse_hdr_set_image_size: (skip):
 **/
void
fu_struct_dfuse_hdr_set_image_size(FuStructDfuseHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_hdr_set_targets: (skip):
 **/
void
fu_struct_dfuse_hdr_set_targets(FuStructDfuseHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[10] = value;
}
/**
 * fu_struct_dfuse_hdr_new: (skip):
 **/
FuStructDfuseHdr *
fu_struct_dfuse_hdr_new(void)
{
    FuStructDfuseHdr *st = fu_struct_dfuse_hdr_new_internal();
    st->buf = g_byte_array_sized_new(11);
    fu_byte_array_set_size(st->buf, 11, 0x0);
    fu_struct_dfuse_hdr_set_sig(st, "DfuSe", NULL);
    fu_struct_dfuse_hdr_set_ver(st, 0x01);
    return st;
}
/**
 * fu_struct_dfuse_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_dfuse_hdr_to_string(const FuStructDfuseHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDfuseHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  image_size: 0x%x\n",
                           (guint) fu_struct_dfuse_hdr_get_image_size(st));
    g_string_append_printf(str, "  targets: 0x%x\n",
                           (guint) fu_struct_dfuse_hdr_get_targets(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_dfuse_hdr_to_bytes: (skip):
 **/
GBytes *
fu_struct_dfuse_hdr_to_bytes(const FuStructDfuseHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return g_bytes_new(st->buf->data, st->buf->len);
}
static gboolean
fu_struct_dfuse_hdr_validate_internal(FuStructDfuseHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "DfuSe", 5) != 0) {
        g_autofree gchar *str = fu_struct_dfuse_hdr_get_sig(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructDfuseHdr.sig was not valid, "
                    "expected 'DfuSe' and got '%s'",
                    str);
        return FALSE;
    }
    if (fu_struct_dfuse_hdr_get_ver(st) != 0x01) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructDfuseHdr.ver was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_dfuse_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_dfuse_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructDfuseHdr) st = fu_struct_dfuse_hdr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 11, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructDfuseHdr failed read of 0x%x: ", (guint) 11);
        return FALSE;
    }
    if (st->buf->len != 11) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructDfuseHdr requested 0x%x and got 0x%x",
                    (guint) 11,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_dfuse_hdr_validate_internal(st, error);
}
static gboolean
fu_struct_dfuse_hdr_parse_internal(FuStructDfuseHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_dfuse_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_dfuse_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_dfuse_hdr_parse_stream: (skip):
 **/
FuStructDfuseHdr *
fu_struct_dfuse_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructDfuseHdr) st = fu_struct_dfuse_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 11, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructDfuseHdr failed read of 0x%x: ", (guint) 11);
        return NULL;
    }
    if (st->buf->len != 11) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructDfuseHdr requested 0x%x and got 0x%x",
                    (guint) 11,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_dfuse_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_dfuse_image_ref: (skip):
 **/
FuStructDfuseImage *
fu_struct_dfuse_image_ref(FuStructDfuseImage *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dfuse_image_unref: (skip):
 **/
void
fu_struct_dfuse_image_unref(FuStructDfuseImage *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDfuseImage refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_dfuse_image_new_internal: (skip):
 **/
static FuStructDfuseImage *
fu_struct_dfuse_image_new_internal(void)
{
    FuStructDfuseImage *st = g_new0(FuStructDfuseImage, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_dfuse_image_get_sig: (skip):
 **/
static gchar *
fu_struct_dfuse_image_get_sig(const FuStructDfuseImage *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 6, NULL);
}
/**
 * fu_struct_dfuse_image_get_alt_setting: (skip):
 **/
guint8
fu_struct_dfuse_image_get_alt_setting(const FuStructDfuseImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_dfuse_image_get_target_named: (skip):
 **/
guint32
fu_struct_dfuse_image_get_target_named(const FuStructDfuseImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 7, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_image_get_target_name: (skip):
 **/
gchar *
fu_struct_dfuse_image_get_target_name(const FuStructDfuseImage *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 11, 255, NULL);
}
/**
 * fu_struct_dfuse_image_get_target_size: (skip):
 **/
guint32
fu_struct_dfuse_image_get_target_size(const FuStructDfuseImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 266, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_image_get_chunks: (skip):
 **/
guint32
fu_struct_dfuse_image_get_chunks(const FuStructDfuseImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 270, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_dfuse_image_set_sig: (skip):
 **/
static gboolean
fu_struct_dfuse_image_set_sig(FuStructDfuseImage *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 6);
        return TRUE;
    }
    len = strlen(value);
    if (len > 6) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructDfuseImage.sig (0x%x bytes)",
                    value, (guint) len, (guint) 6);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_dfuse_image_set_alt_setting: (skip):
 **/
void
fu_struct_dfuse_image_set_alt_setting(FuStructDfuseImage *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_dfuse_image_set_target_named: (skip):
 **/
void
fu_struct_dfuse_image_set_target_named(FuStructDfuseImage *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 7, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_image_set_target_name: (skip):
 **/
gboolean
fu_struct_dfuse_image_set_target_name(FuStructDfuseImage *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 11, 0x0, 255);
        return TRUE;
    }
    len = strlen(value);
    if (len > 255) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructDfuseImage.target_name (0x%x bytes)",
                    value, (guint) len, (guint) 255);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 11, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_dfuse_image_set_target_size: (skip):
 **/
void
fu_struct_dfuse_image_set_target_size(FuStructDfuseImage *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 266, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_image_set_chunks: (skip):
 **/
void
fu_struct_dfuse_image_set_chunks(FuStructDfuseImage *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 270, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_image_new: (skip):
 **/
FuStructDfuseImage *
fu_struct_dfuse_image_new(void)
{
    FuStructDfuseImage *st = fu_struct_dfuse_image_new_internal();
    st->buf = g_byte_array_sized_new(274);
    fu_byte_array_set_size(st->buf, 274, 0x0);
    fu_struct_dfuse_image_set_sig(st, "Target", NULL);
    return st;
}
/**
 * fu_struct_dfuse_image_to_string: (skip):
 **/
static gchar *
fu_struct_dfuse_image_to_string(const FuStructDfuseImage *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDfuseImage:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  alt_setting: 0x%x\n",
                           (guint) fu_struct_dfuse_image_get_alt_setting(st));
    g_string_append_printf(str, "  target_named: 0x%x\n",
                           (guint) fu_struct_dfuse_image_get_target_named(st));
    {
        g_autofree gchar *tmp = fu_struct_dfuse_image_get_target_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  target_name: %s\n", tmp);
    }
    g_string_append_printf(str, "  target_size: 0x%x\n",
                           (guint) fu_struct_dfuse_image_get_target_size(st));
    g_string_append_printf(str, "  chunks: 0x%x\n",
                           (guint) fu_struct_dfuse_image_get_chunks(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_dfuse_image_to_bytes: (skip):
 **/
GBytes *
fu_struct_dfuse_image_to_bytes(const FuStructDfuseImage *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return g_bytes_new(st->buf->data, st->buf->len);
}
static gboolean
fu_struct_dfuse_image_validate_internal(FuStructDfuseImage *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "Target", 6) != 0) {
        g_autofree gchar *str = fu_struct_dfuse_image_get_sig(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructDfuseImage.sig was not valid, "
                    "expected 'Target' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_dfuse_image_validate: (skip):
 **/
gboolean
fu_struct_dfuse_image_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st_buf = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    FuStructDfuseImage st_tmp = {.buf = &st_buf };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 274, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructDfuseImage: ");
        return FALSE;
    }
    if (!fu_struct_dfuse_image_validate_internal(&st_tmp, error))
        return FALSE;
    return TRUE;
}
static gboolean
fu_struct_dfuse_image_parse_internal(FuStructDfuseImage *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_dfuse_image_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_dfuse_image_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_dfuse_image_parse_stream: (skip):
 **/
FuStructDfuseImage *
fu_struct_dfuse_image_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructDfuseImage) st = fu_struct_dfuse_image_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 274, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructDfuseImage failed read of 0x%x: ", (guint) 274);
        return NULL;
    }
    if (st->buf->len != 274) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructDfuseImage requested 0x%x and got 0x%x",
                    (guint) 274,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_dfuse_image_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_dfuse_element_ref: (skip):
 **/
FuStructDfuseElement *
fu_struct_dfuse_element_ref(FuStructDfuseElement *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dfuse_element_unref: (skip):
 **/
void
fu_struct_dfuse_element_unref(FuStructDfuseElement *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDfuseElement refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_dfuse_element_new_internal: (skip):
 **/
static FuStructDfuseElement *
fu_struct_dfuse_element_new_internal(void)
{
    FuStructDfuseElement *st = g_new0(FuStructDfuseElement, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_dfuse_element_get_address: (skip):
 **/
guint32
fu_struct_dfuse_element_get_address(const FuStructDfuseElement *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_element_get_size: (skip):
 **/
guint32
fu_struct_dfuse_element_get_size(const FuStructDfuseElement *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_dfuse_element_set_address: (skip):
 **/
void
fu_struct_dfuse_element_set_address(FuStructDfuseElement *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_element_set_size: (skip):
 **/
void
fu_struct_dfuse_element_set_size(FuStructDfuseElement *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_element_new: (skip):
 **/
FuStructDfuseElement *
fu_struct_dfuse_element_new(void)
{
    FuStructDfuseElement *st = fu_struct_dfuse_element_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    return st;
}
/**
 * fu_struct_dfuse_element_to_string: (skip):
 **/
static gchar *
fu_struct_dfuse_element_to_string(const FuStructDfuseElement *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDfuseElement:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  address: 0x%x\n",
                           (guint) fu_struct_dfuse_element_get_address(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_dfuse_element_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_dfuse_element_to_bytes: (skip):
 **/
GBytes *
fu_struct_dfuse_element_to_bytes(const FuStructDfuseElement *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return g_bytes_new(st->buf->data, st->buf->len);
}
static gboolean
fu_struct_dfuse_element_validate_internal(FuStructDfuseElement *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_dfuse_element_parse_internal(FuStructDfuseElement *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_dfuse_element_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_dfuse_element_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_dfuse_element_parse_stream: (skip):
 **/
FuStructDfuseElement *
fu_struct_dfuse_element_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructDfuseElement) st = fu_struct_dfuse_element_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructDfuseElement failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->buf->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructDfuseElement requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_dfuse_element_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
