#ifndef SBK_NETWORKMANAGERWRAPPER_H
#define SBK_NETWORKMANAGERWRAPPER_H

#include <networkmanager.h>


// Argument includes
#include <QHash>
#include <QString>
#include <QStringList>
#include <qcoreevent.h>
#include <qiodevice.h>
#include <qmetaobject.h>
#include <qnetworkaccessmanager.h>
#include <qnetworkreply.h>
#include <qnetworkrequest.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qurl.h>
#include <qwebenginecertificateerror.h>
#include <qwidget.h>
#include <schemehandlers/extensionschemehandler.h>
#include <urlinterceptor.h>
#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class NetworkManagerWrapper : public NetworkManager
{
public:
    NetworkManagerWrapper(::QObject * parent = nullptr);
    NetworkManagerWrapper(const NetworkManagerWrapper &) = delete;
    NetworkManagerWrapper& operator=(const NetworkManagerWrapper &) = delete;
    NetworkManagerWrapper(NetworkManagerWrapper &&) = delete;
    NetworkManagerWrapper& operator=(NetworkManagerWrapper &&) = delete;
    ~NetworkManagerWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QNetworkReply * createRequest_protected(::QNetworkAccessManager::Operation op, const ::QNetworkRequest & request, ::QIODevice * outgoingData) { return NetworkManager::createRequest(QNetworkAccessManager::Operation(op), request, outgoingData); }
    ::QNetworkReply * createRequest(::QNetworkAccessManager::Operation op, const ::QNetworkRequest & request, ::QIODevice * outgoingData) override;
    static ::QNetworkReply * sbk_o_createRequest(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QNetworkAccessManager::Operation op, const ::QNetworkRequest & request, ::QIODevice * outgoingData);
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    ::QStringList supportedSchemes() const override;
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 9> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  ifndef SBK_QNETWORKACCESSMANAGERWRAPPER_H
#  define SBK_QNETWORKACCESSMANAGERWRAPPER_H

// Inherited base class:
class QNetworkAccessManagerWrapper : public QNetworkAccessManager
{
public:
    QNetworkAccessManagerWrapper(::QObject * parent = nullptr);
    QNetworkAccessManagerWrapper(const QNetworkAccessManagerWrapper &) = delete;
    QNetworkAccessManagerWrapper& operator=(const QNetworkAccessManagerWrapper &) = delete;
    QNetworkAccessManagerWrapper(QNetworkAccessManagerWrapper &&) = delete;
    QNetworkAccessManagerWrapper& operator=(QNetworkAccessManagerWrapper &&) = delete;
    ~QNetworkAccessManagerWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QNetworkReply * createRequest_protected(::QNetworkAccessManager::Operation op, const ::QNetworkRequest & request, ::QIODevice * outgoingData = nullptr) { return QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation(op), request, outgoingData); }
    ::QNetworkReply * createRequest(::QNetworkAccessManager::Operation op, const ::QNetworkRequest & request, ::QIODevice * outgoingData = nullptr) override;
    static ::QNetworkReply * sbk_o_createRequest(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QNetworkAccessManager::Operation op, const ::QNetworkRequest & request, ::QIODevice * outgoingData = nullptr);
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    ::QStringList supportedSchemes() const override;
    ::QStringList supportedSchemesImplementation_protected() const { return QNetworkAccessManager::supportedSchemesImplementation(); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 9> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QNETWORKACCESSMANAGERWRAPPER_H

#  ifndef SBK_QOBJECTWRAPPER_H
#  define SBK_QOBJECTWRAPPER_H

// Inherited base class:
class QObjectWrapper : public QObject
{
public:
    QObjectWrapper(::QObject * parent = nullptr);
    QObjectWrapper(const QObjectWrapper &) = delete;
    QObjectWrapper& operator=(const QObjectWrapper &) = delete;
    QObjectWrapper(QObjectWrapper &&) = delete;
    QObjectWrapper& operator=(QObjectWrapper &&) = delete;
    ~QObjectWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    static void sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event);
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    static void sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    static bool sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    static bool sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event);
    bool isSignalConnected_protected(const ::QMetaMethod & signal) const { return QObject::isSignalConnected(signal); }
    int receivers_protected(const char * signal) const { return QObject::receivers(signal); }
    ::QObject * sender_protected() const { return QObject::sender(); }
    int senderSignalIndex_protected() const { return QObject::senderSignalIndex(); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    static void sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QOBJECTWRAPPER_H

#endif // SBK_NETWORKMANAGERWRAPPER_H
