// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets detailed information about the individual batches within an import task,
// including their status and any error messages. For CloudTrail Event Data Store
// sources, a batch refers to a subset of stored events grouped by their eventTime.
func (c *Client) DescribeImportTaskBatches(ctx context.Context, params *DescribeImportTaskBatchesInput, optFns ...func(*Options)) (*DescribeImportTaskBatchesOutput, error) {
	if params == nil {
		params = &DescribeImportTaskBatchesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeImportTaskBatches", params, optFns, c.addOperationDescribeImportTaskBatchesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeImportTaskBatchesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeImportTaskBatchesInput struct {

	// The ID of the import task to get batch information for.
	//
	// This member is required.
	ImportId *string

	// Optional filter to list import batches by their status. Accepts multiple status
	// values: IN_PROGRESS, CANCELLED, COMPLETED and FAILED.
	BatchImportStatus []types.ImportStatus

	// The maximum number of import batches to return in the response. Default: 10
	Limit *int32

	// The pagination token for the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeImportTaskBatchesOutput struct {

	// The list of import batches that match the request filters.
	ImportBatches []types.ImportBatch

	// The ID of the import task.
	ImportId *string

	// The ARN of the source being imported from.
	ImportSourceArn *string

	// The token to use when requesting the next set of results. Not present if there
	// are no additional results to retrieve.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeImportTaskBatchesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeImportTaskBatches{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeImportTaskBatches{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeImportTaskBatches"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeImportTaskBatchesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeImportTaskBatches(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeImportTaskBatches(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeImportTaskBatches",
	}
}
