
// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/******************************************************************

DO NOT MODIFY. AUTOGENERATED FILE.
This file is generated using the logic from <root>/src/scripts/genEventing.py

******************************************************************/
#include "clrxplatevents.h"
#include "clreventpipewriteevents.h"
inline BOOL EventEnabledGCStart(void) {return EventPipeEventEnabledGCStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCStart());}

inline ULONG FireEtwGCStart(
    const unsigned int  Count,
    const unsigned int  Reason,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCStart(Count,Reason,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCStart(Count,Reason);
    return status;
}

inline BOOL EventEnabledGCStart_V1(void) {return EventPipeEventEnabledGCStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCStart_V1());}

inline ULONG FireEtwGCStart_V1(
    const unsigned int  Count,
    const unsigned int  Depth,
    const unsigned int  Reason,
    const unsigned int  Type,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCStart_V1(Count,Depth,Reason,Type,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCStart_V1(Count,Depth,Reason,Type,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCStart_V2(void) {return EventPipeEventEnabledGCStart_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCStart_V2());}

inline ULONG FireEtwGCStart_V2(
    const unsigned int  Count,
    const unsigned int  Depth,
    const unsigned int  Reason,
    const unsigned int  Type,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ClientSequenceNumber,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCStart_V2(Count,Depth,Reason,Type,ClrInstanceID,ClientSequenceNumber,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCStart_V2(Count,Depth,Reason,Type,ClrInstanceID,ClientSequenceNumber);
    return status;
}

inline BOOL EventEnabledGCEnd(void) {return EventPipeEventEnabledGCEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCEnd());}

inline ULONG FireEtwGCEnd(
    const unsigned int  Count,
    const unsigned short  Depth,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCEnd(Count,Depth,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCEnd(Count,Depth);
    return status;
}

inline BOOL EventEnabledGCEnd_V1(void) {return EventPipeEventEnabledGCEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCEnd_V1());}

inline ULONG FireEtwGCEnd_V1(
    const unsigned int  Count,
    const unsigned int  Depth,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCEnd_V1(Count,Depth,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCEnd_V1(Count,Depth,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCRestartEEEnd(void) {return EventPipeEventEnabledGCRestartEEEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCRestartEEEnd());}

inline ULONG FireEtwGCRestartEEEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCRestartEEEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatGCRestartEEEnd();
    return status;
}

inline BOOL EventEnabledGCRestartEEEnd_V1(void) {return EventPipeEventEnabledGCRestartEEEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCRestartEEEnd_V1());}

inline ULONG FireEtwGCRestartEEEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCRestartEEEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCRestartEEEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCHeapStats(void) {return EventPipeEventEnabledGCHeapStats() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCHeapStats());}

inline ULONG FireEtwGCHeapStats(
    const unsigned __int64  GenerationSize0,
    const unsigned __int64  TotalPromotedSize0,
    const unsigned __int64  GenerationSize1,
    const unsigned __int64  TotalPromotedSize1,
    const unsigned __int64  GenerationSize2,
    const unsigned __int64  TotalPromotedSize2,
    const unsigned __int64  GenerationSize3,
    const unsigned __int64  TotalPromotedSize3,
    const unsigned __int64  FinalizationPromotedSize,
    const unsigned __int64  FinalizationPromotedCount,
    const unsigned int  PinnedObjectCount,
    const unsigned int  SinkBlockCount,
    const unsigned int  GCHandleCount,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCHeapStats(GenerationSize0,TotalPromotedSize0,GenerationSize1,TotalPromotedSize1,GenerationSize2,TotalPromotedSize2,GenerationSize3,TotalPromotedSize3,FinalizationPromotedSize,FinalizationPromotedCount,PinnedObjectCount,SinkBlockCount,GCHandleCount,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCHeapStats(GenerationSize0,TotalPromotedSize0,GenerationSize1,TotalPromotedSize1,GenerationSize2,TotalPromotedSize2,GenerationSize3,TotalPromotedSize3,FinalizationPromotedSize,FinalizationPromotedCount,PinnedObjectCount,SinkBlockCount,GCHandleCount);
    return status;
}

inline BOOL EventEnabledGCHeapStats_V1(void) {return EventPipeEventEnabledGCHeapStats_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCHeapStats_V1());}

inline ULONG FireEtwGCHeapStats_V1(
    const unsigned __int64  GenerationSize0,
    const unsigned __int64  TotalPromotedSize0,
    const unsigned __int64  GenerationSize1,
    const unsigned __int64  TotalPromotedSize1,
    const unsigned __int64  GenerationSize2,
    const unsigned __int64  TotalPromotedSize2,
    const unsigned __int64  GenerationSize3,
    const unsigned __int64  TotalPromotedSize3,
    const unsigned __int64  FinalizationPromotedSize,
    const unsigned __int64  FinalizationPromotedCount,
    const unsigned int  PinnedObjectCount,
    const unsigned int  SinkBlockCount,
    const unsigned int  GCHandleCount,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCHeapStats_V1(GenerationSize0,TotalPromotedSize0,GenerationSize1,TotalPromotedSize1,GenerationSize2,TotalPromotedSize2,GenerationSize3,TotalPromotedSize3,FinalizationPromotedSize,FinalizationPromotedCount,PinnedObjectCount,SinkBlockCount,GCHandleCount,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCHeapStats_V1(GenerationSize0,TotalPromotedSize0,GenerationSize1,TotalPromotedSize1,GenerationSize2,TotalPromotedSize2,GenerationSize3,TotalPromotedSize3,FinalizationPromotedSize,FinalizationPromotedCount,PinnedObjectCount,SinkBlockCount,GCHandleCount,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCHeapStats_V2(void) {return EventPipeEventEnabledGCHeapStats_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCHeapStats_V2());}

inline ULONG FireEtwGCHeapStats_V2(
    const unsigned __int64  GenerationSize0,
    const unsigned __int64  TotalPromotedSize0,
    const unsigned __int64  GenerationSize1,
    const unsigned __int64  TotalPromotedSize1,
    const unsigned __int64  GenerationSize2,
    const unsigned __int64  TotalPromotedSize2,
    const unsigned __int64  GenerationSize3,
    const unsigned __int64  TotalPromotedSize3,
    const unsigned __int64  FinalizationPromotedSize,
    const unsigned __int64  FinalizationPromotedCount,
    const unsigned int  PinnedObjectCount,
    const unsigned int  SinkBlockCount,
    const unsigned int  GCHandleCount,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  GenerationSize4,
    const unsigned __int64  TotalPromotedSize4,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCHeapStats_V2(GenerationSize0,TotalPromotedSize0,GenerationSize1,TotalPromotedSize1,GenerationSize2,TotalPromotedSize2,GenerationSize3,TotalPromotedSize3,FinalizationPromotedSize,FinalizationPromotedCount,PinnedObjectCount,SinkBlockCount,GCHandleCount,ClrInstanceID,GenerationSize4,TotalPromotedSize4,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCHeapStats_V2(GenerationSize0,TotalPromotedSize0,GenerationSize1,TotalPromotedSize1,GenerationSize2,TotalPromotedSize2,GenerationSize3,TotalPromotedSize3,FinalizationPromotedSize,FinalizationPromotedCount,PinnedObjectCount,SinkBlockCount,GCHandleCount,ClrInstanceID,GenerationSize4,TotalPromotedSize4);
    return status;
}

inline BOOL EventEnabledGCCreateSegment(void) {return EventPipeEventEnabledGCCreateSegment() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCCreateSegment());}

inline ULONG FireEtwGCCreateSegment(
    const unsigned __int64  Address,
    const unsigned __int64  Size,
    const unsigned int  Type,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCCreateSegment(Address,Size,Type,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCCreateSegment(Address,Size,Type);
    return status;
}

inline BOOL EventEnabledGCCreateSegment_V1(void) {return EventPipeEventEnabledGCCreateSegment_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCCreateSegment_V1());}

inline ULONG FireEtwGCCreateSegment_V1(
    const unsigned __int64  Address,
    const unsigned __int64  Size,
    const unsigned int  Type,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCCreateSegment_V1(Address,Size,Type,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCCreateSegment_V1(Address,Size,Type,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCFreeSegment(void) {return EventPipeEventEnabledGCFreeSegment() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCFreeSegment());}

inline ULONG FireEtwGCFreeSegment(
    const unsigned __int64  Address,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCFreeSegment(Address,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCFreeSegment(Address);
    return status;
}

inline BOOL EventEnabledGCFreeSegment_V1(void) {return EventPipeEventEnabledGCFreeSegment_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCFreeSegment_V1());}

inline ULONG FireEtwGCFreeSegment_V1(
    const unsigned __int64  Address,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCFreeSegment_V1(Address,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCFreeSegment_V1(Address,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCRestartEEBegin(void) {return EventPipeEventEnabledGCRestartEEBegin() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCRestartEEBegin());}

inline ULONG FireEtwGCRestartEEBegin(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCRestartEEBegin(ActivityId,RelatedActivityId);
    status &= FireEtXplatGCRestartEEBegin();
    return status;
}

inline BOOL EventEnabledGCRestartEEBegin_V1(void) {return EventPipeEventEnabledGCRestartEEBegin_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCRestartEEBegin_V1());}

inline ULONG FireEtwGCRestartEEBegin_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCRestartEEBegin_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCRestartEEBegin_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCSuspendEEEnd(void) {return EventPipeEventEnabledGCSuspendEEEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCSuspendEEEnd());}

inline ULONG FireEtwGCSuspendEEEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCSuspendEEEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatGCSuspendEEEnd();
    return status;
}

inline BOOL EventEnabledGCSuspendEEEnd_V1(void) {return EventPipeEventEnabledGCSuspendEEEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCSuspendEEEnd_V1());}

inline ULONG FireEtwGCSuspendEEEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCSuspendEEEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCSuspendEEEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCSuspendEEBegin(void) {return EventPipeEventEnabledGCSuspendEEBegin() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCSuspendEEBegin());}

inline ULONG FireEtwGCSuspendEEBegin(
    const unsigned short  Reason,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCSuspendEEBegin(Reason,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCSuspendEEBegin(Reason);
    return status;
}

inline BOOL EventEnabledGCSuspendEEBegin_V1(void) {return EventPipeEventEnabledGCSuspendEEBegin_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCSuspendEEBegin_V1());}

inline ULONG FireEtwGCSuspendEEBegin_V1(
    const unsigned int  Reason,
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCSuspendEEBegin_V1(Reason,Count,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCSuspendEEBegin_V1(Reason,Count,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCAllocationTick(void) {return EventPipeEventEnabledGCAllocationTick() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCAllocationTick());}

inline ULONG FireEtwGCAllocationTick(
    const unsigned int  AllocationAmount,
    const unsigned int  AllocationKind,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCAllocationTick(AllocationAmount,AllocationKind,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCAllocationTick(AllocationAmount,AllocationKind);
    return status;
}

inline BOOL EventEnabledGCAllocationTick_V1(void) {return EventPipeEventEnabledGCAllocationTick_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCAllocationTick_V1());}

inline ULONG FireEtwGCAllocationTick_V1(
    const unsigned int  AllocationAmount,
    const unsigned int  AllocationKind,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCAllocationTick_V1(AllocationAmount,AllocationKind,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCAllocationTick_V1(AllocationAmount,AllocationKind,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCAllocationTick_V2(void) {return EventPipeEventEnabledGCAllocationTick_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCAllocationTick_V2());}

inline ULONG FireEtwGCAllocationTick_V2(
    const unsigned int  AllocationAmount,
    const unsigned int  AllocationKind,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  AllocationAmount64,
    const void*  TypeID,
    PCWSTR  TypeName,
    const unsigned int  HeapIndex,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCAllocationTick_V2(AllocationAmount,AllocationKind,ClrInstanceID,AllocationAmount64,TypeID,TypeName,HeapIndex,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCAllocationTick_V2(AllocationAmount,AllocationKind,ClrInstanceID,AllocationAmount64,TypeID,TypeName,HeapIndex);
    return status;
}

inline BOOL EventEnabledGCAllocationTick_V3(void) {return EventPipeEventEnabledGCAllocationTick_V3() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCAllocationTick_V3());}

inline ULONG FireEtwGCAllocationTick_V3(
    const unsigned int  AllocationAmount,
    const unsigned int  AllocationKind,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  AllocationAmount64,
    const void*  TypeID,
    PCWSTR  TypeName,
    const unsigned int  HeapIndex,
    const void*  Address,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCAllocationTick_V3(AllocationAmount,AllocationKind,ClrInstanceID,AllocationAmount64,TypeID,TypeName,HeapIndex,Address,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCAllocationTick_V3(AllocationAmount,AllocationKind,ClrInstanceID,AllocationAmount64,TypeID,TypeName,HeapIndex,Address);
    return status;
}

inline BOOL EventEnabledGCAllocationTick_V4(void) {return EventPipeEventEnabledGCAllocationTick_V4() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCAllocationTick_V4());}

inline ULONG FireEtwGCAllocationTick_V4(
    const unsigned int  AllocationAmount,
    const unsigned int  AllocationKind,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  AllocationAmount64,
    const void*  TypeID,
    PCWSTR  TypeName,
    const unsigned int  HeapIndex,
    const void*  Address,
    const unsigned __int64  ObjectSize,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCAllocationTick_V4(AllocationAmount,AllocationKind,ClrInstanceID,AllocationAmount64,TypeID,TypeName,HeapIndex,Address,ObjectSize,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCAllocationTick_V4(AllocationAmount,AllocationKind,ClrInstanceID,AllocationAmount64,TypeID,TypeName,HeapIndex,Address,ObjectSize);
    return status;
}

inline BOOL EventEnabledGCCreateConcurrentThread(void) {return EventPipeEventEnabledGCCreateConcurrentThread() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCCreateConcurrentThread());}

inline ULONG FireEtwGCCreateConcurrentThread(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCCreateConcurrentThread(ActivityId,RelatedActivityId);
    status &= FireEtXplatGCCreateConcurrentThread();
    return status;
}

inline BOOL EventEnabledGCCreateConcurrentThread_V1(void) {return EventPipeEventEnabledGCCreateConcurrentThread_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCCreateConcurrentThread_V1());}

inline ULONG FireEtwGCCreateConcurrentThread_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCCreateConcurrentThread_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCCreateConcurrentThread_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCTerminateConcurrentThread(void) {return EventPipeEventEnabledGCTerminateConcurrentThread() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCTerminateConcurrentThread());}

inline ULONG FireEtwGCTerminateConcurrentThread(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCTerminateConcurrentThread(ActivityId,RelatedActivityId);
    status &= FireEtXplatGCTerminateConcurrentThread();
    return status;
}

inline BOOL EventEnabledGCTerminateConcurrentThread_V1(void) {return EventPipeEventEnabledGCTerminateConcurrentThread_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCTerminateConcurrentThread_V1());}

inline ULONG FireEtwGCTerminateConcurrentThread_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCTerminateConcurrentThread_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCTerminateConcurrentThread_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCFinalizersEnd(void) {return EventPipeEventEnabledGCFinalizersEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCFinalizersEnd());}

inline ULONG FireEtwGCFinalizersEnd(
    const unsigned int  Count,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCFinalizersEnd(Count,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCFinalizersEnd(Count);
    return status;
}

inline BOOL EventEnabledGCFinalizersEnd_V1(void) {return EventPipeEventEnabledGCFinalizersEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCFinalizersEnd_V1());}

inline ULONG FireEtwGCFinalizersEnd_V1(
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCFinalizersEnd_V1(Count,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCFinalizersEnd_V1(Count,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCFinalizersBegin(void) {return EventPipeEventEnabledGCFinalizersBegin() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCFinalizersBegin());}

inline ULONG FireEtwGCFinalizersBegin(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCFinalizersBegin(ActivityId,RelatedActivityId);
    status &= FireEtXplatGCFinalizersBegin();
    return status;
}

inline BOOL EventEnabledGCFinalizersBegin_V1(void) {return EventPipeEventEnabledGCFinalizersBegin_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCFinalizersBegin_V1());}

inline ULONG FireEtwGCFinalizersBegin_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCFinalizersBegin_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCFinalizersBegin_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBulkType(void) {return EventPipeEventEnabledBulkType() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBulkType());}

inline ULONG FireEtwBulkType(
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBulkType(Count,ClrInstanceID,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatBulkType(Count,ClrInstanceID,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCBulkRootEdge(void) {return EventPipeEventEnabledGCBulkRootEdge() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCBulkRootEdge());}

inline ULONG FireEtwGCBulkRootEdge(
    const unsigned int  Index,
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCBulkRootEdge(Index,Count,ClrInstanceID,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCBulkRootEdge(Index,Count,ClrInstanceID,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCBulkRootConditionalWeakTableElementEdge(void) {return EventPipeEventEnabledGCBulkRootConditionalWeakTableElementEdge() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCBulkRootConditionalWeakTableElementEdge());}

inline ULONG FireEtwGCBulkRootConditionalWeakTableElementEdge(
    const unsigned int  Index,
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCBulkRootConditionalWeakTableElementEdge(Index,Count,ClrInstanceID,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCBulkRootConditionalWeakTableElementEdge(Index,Count,ClrInstanceID,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCBulkNode(void) {return EventPipeEventEnabledGCBulkNode() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCBulkNode());}

inline ULONG FireEtwGCBulkNode(
    const unsigned int  Index,
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCBulkNode(Index,Count,ClrInstanceID,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCBulkNode(Index,Count,ClrInstanceID,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCBulkEdge(void) {return EventPipeEventEnabledGCBulkEdge() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCBulkEdge());}

inline ULONG FireEtwGCBulkEdge(
    const unsigned int  Index,
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCBulkEdge(Index,Count,ClrInstanceID,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCBulkEdge(Index,Count,ClrInstanceID,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCSampledObjectAllocationHigh(void) {return EventPipeEventEnabledGCSampledObjectAllocationHigh() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCSampledObjectAllocationHigh());}

inline ULONG FireEtwGCSampledObjectAllocationHigh(
    const void*  Address,
    const void*  TypeID,
    const unsigned int  ObjectCountForTypeSample,
    const unsigned __int64  TotalSizeForTypeSample,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCSampledObjectAllocationHigh(Address,TypeID,ObjectCountForTypeSample,TotalSizeForTypeSample,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCSampledObjectAllocationHigh(Address,TypeID,ObjectCountForTypeSample,TotalSizeForTypeSample,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCBulkSurvivingObjectRanges(void) {return EventPipeEventEnabledGCBulkSurvivingObjectRanges() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCBulkSurvivingObjectRanges());}

inline ULONG FireEtwGCBulkSurvivingObjectRanges(
    const unsigned int  Index,
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCBulkSurvivingObjectRanges(Index,Count,ClrInstanceID,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCBulkSurvivingObjectRanges(Index,Count,ClrInstanceID,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCBulkMovedObjectRanges(void) {return EventPipeEventEnabledGCBulkMovedObjectRanges() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCBulkMovedObjectRanges());}

inline ULONG FireEtwGCBulkMovedObjectRanges(
    const unsigned int  Index,
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCBulkMovedObjectRanges(Index,Count,ClrInstanceID,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCBulkMovedObjectRanges(Index,Count,ClrInstanceID,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCGenerationRange(void) {return EventPipeEventEnabledGCGenerationRange() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCGenerationRange());}

inline ULONG FireEtwGCGenerationRange(
    const unsigned char  Generation,
    const void*  RangeStart,
    const unsigned __int64  RangeUsedLength,
    const unsigned __int64  RangeReservedLength,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCGenerationRange(Generation,RangeStart,RangeUsedLength,RangeReservedLength,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCGenerationRange(Generation,RangeStart,RangeUsedLength,RangeReservedLength,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCMarkStackRoots(void) {return EventPipeEventEnabledGCMarkStackRoots() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCMarkStackRoots());}

inline ULONG FireEtwGCMarkStackRoots(
    const unsigned int  HeapNum,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCMarkStackRoots(HeapNum,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCMarkStackRoots(HeapNum,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCMarkFinalizeQueueRoots(void) {return EventPipeEventEnabledGCMarkFinalizeQueueRoots() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCMarkFinalizeQueueRoots());}

inline ULONG FireEtwGCMarkFinalizeQueueRoots(
    const unsigned int  HeapNum,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCMarkFinalizeQueueRoots(HeapNum,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCMarkFinalizeQueueRoots(HeapNum,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCMarkHandles(void) {return EventPipeEventEnabledGCMarkHandles() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCMarkHandles());}

inline ULONG FireEtwGCMarkHandles(
    const unsigned int  HeapNum,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCMarkHandles(HeapNum,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCMarkHandles(HeapNum,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCMarkOlderGenerationRoots(void) {return EventPipeEventEnabledGCMarkOlderGenerationRoots() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCMarkOlderGenerationRoots());}

inline ULONG FireEtwGCMarkOlderGenerationRoots(
    const unsigned int  HeapNum,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCMarkOlderGenerationRoots(HeapNum,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCMarkOlderGenerationRoots(HeapNum,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFinalizeObject(void) {return EventPipeEventEnabledFinalizeObject() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFinalizeObject());}

inline ULONG FireEtwFinalizeObject(
    const void*  TypeID,
    const void*  ObjectID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFinalizeObject(TypeID,ObjectID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFinalizeObject(TypeID,ObjectID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledSetGCHandle(void) {return EventPipeEventEnabledSetGCHandle() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledSetGCHandle());}

inline ULONG FireEtwSetGCHandle(
    const void*  HandleID,
    const void*  ObjectID,
    const unsigned int  Kind,
    const unsigned int  Generation,
    const unsigned __int64  AppDomainID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventSetGCHandle(HandleID,ObjectID,Kind,Generation,AppDomainID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatSetGCHandle(HandleID,ObjectID,Kind,Generation,AppDomainID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledDestroyGCHandle(void) {return EventPipeEventEnabledDestroyGCHandle() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDestroyGCHandle());}

inline ULONG FireEtwDestroyGCHandle(
    const void*  HandleID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDestroyGCHandle(HandleID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatDestroyGCHandle(HandleID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCSampledObjectAllocationLow(void) {return EventPipeEventEnabledGCSampledObjectAllocationLow() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCSampledObjectAllocationLow());}

inline ULONG FireEtwGCSampledObjectAllocationLow(
    const void*  Address,
    const void*  TypeID,
    const unsigned int  ObjectCountForTypeSample,
    const unsigned __int64  TotalSizeForTypeSample,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCSampledObjectAllocationLow(Address,TypeID,ObjectCountForTypeSample,TotalSizeForTypeSample,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCSampledObjectAllocationLow(Address,TypeID,ObjectCountForTypeSample,TotalSizeForTypeSample,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledPinObjectAtGCTime(void) {return EventPipeEventEnabledPinObjectAtGCTime() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPinObjectAtGCTime());}

inline ULONG FireEtwPinObjectAtGCTime(
    const void*  HandleID,
    const void*  ObjectID,
    const unsigned __int64  ObjectSize,
    PCWSTR  TypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPinObjectAtGCTime(HandleID,ObjectID,ObjectSize,TypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatPinObjectAtGCTime(HandleID,ObjectID,ObjectSize,TypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCTriggered(void) {return EventPipeEventEnabledGCTriggered() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCTriggered());}

inline ULONG FireEtwGCTriggered(
    const unsigned int  Reason,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCTriggered(Reason,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCTriggered(Reason,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCBulkRootCCW(void) {return EventPipeEventEnabledGCBulkRootCCW() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCBulkRootCCW());}

inline ULONG FireEtwGCBulkRootCCW(
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCBulkRootCCW(Count,ClrInstanceID,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCBulkRootCCW(Count,ClrInstanceID,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCBulkRCW(void) {return EventPipeEventEnabledGCBulkRCW() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCBulkRCW());}

inline ULONG FireEtwGCBulkRCW(
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCBulkRCW(Count,ClrInstanceID,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCBulkRCW(Count,ClrInstanceID,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCBulkRootStaticVar(void) {return EventPipeEventEnabledGCBulkRootStaticVar() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCBulkRootStaticVar());}

inline ULONG FireEtwGCBulkRootStaticVar(
    const unsigned int  Count,
    const unsigned __int64  AppDomainID,
    const unsigned short  ClrInstanceID,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCBulkRootStaticVar(Count,AppDomainID,ClrInstanceID,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCBulkRootStaticVar(Count,AppDomainID,ClrInstanceID,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCDynamicEvent(void) {return EventPipeEventEnabledGCDynamicEvent() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCDynamicEvent());}

inline ULONG FireEtwGCDynamicEvent(
    PCWSTR  Name,
    const unsigned int  DataSize,
    const BYTE* Data,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCDynamicEvent(Name,DataSize,Data,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCDynamicEvent(Name,DataSize,Data,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledWorkerThreadCreate(void) {return EventPipeEventEnabledWorkerThreadCreate() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledWorkerThreadCreate());}

inline ULONG FireEtwWorkerThreadCreate(
    const unsigned int  WorkerThreadCount,
    const unsigned int  RetiredWorkerThreads,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventWorkerThreadCreate(WorkerThreadCount,RetiredWorkerThreads,ActivityId,RelatedActivityId);
    status &= FireEtXplatWorkerThreadCreate(WorkerThreadCount,RetiredWorkerThreads);
    return status;
}

inline BOOL EventEnabledWorkerThreadTerminate(void) {return EventPipeEventEnabledWorkerThreadTerminate() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledWorkerThreadTerminate());}

inline ULONG FireEtwWorkerThreadTerminate(
    const unsigned int  WorkerThreadCount,
    const unsigned int  RetiredWorkerThreads,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventWorkerThreadTerminate(WorkerThreadCount,RetiredWorkerThreads,ActivityId,RelatedActivityId);
    status &= FireEtXplatWorkerThreadTerminate(WorkerThreadCount,RetiredWorkerThreads);
    return status;
}

inline BOOL EventEnabledWorkerThreadRetire(void) {return EventPipeEventEnabledWorkerThreadRetire() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledWorkerThreadRetire());}

inline ULONG FireEtwWorkerThreadRetire(
    const unsigned int  WorkerThreadCount,
    const unsigned int  RetiredWorkerThreads,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventWorkerThreadRetire(WorkerThreadCount,RetiredWorkerThreads,ActivityId,RelatedActivityId);
    status &= FireEtXplatWorkerThreadRetire(WorkerThreadCount,RetiredWorkerThreads);
    return status;
}

inline BOOL EventEnabledWorkerThreadUnretire(void) {return EventPipeEventEnabledWorkerThreadUnretire() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledWorkerThreadUnretire());}

inline ULONG FireEtwWorkerThreadUnretire(
    const unsigned int  WorkerThreadCount,
    const unsigned int  RetiredWorkerThreads,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventWorkerThreadUnretire(WorkerThreadCount,RetiredWorkerThreads,ActivityId,RelatedActivityId);
    status &= FireEtXplatWorkerThreadUnretire(WorkerThreadCount,RetiredWorkerThreads);
    return status;
}

inline BOOL EventEnabledIOThreadCreate(void) {return EventPipeEventEnabledIOThreadCreate() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledIOThreadCreate());}

inline ULONG FireEtwIOThreadCreate(
    const unsigned int  IOThreadCount,
    const unsigned int  RetiredIOThreads,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventIOThreadCreate(IOThreadCount,RetiredIOThreads,ActivityId,RelatedActivityId);
    status &= FireEtXplatIOThreadCreate(IOThreadCount,RetiredIOThreads);
    return status;
}

inline BOOL EventEnabledIOThreadCreate_V1(void) {return EventPipeEventEnabledIOThreadCreate_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledIOThreadCreate_V1());}

inline ULONG FireEtwIOThreadCreate_V1(
    const unsigned int  IOThreadCount,
    const unsigned int  RetiredIOThreads,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventIOThreadCreate_V1(IOThreadCount,RetiredIOThreads,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatIOThreadCreate_V1(IOThreadCount,RetiredIOThreads,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledIOThreadTerminate(void) {return EventPipeEventEnabledIOThreadTerminate() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledIOThreadTerminate());}

inline ULONG FireEtwIOThreadTerminate(
    const unsigned int  IOThreadCount,
    const unsigned int  RetiredIOThreads,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventIOThreadTerminate(IOThreadCount,RetiredIOThreads,ActivityId,RelatedActivityId);
    status &= FireEtXplatIOThreadTerminate(IOThreadCount,RetiredIOThreads);
    return status;
}

inline BOOL EventEnabledIOThreadTerminate_V1(void) {return EventPipeEventEnabledIOThreadTerminate_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledIOThreadTerminate_V1());}

inline ULONG FireEtwIOThreadTerminate_V1(
    const unsigned int  IOThreadCount,
    const unsigned int  RetiredIOThreads,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventIOThreadTerminate_V1(IOThreadCount,RetiredIOThreads,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatIOThreadTerminate_V1(IOThreadCount,RetiredIOThreads,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledIOThreadRetire(void) {return EventPipeEventEnabledIOThreadRetire() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledIOThreadRetire());}

inline ULONG FireEtwIOThreadRetire(
    const unsigned int  IOThreadCount,
    const unsigned int  RetiredIOThreads,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventIOThreadRetire(IOThreadCount,RetiredIOThreads,ActivityId,RelatedActivityId);
    status &= FireEtXplatIOThreadRetire(IOThreadCount,RetiredIOThreads);
    return status;
}

inline BOOL EventEnabledIOThreadRetire_V1(void) {return EventPipeEventEnabledIOThreadRetire_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledIOThreadRetire_V1());}

inline ULONG FireEtwIOThreadRetire_V1(
    const unsigned int  IOThreadCount,
    const unsigned int  RetiredIOThreads,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventIOThreadRetire_V1(IOThreadCount,RetiredIOThreads,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatIOThreadRetire_V1(IOThreadCount,RetiredIOThreads,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledIOThreadUnretire(void) {return EventPipeEventEnabledIOThreadUnretire() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledIOThreadUnretire());}

inline ULONG FireEtwIOThreadUnretire(
    const unsigned int  IOThreadCount,
    const unsigned int  RetiredIOThreads,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventIOThreadUnretire(IOThreadCount,RetiredIOThreads,ActivityId,RelatedActivityId);
    status &= FireEtXplatIOThreadUnretire(IOThreadCount,RetiredIOThreads);
    return status;
}

inline BOOL EventEnabledIOThreadUnretire_V1(void) {return EventPipeEventEnabledIOThreadUnretire_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledIOThreadUnretire_V1());}

inline ULONG FireEtwIOThreadUnretire_V1(
    const unsigned int  IOThreadCount,
    const unsigned int  RetiredIOThreads,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventIOThreadUnretire_V1(IOThreadCount,RetiredIOThreads,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatIOThreadUnretire_V1(IOThreadCount,RetiredIOThreads,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadpoolSuspensionSuspendThread(void) {return EventPipeEventEnabledThreadpoolSuspensionSuspendThread() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadpoolSuspensionSuspendThread());}

inline ULONG FireEtwThreadpoolSuspensionSuspendThread(
    const unsigned int  ClrThreadID,
    const unsigned int  CpuUtilization,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadpoolSuspensionSuspendThread(ClrThreadID,CpuUtilization,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadpoolSuspensionSuspendThread(ClrThreadID,CpuUtilization);
    return status;
}

inline BOOL EventEnabledThreadpoolSuspensionResumeThread(void) {return EventPipeEventEnabledThreadpoolSuspensionResumeThread() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadpoolSuspensionResumeThread());}

inline ULONG FireEtwThreadpoolSuspensionResumeThread(
    const unsigned int  ClrThreadID,
    const unsigned int  CpuUtilization,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadpoolSuspensionResumeThread(ClrThreadID,CpuUtilization,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadpoolSuspensionResumeThread(ClrThreadID,CpuUtilization);
    return status;
}

inline BOOL EventEnabledThreadPoolWorkerThreadStart(void) {return EventPipeEventEnabledThreadPoolWorkerThreadStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolWorkerThreadStart());}

inline ULONG FireEtwThreadPoolWorkerThreadStart(
    const unsigned int  ActiveWorkerThreadCount,
    const unsigned int  RetiredWorkerThreadCount,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolWorkerThreadStart(ActiveWorkerThreadCount,RetiredWorkerThreadCount,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolWorkerThreadStart(ActiveWorkerThreadCount,RetiredWorkerThreadCount,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolWorkerThreadStop(void) {return EventPipeEventEnabledThreadPoolWorkerThreadStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolWorkerThreadStop());}

inline ULONG FireEtwThreadPoolWorkerThreadStop(
    const unsigned int  ActiveWorkerThreadCount,
    const unsigned int  RetiredWorkerThreadCount,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolWorkerThreadStop(ActiveWorkerThreadCount,RetiredWorkerThreadCount,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolWorkerThreadStop(ActiveWorkerThreadCount,RetiredWorkerThreadCount,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolWorkerThreadRetirementStart(void) {return EventPipeEventEnabledThreadPoolWorkerThreadRetirementStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolWorkerThreadRetirementStart());}

inline ULONG FireEtwThreadPoolWorkerThreadRetirementStart(
    const unsigned int  ActiveWorkerThreadCount,
    const unsigned int  RetiredWorkerThreadCount,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolWorkerThreadRetirementStart(ActiveWorkerThreadCount,RetiredWorkerThreadCount,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolWorkerThreadRetirementStart(ActiveWorkerThreadCount,RetiredWorkerThreadCount,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolWorkerThreadRetirementStop(void) {return EventPipeEventEnabledThreadPoolWorkerThreadRetirementStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolWorkerThreadRetirementStop());}

inline ULONG FireEtwThreadPoolWorkerThreadRetirementStop(
    const unsigned int  ActiveWorkerThreadCount,
    const unsigned int  RetiredWorkerThreadCount,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolWorkerThreadRetirementStop(ActiveWorkerThreadCount,RetiredWorkerThreadCount,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolWorkerThreadRetirementStop(ActiveWorkerThreadCount,RetiredWorkerThreadCount,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolWorkerThreadAdjustmentSample(void) {return EventPipeEventEnabledThreadPoolWorkerThreadAdjustmentSample() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolWorkerThreadAdjustmentSample());}

inline ULONG FireEtwThreadPoolWorkerThreadAdjustmentSample(
    const double  Throughput,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolWorkerThreadAdjustmentSample(Throughput,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolWorkerThreadAdjustmentSample(Throughput,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolWorkerThreadAdjustmentAdjustment(void) {return EventPipeEventEnabledThreadPoolWorkerThreadAdjustmentAdjustment() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolWorkerThreadAdjustmentAdjustment());}

inline ULONG FireEtwThreadPoolWorkerThreadAdjustmentAdjustment(
    const double  AverageThroughput,
    const unsigned int  NewWorkerThreadCount,
    const unsigned int  Reason,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolWorkerThreadAdjustmentAdjustment(AverageThroughput,NewWorkerThreadCount,Reason,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolWorkerThreadAdjustmentAdjustment(AverageThroughput,NewWorkerThreadCount,Reason,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolWorkerThreadAdjustmentStats(void) {return EventPipeEventEnabledThreadPoolWorkerThreadAdjustmentStats() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolWorkerThreadAdjustmentStats());}

inline ULONG FireEtwThreadPoolWorkerThreadAdjustmentStats(
    const double  Duration,
    const double  Throughput,
    const double  ThreadWave,
    const double  ThroughputWave,
    const double  ThroughputErrorEstimate,
    const double  AverageThroughputErrorEstimate,
    const double  ThroughputRatio,
    const double  Confidence,
    const double  NewControlSetting,
    const unsigned short  NewThreadWaveMagnitude,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolWorkerThreadAdjustmentStats(Duration,Throughput,ThreadWave,ThroughputWave,ThroughputErrorEstimate,AverageThroughputErrorEstimate,ThroughputRatio,Confidence,NewControlSetting,NewThreadWaveMagnitude,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolWorkerThreadAdjustmentStats(Duration,Throughput,ThreadWave,ThroughputWave,ThroughputErrorEstimate,AverageThroughputErrorEstimate,ThroughputRatio,Confidence,NewControlSetting,NewThreadWaveMagnitude,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolWorkerThreadWait(void) {return EventPipeEventEnabledThreadPoolWorkerThreadWait() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolWorkerThreadWait());}

inline ULONG FireEtwThreadPoolWorkerThreadWait(
    const unsigned int  ActiveWorkerThreadCount,
    const unsigned int  RetiredWorkerThreadCount,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolWorkerThreadWait(ActiveWorkerThreadCount,RetiredWorkerThreadCount,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolWorkerThreadWait(ActiveWorkerThreadCount,RetiredWorkerThreadCount,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledYieldProcessorMeasurement(void) {return EventPipeEventEnabledYieldProcessorMeasurement() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledYieldProcessorMeasurement());}

inline ULONG FireEtwYieldProcessorMeasurement(
    const unsigned short  ClrInstanceID,
    const double  NsPerYield,
    const double  EstablishedNsPerYield,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventYieldProcessorMeasurement(ClrInstanceID,NsPerYield,EstablishedNsPerYield,ActivityId,RelatedActivityId);
    status &= FireEtXplatYieldProcessorMeasurement(ClrInstanceID,NsPerYield,EstablishedNsPerYield);
    return status;
}

inline BOOL EventEnabledThreadPoolMinMaxThreads(void) {return EventPipeEventEnabledThreadPoolMinMaxThreads() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolMinMaxThreads());}

inline ULONG FireEtwThreadPoolMinMaxThreads(
    const unsigned short  MinWorkerThreads,
    const unsigned short  MaxWorkerThreads,
    const unsigned short  MinIOCompletionThreads,
    const unsigned short  MaxIOCompletionThreads,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolMinMaxThreads(MinWorkerThreads,MaxWorkerThreads,MinIOCompletionThreads,MaxIOCompletionThreads,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolMinMaxThreads(MinWorkerThreads,MaxWorkerThreads,MinIOCompletionThreads,MaxIOCompletionThreads,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolWorkingThreadCount(void) {return EventPipeEventEnabledThreadPoolWorkingThreadCount() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolWorkingThreadCount());}

inline ULONG FireEtwThreadPoolWorkingThreadCount(
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolWorkingThreadCount(Count,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolWorkingThreadCount(Count,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolEnqueue(void) {return EventPipeEventEnabledThreadPoolEnqueue() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolEnqueue());}

inline ULONG FireEtwThreadPoolEnqueue(
    const void*  WorkID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolEnqueue(WorkID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolEnqueue(WorkID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolDequeue(void) {return EventPipeEventEnabledThreadPoolDequeue() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolDequeue());}

inline ULONG FireEtwThreadPoolDequeue(
    const void*  WorkID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolDequeue(WorkID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolDequeue(WorkID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolIOEnqueue(void) {return EventPipeEventEnabledThreadPoolIOEnqueue() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolIOEnqueue());}

inline ULONG FireEtwThreadPoolIOEnqueue(
    const void*  NativeOverlapped,
    const void*  Overlapped,
    const BOOL  MultiDequeues,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolIOEnqueue(NativeOverlapped,Overlapped,MultiDequeues,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolIOEnqueue(NativeOverlapped,Overlapped,MultiDequeues,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolIODequeue(void) {return EventPipeEventEnabledThreadPoolIODequeue() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolIODequeue());}

inline ULONG FireEtwThreadPoolIODequeue(
    const void*  NativeOverlapped,
    const void*  Overlapped,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolIODequeue(NativeOverlapped,Overlapped,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolIODequeue(NativeOverlapped,Overlapped,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadPoolIOPack(void) {return EventPipeEventEnabledThreadPoolIOPack() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadPoolIOPack());}

inline ULONG FireEtwThreadPoolIOPack(
    const void*  NativeOverlapped,
    const void*  Overlapped,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadPoolIOPack(NativeOverlapped,Overlapped,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadPoolIOPack(NativeOverlapped,Overlapped,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadCreating(void) {return EventPipeEventEnabledThreadCreating() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadCreating());}

inline ULONG FireEtwThreadCreating(
    const void*  ID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadCreating(ID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadCreating(ID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadRunning(void) {return EventPipeEventEnabledThreadRunning() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadRunning());}

inline ULONG FireEtwThreadRunning(
    const void*  ID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadRunning(ID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadRunning(ID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodDetails(void) {return EventPipeEventEnabledMethodDetails() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDetails());}

inline ULONG FireEtwMethodDetails(
    const unsigned __int64  MethodID,
    const unsigned __int64  TypeID,
    const unsigned int  MethodToken,
    const unsigned int  TypeParameterCount,
    const unsigned __int64  LoaderModuleID,
    const unsigned __int64* TypeParameters,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDetails(MethodID,TypeID,MethodToken,TypeParameterCount,LoaderModuleID,TypeParameters,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDetails(MethodID,TypeID,MethodToken,TypeParameterCount,LoaderModuleID,TypeParameters);
    return status;
}

inline BOOL EventEnabledTypeLoadStart(void) {return EventPipeEventEnabledTypeLoadStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTypeLoadStart());}

inline ULONG FireEtwTypeLoadStart(
    const unsigned int  TypeLoadStartID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTypeLoadStart(TypeLoadStartID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatTypeLoadStart(TypeLoadStartID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledTypeLoadStop(void) {return EventPipeEventEnabledTypeLoadStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTypeLoadStop());}

inline ULONG FireEtwTypeLoadStop(
    const unsigned int  TypeLoadStartID,
    const unsigned short  ClrInstanceID,
    const unsigned short  LoadLevel,
    const unsigned __int64  TypeID,
    PCWSTR  TypeName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTypeLoadStop(TypeLoadStartID,ClrInstanceID,LoadLevel,TypeID,TypeName,ActivityId,RelatedActivityId);
    status &= FireEtXplatTypeLoadStop(TypeLoadStartID,ClrInstanceID,LoadLevel,TypeID,TypeName);
    return status;
}

inline BOOL EventEnabledExceptionThrown(void) {return EventPipeEventEnabledExceptionThrown() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExceptionThrown());}

inline ULONG FireEtwExceptionThrown(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExceptionThrown(ActivityId,RelatedActivityId);
    status &= FireEtXplatExceptionThrown();
    return status;
}

inline BOOL EventEnabledExceptionThrown_V1(void) {return EventPipeEventEnabledExceptionThrown_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExceptionThrown_V1());}

inline ULONG FireEtwExceptionThrown_V1(
    PCWSTR  ExceptionType,
    PCWSTR  ExceptionMessage,
    const void*  ExceptionEIP,
    const unsigned int  ExceptionHRESULT,
    const unsigned short  ExceptionFlags,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExceptionThrown_V1(ExceptionType,ExceptionMessage,ExceptionEIP,ExceptionHRESULT,ExceptionFlags,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatExceptionThrown_V1(ExceptionType,ExceptionMessage,ExceptionEIP,ExceptionHRESULT,ExceptionFlags,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledExceptionCatchStart(void) {return EventPipeEventEnabledExceptionCatchStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExceptionCatchStart());}

inline ULONG FireEtwExceptionCatchStart(
    const unsigned __int64  EntryEIP,
    const unsigned __int64  MethodID,
    PCWSTR  MethodName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExceptionCatchStart(EntryEIP,MethodID,MethodName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatExceptionCatchStart(EntryEIP,MethodID,MethodName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledExceptionCatchStop(void) {return EventPipeEventEnabledExceptionCatchStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExceptionCatchStop());}

inline ULONG FireEtwExceptionCatchStop(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExceptionCatchStop(ActivityId,RelatedActivityId);
    status &= FireEtXplatExceptionCatchStop();
    return status;
}

inline BOOL EventEnabledExceptionFinallyStart(void) {return EventPipeEventEnabledExceptionFinallyStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExceptionFinallyStart());}

inline ULONG FireEtwExceptionFinallyStart(
    const unsigned __int64  EntryEIP,
    const unsigned __int64  MethodID,
    PCWSTR  MethodName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExceptionFinallyStart(EntryEIP,MethodID,MethodName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatExceptionFinallyStart(EntryEIP,MethodID,MethodName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledExceptionFinallyStop(void) {return EventPipeEventEnabledExceptionFinallyStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExceptionFinallyStop());}

inline ULONG FireEtwExceptionFinallyStop(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExceptionFinallyStop(ActivityId,RelatedActivityId);
    status &= FireEtXplatExceptionFinallyStop();
    return status;
}

inline BOOL EventEnabledExceptionFilterStart(void) {return EventPipeEventEnabledExceptionFilterStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExceptionFilterStart());}

inline ULONG FireEtwExceptionFilterStart(
    const unsigned __int64  EntryEIP,
    const unsigned __int64  MethodID,
    PCWSTR  MethodName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExceptionFilterStart(EntryEIP,MethodID,MethodName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatExceptionFilterStart(EntryEIP,MethodID,MethodName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledExceptionFilterStop(void) {return EventPipeEventEnabledExceptionFilterStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExceptionFilterStop());}

inline ULONG FireEtwExceptionFilterStop(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExceptionFilterStop(ActivityId,RelatedActivityId);
    status &= FireEtXplatExceptionFilterStop();
    return status;
}

inline BOOL EventEnabledExceptionThrownStop(void) {return EventPipeEventEnabledExceptionThrownStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExceptionThrownStop());}

inline ULONG FireEtwExceptionThrownStop(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExceptionThrownStop(ActivityId,RelatedActivityId);
    status &= FireEtXplatExceptionThrownStop();
    return status;
}

inline BOOL EventEnabledContention(void) {return EventPipeEventEnabledContention() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledContention());}

inline ULONG FireEtwContention(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventContention(ActivityId,RelatedActivityId);
    status &= FireEtXplatContention();
    return status;
}

inline BOOL EventEnabledContentionStart_V1(void) {return EventPipeEventEnabledContentionStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledContentionStart_V1());}

inline ULONG FireEtwContentionStart_V1(
    const unsigned char  ContentionFlags,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventContentionStart_V1(ContentionFlags,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatContentionStart_V1(ContentionFlags,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledContentionStop(void) {return EventPipeEventEnabledContentionStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledContentionStop());}

inline ULONG FireEtwContentionStop(
    const unsigned char  ContentionFlags,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventContentionStop(ContentionFlags,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatContentionStop(ContentionFlags,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledContentionStop_V1(void) {return EventPipeEventEnabledContentionStop_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledContentionStop_V1());}

inline ULONG FireEtwContentionStop_V1(
    const unsigned char  ContentionFlags,
    const unsigned short  ClrInstanceID,
    const double  DurationNs,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventContentionStop_V1(ContentionFlags,ClrInstanceID,DurationNs,ActivityId,RelatedActivityId);
    status &= FireEtXplatContentionStop_V1(ContentionFlags,ClrInstanceID,DurationNs);
    return status;
}

inline BOOL EventEnabledCLRStackWalk(void) {return EventPipeEventEnabledCLRStackWalk() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledCLRStackWalk());}

inline ULONG FireEtwCLRStackWalk(
    const unsigned short  ClrInstanceID,
    const unsigned char  Reserved1,
    const unsigned char  Reserved2,
    const unsigned int  FrameCount,
    const void** Stack,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventCLRStackWalk(ClrInstanceID,Reserved1,Reserved2,FrameCount,Stack,ActivityId,RelatedActivityId);
    status &= FireEtXplatCLRStackWalk(ClrInstanceID,Reserved1,Reserved2,FrameCount,Stack);
    return status;
}

inline BOOL EventEnabledAppDomainMemAllocated(void) {return EventPipeEventEnabledAppDomainMemAllocated() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainMemAllocated());}

inline ULONG FireEtwAppDomainMemAllocated(
    const unsigned __int64  AppDomainID,
    const unsigned __int64  Allocated,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainMemAllocated(AppDomainID,Allocated,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainMemAllocated(AppDomainID,Allocated,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAppDomainMemSurvived(void) {return EventPipeEventEnabledAppDomainMemSurvived() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainMemSurvived());}

inline ULONG FireEtwAppDomainMemSurvived(
    const unsigned __int64  AppDomainID,
    const unsigned __int64  Survived,
    const unsigned __int64  ProcessSurvived,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainMemSurvived(AppDomainID,Survived,ProcessSurvived,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainMemSurvived(AppDomainID,Survived,ProcessSurvived,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadCreated(void) {return EventPipeEventEnabledThreadCreated() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadCreated());}

inline ULONG FireEtwThreadCreated(
    const unsigned __int64  ManagedThreadID,
    const unsigned __int64  AppDomainID,
    const unsigned int  Flags,
    const unsigned int  ManagedThreadIndex,
    const unsigned int  OSThreadID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadCreated(ManagedThreadID,AppDomainID,Flags,ManagedThreadIndex,OSThreadID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadCreated(ManagedThreadID,AppDomainID,Flags,ManagedThreadIndex,OSThreadID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadTerminated(void) {return EventPipeEventEnabledThreadTerminated() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadTerminated());}

inline ULONG FireEtwThreadTerminated(
    const unsigned __int64  ManagedThreadID,
    const unsigned __int64  AppDomainID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadTerminated(ManagedThreadID,AppDomainID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadTerminated(ManagedThreadID,AppDomainID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadDomainEnter(void) {return EventPipeEventEnabledThreadDomainEnter() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadDomainEnter());}

inline ULONG FireEtwThreadDomainEnter(
    const unsigned __int64  ManagedThreadID,
    const unsigned __int64  AppDomainID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadDomainEnter(ManagedThreadID,AppDomainID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadDomainEnter(ManagedThreadID,AppDomainID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledILStubGenerated(void) {return EventPipeEventEnabledILStubGenerated() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledILStubGenerated());}

inline ULONG FireEtwILStubGenerated(
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  StubMethodID,
    const unsigned int  StubFlags,
    const unsigned int  ManagedInteropMethodToken,
    PCWSTR  ManagedInteropMethodNamespace,
    PCWSTR  ManagedInteropMethodName,
    PCWSTR  ManagedInteropMethodSignature,
    PCWSTR  NativeMethodSignature,
    PCWSTR  StubMethodSignature,
    PCWSTR  StubMethodILCode,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventILStubGenerated(ClrInstanceID,ModuleID,StubMethodID,StubFlags,ManagedInteropMethodToken,ManagedInteropMethodNamespace,ManagedInteropMethodName,ManagedInteropMethodSignature,NativeMethodSignature,StubMethodSignature,StubMethodILCode,ActivityId,RelatedActivityId);
    status &= FireEtXplatILStubGenerated(ClrInstanceID,ModuleID,StubMethodID,StubFlags,ManagedInteropMethodToken,ManagedInteropMethodNamespace,ManagedInteropMethodName,ManagedInteropMethodSignature,NativeMethodSignature,StubMethodSignature,StubMethodILCode);
    return status;
}

inline BOOL EventEnabledILStubCacheHit(void) {return EventPipeEventEnabledILStubCacheHit() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledILStubCacheHit());}

inline ULONG FireEtwILStubCacheHit(
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  StubMethodID,
    const unsigned int  ManagedInteropMethodToken,
    PCWSTR  ManagedInteropMethodNamespace,
    PCWSTR  ManagedInteropMethodName,
    PCWSTR  ManagedInteropMethodSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventILStubCacheHit(ClrInstanceID,ModuleID,StubMethodID,ManagedInteropMethodToken,ManagedInteropMethodNamespace,ManagedInteropMethodName,ManagedInteropMethodSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatILStubCacheHit(ClrInstanceID,ModuleID,StubMethodID,ManagedInteropMethodToken,ManagedInteropMethodNamespace,ManagedInteropMethodName,ManagedInteropMethodSignature);
    return status;
}

inline BOOL EventEnabledDCStartCompleteV2(void) {return EventPipeEventEnabledDCStartCompleteV2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDCStartCompleteV2());}

inline ULONG FireEtwDCStartCompleteV2(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDCStartCompleteV2(ActivityId,RelatedActivityId);
    status &= FireEtXplatDCStartCompleteV2();
    return status;
}

inline BOOL EventEnabledDCEndCompleteV2(void) {return EventPipeEventEnabledDCEndCompleteV2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDCEndCompleteV2());}

inline ULONG FireEtwDCEndCompleteV2(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDCEndCompleteV2(ActivityId,RelatedActivityId);
    status &= FireEtXplatDCEndCompleteV2();
    return status;
}

inline BOOL EventEnabledMethodDCStartV2(void) {return EventPipeEventEnabledMethodDCStartV2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCStartV2());}

inline ULONG FireEtwMethodDCStartV2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCStartV2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCStartV2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags);
    return status;
}

inline BOOL EventEnabledMethodDCEndV2(void) {return EventPipeEventEnabledMethodDCEndV2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCEndV2());}

inline ULONG FireEtwMethodDCEndV2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCEndV2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCEndV2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags);
    return status;
}

inline BOOL EventEnabledMethodDCStartVerboseV2(void) {return EventPipeEventEnabledMethodDCStartVerboseV2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCStartVerboseV2());}

inline ULONG FireEtwMethodDCStartVerboseV2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCStartVerboseV2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCStartVerboseV2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature);
    return status;
}

inline BOOL EventEnabledMethodDCEndVerboseV2(void) {return EventPipeEventEnabledMethodDCEndVerboseV2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCEndVerboseV2());}

inline ULONG FireEtwMethodDCEndVerboseV2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCEndVerboseV2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCEndVerboseV2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature);
    return status;
}

inline BOOL EventEnabledMethodLoad(void) {return EventPipeEventEnabledMethodLoad() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodLoad());}

inline ULONG FireEtwMethodLoad(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodLoad(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodLoad(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags);
    return status;
}

inline BOOL EventEnabledMethodLoad_V1(void) {return EventPipeEventEnabledMethodLoad_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodLoad_V1());}

inline ULONG FireEtwMethodLoad_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodLoad_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodLoad_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodLoad_V2(void) {return EventPipeEventEnabledMethodLoad_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodLoad_V2());}

inline ULONG FireEtwMethodLoad_V2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ReJITID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodLoad_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ReJITID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodLoad_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ReJITID);
    return status;
}

inline BOOL EventEnabledR2RGetEntryPoint(void) {return EventPipeEventEnabledR2RGetEntryPoint() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledR2RGetEntryPoint());}

inline ULONG FireEtwR2RGetEntryPoint(
    const unsigned __int64  MethodID,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const unsigned __int64  EntryPoint,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventR2RGetEntryPoint(MethodID,MethodNamespace,MethodName,MethodSignature,EntryPoint,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatR2RGetEntryPoint(MethodID,MethodNamespace,MethodName,MethodSignature,EntryPoint,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledR2RGetEntryPointStart(void) {return EventPipeEventEnabledR2RGetEntryPointStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledR2RGetEntryPointStart());}

inline ULONG FireEtwR2RGetEntryPointStart(
    const unsigned __int64  MethodID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventR2RGetEntryPointStart(MethodID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatR2RGetEntryPointStart(MethodID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodUnload(void) {return EventPipeEventEnabledMethodUnload() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodUnload());}

inline ULONG FireEtwMethodUnload(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodUnload(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodUnload(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags);
    return status;
}

inline BOOL EventEnabledMethodUnload_V1(void) {return EventPipeEventEnabledMethodUnload_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodUnload_V1());}

inline ULONG FireEtwMethodUnload_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodUnload_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodUnload_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodUnload_V2(void) {return EventPipeEventEnabledMethodUnload_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodUnload_V2());}

inline ULONG FireEtwMethodUnload_V2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ReJITID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodUnload_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ReJITID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodUnload_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ReJITID);
    return status;
}

inline BOOL EventEnabledMethodLoadVerbose(void) {return EventPipeEventEnabledMethodLoadVerbose() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodLoadVerbose());}

inline ULONG FireEtwMethodLoadVerbose(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodLoadVerbose(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodLoadVerbose(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature);
    return status;
}

inline BOOL EventEnabledMethodLoadVerbose_V1(void) {return EventPipeEventEnabledMethodLoadVerbose_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodLoadVerbose_V1());}

inline ULONG FireEtwMethodLoadVerbose_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodLoadVerbose_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodLoadVerbose_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodLoadVerbose_V2(void) {return EventPipeEventEnabledMethodLoadVerbose_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodLoadVerbose_V2());}

inline ULONG FireEtwMethodLoadVerbose_V2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ReJITID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodLoadVerbose_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ReJITID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodLoadVerbose_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ReJITID);
    return status;
}

inline BOOL EventEnabledMethodUnloadVerbose(void) {return EventPipeEventEnabledMethodUnloadVerbose() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodUnloadVerbose());}

inline ULONG FireEtwMethodUnloadVerbose(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodUnloadVerbose(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodUnloadVerbose(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature);
    return status;
}

inline BOOL EventEnabledMethodUnloadVerbose_V1(void) {return EventPipeEventEnabledMethodUnloadVerbose_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodUnloadVerbose_V1());}

inline ULONG FireEtwMethodUnloadVerbose_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodUnloadVerbose_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodUnloadVerbose_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodUnloadVerbose_V2(void) {return EventPipeEventEnabledMethodUnloadVerbose_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodUnloadVerbose_V2());}

inline ULONG FireEtwMethodUnloadVerbose_V2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ReJITID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodUnloadVerbose_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ReJITID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodUnloadVerbose_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ReJITID);
    return status;
}

inline BOOL EventEnabledMethodJittingStarted(void) {return EventPipeEventEnabledMethodJittingStarted() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodJittingStarted());}

inline ULONG FireEtwMethodJittingStarted(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned int  MethodToken,
    const unsigned int  MethodILSize,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodJittingStarted(MethodID,ModuleID,MethodToken,MethodILSize,MethodNamespace,MethodName,MethodSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodJittingStarted(MethodID,ModuleID,MethodToken,MethodILSize,MethodNamespace,MethodName,MethodSignature);
    return status;
}

inline BOOL EventEnabledMethodJittingStarted_V1(void) {return EventPipeEventEnabledMethodJittingStarted_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodJittingStarted_V1());}

inline ULONG FireEtwMethodJittingStarted_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned int  MethodToken,
    const unsigned int  MethodILSize,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodJittingStarted_V1(MethodID,ModuleID,MethodToken,MethodILSize,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodJittingStarted_V1(MethodID,ModuleID,MethodToken,MethodILSize,MethodNamespace,MethodName,MethodSignature,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodJitMemoryAllocatedForCode(void) {return EventPipeEventEnabledMethodJitMemoryAllocatedForCode() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodJitMemoryAllocatedForCode());}

inline ULONG FireEtwMethodJitMemoryAllocatedForCode(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  JitHotCodeRequestSize,
    const unsigned __int64  JitRODataRequestSize,
    const unsigned __int64  AllocatedSizeForJitCode,
    const unsigned int  JitAllocFlag,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodJitMemoryAllocatedForCode(MethodID,ModuleID,JitHotCodeRequestSize,JitRODataRequestSize,AllocatedSizeForJitCode,JitAllocFlag,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodJitMemoryAllocatedForCode(MethodID,ModuleID,JitHotCodeRequestSize,JitRODataRequestSize,AllocatedSizeForJitCode,JitAllocFlag,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodJitInliningSucceeded(void) {return EventPipeEventEnabledMethodJitInliningSucceeded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodJitInliningSucceeded());}

inline ULONG FireEtwMethodJitInliningSucceeded(
    PCWSTR  MethodBeingCompiledNamespace,
    PCWSTR  MethodBeingCompiledName,
    PCWSTR  MethodBeingCompiledNameSignature,
    PCWSTR  InlinerNamespace,
    PCWSTR  InlinerName,
    PCWSTR  InlinerNameSignature,
    PCWSTR  InlineeNamespace,
    PCWSTR  InlineeName,
    PCWSTR  InlineeNameSignature,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodJitInliningSucceeded(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,InlinerNamespace,InlinerName,InlinerNameSignature,InlineeNamespace,InlineeName,InlineeNameSignature,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodJitInliningSucceeded(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,InlinerNamespace,InlinerName,InlinerNameSignature,InlineeNamespace,InlineeName,InlineeNameSignature,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodJitInliningFailedAnsi(void) {return EventPipeEventEnabledMethodJitInliningFailedAnsi() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodJitInliningFailedAnsi());}

inline ULONG FireEtwMethodJitInliningFailedAnsi(
    PCWSTR  MethodBeingCompiledNamespace,
    PCWSTR  MethodBeingCompiledName,
    PCWSTR  MethodBeingCompiledNameSignature,
    PCWSTR  InlinerNamespace,
    PCWSTR  InlinerName,
    PCWSTR  InlinerNameSignature,
    PCWSTR  InlineeNamespace,
    PCWSTR  InlineeName,
    PCWSTR  InlineeNameSignature,
    const BOOL  FailAlways,
    LPCSTR  FailReason,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodJitInliningFailedAnsi(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,InlinerNamespace,InlinerName,InlinerNameSignature,InlineeNamespace,InlineeName,InlineeNameSignature,FailAlways,FailReason,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodJitInliningFailedAnsi(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,InlinerNamespace,InlinerName,InlinerNameSignature,InlineeNamespace,InlineeName,InlineeNameSignature,FailAlways,FailReason,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodJitTailCallSucceeded(void) {return EventPipeEventEnabledMethodJitTailCallSucceeded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodJitTailCallSucceeded());}

inline ULONG FireEtwMethodJitTailCallSucceeded(
    PCWSTR  MethodBeingCompiledNamespace,
    PCWSTR  MethodBeingCompiledName,
    PCWSTR  MethodBeingCompiledNameSignature,
    PCWSTR  CallerNamespace,
    PCWSTR  CallerName,
    PCWSTR  CallerNameSignature,
    PCWSTR  CalleeNamespace,
    PCWSTR  CalleeName,
    PCWSTR  CalleeNameSignature,
    const BOOL  TailPrefix,
    const unsigned int  TailCallType,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodJitTailCallSucceeded(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,CallerNamespace,CallerName,CallerNameSignature,CalleeNamespace,CalleeName,CalleeNameSignature,TailPrefix,TailCallType,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodJitTailCallSucceeded(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,CallerNamespace,CallerName,CallerNameSignature,CalleeNamespace,CalleeName,CalleeNameSignature,TailPrefix,TailCallType,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodJitTailCallFailedAnsi(void) {return EventPipeEventEnabledMethodJitTailCallFailedAnsi() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodJitTailCallFailedAnsi());}

inline ULONG FireEtwMethodJitTailCallFailedAnsi(
    PCWSTR  MethodBeingCompiledNamespace,
    PCWSTR  MethodBeingCompiledName,
    PCWSTR  MethodBeingCompiledNameSignature,
    PCWSTR  CallerNamespace,
    PCWSTR  CallerName,
    PCWSTR  CallerNameSignature,
    PCWSTR  CalleeNamespace,
    PCWSTR  CalleeName,
    PCWSTR  CalleeNameSignature,
    const BOOL  TailPrefix,
    LPCSTR  FailReason,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodJitTailCallFailedAnsi(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,CallerNamespace,CallerName,CallerNameSignature,CalleeNamespace,CalleeName,CalleeNameSignature,TailPrefix,FailReason,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodJitTailCallFailedAnsi(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,CallerNamespace,CallerName,CallerNameSignature,CalleeNamespace,CalleeName,CalleeNameSignature,TailPrefix,FailReason,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodILToNativeMap(void) {return EventPipeEventEnabledMethodILToNativeMap() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodILToNativeMap());}

inline ULONG FireEtwMethodILToNativeMap(
    const unsigned __int64  MethodID,
    const unsigned __int64  ReJITID,
    const unsigned char  MethodExtent,
    const unsigned short  CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodILToNativeMap(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodILToNativeMap(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodILToNativeMap_V1(void) {return EventPipeEventEnabledMethodILToNativeMap_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodILToNativeMap_V1());}

inline ULONG FireEtwMethodILToNativeMap_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ReJITID,
    const unsigned char  MethodExtent,
    const unsigned short  CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ILVersionID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodILToNativeMap_V1(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID,ILVersionID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodILToNativeMap_V1(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID,ILVersionID);
    return status;
}

inline BOOL EventEnabledMethodJitTailCallFailed(void) {return EventPipeEventEnabledMethodJitTailCallFailed() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodJitTailCallFailed());}

inline ULONG FireEtwMethodJitTailCallFailed(
    PCWSTR  MethodBeingCompiledNamespace,
    PCWSTR  MethodBeingCompiledName,
    PCWSTR  MethodBeingCompiledNameSignature,
    PCWSTR  CallerNamespace,
    PCWSTR  CallerName,
    PCWSTR  CallerNameSignature,
    PCWSTR  CalleeNamespace,
    PCWSTR  CalleeName,
    PCWSTR  CalleeNameSignature,
    const BOOL  TailPrefix,
    PCWSTR  FailReason,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodJitTailCallFailed(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,CallerNamespace,CallerName,CallerNameSignature,CalleeNamespace,CalleeName,CalleeNameSignature,TailPrefix,FailReason,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodJitTailCallFailed(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,CallerNamespace,CallerName,CallerNameSignature,CalleeNamespace,CalleeName,CalleeNameSignature,TailPrefix,FailReason,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodJitInliningFailed(void) {return EventPipeEventEnabledMethodJitInliningFailed() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodJitInliningFailed());}

inline ULONG FireEtwMethodJitInliningFailed(
    PCWSTR  MethodBeingCompiledNamespace,
    PCWSTR  MethodBeingCompiledName,
    PCWSTR  MethodBeingCompiledNameSignature,
    PCWSTR  InlinerNamespace,
    PCWSTR  InlinerName,
    PCWSTR  InlinerNameSignature,
    PCWSTR  InlineeNamespace,
    PCWSTR  InlineeName,
    PCWSTR  InlineeNameSignature,
    const BOOL  FailAlways,
    PCWSTR  FailReason,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodJitInliningFailed(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,InlinerNamespace,InlinerName,InlinerNameSignature,InlineeNamespace,InlineeName,InlineeNameSignature,FailAlways,FailReason,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodJitInliningFailed(MethodBeingCompiledNamespace,MethodBeingCompiledName,MethodBeingCompiledNameSignature,InlinerNamespace,InlinerName,InlinerNameSignature,InlineeNamespace,InlineeName,InlineeNameSignature,FailAlways,FailReason,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleDCStartV2(void) {return EventPipeEventEnabledModuleDCStartV2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleDCStartV2());}

inline ULONG FireEtwModuleDCStartV2(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleDCStartV2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleDCStartV2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath);
    return status;
}

inline BOOL EventEnabledModuleDCEndV2(void) {return EventPipeEventEnabledModuleDCEndV2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleDCEndV2());}

inline ULONG FireEtwModuleDCEndV2(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleDCEndV2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleDCEndV2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath);
    return status;
}

inline BOOL EventEnabledDomainModuleLoad(void) {return EventPipeEventEnabledDomainModuleLoad() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDomainModuleLoad());}

inline ULONG FireEtwDomainModuleLoad(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDomainModuleLoad(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatDomainModuleLoad(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath);
    return status;
}

inline BOOL EventEnabledDomainModuleLoad_V1(void) {return EventPipeEventEnabledDomainModuleLoad_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDomainModuleLoad_V1());}

inline ULONG FireEtwDomainModuleLoad_V1(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDomainModuleLoad_V1(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatDomainModuleLoad_V1(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleLoad(void) {return EventPipeEventEnabledModuleLoad() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleLoad());}

inline ULONG FireEtwModuleLoad(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleLoad(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleLoad(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath);
    return status;
}

inline BOOL EventEnabledModuleLoad_V1(void) {return EventPipeEventEnabledModuleLoad_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleLoad_V1());}

inline ULONG FireEtwModuleLoad_V1(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleLoad_V1(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleLoad_V1(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleLoad_V2(void) {return EventPipeEventEnabledModuleLoad_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleLoad_V2());}

inline ULONG FireEtwModuleLoad_V2(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int  ManagedPdbAge,
    PCWSTR  ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int  NativePdbAge,
    PCWSTR  NativePdbBuildPath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleLoad_V2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ManagedPdbSignature,ManagedPdbAge,ManagedPdbBuildPath,NativePdbSignature,NativePdbAge,NativePdbBuildPath,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleLoad_V2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ManagedPdbSignature,ManagedPdbAge,ManagedPdbBuildPath,NativePdbSignature,NativePdbAge,NativePdbBuildPath);
    return status;
}

inline BOOL EventEnabledModuleUnload(void) {return EventPipeEventEnabledModuleUnload() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleUnload());}

inline ULONG FireEtwModuleUnload(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleUnload(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleUnload(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath);
    return status;
}

inline BOOL EventEnabledModuleUnload_V1(void) {return EventPipeEventEnabledModuleUnload_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleUnload_V1());}

inline ULONG FireEtwModuleUnload_V1(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleUnload_V1(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleUnload_V1(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleUnload_V2(void) {return EventPipeEventEnabledModuleUnload_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleUnload_V2());}

inline ULONG FireEtwModuleUnload_V2(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int  ManagedPdbAge,
    PCWSTR  ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int  NativePdbAge,
    PCWSTR  NativePdbBuildPath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleUnload_V2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ManagedPdbSignature,ManagedPdbAge,ManagedPdbBuildPath,NativePdbSignature,NativePdbAge,NativePdbBuildPath,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleUnload_V2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ManagedPdbSignature,ManagedPdbAge,ManagedPdbBuildPath,NativePdbSignature,NativePdbAge,NativePdbBuildPath);
    return status;
}

inline BOOL EventEnabledAssemblyLoad(void) {return EventPipeEventEnabledAssemblyLoad() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyLoad());}

inline ULONG FireEtwAssemblyLoad(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned int  AssemblyFlags,
    PCWSTR  FullyQualifiedAssemblyName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyLoad(AssemblyID,AppDomainID,AssemblyFlags,FullyQualifiedAssemblyName,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyLoad(AssemblyID,AppDomainID,AssemblyFlags,FullyQualifiedAssemblyName);
    return status;
}

inline BOOL EventEnabledAssemblyLoad_V1(void) {return EventPipeEventEnabledAssemblyLoad_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyLoad_V1());}

inline ULONG FireEtwAssemblyLoad_V1(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned __int64  BindingID,
    const unsigned int  AssemblyFlags,
    PCWSTR  FullyQualifiedAssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyLoad_V1(AssemblyID,AppDomainID,BindingID,AssemblyFlags,FullyQualifiedAssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyLoad_V1(AssemblyID,AppDomainID,BindingID,AssemblyFlags,FullyQualifiedAssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAssemblyUnload(void) {return EventPipeEventEnabledAssemblyUnload() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyUnload());}

inline ULONG FireEtwAssemblyUnload(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned int  AssemblyFlags,
    PCWSTR  FullyQualifiedAssemblyName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyUnload(AssemblyID,AppDomainID,AssemblyFlags,FullyQualifiedAssemblyName,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyUnload(AssemblyID,AppDomainID,AssemblyFlags,FullyQualifiedAssemblyName);
    return status;
}

inline BOOL EventEnabledAssemblyUnload_V1(void) {return EventPipeEventEnabledAssemblyUnload_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyUnload_V1());}

inline ULONG FireEtwAssemblyUnload_V1(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned __int64  BindingID,
    const unsigned int  AssemblyFlags,
    PCWSTR  FullyQualifiedAssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyUnload_V1(AssemblyID,AppDomainID,BindingID,AssemblyFlags,FullyQualifiedAssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyUnload_V1(AssemblyID,AppDomainID,BindingID,AssemblyFlags,FullyQualifiedAssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAppDomainLoad(void) {return EventPipeEventEnabledAppDomainLoad() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainLoad());}

inline ULONG FireEtwAppDomainLoad(
    const unsigned __int64  AppDomainID,
    const unsigned int  AppDomainFlags,
    PCWSTR  AppDomainName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainLoad(AppDomainID,AppDomainFlags,AppDomainName,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainLoad(AppDomainID,AppDomainFlags,AppDomainName);
    return status;
}

inline BOOL EventEnabledAppDomainLoad_V1(void) {return EventPipeEventEnabledAppDomainLoad_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainLoad_V1());}

inline ULONG FireEtwAppDomainLoad_V1(
    const unsigned __int64  AppDomainID,
    const unsigned int  AppDomainFlags,
    PCWSTR  AppDomainName,
    const unsigned int  AppDomainIndex,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainLoad_V1(AppDomainID,AppDomainFlags,AppDomainName,AppDomainIndex,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainLoad_V1(AppDomainID,AppDomainFlags,AppDomainName,AppDomainIndex,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAppDomainUnload(void) {return EventPipeEventEnabledAppDomainUnload() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainUnload());}

inline ULONG FireEtwAppDomainUnload(
    const unsigned __int64  AppDomainID,
    const unsigned int  AppDomainFlags,
    PCWSTR  AppDomainName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainUnload(AppDomainID,AppDomainFlags,AppDomainName,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainUnload(AppDomainID,AppDomainFlags,AppDomainName);
    return status;
}

inline BOOL EventEnabledAppDomainUnload_V1(void) {return EventPipeEventEnabledAppDomainUnload_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainUnload_V1());}

inline ULONG FireEtwAppDomainUnload_V1(
    const unsigned __int64  AppDomainID,
    const unsigned int  AppDomainFlags,
    PCWSTR  AppDomainName,
    const unsigned int  AppDomainIndex,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainUnload_V1(AppDomainID,AppDomainFlags,AppDomainName,AppDomainIndex,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainUnload_V1(AppDomainID,AppDomainFlags,AppDomainName,AppDomainIndex,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleRangeLoad(void) {return EventPipeEventEnabledModuleRangeLoad() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleRangeLoad());}

inline ULONG FireEtwModuleRangeLoad(
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ModuleID,
    const unsigned int  RangeBegin,
    const unsigned int  RangeSize,
    const unsigned char  RangeType,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleRangeLoad(ClrInstanceID,ModuleID,RangeBegin,RangeSize,RangeType,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleRangeLoad(ClrInstanceID,ModuleID,RangeBegin,RangeSize,RangeType);
    return status;
}

inline BOOL EventEnabledStrongNameVerificationStart(void) {return EventPipeEventEnabledStrongNameVerificationStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledStrongNameVerificationStart());}

inline ULONG FireEtwStrongNameVerificationStart(
    const unsigned int  VerificationFlags,
    const unsigned int  ErrorCode,
    PCWSTR  FullyQualifiedAssemblyName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventStrongNameVerificationStart(VerificationFlags,ErrorCode,FullyQualifiedAssemblyName,ActivityId,RelatedActivityId);
    status &= FireEtXplatStrongNameVerificationStart(VerificationFlags,ErrorCode,FullyQualifiedAssemblyName);
    return status;
}

inline BOOL EventEnabledStrongNameVerificationStart_V1(void) {return EventPipeEventEnabledStrongNameVerificationStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledStrongNameVerificationStart_V1());}

inline ULONG FireEtwStrongNameVerificationStart_V1(
    const unsigned int  VerificationFlags,
    const unsigned int  ErrorCode,
    PCWSTR  FullyQualifiedAssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventStrongNameVerificationStart_V1(VerificationFlags,ErrorCode,FullyQualifiedAssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatStrongNameVerificationStart_V1(VerificationFlags,ErrorCode,FullyQualifiedAssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledStrongNameVerificationStop(void) {return EventPipeEventEnabledStrongNameVerificationStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledStrongNameVerificationStop());}

inline ULONG FireEtwStrongNameVerificationStop(
    const unsigned int  VerificationFlags,
    const unsigned int  ErrorCode,
    PCWSTR  FullyQualifiedAssemblyName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventStrongNameVerificationStop(VerificationFlags,ErrorCode,FullyQualifiedAssemblyName,ActivityId,RelatedActivityId);
    status &= FireEtXplatStrongNameVerificationStop(VerificationFlags,ErrorCode,FullyQualifiedAssemblyName);
    return status;
}

inline BOOL EventEnabledStrongNameVerificationStop_V1(void) {return EventPipeEventEnabledStrongNameVerificationStop_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledStrongNameVerificationStop_V1());}

inline ULONG FireEtwStrongNameVerificationStop_V1(
    const unsigned int  VerificationFlags,
    const unsigned int  ErrorCode,
    PCWSTR  FullyQualifiedAssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventStrongNameVerificationStop_V1(VerificationFlags,ErrorCode,FullyQualifiedAssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatStrongNameVerificationStop_V1(VerificationFlags,ErrorCode,FullyQualifiedAssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAuthenticodeVerificationStart(void) {return EventPipeEventEnabledAuthenticodeVerificationStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAuthenticodeVerificationStart());}

inline ULONG FireEtwAuthenticodeVerificationStart(
    const unsigned int  VerificationFlags,
    const unsigned int  ErrorCode,
    PCWSTR  ModulePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAuthenticodeVerificationStart(VerificationFlags,ErrorCode,ModulePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatAuthenticodeVerificationStart(VerificationFlags,ErrorCode,ModulePath);
    return status;
}

inline BOOL EventEnabledAuthenticodeVerificationStart_V1(void) {return EventPipeEventEnabledAuthenticodeVerificationStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAuthenticodeVerificationStart_V1());}

inline ULONG FireEtwAuthenticodeVerificationStart_V1(
    const unsigned int  VerificationFlags,
    const unsigned int  ErrorCode,
    PCWSTR  ModulePath,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAuthenticodeVerificationStart_V1(VerificationFlags,ErrorCode,ModulePath,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAuthenticodeVerificationStart_V1(VerificationFlags,ErrorCode,ModulePath,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAuthenticodeVerificationStop(void) {return EventPipeEventEnabledAuthenticodeVerificationStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAuthenticodeVerificationStop());}

inline ULONG FireEtwAuthenticodeVerificationStop(
    const unsigned int  VerificationFlags,
    const unsigned int  ErrorCode,
    PCWSTR  ModulePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAuthenticodeVerificationStop(VerificationFlags,ErrorCode,ModulePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatAuthenticodeVerificationStop(VerificationFlags,ErrorCode,ModulePath);
    return status;
}

inline BOOL EventEnabledAuthenticodeVerificationStop_V1(void) {return EventPipeEventEnabledAuthenticodeVerificationStop_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAuthenticodeVerificationStop_V1());}

inline ULONG FireEtwAuthenticodeVerificationStop_V1(
    const unsigned int  VerificationFlags,
    const unsigned int  ErrorCode,
    PCWSTR  ModulePath,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAuthenticodeVerificationStop_V1(VerificationFlags,ErrorCode,ModulePath,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAuthenticodeVerificationStop_V1(VerificationFlags,ErrorCode,ModulePath,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledRuntimeInformationStart(void) {return EventPipeEventEnabledRuntimeInformationStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledRuntimeInformationStart());}

inline ULONG FireEtwRuntimeInformationStart(
    const unsigned short  ClrInstanceID,
    const unsigned short  Sku,
    const unsigned short  BclMajorVersion,
    const unsigned short  BclMinorVersion,
    const unsigned short  BclBuildNumber,
    const unsigned short  BclQfeNumber,
    const unsigned short  VMMajorVersion,
    const unsigned short  VMMinorVersion,
    const unsigned short  VMBuildNumber,
    const unsigned short  VMQfeNumber,
    const unsigned int  StartupFlags,
    const unsigned char  StartupMode,
    PCWSTR  CommandLine,
    const GUID* ComObjectGuid,
    PCWSTR  RuntimeDllPath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventRuntimeInformationStart(ClrInstanceID,Sku,BclMajorVersion,BclMinorVersion,BclBuildNumber,BclQfeNumber,VMMajorVersion,VMMinorVersion,VMBuildNumber,VMQfeNumber,StartupFlags,StartupMode,CommandLine,ComObjectGuid,RuntimeDllPath,ActivityId,RelatedActivityId);
    status &= FireEtXplatRuntimeInformationStart(ClrInstanceID,Sku,BclMajorVersion,BclMinorVersion,BclBuildNumber,BclQfeNumber,VMMajorVersion,VMMinorVersion,VMBuildNumber,VMQfeNumber,StartupFlags,StartupMode,CommandLine,ComObjectGuid,RuntimeDllPath);
    return status;
}

inline BOOL EventEnabledIncreaseMemoryPressure(void) {return EventPipeEventEnabledIncreaseMemoryPressure() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledIncreaseMemoryPressure());}

inline ULONG FireEtwIncreaseMemoryPressure(
    const unsigned __int64  BytesAllocated,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventIncreaseMemoryPressure(BytesAllocated,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatIncreaseMemoryPressure(BytesAllocated,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledDecreaseMemoryPressure(void) {return EventPipeEventEnabledDecreaseMemoryPressure() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDecreaseMemoryPressure());}

inline ULONG FireEtwDecreaseMemoryPressure(
    const unsigned __int64  BytesFreed,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDecreaseMemoryPressure(BytesFreed,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatDecreaseMemoryPressure(BytesFreed,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCMarkWithType(void) {return EventPipeEventEnabledGCMarkWithType() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCMarkWithType());}

inline ULONG FireEtwGCMarkWithType(
    const unsigned int  HeapNum,
    const unsigned short  ClrInstanceID,
    const unsigned int  Type,
    const unsigned __int64  Bytes,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCMarkWithType(HeapNum,ClrInstanceID,Type,Bytes,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCMarkWithType(HeapNum,ClrInstanceID,Type,Bytes);
    return status;
}

inline BOOL EventEnabledGCJoin_V2(void) {return EventPipeEventEnabledGCJoin_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCJoin_V2());}

inline ULONG FireEtwGCJoin_V2(
    const unsigned int  Heap,
    const unsigned int  JoinTime,
    const unsigned int  JoinType,
    const unsigned short  ClrInstanceID,
    const unsigned int  JoinID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCJoin_V2(Heap,JoinTime,JoinType,ClrInstanceID,JoinID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCJoin_V2(Heap,JoinTime,JoinType,ClrInstanceID,JoinID);
    return status;
}

inline BOOL EventEnabledGCPerHeapHistory_V3(void) {return EventPipeEventEnabledGCPerHeapHistory_V3() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCPerHeapHistory_V3());}

inline ULONG FireEtwGCPerHeapHistory_V3(
    const unsigned short  ClrInstanceID,
    const void*  FreeListAllocated,
    const void*  FreeListRejected,
    const void*  EndOfSegAllocated,
    const void*  CondemnedAllocated,
    const void*  PinnedAllocated,
    const void*  PinnedAllocatedAdvance,
    const unsigned int  RunningFreeListEfficiency,
    const unsigned int  CondemnReasons0,
    const unsigned int  CondemnReasons1,
    const unsigned int  CompactMechanisms,
    const unsigned int  ExpandMechanisms,
    const unsigned int  HeapIndex,
    const void*  ExtraGen0Commit,
    const unsigned int  Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCPerHeapHistory_V3(ClrInstanceID,FreeListAllocated,FreeListRejected,EndOfSegAllocated,CondemnedAllocated,PinnedAllocated,PinnedAllocatedAdvance,RunningFreeListEfficiency,CondemnReasons0,CondemnReasons1,CompactMechanisms,ExpandMechanisms,HeapIndex,ExtraGen0Commit,Count,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCPerHeapHistory_V3(ClrInstanceID,FreeListAllocated,FreeListRejected,EndOfSegAllocated,CondemnedAllocated,PinnedAllocated,PinnedAllocatedAdvance,RunningFreeListEfficiency,CondemnReasons0,CondemnReasons1,CompactMechanisms,ExpandMechanisms,HeapIndex,ExtraGen0Commit,Count,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCGlobalHeapHistory_V2(void) {return EventPipeEventEnabledGCGlobalHeapHistory_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCGlobalHeapHistory_V2());}

inline ULONG FireEtwGCGlobalHeapHistory_V2(
    const unsigned __int64  FinalYoungestDesired,
    const signed int  NumHeaps,
    const unsigned int  CondemnedGeneration,
    const unsigned int  Gen0ReductionCount,
    const unsigned int  Reason,
    const unsigned int  GlobalMechanisms,
    const unsigned short  ClrInstanceID,
    const unsigned int  PauseMode,
    const unsigned int  MemoryPressure,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCGlobalHeapHistory_V2(FinalYoungestDesired,NumHeaps,CondemnedGeneration,Gen0ReductionCount,Reason,GlobalMechanisms,ClrInstanceID,PauseMode,MemoryPressure,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCGlobalHeapHistory_V2(FinalYoungestDesired,NumHeaps,CondemnedGeneration,Gen0ReductionCount,Reason,GlobalMechanisms,ClrInstanceID,PauseMode,MemoryPressure);
    return status;
}

inline BOOL EventEnabledGCGlobalHeapHistory_V3(void) {return EventPipeEventEnabledGCGlobalHeapHistory_V3() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCGlobalHeapHistory_V3());}

inline ULONG FireEtwGCGlobalHeapHistory_V3(
    const unsigned __int64  FinalYoungestDesired,
    const signed int  NumHeaps,
    const unsigned int  CondemnedGeneration,
    const unsigned int  Gen0ReductionCount,
    const unsigned int  Reason,
    const unsigned int  GlobalMechanisms,
    const unsigned short  ClrInstanceID,
    const unsigned int  PauseMode,
    const unsigned int  MemoryPressure,
    const unsigned int  CondemnReasons0,
    const unsigned int  CondemnReasons1,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCGlobalHeapHistory_V3(FinalYoungestDesired,NumHeaps,CondemnedGeneration,Gen0ReductionCount,Reason,GlobalMechanisms,ClrInstanceID,PauseMode,MemoryPressure,CondemnReasons0,CondemnReasons1,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCGlobalHeapHistory_V3(FinalYoungestDesired,NumHeaps,CondemnedGeneration,Gen0ReductionCount,Reason,GlobalMechanisms,ClrInstanceID,PauseMode,MemoryPressure,CondemnReasons0,CondemnReasons1);
    return status;
}

inline BOOL EventEnabledGCGlobalHeapHistory_V4(void) {return EventPipeEventEnabledGCGlobalHeapHistory_V4() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCGlobalHeapHistory_V4());}

inline ULONG FireEtwGCGlobalHeapHistory_V4(
    const unsigned __int64  FinalYoungestDesired,
    const signed int  NumHeaps,
    const unsigned int  CondemnedGeneration,
    const unsigned int  Gen0ReductionCount,
    const unsigned int  Reason,
    const unsigned int  GlobalMechanisms,
    const unsigned short  ClrInstanceID,
    const unsigned int  PauseMode,
    const unsigned int  MemoryPressure,
    const unsigned int  CondemnReasons0,
    const unsigned int  CondemnReasons1,
    const unsigned int  Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCGlobalHeapHistory_V4(FinalYoungestDesired,NumHeaps,CondemnedGeneration,Gen0ReductionCount,Reason,GlobalMechanisms,ClrInstanceID,PauseMode,MemoryPressure,CondemnReasons0,CondemnReasons1,Count,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCGlobalHeapHistory_V4(FinalYoungestDesired,NumHeaps,CondemnedGeneration,Gen0ReductionCount,Reason,GlobalMechanisms,ClrInstanceID,PauseMode,MemoryPressure,CondemnReasons0,CondemnReasons1,Count,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGenAwareBegin(void) {return EventPipeEventEnabledGenAwareBegin() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGenAwareBegin());}

inline ULONG FireEtwGenAwareBegin(
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGenAwareBegin(Count,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGenAwareBegin(Count,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGenAwareEnd(void) {return EventPipeEventEnabledGenAwareEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGenAwareEnd());}

inline ULONG FireEtwGenAwareEnd(
    const unsigned int  Count,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGenAwareEnd(Count,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGenAwareEnd(Count,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCLOHCompact(void) {return EventPipeEventEnabledGCLOHCompact() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCLOHCompact());}

inline ULONG FireEtwGCLOHCompact(
    const unsigned short  ClrInstanceID,
    const unsigned short  Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCLOHCompact(ClrInstanceID,Count,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCLOHCompact(ClrInstanceID,Count,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledGCFitBucketInfo(void) {return EventPipeEventEnabledGCFitBucketInfo() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCFitBucketInfo());}

inline ULONG FireEtwGCFitBucketInfo(
    const unsigned short  ClrInstanceID,
    const unsigned short  BucketKind,
    const unsigned __int64  TotalSize,
    const unsigned short  Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCFitBucketInfo(ClrInstanceID,BucketKind,TotalSize,Count,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCFitBucketInfo(ClrInstanceID,BucketKind,TotalSize,Count,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledDebugIPCEventStart(void) {return EventPipeEventEnabledDebugIPCEventStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDebugIPCEventStart());}

inline ULONG FireEtwDebugIPCEventStart(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDebugIPCEventStart(ActivityId,RelatedActivityId);
    status &= FireEtXplatDebugIPCEventStart();
    return status;
}

inline BOOL EventEnabledDebugIPCEventEnd(void) {return EventPipeEventEnabledDebugIPCEventEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDebugIPCEventEnd());}

inline ULONG FireEtwDebugIPCEventEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDebugIPCEventEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatDebugIPCEventEnd();
    return status;
}

inline BOOL EventEnabledDebugExceptionProcessingStart(void) {return EventPipeEventEnabledDebugExceptionProcessingStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDebugExceptionProcessingStart());}

inline ULONG FireEtwDebugExceptionProcessingStart(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDebugExceptionProcessingStart(ActivityId,RelatedActivityId);
    status &= FireEtXplatDebugExceptionProcessingStart();
    return status;
}

inline BOOL EventEnabledDebugExceptionProcessingEnd(void) {return EventPipeEventEnabledDebugExceptionProcessingEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDebugExceptionProcessingEnd());}

inline ULONG FireEtwDebugExceptionProcessingEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDebugExceptionProcessingEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatDebugExceptionProcessingEnd();
    return status;
}

inline BOOL EventEnabledCodeSymbols(void) {return EventPipeEventEnabledCodeSymbols() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledCodeSymbols());}

inline ULONG FireEtwCodeSymbols(
    const unsigned __int64  ModuleId,
    const unsigned short  TotalChunks,
    const unsigned short  ChunkNumber,
    const unsigned int  ChunkLength,
    const BYTE* Chunk,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventCodeSymbols(ModuleId,TotalChunks,ChunkNumber,ChunkLength,Chunk,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatCodeSymbols(ModuleId,TotalChunks,ChunkNumber,ChunkLength,Chunk,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledEventSource(void) {return EventPipeEventEnabledEventSource() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEventSource());}

inline ULONG FireEtwEventSource(
    const signed int  EventID,
    PCWSTR  EventName,
    PCWSTR  EventSourceName,
    PCWSTR  Payload,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEventSource(EventID,EventName,EventSourceName,Payload,ActivityId,RelatedActivityId);
    status &= FireEtXplatEventSource(EventID,EventName,EventSourceName,Payload);
    return status;
}

inline BOOL EventEnabledTieredCompilationSettings(void) {return EventPipeEventEnabledTieredCompilationSettings() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTieredCompilationSettings());}

inline ULONG FireEtwTieredCompilationSettings(
    const unsigned short  ClrInstanceID,
    const unsigned int  Flags,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTieredCompilationSettings(ClrInstanceID,Flags,ActivityId,RelatedActivityId);
    status &= FireEtXplatTieredCompilationSettings(ClrInstanceID,Flags);
    return status;
}

inline BOOL EventEnabledTieredCompilationPause(void) {return EventPipeEventEnabledTieredCompilationPause() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTieredCompilationPause());}

inline ULONG FireEtwTieredCompilationPause(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTieredCompilationPause(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatTieredCompilationPause(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledTieredCompilationResume(void) {return EventPipeEventEnabledTieredCompilationResume() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTieredCompilationResume());}

inline ULONG FireEtwTieredCompilationResume(
    const unsigned short  ClrInstanceID,
    const unsigned int  NewMethodCount,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTieredCompilationResume(ClrInstanceID,NewMethodCount,ActivityId,RelatedActivityId);
    status &= FireEtXplatTieredCompilationResume(ClrInstanceID,NewMethodCount);
    return status;
}

inline BOOL EventEnabledTieredCompilationBackgroundJitStart(void) {return EventPipeEventEnabledTieredCompilationBackgroundJitStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTieredCompilationBackgroundJitStart());}

inline ULONG FireEtwTieredCompilationBackgroundJitStart(
    const unsigned short  ClrInstanceID,
    const unsigned int  PendingMethodCount,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTieredCompilationBackgroundJitStart(ClrInstanceID,PendingMethodCount,ActivityId,RelatedActivityId);
    status &= FireEtXplatTieredCompilationBackgroundJitStart(ClrInstanceID,PendingMethodCount);
    return status;
}

inline BOOL EventEnabledTieredCompilationBackgroundJitStop(void) {return EventPipeEventEnabledTieredCompilationBackgroundJitStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTieredCompilationBackgroundJitStop());}

inline ULONG FireEtwTieredCompilationBackgroundJitStop(
    const unsigned short  ClrInstanceID,
    const unsigned int  PendingMethodCount,
    const unsigned int  JittedMethodCount,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTieredCompilationBackgroundJitStop(ClrInstanceID,PendingMethodCount,JittedMethodCount,ActivityId,RelatedActivityId);
    status &= FireEtXplatTieredCompilationBackgroundJitStop(ClrInstanceID,PendingMethodCount,JittedMethodCount);
    return status;
}

inline BOOL EventEnabledAssemblyLoadStart(void) {return EventPipeEventEnabledAssemblyLoadStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyLoadStart());}

inline ULONG FireEtwAssemblyLoadStart(
    const unsigned short  ClrInstanceID,
    PCWSTR  AssemblyName,
    PCWSTR  AssemblyPath,
    PCWSTR  RequestingAssembly,
    PCWSTR  AssemblyLoadContext,
    PCWSTR  RequestingAssemblyLoadContext,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyLoadStart(ClrInstanceID,AssemblyName,AssemblyPath,RequestingAssembly,AssemblyLoadContext,RequestingAssemblyLoadContext,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyLoadStart(ClrInstanceID,AssemblyName,AssemblyPath,RequestingAssembly,AssemblyLoadContext,RequestingAssemblyLoadContext);
    return status;
}

inline BOOL EventEnabledAssemblyLoadStop(void) {return EventPipeEventEnabledAssemblyLoadStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyLoadStop());}

inline ULONG FireEtwAssemblyLoadStop(
    const unsigned short  ClrInstanceID,
    PCWSTR  AssemblyName,
    PCWSTR  AssemblyPath,
    PCWSTR  RequestingAssembly,
    PCWSTR  AssemblyLoadContext,
    PCWSTR  RequestingAssemblyLoadContext,
    const BOOL  Success,
    PCWSTR  ResultAssemblyName,
    PCWSTR  ResultAssemblyPath,
    const BOOL  Cached,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyLoadStop(ClrInstanceID,AssemblyName,AssemblyPath,RequestingAssembly,AssemblyLoadContext,RequestingAssemblyLoadContext,Success,ResultAssemblyName,ResultAssemblyPath,Cached,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyLoadStop(ClrInstanceID,AssemblyName,AssemblyPath,RequestingAssembly,AssemblyLoadContext,RequestingAssemblyLoadContext,Success,ResultAssemblyName,ResultAssemblyPath,Cached);
    return status;
}

inline BOOL EventEnabledResolutionAttempted(void) {return EventPipeEventEnabledResolutionAttempted() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledResolutionAttempted());}

inline ULONG FireEtwResolutionAttempted(
    const unsigned short  ClrInstanceID,
    PCWSTR  AssemblyName,
    const unsigned short  Stage,
    PCWSTR  AssemblyLoadContext,
    const unsigned short  Result,
    PCWSTR  ResultAssemblyName,
    PCWSTR  ResultAssemblyPath,
    PCWSTR  ErrorMessage,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventResolutionAttempted(ClrInstanceID,AssemblyName,Stage,AssemblyLoadContext,Result,ResultAssemblyName,ResultAssemblyPath,ErrorMessage,ActivityId,RelatedActivityId);
    status &= FireEtXplatResolutionAttempted(ClrInstanceID,AssemblyName,Stage,AssemblyLoadContext,Result,ResultAssemblyName,ResultAssemblyPath,ErrorMessage);
    return status;
}

inline BOOL EventEnabledAssemblyLoadContextResolvingHandlerInvoked(void) {return EventPipeEventEnabledAssemblyLoadContextResolvingHandlerInvoked() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyLoadContextResolvingHandlerInvoked());}

inline ULONG FireEtwAssemblyLoadContextResolvingHandlerInvoked(
    const unsigned short  ClrInstanceID,
    PCWSTR  AssemblyName,
    PCWSTR  HandlerName,
    PCWSTR  AssemblyLoadContext,
    PCWSTR  ResultAssemblyName,
    PCWSTR  ResultAssemblyPath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyLoadContextResolvingHandlerInvoked(ClrInstanceID,AssemblyName,HandlerName,AssemblyLoadContext,ResultAssemblyName,ResultAssemblyPath,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyLoadContextResolvingHandlerInvoked(ClrInstanceID,AssemblyName,HandlerName,AssemblyLoadContext,ResultAssemblyName,ResultAssemblyPath);
    return status;
}

inline BOOL EventEnabledAppDomainAssemblyResolveHandlerInvoked(void) {return EventPipeEventEnabledAppDomainAssemblyResolveHandlerInvoked() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainAssemblyResolveHandlerInvoked());}

inline ULONG FireEtwAppDomainAssemblyResolveHandlerInvoked(
    const unsigned short  ClrInstanceID,
    PCWSTR  AssemblyName,
    PCWSTR  HandlerName,
    PCWSTR  ResultAssemblyName,
    PCWSTR  ResultAssemblyPath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainAssemblyResolveHandlerInvoked(ClrInstanceID,AssemblyName,HandlerName,ResultAssemblyName,ResultAssemblyPath,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainAssemblyResolveHandlerInvoked(ClrInstanceID,AssemblyName,HandlerName,ResultAssemblyName,ResultAssemblyPath);
    return status;
}

inline BOOL EventEnabledAssemblyLoadFromResolveHandlerInvoked(void) {return EventPipeEventEnabledAssemblyLoadFromResolveHandlerInvoked() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyLoadFromResolveHandlerInvoked());}

inline ULONG FireEtwAssemblyLoadFromResolveHandlerInvoked(
    const unsigned short  ClrInstanceID,
    PCWSTR  AssemblyName,
    const BOOL  IsTrackedLoad,
    PCWSTR  RequestingAssemblyPath,
    PCWSTR  ComputedRequestedAssemblyPath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyLoadFromResolveHandlerInvoked(ClrInstanceID,AssemblyName,IsTrackedLoad,RequestingAssemblyPath,ComputedRequestedAssemblyPath,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyLoadFromResolveHandlerInvoked(ClrInstanceID,AssemblyName,IsTrackedLoad,RequestingAssemblyPath,ComputedRequestedAssemblyPath);
    return status;
}

inline BOOL EventEnabledKnownPathProbed(void) {return EventPipeEventEnabledKnownPathProbed() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledKnownPathProbed());}

inline ULONG FireEtwKnownPathProbed(
    const unsigned short  ClrInstanceID,
    PCWSTR  FilePath,
    const unsigned short  Source,
    const signed int  Result,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventKnownPathProbed(ClrInstanceID,FilePath,Source,Result,ActivityId,RelatedActivityId);
    status &= FireEtXplatKnownPathProbed(ClrInstanceID,FilePath,Source,Result);
    return status;
}

inline BOOL EventEnabledJitInstrumentationData(void) {return EventPipeEventEnabledJitInstrumentationData() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledJitInstrumentationData());}

inline ULONG FireEtwJitInstrumentationData(
    const unsigned short  ClrInstanceID,
    const unsigned int  MethodFlags,
    const unsigned int  DataSize,
    const unsigned __int64  MethodID,
    const BYTE* Data,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventJitInstrumentationData(ClrInstanceID,MethodFlags,DataSize,MethodID,Data,ActivityId,RelatedActivityId);
    status &= FireEtXplatJitInstrumentationData(ClrInstanceID,MethodFlags,DataSize,MethodID,Data);
    return status;
}

inline BOOL EventEnabledJitInstrumentationDataVerbose(void) {return EventPipeEventEnabledJitInstrumentationDataVerbose() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledJitInstrumentationDataVerbose());}

inline ULONG FireEtwJitInstrumentationDataVerbose(
    const unsigned short  ClrInstanceID,
    const unsigned int  MethodFlags,
    const unsigned int  DataSize,
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned int  MethodToken,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const BYTE* Data,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventJitInstrumentationDataVerbose(ClrInstanceID,MethodFlags,DataSize,MethodID,ModuleID,MethodToken,MethodNamespace,MethodName,MethodSignature,Data,ActivityId,RelatedActivityId);
    status &= FireEtXplatJitInstrumentationDataVerbose(ClrInstanceID,MethodFlags,DataSize,MethodID,ModuleID,MethodToken,MethodNamespace,MethodName,MethodSignature,Data);
    return status;
}

inline BOOL EventEnabledProfilerMessage(void) {return EventPipeEventEnabledProfilerMessage() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledProfilerMessage());}

inline ULONG FireEtwProfilerMessage(
    const unsigned short  ClrInstanceID,
    PCWSTR  Message,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventProfilerMessage(ClrInstanceID,Message,ActivityId,RelatedActivityId);
    status &= FireEtXplatProfilerMessage(ClrInstanceID,Message);
    return status;
}

inline BOOL EventEnabledExecutionCheckpoint(void) {return EventPipeEventEnabledExecutionCheckpoint() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExecutionCheckpoint());}

inline ULONG FireEtwExecutionCheckpoint(
    const unsigned short  ClrInstanceID,
    PCWSTR  Name,
    const __int64  Timestamp,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExecutionCheckpoint(ClrInstanceID,Name,Timestamp,ActivityId,RelatedActivityId);
    status &= FireEtXplatExecutionCheckpoint(ClrInstanceID,Name,Timestamp);
    return status;
}

inline BOOL EventEnabledCLRStackWalkDCStart(void) {return EventPipeEventEnabledCLRStackWalkDCStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledCLRStackWalkDCStart());}

inline ULONG FireEtwCLRStackWalkDCStart(
    const unsigned short  ClrInstanceID,
    const unsigned char  Reserved1,
    const unsigned char  Reserved2,
    const unsigned int  FrameCount,
    const void** Stack,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventCLRStackWalkDCStart(ClrInstanceID,Reserved1,Reserved2,FrameCount,Stack,ActivityId,RelatedActivityId);
    status &= FireEtXplatCLRStackWalkDCStart(ClrInstanceID,Reserved1,Reserved2,FrameCount,Stack);
    return status;
}

inline BOOL EventEnabledGCSettingsRundown(void) {return EventPipeEventEnabledGCSettingsRundown() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCSettingsRundown());}

inline ULONG FireEtwGCSettingsRundown(
    const unsigned __int64  HardLimit,
    const unsigned __int64  LOHThreshold,
    const unsigned __int64  PhysicalMemoryConfig,
    const unsigned __int64  Gen0MinBudgetConfig,
    const unsigned __int64  Gen0MaxBudgetConfig,
    const unsigned int  HighMemPercentConfig,
    const unsigned int  BitSettings,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCSettingsRundown(HardLimit,LOHThreshold,PhysicalMemoryConfig,Gen0MinBudgetConfig,Gen0MaxBudgetConfig,HighMemPercentConfig,BitSettings,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCSettingsRundown(HardLimit,LOHThreshold,PhysicalMemoryConfig,Gen0MinBudgetConfig,Gen0MaxBudgetConfig,HighMemPercentConfig,BitSettings,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodDCStart(void) {return EventPipeEventEnabledMethodDCStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCStart());}

inline ULONG FireEtwMethodDCStart(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCStart(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCStart(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags);
    return status;
}

inline BOOL EventEnabledMethodDCStart_V1(void) {return EventPipeEventEnabledMethodDCStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCStart_V1());}

inline ULONG FireEtwMethodDCStart_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCStart_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCStart_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodDCStart_V2(void) {return EventPipeEventEnabledMethodDCStart_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCStart_V2());}

inline ULONG FireEtwMethodDCStart_V2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ReJITID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCStart_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ReJITID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCStart_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ReJITID);
    return status;
}

inline BOOL EventEnabledMethodDCEnd(void) {return EventPipeEventEnabledMethodDCEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCEnd());}

inline ULONG FireEtwMethodDCEnd(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCEnd(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCEnd(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags);
    return status;
}

inline BOOL EventEnabledMethodDCEnd_V1(void) {return EventPipeEventEnabledMethodDCEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCEnd_V1());}

inline ULONG FireEtwMethodDCEnd_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCEnd_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCEnd_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodDCEnd_V2(void) {return EventPipeEventEnabledMethodDCEnd_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCEnd_V2());}

inline ULONG FireEtwMethodDCEnd_V2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ReJITID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCEnd_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ReJITID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCEnd_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,ClrInstanceID,ReJITID);
    return status;
}

inline BOOL EventEnabledMethodDCStartVerbose(void) {return EventPipeEventEnabledMethodDCStartVerbose() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCStartVerbose());}

inline ULONG FireEtwMethodDCStartVerbose(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCStartVerbose(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCStartVerbose(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature);
    return status;
}

inline BOOL EventEnabledMethodDCStartVerbose_V1(void) {return EventPipeEventEnabledMethodDCStartVerbose_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCStartVerbose_V1());}

inline ULONG FireEtwMethodDCStartVerbose_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCStartVerbose_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCStartVerbose_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodDCStartVerbose_V2(void) {return EventPipeEventEnabledMethodDCStartVerbose_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCStartVerbose_V2());}

inline ULONG FireEtwMethodDCStartVerbose_V2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ReJITID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCStartVerbose_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ReJITID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCStartVerbose_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ReJITID);
    return status;
}

inline BOOL EventEnabledMethodDCEndVerbose(void) {return EventPipeEventEnabledMethodDCEndVerbose() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCEndVerbose());}

inline ULONG FireEtwMethodDCEndVerbose(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCEndVerbose(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCEndVerbose(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature);
    return status;
}

inline BOOL EventEnabledMethodDCEndVerbose_V1(void) {return EventPipeEventEnabledMethodDCEndVerbose_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCEndVerbose_V1());}

inline ULONG FireEtwMethodDCEndVerbose_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCEndVerbose_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCEndVerbose_V1(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodDCEndVerbose_V2(void) {return EventPipeEventEnabledMethodDCEndVerbose_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCEndVerbose_V2());}

inline ULONG FireEtwMethodDCEndVerbose_V2(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodStartAddress,
    const unsigned int  MethodSize,
    const unsigned int  MethodToken,
    const unsigned int  MethodFlags,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ReJITID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCEndVerbose_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ReJITID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCEndVerbose_V2(MethodID,ModuleID,MethodStartAddress,MethodSize,MethodToken,MethodFlags,MethodNamespace,MethodName,MethodSignature,ClrInstanceID,ReJITID);
    return status;
}

inline BOOL EventEnabledDCStartComplete(void) {return EventPipeEventEnabledDCStartComplete() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDCStartComplete());}

inline ULONG FireEtwDCStartComplete(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDCStartComplete(ActivityId,RelatedActivityId);
    status &= FireEtXplatDCStartComplete();
    return status;
}

inline BOOL EventEnabledDCStartComplete_V1(void) {return EventPipeEventEnabledDCStartComplete_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDCStartComplete_V1());}

inline ULONG FireEtwDCStartComplete_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDCStartComplete_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatDCStartComplete_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledDCEndComplete(void) {return EventPipeEventEnabledDCEndComplete() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDCEndComplete());}

inline ULONG FireEtwDCEndComplete(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDCEndComplete(ActivityId,RelatedActivityId);
    status &= FireEtXplatDCEndComplete();
    return status;
}

inline BOOL EventEnabledDCEndComplete_V1(void) {return EventPipeEventEnabledDCEndComplete_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDCEndComplete_V1());}

inline ULONG FireEtwDCEndComplete_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDCEndComplete_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatDCEndComplete_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledDCStartInit(void) {return EventPipeEventEnabledDCStartInit() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDCStartInit());}

inline ULONG FireEtwDCStartInit(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDCStartInit(ActivityId,RelatedActivityId);
    status &= FireEtXplatDCStartInit();
    return status;
}

inline BOOL EventEnabledDCStartInit_V1(void) {return EventPipeEventEnabledDCStartInit_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDCStartInit_V1());}

inline ULONG FireEtwDCStartInit_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDCStartInit_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatDCStartInit_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledDCEndInit(void) {return EventPipeEventEnabledDCEndInit() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDCEndInit());}

inline ULONG FireEtwDCEndInit(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDCEndInit(ActivityId,RelatedActivityId);
    status &= FireEtXplatDCEndInit();
    return status;
}

inline BOOL EventEnabledDCEndInit_V1(void) {return EventPipeEventEnabledDCEndInit_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDCEndInit_V1());}

inline ULONG FireEtwDCEndInit_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDCEndInit_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatDCEndInit_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodDCStartILToNativeMap(void) {return EventPipeEventEnabledMethodDCStartILToNativeMap() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCStartILToNativeMap());}

inline ULONG FireEtwMethodDCStartILToNativeMap(
    const unsigned __int64  MethodID,
    const unsigned __int64  ReJITID,
    const unsigned char  MethodExtent,
    const unsigned short  CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCStartILToNativeMap(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCStartILToNativeMap(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodDCStartILToNativeMap_V1(void) {return EventPipeEventEnabledMethodDCStartILToNativeMap_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCStartILToNativeMap_V1());}

inline ULONG FireEtwMethodDCStartILToNativeMap_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ReJITID,
    const unsigned char  MethodExtent,
    const unsigned short  CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ILVersionID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCStartILToNativeMap_V1(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID,ILVersionID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCStartILToNativeMap_V1(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID,ILVersionID);
    return status;
}

inline BOOL EventEnabledMethodDCEndILToNativeMap(void) {return EventPipeEventEnabledMethodDCEndILToNativeMap() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCEndILToNativeMap());}

inline ULONG FireEtwMethodDCEndILToNativeMap(
    const unsigned __int64  MethodID,
    const unsigned __int64  ReJITID,
    const unsigned char  MethodExtent,
    const unsigned short  CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCEndILToNativeMap(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCEndILToNativeMap(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodDCEndILToNativeMap_V1(void) {return EventPipeEventEnabledMethodDCEndILToNativeMap_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodDCEndILToNativeMap_V1());}

inline ULONG FireEtwMethodDCEndILToNativeMap_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ReJITID,
    const unsigned char  MethodExtent,
    const unsigned short  CountOfMapEntries,
    const unsigned int* ILOffsets,
    const unsigned int* NativeOffsets,
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ILVersionID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodDCEndILToNativeMap_V1(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID,ILVersionID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodDCEndILToNativeMap_V1(MethodID,ReJITID,MethodExtent,CountOfMapEntries,ILOffsets,NativeOffsets,ClrInstanceID,ILVersionID);
    return status;
}

inline BOOL EventEnabledDomainModuleDCStart(void) {return EventPipeEventEnabledDomainModuleDCStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDomainModuleDCStart());}

inline ULONG FireEtwDomainModuleDCStart(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDomainModuleDCStart(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatDomainModuleDCStart(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath);
    return status;
}

inline BOOL EventEnabledDomainModuleDCStart_V1(void) {return EventPipeEventEnabledDomainModuleDCStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDomainModuleDCStart_V1());}

inline ULONG FireEtwDomainModuleDCStart_V1(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDomainModuleDCStart_V1(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatDomainModuleDCStart_V1(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledDomainModuleDCEnd(void) {return EventPipeEventEnabledDomainModuleDCEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDomainModuleDCEnd());}

inline ULONG FireEtwDomainModuleDCEnd(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDomainModuleDCEnd(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatDomainModuleDCEnd(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath);
    return status;
}

inline BOOL EventEnabledDomainModuleDCEnd_V1(void) {return EventPipeEventEnabledDomainModuleDCEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledDomainModuleDCEnd_V1());}

inline ULONG FireEtwDomainModuleDCEnd_V1(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventDomainModuleDCEnd_V1(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatDomainModuleDCEnd_V1(ModuleID,AssemblyID,AppDomainID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleDCStart(void) {return EventPipeEventEnabledModuleDCStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleDCStart());}

inline ULONG FireEtwModuleDCStart(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleDCStart(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleDCStart(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath);
    return status;
}

inline BOOL EventEnabledModuleDCStart_V1(void) {return EventPipeEventEnabledModuleDCStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleDCStart_V1());}

inline ULONG FireEtwModuleDCStart_V1(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleDCStart_V1(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleDCStart_V1(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleDCStart_V2(void) {return EventPipeEventEnabledModuleDCStart_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleDCStart_V2());}

inline ULONG FireEtwModuleDCStart_V2(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int  ManagedPdbAge,
    PCWSTR  ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int  NativePdbAge,
    PCWSTR  NativePdbBuildPath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleDCStart_V2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ManagedPdbSignature,ManagedPdbAge,ManagedPdbBuildPath,NativePdbSignature,NativePdbAge,NativePdbBuildPath,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleDCStart_V2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ManagedPdbSignature,ManagedPdbAge,ManagedPdbBuildPath,NativePdbSignature,NativePdbAge,NativePdbBuildPath);
    return status;
}

inline BOOL EventEnabledModuleDCEnd(void) {return EventPipeEventEnabledModuleDCEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleDCEnd());}

inline ULONG FireEtwModuleDCEnd(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleDCEnd(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleDCEnd(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath);
    return status;
}

inline BOOL EventEnabledModuleDCEnd_V1(void) {return EventPipeEventEnabledModuleDCEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleDCEnd_V1());}

inline ULONG FireEtwModuleDCEnd_V1(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleDCEnd_V1(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleDCEnd_V1(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleDCEnd_V2(void) {return EventPipeEventEnabledModuleDCEnd_V2() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleDCEnd_V2());}

inline ULONG FireEtwModuleDCEnd_V2(
    const unsigned __int64  ModuleID,
    const unsigned __int64  AssemblyID,
    const unsigned int  ModuleFlags,
    const unsigned int  Reserved1,
    PCWSTR  ModuleILPath,
    PCWSTR  ModuleNativePath,
    const unsigned short  ClrInstanceID,
    const GUID* ManagedPdbSignature,
    const unsigned int  ManagedPdbAge,
    PCWSTR  ManagedPdbBuildPath,
    const GUID* NativePdbSignature,
    const unsigned int  NativePdbAge,
    PCWSTR  NativePdbBuildPath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleDCEnd_V2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ManagedPdbSignature,ManagedPdbAge,ManagedPdbBuildPath,NativePdbSignature,NativePdbAge,NativePdbBuildPath,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleDCEnd_V2(ModuleID,AssemblyID,ModuleFlags,Reserved1,ModuleILPath,ModuleNativePath,ClrInstanceID,ManagedPdbSignature,ManagedPdbAge,ManagedPdbBuildPath,NativePdbSignature,NativePdbAge,NativePdbBuildPath);
    return status;
}

inline BOOL EventEnabledAssemblyDCStart(void) {return EventPipeEventEnabledAssemblyDCStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyDCStart());}

inline ULONG FireEtwAssemblyDCStart(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned int  AssemblyFlags,
    PCWSTR  FullyQualifiedAssemblyName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyDCStart(AssemblyID,AppDomainID,AssemblyFlags,FullyQualifiedAssemblyName,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyDCStart(AssemblyID,AppDomainID,AssemblyFlags,FullyQualifiedAssemblyName);
    return status;
}

inline BOOL EventEnabledAssemblyDCStart_V1(void) {return EventPipeEventEnabledAssemblyDCStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyDCStart_V1());}

inline ULONG FireEtwAssemblyDCStart_V1(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned __int64  BindingID,
    const unsigned int  AssemblyFlags,
    PCWSTR  FullyQualifiedAssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyDCStart_V1(AssemblyID,AppDomainID,BindingID,AssemblyFlags,FullyQualifiedAssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyDCStart_V1(AssemblyID,AppDomainID,BindingID,AssemblyFlags,FullyQualifiedAssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAssemblyDCEnd(void) {return EventPipeEventEnabledAssemblyDCEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyDCEnd());}

inline ULONG FireEtwAssemblyDCEnd(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned int  AssemblyFlags,
    PCWSTR  FullyQualifiedAssemblyName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyDCEnd(AssemblyID,AppDomainID,AssemblyFlags,FullyQualifiedAssemblyName,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyDCEnd(AssemblyID,AppDomainID,AssemblyFlags,FullyQualifiedAssemblyName);
    return status;
}

inline BOOL EventEnabledAssemblyDCEnd_V1(void) {return EventPipeEventEnabledAssemblyDCEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAssemblyDCEnd_V1());}

inline ULONG FireEtwAssemblyDCEnd_V1(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  AppDomainID,
    const unsigned __int64  BindingID,
    const unsigned int  AssemblyFlags,
    PCWSTR  FullyQualifiedAssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAssemblyDCEnd_V1(AssemblyID,AppDomainID,BindingID,AssemblyFlags,FullyQualifiedAssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAssemblyDCEnd_V1(AssemblyID,AppDomainID,BindingID,AssemblyFlags,FullyQualifiedAssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAppDomainDCStart(void) {return EventPipeEventEnabledAppDomainDCStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainDCStart());}

inline ULONG FireEtwAppDomainDCStart(
    const unsigned __int64  AppDomainID,
    const unsigned int  AppDomainFlags,
    PCWSTR  AppDomainName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainDCStart(AppDomainID,AppDomainFlags,AppDomainName,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainDCStart(AppDomainID,AppDomainFlags,AppDomainName);
    return status;
}

inline BOOL EventEnabledAppDomainDCStart_V1(void) {return EventPipeEventEnabledAppDomainDCStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainDCStart_V1());}

inline ULONG FireEtwAppDomainDCStart_V1(
    const unsigned __int64  AppDomainID,
    const unsigned int  AppDomainFlags,
    PCWSTR  AppDomainName,
    const unsigned int  AppDomainIndex,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainDCStart_V1(AppDomainID,AppDomainFlags,AppDomainName,AppDomainIndex,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainDCStart_V1(AppDomainID,AppDomainFlags,AppDomainName,AppDomainIndex,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAppDomainDCEnd(void) {return EventPipeEventEnabledAppDomainDCEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainDCEnd());}

inline ULONG FireEtwAppDomainDCEnd(
    const unsigned __int64  AppDomainID,
    const unsigned int  AppDomainFlags,
    PCWSTR  AppDomainName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainDCEnd(AppDomainID,AppDomainFlags,AppDomainName,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainDCEnd(AppDomainID,AppDomainFlags,AppDomainName);
    return status;
}

inline BOOL EventEnabledAppDomainDCEnd_V1(void) {return EventPipeEventEnabledAppDomainDCEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAppDomainDCEnd_V1());}

inline ULONG FireEtwAppDomainDCEnd_V1(
    const unsigned __int64  AppDomainID,
    const unsigned int  AppDomainFlags,
    PCWSTR  AppDomainName,
    const unsigned int  AppDomainIndex,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAppDomainDCEnd_V1(AppDomainID,AppDomainFlags,AppDomainName,AppDomainIndex,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAppDomainDCEnd_V1(AppDomainID,AppDomainFlags,AppDomainName,AppDomainIndex,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledThreadDC(void) {return EventPipeEventEnabledThreadDC() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledThreadDC());}

inline ULONG FireEtwThreadDC(
    const unsigned __int64  ManagedThreadID,
    const unsigned __int64  AppDomainID,
    const unsigned int  Flags,
    const unsigned int  ManagedThreadIndex,
    const unsigned int  OSThreadID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventThreadDC(ManagedThreadID,AppDomainID,Flags,ManagedThreadIndex,OSThreadID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatThreadDC(ManagedThreadID,AppDomainID,Flags,ManagedThreadIndex,OSThreadID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleRangeDCStart(void) {return EventPipeEventEnabledModuleRangeDCStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleRangeDCStart());}

inline ULONG FireEtwModuleRangeDCStart(
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ModuleID,
    const unsigned int  RangeBegin,
    const unsigned int  RangeSize,
    const unsigned char  RangeType,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleRangeDCStart(ClrInstanceID,ModuleID,RangeBegin,RangeSize,RangeType,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleRangeDCStart(ClrInstanceID,ModuleID,RangeBegin,RangeSize,RangeType);
    return status;
}

inline BOOL EventEnabledModuleRangeDCEnd(void) {return EventPipeEventEnabledModuleRangeDCEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleRangeDCEnd());}

inline ULONG FireEtwModuleRangeDCEnd(
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ModuleID,
    const unsigned int  RangeBegin,
    const unsigned int  RangeSize,
    const unsigned char  RangeType,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleRangeDCEnd(ClrInstanceID,ModuleID,RangeBegin,RangeSize,RangeType,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleRangeDCEnd(ClrInstanceID,ModuleID,RangeBegin,RangeSize,RangeType);
    return status;
}

inline BOOL EventEnabledRuntimeInformationDCStart(void) {return EventPipeEventEnabledRuntimeInformationDCStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledRuntimeInformationDCStart());}

inline ULONG FireEtwRuntimeInformationDCStart(
    const unsigned short  ClrInstanceID,
    const unsigned short  Sku,
    const unsigned short  BclMajorVersion,
    const unsigned short  BclMinorVersion,
    const unsigned short  BclBuildNumber,
    const unsigned short  BclQfeNumber,
    const unsigned short  VMMajorVersion,
    const unsigned short  VMMinorVersion,
    const unsigned short  VMBuildNumber,
    const unsigned short  VMQfeNumber,
    const unsigned int  StartupFlags,
    const unsigned char  StartupMode,
    PCWSTR  CommandLine,
    const GUID* ComObjectGuid,
    PCWSTR  RuntimeDllPath,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventRuntimeInformationDCStart(ClrInstanceID,Sku,BclMajorVersion,BclMinorVersion,BclBuildNumber,BclQfeNumber,VMMajorVersion,VMMinorVersion,VMBuildNumber,VMQfeNumber,StartupFlags,StartupMode,CommandLine,ComObjectGuid,RuntimeDllPath,ActivityId,RelatedActivityId);
    status &= FireEtXplatRuntimeInformationDCStart(ClrInstanceID,Sku,BclMajorVersion,BclMinorVersion,BclBuildNumber,BclQfeNumber,VMMajorVersion,VMMinorVersion,VMBuildNumber,VMQfeNumber,StartupFlags,StartupMode,CommandLine,ComObjectGuid,RuntimeDllPath);
    return status;
}

inline BOOL EventEnabledTieredCompilationSettingsDCStart(void) {return EventPipeEventEnabledTieredCompilationSettingsDCStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTieredCompilationSettingsDCStart());}

inline ULONG FireEtwTieredCompilationSettingsDCStart(
    const unsigned short  ClrInstanceID,
    const unsigned int  Flags,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTieredCompilationSettingsDCStart(ClrInstanceID,Flags,ActivityId,RelatedActivityId);
    status &= FireEtXplatTieredCompilationSettingsDCStart(ClrInstanceID,Flags);
    return status;
}

inline BOOL EventEnabledExecutionCheckpointDCEnd(void) {return EventPipeEventEnabledExecutionCheckpointDCEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExecutionCheckpointDCEnd());}

inline ULONG FireEtwExecutionCheckpointDCEnd(
    const unsigned short  ClrInstanceID,
    PCWSTR  Name,
    const __int64  Timestamp,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExecutionCheckpointDCEnd(ClrInstanceID,Name,Timestamp,ActivityId,RelatedActivityId);
    status &= FireEtXplatExecutionCheckpointDCEnd(ClrInstanceID,Name,Timestamp);
    return status;
}

inline BOOL EventEnabledStressLogEvent(void) {return EventPipeEventEnabledStressLogEvent() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledStressLogEvent());}

inline ULONG FireEtwStressLogEvent(
    const unsigned int  Facility,
    const unsigned char  LogLevel,
    LPCSTR  Message,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventStressLogEvent(Facility,LogLevel,Message,ActivityId,RelatedActivityId);
    status &= FireEtXplatStressLogEvent(Facility,LogLevel,Message);
    return status;
}

inline BOOL EventEnabledStressLogEvent_V1(void) {return EventPipeEventEnabledStressLogEvent_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledStressLogEvent_V1());}

inline ULONG FireEtwStressLogEvent_V1(
    const unsigned int  Facility,
    const unsigned char  LogLevel,
    LPCSTR  Message,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventStressLogEvent_V1(Facility,LogLevel,Message,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatStressLogEvent_V1(Facility,LogLevel,Message,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledCLRStackWalkStress(void) {return EventPipeEventEnabledCLRStackWalkStress() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledCLRStackWalkStress());}

inline ULONG FireEtwCLRStackWalkStress(
    const unsigned short  ClrInstanceID,
    const unsigned char  Reserved1,
    const unsigned char  Reserved2,
    const unsigned int  FrameCount,
    const void** Stack,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventCLRStackWalkStress(ClrInstanceID,Reserved1,Reserved2,FrameCount,Stack,ActivityId,RelatedActivityId);
    status &= FireEtXplatCLRStackWalkStress(ClrInstanceID,Reserved1,Reserved2,FrameCount,Stack);
    return status;
}

inline BOOL EventEnabledGCDecision(void) {return EventPipeEventEnabledGCDecision() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCDecision());}

inline ULONG FireEtwGCDecision(
    const BOOL  DoCompact,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCDecision(DoCompact,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCDecision(DoCompact);
    return status;
}

inline BOOL EventEnabledGCDecision_V1(void) {return EventPipeEventEnabledGCDecision_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCDecision_V1());}

inline ULONG FireEtwGCDecision_V1(
    const BOOL  DoCompact,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCDecision_V1(DoCompact,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCDecision_V1(DoCompact,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCSettings(void) {return EventPipeEventEnabledGCSettings() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCSettings());}

inline ULONG FireEtwGCSettings(
    const unsigned __int64  SegmentSize,
    const unsigned __int64  LargeObjectSegmentSize,
    const BOOL  ServerGC,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCSettings(SegmentSize,LargeObjectSegmentSize,ServerGC,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCSettings(SegmentSize,LargeObjectSegmentSize,ServerGC);
    return status;
}

inline BOOL EventEnabledGCSettings_V1(void) {return EventPipeEventEnabledGCSettings_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCSettings_V1());}

inline ULONG FireEtwGCSettings_V1(
    const unsigned __int64  SegmentSize,
    const unsigned __int64  LargeObjectSegmentSize,
    const BOOL  ServerGC,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCSettings_V1(SegmentSize,LargeObjectSegmentSize,ServerGC,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCSettings_V1(SegmentSize,LargeObjectSegmentSize,ServerGC,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCOptimized(void) {return EventPipeEventEnabledGCOptimized() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCOptimized());}

inline ULONG FireEtwGCOptimized(
    const unsigned __int64  DesiredAllocation,
    const unsigned __int64  NewAllocation,
    const unsigned int  GenerationNumber,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCOptimized(DesiredAllocation,NewAllocation,GenerationNumber,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCOptimized(DesiredAllocation,NewAllocation,GenerationNumber);
    return status;
}

inline BOOL EventEnabledGCOptimized_V1(void) {return EventPipeEventEnabledGCOptimized_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCOptimized_V1());}

inline ULONG FireEtwGCOptimized_V1(
    const unsigned __int64  DesiredAllocation,
    const unsigned __int64  NewAllocation,
    const unsigned int  GenerationNumber,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCOptimized_V1(DesiredAllocation,NewAllocation,GenerationNumber,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCOptimized_V1(DesiredAllocation,NewAllocation,GenerationNumber,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCPerHeapHistory(void) {return EventPipeEventEnabledGCPerHeapHistory() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCPerHeapHistory());}

inline ULONG FireEtwGCPerHeapHistory(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCPerHeapHistory(ActivityId,RelatedActivityId);
    status &= FireEtXplatGCPerHeapHistory();
    return status;
}

inline BOOL EventEnabledGCPerHeapHistory_V1(void) {return EventPipeEventEnabledGCPerHeapHistory_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCPerHeapHistory_V1());}

inline ULONG FireEtwGCPerHeapHistory_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCPerHeapHistory_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCPerHeapHistory_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCGlobalHeapHistory(void) {return EventPipeEventEnabledGCGlobalHeapHistory() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCGlobalHeapHistory());}

inline ULONG FireEtwGCGlobalHeapHistory(
    const unsigned __int64  FinalYoungestDesired,
    const signed int  NumHeaps,
    const unsigned int  CondemnedGeneration,
    const unsigned int  Gen0ReductionCount,
    const unsigned int  Reason,
    const unsigned int  GlobalMechanisms,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCGlobalHeapHistory(FinalYoungestDesired,NumHeaps,CondemnedGeneration,Gen0ReductionCount,Reason,GlobalMechanisms,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCGlobalHeapHistory(FinalYoungestDesired,NumHeaps,CondemnedGeneration,Gen0ReductionCount,Reason,GlobalMechanisms);
    return status;
}

inline BOOL EventEnabledGCGlobalHeapHistory_V1(void) {return EventPipeEventEnabledGCGlobalHeapHistory_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCGlobalHeapHistory_V1());}

inline ULONG FireEtwGCGlobalHeapHistory_V1(
    const unsigned __int64  FinalYoungestDesired,
    const signed int  NumHeaps,
    const unsigned int  CondemnedGeneration,
    const unsigned int  Gen0ReductionCount,
    const unsigned int  Reason,
    const unsigned int  GlobalMechanisms,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCGlobalHeapHistory_V1(FinalYoungestDesired,NumHeaps,CondemnedGeneration,Gen0ReductionCount,Reason,GlobalMechanisms,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCGlobalHeapHistory_V1(FinalYoungestDesired,NumHeaps,CondemnedGeneration,Gen0ReductionCount,Reason,GlobalMechanisms,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCJoin(void) {return EventPipeEventEnabledGCJoin() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCJoin());}

inline ULONG FireEtwGCJoin(
    const unsigned int  Heap,
    const unsigned int  JoinTime,
    const unsigned int  JoinType,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCJoin(Heap,JoinTime,JoinType,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCJoin(Heap,JoinTime,JoinType);
    return status;
}

inline BOOL EventEnabledGCJoin_V1(void) {return EventPipeEventEnabledGCJoin_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCJoin_V1());}

inline ULONG FireEtwGCJoin_V1(
    const unsigned int  Heap,
    const unsigned int  JoinTime,
    const unsigned int  JoinType,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCJoin_V1(Heap,JoinTime,JoinType,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCJoin_V1(Heap,JoinTime,JoinType,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledPrvGCMarkStackRoots(void) {return EventPipeEventEnabledPrvGCMarkStackRoots() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvGCMarkStackRoots());}

inline ULONG FireEtwPrvGCMarkStackRoots(
    const unsigned int  HeapNum,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvGCMarkStackRoots(HeapNum,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvGCMarkStackRoots(HeapNum);
    return status;
}

inline BOOL EventEnabledPrvGCMarkStackRoots_V1(void) {return EventPipeEventEnabledPrvGCMarkStackRoots_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvGCMarkStackRoots_V1());}

inline ULONG FireEtwPrvGCMarkStackRoots_V1(
    const unsigned int  HeapNum,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvGCMarkStackRoots_V1(HeapNum,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvGCMarkStackRoots_V1(HeapNum,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledPrvGCMarkFinalizeQueueRoots(void) {return EventPipeEventEnabledPrvGCMarkFinalizeQueueRoots() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvGCMarkFinalizeQueueRoots());}

inline ULONG FireEtwPrvGCMarkFinalizeQueueRoots(
    const unsigned int  HeapNum,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvGCMarkFinalizeQueueRoots(HeapNum,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvGCMarkFinalizeQueueRoots(HeapNum);
    return status;
}

inline BOOL EventEnabledPrvGCMarkFinalizeQueueRoots_V1(void) {return EventPipeEventEnabledPrvGCMarkFinalizeQueueRoots_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvGCMarkFinalizeQueueRoots_V1());}

inline ULONG FireEtwPrvGCMarkFinalizeQueueRoots_V1(
    const unsigned int  HeapNum,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvGCMarkFinalizeQueueRoots_V1(HeapNum,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvGCMarkFinalizeQueueRoots_V1(HeapNum,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledPrvGCMarkHandles(void) {return EventPipeEventEnabledPrvGCMarkHandles() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvGCMarkHandles());}

inline ULONG FireEtwPrvGCMarkHandles(
    const unsigned int  HeapNum,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvGCMarkHandles(HeapNum,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvGCMarkHandles(HeapNum);
    return status;
}

inline BOOL EventEnabledPrvGCMarkHandles_V1(void) {return EventPipeEventEnabledPrvGCMarkHandles_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvGCMarkHandles_V1());}

inline ULONG FireEtwPrvGCMarkHandles_V1(
    const unsigned int  HeapNum,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvGCMarkHandles_V1(HeapNum,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvGCMarkHandles_V1(HeapNum,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledPrvGCMarkCards(void) {return EventPipeEventEnabledPrvGCMarkCards() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvGCMarkCards());}

inline ULONG FireEtwPrvGCMarkCards(
    const unsigned int  HeapNum,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvGCMarkCards(HeapNum,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvGCMarkCards(HeapNum);
    return status;
}

inline BOOL EventEnabledPrvGCMarkCards_V1(void) {return EventPipeEventEnabledPrvGCMarkCards_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvGCMarkCards_V1());}

inline ULONG FireEtwPrvGCMarkCards_V1(
    const unsigned int  HeapNum,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvGCMarkCards_V1(HeapNum,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvGCMarkCards_V1(HeapNum,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGCBegin(void) {return EventPipeEventEnabledBGCBegin() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGCBegin());}

inline ULONG FireEtwBGCBegin(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGCBegin(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGCBegin(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGC1stNonConEnd(void) {return EventPipeEventEnabledBGC1stNonConEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGC1stNonConEnd());}

inline ULONG FireEtwBGC1stNonConEnd(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGC1stNonConEnd(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGC1stNonConEnd(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGC1stConEnd(void) {return EventPipeEventEnabledBGC1stConEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGC1stConEnd());}

inline ULONG FireEtwBGC1stConEnd(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGC1stConEnd(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGC1stConEnd(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGC2ndNonConBegin(void) {return EventPipeEventEnabledBGC2ndNonConBegin() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGC2ndNonConBegin());}

inline ULONG FireEtwBGC2ndNonConBegin(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGC2ndNonConBegin(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGC2ndNonConBegin(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGC2ndNonConEnd(void) {return EventPipeEventEnabledBGC2ndNonConEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGC2ndNonConEnd());}

inline ULONG FireEtwBGC2ndNonConEnd(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGC2ndNonConEnd(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGC2ndNonConEnd(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGC2ndConBegin(void) {return EventPipeEventEnabledBGC2ndConBegin() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGC2ndConBegin());}

inline ULONG FireEtwBGC2ndConBegin(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGC2ndConBegin(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGC2ndConBegin(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGC2ndConEnd(void) {return EventPipeEventEnabledBGC2ndConEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGC2ndConEnd());}

inline ULONG FireEtwBGC2ndConEnd(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGC2ndConEnd(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGC2ndConEnd(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGCPlanEnd(void) {return EventPipeEventEnabledBGCPlanEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGCPlanEnd());}

inline ULONG FireEtwBGCPlanEnd(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGCPlanEnd(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGCPlanEnd(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGCSweepEnd(void) {return EventPipeEventEnabledBGCSweepEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGCSweepEnd());}

inline ULONG FireEtwBGCSweepEnd(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGCSweepEnd(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGCSweepEnd(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGCDrainMark(void) {return EventPipeEventEnabledBGCDrainMark() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGCDrainMark());}

inline ULONG FireEtwBGCDrainMark(
    const unsigned __int64  Objects,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGCDrainMark(Objects,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGCDrainMark(Objects,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGCRevisit(void) {return EventPipeEventEnabledBGCRevisit() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGCRevisit());}

inline ULONG FireEtwBGCRevisit(
    const unsigned __int64  Pages,
    const unsigned __int64  Objects,
    const unsigned int  IsLarge,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGCRevisit(Pages,Objects,IsLarge,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGCRevisit(Pages,Objects,IsLarge,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGCOverflow(void) {return EventPipeEventEnabledBGCOverflow() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGCOverflow());}

inline ULONG FireEtwBGCOverflow(
    const unsigned __int64  Min,
    const unsigned __int64  Max,
    const unsigned __int64  Objects,
    const unsigned int  IsLarge,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGCOverflow(Min,Max,Objects,IsLarge,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGCOverflow(Min,Max,Objects,IsLarge,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGCOverflow_V1(void) {return EventPipeEventEnabledBGCOverflow_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGCOverflow_V1());}

inline ULONG FireEtwBGCOverflow_V1(
    const unsigned __int64  Min,
    const unsigned __int64  Max,
    const unsigned __int64  Objects,
    const unsigned int  IsLarge,
    const unsigned short  ClrInstanceID,
    const unsigned int  GenNumber,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGCOverflow_V1(Min,Max,Objects,IsLarge,ClrInstanceID,GenNumber,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGCOverflow_V1(Min,Max,Objects,IsLarge,ClrInstanceID,GenNumber);
    return status;
}

inline BOOL EventEnabledBGCAllocWaitBegin(void) {return EventPipeEventEnabledBGCAllocWaitBegin() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGCAllocWaitBegin());}

inline ULONG FireEtwBGCAllocWaitBegin(
    const unsigned int  Reason,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGCAllocWaitBegin(Reason,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGCAllocWaitBegin(Reason,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGCAllocWaitEnd(void) {return EventPipeEventEnabledBGCAllocWaitEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGCAllocWaitEnd());}

inline ULONG FireEtwBGCAllocWaitEnd(
    const unsigned int  Reason,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGCAllocWaitEnd(Reason,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGCAllocWaitEnd(Reason,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGCFullNotify(void) {return EventPipeEventEnabledGCFullNotify() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCFullNotify());}

inline ULONG FireEtwGCFullNotify(
    const unsigned int  GenNumber,
    const unsigned int  IsAlloc,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCFullNotify(GenNumber,IsAlloc,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCFullNotify(GenNumber,IsAlloc);
    return status;
}

inline BOOL EventEnabledGCFullNotify_V1(void) {return EventPipeEventEnabledGCFullNotify_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGCFullNotify_V1());}

inline ULONG FireEtwGCFullNotify_V1(
    const unsigned int  GenNumber,
    const unsigned int  IsAlloc,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGCFullNotify_V1(GenNumber,IsAlloc,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGCFullNotify_V1(GenNumber,IsAlloc,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBGC1stSweepEnd(void) {return EventPipeEventEnabledBGC1stSweepEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBGC1stSweepEnd());}

inline ULONG FireEtwBGC1stSweepEnd(
    const unsigned int  GenNumber,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBGC1stSweepEnd(GenNumber,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBGC1stSweepEnd(GenNumber,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledEEStartupStart(void) {return EventPipeEventEnabledEEStartupStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEStartupStart());}

inline ULONG FireEtwEEStartupStart(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEStartupStart(ActivityId,RelatedActivityId);
    status &= FireEtXplatEEStartupStart();
    return status;
}

inline BOOL EventEnabledEEStartupStart_V1(void) {return EventPipeEventEnabledEEStartupStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEStartupStart_V1());}

inline ULONG FireEtwEEStartupStart_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEStartupStart_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatEEStartupStart_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledEEStartupEnd(void) {return EventPipeEventEnabledEEStartupEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEStartupEnd());}

inline ULONG FireEtwEEStartupEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEStartupEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatEEStartupEnd();
    return status;
}

inline BOOL EventEnabledEEStartupEnd_V1(void) {return EventPipeEventEnabledEEStartupEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEStartupEnd_V1());}

inline ULONG FireEtwEEStartupEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEStartupEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatEEStartupEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledEEConfigSetup(void) {return EventPipeEventEnabledEEConfigSetup() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEConfigSetup());}

inline ULONG FireEtwEEConfigSetup(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEConfigSetup(ActivityId,RelatedActivityId);
    status &= FireEtXplatEEConfigSetup();
    return status;
}

inline BOOL EventEnabledEEConfigSetup_V1(void) {return EventPipeEventEnabledEEConfigSetup_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEConfigSetup_V1());}

inline ULONG FireEtwEEConfigSetup_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEConfigSetup_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatEEConfigSetup_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledEEConfigSetupEnd(void) {return EventPipeEventEnabledEEConfigSetupEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEConfigSetupEnd());}

inline ULONG FireEtwEEConfigSetupEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEConfigSetupEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatEEConfigSetupEnd();
    return status;
}

inline BOOL EventEnabledEEConfigSetupEnd_V1(void) {return EventPipeEventEnabledEEConfigSetupEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEConfigSetupEnd_V1());}

inline ULONG FireEtwEEConfigSetupEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEConfigSetupEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatEEConfigSetupEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLdSysBases(void) {return EventPipeEventEnabledLdSysBases() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLdSysBases());}

inline ULONG FireEtwLdSysBases(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLdSysBases(ActivityId,RelatedActivityId);
    status &= FireEtXplatLdSysBases();
    return status;
}

inline BOOL EventEnabledLdSysBases_V1(void) {return EventPipeEventEnabledLdSysBases_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLdSysBases_V1());}

inline ULONG FireEtwLdSysBases_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLdSysBases_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLdSysBases_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLdSysBasesEnd(void) {return EventPipeEventEnabledLdSysBasesEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLdSysBasesEnd());}

inline ULONG FireEtwLdSysBasesEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLdSysBasesEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatLdSysBasesEnd();
    return status;
}

inline BOOL EventEnabledLdSysBasesEnd_V1(void) {return EventPipeEventEnabledLdSysBasesEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLdSysBasesEnd_V1());}

inline ULONG FireEtwLdSysBasesEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLdSysBasesEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLdSysBasesEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledExecExe(void) {return EventPipeEventEnabledExecExe() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExecExe());}

inline ULONG FireEtwExecExe(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExecExe(ActivityId,RelatedActivityId);
    status &= FireEtXplatExecExe();
    return status;
}

inline BOOL EventEnabledExecExe_V1(void) {return EventPipeEventEnabledExecExe_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExecExe_V1());}

inline ULONG FireEtwExecExe_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExecExe_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatExecExe_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledExecExeEnd(void) {return EventPipeEventEnabledExecExeEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExecExeEnd());}

inline ULONG FireEtwExecExeEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExecExeEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatExecExeEnd();
    return status;
}

inline BOOL EventEnabledExecExeEnd_V1(void) {return EventPipeEventEnabledExecExeEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExecExeEnd_V1());}

inline ULONG FireEtwExecExeEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExecExeEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatExecExeEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMain(void) {return EventPipeEventEnabledMain() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMain());}

inline ULONG FireEtwMain(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMain(ActivityId,RelatedActivityId);
    status &= FireEtXplatMain();
    return status;
}

inline BOOL EventEnabledMain_V1(void) {return EventPipeEventEnabledMain_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMain_V1());}

inline ULONG FireEtwMain_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMain_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMain_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMainEnd(void) {return EventPipeEventEnabledMainEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMainEnd());}

inline ULONG FireEtwMainEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMainEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatMainEnd();
    return status;
}

inline BOOL EventEnabledMainEnd_V1(void) {return EventPipeEventEnabledMainEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMainEnd_V1());}

inline ULONG FireEtwMainEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMainEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMainEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledApplyPolicyStart(void) {return EventPipeEventEnabledApplyPolicyStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledApplyPolicyStart());}

inline ULONG FireEtwApplyPolicyStart(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventApplyPolicyStart(ActivityId,RelatedActivityId);
    status &= FireEtXplatApplyPolicyStart();
    return status;
}

inline BOOL EventEnabledApplyPolicyStart_V1(void) {return EventPipeEventEnabledApplyPolicyStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledApplyPolicyStart_V1());}

inline ULONG FireEtwApplyPolicyStart_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventApplyPolicyStart_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatApplyPolicyStart_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledApplyPolicyEnd(void) {return EventPipeEventEnabledApplyPolicyEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledApplyPolicyEnd());}

inline ULONG FireEtwApplyPolicyEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventApplyPolicyEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatApplyPolicyEnd();
    return status;
}

inline BOOL EventEnabledApplyPolicyEnd_V1(void) {return EventPipeEventEnabledApplyPolicyEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledApplyPolicyEnd_V1());}

inline ULONG FireEtwApplyPolicyEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventApplyPolicyEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatApplyPolicyEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLdLibShFolder(void) {return EventPipeEventEnabledLdLibShFolder() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLdLibShFolder());}

inline ULONG FireEtwLdLibShFolder(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLdLibShFolder(ActivityId,RelatedActivityId);
    status &= FireEtXplatLdLibShFolder();
    return status;
}

inline BOOL EventEnabledLdLibShFolder_V1(void) {return EventPipeEventEnabledLdLibShFolder_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLdLibShFolder_V1());}

inline ULONG FireEtwLdLibShFolder_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLdLibShFolder_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLdLibShFolder_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLdLibShFolderEnd(void) {return EventPipeEventEnabledLdLibShFolderEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLdLibShFolderEnd());}

inline ULONG FireEtwLdLibShFolderEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLdLibShFolderEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatLdLibShFolderEnd();
    return status;
}

inline BOOL EventEnabledLdLibShFolderEnd_V1(void) {return EventPipeEventEnabledLdLibShFolderEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLdLibShFolderEnd_V1());}

inline ULONG FireEtwLdLibShFolderEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLdLibShFolderEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLdLibShFolderEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledPrestubWorker(void) {return EventPipeEventEnabledPrestubWorker() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrestubWorker());}

inline ULONG FireEtwPrestubWorker(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrestubWorker(ActivityId,RelatedActivityId);
    status &= FireEtXplatPrestubWorker();
    return status;
}

inline BOOL EventEnabledPrestubWorker_V1(void) {return EventPipeEventEnabledPrestubWorker_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrestubWorker_V1());}

inline ULONG FireEtwPrestubWorker_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrestubWorker_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrestubWorker_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledPrestubWorkerEnd(void) {return EventPipeEventEnabledPrestubWorkerEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrestubWorkerEnd());}

inline ULONG FireEtwPrestubWorkerEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrestubWorkerEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatPrestubWorkerEnd();
    return status;
}

inline BOOL EventEnabledPrestubWorkerEnd_V1(void) {return EventPipeEventEnabledPrestubWorkerEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrestubWorkerEnd_V1());}

inline ULONG FireEtwPrestubWorkerEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrestubWorkerEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrestubWorkerEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGetInstallationStart(void) {return EventPipeEventEnabledGetInstallationStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGetInstallationStart());}

inline ULONG FireEtwGetInstallationStart(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGetInstallationStart(ActivityId,RelatedActivityId);
    status &= FireEtXplatGetInstallationStart();
    return status;
}

inline BOOL EventEnabledGetInstallationStart_V1(void) {return EventPipeEventEnabledGetInstallationStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGetInstallationStart_V1());}

inline ULONG FireEtwGetInstallationStart_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGetInstallationStart_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGetInstallationStart_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGetInstallationEnd(void) {return EventPipeEventEnabledGetInstallationEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGetInstallationEnd());}

inline ULONG FireEtwGetInstallationEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGetInstallationEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatGetInstallationEnd();
    return status;
}

inline BOOL EventEnabledGetInstallationEnd_V1(void) {return EventPipeEventEnabledGetInstallationEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGetInstallationEnd_V1());}

inline ULONG FireEtwGetInstallationEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGetInstallationEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGetInstallationEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledOpenHModule(void) {return EventPipeEventEnabledOpenHModule() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledOpenHModule());}

inline ULONG FireEtwOpenHModule(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventOpenHModule(ActivityId,RelatedActivityId);
    status &= FireEtXplatOpenHModule();
    return status;
}

inline BOOL EventEnabledOpenHModule_V1(void) {return EventPipeEventEnabledOpenHModule_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledOpenHModule_V1());}

inline ULONG FireEtwOpenHModule_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventOpenHModule_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatOpenHModule_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledOpenHModuleEnd(void) {return EventPipeEventEnabledOpenHModuleEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledOpenHModuleEnd());}

inline ULONG FireEtwOpenHModuleEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventOpenHModuleEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatOpenHModuleEnd();
    return status;
}

inline BOOL EventEnabledOpenHModuleEnd_V1(void) {return EventPipeEventEnabledOpenHModuleEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledOpenHModuleEnd_V1());}

inline ULONG FireEtwOpenHModuleEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventOpenHModuleEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatOpenHModuleEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledExplicitBindStart(void) {return EventPipeEventEnabledExplicitBindStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExplicitBindStart());}

inline ULONG FireEtwExplicitBindStart(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExplicitBindStart(ActivityId,RelatedActivityId);
    status &= FireEtXplatExplicitBindStart();
    return status;
}

inline BOOL EventEnabledExplicitBindStart_V1(void) {return EventPipeEventEnabledExplicitBindStart_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExplicitBindStart_V1());}

inline ULONG FireEtwExplicitBindStart_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExplicitBindStart_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatExplicitBindStart_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledExplicitBindEnd(void) {return EventPipeEventEnabledExplicitBindEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExplicitBindEnd());}

inline ULONG FireEtwExplicitBindEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExplicitBindEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatExplicitBindEnd();
    return status;
}

inline BOOL EventEnabledExplicitBindEnd_V1(void) {return EventPipeEventEnabledExplicitBindEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledExplicitBindEnd_V1());}

inline ULONG FireEtwExplicitBindEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventExplicitBindEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatExplicitBindEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledParseXml(void) {return EventPipeEventEnabledParseXml() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledParseXml());}

inline ULONG FireEtwParseXml(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventParseXml(ActivityId,RelatedActivityId);
    status &= FireEtXplatParseXml();
    return status;
}

inline BOOL EventEnabledParseXml_V1(void) {return EventPipeEventEnabledParseXml_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledParseXml_V1());}

inline ULONG FireEtwParseXml_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventParseXml_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatParseXml_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledParseXmlEnd(void) {return EventPipeEventEnabledParseXmlEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledParseXmlEnd());}

inline ULONG FireEtwParseXmlEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventParseXmlEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatParseXmlEnd();
    return status;
}

inline BOOL EventEnabledParseXmlEnd_V1(void) {return EventPipeEventEnabledParseXmlEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledParseXmlEnd_V1());}

inline ULONG FireEtwParseXmlEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventParseXmlEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatParseXmlEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledInitDefaultDomain(void) {return EventPipeEventEnabledInitDefaultDomain() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledInitDefaultDomain());}

inline ULONG FireEtwInitDefaultDomain(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventInitDefaultDomain(ActivityId,RelatedActivityId);
    status &= FireEtXplatInitDefaultDomain();
    return status;
}

inline BOOL EventEnabledInitDefaultDomain_V1(void) {return EventPipeEventEnabledInitDefaultDomain_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledInitDefaultDomain_V1());}

inline ULONG FireEtwInitDefaultDomain_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventInitDefaultDomain_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatInitDefaultDomain_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledInitDefaultDomainEnd(void) {return EventPipeEventEnabledInitDefaultDomainEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledInitDefaultDomainEnd());}

inline ULONG FireEtwInitDefaultDomainEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventInitDefaultDomainEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatInitDefaultDomainEnd();
    return status;
}

inline BOOL EventEnabledInitDefaultDomainEnd_V1(void) {return EventPipeEventEnabledInitDefaultDomainEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledInitDefaultDomainEnd_V1());}

inline ULONG FireEtwInitDefaultDomainEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventInitDefaultDomainEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatInitDefaultDomainEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledInitSecurity(void) {return EventPipeEventEnabledInitSecurity() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledInitSecurity());}

inline ULONG FireEtwInitSecurity(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventInitSecurity(ActivityId,RelatedActivityId);
    status &= FireEtXplatInitSecurity();
    return status;
}

inline BOOL EventEnabledInitSecurity_V1(void) {return EventPipeEventEnabledInitSecurity_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledInitSecurity_V1());}

inline ULONG FireEtwInitSecurity_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventInitSecurity_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatInitSecurity_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledInitSecurityEnd(void) {return EventPipeEventEnabledInitSecurityEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledInitSecurityEnd());}

inline ULONG FireEtwInitSecurityEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventInitSecurityEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatInitSecurityEnd();
    return status;
}

inline BOOL EventEnabledInitSecurityEnd_V1(void) {return EventPipeEventEnabledInitSecurityEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledInitSecurityEnd_V1());}

inline ULONG FireEtwInitSecurityEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventInitSecurityEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatInitSecurityEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAllowBindingRedirs(void) {return EventPipeEventEnabledAllowBindingRedirs() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAllowBindingRedirs());}

inline ULONG FireEtwAllowBindingRedirs(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAllowBindingRedirs(ActivityId,RelatedActivityId);
    status &= FireEtXplatAllowBindingRedirs();
    return status;
}

inline BOOL EventEnabledAllowBindingRedirs_V1(void) {return EventPipeEventEnabledAllowBindingRedirs_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAllowBindingRedirs_V1());}

inline ULONG FireEtwAllowBindingRedirs_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAllowBindingRedirs_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAllowBindingRedirs_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAllowBindingRedirsEnd(void) {return EventPipeEventEnabledAllowBindingRedirsEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAllowBindingRedirsEnd());}

inline ULONG FireEtwAllowBindingRedirsEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAllowBindingRedirsEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatAllowBindingRedirsEnd();
    return status;
}

inline BOOL EventEnabledAllowBindingRedirsEnd_V1(void) {return EventPipeEventEnabledAllowBindingRedirsEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAllowBindingRedirsEnd_V1());}

inline ULONG FireEtwAllowBindingRedirsEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAllowBindingRedirsEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAllowBindingRedirsEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledEEConfigSync(void) {return EventPipeEventEnabledEEConfigSync() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEConfigSync());}

inline ULONG FireEtwEEConfigSync(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEConfigSync(ActivityId,RelatedActivityId);
    status &= FireEtXplatEEConfigSync();
    return status;
}

inline BOOL EventEnabledEEConfigSync_V1(void) {return EventPipeEventEnabledEEConfigSync_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEConfigSync_V1());}

inline ULONG FireEtwEEConfigSync_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEConfigSync_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatEEConfigSync_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledEEConfigSyncEnd(void) {return EventPipeEventEnabledEEConfigSyncEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEConfigSyncEnd());}

inline ULONG FireEtwEEConfigSyncEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEConfigSyncEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatEEConfigSyncEnd();
    return status;
}

inline BOOL EventEnabledEEConfigSyncEnd_V1(void) {return EventPipeEventEnabledEEConfigSyncEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEEConfigSyncEnd_V1());}

inline ULONG FireEtwEEConfigSyncEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEEConfigSyncEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatEEConfigSyncEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFusionBinding(void) {return EventPipeEventEnabledFusionBinding() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionBinding());}

inline ULONG FireEtwFusionBinding(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionBinding(ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionBinding();
    return status;
}

inline BOOL EventEnabledFusionBinding_V1(void) {return EventPipeEventEnabledFusionBinding_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionBinding_V1());}

inline ULONG FireEtwFusionBinding_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionBinding_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionBinding_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFusionBindingEnd(void) {return EventPipeEventEnabledFusionBindingEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionBindingEnd());}

inline ULONG FireEtwFusionBindingEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionBindingEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionBindingEnd();
    return status;
}

inline BOOL EventEnabledFusionBindingEnd_V1(void) {return EventPipeEventEnabledFusionBindingEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionBindingEnd_V1());}

inline ULONG FireEtwFusionBindingEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionBindingEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionBindingEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLoaderCatchCall(void) {return EventPipeEventEnabledLoaderCatchCall() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderCatchCall());}

inline ULONG FireEtwLoaderCatchCall(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderCatchCall(ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderCatchCall();
    return status;
}

inline BOOL EventEnabledLoaderCatchCall_V1(void) {return EventPipeEventEnabledLoaderCatchCall_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderCatchCall_V1());}

inline ULONG FireEtwLoaderCatchCall_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderCatchCall_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderCatchCall_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLoaderCatchCallEnd(void) {return EventPipeEventEnabledLoaderCatchCallEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderCatchCallEnd());}

inline ULONG FireEtwLoaderCatchCallEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderCatchCallEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderCatchCallEnd();
    return status;
}

inline BOOL EventEnabledLoaderCatchCallEnd_V1(void) {return EventPipeEventEnabledLoaderCatchCallEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderCatchCallEnd_V1());}

inline ULONG FireEtwLoaderCatchCallEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderCatchCallEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderCatchCallEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFusionInit(void) {return EventPipeEventEnabledFusionInit() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionInit());}

inline ULONG FireEtwFusionInit(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionInit(ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionInit();
    return status;
}

inline BOOL EventEnabledFusionInit_V1(void) {return EventPipeEventEnabledFusionInit_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionInit_V1());}

inline ULONG FireEtwFusionInit_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionInit_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionInit_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFusionInitEnd(void) {return EventPipeEventEnabledFusionInitEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionInitEnd());}

inline ULONG FireEtwFusionInitEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionInitEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionInitEnd();
    return status;
}

inline BOOL EventEnabledFusionInitEnd_V1(void) {return EventPipeEventEnabledFusionInitEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionInitEnd_V1());}

inline ULONG FireEtwFusionInitEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionInitEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionInitEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFusionAppCtx(void) {return EventPipeEventEnabledFusionAppCtx() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionAppCtx());}

inline ULONG FireEtwFusionAppCtx(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionAppCtx(ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionAppCtx();
    return status;
}

inline BOOL EventEnabledFusionAppCtx_V1(void) {return EventPipeEventEnabledFusionAppCtx_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionAppCtx_V1());}

inline ULONG FireEtwFusionAppCtx_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionAppCtx_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionAppCtx_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFusionAppCtxEnd(void) {return EventPipeEventEnabledFusionAppCtxEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionAppCtxEnd());}

inline ULONG FireEtwFusionAppCtxEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionAppCtxEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionAppCtxEnd();
    return status;
}

inline BOOL EventEnabledFusionAppCtxEnd_V1(void) {return EventPipeEventEnabledFusionAppCtxEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionAppCtxEnd_V1());}

inline ULONG FireEtwFusionAppCtxEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionAppCtxEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionAppCtxEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFusion2EE(void) {return EventPipeEventEnabledFusion2EE() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusion2EE());}

inline ULONG FireEtwFusion2EE(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusion2EE(ActivityId,RelatedActivityId);
    status &= FireEtXplatFusion2EE();
    return status;
}

inline BOOL EventEnabledFusion2EE_V1(void) {return EventPipeEventEnabledFusion2EE_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusion2EE_V1());}

inline ULONG FireEtwFusion2EE_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusion2EE_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFusion2EE_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFusion2EEEnd(void) {return EventPipeEventEnabledFusion2EEEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusion2EEEnd());}

inline ULONG FireEtwFusion2EEEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusion2EEEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatFusion2EEEnd();
    return status;
}

inline BOOL EventEnabledFusion2EEEnd_V1(void) {return EventPipeEventEnabledFusion2EEEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusion2EEEnd_V1());}

inline ULONG FireEtwFusion2EEEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusion2EEEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFusion2EEEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledSecurityCatchCall(void) {return EventPipeEventEnabledSecurityCatchCall() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledSecurityCatchCall());}

inline ULONG FireEtwSecurityCatchCall(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventSecurityCatchCall(ActivityId,RelatedActivityId);
    status &= FireEtXplatSecurityCatchCall();
    return status;
}

inline BOOL EventEnabledSecurityCatchCall_V1(void) {return EventPipeEventEnabledSecurityCatchCall_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledSecurityCatchCall_V1());}

inline ULONG FireEtwSecurityCatchCall_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventSecurityCatchCall_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatSecurityCatchCall_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledSecurityCatchCallEnd(void) {return EventPipeEventEnabledSecurityCatchCallEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledSecurityCatchCallEnd());}

inline ULONG FireEtwSecurityCatchCallEnd(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventSecurityCatchCallEnd(ActivityId,RelatedActivityId);
    status &= FireEtXplatSecurityCatchCallEnd();
    return status;
}

inline BOOL EventEnabledSecurityCatchCallEnd_V1(void) {return EventPipeEventEnabledSecurityCatchCallEnd_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledSecurityCatchCallEnd_V1());}

inline ULONG FireEtwSecurityCatchCallEnd_V1(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventSecurityCatchCallEnd_V1(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatSecurityCatchCallEnd_V1(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledCLRStackWalkPrivate(void) {return EventPipeEventEnabledCLRStackWalkPrivate() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledCLRStackWalkPrivate());}

inline ULONG FireEtwCLRStackWalkPrivate(
    const unsigned short  ClrInstanceID,
    const unsigned char  Reserved1,
    const unsigned char  Reserved2,
    const unsigned int  FrameCount,
    const void** Stack,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventCLRStackWalkPrivate(ClrInstanceID,Reserved1,Reserved2,FrameCount,Stack,ActivityId,RelatedActivityId);
    status &= FireEtXplatCLRStackWalkPrivate(ClrInstanceID,Reserved1,Reserved2,FrameCount,Stack);
    return status;
}

inline BOOL EventEnabledModuleRangeLoadPrivate(void) {return EventPipeEventEnabledModuleRangeLoadPrivate() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleRangeLoadPrivate());}

inline ULONG FireEtwModuleRangeLoadPrivate(
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ModuleID,
    const unsigned int  RangeBegin,
    const unsigned int  RangeSize,
    const unsigned char  RangeType,
    const unsigned char  IBCType,
    const unsigned short  SectionType,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleRangeLoadPrivate(ClrInstanceID,ModuleID,RangeBegin,RangeSize,RangeType,IBCType,SectionType,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleRangeLoadPrivate(ClrInstanceID,ModuleID,RangeBegin,RangeSize,RangeType,IBCType,SectionType);
    return status;
}

inline BOOL EventEnabledBindingPolicyPhaseStart(void) {return EventPipeEventEnabledBindingPolicyPhaseStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBindingPolicyPhaseStart());}

inline ULONG FireEtwBindingPolicyPhaseStart(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBindingPolicyPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBindingPolicyPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBindingPolicyPhaseEnd(void) {return EventPipeEventEnabledBindingPolicyPhaseEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBindingPolicyPhaseEnd());}

inline ULONG FireEtwBindingPolicyPhaseEnd(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBindingPolicyPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBindingPolicyPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBindingNgenPhaseStart(void) {return EventPipeEventEnabledBindingNgenPhaseStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBindingNgenPhaseStart());}

inline ULONG FireEtwBindingNgenPhaseStart(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBindingNgenPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBindingNgenPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBindingNgenPhaseEnd(void) {return EventPipeEventEnabledBindingNgenPhaseEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBindingNgenPhaseEnd());}

inline ULONG FireEtwBindingNgenPhaseEnd(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBindingNgenPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBindingNgenPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBindingLookupAndProbingPhaseStart(void) {return EventPipeEventEnabledBindingLookupAndProbingPhaseStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBindingLookupAndProbingPhaseStart());}

inline ULONG FireEtwBindingLookupAndProbingPhaseStart(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBindingLookupAndProbingPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBindingLookupAndProbingPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBindingLookupAndProbingPhaseEnd(void) {return EventPipeEventEnabledBindingLookupAndProbingPhaseEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBindingLookupAndProbingPhaseEnd());}

inline ULONG FireEtwBindingLookupAndProbingPhaseEnd(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBindingLookupAndProbingPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBindingLookupAndProbingPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLoaderPhaseStart(void) {return EventPipeEventEnabledLoaderPhaseStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderPhaseStart());}

inline ULONG FireEtwLoaderPhaseStart(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLoaderPhaseEnd(void) {return EventPipeEventEnabledLoaderPhaseEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderPhaseEnd());}

inline ULONG FireEtwLoaderPhaseEnd(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBindingPhaseStart(void) {return EventPipeEventEnabledBindingPhaseStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBindingPhaseStart());}

inline ULONG FireEtwBindingPhaseStart(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBindingPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBindingPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBindingPhaseEnd(void) {return EventPipeEventEnabledBindingPhaseEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBindingPhaseEnd());}

inline ULONG FireEtwBindingPhaseEnd(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBindingPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBindingPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBindingDownloadPhaseStart(void) {return EventPipeEventEnabledBindingDownloadPhaseStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBindingDownloadPhaseStart());}

inline ULONG FireEtwBindingDownloadPhaseStart(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBindingDownloadPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBindingDownloadPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBindingDownloadPhaseEnd(void) {return EventPipeEventEnabledBindingDownloadPhaseEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBindingDownloadPhaseEnd());}

inline ULONG FireEtwBindingDownloadPhaseEnd(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBindingDownloadPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBindingDownloadPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLoaderAssemblyInitPhaseStart(void) {return EventPipeEventEnabledLoaderAssemblyInitPhaseStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderAssemblyInitPhaseStart());}

inline ULONG FireEtwLoaderAssemblyInitPhaseStart(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderAssemblyInitPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderAssemblyInitPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLoaderAssemblyInitPhaseEnd(void) {return EventPipeEventEnabledLoaderAssemblyInitPhaseEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderAssemblyInitPhaseEnd());}

inline ULONG FireEtwLoaderAssemblyInitPhaseEnd(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderAssemblyInitPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderAssemblyInitPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLoaderMappingPhaseStart(void) {return EventPipeEventEnabledLoaderMappingPhaseStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderMappingPhaseStart());}

inline ULONG FireEtwLoaderMappingPhaseStart(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderMappingPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderMappingPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLoaderMappingPhaseEnd(void) {return EventPipeEventEnabledLoaderMappingPhaseEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderMappingPhaseEnd());}

inline ULONG FireEtwLoaderMappingPhaseEnd(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderMappingPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderMappingPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLoaderDeliverEventsPhaseStart(void) {return EventPipeEventEnabledLoaderDeliverEventsPhaseStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderDeliverEventsPhaseStart());}

inline ULONG FireEtwLoaderDeliverEventsPhaseStart(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderDeliverEventsPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderDeliverEventsPhaseStart(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledLoaderDeliverEventsPhaseEnd(void) {return EventPipeEventEnabledLoaderDeliverEventsPhaseEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledLoaderDeliverEventsPhaseEnd());}

inline ULONG FireEtwLoaderDeliverEventsPhaseEnd(
    const unsigned int  AppDomainID,
    const unsigned int  LoadContextID,
    const unsigned int  FromLoaderCache,
    const unsigned int  DynamicLoad,
    PCWSTR  AssemblyCodebase,
    PCWSTR  AssemblyName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventLoaderDeliverEventsPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatLoaderDeliverEventsPhaseEnd(AppDomainID,LoadContextID,FromLoaderCache,DynamicLoad,AssemblyCodebase,AssemblyName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledEvidenceGenerated(void) {return EventPipeEventEnabledEvidenceGenerated() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEvidenceGenerated());}

inline ULONG FireEtwEvidenceGenerated(
    const unsigned int  Type,
    const unsigned int  AppDomain,
    PCWSTR  ILImage,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEvidenceGenerated(Type,AppDomain,ILImage,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatEvidenceGenerated(Type,AppDomain,ILImage,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleTransparencyComputationStart(void) {return EventPipeEventEnabledModuleTransparencyComputationStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleTransparencyComputationStart());}

inline ULONG FireEtwModuleTransparencyComputationStart(
    PCWSTR  Module,
    const unsigned int  AppDomainID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleTransparencyComputationStart(Module,AppDomainID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleTransparencyComputationStart(Module,AppDomainID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledModuleTransparencyComputationEnd(void) {return EventPipeEventEnabledModuleTransparencyComputationEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledModuleTransparencyComputationEnd());}

inline ULONG FireEtwModuleTransparencyComputationEnd(
    PCWSTR  Module,
    const unsigned int  AppDomainID,
    const BOOL  IsAllCritical,
    const BOOL  IsAllTransparent,
    const BOOL  IsTreatAsSafe,
    const BOOL  IsOpportunisticallyCritical,
    const unsigned int  SecurityRuleSet,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventModuleTransparencyComputationEnd(Module,AppDomainID,IsAllCritical,IsAllTransparent,IsTreatAsSafe,IsOpportunisticallyCritical,SecurityRuleSet,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatModuleTransparencyComputationEnd(Module,AppDomainID,IsAllCritical,IsAllTransparent,IsTreatAsSafe,IsOpportunisticallyCritical,SecurityRuleSet,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledTypeTransparencyComputationStart(void) {return EventPipeEventEnabledTypeTransparencyComputationStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTypeTransparencyComputationStart());}

inline ULONG FireEtwTypeTransparencyComputationStart(
    PCWSTR  Type,
    PCWSTR  Module,
    const unsigned int  AppDomainID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTypeTransparencyComputationStart(Type,Module,AppDomainID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatTypeTransparencyComputationStart(Type,Module,AppDomainID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledTypeTransparencyComputationEnd(void) {return EventPipeEventEnabledTypeTransparencyComputationEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTypeTransparencyComputationEnd());}

inline ULONG FireEtwTypeTransparencyComputationEnd(
    PCWSTR  Type,
    PCWSTR  Module,
    const unsigned int  AppDomainID,
    const BOOL  IsAllCritical,
    const BOOL  IsAllTransparent,
    const BOOL  IsCritical,
    const BOOL  IsTreatAsSafe,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTypeTransparencyComputationEnd(Type,Module,AppDomainID,IsAllCritical,IsAllTransparent,IsCritical,IsTreatAsSafe,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatTypeTransparencyComputationEnd(Type,Module,AppDomainID,IsAllCritical,IsAllTransparent,IsCritical,IsTreatAsSafe,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodTransparencyComputationStart(void) {return EventPipeEventEnabledMethodTransparencyComputationStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodTransparencyComputationStart());}

inline ULONG FireEtwMethodTransparencyComputationStart(
    PCWSTR  Method,
    PCWSTR  Module,
    const unsigned int  AppDomainID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodTransparencyComputationStart(Method,Module,AppDomainID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodTransparencyComputationStart(Method,Module,AppDomainID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMethodTransparencyComputationEnd(void) {return EventPipeEventEnabledMethodTransparencyComputationEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMethodTransparencyComputationEnd());}

inline ULONG FireEtwMethodTransparencyComputationEnd(
    PCWSTR  Method,
    PCWSTR  Module,
    const unsigned int  AppDomainID,
    const BOOL  IsCritical,
    const BOOL  IsTreatAsSafe,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMethodTransparencyComputationEnd(Method,Module,AppDomainID,IsCritical,IsTreatAsSafe,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMethodTransparencyComputationEnd(Method,Module,AppDomainID,IsCritical,IsTreatAsSafe,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFieldTransparencyComputationStart(void) {return EventPipeEventEnabledFieldTransparencyComputationStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFieldTransparencyComputationStart());}

inline ULONG FireEtwFieldTransparencyComputationStart(
    PCWSTR  Field,
    PCWSTR  Module,
    const unsigned int  AppDomainID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFieldTransparencyComputationStart(Field,Module,AppDomainID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFieldTransparencyComputationStart(Field,Module,AppDomainID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFieldTransparencyComputationEnd(void) {return EventPipeEventEnabledFieldTransparencyComputationEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFieldTransparencyComputationEnd());}

inline ULONG FireEtwFieldTransparencyComputationEnd(
    PCWSTR  Field,
    PCWSTR  Module,
    const unsigned int  AppDomainID,
    const BOOL  IsCritical,
    const BOOL  IsTreatAsSafe,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFieldTransparencyComputationEnd(Field,Module,AppDomainID,IsCritical,IsTreatAsSafe,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFieldTransparencyComputationEnd(Field,Module,AppDomainID,IsCritical,IsTreatAsSafe,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledTokenTransparencyComputationStart(void) {return EventPipeEventEnabledTokenTransparencyComputationStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTokenTransparencyComputationStart());}

inline ULONG FireEtwTokenTransparencyComputationStart(
    const unsigned int  Token,
    PCWSTR  Module,
    const unsigned int  AppDomainID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTokenTransparencyComputationStart(Token,Module,AppDomainID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatTokenTransparencyComputationStart(Token,Module,AppDomainID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledTokenTransparencyComputationEnd(void) {return EventPipeEventEnabledTokenTransparencyComputationEnd() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledTokenTransparencyComputationEnd());}

inline ULONG FireEtwTokenTransparencyComputationEnd(
    const unsigned int  Token,
    PCWSTR  Module,
    const unsigned int  AppDomainID,
    const BOOL  IsCritical,
    const BOOL  IsTreatAsSafe,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventTokenTransparencyComputationEnd(Token,Module,AppDomainID,IsCritical,IsTreatAsSafe,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatTokenTransparencyComputationEnd(Token,Module,AppDomainID,IsCritical,IsTreatAsSafe,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledNgenBindEvent(void) {return EventPipeEventEnabledNgenBindEvent() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledNgenBindEvent());}

inline ULONG FireEtwNgenBindEvent(
    const unsigned short  ClrInstanceID,
    const unsigned __int64  BindingID,
    const unsigned int  ReasonCode,
    PCWSTR  AssemblyName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventNgenBindEvent(ClrInstanceID,BindingID,ReasonCode,AssemblyName,ActivityId,RelatedActivityId);
    status &= FireEtXplatNgenBindEvent(ClrInstanceID,BindingID,ReasonCode,AssemblyName);
    return status;
}

inline BOOL EventEnabledJittedMethodRichDebugInfo(void) {return EventPipeEventEnabledJittedMethodRichDebugInfo() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledJittedMethodRichDebugInfo());}

inline ULONG FireEtwJittedMethodRichDebugInfo(
    const unsigned short  ClrInstanceID,
    const unsigned __int64  MethodID,
    const unsigned __int64  ReJITID,
    const unsigned __int64  ILVersionID,
    const unsigned int  ChunkIndex,
    const unsigned int  DataSize,
    const BYTE* Data,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventJittedMethodRichDebugInfo(ClrInstanceID,MethodID,ReJITID,ILVersionID,ChunkIndex,DataSize,Data,ActivityId,RelatedActivityId);
    status &= FireEtXplatJittedMethodRichDebugInfo(ClrInstanceID,MethodID,ReJITID,ILVersionID,ChunkIndex,DataSize,Data);
    return status;
}

inline BOOL EventEnabledFailFast(void) {return EventPipeEventEnabledFailFast() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFailFast());}

inline ULONG FireEtwFailFast(
    PCWSTR  FailFastUserMessage,
    const void*  FailedEIP,
    const unsigned int  OSExitCode,
    const unsigned int  ClrExitCode,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFailFast(FailFastUserMessage,FailedEIP,OSExitCode,ClrExitCode,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatFailFast(FailFastUserMessage,FailedEIP,OSExitCode,ClrExitCode,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledPrvFinalizeObject(void) {return EventPipeEventEnabledPrvFinalizeObject() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvFinalizeObject());}

inline ULONG FireEtwPrvFinalizeObject(
    const void*  TypeID,
    const void*  ObjectID,
    const unsigned short  ClrInstanceID,
    PCWSTR  TypeName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvFinalizeObject(TypeID,ObjectID,ClrInstanceID,TypeName,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvFinalizeObject(TypeID,ObjectID,ClrInstanceID,TypeName);
    return status;
}

inline BOOL EventEnabledCCWRefCountChangeAnsi(void) {return EventPipeEventEnabledCCWRefCountChangeAnsi() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledCCWRefCountChangeAnsi());}

inline ULONG FireEtwCCWRefCountChangeAnsi(
    const void*  HandleID,
    const void*  ObjectID,
    const void*  COMInterfacePointer,
    const unsigned int  NewRefCount,
    const unsigned __int64  AppDomainID,
    LPCSTR  ClassName,
    LPCSTR  NameSpace,
    PCWSTR  Operation,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventCCWRefCountChangeAnsi(HandleID,ObjectID,COMInterfacePointer,NewRefCount,AppDomainID,ClassName,NameSpace,Operation,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatCCWRefCountChangeAnsi(HandleID,ObjectID,COMInterfacePointer,NewRefCount,AppDomainID,ClassName,NameSpace,Operation,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledPrvSetGCHandle(void) {return EventPipeEventEnabledPrvSetGCHandle() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvSetGCHandle());}

inline ULONG FireEtwPrvSetGCHandle(
    const void*  HandleID,
    const void*  ObjectID,
    const unsigned int  Kind,
    const unsigned int  Generation,
    const unsigned __int64  AppDomainID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvSetGCHandle(HandleID,ObjectID,Kind,Generation,AppDomainID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvSetGCHandle(HandleID,ObjectID,Kind,Generation,AppDomainID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledPrvDestroyGCHandle(void) {return EventPipeEventEnabledPrvDestroyGCHandle() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPrvDestroyGCHandle());}

inline ULONG FireEtwPrvDestroyGCHandle(
    const void*  HandleID,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPrvDestroyGCHandle(HandleID,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatPrvDestroyGCHandle(HandleID,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledFusionMessageEvent(void) {return EventPipeEventEnabledFusionMessageEvent() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionMessageEvent());}

inline ULONG FireEtwFusionMessageEvent(
    const unsigned short  ClrInstanceID,
    const BOOL  Prepend,
    PCWSTR  Message,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionMessageEvent(ClrInstanceID,Prepend,Message,ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionMessageEvent(ClrInstanceID,Prepend,Message);
    return status;
}

inline BOOL EventEnabledFusionErrorCodeEvent(void) {return EventPipeEventEnabledFusionErrorCodeEvent() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledFusionErrorCodeEvent());}

inline ULONG FireEtwFusionErrorCodeEvent(
    const unsigned short  ClrInstanceID,
    const unsigned int  Category,
    const unsigned int  ErrorCode,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventFusionErrorCodeEvent(ClrInstanceID,Category,ErrorCode,ActivityId,RelatedActivityId);
    status &= FireEtXplatFusionErrorCodeEvent(ClrInstanceID,Category,ErrorCode);
    return status;
}

inline BOOL EventEnabledPinPlugAtGCTime(void) {return EventPipeEventEnabledPinPlugAtGCTime() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledPinPlugAtGCTime());}

inline ULONG FireEtwPinPlugAtGCTime(
    const void*  PlugStart,
    const void*  PlugEnd,
    const void*  GapBeforeSize,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventPinPlugAtGCTime(PlugStart,PlugEnd,GapBeforeSize,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatPinPlugAtGCTime(PlugStart,PlugEnd,GapBeforeSize,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledCCWRefCountChange(void) {return EventPipeEventEnabledCCWRefCountChange() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledCCWRefCountChange());}

inline ULONG FireEtwCCWRefCountChange(
    const void*  HandleID,
    const void*  ObjectID,
    const void*  COMInterfacePointer,
    const unsigned int  NewRefCount,
    const unsigned __int64  AppDomainID,
    PCWSTR  ClassName,
    PCWSTR  NameSpace,
    PCWSTR  Operation,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventCCWRefCountChange(HandleID,ObjectID,COMInterfacePointer,NewRefCount,AppDomainID,ClassName,NameSpace,Operation,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatCCWRefCountChange(HandleID,ObjectID,COMInterfacePointer,NewRefCount,AppDomainID,ClassName,NameSpace,Operation,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledAllocRequest(void) {return EventPipeEventEnabledAllocRequest() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledAllocRequest());}

inline ULONG FireEtwAllocRequest(
    const void*  LoaderHeapPtr,
    const void*  MemoryAddress,
    const unsigned int  RequestSize,
    const unsigned int  Unused1,
    const unsigned __int64  Unused2,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventAllocRequest(LoaderHeapPtr,MemoryAddress,RequestSize,Unused1,Unused2,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatAllocRequest(LoaderHeapPtr,MemoryAddress,RequestSize,Unused1,Unused2,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMulticoreJit(void) {return EventPipeEventEnabledMulticoreJit() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMulticoreJit());}

inline ULONG FireEtwMulticoreJit(
    const unsigned short  ClrInstanceID,
    PCWSTR  String1,
    PCWSTR  String2,
    const signed int  Int1,
    const signed int  Int2,
    const signed int  Int3,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMulticoreJit(ClrInstanceID,String1,String2,Int1,Int2,Int3,ActivityId,RelatedActivityId);
    status &= FireEtXplatMulticoreJit(ClrInstanceID,String1,String2,Int1,Int2,Int3);
    return status;
}

inline BOOL EventEnabledMulticoreJitMethodCodeReturned(void) {return EventPipeEventEnabledMulticoreJitMethodCodeReturned() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMulticoreJitMethodCodeReturned());}

inline ULONG FireEtwMulticoreJitMethodCodeReturned(
    const unsigned short  ClrInstanceID,
    const unsigned __int64  ModuleID,
    const unsigned __int64  MethodID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMulticoreJitMethodCodeReturned(ClrInstanceID,ModuleID,MethodID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMulticoreJitMethodCodeReturned(ClrInstanceID,ModuleID,MethodID);
    return status;
}

inline BOOL EventEnabledIInspectableRuntimeClassName(void) {return EventPipeEventEnabledIInspectableRuntimeClassName() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledIInspectableRuntimeClassName());}

inline ULONG FireEtwIInspectableRuntimeClassName(
    PCWSTR  TypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventIInspectableRuntimeClassName(TypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatIInspectableRuntimeClassName(TypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledWinRTUnbox(void) {return EventPipeEventEnabledWinRTUnbox() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledWinRTUnbox());}

inline ULONG FireEtwWinRTUnbox(
    PCWSTR  TypeName,
    PCWSTR  SecondTypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventWinRTUnbox(TypeName,SecondTypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatWinRTUnbox(TypeName,SecondTypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledCreateRCW(void) {return EventPipeEventEnabledCreateRCW() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledCreateRCW());}

inline ULONG FireEtwCreateRCW(
    PCWSTR  TypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventCreateRCW(TypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatCreateRCW(TypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledRCWVariance(void) {return EventPipeEventEnabledRCWVariance() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledRCWVariance());}

inline ULONG FireEtwRCWVariance(
    PCWSTR  TypeName,
    PCWSTR  InterfaceTypeName,
    PCWSTR  VariantInterfaceTypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventRCWVariance(TypeName,InterfaceTypeName,VariantInterfaceTypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatRCWVariance(TypeName,InterfaceTypeName,VariantInterfaceTypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledRCWIEnumerableCasting(void) {return EventPipeEventEnabledRCWIEnumerableCasting() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledRCWIEnumerableCasting());}

inline ULONG FireEtwRCWIEnumerableCasting(
    PCWSTR  TypeName,
    PCWSTR  SecondTypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventRCWIEnumerableCasting(TypeName,SecondTypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatRCWIEnumerableCasting(TypeName,SecondTypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledCreateCCW(void) {return EventPipeEventEnabledCreateCCW() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledCreateCCW());}

inline ULONG FireEtwCreateCCW(
    PCWSTR  TypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventCreateCCW(TypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatCreateCCW(TypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledCCWVariance(void) {return EventPipeEventEnabledCCWVariance() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledCCWVariance());}

inline ULONG FireEtwCCWVariance(
    PCWSTR  TypeName,
    PCWSTR  InterfaceTypeName,
    PCWSTR  VariantInterfaceTypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventCCWVariance(TypeName,InterfaceTypeName,VariantInterfaceTypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatCCWVariance(TypeName,InterfaceTypeName,VariantInterfaceTypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledObjectVariantMarshallingToNative(void) {return EventPipeEventEnabledObjectVariantMarshallingToNative() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledObjectVariantMarshallingToNative());}

inline ULONG FireEtwObjectVariantMarshallingToNative(
    PCWSTR  TypeName,
    const signed int  Int1,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventObjectVariantMarshallingToNative(TypeName,Int1,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatObjectVariantMarshallingToNative(TypeName,Int1,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGetTypeFromGUID(void) {return EventPipeEventEnabledGetTypeFromGUID() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGetTypeFromGUID());}

inline ULONG FireEtwGetTypeFromGUID(
    PCWSTR  TypeName,
    PCWSTR  SecondTypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGetTypeFromGUID(TypeName,SecondTypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGetTypeFromGUID(TypeName,SecondTypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledGetTypeFromProgID(void) {return EventPipeEventEnabledGetTypeFromProgID() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledGetTypeFromProgID());}

inline ULONG FireEtwGetTypeFromProgID(
    PCWSTR  TypeName,
    PCWSTR  SecondTypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventGetTypeFromProgID(TypeName,SecondTypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatGetTypeFromProgID(TypeName,SecondTypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledConvertToCallbackEtw(void) {return EventPipeEventEnabledConvertToCallbackEtw() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledConvertToCallbackEtw());}

inline ULONG FireEtwConvertToCallbackEtw(
    PCWSTR  TypeName,
    PCWSTR  SecondTypeName,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventConvertToCallbackEtw(TypeName,SecondTypeName,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatConvertToCallbackEtw(TypeName,SecondTypeName,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledBeginCreateManagedReference(void) {return EventPipeEventEnabledBeginCreateManagedReference() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledBeginCreateManagedReference());}

inline ULONG FireEtwBeginCreateManagedReference(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventBeginCreateManagedReference(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatBeginCreateManagedReference(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledEndCreateManagedReference(void) {return EventPipeEventEnabledEndCreateManagedReference() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledEndCreateManagedReference());}

inline ULONG FireEtwEndCreateManagedReference(
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventEndCreateManagedReference(ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatEndCreateManagedReference(ClrInstanceID);
    return status;
}

inline BOOL EventEnabledObjectVariantMarshallingToManaged(void) {return EventPipeEventEnabledObjectVariantMarshallingToManaged() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledObjectVariantMarshallingToManaged());}

inline ULONG FireEtwObjectVariantMarshallingToManaged(
    PCWSTR  TypeName,
    const signed int  Int1,
    const unsigned short  ClrInstanceID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventObjectVariantMarshallingToManaged(TypeName,Int1,ClrInstanceID,ActivityId,RelatedActivityId);
    status &= FireEtXplatObjectVariantMarshallingToManaged(TypeName,Int1,ClrInstanceID);
    return status;
}

inline BOOL EventEnabledMonoProfilerContextLoaded(void) {return EventPipeEventEnabledMonoProfilerContextLoaded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerContextLoaded());}

inline ULONG FireEtwMonoProfilerContextLoaded(
    const void*  ObjectID,
    const unsigned __int64  AppDomainID,
    const unsigned __int64  ContextID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerContextLoaded(ObjectID,AppDomainID,ContextID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerContextLoaded(ObjectID,AppDomainID,ContextID);
    return status;
}

inline BOOL EventEnabledMonoProfilerContextUnloaded(void) {return EventPipeEventEnabledMonoProfilerContextUnloaded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerContextUnloaded());}

inline ULONG FireEtwMonoProfilerContextUnloaded(
    const void*  ObjectID,
    const unsigned __int64  AppDomainID,
    const unsigned __int64  ContextID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerContextUnloaded(ObjectID,AppDomainID,ContextID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerContextUnloaded(ObjectID,AppDomainID,ContextID);
    return status;
}

inline BOOL EventEnabledMonoProfilerAppDomainLoading(void) {return EventPipeEventEnabledMonoProfilerAppDomainLoading() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerAppDomainLoading());}

inline ULONG FireEtwMonoProfilerAppDomainLoading(
    const unsigned __int64  AppDomainID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerAppDomainLoading(AppDomainID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerAppDomainLoading(AppDomainID);
    return status;
}

inline BOOL EventEnabledMonoProfilerAppDomainLoaded(void) {return EventPipeEventEnabledMonoProfilerAppDomainLoaded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerAppDomainLoaded());}

inline ULONG FireEtwMonoProfilerAppDomainLoaded(
    const unsigned __int64  AppDomainID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerAppDomainLoaded(AppDomainID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerAppDomainLoaded(AppDomainID);
    return status;
}

inline BOOL EventEnabledMonoProfilerAppDomainUnloading(void) {return EventPipeEventEnabledMonoProfilerAppDomainUnloading() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerAppDomainUnloading());}

inline ULONG FireEtwMonoProfilerAppDomainUnloading(
    const unsigned __int64  AppDomainID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerAppDomainUnloading(AppDomainID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerAppDomainUnloading(AppDomainID);
    return status;
}

inline BOOL EventEnabledMonoProfilerAppDomainUnloaded(void) {return EventPipeEventEnabledMonoProfilerAppDomainUnloaded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerAppDomainUnloaded());}

inline ULONG FireEtwMonoProfilerAppDomainUnloaded(
    const unsigned __int64  AppDomainID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerAppDomainUnloaded(AppDomainID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerAppDomainUnloaded(AppDomainID);
    return status;
}

inline BOOL EventEnabledMonoProfilerAppDomainName(void) {return EventPipeEventEnabledMonoProfilerAppDomainName() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerAppDomainName());}

inline ULONG FireEtwMonoProfilerAppDomainName(
    const unsigned __int64  AppDomainID,
    PCWSTR  AppDomainName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerAppDomainName(AppDomainID,AppDomainName,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerAppDomainName(AppDomainID,AppDomainName);
    return status;
}

inline BOOL EventEnabledMonoProfilerJitBegin(void) {return EventPipeEventEnabledMonoProfilerJitBegin() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerJitBegin());}

inline ULONG FireEtwMonoProfilerJitBegin(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned int  MethodToken,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerJitBegin(MethodID,ModuleID,MethodToken,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerJitBegin(MethodID,ModuleID,MethodToken);
    return status;
}

inline BOOL EventEnabledMonoProfilerJitFailed(void) {return EventPipeEventEnabledMonoProfilerJitFailed() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerJitFailed());}

inline ULONG FireEtwMonoProfilerJitFailed(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned int  MethodToken,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerJitFailed(MethodID,ModuleID,MethodToken,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerJitFailed(MethodID,ModuleID,MethodToken);
    return status;
}

inline BOOL EventEnabledMonoProfilerJitDone(void) {return EventPipeEventEnabledMonoProfilerJitDone() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerJitDone());}

inline ULONG FireEtwMonoProfilerJitDone(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned int  MethodToken,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerJitDone(MethodID,ModuleID,MethodToken,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerJitDone(MethodID,ModuleID,MethodToken);
    return status;
}

inline BOOL EventEnabledMonoProfilerJitDone_V1(void) {return EventPipeEventEnabledMonoProfilerJitDone_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerJitDone_V1());}

inline ULONG FireEtwMonoProfilerJitDone_V1(
    const unsigned __int64  MethodID,
    const unsigned __int64  ModuleID,
    const unsigned int  MethodToken,
    const unsigned int  Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerJitDone_V1(MethodID,ModuleID,MethodToken,Count,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerJitDone_V1(MethodID,ModuleID,MethodToken,Count,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledMonoProfilerJitChunkCreated(void) {return EventPipeEventEnabledMonoProfilerJitChunkCreated() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerJitChunkCreated());}

inline ULONG FireEtwMonoProfilerJitChunkCreated(
    const void*  ChunkID,
    const unsigned __int64  ChunkSize,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerJitChunkCreated(ChunkID,ChunkSize,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerJitChunkCreated(ChunkID,ChunkSize);
    return status;
}

inline BOOL EventEnabledMonoProfilerJitChunkDestroyed(void) {return EventPipeEventEnabledMonoProfilerJitChunkDestroyed() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerJitChunkDestroyed());}

inline ULONG FireEtwMonoProfilerJitChunkDestroyed(
    const void*  ChunkID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerJitChunkDestroyed(ChunkID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerJitChunkDestroyed(ChunkID);
    return status;
}

inline BOOL EventEnabledMonoProfilerJitCodeBuffer(void) {return EventPipeEventEnabledMonoProfilerJitCodeBuffer() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerJitCodeBuffer());}

inline ULONG FireEtwMonoProfilerJitCodeBuffer(
    const void*  BufferID,
    const unsigned __int64  BufferSize,
    const unsigned char  BufferType,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerJitCodeBuffer(BufferID,BufferSize,BufferType,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerJitCodeBuffer(BufferID,BufferSize,BufferType);
    return status;
}

inline BOOL EventEnabledMonoProfilerClassLoading(void) {return EventPipeEventEnabledMonoProfilerClassLoading() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerClassLoading());}

inline ULONG FireEtwMonoProfilerClassLoading(
    const unsigned __int64  ClassID,
    const unsigned __int64  ModuleID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerClassLoading(ClassID,ModuleID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerClassLoading(ClassID,ModuleID);
    return status;
}

inline BOOL EventEnabledMonoProfilerClassFailed(void) {return EventPipeEventEnabledMonoProfilerClassFailed() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerClassFailed());}

inline ULONG FireEtwMonoProfilerClassFailed(
    const unsigned __int64  ClassID,
    const unsigned __int64  ModuleID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerClassFailed(ClassID,ModuleID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerClassFailed(ClassID,ModuleID);
    return status;
}

inline BOOL EventEnabledMonoProfilerClassLoaded(void) {return EventPipeEventEnabledMonoProfilerClassLoaded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerClassLoaded());}

inline ULONG FireEtwMonoProfilerClassLoaded(
    const unsigned __int64  ClassID,
    const unsigned __int64  ModuleID,
    PCWSTR  ClassName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerClassLoaded(ClassID,ModuleID,ClassName,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerClassLoaded(ClassID,ModuleID,ClassName);
    return status;
}

inline BOOL EventEnabledMonoProfilerClassLoaded_V1(void) {return EventPipeEventEnabledMonoProfilerClassLoaded_V1() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerClassLoaded_V1());}

inline ULONG FireEtwMonoProfilerClassLoaded_V1(
    const unsigned __int64  ClassID,
    const unsigned __int64  ModuleID,
    PCWSTR  ClassName,
    const unsigned int  Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerClassLoaded_V1(ClassID,ModuleID,ClassName,Count,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerClassLoaded_V1(ClassID,ModuleID,ClassName,Count,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledMonoProfilerVTableLoading(void) {return EventPipeEventEnabledMonoProfilerVTableLoading() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerVTableLoading());}

inline ULONG FireEtwMonoProfilerVTableLoading(
    const unsigned __int64  VTableID,
    const unsigned __int64  ClassID,
    const unsigned __int64  AppDomainID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerVTableLoading(VTableID,ClassID,AppDomainID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerVTableLoading(VTableID,ClassID,AppDomainID);
    return status;
}

inline BOOL EventEnabledMonoProfilerVTableFailed(void) {return EventPipeEventEnabledMonoProfilerVTableFailed() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerVTableFailed());}

inline ULONG FireEtwMonoProfilerVTableFailed(
    const unsigned __int64  VTableID,
    const unsigned __int64  ClassID,
    const unsigned __int64  AppDomainID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerVTableFailed(VTableID,ClassID,AppDomainID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerVTableFailed(VTableID,ClassID,AppDomainID);
    return status;
}

inline BOOL EventEnabledMonoProfilerVTableLoaded(void) {return EventPipeEventEnabledMonoProfilerVTableLoaded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerVTableLoaded());}

inline ULONG FireEtwMonoProfilerVTableLoaded(
    const unsigned __int64  VTableID,
    const unsigned __int64  ClassID,
    const unsigned __int64  AppDomainID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerVTableLoaded(VTableID,ClassID,AppDomainID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerVTableLoaded(VTableID,ClassID,AppDomainID);
    return status;
}

inline BOOL EventEnabledMonoProfilerModuleLoading(void) {return EventPipeEventEnabledMonoProfilerModuleLoading() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerModuleLoading());}

inline ULONG FireEtwMonoProfilerModuleLoading(
    const unsigned __int64  ModuleID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerModuleLoading(ModuleID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerModuleLoading(ModuleID);
    return status;
}

inline BOOL EventEnabledMonoProfilerModuleFailed(void) {return EventPipeEventEnabledMonoProfilerModuleFailed() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerModuleFailed());}

inline ULONG FireEtwMonoProfilerModuleFailed(
    const unsigned __int64  ModuleID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerModuleFailed(ModuleID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerModuleFailed(ModuleID);
    return status;
}

inline BOOL EventEnabledMonoProfilerModuleLoaded(void) {return EventPipeEventEnabledMonoProfilerModuleLoaded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerModuleLoaded());}

inline ULONG FireEtwMonoProfilerModuleLoaded(
    const unsigned __int64  ModuleID,
    PCWSTR  ModuleName,
    PCWSTR  ModuleSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerModuleLoaded(ModuleID,ModuleName,ModuleSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerModuleLoaded(ModuleID,ModuleName,ModuleSignature);
    return status;
}

inline BOOL EventEnabledMonoProfilerModuleUnloading(void) {return EventPipeEventEnabledMonoProfilerModuleUnloading() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerModuleUnloading());}

inline ULONG FireEtwMonoProfilerModuleUnloading(
    const unsigned __int64  ModuleID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerModuleUnloading(ModuleID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerModuleUnloading(ModuleID);
    return status;
}

inline BOOL EventEnabledMonoProfilerModuleUnloaded(void) {return EventPipeEventEnabledMonoProfilerModuleUnloaded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerModuleUnloaded());}

inline ULONG FireEtwMonoProfilerModuleUnloaded(
    const unsigned __int64  ModuleID,
    PCWSTR  ModuleName,
    PCWSTR  ModuleSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerModuleUnloaded(ModuleID,ModuleName,ModuleSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerModuleUnloaded(ModuleID,ModuleName,ModuleSignature);
    return status;
}

inline BOOL EventEnabledMonoProfilerAssemblyLoading(void) {return EventPipeEventEnabledMonoProfilerAssemblyLoading() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerAssemblyLoading());}

inline ULONG FireEtwMonoProfilerAssemblyLoading(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  ModuleID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerAssemblyLoading(AssemblyID,ModuleID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerAssemblyLoading(AssemblyID,ModuleID);
    return status;
}

inline BOOL EventEnabledMonoProfilerAssemblyLoaded(void) {return EventPipeEventEnabledMonoProfilerAssemblyLoaded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerAssemblyLoaded());}

inline ULONG FireEtwMonoProfilerAssemblyLoaded(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  ModuleID,
    PCWSTR  AssemblyName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerAssemblyLoaded(AssemblyID,ModuleID,AssemblyName,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerAssemblyLoaded(AssemblyID,ModuleID,AssemblyName);
    return status;
}

inline BOOL EventEnabledMonoProfilerAssemblyUnloading(void) {return EventPipeEventEnabledMonoProfilerAssemblyUnloading() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerAssemblyUnloading());}

inline ULONG FireEtwMonoProfilerAssemblyUnloading(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  ModuleID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerAssemblyUnloading(AssemblyID,ModuleID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerAssemblyUnloading(AssemblyID,ModuleID);
    return status;
}

inline BOOL EventEnabledMonoProfilerAssemblyUnloaded(void) {return EventPipeEventEnabledMonoProfilerAssemblyUnloaded() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerAssemblyUnloaded());}

inline ULONG FireEtwMonoProfilerAssemblyUnloaded(
    const unsigned __int64  AssemblyID,
    const unsigned __int64  ModuleID,
    PCWSTR  AssemblyName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerAssemblyUnloaded(AssemblyID,ModuleID,AssemblyName,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerAssemblyUnloaded(AssemblyID,ModuleID,AssemblyName);
    return status;
}

inline BOOL EventEnabledMonoProfilerMethodEnter(void) {return EventPipeEventEnabledMonoProfilerMethodEnter() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerMethodEnter());}

inline ULONG FireEtwMonoProfilerMethodEnter(
    const unsigned __int64  MethodID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerMethodEnter(MethodID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerMethodEnter(MethodID);
    return status;
}

inline BOOL EventEnabledMonoProfilerMethodLeave(void) {return EventPipeEventEnabledMonoProfilerMethodLeave() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerMethodLeave());}

inline ULONG FireEtwMonoProfilerMethodLeave(
    const unsigned __int64  MethodID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerMethodLeave(MethodID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerMethodLeave(MethodID);
    return status;
}

inline BOOL EventEnabledMonoProfilerMethodTailCall(void) {return EventPipeEventEnabledMonoProfilerMethodTailCall() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerMethodTailCall());}

inline ULONG FireEtwMonoProfilerMethodTailCall(
    const unsigned __int64  MethodID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerMethodTailCall(MethodID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerMethodTailCall(MethodID);
    return status;
}

inline BOOL EventEnabledMonoProfilerMethodExceptionLeave(void) {return EventPipeEventEnabledMonoProfilerMethodExceptionLeave() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerMethodExceptionLeave());}

inline ULONG FireEtwMonoProfilerMethodExceptionLeave(
    const unsigned __int64  MethodID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerMethodExceptionLeave(MethodID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerMethodExceptionLeave(MethodID);
    return status;
}

inline BOOL EventEnabledMonoProfilerMethodFree(void) {return EventPipeEventEnabledMonoProfilerMethodFree() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerMethodFree());}

inline ULONG FireEtwMonoProfilerMethodFree(
    const unsigned __int64  MethodID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerMethodFree(MethodID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerMethodFree(MethodID);
    return status;
}

inline BOOL EventEnabledMonoProfilerMethodBeginInvoke(void) {return EventPipeEventEnabledMonoProfilerMethodBeginInvoke() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerMethodBeginInvoke());}

inline ULONG FireEtwMonoProfilerMethodBeginInvoke(
    const unsigned __int64  MethodID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerMethodBeginInvoke(MethodID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerMethodBeginInvoke(MethodID);
    return status;
}

inline BOOL EventEnabledMonoProfilerMethodEndInvoke(void) {return EventPipeEventEnabledMonoProfilerMethodEndInvoke() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerMethodEndInvoke());}

inline ULONG FireEtwMonoProfilerMethodEndInvoke(
    const unsigned __int64  MethodID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerMethodEndInvoke(MethodID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerMethodEndInvoke(MethodID);
    return status;
}

inline BOOL EventEnabledMonoProfilerExceptionThrow(void) {return EventPipeEventEnabledMonoProfilerExceptionThrow() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerExceptionThrow());}

inline ULONG FireEtwMonoProfilerExceptionThrow(
    const unsigned __int64  TypeID,
    const void*  ObjectID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerExceptionThrow(TypeID,ObjectID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerExceptionThrow(TypeID,ObjectID);
    return status;
}

inline BOOL EventEnabledMonoProfilerExceptionClause(void) {return EventPipeEventEnabledMonoProfilerExceptionClause() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerExceptionClause());}

inline ULONG FireEtwMonoProfilerExceptionClause(
    const unsigned char  ClauseType,
    const unsigned int  ClauseIdx,
    const unsigned __int64  MethodID,
    const unsigned __int64  TypeID,
    const void*  ObjectID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerExceptionClause(ClauseType,ClauseIdx,MethodID,TypeID,ObjectID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerExceptionClause(ClauseType,ClauseIdx,MethodID,TypeID,ObjectID);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCEvent(void) {return EventPipeEventEnabledMonoProfilerGCEvent() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCEvent());}

inline ULONG FireEtwMonoProfilerGCEvent(
    const unsigned char  GCEventType,
    const unsigned int  GCGeneration,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCEvent(GCEventType,GCGeneration,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCEvent(GCEventType,GCGeneration);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCAllocation(void) {return EventPipeEventEnabledMonoProfilerGCAllocation() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCAllocation());}

inline ULONG FireEtwMonoProfilerGCAllocation(
    const unsigned __int64  VTableID,
    const void*  ObjectID,
    const unsigned __int64  ObjectSize,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCAllocation(VTableID,ObjectID,ObjectSize,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCAllocation(VTableID,ObjectID,ObjectSize);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCMoves(void) {return EventPipeEventEnabledMonoProfilerGCMoves() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCMoves());}

inline ULONG FireEtwMonoProfilerGCMoves(
    const unsigned int  Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCMoves(Count,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCMoves(Count,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCResize(void) {return EventPipeEventEnabledMonoProfilerGCResize() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCResize());}

inline ULONG FireEtwMonoProfilerGCResize(
    const unsigned __int64  NewSize,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCResize(NewSize,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCResize(NewSize);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCHandleCreated(void) {return EventPipeEventEnabledMonoProfilerGCHandleCreated() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCHandleCreated());}

inline ULONG FireEtwMonoProfilerGCHandleCreated(
    const unsigned __int64  HandleID,
    const unsigned char  HandleType,
    const void*  ObjectID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCHandleCreated(HandleID,HandleType,ObjectID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCHandleCreated(HandleID,HandleType,ObjectID);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCHandleDeleted(void) {return EventPipeEventEnabledMonoProfilerGCHandleDeleted() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCHandleDeleted());}

inline ULONG FireEtwMonoProfilerGCHandleDeleted(
    const unsigned __int64  HandleID,
    const unsigned char  HandleType,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCHandleDeleted(HandleID,HandleType,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCHandleDeleted(HandleID,HandleType);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCFinalizing(void) {return EventPipeEventEnabledMonoProfilerGCFinalizing() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCFinalizing());}

inline ULONG FireEtwMonoProfilerGCFinalizing(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCFinalizing(ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCFinalizing();
    return status;
}

inline BOOL EventEnabledMonoProfilerGCFinalized(void) {return EventPipeEventEnabledMonoProfilerGCFinalized() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCFinalized());}

inline ULONG FireEtwMonoProfilerGCFinalized(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCFinalized(ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCFinalized();
    return status;
}

inline BOOL EventEnabledMonoProfilerGCFinalizingObject(void) {return EventPipeEventEnabledMonoProfilerGCFinalizingObject() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCFinalizingObject());}

inline ULONG FireEtwMonoProfilerGCFinalizingObject(
    const void*  ObjectID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCFinalizingObject(ObjectID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCFinalizingObject(ObjectID);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCFinalizedObject(void) {return EventPipeEventEnabledMonoProfilerGCFinalizedObject() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCFinalizedObject());}

inline ULONG FireEtwMonoProfilerGCFinalizedObject(
    const void*  ObjectID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCFinalizedObject(ObjectID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCFinalizedObject(ObjectID);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCRootRegister(void) {return EventPipeEventEnabledMonoProfilerGCRootRegister() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCRootRegister());}

inline ULONG FireEtwMonoProfilerGCRootRegister(
    const void*  RootID,
    const unsigned __int64  RootSize,
    const unsigned char  RootType,
    const unsigned __int64  RootKeyID,
    PCWSTR  RootKeyName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCRootRegister(RootID,RootSize,RootType,RootKeyID,RootKeyName,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCRootRegister(RootID,RootSize,RootType,RootKeyID,RootKeyName);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCRootUnregister(void) {return EventPipeEventEnabledMonoProfilerGCRootUnregister() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCRootUnregister());}

inline ULONG FireEtwMonoProfilerGCRootUnregister(
    const void*  RootID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCRootUnregister(RootID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCRootUnregister(RootID);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCRoots(void) {return EventPipeEventEnabledMonoProfilerGCRoots() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCRoots());}

inline ULONG FireEtwMonoProfilerGCRoots(
    const unsigned int  Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCRoots(Count,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCRoots(Count,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCHeapDumpStart(void) {return EventPipeEventEnabledMonoProfilerGCHeapDumpStart() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCHeapDumpStart());}

inline ULONG FireEtwMonoProfilerGCHeapDumpStart(
    PCWSTR  HeapCollectParam,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCHeapDumpStart(HeapCollectParam,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCHeapDumpStart(HeapCollectParam);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCHeapDumpStop(void) {return EventPipeEventEnabledMonoProfilerGCHeapDumpStop() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCHeapDumpStop());}

inline ULONG FireEtwMonoProfilerGCHeapDumpStop(
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCHeapDumpStop(ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCHeapDumpStop();
    return status;
}

inline BOOL EventEnabledMonoProfilerGCHeapDumpObjectReference(void) {return EventPipeEventEnabledMonoProfilerGCHeapDumpObjectReference() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCHeapDumpObjectReference());}

inline ULONG FireEtwMonoProfilerGCHeapDumpObjectReference(
    const void*  ObjectID,
    const unsigned __int64  VTableID,
    const unsigned __int64  ObjectSize,
    const unsigned char  ObjectGeneration,
    const unsigned int  Count,
    int Values_ElementSize,
    const void* Values,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCHeapDumpObjectReference(ObjectID,VTableID,ObjectSize,ObjectGeneration,Count,Values_ElementSize, Values,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCHeapDumpObjectReference(ObjectID,VTableID,ObjectSize,ObjectGeneration,Count,Values_ElementSize, Values);
    return status;
}

inline BOOL EventEnabledMonoProfilerMonitorContention(void) {return EventPipeEventEnabledMonoProfilerMonitorContention() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerMonitorContention());}

inline ULONG FireEtwMonoProfilerMonitorContention(
    const void*  ObjectID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerMonitorContention(ObjectID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerMonitorContention(ObjectID);
    return status;
}

inline BOOL EventEnabledMonoProfilerMonitorFailed(void) {return EventPipeEventEnabledMonoProfilerMonitorFailed() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerMonitorFailed());}

inline ULONG FireEtwMonoProfilerMonitorFailed(
    const void*  ObjectID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerMonitorFailed(ObjectID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerMonitorFailed(ObjectID);
    return status;
}

inline BOOL EventEnabledMonoProfilerMonitorAcquired(void) {return EventPipeEventEnabledMonoProfilerMonitorAcquired() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerMonitorAcquired());}

inline ULONG FireEtwMonoProfilerMonitorAcquired(
    const void*  ObjectID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerMonitorAcquired(ObjectID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerMonitorAcquired(ObjectID);
    return status;
}

inline BOOL EventEnabledMonoProfilerThreadStarted(void) {return EventPipeEventEnabledMonoProfilerThreadStarted() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerThreadStarted());}

inline ULONG FireEtwMonoProfilerThreadStarted(
    const unsigned __int64  ThreadID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerThreadStarted(ThreadID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerThreadStarted(ThreadID);
    return status;
}

inline BOOL EventEnabledMonoProfilerThreadStopping(void) {return EventPipeEventEnabledMonoProfilerThreadStopping() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerThreadStopping());}

inline ULONG FireEtwMonoProfilerThreadStopping(
    const unsigned __int64  ThreadID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerThreadStopping(ThreadID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerThreadStopping(ThreadID);
    return status;
}

inline BOOL EventEnabledMonoProfilerThreadStopped(void) {return EventPipeEventEnabledMonoProfilerThreadStopped() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerThreadStopped());}

inline ULONG FireEtwMonoProfilerThreadStopped(
    const unsigned __int64  ThreadID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerThreadStopped(ThreadID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerThreadStopped(ThreadID);
    return status;
}

inline BOOL EventEnabledMonoProfilerThreadExited(void) {return EventPipeEventEnabledMonoProfilerThreadExited() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerThreadExited());}

inline ULONG FireEtwMonoProfilerThreadExited(
    const unsigned __int64  ThreadID,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerThreadExited(ThreadID,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerThreadExited(ThreadID);
    return status;
}

inline BOOL EventEnabledMonoProfilerThreadName(void) {return EventPipeEventEnabledMonoProfilerThreadName() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerThreadName());}

inline ULONG FireEtwMonoProfilerThreadName(
    const unsigned __int64  ThreadID,
    PCWSTR  ThreadName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerThreadName(ThreadID,ThreadName,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerThreadName(ThreadID,ThreadName);
    return status;
}

inline BOOL EventEnabledMonoProfilerJitDoneVerbose(void) {return EventPipeEventEnabledMonoProfilerJitDoneVerbose() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerJitDoneVerbose());}

inline ULONG FireEtwMonoProfilerJitDoneVerbose(
    const unsigned __int64  MethodID,
    PCWSTR  MethodNamespace,
    PCWSTR  MethodName,
    PCWSTR  MethodSignature,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerJitDoneVerbose(MethodID,MethodNamespace,MethodName,MethodSignature,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerJitDoneVerbose(MethodID,MethodNamespace,MethodName,MethodSignature);
    return status;
}

inline BOOL EventEnabledMonoProfilerGCHeapDumpVTableClassReference(void) {return EventPipeEventEnabledMonoProfilerGCHeapDumpVTableClassReference() || (XplatEventLogger::IsEventLoggingEnabled() && EventXplatEnabledMonoProfilerGCHeapDumpVTableClassReference());}

inline ULONG FireEtwMonoProfilerGCHeapDumpVTableClassReference(
    const unsigned __int64  VTableID,
    const unsigned __int64  ClassID,
    const unsigned __int64  ModuleID,
    PCWSTR  ClassName,
    LPCGUID ActivityId = nullptr,
    LPCGUID RelatedActivityId = nullptr
)
{
    ULONG status = EventPipeWriteEventMonoProfilerGCHeapDumpVTableClassReference(VTableID,ClassID,ModuleID,ClassName,ActivityId,RelatedActivityId);
    status &= FireEtXplatMonoProfilerGCHeapDumpVTableClassReference(VTableID,ClassID,ModuleID,ClassName);
    return status;
}

