// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/bigquery/storage/v1/avro.proto

package storagepb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The precision of the timestamp value in the Avro message. This precision
// will **only** be applied to the column(s) with the `TIMESTAMP_PICOS` type.
type AvroSerializationOptions_PicosTimestampPrecision int32

const (
	// Unspecified timestamp precision. The default precision is microseconds.
	AvroSerializationOptions_PICOS_TIMESTAMP_PRECISION_UNSPECIFIED AvroSerializationOptions_PicosTimestampPrecision = 0
	// Timestamp values returned by Read API will be truncated to microsecond
	// level precision. The value will be encoded as Avro TIMESTAMP type in a
	// 64 bit integer.
	AvroSerializationOptions_TIMESTAMP_PRECISION_MICROS AvroSerializationOptions_PicosTimestampPrecision = 1
	// Timestamp values returned by Read API will be truncated to nanosecond
	// level precision. The value will be encoded as Avro TIMESTAMP type in a
	// 64 bit integer.
	AvroSerializationOptions_TIMESTAMP_PRECISION_NANOS AvroSerializationOptions_PicosTimestampPrecision = 2
	// Read API will return full precision picosecond value. The value will be
	// encoded as a string which conforms to ISO 8601 format.
	AvroSerializationOptions_TIMESTAMP_PRECISION_PICOS AvroSerializationOptions_PicosTimestampPrecision = 3
)

// Enum value maps for AvroSerializationOptions_PicosTimestampPrecision.
var (
	AvroSerializationOptions_PicosTimestampPrecision_name = map[int32]string{
		0: "PICOS_TIMESTAMP_PRECISION_UNSPECIFIED",
		1: "TIMESTAMP_PRECISION_MICROS",
		2: "TIMESTAMP_PRECISION_NANOS",
		3: "TIMESTAMP_PRECISION_PICOS",
	}
	AvroSerializationOptions_PicosTimestampPrecision_value = map[string]int32{
		"PICOS_TIMESTAMP_PRECISION_UNSPECIFIED": 0,
		"TIMESTAMP_PRECISION_MICROS":            1,
		"TIMESTAMP_PRECISION_NANOS":             2,
		"TIMESTAMP_PRECISION_PICOS":             3,
	}
)

func (x AvroSerializationOptions_PicosTimestampPrecision) Enum() *AvroSerializationOptions_PicosTimestampPrecision {
	p := new(AvroSerializationOptions_PicosTimestampPrecision)
	*p = x
	return p
}

func (x AvroSerializationOptions_PicosTimestampPrecision) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AvroSerializationOptions_PicosTimestampPrecision) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_storage_v1_avro_proto_enumTypes[0].Descriptor()
}

func (AvroSerializationOptions_PicosTimestampPrecision) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_storage_v1_avro_proto_enumTypes[0]
}

func (x AvroSerializationOptions_PicosTimestampPrecision) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AvroSerializationOptions_PicosTimestampPrecision.Descriptor instead.
func (AvroSerializationOptions_PicosTimestampPrecision) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1_avro_proto_rawDescGZIP(), []int{2, 0}
}

// Avro schema.
type AvroSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Json serialized schema, as described at
	// https://avro.apache.org/docs/1.8.1/spec.html.
	Schema string `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"`
}

func (x *AvroSchema) Reset() {
	*x = AvroSchema{}
	mi := &file_google_cloud_bigquery_storage_v1_avro_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AvroSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvroSchema) ProtoMessage() {}

func (x *AvroSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1_avro_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvroSchema.ProtoReflect.Descriptor instead.
func (*AvroSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1_avro_proto_rawDescGZIP(), []int{0}
}

func (x *AvroSchema) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

// Avro rows.
type AvroRows struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Binary serialized rows in a block.
	SerializedBinaryRows []byte `protobuf:"bytes,1,opt,name=serialized_binary_rows,json=serializedBinaryRows,proto3" json:"serialized_binary_rows,omitempty"`
	// [Deprecated] The count of rows in the returning block.
	// Please use the format-independent ReadRowsResponse.row_count instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/bigquery/storage/v1/avro.proto.
	RowCount int64 `protobuf:"varint,2,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
}

func (x *AvroRows) Reset() {
	*x = AvroRows{}
	mi := &file_google_cloud_bigquery_storage_v1_avro_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AvroRows) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvroRows) ProtoMessage() {}

func (x *AvroRows) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1_avro_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvroRows.ProtoReflect.Descriptor instead.
func (*AvroRows) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1_avro_proto_rawDescGZIP(), []int{1}
}

func (x *AvroRows) GetSerializedBinaryRows() []byte {
	if x != nil {
		return x.SerializedBinaryRows
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/bigquery/storage/v1/avro.proto.
func (x *AvroRows) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

// Contains options specific to Avro Serialization.
type AvroSerializationOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable displayName attribute in Avro schema.
	//
	// The Avro specification requires field names to be alphanumeric.  By
	// default, in cases when column names do not conform to these requirements
	// (e.g. non-ascii unicode codepoints) and Avro is requested as an output
	// format, the CreateReadSession call will fail.
	//
	// Setting this field to true, populates avro field names with a placeholder
	// value and populates a "displayName" attribute for every avro field with the
	// original column name.
	EnableDisplayNameAttribute bool `protobuf:"varint,1,opt,name=enable_display_name_attribute,json=enableDisplayNameAttribute,proto3" json:"enable_display_name_attribute,omitempty"`
	// Optional. Set timestamp precision option. If not set, the default precision
	// is microseconds.
	PicosTimestampPrecision AvroSerializationOptions_PicosTimestampPrecision `protobuf:"varint,2,opt,name=picos_timestamp_precision,json=picosTimestampPrecision,proto3,enum=google.cloud.bigquery.storage.v1.AvroSerializationOptions_PicosTimestampPrecision" json:"picos_timestamp_precision,omitempty"`
}

func (x *AvroSerializationOptions) Reset() {
	*x = AvroSerializationOptions{}
	mi := &file_google_cloud_bigquery_storage_v1_avro_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AvroSerializationOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvroSerializationOptions) ProtoMessage() {}

func (x *AvroSerializationOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1_avro_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvroSerializationOptions.ProtoReflect.Descriptor instead.
func (*AvroSerializationOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1_avro_proto_rawDescGZIP(), []int{2}
}

func (x *AvroSerializationOptions) GetEnableDisplayNameAttribute() bool {
	if x != nil {
		return x.EnableDisplayNameAttribute
	}
	return false
}

func (x *AvroSerializationOptions) GetPicosTimestampPrecision() AvroSerializationOptions_PicosTimestampPrecision {
	if x != nil {
		return x.PicosTimestampPrecision
	}
	return AvroSerializationOptions_PICOS_TIMESTAMP_PRECISION_UNSPECIFIED
}

var File_google_cloud_bigquery_storage_v1_avro_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_storage_v1_avro_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x61, 0x76, 0x72, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x22,
	0x24, 0x0a, 0x0a, 0x41, 0x76, 0x72, 0x6f, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x16, 0x0a,
	0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x61, 0x0a, 0x08, 0x41, 0x76, 0x72, 0x6f, 0x52, 0x6f, 0x77,
	0x73, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f,
	0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x14, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x1f, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08,
	0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x93, 0x03, 0x0a, 0x18, 0x41, 0x76, 0x72,
	0x6f, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x1d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x8e, 0x01, 0x0a, 0x19, 0x70, 0x69, 0x63,
	0x6f, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x70, 0x72, 0x65,
	0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x52, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x76, 0x72, 0x6f, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x50, 0x69, 0x63, 0x6f, 0x73, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x17, 0x70, 0x69, 0x63, 0x6f, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x17, 0x50, 0x69,
	0x63, 0x6f, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x50, 0x72, 0x65, 0x63,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x25, 0x50, 0x49, 0x43, 0x4f, 0x53, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x5f, 0x50, 0x52, 0x45, 0x43, 0x49, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x5f, 0x50, 0x52,
	0x45, 0x43, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x43, 0x52, 0x4f, 0x53, 0x10, 0x01,
	0x12, 0x1d, 0x0a, 0x19, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x5f, 0x50, 0x52,
	0x45, 0x43, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x41, 0x4e, 0x4f, 0x53, 0x10, 0x02, 0x12,
	0x1d, 0x0a, 0x19, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x5f, 0x50, 0x52, 0x45,
	0x43, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x49, 0x43, 0x4f, 0x53, 0x10, 0x03, 0x42, 0xb9,
	0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x09, 0x41, 0x76, 0x72, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x70, 0x62, 0x3b, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x5c,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_storage_v1_avro_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_storage_v1_avro_proto_rawDescData = file_google_cloud_bigquery_storage_v1_avro_proto_rawDesc
)

func file_google_cloud_bigquery_storage_v1_avro_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_storage_v1_avro_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_storage_v1_avro_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_storage_v1_avro_proto_rawDescData)
	})
	return file_google_cloud_bigquery_storage_v1_avro_proto_rawDescData
}

var file_google_cloud_bigquery_storage_v1_avro_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_bigquery_storage_v1_avro_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_bigquery_storage_v1_avro_proto_goTypes = []any{
	(AvroSerializationOptions_PicosTimestampPrecision)(0), // 0: google.cloud.bigquery.storage.v1.AvroSerializationOptions.PicosTimestampPrecision
	(*AvroSchema)(nil),               // 1: google.cloud.bigquery.storage.v1.AvroSchema
	(*AvroRows)(nil),                 // 2: google.cloud.bigquery.storage.v1.AvroRows
	(*AvroSerializationOptions)(nil), // 3: google.cloud.bigquery.storage.v1.AvroSerializationOptions
}
var file_google_cloud_bigquery_storage_v1_avro_proto_depIdxs = []int32{
	0, // 0: google.cloud.bigquery.storage.v1.AvroSerializationOptions.picos_timestamp_precision:type_name -> google.cloud.bigquery.storage.v1.AvroSerializationOptions.PicosTimestampPrecision
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_storage_v1_avro_proto_init() }
func file_google_cloud_bigquery_storage_v1_avro_proto_init() {
	if File_google_cloud_bigquery_storage_v1_avro_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_storage_v1_avro_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_bigquery_storage_v1_avro_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_storage_v1_avro_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_storage_v1_avro_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_storage_v1_avro_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_storage_v1_avro_proto = out.File
	file_google_cloud_bigquery_storage_v1_avro_proto_rawDesc = nil
	file_google_cloud_bigquery_storage_v1_avro_proto_goTypes = nil
	file_google_cloud_bigquery_storage_v1_avro_proto_depIdxs = nil
}
