/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	networkingv1beta1 "k8s.io/api/networking/v1beta1"
)

// HTTPIngressPathApplyConfiguration represents a declarative configuration of the HTTPIngressPath type for use
// with apply.
//
// HTTPIngressPath associates a path with a backend. Incoming urls matching the
// path are forwarded to the backend.
type HTTPIngressPathApplyConfiguration struct {
	// path is matched against the path of an incoming request. Currently it can
	// contain characters disallowed from the conventional "path" part of a URL
	// as defined by RFC 3986. Paths must begin with a '/' and must be present
	// when using PathType with value "Exact" or "Prefix".
	Path *string `json:"path,omitempty"`
	// pathType determines the interpretation of the path matching. PathType can
	// be one of the following values:
	// * Exact: Matches the URL path exactly.
	// * Prefix: Matches based on a URL path prefix split by '/'. Matching is
	// done on a path element by element basis. A path element refers is the
	// list of labels in the path split by the '/' separator. A request is a
	// match for path p if every p is an element-wise prefix of p of the
	// request path. Note that if the last element of the path is a substring
	// of the last element in request path, it is not a match (e.g. /foo/bar
	// matches /foo/bar/baz, but does not match /foo/barbaz).
	// * ImplementationSpecific: Interpretation of the Path matching is up to
	// the IngressClass. Implementations can treat this as a separate PathType
	// or treat it identically to Prefix or Exact path types.
	// Implementations are required to support all path types.
	// Defaults to ImplementationSpecific.
	PathType *networkingv1beta1.PathType `json:"pathType,omitempty"`
	// backend defines the referenced service endpoint to which the traffic
	// will be forwarded to.
	Backend *IngressBackendApplyConfiguration `json:"backend,omitempty"`
}

// HTTPIngressPathApplyConfiguration constructs a declarative configuration of the HTTPIngressPath type for use with
// apply.
func HTTPIngressPath() *HTTPIngressPathApplyConfiguration {
	return &HTTPIngressPathApplyConfiguration{}
}

// WithPath sets the Path field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Path field is set to the value of the last call.
func (b *HTTPIngressPathApplyConfiguration) WithPath(value string) *HTTPIngressPathApplyConfiguration {
	b.Path = &value
	return b
}

// WithPathType sets the PathType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PathType field is set to the value of the last call.
func (b *HTTPIngressPathApplyConfiguration) WithPathType(value networkingv1beta1.PathType) *HTTPIngressPathApplyConfiguration {
	b.PathType = &value
	return b
}

// WithBackend sets the Backend field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Backend field is set to the value of the last call.
func (b *HTTPIngressPathApplyConfiguration) WithBackend(value *IngressBackendApplyConfiguration) *HTTPIngressPathApplyConfiguration {
	b.Backend = value
	return b
}
